/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(MEDIA_STREAM)

#include "JSMediaTrackCapabilities.h"

#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMGlobalObject.h"
#include "JSDoubleRange.h"
#include "JSLongRange.h"
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/ObjectConstructor.h>



namespace WebCore {
using namespace JSC;

#if ENABLE(MEDIA_STREAM)

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const MediaTrackCapabilities& dictionary)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    if (!IDLDictionary<DoubleRange>::isNullValue(dictionary.aspectRatio)) {
        auto aspectRatioValue = toJS<IDLDictionary<DoubleRange>>(lexicalGlobalObject, globalObject, throwScope, IDLDictionary<DoubleRange>::extractValueFromNullable(dictionary.aspectRatio));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "aspectRatio"_s), aspectRatioValue);
    }
    if (!IDLSequence<IDLBoolean>::isNullValue(dictionary.backgroundBlur)) {
        auto backgroundBlurValue = toJS<IDLSequence<IDLBoolean>>(lexicalGlobalObject, globalObject, throwScope, IDLSequence<IDLBoolean>::extractValueFromNullable(dictionary.backgroundBlur));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "backgroundBlur"_s), backgroundBlurValue);
    }
    if (!IDLDOMString::isNullValue(dictionary.deviceId)) {
        auto deviceIdValue = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, IDLDOMString::extractValueFromNullable(dictionary.deviceId));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "deviceId"_s), deviceIdValue);
    }
    if (!IDLDOMString::isNullValue(dictionary.displaySurface)) {
        auto displaySurfaceValue = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, IDLDOMString::extractValueFromNullable(dictionary.displaySurface));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "displaySurface"_s), displaySurfaceValue);
    }
    if (!IDLSequence<IDLBoolean>::isNullValue(dictionary.echoCancellation)) {
        auto echoCancellationValue = toJS<IDLSequence<IDLBoolean>>(lexicalGlobalObject, globalObject, throwScope, IDLSequence<IDLBoolean>::extractValueFromNullable(dictionary.echoCancellation));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "echoCancellation"_s), echoCancellationValue);
    }
    if (!IDLSequence<IDLDOMString>::isNullValue(dictionary.facingMode)) {
        auto facingModeValue = toJS<IDLSequence<IDLDOMString>>(lexicalGlobalObject, globalObject, throwScope, IDLSequence<IDLDOMString>::extractValueFromNullable(dictionary.facingMode));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "facingMode"_s), facingModeValue);
    }
    if (!IDLDictionary<DoubleRange>::isNullValue(dictionary.focusDistance)) {
        auto focusDistanceValue = toJS<IDLDictionary<DoubleRange>>(lexicalGlobalObject, globalObject, throwScope, IDLDictionary<DoubleRange>::extractValueFromNullable(dictionary.focusDistance));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "focusDistance"_s), focusDistanceValue);
    }
    if (!IDLDictionary<DoubleRange>::isNullValue(dictionary.frameRate)) {
        auto frameRateValue = toJS<IDLDictionary<DoubleRange>>(lexicalGlobalObject, globalObject, throwScope, IDLDictionary<DoubleRange>::extractValueFromNullable(dictionary.frameRate));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "frameRate"_s), frameRateValue);
    }
    if (!IDLDOMString::isNullValue(dictionary.groupId)) {
        auto groupIdValue = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, IDLDOMString::extractValueFromNullable(dictionary.groupId));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "groupId"_s), groupIdValue);
    }
    if (!IDLDictionary<LongRange>::isNullValue(dictionary.height)) {
        auto heightValue = toJS<IDLDictionary<LongRange>>(lexicalGlobalObject, globalObject, throwScope, IDLDictionary<LongRange>::extractValueFromNullable(dictionary.height));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "height"_s), heightValue);
    }
    if (!IDLSequence<IDLBoolean>::isNullValue(dictionary.powerEfficient)) {
        auto powerEfficientValue = toJS<IDLSequence<IDLBoolean>>(lexicalGlobalObject, globalObject, throwScope, IDLSequence<IDLBoolean>::extractValueFromNullable(dictionary.powerEfficient));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "powerEfficient"_s), powerEfficientValue);
    }
    if (!IDLDictionary<LongRange>::isNullValue(dictionary.sampleRate)) {
        auto sampleRateValue = toJS<IDLDictionary<LongRange>>(lexicalGlobalObject, globalObject, throwScope, IDLDictionary<LongRange>::extractValueFromNullable(dictionary.sampleRate));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "sampleRate"_s), sampleRateValue);
    }
    if (!IDLDictionary<LongRange>::isNullValue(dictionary.sampleSize)) {
        auto sampleSizeValue = toJS<IDLDictionary<LongRange>>(lexicalGlobalObject, globalObject, throwScope, IDLDictionary<LongRange>::extractValueFromNullable(dictionary.sampleSize));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "sampleSize"_s), sampleSizeValue);
    }
    if (!IDLBoolean::isNullValue(dictionary.torch)) {
        auto torchValue = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, IDLBoolean::extractValueFromNullable(dictionary.torch));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "torch"_s), torchValue);
    }
    if (!IDLDictionary<DoubleRange>::isNullValue(dictionary.volume)) {
        auto volumeValue = toJS<IDLDictionary<DoubleRange>>(lexicalGlobalObject, globalObject, throwScope, IDLDictionary<DoubleRange>::extractValueFromNullable(dictionary.volume));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "volume"_s), volumeValue);
    }
    if (!IDLSequence<IDLDOMString>::isNullValue(dictionary.whiteBalanceMode)) {
        auto whiteBalanceModeValue = toJS<IDLSequence<IDLDOMString>>(lexicalGlobalObject, globalObject, throwScope, IDLSequence<IDLDOMString>::extractValueFromNullable(dictionary.whiteBalanceMode));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "whiteBalanceMode"_s), whiteBalanceModeValue);
    }
    if (!IDLDictionary<LongRange>::isNullValue(dictionary.width)) {
        auto widthValue = toJS<IDLDictionary<LongRange>>(lexicalGlobalObject, globalObject, throwScope, IDLDictionary<LongRange>::extractValueFromNullable(dictionary.width));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "width"_s), widthValue);
    }
    if (!IDLDictionary<DoubleRange>::isNullValue(dictionary.zoom)) {
        auto zoomValue = toJS<IDLDictionary<DoubleRange>>(lexicalGlobalObject, globalObject, throwScope, IDLDictionary<DoubleRange>::extractValueFromNullable(dictionary.zoom));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "zoom"_s), zoomValue);
    }
    return result;
}

#endif

} // namespace WebCore


#endif // ENABLE(MEDIA_STREAM)
