/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#pragma once

#include "IDLTypes.h"
#include "IntersectionObserverCallback.h"
#include "JSCallbackData.h"
#include <wtf/Forward.h>

namespace WebCore {

class JSIntersectionObserverCallback final : public IntersectionObserverCallback {
public:
    static Ref<JSIntersectionObserverCallback> create(JSC::JSObject* callback, JSDOMGlobalObject* globalObject)
    {
        return adoptRef(*new JSIntersectionObserverCallback(callback, globalObject));
    }

    ScriptExecutionContext* scriptExecutionContext() const;

    ~JSIntersectionObserverCallback() final;
    JSCallbackData* callbackData() { return m_data; }

    // Functions
    CallbackResult<typename IDLUndefined::CallbackReturnType> invoke(typename IDLInterface<IntersectionObserver>::ParameterType thisObject, typename IDLSequence<IDLInterface<IntersectionObserverEntry>>::ParameterType entries, typename IDLInterface<IntersectionObserver>::ParameterType observer) override;
    CallbackResult<typename IDLUndefined::CallbackReturnType> invokeRethrowingException(typename IDLInterface<IntersectionObserver>::ParameterType thisObject, typename IDLSequence<IDLInterface<IntersectionObserverEntry>>::ParameterType entries, typename IDLInterface<IntersectionObserver>::ParameterType observer) override;

private:
    JSIntersectionObserverCallback(JSC::JSObject*, JSDOMGlobalObject*);

    bool hasCallback() const final { return m_data && m_data->callback(); }

    void visitJSFunction(JSC::AbstractSlotVisitor&) override;

    void visitJSFunction(JSC::SlotVisitor&) override;

    JSCallbackData* m_data;
};

JSC::JSValue toJS(IntersectionObserverCallback&);
inline JSC::JSValue toJS(IntersectionObserverCallback* impl) { return impl ? toJS(*impl) : JSC::jsNull(); }

template<> struct JSDOMCallbackConverterTraits<JSIntersectionObserverCallback> {
    using Base = IntersectionObserverCallback;
};
} // namespace WebCore
