/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(GEOLOCATION)

#include "JSGeolocation.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertCallbacks.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSPositionCallback.h"
#include "JSPositionErrorCallback.h"
#include "JSPositionOptions.h"
#include "Navigator.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include "WebCoreOpaqueRootInlines.h"
#include "WorkerNavigator.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsGeolocationPrototypeFunction_getCurrentPosition);
static JSC_DECLARE_HOST_FUNCTION(jsGeolocationPrototypeFunction_watchPosition);
static JSC_DECLARE_HOST_FUNCTION(jsGeolocationPrototypeFunction_clearWatch);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsGeolocationConstructor);

class JSGeolocationPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSGeolocationPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSGeolocationPrototype* ptr = new (NotNull, JSC::allocateCell<JSGeolocationPrototype>(vm)) JSGeolocationPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSGeolocationPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSGeolocationPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSGeolocationPrototype, JSGeolocationPrototype::Base);

using JSGeolocationDOMConstructor = JSDOMConstructorNotConstructable<JSGeolocation>;

template<> const ClassInfo JSGeolocationDOMConstructor::s_info = { "Geolocation"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGeolocationDOMConstructor) };

template<> JSValue JSGeolocationDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSGeolocationDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "Geolocation"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSGeolocation::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 4> JSGeolocationPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsGeolocationConstructor, 0 } },
    HashTableValue { "getCurrentPosition"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsGeolocationPrototypeFunction_getCurrentPosition, 1 } },
    HashTableValue { "watchPosition"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsGeolocationPrototypeFunction_watchPosition, 1 } },
    HashTableValue { "clearWatch"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsGeolocationPrototypeFunction_clearWatch, 1 } },
};

const ClassInfo JSGeolocationPrototype::s_info = { "Geolocation"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGeolocationPrototype) };

void JSGeolocationPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSGeolocation::info(), JSGeolocationPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSGeolocation::s_info = { "Geolocation"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGeolocation) };

JSGeolocation::JSGeolocation(Structure* structure, JSDOMGlobalObject& globalObject, Ref<Geolocation>&& impl)
    : JSDOMWrapper<Geolocation>(structure, globalObject, WTFMove(impl))
{
}

static_assert(std::is_base_of<ActiveDOMObject, Geolocation>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

JSObject* JSGeolocation::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSGeolocationPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSGeolocationPrototype::create(vm, &globalObject, structure);
}

JSObject* JSGeolocation::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSGeolocation>(vm, globalObject);
}

JSValue JSGeolocation::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSGeolocationDOMConstructor, DOMConstructorID::Geolocation>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSGeolocation::destroy(JSC::JSCell* cell)
{
    JSGeolocation* thisObject = static_cast<JSGeolocation*>(cell);
    thisObject->JSGeolocation::~JSGeolocation();
}

JSC_DEFINE_CUSTOM_GETTER(jsGeolocationConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSGeolocationPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSGeolocation::getConstructor(vm, prototype->globalObject()));
}

static inline JSC::EncodedJSValue jsGeolocationPrototypeFunction_getCurrentPositionBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSGeolocation>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto successCallbackConversionResult = convert<IDLCallbackFunction<JSPositionCallback>>(*lexicalGlobalObject, argument0.value(), *castedThis->globalObject(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeFunctionError(lexicalGlobalObject, scope, 0, "successCallback"_s, "Geolocation"_s, "getCurrentPosition"_s); });
    if (successCallbackConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto errorCallbackConversionResult = convert<IDLNullable<IDLCallbackFunction<JSPositionErrorCallback>>>(*lexicalGlobalObject, argument1.value(), *castedThis->globalObject(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeFunctionError(lexicalGlobalObject, scope, 1, "errorCallback"_s, "Geolocation"_s, "getCurrentPosition"_s); });
    if (errorCallbackConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->argument(2);
    auto optionsConversionResult = convert<IDLDictionary<PositionOptions>>(*lexicalGlobalObject, argument2.value());
    if (optionsConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.getCurrentPosition(successCallbackConversionResult.releaseReturnValue(), errorCallbackConversionResult.releaseReturnValue(), optionsConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsGeolocationPrototypeFunction_getCurrentPosition, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSGeolocation>::call<jsGeolocationPrototypeFunction_getCurrentPositionBody>(*lexicalGlobalObject, *callFrame, "getCurrentPosition");
}

static inline JSC::EncodedJSValue jsGeolocationPrototypeFunction_watchPositionBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSGeolocation>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto successCallbackConversionResult = convert<IDLCallbackFunction<JSPositionCallback>>(*lexicalGlobalObject, argument0.value(), *castedThis->globalObject(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeFunctionError(lexicalGlobalObject, scope, 0, "successCallback"_s, "Geolocation"_s, "watchPosition"_s); });
    if (successCallbackConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto errorCallbackConversionResult = convert<IDLNullable<IDLCallbackFunction<JSPositionErrorCallback>>>(*lexicalGlobalObject, argument1.value(), *castedThis->globalObject(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeFunctionError(lexicalGlobalObject, scope, 1, "errorCallback"_s, "Geolocation"_s, "watchPosition"_s); });
    if (errorCallbackConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->argument(2);
    auto optionsConversionResult = convert<IDLDictionary<PositionOptions>>(*lexicalGlobalObject, argument2.value());
    if (optionsConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLLong>(*lexicalGlobalObject, throwScope, impl.watchPosition(successCallbackConversionResult.releaseReturnValue(), errorCallbackConversionResult.releaseReturnValue(), optionsConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsGeolocationPrototypeFunction_watchPosition, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSGeolocation>::call<jsGeolocationPrototypeFunction_watchPositionBody>(*lexicalGlobalObject, *callFrame, "watchPosition");
}

static inline JSC::EncodedJSValue jsGeolocationPrototypeFunction_clearWatchBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSGeolocation>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto watchIdConversionResult = convert<IDLLong>(*lexicalGlobalObject, argument0.value());
    if (watchIdConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.clearWatch(watchIdConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsGeolocationPrototypeFunction_clearWatch, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSGeolocation>::call<jsGeolocationPrototypeFunction_clearWatchBody>(*lexicalGlobalObject, *callFrame, "clearWatch");
}

JSC::GCClient::IsoSubspace* JSGeolocation::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSGeolocation, UseCustomHeapCellType::No>(vm, "JSGeolocation"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForGeolocation.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForGeolocation = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForGeolocation.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForGeolocation = std::forward<decltype(space)>(space); }
    );
}

void JSGeolocation::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSGeolocation*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSGeolocationOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    SUPPRESS_UNCOUNTED_LOCAL auto* jsGeolocation = jsCast<JSGeolocation*>(handle.slot()->asCell());
    SUPPRESS_UNCOUNTED_LOCAL auto& wrapped = jsGeolocation->wrapped();
    if (!wrapped.isContextStopped() && wrapped.hasPendingActivity()) {
        if (reason) [[unlikely]]
            *reason = "ActiveDOMObject with pending activity"_s;
        return true;
     }
    NavigatorBase* owner = WTF::getPtr(jsGeolocation->wrapped().navigator());
    if (!owner)
        return false;
    if (reason) [[unlikely]]
        *reason = "Reachable from Navigator"_s;
    return containsWebCoreOpaqueRoot(visitor, owner);
}

void JSGeolocationOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsGeolocation = static_cast<JSGeolocation*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsGeolocation->protectedWrapped().ptr(), jsGeolocation);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7Geolocation@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore11GeolocationE[]; }
#endif
template<std::same_as<Geolocation> T>
static inline void verifyVTable(Geolocation* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7Geolocation@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore11GeolocationE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // Geolocation has subclasses. If Geolocation has subclasses that get passed
        // to toJS() we currently require Geolocation you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<Geolocation>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<Geolocation>(impl.ptr());
#endif
    return createWrapper<Geolocation>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, Geolocation& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

Geolocation* JSGeolocation::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSGeolocation*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(GEOLOCATION)
