/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPUPrimitiveTopology.h"

#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>
#include <wtf/SortedArrayMap.h>



namespace WebCore {
using namespace JSC;

String convertEnumerationToString(GPUPrimitiveTopology enumerationValue)
{
    static const std::array<NeverDestroyed<String>, 5> values {
        MAKE_STATIC_STRING_IMPL("point-list"),
        MAKE_STATIC_STRING_IMPL("line-list"),
        MAKE_STATIC_STRING_IMPL("line-strip"),
        MAKE_STATIC_STRING_IMPL("triangle-list"),
        MAKE_STATIC_STRING_IMPL("triangle-strip"),
    };
    static_assert(static_cast<size_t>(GPUPrimitiveTopology::PointList) == 0, "GPUPrimitiveTopology::PointList is not 0 as expected");
    static_assert(static_cast<size_t>(GPUPrimitiveTopology::LineList) == 1, "GPUPrimitiveTopology::LineList is not 1 as expected");
    static_assert(static_cast<size_t>(GPUPrimitiveTopology::LineStrip) == 2, "GPUPrimitiveTopology::LineStrip is not 2 as expected");
    static_assert(static_cast<size_t>(GPUPrimitiveTopology::TriangleList) == 3, "GPUPrimitiveTopology::TriangleList is not 3 as expected");
    static_assert(static_cast<size_t>(GPUPrimitiveTopology::TriangleStrip) == 4, "GPUPrimitiveTopology::TriangleStrip is not 4 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, GPUPrimitiveTopology enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<GPUPrimitiveTopology> parseEnumerationFromString<GPUPrimitiveTopology>(const String& stringValue)
{
    static constexpr std::array<std::pair<ComparableASCIILiteral, GPUPrimitiveTopology>, 5> mappings {
        std::pair<ComparableASCIILiteral, GPUPrimitiveTopology> { "line-list"_s, GPUPrimitiveTopology::LineList },
        std::pair<ComparableASCIILiteral, GPUPrimitiveTopology> { "line-strip"_s, GPUPrimitiveTopology::LineStrip },
        std::pair<ComparableASCIILiteral, GPUPrimitiveTopology> { "point-list"_s, GPUPrimitiveTopology::PointList },
        std::pair<ComparableASCIILiteral, GPUPrimitiveTopology> { "triangle-list"_s, GPUPrimitiveTopology::TriangleList },
        std::pair<ComparableASCIILiteral, GPUPrimitiveTopology> { "triangle-strip"_s, GPUPrimitiveTopology::TriangleStrip },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); enumerationValue) [[likely]]
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<GPUPrimitiveTopology> parseEnumeration<GPUPrimitiveTopology>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<GPUPrimitiveTopology>(value.toWTFString(&lexicalGlobalObject));
}

template<> ASCIILiteral expectedEnumerationValues<GPUPrimitiveTopology>()
{
    return "\"point-list\", \"line-list\", \"line-strip\", \"triangle-list\", \"triangle-strip\""_s;
}

} // namespace WebCore

