/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSDigitalCredentialRequest.h"

#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertObject.h"
#include "JSIdentityCredentialProtocol.h"
#include <JavaScriptCore/JSCInlines.h>



namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<DigitalCredentialRequest>> convertDictionary<DigitalCredentialRequest>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (!isNullOrUndefined && !object) [[unlikely]] {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    DigitalCredentialRequest result;
    JSValue dataValue;
    if (isNullOrUndefined)
        dataValue = jsUndefined();
    else {
        dataValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "data"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (dataValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "data"_s, "DigitalCredentialRequest"_s, "object"_s);
        return ConversionResultException { };
    }
    auto dataConversionResult = convert<IDLObject>(lexicalGlobalObject, dataValue);
    if (dataConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.data = dataConversionResult.releaseReturnValue();
    JSValue protocolValue;
    if (isNullOrUndefined)
        protocolValue = jsUndefined();
    else {
        protocolValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "protocol"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (protocolValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "protocol"_s, "DigitalCredentialRequest"_s, "IdentityCredentialProtocol"_s);
        return ConversionResultException { };
    }
    auto protocolConversionResult = convert<IDLEnumeration<IdentityCredentialProtocol>>(lexicalGlobalObject, protocolValue);
    if (protocolConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.protocol = protocolConversionResult.releaseReturnValue();
    return result;
}

} // namespace WebCore

