/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCSSMatrixComponent.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSCSSMatrixComponentOptions.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMMatrix.h"
#include "JSDOMMatrixReadOnly.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsCSSMatrixComponentConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSMatrixComponent_matrix);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSMatrixComponent_matrix);

class JSCSSMatrixComponentPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSCSSMatrixComponentPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSCSSMatrixComponentPrototype* ptr = new (NotNull, JSC::allocateCell<JSCSSMatrixComponentPrototype>(vm)) JSCSSMatrixComponentPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSCSSMatrixComponentPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSCSSMatrixComponentPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSCSSMatrixComponentPrototype, JSCSSMatrixComponentPrototype::Base);

using JSCSSMatrixComponentDOMConstructor = JSDOMConstructor<JSCSSMatrixComponent>;

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSCSSMatrixComponentDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSCSSMatrixComponentDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto matrixConversionResult = convert<IDLInterface<DOMMatrixReadOnly>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "matrix"_s, "CSSMatrixComponent"_s, nullptr, "DOMMatrixReadOnly"_s); });
    if (matrixConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto optionsConversionResult = convert<IDLDictionary<CSSMatrixComponentOptions>>(*lexicalGlobalObject, argument1.value());
    if (optionsConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    auto object = CSSMatrixComponent::create(*matrixConversionResult.releaseReturnValue(), optionsConversionResult.releaseReturnValue());
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<CSSMatrixComponent>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<CSSMatrixComponent>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}
JSC_ANNOTATE_HOST_FUNCTION(JSCSSMatrixComponentDOMConstructorConstruct, JSCSSMatrixComponentDOMConstructor::construct);

template<> const ClassInfo JSCSSMatrixComponentDOMConstructor::s_info = { "CSSMatrixComponent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCSSMatrixComponentDOMConstructor) };

template<> JSValue JSCSSMatrixComponentDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSCSSTransformComponent::getConstructor(vm, &globalObject);
}

template<> void JSCSSMatrixComponentDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(1), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "CSSMatrixComponent"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSCSSMatrixComponent::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 2> JSCSSMatrixComponentPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSMatrixComponentConstructor, 0 } },
    HashTableValue { "matrix"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSMatrixComponent_matrix, setJSCSSMatrixComponent_matrix } },
};

const ClassInfo JSCSSMatrixComponentPrototype::s_info = { "CSSMatrixComponent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCSSMatrixComponentPrototype) };

void JSCSSMatrixComponentPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSCSSMatrixComponent::info(), JSCSSMatrixComponentPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSCSSMatrixComponent::s_info = { "CSSMatrixComponent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCSSMatrixComponent) };

JSCSSMatrixComponent::JSCSSMatrixComponent(Structure* structure, JSDOMGlobalObject& globalObject, Ref<CSSMatrixComponent>&& impl)
    : JSCSSTransformComponent(structure, globalObject, WTFMove(impl))
{
}

Ref<CSSMatrixComponent> JSCSSMatrixComponent::protectedWrapped() const
{
    return wrapped();
}

static_assert(!std::is_base_of<ActiveDOMObject, CSSMatrixComponent>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSCSSMatrixComponent::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSCSSMatrixComponentPrototype::createStructure(vm, &globalObject, JSCSSTransformComponent::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSCSSMatrixComponentPrototype::create(vm, &globalObject, structure);
}

JSObject* JSCSSMatrixComponent::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSCSSMatrixComponent>(vm, globalObject);
}

JSValue JSCSSMatrixComponent::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSCSSMatrixComponentDOMConstructor, DOMConstructorID::CSSMatrixComponent>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSMatrixComponentConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSCSSMatrixComponentPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSCSSMatrixComponent::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsCSSMatrixComponent_matrixGetter(JSGlobalObject& lexicalGlobalObject, JSCSSMatrixComponent& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<DOMMatrix>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.matrix())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSMatrixComponent_matrix, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSMatrixComponent>::get<jsCSSMatrixComponent_matrixGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSMatrixComponent_matrixSetter(JSGlobalObject& lexicalGlobalObject, JSCSSMatrixComponent& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLInterface<DOMMatrix>>(lexicalGlobalObject, value, [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwAttributeTypeError(lexicalGlobalObject, scope, "CSSMatrixComponent"_s, "matrix"_s, "DOMMatrix"_s); });
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setMatrix(*nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSMatrixComponent_matrix, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSMatrixComponent>::set<setJSCSSMatrixComponent_matrixSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSCSSMatrixComponent::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSCSSMatrixComponent, UseCustomHeapCellType::No>(vm, "JSCSSMatrixComponent"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForCSSMatrixComponent.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForCSSMatrixComponent = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForCSSMatrixComponent.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForCSSMatrixComponent = std::forward<decltype(space)>(space); }
    );
}

void JSCSSMatrixComponent::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSCSSMatrixComponent*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7CSSMatrixComponent@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore18CSSMatrixComponentE[]; }
#endif
template<std::same_as<CSSMatrixComponent> T>
static inline void verifyVTable(CSSMatrixComponent* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7CSSMatrixComponent@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore18CSSMatrixComponentE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // CSSMatrixComponent has subclasses. If CSSMatrixComponent has subclasses that get passed
        // to toJS() we currently require CSSMatrixComponent you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<CSSMatrixComponent>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<CSSMatrixComponent>(impl.ptr());
#endif
    return createWrapper<CSSMatrixComponent>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, CSSMatrixComponent& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}


}
