/*
 * Copyright (C) 2013 Google Inc. All rights reserved.
 * Copyright (C) 2013-2016 Apple Inc. All rights reserved.
 * Copyright (C) 2014 University of Washington. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

// DO NOT EDIT THIS FILE. It is automatically generated from Automation.json by the script: Source/JavaScriptCore/inspector/scripts/generate-inspector-protocol-bindings.py

#include "config.h"
#include "AutomationBackendDispatchers.h"

#include <JavaScriptCore/InspectorFrontendRouter.h>
#include <wtf/NeverDestroyed.h>
#include <wtf/text/MakeString.h>

namespace Inspector {

AutomationBackendDispatcherHandler::~AutomationBackendDispatcherHandler() { }

Ref<AutomationBackendDispatcher> AutomationBackendDispatcher::create(BackendDispatcher& backendDispatcher, AutomationBackendDispatcherHandler* agent)
{
    return adoptRef(*new AutomationBackendDispatcher(backendDispatcher, agent));
}

AutomationBackendDispatcher::AutomationBackendDispatcher(BackendDispatcher& backendDispatcher, AutomationBackendDispatcherHandler* agent)
    : SupplementalBackendDispatcher(backendDispatcher)
    , m_agent(agent)
{
    m_backendDispatcher->registerDispatcherForDomain("Automation"_s, this);
}

void AutomationBackendDispatcher::dispatch(long protocol_requestId, const String& protocol_method, Ref<JSON::Object>&& protocol_message)
{
    Ref<AutomationBackendDispatcher> protect(*this);

    auto protocol_parameters = protocol_message->getObject("params"_s);

    using CallHandler = void (AutomationBackendDispatcher::*)(long protocol_requestId, RefPtr<JSON::Object>&& protocol_message);
    using DispatchMap = HashMap<String, CallHandler>;
    static NeverDestroyed<DispatchMap> dispatchMap = DispatchMap({
        { "getBrowsingContexts"_s, &AutomationBackendDispatcher::getBrowsingContexts },
        { "getBrowsingContext"_s, &AutomationBackendDispatcher::getBrowsingContext },
        { "createBrowsingContext"_s, &AutomationBackendDispatcher::createBrowsingContext },
        { "closeBrowsingContext"_s, &AutomationBackendDispatcher::closeBrowsingContext },
        { "deleteSession"_s, &AutomationBackendDispatcher::deleteSession },
        { "switchToBrowsingContext"_s, &AutomationBackendDispatcher::switchToBrowsingContext },
        { "setWindowFrameOfBrowsingContext"_s, &AutomationBackendDispatcher::setWindowFrameOfBrowsingContext },
        { "maximizeWindowOfBrowsingContext"_s, &AutomationBackendDispatcher::maximizeWindowOfBrowsingContext },
        { "hideWindowOfBrowsingContext"_s, &AutomationBackendDispatcher::hideWindowOfBrowsingContext },
        { "navigateBrowsingContext"_s, &AutomationBackendDispatcher::navigateBrowsingContext },
        { "goBackInBrowsingContext"_s, &AutomationBackendDispatcher::goBackInBrowsingContext },
        { "goForwardInBrowsingContext"_s, &AutomationBackendDispatcher::goForwardInBrowsingContext },
        { "reloadBrowsingContext"_s, &AutomationBackendDispatcher::reloadBrowsingContext },
        { "waitForNavigationToComplete"_s, &AutomationBackendDispatcher::waitForNavigationToComplete },
#if defined(WTF_PLATFORM_MAC) && WTF_PLATFORM_MAC
        { "inspectBrowsingContext"_s, &AutomationBackendDispatcher::inspectBrowsingContext },
#endif // defined(WTF_PLATFORM_MAC) && WTF_PLATFORM_MAC
        { "evaluateJavaScriptFunction"_s, &AutomationBackendDispatcher::evaluateJavaScriptFunction },
        { "performMouseInteraction"_s, &AutomationBackendDispatcher::performMouseInteraction },
        { "performKeyboardInteractions"_s, &AutomationBackendDispatcher::performKeyboardInteractions },
        { "performInteractionSequence"_s, &AutomationBackendDispatcher::performInteractionSequence },
        { "cancelInteractionSequence"_s, &AutomationBackendDispatcher::cancelInteractionSequence },
        { "takeScreenshot"_s, &AutomationBackendDispatcher::takeScreenshot },
        { "resolveChildFrameHandle"_s, &AutomationBackendDispatcher::resolveChildFrameHandle },
        { "resolveParentFrameHandle"_s, &AutomationBackendDispatcher::resolveParentFrameHandle },
        { "computeElementLayout"_s, &AutomationBackendDispatcher::computeElementLayout },
        { "getComputedRole"_s, &AutomationBackendDispatcher::getComputedRole },
        { "getComputedLabel"_s, &AutomationBackendDispatcher::getComputedLabel },
        { "selectOptionElement"_s, &AutomationBackendDispatcher::selectOptionElement },
        { "isShowingJavaScriptDialog"_s, &AutomationBackendDispatcher::isShowingJavaScriptDialog },
        { "dismissCurrentJavaScriptDialog"_s, &AutomationBackendDispatcher::dismissCurrentJavaScriptDialog },
        { "acceptCurrentJavaScriptDialog"_s, &AutomationBackendDispatcher::acceptCurrentJavaScriptDialog },
        { "messageOfCurrentJavaScriptDialog"_s, &AutomationBackendDispatcher::messageOfCurrentJavaScriptDialog },
        { "setUserInputForCurrentJavaScriptPrompt"_s, &AutomationBackendDispatcher::setUserInputForCurrentJavaScriptPrompt },
        { "setFilesToSelectForFileUpload"_s, &AutomationBackendDispatcher::setFilesToSelectForFileUpload },
        { "setFilesForInputFileUpload"_s, &AutomationBackendDispatcher::setFilesForInputFileUpload },
        { "getAllCookies"_s, &AutomationBackendDispatcher::getAllCookies },
        { "deleteSingleCookie"_s, &AutomationBackendDispatcher::deleteSingleCookie },
        { "addSingleCookie"_s, &AutomationBackendDispatcher::addSingleCookie },
        { "deleteAllCookies"_s, &AutomationBackendDispatcher::deleteAllCookies },
        { "getSessionPermissions"_s, &AutomationBackendDispatcher::getSessionPermissions },
        { "setSessionPermissions"_s, &AutomationBackendDispatcher::setSessionPermissions },
        { "addVirtualAuthenticator"_s, &AutomationBackendDispatcher::addVirtualAuthenticator },
        { "removeVirtualAuthenticator"_s, &AutomationBackendDispatcher::removeVirtualAuthenticator },
        { "addVirtualAuthenticatorCredential"_s, &AutomationBackendDispatcher::addVirtualAuthenticatorCredential },
        { "getVirtualAuthenticatorCredentials"_s, &AutomationBackendDispatcher::getVirtualAuthenticatorCredentials },
        { "removeVirtualAuthenticatorCredential"_s, &AutomationBackendDispatcher::removeVirtualAuthenticatorCredential },
        { "removeAllVirtualAuthenticatorCredentials"_s, &AutomationBackendDispatcher::removeAllVirtualAuthenticatorCredentials },
        { "setVirtualAuthenticatorUserVerified"_s, &AutomationBackendDispatcher::setVirtualAuthenticatorUserVerified },
        { "generateTestReport"_s, &AutomationBackendDispatcher::generateTestReport },
#if defined(WTF_PLATFORM_MAC) && WTF_PLATFORM_MAC
        { "loadWebExtension"_s, &AutomationBackendDispatcher::loadWebExtension },
#endif // defined(WTF_PLATFORM_MAC) && WTF_PLATFORM_MAC
#if defined(WTF_PLATFORM_MAC) && WTF_PLATFORM_MAC
        { "unloadWebExtension"_s, &AutomationBackendDispatcher::unloadWebExtension },
#endif // defined(WTF_PLATFORM_MAC) && WTF_PLATFORM_MAC
#if ENABLE(WEBDRIVER_BIDI)
        { "processBidiMessage"_s, &AutomationBackendDispatcher::processBidiMessage },
#endif // ENABLE(WEBDRIVER_BIDI)
    });

    auto findResult = dispatchMap->find(protocol_method);
    if (findResult == dispatchMap->end()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::MethodNotFound, makeString("'Automation."_s, protocol_method, "' was not found"_s));
        return;
    }

    ((*this).*findResult->value)(protocol_requestId, WTFMove(protocol_parameters));
}

void AutomationBackendDispatcher::getBrowsingContexts(long protocol_requestId, RefPtr<JSON::Object>&&)
{
    m_agent->getBrowsingContexts([backendDispatcher = m_backendDispatcher.copyRef(), protocol_requestId](CommandResult<Ref<JSON::ArrayOf<Protocol::Automation::BrowsingContext>>> result) {
        if (!result) {
           ASSERT(!result.error().isEmpty());
           backendDispatcher->reportProtocolError(protocol_requestId, BackendDispatcher::ServerError, result.error());
           backendDispatcher->sendPendingErrors();
           return;
        }
        auto out_contexts = WTFMove(result.value());

        auto protocol_jsonMessage = JSON::Object::create();
        protocol_jsonMessage->setArray("contexts"_s, WTFMove(out_contexts));
        backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
    });
}

void AutomationBackendDispatcher::getBrowsingContext(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_handle = m_backendDispatcher->getString(protocol_parameters.get(), "handle"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Automation.getBrowsingContext' can't be processed"_s);
        return;
    }

    m_agent->getBrowsingContext(in_handle, [backendDispatcher = m_backendDispatcher.copyRef(), protocol_requestId](CommandResult<Ref<Protocol::Automation::BrowsingContext>> result) {
        if (!result) {
           ASSERT(!result.error().isEmpty());
           backendDispatcher->reportProtocolError(protocol_requestId, BackendDispatcher::ServerError, result.error());
           backendDispatcher->sendPendingErrors();
           return;
        }
        auto out_context = WTFMove(result.value());

        auto protocol_jsonMessage = JSON::Object::create();
        protocol_jsonMessage->setObject("context"_s, WTFMove(out_context));
        backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
    });
}

void AutomationBackendDispatcher::createBrowsingContext(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_opt_presentationHint_json = m_backendDispatcher->getString(protocol_parameters.get(), "presentationHint"_s, false);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Automation.createBrowsingContext' can't be processed"_s);
        return;
    }

    auto in_opt_presentationHint = Protocol::AutomationHelpers::parseEnumValueFromString<Protocol::Automation::BrowsingContextPresentation>(in_opt_presentationHint_json);

    m_agent->createBrowsingContext(WTFMove(in_opt_presentationHint), [backendDispatcher = m_backendDispatcher.copyRef(), protocol_requestId](CommandResultOf<String, Protocol::Automation::BrowsingContextPresentation> result) {
        if (!result) {
           ASSERT(!result.error().isEmpty());
           backendDispatcher->reportProtocolError(protocol_requestId, BackendDispatcher::ServerError, result.error());
           backendDispatcher->sendPendingErrors();
           return;
        }
        auto [out_handle, out_presentation] = WTFMove(result.value());

        auto protocol_jsonMessage = JSON::Object::create();
        protocol_jsonMessage->setString("handle"_s, out_handle);
        protocol_jsonMessage->setString("presentation"_s, Protocol::AutomationHelpers::getEnumConstantValue(out_presentation));
        backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
    });
}

void AutomationBackendDispatcher::closeBrowsingContext(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_handle = m_backendDispatcher->getString(protocol_parameters.get(), "handle"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Automation.closeBrowsingContext' can't be processed"_s);
        return;
    }

    m_agent->closeBrowsingContext(in_handle, [backendDispatcher = m_backendDispatcher.copyRef(), protocol_requestId](CommandResult<void> result) {
        if (!result) {
           ASSERT(!result.error().isEmpty());
           backendDispatcher->reportProtocolError(protocol_requestId, BackendDispatcher::ServerError, result.error());
           backendDispatcher->sendPendingErrors();
           return;
        }

        auto protocol_jsonMessage = JSON::Object::create();
        backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
    });
}

void AutomationBackendDispatcher::deleteSession(long protocol_requestId, RefPtr<JSON::Object>&&)
{
    auto result = m_agent->deleteSession();
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void AutomationBackendDispatcher::switchToBrowsingContext(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_browsingContextHandle = m_backendDispatcher->getString(protocol_parameters.get(), "browsingContextHandle"_s, true);
    auto in_opt_frameHandle = m_backendDispatcher->getString(protocol_parameters.get(), "frameHandle"_s, false);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Automation.switchToBrowsingContext' can't be processed"_s);
        return;
    }

    m_agent->switchToBrowsingContext(in_browsingContextHandle, in_opt_frameHandle, [backendDispatcher = m_backendDispatcher.copyRef(), protocol_requestId](CommandResult<void> result) {
        if (!result) {
           ASSERT(!result.error().isEmpty());
           backendDispatcher->reportProtocolError(protocol_requestId, BackendDispatcher::ServerError, result.error());
           backendDispatcher->sendPendingErrors();
           return;
        }

        auto protocol_jsonMessage = JSON::Object::create();
        backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
    });
}

void AutomationBackendDispatcher::setWindowFrameOfBrowsingContext(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_handle = m_backendDispatcher->getString(protocol_parameters.get(), "handle"_s, true);
    auto in_opt_origin = m_backendDispatcher->getObject(protocol_parameters.get(), "origin"_s, false);
    auto in_opt_size = m_backendDispatcher->getObject(protocol_parameters.get(), "size"_s, false);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Automation.setWindowFrameOfBrowsingContext' can't be processed"_s);
        return;
    }

    m_agent->setWindowFrameOfBrowsingContext(in_handle, WTFMove(in_opt_origin), WTFMove(in_opt_size), [backendDispatcher = m_backendDispatcher.copyRef(), protocol_requestId](CommandResult<void> result) {
        if (!result) {
           ASSERT(!result.error().isEmpty());
           backendDispatcher->reportProtocolError(protocol_requestId, BackendDispatcher::ServerError, result.error());
           backendDispatcher->sendPendingErrors();
           return;
        }

        auto protocol_jsonMessage = JSON::Object::create();
        backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
    });
}

void AutomationBackendDispatcher::maximizeWindowOfBrowsingContext(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_handle = m_backendDispatcher->getString(protocol_parameters.get(), "handle"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Automation.maximizeWindowOfBrowsingContext' can't be processed"_s);
        return;
    }

    m_agent->maximizeWindowOfBrowsingContext(in_handle, [backendDispatcher = m_backendDispatcher.copyRef(), protocol_requestId](CommandResult<void> result) {
        if (!result) {
           ASSERT(!result.error().isEmpty());
           backendDispatcher->reportProtocolError(protocol_requestId, BackendDispatcher::ServerError, result.error());
           backendDispatcher->sendPendingErrors();
           return;
        }

        auto protocol_jsonMessage = JSON::Object::create();
        backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
    });
}

void AutomationBackendDispatcher::hideWindowOfBrowsingContext(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_handle = m_backendDispatcher->getString(protocol_parameters.get(), "handle"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Automation.hideWindowOfBrowsingContext' can't be processed"_s);
        return;
    }

    m_agent->hideWindowOfBrowsingContext(in_handle, [backendDispatcher = m_backendDispatcher.copyRef(), protocol_requestId](CommandResult<void> result) {
        if (!result) {
           ASSERT(!result.error().isEmpty());
           backendDispatcher->reportProtocolError(protocol_requestId, BackendDispatcher::ServerError, result.error());
           backendDispatcher->sendPendingErrors();
           return;
        }

        auto protocol_jsonMessage = JSON::Object::create();
        backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
    });
}

void AutomationBackendDispatcher::navigateBrowsingContext(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_handle = m_backendDispatcher->getString(protocol_parameters.get(), "handle"_s, true);
    auto in_url = m_backendDispatcher->getString(protocol_parameters.get(), "url"_s, true);
    auto in_opt_pageLoadStrategy_json = m_backendDispatcher->getString(protocol_parameters.get(), "pageLoadStrategy"_s, false);
    auto in_opt_pageLoadTimeout = m_backendDispatcher->getDouble(protocol_parameters.get(), "pageLoadTimeout"_s, false);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Automation.navigateBrowsingContext' can't be processed"_s);
        return;
    }

    auto in_opt_pageLoadStrategy = Protocol::AutomationHelpers::parseEnumValueFromString<Protocol::Automation::PageLoadStrategy>(in_opt_pageLoadStrategy_json);

    m_agent->navigateBrowsingContext(in_handle, in_url, WTFMove(in_opt_pageLoadStrategy), WTFMove(in_opt_pageLoadTimeout), [backendDispatcher = m_backendDispatcher.copyRef(), protocol_requestId](CommandResult<void> result) {
        if (!result) {
           ASSERT(!result.error().isEmpty());
           backendDispatcher->reportProtocolError(protocol_requestId, BackendDispatcher::ServerError, result.error());
           backendDispatcher->sendPendingErrors();
           return;
        }

        auto protocol_jsonMessage = JSON::Object::create();
        backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
    });
}

void AutomationBackendDispatcher::goBackInBrowsingContext(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_handle = m_backendDispatcher->getString(protocol_parameters.get(), "handle"_s, true);
    auto in_opt_pageLoadStrategy_json = m_backendDispatcher->getString(protocol_parameters.get(), "pageLoadStrategy"_s, false);
    auto in_opt_pageLoadTimeout = m_backendDispatcher->getDouble(protocol_parameters.get(), "pageLoadTimeout"_s, false);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Automation.goBackInBrowsingContext' can't be processed"_s);
        return;
    }

    auto in_opt_pageLoadStrategy = Protocol::AutomationHelpers::parseEnumValueFromString<Protocol::Automation::PageLoadStrategy>(in_opt_pageLoadStrategy_json);

    m_agent->goBackInBrowsingContext(in_handle, WTFMove(in_opt_pageLoadStrategy), WTFMove(in_opt_pageLoadTimeout), [backendDispatcher = m_backendDispatcher.copyRef(), protocol_requestId](CommandResult<void> result) {
        if (!result) {
           ASSERT(!result.error().isEmpty());
           backendDispatcher->reportProtocolError(protocol_requestId, BackendDispatcher::ServerError, result.error());
           backendDispatcher->sendPendingErrors();
           return;
        }

        auto protocol_jsonMessage = JSON::Object::create();
        backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
    });
}

void AutomationBackendDispatcher::goForwardInBrowsingContext(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_handle = m_backendDispatcher->getString(protocol_parameters.get(), "handle"_s, true);
    auto in_opt_pageLoadStrategy_json = m_backendDispatcher->getString(protocol_parameters.get(), "pageLoadStrategy"_s, false);
    auto in_opt_pageLoadTimeout = m_backendDispatcher->getDouble(protocol_parameters.get(), "pageLoadTimeout"_s, false);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Automation.goForwardInBrowsingContext' can't be processed"_s);
        return;
    }

    auto in_opt_pageLoadStrategy = Protocol::AutomationHelpers::parseEnumValueFromString<Protocol::Automation::PageLoadStrategy>(in_opt_pageLoadStrategy_json);

    m_agent->goForwardInBrowsingContext(in_handle, WTFMove(in_opt_pageLoadStrategy), WTFMove(in_opt_pageLoadTimeout), [backendDispatcher = m_backendDispatcher.copyRef(), protocol_requestId](CommandResult<void> result) {
        if (!result) {
           ASSERT(!result.error().isEmpty());
           backendDispatcher->reportProtocolError(protocol_requestId, BackendDispatcher::ServerError, result.error());
           backendDispatcher->sendPendingErrors();
           return;
        }

        auto protocol_jsonMessage = JSON::Object::create();
        backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
    });
}

void AutomationBackendDispatcher::reloadBrowsingContext(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_handle = m_backendDispatcher->getString(protocol_parameters.get(), "handle"_s, true);
    auto in_opt_pageLoadStrategy_json = m_backendDispatcher->getString(protocol_parameters.get(), "pageLoadStrategy"_s, false);
    auto in_opt_pageLoadTimeout = m_backendDispatcher->getDouble(protocol_parameters.get(), "pageLoadTimeout"_s, false);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Automation.reloadBrowsingContext' can't be processed"_s);
        return;
    }

    auto in_opt_pageLoadStrategy = Protocol::AutomationHelpers::parseEnumValueFromString<Protocol::Automation::PageLoadStrategy>(in_opt_pageLoadStrategy_json);

    m_agent->reloadBrowsingContext(in_handle, WTFMove(in_opt_pageLoadStrategy), WTFMove(in_opt_pageLoadTimeout), [backendDispatcher = m_backendDispatcher.copyRef(), protocol_requestId](CommandResult<void> result) {
        if (!result) {
           ASSERT(!result.error().isEmpty());
           backendDispatcher->reportProtocolError(protocol_requestId, BackendDispatcher::ServerError, result.error());
           backendDispatcher->sendPendingErrors();
           return;
        }

        auto protocol_jsonMessage = JSON::Object::create();
        backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
    });
}

void AutomationBackendDispatcher::waitForNavigationToComplete(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_browsingContextHandle = m_backendDispatcher->getString(protocol_parameters.get(), "browsingContextHandle"_s, true);
    auto in_opt_frameHandle = m_backendDispatcher->getString(protocol_parameters.get(), "frameHandle"_s, false);
    auto in_opt_pageLoadStrategy_json = m_backendDispatcher->getString(protocol_parameters.get(), "pageLoadStrategy"_s, false);
    auto in_opt_pageLoadTimeout = m_backendDispatcher->getDouble(protocol_parameters.get(), "pageLoadTimeout"_s, false);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Automation.waitForNavigationToComplete' can't be processed"_s);
        return;
    }

    auto in_opt_pageLoadStrategy = Protocol::AutomationHelpers::parseEnumValueFromString<Protocol::Automation::PageLoadStrategy>(in_opt_pageLoadStrategy_json);

    m_agent->waitForNavigationToComplete(in_browsingContextHandle, in_opt_frameHandle, WTFMove(in_opt_pageLoadStrategy), WTFMove(in_opt_pageLoadTimeout), [backendDispatcher = m_backendDispatcher.copyRef(), protocol_requestId](CommandResult<void> result) {
        if (!result) {
           ASSERT(!result.error().isEmpty());
           backendDispatcher->reportProtocolError(protocol_requestId, BackendDispatcher::ServerError, result.error());
           backendDispatcher->sendPendingErrors();
           return;
        }

        auto protocol_jsonMessage = JSON::Object::create();
        backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
    });
}

#if defined(WTF_PLATFORM_MAC) && WTF_PLATFORM_MAC
void AutomationBackendDispatcher::inspectBrowsingContext(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_handle = m_backendDispatcher->getString(protocol_parameters.get(), "handle"_s, true);
    auto in_opt_enableAutoCapturing = m_backendDispatcher->getBoolean(protocol_parameters.get(), "enableAutoCapturing"_s, false);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Automation.inspectBrowsingContext' can't be processed"_s);
        return;
    }

    m_agent->inspectBrowsingContext(in_handle, WTFMove(in_opt_enableAutoCapturing), [backendDispatcher = m_backendDispatcher.copyRef(), protocol_requestId](CommandResult<void> result) {
        if (!result) {
           ASSERT(!result.error().isEmpty());
           backendDispatcher->reportProtocolError(protocol_requestId, BackendDispatcher::ServerError, result.error());
           backendDispatcher->sendPendingErrors();
           return;
        }

        auto protocol_jsonMessage = JSON::Object::create();
        backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
    });
}
#endif // defined(WTF_PLATFORM_MAC) && WTF_PLATFORM_MAC

void AutomationBackendDispatcher::evaluateJavaScriptFunction(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_browsingContextHandle = m_backendDispatcher->getString(protocol_parameters.get(), "browsingContextHandle"_s, true);
    auto in_opt_frameHandle = m_backendDispatcher->getString(protocol_parameters.get(), "frameHandle"_s, false);
    auto in_function = m_backendDispatcher->getString(protocol_parameters.get(), "function"_s, true);
    auto in_arguments = m_backendDispatcher->getArray(protocol_parameters.get(), "arguments"_s, true);
    auto in_opt_expectsImplicitCallbackArgument = m_backendDispatcher->getBoolean(protocol_parameters.get(), "expectsImplicitCallbackArgument"_s, false);
    auto in_opt_forceUserGesture = m_backendDispatcher->getBoolean(protocol_parameters.get(), "forceUserGesture"_s, false);
    auto in_opt_callbackTimeout = m_backendDispatcher->getDouble(protocol_parameters.get(), "callbackTimeout"_s, false);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Automation.evaluateJavaScriptFunction' can't be processed"_s);
        return;
    }

    m_agent->evaluateJavaScriptFunction(in_browsingContextHandle, in_opt_frameHandle, in_function, in_arguments.releaseNonNull(), WTFMove(in_opt_expectsImplicitCallbackArgument), WTFMove(in_opt_forceUserGesture), WTFMove(in_opt_callbackTimeout), [backendDispatcher = m_backendDispatcher.copyRef(), protocol_requestId](CommandResult<String> result) {
        if (!result) {
           ASSERT(!result.error().isEmpty());
           backendDispatcher->reportProtocolError(protocol_requestId, BackendDispatcher::ServerError, result.error());
           backendDispatcher->sendPendingErrors();
           return;
        }
        auto out_result = WTFMove(result.value());

        auto protocol_jsonMessage = JSON::Object::create();
        protocol_jsonMessage->setString("result"_s, out_result);
        backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
    });
}

void AutomationBackendDispatcher::performMouseInteraction(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_handle = m_backendDispatcher->getString(protocol_parameters.get(), "handle"_s, true);
    auto in_position = m_backendDispatcher->getObject(protocol_parameters.get(), "position"_s, true);
    auto in_button_json = m_backendDispatcher->getString(protocol_parameters.get(), "button"_s, true);
    auto in_interaction_json = m_backendDispatcher->getString(protocol_parameters.get(), "interaction"_s, true);
    auto in_modifiers = m_backendDispatcher->getArray(protocol_parameters.get(), "modifiers"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Automation.performMouseInteraction' can't be processed"_s);
        return;
    }

    auto in_button = Protocol::AutomationHelpers::parseEnumValueFromString<Protocol::Automation::MouseButton>(in_button_json);
    if (!in_button) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, makeString("Unknown button: "_s, in_button_json));
        return;
    }

    auto in_interaction = Protocol::AutomationHelpers::parseEnumValueFromString<Protocol::Automation::MouseInteraction>(in_interaction_json);
    if (!in_interaction) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, makeString("Unknown interaction: "_s, in_interaction_json));
        return;
    }

    m_agent->performMouseInteraction(in_handle, in_position.releaseNonNull(), *in_button, *in_interaction, in_modifiers.releaseNonNull(), [backendDispatcher = m_backendDispatcher.copyRef(), protocol_requestId](CommandResult<Ref<Protocol::Automation::Point>> result) {
        if (!result) {
           ASSERT(!result.error().isEmpty());
           backendDispatcher->reportProtocolError(protocol_requestId, BackendDispatcher::ServerError, result.error());
           backendDispatcher->sendPendingErrors();
           return;
        }
        auto out_position = WTFMove(result.value());

        auto protocol_jsonMessage = JSON::Object::create();
        protocol_jsonMessage->setObject("position"_s, WTFMove(out_position));
        backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
    });
}

void AutomationBackendDispatcher::performKeyboardInteractions(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_handle = m_backendDispatcher->getString(protocol_parameters.get(), "handle"_s, true);
    auto in_interactions = m_backendDispatcher->getArray(protocol_parameters.get(), "interactions"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Automation.performKeyboardInteractions' can't be processed"_s);
        return;
    }

    m_agent->performKeyboardInteractions(in_handle, in_interactions.releaseNonNull(), [backendDispatcher = m_backendDispatcher.copyRef(), protocol_requestId](CommandResult<void> result) {
        if (!result) {
           ASSERT(!result.error().isEmpty());
           backendDispatcher->reportProtocolError(protocol_requestId, BackendDispatcher::ServerError, result.error());
           backendDispatcher->sendPendingErrors();
           return;
        }

        auto protocol_jsonMessage = JSON::Object::create();
        backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
    });
}

void AutomationBackendDispatcher::performInteractionSequence(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_handle = m_backendDispatcher->getString(protocol_parameters.get(), "handle"_s, true);
    auto in_opt_frameHandle = m_backendDispatcher->getString(protocol_parameters.get(), "frameHandle"_s, false);
    auto in_inputSources = m_backendDispatcher->getArray(protocol_parameters.get(), "inputSources"_s, true);
    auto in_steps = m_backendDispatcher->getArray(protocol_parameters.get(), "steps"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Automation.performInteractionSequence' can't be processed"_s);
        return;
    }

    m_agent->performInteractionSequence(in_handle, in_opt_frameHandle, in_inputSources.releaseNonNull(), in_steps.releaseNonNull(), [backendDispatcher = m_backendDispatcher.copyRef(), protocol_requestId](CommandResult<void> result) {
        if (!result) {
           ASSERT(!result.error().isEmpty());
           backendDispatcher->reportProtocolError(protocol_requestId, BackendDispatcher::ServerError, result.error());
           backendDispatcher->sendPendingErrors();
           return;
        }

        auto protocol_jsonMessage = JSON::Object::create();
        backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
    });
}

void AutomationBackendDispatcher::cancelInteractionSequence(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_handle = m_backendDispatcher->getString(protocol_parameters.get(), "handle"_s, true);
    auto in_opt_frameHandle = m_backendDispatcher->getString(protocol_parameters.get(), "frameHandle"_s, false);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Automation.cancelInteractionSequence' can't be processed"_s);
        return;
    }

    m_agent->cancelInteractionSequence(in_handle, in_opt_frameHandle, [backendDispatcher = m_backendDispatcher.copyRef(), protocol_requestId](CommandResult<void> result) {
        if (!result) {
           ASSERT(!result.error().isEmpty());
           backendDispatcher->reportProtocolError(protocol_requestId, BackendDispatcher::ServerError, result.error());
           backendDispatcher->sendPendingErrors();
           return;
        }

        auto protocol_jsonMessage = JSON::Object::create();
        backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
    });
}

void AutomationBackendDispatcher::takeScreenshot(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_handle = m_backendDispatcher->getString(protocol_parameters.get(), "handle"_s, true);
    auto in_opt_frameHandle = m_backendDispatcher->getString(protocol_parameters.get(), "frameHandle"_s, false);
    auto in_opt_nodeHandle = m_backendDispatcher->getString(protocol_parameters.get(), "nodeHandle"_s, false);
    auto in_opt_scrollIntoViewIfNeeded = m_backendDispatcher->getBoolean(protocol_parameters.get(), "scrollIntoViewIfNeeded"_s, false);
    auto in_opt_clipToViewport = m_backendDispatcher->getBoolean(protocol_parameters.get(), "clipToViewport"_s, false);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Automation.takeScreenshot' can't be processed"_s);
        return;
    }

    m_agent->takeScreenshot(in_handle, in_opt_frameHandle, in_opt_nodeHandle, WTFMove(in_opt_scrollIntoViewIfNeeded), WTFMove(in_opt_clipToViewport), [backendDispatcher = m_backendDispatcher.copyRef(), protocol_requestId](CommandResult<String> result) {
        if (!result) {
           ASSERT(!result.error().isEmpty());
           backendDispatcher->reportProtocolError(protocol_requestId, BackendDispatcher::ServerError, result.error());
           backendDispatcher->sendPendingErrors();
           return;
        }
        auto out_data = WTFMove(result.value());

        auto protocol_jsonMessage = JSON::Object::create();
        protocol_jsonMessage->setString("data"_s, out_data);
        backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
    });
}

void AutomationBackendDispatcher::resolveChildFrameHandle(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_browsingContextHandle = m_backendDispatcher->getString(protocol_parameters.get(), "browsingContextHandle"_s, true);
    auto in_opt_frameHandle = m_backendDispatcher->getString(protocol_parameters.get(), "frameHandle"_s, false);
    auto in_opt_ordinal = m_backendDispatcher->getInteger(protocol_parameters.get(), "ordinal"_s, false);
    auto in_opt_name = m_backendDispatcher->getString(protocol_parameters.get(), "name"_s, false);
    auto in_opt_nodeHandle = m_backendDispatcher->getString(protocol_parameters.get(), "nodeHandle"_s, false);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Automation.resolveChildFrameHandle' can't be processed"_s);
        return;
    }

    m_agent->resolveChildFrameHandle(in_browsingContextHandle, in_opt_frameHandle, WTFMove(in_opt_ordinal), in_opt_name, in_opt_nodeHandle, [backendDispatcher = m_backendDispatcher.copyRef(), protocol_requestId](CommandResult<String> result) {
        if (!result) {
           ASSERT(!result.error().isEmpty());
           backendDispatcher->reportProtocolError(protocol_requestId, BackendDispatcher::ServerError, result.error());
           backendDispatcher->sendPendingErrors();
           return;
        }
        auto out_result = WTFMove(result.value());

        auto protocol_jsonMessage = JSON::Object::create();
        protocol_jsonMessage->setString("result"_s, out_result);
        backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
    });
}

void AutomationBackendDispatcher::resolveParentFrameHandle(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_browsingContextHandle = m_backendDispatcher->getString(protocol_parameters.get(), "browsingContextHandle"_s, true);
    auto in_frameHandle = m_backendDispatcher->getString(protocol_parameters.get(), "frameHandle"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Automation.resolveParentFrameHandle' can't be processed"_s);
        return;
    }

    m_agent->resolveParentFrameHandle(in_browsingContextHandle, in_frameHandle, [backendDispatcher = m_backendDispatcher.copyRef(), protocol_requestId](CommandResult<String> result) {
        if (!result) {
           ASSERT(!result.error().isEmpty());
           backendDispatcher->reportProtocolError(protocol_requestId, BackendDispatcher::ServerError, result.error());
           backendDispatcher->sendPendingErrors();
           return;
        }
        auto out_result = WTFMove(result.value());

        auto protocol_jsonMessage = JSON::Object::create();
        protocol_jsonMessage->setString("result"_s, out_result);
        backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
    });
}

void AutomationBackendDispatcher::computeElementLayout(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_browsingContextHandle = m_backendDispatcher->getString(protocol_parameters.get(), "browsingContextHandle"_s, true);
    auto in_frameHandle = m_backendDispatcher->getString(protocol_parameters.get(), "frameHandle"_s, true);
    auto in_nodeHandle = m_backendDispatcher->getString(protocol_parameters.get(), "nodeHandle"_s, true);
    auto in_opt_scrollIntoViewIfNeeded = m_backendDispatcher->getBoolean(protocol_parameters.get(), "scrollIntoViewIfNeeded"_s, false);
    auto in_coordinateSystem_json = m_backendDispatcher->getString(protocol_parameters.get(), "coordinateSystem"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Automation.computeElementLayout' can't be processed"_s);
        return;
    }

    auto in_coordinateSystem = Protocol::AutomationHelpers::parseEnumValueFromString<Protocol::Automation::CoordinateSystem>(in_coordinateSystem_json);
    if (!in_coordinateSystem) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, makeString("Unknown coordinateSystem: "_s, in_coordinateSystem_json));
        return;
    }

    m_agent->computeElementLayout(in_browsingContextHandle, in_frameHandle, in_nodeHandle, WTFMove(in_opt_scrollIntoViewIfNeeded), *in_coordinateSystem, [backendDispatcher = m_backendDispatcher.copyRef(), protocol_requestId](CommandResultOf<Ref<Protocol::Automation::Rect>, RefPtr<Protocol::Automation::Point>, bool> result) {
        if (!result) {
           ASSERT(!result.error().isEmpty());
           backendDispatcher->reportProtocolError(protocol_requestId, BackendDispatcher::ServerError, result.error());
           backendDispatcher->sendPendingErrors();
           return;
        }
        auto [out_rect, out_opt_inViewCenterPoint, out_isObscured] = WTFMove(result.value());

        auto protocol_jsonMessage = JSON::Object::create();
        protocol_jsonMessage->setObject("rect"_s, WTFMove(out_rect));
        if (!!out_opt_inViewCenterPoint)
            protocol_jsonMessage->setObject("inViewCenterPoint"_s, out_opt_inViewCenterPoint.releaseNonNull());
        protocol_jsonMessage->setBoolean("isObscured"_s, out_isObscured);
        backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
    });
}

void AutomationBackendDispatcher::getComputedRole(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_browsingContextHandle = m_backendDispatcher->getString(protocol_parameters.get(), "browsingContextHandle"_s, true);
    auto in_frameHandle = m_backendDispatcher->getString(protocol_parameters.get(), "frameHandle"_s, true);
    auto in_nodeHandle = m_backendDispatcher->getString(protocol_parameters.get(), "nodeHandle"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Automation.getComputedRole' can't be processed"_s);
        return;
    }

    m_agent->getComputedRole(in_browsingContextHandle, in_frameHandle, in_nodeHandle, [backendDispatcher = m_backendDispatcher.copyRef(), protocol_requestId](CommandResult<String> result) {
        if (!result) {
           ASSERT(!result.error().isEmpty());
           backendDispatcher->reportProtocolError(protocol_requestId, BackendDispatcher::ServerError, result.error());
           backendDispatcher->sendPendingErrors();
           return;
        }
        auto out_role = WTFMove(result.value());

        auto protocol_jsonMessage = JSON::Object::create();
        protocol_jsonMessage->setString("role"_s, out_role);
        backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
    });
}

void AutomationBackendDispatcher::getComputedLabel(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_browsingContextHandle = m_backendDispatcher->getString(protocol_parameters.get(), "browsingContextHandle"_s, true);
    auto in_frameHandle = m_backendDispatcher->getString(protocol_parameters.get(), "frameHandle"_s, true);
    auto in_nodeHandle = m_backendDispatcher->getString(protocol_parameters.get(), "nodeHandle"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Automation.getComputedLabel' can't be processed"_s);
        return;
    }

    m_agent->getComputedLabel(in_browsingContextHandle, in_frameHandle, in_nodeHandle, [backendDispatcher = m_backendDispatcher.copyRef(), protocol_requestId](CommandResult<String> result) {
        if (!result) {
           ASSERT(!result.error().isEmpty());
           backendDispatcher->reportProtocolError(protocol_requestId, BackendDispatcher::ServerError, result.error());
           backendDispatcher->sendPendingErrors();
           return;
        }
        auto out_label = WTFMove(result.value());

        auto protocol_jsonMessage = JSON::Object::create();
        protocol_jsonMessage->setString("label"_s, out_label);
        backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
    });
}

void AutomationBackendDispatcher::selectOptionElement(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_browsingContextHandle = m_backendDispatcher->getString(protocol_parameters.get(), "browsingContextHandle"_s, true);
    auto in_frameHandle = m_backendDispatcher->getString(protocol_parameters.get(), "frameHandle"_s, true);
    auto in_nodeHandle = m_backendDispatcher->getString(protocol_parameters.get(), "nodeHandle"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Automation.selectOptionElement' can't be processed"_s);
        return;
    }

    m_agent->selectOptionElement(in_browsingContextHandle, in_frameHandle, in_nodeHandle, [backendDispatcher = m_backendDispatcher.copyRef(), protocol_requestId](CommandResult<void> result) {
        if (!result) {
           ASSERT(!result.error().isEmpty());
           backendDispatcher->reportProtocolError(protocol_requestId, BackendDispatcher::ServerError, result.error());
           backendDispatcher->sendPendingErrors();
           return;
        }

        auto protocol_jsonMessage = JSON::Object::create();
        backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
    });
}

void AutomationBackendDispatcher::isShowingJavaScriptDialog(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_browsingContextHandle = m_backendDispatcher->getString(protocol_parameters.get(), "browsingContextHandle"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Automation.isShowingJavaScriptDialog' can't be processed"_s);
        return;
    }

    auto result = m_agent->isShowingJavaScriptDialog(in_browsingContextHandle);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto out_result = WTFMove(result.value());

    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setBoolean("result"_s, out_result);
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void AutomationBackendDispatcher::dismissCurrentJavaScriptDialog(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_browsingContextHandle = m_backendDispatcher->getString(protocol_parameters.get(), "browsingContextHandle"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Automation.dismissCurrentJavaScriptDialog' can't be processed"_s);
        return;
    }

    auto result = m_agent->dismissCurrentJavaScriptDialog(in_browsingContextHandle);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void AutomationBackendDispatcher::acceptCurrentJavaScriptDialog(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_browsingContextHandle = m_backendDispatcher->getString(protocol_parameters.get(), "browsingContextHandle"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Automation.acceptCurrentJavaScriptDialog' can't be processed"_s);
        return;
    }

    auto result = m_agent->acceptCurrentJavaScriptDialog(in_browsingContextHandle);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void AutomationBackendDispatcher::messageOfCurrentJavaScriptDialog(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_browsingContextHandle = m_backendDispatcher->getString(protocol_parameters.get(), "browsingContextHandle"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Automation.messageOfCurrentJavaScriptDialog' can't be processed"_s);
        return;
    }

    auto result = m_agent->messageOfCurrentJavaScriptDialog(in_browsingContextHandle);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto out_message = WTFMove(result.value());

    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("message"_s, out_message);
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void AutomationBackendDispatcher::setUserInputForCurrentJavaScriptPrompt(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_browsingContextHandle = m_backendDispatcher->getString(protocol_parameters.get(), "browsingContextHandle"_s, true);
    auto in_userInput = m_backendDispatcher->getString(protocol_parameters.get(), "userInput"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Automation.setUserInputForCurrentJavaScriptPrompt' can't be processed"_s);
        return;
    }

    auto result = m_agent->setUserInputForCurrentJavaScriptPrompt(in_browsingContextHandle, in_userInput);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void AutomationBackendDispatcher::setFilesToSelectForFileUpload(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_browsingContextHandle = m_backendDispatcher->getString(protocol_parameters.get(), "browsingContextHandle"_s, true);
    auto in_filenames = m_backendDispatcher->getArray(protocol_parameters.get(), "filenames"_s, true);
    auto in_opt_fileContents = m_backendDispatcher->getArray(protocol_parameters.get(), "fileContents"_s, false);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Automation.setFilesToSelectForFileUpload' can't be processed"_s);
        return;
    }

    auto result = m_agent->setFilesToSelectForFileUpload(in_browsingContextHandle, in_filenames.releaseNonNull(), WTFMove(in_opt_fileContents));
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void AutomationBackendDispatcher::setFilesForInputFileUpload(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_browsingContextHandle = m_backendDispatcher->getString(protocol_parameters.get(), "browsingContextHandle"_s, true);
    auto in_frameHandle = m_backendDispatcher->getString(protocol_parameters.get(), "frameHandle"_s, true);
    auto in_nodeHandle = m_backendDispatcher->getString(protocol_parameters.get(), "nodeHandle"_s, true);
    auto in_filenames = m_backendDispatcher->getArray(protocol_parameters.get(), "filenames"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Automation.setFilesForInputFileUpload' can't be processed"_s);
        return;
    }

    m_agent->setFilesForInputFileUpload(in_browsingContextHandle, in_frameHandle, in_nodeHandle, in_filenames.releaseNonNull(), [backendDispatcher = m_backendDispatcher.copyRef(), protocol_requestId](CommandResult<void> result) {
        if (!result) {
           ASSERT(!result.error().isEmpty());
           backendDispatcher->reportProtocolError(protocol_requestId, BackendDispatcher::ServerError, result.error());
           backendDispatcher->sendPendingErrors();
           return;
        }

        auto protocol_jsonMessage = JSON::Object::create();
        backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
    });
}

void AutomationBackendDispatcher::getAllCookies(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_browsingContextHandle = m_backendDispatcher->getString(protocol_parameters.get(), "browsingContextHandle"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Automation.getAllCookies' can't be processed"_s);
        return;
    }

    m_agent->getAllCookies(in_browsingContextHandle, [backendDispatcher = m_backendDispatcher.copyRef(), protocol_requestId](CommandResult<Ref<JSON::ArrayOf<Protocol::Automation::Cookie>>> result) {
        if (!result) {
           ASSERT(!result.error().isEmpty());
           backendDispatcher->reportProtocolError(protocol_requestId, BackendDispatcher::ServerError, result.error());
           backendDispatcher->sendPendingErrors();
           return;
        }
        auto out_cookies = WTFMove(result.value());

        auto protocol_jsonMessage = JSON::Object::create();
        protocol_jsonMessage->setArray("cookies"_s, WTFMove(out_cookies));
        backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
    });
}

void AutomationBackendDispatcher::deleteSingleCookie(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_browsingContextHandle = m_backendDispatcher->getString(protocol_parameters.get(), "browsingContextHandle"_s, true);
    auto in_cookieName = m_backendDispatcher->getString(protocol_parameters.get(), "cookieName"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Automation.deleteSingleCookie' can't be processed"_s);
        return;
    }

    m_agent->deleteSingleCookie(in_browsingContextHandle, in_cookieName, [backendDispatcher = m_backendDispatcher.copyRef(), protocol_requestId](CommandResult<void> result) {
        if (!result) {
           ASSERT(!result.error().isEmpty());
           backendDispatcher->reportProtocolError(protocol_requestId, BackendDispatcher::ServerError, result.error());
           backendDispatcher->sendPendingErrors();
           return;
        }

        auto protocol_jsonMessage = JSON::Object::create();
        backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
    });
}

void AutomationBackendDispatcher::addSingleCookie(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_browsingContextHandle = m_backendDispatcher->getString(protocol_parameters.get(), "browsingContextHandle"_s, true);
    auto in_cookie = m_backendDispatcher->getObject(protocol_parameters.get(), "cookie"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Automation.addSingleCookie' can't be processed"_s);
        return;
    }

    m_agent->addSingleCookie(in_browsingContextHandle, in_cookie.releaseNonNull(), [backendDispatcher = m_backendDispatcher.copyRef(), protocol_requestId](CommandResult<void> result) {
        if (!result) {
           ASSERT(!result.error().isEmpty());
           backendDispatcher->reportProtocolError(protocol_requestId, BackendDispatcher::ServerError, result.error());
           backendDispatcher->sendPendingErrors();
           return;
        }

        auto protocol_jsonMessage = JSON::Object::create();
        backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
    });
}

void AutomationBackendDispatcher::deleteAllCookies(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_browsingContextHandle = m_backendDispatcher->getString(protocol_parameters.get(), "browsingContextHandle"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Automation.deleteAllCookies' can't be processed"_s);
        return;
    }

    auto result = m_agent->deleteAllCookies(in_browsingContextHandle);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void AutomationBackendDispatcher::getSessionPermissions(long protocol_requestId, RefPtr<JSON::Object>&&)
{
    auto result = m_agent->getSessionPermissions();
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto out_permissions = WTFMove(result.value());

    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setArray("permissions"_s, WTFMove(out_permissions));
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void AutomationBackendDispatcher::setSessionPermissions(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_permissions = m_backendDispatcher->getArray(protocol_parameters.get(), "permissions"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Automation.setSessionPermissions' can't be processed"_s);
        return;
    }

    auto result = m_agent->setSessionPermissions(in_permissions.releaseNonNull());
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void AutomationBackendDispatcher::addVirtualAuthenticator(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_browsingContextHandle = m_backendDispatcher->getString(protocol_parameters.get(), "browsingContextHandle"_s, true);
    auto in_authenticator = m_backendDispatcher->getObject(protocol_parameters.get(), "authenticator"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Automation.addVirtualAuthenticator' can't be processed"_s);
        return;
    }

    auto result = m_agent->addVirtualAuthenticator(in_browsingContextHandle, in_authenticator.releaseNonNull());
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto out_authenticatorId = WTFMove(result.value());

    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("authenticatorId"_s, out_authenticatorId);
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void AutomationBackendDispatcher::removeVirtualAuthenticator(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_browsingContextHandle = m_backendDispatcher->getString(protocol_parameters.get(), "browsingContextHandle"_s, true);
    auto in_authenticatorId = m_backendDispatcher->getString(protocol_parameters.get(), "authenticatorId"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Automation.removeVirtualAuthenticator' can't be processed"_s);
        return;
    }

    auto result = m_agent->removeVirtualAuthenticator(in_browsingContextHandle, in_authenticatorId);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void AutomationBackendDispatcher::addVirtualAuthenticatorCredential(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_browsingContextHandle = m_backendDispatcher->getString(protocol_parameters.get(), "browsingContextHandle"_s, true);
    auto in_authenticatorId = m_backendDispatcher->getString(protocol_parameters.get(), "authenticatorId"_s, true);
    auto in_credential = m_backendDispatcher->getObject(protocol_parameters.get(), "credential"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Automation.addVirtualAuthenticatorCredential' can't be processed"_s);
        return;
    }

    auto result = m_agent->addVirtualAuthenticatorCredential(in_browsingContextHandle, in_authenticatorId, in_credential.releaseNonNull());
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void AutomationBackendDispatcher::getVirtualAuthenticatorCredentials(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_browsingContextHandle = m_backendDispatcher->getString(protocol_parameters.get(), "browsingContextHandle"_s, true);
    auto in_authenticatorId = m_backendDispatcher->getString(protocol_parameters.get(), "authenticatorId"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Automation.getVirtualAuthenticatorCredentials' can't be processed"_s);
        return;
    }

    auto result = m_agent->getVirtualAuthenticatorCredentials(in_browsingContextHandle, in_authenticatorId);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto out_credentials = WTFMove(result.value());

    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setArray("credentials"_s, WTFMove(out_credentials));
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void AutomationBackendDispatcher::removeVirtualAuthenticatorCredential(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_browsingContextHandle = m_backendDispatcher->getString(protocol_parameters.get(), "browsingContextHandle"_s, true);
    auto in_authenticatorId = m_backendDispatcher->getString(protocol_parameters.get(), "authenticatorId"_s, true);
    auto in_credentialId = m_backendDispatcher->getString(protocol_parameters.get(), "credentialId"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Automation.removeVirtualAuthenticatorCredential' can't be processed"_s);
        return;
    }

    auto result = m_agent->removeVirtualAuthenticatorCredential(in_browsingContextHandle, in_authenticatorId, in_credentialId);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void AutomationBackendDispatcher::removeAllVirtualAuthenticatorCredentials(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_browsingContextHandle = m_backendDispatcher->getString(protocol_parameters.get(), "browsingContextHandle"_s, true);
    auto in_authenticatorId = m_backendDispatcher->getString(protocol_parameters.get(), "authenticatorId"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Automation.removeAllVirtualAuthenticatorCredentials' can't be processed"_s);
        return;
    }

    auto result = m_agent->removeAllVirtualAuthenticatorCredentials(in_browsingContextHandle, in_authenticatorId);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void AutomationBackendDispatcher::setVirtualAuthenticatorUserVerified(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_browsingContextHandle = m_backendDispatcher->getString(protocol_parameters.get(), "browsingContextHandle"_s, true);
    auto in_authenticatorId = m_backendDispatcher->getString(protocol_parameters.get(), "authenticatorId"_s, true);
    auto in_isUserVerified = m_backendDispatcher->getBoolean(protocol_parameters.get(), "isUserVerified"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Automation.setVirtualAuthenticatorUserVerified' can't be processed"_s);
        return;
    }

    auto result = m_agent->setVirtualAuthenticatorUserVerified(in_browsingContextHandle, in_authenticatorId, *in_isUserVerified);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

void AutomationBackendDispatcher::generateTestReport(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_browsingContextHandle = m_backendDispatcher->getString(protocol_parameters.get(), "browsingContextHandle"_s, true);
    auto in_message = m_backendDispatcher->getString(protocol_parameters.get(), "message"_s, true);
    auto in_group = m_backendDispatcher->getString(protocol_parameters.get(), "group"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Automation.generateTestReport' can't be processed"_s);
        return;
    }

    auto result = m_agent->generateTestReport(in_browsingContextHandle, in_message, in_group);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}

#if defined(WTF_PLATFORM_MAC) && WTF_PLATFORM_MAC
void AutomationBackendDispatcher::loadWebExtension(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_type_json = m_backendDispatcher->getString(protocol_parameters.get(), "type"_s, true);
    auto in_value = m_backendDispatcher->getString(protocol_parameters.get(), "value"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Automation.loadWebExtension' can't be processed"_s);
        return;
    }

    auto in_type = Protocol::AutomationHelpers::parseEnumValueFromString<Protocol::Automation::WebExtensionResourceOptions>(in_type_json);
    if (!in_type) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, makeString("Unknown type: "_s, in_type_json));
        return;
    }

    m_agent->loadWebExtension(*in_type, in_value, [backendDispatcher = m_backendDispatcher.copyRef(), protocol_requestId](CommandResult<String> result) {
        if (!result) {
           ASSERT(!result.error().isEmpty());
           backendDispatcher->reportProtocolError(protocol_requestId, BackendDispatcher::ServerError, result.error());
           backendDispatcher->sendPendingErrors();
           return;
        }
        auto out_extension = WTFMove(result.value());

        auto protocol_jsonMessage = JSON::Object::create();
        protocol_jsonMessage->setString("extension"_s, out_extension);
        backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
    });
}
#endif // defined(WTF_PLATFORM_MAC) && WTF_PLATFORM_MAC

#if defined(WTF_PLATFORM_MAC) && WTF_PLATFORM_MAC
void AutomationBackendDispatcher::unloadWebExtension(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_identifier = m_backendDispatcher->getString(protocol_parameters.get(), "identifier"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Automation.unloadWebExtension' can't be processed"_s);
        return;
    }

    m_agent->unloadWebExtension(in_identifier, [backendDispatcher = m_backendDispatcher.copyRef(), protocol_requestId](CommandResult<void> result) {
        if (!result) {
           ASSERT(!result.error().isEmpty());
           backendDispatcher->reportProtocolError(protocol_requestId, BackendDispatcher::ServerError, result.error());
           backendDispatcher->sendPendingErrors();
           return;
        }

        auto protocol_jsonMessage = JSON::Object::create();
        backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
    });
}
#endif // defined(WTF_PLATFORM_MAC) && WTF_PLATFORM_MAC

#if ENABLE(WEBDRIVER_BIDI)
void AutomationBackendDispatcher::processBidiMessage(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters)
{
    auto in_message = m_backendDispatcher->getString(protocol_parameters.get(), "message"_s, true);
    if (m_backendDispatcher->hasProtocolErrors()) {
        m_backendDispatcher->reportProtocolError(BackendDispatcher::InvalidParams, "Some arguments of method 'Automation.processBidiMessage' can't be processed"_s);
        return;
    }

    auto result = m_agent->processBidiMessage(in_message);
    if (!result) {
        ASSERT(!result.error().isEmpty());
        m_backendDispatcher->reportProtocolError(BackendDispatcher::ServerError, result.error());
        return;
    }

    auto protocol_jsonMessage = JSON::Object::create();
    m_backendDispatcher->sendResponse(protocol_requestId, WTFMove(protocol_jsonMessage), false);
}
#endif // ENABLE(WEBDRIVER_BIDI)

} // namespace Inspector
