/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSSpeechRecognitionErrorCode.h"

#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>
#include <wtf/SortedArrayMap.h>



namespace WebCore {
using namespace JSC;

String convertEnumerationToString(SpeechRecognitionErrorCode enumerationValue)
{
    static const std::array<NeverDestroyed<String>, 8> values {
        MAKE_STATIC_STRING_IMPL("no-speech"),
        MAKE_STATIC_STRING_IMPL("aborted"),
        MAKE_STATIC_STRING_IMPL("audio-capture"),
        MAKE_STATIC_STRING_IMPL("network"),
        MAKE_STATIC_STRING_IMPL("not-allowed"),
        MAKE_STATIC_STRING_IMPL("service-not-allowed"),
        MAKE_STATIC_STRING_IMPL("bad-grammar"),
        MAKE_STATIC_STRING_IMPL("language-not-supported"),
    };
    static_assert(static_cast<size_t>(SpeechRecognitionErrorCode::NoSpeech) == 0, "SpeechRecognitionErrorCode::NoSpeech is not 0 as expected");
    static_assert(static_cast<size_t>(SpeechRecognitionErrorCode::Aborted) == 1, "SpeechRecognitionErrorCode::Aborted is not 1 as expected");
    static_assert(static_cast<size_t>(SpeechRecognitionErrorCode::AudioCapture) == 2, "SpeechRecognitionErrorCode::AudioCapture is not 2 as expected");
    static_assert(static_cast<size_t>(SpeechRecognitionErrorCode::Network) == 3, "SpeechRecognitionErrorCode::Network is not 3 as expected");
    static_assert(static_cast<size_t>(SpeechRecognitionErrorCode::NotAllowed) == 4, "SpeechRecognitionErrorCode::NotAllowed is not 4 as expected");
    static_assert(static_cast<size_t>(SpeechRecognitionErrorCode::ServiceNotAllowed) == 5, "SpeechRecognitionErrorCode::ServiceNotAllowed is not 5 as expected");
    static_assert(static_cast<size_t>(SpeechRecognitionErrorCode::BadGrammar) == 6, "SpeechRecognitionErrorCode::BadGrammar is not 6 as expected");
    static_assert(static_cast<size_t>(SpeechRecognitionErrorCode::LanguageNotSupported) == 7, "SpeechRecognitionErrorCode::LanguageNotSupported is not 7 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, SpeechRecognitionErrorCode enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<SpeechRecognitionErrorCode> parseEnumerationFromString<SpeechRecognitionErrorCode>(const String& stringValue)
{
    static constexpr std::array<std::pair<ComparableASCIILiteral, SpeechRecognitionErrorCode>, 8> mappings {
        std::pair<ComparableASCIILiteral, SpeechRecognitionErrorCode> { "aborted"_s, SpeechRecognitionErrorCode::Aborted },
        std::pair<ComparableASCIILiteral, SpeechRecognitionErrorCode> { "audio-capture"_s, SpeechRecognitionErrorCode::AudioCapture },
        std::pair<ComparableASCIILiteral, SpeechRecognitionErrorCode> { "bad-grammar"_s, SpeechRecognitionErrorCode::BadGrammar },
        std::pair<ComparableASCIILiteral, SpeechRecognitionErrorCode> { "language-not-supported"_s, SpeechRecognitionErrorCode::LanguageNotSupported },
        std::pair<ComparableASCIILiteral, SpeechRecognitionErrorCode> { "network"_s, SpeechRecognitionErrorCode::Network },
        std::pair<ComparableASCIILiteral, SpeechRecognitionErrorCode> { "no-speech"_s, SpeechRecognitionErrorCode::NoSpeech },
        std::pair<ComparableASCIILiteral, SpeechRecognitionErrorCode> { "not-allowed"_s, SpeechRecognitionErrorCode::NotAllowed },
        std::pair<ComparableASCIILiteral, SpeechRecognitionErrorCode> { "service-not-allowed"_s, SpeechRecognitionErrorCode::ServiceNotAllowed },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); enumerationValue) [[likely]]
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<SpeechRecognitionErrorCode> parseEnumeration<SpeechRecognitionErrorCode>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<SpeechRecognitionErrorCode>(value.toWTFString(&lexicalGlobalObject));
}

template<> ASCIILiteral expectedEnumerationValues<SpeechRecognitionErrorCode>()
{
    return "\"no-speech\", \"aborted\", \"audio-capture\", \"network\", \"not-allowed\", \"service-not-allowed\", \"bad-grammar\", \"language-not-supported\""_s;
}

} // namespace WebCore

