/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSOESTextureHalfFloat.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMBinding.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include "WebCoreOpaqueRootInlines.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

class JSOESTextureHalfFloatPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSOESTextureHalfFloatPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSOESTextureHalfFloatPrototype* ptr = new (NotNull, JSC::allocateCell<JSOESTextureHalfFloatPrototype>(vm)) JSOESTextureHalfFloatPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSOESTextureHalfFloatPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSOESTextureHalfFloatPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSOESTextureHalfFloatPrototype, JSOESTextureHalfFloatPrototype::Base);

/* Hash table for prototype */

static const std::array<HashTableValue, 1> JSOESTextureHalfFloatPrototypeTableValues {
    HashTableValue { "HALF_FLOAT_OES"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8D61 } },
};

const ClassInfo JSOESTextureHalfFloatPrototype::s_info = { "OESTextureHalfFloat"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSOESTextureHalfFloatPrototype) };

void JSOESTextureHalfFloatPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSOESTextureHalfFloat::info(), JSOESTextureHalfFloatPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSOESTextureHalfFloat::s_info = { "OESTextureHalfFloat"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSOESTextureHalfFloat) };

JSOESTextureHalfFloat::JSOESTextureHalfFloat(Structure* structure, JSDOMGlobalObject& globalObject, Ref<OESTextureHalfFloat>&& impl)
    : JSDOMWrapper<OESTextureHalfFloat>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, OESTextureHalfFloat>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSOESTextureHalfFloat::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSOESTextureHalfFloatPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSOESTextureHalfFloatPrototype::create(vm, &globalObject, structure);
}

JSObject* JSOESTextureHalfFloat::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSOESTextureHalfFloat>(vm, globalObject);
}

void JSOESTextureHalfFloat::destroy(JSC::JSCell* cell)
{
    JSOESTextureHalfFloat* thisObject = static_cast<JSOESTextureHalfFloat*>(cell);
    thisObject->JSOESTextureHalfFloat::~JSOESTextureHalfFloat();
}

JSC::GCClient::IsoSubspace* JSOESTextureHalfFloat::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSOESTextureHalfFloat, UseCustomHeapCellType::No>(vm, "JSOESTextureHalfFloat"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForOESTextureHalfFloat.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForOESTextureHalfFloat = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForOESTextureHalfFloat.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForOESTextureHalfFloat = std::forward<decltype(space)>(space); }
    );
}

void JSOESTextureHalfFloat::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSOESTextureHalfFloat*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSOESTextureHalfFloatOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    auto* jsOESTextureHalfFloat = jsCast<JSOESTextureHalfFloat*>(handle.slot()->asCell());
    auto& owner = jsOESTextureHalfFloat->wrapped();
    if (reason) [[unlikely]]
        *reason = "Reachable from jsOESTextureHalfFloat"_s;
    return containsWebCoreOpaqueRoot(visitor, owner);
}

void JSOESTextureHalfFloatOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsOESTextureHalfFloat = static_cast<JSOESTextureHalfFloat*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsOESTextureHalfFloat->protectedWrapped().ptr(), jsOESTextureHalfFloat);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7OESTextureHalfFloat@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore19OESTextureHalfFloatE[]; }
#endif
template<std::same_as<OESTextureHalfFloat> T>
static inline void verifyVTable(OESTextureHalfFloat* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7OESTextureHalfFloat@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore19OESTextureHalfFloatE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // OESTextureHalfFloat has subclasses. If OESTextureHalfFloat has subclasses that get passed
        // to toJS() we currently require OESTextureHalfFloat you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<OESTextureHalfFloat>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<OESTextureHalfFloat>(impl.ptr());
#endif
    return createWrapper<OESTextureHalfFloat>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, OESTextureHalfFloat& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

OESTextureHalfFloat* JSOESTextureHalfFloat::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSOESTextureHalfFloat*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGL)
