/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSSVGSymbolElement.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "JSSVGAnimatedPreserveAspectRatio.h"
#include "JSSVGAnimatedRect.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsSVGSymbolElementConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGSymbolElement_viewBox);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGSymbolElement_preserveAspectRatio);

class JSSVGSymbolElementPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSSVGSymbolElementPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSSVGSymbolElementPrototype* ptr = new (NotNull, JSC::allocateCell<JSSVGSymbolElementPrototype>(vm)) JSSVGSymbolElementPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSSVGSymbolElementPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSSVGSymbolElementPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSSVGSymbolElementPrototype, JSSVGSymbolElementPrototype::Base);

using JSSVGSymbolElementDOMConstructor = JSDOMConstructorNotConstructable<JSSVGSymbolElement>;

template<> const ClassInfo JSSVGSymbolElementDOMConstructor::s_info = { "SVGSymbolElement"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGSymbolElementDOMConstructor) };

template<> JSValue JSSVGSymbolElementDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSSVGGraphicsElement::getConstructor(vm, &globalObject);
}

template<> void JSSVGSymbolElementDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "SVGSymbolElement"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSSVGSymbolElement::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 3> JSSVGSymbolElementPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGSymbolElementConstructor, 0 } },
    HashTableValue { "viewBox"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGSymbolElement_viewBox, 0 } },
    HashTableValue { "preserveAspectRatio"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGSymbolElement_preserveAspectRatio, 0 } },
};

const ClassInfo JSSVGSymbolElementPrototype::s_info = { "SVGSymbolElement"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGSymbolElementPrototype) };

void JSSVGSymbolElementPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSSVGSymbolElement::info(), JSSVGSymbolElementPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSSVGSymbolElement::s_info = { "SVGSymbolElement"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGSymbolElement) };

JSSVGSymbolElement::JSSVGSymbolElement(Structure* structure, JSDOMGlobalObject& globalObject, Ref<SVGSymbolElement>&& impl)
    : JSSVGGraphicsElement(structure, globalObject, WTFMove(impl))
{
}

Ref<SVGSymbolElement> JSSVGSymbolElement::protectedWrapped() const
{
    return wrapped();
}

JSObject* JSSVGSymbolElement::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSSVGSymbolElementPrototype::createStructure(vm, &globalObject, JSSVGGraphicsElement::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSSVGSymbolElementPrototype::create(vm, &globalObject, structure);
}

JSObject* JSSVGSymbolElement::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSSVGSymbolElement>(vm, globalObject);
}

JSValue JSSVGSymbolElement::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGSymbolElementDOMConstructor, DOMConstructorID::SVGSymbolElement>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGSymbolElementConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSSVGSymbolElementPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSSVGSymbolElement::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsSVGSymbolElement_viewBoxGetter(JSGlobalObject& lexicalGlobalObject, JSSVGSymbolElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<SVGAnimatedRect>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.viewBoxAnimated())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGSymbolElement_viewBox, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGSymbolElement>::get<jsSVGSymbolElement_viewBoxGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSVGSymbolElement_preserveAspectRatioGetter(JSGlobalObject& lexicalGlobalObject, JSSVGSymbolElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<SVGAnimatedPreserveAspectRatio>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.preserveAspectRatioAnimated())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGSymbolElement_preserveAspectRatio, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGSymbolElement>::get<jsSVGSymbolElement_preserveAspectRatioGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSSVGSymbolElement::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSSVGSymbolElement, UseCustomHeapCellType::No>(vm, "JSSVGSymbolElement"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForSVGSymbolElement.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForSVGSymbolElement = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForSVGSymbolElement.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForSVGSymbolElement = std::forward<decltype(space)>(space); }
    );
}

void JSSVGSymbolElement::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSSVGSymbolElement*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}


}
