/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSIDBFactory.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "DOMPromiseProxy.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertAny.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertOptional.h"
#include "JSDOMConvertPromise.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMOperationReturningPromise.h"
#include "JSDOMWrapperCache.h"
#include "JSIDBOpenDBRequest.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/ObjectConstructor.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const IDBFactory::DatabaseInfo& dictionary)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    if (!IDLDOMString::isNullValue(dictionary.name)) {
        auto nameValue = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, IDLDOMString::extractValueFromNullable(dictionary.name));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "name"_s), nameValue);
    }
    if (!IDLUnsignedLongLong::isNullValue(dictionary.version)) {
        auto versionValue = toJS<IDLUnsignedLongLong>(lexicalGlobalObject, throwScope, IDLUnsignedLongLong::extractValueFromNullable(dictionary.version));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "version"_s), versionValue);
    }
    return result;
}

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsIDBFactoryPrototypeFunction_open);
static JSC_DECLARE_HOST_FUNCTION(jsIDBFactoryPrototypeFunction_deleteDatabase);
static JSC_DECLARE_HOST_FUNCTION(jsIDBFactoryPrototypeFunction_databases);
static JSC_DECLARE_HOST_FUNCTION(jsIDBFactoryPrototypeFunction_cmp);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsIDBFactoryConstructor);

class JSIDBFactoryPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSIDBFactoryPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSIDBFactoryPrototype* ptr = new (NotNull, JSC::allocateCell<JSIDBFactoryPrototype>(vm)) JSIDBFactoryPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSIDBFactoryPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSIDBFactoryPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSIDBFactoryPrototype, JSIDBFactoryPrototype::Base);

using JSIDBFactoryDOMConstructor = JSDOMConstructorNotConstructable<JSIDBFactory>;

template<> const ClassInfo JSIDBFactoryDOMConstructor::s_info = { "IDBFactory"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSIDBFactoryDOMConstructor) };

template<> JSValue JSIDBFactoryDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSIDBFactoryDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "IDBFactory"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSIDBFactory::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 5> JSIDBFactoryPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsIDBFactoryConstructor, 0 } },
    HashTableValue { "open"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsIDBFactoryPrototypeFunction_open, 1 } },
    HashTableValue { "deleteDatabase"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsIDBFactoryPrototypeFunction_deleteDatabase, 1 } },
    HashTableValue { "databases"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsIDBFactoryPrototypeFunction_databases, 0 } },
    HashTableValue { "cmp"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsIDBFactoryPrototypeFunction_cmp, 2 } },
};

const ClassInfo JSIDBFactoryPrototype::s_info = { "IDBFactory"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSIDBFactoryPrototype) };

void JSIDBFactoryPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSIDBFactory::info(), JSIDBFactoryPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSIDBFactory::s_info = { "IDBFactory"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSIDBFactory) };

JSIDBFactory::JSIDBFactory(Structure* structure, JSDOMGlobalObject& globalObject, Ref<IDBFactory>&& impl)
    : JSDOMWrapper<IDBFactory>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, IDBFactory>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSIDBFactory::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSIDBFactoryPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSIDBFactoryPrototype::create(vm, &globalObject, structure);
}

JSObject* JSIDBFactory::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSIDBFactory>(vm, globalObject);
}

JSValue JSIDBFactory::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSIDBFactoryDOMConstructor, DOMConstructorID::IDBFactory>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSIDBFactory::destroy(JSC::JSCell* cell)
{
    JSIDBFactory* thisObject = static_cast<JSIDBFactory*>(cell);
    thisObject->JSIDBFactory::~JSIDBFactory();
}

JSC_DEFINE_CUSTOM_GETTER(jsIDBFactoryConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSIDBFactoryPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSIDBFactory::getConstructor(vm, prototype->globalObject()));
}

static inline JSC::EncodedJSValue jsIDBFactoryPrototypeFunction_openBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBFactory>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto* context = (*castedThis).globalObject()->scriptExecutionContext();
    if (!context) [[unlikely]]
        return JSValue::encode(jsUndefined());
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto nameConversionResult = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    if (nameConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto versionConversionResult = convert<IDLOptional<IDLEnforceRangeAdaptor<IDLUnsignedLongLong>>>(*lexicalGlobalObject, argument1.value());
    if (versionConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<IDBOpenDBRequest>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.open(*context, nameConversionResult.releaseReturnValue(), versionConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsIDBFactoryPrototypeFunction_open, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSIDBFactory>::call<jsIDBFactoryPrototypeFunction_openBody>(*lexicalGlobalObject, *callFrame, "open");
}

static inline JSC::EncodedJSValue jsIDBFactoryPrototypeFunction_deleteDatabaseBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBFactory>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto* context = (*castedThis).globalObject()->scriptExecutionContext();
    if (!context) [[unlikely]]
        return JSValue::encode(jsUndefined());
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto nameConversionResult = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    if (nameConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<IDBOpenDBRequest>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.deleteDatabase(*context, nameConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsIDBFactoryPrototypeFunction_deleteDatabase, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSIDBFactory>::call<jsIDBFactoryPrototypeFunction_deleteDatabaseBody>(*lexicalGlobalObject, *callFrame, "deleteDatabase");
}

static inline JSC::EncodedJSValue jsIDBFactoryPrototypeFunction_databasesBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSIDBFactory>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    auto* context = (*castedThis).globalObject()->scriptExecutionContext();
    if (!context) [[unlikely]]
        return JSValue::encode(jsUndefined());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLSequence<IDLDictionary<IDBFactory::DatabaseInfo>>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.databases(*context, WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsIDBFactoryPrototypeFunction_databases, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSIDBFactory>::call<jsIDBFactoryPrototypeFunction_databasesBody>(*lexicalGlobalObject, *callFrame, "databases");
}

static inline JSC::EncodedJSValue jsIDBFactoryPrototypeFunction_cmpBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBFactory>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 2) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto firstConversionResult = convert<IDLAny>(*lexicalGlobalObject, argument0.value());
    if (firstConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto secondConversionResult = convert<IDLAny>(*lexicalGlobalObject, argument1.value());
    if (secondConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLShort>(*lexicalGlobalObject, throwScope, impl.cmp(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), firstConversionResult.releaseReturnValue(), secondConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsIDBFactoryPrototypeFunction_cmp, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSIDBFactory>::call<jsIDBFactoryPrototypeFunction_cmpBody>(*lexicalGlobalObject, *callFrame, "cmp");
}

JSC::GCClient::IsoSubspace* JSIDBFactory::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSIDBFactory, UseCustomHeapCellType::No>(vm, "JSIDBFactory"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForIDBFactory.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForIDBFactory = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForIDBFactory.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForIDBFactory = std::forward<decltype(space)>(space); }
    );
}

void JSIDBFactory::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSIDBFactory*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSIDBFactoryOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSIDBFactoryOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsIDBFactory = static_cast<JSIDBFactory*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsIDBFactory->protectedWrapped().ptr(), jsIDBFactory);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<IDBFactory>&& impl)
{
    return createWrapper<IDBFactory>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, IDBFactory& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

IDBFactory* JSIDBFactory::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSIDBFactory*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
