/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPULoadOp.h"

#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>
#include <wtf/SortedArrayMap.h>



namespace WebCore {
using namespace JSC;

String convertEnumerationToString(GPULoadOp enumerationValue)
{
    static const std::array<NeverDestroyed<String>, 2> values {
        MAKE_STATIC_STRING_IMPL("load"),
        MAKE_STATIC_STRING_IMPL("clear"),
    };
    static_assert(static_cast<size_t>(GPULoadOp::Load) == 0, "GPULoadOp::Load is not 0 as expected");
    static_assert(static_cast<size_t>(GPULoadOp::Clear) == 1, "GPULoadOp::Clear is not 1 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, GPULoadOp enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<GPULoadOp> parseEnumerationFromString<GPULoadOp>(const String& stringValue)
{
    static constexpr std::array<std::pair<ComparableASCIILiteral, GPULoadOp>, 2> mappings {
        std::pair<ComparableASCIILiteral, GPULoadOp> { "clear"_s, GPULoadOp::Clear },
        std::pair<ComparableASCIILiteral, GPULoadOp> { "load"_s, GPULoadOp::Load },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); enumerationValue) [[likely]]
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<GPULoadOp> parseEnumeration<GPULoadOp>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<GPULoadOp>(value.toWTFString(&lexicalGlobalObject));
}

template<> ASCIILiteral expectedEnumerationValues<GPULoadOp>()
{
    return "\"load\", \"clear\""_s;
}

} // namespace WebCore

