/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSWebGLStencilTexturing.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMBinding.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include "WebCoreOpaqueRootInlines.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

class JSWebGLStencilTexturingPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSWebGLStencilTexturingPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWebGLStencilTexturingPrototype* ptr = new (NotNull, JSC::allocateCell<JSWebGLStencilTexturingPrototype>(vm)) JSWebGLStencilTexturingPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebGLStencilTexturingPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWebGLStencilTexturingPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebGLStencilTexturingPrototype, JSWebGLStencilTexturingPrototype::Base);

/* Hash table for prototype */

static const std::array<HashTableValue, 2> JSWebGLStencilTexturingPrototypeTableValues {
    HashTableValue { "DEPTH_STENCIL_TEXTURE_MODE_WEBGL"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x90EA } },
    HashTableValue { "STENCIL_INDEX_WEBGL"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x1901 } },
};

const ClassInfo JSWebGLStencilTexturingPrototype::s_info = { "WebGLStencilTexturing"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGLStencilTexturingPrototype) };

void JSWebGLStencilTexturingPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSWebGLStencilTexturing::info(), JSWebGLStencilTexturingPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSWebGLStencilTexturing::s_info = { "WebGLStencilTexturing"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGLStencilTexturing) };

JSWebGLStencilTexturing::JSWebGLStencilTexturing(Structure* structure, JSDOMGlobalObject& globalObject, Ref<WebGLStencilTexturing>&& impl)
    : JSDOMWrapper<WebGLStencilTexturing>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, WebGLStencilTexturing>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSWebGLStencilTexturing::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSWebGLStencilTexturingPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSWebGLStencilTexturingPrototype::create(vm, &globalObject, structure);
}

JSObject* JSWebGLStencilTexturing::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSWebGLStencilTexturing>(vm, globalObject);
}

void JSWebGLStencilTexturing::destroy(JSC::JSCell* cell)
{
    JSWebGLStencilTexturing* thisObject = static_cast<JSWebGLStencilTexturing*>(cell);
    thisObject->JSWebGLStencilTexturing::~JSWebGLStencilTexturing();
}

JSC::GCClient::IsoSubspace* JSWebGLStencilTexturing::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSWebGLStencilTexturing, UseCustomHeapCellType::No>(vm, "JSWebGLStencilTexturing"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForWebGLStencilTexturing.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForWebGLStencilTexturing = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForWebGLStencilTexturing.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForWebGLStencilTexturing = std::forward<decltype(space)>(space); }
    );
}

void JSWebGLStencilTexturing::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSWebGLStencilTexturing*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSWebGLStencilTexturingOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    auto* jsWebGLStencilTexturing = jsCast<JSWebGLStencilTexturing*>(handle.slot()->asCell());
    auto& owner = jsWebGLStencilTexturing->wrapped();
    if (reason) [[unlikely]]
        *reason = "Reachable from jsWebGLStencilTexturing"_s;
    return containsWebCoreOpaqueRoot(visitor, owner);
}

void JSWebGLStencilTexturingOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsWebGLStencilTexturing = static_cast<JSWebGLStencilTexturing*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsWebGLStencilTexturing->protectedWrapped().ptr(), jsWebGLStencilTexturing);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7WebGLStencilTexturing@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore21WebGLStencilTexturingE[]; }
#endif
template<std::same_as<WebGLStencilTexturing> T>
static inline void verifyVTable(WebGLStencilTexturing* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7WebGLStencilTexturing@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore21WebGLStencilTexturingE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // WebGLStencilTexturing has subclasses. If WebGLStencilTexturing has subclasses that get passed
        // to toJS() we currently require WebGLStencilTexturing you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<WebGLStencilTexturing>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<WebGLStencilTexturing>(impl.ptr());
#endif
    return createWrapper<WebGLStencilTexturing>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, WebGLStencilTexturing& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

WebGLStencilTexturing* JSWebGLStencilTexturing::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSWebGLStencilTexturing*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGL)
