/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_AUDIO)

#include "JSAudioParamDescriptor.h"

#include "JSAutomationRate.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertOptional.h"
#include "JSDOMConvertStrings.h"
#include <JavaScriptCore/JSCInlines.h>



namespace WebCore {
using namespace JSC;

#if ENABLE(WEB_AUDIO)

template<> ConversionResult<IDLDictionary<AudioParamDescriptor>> convertDictionary<AudioParamDescriptor>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (!isNullOrUndefined && !object) [[unlikely]] {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    AudioParamDescriptor result;
    JSValue automationRateValue;
    if (isNullOrUndefined)
        automationRateValue = jsUndefined();
    else {
        automationRateValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "automationRate"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto automationRateConversionResult = convertOptionalWithDefault<IDLEnumeration<AutomationRate>>(lexicalGlobalObject, automationRateValue, [&]() -> ConversionResult<IDLEnumeration<AutomationRate>> { return Converter<IDLEnumeration<AutomationRate>>::ReturnType { AutomationRate::ARate }; });
    if (automationRateConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.automationRate = automationRateConversionResult.releaseReturnValue();
    JSValue defaultValueValue;
    if (isNullOrUndefined)
        defaultValueValue = jsUndefined();
    else {
        defaultValueValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "defaultValue"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto defaultValueConversionResult = convertOptionalWithDefault<IDLFloat>(lexicalGlobalObject, defaultValueValue, [&]() -> ConversionResult<IDLFloat> { return Converter<IDLFloat>::ReturnType { 0 }; });
    if (defaultValueConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.defaultValue = defaultValueConversionResult.releaseReturnValue();
    JSValue maxValueValue;
    if (isNullOrUndefined)
        maxValueValue = jsUndefined();
    else {
        maxValueValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "maxValue"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto maxValueConversionResult = convertOptionalWithDefault<IDLFloat>(lexicalGlobalObject, maxValueValue, [&]() -> ConversionResult<IDLFloat> { return Converter<IDLFloat>::ReturnType { 3.4028235e38 }; });
    if (maxValueConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.maxValue = maxValueConversionResult.releaseReturnValue();
    JSValue minValueValue;
    if (isNullOrUndefined)
        minValueValue = jsUndefined();
    else {
        minValueValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "minValue"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto minValueConversionResult = convertOptionalWithDefault<IDLFloat>(lexicalGlobalObject, minValueValue, [&]() -> ConversionResult<IDLFloat> { return Converter<IDLFloat>::ReturnType { -3.4028235e38 }; });
    if (minValueConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.minValue = minValueConversionResult.releaseReturnValue();
    JSValue nameValue;
    if (isNullOrUndefined)
        nameValue = jsUndefined();
    else {
        nameValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "name"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (nameValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "name"_s, "AudioParamDescriptor"_s, "DOMString"_s);
        return ConversionResultException { };
    }
    auto nameConversionResult = convert<IDLDOMString>(lexicalGlobalObject, nameValue);
    if (nameConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.name = nameConversionResult.releaseReturnValue();
    return result;
}

#endif

} // namespace WebCore


#endif // ENABLE(WEB_AUDIO)
