/*
 * Copyright (C) 2022-2023 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1.  Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 * 2.  Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "config.h"
#include "GeneratedSerializers.h"
#include "GeneratedWebKitSecureCoding.h"

#include "APIArray.h"
#include "APIDictionary.h"
#include "APIError.h"
#include "APIFrameHandle.h"
#include "APIGeometry.h"
#include "APINumber.h"
#include "APIObject.h"
#include "APIPageHandle.h"
#include "APIString.h"
#include "APIURL.h"
#include "APIURLRequest.h"
#include "APIURLResponse.h"
#include "APIUserContentURLPattern.h"
#include "AccessibilityPreferences.h"
#include "ArgumentCoders.h"
#if USE(SOUP)
#include "ArgumentCodersGLib.h"
#endif
#if PLATFORM(GTK)
#include "ArgumentCodersGtk.h"
#endif
#if USE(UNIX_DOMAIN_SOCKETS)
#include "ArgumentCodersUnix.h"
#endif
#if ENABLE(GPU_PROCESS) && ENABLE(VIDEO)
#include "AudioTrackPrivateRemoteConfiguration.h"
#endif
#include "AuthenticationChallengeDisposition.h"
#include "AuxiliaryProcessCreationParameters.h"
#if ENABLE(MODEL_PROCESS)
#include "AuxiliaryProcessCreationParameters.h"
#endif
#include "BackgroundFetchChange.h"
#include "BackgroundFetchState.h"
#if ENABLE(GPU_PROCESS)
#include "BufferIdentifierSet.h"
#endif
#include "CacheModel.h"
#include "CallbackID.h"
#include "ContentWorldData.h"
#if ENABLE(CONTEXT_MENUS)
#include "ContextMenuContextData.h"
#endif
#include "CoordinateSystem.h"
#if USE(SKIA)
#include "CoreIPCSkColorSpace.h"
#endif
#if USE(SKIA)
#include "CoreIPCSkData.h"
#endif
#if USE(SKIA)
#include "CoreIPCSkFontStyleSlant.h"
#endif
#if USE(SKIA)
#include "CoreIPCSkString.h"
#endif
#include "DebuggableInfoData.h"
#if PLATFORM(IOS_FAMILY)
#include "DocumentEditingContext.h"
#endif
#include "DragControllerAction.h"
#include "EditingRange.h"
#include "EditorState.h"
#include "FileSystemStorageError.h"
#include "FileSystemSyncAccessHandleInfo.h"
#include "FocusedElementInformation.h"
#include "FormDataReference.h"
#include "FrameInfoData.h"
#include "FrameTreeCreationParameters.h"
#include "FrameTreeNodeData.h"
#include "FullScreenMediaDetails.h"
#if ENABLE(GPU_PROCESS)
#include "GPUProcessConnectionInfo.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "GPUProcessConnectionParameters.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "GPUProcessCreationParameters.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "GPUProcessPreferences.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "GPUProcessSessionParameters.h"
#endif
#if ENABLE(GAMEPAD)
#include "GamepadData.h"
#endif
#include "GoToBackForwardItemParameters.h"
#include "ITPThirdPartyData.h"
#include "ITPThirdPartyDataForSpecificFirstParty.h"
#include "ImageBufferBackendHandle.h"
#include "ImageOptions.h"
#if ENABLE(GPU_PROCESS) && ENABLE(MEDIA_SOURCE)
#include "InitializationSegmentInfo.h"
#endif
#include "InjectUserScriptImmediately.h"
#include "InputMethodState.h"
#include "InspectorExtensionTypes.h"
#include "JavaScriptEvaluationResult.h"
#include "LayerTreeContext.h"
#include "LoadParameters.h"
#if ENABLE(GPU_PROCESS) && ENABLE(MEDIA_SOURCE)
#include "MediaDescriptionInfo.h"
#endif
#if ENABLE(MEDIA_STREAM)
#include "MediaDeviceSandboxExtensions.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "MediaOverridesForTesting.h"
#endif
#include "MediaPlaybackState.h"
#if ENABLE(GPU_PROCESS) && ENABLE(VIDEO)
#include "MediaPlayerPrivateRemote.h"
#endif
#if ENABLE(ARKIT_INLINE_PREVIEW)
#include "ModelIdentifier.h"
#endif
#if ENABLE(MODEL_PROCESS)
#include "ModelProcessConnectionInfo.h"
#endif
#if ENABLE(MODEL_PROCESS)
#include "ModelProcessConnectionParameters.h"
#endif
#if ENABLE(MODEL_PROCESS)
#include "ModelProcessCreationParameters.h"
#endif
#include "MonotonicObjectIdentifier.h"
#include "NavigationActionData.h"
#include "NetworkProcessConnectionInfo.h"
#include "NetworkProcessConnectionParameters.h"
#include "NetworkProcessCreationParameters.h"
#include "NetworkResourceLoadParameters.h"
#include "NetworkSessionCreationParameters.h"
#include "NodeInfo.h"
#include "PlatformFontInfo.h"
#include "PlatformPopupMenuData.h"
#include "PolicyDecision.h"
#if ENABLE(GPU_PROCESS) && PLATFORM(COCOA)
#include "PrepareBackingStoreBuffersData.h"
#endif
#include "PrintInfo.h"
#include "PrivateClickMeasurementManagerInterface.h"
#include "ProvisionalFrameCreationParameters.h"
#if USE(LIBWEBRTC)
#include "RTCNetwork.h"
#endif
#if USE(LIBWEBRTC)
#include "RTCPacketOptions.h"
#endif
#if (USE(LIBWEBRTC)) && (USE(LIBWEBRTC) && PLATFORM(COCOA))
#include "RTCWebKitEncodedFrameInfo.h"
#endif
#if ENABLE(GPU_PROCESS) && USE(AUDIO_SESSION)
#include "RemoteAudioSessionConfiguration.h"
#endif
#if ENABLE(GPU_PROCESS) && ENABLE(ENCRYPTED_MEDIA)
#include "RemoteCDMConfiguration.h"
#endif
#if ENABLE(GPU_PROCESS) && ENABLE(ENCRYPTED_MEDIA)
#include "RemoteCDMInstanceConfiguration.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "RemoteGPURequestAdapterResponse.h"
#endif
#if ENABLE(GPU_PROCESS) && ENABLE(WEBGL)
#include "RemoteGraphicsContextGLInitializationState.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "RemoteImageBufferSetConfiguration.h"
#endif
#if ENABLE(GPU_PROCESS) && PLATFORM(COCOA)
#include "RemoteImageBufferSetIdentifier.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "RemoteMediaPlayerConfiguration.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "RemoteMediaPlayerProxyConfiguration.h"
#endif
#if ENABLE(GPU_PROCESS) && ENABLE(VIDEO)
#include "RemoteMediaPlayerState.h"
#endif
#if ENABLE(GPU_PROCESS) && PLATFORM(IOS_FAMILY)
#include "RemoteMediaSessionHelper.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "RemoteSerializedImageBufferIdentifier.h"
#endif
#if ENABLE(GPU_PROCESS) && ENABLE(VIDEO)
#include "RemoteTrackInfo.h"
#endif
#if ENABLE(GPU_PROCESS) && ENABLE(VIDEO)
#include "RemoteVideoFrameIdentifier.h"
#endif
#if ENABLE(GPU_PROCESS) && ENABLE(VIDEO)
#include "RemoteVideoFrameProxyProperties.h"
#endif
#if ENABLE(TOUCH_EVENTS)
#include "RemoteWebTouchEvent.h"
#endif
#include "RemoteWorkerInitializationData.h"
#include "RemoteWorkerType.h"
#include "RendererBufferFormat.h"
#include "ResourceLoadInfo.h"
#include "ResourceLoadStatisticsParameters.h"
#include "RunJavaScriptParameters.h"
#include "SameDocumentNavigationType.h"
#include "ScriptTrackingPrivacyFilter.h"
#if ENABLE(MOMENTUM_EVENT_DISPATCHER)
#include "ScrollingAccelerationCurve.h"
#endif
#include "SessionState.h"
#include "SharedBufferReference.h"
#include "SharedFileHandle.h"
#include "SharedPreferencesForWebProcess.h"
#if ENABLE(GPU_PROCESS) && PLATFORM(COCOA) && ENABLE(VIDEO)
#include "SharedVideoFrame.h"
#endif
#include "StorageAccessStatus.h"
#include "StreamConnectionEncoder.h"
#include "StreamServerConnection.h"
#include "SyntheticEditingCommandType.h"
#include "TextRecognitionUpdateResult.h"
#if ENABLE(GPU_PROCESS) && ENABLE(VIDEO)
#include "TextTrackPrivateRemoteConfiguration.h"
#endif
#if ENABLE(GPU_PROCESS) && ENABLE(VIDEO)
#include "TrackPrivateRemoteConfiguration.h"
#endif
#include "URLSchemeTaskParameters.h"
#include "UndoOrRedo.h"
#include "UnifiedOriginStorageLevel.h"
#if USE(COORDINATED_GRAPHICS) || USE(TEXTURE_MAPPER)
#include "UpdateInfo.h"
#endif
#include "UserContentControllerParameters.h"
#include "UserData.h"
#include "UserMessage.h"
#if ENABLE(GPU_PROCESS) && ENABLE(VIDEO)
#include "VideoTrackPrivateRemoteConfiguration.h"
#endif
#if ENABLE(UI_SIDE_COMPOSITING)
#include "VisibleContentRectUpdateInfo.h"
#endif
#include "WebBackForwardListCounts.h"
#if ENABLE(CONTENT_EXTENSIONS)
#include "WebCompiledContentRuleListData.h"
#endif
#if ENABLE(CONTEXT_MENUS)
#include "WebContextMenuItemData.h"
#endif
#include "WebEvent.h"
#if ENABLE(WK_WEB_EXTENSIONS)
#include "WebExtension.h"
#endif
#if ENABLE(WK_WEB_EXTENSIONS_SIDEBAR)
#include "WebExtensionActionClickBehavior.h"
#endif
#if ENABLE(WK_WEB_EXTENSIONS)
#include "WebExtensionAlarmParameters.h"
#endif
#if ENABLE(WK_WEB_EXTENSIONS_BOOKMARKS)
#include "WebExtensionBookmarksParameters.h"
#endif
#if ENABLE(WK_WEB_EXTENSIONS)
#include "WebExtensionCommandParameters.h"
#endif
#if ENABLE(WK_WEB_EXTENSIONS)
#include "WebExtensionContentWorldType.h"
#endif
#if ENABLE(WK_WEB_EXTENSIONS)
#include "WebExtensionContext.h"
#endif
#if ENABLE(WK_WEB_EXTENSIONS)
#include "WebExtensionContextParameters.h"
#endif
#if ENABLE(WK_WEB_EXTENSIONS)
#include "WebExtensionControllerParameters.h"
#endif
#if ENABLE(WK_WEB_EXTENSIONS)
#include "WebExtensionCookieParameters.h"
#endif
#if ENABLE(WK_WEB_EXTENSIONS)
#include "WebExtensionDataType.h"
#endif
#if ENABLE(WK_WEB_EXTENSIONS)
#include "WebExtensionEventListenerType.h"
#endif
#if ENABLE(WK_WEB_EXTENSIONS)
#include "WebExtensionFrameParameters.h"
#endif
#if ENABLE(WK_WEB_EXTENSIONS)
#include "WebExtensionMatchedRuleParameters.h"
#endif
#if ENABLE(WK_WEB_EXTENSIONS)
#include "WebExtensionMenuItemContextParameters.h"
#endif
#if ENABLE(WK_WEB_EXTENSIONS)
#include "WebExtensionMenuItemParameters.h"
#endif
#if ENABLE(WK_WEB_EXTENSIONS)
#include "WebExtensionMessageSenderParameters.h"
#endif
#if ENABLE(WK_WEB_EXTENSIONS)
#include "WebExtensionMessageTargetParameters.h"
#endif
#if ENABLE(WK_WEB_EXTENSIONS)
#include "WebExtensionRegisteredScriptParameters.h"
#endif
#if ENABLE(WK_WEB_EXTENSIONS)
#include "WebExtensionScriptInjectionParameters.h"
#endif
#if ENABLE(WK_WEB_EXTENSIONS)
#include "WebExtensionScriptInjectionResultParameters.h"
#endif
#if ENABLE(WK_WEB_EXTENSIONS_SIDEBAR)
#include "WebExtensionSidebarParameters.h"
#endif
#if ENABLE(WK_WEB_EXTENSIONS)
#include "WebExtensionStorageAccessLevel.h"
#endif
#if ENABLE(WK_WEB_EXTENSIONS)
#include "WebExtensionTab.h"
#endif
#if ENABLE(WK_WEB_EXTENSIONS)
#include "WebExtensionTabParameters.h"
#endif
#if ENABLE(WK_WEB_EXTENSIONS)
#include "WebExtensionTabQueryParameters.h"
#endif
#if ENABLE(WK_WEB_EXTENSIONS)
#include "WebExtensionWindow.h"
#endif
#if ENABLE(WK_WEB_EXTENSIONS)
#include "WebExtensionWindowParameters.h"
#endif
#include "WebFindOptions.h"
#include "WebFoundTextRange.h"
#include "WebFrameMetrics.h"
#if ENABLE(GPU_PROCESS)
#include "WebGPUBindGroupDescriptor.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUBindGroupEntry.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUBindGroupLayoutDescriptor.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUBindGroupLayoutEntry.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUBlendComponent.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUBlendState.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUBufferBinding.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUBufferBindingLayout.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUBufferDescriptor.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUCanvasConfiguration.h"
#endif
#include "WebGPUColor.h"
#if ENABLE(GPU_PROCESS)
#include "WebGPUColorTargetState.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUCommandBufferDescriptor.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUCommandEncoderDescriptor.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUCompilationMessage.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUComputePassDescriptor.h"
#endif
#include "WebGPUComputePassTimestampWrites.h"
#if ENABLE(GPU_PROCESS)
#include "WebGPUComputePipelineDescriptor.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUDepthStencilState.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUDeviceDescriptor.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUError.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUExtent3D.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUExternalTextureBindingLayout.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUExternalTextureDescriptor.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUFragmentState.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUImageCopyBuffer.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUImageCopyExternalImage.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUImageCopyTexture.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUImageCopyTextureTagged.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUImageDataLayout.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUInternalError.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUMultisampleState.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUObjectDescriptorBase.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUOrigin2D.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUOrigin3D.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUOutOfMemoryError.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUPipelineDescriptorBase.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUPipelineLayoutDescriptor.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUPresentationContextDescriptor.h"
#endif
#include "WebGPUPrimitiveState.h"
#if ENABLE(GPU_PROCESS)
#include "WebGPUPrimitiveState.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUProgrammableStage.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUQuerySetDescriptor.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPURenderBundleDescriptor.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPURenderBundleEncoderDescriptor.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPURenderPassColorAttachment.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPURenderPassDepthStencilAttachment.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPURenderPassDescriptor.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPURenderPassLayout.h"
#endif
#include "WebGPURenderPassTimestampWrites.h"
#if ENABLE(GPU_PROCESS)
#include "WebGPURenderPipelineDescriptor.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPURequestAdapterOptions.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUSamplerBindingLayout.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUSamplerDescriptor.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUShaderModuleCompilationHint.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUShaderModuleDescriptor.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUStencilFaceState.h"
#endif
#include "WebGPUStorageTextureBindingLayout.h"
#if ENABLE(GPU_PROCESS)
#include "WebGPUStorageTextureBindingLayout.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUSupportedFeatures.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUSupportedLimits.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUTextureBindingLayout.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUTextureDescriptor.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUTextureViewDescriptor.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUValidationError.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUVertexAttribute.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUVertexBufferLayout.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUVertexState.h"
#endif
#if ENABLE(MAC_GESTURE_EVENTS)
#include "WebGestureEvent.h"
#endif
#include "WebHitTestResultData.h"
#include "WebIDBResult.h"
#include "WebImage.h"
#include "WebKeyboardEvent.h"
#include "WebMouseEvent.h"
#include "WebNavigationDataStore.h"
#include "WebPageCreationParameters.h"
#include "WebPageGroupData.h"
#include "WebPageNetworkParameters.h"
#include "WebPopupItem.h"
#include "WebPreferencesStore.h"
#include "WebProcessCreationParameters.h"
#include "WebProcessDataStoreParameters.h"
#if ENABLE(SPEECH_SYNTHESIS)
#include "WebSpeechSynthesisVoice.h"
#endif
#if ENABLE(TOUCH_EVENTS)
#include "WebTouchEvent.h"
#endif
#include "WebUserContentControllerDataTypes.h"
#include "WebWheelEvent.h"
#include "WebsiteAutoplayPolicy.h"
#include "WebsiteAutoplayQuirk.h"
#include "WebsiteData.h"
#include "WebsiteDataFetchOption.h"
#include "WebsiteDataStoreParameters.h"
#include "WebsiteDataType.h"
#include "WebsitePoliciesData.h"
#include "WebsitePopUpPolicy.h"
#include "WebsitePushAndNotificationsEnabledPolicy.h"
#if ENABLE(WEBXR)
#include "XRDeviceInfo.h"
#endif
#if (ENABLE(WEBXR)) && (USE(OPENXR))
#include "XRDeviceLayer.h"
#endif
#include <JavaScriptCore/ArrayBuffer.h>
#include <JavaScriptCore/ConsoleTypes.h>
#include <JavaScriptCore/InspectorFrontendChannel.h>
#include <JavaScriptCore/InspectorTarget.h>
#include <JavaScriptCore/SourceTaintedOrigin.h>
#include <JavaScriptCore/WasmModule.h>
#if USE(SYSTEM_PREVIEW)
#include <WebCore/ARKitBadgeSystemImage.h>
#endif
#include <WebCore/AXObjectCache.h>
#if ENABLE(THREADED_ANIMATION_RESOLUTION)
#include <WebCore/AcceleratedEffect.h>
#endif
#if ENABLE(THREADED_ANIMATION_RESOLUTION)
#include <WebCore/AcceleratedEffectValues.h>
#endif
#include <WebCore/AffineTransform.h>
#if ENABLE(WEB_AUTHN)
#include <WebCore/AllAcceptedCredentialsOptions.h>
#endif
#include <WebCore/Allowlist.h>
#if ENABLE(THREADED_ANIMATION_RESOLUTION)
#include <WebCore/AnimationEffectTiming.h>
#endif
#if ENABLE(APP_HIGHLIGHTS)
#include <WebCore/AppHighlight.h>
#endif
#if USE(APPKIT)
#include <WebCore/AppKitControlSystemImage.h>
#endif
#if ENABLE(APPLE_PAY_AMS_UI) && ENABLE(PAYMENT_REQUEST)
#include <WebCore/ApplePayAMSUIRequest.h>
#endif
#if ENABLE(APPLE_PAY_AUTOMATIC_RELOAD_PAYMENTS)
#include <WebCore/ApplePayAutomaticReloadPaymentRequest.h>
#endif
#if ENABLE(APPLE_PAY)
#include <WebCore/ApplePayButtonPart.h>
#endif
#if ENABLE(APPLE_PAY)
#include <WebCore/ApplePayContactField.h>
#endif
#if ENABLE(APPLE_PAY_COUPON_CODE)
#include <WebCore/ApplePayCouponCodeUpdate.h>
#endif
#if ENABLE(APPLE_PAY_SHIPPING_METHOD_DATE_COMPONENTS_RANGE)
#include <WebCore/ApplePayDateComponents.h>
#endif
#if ENABLE(APPLE_PAY_SHIPPING_METHOD_DATE_COMPONENTS_RANGE)
#include <WebCore/ApplePayDateComponentsRange.h>
#endif
#if ENABLE(APPLE_PAY_DEFERRED_PAYMENTS)
#include <WebCore/ApplePayDeferredPaymentRequest.h>
#endif
#if ENABLE(APPLE_PAY)
#include <WebCore/ApplePayDetailsUpdateBase.h>
#endif
#if ENABLE(APPLE_PAY_DISBURSEMENTS)
#include <WebCore/ApplePayDisbursementRequest.h>
#endif
#if ENABLE(APPLE_PAY)
#include <WebCore/ApplePayError.h>
#endif
#if ENABLE(APPLE_PAY)
#include <WebCore/ApplePayFeature.h>
#endif
#if ENABLE(APPLE_PAY_INSTALLMENTS)
#include <WebCore/ApplePayInstallmentConfigurationWebCore.h>
#endif
#if ENABLE(APPLE_PAY_INSTALLMENTS)
#include <WebCore/ApplePayInstallmentItem.h>
#endif
#if ENABLE(APPLE_PAY)
#include <WebCore/ApplePayLineItem.h>
#endif
#if ENABLE(APPLE_PAY)
#include <WebCore/ApplePayLogoSystemImage.h>
#endif
#if ENABLE(APPLE_PAY)
#include <WebCore/ApplePayPaymentAuthorizationResult.h>
#endif
#if ENABLE(APPLE_PAY)
#include <WebCore/ApplePayPaymentMethodUpdate.h>
#endif
#if ENABLE(APPLE_PAY_PAYMENT_ORDER_DETAILS)
#include <WebCore/ApplePayPaymentOrderDetails.h>
#endif
#if ENABLE(APPLE_PAY_MULTI_MERCHANT_PAYMENTS)
#include <WebCore/ApplePayPaymentTokenContext.h>
#endif
#if ENABLE(APPLE_PAY_RECURRING_PAYMENTS)
#include <WebCore/ApplePayRecurringPaymentRequest.h>
#endif
#if ENABLE(APPLE_PAY)
#include <WebCore/ApplePaySetupConfiguration.h>
#endif
#if ENABLE(APPLE_PAY)
#include <WebCore/ApplePayShippingContactUpdate.h>
#endif
#if ENABLE(APPLE_PAY)
#include <WebCore/ApplePayShippingMethod.h>
#endif
#if ENABLE(APPLE_PAY)
#include <WebCore/ApplePayShippingMethodUpdate.h>
#endif
#if HAVE(CORE_MATERIAL)
#include <WebCore/AppleVisualEffect.h>
#endif
#if ENABLE(APPLICATION_MANIFEST)
#include <WebCore/ApplicationManifest.h>
#endif
#if PLATFORM(COCOA)
#include <WebCore/ArchiveResource.h>
#endif
#if ENABLE(ATTACHMENT_ELEMENT)
#include <WebCore/AttachmentAssociatedElement.h>
#endif
#include <WebCore/AttributionSecondsUntilSendData.h>
#include <WebCore/AudioConfiguration.h>
#include <WebCore/AudioIOCallback.h>
#if USE(AUDIO_SESSION)
#include <WebCore/AudioSession.h>
#endif
#if ENABLE(VIDEO)
#include <WebCore/AudioTrackPrivate.h>
#endif
#include <WebCore/AuthenticationChallenge.h>
#if ENABLE(WEB_AUTHN)
#include <WebCore/AuthenticationExtensionsClientInputs.h>
#endif
#if ENABLE(WEB_AUTHN)
#include <WebCore/AuthenticationExtensionsClientOutputs.h>
#endif
#if ENABLE(WEB_AUTHN)
#include <WebCore/AuthenticatorResponseData.h>
#endif
#if ENABLE(WEB_AUTHN)
#include <WebCore/AuthenticatorSelectionCriteria.h>
#endif
#include <WebCore/AutocapitalizeTypes.h>
#include <WebCore/Autofill.h>
#include <WebCore/AutoplayEvent.h>
#include <WebCore/BackgroundFetchFailureReason.h>
#include <WebCore/BackgroundFetchInformation.h>
#include <WebCore/BackgroundFetchOptions.h>
#include <WebCore/BackgroundFetchRecordInformation.h>
#include <WebCore/BackgroundFetchRequest.h>
#include <WebCore/BackgroundFetchResult.h>
#if ENABLE(GPU_PROCESS)
#include <WebCore/BarcodeDetectorOptionsInterface.h>
#endif
#if ENABLE(GPU_PROCESS)
#include <WebCore/BarcodeFormatInterface.h>
#endif
#include <WebCore/BlobPart.h>
#include <WebCore/BufferSource.h>
#include <WebCore/ButtonPart.h>
#include <WebCore/ByteArrayPixelBuffer.h>
#if PLATFORM(COCOA)
#include <WebCore/CAAudioStreamDescription.h>
#endif
#if ENABLE(ENCRYPTED_MEDIA)
#include <WebCore/CDMInstance.h>
#endif
#if ENABLE(ENCRYPTED_MEDIA)
#include <WebCore/CDMInstanceSession.h>
#endif
#if ENABLE(ENCRYPTED_MEDIA)
#include <WebCore/CDMKeySystemConfiguration.h>
#endif
#if ENABLE(ENCRYPTED_MEDIA)
#include <WebCore/CDMMediaCapability.h>
#endif
#if ENABLE(GPU_PROCESS) && ENABLE(ENCRYPTED_MEDIA)
#include <WebCore/CDMPrivate.h>
#endif
#if ENABLE(ENCRYPTED_MEDIA)
#include <WebCore/CDMRestrictions.h>
#endif
#include <WebCore/COEPInheritenceViolationReportBody.h>
#include <WebCore/CORPViolationReportBody.h>
#include <WebCore/CSPViolationReportBody.h>
#include <WebCore/CSSFilter.h>
#include <WebCore/CSSValueKey.h>
#include <WebCore/CacheQueryOptions.h>
#include <WebCore/CanvasActivityRecord.h>
#if ENABLE(VIDEO)
#include <WebCore/CaptionUserPreferences.h>
#endif
#if ENABLE(MEDIA_STREAM)
#include <WebCore/CaptureDevice.h>
#endif
#if ENABLE(MEDIA_STREAM)
#include <WebCore/CaptureDeviceWithCapabilities.h>
#endif
#if PLATFORM(MAC)
#include <WebCore/CaretAnimator.h>
#endif
#include <WebCore/CertificateInfo.h>
#include <WebCore/CharacterRange.h>
#include <WebCore/ClientOrigin.h>
#include <WebCore/Color.h>
#include <WebCore/ColorInterpolationMethod.h>
#include <WebCore/ColorTypes.h>
#include <WebCore/ColorWellPart.h>
#include <WebCore/CompositionHighlight.h>
#include <WebCore/CompositionUnderline.h>
#include <WebCore/ContactInfo.h>
#include <WebCore/ContactsRequestData.h>
#if ENABLE(CONTENT_EXTENSIONS)
#include <WebCore/ContentRuleListResults.h>
#endif
#include <WebCore/ContentSecurityPolicy.h>
#include <WebCore/ContentSecurityPolicyResponseHeaders.h>
#include <WebCore/ContentType.h>
#if ENABLE(CONTEXT_MENUS)
#include <WebCore/ContextMenuContext.h>
#endif
#include <WebCore/ContextMenuItem.h>
#include <WebCore/ControlPart.h>
#include <WebCore/ControlStyle.h>
#include <WebCore/Cookie.h>
#include <WebCore/CookieChangeSubscription.h>
#include <WebCore/CookieConsentDecisionResult.h>
#include <WebCore/CookieRequestHeaderFieldProxy.h>
#include <WebCore/CookieStoreGetOptions.h>
#include <WebCore/Credential.h>
#if PLATFORM(COCOA)
#include <WebCore/Credential.h>
#endif
#if USE(CURL)
#include <WebCore/Credential.h>
#endif
#if USE(SOUP)
#include <WebCore/Credential.h>
#endif
#if ENABLE(WEB_AUTHN)
#include <WebCore/CredentialPropertiesOutput.h>
#endif
#include <WebCore/CrossOriginAccessControl.h>
#include <WebCore/CrossOriginEmbedderPolicy.h>
#include <WebCore/CrossOriginOpenerPolicy.h>
#include <WebCore/CrossSiteNavigationDataTransfer.h>
#include <WebCore/CryptoKeyData.h>
#if ENABLE(WEB_AUTHN)
#include <WebCore/CurrentUserDetailsOptions.h>
#endif
#include <WebCore/Cursor.h>
#include <WebCore/CustomHeaderFields.h>
#if USE(GBM)
#include <WebCore/DMABufBuffer.h>
#endif
#if ENABLE(DOM_AUDIO_SESSION)
#include <WebCore/DOMAudioSession.h>
#endif
#include <WebCore/DOMCacheEngine.h>
#include <WebCore/DOMPasteAccess.h>
#if USE(GBM)
#include <WebCore/DRMDevice.h>
#endif
#if ENABLE(DATA_DETECTION)
#include <WebCore/DataDetectorElementInfo.h>
#endif
#if ENABLE(DATA_DETECTION)
#include <WebCore/DataDetectorType.h>
#endif
#include <WebCore/DataListSuggestionInformation.h>
#include <WebCore/DatabaseDetails.h>
#include <WebCore/DateTimeChooserParameters.h>
#include <WebCore/DeprecationReportBody.h>
#include <WebCore/DestinationColorSpace.h>
#if ENABLE(WEB_RTC)
#include <WebCore/DetachedRTCDataChannel.h>
#endif
#if ENABLE(GPU_PROCESS)
#include <WebCore/DetectedBarcodeInterface.h>
#endif
#if ENABLE(GPU_PROCESS)
#include <WebCore/DetectedFaceInterface.h>
#endif
#if ENABLE(GPU_PROCESS)
#include <WebCore/DetectedTextInterface.h>
#endif
#include <WebCore/DeviceOrientationOrMotionPermissionState.h>
#include <WebCore/DiagnosticLoggingClient.h>
#include <WebCore/DiagnosticLoggingDomain.h>
#include <WebCore/DictationAlternative.h>
#include <WebCore/DictionaryPopupInfo.h>
#if (ENABLE(WEB_AUTHN)) && (HAVE(DIGITAL_CREDENTIALS_UI))
#include <WebCore/DigitalCredentialsRequestData.h>
#endif
#if (ENABLE(WEB_AUTHN)) && (HAVE(DIGITAL_CREDENTIALS_UI))
#include <WebCore/DigitalCredentialsResponseData.h>
#endif
#if HAVE(SCREEN_CAPTURE_KIT)
#include <WebCore/DisplayCapturePromptType.h>
#endif
#include <WebCore/DisplayListItems.h>
#include <WebCore/DisplayUpdate.h>
#include <WebCore/DistantLightSource.h>
#include <WebCore/DocumentClasses.h>
#include <WebCore/DocumentLoader.h>
#include <WebCore/DocumentStorageAccess.h>
#include <WebCore/DocumentSyncData.h>
#include <WebCore/DragData.h>
#if ENABLE(DRAG_SUPPORT)
#include <WebCore/DragData.h>
#endif
#include <WebCore/DragImage.h>
#include <WebCore/DragItem.h>
#if ENABLE(RE_DYNAMIC_CONTENT_SCALING)
#include <WebCore/DynamicContentScalingDisplayList.h>
#endif
#include <WebCore/ElementAnimationContext.h>
#include <WebCore/ElementContext.h>
#include <WebCore/ElementTargetingTypes.h>
#include <WebCore/EventInit.h>
#include <WebCore/EventRegion.h>
#include <WebCore/EventTrackingRegions.h>
#include <WebCore/Exception.h>
#include <WebCore/ExceptionData.h>
#include <WebCore/ExceptionDetails.h>
#include <WebCore/FEBlend.h>
#include <WebCore/FEColorMatrix.h>
#include <WebCore/FEComponentTransfer.h>
#include <WebCore/FEComposite.h>
#include <WebCore/FEConvolveMatrix.h>
#include <WebCore/FEDiffuseLighting.h>
#include <WebCore/FEDisplacementMap.h>
#include <WebCore/FEDropShadow.h>
#include <WebCore/FEFlood.h>
#include <WebCore/FEGaussianBlur.h>
#include <WebCore/FEImage.h>
#include <WebCore/FEMerge.h>
#include <WebCore/FEMorphology.h>
#include <WebCore/FEOffset.h>
#include <WebCore/FESpecularLighting.h>
#include <WebCore/FETile.h>
#include <WebCore/FETurbulence.h>
#if ENABLE(GPU_PROCESS)
#include <WebCore/FaceDetectorOptionsInterface.h>
#endif
#include <WebCore/FetchOptions.h>
#include <WebCore/FileChooser.h>
#include <WebCore/FileSystemWriteCommandType.h>
#if ENABLE(MEDIA_STREAM)
#include <WebCore/FillLightMode.h>
#endif
#include <WebCore/Filter.h>
#include <WebCore/FilterEffect.h>
#include <WebCore/FilterEffectGeometry.h>
#include <WebCore/FilterFunction.h>
#include <WebCore/FilterOperation.h>
#if !USE(COORDINATED_GRAPHICS)
#include <WebCore/FilterOperation.h>
#endif
#if !USE(COORDINATED_GRAPHICS)
#include <WebCore/FilterOperations.h>
#endif
#include <WebCore/FilterRenderingMode.h>
#include <WebCore/FixedContainerEdges.h>
#include <WebCore/FloatLine.h>
#include <WebCore/FloatPoint.h>
#include <WebCore/FloatPoint3D.h>
#include <WebCore/FloatQuad.h>
#include <WebCore/FloatRect.h>
#include <WebCore/FloatRoundedRect.h>
#include <WebCore/FloatSegment.h>
#include <WebCore/FloatSize.h>
#include <WebCore/FocusController.h>
#include <WebCore/FocusDirection.h>
#include <WebCore/FocusEventData.h>
#include <WebCore/Font.h>
#include <WebCore/FontAttributeChanges.h>
#include <WebCore/FontAttributes.h>
#include <WebCore/FontCache.h>
#include <WebCore/FontCustomPlatformData.h>
#include <WebCore/FontPlatformData.h>
#if USE(SKIA)
#include <WebCore/FontPlatformData.h>
#endif
#include <WebCore/FontSelectionAlgorithm.h>
#include <WebCore/FontShadow.h>
#include <WebCore/FontTaggedSettings.h>
#include <WebCore/FormData.h>
#include <WebCore/FourCC.h>
#include <WebCore/FrameTreeSyncData.h>
#if ENABLE(GAMEPAD)
#include <WebCore/GamepadEffectParameters.h>
#endif
#if ENABLE(GAMEPAD)
#include <WebCore/GamepadHapticEffectType.h>
#endif
#include <WebCore/GeolocationPositionData.h>
#include <WebCore/GlobalFrameIdentifier.h>
#include <WebCore/GlobalWindowIdentifier.h>
#include <WebCore/Gradient.h>
#include <WebCore/GradientColorStop.h>
#include <WebCore/GradientColorStops.h>
#if (!PLATFORM(COCOA) && ENABLE(WEBGL)) && ((PLATFORM(GTK) || PLATFORM(WPE)))
#include <WebCore/GraphicsContextGL.h>
#endif
#if ENABLE(WEBGL)
#include <WebCore/GraphicsContextGL.h>
#endif
#if PLATFORM(COCOA) && ENABLE(GPU_PROCESS) && ENABLE(WEBGL)
#include <WebCore/GraphicsContextGL.h>
#endif
#if ENABLE(GPU_PROCESS) && ENABLE(WEBGL)
#include <WebCore/GraphicsContextGLActiveInfo.h>
#endif
#if ENABLE(GPU_PROCESS) && ENABLE(WEBGL)
#include <WebCore/GraphicsContextGLAttributes.h>
#endif
#include <WebCore/GraphicsStyle.h>
#include <WebCore/GraphicsTypes.h>
#include <WebCore/GraphicsTypesGL.h>
#include <WebCore/HTMLModelElementCamera.h>
#include <WebCore/HTTPCookieAcceptPolicy.h>
#include <WebCore/HTTPHeaderField.h>
#include <WebCore/HTTPHeaderMap.h>
#include <WebCore/HostingContext.h>
#include <WebCore/IDBCursorInfo.h>
#include <WebCore/IDBCursorRecord.h>
#include <WebCore/IDBDatabaseIdentifier.h>
#include <WebCore/IDBDatabaseInfo.h>
#include <WebCore/IDBDatabaseNameAndVersion.h>
#include <WebCore/IDBError.h>
#include <WebCore/IDBGetAllRecordsData.h>
#include <WebCore/IDBGetAllResult.h>
#include <WebCore/IDBGetRecordData.h>
#include <WebCore/IDBGetResult.h>
#include <WebCore/IDBIndexInfo.h>
#include <WebCore/IDBIterateCursorData.h>
#include <WebCore/IDBKeyData.h>
#include <WebCore/IDBKeyRangeData.h>
#include <WebCore/IDBObjectStoreInfo.h>
#include <WebCore/IDBOpenRequestData.h>
#include <WebCore/IDBRequestData.h>
#include <WebCore/IDBResourceIdentifier.h>
#include <WebCore/IDBResultData.h>
#include <WebCore/IDBTransactionInfo.h>
#include <WebCore/IDBValue.h>
#if (ENABLE(WEB_AUTHN)) && (HAVE(DIGITAL_CREDENTIALS_UI))
#include <WebCore/ISO18013.h>
#endif
#include <WebCore/ISOVTTCue.h>
#include <WebCore/IdentityTransformOperation.h>
#include <WebCore/Image.h>
#include <WebCore/ImageBitmap.h>
#include <WebCore/ImageBuffer.h>
#include <WebCore/ImageBufferFormat.h>
#include <WebCore/ImageBufferResourceLimits.h>
#if ENABLE(SERVICE_CONTROLS)
#include <WebCore/ImageControlsButtonPart.h>
#endif
#include <WebCore/ImageDecoder.h>
#include <WebCore/ImageOrientation.h>
#include <WebCore/ImagePaintingOptions.h>
#include <WebCore/ImageResource.h>
#include <WebCore/ImageTypes.h>
#if PLATFORM(COCOA)
#include <WebCore/ImageUtilities.h>
#endif
#if ENABLE(VIDEO)
#include <WebCore/InbandGenericCue.h>
#endif
#include <WebCore/IndexKey.h>
#include <WebCore/InnerSpinButtonPart.h>
#include <WebCore/InspectorBackendClient.h>
#include <WebCore/InspectorFrontendClient.h>
#if ENABLE(INSPECTOR_EXTENSIONS)
#include <WebCore/InspectorFrontendClient.h>
#endif
#if PLATFORM(IOS_FAMILY)
#include <WebCore/InspectorOverlay.h>
#endif
#if PLATFORM(IOS_FAMILY)
#include <WebCore/InspectorOverlayLabel.h>
#endif
#include <WebCore/IntPoint.h>
#include <WebCore/IntRect.h>
#include <WebCore/IntSize.h>
#include <WebCore/InteractionRegion.h>
#include <WebCore/IsLoggedIn.h>
#include <WebCore/JsonWebKey.h>
#include <WebCore/KeyboardScroll.h>
#if PLATFORM(COCOA)
#include <WebCore/KeypressCommand.h>
#endif
#if ENABLE(GPU_PROCESS)
#include <WebCore/LandmarkInterface.h>
#endif
#if ENABLE(GPU_PROCESS)
#include <WebCore/LandmarkTypeInterface.h>
#endif
#include <WebCore/LayerTreeAsTextOptions.h>
#include <WebCore/LayoutPoint.h>
#include <WebCore/LayoutRect.h>
#include <WebCore/LayoutSize.h>
#include <WebCore/LayoutUnit.h>
#if PLATFORM(COCOA)
#include <WebCore/LegacyWebArchive.h>
#endif
#include <WebCore/Length.h>
#include <WebCore/LengthPoint.h>
#include <WebCore/LengthSize.h>
#include <WebCore/LightSource.h>
#include <WebCore/LinkDecorationFilteringData.h>
#include <WebCore/LinkIcon.h>
#include <WebCore/LoadSchedulingMode.h>
#include <WebCore/LocalFrameLoaderClient.h>
#include <WebCore/LoginStatus.h>
#include <WebCore/MDNSRegisterError.h>
#include <WebCore/MarkupExclusionRule.h>
#include <WebCore/Matrix3DTransformOperation.h>
#include <WebCore/MatrixTransformOperation.h>
#include <WebCore/MediaCapabilitiesDecodingInfo.h>
#include <WebCore/MediaCapabilitiesEncodingInfo.h>
#include <WebCore/MediaCapabilitiesInfo.h>
#include <WebCore/MediaConfiguration.h>
#if ENABLE(MEDIA_STREAM)
#include <WebCore/MediaConstraints.h>
#endif
#if ENABLE(MEDIA_CONTROLS_CONTEXT_MENUS) && USE(UICONTEXTMENU)
#include <WebCore/MediaControlsContextMenuItem.h>
#endif
#include <WebCore/MediaDecodingConfiguration.h>
#include <WebCore/MediaDeviceHashSalts.h>
#include <WebCore/MediaEncodingConfiguration.h>
#if ENABLE(VIDEO)
#include <WebCore/MediaPlayer.h>
#endif
#if ENABLE(MEDIA_SESSION)
#include <WebCore/MediaPositionState.h>
#endif
#include <WebCore/MediaProducer.h>
#include <WebCore/MediaSample.h>
#include <WebCore/MediaSelectionOption.h>
#if ENABLE(MEDIA_SESSION)
#include <WebCore/MediaSessionAction.h>
#endif
#if ENABLE(MEDIA_SESSION_COORDINATOR)
#include <WebCore/MediaSessionCoordinatorState.h>
#endif
#if ENABLE(MEDIA_SESSION)
#include <WebCore/MediaSessionPlaybackState.h>
#endif
#if ENABLE(MEDIA_SESSION_COORDINATOR)
#include <WebCore/MediaSessionReadyState.h>
#endif
#if ENABLE(MEDIA_STREAM)
#include <WebCore/MediaSettingsRange.h>
#endif
#if ENABLE(MEDIA_SOURCE)
#include <WebCore/MediaSourceConfiguration.h>
#endif
#if ENABLE(MEDIA_SOURCE)
#include <WebCore/MediaSourcePrivate.h>
#endif
#include <WebCore/MediaStreamRequest.h>
#if ! ENABLE(MEDIA_STREAM)
#include <WebCore/MediaStreamRequest.h>
#endif
#if ENABLE(MEDIA_STREAM)
#include <WebCore/MediaStreamRequest.h>
#endif
#include <WebCore/MediaUsageInfo.h>
#if ENABLE(WEB_AUTHN)
#include <WebCore/MediationRequirement.h>
#endif
#include <WebCore/MenuListButtonPart.h>
#include <WebCore/MenuListPart.h>
#include <WebCore/MessageForTesting.h>
#include <WebCore/MessagePort.h>
#include <WebCore/MessagePortIdentifier.h>
#include <WebCore/MessageWithMessagePorts.h>
#include <WebCore/MeterPart.h>
#if ENABLE(MEDIA_STREAM)
#include <WebCore/MeteringMode.h>
#endif
#if (ENABLE(WEB_AUTHN)) && (HAVE(DIGITAL_CREDENTIALS_UI))
#include <WebCore/MobileDocumentRequest.h>
#endif
#if ENABLE(CONTENT_FILTERING)
#include <WebCore/MockContentFilterSettings.h>
#endif
#if ENABLE(MEDIA_STREAM)
#include <WebCore/MockMediaDevice.h>
#endif
#if ENABLE(WEB_AUTHN)
#include <WebCore/MockWebAuthenticationConfiguration.h>
#endif
#include <WebCore/ModalContainerTypes.h>
#include <WebCore/Model.h>
#if ENABLE(MODEL_PROCESS)
#include <WebCore/ModelContext.h>
#endif
#include <WebCore/ModelPlayerAnimationState.h>
#include <WebCore/MotionPath.h>
#include <WebCore/NavigationPreloadState.h>
#include <WebCore/NavigationRequester.h>
#include <WebCore/NavigationScheduler.h>
#include <WebCore/NetworkLoadInformation.h>
#include <WebCore/NetworkLoadMetrics.h>
#include <WebCore/NotificationData.h>
#include <WebCore/NotificationOptionsPayload.h>
#include <WebCore/NotificationPayload.h>
#include <WebCore/NotificationResources.h>
#include <WebCore/NowPlayingInfo.h>
#include <WebCore/OffscreenCanvas.h>
#if (ENABLE(WEB_AUTHN)) && (HAVE(DIGITAL_CREDENTIALS_UI))
#include <WebCore/OpenID4VPRequest.h>
#endif
#include <WebCore/OrganizationStorageAccessPromptQuirk.h>
#include <WebCore/OwnerPermissionsPolicyData.h>
#include <WebCore/Pagination.h>
#include <WebCore/Pasteboard.h>
#include <WebCore/PasteboardCustomData.h>
#include <WebCore/PasteboardItemInfo.h>
#include <WebCore/Path.h>
#include <WebCore/PathOperation.h>
#include <WebCore/PathSegment.h>
#include <WebCore/PathSegmentData.h>
#include <WebCore/Pattern.h>
#if ENABLE(APPLE_PAY_INSTALLMENTS)
#include <WebCore/PaymentInstallmentConfigurationWebCore.h>
#endif
#include <WebCore/PermissionDescriptor.h>
#include <WebCore/PermissionQuerySource.h>
#include <WebCore/PermissionState.h>
#include <WebCore/PermissionsPolicy.h>
#include <WebCore/PerspectiveTransformOperation.h>
#if ENABLE(MEDIA_STREAM)
#include <WebCore/PhotoCapabilities.h>
#endif
#if ENABLE(MEDIA_STREAM)
#include <WebCore/PhotoSettings.h>
#endif
#include <WebCore/PixelBuffer.h>
#include <WebCore/PixelBufferFormat.h>
#if ENABLE(VIDEO)
#include <WebCore/PlatformAudioTrackConfiguration.h>
#endif
#if (!(USE(CG))) && (!(USE(SKIA)))
#include <WebCore/PlatformColorSpace.h>
#endif
#include <WebCore/PlatformDynamicRangeLimit.h>
#include <WebCore/PlatformMediaSession.h>
#if ENABLE(VIDEO)
#include <WebCore/PlatformTextTrack.h>
#endif
#include <WebCore/PlatformTimeRanges.h>
#if ENABLE(VIDEO)
#include <WebCore/PlatformTrackConfiguration.h>
#endif
#include <WebCore/PlatformVideoColorSpace.h>
#if ENABLE(VIDEO)
#include <WebCore/PlatformVideoTrackConfiguration.h>
#endif
#include <WebCore/PlatformWheelEvent.h>
#if (ENABLE(WEBXR)) && (USE(OPENXR))
#include <WebCore/PlatformXR.h>
#endif
#if ENABLE(WEBXR)
#include <WebCore/PlatformXR.h>
#endif
#include <WebCore/PluginData.h>
#include <WebCore/PointLightSource.h>
#include <WebCore/PolicyContainer.h>
#include <WebCore/PredefinedColorSpace.h>
#include <WebCore/PrewarmInformation.h>
#include <WebCore/PrivateClickMeasurement.h>
#include <WebCore/ProcessIdentity.h>
#include <WebCore/ProcessQualified.h>
#include <WebCore/ProcessSwapDisposition.h>
#include <WebCore/ProcessSyncData.h>
#include <WebCore/ProgressBarPart.h>
#include <WebCore/PromisedAttachmentInfo.h>
#include <WebCore/ProtectionSpace.h>
#include <WebCore/ProtectionSpaceBase.h>
#include <WebCore/PublicKeyCredentialCreationOptions.h>
#if ENABLE(WEB_AUTHN)
#include <WebCore/PublicKeyCredentialDescriptor.h>
#endif
#if ENABLE(WEB_AUTHN)
#include <WebCore/PublicKeyCredentialEntity.h>
#endif
#include <WebCore/PublicKeyCredentialRequestOptions.h>
#if ENABLE(WEB_AUTHN)
#include <WebCore/PublicKeyCredentialRpEntity.h>
#endif
#if ENABLE(WEB_AUTHN)
#include <WebCore/PublicKeyCredentialUserEntity.h>
#endif
#include <WebCore/PublicSuffix.h>
#include <WebCore/PushPermissionState.h>
#include <WebCore/PushSubscriptionData.h>
#if ENABLE(WEB_RTC)
#include <WebCore/RTCDataChannelHandler.h>
#endif
#include <WebCore/RTCErrorDetailType.h>
#if ENABLE(MEDIA_STREAM)
#include <WebCore/RealtimeMediaSource.h>
#endif
#if ENABLE(MEDIA_STREAM)
#include <WebCore/RealtimeMediaSourceCapabilities.h>
#endif
#if ENABLE(MEDIA_STREAM)
#include <WebCore/RealtimeMediaSourceCenter.h>
#endif
#if ENABLE(MEDIA_STREAM)
#include <WebCore/RealtimeMediaSourceSettings.h>
#endif
#if ENABLE(MEDIA_STREAM)
#include <WebCore/RealtimeMediaSourceSupportedConstraints.h>
#endif
#include <WebCore/RectEdges.h>
#if ENABLE(MEDIA_STREAM)
#include <WebCore/RedEyeReduction.h>
#endif
#include <WebCore/Region.h>
#include <WebCore/RegistrableDomain.h>
#include <WebCore/RemoteUserInputEventData.h>
#include <WebCore/RenderObject.h>
#include <WebCore/RenderStyleConstants.h>
#if ENABLE(THREADED_ANIMATION_RESOLUTION)
#include <WebCore/RenderStyleConstants.h>
#endif
#include <WebCore/RenderTreeAsText.h>
#include <WebCore/Report.h>
#include <WebCore/ReportBody.h>
#include <WebCore/ResourceError.h>
#include <WebCore/ResourceLoadStatistics.h>
#include <WebCore/ResourceLoaderOptions.h>
#include <WebCore/ResourceRequest.h>
#if !USE(CURL) && !PLATFORM(COCOA)
#include <WebCore/ResourceRequest.h>
#endif
#if PLATFORM(COCOA)
#include <WebCore/ResourceRequest.h>
#endif
#if USE(CURL)
#include <WebCore/ResourceRequest.h>
#endif
#if USE(SOUP)
#include <WebCore/ResourceRequest.h>
#endif
#include <WebCore/ResourceResponse.h>
#include <WebCore/ResourceResponseBase.h>
#include <WebCore/RetrieveRecordsOptions.h>
#include <WebCore/RotateTransformOperation.h>
#include <WebCore/RouterSourceDict.h>
#include <WebCore/RsaOtherPrimesInfo.h>
#include <WebCore/SVGFilter.h>
#include <WebCore/SVGFilterExpression.h>
#include <WebCore/SVGPathByteStream.h>
#include <WebCore/SVGPreserveAspectRatioValue.h>
#include <WebCore/SameSiteInfo.h>
#include <WebCore/ScaleTransformOperation.h>
#include <WebCore/ScreenOrientationLockType.h>
#include <WebCore/ScreenOrientationType.h>
#include <WebCore/ScreenProperties.h>
#if !ENABLE(SHAREABLE_RESOURCE) || !PLATFORM(COCOA)
#include <WebCore/ScriptBuffer.h>
#endif
#if ENABLE(SHAREABLE_RESOURCE) && PLATFORM(COCOA)
#include <WebCore/ScriptBuffer.h>
#endif
#include <WebCore/ScriptTrackingPrivacyCategory.h>
#include <WebCore/ScrollTypes.h>
#if USE(APPKIT)
#include <WebCore/ScrollbarTrackCornerSystemImageMac.h>
#endif
#include <WebCore/ScrollingConstraints.h>
#include <WebCore/ScrollingCoordinatorTypes.h>
#if ENABLE(ASYNC_SCROLLING)
#include <WebCore/ScrollingStateNode.h>
#endif
#include <WebCore/SearchFieldCancelButtonPart.h>
#include <WebCore/SearchFieldPart.h>
#include <WebCore/SearchFieldResultsPart.h>
#include <WebCore/SearchPopupMenu.h>
#include <WebCore/SecurityOrigin.h>
#include <WebCore/SecurityOriginData.h>
#include <WebCore/SecurityPolicyViolationEvent.h>
#include <WebCore/SecurityPolicyViolationEventDisposition.h>
#include <WebCore/SelectionData.h>
#if PLATFORM(IOS_FAMILY)
#include <WebCore/SelectionGeometry.h>
#endif
#if ENABLE(ATTACHMENT_ELEMENT)
#include <WebCore/SerializedAttachmentData.h>
#endif
#include <WebCore/SerializedNode.h>
#if ENABLE(VIDEO)
#include <WebCore/SerializedPlatformDataCueValue.h>
#endif
#include <WebCore/SerializedScriptValue.h>
#include <WebCore/ServiceWorkerClientData.h>
#include <WebCore/ServiceWorkerClientPendingMessage.h>
#include <WebCore/ServiceWorkerClientQueryOptions.h>
#include <WebCore/ServiceWorkerContextData.h>
#include <WebCore/ServiceWorkerData.h>
#include <WebCore/ServiceWorkerImportedScript.h>
#include <WebCore/ServiceWorkerJobData.h>
#include <WebCore/ServiceWorkerJobDataIdentifier.h>
#include <WebCore/ServiceWorkerRegistrationData.h>
#include <WebCore/ServiceWorkerRegistrationKey.h>
#include <WebCore/ServiceWorkerRegistrationOptions.h>
#include <WebCore/ServiceWorkerRoute.h>
#include <WebCore/ShareData.h>
#include <WebCore/ShareableBitmap.h>
#if ENABLE(SHAREABLE_RESOURCE)
#include <WebCore/ShareableResource.h>
#endif
#include <WebCore/SharedBuffer.h>
#include <WebCore/SharedStringHash.h>
#include <WebCore/SharedWorkerKey.h>
#include <WebCore/ShouldTreatAsContinuingLoad.h>
#include <WebCore/Site.h>
#include <WebCore/SkewTransformOperation.h>
#include <WebCore/SliderThumbPart.h>
#include <WebCore/SliderTrackPart.h>
#include <WebCore/SocketStreamError.h>
#include <WebCore/SoupNetworkProxySettings.h>
#include <WebCore/SourceAlpha.h>
#if ENABLE(MEDIA_SOURCE)
#include <WebCore/SourceBufferPrivate.h>
#endif
#if ENABLE(MEDIA_SOURCE)
#include <WebCore/SourceBufferPrivateClient.h>
#endif
#include <WebCore/SourceGraphic.h>
#include <WebCore/SourceImage.h>
#if ENABLE(WEB_PAGE_SPATIAL_BACKDROP)
#include <WebCore/SpatialBackdropSource.h>
#endif
#if ENABLE(VIDEO)
#include <WebCore/SpatialVideoMetadata.h>
#endif
#include <WebCore/SpeechRecognitionError.h>
#include <WebCore/SpeechRecognitionRequestInfo.h>
#include <WebCore/SpeechRecognitionResultData.h>
#include <WebCore/SpeechRecognitionUpdate.h>
#include <WebCore/SpotLightSource.h>
#if ENABLE(MODEL_PROCESS)
#include <WebCore/StageModeOperations.h>
#endif
#include <WebCore/StorageBlockingPolicy.h>
#include <WebCore/StorageEstimate.h>
#include <WebCore/StorageType.h>
#include <WebCore/StyleBorderRadius.h>
#include <WebCore/StyleCircleFunction.h>
#include <WebCore/StyleEllipseFunction.h>
#include <WebCore/StyleFillRule.h>
#include <WebCore/StyleGradient.h>
#include <WebCore/StyleInsetFunction.h>
#include <WebCore/StyleLengthWrapperData.h>
#include <WebCore/StyleListStyleType.h>
#if ENABLE(THREADED_ANIMATION_RESOLUTION)
#include <WebCore/StyleOffsetRotate.h>
#endif
#include <WebCore/StylePathFunction.h>
#include <WebCore/StylePolygonFunction.h>
#include <WebCore/StylePosition.h>
#include <WebCore/StylePrimitiveNumericTypes.h>
#include <WebCore/StyleRayFunction.h>
#include <WebCore/StyleShapeFunction.h>
#include <WebCore/SubstituteData.h>
#include <WebCore/SwitchThumbPart.h>
#include <WebCore/SwitchTrackPart.h>
#include <WebCore/SystemImage.h>
#include <WebCore/SystemPreviewInfo.h>
#include <WebCore/SystemSettings.h>
#include <WebCore/TestReportBody.h>
#include <WebCore/TextAreaPart.h>
#if PLATFORM(COCOA)
#include <WebCore/TextAttachmentForSerialization.h>
#endif
#include <WebCore/TextChecking.h>
#include <WebCore/TextExtractionTypes.h>
#include <WebCore/TextFieldPart.h>
#include <WebCore/TextFlags.h>
#include <WebCore/TextGranularity.h>
#include <WebCore/TextIndicator.h>
#include <WebCore/TextManipulationController.h>
#include <WebCore/TextManipulationControllerManipulationFailure.h>
#include <WebCore/TextManipulationItem.h>
#include <WebCore/TextManipulationToken.h>
#if ENABLE(IMAGE_ANALYSIS)
#include <WebCore/TextRecognitionResult.h>
#endif
#if ENABLE(IMAGE_ANALYSIS) && ENABLE(DATA_DETECTION)
#include <WebCore/TextRecognitionResult.h>
#endif
#include <WebCore/ThreadSafeDataBuffer.h>
#include <WebCore/TimingFunction.h>
#include <WebCore/ToggleButtonPart.h>
#include <WebCore/TransformOperation.h>
#include <WebCore/TransformOperationData.h>
#include <WebCore/TransformOperations.h>
#include <WebCore/TransformationMatrix.h>
#include <WebCore/TranslateTransformOperation.h>
#if HAVE(TRANSLATION_UI_SERVICES) && ENABLE(CONTEXT_MENUS)
#include <WebCore/TranslationContextMenuInfo.h>
#endif
#include <WebCore/TrustedFonts.h>
#if ENABLE(WEB_AUTHN)
#include <WebCore/UnknownCredentialOptions.h>
#endif
#include <WebCore/UserScript.h>
#include <WebCore/UserStyleSheet.h>
#include <WebCore/VP9Utilities.h>
#if ENABLE(VIDEO)
#include <WebCore/VTTCue.h>
#endif
#include <WebCore/VelocityData.h>
#include <WebCore/VideoCodecType.h>
#include <WebCore/VideoConfiguration.h>
#include <WebCore/VideoEncoderScalabilityMode.h>
#if ENABLE(VIDEO)
#include <WebCore/VideoFrame.h>
#endif
#if ENABLE(VIDEO) && USE(AVFOUNDATION)
#include <WebCore/VideoFrameCV.h>
#endif
#if ENABLE(VIDEO)
#include <WebCore/VideoFrameMetadata.h>
#endif
#include <WebCore/VideoFrameTimeMetadata.h>
#if ENABLE(VIDEO)
#include <WebCore/VideoPlaybackQualityMetrics.h>
#endif
#if ENABLE(MEDIA_STREAM)
#include <WebCore/VideoPreset.h>
#endif
#if ENABLE(VIDEO)
#include <WebCore/VideoProjectionMetadata.h>
#endif
#if ENABLE(VIDEO)
#include <WebCore/VideoTrackPrivate.h>
#endif
#if ENABLE(META_VIEWPORT)
#include <WebCore/ViewportArguments.h>
#endif
#include <WebCore/VisibleSelection.h>
#if ENABLE(THREADED_ANIMATION_RESOLUTION)
#include <WebCore/WebAnimationTime.h>
#endif
#if ENABLE(THREADED_ANIMATION_RESOLUTION)
#include <WebCore/WebAnimationTypes.h>
#endif
#include <WebCore/WebCodecsEncodedAudioChunk.h>
#if ENABLE(WEB_CODECS)
#include <WebCore/WebCodecsEncodedAudioChunk.h>
#endif
#if ENABLE(WEB_CODECS)
#include <WebCore/WebCodecsEncodedAudioChunkData.h>
#endif
#include <WebCore/WebCodecsEncodedVideoChunk.h>
#if ENABLE(WEB_CODECS)
#include <WebCore/WebCodecsEncodedVideoChunk.h>
#endif
#if ENABLE(WEB_CODECS)
#include <WebCore/WebCodecsEncodedVideoChunkData.h>
#endif
#include <WebCore/WebGPUAddressMode.h>
#include <WebCore/WebGPUBlendFactor.h>
#include <WebCore/WebGPUBlendOperation.h>
#include <WebCore/WebGPUBufferBindingType.h>
#include <WebCore/WebGPUBufferUsage.h>
#include <WebCore/WebGPUCanvasAlphaMode.h>
#include <WebCore/WebGPUCanvasToneMappingMode.h>
#include <WebCore/WebGPUColorWrite.h>
#include <WebCore/WebGPUCompareFunction.h>
#include <WebCore/WebGPUCompilationMessageType.h>
#include <WebCore/WebGPUCullMode.h>
#include <WebCore/WebGPUDeviceLostReason.h>
#include <WebCore/WebGPUErrorFilter.h>
#include <WebCore/WebGPUFilterMode.h>
#include <WebCore/WebGPUFrontFace.h>
#include <WebCore/WebGPUIndexFormat.h>
#include <WebCore/WebGPULoadOp.h>
#include <WebCore/WebGPUMapMode.h>
#include <WebCore/WebGPUPredefinedColorSpace.h>
#include <WebCore/WebGPUPrimitiveTopology.h>
#include <WebCore/WebGPUQueryType.h>
#include <WebCore/WebGPUSamplerBindingType.h>
#include <WebCore/WebGPUShaderStage.h>
#include <WebCore/WebGPUStencilOperation.h>
#include <WebCore/WebGPUStorageTextureAccess.h>
#include <WebCore/WebGPUStoreOp.h>
#include <WebCore/WebGPUTextureAspect.h>
#include <WebCore/WebGPUTextureDimension.h>
#include <WebCore/WebGPUTextureFormat.h>
#include <WebCore/WebGPUTextureSampleType.h>
#include <WebCore/WebGPUTextureUsage.h>
#include <WebCore/WebGPUTextureViewDimension.h>
#include <WebCore/WebGPUVertexFormat.h>
#include <WebCore/WebGPUVertexStepMode.h>
#include <WebCore/WebGPUXREye.h>
#include <WebCore/WebLockManagerSnapshot.h>
#include <WebCore/WheelEventTestMonitor.h>
#include <WebCore/WindowFeatures.h>
#include <WebCore/WorkerFetchResult.h>
#include <WebCore/WorkerInitializationData.h>
#include <WebCore/WorkerOptions.h>
#include <WebCore/WrappedCryptoKey.h>
#include <WebCore/WritingDirection.h>
#if ENABLE(WRITING_TOOLS)
#include <WebCore/WritingToolsTypes.h>
#endif
#if USE(SKIA)
#include <hb.h>
#endif
#include <pal/SessionID.h>
#include <skia/core/SkFontStyle.h>
#include <wtf/JSONValues.h>
#if OS(DARWIN)
#include <wtf/MachSendRight.h>
#endif
#if PLATFORM(COCOA)
#include <wtf/MachSendRightAnnotated.h>
#endif
#include <wtf/MediaTime.h>
#include <wtf/MemoryPressureHandler.h>
#include <wtf/MonotonicTime.h>
#include <wtf/ObjectIdentifier.h>
#if ENABLE(MODEL_PROCESS)
#include <wtf/ProcessID.h>
#endif
#include <wtf/RobinHoodHashTable.h>
#include <wtf/Seconds.h>
#include <wtf/URL.h>
#include <wtf/UUID.h>
#include <wtf/Variant.h>
#include <wtf/WallTime.h>
#include <wtf/text/AtomString.h>
#include <wtf/text/CString.h>
#if USE(UNIX_DOMAIN_SOCKETS)
#include <wtf/unix/UnixFileDescriptor.h>
#endif

template<size_t...> struct MembersInCorrectOrder;
template<size_t onlyOffset> struct MembersInCorrectOrder<onlyOffset> {
    static constexpr bool value = true;
};
template<size_t firstOffset, size_t secondOffset, size_t... remainingOffsets> struct MembersInCorrectOrder<firstOffset, secondOffset, remainingOffsets...> {
    static constexpr bool value = firstOffset > secondOffset ? false : MembersInCorrectOrder<secondOffset, remainingOffsets...>::value;
};

template<uint64_t...> struct BitsInIncreasingOrder;
template<uint64_t onlyBit> struct BitsInIncreasingOrder<onlyBit> {
    static constexpr bool value = true;
};
template<uint64_t firstBit, uint64_t secondBit, uint64_t... remainingBits> struct BitsInIncreasingOrder<firstBit, secondBit, remainingBits...> {
    static constexpr bool value = firstBit == secondBit >> 1 && BitsInIncreasingOrder<secondBit, remainingBits...>::value;
};

template<bool, bool> struct VirtualTableAndRefCountOverhead;
template<> struct VirtualTableAndRefCountOverhead<true, true> : public RefCounted<VirtualTableAndRefCountOverhead<true, true>> {
    virtual ~VirtualTableAndRefCountOverhead() { }
};
template<> struct VirtualTableAndRefCountOverhead<false, true> : public RefCounted<VirtualTableAndRefCountOverhead<false, true>> { };
template<> struct VirtualTableAndRefCountOverhead<true, false> {
    virtual ~VirtualTableAndRefCountOverhead() { }
};
template<> struct VirtualTableAndRefCountOverhead<false, false> { };

IGNORE_WARNINGS_BEGIN("invalid-offsetof")

namespace IPC {


#if ENABLE(GPU_PROCESS) && ENABLE(MEDIA_SOURCE)
template<> struct ArgumentCoder<WebKit::InitializationSegmentInfo::TrackInformation> {
    static void encode(Encoder&, const WebKit::InitializationSegmentInfo::TrackInformation&);
    static std::optional<WebKit::InitializationSegmentInfo::TrackInformation> decode(Decoder&);
};
#endif

#if !USE(UNIX_DOMAIN_SOCKETS)
template<> struct ArgumentCoder<IPC::SharedBufferReference::SerializableBuffer> {
    static void encode(Encoder&, IPC::SharedBufferReference::SerializableBuffer&&);
    static std::optional<IPC::SharedBufferReference::SerializableBuffer> decode(Decoder&);
};
#endif

#if PLATFORM(IOS_FAMILY)
template<> struct ArgumentCoder<WebKit::DocumentEditingContext::Range> {
    static void encode(Encoder&, const WebKit::DocumentEditingContext::Range&);
    static std::optional<WebKit::DocumentEditingContext::Range> decode(Decoder&);
};
#endif

#if PLATFORM(IOS_FAMILY)
template<> struct ArgumentCoder<WebKit::DocumentEditingContext::TextRectAndRange> {
    static void encode(Encoder&, const WebKit::DocumentEditingContext::TextRectAndRange&);
    static std::optional<WebKit::DocumentEditingContext::TextRectAndRange> decode(Decoder&);
};
#endif

template<> struct ArgumentCoder<WebKit::EditorState::PostLayoutData> {
    static void encode(Encoder&, const WebKit::EditorState::PostLayoutData&);
    static std::optional<WebKit::EditorState::PostLayoutData> decode(Decoder&);
};

template<> struct ArgumentCoder<WebKit::EditorState::VisualData> {
    static void encode(Encoder&, const WebKit::EditorState::VisualData&);
    static std::optional<WebKit::EditorState::VisualData> decode(Decoder&);
};

#if USE(LIBWEBRTC)
template<> struct ArgumentCoder<WebKit::WebRTCNetwork::IPAddress::UnspecifiedFamily> {
    static void encode(Encoder&, const WebKit::WebRTCNetwork::IPAddress::UnspecifiedFamily&);
    static std::optional<WebKit::WebRTCNetwork::IPAddress::UnspecifiedFamily> decode(Decoder&);
};
#endif

#if (USE(LIBWEBRTC)) && (USE(LIBWEBRTC) && PLATFORM(COCOA))
template<> struct ArgumentCoder<webrtc::EncodedImage::Timing> {
    static void encode(Encoder&, const webrtc::EncodedImage::Timing&);
    static std::optional<webrtc::EncodedImage::Timing> decode(Decoder&);
};
#endif

#if USE(LIBWEBRTC)
template<> struct ArgumentCoder<WebKit::RTCPacketOptions::SerializableData> {
    static void encode(Encoder&, const WebKit::RTCPacketOptions::SerializableData&);
    static std::optional<WebKit::RTCPacketOptions::SerializableData> decode(Decoder&);
};
#endif

#if ENABLE(SANDBOX_EXTENSIONS)
template<> struct ArgumentCoder<WebKit::SandboxExtensionImpl> {
    static void encode(Encoder&, WebKit::SandboxExtensionImpl&&);
    static std::optional<WebKit::SandboxExtensionImpl> decode(Decoder&);
};
#endif

template<> struct ArgumentCoder<WebCore::SerializedNode::QualifiedName> {
    static void encode(Encoder&, const WebCore::SerializedNode::QualifiedName&);
    static std::optional<WebCore::SerializedNode::QualifiedName> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::SerializedNode::ContainerNode> {
    static void encode(Encoder&, const WebCore::SerializedNode::ContainerNode&);
    static std::optional<WebCore::SerializedNode::ContainerNode> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::SerializedNode::Attr> {
    static void encode(Encoder&, const WebCore::SerializedNode::Attr&);
    static std::optional<WebCore::SerializedNode::Attr> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::SerializedNode::CharacterData> {
    static void encode(Encoder&, const WebCore::SerializedNode::CharacterData&);
    static std::optional<WebCore::SerializedNode::CharacterData> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::SerializedNode::Document> {
    static void encode(Encoder&, const WebCore::SerializedNode::Document&);
    static std::optional<WebCore::SerializedNode::Document> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::SerializedNode::DocumentFragment> {
    static void encode(Encoder&, const WebCore::SerializedNode::DocumentFragment&);
    static std::optional<WebCore::SerializedNode::DocumentFragment> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::SerializedNode::DocumentType> {
    static void encode(Encoder&, const WebCore::SerializedNode::DocumentType&);
    static std::optional<WebCore::SerializedNode::DocumentType> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::SerializedNode::Element::Attribute> {
    static void encode(Encoder&, const WebCore::SerializedNode::Element::Attribute&);
    static std::optional<WebCore::SerializedNode::Element::Attribute> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::SerializedNode::Element> {
    static void encode(Encoder&, const WebCore::SerializedNode::Element&);
    static std::optional<WebCore::SerializedNode::Element> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::SerializedNode::Comment> {
    static void encode(Encoder&, const WebCore::SerializedNode::Comment&);
    static std::optional<WebCore::SerializedNode::Comment> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::SerializedNode::Text> {
    static void encode(Encoder&, const WebCore::SerializedNode::Text&);
    static std::optional<WebCore::SerializedNode::Text> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::SerializedNode::CDATASection> {
    static void encode(Encoder&, const WebCore::SerializedNode::CDATASection&);
    static std::optional<WebCore::SerializedNode::CDATASection> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::SerializedNode::ProcessingInstruction> {
    static void encode(Encoder&, const WebCore::SerializedNode::ProcessingInstruction&);
    static std::optional<WebCore::SerializedNode::ProcessingInstruction> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::SerializedNode::ShadowRoot> {
    static void encode(Encoder&, const WebCore::SerializedNode::ShadowRoot&);
    static std::optional<WebCore::SerializedNode::ShadowRoot> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::SerializedNode::HTMLTemplateElement> {
    static void encode(Encoder&, const WebCore::SerializedNode::HTMLTemplateElement&);
    static std::optional<WebCore::SerializedNode::HTMLTemplateElement> decode(Decoder&);
};

template<> struct ArgumentCoder<WebKit::HTTPBody::Element> {
    static void encode(Encoder&, const WebKit::HTTPBody::Element&);
    static std::optional<WebKit::HTTPBody::Element> decode(Decoder&);
};

template<> struct ArgumentCoder<WebKit::HTTPBody::Element::FileData> {
    static void encode(Encoder&, const WebKit::HTTPBody::Element::FileData&);
    static std::optional<WebKit::HTTPBody::Element::FileData> decode(Decoder&);
};

template<> struct ArgumentCoder<std::monostate> {
    static void encode(Encoder&, const std::monostate&);
    static void encode(StreamConnectionEncoder&, const std::monostate&);
    static std::optional<std::monostate> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Style::ListStyleType> {
    static void encode(Encoder&, const WebCore::Style::ListStyleType&);
    static std::optional<WebCore::Style::ListStyleType> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Style::ListStyleType::NoneData> {
    static void encode(Encoder&, const WebCore::Style::ListStyleType::NoneData&);
    static std::optional<WebCore::Style::ListStyleType::NoneData> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Style::ListStyleType::StringData> {
    static void encode(Encoder&, const WebCore::Style::ListStyleType::StringData&);
    static std::optional<WebCore::Style::ListStyleType::StringData> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Style::ListStyleType::CounterStyleData> {
    static void encode(Encoder&, const WebCore::Style::ListStyleType::CounterStyleData&);
    static std::optional<WebCore::Style::ListStyleType::CounterStyleData> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::IDBKeyData::Invalid> {
    static void encode(Encoder&, const WebCore::IDBKeyData::Invalid&);
    static std::optional<WebCore::IDBKeyData::Invalid> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::IDBKeyData::Min> {
    static void encode(Encoder&, const WebCore::IDBKeyData::Min&);
    static std::optional<WebCore::IDBKeyData::Min> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::IDBKeyData::Max> {
    static void encode(Encoder&, const WebCore::IDBKeyData::Max&);
    static std::optional<WebCore::IDBKeyData::Max> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::IDBKeyData::Date> {
    static void encode(Encoder&, const WebCore::IDBKeyData::Date&);
    static std::optional<WebCore::IDBKeyData::Date> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::LinearTimingFunction::Point> {
    static void encode(Encoder&, const WebCore::LinearTimingFunction::Point&);
    static std::optional<WebCore::LinearTimingFunction::Point> decode(Decoder&);
};

#if ENABLE(APPLICATION_MANIFEST)
template<> struct ArgumentCoder<WebCore::ApplicationManifest::Icon> {
    static void encode(Encoder&, const WebCore::ApplicationManifest::Icon&);
    static std::optional<WebCore::ApplicationManifest::Icon> decode(Decoder&);
};
#endif

#if ENABLE(APPLICATION_MANIFEST)
template<> struct ArgumentCoder<WebCore::ApplicationManifest::Shortcut> {
    static void encode(Encoder&, const WebCore::ApplicationManifest::Shortcut&);
    static std::optional<WebCore::ApplicationManifest::Shortcut> decode(Decoder&);
};
#endif

template<> struct ArgumentCoder<WebCore::WebLockManagerSnapshot::Info> {
    static void encode(Encoder&, const WebCore::WebLockManagerSnapshot::Info&);
    static std::optional<WebCore::WebLockManagerSnapshot::Info> decode(Decoder&);
};

#if ENABLE(WEB_AUTHN)
template<> struct ArgumentCoder<WebCore::AuthenticationExtensionsClientInputs::LargeBlobInputs> {
    static void encode(Encoder&, const WebCore::AuthenticationExtensionsClientInputs::LargeBlobInputs&);
    static std::optional<WebCore::AuthenticationExtensionsClientInputs::LargeBlobInputs> decode(Decoder&);
};
#endif

#if ENABLE(WEB_AUTHN)
template<> struct ArgumentCoder<WebCore::AuthenticationExtensionsClientInputs::PRFValues> {
    static void encode(Encoder&, const WebCore::AuthenticationExtensionsClientInputs::PRFValues&);
    static std::optional<WebCore::AuthenticationExtensionsClientInputs::PRFValues> decode(Decoder&);
};
#endif

#if ENABLE(WEB_AUTHN)
template<> struct ArgumentCoder<WebCore::AuthenticationExtensionsClientInputs::PRFInputs> {
    static void encode(Encoder&, const WebCore::AuthenticationExtensionsClientInputs::PRFInputs&);
    static std::optional<WebCore::AuthenticationExtensionsClientInputs::PRFInputs> decode(Decoder&);
};
#endif

#if ENABLE(WEB_AUTHN)
template<> struct ArgumentCoder<WebCore::AuthenticationExtensionsClientOutputs::LargeBlobOutputs> {
    static void encode(Encoder&, const WebCore::AuthenticationExtensionsClientOutputs::LargeBlobOutputs&);
    static std::optional<WebCore::AuthenticationExtensionsClientOutputs::LargeBlobOutputs> decode(Decoder&);
};
#endif

#if ENABLE(WEB_AUTHN)
template<> struct ArgumentCoder<WebCore::AuthenticationExtensionsClientOutputs::PRFValues> {
    static void encode(Encoder&, const WebCore::AuthenticationExtensionsClientOutputs::PRFValues&);
    static std::optional<WebCore::AuthenticationExtensionsClientOutputs::PRFValues> decode(Decoder&);
};
#endif

#if ENABLE(WEB_AUTHN)
template<> struct ArgumentCoder<WebCore::AuthenticationExtensionsClientOutputs::PRFOutputs> {
    static void encode(Encoder&, const WebCore::AuthenticationExtensionsClientOutputs::PRFOutputs&);
    static std::optional<WebCore::AuthenticationExtensionsClientOutputs::PRFOutputs> decode(Decoder&);
};
#endif

#if ENABLE(WEB_AUTHN)
template<> struct ArgumentCoder<WebCore::PublicKeyCredentialParameters> {
    static void encode(Encoder&, const WebCore::PublicKeyCredentialParameters&);
    static std::optional<WebCore::PublicKeyCredentialParameters> decode(Decoder&);
};
#endif

template<> struct ArgumentCoder<WebCore::HTTPHeaderMap::CommonHeader> {
    static void encode(Encoder&, const WebCore::HTTPHeaderMap::CommonHeader&);
    static std::optional<WebCore::HTTPHeaderMap::CommonHeader> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::HTTPHeaderMap::UncommonHeader> {
    static void encode(Encoder&, const WebCore::HTTPHeaderMap::UncommonHeader&);
    static std::optional<WebCore::HTTPHeaderMap::UncommonHeader> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::ResourceRequest::RequestData> {
    static void encode(Encoder&, const WebCore::ResourceRequest::RequestData&);
    static std::optional<WebCore::ResourceRequest::RequestData> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::ResourceError::IPCData> {
    static void encode(Encoder&, const WebCore::ResourceError::IPCData&);
    static std::optional<WebCore::ResourceError::IPCData> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::FormDataElement::EncodedFileData> {
    static void encode(Encoder&, const WebCore::FormDataElement::EncodedFileData&);
    static std::optional<WebCore::FormDataElement::EncodedFileData> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::FormDataElement::EncodedBlobData> {
    static void encode(Encoder&, const WebCore::FormDataElement::EncodedBlobData&);
    static std::optional<WebCore::FormDataElement::EncodedBlobData> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::PlatformTimeRanges::Range> {
    static void encode(Encoder&, const WebCore::PlatformTimeRanges::Range&);
    static std::optional<WebCore::PlatformTimeRanges::Range> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::PasteboardCustomData::Entry> {
    static void encode(Encoder&, const WebCore::PasteboardCustomData::Entry&);
    static std::optional<WebCore::PasteboardCustomData::Entry> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Gradient::LinearData> {
    static void encode(Encoder&, const WebCore::Gradient::LinearData&);
    static void encode(StreamConnectionEncoder&, const WebCore::Gradient::LinearData&);
    static std::optional<WebCore::Gradient::LinearData> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Gradient::RadialData> {
    static void encode(Encoder&, const WebCore::Gradient::RadialData&);
    static void encode(StreamConnectionEncoder&, const WebCore::Gradient::RadialData&);
    static std::optional<WebCore::Gradient::RadialData> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Gradient::ConicData> {
    static void encode(Encoder&, const WebCore::Gradient::ConicData&);
    static void encode(StreamConnectionEncoder&, const WebCore::Gradient::ConicData&);
    static std::optional<WebCore::Gradient::ConicData> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Style::Angle<WebCore::CSS::Nonnegative>> {
    static void encode(Encoder&, const WebCore::Style::Angle<WebCore::CSS::Nonnegative>&);
    static std::optional<WebCore::Style::Angle<WebCore::CSS::Nonnegative>> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Style::Angle<WebCore::CSS::All>> {
    static void encode(Encoder&, const WebCore::Style::Angle<WebCore::CSS::All>&);
    static std::optional<WebCore::Style::Angle<WebCore::CSS::All>> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Style::AngleAllFloat> {
    static void encode(Encoder&, const WebCore::Style::AngleAllFloat&);
    static std::optional<WebCore::Style::AngleAllFloat> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Style::PercentageNonnegativeFloat> {
    static void encode(Encoder&, const WebCore::Style::PercentageNonnegativeFloat&);
    static std::optional<WebCore::Style::PercentageNonnegativeFloat> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Style::PercentageAllFloat> {
    static void encode(Encoder&, const WebCore::Style::PercentageAllFloat&);
    static std::optional<WebCore::Style::PercentageAllFloat> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Style::LengthNonnegative> {
    static void encode(Encoder&, const WebCore::Style::LengthNonnegative&);
    static std::optional<WebCore::Style::LengthNonnegative> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Style::Length<WebCore::CSS::All>> {
    static void encode(Encoder&, const WebCore::Style::Length<WebCore::CSS::All>&);
    static std::optional<WebCore::Style::Length<WebCore::CSS::All>> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Style::Percentage<WebCore::CSS::Nonnegative>> {
    static void encode(Encoder&, const WebCore::Style::Percentage<WebCore::CSS::Nonnegative>&);
    static std::optional<WebCore::Style::Percentage<WebCore::CSS::Nonnegative>> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Style::Percentage<WebCore::CSS::All>> {
    static void encode(Encoder&, const WebCore::Style::Percentage<WebCore::CSS::All>&);
    static std::optional<WebCore::Style::Percentage<WebCore::CSS::All>> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Style::LengthPercentage<WebCore::CSS::All>> {
    static void encode(Encoder&, const WebCore::Style::LengthPercentage<WebCore::CSS::All>&);
    static std::optional<WebCore::Style::LengthPercentage<WebCore::CSS::All>> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Style::LengthPercentage<WebCore::CSS::Nonnegative>> {
    static void encode(Encoder&, const WebCore::Style::LengthPercentage<WebCore::CSS::Nonnegative>&);
    static std::optional<WebCore::Style::LengthPercentage<WebCore::CSS::Nonnegative>> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::SpaceSeparatedPair<WebCore::Style::LengthPercentageNonnegative>> {
    static void encode(Encoder&, const WebCore::SpaceSeparatedPair<WebCore::Style::LengthPercentageNonnegative>&);
    static std::optional<WebCore::SpaceSeparatedPair<WebCore::Style::LengthPercentageNonnegative>> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::SpaceSeparatedPair<WebCore::Style::LengthPercentageAll>> {
    static void encode(Encoder&, const WebCore::SpaceSeparatedPair<WebCore::Style::LengthPercentageAll>&);
    static std::optional<WebCore::SpaceSeparatedPair<WebCore::Style::LengthPercentageAll>> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::SpaceSeparatedPair<WebCore::Style::CoordinatePair>> {
    static void encode(Encoder&, const WebCore::SpaceSeparatedPair<WebCore::Style::CoordinatePair>&);
    static std::optional<WebCore::SpaceSeparatedPair<WebCore::Style::CoordinatePair>> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::SpaceSeparatedSize<WebCore::Style::LengthPercentageNonnegative>> {
    static void encode(Encoder&, const WebCore::SpaceSeparatedSize<WebCore::Style::LengthPercentageNonnegative>&);
    static std::optional<WebCore::SpaceSeparatedSize<WebCore::Style::LengthPercentageNonnegative>> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::SpaceSeparatedSize<WebCore::Style::LengthPercentageAll>> {
    static void encode(Encoder&, const WebCore::SpaceSeparatedSize<WebCore::Style::LengthPercentageAll>&);
    static std::optional<WebCore::SpaceSeparatedSize<WebCore::Style::LengthPercentageAll>> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::SpaceSeparatedPoint<WebCore::Style::LengthPercentageNonnegative>> {
    static void encode(Encoder&, const WebCore::SpaceSeparatedPoint<WebCore::Style::LengthPercentageNonnegative>&);
    static std::optional<WebCore::SpaceSeparatedPoint<WebCore::Style::LengthPercentageNonnegative>> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::SpaceSeparatedPoint<WebCore::Style::LengthPercentageAll>> {
    static void encode(Encoder&, const WebCore::SpaceSeparatedPoint<WebCore::Style::LengthPercentageAll>&);
    static std::optional<WebCore::SpaceSeparatedPoint<WebCore::Style::LengthPercentageAll>> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::MinimallySerializingSpaceSeparatedSize<WebCore::Style::LengthPercentageNonnegative>> {
    static void encode(Encoder&, const WebCore::MinimallySerializingSpaceSeparatedSize<WebCore::Style::LengthPercentageNonnegative>&);
    static std::optional<WebCore::MinimallySerializingSpaceSeparatedSize<WebCore::Style::LengthPercentageNonnegative>> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::MinimallySerializingSpaceSeparatedSize<WebCore::Style::LengthPercentageAll>> {
    static void encode(Encoder&, const WebCore::MinimallySerializingSpaceSeparatedSize<WebCore::Style::LengthPercentageAll>&);
    static std::optional<WebCore::MinimallySerializingSpaceSeparatedSize<WebCore::Style::LengthPercentageAll>> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::CommaSeparatedVector<WebCore::Style::LengthPercentageSpaceSeparatedPointAll>> {
    static void encode(Encoder&, const WebCore::CommaSeparatedVector<WebCore::Style::LengthPercentageSpaceSeparatedPointAll>&);
    static std::optional<WebCore::CommaSeparatedVector<WebCore::Style::LengthPercentageSpaceSeparatedPointAll>> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::CommaSeparatedVector<WebCore::Style::LengthPercentageSpaceSeparatedPointNonnegative>> {
    static void encode(Encoder&, const WebCore::CommaSeparatedVector<WebCore::Style::LengthPercentageSpaceSeparatedPointNonnegative>&);
    static std::optional<WebCore::CommaSeparatedVector<WebCore::Style::LengthPercentageSpaceSeparatedPointNonnegative>> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::MinimallySerializingSpaceSeparatedRectEdges<WebCore::Style::LengthPercentageAll>> {
    static void encode(Encoder&, const WebCore::MinimallySerializingSpaceSeparatedRectEdges<WebCore::Style::LengthPercentageAll>&);
    static std::optional<WebCore::MinimallySerializingSpaceSeparatedRectEdges<WebCore::Style::LengthPercentageAll>> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::CommaSeparatedVector<WebCore::Style::ShapeCommand>> {
    static void encode(Encoder&, const WebCore::CommaSeparatedVector<WebCore::Style::ShapeCommand>&);
    static std::optional<WebCore::CommaSeparatedVector<WebCore::Style::ShapeCommand>> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Style::LengthWrapperData::AutoData> {
    static void encode(Encoder&, const WebCore::Style::LengthWrapperData::AutoData&);
    static std::optional<WebCore::Style::LengthWrapperData::AutoData> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Style::LengthWrapperData::NormalData> {
    static void encode(Encoder&, const WebCore::Style::LengthWrapperData::NormalData&);
    static std::optional<WebCore::Style::LengthWrapperData::NormalData> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Style::LengthWrapperData::FixedData> {
    static void encode(Encoder&, const WebCore::Style::LengthWrapperData::FixedData&);
    static std::optional<WebCore::Style::LengthWrapperData::FixedData> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Style::LengthWrapperData::RelativeData> {
    static void encode(Encoder&, const WebCore::Style::LengthWrapperData::RelativeData&);
    static std::optional<WebCore::Style::LengthWrapperData::RelativeData> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Style::LengthWrapperData::PercentData> {
    static void encode(Encoder&, const WebCore::Style::LengthWrapperData::PercentData&);
    static std::optional<WebCore::Style::LengthWrapperData::PercentData> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Style::LengthWrapperData::IntrinsicData> {
    static void encode(Encoder&, const WebCore::Style::LengthWrapperData::IntrinsicData&);
    static std::optional<WebCore::Style::LengthWrapperData::IntrinsicData> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Style::LengthWrapperData::MinIntrinsicData> {
    static void encode(Encoder&, const WebCore::Style::LengthWrapperData::MinIntrinsicData&);
    static std::optional<WebCore::Style::LengthWrapperData::MinIntrinsicData> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Style::LengthWrapperData::MinContentData> {
    static void encode(Encoder&, const WebCore::Style::LengthWrapperData::MinContentData&);
    static std::optional<WebCore::Style::LengthWrapperData::MinContentData> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Style::LengthWrapperData::MaxContentData> {
    static void encode(Encoder&, const WebCore::Style::LengthWrapperData::MaxContentData&);
    static std::optional<WebCore::Style::LengthWrapperData::MaxContentData> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Style::LengthWrapperData::FillAvailableData> {
    static void encode(Encoder&, const WebCore::Style::LengthWrapperData::FillAvailableData&);
    static std::optional<WebCore::Style::LengthWrapperData::FillAvailableData> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Style::LengthWrapperData::FitContentData> {
    static void encode(Encoder&, const WebCore::Style::LengthWrapperData::FitContentData&);
    static std::optional<WebCore::Style::LengthWrapperData::FitContentData> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Style::LengthWrapperData::ContentData> {
    static void encode(Encoder&, const WebCore::Style::LengthWrapperData::ContentData&);
    static std::optional<WebCore::Style::LengthWrapperData::ContentData> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Style::LengthWrapperData::UndefinedData> {
    static void encode(Encoder&, const WebCore::Style::LengthWrapperData::UndefinedData&);
    static std::optional<WebCore::Style::LengthWrapperData::UndefinedData> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Style::PositionX> {
    static void encode(Encoder&, const WebCore::Style::PositionX&);
    static std::optional<WebCore::Style::PositionX> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Style::PositionY> {
    static void encode(Encoder&, const WebCore::Style::PositionY&);
    static std::optional<WebCore::Style::PositionY> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Style::Position> {
    static void encode(Encoder&, const WebCore::Style::Position&);
    static std::optional<WebCore::Style::Position> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Style::TwoComponentPositionHorizontal> {
    static void encode(Encoder&, const WebCore::Style::TwoComponentPositionHorizontal&);
    static std::optional<WebCore::Style::TwoComponentPositionHorizontal> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Style::TwoComponentPositionVertical> {
    static void encode(Encoder&, const WebCore::Style::TwoComponentPositionVertical&);
    static std::optional<WebCore::Style::TwoComponentPositionVertical> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Constant<WebCore::CSSValueClosestCorner>> {
    static void encode(Encoder&, const WebCore::Constant<WebCore::CSSValueClosestCorner>&);
    static std::optional<WebCore::Constant<WebCore::CSSValueClosestCorner>> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Constant<WebCore::CSSValueClosestSide>> {
    static void encode(Encoder&, const WebCore::Constant<WebCore::CSSValueClosestSide>&);
    static std::optional<WebCore::Constant<WebCore::CSSValueClosestSide>> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Constant<WebCore::CSSValueFarthestCorner>> {
    static void encode(Encoder&, const WebCore::Constant<WebCore::CSSValueFarthestCorner>&);
    static std::optional<WebCore::Constant<WebCore::CSSValueFarthestCorner>> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Constant<WebCore::CSSValueFarthestSide>> {
    static void encode(Encoder&, const WebCore::Constant<WebCore::CSSValueFarthestSide>&);
    static std::optional<WebCore::Constant<WebCore::CSSValueFarthestSide>> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Style::CircleFunction> {
    static void encode(Encoder&, const WebCore::Style::CircleFunction&);
    static std::optional<WebCore::Style::CircleFunction> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Style::Circle> {
    static void encode(Encoder&, const WebCore::Style::Circle&);
    static std::optional<WebCore::Style::Circle> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::SpaceSeparatedPair<WebCore::Style::Ellipse::RadialSize>> {
    static void encode(Encoder&, const WebCore::SpaceSeparatedPair<WebCore::Style::Ellipse::RadialSize>&);
    static std::optional<WebCore::SpaceSeparatedPair<WebCore::Style::Ellipse::RadialSize>> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Style::EllipseFunction> {
    static void encode(Encoder&, const WebCore::Style::EllipseFunction&);
    static std::optional<WebCore::Style::EllipseFunction> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Style::Ellipse> {
    static void encode(Encoder&, const WebCore::Style::Ellipse&);
    static std::optional<WebCore::Style::Ellipse> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Style::InsetFunction> {
    static void encode(Encoder&, const WebCore::Style::InsetFunction&);
    static std::optional<WebCore::Style::InsetFunction> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Style::Inset> {
    static void encode(Encoder&, const WebCore::Style::Inset&);
    static std::optional<WebCore::Style::Inset> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Style::PathFunction> {
    static void encode(Encoder&, const WebCore::Style::PathFunction&);
    static std::optional<WebCore::Style::PathFunction> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Style::Path::Data> {
    static void encode(Encoder&, const WebCore::Style::Path::Data&);
    static std::optional<WebCore::Style::Path::Data> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Style::Path> {
    static void encode(Encoder&, const WebCore::Style::Path&);
    static std::optional<WebCore::Style::Path> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Style::PolygonFunction> {
    static void encode(Encoder&, const WebCore::Style::PolygonFunction&);
    static std::optional<WebCore::Style::PolygonFunction> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Style::Polygon> {
    static void encode(Encoder&, const WebCore::Style::Polygon&);
    static std::optional<WebCore::Style::Polygon> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Constant<WebCore::CSSValueNonzero>> {
    static void encode(Encoder&, const WebCore::Constant<WebCore::CSSValueNonzero>&);
    static std::optional<WebCore::Constant<WebCore::CSSValueNonzero>> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Constant<WebCore::CSSValueEvenodd>> {
    static void encode(Encoder&, const WebCore::Constant<WebCore::CSSValueEvenodd>&);
    static std::optional<WebCore::Constant<WebCore::CSSValueEvenodd>> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Constant<WebCore::CSSValueBy>> {
    static void encode(Encoder&, const WebCore::Constant<WebCore::CSSValueBy>&);
    static std::optional<WebCore::Constant<WebCore::CSSValueBy>> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Constant<WebCore::CSSValueTo>> {
    static void encode(Encoder&, const WebCore::Constant<WebCore::CSSValueTo>&);
    static std::optional<WebCore::Constant<WebCore::CSSValueTo>> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Constant<WebCore::CSSValueCcw>> {
    static void encode(Encoder&, const WebCore::Constant<WebCore::CSSValueCcw>&);
    static std::optional<WebCore::Constant<WebCore::CSSValueCcw>> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Constant<WebCore::CSSValueCw>> {
    static void encode(Encoder&, const WebCore::Constant<WebCore::CSSValueCw>&);
    static std::optional<WebCore::Constant<WebCore::CSSValueCw>> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Constant<WebCore::CSSValueLarge>> {
    static void encode(Encoder&, const WebCore::Constant<WebCore::CSSValueLarge>&);
    static std::optional<WebCore::Constant<WebCore::CSSValueLarge>> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Constant<WebCore::CSSValueSmall>> {
    static void encode(Encoder&, const WebCore::Constant<WebCore::CSSValueSmall>&);
    static std::optional<WebCore::Constant<WebCore::CSSValueSmall>> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Constant<WebCore::CSSValueStart>> {
    static void encode(Encoder&, const WebCore::Constant<WebCore::CSSValueStart>&);
    static std::optional<WebCore::Constant<WebCore::CSSValueStart>> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Constant<WebCore::CSSValueEnd>> {
    static void encode(Encoder&, const WebCore::Constant<WebCore::CSSValueEnd>&);
    static std::optional<WebCore::Constant<WebCore::CSSValueEnd>> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Constant<WebCore::CSSValueOrigin>> {
    static void encode(Encoder&, const WebCore::Constant<WebCore::CSSValueOrigin>&);
    static std::optional<WebCore::Constant<WebCore::CSSValueOrigin>> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Constant<WebCore::CSSValueClose>> {
    static void encode(Encoder&, const WebCore::Constant<WebCore::CSSValueClose>&);
    static std::optional<WebCore::Constant<WebCore::CSSValueClose>> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Style::ToPosition> {
    static void encode(Encoder&, const WebCore::Style::ToPosition&);
    static std::optional<WebCore::Style::ToPosition> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Style::ByCoordinatePair> {
    static void encode(Encoder&, const WebCore::Style::ByCoordinatePair&);
    static std::optional<WebCore::Style::ByCoordinatePair> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Style::RelativeControlPoint> {
    static void encode(Encoder&, const WebCore::Style::RelativeControlPoint&);
    static std::optional<WebCore::Style::RelativeControlPoint> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Style::AbsoluteControlPoint> {
    static void encode(Encoder&, const WebCore::Style::AbsoluteControlPoint&);
    static std::optional<WebCore::Style::AbsoluteControlPoint> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Style::ShapeFunction> {
    static void encode(Encoder&, const WebCore::Style::ShapeFunction&);
    static std::optional<WebCore::Style::ShapeFunction> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Style::Shape> {
    static void encode(Encoder&, const WebCore::Style::Shape&);
    static std::optional<WebCore::Style::Shape> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Style::MoveCommand> {
    static void encode(Encoder&, const WebCore::Style::MoveCommand&);
    static std::optional<WebCore::Style::MoveCommand> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Style::LineCommand> {
    static void encode(Encoder&, const WebCore::Style::LineCommand&);
    static std::optional<WebCore::Style::LineCommand> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Style::HLineCommand::To> {
    static void encode(Encoder&, const WebCore::Style::HLineCommand::To&);
    static std::optional<WebCore::Style::HLineCommand::To> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Style::HLineCommand::By> {
    static void encode(Encoder&, const WebCore::Style::HLineCommand::By&);
    static std::optional<WebCore::Style::HLineCommand::By> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Style::HLineCommand> {
    static void encode(Encoder&, const WebCore::Style::HLineCommand&);
    static std::optional<WebCore::Style::HLineCommand> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Style::VLineCommand::To> {
    static void encode(Encoder&, const WebCore::Style::VLineCommand::To&);
    static std::optional<WebCore::Style::VLineCommand::To> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Style::VLineCommand::By> {
    static void encode(Encoder&, const WebCore::Style::VLineCommand::By&);
    static std::optional<WebCore::Style::VLineCommand::By> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Style::VLineCommand> {
    static void encode(Encoder&, const WebCore::Style::VLineCommand&);
    static std::optional<WebCore::Style::VLineCommand> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Style::CurveCommand::To> {
    static void encode(Encoder&, const WebCore::Style::CurveCommand::To&);
    static std::optional<WebCore::Style::CurveCommand::To> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Style::CurveCommand::By> {
    static void encode(Encoder&, const WebCore::Style::CurveCommand::By&);
    static std::optional<WebCore::Style::CurveCommand::By> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Style::CurveCommand> {
    static void encode(Encoder&, const WebCore::Style::CurveCommand&);
    static std::optional<WebCore::Style::CurveCommand> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Style::SmoothCommand::To> {
    static void encode(Encoder&, const WebCore::Style::SmoothCommand::To&);
    static std::optional<WebCore::Style::SmoothCommand::To> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Style::SmoothCommand::By> {
    static void encode(Encoder&, const WebCore::Style::SmoothCommand::By&);
    static std::optional<WebCore::Style::SmoothCommand::By> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Style::SmoothCommand> {
    static void encode(Encoder&, const WebCore::Style::SmoothCommand&);
    static std::optional<WebCore::Style::SmoothCommand> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Style::ArcCommand> {
    static void encode(Encoder&, const WebCore::Style::ArcCommand&);
    static std::optional<WebCore::Style::ArcCommand> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Style::BorderRadius> {
    static void encode(Encoder&, const WebCore::Style::BorderRadius&);
    static std::optional<WebCore::Style::BorderRadius> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Constant<WebCore::CSSValueSides>> {
    static void encode(Encoder&, const WebCore::Constant<WebCore::CSSValueSides>&);
    static std::optional<WebCore::Constant<WebCore::CSSValueSides>> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Constant<WebCore::CSSValueContain>> {
    static void encode(Encoder&, const WebCore::Constant<WebCore::CSSValueContain>&);
    static std::optional<WebCore::Constant<WebCore::CSSValueContain>> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Style::RayFunction> {
    static void encode(Encoder&, const WebCore::Style::RayFunction&);
    static std::optional<WebCore::Style::RayFunction> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Style::Ray> {
    static void encode(Encoder&, const WebCore::Style::Ray&);
    static std::optional<WebCore::Style::Ray> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::TextManipulationControllerExclusionRule::ElementRule> {
    static void encode(Encoder&, const WebCore::TextManipulationControllerExclusionRule::ElementRule&);
    static std::optional<WebCore::TextManipulationControllerExclusionRule::ElementRule> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::TextManipulationControllerExclusionRule::AttributeRule> {
    static void encode(Encoder&, const WebCore::TextManipulationControllerExclusionRule::AttributeRule&);
    static std::optional<WebCore::TextManipulationControllerExclusionRule::AttributeRule> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::TextManipulationControllerExclusionRule::ClassRule> {
    static void encode(Encoder&, const WebCore::TextManipulationControllerExclusionRule::ClassRule&);
    static std::optional<WebCore::TextManipulationControllerExclusionRule::ClassRule> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::ColorInterpolationMethod::HSL> {
    static void encode(Encoder&, const WebCore::ColorInterpolationMethod::HSL&);
    static void encode(StreamConnectionEncoder&, const WebCore::ColorInterpolationMethod::HSL&);
    static std::optional<WebCore::ColorInterpolationMethod::HSL> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::ColorInterpolationMethod::HWB> {
    static void encode(Encoder&, const WebCore::ColorInterpolationMethod::HWB&);
    static void encode(StreamConnectionEncoder&, const WebCore::ColorInterpolationMethod::HWB&);
    static std::optional<WebCore::ColorInterpolationMethod::HWB> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::ColorInterpolationMethod::LCH> {
    static void encode(Encoder&, const WebCore::ColorInterpolationMethod::LCH&);
    static void encode(StreamConnectionEncoder&, const WebCore::ColorInterpolationMethod::LCH&);
    static std::optional<WebCore::ColorInterpolationMethod::LCH> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::ColorInterpolationMethod::Lab> {
    static void encode(Encoder&, const WebCore::ColorInterpolationMethod::Lab&);
    static void encode(StreamConnectionEncoder&, const WebCore::ColorInterpolationMethod::Lab&);
    static std::optional<WebCore::ColorInterpolationMethod::Lab> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::ColorInterpolationMethod::OKLCH> {
    static void encode(Encoder&, const WebCore::ColorInterpolationMethod::OKLCH&);
    static void encode(StreamConnectionEncoder&, const WebCore::ColorInterpolationMethod::OKLCH&);
    static std::optional<WebCore::ColorInterpolationMethod::OKLCH> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::ColorInterpolationMethod::OKLab> {
    static void encode(Encoder&, const WebCore::ColorInterpolationMethod::OKLab&);
    static void encode(StreamConnectionEncoder&, const WebCore::ColorInterpolationMethod::OKLab&);
    static std::optional<WebCore::ColorInterpolationMethod::OKLab> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::ColorInterpolationMethod::SRGB> {
    static void encode(Encoder&, const WebCore::ColorInterpolationMethod::SRGB&);
    static void encode(StreamConnectionEncoder&, const WebCore::ColorInterpolationMethod::SRGB&);
    static std::optional<WebCore::ColorInterpolationMethod::SRGB> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::ColorInterpolationMethod::SRGBLinear> {
    static void encode(Encoder&, const WebCore::ColorInterpolationMethod::SRGBLinear&);
    static void encode(StreamConnectionEncoder&, const WebCore::ColorInterpolationMethod::SRGBLinear&);
    static std::optional<WebCore::ColorInterpolationMethod::SRGBLinear> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::ColorInterpolationMethod::DisplayP3> {
    static void encode(Encoder&, const WebCore::ColorInterpolationMethod::DisplayP3&);
    static void encode(StreamConnectionEncoder&, const WebCore::ColorInterpolationMethod::DisplayP3&);
    static std::optional<WebCore::ColorInterpolationMethod::DisplayP3> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::ColorInterpolationMethod::A98RGB> {
    static void encode(Encoder&, const WebCore::ColorInterpolationMethod::A98RGB&);
    static void encode(StreamConnectionEncoder&, const WebCore::ColorInterpolationMethod::A98RGB&);
    static std::optional<WebCore::ColorInterpolationMethod::A98RGB> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::ColorInterpolationMethod::ProPhotoRGB> {
    static void encode(Encoder&, const WebCore::ColorInterpolationMethod::ProPhotoRGB&);
    static void encode(StreamConnectionEncoder&, const WebCore::ColorInterpolationMethod::ProPhotoRGB&);
    static std::optional<WebCore::ColorInterpolationMethod::ProPhotoRGB> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::ColorInterpolationMethod::Rec2020> {
    static void encode(Encoder&, const WebCore::ColorInterpolationMethod::Rec2020&);
    static void encode(StreamConnectionEncoder&, const WebCore::ColorInterpolationMethod::Rec2020&);
    static std::optional<WebCore::ColorInterpolationMethod::Rec2020> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::ColorInterpolationMethod::XYZD50> {
    static void encode(Encoder&, const WebCore::ColorInterpolationMethod::XYZD50&);
    static void encode(StreamConnectionEncoder&, const WebCore::ColorInterpolationMethod::XYZD50&);
    static std::optional<WebCore::ColorInterpolationMethod::XYZD50> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::ColorInterpolationMethod::XYZD65> {
    static void encode(Encoder&, const WebCore::ColorInterpolationMethod::XYZD65&);
    static void encode(StreamConnectionEncoder&, const WebCore::ColorInterpolationMethod::XYZD65&);
    static std::optional<WebCore::ColorInterpolationMethod::XYZD65> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::SecurityOriginData::Tuple> {
    static void encode(Encoder&, const WebCore::SecurityOriginData::Tuple&);
    static std::optional<WebCore::SecurityOriginData::Tuple> decode(Decoder&);
};

#if ENABLE(MEDIA_STREAM)
template<> struct ArgumentCoder<WebCore::RealtimeMediaSourceCenter::ValidDevices> {
    static void encode(Encoder&, const WebCore::RealtimeMediaSourceCenter::ValidDevices&);
    static std::optional<WebCore::RealtimeMediaSourceCenter::ValidDevices> decode(Decoder&);
};
#endif

#if ENABLE(CONTENT_EXTENSIONS)
template<> struct ArgumentCoder<WebCore::ContentRuleListResults::Result> {
    static void encode(Encoder&, const WebCore::ContentRuleListResults::Result&);
    static std::optional<WebCore::ContentRuleListResults::Result> decode(Decoder&);
};
#endif

#if ENABLE(CONTENT_EXTENSIONS)
template<> struct ArgumentCoder<WebCore::ContentRuleListResults::Summary> {
    static void encode(Encoder&, const WebCore::ContentRuleListResults::Summary&);
    static std::optional<WebCore::ContentRuleListResults::Summary> decode(Decoder&);
};
#endif

template<> struct ArgumentCoder<WebCore::Region::Span> {
    static void encode(Encoder&, const WebCore::Region::Span&);
    static void encode(StreamConnectionEncoder&, const WebCore::Region::Span&);
    static std::optional<WebCore::Region::Span> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Region::Shape> {
    static void encode(Encoder&, const WebCore::Region::Shape&);
    static void encode(StreamConnectionEncoder&, const WebCore::Region::Shape&);
    static std::optional<WebCore::Region::Shape> decode(Decoder&);
};

#if ENABLE(WEB_AUTHN)
template<> struct ArgumentCoder<WebCore::MockWebAuthenticationConfiguration::LocalConfiguration> {
    static void encode(Encoder&, const WebCore::MockWebAuthenticationConfiguration::LocalConfiguration&);
    static std::optional<WebCore::MockWebAuthenticationConfiguration::LocalConfiguration> decode(Decoder&);
};
#endif

#if ENABLE(WEB_AUTHN)
template<> struct ArgumentCoder<WebCore::MockWebAuthenticationConfiguration::HidConfiguration> {
    static void encode(Encoder&, const WebCore::MockWebAuthenticationConfiguration::HidConfiguration&);
    static std::optional<WebCore::MockWebAuthenticationConfiguration::HidConfiguration> decode(Decoder&);
};
#endif

#if ENABLE(WEB_AUTHN)
template<> struct ArgumentCoder<WebCore::MockWebAuthenticationConfiguration::NfcConfiguration> {
    static void encode(Encoder&, const WebCore::MockWebAuthenticationConfiguration::NfcConfiguration&);
    static std::optional<WebCore::MockWebAuthenticationConfiguration::NfcConfiguration> decode(Decoder&);
};
#endif

#if ENABLE(WEB_AUTHN)
template<> struct ArgumentCoder<WebCore::MockWebAuthenticationConfiguration::CcidConfiguration> {
    static void encode(Encoder&, const WebCore::MockWebAuthenticationConfiguration::CcidConfiguration&);
    static std::optional<WebCore::MockWebAuthenticationConfiguration::CcidConfiguration> decode(Decoder&);
};
#endif

#if (ENABLE(WEB_AUTHN)) && (HAVE(DIGITAL_CREDENTIALS_UI))
template<> struct ArgumentCoder<WebCore::ISO18013ElementInfo> {
    static void encode(Encoder&, const WebCore::ISO18013ElementInfo&);
    static std::optional<WebCore::ISO18013ElementInfo> decode(Decoder&);
};
#endif

#if (ENABLE(WEB_AUTHN)) && (HAVE(DIGITAL_CREDENTIALS_UI))
template<> struct ArgumentCoder<WebCore::ISO18013DocumentRequest> {
    static void encode(Encoder&, const WebCore::ISO18013DocumentRequest&);
    static std::optional<WebCore::ISO18013DocumentRequest> decode(Decoder&);
};
#endif

#if (ENABLE(WEB_AUTHN)) && (HAVE(DIGITAL_CREDENTIALS_UI))
template<> struct ArgumentCoder<WebCore::ISO18013DocumentRequestSet> {
    static void encode(Encoder&, const WebCore::ISO18013DocumentRequestSet&);
    static std::optional<WebCore::ISO18013DocumentRequestSet> decode(Decoder&);
};
#endif

#if (ENABLE(WEB_AUTHN)) && (HAVE(DIGITAL_CREDENTIALS_UI))
template<> struct ArgumentCoder<WebCore::ISO18013PresentmentRequest> {
    static void encode(Encoder&, const WebCore::ISO18013PresentmentRequest&);
    static std::optional<WebCore::ISO18013PresentmentRequest> decode(Decoder&);
};
#endif

#if (ENABLE(WEB_AUTHN)) && (HAVE(DIGITAL_CREDENTIALS_UI))
template<> struct ArgumentCoder<WebCore::ValidatedMobileDocumentRequest> {
    static void encode(Encoder&, const WebCore::ValidatedMobileDocumentRequest&);
    static std::optional<WebCore::ValidatedMobileDocumentRequest> decode(Decoder&);
};
#endif

#if ENABLE(THREADED_ANIMATION_RESOLUTION)
template<> struct ArgumentCoder<WebCore::Constant<WebCore::CSSValueAuto>> {
    static void encode(Encoder&, const WebCore::Constant<WebCore::CSSValueAuto>&);
    static std::optional<WebCore::Constant<WebCore::CSSValueAuto>> decode(Decoder&);
};
#endif

#if ENABLE(THREADED_ANIMATION_RESOLUTION)
template<> struct ArgumentCoder<WebCore::AcceleratedEffect::Keyframe> {
    static void encode(Encoder&, const WebCore::AcceleratedEffect::Keyframe&);
    static std::optional<WebCore::AcceleratedEffect::Keyframe> decode(Decoder&);
};
#endif

template<> struct ArgumentCoder<WebCore::Credential::NonPlatformData> {
    static void encode(Encoder&, const WebCore::Credential::NonPlatformData&);
    static std::optional<WebCore::Credential::NonPlatformData> decode(Decoder&);
};

#if USE(SOUP)
template<> struct ArgumentCoder<WebCore::Credential::PlatformData> {
    static void encode(Encoder&, const WebCore::Credential::PlatformData&);
    static std::optional<WebCore::Credential::PlatformData> decode(Decoder&);
};
#endif

#if PLATFORM(IOS_FAMILY)
template<> struct ArgumentCoder<WebCore::InspectorOverlayLabel::Content::Decoration> {
    static void encode(Encoder&, const WebCore::InspectorOverlayLabel::Content::Decoration&);
    static std::optional<WebCore::InspectorOverlayLabel::Content::Decoration> decode(Decoder&);
};
#endif

#if PLATFORM(IOS_FAMILY)
template<> struct ArgumentCoder<WebCore::InspectorOverlayLabel::Content> {
    static void encode(Encoder&, const WebCore::InspectorOverlayLabel::Content&);
    static std::optional<WebCore::InspectorOverlayLabel::Content> decode(Decoder&);
};
#endif

#if PLATFORM(IOS_FAMILY)
template<> struct ArgumentCoder<WebCore::InspectorOverlayLabel::Arrow> {
    static void encode(Encoder&, const WebCore::InspectorOverlayLabel::Arrow&);
    static std::optional<WebCore::InspectorOverlayLabel::Arrow> decode(Decoder&);
};
#endif

#if PLATFORM(IOS_FAMILY)
template<> struct ArgumentCoder<WebCore::InspectorOverlayHighlight::FlexHighlightOverlay> {
    static void encode(Encoder&, const WebCore::InspectorOverlayHighlight::FlexHighlightOverlay&);
    static std::optional<WebCore::InspectorOverlayHighlight::FlexHighlightOverlay> decode(Decoder&);
};
#endif

#if PLATFORM(IOS_FAMILY)
template<> struct ArgumentCoder<WebCore::InspectorOverlayHighlight::GridHighlightOverlay::Area> {
    static void encode(Encoder&, const WebCore::InspectorOverlayHighlight::GridHighlightOverlay::Area&);
    static std::optional<WebCore::InspectorOverlayHighlight::GridHighlightOverlay::Area> decode(Decoder&);
};
#endif

#if PLATFORM(IOS_FAMILY)
template<> struct ArgumentCoder<WebCore::InspectorOverlayHighlight::GridHighlightOverlay> {
    static void encode(Encoder&, const WebCore::InspectorOverlayHighlight::GridHighlightOverlay&);
    static std::optional<WebCore::InspectorOverlayHighlight::GridHighlightOverlay> decode(Decoder&);
};
#endif

template<> struct ArgumentCoder<WebCore::SerializedScriptValue::Internals> {
    static void encode(Encoder&, const WebCore::SerializedScriptValue::Internals&);
    static std::optional<WebCore::SerializedScriptValue::Internals> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Cursor::CustomCursorIPCData> {
    static void encode(Encoder&, const WebCore::Cursor::CustomCursorIPCData&);
    static std::optional<WebCore::Cursor::CustomCursorIPCData> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Length::AutoData> {
    static void encode(Encoder&, const WebCore::Length::AutoData&);
    static std::optional<WebCore::Length::AutoData> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Length::NormalData> {
    static void encode(Encoder&, const WebCore::Length::NormalData&);
    static std::optional<WebCore::Length::NormalData> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Length::RelativeData> {
    static void encode(Encoder&, const WebCore::Length::RelativeData&);
    static std::optional<WebCore::Length::RelativeData> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Length::PercentData> {
    static void encode(Encoder&, const WebCore::Length::PercentData&);
    static std::optional<WebCore::Length::PercentData> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Length::FixedData> {
    static void encode(Encoder&, const WebCore::Length::FixedData&);
    static std::optional<WebCore::Length::FixedData> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Length::IntrinsicData> {
    static void encode(Encoder&, const WebCore::Length::IntrinsicData&);
    static std::optional<WebCore::Length::IntrinsicData> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Length::MinIntrinsicData> {
    static void encode(Encoder&, const WebCore::Length::MinIntrinsicData&);
    static std::optional<WebCore::Length::MinIntrinsicData> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Length::MinContentData> {
    static void encode(Encoder&, const WebCore::Length::MinContentData&);
    static std::optional<WebCore::Length::MinContentData> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Length::MaxContentData> {
    static void encode(Encoder&, const WebCore::Length::MaxContentData&);
    static std::optional<WebCore::Length::MaxContentData> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Length::FillAvailableData> {
    static void encode(Encoder&, const WebCore::Length::FillAvailableData&);
    static std::optional<WebCore::Length::FillAvailableData> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Length::FitContentData> {
    static void encode(Encoder&, const WebCore::Length::FitContentData&);
    static std::optional<WebCore::Length::FitContentData> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Length::ContentData> {
    static void encode(Encoder&, const WebCore::Length::ContentData&);
    static std::optional<WebCore::Length::ContentData> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Length::UndefinedData> {
    static void encode(Encoder&, const WebCore::Length::UndefinedData&);
    static std::optional<WebCore::Length::UndefinedData> decode(Decoder&);
};

#if ENABLE(VIDEO)
template<> struct ArgumentCoder<WebCore::SerializedPlatformDataCueValue::Data> {
    static void encode(Encoder&, const WebCore::SerializedPlatformDataCueValue::Data&);
    static std::optional<WebCore::SerializedPlatformDataCueValue::Data> decode(Decoder&);
};
#endif

template<> struct ArgumentCoder<WebCore::Allowlist::AllowAllOrigins> {
    static void encode(Encoder&, const WebCore::Allowlist::AllowAllOrigins&);
    static std::optional<WebCore::Allowlist::AllowAllOrigins> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::MediaSamplesBlock::MediaSampleItem> {
    static void encode(Encoder&, const WebCore::MediaSamplesBlock::MediaSampleItem&);
    static std::optional<WebCore::MediaSamplesBlock::MediaSampleItem> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::RectEdges<WebCore::FixedContainerEdge>> {
    static void encode(Encoder&, const WebCore::RectEdges<WebCore::FixedContainerEdge>&);
    static std::optional<WebCore::RectEdges<WebCore::FixedContainerEdge>> decode(Decoder&);
};

template<> struct ArgumentCoder<WebKit::WebFoundTextRange::DOMData> {
    static void encode(Encoder&, const WebKit::WebFoundTextRange::DOMData&);
    static std::optional<WebKit::WebFoundTextRange::DOMData> decode(Decoder&);
};

template<> struct ArgumentCoder<WebKit::WebFoundTextRange::PDFData> {
    static void encode(Encoder&, const WebKit::WebFoundTextRange::PDFData&);
    static std::optional<WebKit::WebFoundTextRange::PDFData> decode(Decoder&);
};

template<> struct ArgumentCoder<WebKit::RemotePageParameters> {
    static void encode(Encoder&, const WebKit::RemotePageParameters&);
    static std::optional<WebKit::RemotePageParameters> decode(Decoder&);
};

template<> struct ArgumentCoder<WebKit::WebsiteData::Entry> {
    static void encode(Encoder&, const WebKit::WebsiteData::Entry&);
    static std::optional<WebKit::WebsiteData::Entry> decode(Decoder&);
};

#if ENABLE(WEBXR)
template<> struct ArgumentCoder<PlatformXR::DepthRange> {
    static void encode(Encoder&, const PlatformXR::DepthRange&);
    static std::optional<PlatformXR::DepthRange> decode(Decoder&);
};
#endif

#if ENABLE(WEBXR)
template<> struct ArgumentCoder<PlatformXR::FrameData::FloatQuaternion> {
    static void encode(Encoder&, const PlatformXR::FrameData::FloatQuaternion&);
    static std::optional<PlatformXR::FrameData::FloatQuaternion> decode(Decoder&);
};
#endif

#if ENABLE(WEBXR)
template<> struct ArgumentCoder<PlatformXR::FrameData::Pose> {
    static void encode(Encoder&, const PlatformXR::FrameData::Pose&);
    static std::optional<PlatformXR::FrameData::Pose> decode(Decoder&);
};
#endif

#if ENABLE(WEBXR)
template<> struct ArgumentCoder<PlatformXR::FrameData::Fov> {
    static void encode(Encoder&, const PlatformXR::FrameData::Fov&);
    static std::optional<PlatformXR::FrameData::Fov> decode(Decoder&);
};
#endif

#if ENABLE(WEBXR)
template<> struct ArgumentCoder<PlatformXR::FrameData::View> {
    static void encode(Encoder&, const PlatformXR::FrameData::View&);
    static std::optional<PlatformXR::FrameData::View> decode(Decoder&);
};
#endif

#if ENABLE(WEBXR)
template<> struct ArgumentCoder<PlatformXR::FrameData::StageParameters> {
    static void encode(Encoder&, const PlatformXR::FrameData::StageParameters&);
    static std::optional<PlatformXR::FrameData::StageParameters> decode(Decoder&);
};
#endif

#if ENABLE(WEBXR)
template<> struct ArgumentCoder<PlatformXR::FrameData::RateMapDescription> {
    static void encode(Encoder&, const PlatformXR::FrameData::RateMapDescription&);
    static std::optional<PlatformXR::FrameData::RateMapDescription> decode(Decoder&);
};
#endif

#if ENABLE(WEBXR)
template<> struct ArgumentCoder<PlatformXR::FrameData::LayerSetupData> {
    static void encode(Encoder&, PlatformXR::FrameData::LayerSetupData&&);
    static std::optional<PlatformXR::FrameData::LayerSetupData> decode(Decoder&);
};
#endif

#if ENABLE(WEBXR)
template<> struct ArgumentCoder<PlatformXR::FrameData::ExternalTexture> {
    static void encode(Encoder&, PlatformXR::FrameData::ExternalTexture&&);
    static std::optional<PlatformXR::FrameData::ExternalTexture> decode(Decoder&);
};
#endif

#if ENABLE(WEBXR)
template<> struct ArgumentCoder<PlatformXR::FrameData::ExternalTextureData> {
    static void encode(Encoder&, PlatformXR::FrameData::ExternalTextureData&&);
    static std::optional<PlatformXR::FrameData::ExternalTextureData> decode(Decoder&);
};
#endif

#if ENABLE(WEBXR)
template<> struct ArgumentCoder<PlatformXR::FrameData::LayerData> {
    static void encode(Encoder&, PlatformXR::FrameData::LayerData&&);
    static std::optional<PlatformXR::FrameData::LayerData> decode(Decoder&);
};
#endif

#if ENABLE(WEBXR)
template<> struct ArgumentCoder<PlatformXR::FrameData::InputSourceButton> {
    static void encode(Encoder&, const PlatformXR::FrameData::InputSourceButton&);
    static std::optional<PlatformXR::FrameData::InputSourceButton> decode(Decoder&);
};
#endif

#if ENABLE(WEBXR)
template<> struct ArgumentCoder<PlatformXR::FrameData::InputSourcePose> {
    static void encode(Encoder&, const PlatformXR::FrameData::InputSourcePose&);
    static std::optional<PlatformXR::FrameData::InputSourcePose> decode(Decoder&);
};
#endif

#if ENABLE(WEBXR_HANDS)
template<> struct ArgumentCoder<PlatformXR::FrameData::InputSourceHandJoint> {
    static void encode(Encoder&, const PlatformXR::FrameData::InputSourceHandJoint&);
    static std::optional<PlatformXR::FrameData::InputSourceHandJoint> decode(Decoder&);
};
#endif

#if ENABLE(WEBXR)
template<> struct ArgumentCoder<PlatformXR::FrameData::InputSource> {
    static void encode(Encoder&, const PlatformXR::FrameData::InputSource&);
    static std::optional<PlatformXR::FrameData::InputSource> decode(Decoder&);
};
#endif

#if (ENABLE(WEBXR)) && (USE(OPENXR))
template<> struct ArgumentCoder<PlatformXR::Device::LayerView> {
    static void encode(Encoder&, const PlatformXR::Device::LayerView&);
    static std::optional<PlatformXR::Device::LayerView> decode(Decoder&);
};
#endif

#if USE(SKIA)
template<> struct ArgumentCoder<SkFontStyle::Slant> {
    static void encode(Encoder&, const SkFontStyle::Slant&);
    static std::optional<SkFontStyle::Slant> decode(Decoder&);
};
#endif

template<> struct ArgumentCoder<WebKit::RendererBufferFormat::Format> {
    static void encode(Encoder&, const WebKit::RendererBufferFormat::Format&);
    static std::optional<WebKit::RendererBufferFormat::Format> decode(Decoder&);
};

template<> struct ArgumentCoder<WebKit::UserMessage::NullMessage> {
    static void encode(Encoder&, const WebKit::UserMessage::NullMessage&);
    static std::optional<WebKit::UserMessage::NullMessage> decode(Decoder&);
};

template<> struct ArgumentCoder<WebKit::UserMessage::ErrorMessage> {
    static void encode(Encoder&, const WebKit::UserMessage::ErrorMessage&);
    static std::optional<WebKit::UserMessage::ErrorMessage> decode(Decoder&);
};

template<> struct ArgumentCoder<WebKit::UserMessage::DataMessage> {
    static void encode(Encoder&, const WebKit::UserMessage::DataMessage&);
    static std::optional<WebKit::UserMessage::DataMessage> decode(Decoder&);
};

#if ENABLE(GPU_PROCESS)
void ArgumentCoder<WebKit::GPUProcessCreationParameters>::encode(Encoder& encoder, WebKit::GPUProcessCreationParameters&& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.auxiliaryProcessParameters)>, WebKit::AuxiliaryProcessCreationParameters>);
#if ENABLE(MEDIA_STREAM)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.useMockCaptureDevices)>, bool>);
#endif
#if (ENABLE(MEDIA_STREAM)) && (PLATFORM(MAC))
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.microphoneSandboxExtensionHandle)>, WebKit::SandboxExtensionHandle>);
#endif
#if (ENABLE(MEDIA_STREAM)) && (PLATFORM(MAC))
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.launchServicesExtensionHandle)>, WebKit::SandboxExtensionHandle>);
#endif
#if USE(MODERN_AVCONTENTKEYSESSION)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.shouldUseModernAVContentKeySession)>, bool>);
#endif
#if USE(SANDBOX_EXTENSIONS_FOR_CACHE_AND_TEMP_DIRECTORY_ACCESS)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.containerCachesDirectoryExtensionHandle)>, WebKit::SandboxExtensionHandle>);
#endif
#if USE(SANDBOX_EXTENSIONS_FOR_CACHE_AND_TEMP_DIRECTORY_ACCESS)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.containerTemporaryDirectoryExtensionHandle)>, WebKit::SandboxExtensionHandle>);
#endif
#if USE(SANDBOX_EXTENSIONS_FOR_CACHE_AND_TEMP_DIRECTORY_ACCESS)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.containerCachesDirectory)>, String>);
#endif
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.mobileGestaltExtensionHandle)>, std::optional<WebKit::SandboxExtensionHandle>>);
#if PLATFORM(COCOA) && ENABLE(REMOTE_INSPECTOR)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.gpuToolsExtensionHandles)>, Vector<WebKit::SandboxExtensionHandle>>);
#endif
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.applicationVisibleName)>, String>);
#if USE(GBM)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.drmDevice)>, WebCore::DRMDevice>);
#endif
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.overrideLanguages)>, Vector<String>>);
#if PLATFORM(COCOA)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.enableMetalDebugDeviceForTesting)>, bool>);
#endif
#if PLATFORM(COCOA)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.enableMetalShaderValidationForTesting)>, bool>);
#endif
    struct ShouldBeSameSizeAsGPUProcessCreationParameters : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::GPUProcessCreationParameters>, false> {
        WebKit::AuxiliaryProcessCreationParameters auxiliaryProcessParameters;
#if ENABLE(MEDIA_STREAM)
        bool useMockCaptureDevices;
#endif
#if (ENABLE(MEDIA_STREAM)) && (PLATFORM(MAC))
        WebKit::SandboxExtensionHandle microphoneSandboxExtensionHandle;
#endif
#if (ENABLE(MEDIA_STREAM)) && (PLATFORM(MAC))
        WebKit::SandboxExtensionHandle launchServicesExtensionHandle;
#endif
#if USE(MODERN_AVCONTENTKEYSESSION)
        bool shouldUseModernAVContentKeySession;
#endif
#if USE(SANDBOX_EXTENSIONS_FOR_CACHE_AND_TEMP_DIRECTORY_ACCESS)
        WebKit::SandboxExtensionHandle containerCachesDirectoryExtensionHandle;
#endif
#if USE(SANDBOX_EXTENSIONS_FOR_CACHE_AND_TEMP_DIRECTORY_ACCESS)
        WebKit::SandboxExtensionHandle containerTemporaryDirectoryExtensionHandle;
#endif
#if USE(SANDBOX_EXTENSIONS_FOR_CACHE_AND_TEMP_DIRECTORY_ACCESS)
        String containerCachesDirectory;
#endif
        std::optional<WebKit::SandboxExtensionHandle> mobileGestaltExtensionHandle;
#if PLATFORM(COCOA) && ENABLE(REMOTE_INSPECTOR)
        Vector<WebKit::SandboxExtensionHandle> gpuToolsExtensionHandles;
#endif
        String applicationVisibleName;
#if USE(GBM)
        WebCore::DRMDevice drmDevice;
#endif
        Vector<String> overrideLanguages;
#if PLATFORM(COCOA)
        bool enableMetalDebugDeviceForTesting;
#endif
#if PLATFORM(COCOA)
        bool enableMetalShaderValidationForTesting;
#endif
    };
    static_assert(sizeof(ShouldBeSameSizeAsGPUProcessCreationParameters) == sizeof(WebKit::GPUProcessCreationParameters));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::GPUProcessCreationParameters, auxiliaryProcessParameters)
#if ENABLE(MEDIA_STREAM)
        , offsetof(WebKit::GPUProcessCreationParameters, useMockCaptureDevices)
#endif
#if (ENABLE(MEDIA_STREAM)) && (PLATFORM(MAC))
        , offsetof(WebKit::GPUProcessCreationParameters, microphoneSandboxExtensionHandle)
#endif
#if (ENABLE(MEDIA_STREAM)) && (PLATFORM(MAC))
        , offsetof(WebKit::GPUProcessCreationParameters, launchServicesExtensionHandle)
#endif
#if USE(MODERN_AVCONTENTKEYSESSION)
        , offsetof(WebKit::GPUProcessCreationParameters, shouldUseModernAVContentKeySession)
#endif
#if USE(SANDBOX_EXTENSIONS_FOR_CACHE_AND_TEMP_DIRECTORY_ACCESS)
        , offsetof(WebKit::GPUProcessCreationParameters, containerCachesDirectoryExtensionHandle)
#endif
#if USE(SANDBOX_EXTENSIONS_FOR_CACHE_AND_TEMP_DIRECTORY_ACCESS)
        , offsetof(WebKit::GPUProcessCreationParameters, containerTemporaryDirectoryExtensionHandle)
#endif
#if USE(SANDBOX_EXTENSIONS_FOR_CACHE_AND_TEMP_DIRECTORY_ACCESS)
        , offsetof(WebKit::GPUProcessCreationParameters, containerCachesDirectory)
#endif
        , offsetof(WebKit::GPUProcessCreationParameters, mobileGestaltExtensionHandle)
#if PLATFORM(COCOA) && ENABLE(REMOTE_INSPECTOR)
        , offsetof(WebKit::GPUProcessCreationParameters, gpuToolsExtensionHandles)
#endif
        , offsetof(WebKit::GPUProcessCreationParameters, applicationVisibleName)
#if USE(GBM)
        , offsetof(WebKit::GPUProcessCreationParameters, drmDevice)
#endif
        , offsetof(WebKit::GPUProcessCreationParameters, overrideLanguages)
#if PLATFORM(COCOA)
        , offsetof(WebKit::GPUProcessCreationParameters, enableMetalDebugDeviceForTesting)
#endif
#if PLATFORM(COCOA)
        , offsetof(WebKit::GPUProcessCreationParameters, enableMetalShaderValidationForTesting)
#endif
    >::value);

    encoder << WTFMove(instance.auxiliaryProcessParameters);
#if ENABLE(MEDIA_STREAM)
    encoder << WTFMove(instance.useMockCaptureDevices);
#endif
#if (ENABLE(MEDIA_STREAM)) && (PLATFORM(MAC))
    encoder << WTFMove(instance.microphoneSandboxExtensionHandle);
#endif
#if (ENABLE(MEDIA_STREAM)) && (PLATFORM(MAC))
    encoder << WTFMove(instance.launchServicesExtensionHandle);
#endif
#if USE(MODERN_AVCONTENTKEYSESSION)
    encoder << WTFMove(instance.shouldUseModernAVContentKeySession);
#endif
#if USE(SANDBOX_EXTENSIONS_FOR_CACHE_AND_TEMP_DIRECTORY_ACCESS)
    encoder << WTFMove(instance.containerCachesDirectoryExtensionHandle);
#endif
#if USE(SANDBOX_EXTENSIONS_FOR_CACHE_AND_TEMP_DIRECTORY_ACCESS)
    encoder << WTFMove(instance.containerTemporaryDirectoryExtensionHandle);
#endif
#if USE(SANDBOX_EXTENSIONS_FOR_CACHE_AND_TEMP_DIRECTORY_ACCESS)
    encoder << WTFMove(instance.containerCachesDirectory);
#endif
    encoder << WTFMove(instance.mobileGestaltExtensionHandle);
#if PLATFORM(COCOA) && ENABLE(REMOTE_INSPECTOR)
    encoder << WTFMove(instance.gpuToolsExtensionHandles);
#endif
    encoder << WTFMove(instance.applicationVisibleName);
#if USE(GBM)
    encoder << WTFMove(instance.drmDevice);
#endif
    encoder << WTFMove(instance.overrideLanguages);
#if PLATFORM(COCOA)
    encoder << WTFMove(instance.enableMetalDebugDeviceForTesting);
#endif
#if PLATFORM(COCOA)
    encoder << WTFMove(instance.enableMetalShaderValidationForTesting);
#endif
}

std::optional<WebKit::GPUProcessCreationParameters> ArgumentCoder<WebKit::GPUProcessCreationParameters>::decode(Decoder& decoder)
{
    bool addedDecodingFailureIndex = false;
    auto auxiliaryProcessParameters = decoder.decode<WebKit::AuxiliaryProcessCreationParameters>();
    if (!auxiliaryProcessParameters && !addedDecodingFailureIndex) [[unlikely]] {
        decoder.addIndexOfDecodingFailure(0);
        addedDecodingFailureIndex = true;
    }
#if ENABLE(MEDIA_STREAM)
    auto useMockCaptureDevices = decoder.decode<bool>();
    if (!useMockCaptureDevices && !addedDecodingFailureIndex) [[unlikely]] {
        decoder.addIndexOfDecodingFailure(1);
        addedDecodingFailureIndex = true;
    }
#endif
#if (ENABLE(MEDIA_STREAM)) && (PLATFORM(MAC))
    auto microphoneSandboxExtensionHandle = decoder.decode<WebKit::SandboxExtensionHandle>();
    if (!microphoneSandboxExtensionHandle && !addedDecodingFailureIndex) [[unlikely]] {
        decoder.addIndexOfDecodingFailure(2);
        addedDecodingFailureIndex = true;
    }
#endif
#if (ENABLE(MEDIA_STREAM)) && (PLATFORM(MAC))
    auto launchServicesExtensionHandle = decoder.decode<WebKit::SandboxExtensionHandle>();
    if (!launchServicesExtensionHandle && !addedDecodingFailureIndex) [[unlikely]] {
        decoder.addIndexOfDecodingFailure(3);
        addedDecodingFailureIndex = true;
    }
#endif
#if USE(MODERN_AVCONTENTKEYSESSION)
    auto shouldUseModernAVContentKeySession = decoder.decode<bool>();
    if (!shouldUseModernAVContentKeySession && !addedDecodingFailureIndex) [[unlikely]] {
        decoder.addIndexOfDecodingFailure(4);
        addedDecodingFailureIndex = true;
    }
#endif
#if USE(SANDBOX_EXTENSIONS_FOR_CACHE_AND_TEMP_DIRECTORY_ACCESS)
    auto containerCachesDirectoryExtensionHandle = decoder.decode<WebKit::SandboxExtensionHandle>();
    if (!containerCachesDirectoryExtensionHandle && !addedDecodingFailureIndex) [[unlikely]] {
        decoder.addIndexOfDecodingFailure(5);
        addedDecodingFailureIndex = true;
    }
#endif
#if USE(SANDBOX_EXTENSIONS_FOR_CACHE_AND_TEMP_DIRECTORY_ACCESS)
    auto containerTemporaryDirectoryExtensionHandle = decoder.decode<WebKit::SandboxExtensionHandle>();
    if (!containerTemporaryDirectoryExtensionHandle && !addedDecodingFailureIndex) [[unlikely]] {
        decoder.addIndexOfDecodingFailure(6);
        addedDecodingFailureIndex = true;
    }
#endif
#if USE(SANDBOX_EXTENSIONS_FOR_CACHE_AND_TEMP_DIRECTORY_ACCESS)
    auto containerCachesDirectory = decoder.decode<String>();
    if (!containerCachesDirectory && !addedDecodingFailureIndex) [[unlikely]] {
        decoder.addIndexOfDecodingFailure(7);
        addedDecodingFailureIndex = true;
    }
#endif
    auto mobileGestaltExtensionHandle = decoder.decode<std::optional<WebKit::SandboxExtensionHandle>>();
    if (!mobileGestaltExtensionHandle && !addedDecodingFailureIndex) [[unlikely]] {
        decoder.addIndexOfDecodingFailure(8);
        addedDecodingFailureIndex = true;
    }
#if PLATFORM(COCOA) && ENABLE(REMOTE_INSPECTOR)
    auto gpuToolsExtensionHandles = decoder.decode<Vector<WebKit::SandboxExtensionHandle>>();
    if (!gpuToolsExtensionHandles && !addedDecodingFailureIndex) [[unlikely]] {
        decoder.addIndexOfDecodingFailure(9);
        addedDecodingFailureIndex = true;
    }
#endif
    auto applicationVisibleName = decoder.decode<String>();
    if (!applicationVisibleName && !addedDecodingFailureIndex) [[unlikely]] {
        decoder.addIndexOfDecodingFailure(10);
        addedDecodingFailureIndex = true;
    }
#if USE(GBM)
    auto drmDevice = decoder.decode<WebCore::DRMDevice>();
    if (!drmDevice && !addedDecodingFailureIndex) [[unlikely]] {
        decoder.addIndexOfDecodingFailure(11);
        addedDecodingFailureIndex = true;
    }
#endif
    auto overrideLanguages = decoder.decode<Vector<String>>();
    if (!overrideLanguages && !addedDecodingFailureIndex) [[unlikely]] {
        decoder.addIndexOfDecodingFailure(12);
        addedDecodingFailureIndex = true;
    }
#if PLATFORM(COCOA)
    auto enableMetalDebugDeviceForTesting = decoder.decode<bool>();
    if (!enableMetalDebugDeviceForTesting && !addedDecodingFailureIndex) [[unlikely]] {
        decoder.addIndexOfDecodingFailure(13);
        addedDecodingFailureIndex = true;
    }
#endif
#if PLATFORM(COCOA)
    auto enableMetalShaderValidationForTesting = decoder.decode<bool>();
    if (!enableMetalShaderValidationForTesting && !addedDecodingFailureIndex) [[unlikely]] {
        decoder.addIndexOfDecodingFailure(14);
        addedDecodingFailureIndex = true;
    }
#endif
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebKit::GPUProcessCreationParameters {
            WTFMove(*auxiliaryProcessParameters),
#if ENABLE(MEDIA_STREAM)
            WTFMove(*useMockCaptureDevices),
#endif
#if (ENABLE(MEDIA_STREAM)) && (PLATFORM(MAC))
            WTFMove(*microphoneSandboxExtensionHandle),
#endif
#if (ENABLE(MEDIA_STREAM)) && (PLATFORM(MAC))
            WTFMove(*launchServicesExtensionHandle),
#endif
#if USE(MODERN_AVCONTENTKEYSESSION)
            WTFMove(*shouldUseModernAVContentKeySession),
#endif
#if USE(SANDBOX_EXTENSIONS_FOR_CACHE_AND_TEMP_DIRECTORY_ACCESS)
            WTFMove(*containerCachesDirectoryExtensionHandle),
#endif
#if USE(SANDBOX_EXTENSIONS_FOR_CACHE_AND_TEMP_DIRECTORY_ACCESS)
            WTFMove(*containerTemporaryDirectoryExtensionHandle),
#endif
#if USE(SANDBOX_EXTENSIONS_FOR_CACHE_AND_TEMP_DIRECTORY_ACCESS)
            WTFMove(*containerCachesDirectory),
#endif
            WTFMove(*mobileGestaltExtensionHandle),
#if PLATFORM(COCOA) && ENABLE(REMOTE_INSPECTOR)
            WTFMove(*gpuToolsExtensionHandles),
#endif
            WTFMove(*applicationVisibleName),
#if USE(GBM)
            WTFMove(*drmDevice),
#endif
            WTFMove(*overrideLanguages),
#if PLATFORM(COCOA)
            WTFMove(*enableMetalDebugDeviceForTesting),
#endif
#if PLATFORM(COCOA)
            WTFMove(*enableMetalShaderValidationForTesting)
#endif
        }
    };
}

#endif

#if ENABLE(GPU_PROCESS)
void ArgumentCoder<WebKit::GPUProcessPreferences>::encode(Encoder& encoder, const WebKit::GPUProcessPreferences& instance)
{
#if USE(MODERN_AVCONTENTKEYSESSION)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.shouldUseModernAVContentKeySession)>, std::optional<bool>>);
#endif
#if ENABLE(VP9)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.vp9DecoderEnabled)>, std::optional<bool>>);
#endif
#if ENABLE(VP9)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.swVPDecodersAlwaysEnabled)>, bool>);
#endif
    struct ShouldBeSameSizeAsGPUProcessPreferences : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::GPUProcessPreferences>, false> {
#if USE(MODERN_AVCONTENTKEYSESSION)
        std::optional<bool> shouldUseModernAVContentKeySession;
#endif
#if ENABLE(VP9)
        std::optional<bool> vp9DecoderEnabled;
#endif
#if ENABLE(VP9)
        bool swVPDecodersAlwaysEnabled;
#endif
    };
    static_assert(sizeof(ShouldBeSameSizeAsGPUProcessPreferences) == sizeof(WebKit::GPUProcessPreferences));
    static_assert(MembersInCorrectOrder < 0
#if USE(MODERN_AVCONTENTKEYSESSION)
        , offsetof(WebKit::GPUProcessPreferences, shouldUseModernAVContentKeySession)
#endif
#if ENABLE(VP9)
        , offsetof(WebKit::GPUProcessPreferences, vp9DecoderEnabled)
#endif
#if ENABLE(VP9)
        , offsetof(WebKit::GPUProcessPreferences, swVPDecodersAlwaysEnabled)
#endif
    >::value);

#if USE(MODERN_AVCONTENTKEYSESSION)
    encoder << instance.shouldUseModernAVContentKeySession;
#endif
#if ENABLE(VP9)
    encoder << instance.vp9DecoderEnabled;
#endif
#if ENABLE(VP9)
    encoder << instance.swVPDecodersAlwaysEnabled;
#endif
}

std::optional<WebKit::GPUProcessPreferences> ArgumentCoder<WebKit::GPUProcessPreferences>::decode(Decoder& decoder)
{
#if USE(MODERN_AVCONTENTKEYSESSION)
    auto shouldUseModernAVContentKeySession = decoder.decode<std::optional<bool>>();
#endif
#if ENABLE(VP9)
    auto vp9DecoderEnabled = decoder.decode<std::optional<bool>>();
#endif
#if ENABLE(VP9)
    auto swVPDecodersAlwaysEnabled = decoder.decode<bool>();
#endif
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebKit::GPUProcessPreferences {
#if USE(MODERN_AVCONTENTKEYSESSION)
            WTFMove(*shouldUseModernAVContentKeySession),
#endif
#if ENABLE(VP9)
            WTFMove(*vp9DecoderEnabled),
#endif
#if ENABLE(VP9)
            WTFMove(*swVPDecodersAlwaysEnabled)
#endif
        }
    };
}

#endif

#if ENABLE(GPU_PROCESS)
void ArgumentCoder<WebKit::GPUProcessSessionParameters>::encode(Encoder& encoder, WebKit::GPUProcessSessionParameters&& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.mediaCacheDirectory)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.mediaCacheDirectorySandboxExtensionHandle)>, WebKit::SandboxExtensionHandle>);
#if ENABLE(LEGACY_ENCRYPTED_MEDIA) || ENABLE(ENCRYPTED_MEDIA)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.mediaKeysStorageDirectory)>, String>);
#endif
#if ENABLE(LEGACY_ENCRYPTED_MEDIA) || ENABLE(ENCRYPTED_MEDIA)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.mediaKeysStorageDirectorySandboxExtensionHandle)>, WebKit::SandboxExtensionHandle>);
#endif
    struct ShouldBeSameSizeAsGPUProcessSessionParameters : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::GPUProcessSessionParameters>, false> {
        String mediaCacheDirectory;
        WebKit::SandboxExtensionHandle mediaCacheDirectorySandboxExtensionHandle;
#if ENABLE(LEGACY_ENCRYPTED_MEDIA) || ENABLE(ENCRYPTED_MEDIA)
        String mediaKeysStorageDirectory;
#endif
#if ENABLE(LEGACY_ENCRYPTED_MEDIA) || ENABLE(ENCRYPTED_MEDIA)
        WebKit::SandboxExtensionHandle mediaKeysStorageDirectorySandboxExtensionHandle;
#endif
    };
    static_assert(sizeof(ShouldBeSameSizeAsGPUProcessSessionParameters) == sizeof(WebKit::GPUProcessSessionParameters));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::GPUProcessSessionParameters, mediaCacheDirectory)
        , offsetof(WebKit::GPUProcessSessionParameters, mediaCacheDirectorySandboxExtensionHandle)
#if ENABLE(LEGACY_ENCRYPTED_MEDIA) || ENABLE(ENCRYPTED_MEDIA)
        , offsetof(WebKit::GPUProcessSessionParameters, mediaKeysStorageDirectory)
#endif
#if ENABLE(LEGACY_ENCRYPTED_MEDIA) || ENABLE(ENCRYPTED_MEDIA)
        , offsetof(WebKit::GPUProcessSessionParameters, mediaKeysStorageDirectorySandboxExtensionHandle)
#endif
    >::value);

    encoder << WTFMove(instance.mediaCacheDirectory);
    encoder << WTFMove(instance.mediaCacheDirectorySandboxExtensionHandle);
#if ENABLE(LEGACY_ENCRYPTED_MEDIA) || ENABLE(ENCRYPTED_MEDIA)
    encoder << WTFMove(instance.mediaKeysStorageDirectory);
#endif
#if ENABLE(LEGACY_ENCRYPTED_MEDIA) || ENABLE(ENCRYPTED_MEDIA)
    encoder << WTFMove(instance.mediaKeysStorageDirectorySandboxExtensionHandle);
#endif
}

std::optional<WebKit::GPUProcessSessionParameters> ArgumentCoder<WebKit::GPUProcessSessionParameters>::decode(Decoder& decoder)
{
    auto mediaCacheDirectory = decoder.decode<String>();
    auto mediaCacheDirectorySandboxExtensionHandle = decoder.decode<WebKit::SandboxExtensionHandle>();
#if ENABLE(LEGACY_ENCRYPTED_MEDIA) || ENABLE(ENCRYPTED_MEDIA)
    auto mediaKeysStorageDirectory = decoder.decode<String>();
#endif
#if ENABLE(LEGACY_ENCRYPTED_MEDIA) || ENABLE(ENCRYPTED_MEDIA)
    auto mediaKeysStorageDirectorySandboxExtensionHandle = decoder.decode<WebKit::SandboxExtensionHandle>();
#endif
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebKit::GPUProcessSessionParameters {
            WTFMove(*mediaCacheDirectory),
            WTFMove(*mediaCacheDirectorySandboxExtensionHandle),
#if ENABLE(LEGACY_ENCRYPTED_MEDIA) || ENABLE(ENCRYPTED_MEDIA)
            WTFMove(*mediaKeysStorageDirectory),
#endif
#if ENABLE(LEGACY_ENCRYPTED_MEDIA) || ENABLE(ENCRYPTED_MEDIA)
            WTFMove(*mediaKeysStorageDirectorySandboxExtensionHandle)
#endif
        }
    };
}

#endif

void ArgumentCoder<WebCore::PathMoveTo>::encode(Encoder& encoder, const WebCore::PathMoveTo& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.point)>, WebCore::FloatPoint>);
    struct ShouldBeSameSizeAsPathMoveTo : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::PathMoveTo>, false> {
        WebCore::FloatPoint point;
    };
    static_assert(sizeof(ShouldBeSameSizeAsPathMoveTo) == sizeof(WebCore::PathMoveTo));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::PathMoveTo, point)
    >::value);

    encoder << instance.point;
}

void ArgumentCoder<WebCore::PathMoveTo>::encode(StreamConnectionEncoder& encoder, const WebCore::PathMoveTo& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.point)>, WebCore::FloatPoint>);
    struct ShouldBeSameSizeAsPathMoveTo : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::PathMoveTo>, false> {
        WebCore::FloatPoint point;
    };
    static_assert(sizeof(ShouldBeSameSizeAsPathMoveTo) == sizeof(WebCore::PathMoveTo));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::PathMoveTo, point)
    >::value);

    encoder << instance.point;
}

std::optional<WebCore::PathMoveTo> ArgumentCoder<WebCore::PathMoveTo>::decode(Decoder& decoder)
{
    auto point = decoder.decode<WebCore::FloatPoint>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::PathMoveTo {
            WTFMove(*point)
        }
    };
}

void ArgumentCoder<WebCore::PathLineTo>::encode(Encoder& encoder, const WebCore::PathLineTo& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.point)>, WebCore::FloatPoint>);
    struct ShouldBeSameSizeAsPathLineTo : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::PathLineTo>, false> {
        WebCore::FloatPoint point;
    };
    static_assert(sizeof(ShouldBeSameSizeAsPathLineTo) == sizeof(WebCore::PathLineTo));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::PathLineTo, point)
    >::value);

    encoder << instance.point;
}

void ArgumentCoder<WebCore::PathLineTo>::encode(StreamConnectionEncoder& encoder, const WebCore::PathLineTo& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.point)>, WebCore::FloatPoint>);
    struct ShouldBeSameSizeAsPathLineTo : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::PathLineTo>, false> {
        WebCore::FloatPoint point;
    };
    static_assert(sizeof(ShouldBeSameSizeAsPathLineTo) == sizeof(WebCore::PathLineTo));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::PathLineTo, point)
    >::value);

    encoder << instance.point;
}

std::optional<WebCore::PathLineTo> ArgumentCoder<WebCore::PathLineTo>::decode(Decoder& decoder)
{
    auto point = decoder.decode<WebCore::FloatPoint>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::PathLineTo {
            WTFMove(*point)
        }
    };
}

void ArgumentCoder<WebCore::PathQuadCurveTo>::encode(Encoder& encoder, const WebCore::PathQuadCurveTo& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.controlPoint)>, WebCore::FloatPoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.endPoint)>, WebCore::FloatPoint>);
    struct ShouldBeSameSizeAsPathQuadCurveTo : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::PathQuadCurveTo>, false> {
        WebCore::FloatPoint controlPoint;
        WebCore::FloatPoint endPoint;
    };
    static_assert(sizeof(ShouldBeSameSizeAsPathQuadCurveTo) == sizeof(WebCore::PathQuadCurveTo));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::PathQuadCurveTo, controlPoint)
        , offsetof(WebCore::PathQuadCurveTo, endPoint)
    >::value);

    encoder << instance.controlPoint;
    encoder << instance.endPoint;
}

void ArgumentCoder<WebCore::PathQuadCurveTo>::encode(StreamConnectionEncoder& encoder, const WebCore::PathQuadCurveTo& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.controlPoint)>, WebCore::FloatPoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.endPoint)>, WebCore::FloatPoint>);
    struct ShouldBeSameSizeAsPathQuadCurveTo : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::PathQuadCurveTo>, false> {
        WebCore::FloatPoint controlPoint;
        WebCore::FloatPoint endPoint;
    };
    static_assert(sizeof(ShouldBeSameSizeAsPathQuadCurveTo) == sizeof(WebCore::PathQuadCurveTo));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::PathQuadCurveTo, controlPoint)
        , offsetof(WebCore::PathQuadCurveTo, endPoint)
    >::value);

    encoder << instance.controlPoint;
    encoder << instance.endPoint;
}

std::optional<WebCore::PathQuadCurveTo> ArgumentCoder<WebCore::PathQuadCurveTo>::decode(Decoder& decoder)
{
    auto controlPoint = decoder.decode<WebCore::FloatPoint>();
    auto endPoint = decoder.decode<WebCore::FloatPoint>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::PathQuadCurveTo {
            WTFMove(*controlPoint),
            WTFMove(*endPoint)
        }
    };
}

void ArgumentCoder<WebCore::PathBezierCurveTo>::encode(Encoder& encoder, const WebCore::PathBezierCurveTo& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.controlPoint1)>, WebCore::FloatPoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.controlPoint2)>, WebCore::FloatPoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.endPoint)>, WebCore::FloatPoint>);
    struct ShouldBeSameSizeAsPathBezierCurveTo : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::PathBezierCurveTo>, false> {
        WebCore::FloatPoint controlPoint1;
        WebCore::FloatPoint controlPoint2;
        WebCore::FloatPoint endPoint;
    };
    static_assert(sizeof(ShouldBeSameSizeAsPathBezierCurveTo) == sizeof(WebCore::PathBezierCurveTo));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::PathBezierCurveTo, controlPoint1)
        , offsetof(WebCore::PathBezierCurveTo, controlPoint2)
        , offsetof(WebCore::PathBezierCurveTo, endPoint)
    >::value);

    encoder << instance.controlPoint1;
    encoder << instance.controlPoint2;
    encoder << instance.endPoint;
}

void ArgumentCoder<WebCore::PathBezierCurveTo>::encode(StreamConnectionEncoder& encoder, const WebCore::PathBezierCurveTo& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.controlPoint1)>, WebCore::FloatPoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.controlPoint2)>, WebCore::FloatPoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.endPoint)>, WebCore::FloatPoint>);
    struct ShouldBeSameSizeAsPathBezierCurveTo : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::PathBezierCurveTo>, false> {
        WebCore::FloatPoint controlPoint1;
        WebCore::FloatPoint controlPoint2;
        WebCore::FloatPoint endPoint;
    };
    static_assert(sizeof(ShouldBeSameSizeAsPathBezierCurveTo) == sizeof(WebCore::PathBezierCurveTo));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::PathBezierCurveTo, controlPoint1)
        , offsetof(WebCore::PathBezierCurveTo, controlPoint2)
        , offsetof(WebCore::PathBezierCurveTo, endPoint)
    >::value);

    encoder << instance.controlPoint1;
    encoder << instance.controlPoint2;
    encoder << instance.endPoint;
}

std::optional<WebCore::PathBezierCurveTo> ArgumentCoder<WebCore::PathBezierCurveTo>::decode(Decoder& decoder)
{
    auto controlPoint1 = decoder.decode<WebCore::FloatPoint>();
    auto controlPoint2 = decoder.decode<WebCore::FloatPoint>();
    auto endPoint = decoder.decode<WebCore::FloatPoint>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::PathBezierCurveTo {
            WTFMove(*controlPoint1),
            WTFMove(*controlPoint2),
            WTFMove(*endPoint)
        }
    };
}

void ArgumentCoder<WebCore::PathArcTo>::encode(Encoder& encoder, const WebCore::PathArcTo& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.controlPoint1)>, WebCore::FloatPoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.controlPoint2)>, WebCore::FloatPoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.radius)>, float>);
    struct ShouldBeSameSizeAsPathArcTo : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::PathArcTo>, false> {
        WebCore::FloatPoint controlPoint1;
        WebCore::FloatPoint controlPoint2;
        float radius;
    };
    static_assert(sizeof(ShouldBeSameSizeAsPathArcTo) == sizeof(WebCore::PathArcTo));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::PathArcTo, controlPoint1)
        , offsetof(WebCore::PathArcTo, controlPoint2)
        , offsetof(WebCore::PathArcTo, radius)
    >::value);

    encoder << instance.controlPoint1;
    encoder << instance.controlPoint2;
    encoder << instance.radius;
}

void ArgumentCoder<WebCore::PathArcTo>::encode(StreamConnectionEncoder& encoder, const WebCore::PathArcTo& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.controlPoint1)>, WebCore::FloatPoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.controlPoint2)>, WebCore::FloatPoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.radius)>, float>);
    struct ShouldBeSameSizeAsPathArcTo : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::PathArcTo>, false> {
        WebCore::FloatPoint controlPoint1;
        WebCore::FloatPoint controlPoint2;
        float radius;
    };
    static_assert(sizeof(ShouldBeSameSizeAsPathArcTo) == sizeof(WebCore::PathArcTo));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::PathArcTo, controlPoint1)
        , offsetof(WebCore::PathArcTo, controlPoint2)
        , offsetof(WebCore::PathArcTo, radius)
    >::value);

    encoder << instance.controlPoint1;
    encoder << instance.controlPoint2;
    encoder << instance.radius;
}

std::optional<WebCore::PathArcTo> ArgumentCoder<WebCore::PathArcTo>::decode(Decoder& decoder)
{
    auto controlPoint1 = decoder.decode<WebCore::FloatPoint>();
    auto controlPoint2 = decoder.decode<WebCore::FloatPoint>();
    auto radius = decoder.decode<float>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::PathArcTo {
            WTFMove(*controlPoint1),
            WTFMove(*controlPoint2),
            WTFMove(*radius)
        }
    };
}

void ArgumentCoder<WebCore::PathArc>::encode(Encoder& encoder, const WebCore::PathArc& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.center)>, WebCore::FloatPoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.radius)>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.startAngle)>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.endAngle)>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.direction)>, WebCore::RotationDirection>);
    struct ShouldBeSameSizeAsPathArc : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::PathArc>, false> {
        WebCore::FloatPoint center;
        float radius;
        float startAngle;
        float endAngle;
        WebCore::RotationDirection direction;
    };
    static_assert(sizeof(ShouldBeSameSizeAsPathArc) == sizeof(WebCore::PathArc));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::PathArc, center)
        , offsetof(WebCore::PathArc, radius)
        , offsetof(WebCore::PathArc, startAngle)
        , offsetof(WebCore::PathArc, endAngle)
        , offsetof(WebCore::PathArc, direction)
    >::value);

    encoder << instance.center;
    encoder << instance.radius;
    encoder << instance.startAngle;
    encoder << instance.endAngle;
    encoder << instance.direction;
}

void ArgumentCoder<WebCore::PathArc>::encode(StreamConnectionEncoder& encoder, const WebCore::PathArc& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.center)>, WebCore::FloatPoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.radius)>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.startAngle)>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.endAngle)>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.direction)>, WebCore::RotationDirection>);
    struct ShouldBeSameSizeAsPathArc : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::PathArc>, false> {
        WebCore::FloatPoint center;
        float radius;
        float startAngle;
        float endAngle;
        WebCore::RotationDirection direction;
    };
    static_assert(sizeof(ShouldBeSameSizeAsPathArc) == sizeof(WebCore::PathArc));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::PathArc, center)
        , offsetof(WebCore::PathArc, radius)
        , offsetof(WebCore::PathArc, startAngle)
        , offsetof(WebCore::PathArc, endAngle)
        , offsetof(WebCore::PathArc, direction)
    >::value);

    encoder << instance.center;
    encoder << instance.radius;
    encoder << instance.startAngle;
    encoder << instance.endAngle;
    encoder << instance.direction;
}

std::optional<WebCore::PathArc> ArgumentCoder<WebCore::PathArc>::decode(Decoder& decoder)
{
    auto center = decoder.decode<WebCore::FloatPoint>();
    auto radius = decoder.decode<float>();
    auto startAngle = decoder.decode<float>();
    auto endAngle = decoder.decode<float>();
    auto direction = decoder.decode<WebCore::RotationDirection>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::PathArc {
            WTFMove(*center),
            WTFMove(*radius),
            WTFMove(*startAngle),
            WTFMove(*endAngle),
            WTFMove(*direction)
        }
    };
}

void ArgumentCoder<WebCore::PathClosedArc>::encode(Encoder& encoder, const WebCore::PathClosedArc& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.arc)>, WebCore::PathArc>);
    struct ShouldBeSameSizeAsPathClosedArc : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::PathClosedArc>, false> {
        WebCore::PathArc arc;
    };
    static_assert(sizeof(ShouldBeSameSizeAsPathClosedArc) == sizeof(WebCore::PathClosedArc));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::PathClosedArc, arc)
    >::value);

    encoder << instance.arc;
}

void ArgumentCoder<WebCore::PathClosedArc>::encode(StreamConnectionEncoder& encoder, const WebCore::PathClosedArc& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.arc)>, WebCore::PathArc>);
    struct ShouldBeSameSizeAsPathClosedArc : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::PathClosedArc>, false> {
        WebCore::PathArc arc;
    };
    static_assert(sizeof(ShouldBeSameSizeAsPathClosedArc) == sizeof(WebCore::PathClosedArc));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::PathClosedArc, arc)
    >::value);

    encoder << instance.arc;
}

std::optional<WebCore::PathClosedArc> ArgumentCoder<WebCore::PathClosedArc>::decode(Decoder& decoder)
{
    auto arc = decoder.decode<WebCore::PathArc>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::PathClosedArc {
            WTFMove(*arc)
        }
    };
}

void ArgumentCoder<WebCore::PathEllipse>::encode(Encoder& encoder, const WebCore::PathEllipse& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.center)>, WebCore::FloatPoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.radiusX)>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.radiusY)>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.rotation)>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.startAngle)>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.endAngle)>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.direction)>, WebCore::RotationDirection>);
    struct ShouldBeSameSizeAsPathEllipse : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::PathEllipse>, false> {
        WebCore::FloatPoint center;
        float radiusX;
        float radiusY;
        float rotation;
        float startAngle;
        float endAngle;
        WebCore::RotationDirection direction;
    };
    static_assert(sizeof(ShouldBeSameSizeAsPathEllipse) == sizeof(WebCore::PathEllipse));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::PathEllipse, center)
        , offsetof(WebCore::PathEllipse, radiusX)
        , offsetof(WebCore::PathEllipse, radiusY)
        , offsetof(WebCore::PathEllipse, rotation)
        , offsetof(WebCore::PathEllipse, startAngle)
        , offsetof(WebCore::PathEllipse, endAngle)
        , offsetof(WebCore::PathEllipse, direction)
    >::value);

    encoder << instance.center;
    encoder << instance.radiusX;
    encoder << instance.radiusY;
    encoder << instance.rotation;
    encoder << instance.startAngle;
    encoder << instance.endAngle;
    encoder << instance.direction;
}

void ArgumentCoder<WebCore::PathEllipse>::encode(StreamConnectionEncoder& encoder, const WebCore::PathEllipse& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.center)>, WebCore::FloatPoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.radiusX)>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.radiusY)>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.rotation)>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.startAngle)>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.endAngle)>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.direction)>, WebCore::RotationDirection>);
    struct ShouldBeSameSizeAsPathEllipse : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::PathEllipse>, false> {
        WebCore::FloatPoint center;
        float radiusX;
        float radiusY;
        float rotation;
        float startAngle;
        float endAngle;
        WebCore::RotationDirection direction;
    };
    static_assert(sizeof(ShouldBeSameSizeAsPathEllipse) == sizeof(WebCore::PathEllipse));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::PathEllipse, center)
        , offsetof(WebCore::PathEllipse, radiusX)
        , offsetof(WebCore::PathEllipse, radiusY)
        , offsetof(WebCore::PathEllipse, rotation)
        , offsetof(WebCore::PathEllipse, startAngle)
        , offsetof(WebCore::PathEllipse, endAngle)
        , offsetof(WebCore::PathEllipse, direction)
    >::value);

    encoder << instance.center;
    encoder << instance.radiusX;
    encoder << instance.radiusY;
    encoder << instance.rotation;
    encoder << instance.startAngle;
    encoder << instance.endAngle;
    encoder << instance.direction;
}

std::optional<WebCore::PathEllipse> ArgumentCoder<WebCore::PathEllipse>::decode(Decoder& decoder)
{
    auto center = decoder.decode<WebCore::FloatPoint>();
    auto radiusX = decoder.decode<float>();
    auto radiusY = decoder.decode<float>();
    auto rotation = decoder.decode<float>();
    auto startAngle = decoder.decode<float>();
    auto endAngle = decoder.decode<float>();
    auto direction = decoder.decode<WebCore::RotationDirection>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::PathEllipse {
            WTFMove(*center),
            WTFMove(*radiusX),
            WTFMove(*radiusY),
            WTFMove(*rotation),
            WTFMove(*startAngle),
            WTFMove(*endAngle),
            WTFMove(*direction)
        }
    };
}

void ArgumentCoder<WebCore::PathEllipseInRect>::encode(Encoder& encoder, const WebCore::PathEllipseInRect& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.rect)>, WebCore::FloatRect>);
    struct ShouldBeSameSizeAsPathEllipseInRect : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::PathEllipseInRect>, false> {
        WebCore::FloatRect rect;
    };
    static_assert(sizeof(ShouldBeSameSizeAsPathEllipseInRect) == sizeof(WebCore::PathEllipseInRect));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::PathEllipseInRect, rect)
    >::value);

    encoder << instance.rect;
}

void ArgumentCoder<WebCore::PathEllipseInRect>::encode(StreamConnectionEncoder& encoder, const WebCore::PathEllipseInRect& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.rect)>, WebCore::FloatRect>);
    struct ShouldBeSameSizeAsPathEllipseInRect : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::PathEllipseInRect>, false> {
        WebCore::FloatRect rect;
    };
    static_assert(sizeof(ShouldBeSameSizeAsPathEllipseInRect) == sizeof(WebCore::PathEllipseInRect));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::PathEllipseInRect, rect)
    >::value);

    encoder << instance.rect;
}

std::optional<WebCore::PathEllipseInRect> ArgumentCoder<WebCore::PathEllipseInRect>::decode(Decoder& decoder)
{
    auto rect = decoder.decode<WebCore::FloatRect>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::PathEllipseInRect {
            WTFMove(*rect)
        }
    };
}

void ArgumentCoder<WebCore::PathRect>::encode(Encoder& encoder, const WebCore::PathRect& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.rect)>, WebCore::FloatRect>);
    struct ShouldBeSameSizeAsPathRect : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::PathRect>, false> {
        WebCore::FloatRect rect;
    };
    static_assert(sizeof(ShouldBeSameSizeAsPathRect) == sizeof(WebCore::PathRect));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::PathRect, rect)
    >::value);

    encoder << instance.rect;
}

void ArgumentCoder<WebCore::PathRect>::encode(StreamConnectionEncoder& encoder, const WebCore::PathRect& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.rect)>, WebCore::FloatRect>);
    struct ShouldBeSameSizeAsPathRect : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::PathRect>, false> {
        WebCore::FloatRect rect;
    };
    static_assert(sizeof(ShouldBeSameSizeAsPathRect) == sizeof(WebCore::PathRect));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::PathRect, rect)
    >::value);

    encoder << instance.rect;
}

std::optional<WebCore::PathRect> ArgumentCoder<WebCore::PathRect>::decode(Decoder& decoder)
{
    auto rect = decoder.decode<WebCore::FloatRect>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::PathRect {
            WTFMove(*rect)
        }
    };
}

void ArgumentCoder<WebCore::PathRoundedRect>::encode(Encoder& encoder, const WebCore::PathRoundedRect& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.roundedRect)>, WebCore::FloatRoundedRect>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.strategy)>, WebCore::PathRoundedRect::Strategy>);
    struct ShouldBeSameSizeAsPathRoundedRect : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::PathRoundedRect>, false> {
        WebCore::FloatRoundedRect roundedRect;
        WebCore::PathRoundedRect::Strategy strategy;
    };
    static_assert(sizeof(ShouldBeSameSizeAsPathRoundedRect) == sizeof(WebCore::PathRoundedRect));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::PathRoundedRect, roundedRect)
        , offsetof(WebCore::PathRoundedRect, strategy)
    >::value);

    encoder << instance.roundedRect;
    encoder << instance.strategy;
}

void ArgumentCoder<WebCore::PathRoundedRect>::encode(StreamConnectionEncoder& encoder, const WebCore::PathRoundedRect& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.roundedRect)>, WebCore::FloatRoundedRect>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.strategy)>, WebCore::PathRoundedRect::Strategy>);
    struct ShouldBeSameSizeAsPathRoundedRect : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::PathRoundedRect>, false> {
        WebCore::FloatRoundedRect roundedRect;
        WebCore::PathRoundedRect::Strategy strategy;
    };
    static_assert(sizeof(ShouldBeSameSizeAsPathRoundedRect) == sizeof(WebCore::PathRoundedRect));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::PathRoundedRect, roundedRect)
        , offsetof(WebCore::PathRoundedRect, strategy)
    >::value);

    encoder << instance.roundedRect;
    encoder << instance.strategy;
}

std::optional<WebCore::PathRoundedRect> ArgumentCoder<WebCore::PathRoundedRect>::decode(Decoder& decoder)
{
    auto roundedRect = decoder.decode<WebCore::FloatRoundedRect>();
    auto strategy = decoder.decode<WebCore::PathRoundedRect::Strategy>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::PathRoundedRect {
            WTFMove(*roundedRect),
            WTFMove(*strategy)
        }
    };
}

void ArgumentCoder<WebCore::PathContinuousRoundedRect>::encode(Encoder& encoder, const WebCore::PathContinuousRoundedRect& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.rect)>, WebCore::FloatRect>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.cornerWidth)>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.cornerHeight)>, float>);
    struct ShouldBeSameSizeAsPathContinuousRoundedRect : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::PathContinuousRoundedRect>, false> {
        WebCore::FloatRect rect;
        float cornerWidth;
        float cornerHeight;
    };
    static_assert(sizeof(ShouldBeSameSizeAsPathContinuousRoundedRect) == sizeof(WebCore::PathContinuousRoundedRect));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::PathContinuousRoundedRect, rect)
        , offsetof(WebCore::PathContinuousRoundedRect, cornerWidth)
        , offsetof(WebCore::PathContinuousRoundedRect, cornerHeight)
    >::value);

    encoder << instance.rect;
    encoder << instance.cornerWidth;
    encoder << instance.cornerHeight;
}

void ArgumentCoder<WebCore::PathContinuousRoundedRect>::encode(StreamConnectionEncoder& encoder, const WebCore::PathContinuousRoundedRect& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.rect)>, WebCore::FloatRect>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.cornerWidth)>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.cornerHeight)>, float>);
    struct ShouldBeSameSizeAsPathContinuousRoundedRect : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::PathContinuousRoundedRect>, false> {
        WebCore::FloatRect rect;
        float cornerWidth;
        float cornerHeight;
    };
    static_assert(sizeof(ShouldBeSameSizeAsPathContinuousRoundedRect) == sizeof(WebCore::PathContinuousRoundedRect));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::PathContinuousRoundedRect, rect)
        , offsetof(WebCore::PathContinuousRoundedRect, cornerWidth)
        , offsetof(WebCore::PathContinuousRoundedRect, cornerHeight)
    >::value);

    encoder << instance.rect;
    encoder << instance.cornerWidth;
    encoder << instance.cornerHeight;
}

std::optional<WebCore::PathContinuousRoundedRect> ArgumentCoder<WebCore::PathContinuousRoundedRect>::decode(Decoder& decoder)
{
    auto rect = decoder.decode<WebCore::FloatRect>();
    auto cornerWidth = decoder.decode<float>();
    auto cornerHeight = decoder.decode<float>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::PathContinuousRoundedRect {
            WTFMove(*rect),
            WTFMove(*cornerWidth),
            WTFMove(*cornerHeight)
        }
    };
}

void ArgumentCoder<WebCore::PathDataLine>::encode(Encoder& encoder, const WebCore::PathDataLine& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.span())>, std::span<const float, 4>>);

    encoder << instance.span();
}

void ArgumentCoder<WebCore::PathDataLine>::encode(StreamConnectionEncoder& encoder, const WebCore::PathDataLine& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.span())>, std::span<const float, 4>>);

    encoder << instance.span();
}

std::optional<WebCore::PathDataLine> ArgumentCoder<WebCore::PathDataLine>::decode(Decoder& decoder)
{
    auto span = decoder.decode<std::span<const float, 4>>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::PathDataLine {
            WTFMove(*span)
        }
    };
}

void ArgumentCoder<WebCore::PathDataQuadCurve>::encode(Encoder& encoder, const WebCore::PathDataQuadCurve& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.start)>, WebCore::FloatPoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.controlPoint)>, WebCore::FloatPoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.endPoint)>, WebCore::FloatPoint>);
    struct ShouldBeSameSizeAsPathDataQuadCurve : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::PathDataQuadCurve>, false> {
        WebCore::FloatPoint start;
        WebCore::FloatPoint controlPoint;
        WebCore::FloatPoint endPoint;
    };
    static_assert(sizeof(ShouldBeSameSizeAsPathDataQuadCurve) == sizeof(WebCore::PathDataQuadCurve));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::PathDataQuadCurve, start)
        , offsetof(WebCore::PathDataQuadCurve, controlPoint)
        , offsetof(WebCore::PathDataQuadCurve, endPoint)
    >::value);

    encoder << instance.start;
    encoder << instance.controlPoint;
    encoder << instance.endPoint;
}

void ArgumentCoder<WebCore::PathDataQuadCurve>::encode(StreamConnectionEncoder& encoder, const WebCore::PathDataQuadCurve& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.start)>, WebCore::FloatPoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.controlPoint)>, WebCore::FloatPoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.endPoint)>, WebCore::FloatPoint>);
    struct ShouldBeSameSizeAsPathDataQuadCurve : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::PathDataQuadCurve>, false> {
        WebCore::FloatPoint start;
        WebCore::FloatPoint controlPoint;
        WebCore::FloatPoint endPoint;
    };
    static_assert(sizeof(ShouldBeSameSizeAsPathDataQuadCurve) == sizeof(WebCore::PathDataQuadCurve));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::PathDataQuadCurve, start)
        , offsetof(WebCore::PathDataQuadCurve, controlPoint)
        , offsetof(WebCore::PathDataQuadCurve, endPoint)
    >::value);

    encoder << instance.start;
    encoder << instance.controlPoint;
    encoder << instance.endPoint;
}

std::optional<WebCore::PathDataQuadCurve> ArgumentCoder<WebCore::PathDataQuadCurve>::decode(Decoder& decoder)
{
    auto start = decoder.decode<WebCore::FloatPoint>();
    auto controlPoint = decoder.decode<WebCore::FloatPoint>();
    auto endPoint = decoder.decode<WebCore::FloatPoint>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::PathDataQuadCurve {
            WTFMove(*start),
            WTFMove(*controlPoint),
            WTFMove(*endPoint)
        }
    };
}

void ArgumentCoder<WebCore::PathDataBezierCurve>::encode(Encoder& encoder, const WebCore::PathDataBezierCurve& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.start)>, WebCore::FloatPoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.controlPoint1)>, WebCore::FloatPoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.controlPoint2)>, WebCore::FloatPoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.endPoint)>, WebCore::FloatPoint>);
    struct ShouldBeSameSizeAsPathDataBezierCurve : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::PathDataBezierCurve>, false> {
        WebCore::FloatPoint start;
        WebCore::FloatPoint controlPoint1;
        WebCore::FloatPoint controlPoint2;
        WebCore::FloatPoint endPoint;
    };
    static_assert(sizeof(ShouldBeSameSizeAsPathDataBezierCurve) == sizeof(WebCore::PathDataBezierCurve));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::PathDataBezierCurve, start)
        , offsetof(WebCore::PathDataBezierCurve, controlPoint1)
        , offsetof(WebCore::PathDataBezierCurve, controlPoint2)
        , offsetof(WebCore::PathDataBezierCurve, endPoint)
    >::value);

    encoder << instance.start;
    encoder << instance.controlPoint1;
    encoder << instance.controlPoint2;
    encoder << instance.endPoint;
}

void ArgumentCoder<WebCore::PathDataBezierCurve>::encode(StreamConnectionEncoder& encoder, const WebCore::PathDataBezierCurve& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.start)>, WebCore::FloatPoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.controlPoint1)>, WebCore::FloatPoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.controlPoint2)>, WebCore::FloatPoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.endPoint)>, WebCore::FloatPoint>);
    struct ShouldBeSameSizeAsPathDataBezierCurve : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::PathDataBezierCurve>, false> {
        WebCore::FloatPoint start;
        WebCore::FloatPoint controlPoint1;
        WebCore::FloatPoint controlPoint2;
        WebCore::FloatPoint endPoint;
    };
    static_assert(sizeof(ShouldBeSameSizeAsPathDataBezierCurve) == sizeof(WebCore::PathDataBezierCurve));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::PathDataBezierCurve, start)
        , offsetof(WebCore::PathDataBezierCurve, controlPoint1)
        , offsetof(WebCore::PathDataBezierCurve, controlPoint2)
        , offsetof(WebCore::PathDataBezierCurve, endPoint)
    >::value);

    encoder << instance.start;
    encoder << instance.controlPoint1;
    encoder << instance.controlPoint2;
    encoder << instance.endPoint;
}

std::optional<WebCore::PathDataBezierCurve> ArgumentCoder<WebCore::PathDataBezierCurve>::decode(Decoder& decoder)
{
    auto start = decoder.decode<WebCore::FloatPoint>();
    auto controlPoint1 = decoder.decode<WebCore::FloatPoint>();
    auto controlPoint2 = decoder.decode<WebCore::FloatPoint>();
    auto endPoint = decoder.decode<WebCore::FloatPoint>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::PathDataBezierCurve {
            WTFMove(*start),
            WTFMove(*controlPoint1),
            WTFMove(*controlPoint2),
            WTFMove(*endPoint)
        }
    };
}

void ArgumentCoder<WebCore::PathDataArc>::encode(Encoder& encoder, const WebCore::PathDataArc& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.start)>, WebCore::FloatPoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.controlPoint1)>, WebCore::FloatPoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.controlPoint2)>, WebCore::FloatPoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.radius)>, float>);
    struct ShouldBeSameSizeAsPathDataArc : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::PathDataArc>, false> {
        WebCore::FloatPoint start;
        WebCore::FloatPoint controlPoint1;
        WebCore::FloatPoint controlPoint2;
        float radius;
    };
    static_assert(sizeof(ShouldBeSameSizeAsPathDataArc) == sizeof(WebCore::PathDataArc));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::PathDataArc, start)
        , offsetof(WebCore::PathDataArc, controlPoint1)
        , offsetof(WebCore::PathDataArc, controlPoint2)
        , offsetof(WebCore::PathDataArc, radius)
    >::value);

    encoder << instance.start;
    encoder << instance.controlPoint1;
    encoder << instance.controlPoint2;
    encoder << instance.radius;
}

void ArgumentCoder<WebCore::PathDataArc>::encode(StreamConnectionEncoder& encoder, const WebCore::PathDataArc& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.start)>, WebCore::FloatPoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.controlPoint1)>, WebCore::FloatPoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.controlPoint2)>, WebCore::FloatPoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.radius)>, float>);
    struct ShouldBeSameSizeAsPathDataArc : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::PathDataArc>, false> {
        WebCore::FloatPoint start;
        WebCore::FloatPoint controlPoint1;
        WebCore::FloatPoint controlPoint2;
        float radius;
    };
    static_assert(sizeof(ShouldBeSameSizeAsPathDataArc) == sizeof(WebCore::PathDataArc));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::PathDataArc, start)
        , offsetof(WebCore::PathDataArc, controlPoint1)
        , offsetof(WebCore::PathDataArc, controlPoint2)
        , offsetof(WebCore::PathDataArc, radius)
    >::value);

    encoder << instance.start;
    encoder << instance.controlPoint1;
    encoder << instance.controlPoint2;
    encoder << instance.radius;
}

std::optional<WebCore::PathDataArc> ArgumentCoder<WebCore::PathDataArc>::decode(Decoder& decoder)
{
    auto start = decoder.decode<WebCore::FloatPoint>();
    auto controlPoint1 = decoder.decode<WebCore::FloatPoint>();
    auto controlPoint2 = decoder.decode<WebCore::FloatPoint>();
    auto radius = decoder.decode<float>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::PathDataArc {
            WTFMove(*start),
            WTFMove(*controlPoint1),
            WTFMove(*controlPoint2),
            WTFMove(*radius)
        }
    };
}

void ArgumentCoder<WebCore::PathCloseSubpath>::encode(Encoder& encoder, const WebCore::PathCloseSubpath& instance)
{
    struct ShouldBeSameSizeAsPathCloseSubpath : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::PathCloseSubpath>, false> {
    };
    static_assert(sizeof(ShouldBeSameSizeAsPathCloseSubpath) == sizeof(WebCore::PathCloseSubpath));
    static_assert(MembersInCorrectOrder < 0
    >::value);

}

void ArgumentCoder<WebCore::PathCloseSubpath>::encode(StreamConnectionEncoder& encoder, const WebCore::PathCloseSubpath& instance)
{
    struct ShouldBeSameSizeAsPathCloseSubpath : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::PathCloseSubpath>, false> {
    };
    static_assert(sizeof(ShouldBeSameSizeAsPathCloseSubpath) == sizeof(WebCore::PathCloseSubpath));
    static_assert(MembersInCorrectOrder < 0
    >::value);

}

std::optional<WebCore::PathCloseSubpath> ArgumentCoder<WebCore::PathCloseSubpath>::decode(Decoder& decoder)
{
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::PathCloseSubpath {
        }
    };
}

void ArgumentCoder<WebCore::PathSegment>::encode(Encoder& encoder, const WebCore::PathSegment& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.data())>, WebCore::PathSegment::Data>);

    encoder << instance.data();
}

void ArgumentCoder<WebCore::PathSegment>::encode(StreamConnectionEncoder& encoder, const WebCore::PathSegment& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.data())>, WebCore::PathSegment::Data>);

    encoder << instance.data();
}

std::optional<WebCore::PathSegment> ArgumentCoder<WebCore::PathSegment>::decode(Decoder& decoder)
{
    auto data = decoder.decode<WebCore::PathSegment::Data>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::PathSegment {
            WTFMove(*data)
        }
    };
}

#if ENABLE(GPU_PROCESS) && ENABLE(WEBGL)
void ArgumentCoder<WebKit::RemoteGraphicsContextGLInitializationState>::encode(Encoder& encoder, const WebKit::RemoteGraphicsContextGLInitializationState& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.availableExtensions)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.requestableExtensions)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.externalImageTarget)>, GCGLenum>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.externalImageBindingQuery)>, GCGLenum>);
    struct ShouldBeSameSizeAsRemoteGraphicsContextGLInitializationState : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::RemoteGraphicsContextGLInitializationState>, false> {
        String availableExtensions;
        String requestableExtensions;
        GCGLenum externalImageTarget;
        GCGLenum externalImageBindingQuery;
    };
    static_assert(sizeof(ShouldBeSameSizeAsRemoteGraphicsContextGLInitializationState) == sizeof(WebKit::RemoteGraphicsContextGLInitializationState));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::RemoteGraphicsContextGLInitializationState, availableExtensions)
        , offsetof(WebKit::RemoteGraphicsContextGLInitializationState, requestableExtensions)
        , offsetof(WebKit::RemoteGraphicsContextGLInitializationState, externalImageTarget)
        , offsetof(WebKit::RemoteGraphicsContextGLInitializationState, externalImageBindingQuery)
    >::value);

    encoder << instance.availableExtensions;
    encoder << instance.requestableExtensions;
    encoder << instance.externalImageTarget;
    encoder << instance.externalImageBindingQuery;
}

std::optional<WebKit::RemoteGraphicsContextGLInitializationState> ArgumentCoder<WebKit::RemoteGraphicsContextGLInitializationState>::decode(Decoder& decoder)
{
    auto availableExtensions = decoder.decode<String>();
    auto requestableExtensions = decoder.decode<String>();
    auto externalImageTarget = decoder.decode<GCGLenum>();
    auto externalImageBindingQuery = decoder.decode<GCGLenum>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebKit::RemoteGraphicsContextGLInitializationState {
            WTFMove(*availableExtensions),
            WTFMove(*requestableExtensions),
            WTFMove(*externalImageTarget),
            WTFMove(*externalImageBindingQuery)
        }
    };
}

#endif

#if ENABLE(GPU_PROCESS)
void ArgumentCoder<WebKit::RemoteGPURequestAdapterResponse>::encode(Encoder& encoder, const WebKit::RemoteGPURequestAdapterResponse& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.name)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.features)>, WebKit::WebGPU::SupportedFeatures>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.limits)>, WebKit::WebGPU::SupportedLimits>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isFallbackAdapter)>, bool>);
    struct ShouldBeSameSizeAsRemoteGPURequestAdapterResponse : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::RemoteGPURequestAdapterResponse>, false> {
        String name;
        WebKit::WebGPU::SupportedFeatures features;
        WebKit::WebGPU::SupportedLimits limits;
        bool isFallbackAdapter;
    };
    static_assert(sizeof(ShouldBeSameSizeAsRemoteGPURequestAdapterResponse) == sizeof(WebKit::RemoteGPURequestAdapterResponse));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::RemoteGPURequestAdapterResponse, name)
        , offsetof(WebKit::RemoteGPURequestAdapterResponse, features)
        , offsetof(WebKit::RemoteGPURequestAdapterResponse, limits)
        , offsetof(WebKit::RemoteGPURequestAdapterResponse, isFallbackAdapter)
    >::value);

    encoder << instance.name;
    encoder << instance.features;
    encoder << instance.limits;
    encoder << instance.isFallbackAdapter;
}

void ArgumentCoder<WebKit::RemoteGPURequestAdapterResponse>::encode(StreamConnectionEncoder& encoder, const WebKit::RemoteGPURequestAdapterResponse& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.name)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.features)>, WebKit::WebGPU::SupportedFeatures>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.limits)>, WebKit::WebGPU::SupportedLimits>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isFallbackAdapter)>, bool>);
    struct ShouldBeSameSizeAsRemoteGPURequestAdapterResponse : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::RemoteGPURequestAdapterResponse>, false> {
        String name;
        WebKit::WebGPU::SupportedFeatures features;
        WebKit::WebGPU::SupportedLimits limits;
        bool isFallbackAdapter;
    };
    static_assert(sizeof(ShouldBeSameSizeAsRemoteGPURequestAdapterResponse) == sizeof(WebKit::RemoteGPURequestAdapterResponse));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::RemoteGPURequestAdapterResponse, name)
        , offsetof(WebKit::RemoteGPURequestAdapterResponse, features)
        , offsetof(WebKit::RemoteGPURequestAdapterResponse, limits)
        , offsetof(WebKit::RemoteGPURequestAdapterResponse, isFallbackAdapter)
    >::value);

    encoder << instance.name;
    encoder << instance.features;
    encoder << instance.limits;
    encoder << instance.isFallbackAdapter;
}

std::optional<WebKit::RemoteGPURequestAdapterResponse> ArgumentCoder<WebKit::RemoteGPURequestAdapterResponse>::decode(Decoder& decoder)
{
    auto name = decoder.decode<String>();
    auto features = decoder.decode<WebKit::WebGPU::SupportedFeatures>();
    auto limits = decoder.decode<WebKit::WebGPU::SupportedLimits>();
    auto isFallbackAdapter = decoder.decode<bool>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebKit::RemoteGPURequestAdapterResponse {
            WTFMove(*name),
            WTFMove(*features),
            WTFMove(*limits),
            WTFMove(*isFallbackAdapter)
        }
    };
}

#endif

#if ENABLE(GPU_PROCESS) && ENABLE(VIDEO)
void ArgumentCoder<WebKit::AudioTrackPrivateRemoteConfiguration>::encode(Encoder& encoder, const WebKit::AudioTrackPrivateRemoteConfiguration& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.trackId)>, WebCore::TrackID>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.label)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.language)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.startTimeVariance)>, MediaTime>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.trackIndex)>, int>);
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::TrackPrivateRemoteConfiguration, trackId)
        , offsetof(WebKit::TrackPrivateRemoteConfiguration, label)
        , offsetof(WebKit::TrackPrivateRemoteConfiguration, language)
        , offsetof(WebKit::TrackPrivateRemoteConfiguration, startTimeVariance)
        , offsetof(WebKit::TrackPrivateRemoteConfiguration, trackIndex)
    >::value);

    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.enabled)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.kind)>, WebCore::AudioTrackPrivate::Kind>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.trackConfiguration)>, WebCore::PlatformAudioTrackConfiguration>);
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::AudioTrackPrivateRemoteConfiguration, enabled)
        , offsetof(WebKit::AudioTrackPrivateRemoteConfiguration, kind)
        , offsetof(WebKit::AudioTrackPrivateRemoteConfiguration, trackConfiguration)
    >::value);

    encoder << instance.trackId;
    encoder << instance.label;
    encoder << instance.language;
    encoder << instance.startTimeVariance;
    encoder << instance.trackIndex;
    encoder << instance.enabled;
    encoder << instance.kind;
    encoder << instance.trackConfiguration;
}

std::optional<WebKit::AudioTrackPrivateRemoteConfiguration> ArgumentCoder<WebKit::AudioTrackPrivateRemoteConfiguration>::decode(Decoder& decoder)
{
    auto trackId = decoder.decode<WebCore::TrackID>();
    auto label = decoder.decode<String>();
    auto language = decoder.decode<String>();
    auto startTimeVariance = decoder.decode<MediaTime>();
    auto trackIndex = decoder.decode<int>();
    auto enabled = decoder.decode<bool>();
    auto kind = decoder.decode<WebCore::AudioTrackPrivate::Kind>();
    auto trackConfiguration = decoder.decode<WebCore::PlatformAudioTrackConfiguration>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebKit::AudioTrackPrivateRemoteConfiguration {
            WebKit::TrackPrivateRemoteConfiguration {
                WTFMove(*trackId),
                WTFMove(*label),
                WTFMove(*language),
                WTFMove(*startTimeVariance),
                WTFMove(*trackIndex)
            },
            WTFMove(*enabled),
            WTFMove(*kind),
            WTFMove(*trackConfiguration)
        }
    };
}

#endif

#if ENABLE(GPU_PROCESS) && ENABLE(MEDIA_SOURCE)
void ArgumentCoder<WebKit::InitializationSegmentInfo>::encode(Encoder& encoder, const WebKit::InitializationSegmentInfo& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.duration)>, MediaTime>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.audioTracks)>, Vector<WebKit::InitializationSegmentInfo::TrackInformation>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.videoTracks)>, Vector<WebKit::InitializationSegmentInfo::TrackInformation>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.textTracks)>, Vector<WebKit::InitializationSegmentInfo::TrackInformation>>);
    struct ShouldBeSameSizeAsInitializationSegmentInfo : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::InitializationSegmentInfo>, false> {
        MediaTime duration;
        Vector<WebKit::InitializationSegmentInfo::TrackInformation> audioTracks;
        Vector<WebKit::InitializationSegmentInfo::TrackInformation> videoTracks;
        Vector<WebKit::InitializationSegmentInfo::TrackInformation> textTracks;
    };
    static_assert(sizeof(ShouldBeSameSizeAsInitializationSegmentInfo) == sizeof(WebKit::InitializationSegmentInfo));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::InitializationSegmentInfo, duration)
        , offsetof(WebKit::InitializationSegmentInfo, audioTracks)
        , offsetof(WebKit::InitializationSegmentInfo, videoTracks)
        , offsetof(WebKit::InitializationSegmentInfo, textTracks)
    >::value);

    encoder << instance.duration;
    encoder << instance.audioTracks;
    encoder << instance.videoTracks;
    encoder << instance.textTracks;
}

std::optional<WebKit::InitializationSegmentInfo> ArgumentCoder<WebKit::InitializationSegmentInfo>::decode(Decoder& decoder)
{
    auto duration = decoder.decode<MediaTime>();
    auto audioTracks = decoder.decode<Vector<WebKit::InitializationSegmentInfo::TrackInformation>>();
    auto videoTracks = decoder.decode<Vector<WebKit::InitializationSegmentInfo::TrackInformation>>();
    auto textTracks = decoder.decode<Vector<WebKit::InitializationSegmentInfo::TrackInformation>>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebKit::InitializationSegmentInfo {
            WTFMove(*duration),
            WTFMove(*audioTracks),
            WTFMove(*videoTracks),
            WTFMove(*textTracks)
        }
    };
}

#endif

#if ENABLE(GPU_PROCESS) && ENABLE(MEDIA_SOURCE)
void ArgumentCoder<WebKit::InitializationSegmentInfo::TrackInformation>::encode(Encoder& encoder, const WebKit::InitializationSegmentInfo::TrackInformation& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.description)>, WebKit::MediaDescriptionInfo>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.id)>, WebCore::TrackID>);
    struct ShouldBeSameSizeAsTrackInformation : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::InitializationSegmentInfo::TrackInformation>, false> {
        WebKit::MediaDescriptionInfo description;
        WebCore::TrackID id;
    };
    static_assert(sizeof(ShouldBeSameSizeAsTrackInformation) == sizeof(WebKit::InitializationSegmentInfo::TrackInformation));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::InitializationSegmentInfo::TrackInformation, description)
        , offsetof(WebKit::InitializationSegmentInfo::TrackInformation, id)
    >::value);

    encoder << instance.description;
    encoder << instance.id;
}

std::optional<WebKit::InitializationSegmentInfo::TrackInformation> ArgumentCoder<WebKit::InitializationSegmentInfo::TrackInformation>::decode(Decoder& decoder)
{
    auto description = decoder.decode<WebKit::MediaDescriptionInfo>();
    auto id = decoder.decode<WebCore::TrackID>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebKit::InitializationSegmentInfo::TrackInformation {
            WTFMove(*description),
            WTFMove(*id)
        }
    };
}

#endif

#if ENABLE(GPU_PROCESS) && ENABLE(MEDIA_SOURCE)
void ArgumentCoder<WebKit::MediaDescriptionInfo>::encode(Encoder& encoder, const WebKit::MediaDescriptionInfo& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_codec)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_isVideo)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_isAudio)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_isText)>, bool>);
    struct ShouldBeSameSizeAsMediaDescriptionInfo : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::MediaDescriptionInfo>, false> {
        String m_codec;
        bool m_isVideo;
        bool m_isAudio;
        bool m_isText;
    };
    static_assert(sizeof(ShouldBeSameSizeAsMediaDescriptionInfo) == sizeof(WebKit::MediaDescriptionInfo));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::MediaDescriptionInfo, m_codec)
        , offsetof(WebKit::MediaDescriptionInfo, m_isVideo)
        , offsetof(WebKit::MediaDescriptionInfo, m_isAudio)
        , offsetof(WebKit::MediaDescriptionInfo, m_isText)
    >::value);

    encoder << instance.m_codec;
    encoder << instance.m_isVideo;
    encoder << instance.m_isAudio;
    encoder << instance.m_isText;
}

std::optional<WebKit::MediaDescriptionInfo> ArgumentCoder<WebKit::MediaDescriptionInfo>::decode(Decoder& decoder)
{
    auto m_codec = decoder.decode<String>();
    auto m_isVideo = decoder.decode<bool>();
    auto m_isAudio = decoder.decode<bool>();
    auto m_isText = decoder.decode<bool>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebKit::MediaDescriptionInfo {
            WTFMove(*m_codec),
            WTFMove(*m_isVideo),
            WTFMove(*m_isAudio),
            WTFMove(*m_isText)
        }
    };
}

#endif

#if ENABLE(GPU_PROCESS)
void ArgumentCoder<WebKit::RemoteMediaPlayerProxyConfiguration>::encode(Encoder& encoder, const WebKit::RemoteMediaPlayerProxyConfiguration& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.referrer)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.userAgent)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.sourceApplicationIdentifier)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.networkInterfaceName)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.audioOutputDeviceId)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.mediaContentTypesRequiringHardwareSupport)>, Vector<WebCore::ContentType>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.allowedMediaContainerTypes)>, std::optional<Vector<String>>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.allowedMediaCodecTypes)>, std::optional<Vector<String>>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.allowedMediaVideoCodecIDs)>, std::optional<Vector<WebCore::FourCC>>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.allowedMediaAudioCodecIDs)>, std::optional<Vector<WebCore::FourCC>>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.allowedMediaCaptionFormatTypes)>, std::optional<Vector<WebCore::FourCC>>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.playerContentBoxRect)>, WebCore::LayoutRect>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.preferredAudioCharacteristics)>, Vector<String>>);
#if PLATFORM(COCOA)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.outOfBandTrackData)>, Vector<WebCore::PlatformTextTrackData>>);
#endif
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.documentSecurityOrigin)>, WebCore::SecurityOriginData>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.presentationSize)>, WebCore::IntSize>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.videoLayerSize)>, WebCore::FloatSize>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.logIdentifier)>, uint64_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.shouldUsePersistentCache)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isVideo)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.renderingCanBeAccelerated)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.shouldDisableHDR)>, bool>);
#if PLATFORM(IOS_FAMILY)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.canShowWhileLocked)>, bool>);
#endif
#if HAVE(SPATIAL_AUDIO_EXPERIENCE)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.prefersSpatialAudioExperience)>, bool>);
#endif
    struct ShouldBeSameSizeAsRemoteMediaPlayerProxyConfiguration : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::RemoteMediaPlayerProxyConfiguration>, false> {
        String referrer;
        String userAgent;
        String sourceApplicationIdentifier;
        String networkInterfaceName;
        String audioOutputDeviceId;
        Vector<WebCore::ContentType> mediaContentTypesRequiringHardwareSupport;
        std::optional<Vector<String>> allowedMediaContainerTypes;
        std::optional<Vector<String>> allowedMediaCodecTypes;
        std::optional<Vector<WebCore::FourCC>> allowedMediaVideoCodecIDs;
        std::optional<Vector<WebCore::FourCC>> allowedMediaAudioCodecIDs;
        std::optional<Vector<WebCore::FourCC>> allowedMediaCaptionFormatTypes;
        WebCore::LayoutRect playerContentBoxRect;
        Vector<String> preferredAudioCharacteristics;
#if PLATFORM(COCOA)
        Vector<WebCore::PlatformTextTrackData> outOfBandTrackData;
#endif
        WebCore::SecurityOriginData documentSecurityOrigin;
        WebCore::IntSize presentationSize;
        WebCore::FloatSize videoLayerSize;
        uint64_t logIdentifier;
        bool shouldUsePersistentCache;
        bool isVideo;
        bool renderingCanBeAccelerated;
        bool shouldDisableHDR;
#if PLATFORM(IOS_FAMILY)
        bool canShowWhileLocked;
#endif
#if HAVE(SPATIAL_AUDIO_EXPERIENCE)
        bool prefersSpatialAudioExperience;
#endif
    };
    static_assert(sizeof(ShouldBeSameSizeAsRemoteMediaPlayerProxyConfiguration) == sizeof(WebKit::RemoteMediaPlayerProxyConfiguration));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::RemoteMediaPlayerProxyConfiguration, referrer)
        , offsetof(WebKit::RemoteMediaPlayerProxyConfiguration, userAgent)
        , offsetof(WebKit::RemoteMediaPlayerProxyConfiguration, sourceApplicationIdentifier)
        , offsetof(WebKit::RemoteMediaPlayerProxyConfiguration, networkInterfaceName)
        , offsetof(WebKit::RemoteMediaPlayerProxyConfiguration, audioOutputDeviceId)
        , offsetof(WebKit::RemoteMediaPlayerProxyConfiguration, mediaContentTypesRequiringHardwareSupport)
        , offsetof(WebKit::RemoteMediaPlayerProxyConfiguration, allowedMediaContainerTypes)
        , offsetof(WebKit::RemoteMediaPlayerProxyConfiguration, allowedMediaCodecTypes)
        , offsetof(WebKit::RemoteMediaPlayerProxyConfiguration, allowedMediaVideoCodecIDs)
        , offsetof(WebKit::RemoteMediaPlayerProxyConfiguration, allowedMediaAudioCodecIDs)
        , offsetof(WebKit::RemoteMediaPlayerProxyConfiguration, allowedMediaCaptionFormatTypes)
        , offsetof(WebKit::RemoteMediaPlayerProxyConfiguration, playerContentBoxRect)
        , offsetof(WebKit::RemoteMediaPlayerProxyConfiguration, preferredAudioCharacteristics)
#if PLATFORM(COCOA)
        , offsetof(WebKit::RemoteMediaPlayerProxyConfiguration, outOfBandTrackData)
#endif
        , offsetof(WebKit::RemoteMediaPlayerProxyConfiguration, documentSecurityOrigin)
        , offsetof(WebKit::RemoteMediaPlayerProxyConfiguration, presentationSize)
        , offsetof(WebKit::RemoteMediaPlayerProxyConfiguration, videoLayerSize)
        , offsetof(WebKit::RemoteMediaPlayerProxyConfiguration, logIdentifier)
        , offsetof(WebKit::RemoteMediaPlayerProxyConfiguration, shouldUsePersistentCache)
        , offsetof(WebKit::RemoteMediaPlayerProxyConfiguration, isVideo)
        , offsetof(WebKit::RemoteMediaPlayerProxyConfiguration, renderingCanBeAccelerated)
        , offsetof(WebKit::RemoteMediaPlayerProxyConfiguration, shouldDisableHDR)
#if PLATFORM(IOS_FAMILY)
        , offsetof(WebKit::RemoteMediaPlayerProxyConfiguration, canShowWhileLocked)
#endif
#if HAVE(SPATIAL_AUDIO_EXPERIENCE)
        , offsetof(WebKit::RemoteMediaPlayerProxyConfiguration, prefersSpatialAudioExperience)
#endif
    >::value);

    encoder << instance.referrer;
    encoder << instance.userAgent;
    encoder << instance.sourceApplicationIdentifier;
    encoder << instance.networkInterfaceName;
    encoder << instance.audioOutputDeviceId;
    encoder << instance.mediaContentTypesRequiringHardwareSupport;
    encoder << instance.allowedMediaContainerTypes;
    encoder << instance.allowedMediaCodecTypes;
    encoder << instance.allowedMediaVideoCodecIDs;
    encoder << instance.allowedMediaAudioCodecIDs;
    encoder << instance.allowedMediaCaptionFormatTypes;
    encoder << instance.playerContentBoxRect;
    encoder << instance.preferredAudioCharacteristics;
#if PLATFORM(COCOA)
    encoder << instance.outOfBandTrackData;
#endif
    encoder << instance.documentSecurityOrigin;
    encoder << instance.presentationSize;
    encoder << instance.videoLayerSize;
    encoder << instance.logIdentifier;
    encoder << instance.shouldUsePersistentCache;
    encoder << instance.isVideo;
    encoder << instance.renderingCanBeAccelerated;
    encoder << instance.shouldDisableHDR;
#if PLATFORM(IOS_FAMILY)
    encoder << instance.canShowWhileLocked;
#endif
#if HAVE(SPATIAL_AUDIO_EXPERIENCE)
    encoder << instance.prefersSpatialAudioExperience;
#endif
}

std::optional<WebKit::RemoteMediaPlayerProxyConfiguration> ArgumentCoder<WebKit::RemoteMediaPlayerProxyConfiguration>::decode(Decoder& decoder)
{
    auto referrer = decoder.decode<String>();
    auto userAgent = decoder.decode<String>();
    auto sourceApplicationIdentifier = decoder.decode<String>();
    auto networkInterfaceName = decoder.decode<String>();
    auto audioOutputDeviceId = decoder.decode<String>();
    auto mediaContentTypesRequiringHardwareSupport = decoder.decode<Vector<WebCore::ContentType>>();
    auto allowedMediaContainerTypes = decoder.decode<std::optional<Vector<String>>>();
    auto allowedMediaCodecTypes = decoder.decode<std::optional<Vector<String>>>();
    auto allowedMediaVideoCodecIDs = decoder.decode<std::optional<Vector<WebCore::FourCC>>>();
    auto allowedMediaAudioCodecIDs = decoder.decode<std::optional<Vector<WebCore::FourCC>>>();
    auto allowedMediaCaptionFormatTypes = decoder.decode<std::optional<Vector<WebCore::FourCC>>>();
    auto playerContentBoxRect = decoder.decode<WebCore::LayoutRect>();
    auto preferredAudioCharacteristics = decoder.decode<Vector<String>>();
#if PLATFORM(COCOA)
    auto outOfBandTrackData = decoder.decode<Vector<WebCore::PlatformTextTrackData>>();
#endif
    auto documentSecurityOrigin = decoder.decode<WebCore::SecurityOriginData>();
    auto presentationSize = decoder.decode<WebCore::IntSize>();
    auto videoLayerSize = decoder.decode<WebCore::FloatSize>();
    auto logIdentifier = decoder.decode<uint64_t>();
    auto shouldUsePersistentCache = decoder.decode<bool>();
    auto isVideo = decoder.decode<bool>();
    auto renderingCanBeAccelerated = decoder.decode<bool>();
    auto shouldDisableHDR = decoder.decode<bool>();
#if PLATFORM(IOS_FAMILY)
    auto canShowWhileLocked = decoder.decode<bool>();
#endif
#if HAVE(SPATIAL_AUDIO_EXPERIENCE)
    auto prefersSpatialAudioExperience = decoder.decode<bool>();
#endif
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebKit::RemoteMediaPlayerProxyConfiguration {
            WTFMove(*referrer),
            WTFMove(*userAgent),
            WTFMove(*sourceApplicationIdentifier),
            WTFMove(*networkInterfaceName),
            WTFMove(*audioOutputDeviceId),
            WTFMove(*mediaContentTypesRequiringHardwareSupport),
            WTFMove(*allowedMediaContainerTypes),
            WTFMove(*allowedMediaCodecTypes),
            WTFMove(*allowedMediaVideoCodecIDs),
            WTFMove(*allowedMediaAudioCodecIDs),
            WTFMove(*allowedMediaCaptionFormatTypes),
            WTFMove(*playerContentBoxRect),
            WTFMove(*preferredAudioCharacteristics),
#if PLATFORM(COCOA)
            WTFMove(*outOfBandTrackData),
#endif
            WTFMove(*documentSecurityOrigin),
            WTFMove(*presentationSize),
            WTFMove(*videoLayerSize),
            WTFMove(*logIdentifier),
            WTFMove(*shouldUsePersistentCache),
            WTFMove(*isVideo),
            WTFMove(*renderingCanBeAccelerated),
            WTFMove(*shouldDisableHDR),
#if PLATFORM(IOS_FAMILY)
            WTFMove(*canShowWhileLocked),
#endif
#if HAVE(SPATIAL_AUDIO_EXPERIENCE)
            WTFMove(*prefersSpatialAudioExperience)
#endif
        }
    };
}

#endif

#if ENABLE(GPU_PROCESS) && ENABLE(VIDEO)
void ArgumentCoder<WebKit::RemoteAudioInfo>::encode(Encoder& encoder, const WebKit::RemoteAudioInfo& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.codecName)>, WebCore::FourCC>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.codecString)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.trackID)>, WebCore::TrackID>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.rate)>, uint32_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.channels)>, uint32_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.framesPerPacket)>, uint32_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.bitDepth)>, uint8_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.cookieData)>, RefPtr<WebCore::SharedBuffer>>);
    struct ShouldBeSameSizeAsRemoteAudioInfo : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::RemoteAudioInfo>, false> {
        WebCore::FourCC codecName;
        String codecString;
        WebCore::TrackID trackID;
        uint32_t rate;
        uint32_t channels;
        uint32_t framesPerPacket;
        uint8_t bitDepth;
        RefPtr<WebCore::SharedBuffer> cookieData;
    };
    static_assert(sizeof(ShouldBeSameSizeAsRemoteAudioInfo) == sizeof(WebKit::RemoteAudioInfo));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::RemoteAudioInfo, codecName)
        , offsetof(WebKit::RemoteAudioInfo, codecString)
        , offsetof(WebKit::RemoteAudioInfo, trackID)
        , offsetof(WebKit::RemoteAudioInfo, rate)
        , offsetof(WebKit::RemoteAudioInfo, channels)
        , offsetof(WebKit::RemoteAudioInfo, framesPerPacket)
        , offsetof(WebKit::RemoteAudioInfo, bitDepth)
        , offsetof(WebKit::RemoteAudioInfo, cookieData)
    >::value);

    encoder << instance.codecName;
    encoder << instance.codecString;
    encoder << instance.trackID;
    encoder << instance.rate;
    encoder << instance.channels;
    encoder << instance.framesPerPacket;
    encoder << instance.bitDepth;
    encoder << instance.cookieData;
}

std::optional<WebKit::RemoteAudioInfo> ArgumentCoder<WebKit::RemoteAudioInfo>::decode(Decoder& decoder)
{
    auto codecName = decoder.decode<WebCore::FourCC>();
    auto codecString = decoder.decode<String>();
    auto trackID = decoder.decode<WebCore::TrackID>();
    auto rate = decoder.decode<uint32_t>();
    auto channels = decoder.decode<uint32_t>();
    auto framesPerPacket = decoder.decode<uint32_t>();
    auto bitDepth = decoder.decode<uint8_t>();
    auto cookieData = decoder.decode<RefPtr<WebCore::SharedBuffer>>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebKit::RemoteAudioInfo {
            WTFMove(*codecName),
            WTFMove(*codecString),
            WTFMove(*trackID),
            WTFMove(*rate),
            WTFMove(*channels),
            WTFMove(*framesPerPacket),
            WTFMove(*bitDepth),
            WTFMove(*cookieData)
        }
    };
}

#endif

#if ENABLE(GPU_PROCESS) && ENABLE(VIDEO)
void ArgumentCoder<WebKit::RemoteVideoInfo>::encode(Encoder& encoder, const WebKit::RemoteVideoInfo& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.codecName)>, WebCore::FourCC>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.codecString)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.trackID)>, WebCore::TrackID>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.size)>, WebCore::FloatSize>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.displaySize)>, WebCore::FloatSize>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.bitDepth)>, uint8_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.colorSpace)>, WebCore::PlatformVideoColorSpace>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.atomData)>, RefPtr<WebCore::SharedBuffer>>);
    struct ShouldBeSameSizeAsRemoteVideoInfo : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::RemoteVideoInfo>, false> {
        WebCore::FourCC codecName;
        String codecString;
        WebCore::TrackID trackID;
        WebCore::FloatSize size;
        WebCore::FloatSize displaySize;
        uint8_t bitDepth;
        WebCore::PlatformVideoColorSpace colorSpace;
        RefPtr<WebCore::SharedBuffer> atomData;
    };
    static_assert(sizeof(ShouldBeSameSizeAsRemoteVideoInfo) == sizeof(WebKit::RemoteVideoInfo));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::RemoteVideoInfo, codecName)
        , offsetof(WebKit::RemoteVideoInfo, codecString)
        , offsetof(WebKit::RemoteVideoInfo, trackID)
        , offsetof(WebKit::RemoteVideoInfo, size)
        , offsetof(WebKit::RemoteVideoInfo, displaySize)
        , offsetof(WebKit::RemoteVideoInfo, bitDepth)
        , offsetof(WebKit::RemoteVideoInfo, colorSpace)
        , offsetof(WebKit::RemoteVideoInfo, atomData)
    >::value);

    encoder << instance.codecName;
    encoder << instance.codecString;
    encoder << instance.trackID;
    encoder << instance.size;
    encoder << instance.displaySize;
    encoder << instance.bitDepth;
    encoder << instance.colorSpace;
    encoder << instance.atomData;
}

std::optional<WebKit::RemoteVideoInfo> ArgumentCoder<WebKit::RemoteVideoInfo>::decode(Decoder& decoder)
{
    auto codecName = decoder.decode<WebCore::FourCC>();
    auto codecString = decoder.decode<String>();
    auto trackID = decoder.decode<WebCore::TrackID>();
    auto size = decoder.decode<WebCore::FloatSize>();
    auto displaySize = decoder.decode<WebCore::FloatSize>();
    auto bitDepth = decoder.decode<uint8_t>();
    auto colorSpace = decoder.decode<WebCore::PlatformVideoColorSpace>();
    auto atomData = decoder.decode<RefPtr<WebCore::SharedBuffer>>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebKit::RemoteVideoInfo {
            WTFMove(*codecName),
            WTFMove(*codecString),
            WTFMove(*trackID),
            WTFMove(*size),
            WTFMove(*displaySize),
            WTFMove(*bitDepth),
            WTFMove(*colorSpace),
            WTFMove(*atomData)
        }
    };
}

#endif

#if ENABLE(GPU_PROCESS) && ENABLE(VIDEO)
void ArgumentCoder<WebKit::TextTrackPrivateRemoteConfiguration>::encode(Encoder& encoder, const WebKit::TextTrackPrivateRemoteConfiguration& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.trackId)>, WebCore::TrackID>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.label)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.language)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.inBandMetadataTrackDispatchType)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.startTimeVariance)>, MediaTime>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.trackIndex)>, int>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.cueFormat)>, WebCore::InbandTextTrackPrivate::CueFormat>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.kind)>, WebCore::InbandTextTrackPrivate::Kind>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isClosedCaptions)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isSDH)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.containsOnlyForcedSubtitles)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isMainProgramContent)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isEasyToRead)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isDefault)>, bool>);
    struct ShouldBeSameSizeAsTextTrackPrivateRemoteConfiguration : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::TextTrackPrivateRemoteConfiguration>, false> {
        WebCore::TrackID trackId;
        String label;
        String language;
        String inBandMetadataTrackDispatchType;
        MediaTime startTimeVariance;
        int trackIndex;
        WebCore::InbandTextTrackPrivate::CueFormat cueFormat;
        WebCore::InbandTextTrackPrivate::Kind kind;
        bool isClosedCaptions;
        bool isSDH;
        bool containsOnlyForcedSubtitles;
        bool isMainProgramContent;
        bool isEasyToRead;
        bool isDefault;
    };
    static_assert(sizeof(ShouldBeSameSizeAsTextTrackPrivateRemoteConfiguration) == sizeof(WebKit::TextTrackPrivateRemoteConfiguration));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::TextTrackPrivateRemoteConfiguration, trackId)
        , offsetof(WebKit::TextTrackPrivateRemoteConfiguration, label)
        , offsetof(WebKit::TextTrackPrivateRemoteConfiguration, language)
        , offsetof(WebKit::TextTrackPrivateRemoteConfiguration, inBandMetadataTrackDispatchType)
        , offsetof(WebKit::TextTrackPrivateRemoteConfiguration, startTimeVariance)
        , offsetof(WebKit::TextTrackPrivateRemoteConfiguration, trackIndex)
        , offsetof(WebKit::TextTrackPrivateRemoteConfiguration, cueFormat)
        , offsetof(WebKit::TextTrackPrivateRemoteConfiguration, kind)
        , offsetof(WebKit::TextTrackPrivateRemoteConfiguration, isClosedCaptions)
        , offsetof(WebKit::TextTrackPrivateRemoteConfiguration, isSDH)
        , offsetof(WebKit::TextTrackPrivateRemoteConfiguration, containsOnlyForcedSubtitles)
        , offsetof(WebKit::TextTrackPrivateRemoteConfiguration, isMainProgramContent)
        , offsetof(WebKit::TextTrackPrivateRemoteConfiguration, isEasyToRead)
        , offsetof(WebKit::TextTrackPrivateRemoteConfiguration, isDefault)
    >::value);

    encoder << instance.trackId;
    encoder << instance.label;
    encoder << instance.language;
    encoder << instance.inBandMetadataTrackDispatchType;
    encoder << instance.startTimeVariance;
    encoder << instance.trackIndex;
    encoder << instance.cueFormat;
    encoder << instance.kind;
    encoder << instance.isClosedCaptions;
    encoder << instance.isSDH;
    encoder << instance.containsOnlyForcedSubtitles;
    encoder << instance.isMainProgramContent;
    encoder << instance.isEasyToRead;
    encoder << instance.isDefault;
}

std::optional<WebKit::TextTrackPrivateRemoteConfiguration> ArgumentCoder<WebKit::TextTrackPrivateRemoteConfiguration>::decode(Decoder& decoder)
{
    auto trackId = decoder.decode<WebCore::TrackID>();
    auto label = decoder.decode<String>();
    auto language = decoder.decode<String>();
    auto inBandMetadataTrackDispatchType = decoder.decode<String>();
    auto startTimeVariance = decoder.decode<MediaTime>();
    auto trackIndex = decoder.decode<int>();
    auto cueFormat = decoder.decode<WebCore::InbandTextTrackPrivate::CueFormat>();
    auto kind = decoder.decode<WebCore::InbandTextTrackPrivate::Kind>();
    auto isClosedCaptions = decoder.decode<bool>();
    auto isSDH = decoder.decode<bool>();
    auto containsOnlyForcedSubtitles = decoder.decode<bool>();
    auto isMainProgramContent = decoder.decode<bool>();
    auto isEasyToRead = decoder.decode<bool>();
    auto isDefault = decoder.decode<bool>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebKit::TextTrackPrivateRemoteConfiguration {
            WTFMove(*trackId),
            WTFMove(*label),
            WTFMove(*language),
            WTFMove(*inBandMetadataTrackDispatchType),
            WTFMove(*startTimeVariance),
            WTFMove(*trackIndex),
            WTFMove(*cueFormat),
            WTFMove(*kind),
            WTFMove(*isClosedCaptions),
            WTFMove(*isSDH),
            WTFMove(*containsOnlyForcedSubtitles),
            WTFMove(*isMainProgramContent),
            WTFMove(*isEasyToRead),
            WTFMove(*isDefault)
        }
    };
}

#endif

#if ENABLE(GPU_PROCESS) && ENABLE(VIDEO)
void ArgumentCoder<WebKit::TrackPrivateRemoteConfiguration>::encode(Encoder& encoder, const WebKit::TrackPrivateRemoteConfiguration& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.trackId)>, WebCore::TrackID>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.label)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.language)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.startTimeVariance)>, MediaTime>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.trackIndex)>, int>);
    struct ShouldBeSameSizeAsTrackPrivateRemoteConfiguration : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::TrackPrivateRemoteConfiguration>, false> {
        WebCore::TrackID trackId;
        String label;
        String language;
        MediaTime startTimeVariance;
        int trackIndex;
    };
    static_assert(sizeof(ShouldBeSameSizeAsTrackPrivateRemoteConfiguration) == sizeof(WebKit::TrackPrivateRemoteConfiguration));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::TrackPrivateRemoteConfiguration, trackId)
        , offsetof(WebKit::TrackPrivateRemoteConfiguration, label)
        , offsetof(WebKit::TrackPrivateRemoteConfiguration, language)
        , offsetof(WebKit::TrackPrivateRemoteConfiguration, startTimeVariance)
        , offsetof(WebKit::TrackPrivateRemoteConfiguration, trackIndex)
    >::value);

    encoder << instance.trackId;
    encoder << instance.label;
    encoder << instance.language;
    encoder << instance.startTimeVariance;
    encoder << instance.trackIndex;
}

std::optional<WebKit::TrackPrivateRemoteConfiguration> ArgumentCoder<WebKit::TrackPrivateRemoteConfiguration>::decode(Decoder& decoder)
{
    auto trackId = decoder.decode<WebCore::TrackID>();
    auto label = decoder.decode<String>();
    auto language = decoder.decode<String>();
    auto startTimeVariance = decoder.decode<MediaTime>();
    auto trackIndex = decoder.decode<int>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebKit::TrackPrivateRemoteConfiguration {
            WTFMove(*trackId),
            WTFMove(*label),
            WTFMove(*language),
            WTFMove(*startTimeVariance),
            WTFMove(*trackIndex)
        }
    };
}

#endif

#if ENABLE(GPU_PROCESS) && ENABLE(VIDEO)
void ArgumentCoder<WebKit::VideoTrackPrivateRemoteConfiguration>::encode(Encoder& encoder, const WebKit::VideoTrackPrivateRemoteConfiguration& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.trackId)>, WebCore::TrackID>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.label)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.language)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.startTimeVariance)>, MediaTime>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.trackIndex)>, int>);
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::TrackPrivateRemoteConfiguration, trackId)
        , offsetof(WebKit::TrackPrivateRemoteConfiguration, label)
        , offsetof(WebKit::TrackPrivateRemoteConfiguration, language)
        , offsetof(WebKit::TrackPrivateRemoteConfiguration, startTimeVariance)
        , offsetof(WebKit::TrackPrivateRemoteConfiguration, trackIndex)
    >::value);

    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.selected)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.kind)>, WebCore::VideoTrackPrivate::Kind>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.trackConfiguration)>, WebCore::PlatformVideoTrackConfiguration>);
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::VideoTrackPrivateRemoteConfiguration, selected)
        , offsetof(WebKit::VideoTrackPrivateRemoteConfiguration, kind)
        , offsetof(WebKit::VideoTrackPrivateRemoteConfiguration, trackConfiguration)
    >::value);

    encoder << instance.trackId;
    encoder << instance.label;
    encoder << instance.language;
    encoder << instance.startTimeVariance;
    encoder << instance.trackIndex;
    encoder << instance.selected;
    encoder << instance.kind;
    encoder << instance.trackConfiguration;
}

std::optional<WebKit::VideoTrackPrivateRemoteConfiguration> ArgumentCoder<WebKit::VideoTrackPrivateRemoteConfiguration>::decode(Decoder& decoder)
{
    auto trackId = decoder.decode<WebCore::TrackID>();
    auto label = decoder.decode<String>();
    auto language = decoder.decode<String>();
    auto startTimeVariance = decoder.decode<MediaTime>();
    auto trackIndex = decoder.decode<int>();
    auto selected = decoder.decode<bool>();
    auto kind = decoder.decode<WebCore::VideoTrackPrivate::Kind>();
    auto trackConfiguration = decoder.decode<WebCore::PlatformVideoTrackConfiguration>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebKit::VideoTrackPrivateRemoteConfiguration {
            WebKit::TrackPrivateRemoteConfiguration {
                WTFMove(*trackId),
                WTFMove(*label),
                WTFMove(*language),
                WTFMove(*startTimeVariance),
                WTFMove(*trackIndex)
            },
            WTFMove(*selected),
            WTFMove(*kind),
            WTFMove(*trackConfiguration)
        }
    };
}

#endif

#if ENABLE(MODEL_PROCESS)
void ArgumentCoder<WebKit::ModelProcessCreationParameters>::encode(Encoder& encoder, WebKit::ModelProcessCreationParameters&& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.auxiliaryProcessParameters)>, WebKit::AuxiliaryProcessCreationParameters>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.parentPID)>, ProcessID>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.applicationVisibleName)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.restrictiveRenderingMode)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.debugEntityMemoryLimit)>, std::optional<int>>);
    struct ShouldBeSameSizeAsModelProcessCreationParameters : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::ModelProcessCreationParameters>, false> {
        WebKit::AuxiliaryProcessCreationParameters auxiliaryProcessParameters;
        ProcessID parentPID;
        String applicationVisibleName;
        bool restrictiveRenderingMode;
        std::optional<int> debugEntityMemoryLimit;
    };
    static_assert(sizeof(ShouldBeSameSizeAsModelProcessCreationParameters) == sizeof(WebKit::ModelProcessCreationParameters));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::ModelProcessCreationParameters, auxiliaryProcessParameters)
        , offsetof(WebKit::ModelProcessCreationParameters, parentPID)
        , offsetof(WebKit::ModelProcessCreationParameters, applicationVisibleName)
        , offsetof(WebKit::ModelProcessCreationParameters, restrictiveRenderingMode)
        , offsetof(WebKit::ModelProcessCreationParameters, debugEntityMemoryLimit)
    >::value);

    encoder << WTFMove(instance.auxiliaryProcessParameters);
    encoder << WTFMove(instance.parentPID);
    encoder << WTFMove(instance.applicationVisibleName);
    encoder << WTFMove(instance.restrictiveRenderingMode);
    encoder << WTFMove(instance.debugEntityMemoryLimit);
}

std::optional<WebKit::ModelProcessCreationParameters> ArgumentCoder<WebKit::ModelProcessCreationParameters>::decode(Decoder& decoder)
{
    auto auxiliaryProcessParameters = decoder.decode<WebKit::AuxiliaryProcessCreationParameters>();
    auto parentPID = decoder.decode<ProcessID>();
    auto applicationVisibleName = decoder.decode<String>();
    auto restrictiveRenderingMode = decoder.decode<bool>();
    auto debugEntityMemoryLimit = decoder.decode<std::optional<int>>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebKit::ModelProcessCreationParameters {
            WTFMove(*auxiliaryProcessParameters),
            WTFMove(*parentPID),
            WTFMove(*applicationVisibleName),
            WTFMove(*restrictiveRenderingMode),
            WTFMove(*debugEntityMemoryLimit)
        }
    };
}

#endif

void ArgumentCoder<WebKit::NetworkProcessCreationParameters>::encode(Encoder& encoder, WebKit::NetworkProcessCreationParameters&& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.auxiliaryProcessParameters)>, WebKit::AuxiliaryProcessCreationParameters>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.cacheModel)>, WebKit::CacheModel>);
#if PLATFORM(MAC) || PLATFORM(MACCATALYST)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.uiProcessCookieStorageIdentifier)>, Vector<uint8_t>>);
#endif
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.shouldSuppressMemoryPressureHandler)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.urlSchemesRegisteredForCustomProtocols)>, Vector<String>>);
#if PLATFORM(COCOA)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.uiProcessBundleIdentifier)>, String>);
#endif
#if PLATFORM(COCOA)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.networkATSContext)>, RetainPtr<CFDataRef>>);
#endif
#if PLATFORM(COCOA)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isParentProcessFullWebBrowserOrRunningTest)>, bool>);
#endif
#if USE(SOUP)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.cookieAcceptPolicy)>, WebCore::HTTPCookieAcceptPolicy>);
#endif
#if USE(SOUP)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.languages)>, Vector<String>>);
#endif
#if USE(SOUP)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.memoryPressureHandlerConfiguration)>, std::optional<MemoryPressureHandler::Configuration>>);
#endif
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.urlSchemesRegisteredAsSecure)>, Vector<String>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.urlSchemesRegisteredAsBypassingContentSecurityPolicy)>, Vector<String>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.urlSchemesRegisteredAsLocal)>, Vector<String>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.urlSchemesRegisteredAsNoAccess)>, Vector<String>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.enablePrivateClickMeasurement)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.ftpEnabled)>, bool>);
#if PLATFORM(COCOA)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.enableModernDownloadProgress)>, bool>);
#endif
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.websiteDataStoreParameters)>, Vector<WebKit::WebsiteDataStoreParameters>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.allowedFirstPartiesForCookies)>, Vector<std::pair<WebCore::ProcessIdentifier, WebCore::RegistrableDomain>>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.localhostAliasesForTesting)>, HashSet<String>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.storageAccessPromptQuirksData)>, Vector<WebCore::OrganizationStorageAccessPromptQuirk>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.defaultRequestTimeoutInterval)>, Markable<double>>);
    struct ShouldBeSameSizeAsNetworkProcessCreationParameters : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::NetworkProcessCreationParameters>, false> {
        WebKit::AuxiliaryProcessCreationParameters auxiliaryProcessParameters;
        WebKit::CacheModel cacheModel;
#if PLATFORM(MAC) || PLATFORM(MACCATALYST)
        Vector<uint8_t> uiProcessCookieStorageIdentifier;
#endif
        bool shouldSuppressMemoryPressureHandler;
        Vector<String> urlSchemesRegisteredForCustomProtocols;
#if PLATFORM(COCOA)
        String uiProcessBundleIdentifier;
#endif
#if PLATFORM(COCOA)
        RetainPtr<CFDataRef> networkATSContext;
#endif
#if PLATFORM(COCOA)
        bool isParentProcessFullWebBrowserOrRunningTest;
#endif
#if USE(SOUP)
        WebCore::HTTPCookieAcceptPolicy cookieAcceptPolicy;
#endif
#if USE(SOUP)
        Vector<String> languages;
#endif
#if USE(SOUP)
        std::optional<MemoryPressureHandler::Configuration> memoryPressureHandlerConfiguration;
#endif
        Vector<String> urlSchemesRegisteredAsSecure;
        Vector<String> urlSchemesRegisteredAsBypassingContentSecurityPolicy;
        Vector<String> urlSchemesRegisteredAsLocal;
        Vector<String> urlSchemesRegisteredAsNoAccess;
        bool enablePrivateClickMeasurement;
        bool ftpEnabled;
#if PLATFORM(COCOA)
        bool enableModernDownloadProgress;
#endif
        Vector<WebKit::WebsiteDataStoreParameters> websiteDataStoreParameters;
        Vector<std::pair<WebCore::ProcessIdentifier, WebCore::RegistrableDomain>> allowedFirstPartiesForCookies;
        HashSet<String> localhostAliasesForTesting;
        Vector<WebCore::OrganizationStorageAccessPromptQuirk> storageAccessPromptQuirksData;
        Markable<double> defaultRequestTimeoutInterval;
    };
    static_assert(sizeof(ShouldBeSameSizeAsNetworkProcessCreationParameters) == sizeof(WebKit::NetworkProcessCreationParameters));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::NetworkProcessCreationParameters, auxiliaryProcessParameters)
        , offsetof(WebKit::NetworkProcessCreationParameters, cacheModel)
#if PLATFORM(MAC) || PLATFORM(MACCATALYST)
        , offsetof(WebKit::NetworkProcessCreationParameters, uiProcessCookieStorageIdentifier)
#endif
        , offsetof(WebKit::NetworkProcessCreationParameters, shouldSuppressMemoryPressureHandler)
        , offsetof(WebKit::NetworkProcessCreationParameters, urlSchemesRegisteredForCustomProtocols)
#if PLATFORM(COCOA)
        , offsetof(WebKit::NetworkProcessCreationParameters, uiProcessBundleIdentifier)
#endif
#if PLATFORM(COCOA)
        , offsetof(WebKit::NetworkProcessCreationParameters, networkATSContext)
#endif
#if PLATFORM(COCOA)
        , offsetof(WebKit::NetworkProcessCreationParameters, isParentProcessFullWebBrowserOrRunningTest)
#endif
#if USE(SOUP)
        , offsetof(WebKit::NetworkProcessCreationParameters, cookieAcceptPolicy)
#endif
#if USE(SOUP)
        , offsetof(WebKit::NetworkProcessCreationParameters, languages)
#endif
#if USE(SOUP)
        , offsetof(WebKit::NetworkProcessCreationParameters, memoryPressureHandlerConfiguration)
#endif
        , offsetof(WebKit::NetworkProcessCreationParameters, urlSchemesRegisteredAsSecure)
        , offsetof(WebKit::NetworkProcessCreationParameters, urlSchemesRegisteredAsBypassingContentSecurityPolicy)
        , offsetof(WebKit::NetworkProcessCreationParameters, urlSchemesRegisteredAsLocal)
        , offsetof(WebKit::NetworkProcessCreationParameters, urlSchemesRegisteredAsNoAccess)
        , offsetof(WebKit::NetworkProcessCreationParameters, enablePrivateClickMeasurement)
        , offsetof(WebKit::NetworkProcessCreationParameters, ftpEnabled)
#if PLATFORM(COCOA)
        , offsetof(WebKit::NetworkProcessCreationParameters, enableModernDownloadProgress)
#endif
        , offsetof(WebKit::NetworkProcessCreationParameters, websiteDataStoreParameters)
        , offsetof(WebKit::NetworkProcessCreationParameters, allowedFirstPartiesForCookies)
        , offsetof(WebKit::NetworkProcessCreationParameters, localhostAliasesForTesting)
        , offsetof(WebKit::NetworkProcessCreationParameters, storageAccessPromptQuirksData)
        , offsetof(WebKit::NetworkProcessCreationParameters, defaultRequestTimeoutInterval)
    >::value);

    encoder << WTFMove(instance.auxiliaryProcessParameters);
    encoder << WTFMove(instance.cacheModel);
#if PLATFORM(MAC) || PLATFORM(MACCATALYST)
    encoder << WTFMove(instance.uiProcessCookieStorageIdentifier);
#endif
    encoder << WTFMove(instance.shouldSuppressMemoryPressureHandler);
    encoder << WTFMove(instance.urlSchemesRegisteredForCustomProtocols);
#if PLATFORM(COCOA)
    encoder << WTFMove(instance.uiProcessBundleIdentifier);
#endif
#if PLATFORM(COCOA)
    encoder << WTFMove(instance.networkATSContext);
#endif
#if PLATFORM(COCOA)
    encoder << WTFMove(instance.isParentProcessFullWebBrowserOrRunningTest);
#endif
#if USE(SOUP)
    encoder << WTFMove(instance.cookieAcceptPolicy);
#endif
#if USE(SOUP)
    encoder << WTFMove(instance.languages);
#endif
#if USE(SOUP)
    encoder << WTFMove(instance.memoryPressureHandlerConfiguration);
#endif
    encoder << WTFMove(instance.urlSchemesRegisteredAsSecure);
    encoder << WTFMove(instance.urlSchemesRegisteredAsBypassingContentSecurityPolicy);
    encoder << WTFMove(instance.urlSchemesRegisteredAsLocal);
    encoder << WTFMove(instance.urlSchemesRegisteredAsNoAccess);
    encoder << WTFMove(instance.enablePrivateClickMeasurement);
    encoder << WTFMove(instance.ftpEnabled);
#if PLATFORM(COCOA)
    encoder << WTFMove(instance.enableModernDownloadProgress);
#endif
    encoder << WTFMove(instance.websiteDataStoreParameters);
    encoder << WTFMove(instance.allowedFirstPartiesForCookies);
    encoder << WTFMove(instance.localhostAliasesForTesting);
    encoder << WTFMove(instance.storageAccessPromptQuirksData);
    encoder << WTFMove(instance.defaultRequestTimeoutInterval);
}

std::optional<WebKit::NetworkProcessCreationParameters> ArgumentCoder<WebKit::NetworkProcessCreationParameters>::decode(Decoder& decoder)
{
    auto auxiliaryProcessParameters = decoder.decode<WebKit::AuxiliaryProcessCreationParameters>();
    auto cacheModel = decoder.decode<WebKit::CacheModel>();
#if PLATFORM(MAC) || PLATFORM(MACCATALYST)
    auto uiProcessCookieStorageIdentifier = decoder.decode<Vector<uint8_t>>();
#endif
    auto shouldSuppressMemoryPressureHandler = decoder.decode<bool>();
    auto urlSchemesRegisteredForCustomProtocols = decoder.decode<Vector<String>>();
#if PLATFORM(COCOA)
    auto uiProcessBundleIdentifier = decoder.decode<String>();
#endif
#if PLATFORM(COCOA)
    auto networkATSContext = decoder.decode<RetainPtr<CFDataRef>>();
#endif
#if PLATFORM(COCOA)
    auto isParentProcessFullWebBrowserOrRunningTest = decoder.decode<bool>();
#endif
#if USE(SOUP)
    auto cookieAcceptPolicy = decoder.decode<WebCore::HTTPCookieAcceptPolicy>();
#endif
#if USE(SOUP)
    auto languages = decoder.decode<Vector<String>>();
#endif
#if USE(SOUP)
    auto memoryPressureHandlerConfiguration = decoder.decode<std::optional<MemoryPressureHandler::Configuration>>();
#endif
    auto urlSchemesRegisteredAsSecure = decoder.decode<Vector<String>>();
    auto urlSchemesRegisteredAsBypassingContentSecurityPolicy = decoder.decode<Vector<String>>();
    auto urlSchemesRegisteredAsLocal = decoder.decode<Vector<String>>();
    auto urlSchemesRegisteredAsNoAccess = decoder.decode<Vector<String>>();
    auto enablePrivateClickMeasurement = decoder.decode<bool>();
    auto ftpEnabled = decoder.decode<bool>();
#if PLATFORM(COCOA)
    auto enableModernDownloadProgress = decoder.decode<bool>();
#endif
    auto websiteDataStoreParameters = decoder.decode<Vector<WebKit::WebsiteDataStoreParameters>>();
    auto allowedFirstPartiesForCookies = decoder.decode<Vector<std::pair<WebCore::ProcessIdentifier, WebCore::RegistrableDomain>>>();
    auto localhostAliasesForTesting = decoder.decode<HashSet<String>>();
    auto storageAccessPromptQuirksData = decoder.decode<Vector<WebCore::OrganizationStorageAccessPromptQuirk>>();
    auto defaultRequestTimeoutInterval = decoder.decode<Markable<double>>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebKit::NetworkProcessCreationParameters {
            WTFMove(*auxiliaryProcessParameters),
            WTFMove(*cacheModel),
#if PLATFORM(MAC) || PLATFORM(MACCATALYST)
            WTFMove(*uiProcessCookieStorageIdentifier),
#endif
            WTFMove(*shouldSuppressMemoryPressureHandler),
            WTFMove(*urlSchemesRegisteredForCustomProtocols),
#if PLATFORM(COCOA)
            WTFMove(*uiProcessBundleIdentifier),
#endif
#if PLATFORM(COCOA)
            WTFMove(*networkATSContext),
#endif
#if PLATFORM(COCOA)
            WTFMove(*isParentProcessFullWebBrowserOrRunningTest),
#endif
#if USE(SOUP)
            WTFMove(*cookieAcceptPolicy),
#endif
#if USE(SOUP)
            WTFMove(*languages),
#endif
#if USE(SOUP)
            WTFMove(*memoryPressureHandlerConfiguration),
#endif
            WTFMove(*urlSchemesRegisteredAsSecure),
            WTFMove(*urlSchemesRegisteredAsBypassingContentSecurityPolicy),
            WTFMove(*urlSchemesRegisteredAsLocal),
            WTFMove(*urlSchemesRegisteredAsNoAccess),
            WTFMove(*enablePrivateClickMeasurement),
            WTFMove(*ftpEnabled),
#if PLATFORM(COCOA)
            WTFMove(*enableModernDownloadProgress),
#endif
            WTFMove(*websiteDataStoreParameters),
            WTFMove(*allowedFirstPartiesForCookies),
            WTFMove(*localhostAliasesForTesting),
            WTFMove(*storageAccessPromptQuirksData),
            WTFMove(*defaultRequestTimeoutInterval)
        }
    };
}

void ArgumentCoder<WebKit::NetworkResourceLoadParameters>::encode(Encoder& encoder, WebKit::NetworkResourceLoadParameters&& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.webPageProxyID)>, WebKit::WebPageProxyIdentifier>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.webPageID)>, WebCore::PageIdentifier>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.webFrameID)>, WebCore::FrameIdentifier>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.request)>, WebCore::ResourceRequest>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.topOrigin)>, RefPtr<WebCore::SecurityOrigin>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.sourceOrigin)>, RefPtr<WebCore::SecurityOrigin>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.parentPID)>, WTF::ProcessID>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.contentSniffingPolicy)>, WebCore::ContentSniffingPolicy>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.contentEncodingSniffingPolicy)>, WebCore::ContentEncodingSniffingPolicy>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.storedCredentialsPolicy)>, WebCore::StoredCredentialsPolicy>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.clientCredentialPolicy)>, WebCore::ClientCredentialPolicy>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.shouldClearReferrerOnHTTPSToHTTPRedirect)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.needsCertificateInfo)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isMainFrameNavigation)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.mainResourceNavigationDataForAnyFrame)>, std::optional<WebKit::NavigationActionData>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.shouldPreconnectOnly)>, WebKit::PreconnectOnly>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isNavigatingToAppBoundDomain)>, std::optional<WebKit::NavigatingToAppBoundDomain>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.hadMainFrameMainResourcePrivateRelayed)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.allowPrivacyProxy)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.advancedPrivacyProtections)>, OptionSet<WebCore::AdvancedPrivacyProtections>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.requiredCookiesVersion)>, uint64_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.identifier)>, Markable<WebCore::ResourceLoaderIdentifier>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.requestBodySandboxExtensions)>, Vector<WebKit::SandboxExtensionHandle>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.resourceSandboxExtension)>, std::optional<WebKit::SandboxExtensionHandle>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.maximumBufferingTime)>, Seconds>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.options)>, WebCore::FetchOptions>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.cspResponseHeaders)>, std::optional<WebCore::ContentSecurityPolicyResponseHeaders>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.parentFrameURL)>, URL>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.frameURL)>, URL>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.parentCrossOriginEmbedderPolicy)>, WebCore::CrossOriginEmbedderPolicy>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.crossOriginEmbedderPolicy)>, WebCore::CrossOriginEmbedderPolicy>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.originalRequestHeaders)>, WebCore::HTTPHeaderMap>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.shouldRestrictHTTPResponseAccess)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.preflightPolicy)>, WebCore::PreflightPolicy>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.shouldEnableCrossOriginResourcePolicy)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.frameAncestorOrigins)>, Vector<Ref<WebCore::SecurityOrigin>>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.pageHasResourceLoadClient)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.parentFrameID)>, std::optional<WebCore::FrameIdentifier>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.crossOriginAccessControlCheckEnabled)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.documentURL)>, URL>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isCrossOriginOpenerPolicyEnabled)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isClearSiteDataHeaderEnabled)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isClearSiteDataExecutionContextEnabled)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isDisplayingInitialEmptyDocument)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.effectiveSandboxFlags)>, WebCore::SandboxFlags>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.openerURL)>, URL>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.sourceCrossOriginOpenerPolicy)>, WebCore::CrossOriginOpenerPolicy>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.navigationID)>, std::optional<WebCore::NavigationIdentifier>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.navigationRequester)>, std::optional<WebCore::NavigationRequester>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.serviceWorkersMode)>, WebCore::ServiceWorkersMode>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.serviceWorkerRegistrationIdentifier)>, std::optional<WebCore::ServiceWorkerRegistrationIdentifier>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.httpHeadersToKeep)>, OptionSet<WebCore::HTTPHeadersToKeepFromCleaning>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.navigationPreloadIdentifier)>, std::optional<WebCore::FetchIdentifier>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.workerIdentifier)>, WebCore::FetchingWorkerIdentifier>);
#if ENABLE(CONTENT_EXTENSIONS)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.mainDocumentURL)>, URL>);
#endif
#if ENABLE(CONTENT_EXTENSIONS)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.userContentControllerIdentifier)>, std::optional<WebKit::UserContentControllerIdentifier>>);
#endif
#if ENABLE(WK_WEB_EXTENSIONS)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.pageHasLoadedWebExtensions)>, bool>);
#endif
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.linkPreconnectEarlyHintsEnabled)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.shouldRecordFrameLoadForStorageAccess)>, bool>);
    struct ShouldBeSameSizeAsNetworkResourceLoadParameters : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::NetworkResourceLoadParameters>, false> {
        WebKit::WebPageProxyIdentifier webPageProxyID;
        WebCore::PageIdentifier webPageID;
        WebCore::FrameIdentifier webFrameID;
        WebCore::ResourceRequest request;
        RefPtr<WebCore::SecurityOrigin> topOrigin;
        RefPtr<WebCore::SecurityOrigin> sourceOrigin;
        WTF::ProcessID parentPID;
        WebCore::ContentSniffingPolicy contentSniffingPolicy;
        WebCore::ContentEncodingSniffingPolicy contentEncodingSniffingPolicy;
        WebCore::StoredCredentialsPolicy storedCredentialsPolicy;
        WebCore::ClientCredentialPolicy clientCredentialPolicy;
        bool shouldClearReferrerOnHTTPSToHTTPRedirect;
        bool needsCertificateInfo;
        bool isMainFrameNavigation;
        std::optional<WebKit::NavigationActionData> mainResourceNavigationDataForAnyFrame;
        WebKit::PreconnectOnly shouldPreconnectOnly;
        std::optional<WebKit::NavigatingToAppBoundDomain> isNavigatingToAppBoundDomain;
        bool hadMainFrameMainResourcePrivateRelayed;
        bool allowPrivacyProxy;
        OptionSet<WebCore::AdvancedPrivacyProtections> advancedPrivacyProtections;
        uint64_t requiredCookiesVersion;
        Markable<WebCore::ResourceLoaderIdentifier> identifier;
        Vector<WebKit::SandboxExtensionHandle> requestBodySandboxExtensions;
        std::optional<WebKit::SandboxExtensionHandle> resourceSandboxExtension;
        Seconds maximumBufferingTime;
        WebCore::FetchOptions options;
        std::optional<WebCore::ContentSecurityPolicyResponseHeaders> cspResponseHeaders;
        URL parentFrameURL;
        URL frameURL;
        WebCore::CrossOriginEmbedderPolicy parentCrossOriginEmbedderPolicy;
        WebCore::CrossOriginEmbedderPolicy crossOriginEmbedderPolicy;
        WebCore::HTTPHeaderMap originalRequestHeaders;
        bool shouldRestrictHTTPResponseAccess;
        WebCore::PreflightPolicy preflightPolicy;
        bool shouldEnableCrossOriginResourcePolicy;
        Vector<Ref<WebCore::SecurityOrigin>> frameAncestorOrigins;
        bool pageHasResourceLoadClient;
        std::optional<WebCore::FrameIdentifier> parentFrameID;
        bool crossOriginAccessControlCheckEnabled;
        URL documentURL;
        bool isCrossOriginOpenerPolicyEnabled;
        bool isClearSiteDataHeaderEnabled;
        bool isClearSiteDataExecutionContextEnabled;
        bool isDisplayingInitialEmptyDocument;
        WebCore::SandboxFlags effectiveSandboxFlags;
        URL openerURL;
        WebCore::CrossOriginOpenerPolicy sourceCrossOriginOpenerPolicy;
        std::optional<WebCore::NavigationIdentifier> navigationID;
        std::optional<WebCore::NavigationRequester> navigationRequester;
        WebCore::ServiceWorkersMode serviceWorkersMode;
        std::optional<WebCore::ServiceWorkerRegistrationIdentifier> serviceWorkerRegistrationIdentifier;
        OptionSet<WebCore::HTTPHeadersToKeepFromCleaning> httpHeadersToKeep;
        std::optional<WebCore::FetchIdentifier> navigationPreloadIdentifier;
        WebCore::FetchingWorkerIdentifier workerIdentifier;
#if ENABLE(CONTENT_EXTENSIONS)
        URL mainDocumentURL;
#endif
#if ENABLE(CONTENT_EXTENSIONS)
        std::optional<WebKit::UserContentControllerIdentifier> userContentControllerIdentifier;
#endif
#if ENABLE(WK_WEB_EXTENSIONS)
        bool pageHasLoadedWebExtensions;
#endif
        bool linkPreconnectEarlyHintsEnabled;
        bool shouldRecordFrameLoadForStorageAccess;
    };
    static_assert(sizeof(ShouldBeSameSizeAsNetworkResourceLoadParameters) == sizeof(WebKit::NetworkResourceLoadParameters));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::NetworkResourceLoadParameters, webPageProxyID)
        , offsetof(WebKit::NetworkResourceLoadParameters, webPageID)
        , offsetof(WebKit::NetworkResourceLoadParameters, webFrameID)
        , offsetof(WebKit::NetworkResourceLoadParameters, request)
        , offsetof(WebKit::NetworkResourceLoadParameters, topOrigin)
        , offsetof(WebKit::NetworkResourceLoadParameters, sourceOrigin)
        , offsetof(WebKit::NetworkResourceLoadParameters, parentPID)
        , offsetof(WebKit::NetworkResourceLoadParameters, contentSniffingPolicy)
        , offsetof(WebKit::NetworkResourceLoadParameters, contentEncodingSniffingPolicy)
        , offsetof(WebKit::NetworkResourceLoadParameters, storedCredentialsPolicy)
        , offsetof(WebKit::NetworkResourceLoadParameters, clientCredentialPolicy)
        , offsetof(WebKit::NetworkResourceLoadParameters, shouldClearReferrerOnHTTPSToHTTPRedirect)
        , offsetof(WebKit::NetworkResourceLoadParameters, needsCertificateInfo)
        , offsetof(WebKit::NetworkResourceLoadParameters, isMainFrameNavigation)
        , offsetof(WebKit::NetworkResourceLoadParameters, mainResourceNavigationDataForAnyFrame)
        , offsetof(WebKit::NetworkResourceLoadParameters, shouldPreconnectOnly)
        , offsetof(WebKit::NetworkResourceLoadParameters, isNavigatingToAppBoundDomain)
        , offsetof(WebKit::NetworkResourceLoadParameters, hadMainFrameMainResourcePrivateRelayed)
        , offsetof(WebKit::NetworkResourceLoadParameters, allowPrivacyProxy)
        , offsetof(WebKit::NetworkResourceLoadParameters, advancedPrivacyProtections)
        , offsetof(WebKit::NetworkResourceLoadParameters, requiredCookiesVersion)
        , offsetof(WebKit::NetworkResourceLoadParameters, identifier)
        , offsetof(WebKit::NetworkResourceLoadParameters, requestBodySandboxExtensions)
        , offsetof(WebKit::NetworkResourceLoadParameters, resourceSandboxExtension)
        , offsetof(WebKit::NetworkResourceLoadParameters, maximumBufferingTime)
        , offsetof(WebKit::NetworkResourceLoadParameters, options)
        , offsetof(WebKit::NetworkResourceLoadParameters, cspResponseHeaders)
        , offsetof(WebKit::NetworkResourceLoadParameters, parentFrameURL)
        , offsetof(WebKit::NetworkResourceLoadParameters, frameURL)
        , offsetof(WebKit::NetworkResourceLoadParameters, parentCrossOriginEmbedderPolicy)
        , offsetof(WebKit::NetworkResourceLoadParameters, crossOriginEmbedderPolicy)
        , offsetof(WebKit::NetworkResourceLoadParameters, originalRequestHeaders)
        , offsetof(WebKit::NetworkResourceLoadParameters, shouldRestrictHTTPResponseAccess)
        , offsetof(WebKit::NetworkResourceLoadParameters, preflightPolicy)
        , offsetof(WebKit::NetworkResourceLoadParameters, shouldEnableCrossOriginResourcePolicy)
        , offsetof(WebKit::NetworkResourceLoadParameters, frameAncestorOrigins)
        , offsetof(WebKit::NetworkResourceLoadParameters, pageHasResourceLoadClient)
        , offsetof(WebKit::NetworkResourceLoadParameters, parentFrameID)
        , offsetof(WebKit::NetworkResourceLoadParameters, crossOriginAccessControlCheckEnabled)
        , offsetof(WebKit::NetworkResourceLoadParameters, documentURL)
        , offsetof(WebKit::NetworkResourceLoadParameters, isCrossOriginOpenerPolicyEnabled)
        , offsetof(WebKit::NetworkResourceLoadParameters, isClearSiteDataHeaderEnabled)
        , offsetof(WebKit::NetworkResourceLoadParameters, isClearSiteDataExecutionContextEnabled)
        , offsetof(WebKit::NetworkResourceLoadParameters, isDisplayingInitialEmptyDocument)
        , offsetof(WebKit::NetworkResourceLoadParameters, effectiveSandboxFlags)
        , offsetof(WebKit::NetworkResourceLoadParameters, openerURL)
        , offsetof(WebKit::NetworkResourceLoadParameters, sourceCrossOriginOpenerPolicy)
        , offsetof(WebKit::NetworkResourceLoadParameters, navigationID)
        , offsetof(WebKit::NetworkResourceLoadParameters, navigationRequester)
        , offsetof(WebKit::NetworkResourceLoadParameters, serviceWorkersMode)
        , offsetof(WebKit::NetworkResourceLoadParameters, serviceWorkerRegistrationIdentifier)
        , offsetof(WebKit::NetworkResourceLoadParameters, httpHeadersToKeep)
        , offsetof(WebKit::NetworkResourceLoadParameters, navigationPreloadIdentifier)
        , offsetof(WebKit::NetworkResourceLoadParameters, workerIdentifier)
#if ENABLE(CONTENT_EXTENSIONS)
        , offsetof(WebKit::NetworkResourceLoadParameters, mainDocumentURL)
#endif
#if ENABLE(CONTENT_EXTENSIONS)
        , offsetof(WebKit::NetworkResourceLoadParameters, userContentControllerIdentifier)
#endif
#if ENABLE(WK_WEB_EXTENSIONS)
        , offsetof(WebKit::NetworkResourceLoadParameters, pageHasLoadedWebExtensions)
#endif
        , offsetof(WebKit::NetworkResourceLoadParameters, linkPreconnectEarlyHintsEnabled)
        , offsetof(WebKit::NetworkResourceLoadParameters, shouldRecordFrameLoadForStorageAccess)
    >::value);

    encoder << WTFMove(instance.webPageProxyID);
    encoder << WTFMove(instance.webPageID);
    encoder << WTFMove(instance.webFrameID);
    RefPtr requestBody = instance.request.httpBody();
    encoder << WTFMove(instance.request);
    encoder << IPC::FormDataReference { WTFMove(requestBody) };
    encoder << WTFMove(instance.topOrigin);
    encoder << WTFMove(instance.sourceOrigin);
    encoder << WTFMove(instance.parentPID);
    encoder << WTFMove(instance.contentSniffingPolicy);
    encoder << WTFMove(instance.contentEncodingSniffingPolicy);
    encoder << WTFMove(instance.storedCredentialsPolicy);
    encoder << WTFMove(instance.clientCredentialPolicy);
    encoder << WTFMove(instance.shouldClearReferrerOnHTTPSToHTTPRedirect);
    encoder << WTFMove(instance.needsCertificateInfo);
    encoder << WTFMove(instance.isMainFrameNavigation);
    encoder << WTFMove(instance.mainResourceNavigationDataForAnyFrame);
    encoder << WTFMove(instance.shouldPreconnectOnly);
    encoder << WTFMove(instance.isNavigatingToAppBoundDomain);
    encoder << WTFMove(instance.hadMainFrameMainResourcePrivateRelayed);
    encoder << WTFMove(instance.allowPrivacyProxy);
    encoder << WTFMove(instance.advancedPrivacyProtections);
    encoder << WTFMove(instance.requiredCookiesVersion);
    encoder << WTFMove(instance.identifier);
    encoder << WTFMove(instance.requestBodySandboxExtensions);
    encoder << WTFMove(instance.resourceSandboxExtension);
    encoder << WTFMove(instance.maximumBufferingTime);
    encoder << WTFMove(instance.options);
    encoder << WTFMove(instance.cspResponseHeaders);
    encoder << WTFMove(instance.parentFrameURL);
    encoder << WTFMove(instance.frameURL);
    encoder << WTFMove(instance.parentCrossOriginEmbedderPolicy);
    encoder << WTFMove(instance.crossOriginEmbedderPolicy);
    encoder << WTFMove(instance.originalRequestHeaders);
    encoder << WTFMove(instance.shouldRestrictHTTPResponseAccess);
    encoder << WTFMove(instance.preflightPolicy);
    encoder << WTFMove(instance.shouldEnableCrossOriginResourcePolicy);
    encoder << WTFMove(instance.frameAncestorOrigins);
    encoder << WTFMove(instance.pageHasResourceLoadClient);
    encoder << WTFMove(instance.parentFrameID);
    encoder << WTFMove(instance.crossOriginAccessControlCheckEnabled);
    encoder << WTFMove(instance.documentURL);
    encoder << WTFMove(instance.isCrossOriginOpenerPolicyEnabled);
    encoder << WTFMove(instance.isClearSiteDataHeaderEnabled);
    encoder << WTFMove(instance.isClearSiteDataExecutionContextEnabled);
    encoder << WTFMove(instance.isDisplayingInitialEmptyDocument);
    encoder << WTFMove(instance.effectiveSandboxFlags);
    encoder << WTFMove(instance.openerURL);
    encoder << WTFMove(instance.sourceCrossOriginOpenerPolicy);
    encoder << WTFMove(instance.navigationID);
    encoder << WTFMove(instance.navigationRequester);
    encoder << WTFMove(instance.serviceWorkersMode);
    encoder << WTFMove(instance.serviceWorkerRegistrationIdentifier);
    encoder << WTFMove(instance.httpHeadersToKeep);
    encoder << WTFMove(instance.navigationPreloadIdentifier);
    encoder << WTFMove(instance.workerIdentifier);
#if ENABLE(CONTENT_EXTENSIONS)
    encoder << WTFMove(instance.mainDocumentURL);
#endif
#if ENABLE(CONTENT_EXTENSIONS)
    encoder << WTFMove(instance.userContentControllerIdentifier);
#endif
#if ENABLE(WK_WEB_EXTENSIONS)
    encoder << WTFMove(instance.pageHasLoadedWebExtensions);
#endif
    encoder << WTFMove(instance.linkPreconnectEarlyHintsEnabled);
    encoder << WTFMove(instance.shouldRecordFrameLoadForStorageAccess);
}

std::optional<WebKit::NetworkResourceLoadParameters> ArgumentCoder<WebKit::NetworkResourceLoadParameters>::decode(Decoder& decoder)
{
    auto webPageProxyID = decoder.decode<WebKit::WebPageProxyIdentifier>();
    auto webPageID = decoder.decode<WebCore::PageIdentifier>();
    auto webFrameID = decoder.decode<WebCore::FrameIdentifier>();
    auto request = decoder.decode<WebCore::ResourceRequest>();
    if (request) {
        if (auto requestBody = decoder.decode<IPC::FormDataReference>())
            request->setHTTPBody(requestBody->takeData());
    }
    auto topOrigin = decoder.decode<RefPtr<WebCore::SecurityOrigin>>();
    auto sourceOrigin = decoder.decode<RefPtr<WebCore::SecurityOrigin>>();
    auto parentPID = decoder.decode<WTF::ProcessID>();
    auto contentSniffingPolicy = decoder.decode<WebCore::ContentSniffingPolicy>();
    auto contentEncodingSniffingPolicy = decoder.decode<WebCore::ContentEncodingSniffingPolicy>();
    auto storedCredentialsPolicy = decoder.decode<WebCore::StoredCredentialsPolicy>();
    auto clientCredentialPolicy = decoder.decode<WebCore::ClientCredentialPolicy>();
    auto shouldClearReferrerOnHTTPSToHTTPRedirect = decoder.decode<bool>();
    auto needsCertificateInfo = decoder.decode<bool>();
    auto isMainFrameNavigation = decoder.decode<bool>();
    auto mainResourceNavigationDataForAnyFrame = decoder.decode<std::optional<WebKit::NavigationActionData>>();
    auto shouldPreconnectOnly = decoder.decode<WebKit::PreconnectOnly>();
    auto isNavigatingToAppBoundDomain = decoder.decode<std::optional<WebKit::NavigatingToAppBoundDomain>>();
    auto hadMainFrameMainResourcePrivateRelayed = decoder.decode<bool>();
    auto allowPrivacyProxy = decoder.decode<bool>();
    auto advancedPrivacyProtections = decoder.decode<OptionSet<WebCore::AdvancedPrivacyProtections>>();
    auto requiredCookiesVersion = decoder.decode<uint64_t>();
    auto identifier = decoder.decode<Markable<WebCore::ResourceLoaderIdentifier>>();
    auto requestBodySandboxExtensions = decoder.decode<Vector<WebKit::SandboxExtensionHandle>>();
    auto resourceSandboxExtension = decoder.decode<std::optional<WebKit::SandboxExtensionHandle>>();
    auto maximumBufferingTime = decoder.decode<Seconds>();
    auto options = decoder.decode<WebCore::FetchOptions>();
    auto cspResponseHeaders = decoder.decode<std::optional<WebCore::ContentSecurityPolicyResponseHeaders>>();
    auto parentFrameURL = decoder.decode<URL>();
    auto frameURL = decoder.decode<URL>();
    auto parentCrossOriginEmbedderPolicy = decoder.decode<WebCore::CrossOriginEmbedderPolicy>();
    auto crossOriginEmbedderPolicy = decoder.decode<WebCore::CrossOriginEmbedderPolicy>();
    auto originalRequestHeaders = decoder.decode<WebCore::HTTPHeaderMap>();
    auto shouldRestrictHTTPResponseAccess = decoder.decode<bool>();
    auto preflightPolicy = decoder.decode<WebCore::PreflightPolicy>();
    auto shouldEnableCrossOriginResourcePolicy = decoder.decode<bool>();
    auto frameAncestorOrigins = decoder.decode<Vector<Ref<WebCore::SecurityOrigin>>>();
    auto pageHasResourceLoadClient = decoder.decode<bool>();
    auto parentFrameID = decoder.decode<std::optional<WebCore::FrameIdentifier>>();
    auto crossOriginAccessControlCheckEnabled = decoder.decode<bool>();
    auto documentURL = decoder.decode<URL>();
    auto isCrossOriginOpenerPolicyEnabled = decoder.decode<bool>();
    auto isClearSiteDataHeaderEnabled = decoder.decode<bool>();
    auto isClearSiteDataExecutionContextEnabled = decoder.decode<bool>();
    auto isDisplayingInitialEmptyDocument = decoder.decode<bool>();
    auto effectiveSandboxFlags = decoder.decode<WebCore::SandboxFlags>();
    auto openerURL = decoder.decode<URL>();
    auto sourceCrossOriginOpenerPolicy = decoder.decode<WebCore::CrossOriginOpenerPolicy>();
    auto navigationID = decoder.decode<std::optional<WebCore::NavigationIdentifier>>();
    auto navigationRequester = decoder.decode<std::optional<WebCore::NavigationRequester>>();
    auto serviceWorkersMode = decoder.decode<WebCore::ServiceWorkersMode>();
    auto serviceWorkerRegistrationIdentifier = decoder.decode<std::optional<WebCore::ServiceWorkerRegistrationIdentifier>>();
    auto httpHeadersToKeep = decoder.decode<OptionSet<WebCore::HTTPHeadersToKeepFromCleaning>>();
    auto navigationPreloadIdentifier = decoder.decode<std::optional<WebCore::FetchIdentifier>>();
    auto workerIdentifier = decoder.decode<WebCore::FetchingWorkerIdentifier>();
#if ENABLE(CONTENT_EXTENSIONS)
    auto mainDocumentURL = decoder.decode<URL>();
#endif
#if ENABLE(CONTENT_EXTENSIONS)
    auto userContentControllerIdentifier = decoder.decode<std::optional<WebKit::UserContentControllerIdentifier>>();
#endif
#if ENABLE(WK_WEB_EXTENSIONS)
    auto pageHasLoadedWebExtensions = decoder.decode<bool>();
#endif
    auto linkPreconnectEarlyHintsEnabled = decoder.decode<bool>();
    auto shouldRecordFrameLoadForStorageAccess = decoder.decode<bool>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebKit::NetworkResourceLoadParameters {
            WTFMove(*webPageProxyID),
            WTFMove(*webPageID),
            WTFMove(*webFrameID),
            WTFMove(*request),
            WTFMove(*topOrigin),
            WTFMove(*sourceOrigin),
            WTFMove(*parentPID),
            WTFMove(*contentSniffingPolicy),
            WTFMove(*contentEncodingSniffingPolicy),
            WTFMove(*storedCredentialsPolicy),
            WTFMove(*clientCredentialPolicy),
            WTFMove(*shouldClearReferrerOnHTTPSToHTTPRedirect),
            WTFMove(*needsCertificateInfo),
            WTFMove(*isMainFrameNavigation),
            WTFMove(*mainResourceNavigationDataForAnyFrame),
            WTFMove(*shouldPreconnectOnly),
            WTFMove(*isNavigatingToAppBoundDomain),
            WTFMove(*hadMainFrameMainResourcePrivateRelayed),
            WTFMove(*allowPrivacyProxy),
            WTFMove(*advancedPrivacyProtections),
            WTFMove(*requiredCookiesVersion),
            WTFMove(*identifier),
            WTFMove(*requestBodySandboxExtensions),
            WTFMove(*resourceSandboxExtension),
            WTFMove(*maximumBufferingTime),
            WTFMove(*options),
            WTFMove(*cspResponseHeaders),
            WTFMove(*parentFrameURL),
            WTFMove(*frameURL),
            WTFMove(*parentCrossOriginEmbedderPolicy),
            WTFMove(*crossOriginEmbedderPolicy),
            WTFMove(*originalRequestHeaders),
            WTFMove(*shouldRestrictHTTPResponseAccess),
            WTFMove(*preflightPolicy),
            WTFMove(*shouldEnableCrossOriginResourcePolicy),
            WTFMove(*frameAncestorOrigins),
            WTFMove(*pageHasResourceLoadClient),
            WTFMove(*parentFrameID),
            WTFMove(*crossOriginAccessControlCheckEnabled),
            WTFMove(*documentURL),
            WTFMove(*isCrossOriginOpenerPolicyEnabled),
            WTFMove(*isClearSiteDataHeaderEnabled),
            WTFMove(*isClearSiteDataExecutionContextEnabled),
            WTFMove(*isDisplayingInitialEmptyDocument),
            WTFMove(*effectiveSandboxFlags),
            WTFMove(*openerURL),
            WTFMove(*sourceCrossOriginOpenerPolicy),
            WTFMove(*navigationID),
            WTFMove(*navigationRequester),
            WTFMove(*serviceWorkersMode),
            WTFMove(*serviceWorkerRegistrationIdentifier),
            WTFMove(*httpHeadersToKeep),
            WTFMove(*navigationPreloadIdentifier),
            WTFMove(*workerIdentifier),
#if ENABLE(CONTENT_EXTENSIONS)
            WTFMove(*mainDocumentURL),
#endif
#if ENABLE(CONTENT_EXTENSIONS)
            WTFMove(*userContentControllerIdentifier),
#endif
#if ENABLE(WK_WEB_EXTENSIONS)
            WTFMove(*pageHasLoadedWebExtensions),
#endif
            WTFMove(*linkPreconnectEarlyHintsEnabled),
            WTFMove(*shouldRecordFrameLoadForStorageAccess)
        }
    };
}

void ArgumentCoder<WebKit::NetworkSessionCreationParameters>::encode(Encoder& encoder, WebKit::NetworkSessionCreationParameters&& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.sessionID)>, PAL::SessionID>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.dataStoreIdentifier)>, Markable<WTF::UUID>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.boundInterfaceIdentifier)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.allowsCellularAccess)>, WebKit::AllowsCellularAccess>);
#if PLATFORM(COCOA)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.proxyConfiguration)>, RetainPtr<CFDictionaryRef>>);
#endif
#if PLATFORM(COCOA)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.sourceApplicationBundleIdentifier)>, String>);
#endif
#if PLATFORM(COCOA)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.sourceApplicationSecondaryIdentifier)>, String>);
#endif
#if PLATFORM(COCOA)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.shouldLogCookieInformation)>, bool>);
#endif
#if PLATFORM(COCOA)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.httpProxy)>, URL>);
#endif
#if PLATFORM(COCOA)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.httpsProxy)>, URL>);
#endif
#if HAVE(ALTERNATIVE_SERVICE)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.alternativeServiceDirectory)>, String>);
#endif
#if HAVE(ALTERNATIVE_SERVICE)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.alternativeServiceDirectoryExtensionHandle)>, WebKit::SandboxExtensionHandle>);
#endif
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.hstsStorageDirectory)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.hstsStorageDirectoryExtensionHandle)>, WebKit::SandboxExtensionHandle>);
#if USE(SOUP)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.cookiePersistentStoragePath)>, String>);
#endif
#if USE(SOUP)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.cookiePersistentStorageType)>, WebKit::SoupCookiePersistentStorageType>);
#endif
#if USE(SOUP)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.persistentCredentialStorageEnabled)>, bool>);
#endif
#if USE(SOUP)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.ignoreTLSErrors)>, bool>);
#endif
#if USE(SOUP)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.proxySettings)>, WebCore::SoupNetworkProxySettings>);
#endif
#if USE(SOUP)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.cookieAcceptPolicy)>, WebCore::HTTPCookieAcceptPolicy>);
#endif
#if USE(CURL)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.cookiePersistentStorageFile)>, String>);
#endif
#if USE(CURL)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.proxySettings)>, WebCore::CurlProxySettings>);
#endif
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.deviceManagementRestrictionsEnabled)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.allLoadsBlockedByDeviceManagementRestrictionsForTesting)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.webPushDaemonConnectionConfiguration)>, WebKit::WebPushD::WebPushDaemonConnectionConfiguration>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.networkCacheDirectory)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.networkCacheDirectoryExtensionHandle)>, WebKit::SandboxExtensionHandle>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.dataConnectionServiceType)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.fastServerTrustEvaluationEnabled)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.networkCacheSpeculativeValidationEnabled)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.shouldUseTestingNetworkSession)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.staleWhileRevalidateEnabled)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.testSpeedMultiplier)>, unsigned>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.suppressesConnectionTerminationOnSystemChange)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.allowsServerPreconnect)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.requiresSecureHTTPSProxyConnection)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.shouldRunServiceWorkersOnMainThreadForTesting)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.overrideServiceWorkerRegistrationCountTestingValue)>, std::optional<unsigned>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.preventsSystemHTTPProxyAuthentication)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.useNetworkLoader)>, std::optional<bool>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.allowsHSTSWithUntrustedRootCertificate)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.pcmMachServiceName)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.webPushMachServiceName)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.webPushPartitionString)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.enablePrivateClickMeasurementDebugMode)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isOptInCookiePartitioningEnabled)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.shouldSendPrivateTokenIPCForTesting)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.cookiesVersion)>, uint64_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.unifiedOriginStorageLevel)>, WebKit::UnifiedOriginStorageLevel>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.perOriginStorageQuota)>, uint64_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.originQuotaRatio)>, std::optional<double>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.totalQuotaRatio)>, std::optional<double>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.standardVolumeCapacity)>, std::optional<uint64_t>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.volumeCapacityOverride)>, std::optional<uint64_t>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.localStorageDirectory)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.localStorageDirectoryExtensionHandle)>, WebKit::SandboxExtensionHandle>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.indexedDBDirectory)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.indexedDBDirectoryExtensionHandle)>, WebKit::SandboxExtensionHandle>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.cacheStorageDirectory)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.cacheStorageDirectoryExtensionHandle)>, WebKit::SandboxExtensionHandle>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.generalStorageDirectory)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.generalStorageDirectoryHandle)>, WebKit::SandboxExtensionHandle>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.serviceWorkerRegistrationDirectory)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.serviceWorkerRegistrationDirectoryExtensionHandle)>, WebKit::SandboxExtensionHandle>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.serviceWorkerProcessTerminationDelayEnabled)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.inspectionForServiceWorkersAllowed)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.storageSiteValidationEnabled)>, bool>);
#if ENABLE(DECLARATIVE_WEB_PUSH)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isDeclarativeWebPushEnabled)>, bool>);
#endif
#if HAVE(NW_PROXY_CONFIG)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.proxyConfigData)>, std::optional<Vector<std::pair<Vector<uint8_t>, std::optional<WTF::UUID>>>>>);
#endif
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.resourceLoadStatisticsParameters)>, WebKit::ResourceLoadStatisticsParameters>);
#if ENABLE(CONTENT_EXTENSIONS)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.resourceMonitorThrottlerDirectory)>, String>);
#endif
#if ENABLE(CONTENT_EXTENSIONS)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.resourceMonitorThrottlerDirectoryExtensionHandle)>, WebKit::SandboxExtensionHandle>);
#endif
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isLegacyTLSAllowed)>, bool>);
#if HAVE(WEBCONTENTRESTRICTIONS_PATH_SPI)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.webContentRestrictionsConfigurationFile)>, String>);
#endif
#if HAVE(WEBCONTENTRESTRICTIONS_PATH_SPI)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.webContentRestrictionsConfigurationExtensionHandle)>, WebKit::SandboxExtension::Handle>);
#endif
    struct ShouldBeSameSizeAsNetworkSessionCreationParameters : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::NetworkSessionCreationParameters>, false> {
        PAL::SessionID sessionID;
        Markable<WTF::UUID> dataStoreIdentifier;
        String boundInterfaceIdentifier;
        WebKit::AllowsCellularAccess allowsCellularAccess;
#if PLATFORM(COCOA)
        RetainPtr<CFDictionaryRef> proxyConfiguration;
#endif
#if PLATFORM(COCOA)
        String sourceApplicationBundleIdentifier;
#endif
#if PLATFORM(COCOA)
        String sourceApplicationSecondaryIdentifier;
#endif
#if PLATFORM(COCOA)
        bool shouldLogCookieInformation;
#endif
#if PLATFORM(COCOA)
        URL httpProxy;
#endif
#if PLATFORM(COCOA)
        URL httpsProxy;
#endif
#if HAVE(ALTERNATIVE_SERVICE)
        String alternativeServiceDirectory;
#endif
#if HAVE(ALTERNATIVE_SERVICE)
        WebKit::SandboxExtensionHandle alternativeServiceDirectoryExtensionHandle;
#endif
        String hstsStorageDirectory;
        WebKit::SandboxExtensionHandle hstsStorageDirectoryExtensionHandle;
#if USE(SOUP)
        String cookiePersistentStoragePath;
#endif
#if USE(SOUP)
        WebKit::SoupCookiePersistentStorageType cookiePersistentStorageType;
#endif
#if USE(SOUP)
        bool persistentCredentialStorageEnabled;
#endif
#if USE(SOUP)
        bool ignoreTLSErrors;
#endif
#if USE(SOUP)
        WebCore::SoupNetworkProxySettings proxySettings;
#endif
#if USE(SOUP)
        WebCore::HTTPCookieAcceptPolicy cookieAcceptPolicy;
#endif
#if USE(CURL)
        String cookiePersistentStorageFile;
#endif
#if USE(CURL)
        WebCore::CurlProxySettings proxySettings;
#endif
        bool deviceManagementRestrictionsEnabled;
        bool allLoadsBlockedByDeviceManagementRestrictionsForTesting;
        WebKit::WebPushD::WebPushDaemonConnectionConfiguration webPushDaemonConnectionConfiguration;
        String networkCacheDirectory;
        WebKit::SandboxExtensionHandle networkCacheDirectoryExtensionHandle;
        String dataConnectionServiceType;
        bool fastServerTrustEvaluationEnabled;
        bool networkCacheSpeculativeValidationEnabled;
        bool shouldUseTestingNetworkSession;
        bool staleWhileRevalidateEnabled;
        unsigned testSpeedMultiplier;
        bool suppressesConnectionTerminationOnSystemChange;
        bool allowsServerPreconnect;
        bool requiresSecureHTTPSProxyConnection;
        bool shouldRunServiceWorkersOnMainThreadForTesting;
        std::optional<unsigned> overrideServiceWorkerRegistrationCountTestingValue;
        bool preventsSystemHTTPProxyAuthentication;
        std::optional<bool> useNetworkLoader;
        bool allowsHSTSWithUntrustedRootCertificate;
        String pcmMachServiceName;
        String webPushMachServiceName;
        String webPushPartitionString;
        bool enablePrivateClickMeasurementDebugMode;
        bool isOptInCookiePartitioningEnabled;
        bool shouldSendPrivateTokenIPCForTesting;
        uint64_t cookiesVersion;
        WebKit::UnifiedOriginStorageLevel unifiedOriginStorageLevel;
        uint64_t perOriginStorageQuota;
        std::optional<double> originQuotaRatio;
        std::optional<double> totalQuotaRatio;
        std::optional<uint64_t> standardVolumeCapacity;
        std::optional<uint64_t> volumeCapacityOverride;
        String localStorageDirectory;
        WebKit::SandboxExtensionHandle localStorageDirectoryExtensionHandle;
        String indexedDBDirectory;
        WebKit::SandboxExtensionHandle indexedDBDirectoryExtensionHandle;
        String cacheStorageDirectory;
        WebKit::SandboxExtensionHandle cacheStorageDirectoryExtensionHandle;
        String generalStorageDirectory;
        WebKit::SandboxExtensionHandle generalStorageDirectoryHandle;
        String serviceWorkerRegistrationDirectory;
        WebKit::SandboxExtensionHandle serviceWorkerRegistrationDirectoryExtensionHandle;
        bool serviceWorkerProcessTerminationDelayEnabled;
        bool inspectionForServiceWorkersAllowed;
        bool storageSiteValidationEnabled;
#if ENABLE(DECLARATIVE_WEB_PUSH)
        bool isDeclarativeWebPushEnabled;
#endif
#if HAVE(NW_PROXY_CONFIG)
        std::optional<Vector<std::pair<Vector<uint8_t>, std::optional<WTF::UUID>>>> proxyConfigData;
#endif
        WebKit::ResourceLoadStatisticsParameters resourceLoadStatisticsParameters;
#if ENABLE(CONTENT_EXTENSIONS)
        String resourceMonitorThrottlerDirectory;
#endif
#if ENABLE(CONTENT_EXTENSIONS)
        WebKit::SandboxExtensionHandle resourceMonitorThrottlerDirectoryExtensionHandle;
#endif
        bool isLegacyTLSAllowed;
#if HAVE(WEBCONTENTRESTRICTIONS_PATH_SPI)
        String webContentRestrictionsConfigurationFile;
#endif
#if HAVE(WEBCONTENTRESTRICTIONS_PATH_SPI)
        WebKit::SandboxExtension::Handle webContentRestrictionsConfigurationExtensionHandle;
#endif
    };
    static_assert(sizeof(ShouldBeSameSizeAsNetworkSessionCreationParameters) == sizeof(WebKit::NetworkSessionCreationParameters));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::NetworkSessionCreationParameters, sessionID)
        , offsetof(WebKit::NetworkSessionCreationParameters, dataStoreIdentifier)
        , offsetof(WebKit::NetworkSessionCreationParameters, boundInterfaceIdentifier)
        , offsetof(WebKit::NetworkSessionCreationParameters, allowsCellularAccess)
#if PLATFORM(COCOA)
        , offsetof(WebKit::NetworkSessionCreationParameters, proxyConfiguration)
#endif
#if PLATFORM(COCOA)
        , offsetof(WebKit::NetworkSessionCreationParameters, sourceApplicationBundleIdentifier)
#endif
#if PLATFORM(COCOA)
        , offsetof(WebKit::NetworkSessionCreationParameters, sourceApplicationSecondaryIdentifier)
#endif
#if PLATFORM(COCOA)
        , offsetof(WebKit::NetworkSessionCreationParameters, shouldLogCookieInformation)
#endif
#if PLATFORM(COCOA)
        , offsetof(WebKit::NetworkSessionCreationParameters, httpProxy)
#endif
#if PLATFORM(COCOA)
        , offsetof(WebKit::NetworkSessionCreationParameters, httpsProxy)
#endif
#if HAVE(ALTERNATIVE_SERVICE)
        , offsetof(WebKit::NetworkSessionCreationParameters, alternativeServiceDirectory)
#endif
#if HAVE(ALTERNATIVE_SERVICE)
        , offsetof(WebKit::NetworkSessionCreationParameters, alternativeServiceDirectoryExtensionHandle)
#endif
        , offsetof(WebKit::NetworkSessionCreationParameters, hstsStorageDirectory)
        , offsetof(WebKit::NetworkSessionCreationParameters, hstsStorageDirectoryExtensionHandle)
#if USE(SOUP)
        , offsetof(WebKit::NetworkSessionCreationParameters, cookiePersistentStoragePath)
#endif
#if USE(SOUP)
        , offsetof(WebKit::NetworkSessionCreationParameters, cookiePersistentStorageType)
#endif
#if USE(SOUP)
        , offsetof(WebKit::NetworkSessionCreationParameters, persistentCredentialStorageEnabled)
#endif
#if USE(SOUP)
        , offsetof(WebKit::NetworkSessionCreationParameters, ignoreTLSErrors)
#endif
#if USE(SOUP)
        , offsetof(WebKit::NetworkSessionCreationParameters, proxySettings)
#endif
#if USE(SOUP)
        , offsetof(WebKit::NetworkSessionCreationParameters, cookieAcceptPolicy)
#endif
#if USE(CURL)
        , offsetof(WebKit::NetworkSessionCreationParameters, cookiePersistentStorageFile)
#endif
#if USE(CURL)
        , offsetof(WebKit::NetworkSessionCreationParameters, proxySettings)
#endif
        , offsetof(WebKit::NetworkSessionCreationParameters, deviceManagementRestrictionsEnabled)
        , offsetof(WebKit::NetworkSessionCreationParameters, allLoadsBlockedByDeviceManagementRestrictionsForTesting)
        , offsetof(WebKit::NetworkSessionCreationParameters, webPushDaemonConnectionConfiguration)
        , offsetof(WebKit::NetworkSessionCreationParameters, networkCacheDirectory)
        , offsetof(WebKit::NetworkSessionCreationParameters, networkCacheDirectoryExtensionHandle)
        , offsetof(WebKit::NetworkSessionCreationParameters, dataConnectionServiceType)
        , offsetof(WebKit::NetworkSessionCreationParameters, fastServerTrustEvaluationEnabled)
        , offsetof(WebKit::NetworkSessionCreationParameters, networkCacheSpeculativeValidationEnabled)
        , offsetof(WebKit::NetworkSessionCreationParameters, shouldUseTestingNetworkSession)
        , offsetof(WebKit::NetworkSessionCreationParameters, staleWhileRevalidateEnabled)
        , offsetof(WebKit::NetworkSessionCreationParameters, testSpeedMultiplier)
        , offsetof(WebKit::NetworkSessionCreationParameters, suppressesConnectionTerminationOnSystemChange)
        , offsetof(WebKit::NetworkSessionCreationParameters, allowsServerPreconnect)
        , offsetof(WebKit::NetworkSessionCreationParameters, requiresSecureHTTPSProxyConnection)
        , offsetof(WebKit::NetworkSessionCreationParameters, shouldRunServiceWorkersOnMainThreadForTesting)
        , offsetof(WebKit::NetworkSessionCreationParameters, overrideServiceWorkerRegistrationCountTestingValue)
        , offsetof(WebKit::NetworkSessionCreationParameters, preventsSystemHTTPProxyAuthentication)
        , offsetof(WebKit::NetworkSessionCreationParameters, useNetworkLoader)
        , offsetof(WebKit::NetworkSessionCreationParameters, allowsHSTSWithUntrustedRootCertificate)
        , offsetof(WebKit::NetworkSessionCreationParameters, pcmMachServiceName)
        , offsetof(WebKit::NetworkSessionCreationParameters, webPushMachServiceName)
        , offsetof(WebKit::NetworkSessionCreationParameters, webPushPartitionString)
        , offsetof(WebKit::NetworkSessionCreationParameters, enablePrivateClickMeasurementDebugMode)
        , offsetof(WebKit::NetworkSessionCreationParameters, isOptInCookiePartitioningEnabled)
        , offsetof(WebKit::NetworkSessionCreationParameters, shouldSendPrivateTokenIPCForTesting)
        , offsetof(WebKit::NetworkSessionCreationParameters, cookiesVersion)
        , offsetof(WebKit::NetworkSessionCreationParameters, unifiedOriginStorageLevel)
        , offsetof(WebKit::NetworkSessionCreationParameters, perOriginStorageQuota)
        , offsetof(WebKit::NetworkSessionCreationParameters, originQuotaRatio)
        , offsetof(WebKit::NetworkSessionCreationParameters, totalQuotaRatio)
        , offsetof(WebKit::NetworkSessionCreationParameters, standardVolumeCapacity)
        , offsetof(WebKit::NetworkSessionCreationParameters, volumeCapacityOverride)
        , offsetof(WebKit::NetworkSessionCreationParameters, localStorageDirectory)
        , offsetof(WebKit::NetworkSessionCreationParameters, localStorageDirectoryExtensionHandle)
        , offsetof(WebKit::NetworkSessionCreationParameters, indexedDBDirectory)
        , offsetof(WebKit::NetworkSessionCreationParameters, indexedDBDirectoryExtensionHandle)
        , offsetof(WebKit::NetworkSessionCreationParameters, cacheStorageDirectory)
        , offsetof(WebKit::NetworkSessionCreationParameters, cacheStorageDirectoryExtensionHandle)
        , offsetof(WebKit::NetworkSessionCreationParameters, generalStorageDirectory)
        , offsetof(WebKit::NetworkSessionCreationParameters, generalStorageDirectoryHandle)
        , offsetof(WebKit::NetworkSessionCreationParameters, serviceWorkerRegistrationDirectory)
        , offsetof(WebKit::NetworkSessionCreationParameters, serviceWorkerRegistrationDirectoryExtensionHandle)
        , offsetof(WebKit::NetworkSessionCreationParameters, serviceWorkerProcessTerminationDelayEnabled)
        , offsetof(WebKit::NetworkSessionCreationParameters, inspectionForServiceWorkersAllowed)
        , offsetof(WebKit::NetworkSessionCreationParameters, storageSiteValidationEnabled)
#if ENABLE(DECLARATIVE_WEB_PUSH)
        , offsetof(WebKit::NetworkSessionCreationParameters, isDeclarativeWebPushEnabled)
#endif
#if HAVE(NW_PROXY_CONFIG)
        , offsetof(WebKit::NetworkSessionCreationParameters, proxyConfigData)
#endif
        , offsetof(WebKit::NetworkSessionCreationParameters, resourceLoadStatisticsParameters)
#if ENABLE(CONTENT_EXTENSIONS)
        , offsetof(WebKit::NetworkSessionCreationParameters, resourceMonitorThrottlerDirectory)
#endif
#if ENABLE(CONTENT_EXTENSIONS)
        , offsetof(WebKit::NetworkSessionCreationParameters, resourceMonitorThrottlerDirectoryExtensionHandle)
#endif
        , offsetof(WebKit::NetworkSessionCreationParameters, isLegacyTLSAllowed)
#if HAVE(WEBCONTENTRESTRICTIONS_PATH_SPI)
        , offsetof(WebKit::NetworkSessionCreationParameters, webContentRestrictionsConfigurationFile)
#endif
#if HAVE(WEBCONTENTRESTRICTIONS_PATH_SPI)
        , offsetof(WebKit::NetworkSessionCreationParameters, webContentRestrictionsConfigurationExtensionHandle)
#endif
    >::value);

    encoder << WTFMove(instance.sessionID);
    encoder << WTFMove(instance.dataStoreIdentifier);
    encoder << WTFMove(instance.boundInterfaceIdentifier);
    encoder << WTFMove(instance.allowsCellularAccess);
#if PLATFORM(COCOA)
    encoder << WTFMove(instance.proxyConfiguration);
#endif
#if PLATFORM(COCOA)
    encoder << WTFMove(instance.sourceApplicationBundleIdentifier);
#endif
#if PLATFORM(COCOA)
    encoder << WTFMove(instance.sourceApplicationSecondaryIdentifier);
#endif
#if PLATFORM(COCOA)
    encoder << WTFMove(instance.shouldLogCookieInformation);
#endif
#if PLATFORM(COCOA)
    encoder << WTFMove(instance.httpProxy);
#endif
#if PLATFORM(COCOA)
    encoder << WTFMove(instance.httpsProxy);
#endif
#if HAVE(ALTERNATIVE_SERVICE)
    encoder << WTFMove(instance.alternativeServiceDirectory);
#endif
#if HAVE(ALTERNATIVE_SERVICE)
    encoder << WTFMove(instance.alternativeServiceDirectoryExtensionHandle);
#endif
    encoder << WTFMove(instance.hstsStorageDirectory);
    encoder << WTFMove(instance.hstsStorageDirectoryExtensionHandle);
#if USE(SOUP)
    encoder << WTFMove(instance.cookiePersistentStoragePath);
#endif
#if USE(SOUP)
    encoder << WTFMove(instance.cookiePersistentStorageType);
#endif
#if USE(SOUP)
    encoder << WTFMove(instance.persistentCredentialStorageEnabled);
#endif
#if USE(SOUP)
    encoder << WTFMove(instance.ignoreTLSErrors);
#endif
#if USE(SOUP)
    encoder << WTFMove(instance.proxySettings);
#endif
#if USE(SOUP)
    encoder << WTFMove(instance.cookieAcceptPolicy);
#endif
#if USE(CURL)
    encoder << WTFMove(instance.cookiePersistentStorageFile);
#endif
#if USE(CURL)
    encoder << WTFMove(instance.proxySettings);
#endif
    encoder << WTFMove(instance.deviceManagementRestrictionsEnabled);
    encoder << WTFMove(instance.allLoadsBlockedByDeviceManagementRestrictionsForTesting);
    encoder << WTFMove(instance.webPushDaemonConnectionConfiguration);
    encoder << WTFMove(instance.networkCacheDirectory);
    encoder << WTFMove(instance.networkCacheDirectoryExtensionHandle);
    encoder << WTFMove(instance.dataConnectionServiceType);
    encoder << WTFMove(instance.fastServerTrustEvaluationEnabled);
    encoder << WTFMove(instance.networkCacheSpeculativeValidationEnabled);
    encoder << WTFMove(instance.shouldUseTestingNetworkSession);
    encoder << WTFMove(instance.staleWhileRevalidateEnabled);
    encoder << WTFMove(instance.testSpeedMultiplier);
    encoder << WTFMove(instance.suppressesConnectionTerminationOnSystemChange);
    encoder << WTFMove(instance.allowsServerPreconnect);
    encoder << WTFMove(instance.requiresSecureHTTPSProxyConnection);
    encoder << WTFMove(instance.shouldRunServiceWorkersOnMainThreadForTesting);
    encoder << WTFMove(instance.overrideServiceWorkerRegistrationCountTestingValue);
    encoder << WTFMove(instance.preventsSystemHTTPProxyAuthentication);
    encoder << WTFMove(instance.useNetworkLoader);
    encoder << WTFMove(instance.allowsHSTSWithUntrustedRootCertificate);
    encoder << WTFMove(instance.pcmMachServiceName);
    encoder << WTFMove(instance.webPushMachServiceName);
    encoder << WTFMove(instance.webPushPartitionString);
    encoder << WTFMove(instance.enablePrivateClickMeasurementDebugMode);
    encoder << WTFMove(instance.isOptInCookiePartitioningEnabled);
    encoder << WTFMove(instance.shouldSendPrivateTokenIPCForTesting);
    encoder << WTFMove(instance.cookiesVersion);
    encoder << WTFMove(instance.unifiedOriginStorageLevel);
    encoder << WTFMove(instance.perOriginStorageQuota);
    encoder << WTFMove(instance.originQuotaRatio);
    encoder << WTFMove(instance.totalQuotaRatio);
    encoder << WTFMove(instance.standardVolumeCapacity);
    encoder << WTFMove(instance.volumeCapacityOverride);
    encoder << WTFMove(instance.localStorageDirectory);
    encoder << WTFMove(instance.localStorageDirectoryExtensionHandle);
    encoder << WTFMove(instance.indexedDBDirectory);
    encoder << WTFMove(instance.indexedDBDirectoryExtensionHandle);
    encoder << WTFMove(instance.cacheStorageDirectory);
    encoder << WTFMove(instance.cacheStorageDirectoryExtensionHandle);
    encoder << WTFMove(instance.generalStorageDirectory);
    encoder << WTFMove(instance.generalStorageDirectoryHandle);
    encoder << WTFMove(instance.serviceWorkerRegistrationDirectory);
    encoder << WTFMove(instance.serviceWorkerRegistrationDirectoryExtensionHandle);
    encoder << WTFMove(instance.serviceWorkerProcessTerminationDelayEnabled);
    encoder << WTFMove(instance.inspectionForServiceWorkersAllowed);
    encoder << WTFMove(instance.storageSiteValidationEnabled);
#if ENABLE(DECLARATIVE_WEB_PUSH)
    encoder << WTFMove(instance.isDeclarativeWebPushEnabled);
#endif
#if HAVE(NW_PROXY_CONFIG)
    encoder << WTFMove(instance.proxyConfigData);
#endif
    encoder << WTFMove(instance.resourceLoadStatisticsParameters);
#if ENABLE(CONTENT_EXTENSIONS)
    encoder << WTFMove(instance.resourceMonitorThrottlerDirectory);
#endif
#if ENABLE(CONTENT_EXTENSIONS)
    encoder << WTFMove(instance.resourceMonitorThrottlerDirectoryExtensionHandle);
#endif
    encoder << WTFMove(instance.isLegacyTLSAllowed);
#if HAVE(WEBCONTENTRESTRICTIONS_PATH_SPI)
    encoder << WTFMove(instance.webContentRestrictionsConfigurationFile);
#endif
#if HAVE(WEBCONTENTRESTRICTIONS_PATH_SPI)
    encoder << WTFMove(instance.webContentRestrictionsConfigurationExtensionHandle);
#endif
}

std::optional<WebKit::NetworkSessionCreationParameters> ArgumentCoder<WebKit::NetworkSessionCreationParameters>::decode(Decoder& decoder)
{
    auto sessionID = decoder.decode<PAL::SessionID>();
    auto dataStoreIdentifier = decoder.decode<Markable<WTF::UUID>>();
    auto boundInterfaceIdentifier = decoder.decode<String>();
    auto allowsCellularAccess = decoder.decode<WebKit::AllowsCellularAccess>();
#if PLATFORM(COCOA)
    auto proxyConfiguration = decoder.decode<RetainPtr<CFDictionaryRef>>();
#endif
#if PLATFORM(COCOA)
    auto sourceApplicationBundleIdentifier = decoder.decode<String>();
#endif
#if PLATFORM(COCOA)
    auto sourceApplicationSecondaryIdentifier = decoder.decode<String>();
#endif
#if PLATFORM(COCOA)
    auto shouldLogCookieInformation = decoder.decode<bool>();
#endif
#if PLATFORM(COCOA)
    auto httpProxy = decoder.decode<URL>();
#endif
#if PLATFORM(COCOA)
    auto httpsProxy = decoder.decode<URL>();
#endif
#if HAVE(ALTERNATIVE_SERVICE)
    auto alternativeServiceDirectory = decoder.decode<String>();
#endif
#if HAVE(ALTERNATIVE_SERVICE)
    auto alternativeServiceDirectoryExtensionHandle = decoder.decode<WebKit::SandboxExtensionHandle>();
#endif
    auto hstsStorageDirectory = decoder.decode<String>();
    auto hstsStorageDirectoryExtensionHandle = decoder.decode<WebKit::SandboxExtensionHandle>();
#if USE(SOUP)
    auto cookiePersistentStoragePath = decoder.decode<String>();
#endif
#if USE(SOUP)
    auto cookiePersistentStorageType = decoder.decode<WebKit::SoupCookiePersistentStorageType>();
#endif
#if USE(SOUP)
    auto persistentCredentialStorageEnabled = decoder.decode<bool>();
#endif
#if USE(SOUP)
    auto ignoreTLSErrors = decoder.decode<bool>();
#endif
#if USE(SOUP)
    auto proxySettings = decoder.decode<WebCore::SoupNetworkProxySettings>();
#endif
#if USE(SOUP)
    auto cookieAcceptPolicy = decoder.decode<WebCore::HTTPCookieAcceptPolicy>();
#endif
#if USE(CURL)
    auto cookiePersistentStorageFile = decoder.decode<String>();
#endif
#if USE(CURL)
    auto proxySettings = decoder.decode<WebCore::CurlProxySettings>();
#endif
    auto deviceManagementRestrictionsEnabled = decoder.decode<bool>();
    auto allLoadsBlockedByDeviceManagementRestrictionsForTesting = decoder.decode<bool>();
    auto webPushDaemonConnectionConfiguration = decoder.decode<WebKit::WebPushD::WebPushDaemonConnectionConfiguration>();
    auto networkCacheDirectory = decoder.decode<String>();
    auto networkCacheDirectoryExtensionHandle = decoder.decode<WebKit::SandboxExtensionHandle>();
    auto dataConnectionServiceType = decoder.decode<String>();
    auto fastServerTrustEvaluationEnabled = decoder.decode<bool>();
    auto networkCacheSpeculativeValidationEnabled = decoder.decode<bool>();
    auto shouldUseTestingNetworkSession = decoder.decode<bool>();
    auto staleWhileRevalidateEnabled = decoder.decode<bool>();
    auto testSpeedMultiplier = decoder.decode<unsigned>();
    auto suppressesConnectionTerminationOnSystemChange = decoder.decode<bool>();
    auto allowsServerPreconnect = decoder.decode<bool>();
    auto requiresSecureHTTPSProxyConnection = decoder.decode<bool>();
    auto shouldRunServiceWorkersOnMainThreadForTesting = decoder.decode<bool>();
    auto overrideServiceWorkerRegistrationCountTestingValue = decoder.decode<std::optional<unsigned>>();
    auto preventsSystemHTTPProxyAuthentication = decoder.decode<bool>();
    auto useNetworkLoader = decoder.decode<std::optional<bool>>();
    auto allowsHSTSWithUntrustedRootCertificate = decoder.decode<bool>();
    auto pcmMachServiceName = decoder.decode<String>();
    auto webPushMachServiceName = decoder.decode<String>();
    auto webPushPartitionString = decoder.decode<String>();
    auto enablePrivateClickMeasurementDebugMode = decoder.decode<bool>();
    auto isOptInCookiePartitioningEnabled = decoder.decode<bool>();
    auto shouldSendPrivateTokenIPCForTesting = decoder.decode<bool>();
    auto cookiesVersion = decoder.decode<uint64_t>();
    auto unifiedOriginStorageLevel = decoder.decode<WebKit::UnifiedOriginStorageLevel>();
    auto perOriginStorageQuota = decoder.decode<uint64_t>();
    auto originQuotaRatio = decoder.decode<std::optional<double>>();
    auto totalQuotaRatio = decoder.decode<std::optional<double>>();
    auto standardVolumeCapacity = decoder.decode<std::optional<uint64_t>>();
    auto volumeCapacityOverride = decoder.decode<std::optional<uint64_t>>();
    auto localStorageDirectory = decoder.decode<String>();
    auto localStorageDirectoryExtensionHandle = decoder.decode<WebKit::SandboxExtensionHandle>();
    auto indexedDBDirectory = decoder.decode<String>();
    auto indexedDBDirectoryExtensionHandle = decoder.decode<WebKit::SandboxExtensionHandle>();
    auto cacheStorageDirectory = decoder.decode<String>();
    auto cacheStorageDirectoryExtensionHandle = decoder.decode<WebKit::SandboxExtensionHandle>();
    auto generalStorageDirectory = decoder.decode<String>();
    auto generalStorageDirectoryHandle = decoder.decode<WebKit::SandboxExtensionHandle>();
    auto serviceWorkerRegistrationDirectory = decoder.decode<String>();
    auto serviceWorkerRegistrationDirectoryExtensionHandle = decoder.decode<WebKit::SandboxExtensionHandle>();
    auto serviceWorkerProcessTerminationDelayEnabled = decoder.decode<bool>();
    auto inspectionForServiceWorkersAllowed = decoder.decode<bool>();
    auto storageSiteValidationEnabled = decoder.decode<bool>();
#if ENABLE(DECLARATIVE_WEB_PUSH)
    auto isDeclarativeWebPushEnabled = decoder.decode<bool>();
#endif
#if HAVE(NW_PROXY_CONFIG)
    auto proxyConfigData = decoder.decode<std::optional<Vector<std::pair<Vector<uint8_t>, std::optional<WTF::UUID>>>>>();
#endif
    auto resourceLoadStatisticsParameters = decoder.decode<WebKit::ResourceLoadStatisticsParameters>();
#if ENABLE(CONTENT_EXTENSIONS)
    auto resourceMonitorThrottlerDirectory = decoder.decode<String>();
#endif
#if ENABLE(CONTENT_EXTENSIONS)
    auto resourceMonitorThrottlerDirectoryExtensionHandle = decoder.decode<WebKit::SandboxExtensionHandle>();
#endif
    auto isLegacyTLSAllowed = decoder.decode<bool>();
#if HAVE(WEBCONTENTRESTRICTIONS_PATH_SPI)
    auto webContentRestrictionsConfigurationFile = decoder.decode<String>();
#endif
#if HAVE(WEBCONTENTRESTRICTIONS_PATH_SPI)
    auto webContentRestrictionsConfigurationExtensionHandle = decoder.decode<WebKit::SandboxExtension::Handle>();
#endif
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebKit::NetworkSessionCreationParameters {
            WTFMove(*sessionID),
            WTFMove(*dataStoreIdentifier),
            WTFMove(*boundInterfaceIdentifier),
            WTFMove(*allowsCellularAccess),
#if PLATFORM(COCOA)
            WTFMove(*proxyConfiguration),
#endif
#if PLATFORM(COCOA)
            WTFMove(*sourceApplicationBundleIdentifier),
#endif
#if PLATFORM(COCOA)
            WTFMove(*sourceApplicationSecondaryIdentifier),
#endif
#if PLATFORM(COCOA)
            WTFMove(*shouldLogCookieInformation),
#endif
#if PLATFORM(COCOA)
            WTFMove(*httpProxy),
#endif
#if PLATFORM(COCOA)
            WTFMove(*httpsProxy),
#endif
#if HAVE(ALTERNATIVE_SERVICE)
            WTFMove(*alternativeServiceDirectory),
#endif
#if HAVE(ALTERNATIVE_SERVICE)
            WTFMove(*alternativeServiceDirectoryExtensionHandle),
#endif
            WTFMove(*hstsStorageDirectory),
            WTFMove(*hstsStorageDirectoryExtensionHandle),
#if USE(SOUP)
            WTFMove(*cookiePersistentStoragePath),
#endif
#if USE(SOUP)
            WTFMove(*cookiePersistentStorageType),
#endif
#if USE(SOUP)
            WTFMove(*persistentCredentialStorageEnabled),
#endif
#if USE(SOUP)
            WTFMove(*ignoreTLSErrors),
#endif
#if USE(SOUP)
            WTFMove(*proxySettings),
#endif
#if USE(SOUP)
            WTFMove(*cookieAcceptPolicy),
#endif
#if USE(CURL)
            WTFMove(*cookiePersistentStorageFile),
#endif
#if USE(CURL)
            WTFMove(*proxySettings),
#endif
            WTFMove(*deviceManagementRestrictionsEnabled),
            WTFMove(*allLoadsBlockedByDeviceManagementRestrictionsForTesting),
            WTFMove(*webPushDaemonConnectionConfiguration),
            WTFMove(*networkCacheDirectory),
            WTFMove(*networkCacheDirectoryExtensionHandle),
            WTFMove(*dataConnectionServiceType),
            WTFMove(*fastServerTrustEvaluationEnabled),
            WTFMove(*networkCacheSpeculativeValidationEnabled),
            WTFMove(*shouldUseTestingNetworkSession),
            WTFMove(*staleWhileRevalidateEnabled),
            WTFMove(*testSpeedMultiplier),
            WTFMove(*suppressesConnectionTerminationOnSystemChange),
            WTFMove(*allowsServerPreconnect),
            WTFMove(*requiresSecureHTTPSProxyConnection),
            WTFMove(*shouldRunServiceWorkersOnMainThreadForTesting),
            WTFMove(*overrideServiceWorkerRegistrationCountTestingValue),
            WTFMove(*preventsSystemHTTPProxyAuthentication),
            WTFMove(*useNetworkLoader),
            WTFMove(*allowsHSTSWithUntrustedRootCertificate),
            WTFMove(*pcmMachServiceName),
            WTFMove(*webPushMachServiceName),
            WTFMove(*webPushPartitionString),
            WTFMove(*enablePrivateClickMeasurementDebugMode),
            WTFMove(*isOptInCookiePartitioningEnabled),
            WTFMove(*shouldSendPrivateTokenIPCForTesting),
            WTFMove(*cookiesVersion),
            WTFMove(*unifiedOriginStorageLevel),
            WTFMove(*perOriginStorageQuota),
            WTFMove(*originQuotaRatio),
            WTFMove(*totalQuotaRatio),
            WTFMove(*standardVolumeCapacity),
            WTFMove(*volumeCapacityOverride),
            WTFMove(*localStorageDirectory),
            WTFMove(*localStorageDirectoryExtensionHandle),
            WTFMove(*indexedDBDirectory),
            WTFMove(*indexedDBDirectoryExtensionHandle),
            WTFMove(*cacheStorageDirectory),
            WTFMove(*cacheStorageDirectoryExtensionHandle),
            WTFMove(*generalStorageDirectory),
            WTFMove(*generalStorageDirectoryHandle),
            WTFMove(*serviceWorkerRegistrationDirectory),
            WTFMove(*serviceWorkerRegistrationDirectoryExtensionHandle),
            WTFMove(*serviceWorkerProcessTerminationDelayEnabled),
            WTFMove(*inspectionForServiceWorkersAllowed),
            WTFMove(*storageSiteValidationEnabled),
#if ENABLE(DECLARATIVE_WEB_PUSH)
            WTFMove(*isDeclarativeWebPushEnabled),
#endif
#if HAVE(NW_PROXY_CONFIG)
            WTFMove(*proxyConfigData),
#endif
            WTFMove(*resourceLoadStatisticsParameters),
#if ENABLE(CONTENT_EXTENSIONS)
            WTFMove(*resourceMonitorThrottlerDirectory),
#endif
#if ENABLE(CONTENT_EXTENSIONS)
            WTFMove(*resourceMonitorThrottlerDirectoryExtensionHandle),
#endif
            WTFMove(*isLegacyTLSAllowed),
#if HAVE(WEBCONTENTRESTRICTIONS_PATH_SPI)
            WTFMove(*webContentRestrictionsConfigurationFile),
#endif
#if HAVE(WEBCONTENTRESTRICTIONS_PATH_SPI)
            WTFMove(*webContentRestrictionsConfigurationExtensionHandle)
#endif
        }
    };
}

void ArgumentCoder<WebKit::ITPThirdPartyData>::encode(Encoder& encoder, const WebKit::ITPThirdPartyData& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.thirdPartyDomain)>, WebCore::RegistrableDomain>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.underFirstParties)>, Vector<WebKit::ITPThirdPartyDataForSpecificFirstParty>>);
    struct ShouldBeSameSizeAsITPThirdPartyData : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::ITPThirdPartyData>, false> {
        WebCore::RegistrableDomain thirdPartyDomain;
        Vector<WebKit::ITPThirdPartyDataForSpecificFirstParty> underFirstParties;
    };
    static_assert(sizeof(ShouldBeSameSizeAsITPThirdPartyData) == sizeof(WebKit::ITPThirdPartyData));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::ITPThirdPartyData, thirdPartyDomain)
        , offsetof(WebKit::ITPThirdPartyData, underFirstParties)
    >::value);

    encoder << instance.thirdPartyDomain;
    encoder << instance.underFirstParties;
}

std::optional<WebKit::ITPThirdPartyData> ArgumentCoder<WebKit::ITPThirdPartyData>::decode(Decoder& decoder)
{
    auto thirdPartyDomain = decoder.decode<WebCore::RegistrableDomain>();
    auto underFirstParties = decoder.decode<Vector<WebKit::ITPThirdPartyDataForSpecificFirstParty>>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebKit::ITPThirdPartyData {
            WTFMove(*thirdPartyDomain),
            WTFMove(*underFirstParties)
        }
    };
}

void ArgumentCoder<WebKit::ITPThirdPartyDataForSpecificFirstParty>::encode(Encoder& encoder, const WebKit::ITPThirdPartyDataForSpecificFirstParty& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.firstPartyDomain)>, WebCore::RegistrableDomain>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.storageAccessGranted)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.timeLastUpdated)>, Seconds>);
    struct ShouldBeSameSizeAsITPThirdPartyDataForSpecificFirstParty : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::ITPThirdPartyDataForSpecificFirstParty>, false> {
        WebCore::RegistrableDomain firstPartyDomain;
        bool storageAccessGranted;
        Seconds timeLastUpdated;
    };
    static_assert(sizeof(ShouldBeSameSizeAsITPThirdPartyDataForSpecificFirstParty) == sizeof(WebKit::ITPThirdPartyDataForSpecificFirstParty));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::ITPThirdPartyDataForSpecificFirstParty, firstPartyDomain)
        , offsetof(WebKit::ITPThirdPartyDataForSpecificFirstParty, storageAccessGranted)
        , offsetof(WebKit::ITPThirdPartyDataForSpecificFirstParty, timeLastUpdated)
    >::value);

    encoder << instance.firstPartyDomain;
    encoder << instance.storageAccessGranted;
    encoder << instance.timeLastUpdated;
}

std::optional<WebKit::ITPThirdPartyDataForSpecificFirstParty> ArgumentCoder<WebKit::ITPThirdPartyDataForSpecificFirstParty>::decode(Decoder& decoder)
{
    auto firstPartyDomain = decoder.decode<WebCore::RegistrableDomain>();
    auto storageAccessGranted = decoder.decode<bool>();
    auto timeLastUpdated = decoder.decode<Seconds>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebKit::ITPThirdPartyDataForSpecificFirstParty {
            WTFMove(*firstPartyDomain),
            WTFMove(*storageAccessGranted),
            WTFMove(*timeLastUpdated)
        }
    };
}

void ArgumentCoder<IPC::FormDataReference>::encode(Encoder& encoder, const IPC::FormDataReference& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.data())>, RefPtr<WebCore::FormData>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.sandboxExtensionHandles())>, Vector<WebKit::SandboxExtensionHandle>>);

    encoder << instance.data();
    encoder << instance.sandboxExtensionHandles();
}

std::optional<IPC::FormDataReference> ArgumentCoder<IPC::FormDataReference>::decode(Decoder& decoder)
{
    auto data = decoder.decode<RefPtr<WebCore::FormData>>();
    auto sandboxExtensionHandles = decoder.decode<Vector<WebKit::SandboxExtensionHandle>>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        IPC::FormDataReference {
            WTFMove(*data),
            WTFMove(*sandboxExtensionHandles)
        }
    };
}

#if ENABLE(GPU_PROCESS) && ENABLE(VIDEO)
void ArgumentCoder<WebKit::RemoteVideoFrameReference>::encode(Encoder& encoder, const WebKit::RemoteVideoFrameReference& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.identifier())>, WebKit::RemoteVideoFrameIdentifier>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.version())>, uint64_t>);

    encoder << instance.identifier();
    encoder << instance.version();
}

void ArgumentCoder<WebKit::RemoteVideoFrameReference>::encode(StreamConnectionEncoder& encoder, const WebKit::RemoteVideoFrameReference& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.identifier())>, WebKit::RemoteVideoFrameIdentifier>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.version())>, uint64_t>);

    encoder << instance.identifier();
    encoder << instance.version();
}

std::optional<WebKit::RemoteVideoFrameReference> ArgumentCoder<WebKit::RemoteVideoFrameReference>::decode(Decoder& decoder)
{
    auto identifier = decoder.decode<WebKit::RemoteVideoFrameIdentifier>();
    auto version = decoder.decode<uint64_t>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebKit::RemoteVideoFrameReference {
            WTFMove(*identifier),
            WTFMove(*version)
        }
    };
}

#endif

#if ENABLE(GPU_PROCESS) && ENABLE(VIDEO)
void ArgumentCoder<WebKit::RemoteVideoFrameWriteReference>::encode(Encoder& encoder, const WebKit::RemoteVideoFrameWriteReference& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.reference())>, WebKit::RemoteVideoFrameReference>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.pendingReads())>, uint64_t>);

    encoder << instance.reference();
    encoder << instance.pendingReads();
}

void ArgumentCoder<WebKit::RemoteVideoFrameWriteReference>::encode(StreamConnectionEncoder& encoder, const WebKit::RemoteVideoFrameWriteReference& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.reference())>, WebKit::RemoteVideoFrameReference>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.pendingReads())>, uint64_t>);

    encoder << instance.reference();
    encoder << instance.pendingReads();
}

std::optional<WebKit::RemoteVideoFrameWriteReference> ArgumentCoder<WebKit::RemoteVideoFrameWriteReference>::decode(Decoder& decoder)
{
    auto reference = decoder.decode<WebKit::RemoteVideoFrameReference>();
    auto pendingReads = decoder.decode<uint64_t>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebKit::RemoteVideoFrameWriteReference {
            WTFMove(*reference),
            WTFMove(*pendingReads)
        }
    };
}

#endif

#if ENABLE(GPU_PROCESS) && ENABLE(VIDEO)
void ArgumentCoder<WebKit::RemoteVideoFrameReadReference>::encode(Encoder& encoder, const WebKit::RemoteVideoFrameReadReference& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.reference())>, WebKit::RemoteVideoFrameReference>);

    encoder << instance.reference();
}

void ArgumentCoder<WebKit::RemoteVideoFrameReadReference>::encode(StreamConnectionEncoder& encoder, const WebKit::RemoteVideoFrameReadReference& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.reference())>, WebKit::RemoteVideoFrameReference>);

    encoder << instance.reference();
}

std::optional<WebKit::RemoteVideoFrameReadReference> ArgumentCoder<WebKit::RemoteVideoFrameReadReference>::decode(Decoder& decoder)
{
    auto reference = decoder.decode<WebKit::RemoteVideoFrameReference>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebKit::RemoteVideoFrameReadReference {
            WTFMove(*reference)
        }
    };
}

#endif

#if ENABLE(GPU_PROCESS)
void ArgumentCoder<WebKit::RemoteSerializedImageBufferReference>::encode(Encoder& encoder, const WebKit::RemoteSerializedImageBufferReference& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.identifier())>, WebKit::RemoteSerializedImageBufferIdentifier>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.version())>, uint64_t>);

    encoder << instance.identifier();
    encoder << instance.version();
}

void ArgumentCoder<WebKit::RemoteSerializedImageBufferReference>::encode(StreamConnectionEncoder& encoder, const WebKit::RemoteSerializedImageBufferReference& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.identifier())>, WebKit::RemoteSerializedImageBufferIdentifier>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.version())>, uint64_t>);

    encoder << instance.identifier();
    encoder << instance.version();
}

std::optional<WebKit::RemoteSerializedImageBufferReference> ArgumentCoder<WebKit::RemoteSerializedImageBufferReference>::decode(Decoder& decoder)
{
    auto identifier = decoder.decode<WebKit::RemoteSerializedImageBufferIdentifier>();
    auto version = decoder.decode<uint64_t>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebKit::RemoteSerializedImageBufferReference {
            WTFMove(*identifier),
            WTFMove(*version)
        }
    };
}

#endif

#if ENABLE(GPU_PROCESS)
void ArgumentCoder<WebKit::RemoteSerializedImageBufferWriteReference>::encode(Encoder& encoder, const WebKit::RemoteSerializedImageBufferWriteReference& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.reference())>, WebKit::RemoteSerializedImageBufferReference>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.pendingReads())>, uint64_t>);

    encoder << instance.reference();
    encoder << instance.pendingReads();
}

void ArgumentCoder<WebKit::RemoteSerializedImageBufferWriteReference>::encode(StreamConnectionEncoder& encoder, const WebKit::RemoteSerializedImageBufferWriteReference& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.reference())>, WebKit::RemoteSerializedImageBufferReference>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.pendingReads())>, uint64_t>);

    encoder << instance.reference();
    encoder << instance.pendingReads();
}

std::optional<WebKit::RemoteSerializedImageBufferWriteReference> ArgumentCoder<WebKit::RemoteSerializedImageBufferWriteReference>::decode(Decoder& decoder)
{
    auto reference = decoder.decode<WebKit::RemoteSerializedImageBufferReference>();
    auto pendingReads = decoder.decode<uint64_t>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebKit::RemoteSerializedImageBufferWriteReference {
            WTFMove(*reference),
            WTFMove(*pendingReads)
        }
    };
}

#endif

#if ENABLE(GPU_PROCESS)
void ArgumentCoder<WebKit::RemoteSerializedImageBufferReadReference>::encode(Encoder& encoder, const WebKit::RemoteSerializedImageBufferReadReference& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.reference())>, WebKit::RemoteSerializedImageBufferReference>);

    encoder << instance.reference();
}

void ArgumentCoder<WebKit::RemoteSerializedImageBufferReadReference>::encode(StreamConnectionEncoder& encoder, const WebKit::RemoteSerializedImageBufferReadReference& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.reference())>, WebKit::RemoteSerializedImageBufferReference>);

    encoder << instance.reference();
}

std::optional<WebKit::RemoteSerializedImageBufferReadReference> ArgumentCoder<WebKit::RemoteSerializedImageBufferReadReference>::decode(Decoder& decoder)
{
    auto reference = decoder.decode<WebKit::RemoteSerializedImageBufferReference>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebKit::RemoteSerializedImageBufferReadReference {
            WTFMove(*reference)
        }
    };
}

#endif

#if !USE(UNIX_DOMAIN_SOCKETS)
void ArgumentCoder<IPC::SharedBufferReference::SerializableBuffer>::encode(Encoder& encoder, IPC::SharedBufferReference::SerializableBuffer&& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.size)>, uint64_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.handle)>, std::optional<WebCore::SharedMemory::Handle>>);
    struct ShouldBeSameSizeAsSerializableBuffer : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<IPC::SharedBufferReference::SerializableBuffer>, false> {
        uint64_t size;
        std::optional<WebCore::SharedMemory::Handle> handle;
    };
    static_assert(sizeof(ShouldBeSameSizeAsSerializableBuffer) == sizeof(IPC::SharedBufferReference::SerializableBuffer));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(IPC::SharedBufferReference::SerializableBuffer, size)
        , offsetof(IPC::SharedBufferReference::SerializableBuffer, handle)
    >::value);

    encoder << WTFMove(instance.size);
    encoder << WTFMove(instance.handle);
}

std::optional<IPC::SharedBufferReference::SerializableBuffer> ArgumentCoder<IPC::SharedBufferReference::SerializableBuffer>::decode(Decoder& decoder)
{
    auto size = decoder.decode<uint64_t>();
    auto handle = decoder.decode<std::optional<WebCore::SharedMemory::Handle>>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        IPC::SharedBufferReference::SerializableBuffer {
            WTFMove(*size),
            WTFMove(*handle)
        }
    };
}

#endif

void ArgumentCoder<IPC::SharedBufferReference>::encode(Encoder& encoder, const IPC::SharedBufferReference& instance)
{
#if USE(UNIX_DOMAIN_SOCKETS)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.buffer())>, RefPtr<WebCore::FragmentedSharedBuffer>>);
#endif
#if !(USE(UNIX_DOMAIN_SOCKETS))
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.serializableBuffer())>, std::optional<IPC::SharedBufferReference::SerializableBuffer>>);
#endif

#if USE(UNIX_DOMAIN_SOCKETS)
    encoder << instance.buffer();
#endif
#if !(USE(UNIX_DOMAIN_SOCKETS))
    encoder << instance.serializableBuffer();
#endif
}

std::optional<IPC::SharedBufferReference> ArgumentCoder<IPC::SharedBufferReference>::decode(Decoder& decoder)
{
#if USE(UNIX_DOMAIN_SOCKETS)
    auto buffer = decoder.decode<RefPtr<WebCore::FragmentedSharedBuffer>>();
#endif
#if !(USE(UNIX_DOMAIN_SOCKETS))
    auto serializableBuffer = decoder.decode<std::optional<IPC::SharedBufferReference::SerializableBuffer>>();
#endif
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        IPC::SharedBufferReference {
#if USE(UNIX_DOMAIN_SOCKETS)
            WTFMove(*buffer),
#endif
#if !(USE(UNIX_DOMAIN_SOCKETS))
            WTFMove(*serializableBuffer)
#endif
        }
    };
}

void ArgumentCoder<IPC::SharedFileHandle>::encode(Encoder& encoder, const IPC::SharedFileHandle& instance)
{
#if PLATFORM(COCOA)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.toMachSendRight())>, MachSendRight>);
#endif

#if PLATFORM(COCOA)
    encoder << instance.toMachSendRight();
#endif
}

std::optional<IPC::SharedFileHandle> ArgumentCoder<IPC::SharedFileHandle>::decode(Decoder& decoder)
{
#if PLATFORM(COCOA)
    auto toMachSendRight = decoder.decode<MachSendRight>();
#endif
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        IPC::SharedFileHandle {
#if PLATFORM(COCOA)
            WTFMove(*toMachSendRight)
#endif
        }
    };
}

void ArgumentCoder<IPC::StreamServerConnectionHandle>::encode(Encoder& encoder, IPC::StreamServerConnectionHandle&& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.outOfStreamConnection)>, IPC::ConnectionHandle>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.buffer)>, WebCore::SharedMemoryHandle>);
    struct ShouldBeSameSizeAsStreamServerConnectionHandle : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<IPC::StreamServerConnectionHandle>, false> {
        IPC::ConnectionHandle outOfStreamConnection;
        WebCore::SharedMemoryHandle buffer;
    };
    static_assert(sizeof(ShouldBeSameSizeAsStreamServerConnectionHandle) == sizeof(IPC::StreamServerConnectionHandle));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(IPC::StreamServerConnectionHandle, outOfStreamConnection)
        , offsetof(IPC::StreamServerConnectionHandle, buffer)
    >::value);

    encoder << WTFMove(instance.outOfStreamConnection);
    encoder << WTFMove(instance.buffer);
}

std::optional<IPC::StreamServerConnectionHandle> ArgumentCoder<IPC::StreamServerConnectionHandle>::decode(Decoder& decoder)
{
    auto outOfStreamConnection = decoder.decode<IPC::ConnectionHandle>();
    auto buffer = decoder.decode<WebCore::SharedMemoryHandle>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;

    if (!(IPC::StreamConnectionBuffer::sharedMemorySizeIsValid(buffer->size())))
        return std::nullopt;
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        IPC::StreamServerConnectionHandle {
            WTFMove(*outOfStreamConnection),
            WTFMove(*buffer)
        }
    };
}

void ArgumentCoder<WebKit::AccessibilityPreferences>::encode(Encoder& encoder, const WebKit::AccessibilityPreferences& instance)
{
#if HAVE(PER_APP_ACCESSIBILITY_PREFERENCES)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.reduceMotionEnabled)>, WebKit::WebKitAXValueState>);
#endif
#if HAVE(PER_APP_ACCESSIBILITY_PREFERENCES)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.increaseButtonLegibility)>, WebKit::WebKitAXValueState>);
#endif
#if HAVE(PER_APP_ACCESSIBILITY_PREFERENCES)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.enhanceTextLegibility)>, WebKit::WebKitAXValueState>);
#endif
#if HAVE(PER_APP_ACCESSIBILITY_PREFERENCES)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.darkenSystemColors)>, WebKit::WebKitAXValueState>);
#endif
#if HAVE(PER_APP_ACCESSIBILITY_PREFERENCES)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.invertColorsEnabled)>, WebKit::WebKitAXValueState>);
#endif
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.imageAnimationEnabled)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.enhanceTextLegibilityOverall)>, bool>);
#if ENABLE(ACCESSIBILITY_NON_BLINKING_CURSOR)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.prefersNonBlinkingCursor)>, bool>);
#endif
    struct ShouldBeSameSizeAsAccessibilityPreferences : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::AccessibilityPreferences>, false> {
#if HAVE(PER_APP_ACCESSIBILITY_PREFERENCES)
        WebKit::WebKitAXValueState reduceMotionEnabled;
#endif
#if HAVE(PER_APP_ACCESSIBILITY_PREFERENCES)
        WebKit::WebKitAXValueState increaseButtonLegibility;
#endif
#if HAVE(PER_APP_ACCESSIBILITY_PREFERENCES)
        WebKit::WebKitAXValueState enhanceTextLegibility;
#endif
#if HAVE(PER_APP_ACCESSIBILITY_PREFERENCES)
        WebKit::WebKitAXValueState darkenSystemColors;
#endif
#if HAVE(PER_APP_ACCESSIBILITY_PREFERENCES)
        WebKit::WebKitAXValueState invertColorsEnabled;
#endif
        bool imageAnimationEnabled;
        bool enhanceTextLegibilityOverall;
#if ENABLE(ACCESSIBILITY_NON_BLINKING_CURSOR)
        bool prefersNonBlinkingCursor;
#endif
    };
    static_assert(sizeof(ShouldBeSameSizeAsAccessibilityPreferences) == sizeof(WebKit::AccessibilityPreferences));
    static_assert(MembersInCorrectOrder < 0
#if HAVE(PER_APP_ACCESSIBILITY_PREFERENCES)
        , offsetof(WebKit::AccessibilityPreferences, reduceMotionEnabled)
#endif
#if HAVE(PER_APP_ACCESSIBILITY_PREFERENCES)
        , offsetof(WebKit::AccessibilityPreferences, increaseButtonLegibility)
#endif
#if HAVE(PER_APP_ACCESSIBILITY_PREFERENCES)
        , offsetof(WebKit::AccessibilityPreferences, enhanceTextLegibility)
#endif
#if HAVE(PER_APP_ACCESSIBILITY_PREFERENCES)
        , offsetof(WebKit::AccessibilityPreferences, darkenSystemColors)
#endif
#if HAVE(PER_APP_ACCESSIBILITY_PREFERENCES)
        , offsetof(WebKit::AccessibilityPreferences, invertColorsEnabled)
#endif
        , offsetof(WebKit::AccessibilityPreferences, imageAnimationEnabled)
        , offsetof(WebKit::AccessibilityPreferences, enhanceTextLegibilityOverall)
#if ENABLE(ACCESSIBILITY_NON_BLINKING_CURSOR)
        , offsetof(WebKit::AccessibilityPreferences, prefersNonBlinkingCursor)
#endif
    >::value);

#if HAVE(PER_APP_ACCESSIBILITY_PREFERENCES)
    encoder << instance.reduceMotionEnabled;
#endif
#if HAVE(PER_APP_ACCESSIBILITY_PREFERENCES)
    encoder << instance.increaseButtonLegibility;
#endif
#if HAVE(PER_APP_ACCESSIBILITY_PREFERENCES)
    encoder << instance.enhanceTextLegibility;
#endif
#if HAVE(PER_APP_ACCESSIBILITY_PREFERENCES)
    encoder << instance.darkenSystemColors;
#endif
#if HAVE(PER_APP_ACCESSIBILITY_PREFERENCES)
    encoder << instance.invertColorsEnabled;
#endif
    encoder << instance.imageAnimationEnabled;
    encoder << instance.enhanceTextLegibilityOverall;
#if ENABLE(ACCESSIBILITY_NON_BLINKING_CURSOR)
    encoder << instance.prefersNonBlinkingCursor;
#endif
}

std::optional<WebKit::AccessibilityPreferences> ArgumentCoder<WebKit::AccessibilityPreferences>::decode(Decoder& decoder)
{
#if HAVE(PER_APP_ACCESSIBILITY_PREFERENCES)
    auto reduceMotionEnabled = decoder.decode<WebKit::WebKitAXValueState>();
#endif
#if HAVE(PER_APP_ACCESSIBILITY_PREFERENCES)
    auto increaseButtonLegibility = decoder.decode<WebKit::WebKitAXValueState>();
#endif
#if HAVE(PER_APP_ACCESSIBILITY_PREFERENCES)
    auto enhanceTextLegibility = decoder.decode<WebKit::WebKitAXValueState>();
#endif
#if HAVE(PER_APP_ACCESSIBILITY_PREFERENCES)
    auto darkenSystemColors = decoder.decode<WebKit::WebKitAXValueState>();
#endif
#if HAVE(PER_APP_ACCESSIBILITY_PREFERENCES)
    auto invertColorsEnabled = decoder.decode<WebKit::WebKitAXValueState>();
#endif
    auto imageAnimationEnabled = decoder.decode<bool>();
    auto enhanceTextLegibilityOverall = decoder.decode<bool>();
#if ENABLE(ACCESSIBILITY_NON_BLINKING_CURSOR)
    auto prefersNonBlinkingCursor = decoder.decode<bool>();
#endif
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebKit::AccessibilityPreferences {
#if HAVE(PER_APP_ACCESSIBILITY_PREFERENCES)
            WTFMove(*reduceMotionEnabled),
#endif
#if HAVE(PER_APP_ACCESSIBILITY_PREFERENCES)
            WTFMove(*increaseButtonLegibility),
#endif
#if HAVE(PER_APP_ACCESSIBILITY_PREFERENCES)
            WTFMove(*enhanceTextLegibility),
#endif
#if HAVE(PER_APP_ACCESSIBILITY_PREFERENCES)
            WTFMove(*darkenSystemColors),
#endif
#if HAVE(PER_APP_ACCESSIBILITY_PREFERENCES)
            WTFMove(*invertColorsEnabled),
#endif
            WTFMove(*imageAnimationEnabled),
            WTFMove(*enhanceTextLegibilityOverall),
#if ENABLE(ACCESSIBILITY_NON_BLINKING_CURSOR)
            WTFMove(*prefersNonBlinkingCursor)
#endif
        }
    };
}

void ArgumentCoder<WebKit::AuxiliaryProcessCreationParameters>::encode(Encoder& encoder, const WebKit::AuxiliaryProcessCreationParameters& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.wtfLoggingChannels)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.webCoreLoggingChannels)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.webKitLoggingChannels)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.classNamesExemptFromSecureCodingCrash)>, std::unique_ptr<HashSet<String>>>);
    struct ShouldBeSameSizeAsAuxiliaryProcessCreationParameters : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::AuxiliaryProcessCreationParameters>, false> {
        String wtfLoggingChannels;
        String webCoreLoggingChannels;
        String webKitLoggingChannels;
        std::unique_ptr<HashSet<String>> classNamesExemptFromSecureCodingCrash;
    };
    static_assert(sizeof(ShouldBeSameSizeAsAuxiliaryProcessCreationParameters) == sizeof(WebKit::AuxiliaryProcessCreationParameters));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::AuxiliaryProcessCreationParameters, wtfLoggingChannels)
        , offsetof(WebKit::AuxiliaryProcessCreationParameters, webCoreLoggingChannels)
        , offsetof(WebKit::AuxiliaryProcessCreationParameters, webKitLoggingChannels)
        , offsetof(WebKit::AuxiliaryProcessCreationParameters, classNamesExemptFromSecureCodingCrash)
    >::value);

    encoder << instance.wtfLoggingChannels;
    encoder << instance.webCoreLoggingChannels;
    encoder << instance.webKitLoggingChannels;
    encoder << instance.classNamesExemptFromSecureCodingCrash;
}

std::optional<WebKit::AuxiliaryProcessCreationParameters> ArgumentCoder<WebKit::AuxiliaryProcessCreationParameters>::decode(Decoder& decoder)
{
    auto wtfLoggingChannels = decoder.decode<String>();
    auto webCoreLoggingChannels = decoder.decode<String>();
    auto webKitLoggingChannels = decoder.decode<String>();
    auto classNamesExemptFromSecureCodingCrash = decoder.decode<std::unique_ptr<HashSet<String>>>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebKit::AuxiliaryProcessCreationParameters {
            WTFMove(*wtfLoggingChannels),
            WTFMove(*webCoreLoggingChannels),
            WTFMove(*webKitLoggingChannels),
            WTFMove(*classNamesExemptFromSecureCodingCrash)
        }
    };
}

void ArgumentCoder<WebKit::BackgroundFetchState>::encode(Encoder& encoder, const WebKit::BackgroundFetchState& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.topOrigin)>, WebCore::SecurityOriginData>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.scope)>, URL>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.identifier)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.options)>, WebCore::BackgroundFetchOptions>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.downloadTotal)>, uint64_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.downloaded)>, uint64_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.uploadTotal)>, uint64_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.uploaded)>, uint64_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.result)>, WebCore::BackgroundFetchResult>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.failureReason)>, WebCore::BackgroundFetchFailureReason>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isPaused)>, bool>);
    struct ShouldBeSameSizeAsBackgroundFetchState : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::BackgroundFetchState>, false> {
        WebCore::SecurityOriginData topOrigin;
        URL scope;
        String identifier;
        WebCore::BackgroundFetchOptions options;
        uint64_t downloadTotal;
        uint64_t downloaded;
        uint64_t uploadTotal;
        uint64_t uploaded;
        WebCore::BackgroundFetchResult result;
        WebCore::BackgroundFetchFailureReason failureReason;
        bool isPaused;
    };
    static_assert(sizeof(ShouldBeSameSizeAsBackgroundFetchState) == sizeof(WebKit::BackgroundFetchState));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::BackgroundFetchState, topOrigin)
        , offsetof(WebKit::BackgroundFetchState, scope)
        , offsetof(WebKit::BackgroundFetchState, identifier)
        , offsetof(WebKit::BackgroundFetchState, options)
        , offsetof(WebKit::BackgroundFetchState, downloadTotal)
        , offsetof(WebKit::BackgroundFetchState, downloaded)
        , offsetof(WebKit::BackgroundFetchState, uploadTotal)
        , offsetof(WebKit::BackgroundFetchState, uploaded)
        , offsetof(WebKit::BackgroundFetchState, result)
        , offsetof(WebKit::BackgroundFetchState, failureReason)
        , offsetof(WebKit::BackgroundFetchState, isPaused)
    >::value);

    encoder << instance.topOrigin;
    encoder << instance.scope;
    encoder << instance.identifier;
    encoder << instance.options;
    encoder << instance.downloadTotal;
    encoder << instance.downloaded;
    encoder << instance.uploadTotal;
    encoder << instance.uploaded;
    encoder << instance.result;
    encoder << instance.failureReason;
    encoder << instance.isPaused;
}

std::optional<WebKit::BackgroundFetchState> ArgumentCoder<WebKit::BackgroundFetchState>::decode(Decoder& decoder)
{
    auto topOrigin = decoder.decode<WebCore::SecurityOriginData>();
    auto scope = decoder.decode<URL>();
    auto identifier = decoder.decode<String>();
    auto options = decoder.decode<WebCore::BackgroundFetchOptions>();
    auto downloadTotal = decoder.decode<uint64_t>();
    auto downloaded = decoder.decode<uint64_t>();
    auto uploadTotal = decoder.decode<uint64_t>();
    auto uploaded = decoder.decode<uint64_t>();
    auto result = decoder.decode<WebCore::BackgroundFetchResult>();
    auto failureReason = decoder.decode<WebCore::BackgroundFetchFailureReason>();
    auto isPaused = decoder.decode<bool>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebKit::BackgroundFetchState {
            WTFMove(*topOrigin),
            WTFMove(*scope),
            WTFMove(*identifier),
            WTFMove(*options),
            WTFMove(*downloadTotal),
            WTFMove(*downloaded),
            WTFMove(*uploadTotal),
            WTFMove(*uploaded),
            WTFMove(*result),
            WTFMove(*failureReason),
            WTFMove(*isPaused)
        }
    };
}

void ArgumentCoder<WebKit::CallbackID>::encode(Encoder& encoder, const WebKit::CallbackID& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_id)>, uint64_t>);
    struct ShouldBeSameSizeAsCallbackID : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::CallbackID>, false> {
        uint64_t m_id;
    };
    static_assert(sizeof(ShouldBeSameSizeAsCallbackID) == sizeof(WebKit::CallbackID));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::CallbackID, m_id)
    >::value);

    encoder << instance.m_id;
}

std::optional<WebKit::CallbackID> ArgumentCoder<WebKit::CallbackID>::decode(Decoder& decoder)
{
    auto m_id = decoder.decode<uint64_t>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;

    if (!(WebKit::CallbackID::isValidCallbackID(*m_id)))
        return std::nullopt;
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebKit::CallbackID {
            WTFMove(*m_id)
        }
    };
}

void ArgumentCoder<WebKit::ContentWorldData>::encode(Encoder& encoder, const WebKit::ContentWorldData& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.identifier)>, WebKit::ContentWorldIdentifier>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.name)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.options)>, OptionSet<WebKit::ContentWorldOption>>);
    struct ShouldBeSameSizeAsContentWorldData : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::ContentWorldData>, false> {
        WebKit::ContentWorldIdentifier identifier;
        String name;
        OptionSet<WebKit::ContentWorldOption> options;
    };
    static_assert(sizeof(ShouldBeSameSizeAsContentWorldData) == sizeof(WebKit::ContentWorldData));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::ContentWorldData, identifier)
        , offsetof(WebKit::ContentWorldData, name)
        , offsetof(WebKit::ContentWorldData, options)
    >::value);

    encoder << instance.identifier;
    encoder << instance.name;
    encoder << instance.options;
}

std::optional<WebKit::ContentWorldData> ArgumentCoder<WebKit::ContentWorldData>::decode(Decoder& decoder)
{
    bool addedDecodingFailureIndex = false;
    auto identifier = decoder.decode<WebKit::ContentWorldIdentifier>();
    if (!identifier && !addedDecodingFailureIndex) [[unlikely]] {
        decoder.addIndexOfDecodingFailure(0);
        addedDecodingFailureIndex = true;
    }
    auto name = decoder.decode<String>();
    if (!name && !addedDecodingFailureIndex) [[unlikely]] {
        decoder.addIndexOfDecodingFailure(1);
        addedDecodingFailureIndex = true;
    }
    auto options = decoder.decode<OptionSet<WebKit::ContentWorldOption>>();
    if (!options && !addedDecodingFailureIndex) [[unlikely]] {
        decoder.addIndexOfDecodingFailure(2);
        addedDecodingFailureIndex = true;
    }
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebKit::ContentWorldData {
            WTFMove(*identifier),
            WTFMove(*name),
            WTFMove(*options)
        }
    };
}

#if ENABLE(CONTEXT_MENUS)
void ArgumentCoder<WebKit::ContextMenuContextData>::encode(Encoder& encoder, const WebKit::ContextMenuContextData& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.type())>, WebCore::ContextMenuContextType>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.menuLocation())>, WebCore::IntPoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.menuItems())>, Vector<WebKit::WebContextMenuItemData>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.webHitTestResultData())>, std::optional<WebKit::WebHitTestResultData>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.selectedText())>, String>);
#if ENABLE(SERVICE_CONTROLS)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.createControlledImageReadOnlyHandle())>, std::optional<WebCore::ShareableBitmapHandle>>);
#endif
#if ENABLE(SERVICE_CONTROLS)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.controlledSelection())>, WebCore::AttributedString>);
#endif
#if ENABLE(SERVICE_CONTROLS)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.selectedTelephoneNumbers())>, Vector<String>>);
#endif
#if ENABLE(SERVICE_CONTROLS)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.selectionIsEditable())>, bool>);
#endif
#if ENABLE(SERVICE_CONTROLS)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.controlledImageBounds())>, WebCore::IntRect>);
#endif
#if ENABLE(SERVICE_CONTROLS)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.controlledImageAttachmentID())>, String>);
#endif
#if ENABLE(SERVICE_CONTROLS)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.controlledImageElementContext())>, std::optional<WebCore::ElementContext>>);
#endif
#if ENABLE(SERVICE_CONTROLS)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.controlledImageMIMEType())>, String>);
#endif
#if ENABLE(CONTEXT_MENU_QR_CODE_DETECTION)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.createPotentialQRCodeNodeSnapshotImageReadOnlyHandle())>, std::optional<WebCore::ShareableBitmapHandle>>);
#endif
#if ENABLE(CONTEXT_MENU_QR_CODE_DETECTION)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.createPotentialQRCodeViewportSnapshotImageReadOnlyHandle())>, std::optional<WebCore::ShareableBitmapHandle>>);
#endif
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.hasEntireImage())>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.allowsFollowingLink())>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.allowsFollowingImageURL())>, bool>);

    encoder << instance.type();
    encoder << instance.menuLocation();
    encoder << instance.menuItems();
    encoder << instance.webHitTestResultData();
    encoder << instance.selectedText();
#if ENABLE(SERVICE_CONTROLS)
    encoder << instance.createControlledImageReadOnlyHandle();
#endif
#if ENABLE(SERVICE_CONTROLS)
    encoder << instance.controlledSelection();
#endif
#if ENABLE(SERVICE_CONTROLS)
    encoder << instance.selectedTelephoneNumbers();
#endif
#if ENABLE(SERVICE_CONTROLS)
    encoder << instance.selectionIsEditable();
#endif
#if ENABLE(SERVICE_CONTROLS)
    encoder << instance.controlledImageBounds();
#endif
#if ENABLE(SERVICE_CONTROLS)
    encoder << instance.controlledImageAttachmentID();
#endif
#if ENABLE(SERVICE_CONTROLS)
    encoder << instance.controlledImageElementContext();
#endif
#if ENABLE(SERVICE_CONTROLS)
    encoder << instance.controlledImageMIMEType();
#endif
#if ENABLE(CONTEXT_MENU_QR_CODE_DETECTION)
    encoder << instance.createPotentialQRCodeNodeSnapshotImageReadOnlyHandle();
#endif
#if ENABLE(CONTEXT_MENU_QR_CODE_DETECTION)
    encoder << instance.createPotentialQRCodeViewportSnapshotImageReadOnlyHandle();
#endif
    encoder << instance.hasEntireImage();
    encoder << instance.allowsFollowingLink();
    encoder << instance.allowsFollowingImageURL();
}

std::optional<WebKit::ContextMenuContextData> ArgumentCoder<WebKit::ContextMenuContextData>::decode(Decoder& decoder)
{
    auto type = decoder.decode<WebCore::ContextMenuContextType>();
    auto menuLocation = decoder.decode<WebCore::IntPoint>();
    auto menuItems = decoder.decode<Vector<WebKit::WebContextMenuItemData>>();
    auto webHitTestResultData = decoder.decode<std::optional<WebKit::WebHitTestResultData>>();
    auto selectedText = decoder.decode<String>();
#if ENABLE(SERVICE_CONTROLS)
    auto createControlledImageReadOnlyHandle = decoder.decode<std::optional<WebCore::ShareableBitmapHandle>>();
#endif
#if ENABLE(SERVICE_CONTROLS)
    auto controlledSelection = decoder.decode<WebCore::AttributedString>();
#endif
#if ENABLE(SERVICE_CONTROLS)
    auto selectedTelephoneNumbers = decoder.decode<Vector<String>>();
#endif
#if ENABLE(SERVICE_CONTROLS)
    auto selectionIsEditable = decoder.decode<bool>();
#endif
#if ENABLE(SERVICE_CONTROLS)
    auto controlledImageBounds = decoder.decode<WebCore::IntRect>();
#endif
#if ENABLE(SERVICE_CONTROLS)
    auto controlledImageAttachmentID = decoder.decode<String>();
#endif
#if ENABLE(SERVICE_CONTROLS)
    auto controlledImageElementContext = decoder.decode<std::optional<WebCore::ElementContext>>();
#endif
#if ENABLE(SERVICE_CONTROLS)
    auto controlledImageMIMEType = decoder.decode<String>();
#endif
#if ENABLE(CONTEXT_MENU_QR_CODE_DETECTION)
    auto createPotentialQRCodeNodeSnapshotImageReadOnlyHandle = decoder.decode<std::optional<WebCore::ShareableBitmapHandle>>();
#endif
#if ENABLE(CONTEXT_MENU_QR_CODE_DETECTION)
    auto createPotentialQRCodeViewportSnapshotImageReadOnlyHandle = decoder.decode<std::optional<WebCore::ShareableBitmapHandle>>();
#endif
    auto hasEntireImage = decoder.decode<bool>();
    auto allowsFollowingLink = decoder.decode<bool>();
    auto allowsFollowingImageURL = decoder.decode<bool>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebKit::ContextMenuContextData {
            WTFMove(*type),
            WTFMove(*menuLocation),
            WTFMove(*menuItems),
            WTFMove(*webHitTestResultData),
            WTFMove(*selectedText),
#if ENABLE(SERVICE_CONTROLS)
            WTFMove(*createControlledImageReadOnlyHandle),
#endif
#if ENABLE(SERVICE_CONTROLS)
            WTFMove(*controlledSelection),
#endif
#if ENABLE(SERVICE_CONTROLS)
            WTFMove(*selectedTelephoneNumbers),
#endif
#if ENABLE(SERVICE_CONTROLS)
            WTFMove(*selectionIsEditable),
#endif
#if ENABLE(SERVICE_CONTROLS)
            WTFMove(*controlledImageBounds),
#endif
#if ENABLE(SERVICE_CONTROLS)
            WTFMove(*controlledImageAttachmentID),
#endif
#if ENABLE(SERVICE_CONTROLS)
            WTFMove(*controlledImageElementContext),
#endif
#if ENABLE(SERVICE_CONTROLS)
            WTFMove(*controlledImageMIMEType),
#endif
#if ENABLE(CONTEXT_MENU_QR_CODE_DETECTION)
            WTFMove(*createPotentialQRCodeNodeSnapshotImageReadOnlyHandle),
#endif
#if ENABLE(CONTEXT_MENU_QR_CODE_DETECTION)
            WTFMove(*createPotentialQRCodeViewportSnapshotImageReadOnlyHandle),
#endif
            WTFMove(*hasEntireImage),
            WTFMove(*allowsFollowingLink),
            WTFMove(*allowsFollowingImageURL)
        }
    };
}

#endif

void ArgumentCoder<WebKit::DebuggableInfoData>::encode(Encoder& encoder, const WebKit::DebuggableInfoData& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.debuggableType)>, Inspector::DebuggableType>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.targetPlatformName)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.targetBuildVersion)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.targetProductVersion)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.targetIsSimulator)>, bool>);
    struct ShouldBeSameSizeAsDebuggableInfoData : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::DebuggableInfoData>, false> {
        Inspector::DebuggableType debuggableType;
        String targetPlatformName;
        String targetBuildVersion;
        String targetProductVersion;
        bool targetIsSimulator;
    };
    static_assert(sizeof(ShouldBeSameSizeAsDebuggableInfoData) == sizeof(WebKit::DebuggableInfoData));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::DebuggableInfoData, debuggableType)
        , offsetof(WebKit::DebuggableInfoData, targetPlatformName)
        , offsetof(WebKit::DebuggableInfoData, targetBuildVersion)
        , offsetof(WebKit::DebuggableInfoData, targetProductVersion)
        , offsetof(WebKit::DebuggableInfoData, targetIsSimulator)
    >::value);

    encoder << instance.debuggableType;
    encoder << instance.targetPlatformName;
    encoder << instance.targetBuildVersion;
    encoder << instance.targetProductVersion;
    encoder << instance.targetIsSimulator;
}

std::optional<WebKit::DebuggableInfoData> ArgumentCoder<WebKit::DebuggableInfoData>::decode(Decoder& decoder)
{
    auto debuggableType = decoder.decode<Inspector::DebuggableType>();
    auto targetPlatformName = decoder.decode<String>();
    auto targetBuildVersion = decoder.decode<String>();
    auto targetProductVersion = decoder.decode<String>();
    auto targetIsSimulator = decoder.decode<bool>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebKit::DebuggableInfoData {
            WTFMove(*debuggableType),
            WTFMove(*targetPlatformName),
            WTFMove(*targetBuildVersion),
            WTFMove(*targetProductVersion),
            WTFMove(*targetIsSimulator)
        }
    };
}

#if PLATFORM(IOS_FAMILY)
void ArgumentCoder<WebKit::DocumentEditingContext::Range>::encode(Encoder& encoder, const WebKit::DocumentEditingContext::Range& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.location)>, uint64_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.length)>, uint64_t>);
    struct ShouldBeSameSizeAsRange : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::DocumentEditingContext::Range>, false> {
        uint64_t location;
        uint64_t length;
    };
    static_assert(sizeof(ShouldBeSameSizeAsRange) == sizeof(WebKit::DocumentEditingContext::Range));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::DocumentEditingContext::Range, location)
        , offsetof(WebKit::DocumentEditingContext::Range, length)
    >::value);

    encoder << instance.location;
    encoder << instance.length;
}

std::optional<WebKit::DocumentEditingContext::Range> ArgumentCoder<WebKit::DocumentEditingContext::Range>::decode(Decoder& decoder)
{
    auto location = decoder.decode<uint64_t>();
    auto length = decoder.decode<uint64_t>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;

    if (!(!(CheckedUint64 { *location } + *length).hasOverflowed()))
        return std::nullopt;
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebKit::DocumentEditingContext::Range {
            WTFMove(*location),
            WTFMove(*length)
        }
    };
}

#endif

#if PLATFORM(IOS_FAMILY)
void ArgumentCoder<WebKit::DocumentEditingContext::TextRectAndRange>::encode(Encoder& encoder, const WebKit::DocumentEditingContext::TextRectAndRange& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.rect)>, WebCore::FloatRect>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.range)>, WebKit::DocumentEditingContext::Range>);
    struct ShouldBeSameSizeAsTextRectAndRange : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::DocumentEditingContext::TextRectAndRange>, false> {
        WebCore::FloatRect rect;
        WebKit::DocumentEditingContext::Range range;
    };
    static_assert(sizeof(ShouldBeSameSizeAsTextRectAndRange) == sizeof(WebKit::DocumentEditingContext::TextRectAndRange));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::DocumentEditingContext::TextRectAndRange, rect)
        , offsetof(WebKit::DocumentEditingContext::TextRectAndRange, range)
    >::value);

    encoder << instance.rect;
    encoder << instance.range;
}

std::optional<WebKit::DocumentEditingContext::TextRectAndRange> ArgumentCoder<WebKit::DocumentEditingContext::TextRectAndRange>::decode(Decoder& decoder)
{
    auto rect = decoder.decode<WebCore::FloatRect>();
    auto range = decoder.decode<WebKit::DocumentEditingContext::Range>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebKit::DocumentEditingContext::TextRectAndRange {
            WTFMove(*rect),
            WTFMove(*range)
        }
    };
}

#endif

#if PLATFORM(IOS_FAMILY)
void ArgumentCoder<WebKit::DocumentEditingContextRequest>::encode(Encoder& encoder, const WebKit::DocumentEditingContextRequest& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.options)>, OptionSet<WebKit::DocumentEditingContextRequest::Options>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.surroundingGranularity)>, WebCore::TextGranularity>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.granularityCount)>, int64_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.rect)>, WebCore::FloatRect>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.textInputContext)>, std::optional<WebCore::ElementContext>>);
    struct ShouldBeSameSizeAsDocumentEditingContextRequest : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::DocumentEditingContextRequest>, false> {
        OptionSet<WebKit::DocumentEditingContextRequest::Options> options;
        WebCore::TextGranularity surroundingGranularity;
        int64_t granularityCount;
        WebCore::FloatRect rect;
        std::optional<WebCore::ElementContext> textInputContext;
    };
    static_assert(sizeof(ShouldBeSameSizeAsDocumentEditingContextRequest) == sizeof(WebKit::DocumentEditingContextRequest));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::DocumentEditingContextRequest, options)
        , offsetof(WebKit::DocumentEditingContextRequest, surroundingGranularity)
        , offsetof(WebKit::DocumentEditingContextRequest, granularityCount)
        , offsetof(WebKit::DocumentEditingContextRequest, rect)
        , offsetof(WebKit::DocumentEditingContextRequest, textInputContext)
    >::value);

    encoder << instance.options;
    encoder << instance.surroundingGranularity;
    encoder << instance.granularityCount;
    encoder << instance.rect;
    encoder << instance.textInputContext;
}

std::optional<WebKit::DocumentEditingContextRequest> ArgumentCoder<WebKit::DocumentEditingContextRequest>::decode(Decoder& decoder)
{
    auto options = decoder.decode<OptionSet<WebKit::DocumentEditingContextRequest::Options>>();
    auto surroundingGranularity = decoder.decode<WebCore::TextGranularity>();
    auto granularityCount = decoder.decode<int64_t>();
    auto rect = decoder.decode<WebCore::FloatRect>();
    auto textInputContext = decoder.decode<std::optional<WebCore::ElementContext>>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebKit::DocumentEditingContextRequest {
            WTFMove(*options),
            WTFMove(*surroundingGranularity),
            WTFMove(*granularityCount),
            WTFMove(*rect),
            WTFMove(*textInputContext)
        }
    };
}

#endif

#if PLATFORM(IOS_FAMILY)
void ArgumentCoder<WebKit::DocumentEditingContext>::encode(Encoder& encoder, const WebKit::DocumentEditingContext& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.contextBefore)>, WebCore::AttributedString>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.selectedText)>, WebCore::AttributedString>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.contextAfter)>, WebCore::AttributedString>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.markedText)>, WebCore::AttributedString>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.annotatedText)>, WebCore::AttributedString>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.selectedRangeInMarkedText)>, WebKit::DocumentEditingContext::Range>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.textRects)>, Vector<WebKit::DocumentEditingContext::TextRectAndRange>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.autocorrectedRanges)>, Vector<WebKit::DocumentEditingContext::Range>>);
    struct ShouldBeSameSizeAsDocumentEditingContext : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::DocumentEditingContext>, false> {
        WebCore::AttributedString contextBefore;
        WebCore::AttributedString selectedText;
        WebCore::AttributedString contextAfter;
        WebCore::AttributedString markedText;
        WebCore::AttributedString annotatedText;
        WebKit::DocumentEditingContext::Range selectedRangeInMarkedText;
        Vector<WebKit::DocumentEditingContext::TextRectAndRange> textRects;
        Vector<WebKit::DocumentEditingContext::Range> autocorrectedRanges;
    };
    static_assert(sizeof(ShouldBeSameSizeAsDocumentEditingContext) == sizeof(WebKit::DocumentEditingContext));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::DocumentEditingContext, contextBefore)
        , offsetof(WebKit::DocumentEditingContext, selectedText)
        , offsetof(WebKit::DocumentEditingContext, contextAfter)
        , offsetof(WebKit::DocumentEditingContext, markedText)
        , offsetof(WebKit::DocumentEditingContext, annotatedText)
        , offsetof(WebKit::DocumentEditingContext, selectedRangeInMarkedText)
        , offsetof(WebKit::DocumentEditingContext, textRects)
        , offsetof(WebKit::DocumentEditingContext, autocorrectedRanges)
    >::value);

    encoder << instance.contextBefore;
    encoder << instance.selectedText;
    encoder << instance.contextAfter;
    encoder << instance.markedText;
    encoder << instance.annotatedText;
    encoder << instance.selectedRangeInMarkedText;
    encoder << instance.textRects;
    encoder << instance.autocorrectedRanges;
}

std::optional<WebKit::DocumentEditingContext> ArgumentCoder<WebKit::DocumentEditingContext>::decode(Decoder& decoder)
{
    auto contextBefore = decoder.decode<WebCore::AttributedString>();
    auto selectedText = decoder.decode<WebCore::AttributedString>();
    auto contextAfter = decoder.decode<WebCore::AttributedString>();
    auto markedText = decoder.decode<WebCore::AttributedString>();
    auto annotatedText = decoder.decode<WebCore::AttributedString>();
    auto selectedRangeInMarkedText = decoder.decode<WebKit::DocumentEditingContext::Range>();
    auto textRects = decoder.decode<Vector<WebKit::DocumentEditingContext::TextRectAndRange>>();
    auto autocorrectedRanges = decoder.decode<Vector<WebKit::DocumentEditingContext::Range>>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebKit::DocumentEditingContext {
            WTFMove(*contextBefore),
            WTFMove(*selectedText),
            WTFMove(*contextAfter),
            WTFMove(*markedText),
            WTFMove(*annotatedText),
            WTFMove(*selectedRangeInMarkedText),
            WTFMove(*textRects),
            WTFMove(*autocorrectedRanges)
        }
    };
}

#endif

void ArgumentCoder<WebKit::EditingRange>::encode(Encoder& encoder, const WebKit::EditingRange& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.location)>, uint64_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.length)>, uint64_t>);
    struct ShouldBeSameSizeAsEditingRange : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::EditingRange>, false> {
        uint64_t location;
        uint64_t length;
    };
    static_assert(sizeof(ShouldBeSameSizeAsEditingRange) == sizeof(WebKit::EditingRange));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::EditingRange, location)
        , offsetof(WebKit::EditingRange, length)
    >::value);

    encoder << instance.location;
    encoder << instance.length;
}

std::optional<WebKit::EditingRange> ArgumentCoder<WebKit::EditingRange>::decode(Decoder& decoder)
{
    auto location = decoder.decode<uint64_t>();
    auto length = decoder.decode<uint64_t>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;

    if (!(!(Checked<uint64_t> { *location } + *length).hasOverflowed()))
        return std::nullopt;
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebKit::EditingRange {
            WTFMove(*location),
            WTFMove(*length)
        }
    };
}

void ArgumentCoder<WebKit::EditorState>::encode(Encoder& encoder, const WebKit::EditorState& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.identifier)>, WebKit::EditorStateIdentifier>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.shouldIgnoreSelectionChanges)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.selectionIsNone)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.selectionIsRange)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.selectionIsRangeInsideImageOverlay)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.selectionIsRangeInAutoFilledAndViewableField)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isContentEditable)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isContentRichlyEditable)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isInPasswordField)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.hasComposition)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.triggeredByAccessibilitySelectionChange)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isInPlugin)>, bool>);
#if PLATFORM(MAC)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.canEnableAutomaticSpellingCorrection)>, bool>);
#endif
#if PLATFORM(MAC)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.inputMethodUsesCorrectKeyEventOrder)>, bool>);
#endif
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.postLayoutData)>, std::optional<WebKit::EditorState::PostLayoutData>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.visualData)>, std::optional<WebKit::EditorState::VisualData>>);
    struct ShouldBeSameSizeAsEditorState : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::EditorState>, false> {
        WebKit::EditorStateIdentifier identifier;
        bool shouldIgnoreSelectionChanges;
        bool selectionIsNone;
        bool selectionIsRange;
        bool selectionIsRangeInsideImageOverlay;
        bool selectionIsRangeInAutoFilledAndViewableField;
        bool isContentEditable;
        bool isContentRichlyEditable;
        bool isInPasswordField;
        bool hasComposition;
        bool triggeredByAccessibilitySelectionChange;
        bool isInPlugin;
#if PLATFORM(MAC)
        bool canEnableAutomaticSpellingCorrection;
#endif
#if PLATFORM(MAC)
        bool inputMethodUsesCorrectKeyEventOrder;
#endif
        std::optional<WebKit::EditorState::PostLayoutData> postLayoutData;
        std::optional<WebKit::EditorState::VisualData> visualData;
    };
    static_assert(sizeof(ShouldBeSameSizeAsEditorState) == sizeof(WebKit::EditorState));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::EditorState, identifier)
        , offsetof(WebKit::EditorState, shouldIgnoreSelectionChanges)
        , offsetof(WebKit::EditorState, selectionIsNone)
        , offsetof(WebKit::EditorState, selectionIsRange)
        , offsetof(WebKit::EditorState, selectionIsRangeInsideImageOverlay)
        , offsetof(WebKit::EditorState, selectionIsRangeInAutoFilledAndViewableField)
        , offsetof(WebKit::EditorState, isContentEditable)
        , offsetof(WebKit::EditorState, isContentRichlyEditable)
        , offsetof(WebKit::EditorState, isInPasswordField)
        , offsetof(WebKit::EditorState, hasComposition)
        , offsetof(WebKit::EditorState, triggeredByAccessibilitySelectionChange)
        , offsetof(WebKit::EditorState, isInPlugin)
#if PLATFORM(MAC)
        , offsetof(WebKit::EditorState, canEnableAutomaticSpellingCorrection)
#endif
#if PLATFORM(MAC)
        , offsetof(WebKit::EditorState, inputMethodUsesCorrectKeyEventOrder)
#endif
        , offsetof(WebKit::EditorState, postLayoutData)
        , offsetof(WebKit::EditorState, visualData)
    >::value);

    encoder << instance.identifier;
    encoder << instance.shouldIgnoreSelectionChanges;
    encoder << instance.selectionIsNone;
    encoder << instance.selectionIsRange;
    encoder << instance.selectionIsRangeInsideImageOverlay;
    encoder << instance.selectionIsRangeInAutoFilledAndViewableField;
    encoder << instance.isContentEditable;
    encoder << instance.isContentRichlyEditable;
    encoder << instance.isInPasswordField;
    encoder << instance.hasComposition;
    encoder << instance.triggeredByAccessibilitySelectionChange;
    encoder << instance.isInPlugin;
#if PLATFORM(MAC)
    encoder << instance.canEnableAutomaticSpellingCorrection;
#endif
#if PLATFORM(MAC)
    encoder << instance.inputMethodUsesCorrectKeyEventOrder;
#endif
    encoder << instance.postLayoutData;
    encoder << instance.visualData;
}

std::optional<WebKit::EditorState> ArgumentCoder<WebKit::EditorState>::decode(Decoder& decoder)
{
    auto identifier = decoder.decode<WebKit::EditorStateIdentifier>();
    auto shouldIgnoreSelectionChanges = decoder.decode<bool>();
    auto selectionIsNone = decoder.decode<bool>();
    auto selectionIsRange = decoder.decode<bool>();
    auto selectionIsRangeInsideImageOverlay = decoder.decode<bool>();
    auto selectionIsRangeInAutoFilledAndViewableField = decoder.decode<bool>();
    auto isContentEditable = decoder.decode<bool>();
    auto isContentRichlyEditable = decoder.decode<bool>();
    auto isInPasswordField = decoder.decode<bool>();
    auto hasComposition = decoder.decode<bool>();
    auto triggeredByAccessibilitySelectionChange = decoder.decode<bool>();
    auto isInPlugin = decoder.decode<bool>();
#if PLATFORM(MAC)
    auto canEnableAutomaticSpellingCorrection = decoder.decode<bool>();
#endif
#if PLATFORM(MAC)
    auto inputMethodUsesCorrectKeyEventOrder = decoder.decode<bool>();
#endif
    auto postLayoutData = decoder.decode<std::optional<WebKit::EditorState::PostLayoutData>>();
    auto visualData = decoder.decode<std::optional<WebKit::EditorState::VisualData>>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebKit::EditorState {
            WTFMove(*identifier),
            WTFMove(*shouldIgnoreSelectionChanges),
            WTFMove(*selectionIsNone),
            WTFMove(*selectionIsRange),
            WTFMove(*selectionIsRangeInsideImageOverlay),
            WTFMove(*selectionIsRangeInAutoFilledAndViewableField),
            WTFMove(*isContentEditable),
            WTFMove(*isContentRichlyEditable),
            WTFMove(*isInPasswordField),
            WTFMove(*hasComposition),
            WTFMove(*triggeredByAccessibilitySelectionChange),
            WTFMove(*isInPlugin),
#if PLATFORM(MAC)
            WTFMove(*canEnableAutomaticSpellingCorrection),
#endif
#if PLATFORM(MAC)
            WTFMove(*inputMethodUsesCorrectKeyEventOrder),
#endif
            WTFMove(*postLayoutData),
            WTFMove(*visualData)
        }
    };
}

void ArgumentCoder<WebKit::EditorState::PostLayoutData>::encode(Encoder& encoder, const WebKit::EditorState::PostLayoutData& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.typingAttributes)>, OptionSet<WebKit::TypingAttribute>>);
#if PLATFORM(COCOA)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.selectedTextLength)>, uint64_t>);
#endif
#if PLATFORM(COCOA)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.textAlignment)>, WebKit::TextAlignment>);
#endif
#if PLATFORM(COCOA)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.textColor)>, WebCore::Color>);
#endif
#if PLATFORM(COCOA)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.enclosingListType)>, WebKit::ListType>);
#endif
#if PLATFORM(COCOA)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.baseWritingDirection)>, WebCore::WritingDirection>);
#endif
#if PLATFORM(COCOA)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.selectionIsTransparentOrFullyClipped)>, bool>);
#endif
#if PLATFORM(COCOA)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.canEnableWritingSuggestions)>, bool>);
#endif
#if PLATFORM(IOS_FAMILY)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.markedText)>, String>);
#endif
#if PLATFORM(IOS_FAMILY)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.wordAtSelection)>, String>);
#endif
#if PLATFORM(IOS_FAMILY)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.characterAfterSelection)>, char32_t>);
#endif
#if PLATFORM(IOS_FAMILY)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.characterBeforeSelection)>, char32_t>);
#endif
#if PLATFORM(IOS_FAMILY)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.twoCharacterBeforeSelection)>, char32_t>);
#endif
#if PLATFORM(IOS_FAMILY) && USE(DICTATION_ALTERNATIVES)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.dictationContextsForSelection)>, Vector<WebCore::DictationContext>>);
#endif
#if PLATFORM(IOS_FAMILY)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isReplaceAllowed)>, bool>);
#endif
#if PLATFORM(IOS_FAMILY)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.hasContent)>, bool>);
#endif
#if PLATFORM(IOS_FAMILY)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isStableStateUpdate)>, bool>);
#endif
#if PLATFORM(IOS_FAMILY)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.insideFixedPosition)>, bool>);
#endif
#if PLATFORM(IOS_FAMILY)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.hasPlainText)>, bool>);
#endif
#if PLATFORM(IOS_FAMILY)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.caretColor)>, WebCore::Color>);
#endif
#if PLATFORM(IOS_FAMILY)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.hasCaretColorAuto)>, bool>);
#endif
#if PLATFORM(IOS_FAMILY)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.atStartOfSentence)>, bool>);
#endif
#if PLATFORM(IOS_FAMILY)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.selectionStartIsAtParagraphBoundary)>, bool>);
#endif
#if PLATFORM(IOS_FAMILY)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.selectionEndIsAtParagraphBoundary)>, bool>);
#endif
#if PLATFORM(IOS_FAMILY)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.hasGrammarDocumentMarkers)>, bool>);
#endif
#if PLATFORM(IOS_FAMILY)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.selectedEditableImage)>, std::optional<WebCore::ElementContext>>);
#endif
#if PLATFORM(MAC)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.selectionBoundingRect)>, WebCore::IntRect>);
#endif
#if PLATFORM(MAC)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.candidateRequestStartPosition)>, uint64_t>);
#endif
#if PLATFORM(MAC)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.paragraphContextForCandidateRequest)>, String>);
#endif
#if PLATFORM(MAC)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.stringForCandidateRequest)>, String>);
#endif
#if PLATFORM(GTK) || PLATFORM(WPE)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.surroundingContext)>, String>);
#endif
#if PLATFORM(GTK) || PLATFORM(WPE)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.surroundingContextCursorPosition)>, uint64_t>);
#endif
#if PLATFORM(GTK) || PLATFORM(WPE)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.surroundingContextSelectionPosition)>, uint64_t>);
#endif
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.fontAttributes)>, std::optional<WebCore::FontAttributes>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.canCut)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.canCopy)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.canPaste)>, bool>);
    struct ShouldBeSameSizeAsPostLayoutData : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::EditorState::PostLayoutData>, false> {
        OptionSet<WebKit::TypingAttribute> typingAttributes;
#if PLATFORM(COCOA)
        uint64_t selectedTextLength;
#endif
#if PLATFORM(COCOA)
        WebKit::TextAlignment textAlignment;
#endif
#if PLATFORM(COCOA)
        WebCore::Color textColor;
#endif
#if PLATFORM(COCOA)
        WebKit::ListType enclosingListType;
#endif
#if PLATFORM(COCOA)
        WebCore::WritingDirection baseWritingDirection;
#endif
#if PLATFORM(COCOA)
        bool selectionIsTransparentOrFullyClipped;
#endif
#if PLATFORM(COCOA)
        bool canEnableWritingSuggestions;
#endif
#if PLATFORM(IOS_FAMILY)
        String markedText;
#endif
#if PLATFORM(IOS_FAMILY)
        String wordAtSelection;
#endif
#if PLATFORM(IOS_FAMILY)
        char32_t characterAfterSelection;
#endif
#if PLATFORM(IOS_FAMILY)
        char32_t characterBeforeSelection;
#endif
#if PLATFORM(IOS_FAMILY)
        char32_t twoCharacterBeforeSelection;
#endif
#if PLATFORM(IOS_FAMILY) && USE(DICTATION_ALTERNATIVES)
        Vector<WebCore::DictationContext> dictationContextsForSelection;
#endif
#if PLATFORM(IOS_FAMILY)
        bool isReplaceAllowed;
#endif
#if PLATFORM(IOS_FAMILY)
        bool hasContent;
#endif
#if PLATFORM(IOS_FAMILY)
        bool isStableStateUpdate;
#endif
#if PLATFORM(IOS_FAMILY)
        bool insideFixedPosition;
#endif
#if PLATFORM(IOS_FAMILY)
        bool hasPlainText;
#endif
#if PLATFORM(IOS_FAMILY)
        WebCore::Color caretColor;
#endif
#if PLATFORM(IOS_FAMILY)
        bool hasCaretColorAuto;
#endif
#if PLATFORM(IOS_FAMILY)
        bool atStartOfSentence;
#endif
#if PLATFORM(IOS_FAMILY)
        bool selectionStartIsAtParagraphBoundary;
#endif
#if PLATFORM(IOS_FAMILY)
        bool selectionEndIsAtParagraphBoundary;
#endif
#if PLATFORM(IOS_FAMILY)
        bool hasGrammarDocumentMarkers;
#endif
#if PLATFORM(IOS_FAMILY)
        std::optional<WebCore::ElementContext> selectedEditableImage;
#endif
#if PLATFORM(MAC)
        WebCore::IntRect selectionBoundingRect;
#endif
#if PLATFORM(MAC)
        uint64_t candidateRequestStartPosition;
#endif
#if PLATFORM(MAC)
        String paragraphContextForCandidateRequest;
#endif
#if PLATFORM(MAC)
        String stringForCandidateRequest;
#endif
#if PLATFORM(GTK) || PLATFORM(WPE)
        String surroundingContext;
#endif
#if PLATFORM(GTK) || PLATFORM(WPE)
        uint64_t surroundingContextCursorPosition;
#endif
#if PLATFORM(GTK) || PLATFORM(WPE)
        uint64_t surroundingContextSelectionPosition;
#endif
        std::optional<WebCore::FontAttributes> fontAttributes;
        bool canCut;
        bool canCopy;
        bool canPaste;
    };
    static_assert(sizeof(ShouldBeSameSizeAsPostLayoutData) == sizeof(WebKit::EditorState::PostLayoutData));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::EditorState::PostLayoutData, typingAttributes)
#if PLATFORM(COCOA)
        , offsetof(WebKit::EditorState::PostLayoutData, selectedTextLength)
#endif
#if PLATFORM(COCOA)
        , offsetof(WebKit::EditorState::PostLayoutData, textAlignment)
#endif
#if PLATFORM(COCOA)
        , offsetof(WebKit::EditorState::PostLayoutData, textColor)
#endif
#if PLATFORM(COCOA)
        , offsetof(WebKit::EditorState::PostLayoutData, enclosingListType)
#endif
#if PLATFORM(COCOA)
        , offsetof(WebKit::EditorState::PostLayoutData, baseWritingDirection)
#endif
#if PLATFORM(COCOA)
        , offsetof(WebKit::EditorState::PostLayoutData, selectionIsTransparentOrFullyClipped)
#endif
#if PLATFORM(COCOA)
        , offsetof(WebKit::EditorState::PostLayoutData, canEnableWritingSuggestions)
#endif
#if PLATFORM(IOS_FAMILY)
        , offsetof(WebKit::EditorState::PostLayoutData, markedText)
#endif
#if PLATFORM(IOS_FAMILY)
        , offsetof(WebKit::EditorState::PostLayoutData, wordAtSelection)
#endif
#if PLATFORM(IOS_FAMILY)
        , offsetof(WebKit::EditorState::PostLayoutData, characterAfterSelection)
#endif
#if PLATFORM(IOS_FAMILY)
        , offsetof(WebKit::EditorState::PostLayoutData, characterBeforeSelection)
#endif
#if PLATFORM(IOS_FAMILY)
        , offsetof(WebKit::EditorState::PostLayoutData, twoCharacterBeforeSelection)
#endif
#if PLATFORM(IOS_FAMILY) && USE(DICTATION_ALTERNATIVES)
        , offsetof(WebKit::EditorState::PostLayoutData, dictationContextsForSelection)
#endif
#if PLATFORM(IOS_FAMILY)
        , offsetof(WebKit::EditorState::PostLayoutData, isReplaceAllowed)
#endif
#if PLATFORM(IOS_FAMILY)
        , offsetof(WebKit::EditorState::PostLayoutData, hasContent)
#endif
#if PLATFORM(IOS_FAMILY)
        , offsetof(WebKit::EditorState::PostLayoutData, isStableStateUpdate)
#endif
#if PLATFORM(IOS_FAMILY)
        , offsetof(WebKit::EditorState::PostLayoutData, insideFixedPosition)
#endif
#if PLATFORM(IOS_FAMILY)
        , offsetof(WebKit::EditorState::PostLayoutData, hasPlainText)
#endif
#if PLATFORM(IOS_FAMILY)
        , offsetof(WebKit::EditorState::PostLayoutData, caretColor)
#endif
#if PLATFORM(IOS_FAMILY)
        , offsetof(WebKit::EditorState::PostLayoutData, hasCaretColorAuto)
#endif
#if PLATFORM(IOS_FAMILY)
        , offsetof(WebKit::EditorState::PostLayoutData, atStartOfSentence)
#endif
#if PLATFORM(IOS_FAMILY)
        , offsetof(WebKit::EditorState::PostLayoutData, selectionStartIsAtParagraphBoundary)
#endif
#if PLATFORM(IOS_FAMILY)
        , offsetof(WebKit::EditorState::PostLayoutData, selectionEndIsAtParagraphBoundary)
#endif
#if PLATFORM(IOS_FAMILY)
        , offsetof(WebKit::EditorState::PostLayoutData, hasGrammarDocumentMarkers)
#endif
#if PLATFORM(IOS_FAMILY)
        , offsetof(WebKit::EditorState::PostLayoutData, selectedEditableImage)
#endif
#if PLATFORM(MAC)
        , offsetof(WebKit::EditorState::PostLayoutData, selectionBoundingRect)
#endif
#if PLATFORM(MAC)
        , offsetof(WebKit::EditorState::PostLayoutData, candidateRequestStartPosition)
#endif
#if PLATFORM(MAC)
        , offsetof(WebKit::EditorState::PostLayoutData, paragraphContextForCandidateRequest)
#endif
#if PLATFORM(MAC)
        , offsetof(WebKit::EditorState::PostLayoutData, stringForCandidateRequest)
#endif
#if PLATFORM(GTK) || PLATFORM(WPE)
        , offsetof(WebKit::EditorState::PostLayoutData, surroundingContext)
#endif
#if PLATFORM(GTK) || PLATFORM(WPE)
        , offsetof(WebKit::EditorState::PostLayoutData, surroundingContextCursorPosition)
#endif
#if PLATFORM(GTK) || PLATFORM(WPE)
        , offsetof(WebKit::EditorState::PostLayoutData, surroundingContextSelectionPosition)
#endif
        , offsetof(WebKit::EditorState::PostLayoutData, fontAttributes)
        , offsetof(WebKit::EditorState::PostLayoutData, canCut)
        , offsetof(WebKit::EditorState::PostLayoutData, canCopy)
        , offsetof(WebKit::EditorState::PostLayoutData, canPaste)
    >::value);

    encoder << instance.typingAttributes;
#if PLATFORM(COCOA)
    encoder << instance.selectedTextLength;
#endif
#if PLATFORM(COCOA)
    encoder << instance.textAlignment;
#endif
#if PLATFORM(COCOA)
    encoder << instance.textColor;
#endif
#if PLATFORM(COCOA)
    encoder << instance.enclosingListType;
#endif
#if PLATFORM(COCOA)
    encoder << instance.baseWritingDirection;
#endif
#if PLATFORM(COCOA)
    encoder << instance.selectionIsTransparentOrFullyClipped;
#endif
#if PLATFORM(COCOA)
    encoder << instance.canEnableWritingSuggestions;
#endif
#if PLATFORM(IOS_FAMILY)
    encoder << instance.markedText;
#endif
#if PLATFORM(IOS_FAMILY)
    encoder << instance.wordAtSelection;
#endif
#if PLATFORM(IOS_FAMILY)
    encoder << instance.characterAfterSelection;
#endif
#if PLATFORM(IOS_FAMILY)
    encoder << instance.characterBeforeSelection;
#endif
#if PLATFORM(IOS_FAMILY)
    encoder << instance.twoCharacterBeforeSelection;
#endif
#if PLATFORM(IOS_FAMILY) && USE(DICTATION_ALTERNATIVES)
    encoder << instance.dictationContextsForSelection;
#endif
#if PLATFORM(IOS_FAMILY)
    encoder << instance.isReplaceAllowed;
#endif
#if PLATFORM(IOS_FAMILY)
    encoder << instance.hasContent;
#endif
#if PLATFORM(IOS_FAMILY)
    encoder << instance.isStableStateUpdate;
#endif
#if PLATFORM(IOS_FAMILY)
    encoder << instance.insideFixedPosition;
#endif
#if PLATFORM(IOS_FAMILY)
    encoder << instance.hasPlainText;
#endif
#if PLATFORM(IOS_FAMILY)
    encoder << instance.caretColor;
#endif
#if PLATFORM(IOS_FAMILY)
    encoder << instance.hasCaretColorAuto;
#endif
#if PLATFORM(IOS_FAMILY)
    encoder << instance.atStartOfSentence;
#endif
#if PLATFORM(IOS_FAMILY)
    encoder << instance.selectionStartIsAtParagraphBoundary;
#endif
#if PLATFORM(IOS_FAMILY)
    encoder << instance.selectionEndIsAtParagraphBoundary;
#endif
#if PLATFORM(IOS_FAMILY)
    encoder << instance.hasGrammarDocumentMarkers;
#endif
#if PLATFORM(IOS_FAMILY)
    encoder << instance.selectedEditableImage;
#endif
#if PLATFORM(MAC)
    encoder << instance.selectionBoundingRect;
#endif
#if PLATFORM(MAC)
    encoder << instance.candidateRequestStartPosition;
#endif
#if PLATFORM(MAC)
    encoder << instance.paragraphContextForCandidateRequest;
#endif
#if PLATFORM(MAC)
    encoder << instance.stringForCandidateRequest;
#endif
#if PLATFORM(GTK) || PLATFORM(WPE)
    encoder << instance.surroundingContext;
#endif
#if PLATFORM(GTK) || PLATFORM(WPE)
    encoder << instance.surroundingContextCursorPosition;
#endif
#if PLATFORM(GTK) || PLATFORM(WPE)
    encoder << instance.surroundingContextSelectionPosition;
#endif
    encoder << instance.fontAttributes;
    encoder << instance.canCut;
    encoder << instance.canCopy;
    encoder << instance.canPaste;
}

std::optional<WebKit::EditorState::PostLayoutData> ArgumentCoder<WebKit::EditorState::PostLayoutData>::decode(Decoder& decoder)
{
    auto typingAttributes = decoder.decode<OptionSet<WebKit::TypingAttribute>>();
#if PLATFORM(COCOA)
    auto selectedTextLength = decoder.decode<uint64_t>();
#endif
#if PLATFORM(COCOA)
    auto textAlignment = decoder.decode<WebKit::TextAlignment>();
#endif
#if PLATFORM(COCOA)
    auto textColor = decoder.decode<WebCore::Color>();
#endif
#if PLATFORM(COCOA)
    auto enclosingListType = decoder.decode<WebKit::ListType>();
#endif
#if PLATFORM(COCOA)
    auto baseWritingDirection = decoder.decode<WebCore::WritingDirection>();
#endif
#if PLATFORM(COCOA)
    auto selectionIsTransparentOrFullyClipped = decoder.decode<bool>();
#endif
#if PLATFORM(COCOA)
    auto canEnableWritingSuggestions = decoder.decode<bool>();
#endif
#if PLATFORM(IOS_FAMILY)
    auto markedText = decoder.decode<String>();
#endif
#if PLATFORM(IOS_FAMILY)
    auto wordAtSelection = decoder.decode<String>();
#endif
#if PLATFORM(IOS_FAMILY)
    auto characterAfterSelection = decoder.decode<char32_t>();
#endif
#if PLATFORM(IOS_FAMILY)
    auto characterBeforeSelection = decoder.decode<char32_t>();
#endif
#if PLATFORM(IOS_FAMILY)
    auto twoCharacterBeforeSelection = decoder.decode<char32_t>();
#endif
#if PLATFORM(IOS_FAMILY) && USE(DICTATION_ALTERNATIVES)
    auto dictationContextsForSelection = decoder.decode<Vector<WebCore::DictationContext>>();
#endif
#if PLATFORM(IOS_FAMILY)
    auto isReplaceAllowed = decoder.decode<bool>();
#endif
#if PLATFORM(IOS_FAMILY)
    auto hasContent = decoder.decode<bool>();
#endif
#if PLATFORM(IOS_FAMILY)
    auto isStableStateUpdate = decoder.decode<bool>();
#endif
#if PLATFORM(IOS_FAMILY)
    auto insideFixedPosition = decoder.decode<bool>();
#endif
#if PLATFORM(IOS_FAMILY)
    auto hasPlainText = decoder.decode<bool>();
#endif
#if PLATFORM(IOS_FAMILY)
    auto caretColor = decoder.decode<WebCore::Color>();
#endif
#if PLATFORM(IOS_FAMILY)
    auto hasCaretColorAuto = decoder.decode<bool>();
#endif
#if PLATFORM(IOS_FAMILY)
    auto atStartOfSentence = decoder.decode<bool>();
#endif
#if PLATFORM(IOS_FAMILY)
    auto selectionStartIsAtParagraphBoundary = decoder.decode<bool>();
#endif
#if PLATFORM(IOS_FAMILY)
    auto selectionEndIsAtParagraphBoundary = decoder.decode<bool>();
#endif
#if PLATFORM(IOS_FAMILY)
    auto hasGrammarDocumentMarkers = decoder.decode<bool>();
#endif
#if PLATFORM(IOS_FAMILY)
    auto selectedEditableImage = decoder.decode<std::optional<WebCore::ElementContext>>();
#endif
#if PLATFORM(MAC)
    auto selectionBoundingRect = decoder.decode<WebCore::IntRect>();
#endif
#if PLATFORM(MAC)
    auto candidateRequestStartPosition = decoder.decode<uint64_t>();
#endif
#if PLATFORM(MAC)
    auto paragraphContextForCandidateRequest = decoder.decode<String>();
#endif
#if PLATFORM(MAC)
    auto stringForCandidateRequest = decoder.decode<String>();
#endif
#if PLATFORM(GTK) || PLATFORM(WPE)
    auto surroundingContext = decoder.decode<String>();
#endif
#if PLATFORM(GTK) || PLATFORM(WPE)
    auto surroundingContextCursorPosition = decoder.decode<uint64_t>();
#endif
#if PLATFORM(GTK) || PLATFORM(WPE)
    auto surroundingContextSelectionPosition = decoder.decode<uint64_t>();
#endif
    auto fontAttributes = decoder.decode<std::optional<WebCore::FontAttributes>>();
    auto canCut = decoder.decode<bool>();
    auto canCopy = decoder.decode<bool>();
    auto canPaste = decoder.decode<bool>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebKit::EditorState::PostLayoutData {
            WTFMove(*typingAttributes),
#if PLATFORM(COCOA)
            WTFMove(*selectedTextLength),
#endif
#if PLATFORM(COCOA)
            WTFMove(*textAlignment),
#endif
#if PLATFORM(COCOA)
            WTFMove(*textColor),
#endif
#if PLATFORM(COCOA)
            WTFMove(*enclosingListType),
#endif
#if PLATFORM(COCOA)
            WTFMove(*baseWritingDirection),
#endif
#if PLATFORM(COCOA)
            WTFMove(*selectionIsTransparentOrFullyClipped),
#endif
#if PLATFORM(COCOA)
            WTFMove(*canEnableWritingSuggestions),
#endif
#if PLATFORM(IOS_FAMILY)
            WTFMove(*markedText),
#endif
#if PLATFORM(IOS_FAMILY)
            WTFMove(*wordAtSelection),
#endif
#if PLATFORM(IOS_FAMILY)
            WTFMove(*characterAfterSelection),
#endif
#if PLATFORM(IOS_FAMILY)
            WTFMove(*characterBeforeSelection),
#endif
#if PLATFORM(IOS_FAMILY)
            WTFMove(*twoCharacterBeforeSelection),
#endif
#if PLATFORM(IOS_FAMILY) && USE(DICTATION_ALTERNATIVES)
            WTFMove(*dictationContextsForSelection),
#endif
#if PLATFORM(IOS_FAMILY)
            WTFMove(*isReplaceAllowed),
#endif
#if PLATFORM(IOS_FAMILY)
            WTFMove(*hasContent),
#endif
#if PLATFORM(IOS_FAMILY)
            WTFMove(*isStableStateUpdate),
#endif
#if PLATFORM(IOS_FAMILY)
            WTFMove(*insideFixedPosition),
#endif
#if PLATFORM(IOS_FAMILY)
            WTFMove(*hasPlainText),
#endif
#if PLATFORM(IOS_FAMILY)
            WTFMove(*caretColor),
#endif
#if PLATFORM(IOS_FAMILY)
            WTFMove(*hasCaretColorAuto),
#endif
#if PLATFORM(IOS_FAMILY)
            WTFMove(*atStartOfSentence),
#endif
#if PLATFORM(IOS_FAMILY)
            WTFMove(*selectionStartIsAtParagraphBoundary),
#endif
#if PLATFORM(IOS_FAMILY)
            WTFMove(*selectionEndIsAtParagraphBoundary),
#endif
#if PLATFORM(IOS_FAMILY)
            WTFMove(*hasGrammarDocumentMarkers),
#endif
#if PLATFORM(IOS_FAMILY)
            WTFMove(*selectedEditableImage),
#endif
#if PLATFORM(MAC)
            WTFMove(*selectionBoundingRect),
#endif
#if PLATFORM(MAC)
            WTFMove(*candidateRequestStartPosition),
#endif
#if PLATFORM(MAC)
            WTFMove(*paragraphContextForCandidateRequest),
#endif
#if PLATFORM(MAC)
            WTFMove(*stringForCandidateRequest),
#endif
#if PLATFORM(GTK) || PLATFORM(WPE)
            WTFMove(*surroundingContext),
#endif
#if PLATFORM(GTK) || PLATFORM(WPE)
            WTFMove(*surroundingContextCursorPosition),
#endif
#if PLATFORM(GTK) || PLATFORM(WPE)
            WTFMove(*surroundingContextSelectionPosition),
#endif
            WTFMove(*fontAttributes),
            WTFMove(*canCut),
            WTFMove(*canCopy),
            WTFMove(*canPaste)
        }
    };
}

void ArgumentCoder<WebKit::EditorState::VisualData>::encode(Encoder& encoder, const WebKit::EditorState::VisualData& instance)
{
#if PLATFORM(IOS_FAMILY) || PLATFORM(GTK) || PLATFORM(WPE)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.caretRectAtStart)>, WebCore::IntRect>);
#endif
#if PLATFORM(IOS_FAMILY)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.selectionClipRect)>, WebCore::IntRect>);
#endif
#if PLATFORM(IOS_FAMILY)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.editableRootBounds)>, WebCore::IntRect>);
#endif
#if PLATFORM(IOS_FAMILY)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.caretRectAtEnd)>, WebCore::IntRect>);
#endif
#if PLATFORM(IOS_FAMILY)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.selectionGeometries)>, Vector<WebCore::SelectionGeometry>>);
#endif
#if PLATFORM(IOS_FAMILY)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.markedTextRects)>, Vector<WebCore::SelectionGeometry>>);
#endif
#if PLATFORM(IOS_FAMILY)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.markedTextCaretRectAtStart)>, WebCore::IntRect>);
#endif
#if PLATFORM(IOS_FAMILY)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.markedTextCaretRectAtEnd)>, WebCore::IntRect>);
#endif
#if PLATFORM(IOS_FAMILY)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.enclosingLayerID)>, std::optional<WebCore::PlatformLayerIdentifier>>);
#endif
#if PLATFORM(IOS_FAMILY)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.intersectingLayerIDs)>, Vector<WebCore::PlatformLayerIdentifier>>);
#endif
#if PLATFORM(IOS_FAMILY)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.enclosingScrollingNodeID)>, std::optional<WebCore::ScrollingNodeID>>);
#endif
#if PLATFORM(IOS_FAMILY)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.scrollingNodeIDAtStart)>, std::optional<WebCore::ScrollingNodeID>>);
#endif
#if PLATFORM(IOS_FAMILY)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.scrollingNodeIDAtEnd)>, std::optional<WebCore::ScrollingNodeID>>);
#endif
#if PLATFORM(IOS_FAMILY)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.enclosingScrollOffset)>, WebCore::ScrollOffset>);
#endif
#if PLATFORM(IOS_FAMILY)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.enclosingLayerUsesContentsLayer)>, bool>);
#endif
    struct ShouldBeSameSizeAsVisualData : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::EditorState::VisualData>, false> {
#if PLATFORM(IOS_FAMILY) || PLATFORM(GTK) || PLATFORM(WPE)
        WebCore::IntRect caretRectAtStart;
#endif
#if PLATFORM(IOS_FAMILY)
        WebCore::IntRect selectionClipRect;
#endif
#if PLATFORM(IOS_FAMILY)
        WebCore::IntRect editableRootBounds;
#endif
#if PLATFORM(IOS_FAMILY)
        WebCore::IntRect caretRectAtEnd;
#endif
#if PLATFORM(IOS_FAMILY)
        Vector<WebCore::SelectionGeometry> selectionGeometries;
#endif
#if PLATFORM(IOS_FAMILY)
        Vector<WebCore::SelectionGeometry> markedTextRects;
#endif
#if PLATFORM(IOS_FAMILY)
        WebCore::IntRect markedTextCaretRectAtStart;
#endif
#if PLATFORM(IOS_FAMILY)
        WebCore::IntRect markedTextCaretRectAtEnd;
#endif
#if PLATFORM(IOS_FAMILY)
        std::optional<WebCore::PlatformLayerIdentifier> enclosingLayerID;
#endif
#if PLATFORM(IOS_FAMILY)
        Vector<WebCore::PlatformLayerIdentifier> intersectingLayerIDs;
#endif
#if PLATFORM(IOS_FAMILY)
        std::optional<WebCore::ScrollingNodeID> enclosingScrollingNodeID;
#endif
#if PLATFORM(IOS_FAMILY)
        std::optional<WebCore::ScrollingNodeID> scrollingNodeIDAtStart;
#endif
#if PLATFORM(IOS_FAMILY)
        std::optional<WebCore::ScrollingNodeID> scrollingNodeIDAtEnd;
#endif
#if PLATFORM(IOS_FAMILY)
        WebCore::ScrollOffset enclosingScrollOffset;
#endif
#if PLATFORM(IOS_FAMILY)
        bool enclosingLayerUsesContentsLayer;
#endif
    };
    static_assert(sizeof(ShouldBeSameSizeAsVisualData) == sizeof(WebKit::EditorState::VisualData));
    static_assert(MembersInCorrectOrder < 0
#if PLATFORM(IOS_FAMILY) || PLATFORM(GTK) || PLATFORM(WPE)
        , offsetof(WebKit::EditorState::VisualData, caretRectAtStart)
#endif
#if PLATFORM(IOS_FAMILY)
        , offsetof(WebKit::EditorState::VisualData, selectionClipRect)
#endif
#if PLATFORM(IOS_FAMILY)
        , offsetof(WebKit::EditorState::VisualData, editableRootBounds)
#endif
#if PLATFORM(IOS_FAMILY)
        , offsetof(WebKit::EditorState::VisualData, caretRectAtEnd)
#endif
#if PLATFORM(IOS_FAMILY)
        , offsetof(WebKit::EditorState::VisualData, selectionGeometries)
#endif
#if PLATFORM(IOS_FAMILY)
        , offsetof(WebKit::EditorState::VisualData, markedTextRects)
#endif
#if PLATFORM(IOS_FAMILY)
        , offsetof(WebKit::EditorState::VisualData, markedTextCaretRectAtStart)
#endif
#if PLATFORM(IOS_FAMILY)
        , offsetof(WebKit::EditorState::VisualData, markedTextCaretRectAtEnd)
#endif
#if PLATFORM(IOS_FAMILY)
        , offsetof(WebKit::EditorState::VisualData, enclosingLayerID)
#endif
#if PLATFORM(IOS_FAMILY)
        , offsetof(WebKit::EditorState::VisualData, intersectingLayerIDs)
#endif
#if PLATFORM(IOS_FAMILY)
        , offsetof(WebKit::EditorState::VisualData, enclosingScrollingNodeID)
#endif
#if PLATFORM(IOS_FAMILY)
        , offsetof(WebKit::EditorState::VisualData, scrollingNodeIDAtStart)
#endif
#if PLATFORM(IOS_FAMILY)
        , offsetof(WebKit::EditorState::VisualData, scrollingNodeIDAtEnd)
#endif
#if PLATFORM(IOS_FAMILY)
        , offsetof(WebKit::EditorState::VisualData, enclosingScrollOffset)
#endif
#if PLATFORM(IOS_FAMILY)
        , offsetof(WebKit::EditorState::VisualData, enclosingLayerUsesContentsLayer)
#endif
    >::value);

#if PLATFORM(IOS_FAMILY) || PLATFORM(GTK) || PLATFORM(WPE)
    encoder << instance.caretRectAtStart;
#endif
#if PLATFORM(IOS_FAMILY)
    encoder << instance.selectionClipRect;
#endif
#if PLATFORM(IOS_FAMILY)
    encoder << instance.editableRootBounds;
#endif
#if PLATFORM(IOS_FAMILY)
    encoder << instance.caretRectAtEnd;
#endif
#if PLATFORM(IOS_FAMILY)
    encoder << instance.selectionGeometries;
#endif
#if PLATFORM(IOS_FAMILY)
    encoder << instance.markedTextRects;
#endif
#if PLATFORM(IOS_FAMILY)
    encoder << instance.markedTextCaretRectAtStart;
#endif
#if PLATFORM(IOS_FAMILY)
    encoder << instance.markedTextCaretRectAtEnd;
#endif
#if PLATFORM(IOS_FAMILY)
    encoder << instance.enclosingLayerID;
#endif
#if PLATFORM(IOS_FAMILY)
    encoder << instance.intersectingLayerIDs;
#endif
#if PLATFORM(IOS_FAMILY)
    encoder << instance.enclosingScrollingNodeID;
#endif
#if PLATFORM(IOS_FAMILY)
    encoder << instance.scrollingNodeIDAtStart;
#endif
#if PLATFORM(IOS_FAMILY)
    encoder << instance.scrollingNodeIDAtEnd;
#endif
#if PLATFORM(IOS_FAMILY)
    encoder << instance.enclosingScrollOffset;
#endif
#if PLATFORM(IOS_FAMILY)
    encoder << instance.enclosingLayerUsesContentsLayer;
#endif
}

std::optional<WebKit::EditorState::VisualData> ArgumentCoder<WebKit::EditorState::VisualData>::decode(Decoder& decoder)
{
#if PLATFORM(IOS_FAMILY) || PLATFORM(GTK) || PLATFORM(WPE)
    auto caretRectAtStart = decoder.decode<WebCore::IntRect>();
#endif
#if PLATFORM(IOS_FAMILY)
    auto selectionClipRect = decoder.decode<WebCore::IntRect>();
#endif
#if PLATFORM(IOS_FAMILY)
    auto editableRootBounds = decoder.decode<WebCore::IntRect>();
#endif
#if PLATFORM(IOS_FAMILY)
    auto caretRectAtEnd = decoder.decode<WebCore::IntRect>();
#endif
#if PLATFORM(IOS_FAMILY)
    auto selectionGeometries = decoder.decode<Vector<WebCore::SelectionGeometry>>();
#endif
#if PLATFORM(IOS_FAMILY)
    auto markedTextRects = decoder.decode<Vector<WebCore::SelectionGeometry>>();
#endif
#if PLATFORM(IOS_FAMILY)
    auto markedTextCaretRectAtStart = decoder.decode<WebCore::IntRect>();
#endif
#if PLATFORM(IOS_FAMILY)
    auto markedTextCaretRectAtEnd = decoder.decode<WebCore::IntRect>();
#endif
#if PLATFORM(IOS_FAMILY)
    auto enclosingLayerID = decoder.decode<std::optional<WebCore::PlatformLayerIdentifier>>();
#endif
#if PLATFORM(IOS_FAMILY)
    auto intersectingLayerIDs = decoder.decode<Vector<WebCore::PlatformLayerIdentifier>>();
#endif
#if PLATFORM(IOS_FAMILY)
    auto enclosingScrollingNodeID = decoder.decode<std::optional<WebCore::ScrollingNodeID>>();
#endif
#if PLATFORM(IOS_FAMILY)
    auto scrollingNodeIDAtStart = decoder.decode<std::optional<WebCore::ScrollingNodeID>>();
#endif
#if PLATFORM(IOS_FAMILY)
    auto scrollingNodeIDAtEnd = decoder.decode<std::optional<WebCore::ScrollingNodeID>>();
#endif
#if PLATFORM(IOS_FAMILY)
    auto enclosingScrollOffset = decoder.decode<WebCore::ScrollOffset>();
#endif
#if PLATFORM(IOS_FAMILY)
    auto enclosingLayerUsesContentsLayer = decoder.decode<bool>();
#endif
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebKit::EditorState::VisualData {
#if PLATFORM(IOS_FAMILY) || PLATFORM(GTK) || PLATFORM(WPE)
            WTFMove(*caretRectAtStart),
#endif
#if PLATFORM(IOS_FAMILY)
            WTFMove(*selectionClipRect),
#endif
#if PLATFORM(IOS_FAMILY)
            WTFMove(*editableRootBounds),
#endif
#if PLATFORM(IOS_FAMILY)
            WTFMove(*caretRectAtEnd),
#endif
#if PLATFORM(IOS_FAMILY)
            WTFMove(*selectionGeometries),
#endif
#if PLATFORM(IOS_FAMILY)
            WTFMove(*markedTextRects),
#endif
#if PLATFORM(IOS_FAMILY)
            WTFMove(*markedTextCaretRectAtStart),
#endif
#if PLATFORM(IOS_FAMILY)
            WTFMove(*markedTextCaretRectAtEnd),
#endif
#if PLATFORM(IOS_FAMILY)
            WTFMove(*enclosingLayerID),
#endif
#if PLATFORM(IOS_FAMILY)
            WTFMove(*intersectingLayerIDs),
#endif
#if PLATFORM(IOS_FAMILY)
            WTFMove(*enclosingScrollingNodeID),
#endif
#if PLATFORM(IOS_FAMILY)
            WTFMove(*scrollingNodeIDAtStart),
#endif
#if PLATFORM(IOS_FAMILY)
            WTFMove(*scrollingNodeIDAtEnd),
#endif
#if PLATFORM(IOS_FAMILY)
            WTFMove(*enclosingScrollOffset),
#endif
#if PLATFORM(IOS_FAMILY)
            WTFMove(*enclosingLayerUsesContentsLayer)
#endif
        }
    };
}

void ArgumentCoder<WebKit::FileSystemSyncAccessHandleInfo>::encode(Encoder& encoder, const WebKit::FileSystemSyncAccessHandleInfo& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.identifier)>, Markable<WebCore::FileSystemSyncAccessHandleIdentifier>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.handle)>, IPC::SharedFileHandle>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.capacity)>, uint64_t>);
    struct ShouldBeSameSizeAsFileSystemSyncAccessHandleInfo : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::FileSystemSyncAccessHandleInfo>, false> {
        Markable<WebCore::FileSystemSyncAccessHandleIdentifier> identifier;
        IPC::SharedFileHandle handle;
        uint64_t capacity;
    };
    static_assert(sizeof(ShouldBeSameSizeAsFileSystemSyncAccessHandleInfo) == sizeof(WebKit::FileSystemSyncAccessHandleInfo));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::FileSystemSyncAccessHandleInfo, identifier)
        , offsetof(WebKit::FileSystemSyncAccessHandleInfo, handle)
        , offsetof(WebKit::FileSystemSyncAccessHandleInfo, capacity)
    >::value);

    encoder << instance.identifier;
    encoder << instance.handle;
    encoder << instance.capacity;
}

std::optional<WebKit::FileSystemSyncAccessHandleInfo> ArgumentCoder<WebKit::FileSystemSyncAccessHandleInfo>::decode(Decoder& decoder)
{
    auto identifier = decoder.decode<Markable<WebCore::FileSystemSyncAccessHandleIdentifier>>();
    auto handle = decoder.decode<IPC::SharedFileHandle>();
    auto capacity = decoder.decode<uint64_t>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebKit::FileSystemSyncAccessHandleInfo {
            WTFMove(*identifier),
            WTFMove(*handle),
            WTFMove(*capacity)
        }
    };
}

#if PLATFORM(IOS_FAMILY)
void ArgumentCoder<WebKit::OptionItem>::encode(Encoder& encoder, const WebKit::OptionItem& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.text)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isGroup)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isSelected)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.disabled)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.parentGroupID)>, int>);
    struct ShouldBeSameSizeAsOptionItem : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::OptionItem>, false> {
        String text;
        bool isGroup;
        bool isSelected;
        bool disabled;
        int parentGroupID;
    };
    static_assert(sizeof(ShouldBeSameSizeAsOptionItem) == sizeof(WebKit::OptionItem));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::OptionItem, text)
        , offsetof(WebKit::OptionItem, isGroup)
        , offsetof(WebKit::OptionItem, isSelected)
        , offsetof(WebKit::OptionItem, disabled)
        , offsetof(WebKit::OptionItem, parentGroupID)
    >::value);

    encoder << instance.text;
    encoder << instance.isGroup;
    encoder << instance.isSelected;
    encoder << instance.disabled;
    encoder << instance.parentGroupID;
}

std::optional<WebKit::OptionItem> ArgumentCoder<WebKit::OptionItem>::decode(Decoder& decoder)
{
    auto text = decoder.decode<String>();
    auto isGroup = decoder.decode<bool>();
    auto isSelected = decoder.decode<bool>();
    auto disabled = decoder.decode<bool>();
    auto parentGroupID = decoder.decode<int>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebKit::OptionItem {
            WTFMove(*text),
            WTFMove(*isGroup),
            WTFMove(*isSelected),
            WTFMove(*disabled),
            WTFMove(*parentGroupID)
        }
    };
}

#endif

#if PLATFORM(IOS_FAMILY)
void ArgumentCoder<WebKit::FocusedElementInformation>::encode(Encoder& encoder, const WebKit::FocusedElementInformation& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.interactionRect)>, WebCore::IntRect>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.elementContext)>, WebCore::ElementContext>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.lastInteractionLocation)>, WebCore::IntPoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.minimumScaleFactor)>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.maximumScaleFactor)>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.maximumScaleFactorIgnoringAlwaysScalable)>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.nodeFontSize)>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.hasNextNode)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.nextNodeRect)>, WebCore::IntRect>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.hasPreviousNode)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.previousNodeRect)>, WebCore::IntRect>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isAutocorrect)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isRTL)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isMultiSelect)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isReadOnly)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.allowsUserScaling)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.allowsUserScalingIgnoringAlwaysScalable)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.insideFixedPosition)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.hasPlainText)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.autocapitalizeType)>, WebCore::AutocapitalizeType>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.elementType)>, WebKit::InputType>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.inputMode)>, WebCore::InputMode>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.enterKeyHint)>, WebCore::EnterKeyHint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.formAction)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.selectOptions)>, Vector<WebKit::OptionItem>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.selectedIndex)>, int>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.value)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.valueAsNumber)>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.title)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.acceptsAutofilledLoginCredentials)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isAutofillableUsernameField)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.representingPageURL)>, URL>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.autofillFieldName)>, WebCore::AutofillFieldName>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.nonAutofillCredentialType)>, WebCore::NonAutofillCredentialType>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.placeholder)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.label)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.ariaLabel)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.hasSuggestions)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isFocusingWithDataListDropdown)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.colorValue)>, WebCore::Color>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.supportsAlpha)>, WebKit::ColorControlSupportsAlpha>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.suggestedColors)>, Vector<WebCore::Color>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.hasEverBeenPasswordField)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.shouldSynthesizeKeyEventsForEditing)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isSpellCheckingEnabled)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isWritingSuggestionsEnabled)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.shouldAvoidResizingWhenInputViewBoundsChange)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.shouldAvoidScrollingWhenFocusedContentIsVisible)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.shouldUseLegacySelectPopoverDismissalBehaviorInDataActivation)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.shouldHideSoftTopScrollEdgeEffect)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isFocusingWithValidationMessage)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.preventScroll)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.identifier)>, WebKit::FocusedElementInformationIdentifier>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.containerScrollingNodeID)>, Markable<WebCore::ScrollingNodeID>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.frame)>, std::optional<WebKit::FrameInfoData>>);
    struct ShouldBeSameSizeAsFocusedElementInformation : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::FocusedElementInformation>, false> {
        WebCore::IntRect interactionRect;
        WebCore::ElementContext elementContext;
        WebCore::IntPoint lastInteractionLocation;
        double minimumScaleFactor;
        double maximumScaleFactor;
        double maximumScaleFactorIgnoringAlwaysScalable;
        double nodeFontSize;
        bool hasNextNode;
        WebCore::IntRect nextNodeRect;
        bool hasPreviousNode;
        WebCore::IntRect previousNodeRect;
        bool isAutocorrect;
        bool isRTL;
        bool isMultiSelect;
        bool isReadOnly;
        bool allowsUserScaling;
        bool allowsUserScalingIgnoringAlwaysScalable;
        bool insideFixedPosition;
        bool hasPlainText;
        WebCore::AutocapitalizeType autocapitalizeType;
        WebKit::InputType elementType;
        WebCore::InputMode inputMode;
        WebCore::EnterKeyHint enterKeyHint;
        String formAction;
        Vector<WebKit::OptionItem> selectOptions;
        int selectedIndex;
        String value;
        double valueAsNumber;
        String title;
        bool acceptsAutofilledLoginCredentials;
        bool isAutofillableUsernameField;
        URL representingPageURL;
        WebCore::AutofillFieldName autofillFieldName;
        WebCore::NonAutofillCredentialType nonAutofillCredentialType;
        String placeholder;
        String label;
        String ariaLabel;
        bool hasSuggestions;
        bool isFocusingWithDataListDropdown;
        WebCore::Color colorValue;
        WebKit::ColorControlSupportsAlpha supportsAlpha;
        Vector<WebCore::Color> suggestedColors;
        bool hasEverBeenPasswordField;
        bool shouldSynthesizeKeyEventsForEditing;
        bool isSpellCheckingEnabled;
        bool isWritingSuggestionsEnabled;
        bool shouldAvoidResizingWhenInputViewBoundsChange;
        bool shouldAvoidScrollingWhenFocusedContentIsVisible;
        bool shouldUseLegacySelectPopoverDismissalBehaviorInDataActivation;
        bool shouldHideSoftTopScrollEdgeEffect;
        bool isFocusingWithValidationMessage;
        bool preventScroll;
        WebKit::FocusedElementInformationIdentifier identifier;
        Markable<WebCore::ScrollingNodeID> containerScrollingNodeID;
        std::optional<WebKit::FrameInfoData> frame;
    };
    static_assert(sizeof(ShouldBeSameSizeAsFocusedElementInformation) == sizeof(WebKit::FocusedElementInformation));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::FocusedElementInformation, interactionRect)
        , offsetof(WebKit::FocusedElementInformation, elementContext)
        , offsetof(WebKit::FocusedElementInformation, lastInteractionLocation)
        , offsetof(WebKit::FocusedElementInformation, minimumScaleFactor)
        , offsetof(WebKit::FocusedElementInformation, maximumScaleFactor)
        , offsetof(WebKit::FocusedElementInformation, maximumScaleFactorIgnoringAlwaysScalable)
        , offsetof(WebKit::FocusedElementInformation, nodeFontSize)
        , offsetof(WebKit::FocusedElementInformation, hasNextNode)
        , offsetof(WebKit::FocusedElementInformation, nextNodeRect)
        , offsetof(WebKit::FocusedElementInformation, hasPreviousNode)
        , offsetof(WebKit::FocusedElementInformation, previousNodeRect)
        , offsetof(WebKit::FocusedElementInformation, isAutocorrect)
        , offsetof(WebKit::FocusedElementInformation, isRTL)
        , offsetof(WebKit::FocusedElementInformation, isMultiSelect)
        , offsetof(WebKit::FocusedElementInformation, isReadOnly)
        , offsetof(WebKit::FocusedElementInformation, allowsUserScaling)
        , offsetof(WebKit::FocusedElementInformation, allowsUserScalingIgnoringAlwaysScalable)
        , offsetof(WebKit::FocusedElementInformation, insideFixedPosition)
        , offsetof(WebKit::FocusedElementInformation, hasPlainText)
        , offsetof(WebKit::FocusedElementInformation, autocapitalizeType)
        , offsetof(WebKit::FocusedElementInformation, elementType)
        , offsetof(WebKit::FocusedElementInformation, inputMode)
        , offsetof(WebKit::FocusedElementInformation, enterKeyHint)
        , offsetof(WebKit::FocusedElementInformation, formAction)
        , offsetof(WebKit::FocusedElementInformation, selectOptions)
        , offsetof(WebKit::FocusedElementInformation, selectedIndex)
        , offsetof(WebKit::FocusedElementInformation, value)
        , offsetof(WebKit::FocusedElementInformation, valueAsNumber)
        , offsetof(WebKit::FocusedElementInformation, title)
        , offsetof(WebKit::FocusedElementInformation, acceptsAutofilledLoginCredentials)
        , offsetof(WebKit::FocusedElementInformation, isAutofillableUsernameField)
        , offsetof(WebKit::FocusedElementInformation, representingPageURL)
        , offsetof(WebKit::FocusedElementInformation, autofillFieldName)
        , offsetof(WebKit::FocusedElementInformation, nonAutofillCredentialType)
        , offsetof(WebKit::FocusedElementInformation, placeholder)
        , offsetof(WebKit::FocusedElementInformation, label)
        , offsetof(WebKit::FocusedElementInformation, ariaLabel)
        , offsetof(WebKit::FocusedElementInformation, hasSuggestions)
        , offsetof(WebKit::FocusedElementInformation, isFocusingWithDataListDropdown)
        , offsetof(WebKit::FocusedElementInformation, colorValue)
        , offsetof(WebKit::FocusedElementInformation, supportsAlpha)
        , offsetof(WebKit::FocusedElementInformation, suggestedColors)
        , offsetof(WebKit::FocusedElementInformation, hasEverBeenPasswordField)
        , offsetof(WebKit::FocusedElementInformation, shouldSynthesizeKeyEventsForEditing)
        , offsetof(WebKit::FocusedElementInformation, isSpellCheckingEnabled)
        , offsetof(WebKit::FocusedElementInformation, isWritingSuggestionsEnabled)
        , offsetof(WebKit::FocusedElementInformation, shouldAvoidResizingWhenInputViewBoundsChange)
        , offsetof(WebKit::FocusedElementInformation, shouldAvoidScrollingWhenFocusedContentIsVisible)
        , offsetof(WebKit::FocusedElementInformation, shouldUseLegacySelectPopoverDismissalBehaviorInDataActivation)
        , offsetof(WebKit::FocusedElementInformation, shouldHideSoftTopScrollEdgeEffect)
        , offsetof(WebKit::FocusedElementInformation, isFocusingWithValidationMessage)
        , offsetof(WebKit::FocusedElementInformation, preventScroll)
        , offsetof(WebKit::FocusedElementInformation, identifier)
        , offsetof(WebKit::FocusedElementInformation, containerScrollingNodeID)
        , offsetof(WebKit::FocusedElementInformation, frame)
    >::value);

    encoder << instance.interactionRect;
    encoder << instance.elementContext;
    encoder << instance.lastInteractionLocation;
    encoder << instance.minimumScaleFactor;
    encoder << instance.maximumScaleFactor;
    encoder << instance.maximumScaleFactorIgnoringAlwaysScalable;
    encoder << instance.nodeFontSize;
    encoder << instance.hasNextNode;
    encoder << instance.nextNodeRect;
    encoder << instance.hasPreviousNode;
    encoder << instance.previousNodeRect;
    encoder << instance.isAutocorrect;
    encoder << instance.isRTL;
    encoder << instance.isMultiSelect;
    encoder << instance.isReadOnly;
    encoder << instance.allowsUserScaling;
    encoder << instance.allowsUserScalingIgnoringAlwaysScalable;
    encoder << instance.insideFixedPosition;
    encoder << instance.hasPlainText;
    encoder << instance.autocapitalizeType;
    encoder << instance.elementType;
    encoder << instance.inputMode;
    encoder << instance.enterKeyHint;
    encoder << instance.formAction;
    encoder << instance.selectOptions;
    encoder << instance.selectedIndex;
    encoder << instance.value;
    encoder << instance.valueAsNumber;
    encoder << instance.title;
    encoder << instance.acceptsAutofilledLoginCredentials;
    encoder << instance.isAutofillableUsernameField;
    encoder << instance.representingPageURL;
    encoder << instance.autofillFieldName;
    encoder << instance.nonAutofillCredentialType;
    encoder << instance.placeholder;
    encoder << instance.label;
    encoder << instance.ariaLabel;
    encoder << instance.hasSuggestions;
    encoder << instance.isFocusingWithDataListDropdown;
    encoder << instance.colorValue;
    encoder << instance.supportsAlpha;
    encoder << instance.suggestedColors;
    encoder << instance.hasEverBeenPasswordField;
    encoder << instance.shouldSynthesizeKeyEventsForEditing;
    encoder << instance.isSpellCheckingEnabled;
    encoder << instance.isWritingSuggestionsEnabled;
    encoder << instance.shouldAvoidResizingWhenInputViewBoundsChange;
    encoder << instance.shouldAvoidScrollingWhenFocusedContentIsVisible;
    encoder << instance.shouldUseLegacySelectPopoverDismissalBehaviorInDataActivation;
    encoder << instance.shouldHideSoftTopScrollEdgeEffect;
    encoder << instance.isFocusingWithValidationMessage;
    encoder << instance.preventScroll;
    encoder << instance.identifier;
    encoder << instance.containerScrollingNodeID;
    encoder << instance.frame;
}

std::optional<WebKit::FocusedElementInformation> ArgumentCoder<WebKit::FocusedElementInformation>::decode(Decoder& decoder)
{
    auto interactionRect = decoder.decode<WebCore::IntRect>();
    auto elementContext = decoder.decode<WebCore::ElementContext>();
    auto lastInteractionLocation = decoder.decode<WebCore::IntPoint>();
    auto minimumScaleFactor = decoder.decode<double>();
    auto maximumScaleFactor = decoder.decode<double>();
    auto maximumScaleFactorIgnoringAlwaysScalable = decoder.decode<double>();
    auto nodeFontSize = decoder.decode<double>();
    auto hasNextNode = decoder.decode<bool>();
    auto nextNodeRect = decoder.decode<WebCore::IntRect>();
    auto hasPreviousNode = decoder.decode<bool>();
    auto previousNodeRect = decoder.decode<WebCore::IntRect>();
    auto isAutocorrect = decoder.decode<bool>();
    auto isRTL = decoder.decode<bool>();
    auto isMultiSelect = decoder.decode<bool>();
    auto isReadOnly = decoder.decode<bool>();
    auto allowsUserScaling = decoder.decode<bool>();
    auto allowsUserScalingIgnoringAlwaysScalable = decoder.decode<bool>();
    auto insideFixedPosition = decoder.decode<bool>();
    auto hasPlainText = decoder.decode<bool>();
    auto autocapitalizeType = decoder.decode<WebCore::AutocapitalizeType>();
    auto elementType = decoder.decode<WebKit::InputType>();
    auto inputMode = decoder.decode<WebCore::InputMode>();
    auto enterKeyHint = decoder.decode<WebCore::EnterKeyHint>();
    auto formAction = decoder.decode<String>();
    auto selectOptions = decoder.decode<Vector<WebKit::OptionItem>>();
    auto selectedIndex = decoder.decode<int>();
    auto value = decoder.decode<String>();
    auto valueAsNumber = decoder.decode<double>();
    auto title = decoder.decode<String>();
    auto acceptsAutofilledLoginCredentials = decoder.decode<bool>();
    auto isAutofillableUsernameField = decoder.decode<bool>();
    auto representingPageURL = decoder.decode<URL>();
    auto autofillFieldName = decoder.decode<WebCore::AutofillFieldName>();
    auto nonAutofillCredentialType = decoder.decode<WebCore::NonAutofillCredentialType>();
    auto placeholder = decoder.decode<String>();
    auto label = decoder.decode<String>();
    auto ariaLabel = decoder.decode<String>();
    auto hasSuggestions = decoder.decode<bool>();
    auto isFocusingWithDataListDropdown = decoder.decode<bool>();
    auto colorValue = decoder.decode<WebCore::Color>();
    auto supportsAlpha = decoder.decode<WebKit::ColorControlSupportsAlpha>();
    auto suggestedColors = decoder.decode<Vector<WebCore::Color>>();
    auto hasEverBeenPasswordField = decoder.decode<bool>();
    auto shouldSynthesizeKeyEventsForEditing = decoder.decode<bool>();
    auto isSpellCheckingEnabled = decoder.decode<bool>();
    auto isWritingSuggestionsEnabled = decoder.decode<bool>();
    auto shouldAvoidResizingWhenInputViewBoundsChange = decoder.decode<bool>();
    auto shouldAvoidScrollingWhenFocusedContentIsVisible = decoder.decode<bool>();
    auto shouldUseLegacySelectPopoverDismissalBehaviorInDataActivation = decoder.decode<bool>();
    auto shouldHideSoftTopScrollEdgeEffect = decoder.decode<bool>();
    auto isFocusingWithValidationMessage = decoder.decode<bool>();
    auto preventScroll = decoder.decode<bool>();
    auto identifier = decoder.decode<WebKit::FocusedElementInformationIdentifier>();
    auto containerScrollingNodeID = decoder.decode<Markable<WebCore::ScrollingNodeID>>();
    auto frame = decoder.decode<std::optional<WebKit::FrameInfoData>>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebKit::FocusedElementInformation {
            WTFMove(*interactionRect),
            WTFMove(*elementContext),
            WTFMove(*lastInteractionLocation),
            WTFMove(*minimumScaleFactor),
            WTFMove(*maximumScaleFactor),
            WTFMove(*maximumScaleFactorIgnoringAlwaysScalable),
            WTFMove(*nodeFontSize),
            WTFMove(*hasNextNode),
            WTFMove(*nextNodeRect),
            WTFMove(*hasPreviousNode),
            WTFMove(*previousNodeRect),
            WTFMove(*isAutocorrect),
            WTFMove(*isRTL),
            WTFMove(*isMultiSelect),
            WTFMove(*isReadOnly),
            WTFMove(*allowsUserScaling),
            WTFMove(*allowsUserScalingIgnoringAlwaysScalable),
            WTFMove(*insideFixedPosition),
            WTFMove(*hasPlainText),
            WTFMove(*autocapitalizeType),
            WTFMove(*elementType),
            WTFMove(*inputMode),
            WTFMove(*enterKeyHint),
            WTFMove(*formAction),
            WTFMove(*selectOptions),
            WTFMove(*selectedIndex),
            WTFMove(*value),
            WTFMove(*valueAsNumber),
            WTFMove(*title),
            WTFMove(*acceptsAutofilledLoginCredentials),
            WTFMove(*isAutofillableUsernameField),
            WTFMove(*representingPageURL),
            WTFMove(*autofillFieldName),
            WTFMove(*nonAutofillCredentialType),
            WTFMove(*placeholder),
            WTFMove(*label),
            WTFMove(*ariaLabel),
            WTFMove(*hasSuggestions),
            WTFMove(*isFocusingWithDataListDropdown),
            WTFMove(*colorValue),
            WTFMove(*supportsAlpha),
            WTFMove(*suggestedColors),
            WTFMove(*hasEverBeenPasswordField),
            WTFMove(*shouldSynthesizeKeyEventsForEditing),
            WTFMove(*isSpellCheckingEnabled),
            WTFMove(*isWritingSuggestionsEnabled),
            WTFMove(*shouldAvoidResizingWhenInputViewBoundsChange),
            WTFMove(*shouldAvoidScrollingWhenFocusedContentIsVisible),
            WTFMove(*shouldUseLegacySelectPopoverDismissalBehaviorInDataActivation),
            WTFMove(*shouldHideSoftTopScrollEdgeEffect),
            WTFMove(*isFocusingWithValidationMessage),
            WTFMove(*preventScroll),
            WTFMove(*identifier),
            WTFMove(*containerScrollingNodeID),
            WTFMove(*frame)
        }
    };
}

#endif

void ArgumentCoder<WebKit::FrameInfoData>::encode(Encoder& encoder, const WebKit::FrameInfoData& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isMainFrame)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.frameType)>, WebKit::FrameType>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.request)>, WebCore::ResourceRequest>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.securityOrigin)>, WebCore::SecurityOriginData>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.frameName)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.frameID)>, WebCore::FrameIdentifier>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.parentFrameID)>, Markable<WebCore::FrameIdentifier>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.documentID)>, Markable<WebCore::ScriptExecutionContextIdentifier>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.certificateInfo)>, WebCore::CertificateInfo>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.processID)>, WTF::ProcessID>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isFocused)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.errorOccurred)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.frameMetrics)>, WebKit::WebFrameMetrics>);
    struct ShouldBeSameSizeAsFrameInfoData : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::FrameInfoData>, false> {
        bool isMainFrame;
        WebKit::FrameType frameType;
        WebCore::ResourceRequest request;
        WebCore::SecurityOriginData securityOrigin;
        String frameName;
        WebCore::FrameIdentifier frameID;
        Markable<WebCore::FrameIdentifier> parentFrameID;
        Markable<WebCore::ScriptExecutionContextIdentifier> documentID;
        WebCore::CertificateInfo certificateInfo;
        WTF::ProcessID processID;
        bool isFocused;
        bool errorOccurred;
        WebKit::WebFrameMetrics frameMetrics;
    };
    static_assert(sizeof(ShouldBeSameSizeAsFrameInfoData) == sizeof(WebKit::FrameInfoData));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::FrameInfoData, isMainFrame)
        , offsetof(WebKit::FrameInfoData, frameType)
        , offsetof(WebKit::FrameInfoData, request)
        , offsetof(WebKit::FrameInfoData, securityOrigin)
        , offsetof(WebKit::FrameInfoData, frameName)
        , offsetof(WebKit::FrameInfoData, frameID)
        , offsetof(WebKit::FrameInfoData, parentFrameID)
        , offsetof(WebKit::FrameInfoData, documentID)
        , offsetof(WebKit::FrameInfoData, certificateInfo)
        , offsetof(WebKit::FrameInfoData, processID)
        , offsetof(WebKit::FrameInfoData, isFocused)
        , offsetof(WebKit::FrameInfoData, errorOccurred)
        , offsetof(WebKit::FrameInfoData, frameMetrics)
    >::value);

    encoder << instance.isMainFrame;
    encoder << instance.frameType;
    encoder << instance.request;
    encoder << instance.securityOrigin;
    encoder << instance.frameName;
    encoder << instance.frameID;
    encoder << instance.parentFrameID;
    encoder << instance.documentID;
    encoder << instance.certificateInfo;
    encoder << instance.processID;
    encoder << instance.isFocused;
    encoder << instance.errorOccurred;
    encoder << instance.frameMetrics;
}

std::optional<WebKit::FrameInfoData> ArgumentCoder<WebKit::FrameInfoData>::decode(Decoder& decoder)
{
    auto isMainFrame = decoder.decode<bool>();
    auto frameType = decoder.decode<WebKit::FrameType>();
    auto request = decoder.decode<WebCore::ResourceRequest>();
    auto securityOrigin = decoder.decode<WebCore::SecurityOriginData>();
    auto frameName = decoder.decode<String>();
    auto frameID = decoder.decode<WebCore::FrameIdentifier>();
    auto parentFrameID = decoder.decode<Markable<WebCore::FrameIdentifier>>();
    auto documentID = decoder.decode<Markable<WebCore::ScriptExecutionContextIdentifier>>();
    auto certificateInfo = decoder.decode<WebCore::CertificateInfo>();
    auto processID = decoder.decode<WTF::ProcessID>();
    auto isFocused = decoder.decode<bool>();
    auto errorOccurred = decoder.decode<bool>();
    auto frameMetrics = decoder.decode<WebKit::WebFrameMetrics>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebKit::FrameInfoData {
            WTFMove(*isMainFrame),
            WTFMove(*frameType),
            WTFMove(*request),
            WTFMove(*securityOrigin),
            WTFMove(*frameName),
            WTFMove(*frameID),
            WTFMove(*parentFrameID),
            WTFMove(*documentID),
            WTFMove(*certificateInfo),
            WTFMove(*processID),
            WTFMove(*isFocused),
            WTFMove(*errorOccurred),
            WTFMove(*frameMetrics)
        }
    };
}

void ArgumentCoder<WebKit::FrameTreeCreationParameters>::encode(Encoder& encoder, const WebKit::FrameTreeCreationParameters& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.frameID)>, WebCore::FrameIdentifier>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.openerFrameID)>, std::optional<WebCore::FrameIdentifier>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.frameName)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.frameTreeSyncData)>, Ref<WebCore::FrameTreeSyncData>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.children)>, Vector<WebKit::FrameTreeCreationParameters>>);
    struct ShouldBeSameSizeAsFrameTreeCreationParameters : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::FrameTreeCreationParameters>, false> {
        WebCore::FrameIdentifier frameID;
        std::optional<WebCore::FrameIdentifier> openerFrameID;
        String frameName;
        Ref<WebCore::FrameTreeSyncData> frameTreeSyncData;
        Vector<WebKit::FrameTreeCreationParameters> children;
    };
    static_assert(sizeof(ShouldBeSameSizeAsFrameTreeCreationParameters) == sizeof(WebKit::FrameTreeCreationParameters));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::FrameTreeCreationParameters, frameID)
        , offsetof(WebKit::FrameTreeCreationParameters, openerFrameID)
        , offsetof(WebKit::FrameTreeCreationParameters, frameName)
        , offsetof(WebKit::FrameTreeCreationParameters, frameTreeSyncData)
        , offsetof(WebKit::FrameTreeCreationParameters, children)
    >::value);

    encoder << instance.frameID;
    encoder << instance.openerFrameID;
    encoder << instance.frameName;
    encoder << instance.frameTreeSyncData;
    encoder << instance.children;
}

std::optional<WebKit::FrameTreeCreationParameters> ArgumentCoder<WebKit::FrameTreeCreationParameters>::decode(Decoder& decoder)
{
    auto frameID = decoder.decode<WebCore::FrameIdentifier>();
    auto openerFrameID = decoder.decode<std::optional<WebCore::FrameIdentifier>>();
    auto frameName = decoder.decode<String>();
    auto frameTreeSyncData = decoder.decode<Ref<WebCore::FrameTreeSyncData>>();
    auto children = decoder.decode<Vector<WebKit::FrameTreeCreationParameters>>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebKit::FrameTreeCreationParameters {
            WTFMove(*frameID),
            WTFMove(*openerFrameID),
            WTFMove(*frameName),
            WTFMove(*frameTreeSyncData),
            WTFMove(*children)
        }
    };
}

void ArgumentCoder<WebKit::FrameTreeNodeData>::encode(Encoder& encoder, const WebKit::FrameTreeNodeData& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.info)>, WebKit::FrameInfoData>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.children)>, Vector<WebKit::FrameTreeNodeData>>);
    struct ShouldBeSameSizeAsFrameTreeNodeData : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::FrameTreeNodeData>, false> {
        WebKit::FrameInfoData info;
        Vector<WebKit::FrameTreeNodeData> children;
    };
    static_assert(sizeof(ShouldBeSameSizeAsFrameTreeNodeData) == sizeof(WebKit::FrameTreeNodeData));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::FrameTreeNodeData, info)
        , offsetof(WebKit::FrameTreeNodeData, children)
    >::value);

    encoder << instance.info;
    encoder << instance.children;
}

std::optional<WebKit::FrameTreeNodeData> ArgumentCoder<WebKit::FrameTreeNodeData>::decode(Decoder& decoder)
{
    auto info = decoder.decode<WebKit::FrameInfoData>();
    auto children = decoder.decode<Vector<WebKit::FrameTreeNodeData>>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebKit::FrameTreeNodeData {
            WTFMove(*info),
            WTFMove(*children)
        }
    };
}

void ArgumentCoder<WebKit::FullScreenMediaDetails>::encode(Encoder& encoder, WebKit::FullScreenMediaDetails&& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.type)>, WebKit::FullScreenMediaDetails::Type>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.mediaDimensions)>, WebCore::FloatSize>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.mimeType)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.imageHandle)>, std::optional<WebCore::SharedMemory::Handle>>);
    struct ShouldBeSameSizeAsFullScreenMediaDetails : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::FullScreenMediaDetails>, false> {
        WebKit::FullScreenMediaDetails::Type type;
        WebCore::FloatSize mediaDimensions;
        String mimeType;
        std::optional<WebCore::SharedMemory::Handle> imageHandle;
    };
    static_assert(sizeof(ShouldBeSameSizeAsFullScreenMediaDetails) == sizeof(WebKit::FullScreenMediaDetails));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::FullScreenMediaDetails, type)
        , offsetof(WebKit::FullScreenMediaDetails, mediaDimensions)
        , offsetof(WebKit::FullScreenMediaDetails, mimeType)
        , offsetof(WebKit::FullScreenMediaDetails, imageHandle)
    >::value);

    encoder << WTFMove(instance.type);
    encoder << WTFMove(instance.mediaDimensions);
    encoder << WTFMove(instance.mimeType);
    encoder << WTFMove(instance.imageHandle);
}

std::optional<WebKit::FullScreenMediaDetails> ArgumentCoder<WebKit::FullScreenMediaDetails>::decode(Decoder& decoder)
{
    auto type = decoder.decode<WebKit::FullScreenMediaDetails::Type>();
    auto mediaDimensions = decoder.decode<WebCore::FloatSize>();
    auto mimeType = decoder.decode<String>();
    auto imageHandle = decoder.decode<std::optional<WebCore::SharedMemory::Handle>>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebKit::FullScreenMediaDetails {
            WTFMove(*type),
            WTFMove(*mediaDimensions),
            WTFMove(*mimeType),
            WTFMove(*imageHandle)
        }
    };
}

#if ENABLE(GPU_PROCESS)
void ArgumentCoder<WebKit::GPUProcessConnectionParameters>::encode(Encoder& encoder, WebKit::GPUProcessConnectionParameters&& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.webProcessIdentity)>, WebCore::ProcessIdentity>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.sharedPreferencesForWebProcess)>, WebKit::SharedPreferencesForWebProcess>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isLockdownModeEnabled)>, bool>);
#if ENABLE(IPC_TESTING_API)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.ignoreInvalidMessageForTesting)>, bool>);
#endif
#if HAVE(AUDIT_TOKEN)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.presentingApplicationAuditTokens)>, HashMap<WebCore::PageIdentifier, WebKit::CoreIPCAuditToken>>);
#endif
#if PLATFORM(COCOA)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.applicationBundleIdentifier)>, String>);
#endif
#if ENABLE(VP9)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.hasVP9HardwareDecoder)>, std::optional<bool>>);
#endif
#if ENABLE(AV1)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.hasAV1HardwareDecoder)>, std::optional<bool>>);
#endif
    struct ShouldBeSameSizeAsGPUProcessConnectionParameters : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::GPUProcessConnectionParameters>, false> {
        WebCore::ProcessIdentity webProcessIdentity;
        WebKit::SharedPreferencesForWebProcess sharedPreferencesForWebProcess;
        bool isLockdownModeEnabled;
#if ENABLE(IPC_TESTING_API)
        bool ignoreInvalidMessageForTesting;
#endif
#if HAVE(AUDIT_TOKEN)
        HashMap<WebCore::PageIdentifier, WebKit::CoreIPCAuditToken> presentingApplicationAuditTokens;
#endif
#if PLATFORM(COCOA)
        String applicationBundleIdentifier;
#endif
#if ENABLE(VP9)
        std::optional<bool> hasVP9HardwareDecoder;
#endif
#if ENABLE(AV1)
        std::optional<bool> hasAV1HardwareDecoder;
#endif
    };
    static_assert(sizeof(ShouldBeSameSizeAsGPUProcessConnectionParameters) == sizeof(WebKit::GPUProcessConnectionParameters));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::GPUProcessConnectionParameters, webProcessIdentity)
        , offsetof(WebKit::GPUProcessConnectionParameters, sharedPreferencesForWebProcess)
        , offsetof(WebKit::GPUProcessConnectionParameters, isLockdownModeEnabled)
#if ENABLE(IPC_TESTING_API)
        , offsetof(WebKit::GPUProcessConnectionParameters, ignoreInvalidMessageForTesting)
#endif
#if HAVE(AUDIT_TOKEN)
        , offsetof(WebKit::GPUProcessConnectionParameters, presentingApplicationAuditTokens)
#endif
#if PLATFORM(COCOA)
        , offsetof(WebKit::GPUProcessConnectionParameters, applicationBundleIdentifier)
#endif
#if ENABLE(VP9)
        , offsetof(WebKit::GPUProcessConnectionParameters, hasVP9HardwareDecoder)
#endif
#if ENABLE(AV1)
        , offsetof(WebKit::GPUProcessConnectionParameters, hasAV1HardwareDecoder)
#endif
    >::value);

    encoder << WTFMove(instance.webProcessIdentity);
    encoder << WTFMove(instance.sharedPreferencesForWebProcess);
    encoder << WTFMove(instance.isLockdownModeEnabled);
#if ENABLE(IPC_TESTING_API)
    encoder << WTFMove(instance.ignoreInvalidMessageForTesting);
#endif
#if HAVE(AUDIT_TOKEN)
    encoder << WTFMove(instance.presentingApplicationAuditTokens);
#endif
#if PLATFORM(COCOA)
    encoder << WTFMove(instance.applicationBundleIdentifier);
#endif
#if ENABLE(VP9)
    encoder << WTFMove(instance.hasVP9HardwareDecoder);
#endif
#if ENABLE(AV1)
    encoder << WTFMove(instance.hasAV1HardwareDecoder);
#endif
}

std::optional<WebKit::GPUProcessConnectionParameters> ArgumentCoder<WebKit::GPUProcessConnectionParameters>::decode(Decoder& decoder)
{
    auto webProcessIdentity = decoder.decode<WebCore::ProcessIdentity>();
    auto sharedPreferencesForWebProcess = decoder.decode<WebKit::SharedPreferencesForWebProcess>();
    auto isLockdownModeEnabled = decoder.decode<bool>();
#if ENABLE(IPC_TESTING_API)
    auto ignoreInvalidMessageForTesting = decoder.decode<bool>();
#endif
#if HAVE(AUDIT_TOKEN)
    auto presentingApplicationAuditTokens = decoder.decode<HashMap<WebCore::PageIdentifier, WebKit::CoreIPCAuditToken>>();
#endif
#if PLATFORM(COCOA)
    auto applicationBundleIdentifier = decoder.decode<String>();
#endif
#if ENABLE(VP9)
    auto hasVP9HardwareDecoder = decoder.decode<std::optional<bool>>();
#endif
#if ENABLE(AV1)
    auto hasAV1HardwareDecoder = decoder.decode<std::optional<bool>>();
#endif
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebKit::GPUProcessConnectionParameters {
            WTFMove(*webProcessIdentity),
            WTFMove(*sharedPreferencesForWebProcess),
            WTFMove(*isLockdownModeEnabled),
#if ENABLE(IPC_TESTING_API)
            WTFMove(*ignoreInvalidMessageForTesting),
#endif
#if HAVE(AUDIT_TOKEN)
            WTFMove(*presentingApplicationAuditTokens),
#endif
#if PLATFORM(COCOA)
            WTFMove(*applicationBundleIdentifier),
#endif
#if ENABLE(VP9)
            WTFMove(*hasVP9HardwareDecoder),
#endif
#if ENABLE(AV1)
            WTFMove(*hasAV1HardwareDecoder)
#endif
        }
    };
}

#endif

void ArgumentCoder<WebKit::GoToBackForwardItemParameters>::encode(Encoder& encoder, WebKit::GoToBackForwardItemParameters&& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.navigationID)>, WebCore::NavigationIdentifier>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.frameState)>, Ref<WebKit::FrameState>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.backForwardType)>, WebCore::FrameLoadType>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.shouldTreatAsContinuingLoad)>, WebCore::ShouldTreatAsContinuingLoad>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.websitePolicies)>, std::optional<WebKit::WebsitePoliciesData>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.lastNavigationWasAppInitiated)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.existingNetworkResourceLoadIdentifierToResume)>, std::optional<WebKit::NetworkResourceLoadIdentifier>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.publicSuffix)>, WebCore::PublicSuffix>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.sandboxExtensionHandle)>, WebKit::SandboxExtensionHandle>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.processSwapDisposition)>, WebCore::ProcessSwapDisposition>);
    struct ShouldBeSameSizeAsGoToBackForwardItemParameters : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::GoToBackForwardItemParameters>, false> {
        WebCore::NavigationIdentifier navigationID;
        Ref<WebKit::FrameState> frameState;
        WebCore::FrameLoadType backForwardType;
        WebCore::ShouldTreatAsContinuingLoad shouldTreatAsContinuingLoad;
        std::optional<WebKit::WebsitePoliciesData> websitePolicies;
        bool lastNavigationWasAppInitiated;
        std::optional<WebKit::NetworkResourceLoadIdentifier> existingNetworkResourceLoadIdentifierToResume;
        WebCore::PublicSuffix publicSuffix;
        WebKit::SandboxExtensionHandle sandboxExtensionHandle;
        WebCore::ProcessSwapDisposition processSwapDisposition;
    };
    static_assert(sizeof(ShouldBeSameSizeAsGoToBackForwardItemParameters) == sizeof(WebKit::GoToBackForwardItemParameters));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::GoToBackForwardItemParameters, navigationID)
        , offsetof(WebKit::GoToBackForwardItemParameters, frameState)
        , offsetof(WebKit::GoToBackForwardItemParameters, backForwardType)
        , offsetof(WebKit::GoToBackForwardItemParameters, shouldTreatAsContinuingLoad)
        , offsetof(WebKit::GoToBackForwardItemParameters, websitePolicies)
        , offsetof(WebKit::GoToBackForwardItemParameters, lastNavigationWasAppInitiated)
        , offsetof(WebKit::GoToBackForwardItemParameters, existingNetworkResourceLoadIdentifierToResume)
        , offsetof(WebKit::GoToBackForwardItemParameters, publicSuffix)
        , offsetof(WebKit::GoToBackForwardItemParameters, sandboxExtensionHandle)
        , offsetof(WebKit::GoToBackForwardItemParameters, processSwapDisposition)
    >::value);

    encoder << WTFMove(instance.navigationID);
    encoder << WTFMove(instance.frameState);
    encoder << WTFMove(instance.backForwardType);
    encoder << WTFMove(instance.shouldTreatAsContinuingLoad);
    encoder << WTFMove(instance.websitePolicies);
    encoder << WTFMove(instance.lastNavigationWasAppInitiated);
    encoder << WTFMove(instance.existingNetworkResourceLoadIdentifierToResume);
    encoder << WTFMove(instance.publicSuffix);
    encoder << WTFMove(instance.sandboxExtensionHandle);
    encoder << WTFMove(instance.processSwapDisposition);
}

std::optional<WebKit::GoToBackForwardItemParameters> ArgumentCoder<WebKit::GoToBackForwardItemParameters>::decode(Decoder& decoder)
{
    auto navigationID = decoder.decode<WebCore::NavigationIdentifier>();
    auto frameState = decoder.decode<Ref<WebKit::FrameState>>();
    auto backForwardType = decoder.decode<WebCore::FrameLoadType>();
    auto shouldTreatAsContinuingLoad = decoder.decode<WebCore::ShouldTreatAsContinuingLoad>();
    auto websitePolicies = decoder.decode<std::optional<WebKit::WebsitePoliciesData>>();
    auto lastNavigationWasAppInitiated = decoder.decode<bool>();
    auto existingNetworkResourceLoadIdentifierToResume = decoder.decode<std::optional<WebKit::NetworkResourceLoadIdentifier>>();
    auto publicSuffix = decoder.decode<WebCore::PublicSuffix>();
    auto sandboxExtensionHandle = decoder.decode<WebKit::SandboxExtensionHandle>();
    auto processSwapDisposition = decoder.decode<WebCore::ProcessSwapDisposition>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebKit::GoToBackForwardItemParameters {
            WTFMove(*navigationID),
            WTFMove(*frameState),
            WTFMove(*backForwardType),
            WTFMove(*shouldTreatAsContinuingLoad),
            WTFMove(*websitePolicies),
            WTFMove(*lastNavigationWasAppInitiated),
            WTFMove(*existingNetworkResourceLoadIdentifierToResume),
            WTFMove(*publicSuffix),
            WTFMove(*sandboxExtensionHandle),
            WTFMove(*processSwapDisposition)
        }
    };
}

void ArgumentCoder<WebKit::NodeInfo>::encode(Encoder& encoder, const WebKit::NodeInfo& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.nodeIdentifier)>, WebCore::NodeIdentifier>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.contentFrameIdentifier)>, Markable<WebCore::FrameIdentifier>>);
    struct ShouldBeSameSizeAsNodeInfo : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::NodeInfo>, false> {
        WebCore::NodeIdentifier nodeIdentifier;
        Markable<WebCore::FrameIdentifier> contentFrameIdentifier;
    };
    static_assert(sizeof(ShouldBeSameSizeAsNodeInfo) == sizeof(WebKit::NodeInfo));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::NodeInfo, nodeIdentifier)
        , offsetof(WebKit::NodeInfo, contentFrameIdentifier)
    >::value);

    encoder << instance.nodeIdentifier;
    encoder << instance.contentFrameIdentifier;
}

std::optional<WebKit::NodeInfo> ArgumentCoder<WebKit::NodeInfo>::decode(Decoder& decoder)
{
    auto nodeIdentifier = decoder.decode<WebCore::NodeIdentifier>();
    auto contentFrameIdentifier = decoder.decode<Markable<WebCore::FrameIdentifier>>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebKit::NodeInfo {
            WTFMove(*nodeIdentifier),
            WTFMove(*contentFrameIdentifier)
        }
    };
}

void ArgumentCoder<WebKit::JavaScriptEvaluationResult>::encode(Encoder& encoder, const WebKit::JavaScriptEvaluationResult& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.root())>, WebKit::JSObjectID>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.map())>, HashMap<WebKit::JSObjectID, Variant<WebKit::JavaScriptEvaluationResult::EmptyType, bool, double, String, Seconds, Vector<WebKit::JSObjectID>, HashMap<WebKit::JSObjectID, WebKit::JSObjectID>, WebKit::NodeInfo, UniqueRef<WebCore::SerializedNode>>>>);

    encoder << instance.root();
    encoder << instance.map();
}

std::optional<WebKit::JavaScriptEvaluationResult> ArgumentCoder<WebKit::JavaScriptEvaluationResult>::decode(Decoder& decoder)
{
    auto root = decoder.decode<WebKit::JSObjectID>();
    auto map = decoder.decode<HashMap<WebKit::JSObjectID, Variant<WebKit::JavaScriptEvaluationResult::EmptyType, bool, double, String, Seconds, Vector<WebKit::JSObjectID>, HashMap<WebKit::JSObjectID, WebKit::JSObjectID>, WebKit::NodeInfo, UniqueRef<WebCore::SerializedNode>>>>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebKit::JavaScriptEvaluationResult {
            WTFMove(*root),
            WTFMove(*map)
        }
    };
}

void ArgumentCoder<WebKit::LayerTreeContext>::encode(Encoder& encoder, const WebKit::LayerTreeContext& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.contextID)>, uint64_t>);
    struct ShouldBeSameSizeAsLayerTreeContext : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::LayerTreeContext>, false> {
        uint64_t contextID;
    };
    static_assert(sizeof(ShouldBeSameSizeAsLayerTreeContext) == sizeof(WebKit::LayerTreeContext));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::LayerTreeContext, contextID)
    >::value);

    encoder << instance.contextID;
}

std::optional<WebKit::LayerTreeContext> ArgumentCoder<WebKit::LayerTreeContext>::decode(Decoder& decoder)
{
    auto contextID = decoder.decode<uint64_t>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebKit::LayerTreeContext {
            WTFMove(*contextID)
        }
    };
}

void ArgumentCoder<WebKit::LoadParameters>::encode(Encoder& encoder, WebKit::LoadParameters&& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.publicSuffix)>, WebCore::PublicSuffix>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.navigationID)>, std::optional<WebCore::NavigationIdentifier>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.frameIdentifier)>, std::optional<WebCore::FrameIdentifier>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.request)>, WebCore::ResourceRequest>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.sandboxExtensionHandle)>, WebKit::SandboxExtensionHandle>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.data)>, RefPtr<WebCore::SharedBuffer>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.MIMEType)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.encodingName)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.baseURLString)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.unreachableURLString)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.provisionalLoadErrorURLString)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.websitePolicies)>, std::optional<WebKit::WebsitePoliciesData>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.originatingFrame)>, std::optional<WebKit::FrameInfoData>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.shouldOpenExternalURLsPolicy)>, WebCore::ShouldOpenExternalURLsPolicy>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.shouldTreatAsContinuingLoad)>, WebCore::ShouldTreatAsContinuingLoad>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.userData)>, WebKit::UserData>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.lockHistory)>, WebCore::LockHistory>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.lockBackForwardList)>, WebCore::LockBackForwardList>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.sessionHistoryVisibility)>, WebCore::SubstituteData::SessionHistoryVisibility>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.clientRedirectSourceForHistory)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.effectiveSandboxFlags)>, WebCore::SandboxFlags>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.ownerPermissionsPolicy)>, std::optional<WebCore::OwnerPermissionsPolicyData>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isNavigatingToAppBoundDomain)>, std::optional<WebKit::NavigatingToAppBoundDomain>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.existingNetworkResourceLoadIdentifierToResume)>, std::optional<WebKit::NetworkResourceLoadIdentifier>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isServiceWorkerLoad)>, bool>);
#if PLATFORM(COCOA)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.dataDetectionReferenceDate)>, std::optional<double>>);
#endif
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isRequestFromClientOrUserInput)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isPerformingHTTPFallback)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isHandledByAboutSchemeHandler)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.advancedPrivacyProtections)>, std::optional<OptionSet<WebCore::AdvancedPrivacyProtections>>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.requiredCookiesVersion)>, uint64_t>);
    struct ShouldBeSameSizeAsLoadParameters : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::LoadParameters>, false> {
        WebCore::PublicSuffix publicSuffix;
        std::optional<WebCore::NavigationIdentifier> navigationID;
        std::optional<WebCore::FrameIdentifier> frameIdentifier;
        WebCore::ResourceRequest request;
        WebKit::SandboxExtensionHandle sandboxExtensionHandle;
        RefPtr<WebCore::SharedBuffer> data;
        String MIMEType;
        String encodingName;
        String baseURLString;
        String unreachableURLString;
        String provisionalLoadErrorURLString;
        std::optional<WebKit::WebsitePoliciesData> websitePolicies;
        std::optional<WebKit::FrameInfoData> originatingFrame;
        WebCore::ShouldOpenExternalURLsPolicy shouldOpenExternalURLsPolicy;
        WebCore::ShouldTreatAsContinuingLoad shouldTreatAsContinuingLoad;
        WebKit::UserData userData;
        WebCore::LockHistory lockHistory;
        WebCore::LockBackForwardList lockBackForwardList;
        WebCore::SubstituteData::SessionHistoryVisibility sessionHistoryVisibility;
        String clientRedirectSourceForHistory;
        WebCore::SandboxFlags effectiveSandboxFlags;
        std::optional<WebCore::OwnerPermissionsPolicyData> ownerPermissionsPolicy;
        std::optional<WebKit::NavigatingToAppBoundDomain> isNavigatingToAppBoundDomain;
        std::optional<WebKit::NetworkResourceLoadIdentifier> existingNetworkResourceLoadIdentifierToResume;
        bool isServiceWorkerLoad;
#if PLATFORM(COCOA)
        std::optional<double> dataDetectionReferenceDate;
#endif
        bool isRequestFromClientOrUserInput;
        bool isPerformingHTTPFallback;
        bool isHandledByAboutSchemeHandler;
        std::optional<OptionSet<WebCore::AdvancedPrivacyProtections>> advancedPrivacyProtections;
        uint64_t requiredCookiesVersion;
    };
    static_assert(sizeof(ShouldBeSameSizeAsLoadParameters) == sizeof(WebKit::LoadParameters));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::LoadParameters, publicSuffix)
        , offsetof(WebKit::LoadParameters, navigationID)
        , offsetof(WebKit::LoadParameters, frameIdentifier)
        , offsetof(WebKit::LoadParameters, request)
        , offsetof(WebKit::LoadParameters, sandboxExtensionHandle)
        , offsetof(WebKit::LoadParameters, data)
        , offsetof(WebKit::LoadParameters, MIMEType)
        , offsetof(WebKit::LoadParameters, encodingName)
        , offsetof(WebKit::LoadParameters, baseURLString)
        , offsetof(WebKit::LoadParameters, unreachableURLString)
        , offsetof(WebKit::LoadParameters, provisionalLoadErrorURLString)
        , offsetof(WebKit::LoadParameters, websitePolicies)
        , offsetof(WebKit::LoadParameters, originatingFrame)
        , offsetof(WebKit::LoadParameters, shouldOpenExternalURLsPolicy)
        , offsetof(WebKit::LoadParameters, shouldTreatAsContinuingLoad)
        , offsetof(WebKit::LoadParameters, userData)
        , offsetof(WebKit::LoadParameters, lockHistory)
        , offsetof(WebKit::LoadParameters, lockBackForwardList)
        , offsetof(WebKit::LoadParameters, sessionHistoryVisibility)
        , offsetof(WebKit::LoadParameters, clientRedirectSourceForHistory)
        , offsetof(WebKit::LoadParameters, effectiveSandboxFlags)
        , offsetof(WebKit::LoadParameters, ownerPermissionsPolicy)
        , offsetof(WebKit::LoadParameters, isNavigatingToAppBoundDomain)
        , offsetof(WebKit::LoadParameters, existingNetworkResourceLoadIdentifierToResume)
        , offsetof(WebKit::LoadParameters, isServiceWorkerLoad)
#if PLATFORM(COCOA)
        , offsetof(WebKit::LoadParameters, dataDetectionReferenceDate)
#endif
        , offsetof(WebKit::LoadParameters, isRequestFromClientOrUserInput)
        , offsetof(WebKit::LoadParameters, isPerformingHTTPFallback)
        , offsetof(WebKit::LoadParameters, isHandledByAboutSchemeHandler)
        , offsetof(WebKit::LoadParameters, advancedPrivacyProtections)
        , offsetof(WebKit::LoadParameters, requiredCookiesVersion)
    >::value);

    encoder << WTFMove(instance.publicSuffix);
    encoder << WTFMove(instance.navigationID);
    encoder << WTFMove(instance.frameIdentifier);
    RefPtr requestBody = instance.request.httpBody();
    encoder << WTFMove(instance.request);
    encoder << IPC::FormDataReference { WTFMove(requestBody) };
    encoder << WTFMove(instance.sandboxExtensionHandle);
    encoder << WTFMove(instance.data);
    encoder << WTFMove(instance.MIMEType);
    encoder << WTFMove(instance.encodingName);
    encoder << WTFMove(instance.baseURLString);
    encoder << WTFMove(instance.unreachableURLString);
    encoder << WTFMove(instance.provisionalLoadErrorURLString);
    encoder << WTFMove(instance.websitePolicies);
    encoder << WTFMove(instance.originatingFrame);
    encoder << WTFMove(instance.shouldOpenExternalURLsPolicy);
    encoder << WTFMove(instance.shouldTreatAsContinuingLoad);
    encoder << WTFMove(instance.userData);
    encoder << WTFMove(instance.lockHistory);
    encoder << WTFMove(instance.lockBackForwardList);
    encoder << WTFMove(instance.sessionHistoryVisibility);
    encoder << WTFMove(instance.clientRedirectSourceForHistory);
    encoder << WTFMove(instance.effectiveSandboxFlags);
    encoder << WTFMove(instance.ownerPermissionsPolicy);
    encoder << WTFMove(instance.isNavigatingToAppBoundDomain);
    encoder << WTFMove(instance.existingNetworkResourceLoadIdentifierToResume);
    encoder << WTFMove(instance.isServiceWorkerLoad);
#if PLATFORM(COCOA)
    encoder << WTFMove(instance.dataDetectionReferenceDate);
#endif
    encoder << WTFMove(instance.isRequestFromClientOrUserInput);
    encoder << WTFMove(instance.isPerformingHTTPFallback);
    encoder << WTFMove(instance.isHandledByAboutSchemeHandler);
    encoder << WTFMove(instance.advancedPrivacyProtections);
    encoder << WTFMove(instance.requiredCookiesVersion);
}

std::optional<WebKit::LoadParameters> ArgumentCoder<WebKit::LoadParameters>::decode(Decoder& decoder)
{
    auto publicSuffix = decoder.decode<WebCore::PublicSuffix>();
    auto navigationID = decoder.decode<std::optional<WebCore::NavigationIdentifier>>();
    auto frameIdentifier = decoder.decode<std::optional<WebCore::FrameIdentifier>>();
    auto request = decoder.decode<WebCore::ResourceRequest>();
    if (request) {
        if (auto requestBody = decoder.decode<IPC::FormDataReference>())
            request->setHTTPBody(requestBody->takeData());
    }
    auto sandboxExtensionHandle = decoder.decode<WebKit::SandboxExtensionHandle>();
    auto data = decoder.decode<RefPtr<WebCore::SharedBuffer>>();
    auto MIMEType = decoder.decode<String>();
    auto encodingName = decoder.decode<String>();
    auto baseURLString = decoder.decode<String>();
    auto unreachableURLString = decoder.decode<String>();
    auto provisionalLoadErrorURLString = decoder.decode<String>();
    auto websitePolicies = decoder.decode<std::optional<WebKit::WebsitePoliciesData>>();
    auto originatingFrame = decoder.decode<std::optional<WebKit::FrameInfoData>>();
    auto shouldOpenExternalURLsPolicy = decoder.decode<WebCore::ShouldOpenExternalURLsPolicy>();
    auto shouldTreatAsContinuingLoad = decoder.decode<WebCore::ShouldTreatAsContinuingLoad>();
    auto userData = decoder.decode<WebKit::UserData>();
    auto lockHistory = decoder.decode<WebCore::LockHistory>();
    auto lockBackForwardList = decoder.decode<WebCore::LockBackForwardList>();
    auto sessionHistoryVisibility = decoder.decode<WebCore::SubstituteData::SessionHistoryVisibility>();
    auto clientRedirectSourceForHistory = decoder.decode<String>();
    auto effectiveSandboxFlags = decoder.decode<WebCore::SandboxFlags>();
    auto ownerPermissionsPolicy = decoder.decode<std::optional<WebCore::OwnerPermissionsPolicyData>>();
    auto isNavigatingToAppBoundDomain = decoder.decode<std::optional<WebKit::NavigatingToAppBoundDomain>>();
    auto existingNetworkResourceLoadIdentifierToResume = decoder.decode<std::optional<WebKit::NetworkResourceLoadIdentifier>>();
    auto isServiceWorkerLoad = decoder.decode<bool>();
#if PLATFORM(COCOA)
    auto dataDetectionReferenceDate = decoder.decode<std::optional<double>>();
#endif
    auto isRequestFromClientOrUserInput = decoder.decode<bool>();
    auto isPerformingHTTPFallback = decoder.decode<bool>();
    auto isHandledByAboutSchemeHandler = decoder.decode<bool>();
    auto advancedPrivacyProtections = decoder.decode<std::optional<OptionSet<WebCore::AdvancedPrivacyProtections>>>();
    auto requiredCookiesVersion = decoder.decode<uint64_t>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebKit::LoadParameters {
            WTFMove(*publicSuffix),
            WTFMove(*navigationID),
            WTFMove(*frameIdentifier),
            WTFMove(*request),
            WTFMove(*sandboxExtensionHandle),
            WTFMove(*data),
            WTFMove(*MIMEType),
            WTFMove(*encodingName),
            WTFMove(*baseURLString),
            WTFMove(*unreachableURLString),
            WTFMove(*provisionalLoadErrorURLString),
            WTFMove(*websitePolicies),
            WTFMove(*originatingFrame),
            WTFMove(*shouldOpenExternalURLsPolicy),
            WTFMove(*shouldTreatAsContinuingLoad),
            WTFMove(*userData),
            WTFMove(*lockHistory),
            WTFMove(*lockBackForwardList),
            WTFMove(*sessionHistoryVisibility),
            WTFMove(*clientRedirectSourceForHistory),
            WTFMove(*effectiveSandboxFlags),
            WTFMove(*ownerPermissionsPolicy),
            WTFMove(*isNavigatingToAppBoundDomain),
            WTFMove(*existingNetworkResourceLoadIdentifierToResume),
            WTFMove(*isServiceWorkerLoad),
#if PLATFORM(COCOA)
            WTFMove(*dataDetectionReferenceDate),
#endif
            WTFMove(*isRequestFromClientOrUserInput),
            WTFMove(*isPerformingHTTPFallback),
            WTFMove(*isHandledByAboutSchemeHandler),
            WTFMove(*advancedPrivacyProtections),
            WTFMove(*requiredCookiesVersion)
        }
    };
}

#if ENABLE(ARKIT_INLINE_PREVIEW)
void ArgumentCoder<WebKit::ModelIdentifier>::encode(Encoder& encoder, const WebKit::ModelIdentifier& instance)
{
#if ENABLE(ARKIT_INLINE_PREVIEW_MAC)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.uuid)>, String>);
#endif
#if ENABLE(ARKIT_INLINE_PREVIEW_IOS)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.layerIdentifier)>, WebCore::PlatformLayerIdentifier>);
#endif
    struct ShouldBeSameSizeAsModelIdentifier : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::ModelIdentifier>, false> {
#if ENABLE(ARKIT_INLINE_PREVIEW_MAC)
        String uuid;
#endif
#if ENABLE(ARKIT_INLINE_PREVIEW_IOS)
        WebCore::PlatformLayerIdentifier layerIdentifier;
#endif
    };
    static_assert(sizeof(ShouldBeSameSizeAsModelIdentifier) == sizeof(WebKit::ModelIdentifier));
    static_assert(MembersInCorrectOrder < 0
#if ENABLE(ARKIT_INLINE_PREVIEW_MAC)
        , offsetof(WebKit::ModelIdentifier, uuid)
#endif
#if ENABLE(ARKIT_INLINE_PREVIEW_IOS)
        , offsetof(WebKit::ModelIdentifier, layerIdentifier)
#endif
    >::value);

#if ENABLE(ARKIT_INLINE_PREVIEW_MAC)
    encoder << instance.uuid;
#endif
#if ENABLE(ARKIT_INLINE_PREVIEW_IOS)
    encoder << instance.layerIdentifier;
#endif
}

std::optional<WebKit::ModelIdentifier> ArgumentCoder<WebKit::ModelIdentifier>::decode(Decoder& decoder)
{
#if ENABLE(ARKIT_INLINE_PREVIEW_MAC)
    auto uuid = decoder.decode<String>();
#endif
#if ENABLE(ARKIT_INLINE_PREVIEW_IOS)
    auto layerIdentifier = decoder.decode<WebCore::PlatformLayerIdentifier>();
#endif
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebKit::ModelIdentifier {
#if ENABLE(ARKIT_INLINE_PREVIEW_MAC)
            WTFMove(*uuid),
#endif
#if ENABLE(ARKIT_INLINE_PREVIEW_IOS)
            WTFMove(*layerIdentifier)
#endif
        }
    };
}

#endif

#if ENABLE(MODEL_PROCESS)
void ArgumentCoder<WebKit::ModelProcessConnectionParameters>::encode(Encoder& encoder, WebKit::ModelProcessConnectionParameters&& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.webProcessIdentity)>, WebCore::ProcessIdentity>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.sharedPreferencesForWebProcess)>, WebKit::SharedPreferencesForWebProcess>);
#if ENABLE(IPC_TESTING_API)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.ignoreInvalidMessageForTesting)>, bool>);
#endif
#if HAVE(AUDIT_TOKEN)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.presentingApplicationAuditToken)>, std::optional<WebKit::CoreIPCAuditToken>>);
#endif
    struct ShouldBeSameSizeAsModelProcessConnectionParameters : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::ModelProcessConnectionParameters>, false> {
        WebCore::ProcessIdentity webProcessIdentity;
        WebKit::SharedPreferencesForWebProcess sharedPreferencesForWebProcess;
#if ENABLE(IPC_TESTING_API)
        bool ignoreInvalidMessageForTesting;
#endif
#if HAVE(AUDIT_TOKEN)
        std::optional<WebKit::CoreIPCAuditToken> presentingApplicationAuditToken;
#endif
    };
    static_assert(sizeof(ShouldBeSameSizeAsModelProcessConnectionParameters) == sizeof(WebKit::ModelProcessConnectionParameters));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::ModelProcessConnectionParameters, webProcessIdentity)
        , offsetof(WebKit::ModelProcessConnectionParameters, sharedPreferencesForWebProcess)
#if ENABLE(IPC_TESTING_API)
        , offsetof(WebKit::ModelProcessConnectionParameters, ignoreInvalidMessageForTesting)
#endif
#if HAVE(AUDIT_TOKEN)
        , offsetof(WebKit::ModelProcessConnectionParameters, presentingApplicationAuditToken)
#endif
    >::value);

    encoder << WTFMove(instance.webProcessIdentity);
    encoder << WTFMove(instance.sharedPreferencesForWebProcess);
#if ENABLE(IPC_TESTING_API)
    encoder << WTFMove(instance.ignoreInvalidMessageForTesting);
#endif
#if HAVE(AUDIT_TOKEN)
    encoder << WTFMove(instance.presentingApplicationAuditToken);
#endif
}

std::optional<WebKit::ModelProcessConnectionParameters> ArgumentCoder<WebKit::ModelProcessConnectionParameters>::decode(Decoder& decoder)
{
    auto webProcessIdentity = decoder.decode<WebCore::ProcessIdentity>();
    auto sharedPreferencesForWebProcess = decoder.decode<WebKit::SharedPreferencesForWebProcess>();
#if ENABLE(IPC_TESTING_API)
    auto ignoreInvalidMessageForTesting = decoder.decode<bool>();
#endif
#if HAVE(AUDIT_TOKEN)
    auto presentingApplicationAuditToken = decoder.decode<std::optional<WebKit::CoreIPCAuditToken>>();
#endif
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebKit::ModelProcessConnectionParameters {
            WTFMove(*webProcessIdentity),
            WTFMove(*sharedPreferencesForWebProcess),
#if ENABLE(IPC_TESTING_API)
            WTFMove(*ignoreInvalidMessageForTesting),
#endif
#if HAVE(AUDIT_TOKEN)
            WTFMove(*presentingApplicationAuditToken)
#endif
        }
    };
}

#endif

void ArgumentCoder<WebKit::EditorStateIdentifier>::encode(Encoder& encoder, const WebKit::EditorStateIdentifier& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.toUInt64())>, uint64_t>);

    encoder << instance.toUInt64();
}

void ArgumentCoder<WebKit::EditorStateIdentifier>::encode(StreamConnectionEncoder& encoder, const WebKit::EditorStateIdentifier& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.toUInt64())>, uint64_t>);

    encoder << instance.toUInt64();
}

std::optional<WebKit::EditorStateIdentifier> ArgumentCoder<WebKit::EditorStateIdentifier>::decode(Decoder& decoder)
{
    auto toUInt64 = decoder.decode<uint64_t>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;

    if (!(WebKit::MonotonicObjectIdentifier<WebKit::EditorStateIdentifierType>::isValidIdentifier(*toUInt64)))
        return std::nullopt;
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebKit::EditorStateIdentifier {
            WTFMove(*toUInt64)
        }
    };
}

void ArgumentCoder<WebKit::RenderingUpdateID>::encode(Encoder& encoder, const WebKit::RenderingUpdateID& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.toUInt64())>, uint64_t>);

    encoder << instance.toUInt64();
}

void ArgumentCoder<WebKit::RenderingUpdateID>::encode(StreamConnectionEncoder& encoder, const WebKit::RenderingUpdateID& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.toUInt64())>, uint64_t>);

    encoder << instance.toUInt64();
}

std::optional<WebKit::RenderingUpdateID> ArgumentCoder<WebKit::RenderingUpdateID>::decode(Decoder& decoder)
{
    auto toUInt64 = decoder.decode<uint64_t>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;

    if (!(WebKit::MonotonicObjectIdentifier<WebKit::RenderingUpdateIDType>::isValidIdentifier(*toUInt64)))
        return std::nullopt;
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebKit::RenderingUpdateID {
            WTFMove(*toUInt64)
        }
    };
}

void ArgumentCoder<WebKit::TransactionIdentifier>::encode(Encoder& encoder, const WebKit::TransactionIdentifier& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.toUInt64())>, uint64_t>);

    encoder << instance.toUInt64();
}

void ArgumentCoder<WebKit::TransactionIdentifier>::encode(StreamConnectionEncoder& encoder, const WebKit::TransactionIdentifier& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.toUInt64())>, uint64_t>);

    encoder << instance.toUInt64();
}

std::optional<WebKit::TransactionIdentifier> ArgumentCoder<WebKit::TransactionIdentifier>::decode(Decoder& decoder)
{
    auto toUInt64 = decoder.decode<uint64_t>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;

    if (!(WebKit::MonotonicObjectIdentifier<WebKit::TransactionIDType>::isValidIdentifier(*toUInt64)))
        return std::nullopt;
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebKit::TransactionIdentifier {
            WTFMove(*toUInt64)
        }
    };
}

void ArgumentCoder<WebKit::FocusedElementInformationIdentifier>::encode(Encoder& encoder, const WebKit::FocusedElementInformationIdentifier& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.toUInt64())>, uint64_t>);

    encoder << instance.toUInt64();
}

void ArgumentCoder<WebKit::FocusedElementInformationIdentifier>::encode(StreamConnectionEncoder& encoder, const WebKit::FocusedElementInformationIdentifier& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.toUInt64())>, uint64_t>);

    encoder << instance.toUInt64();
}

std::optional<WebKit::FocusedElementInformationIdentifier> ArgumentCoder<WebKit::FocusedElementInformationIdentifier>::decode(Decoder& decoder)
{
    auto toUInt64 = decoder.decode<uint64_t>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;

    if (!(WebKit::MonotonicObjectIdentifier<WebKit::FocusedElementInformationIdentifierType>::isValidIdentifier(*toUInt64)))
        return std::nullopt;
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebKit::FocusedElementInformationIdentifier {
            WTFMove(*toUInt64)
        }
    };
}

void ArgumentCoder<WebKit::NavigationActionData>::encode(Encoder& encoder, const WebKit::NavigationActionData& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.navigationType)>, WebCore::NavigationType>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.modifiers)>, OptionSet<WebKit::WebEventModifier>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.mouseButton)>, WebKit::WebMouseEventButton>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.syntheticClickType)>, WebKit::WebMouseEventSyntheticClickType>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.userGestureTokenIdentifier)>, std::optional<WebCore::UserGestureTokenIdentifier>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.userGestureAuthorizationToken)>, std::optional<WTF::UUID>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.canHandleRequest)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.shouldOpenExternalURLsPolicy)>, WebCore::ShouldOpenExternalURLsPolicy>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.downloadAttribute)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.clickLocationInRootViewCoordinates)>, WebCore::FloatPoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.redirectResponse)>, WebCore::ResourceResponse>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isRequestFromClientOrUserInput)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.treatAsSameOriginNavigation)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.hasOpenedFrames)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.openedByDOMWithOpener)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.hasOpener)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isPerformingHTTPFallback)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isInitialFrameSrcLoad)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isContentRuleListRedirect)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.openedMainFrameName)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.requesterOrigin)>, WebCore::SecurityOriginData>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.requesterTopOrigin)>, WebCore::SecurityOriginData>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.targetBackForwardItemIdentifier)>, std::optional<WebCore::BackForwardItemIdentifier>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.sourceBackForwardItemIdentifier)>, std::optional<WebCore::BackForwardItemIdentifier>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.lockHistory)>, WebCore::LockHistory>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.lockBackForwardList)>, WebCore::LockBackForwardList>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.clientRedirectSourceForHistory)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.effectiveSandboxFlags)>, WebCore::SandboxFlags>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.ownerPermissionsPolicy)>, std::optional<WebCore::OwnerPermissionsPolicyData>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.privateClickMeasurement)>, std::optional<WebCore::PrivateClickMeasurement>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.advancedPrivacyProtections)>, OptionSet<WebCore::AdvancedPrivacyProtections>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.originatorAdvancedPrivacyProtections)>, std::optional<OptionSet<WebCore::AdvancedPrivacyProtections>>>);
#if PLATFORM(MAC) || HAVE(UIKIT_WITH_MOUSE_SUPPORT)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.webHitTestResultData)>, std::optional<WebKit::WebHitTestResultData>>);
#endif
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.originatingFrameInfoData)>, WebKit::FrameInfoData>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.originatingPageID)>, std::optional<WebKit::WebPageProxyIdentifier>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.frameInfo)>, WebKit::FrameInfoData>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.navigationID)>, std::optional<WebCore::NavigationIdentifier>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.originalRequest)>, WebCore::ResourceRequest>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.request)>, WebCore::ResourceRequest>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.invalidURLString)>, String>);
    struct ShouldBeSameSizeAsNavigationActionData : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::NavigationActionData>, false> {
        WebCore::NavigationType navigationType;
        OptionSet<WebKit::WebEventModifier> modifiers;
        WebKit::WebMouseEventButton mouseButton;
        WebKit::WebMouseEventSyntheticClickType syntheticClickType;
        std::optional<WebCore::UserGestureTokenIdentifier> userGestureTokenIdentifier;
        std::optional<WTF::UUID> userGestureAuthorizationToken;
        bool canHandleRequest;
        WebCore::ShouldOpenExternalURLsPolicy shouldOpenExternalURLsPolicy;
        String downloadAttribute;
        WebCore::FloatPoint clickLocationInRootViewCoordinates;
        WebCore::ResourceResponse redirectResponse;
        bool isRequestFromClientOrUserInput;
        bool treatAsSameOriginNavigation;
        bool hasOpenedFrames;
        bool openedByDOMWithOpener;
        bool hasOpener;
        bool isPerformingHTTPFallback;
        bool isInitialFrameSrcLoad;
        bool isContentRuleListRedirect;
        String openedMainFrameName;
        WebCore::SecurityOriginData requesterOrigin;
        WebCore::SecurityOriginData requesterTopOrigin;
        std::optional<WebCore::BackForwardItemIdentifier> targetBackForwardItemIdentifier;
        std::optional<WebCore::BackForwardItemIdentifier> sourceBackForwardItemIdentifier;
        WebCore::LockHistory lockHistory;
        WebCore::LockBackForwardList lockBackForwardList;
        String clientRedirectSourceForHistory;
        WebCore::SandboxFlags effectiveSandboxFlags;
        std::optional<WebCore::OwnerPermissionsPolicyData> ownerPermissionsPolicy;
        std::optional<WebCore::PrivateClickMeasurement> privateClickMeasurement;
        OptionSet<WebCore::AdvancedPrivacyProtections> advancedPrivacyProtections;
        std::optional<OptionSet<WebCore::AdvancedPrivacyProtections>> originatorAdvancedPrivacyProtections;
#if PLATFORM(MAC) || HAVE(UIKIT_WITH_MOUSE_SUPPORT)
        std::optional<WebKit::WebHitTestResultData> webHitTestResultData;
#endif
        WebKit::FrameInfoData originatingFrameInfoData;
        std::optional<WebKit::WebPageProxyIdentifier> originatingPageID;
        WebKit::FrameInfoData frameInfo;
        std::optional<WebCore::NavigationIdentifier> navigationID;
        WebCore::ResourceRequest originalRequest;
        WebCore::ResourceRequest request;
        String invalidURLString;
    };
    static_assert(sizeof(ShouldBeSameSizeAsNavigationActionData) == sizeof(WebKit::NavigationActionData));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::NavigationActionData, navigationType)
        , offsetof(WebKit::NavigationActionData, modifiers)
        , offsetof(WebKit::NavigationActionData, mouseButton)
        , offsetof(WebKit::NavigationActionData, syntheticClickType)
        , offsetof(WebKit::NavigationActionData, userGestureTokenIdentifier)
        , offsetof(WebKit::NavigationActionData, userGestureAuthorizationToken)
        , offsetof(WebKit::NavigationActionData, canHandleRequest)
        , offsetof(WebKit::NavigationActionData, shouldOpenExternalURLsPolicy)
        , offsetof(WebKit::NavigationActionData, downloadAttribute)
        , offsetof(WebKit::NavigationActionData, clickLocationInRootViewCoordinates)
        , offsetof(WebKit::NavigationActionData, redirectResponse)
        , offsetof(WebKit::NavigationActionData, isRequestFromClientOrUserInput)
        , offsetof(WebKit::NavigationActionData, treatAsSameOriginNavigation)
        , offsetof(WebKit::NavigationActionData, hasOpenedFrames)
        , offsetof(WebKit::NavigationActionData, openedByDOMWithOpener)
        , offsetof(WebKit::NavigationActionData, hasOpener)
        , offsetof(WebKit::NavigationActionData, isPerformingHTTPFallback)
        , offsetof(WebKit::NavigationActionData, isInitialFrameSrcLoad)
        , offsetof(WebKit::NavigationActionData, isContentRuleListRedirect)
        , offsetof(WebKit::NavigationActionData, openedMainFrameName)
        , offsetof(WebKit::NavigationActionData, requesterOrigin)
        , offsetof(WebKit::NavigationActionData, requesterTopOrigin)
        , offsetof(WebKit::NavigationActionData, targetBackForwardItemIdentifier)
        , offsetof(WebKit::NavigationActionData, sourceBackForwardItemIdentifier)
        , offsetof(WebKit::NavigationActionData, lockHistory)
        , offsetof(WebKit::NavigationActionData, lockBackForwardList)
        , offsetof(WebKit::NavigationActionData, clientRedirectSourceForHistory)
        , offsetof(WebKit::NavigationActionData, effectiveSandboxFlags)
        , offsetof(WebKit::NavigationActionData, ownerPermissionsPolicy)
        , offsetof(WebKit::NavigationActionData, privateClickMeasurement)
        , offsetof(WebKit::NavigationActionData, advancedPrivacyProtections)
        , offsetof(WebKit::NavigationActionData, originatorAdvancedPrivacyProtections)
#if PLATFORM(MAC) || HAVE(UIKIT_WITH_MOUSE_SUPPORT)
        , offsetof(WebKit::NavigationActionData, webHitTestResultData)
#endif
        , offsetof(WebKit::NavigationActionData, originatingFrameInfoData)
        , offsetof(WebKit::NavigationActionData, originatingPageID)
        , offsetof(WebKit::NavigationActionData, frameInfo)
        , offsetof(WebKit::NavigationActionData, navigationID)
        , offsetof(WebKit::NavigationActionData, originalRequest)
        , offsetof(WebKit::NavigationActionData, request)
        , offsetof(WebKit::NavigationActionData, invalidURLString)
    >::value);

    encoder << instance.navigationType;
    encoder << instance.modifiers;
    encoder << instance.mouseButton;
    encoder << instance.syntheticClickType;
    encoder << instance.userGestureTokenIdentifier;
    encoder << instance.userGestureAuthorizationToken;
    encoder << instance.canHandleRequest;
    encoder << instance.shouldOpenExternalURLsPolicy;
    encoder << instance.downloadAttribute;
    encoder << instance.clickLocationInRootViewCoordinates;
    encoder << instance.redirectResponse;
    encoder << instance.isRequestFromClientOrUserInput;
    encoder << instance.treatAsSameOriginNavigation;
    encoder << instance.hasOpenedFrames;
    encoder << instance.openedByDOMWithOpener;
    encoder << instance.hasOpener;
    encoder << instance.isPerformingHTTPFallback;
    encoder << instance.isInitialFrameSrcLoad;
    encoder << instance.isContentRuleListRedirect;
    encoder << instance.openedMainFrameName;
    encoder << instance.requesterOrigin;
    encoder << instance.requesterTopOrigin;
    encoder << instance.targetBackForwardItemIdentifier;
    encoder << instance.sourceBackForwardItemIdentifier;
    encoder << instance.lockHistory;
    encoder << instance.lockBackForwardList;
    encoder << instance.clientRedirectSourceForHistory;
    encoder << instance.effectiveSandboxFlags;
    encoder << instance.ownerPermissionsPolicy;
    encoder << instance.privateClickMeasurement;
    encoder << instance.advancedPrivacyProtections;
    encoder << instance.originatorAdvancedPrivacyProtections;
#if PLATFORM(MAC) || HAVE(UIKIT_WITH_MOUSE_SUPPORT)
    encoder << instance.webHitTestResultData;
#endif
    encoder << instance.originatingFrameInfoData;
    encoder << instance.originatingPageID;
    encoder << instance.frameInfo;
    encoder << instance.navigationID;
    encoder << instance.originalRequest;
    encoder << instance.request;
    encoder << IPC::FormDataReference { instance.request.httpBody() };
    encoder << instance.invalidURLString;
}

std::optional<WebKit::NavigationActionData> ArgumentCoder<WebKit::NavigationActionData>::decode(Decoder& decoder)
{
    auto navigationType = decoder.decode<WebCore::NavigationType>();
    auto modifiers = decoder.decode<OptionSet<WebKit::WebEventModifier>>();
    auto mouseButton = decoder.decode<WebKit::WebMouseEventButton>();
    auto syntheticClickType = decoder.decode<WebKit::WebMouseEventSyntheticClickType>();
    auto userGestureTokenIdentifier = decoder.decode<std::optional<WebCore::UserGestureTokenIdentifier>>();
    auto userGestureAuthorizationToken = decoder.decode<std::optional<WTF::UUID>>();
    auto canHandleRequest = decoder.decode<bool>();
    auto shouldOpenExternalURLsPolicy = decoder.decode<WebCore::ShouldOpenExternalURLsPolicy>();
    auto downloadAttribute = decoder.decode<String>();
    auto clickLocationInRootViewCoordinates = decoder.decode<WebCore::FloatPoint>();
    auto redirectResponse = decoder.decode<WebCore::ResourceResponse>();
    auto isRequestFromClientOrUserInput = decoder.decode<bool>();
    auto treatAsSameOriginNavigation = decoder.decode<bool>();
    auto hasOpenedFrames = decoder.decode<bool>();
    auto openedByDOMWithOpener = decoder.decode<bool>();
    auto hasOpener = decoder.decode<bool>();
    auto isPerformingHTTPFallback = decoder.decode<bool>();
    auto isInitialFrameSrcLoad = decoder.decode<bool>();
    auto isContentRuleListRedirect = decoder.decode<bool>();
    auto openedMainFrameName = decoder.decode<String>();
    auto requesterOrigin = decoder.decode<WebCore::SecurityOriginData>();
    auto requesterTopOrigin = decoder.decode<WebCore::SecurityOriginData>();
    auto targetBackForwardItemIdentifier = decoder.decode<std::optional<WebCore::BackForwardItemIdentifier>>();
    auto sourceBackForwardItemIdentifier = decoder.decode<std::optional<WebCore::BackForwardItemIdentifier>>();
    auto lockHistory = decoder.decode<WebCore::LockHistory>();
    auto lockBackForwardList = decoder.decode<WebCore::LockBackForwardList>();
    auto clientRedirectSourceForHistory = decoder.decode<String>();
    auto effectiveSandboxFlags = decoder.decode<WebCore::SandboxFlags>();
    auto ownerPermissionsPolicy = decoder.decode<std::optional<WebCore::OwnerPermissionsPolicyData>>();
    auto privateClickMeasurement = decoder.decode<std::optional<WebCore::PrivateClickMeasurement>>();
    auto advancedPrivacyProtections = decoder.decode<OptionSet<WebCore::AdvancedPrivacyProtections>>();
    auto originatorAdvancedPrivacyProtections = decoder.decode<std::optional<OptionSet<WebCore::AdvancedPrivacyProtections>>>();
#if PLATFORM(MAC) || HAVE(UIKIT_WITH_MOUSE_SUPPORT)
    auto webHitTestResultData = decoder.decode<std::optional<WebKit::WebHitTestResultData>>();
#endif
    auto originatingFrameInfoData = decoder.decode<WebKit::FrameInfoData>();
    auto originatingPageID = decoder.decode<std::optional<WebKit::WebPageProxyIdentifier>>();
    auto frameInfo = decoder.decode<WebKit::FrameInfoData>();
    auto navigationID = decoder.decode<std::optional<WebCore::NavigationIdentifier>>();
    auto originalRequest = decoder.decode<WebCore::ResourceRequest>();
    auto request = decoder.decode<WebCore::ResourceRequest>();
    if (request) {
        if (auto requestBody = decoder.decode<IPC::FormDataReference>())
            request->setHTTPBody(requestBody->takeData());
    }
    auto invalidURLString = decoder.decode<String>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebKit::NavigationActionData {
            WTFMove(*navigationType),
            WTFMove(*modifiers),
            WTFMove(*mouseButton),
            WTFMove(*syntheticClickType),
            WTFMove(*userGestureTokenIdentifier),
            WTFMove(*userGestureAuthorizationToken),
            WTFMove(*canHandleRequest),
            WTFMove(*shouldOpenExternalURLsPolicy),
            WTFMove(*downloadAttribute),
            WTFMove(*clickLocationInRootViewCoordinates),
            WTFMove(*redirectResponse),
            WTFMove(*isRequestFromClientOrUserInput),
            WTFMove(*treatAsSameOriginNavigation),
            WTFMove(*hasOpenedFrames),
            WTFMove(*openedByDOMWithOpener),
            WTFMove(*hasOpener),
            WTFMove(*isPerformingHTTPFallback),
            WTFMove(*isInitialFrameSrcLoad),
            WTFMove(*isContentRuleListRedirect),
            WTFMove(*openedMainFrameName),
            WTFMove(*requesterOrigin),
            WTFMove(*requesterTopOrigin),
            WTFMove(*targetBackForwardItemIdentifier),
            WTFMove(*sourceBackForwardItemIdentifier),
            WTFMove(*lockHistory),
            WTFMove(*lockBackForwardList),
            WTFMove(*clientRedirectSourceForHistory),
            WTFMove(*effectiveSandboxFlags),
            WTFMove(*ownerPermissionsPolicy),
            WTFMove(*privateClickMeasurement),
            WTFMove(*advancedPrivacyProtections),
            WTFMove(*originatorAdvancedPrivacyProtections),
#if PLATFORM(MAC) || HAVE(UIKIT_WITH_MOUSE_SUPPORT)
            WTFMove(*webHitTestResultData),
#endif
            WTFMove(*originatingFrameInfoData),
            WTFMove(*originatingPageID),
            WTFMove(*frameInfo),
            WTFMove(*navigationID),
            WTFMove(*originalRequest),
            WTFMove(*request),
            WTFMove(*invalidURLString)
        }
    };
}

void ArgumentCoder<WebKit::NetworkProcessConnectionParameters>::encode(Encoder& encoder, const WebKit::NetworkProcessConnectionParameters& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.sharedPreferencesForWebProcess)>, WebKit::SharedPreferencesForWebProcess>);
#if ENABLE(IPC_TESTING_API)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.ignoreInvalidMessageForTesting)>, bool>);
#endif
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.pagesWithRelaxedThirdPartyCookieBlocking)>, Vector<WebKit::WebPageProxyIdentifier>>);
    struct ShouldBeSameSizeAsNetworkProcessConnectionParameters : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::NetworkProcessConnectionParameters>, false> {
        WebKit::SharedPreferencesForWebProcess sharedPreferencesForWebProcess;
#if ENABLE(IPC_TESTING_API)
        bool ignoreInvalidMessageForTesting;
#endif
        Vector<WebKit::WebPageProxyIdentifier> pagesWithRelaxedThirdPartyCookieBlocking;
    };
    static_assert(sizeof(ShouldBeSameSizeAsNetworkProcessConnectionParameters) == sizeof(WebKit::NetworkProcessConnectionParameters));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::NetworkProcessConnectionParameters, sharedPreferencesForWebProcess)
#if ENABLE(IPC_TESTING_API)
        , offsetof(WebKit::NetworkProcessConnectionParameters, ignoreInvalidMessageForTesting)
#endif
        , offsetof(WebKit::NetworkProcessConnectionParameters, pagesWithRelaxedThirdPartyCookieBlocking)
    >::value);

    encoder << instance.sharedPreferencesForWebProcess;
#if ENABLE(IPC_TESTING_API)
    encoder << instance.ignoreInvalidMessageForTesting;
#endif
    encoder << instance.pagesWithRelaxedThirdPartyCookieBlocking;
}

std::optional<WebKit::NetworkProcessConnectionParameters> ArgumentCoder<WebKit::NetworkProcessConnectionParameters>::decode(Decoder& decoder)
{
    auto sharedPreferencesForWebProcess = decoder.decode<WebKit::SharedPreferencesForWebProcess>();
#if ENABLE(IPC_TESTING_API)
    auto ignoreInvalidMessageForTesting = decoder.decode<bool>();
#endif
    auto pagesWithRelaxedThirdPartyCookieBlocking = decoder.decode<Vector<WebKit::WebPageProxyIdentifier>>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebKit::NetworkProcessConnectionParameters {
            WTFMove(*sharedPreferencesForWebProcess),
#if ENABLE(IPC_TESTING_API)
            WTFMove(*ignoreInvalidMessageForTesting),
#endif
            WTFMove(*pagesWithRelaxedThirdPartyCookieBlocking)
        }
    };
}

void ArgumentCoder<WebCore::PasteboardImage>::encode(Encoder& encoder, const WebCore::PasteboardImage& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.image)>, RefPtr<WebCore::Image>>);
#if PLATFORM(MAC)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.dataInWebArchiveFormat)>, RefPtr<WebCore::SharedBuffer>>);
#endif
#if PLATFORM(MAC)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.dataInHTMLFormat)>, String>);
#endif
#if !PLATFORM(WIN)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.url)>, WebCore::PasteboardURL>);
#endif
#if !(PLATFORM(GTK) || PLATFORM(WPE) || PLATFORM(WIN))
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.resourceData)>, RefPtr<WebCore::SharedBuffer>>);
#endif
#if !(PLATFORM(GTK) || PLATFORM(WPE) || PLATFORM(WIN))
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.resourceMIMEType)>, String>);
#endif
#if !(PLATFORM(GTK) || PLATFORM(WPE) || PLATFORM(WIN))
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.clientTypesAndData)>, Vector<std::pair<String, RefPtr<WebCore::SharedBuffer>>>>);
#endif
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.suggestedName)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.imageSize)>, WebCore::FloatSize>);
    struct ShouldBeSameSizeAsPasteboardImage : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::PasteboardImage>, false> {
        RefPtr<WebCore::Image> image;
#if PLATFORM(MAC)
        RefPtr<WebCore::SharedBuffer> dataInWebArchiveFormat;
#endif
#if PLATFORM(MAC)
        String dataInHTMLFormat;
#endif
#if !PLATFORM(WIN)
        WebCore::PasteboardURL url;
#endif
#if !(PLATFORM(GTK) || PLATFORM(WPE) || PLATFORM(WIN))
        RefPtr<WebCore::SharedBuffer> resourceData;
#endif
#if !(PLATFORM(GTK) || PLATFORM(WPE) || PLATFORM(WIN))
        String resourceMIMEType;
#endif
#if !(PLATFORM(GTK) || PLATFORM(WPE) || PLATFORM(WIN))
        Vector<std::pair<String, RefPtr<WebCore::SharedBuffer>>> clientTypesAndData;
#endif
        String suggestedName;
        WebCore::FloatSize imageSize;
    };
    static_assert(sizeof(ShouldBeSameSizeAsPasteboardImage) == sizeof(WebCore::PasteboardImage));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::PasteboardImage, image)
#if PLATFORM(MAC)
        , offsetof(WebCore::PasteboardImage, dataInWebArchiveFormat)
#endif
#if PLATFORM(MAC)
        , offsetof(WebCore::PasteboardImage, dataInHTMLFormat)
#endif
#if !PLATFORM(WIN)
        , offsetof(WebCore::PasteboardImage, url)
#endif
#if !(PLATFORM(GTK) || PLATFORM(WPE) || PLATFORM(WIN))
        , offsetof(WebCore::PasteboardImage, resourceData)
#endif
#if !(PLATFORM(GTK) || PLATFORM(WPE) || PLATFORM(WIN))
        , offsetof(WebCore::PasteboardImage, resourceMIMEType)
#endif
#if !(PLATFORM(GTK) || PLATFORM(WPE) || PLATFORM(WIN))
        , offsetof(WebCore::PasteboardImage, clientTypesAndData)
#endif
        , offsetof(WebCore::PasteboardImage, suggestedName)
        , offsetof(WebCore::PasteboardImage, imageSize)
    >::value);

    encoder << instance.image;
#if PLATFORM(MAC)
    encoder << instance.dataInWebArchiveFormat;
#endif
#if PLATFORM(MAC)
    encoder << instance.dataInHTMLFormat;
#endif
#if !PLATFORM(WIN)
    encoder << instance.url;
#endif
#if !(PLATFORM(GTK) || PLATFORM(WPE) || PLATFORM(WIN))
    encoder << instance.resourceData;
#endif
#if !(PLATFORM(GTK) || PLATFORM(WPE) || PLATFORM(WIN))
    encoder << instance.resourceMIMEType;
#endif
#if !(PLATFORM(GTK) || PLATFORM(WPE) || PLATFORM(WIN))
    encoder << instance.clientTypesAndData;
#endif
    encoder << instance.suggestedName;
    encoder << instance.imageSize;
}

std::optional<WebCore::PasteboardImage> ArgumentCoder<WebCore::PasteboardImage>::decode(Decoder& decoder)
{
    auto image = decoder.decode<RefPtr<WebCore::Image>>();
#if PLATFORM(MAC)
    auto dataInWebArchiveFormat = decoder.decode<RefPtr<WebCore::SharedBuffer>>();
#endif
#if PLATFORM(MAC)
    auto dataInHTMLFormat = decoder.decode<String>();
#endif
#if !PLATFORM(WIN)
    auto url = decoder.decode<WebCore::PasteboardURL>();
#endif
#if !(PLATFORM(GTK) || PLATFORM(WPE) || PLATFORM(WIN))
    auto resourceData = decoder.decode<RefPtr<WebCore::SharedBuffer>>();
#endif
#if !(PLATFORM(GTK) || PLATFORM(WPE) || PLATFORM(WIN))
    auto resourceMIMEType = decoder.decode<String>();
#endif
#if !(PLATFORM(GTK) || PLATFORM(WPE) || PLATFORM(WIN))
    auto clientTypesAndData = decoder.decode<Vector<std::pair<String, RefPtr<WebCore::SharedBuffer>>>>();
#endif
    auto suggestedName = decoder.decode<String>();
    auto imageSize = decoder.decode<WebCore::FloatSize>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::PasteboardImage {
            WTFMove(*image),
#if PLATFORM(MAC)
            WTFMove(*dataInWebArchiveFormat),
#endif
#if PLATFORM(MAC)
            WTFMove(*dataInHTMLFormat),
#endif
#if !PLATFORM(WIN)
            WTFMove(*url),
#endif
#if !(PLATFORM(GTK) || PLATFORM(WPE) || PLATFORM(WIN))
            WTFMove(*resourceData),
#endif
#if !(PLATFORM(GTK) || PLATFORM(WPE) || PLATFORM(WIN))
            WTFMove(*resourceMIMEType),
#endif
#if !(PLATFORM(GTK) || PLATFORM(WPE) || PLATFORM(WIN))
            WTFMove(*clientTypesAndData),
#endif
            WTFMove(*suggestedName),
            WTFMove(*imageSize)
        }
    };
}

void ArgumentCoder<WebCore::PasteboardWebContent>::encode(Encoder& encoder, const WebCore::PasteboardWebContent& instance)
{
#if PLATFORM(COCOA)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.contentOrigin)>, String>);
#endif
#if PLATFORM(COCOA)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.canSmartCopyOrDelete)>, bool>);
#endif
#if PLATFORM(COCOA)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.dataInWebArchiveFormat)>, RefPtr<WebCore::SharedBuffer>>);
#endif
#if PLATFORM(COCOA)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.dataInRTFDFormat)>, RefPtr<WebCore::SharedBuffer>>);
#endif
#if PLATFORM(COCOA)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.dataInRTFFormat)>, RefPtr<WebCore::SharedBuffer>>);
#endif
#if PLATFORM(COCOA)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.dataInAttributedStringFormat)>, RefPtr<WebCore::SharedBuffer>>);
#endif
#if PLATFORM(COCOA)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.dataInHTMLFormat)>, String>);
#endif
#if PLATFORM(COCOA)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.dataInStringFormat)>, String>);
#endif
#if PLATFORM(COCOA)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.clientTypesAndData)>, Vector<std::pair<String, RefPtr<WebCore::SharedBuffer>>>>);
#endif
#if PLATFORM(GTK) || PLATFORM(WPE)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.contentOrigin)>, String>);
#endif
#if PLATFORM(GTK) || PLATFORM(WPE)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.canSmartCopyOrDelete)>, bool>);
#endif
#if PLATFORM(GTK) || PLATFORM(WPE)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.text)>, String>);
#endif
#if PLATFORM(GTK) || PLATFORM(WPE)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.markup)>, String>);
#endif
#if USE(LIBWPE) && !PLATFORM(WPE)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.text)>, String>);
#endif
#if USE(LIBWPE) && !PLATFORM(WPE)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.markup)>, String>);
#endif
    struct ShouldBeSameSizeAsPasteboardWebContent : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::PasteboardWebContent>, false> {
#if PLATFORM(COCOA)
        String contentOrigin;
#endif
#if PLATFORM(COCOA)
        bool canSmartCopyOrDelete;
#endif
#if PLATFORM(COCOA)
        RefPtr<WebCore::SharedBuffer> dataInWebArchiveFormat;
#endif
#if PLATFORM(COCOA)
        RefPtr<WebCore::SharedBuffer> dataInRTFDFormat;
#endif
#if PLATFORM(COCOA)
        RefPtr<WebCore::SharedBuffer> dataInRTFFormat;
#endif
#if PLATFORM(COCOA)
        RefPtr<WebCore::SharedBuffer> dataInAttributedStringFormat;
#endif
#if PLATFORM(COCOA)
        String dataInHTMLFormat;
#endif
#if PLATFORM(COCOA)
        String dataInStringFormat;
#endif
#if PLATFORM(COCOA)
        Vector<std::pair<String, RefPtr<WebCore::SharedBuffer>>> clientTypesAndData;
#endif
#if PLATFORM(GTK) || PLATFORM(WPE)
        String contentOrigin;
#endif
#if PLATFORM(GTK) || PLATFORM(WPE)
        bool canSmartCopyOrDelete;
#endif
#if PLATFORM(GTK) || PLATFORM(WPE)
        String text;
#endif
#if PLATFORM(GTK) || PLATFORM(WPE)
        String markup;
#endif
#if USE(LIBWPE) && !PLATFORM(WPE)
        String text;
#endif
#if USE(LIBWPE) && !PLATFORM(WPE)
        String markup;
#endif
    };
    static_assert(sizeof(ShouldBeSameSizeAsPasteboardWebContent) == sizeof(WebCore::PasteboardWebContent));
    static_assert(MembersInCorrectOrder < 0
#if PLATFORM(COCOA)
        , offsetof(WebCore::PasteboardWebContent, contentOrigin)
#endif
#if PLATFORM(COCOA)
        , offsetof(WebCore::PasteboardWebContent, canSmartCopyOrDelete)
#endif
#if PLATFORM(COCOA)
        , offsetof(WebCore::PasteboardWebContent, dataInWebArchiveFormat)
#endif
#if PLATFORM(COCOA)
        , offsetof(WebCore::PasteboardWebContent, dataInRTFDFormat)
#endif
#if PLATFORM(COCOA)
        , offsetof(WebCore::PasteboardWebContent, dataInRTFFormat)
#endif
#if PLATFORM(COCOA)
        , offsetof(WebCore::PasteboardWebContent, dataInAttributedStringFormat)
#endif
#if PLATFORM(COCOA)
        , offsetof(WebCore::PasteboardWebContent, dataInHTMLFormat)
#endif
#if PLATFORM(COCOA)
        , offsetof(WebCore::PasteboardWebContent, dataInStringFormat)
#endif
#if PLATFORM(COCOA)
        , offsetof(WebCore::PasteboardWebContent, clientTypesAndData)
#endif
#if PLATFORM(GTK) || PLATFORM(WPE)
        , offsetof(WebCore::PasteboardWebContent, contentOrigin)
#endif
#if PLATFORM(GTK) || PLATFORM(WPE)
        , offsetof(WebCore::PasteboardWebContent, canSmartCopyOrDelete)
#endif
#if PLATFORM(GTK) || PLATFORM(WPE)
        , offsetof(WebCore::PasteboardWebContent, text)
#endif
#if PLATFORM(GTK) || PLATFORM(WPE)
        , offsetof(WebCore::PasteboardWebContent, markup)
#endif
#if USE(LIBWPE) && !PLATFORM(WPE)
        , offsetof(WebCore::PasteboardWebContent, text)
#endif
#if USE(LIBWPE) && !PLATFORM(WPE)
        , offsetof(WebCore::PasteboardWebContent, markup)
#endif
    >::value);

#if PLATFORM(COCOA)
    encoder << instance.contentOrigin;
#endif
#if PLATFORM(COCOA)
    encoder << instance.canSmartCopyOrDelete;
#endif
#if PLATFORM(COCOA)
    encoder << instance.dataInWebArchiveFormat;
#endif
#if PLATFORM(COCOA)
    encoder << instance.dataInRTFDFormat;
#endif
#if PLATFORM(COCOA)
    encoder << instance.dataInRTFFormat;
#endif
#if PLATFORM(COCOA)
    encoder << instance.dataInAttributedStringFormat;
#endif
#if PLATFORM(COCOA)
    encoder << instance.dataInHTMLFormat;
#endif
#if PLATFORM(COCOA)
    encoder << instance.dataInStringFormat;
#endif
#if PLATFORM(COCOA)
    encoder << instance.clientTypesAndData;
#endif
#if PLATFORM(GTK) || PLATFORM(WPE)
    encoder << instance.contentOrigin;
#endif
#if PLATFORM(GTK) || PLATFORM(WPE)
    encoder << instance.canSmartCopyOrDelete;
#endif
#if PLATFORM(GTK) || PLATFORM(WPE)
    encoder << instance.text;
#endif
#if PLATFORM(GTK) || PLATFORM(WPE)
    encoder << instance.markup;
#endif
#if USE(LIBWPE) && !PLATFORM(WPE)
    encoder << instance.text;
#endif
#if USE(LIBWPE) && !PLATFORM(WPE)
    encoder << instance.markup;
#endif
}

std::optional<WebCore::PasteboardWebContent> ArgumentCoder<WebCore::PasteboardWebContent>::decode(Decoder& decoder)
{
#if PLATFORM(COCOA)
    auto contentOrigin = decoder.decode<String>();
#endif
#if PLATFORM(COCOA)
    auto canSmartCopyOrDelete = decoder.decode<bool>();
#endif
#if PLATFORM(COCOA)
    auto dataInWebArchiveFormat = decoder.decode<RefPtr<WebCore::SharedBuffer>>();
#endif
#if PLATFORM(COCOA)
    auto dataInRTFDFormat = decoder.decode<RefPtr<WebCore::SharedBuffer>>();
#endif
#if PLATFORM(COCOA)
    auto dataInRTFFormat = decoder.decode<RefPtr<WebCore::SharedBuffer>>();
#endif
#if PLATFORM(COCOA)
    auto dataInAttributedStringFormat = decoder.decode<RefPtr<WebCore::SharedBuffer>>();
#endif
#if PLATFORM(COCOA)
    auto dataInHTMLFormat = decoder.decode<String>();
#endif
#if PLATFORM(COCOA)
    auto dataInStringFormat = decoder.decode<String>();
#endif
#if PLATFORM(COCOA)
    auto clientTypesAndData = decoder.decode<Vector<std::pair<String, RefPtr<WebCore::SharedBuffer>>>>();
#endif
#if PLATFORM(GTK) || PLATFORM(WPE)
    auto contentOrigin = decoder.decode<String>();
#endif
#if PLATFORM(GTK) || PLATFORM(WPE)
    auto canSmartCopyOrDelete = decoder.decode<bool>();
#endif
#if PLATFORM(GTK) || PLATFORM(WPE)
    auto text = decoder.decode<String>();
#endif
#if PLATFORM(GTK) || PLATFORM(WPE)
    auto markup = decoder.decode<String>();
#endif
#if USE(LIBWPE) && !PLATFORM(WPE)
    auto text = decoder.decode<String>();
#endif
#if USE(LIBWPE) && !PLATFORM(WPE)
    auto markup = decoder.decode<String>();
#endif
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::PasteboardWebContent {
#if PLATFORM(COCOA)
            WTFMove(*contentOrigin),
#endif
#if PLATFORM(COCOA)
            WTFMove(*canSmartCopyOrDelete),
#endif
#if PLATFORM(COCOA)
            WTFMove(*dataInWebArchiveFormat),
#endif
#if PLATFORM(COCOA)
            WTFMove(*dataInRTFDFormat),
#endif
#if PLATFORM(COCOA)
            WTFMove(*dataInRTFFormat),
#endif
#if PLATFORM(COCOA)
            WTFMove(*dataInAttributedStringFormat),
#endif
#if PLATFORM(COCOA)
            WTFMove(*dataInHTMLFormat),
#endif
#if PLATFORM(COCOA)
            WTFMove(*dataInStringFormat),
#endif
#if PLATFORM(COCOA)
            WTFMove(*clientTypesAndData),
#endif
#if PLATFORM(GTK) || PLATFORM(WPE)
            WTFMove(*contentOrigin),
#endif
#if PLATFORM(GTK) || PLATFORM(WPE)
            WTFMove(*canSmartCopyOrDelete),
#endif
#if PLATFORM(GTK) || PLATFORM(WPE)
            WTFMove(*text),
#endif
#if PLATFORM(GTK) || PLATFORM(WPE)
            WTFMove(*markup),
#endif
#if USE(LIBWPE) && !PLATFORM(WPE)
            WTFMove(*text),
#endif
#if USE(LIBWPE) && !PLATFORM(WPE)
            WTFMove(*markup)
#endif
        }
    };
}

void ArgumentCoder<WebCore::PasteboardURL>::encode(Encoder& encoder, const WebCore::PasteboardURL& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.url)>, URL>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.title)>, String>);
#if PLATFORM(MAC)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.userVisibleForm)>, String>);
#endif
#if PLATFORM(GTK) || PLATFORM(WPE)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.markup)>, String>);
#endif
    struct ShouldBeSameSizeAsPasteboardURL : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::PasteboardURL>, false> {
        URL url;
        String title;
#if PLATFORM(MAC)
        String userVisibleForm;
#endif
#if PLATFORM(GTK) || PLATFORM(WPE)
        String markup;
#endif
    };
    static_assert(sizeof(ShouldBeSameSizeAsPasteboardURL) == sizeof(WebCore::PasteboardURL));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::PasteboardURL, url)
        , offsetof(WebCore::PasteboardURL, title)
#if PLATFORM(MAC)
        , offsetof(WebCore::PasteboardURL, userVisibleForm)
#endif
#if PLATFORM(GTK) || PLATFORM(WPE)
        , offsetof(WebCore::PasteboardURL, markup)
#endif
    >::value);

    encoder << instance.url;
    encoder << instance.title;
#if PLATFORM(MAC)
    encoder << instance.userVisibleForm;
#endif
#if PLATFORM(GTK) || PLATFORM(WPE)
    encoder << instance.markup;
#endif
}

std::optional<WebCore::PasteboardURL> ArgumentCoder<WebCore::PasteboardURL>::decode(Decoder& decoder)
{
    auto url = decoder.decode<URL>();
    auto title = decoder.decode<String>();
#if PLATFORM(MAC)
    auto userVisibleForm = decoder.decode<String>();
#endif
#if PLATFORM(GTK) || PLATFORM(WPE)
    auto markup = decoder.decode<String>();
#endif
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::PasteboardURL {
            WTFMove(*url),
            WTFMove(*title),
#if PLATFORM(MAC)
            WTFMove(*userVisibleForm),
#endif
#if PLATFORM(GTK) || PLATFORM(WPE)
            WTFMove(*markup)
#endif
        }
    };
}

void ArgumentCoder<WebCore::PasteboardBuffer>::encode(Encoder& encoder, const WebCore::PasteboardBuffer& instance)
{
#if PLATFORM(COCOA)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.contentOrigin)>, String>);
#endif
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.type)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.data)>, RefPtr<WebCore::SharedBuffer>>);
    struct ShouldBeSameSizeAsPasteboardBuffer : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::PasteboardBuffer>, false> {
#if PLATFORM(COCOA)
        String contentOrigin;
#endif
        String type;
        RefPtr<WebCore::SharedBuffer> data;
    };
    static_assert(sizeof(ShouldBeSameSizeAsPasteboardBuffer) == sizeof(WebCore::PasteboardBuffer));
    static_assert(MembersInCorrectOrder < 0
#if PLATFORM(COCOA)
        , offsetof(WebCore::PasteboardBuffer, contentOrigin)
#endif
        , offsetof(WebCore::PasteboardBuffer, type)
        , offsetof(WebCore::PasteboardBuffer, data)
    >::value);

#if PLATFORM(COCOA)
    encoder << instance.contentOrigin;
#endif
    encoder << instance.type;
    encoder << instance.data;
}

std::optional<WebCore::PasteboardBuffer> ArgumentCoder<WebCore::PasteboardBuffer>::decode(Decoder& decoder)
{
#if PLATFORM(COCOA)
    auto contentOrigin = decoder.decode<String>();
#endif
    auto type = decoder.decode<String>();
    auto data = decoder.decode<RefPtr<WebCore::SharedBuffer>>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::PasteboardBuffer {
#if PLATFORM(COCOA)
            WTFMove(*contentOrigin),
#endif
            WTFMove(*type),
            WTFMove(*data)
        }
    };
}

void ArgumentCoder<WebKit::PlatformFontInfo>::encode(Encoder& encoder, const WebKit::PlatformFontInfo& instance)
{
#if PLATFORM(COCOA)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.fontAttributeDictionary)>, RetainPtr<CFDictionaryRef>>);
#endif
    struct ShouldBeSameSizeAsPlatformFontInfo : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::PlatformFontInfo>, false> {
#if PLATFORM(COCOA)
        RetainPtr<CFDictionaryRef> fontAttributeDictionary;
#endif
    };
    static_assert(sizeof(ShouldBeSameSizeAsPlatformFontInfo) == sizeof(WebKit::PlatformFontInfo));
    static_assert(MembersInCorrectOrder < 0
#if PLATFORM(COCOA)
        , offsetof(WebKit::PlatformFontInfo, fontAttributeDictionary)
#endif
    >::value);

#if PLATFORM(COCOA)
    encoder << instance.fontAttributeDictionary;
#endif
}

std::optional<WebKit::PlatformFontInfo> ArgumentCoder<WebKit::PlatformFontInfo>::decode(Decoder& decoder)
{
#if PLATFORM(COCOA)
    auto fontAttributeDictionary = decoder.decode<RetainPtr<CFDictionaryRef>>();
#endif
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebKit::PlatformFontInfo {
#if PLATFORM(COCOA)
            WTFMove(*fontAttributeDictionary)
#endif
        }
    };
}

void ArgumentCoder<WebKit::PlatformPopupMenuData>::encode(Encoder& encoder, const WebKit::PlatformPopupMenuData& instance)
{
#if PLATFORM(COCOA)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.fontInfo)>, WebKit::PlatformFontInfo>);
#endif
#if PLATFORM(COCOA)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.shouldPopOver)>, bool>);
#endif
#if PLATFORM(COCOA)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.hideArrows)>, bool>);
#endif
#if PLATFORM(COCOA)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.menuSize)>, WebCore::PopupMenuStyle::Size>);
#endif
#if PLATFORM(WIN)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_clientPaddingLeft)>, int>);
#endif
#if PLATFORM(WIN)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_clientPaddingRight)>, int>);
#endif
#if PLATFORM(WIN)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_clientInsetLeft)>, int>);
#endif
#if PLATFORM(WIN)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_clientInsetRight)>, int>);
#endif
#if PLATFORM(WIN)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_popupWidth)>, int>);
#endif
#if PLATFORM(WIN)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_itemHeight)>, float>);
#endif
#if PLATFORM(WIN)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_isRTL)>, bool>);
#endif
#if PLATFORM(WIN)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_notSelectedBackingStore)>, RefPtr<WebCore::ShareableBitmap>>);
#endif
#if PLATFORM(WIN)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_selectedBackingStore)>, RefPtr<WebCore::ShareableBitmap>>);
#endif
    struct ShouldBeSameSizeAsPlatformPopupMenuData : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::PlatformPopupMenuData>, false> {
#if PLATFORM(COCOA)
        WebKit::PlatformFontInfo fontInfo;
#endif
#if PLATFORM(COCOA)
        bool shouldPopOver;
#endif
#if PLATFORM(COCOA)
        bool hideArrows;
#endif
#if PLATFORM(COCOA)
        WebCore::PopupMenuStyle::Size menuSize;
#endif
#if PLATFORM(WIN)
        int m_clientPaddingLeft;
#endif
#if PLATFORM(WIN)
        int m_clientPaddingRight;
#endif
#if PLATFORM(WIN)
        int m_clientInsetLeft;
#endif
#if PLATFORM(WIN)
        int m_clientInsetRight;
#endif
#if PLATFORM(WIN)
        int m_popupWidth;
#endif
#if PLATFORM(WIN)
        float m_itemHeight;
#endif
#if PLATFORM(WIN)
        bool m_isRTL;
#endif
#if PLATFORM(WIN)
        RefPtr<WebCore::ShareableBitmap> m_notSelectedBackingStore;
#endif
#if PLATFORM(WIN)
        RefPtr<WebCore::ShareableBitmap> m_selectedBackingStore;
#endif
    };
    static_assert(sizeof(ShouldBeSameSizeAsPlatformPopupMenuData) == sizeof(WebKit::PlatformPopupMenuData));
    static_assert(MembersInCorrectOrder < 0
#if PLATFORM(COCOA)
        , offsetof(WebKit::PlatformPopupMenuData, fontInfo)
#endif
#if PLATFORM(COCOA)
        , offsetof(WebKit::PlatformPopupMenuData, shouldPopOver)
#endif
#if PLATFORM(COCOA)
        , offsetof(WebKit::PlatformPopupMenuData, hideArrows)
#endif
#if PLATFORM(COCOA)
        , offsetof(WebKit::PlatformPopupMenuData, menuSize)
#endif
#if PLATFORM(WIN)
        , offsetof(WebKit::PlatformPopupMenuData, m_clientPaddingLeft)
#endif
#if PLATFORM(WIN)
        , offsetof(WebKit::PlatformPopupMenuData, m_clientPaddingRight)
#endif
#if PLATFORM(WIN)
        , offsetof(WebKit::PlatformPopupMenuData, m_clientInsetLeft)
#endif
#if PLATFORM(WIN)
        , offsetof(WebKit::PlatformPopupMenuData, m_clientInsetRight)
#endif
#if PLATFORM(WIN)
        , offsetof(WebKit::PlatformPopupMenuData, m_popupWidth)
#endif
#if PLATFORM(WIN)
        , offsetof(WebKit::PlatformPopupMenuData, m_itemHeight)
#endif
#if PLATFORM(WIN)
        , offsetof(WebKit::PlatformPopupMenuData, m_isRTL)
#endif
#if PLATFORM(WIN)
        , offsetof(WebKit::PlatformPopupMenuData, m_notSelectedBackingStore)
#endif
#if PLATFORM(WIN)
        , offsetof(WebKit::PlatformPopupMenuData, m_selectedBackingStore)
#endif
    >::value);

#if PLATFORM(COCOA)
    encoder << instance.fontInfo;
#endif
#if PLATFORM(COCOA)
    encoder << instance.shouldPopOver;
#endif
#if PLATFORM(COCOA)
    encoder << instance.hideArrows;
#endif
#if PLATFORM(COCOA)
    encoder << instance.menuSize;
#endif
#if PLATFORM(WIN)
    encoder << instance.m_clientPaddingLeft;
#endif
#if PLATFORM(WIN)
    encoder << instance.m_clientPaddingRight;
#endif
#if PLATFORM(WIN)
    encoder << instance.m_clientInsetLeft;
#endif
#if PLATFORM(WIN)
    encoder << instance.m_clientInsetRight;
#endif
#if PLATFORM(WIN)
    encoder << instance.m_popupWidth;
#endif
#if PLATFORM(WIN)
    encoder << instance.m_itemHeight;
#endif
#if PLATFORM(WIN)
    encoder << instance.m_isRTL;
#endif
#if PLATFORM(WIN)
    encoder << instance.m_notSelectedBackingStore;
#endif
#if PLATFORM(WIN)
    encoder << instance.m_selectedBackingStore;
#endif
}

std::optional<WebKit::PlatformPopupMenuData> ArgumentCoder<WebKit::PlatformPopupMenuData>::decode(Decoder& decoder)
{
#if PLATFORM(COCOA)
    auto fontInfo = decoder.decode<WebKit::PlatformFontInfo>();
#endif
#if PLATFORM(COCOA)
    auto shouldPopOver = decoder.decode<bool>();
#endif
#if PLATFORM(COCOA)
    auto hideArrows = decoder.decode<bool>();
#endif
#if PLATFORM(COCOA)
    auto menuSize = decoder.decode<WebCore::PopupMenuStyle::Size>();
#endif
#if PLATFORM(WIN)
    auto m_clientPaddingLeft = decoder.decode<int>();
#endif
#if PLATFORM(WIN)
    auto m_clientPaddingRight = decoder.decode<int>();
#endif
#if PLATFORM(WIN)
    auto m_clientInsetLeft = decoder.decode<int>();
#endif
#if PLATFORM(WIN)
    auto m_clientInsetRight = decoder.decode<int>();
#endif
#if PLATFORM(WIN)
    auto m_popupWidth = decoder.decode<int>();
#endif
#if PLATFORM(WIN)
    auto m_itemHeight = decoder.decode<float>();
#endif
#if PLATFORM(WIN)
    auto m_isRTL = decoder.decode<bool>();
#endif
#if PLATFORM(WIN)
    auto m_notSelectedBackingStore = decoder.decode<RefPtr<WebCore::ShareableBitmap>>();
#endif
#if PLATFORM(WIN)
    auto m_selectedBackingStore = decoder.decode<RefPtr<WebCore::ShareableBitmap>>();
#endif
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebKit::PlatformPopupMenuData {
#if PLATFORM(COCOA)
            WTFMove(*fontInfo),
#endif
#if PLATFORM(COCOA)
            WTFMove(*shouldPopOver),
#endif
#if PLATFORM(COCOA)
            WTFMove(*hideArrows),
#endif
#if PLATFORM(COCOA)
            WTFMove(*menuSize),
#endif
#if PLATFORM(WIN)
            WTFMove(*m_clientPaddingLeft),
#endif
#if PLATFORM(WIN)
            WTFMove(*m_clientPaddingRight),
#endif
#if PLATFORM(WIN)
            WTFMove(*m_clientInsetLeft),
#endif
#if PLATFORM(WIN)
            WTFMove(*m_clientInsetRight),
#endif
#if PLATFORM(WIN)
            WTFMove(*m_popupWidth),
#endif
#if PLATFORM(WIN)
            WTFMove(*m_itemHeight),
#endif
#if PLATFORM(WIN)
            WTFMove(*m_isRTL),
#endif
#if PLATFORM(WIN)
            WTFMove(*m_notSelectedBackingStore),
#endif
#if PLATFORM(WIN)
            WTFMove(*m_selectedBackingStore)
#endif
        }
    };
}

void ArgumentCoder<WebKit::PolicyDecision>::encode(Encoder& encoder, WebKit::PolicyDecision&& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isNavigatingToAppBoundDomain)>, std::optional<WebKit::NavigatingToAppBoundDomain>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.policyAction)>, WebCore::PolicyAction>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.navigationID)>, std::optional<WebCore::NavigationIdentifier>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.downloadID)>, std::optional<WebKit::DownloadID>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.websitePoliciesData)>, std::optional<WebKit::WebsitePoliciesData>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.sandboxExtensionHandle)>, std::optional<WebKit::SandboxExtensionHandle>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.consoleMessage)>, std::optional<WebKit::PolicyDecisionConsoleMessage>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isSafeBrowsingCheckOngoing)>, WebKit::SafeBrowsingCheckOngoing>);
    struct ShouldBeSameSizeAsPolicyDecision : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::PolicyDecision>, false> {
        std::optional<WebKit::NavigatingToAppBoundDomain> isNavigatingToAppBoundDomain;
        WebCore::PolicyAction policyAction;
        std::optional<WebCore::NavigationIdentifier> navigationID;
        std::optional<WebKit::DownloadID> downloadID;
        std::optional<WebKit::WebsitePoliciesData> websitePoliciesData;
        std::optional<WebKit::SandboxExtensionHandle> sandboxExtensionHandle;
        std::optional<WebKit::PolicyDecisionConsoleMessage> consoleMessage;
        WebKit::SafeBrowsingCheckOngoing isSafeBrowsingCheckOngoing;
    };
    static_assert(sizeof(ShouldBeSameSizeAsPolicyDecision) == sizeof(WebKit::PolicyDecision));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::PolicyDecision, isNavigatingToAppBoundDomain)
        , offsetof(WebKit::PolicyDecision, policyAction)
        , offsetof(WebKit::PolicyDecision, navigationID)
        , offsetof(WebKit::PolicyDecision, downloadID)
        , offsetof(WebKit::PolicyDecision, websitePoliciesData)
        , offsetof(WebKit::PolicyDecision, sandboxExtensionHandle)
        , offsetof(WebKit::PolicyDecision, consoleMessage)
        , offsetof(WebKit::PolicyDecision, isSafeBrowsingCheckOngoing)
    >::value);

    encoder << WTFMove(instance.isNavigatingToAppBoundDomain);
    encoder << WTFMove(instance.policyAction);
    encoder << WTFMove(instance.navigationID);
    encoder << WTFMove(instance.downloadID);
    encoder << WTFMove(instance.websitePoliciesData);
    encoder << WTFMove(instance.sandboxExtensionHandle);
    encoder << WTFMove(instance.consoleMessage);
    encoder << WTFMove(instance.isSafeBrowsingCheckOngoing);
}

std::optional<WebKit::PolicyDecision> ArgumentCoder<WebKit::PolicyDecision>::decode(Decoder& decoder)
{
    auto isNavigatingToAppBoundDomain = decoder.decode<std::optional<WebKit::NavigatingToAppBoundDomain>>();
    auto policyAction = decoder.decode<WebCore::PolicyAction>();
    auto navigationID = decoder.decode<std::optional<WebCore::NavigationIdentifier>>();
    auto downloadID = decoder.decode<std::optional<WebKit::DownloadID>>();
    auto websitePoliciesData = decoder.decode<std::optional<WebKit::WebsitePoliciesData>>();
    auto sandboxExtensionHandle = decoder.decode<std::optional<WebKit::SandboxExtensionHandle>>();
    auto consoleMessage = decoder.decode<std::optional<WebKit::PolicyDecisionConsoleMessage>>();
    auto isSafeBrowsingCheckOngoing = decoder.decode<WebKit::SafeBrowsingCheckOngoing>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebKit::PolicyDecision {
            WTFMove(*isNavigatingToAppBoundDomain),
            WTFMove(*policyAction),
            WTFMove(*navigationID),
            WTFMove(*downloadID),
            WTFMove(*websitePoliciesData),
            WTFMove(*sandboxExtensionHandle),
            WTFMove(*consoleMessage),
            WTFMove(*isSafeBrowsingCheckOngoing)
        }
    };
}

void ArgumentCoder<WebKit::PolicyDecisionConsoleMessage>::encode(Encoder& encoder, const WebKit::PolicyDecisionConsoleMessage& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.messageLevel)>, JSC::MessageLevel>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.messageSource)>, JSC::MessageSource>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.message)>, String>);
    struct ShouldBeSameSizeAsPolicyDecisionConsoleMessage : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::PolicyDecisionConsoleMessage>, false> {
        JSC::MessageLevel messageLevel;
        JSC::MessageSource messageSource;
        String message;
    };
    static_assert(sizeof(ShouldBeSameSizeAsPolicyDecisionConsoleMessage) == sizeof(WebKit::PolicyDecisionConsoleMessage));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::PolicyDecisionConsoleMessage, messageLevel)
        , offsetof(WebKit::PolicyDecisionConsoleMessage, messageSource)
        , offsetof(WebKit::PolicyDecisionConsoleMessage, message)
    >::value);

    encoder << instance.messageLevel;
    encoder << instance.messageSource;
    encoder << instance.message;
}

std::optional<WebKit::PolicyDecisionConsoleMessage> ArgumentCoder<WebKit::PolicyDecisionConsoleMessage>::decode(Decoder& decoder)
{
    auto messageLevel = decoder.decode<JSC::MessageLevel>();
    auto messageSource = decoder.decode<JSC::MessageSource>();
    auto message = decoder.decode<String>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebKit::PolicyDecisionConsoleMessage {
            WTFMove(*messageLevel),
            WTFMove(*messageSource),
            WTFMove(*message)
        }
    };
}

void ArgumentCoder<WebKit::PrintInfo>::encode(Encoder& encoder, const WebKit::PrintInfo& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.pageSetupScaleFactor)>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.availablePaperWidth)>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.availablePaperHeight)>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.margin)>, WebCore::FloatBoxExtent>);
#if PLATFORM(IOS_FAMILY)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.snapshotFirstPage)>, bool>);
#endif
#if PLATFORM(GTK)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.printSettings)>, GRefPtr<GtkPrintSettings>>);
#endif
#if PLATFORM(GTK)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.pageSetup)>, GRefPtr<GtkPageSetup>>);
#endif
#if PLATFORM(GTK)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.printMode)>, WebKit::PrintInfo::PrintMode>);
#endif
    struct ShouldBeSameSizeAsPrintInfo : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::PrintInfo>, false> {
        float pageSetupScaleFactor;
        float availablePaperWidth;
        float availablePaperHeight;
        WebCore::FloatBoxExtent margin;
#if PLATFORM(IOS_FAMILY)
        bool snapshotFirstPage;
#endif
#if PLATFORM(GTK)
        GRefPtr<GtkPrintSettings> printSettings;
#endif
#if PLATFORM(GTK)
        GRefPtr<GtkPageSetup> pageSetup;
#endif
#if PLATFORM(GTK)
        WebKit::PrintInfo::PrintMode printMode;
#endif
    };
    static_assert(sizeof(ShouldBeSameSizeAsPrintInfo) == sizeof(WebKit::PrintInfo));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::PrintInfo, pageSetupScaleFactor)
        , offsetof(WebKit::PrintInfo, availablePaperWidth)
        , offsetof(WebKit::PrintInfo, availablePaperHeight)
        , offsetof(WebKit::PrintInfo, margin)
#if PLATFORM(IOS_FAMILY)
        , offsetof(WebKit::PrintInfo, snapshotFirstPage)
#endif
#if PLATFORM(GTK)
        , offsetof(WebKit::PrintInfo, printSettings)
#endif
#if PLATFORM(GTK)
        , offsetof(WebKit::PrintInfo, pageSetup)
#endif
#if PLATFORM(GTK)
        , offsetof(WebKit::PrintInfo, printMode)
#endif
    >::value);

    encoder << instance.pageSetupScaleFactor;
    encoder << instance.availablePaperWidth;
    encoder << instance.availablePaperHeight;
    encoder << instance.margin;
#if PLATFORM(IOS_FAMILY)
    encoder << instance.snapshotFirstPage;
#endif
#if PLATFORM(GTK)
    encoder << instance.printSettings;
#endif
#if PLATFORM(GTK)
    encoder << instance.pageSetup;
#endif
#if PLATFORM(GTK)
    encoder << instance.printMode;
#endif
}

std::optional<WebKit::PrintInfo> ArgumentCoder<WebKit::PrintInfo>::decode(Decoder& decoder)
{
    auto pageSetupScaleFactor = decoder.decode<float>();
    auto availablePaperWidth = decoder.decode<float>();
    auto availablePaperHeight = decoder.decode<float>();
    auto margin = decoder.decode<WebCore::FloatBoxExtent>();
#if PLATFORM(IOS_FAMILY)
    auto snapshotFirstPage = decoder.decode<bool>();
#endif
#if PLATFORM(GTK)
    auto printSettings = decoder.decode<GRefPtr<GtkPrintSettings>>();
#endif
#if PLATFORM(GTK)
    auto pageSetup = decoder.decode<GRefPtr<GtkPageSetup>>();
#endif
#if PLATFORM(GTK)
    auto printMode = decoder.decode<WebKit::PrintInfo::PrintMode>();
#endif
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebKit::PrintInfo {
            WTFMove(*pageSetupScaleFactor),
            WTFMove(*availablePaperWidth),
            WTFMove(*availablePaperHeight),
            WTFMove(*margin),
#if PLATFORM(IOS_FAMILY)
            WTFMove(*snapshotFirstPage),
#endif
#if PLATFORM(GTK)
            WTFMove(*printSettings),
#endif
#if PLATFORM(GTK)
            WTFMove(*pageSetup),
#endif
#if PLATFORM(GTK)
            WTFMove(*printMode)
#endif
        }
    };
}

void ArgumentCoder<WebCore::BackForwardFrameItemIdentifier>::encode(Encoder& encoder, const WebCore::BackForwardFrameItemIdentifier& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.object())>, WebCore::BackForwardFrameItemIdentifierID>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.processIdentifier())>, WebCore::ProcessIdentifier>);

    encoder << instance.object();
    encoder << instance.processIdentifier();
}

void ArgumentCoder<WebCore::BackForwardFrameItemIdentifier>::encode(StreamConnectionEncoder& encoder, const WebCore::BackForwardFrameItemIdentifier& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.object())>, WebCore::BackForwardFrameItemIdentifierID>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.processIdentifier())>, WebCore::ProcessIdentifier>);

    encoder << instance.object();
    encoder << instance.processIdentifier();
}

std::optional<WebCore::BackForwardFrameItemIdentifier> ArgumentCoder<WebCore::BackForwardFrameItemIdentifier>::decode(Decoder& decoder)
{
    auto object = decoder.decode<WebCore::BackForwardFrameItemIdentifierID>();
    auto processIdentifier = decoder.decode<WebCore::ProcessIdentifier>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::BackForwardFrameItemIdentifier {
            WTFMove(*object),
            WTFMove(*processIdentifier)
        }
    };
}

void ArgumentCoder<WebCore::BackForwardItemIdentifier>::encode(Encoder& encoder, const WebCore::BackForwardItemIdentifier& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.object())>, WebCore::BackForwardItemIdentifierID>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.processIdentifier())>, WebCore::ProcessIdentifier>);

    encoder << instance.object();
    encoder << instance.processIdentifier();
}

void ArgumentCoder<WebCore::BackForwardItemIdentifier>::encode(StreamConnectionEncoder& encoder, const WebCore::BackForwardItemIdentifier& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.object())>, WebCore::BackForwardItemIdentifierID>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.processIdentifier())>, WebCore::ProcessIdentifier>);

    encoder << instance.object();
    encoder << instance.processIdentifier();
}

std::optional<WebCore::BackForwardItemIdentifier> ArgumentCoder<WebCore::BackForwardItemIdentifier>::decode(Decoder& decoder)
{
    auto object = decoder.decode<WebCore::BackForwardItemIdentifierID>();
    auto processIdentifier = decoder.decode<WebCore::ProcessIdentifier>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::BackForwardItemIdentifier {
            WTFMove(*object),
            WTFMove(*processIdentifier)
        }
    };
}

void ArgumentCoder<WebCore::DOMCacheIdentifier>::encode(Encoder& encoder, const WebCore::DOMCacheIdentifier& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.object())>, WebCore::DOMCacheIdentifierID>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.processIdentifier())>, WebCore::ProcessIdentifier>);

    encoder << instance.object();
    encoder << instance.processIdentifier();
}

void ArgumentCoder<WebCore::DOMCacheIdentifier>::encode(StreamConnectionEncoder& encoder, const WebCore::DOMCacheIdentifier& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.object())>, WebCore::DOMCacheIdentifierID>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.processIdentifier())>, WebCore::ProcessIdentifier>);

    encoder << instance.object();
    encoder << instance.processIdentifier();
}

std::optional<WebCore::DOMCacheIdentifier> ArgumentCoder<WebCore::DOMCacheIdentifier>::decode(Decoder& decoder)
{
    auto object = decoder.decode<WebCore::DOMCacheIdentifierID>();
    auto processIdentifier = decoder.decode<WebCore::ProcessIdentifier>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::DOMCacheIdentifier {
            WTFMove(*object),
            WTFMove(*processIdentifier)
        }
    };
}

void ArgumentCoder<WebCore::OpaqueOriginIdentifierProcessQualified>::encode(Encoder& encoder, const WebCore::OpaqueOriginIdentifierProcessQualified& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.object())>, WebCore::OpaqueOriginIdentifier>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.processIdentifier())>, WebCore::ProcessIdentifier>);

    encoder << instance.object();
    encoder << instance.processIdentifier();
}

void ArgumentCoder<WebCore::OpaqueOriginIdentifierProcessQualified>::encode(StreamConnectionEncoder& encoder, const WebCore::OpaqueOriginIdentifierProcessQualified& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.object())>, WebCore::OpaqueOriginIdentifier>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.processIdentifier())>, WebCore::ProcessIdentifier>);

    encoder << instance.object();
    encoder << instance.processIdentifier();
}

std::optional<WebCore::OpaqueOriginIdentifierProcessQualified> ArgumentCoder<WebCore::OpaqueOriginIdentifierProcessQualified>::decode(Decoder& decoder)
{
    auto object = decoder.decode<WebCore::OpaqueOriginIdentifier>();
    auto processIdentifier = decoder.decode<WebCore::ProcessIdentifier>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::OpaqueOriginIdentifierProcessQualified {
            WTFMove(*object),
            WTFMove(*processIdentifier)
        }
    };
}

void ArgumentCoder<WebCore::PlatformLayerIdentifier>::encode(Encoder& encoder, const WebCore::PlatformLayerIdentifier& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.object())>, WebCore::PlatformLayerIdentifierID>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.processIdentifier())>, WebCore::ProcessIdentifier>);

    encoder << instance.object();
    encoder << instance.processIdentifier();
}

void ArgumentCoder<WebCore::PlatformLayerIdentifier>::encode(StreamConnectionEncoder& encoder, const WebCore::PlatformLayerIdentifier& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.object())>, WebCore::PlatformLayerIdentifierID>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.processIdentifier())>, WebCore::ProcessIdentifier>);

    encoder << instance.object();
    encoder << instance.processIdentifier();
}

std::optional<WebCore::PlatformLayerIdentifier> ArgumentCoder<WebCore::PlatformLayerIdentifier>::decode(Decoder& decoder)
{
    auto object = decoder.decode<WebCore::PlatformLayerIdentifierID>();
    auto processIdentifier = decoder.decode<WebCore::ProcessIdentifier>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::PlatformLayerIdentifier {
            WTFMove(*object),
            WTFMove(*processIdentifier)
        }
    };
}

void ArgumentCoder<WebCore::PlaybackTargetClientContextIdentifier>::encode(Encoder& encoder, const WebCore::PlaybackTargetClientContextIdentifier& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.object())>, WebCore::PlaybackTargetClientContextID>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.processIdentifier())>, WebCore::ProcessIdentifier>);

    encoder << instance.object();
    encoder << instance.processIdentifier();
}

void ArgumentCoder<WebCore::PlaybackTargetClientContextIdentifier>::encode(StreamConnectionEncoder& encoder, const WebCore::PlaybackTargetClientContextIdentifier& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.object())>, WebCore::PlaybackTargetClientContextID>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.processIdentifier())>, WebCore::ProcessIdentifier>);

    encoder << instance.object();
    encoder << instance.processIdentifier();
}

std::optional<WebCore::PlaybackTargetClientContextIdentifier> ArgumentCoder<WebCore::PlaybackTargetClientContextIdentifier>::decode(Decoder& decoder)
{
    auto object = decoder.decode<WebCore::PlaybackTargetClientContextID>();
    auto processIdentifier = decoder.decode<WebCore::ProcessIdentifier>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::PlaybackTargetClientContextIdentifier {
            WTFMove(*object),
            WTFMove(*processIdentifier)
        }
    };
}

void ArgumentCoder<WebCore::RTCDataChannelIdentifier>::encode(Encoder& encoder, const WebCore::RTCDataChannelIdentifier& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.object())>, WebCore::RTCDataChannelLocalIdentifier>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.processIdentifier())>, WebCore::ProcessIdentifier>);

    encoder << instance.object();
    encoder << instance.processIdentifier();
}

void ArgumentCoder<WebCore::RTCDataChannelIdentifier>::encode(StreamConnectionEncoder& encoder, const WebCore::RTCDataChannelIdentifier& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.object())>, WebCore::RTCDataChannelLocalIdentifier>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.processIdentifier())>, WebCore::ProcessIdentifier>);

    encoder << instance.object();
    encoder << instance.processIdentifier();
}

std::optional<WebCore::RTCDataChannelIdentifier> ArgumentCoder<WebCore::RTCDataChannelIdentifier>::decode(Decoder& decoder)
{
    auto object = decoder.decode<WebCore::RTCDataChannelLocalIdentifier>();
    auto processIdentifier = decoder.decode<WebCore::ProcessIdentifier>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::RTCDataChannelIdentifier {
            WTFMove(*object),
            WTFMove(*processIdentifier)
        }
    };
}

void ArgumentCoder<WebCore::SharedWorkerObjectIdentifier>::encode(Encoder& encoder, const WebCore::SharedWorkerObjectIdentifier& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.object())>, WebCore::SharedWorkerObjectIdentifierID>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.processIdentifier())>, WebCore::ProcessIdentifier>);

    encoder << instance.object();
    encoder << instance.processIdentifier();
}

void ArgumentCoder<WebCore::SharedWorkerObjectIdentifier>::encode(StreamConnectionEncoder& encoder, const WebCore::SharedWorkerObjectIdentifier& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.object())>, WebCore::SharedWorkerObjectIdentifierID>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.processIdentifier())>, WebCore::ProcessIdentifier>);

    encoder << instance.object();
    encoder << instance.processIdentifier();
}

std::optional<WebCore::SharedWorkerObjectIdentifier> ArgumentCoder<WebCore::SharedWorkerObjectIdentifier>::decode(Decoder& decoder)
{
    auto object = decoder.decode<WebCore::SharedWorkerObjectIdentifierID>();
    auto processIdentifier = decoder.decode<WebCore::ProcessIdentifier>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::SharedWorkerObjectIdentifier {
            WTFMove(*object),
            WTFMove(*processIdentifier)
        }
    };
}

void ArgumentCoder<WebCore::UserGestureTokenIdentifier>::encode(Encoder& encoder, const WebCore::UserGestureTokenIdentifier& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.object())>, WebCore::UserGestureTokenIdentifierID>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.processIdentifier())>, WebCore::ProcessIdentifier>);

    encoder << instance.object();
    encoder << instance.processIdentifier();
}

void ArgumentCoder<WebCore::UserGestureTokenIdentifier>::encode(StreamConnectionEncoder& encoder, const WebCore::UserGestureTokenIdentifier& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.object())>, WebCore::UserGestureTokenIdentifierID>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.processIdentifier())>, WebCore::ProcessIdentifier>);

    encoder << instance.object();
    encoder << instance.processIdentifier();
}

std::optional<WebCore::UserGestureTokenIdentifier> ArgumentCoder<WebCore::UserGestureTokenIdentifier>::decode(Decoder& decoder)
{
    auto object = decoder.decode<WebCore::UserGestureTokenIdentifierID>();
    auto processIdentifier = decoder.decode<WebCore::ProcessIdentifier>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::UserGestureTokenIdentifier {
            WTFMove(*object),
            WTFMove(*processIdentifier)
        }
    };
}

void ArgumentCoder<WebCore::WebLockIdentifier>::encode(Encoder& encoder, const WebCore::WebLockIdentifier& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.object())>, WebCore::WebLockIdentifierID>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.processIdentifier())>, WebCore::ProcessIdentifier>);

    encoder << instance.object();
    encoder << instance.processIdentifier();
}

void ArgumentCoder<WebCore::WebLockIdentifier>::encode(StreamConnectionEncoder& encoder, const WebCore::WebLockIdentifier& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.object())>, WebCore::WebLockIdentifierID>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.processIdentifier())>, WebCore::ProcessIdentifier>);

    encoder << instance.object();
    encoder << instance.processIdentifier();
}

std::optional<WebCore::WebLockIdentifier> ArgumentCoder<WebCore::WebLockIdentifier>::decode(Decoder& decoder)
{
    auto object = decoder.decode<WebCore::WebLockIdentifierID>();
    auto processIdentifier = decoder.decode<WebCore::ProcessIdentifier>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::WebLockIdentifier {
            WTFMove(*object),
            WTFMove(*processIdentifier)
        }
    };
}

void ArgumentCoder<WebCore::ScrollingNodeID>::encode(Encoder& encoder, const WebCore::ScrollingNodeID& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.object())>, WebCore::ScrollingNodeIdentifier>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.processIdentifier())>, WebCore::ProcessIdentifier>);

    encoder << instance.object();
    encoder << instance.processIdentifier();
}

void ArgumentCoder<WebCore::ScrollingNodeID>::encode(StreamConnectionEncoder& encoder, const WebCore::ScrollingNodeID& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.object())>, WebCore::ScrollingNodeIdentifier>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.processIdentifier())>, WebCore::ProcessIdentifier>);

    encoder << instance.object();
    encoder << instance.processIdentifier();
}

std::optional<WebCore::ScrollingNodeID> ArgumentCoder<WebCore::ScrollingNodeID>::decode(Decoder& decoder)
{
    auto object = decoder.decode<WebCore::ScrollingNodeIdentifier>();
    auto processIdentifier = decoder.decode<WebCore::ProcessIdentifier>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::ScrollingNodeID {
            WTFMove(*object),
            WTFMove(*processIdentifier)
        }
    };
}

void ArgumentCoder<WebCore::ScriptExecutionContextIdentifier>::encode(Encoder& encoder, const WebCore::ScriptExecutionContextIdentifier& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.object())>, WTF::UUID>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.processIdentifier())>, WebCore::ProcessIdentifier>);

    encoder << instance.object();
    encoder << instance.processIdentifier();
}

std::optional<WebCore::ScriptExecutionContextIdentifier> ArgumentCoder<WebCore::ScriptExecutionContextIdentifier>::decode(Decoder& decoder)
{
    auto object = decoder.decode<WTF::UUID>();
    auto processIdentifier = decoder.decode<WebCore::ProcessIdentifier>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::ScriptExecutionContextIdentifier {
            WTFMove(*object),
            WTFMove(*processIdentifier)
        }
    };
}

void ArgumentCoder<WebKit::TransactionID>::encode(Encoder& encoder, const WebKit::TransactionID& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.object())>, WebKit::TransactionIdentifier>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.processIdentifier())>, WebCore::ProcessIdentifier>);

    encoder << instance.object();
    encoder << instance.processIdentifier();
}

std::optional<WebKit::TransactionID> ArgumentCoder<WebKit::TransactionID>::decode(Decoder& decoder)
{
    auto object = decoder.decode<WebKit::TransactionIdentifier>();
    auto processIdentifier = decoder.decode<WebCore::ProcessIdentifier>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebKit::TransactionID {
            WTFMove(*object),
            WTFMove(*processIdentifier)
        }
    };
}

void ArgumentCoder<WebKit::PlaybackSessionContextIdentifier>::encode(Encoder& encoder, const WebKit::PlaybackSessionContextIdentifier& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.object())>, WebCore::MediaPlayerClientIdentifier>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.processIdentifier())>, WebCore::ProcessIdentifier>);

    encoder << instance.object();
    encoder << instance.processIdentifier();
}

std::optional<WebKit::PlaybackSessionContextIdentifier> ArgumentCoder<WebKit::PlaybackSessionContextIdentifier>::decode(Decoder& decoder)
{
    auto object = decoder.decode<WebCore::MediaPlayerClientIdentifier>();
    auto processIdentifier = decoder.decode<WebCore::ProcessIdentifier>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebKit::PlaybackSessionContextIdentifier {
            WTFMove(*object),
            WTFMove(*processIdentifier)
        }
    };
}

void ArgumentCoder<WebKit::ProvisionalFrameCreationParameters>::encode(Encoder& encoder, const WebKit::ProvisionalFrameCreationParameters& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.frameID)>, WebCore::FrameIdentifier>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.frameIDBeforeProvisionalNavigation)>, std::optional<WebCore::FrameIdentifier>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.layerHostingContextIdentifier)>, std::optional<WebCore::LayerHostingContextIdentifier>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.effectiveSandboxFlags)>, WebCore::SandboxFlags>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.scrollingMode)>, WebCore::ScrollbarMode>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.initialSize)>, std::optional<WebCore::IntSize>>);
    struct ShouldBeSameSizeAsProvisionalFrameCreationParameters : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::ProvisionalFrameCreationParameters>, false> {
        WebCore::FrameIdentifier frameID;
        std::optional<WebCore::FrameIdentifier> frameIDBeforeProvisionalNavigation;
        std::optional<WebCore::LayerHostingContextIdentifier> layerHostingContextIdentifier;
        WebCore::SandboxFlags effectiveSandboxFlags;
        WebCore::ScrollbarMode scrollingMode;
        std::optional<WebCore::IntSize> initialSize;
    };
    static_assert(sizeof(ShouldBeSameSizeAsProvisionalFrameCreationParameters) == sizeof(WebKit::ProvisionalFrameCreationParameters));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::ProvisionalFrameCreationParameters, frameID)
        , offsetof(WebKit::ProvisionalFrameCreationParameters, frameIDBeforeProvisionalNavigation)
        , offsetof(WebKit::ProvisionalFrameCreationParameters, layerHostingContextIdentifier)
        , offsetof(WebKit::ProvisionalFrameCreationParameters, effectiveSandboxFlags)
        , offsetof(WebKit::ProvisionalFrameCreationParameters, scrollingMode)
        , offsetof(WebKit::ProvisionalFrameCreationParameters, initialSize)
    >::value);

    encoder << instance.frameID;
    encoder << instance.frameIDBeforeProvisionalNavigation;
    encoder << instance.layerHostingContextIdentifier;
    encoder << instance.effectiveSandboxFlags;
    encoder << instance.scrollingMode;
    encoder << instance.initialSize;
}

std::optional<WebKit::ProvisionalFrameCreationParameters> ArgumentCoder<WebKit::ProvisionalFrameCreationParameters>::decode(Decoder& decoder)
{
    auto frameID = decoder.decode<WebCore::FrameIdentifier>();
    auto frameIDBeforeProvisionalNavigation = decoder.decode<std::optional<WebCore::FrameIdentifier>>();
    auto layerHostingContextIdentifier = decoder.decode<std::optional<WebCore::LayerHostingContextIdentifier>>();
    auto effectiveSandboxFlags = decoder.decode<WebCore::SandboxFlags>();
    auto scrollingMode = decoder.decode<WebCore::ScrollbarMode>();
    auto initialSize = decoder.decode<std::optional<WebCore::IntSize>>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebKit::ProvisionalFrameCreationParameters {
            WTFMove(*frameID),
            WTFMove(*frameIDBeforeProvisionalNavigation),
            WTFMove(*layerHostingContextIdentifier),
            WTFMove(*effectiveSandboxFlags),
            WTFMove(*scrollingMode),
            WTFMove(*initialSize)
        }
    };
}

#if USE(LIBWEBRTC)
void ArgumentCoder<WebKit::WebRTCNetwork::IPAddress>::encode(Encoder& encoder, const WebKit::WebRTCNetwork::IPAddress& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.value)>, Variant<WebKit::WebRTCNetwork::IPAddress::UnspecifiedFamily, uint32_t, std::array<uint32_t, 4>>>);
    struct ShouldBeSameSizeAsIPAddress : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::WebRTCNetwork::IPAddress>, false> {
        Variant<WebKit::WebRTCNetwork::IPAddress::UnspecifiedFamily, uint32_t, std::array<uint32_t, 4>> value;
    };
    static_assert(sizeof(ShouldBeSameSizeAsIPAddress) == sizeof(WebKit::WebRTCNetwork::IPAddress));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::WebRTCNetwork::IPAddress, value)
    >::value);

    encoder << instance.value;
}

std::optional<WebKit::WebRTCNetwork::IPAddress> ArgumentCoder<WebKit::WebRTCNetwork::IPAddress>::decode(Decoder& decoder)
{
    auto value = decoder.decode<Variant<WebKit::WebRTCNetwork::IPAddress::UnspecifiedFamily, uint32_t, std::array<uint32_t, 4>>>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebKit::WebRTCNetwork::IPAddress {
            WTFMove(*value)
        }
    };
}

#endif

#if USE(LIBWEBRTC)
void ArgumentCoder<WebKit::WebRTCNetwork::IPAddress::UnspecifiedFamily>::encode(Encoder& encoder, const WebKit::WebRTCNetwork::IPAddress::UnspecifiedFamily& instance)
{
    struct ShouldBeSameSizeAsUnspecifiedFamily : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::WebRTCNetwork::IPAddress::UnspecifiedFamily>, false> {
    };
    static_assert(sizeof(ShouldBeSameSizeAsUnspecifiedFamily) == sizeof(WebKit::WebRTCNetwork::IPAddress::UnspecifiedFamily));
    static_assert(MembersInCorrectOrder < 0
    >::value);

}

std::optional<WebKit::WebRTCNetwork::IPAddress::UnspecifiedFamily> ArgumentCoder<WebKit::WebRTCNetwork::IPAddress::UnspecifiedFamily>::decode(Decoder& decoder)
{
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebKit::WebRTCNetwork::IPAddress::UnspecifiedFamily {
        }
    };
}

#endif

#if USE(LIBWEBRTC)
void ArgumentCoder<WebKit::WebRTCNetwork::InterfaceAddress>::encode(Encoder& encoder, const WebKit::WebRTCNetwork::InterfaceAddress& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.address)>, WebKit::WebRTCNetwork::IPAddress>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.ipv6Flags)>, int>);
    struct ShouldBeSameSizeAsInterfaceAddress : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::WebRTCNetwork::InterfaceAddress>, false> {
        WebKit::WebRTCNetwork::IPAddress address;
        int ipv6Flags;
    };
    static_assert(sizeof(ShouldBeSameSizeAsInterfaceAddress) == sizeof(WebKit::WebRTCNetwork::InterfaceAddress));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::WebRTCNetwork::InterfaceAddress, address)
        , offsetof(WebKit::WebRTCNetwork::InterfaceAddress, ipv6Flags)
    >::value);

    encoder << instance.address;
    encoder << instance.ipv6Flags;
}

std::optional<WebKit::WebRTCNetwork::InterfaceAddress> ArgumentCoder<WebKit::WebRTCNetwork::InterfaceAddress>::decode(Decoder& decoder)
{
    auto address = decoder.decode<WebKit::WebRTCNetwork::IPAddress>();
    auto ipv6Flags = decoder.decode<int>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebKit::WebRTCNetwork::InterfaceAddress {
            WTFMove(*address),
            WTFMove(*ipv6Flags)
        }
    };
}

#endif

#if USE(LIBWEBRTC)
void ArgumentCoder<WebKit::WebRTCNetwork::SocketAddress>::encode(Encoder& encoder, const WebKit::WebRTCNetwork::SocketAddress& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.port)>, uint16_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.scopeID)>, int>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.hostname)>, Vector<char>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.ipAddress)>, std::optional<WebKit::WebRTCNetwork::IPAddress>>);
    struct ShouldBeSameSizeAsSocketAddress : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::WebRTCNetwork::SocketAddress>, false> {
        uint16_t port;
        int scopeID;
        Vector<char> hostname;
        std::optional<WebKit::WebRTCNetwork::IPAddress> ipAddress;
    };
    static_assert(sizeof(ShouldBeSameSizeAsSocketAddress) == sizeof(WebKit::WebRTCNetwork::SocketAddress));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::WebRTCNetwork::SocketAddress, port)
        , offsetof(WebKit::WebRTCNetwork::SocketAddress, scopeID)
        , offsetof(WebKit::WebRTCNetwork::SocketAddress, hostname)
        , offsetof(WebKit::WebRTCNetwork::SocketAddress, ipAddress)
    >::value);

    encoder << instance.port;
    encoder << instance.scopeID;
    encoder << instance.hostname;
    encoder << instance.ipAddress;
}

std::optional<WebKit::WebRTCNetwork::SocketAddress> ArgumentCoder<WebKit::WebRTCNetwork::SocketAddress>::decode(Decoder& decoder)
{
    auto port = decoder.decode<uint16_t>();
    auto scopeID = decoder.decode<int>();
    auto hostname = decoder.decode<Vector<char>>();
    auto ipAddress = decoder.decode<std::optional<WebKit::WebRTCNetwork::IPAddress>>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebKit::WebRTCNetwork::SocketAddress {
            WTFMove(*port),
            WTFMove(*scopeID),
            WTFMove(*hostname),
            WTFMove(*ipAddress)
        }
    };
}

#endif

#if USE(LIBWEBRTC)
void ArgumentCoder<WebKit::RTCNetwork>::encode(Encoder& encoder, const WebKit::RTCNetwork& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.name)>, Vector<char>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.description)>, Vector<char>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.prefix)>, WebKit::WebRTCNetwork::IPAddress>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.prefixLength)>, int>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.type)>, int>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.id)>, uint16_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.preference)>, int>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.active)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.ignored)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.scopeID)>, int>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.ips)>, Vector<WebKit::WebRTCNetwork::InterfaceAddress>>);
    struct ShouldBeSameSizeAsRTCNetwork : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::RTCNetwork>, false> {
        Vector<char> name;
        Vector<char> description;
        WebKit::WebRTCNetwork::IPAddress prefix;
        int prefixLength;
        int type;
        uint16_t id;
        int preference;
        bool active;
        bool ignored;
        int scopeID;
        Vector<WebKit::WebRTCNetwork::InterfaceAddress> ips;
    };
    static_assert(sizeof(ShouldBeSameSizeAsRTCNetwork) == sizeof(WebKit::RTCNetwork));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::RTCNetwork, name)
        , offsetof(WebKit::RTCNetwork, description)
        , offsetof(WebKit::RTCNetwork, prefix)
        , offsetof(WebKit::RTCNetwork, prefixLength)
        , offsetof(WebKit::RTCNetwork, type)
        , offsetof(WebKit::RTCNetwork, id)
        , offsetof(WebKit::RTCNetwork, preference)
        , offsetof(WebKit::RTCNetwork, active)
        , offsetof(WebKit::RTCNetwork, ignored)
        , offsetof(WebKit::RTCNetwork, scopeID)
        , offsetof(WebKit::RTCNetwork, ips)
    >::value);

    encoder << instance.name;
    encoder << instance.description;
    encoder << instance.prefix;
    encoder << instance.prefixLength;
    encoder << instance.type;
    encoder << instance.id;
    encoder << instance.preference;
    encoder << instance.active;
    encoder << instance.ignored;
    encoder << instance.scopeID;
    encoder << instance.ips;
}

std::optional<WebKit::RTCNetwork> ArgumentCoder<WebKit::RTCNetwork>::decode(Decoder& decoder)
{
    auto name = decoder.decode<Vector<char>>();
    auto description = decoder.decode<Vector<char>>();
    auto prefix = decoder.decode<WebKit::WebRTCNetwork::IPAddress>();
    auto prefixLength = decoder.decode<int>();
    auto type = decoder.decode<int>();
    auto id = decoder.decode<uint16_t>();
    auto preference = decoder.decode<int>();
    auto active = decoder.decode<bool>();
    auto ignored = decoder.decode<bool>();
    auto scopeID = decoder.decode<int>();
    auto ips = decoder.decode<Vector<WebKit::WebRTCNetwork::InterfaceAddress>>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebKit::RTCNetwork {
            WTFMove(*name),
            WTFMove(*description),
            WTFMove(*prefix),
            WTFMove(*prefixLength),
            WTFMove(*type),
            WTFMove(*id),
            WTFMove(*preference),
            WTFMove(*active),
            WTFMove(*ignored),
            WTFMove(*scopeID),
            WTFMove(*ips)
        }
    };
}

#endif

#if (USE(LIBWEBRTC)) && (USE(LIBWEBRTC) && PLATFORM(COCOA))
void ArgumentCoder<webrtc::WebKitEncodedFrameInfo>::encode(Encoder& encoder, const webrtc::WebKitEncodedFrameInfo& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.width)>, uint32_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.height)>, uint32_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.timeStamp)>, int64_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.duration)>, std::optional<uint64_t>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.ntpTimeMS)>, int64_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.captureTimeMS)>, int64_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.frameType)>, webrtc::VideoFrameType>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.rotation)>, webrtc::WebKitEncodedVideoRotation>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.contentType)>, webrtc::VideoContentType>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.completeFrame)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.qp)>, int>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.temporalIndex)>, int>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.timing)>, webrtc::WebKitEncodedFrameTiming>);
    struct ShouldBeSameSizeAsWebKitEncodedFrameInfo : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<webrtc::WebKitEncodedFrameInfo>, false> {
        uint32_t width;
        uint32_t height;
        int64_t timeStamp;
        std::optional<uint64_t> duration;
        int64_t ntpTimeMS;
        int64_t captureTimeMS;
        webrtc::VideoFrameType frameType;
        webrtc::WebKitEncodedVideoRotation rotation;
        webrtc::VideoContentType contentType;
        bool completeFrame;
        int qp;
        int temporalIndex;
        webrtc::WebKitEncodedFrameTiming timing;
    };
    static_assert(sizeof(ShouldBeSameSizeAsWebKitEncodedFrameInfo) == sizeof(webrtc::WebKitEncodedFrameInfo));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(webrtc::WebKitEncodedFrameInfo, width)
        , offsetof(webrtc::WebKitEncodedFrameInfo, height)
        , offsetof(webrtc::WebKitEncodedFrameInfo, timeStamp)
        , offsetof(webrtc::WebKitEncodedFrameInfo, duration)
        , offsetof(webrtc::WebKitEncodedFrameInfo, ntpTimeMS)
        , offsetof(webrtc::WebKitEncodedFrameInfo, captureTimeMS)
        , offsetof(webrtc::WebKitEncodedFrameInfo, frameType)
        , offsetof(webrtc::WebKitEncodedFrameInfo, rotation)
        , offsetof(webrtc::WebKitEncodedFrameInfo, contentType)
        , offsetof(webrtc::WebKitEncodedFrameInfo, completeFrame)
        , offsetof(webrtc::WebKitEncodedFrameInfo, qp)
        , offsetof(webrtc::WebKitEncodedFrameInfo, temporalIndex)
        , offsetof(webrtc::WebKitEncodedFrameInfo, timing)
    >::value);

    encoder << instance.width;
    encoder << instance.height;
    encoder << instance.timeStamp;
    encoder << instance.duration;
    encoder << instance.ntpTimeMS;
    encoder << instance.captureTimeMS;
    encoder << instance.frameType;
    encoder << instance.rotation;
    encoder << instance.contentType;
    encoder << instance.completeFrame;
    encoder << instance.qp;
    encoder << instance.temporalIndex;
    encoder << instance.timing;
}

std::optional<webrtc::WebKitEncodedFrameInfo> ArgumentCoder<webrtc::WebKitEncodedFrameInfo>::decode(Decoder& decoder)
{
    auto width = decoder.decode<uint32_t>();
    auto height = decoder.decode<uint32_t>();
    auto timeStamp = decoder.decode<int64_t>();
    auto duration = decoder.decode<std::optional<uint64_t>>();
    auto ntpTimeMS = decoder.decode<int64_t>();
    auto captureTimeMS = decoder.decode<int64_t>();
    auto frameType = decoder.decode<webrtc::VideoFrameType>();
    auto rotation = decoder.decode<webrtc::WebKitEncodedVideoRotation>();
    auto contentType = decoder.decode<webrtc::VideoContentType>();
    auto completeFrame = decoder.decode<bool>();
    auto qp = decoder.decode<int>();
    auto temporalIndex = decoder.decode<int>();
    auto timing = decoder.decode<webrtc::WebKitEncodedFrameTiming>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        webrtc::WebKitEncodedFrameInfo {
            WTFMove(*width),
            WTFMove(*height),
            WTFMove(*timeStamp),
            WTFMove(*duration),
            WTFMove(*ntpTimeMS),
            WTFMove(*captureTimeMS),
            WTFMove(*frameType),
            WTFMove(*rotation),
            WTFMove(*contentType),
            WTFMove(*completeFrame),
            WTFMove(*qp),
            WTFMove(*temporalIndex),
            WTFMove(*timing)
        }
    };
}

#endif

#if (USE(LIBWEBRTC)) && (USE(LIBWEBRTC) && PLATFORM(COCOA))
void ArgumentCoder<webrtc::EncodedImage::Timing>::encode(Encoder& encoder, const webrtc::EncodedImage::Timing& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.flags)>, uint8_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.encode_start_ms)>, int64_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.encode_finish_ms)>, int64_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.packetization_finish_ms)>, int64_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.pacer_exit_ms)>, int64_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.network_timestamp_ms)>, int64_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.network2_timestamp_ms)>, int64_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.receive_start_ms)>, int64_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.receive_finish_ms)>, int64_t>);
    struct ShouldBeSameSizeAsTiming : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<webrtc::EncodedImage::Timing>, false> {
        uint8_t flags;
        int64_t encode_start_ms;
        int64_t encode_finish_ms;
        int64_t packetization_finish_ms;
        int64_t pacer_exit_ms;
        int64_t network_timestamp_ms;
        int64_t network2_timestamp_ms;
        int64_t receive_start_ms;
        int64_t receive_finish_ms;
    };
    static_assert(sizeof(ShouldBeSameSizeAsTiming) == sizeof(webrtc::EncodedImage::Timing));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(webrtc::EncodedImage::Timing, flags)
        , offsetof(webrtc::EncodedImage::Timing, encode_start_ms)
        , offsetof(webrtc::EncodedImage::Timing, encode_finish_ms)
        , offsetof(webrtc::EncodedImage::Timing, packetization_finish_ms)
        , offsetof(webrtc::EncodedImage::Timing, pacer_exit_ms)
        , offsetof(webrtc::EncodedImage::Timing, network_timestamp_ms)
        , offsetof(webrtc::EncodedImage::Timing, network2_timestamp_ms)
        , offsetof(webrtc::EncodedImage::Timing, receive_start_ms)
        , offsetof(webrtc::EncodedImage::Timing, receive_finish_ms)
    >::value);

    encoder << instance.flags;
    encoder << instance.encode_start_ms;
    encoder << instance.encode_finish_ms;
    encoder << instance.packetization_finish_ms;
    encoder << instance.pacer_exit_ms;
    encoder << instance.network_timestamp_ms;
    encoder << instance.network2_timestamp_ms;
    encoder << instance.receive_start_ms;
    encoder << instance.receive_finish_ms;
}

std::optional<webrtc::EncodedImage::Timing> ArgumentCoder<webrtc::EncodedImage::Timing>::decode(Decoder& decoder)
{
    auto flags = decoder.decode<uint8_t>();
    auto encode_start_ms = decoder.decode<int64_t>();
    auto encode_finish_ms = decoder.decode<int64_t>();
    auto packetization_finish_ms = decoder.decode<int64_t>();
    auto pacer_exit_ms = decoder.decode<int64_t>();
    auto network_timestamp_ms = decoder.decode<int64_t>();
    auto network2_timestamp_ms = decoder.decode<int64_t>();
    auto receive_start_ms = decoder.decode<int64_t>();
    auto receive_finish_ms = decoder.decode<int64_t>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        webrtc::EncodedImage::Timing {
            WTFMove(*flags),
            WTFMove(*encode_start_ms),
            WTFMove(*encode_finish_ms),
            WTFMove(*packetization_finish_ms),
            WTFMove(*pacer_exit_ms),
            WTFMove(*network_timestamp_ms),
            WTFMove(*network2_timestamp_ms),
            WTFMove(*receive_start_ms),
            WTFMove(*receive_finish_ms)
        }
    };
}

#endif

#if USE(LIBWEBRTC)
void ArgumentCoder<WebKit::RTCPacketOptions::SerializableData>::encode(Encoder& encoder, const WebKit::RTCPacketOptions::SerializableData& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.dscp)>, WebKit::RTCPacketOptions::DifferentiatedServicesCodePoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.packetId)>, int32_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.rtpSendtimeExtensionId)>, int>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.srtpAuthTagLength)>, int64_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.srtpAuthKey)>, std::span<const char>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.srtpPacketIndex)>, int64_t>);
    struct ShouldBeSameSizeAsSerializableData : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::RTCPacketOptions::SerializableData>, false> {
        WebKit::RTCPacketOptions::DifferentiatedServicesCodePoint dscp;
        int32_t packetId;
        int rtpSendtimeExtensionId;
        int64_t srtpAuthTagLength;
        std::span<const char> srtpAuthKey;
        int64_t srtpPacketIndex;
    };
    static_assert(sizeof(ShouldBeSameSizeAsSerializableData) == sizeof(WebKit::RTCPacketOptions::SerializableData));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::RTCPacketOptions::SerializableData, dscp)
        , offsetof(WebKit::RTCPacketOptions::SerializableData, packetId)
        , offsetof(WebKit::RTCPacketOptions::SerializableData, rtpSendtimeExtensionId)
        , offsetof(WebKit::RTCPacketOptions::SerializableData, srtpAuthTagLength)
        , offsetof(WebKit::RTCPacketOptions::SerializableData, srtpAuthKey)
        , offsetof(WebKit::RTCPacketOptions::SerializableData, srtpPacketIndex)
    >::value);

    encoder << instance.dscp;
    encoder << instance.packetId;
    encoder << instance.rtpSendtimeExtensionId;
    encoder << instance.srtpAuthTagLength;
    encoder << instance.srtpAuthKey;
    encoder << instance.srtpPacketIndex;
}

std::optional<WebKit::RTCPacketOptions::SerializableData> ArgumentCoder<WebKit::RTCPacketOptions::SerializableData>::decode(Decoder& decoder)
{
    auto dscp = decoder.decode<WebKit::RTCPacketOptions::DifferentiatedServicesCodePoint>();
    auto packetId = decoder.decode<int32_t>();
    auto rtpSendtimeExtensionId = decoder.decode<int>();
    auto srtpAuthTagLength = decoder.decode<int64_t>();
    auto srtpAuthKey = decoder.decode<std::span<const char>>();
    auto srtpPacketIndex = decoder.decode<int64_t>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebKit::RTCPacketOptions::SerializableData {
            WTFMove(*dscp),
            WTFMove(*packetId),
            WTFMove(*rtpSendtimeExtensionId),
            WTFMove(*srtpAuthTagLength),
            WTFMove(*srtpAuthKey),
            WTFMove(*srtpPacketIndex)
        }
    };
}

#endif

#if USE(LIBWEBRTC)
void ArgumentCoder<WebKit::RTCPacketOptions>::encode(Encoder& encoder, const WebKit::RTCPacketOptions& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.serializableData())>, WebKit::RTCPacketOptions::SerializableData>);

    encoder << instance.serializableData();
}

std::optional<WebKit::RTCPacketOptions> ArgumentCoder<WebKit::RTCPacketOptions>::decode(Decoder& decoder)
{
    auto serializableData = decoder.decode<WebKit::RTCPacketOptions::SerializableData>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebKit::RTCPacketOptions {
            WTFMove(*serializableData)
        }
    };
}

#endif

#if ENABLE(TOUCH_EVENTS)
void ArgumentCoder<WebKit::RemoteWebTouchEvent>::encode(Encoder& encoder, const WebKit::RemoteWebTouchEvent& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.targetFrameID)>, WebCore::FrameIdentifier>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.transformedEvent)>, WebKit::WebTouchEvent>);
    struct ShouldBeSameSizeAsRemoteWebTouchEvent : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::RemoteWebTouchEvent>, false> {
        WebCore::FrameIdentifier targetFrameID;
        WebKit::WebTouchEvent transformedEvent;
    };
    static_assert(sizeof(ShouldBeSameSizeAsRemoteWebTouchEvent) == sizeof(WebKit::RemoteWebTouchEvent));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::RemoteWebTouchEvent, targetFrameID)
        , offsetof(WebKit::RemoteWebTouchEvent, transformedEvent)
    >::value);

    encoder << instance.targetFrameID;
    encoder << instance.transformedEvent;
}

std::optional<WebKit::RemoteWebTouchEvent> ArgumentCoder<WebKit::RemoteWebTouchEvent>::decode(Decoder& decoder)
{
    auto targetFrameID = decoder.decode<WebCore::FrameIdentifier>();
    auto transformedEvent = decoder.decode<WebKit::WebTouchEvent>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebKit::RemoteWebTouchEvent {
            WTFMove(*targetFrameID),
            WTFMove(*transformedEvent)
        }
    };
}

#endif

void ArgumentCoder<WebKit::RemoteWorkerInitializationData>::encode(Encoder& encoder, const WebKit::RemoteWorkerInitializationData& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.userContentControllerIdentifier)>, WebKit::UserContentControllerIdentifier>);
#if ENABLE(CONTENT_EXTENSIONS)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.contentRuleLists)>, Vector<std::pair<WebKit::WebCompiledContentRuleListData, URL>>>);
#endif
    struct ShouldBeSameSizeAsRemoteWorkerInitializationData : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::RemoteWorkerInitializationData>, false> {
        WebKit::UserContentControllerIdentifier userContentControllerIdentifier;
#if ENABLE(CONTENT_EXTENSIONS)
        Vector<std::pair<WebKit::WebCompiledContentRuleListData, URL>> contentRuleLists;
#endif
    };
    static_assert(sizeof(ShouldBeSameSizeAsRemoteWorkerInitializationData) == sizeof(WebKit::RemoteWorkerInitializationData));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::RemoteWorkerInitializationData, userContentControllerIdentifier)
#if ENABLE(CONTENT_EXTENSIONS)
        , offsetof(WebKit::RemoteWorkerInitializationData, contentRuleLists)
#endif
    >::value);

    encoder << instance.userContentControllerIdentifier;
#if ENABLE(CONTENT_EXTENSIONS)
    encoder << instance.contentRuleLists;
#endif
}

std::optional<WebKit::RemoteWorkerInitializationData> ArgumentCoder<WebKit::RemoteWorkerInitializationData>::decode(Decoder& decoder)
{
    auto userContentControllerIdentifier = decoder.decode<WebKit::UserContentControllerIdentifier>();
#if ENABLE(CONTENT_EXTENSIONS)
    auto contentRuleLists = decoder.decode<Vector<std::pair<WebKit::WebCompiledContentRuleListData, URL>>>();
#endif
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebKit::RemoteWorkerInitializationData {
            WTFMove(*userContentControllerIdentifier),
#if ENABLE(CONTENT_EXTENSIONS)
            WTFMove(*contentRuleLists)
#endif
        }
    };
}

void ArgumentCoder<WebKit::ResourceLoadInfo>::encode(Encoder& encoder, const WebKit::ResourceLoadInfo& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.resourceLoadID)>, WebKit::NetworkResourceLoadIdentifier>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.frameID)>, std::optional<WebCore::FrameIdentifier>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.parentFrameID)>, std::optional<WebCore::FrameIdentifier>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.documentID)>, Markable<WTF::UUID>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.originalURL)>, URL>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.originalHTTPMethod)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.eventTimestamp)>, WallTime>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.loadedFromCache)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.type)>, WebKit::ResourceLoadInfo::Type>);
    struct ShouldBeSameSizeAsResourceLoadInfo : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::ResourceLoadInfo>, false> {
        WebKit::NetworkResourceLoadIdentifier resourceLoadID;
        std::optional<WebCore::FrameIdentifier> frameID;
        std::optional<WebCore::FrameIdentifier> parentFrameID;
        Markable<WTF::UUID> documentID;
        URL originalURL;
        String originalHTTPMethod;
        WallTime eventTimestamp;
        bool loadedFromCache;
        WebKit::ResourceLoadInfo::Type type;
    };
    static_assert(sizeof(ShouldBeSameSizeAsResourceLoadInfo) == sizeof(WebKit::ResourceLoadInfo));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::ResourceLoadInfo, resourceLoadID)
        , offsetof(WebKit::ResourceLoadInfo, frameID)
        , offsetof(WebKit::ResourceLoadInfo, parentFrameID)
        , offsetof(WebKit::ResourceLoadInfo, documentID)
        , offsetof(WebKit::ResourceLoadInfo, originalURL)
        , offsetof(WebKit::ResourceLoadInfo, originalHTTPMethod)
        , offsetof(WebKit::ResourceLoadInfo, eventTimestamp)
        , offsetof(WebKit::ResourceLoadInfo, loadedFromCache)
        , offsetof(WebKit::ResourceLoadInfo, type)
    >::value);

    encoder << instance.resourceLoadID;
    encoder << instance.frameID;
    encoder << instance.parentFrameID;
    encoder << instance.documentID;
    encoder << instance.originalURL;
    encoder << instance.originalHTTPMethod;
    encoder << instance.eventTimestamp;
    encoder << instance.loadedFromCache;
    encoder << instance.type;
}

std::optional<WebKit::ResourceLoadInfo> ArgumentCoder<WebKit::ResourceLoadInfo>::decode(Decoder& decoder)
{
    auto resourceLoadID = decoder.decode<WebKit::NetworkResourceLoadIdentifier>();
    auto frameID = decoder.decode<std::optional<WebCore::FrameIdentifier>>();
    auto parentFrameID = decoder.decode<std::optional<WebCore::FrameIdentifier>>();
    auto documentID = decoder.decode<Markable<WTF::UUID>>();
    auto originalURL = decoder.decode<URL>();
    auto originalHTTPMethod = decoder.decode<String>();
    auto eventTimestamp = decoder.decode<WallTime>();
    auto loadedFromCache = decoder.decode<bool>();
    auto type = decoder.decode<WebKit::ResourceLoadInfo::Type>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebKit::ResourceLoadInfo {
            WTFMove(*resourceLoadID),
            WTFMove(*frameID),
            WTFMove(*parentFrameID),
            WTFMove(*documentID),
            WTFMove(*originalURL),
            WTFMove(*originalHTTPMethod),
            WTFMove(*eventTimestamp),
            WTFMove(*loadedFromCache),
            WTFMove(*type)
        }
    };
}

void ArgumentCoder<WebKit::ResourceLoadStatisticsParameters>::encode(Encoder& encoder, WebKit::ResourceLoadStatisticsParameters&& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.directory)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.directoryExtensionHandle)>, WebKit::SandboxExtensionHandle>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.enabled)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.enableLogTestingEvent)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.shouldIncludeLocalhost)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.enableDebugMode)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.thirdPartyCookieBlockingMode)>, WebCore::ThirdPartyCookieBlockingMode>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.sameSiteStrictEnforcementEnabled)>, WebCore::SameSiteStrictEnforcementEnabled>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.firstPartyWebsiteDataRemovalMode)>, WebCore::FirstPartyWebsiteDataRemovalMode>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.standaloneApplicationDomain)>, WebCore::RegistrableDomain>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.appBoundDomains)>, HashSet<WebCore::RegistrableDomain>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.managedDomains)>, HashSet<WebCore::RegistrableDomain>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.persistedDomains)>, HashSet<WebCore::RegistrableDomain>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.manualPrevalentResource)>, WebCore::RegistrableDomain>);
    struct ShouldBeSameSizeAsResourceLoadStatisticsParameters : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::ResourceLoadStatisticsParameters>, false> {
        String directory;
        WebKit::SandboxExtensionHandle directoryExtensionHandle;
        bool enabled;
        bool enableLogTestingEvent;
        bool shouldIncludeLocalhost;
        bool enableDebugMode;
        WebCore::ThirdPartyCookieBlockingMode thirdPartyCookieBlockingMode;
        WebCore::SameSiteStrictEnforcementEnabled sameSiteStrictEnforcementEnabled;
        WebCore::FirstPartyWebsiteDataRemovalMode firstPartyWebsiteDataRemovalMode;
        WebCore::RegistrableDomain standaloneApplicationDomain;
        HashSet<WebCore::RegistrableDomain> appBoundDomains;
        HashSet<WebCore::RegistrableDomain> managedDomains;
        HashSet<WebCore::RegistrableDomain> persistedDomains;
        WebCore::RegistrableDomain manualPrevalentResource;
    };
    static_assert(sizeof(ShouldBeSameSizeAsResourceLoadStatisticsParameters) == sizeof(WebKit::ResourceLoadStatisticsParameters));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::ResourceLoadStatisticsParameters, directory)
        , offsetof(WebKit::ResourceLoadStatisticsParameters, directoryExtensionHandle)
        , offsetof(WebKit::ResourceLoadStatisticsParameters, enabled)
        , offsetof(WebKit::ResourceLoadStatisticsParameters, enableLogTestingEvent)
        , offsetof(WebKit::ResourceLoadStatisticsParameters, shouldIncludeLocalhost)
        , offsetof(WebKit::ResourceLoadStatisticsParameters, enableDebugMode)
        , offsetof(WebKit::ResourceLoadStatisticsParameters, thirdPartyCookieBlockingMode)
        , offsetof(WebKit::ResourceLoadStatisticsParameters, sameSiteStrictEnforcementEnabled)
        , offsetof(WebKit::ResourceLoadStatisticsParameters, firstPartyWebsiteDataRemovalMode)
        , offsetof(WebKit::ResourceLoadStatisticsParameters, standaloneApplicationDomain)
        , offsetof(WebKit::ResourceLoadStatisticsParameters, appBoundDomains)
        , offsetof(WebKit::ResourceLoadStatisticsParameters, managedDomains)
        , offsetof(WebKit::ResourceLoadStatisticsParameters, persistedDomains)
        , offsetof(WebKit::ResourceLoadStatisticsParameters, manualPrevalentResource)
    >::value);

    encoder << WTFMove(instance.directory);
    encoder << WTFMove(instance.directoryExtensionHandle);
    encoder << WTFMove(instance.enabled);
    encoder << WTFMove(instance.enableLogTestingEvent);
    encoder << WTFMove(instance.shouldIncludeLocalhost);
    encoder << WTFMove(instance.enableDebugMode);
    encoder << WTFMove(instance.thirdPartyCookieBlockingMode);
    encoder << WTFMove(instance.sameSiteStrictEnforcementEnabled);
    encoder << WTFMove(instance.firstPartyWebsiteDataRemovalMode);
    encoder << WTFMove(instance.standaloneApplicationDomain);
    encoder << WTFMove(instance.appBoundDomains);
    encoder << WTFMove(instance.managedDomains);
    encoder << WTFMove(instance.persistedDomains);
    encoder << WTFMove(instance.manualPrevalentResource);
}

std::optional<WebKit::ResourceLoadStatisticsParameters> ArgumentCoder<WebKit::ResourceLoadStatisticsParameters>::decode(Decoder& decoder)
{
    auto directory = decoder.decode<String>();
    auto directoryExtensionHandle = decoder.decode<WebKit::SandboxExtensionHandle>();
    auto enabled = decoder.decode<bool>();
    auto enableLogTestingEvent = decoder.decode<bool>();
    auto shouldIncludeLocalhost = decoder.decode<bool>();
    auto enableDebugMode = decoder.decode<bool>();
    auto thirdPartyCookieBlockingMode = decoder.decode<WebCore::ThirdPartyCookieBlockingMode>();
    auto sameSiteStrictEnforcementEnabled = decoder.decode<WebCore::SameSiteStrictEnforcementEnabled>();
    auto firstPartyWebsiteDataRemovalMode = decoder.decode<WebCore::FirstPartyWebsiteDataRemovalMode>();
    auto standaloneApplicationDomain = decoder.decode<WebCore::RegistrableDomain>();
    auto appBoundDomains = decoder.decode<HashSet<WebCore::RegistrableDomain>>();
    auto managedDomains = decoder.decode<HashSet<WebCore::RegistrableDomain>>();
    auto persistedDomains = decoder.decode<HashSet<WebCore::RegistrableDomain>>();
    auto manualPrevalentResource = decoder.decode<WebCore::RegistrableDomain>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebKit::ResourceLoadStatisticsParameters {
            WTFMove(*directory),
            WTFMove(*directoryExtensionHandle),
            WTFMove(*enabled),
            WTFMove(*enableLogTestingEvent),
            WTFMove(*shouldIncludeLocalhost),
            WTFMove(*enableDebugMode),
            WTFMove(*thirdPartyCookieBlockingMode),
            WTFMove(*sameSiteStrictEnforcementEnabled),
            WTFMove(*firstPartyWebsiteDataRemovalMode),
            WTFMove(*standaloneApplicationDomain),
            WTFMove(*appBoundDomains),
            WTFMove(*managedDomains),
            WTFMove(*persistedDomains),
            WTFMove(*manualPrevalentResource)
        }
    };
}

void ArgumentCoder<WebKit::SandboxExtensionHandle>::encode(Encoder& encoder, WebKit::SandboxExtensionHandle&& instance)
{
#if ENABLE(SANDBOX_EXTENSIONS)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.takeImpl())>, std::unique_ptr<WebKit::SandboxExtensionImpl>>);
#endif

#if ENABLE(SANDBOX_EXTENSIONS)
    encoder << instance.takeImpl();
#endif
}

std::optional<WebKit::SandboxExtensionHandle> ArgumentCoder<WebKit::SandboxExtensionHandle>::decode(Decoder& decoder)
{
#if ENABLE(SANDBOX_EXTENSIONS)
    auto takeImpl = decoder.decode<std::unique_ptr<WebKit::SandboxExtensionImpl>>();
#endif
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebKit::SandboxExtensionHandle {
#if ENABLE(SANDBOX_EXTENSIONS)
            WTFMove(*takeImpl)
#endif
        }
    };
}

#if ENABLE(SANDBOX_EXTENSIONS)
void ArgumentCoder<WebKit::SandboxExtensionImpl>::encode(Encoder& encoder, WebKit::SandboxExtensionImpl&& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.getSerializedFormat())>, std::span<const uint8_t>>);

    encoder << instance.getSerializedFormat();
}

std::optional<WebKit::SandboxExtensionImpl> ArgumentCoder<WebKit::SandboxExtensionImpl>::decode(Decoder& decoder)
{
    auto getSerializedFormat = decoder.decode<std::span<const uint8_t>>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebKit::SandboxExtensionImpl {
            WTFMove(*getSerializedFormat)
        }
    };
}

#endif

void ArgumentCoder<WebKit::ScriptTrackingPrivacyHost>::encode(Encoder& encoder, const WebKit::ScriptTrackingPrivacyHost& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.hostName)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.allowedCategories)>, OptionSet<WebCore::ScriptTrackingPrivacyFlag>>);
    struct ShouldBeSameSizeAsScriptTrackingPrivacyHost : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::ScriptTrackingPrivacyHost>, false> {
        String hostName;
        OptionSet<WebCore::ScriptTrackingPrivacyFlag> allowedCategories;
    };
    static_assert(sizeof(ShouldBeSameSizeAsScriptTrackingPrivacyHost) == sizeof(WebKit::ScriptTrackingPrivacyHost));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::ScriptTrackingPrivacyHost, hostName)
        , offsetof(WebKit::ScriptTrackingPrivacyHost, allowedCategories)
    >::value);

    encoder << instance.hostName;
    encoder << instance.allowedCategories;
}

std::optional<WebKit::ScriptTrackingPrivacyHost> ArgumentCoder<WebKit::ScriptTrackingPrivacyHost>::decode(Decoder& decoder)
{
    auto hostName = decoder.decode<String>();
    auto allowedCategories = decoder.decode<OptionSet<WebCore::ScriptTrackingPrivacyFlag>>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebKit::ScriptTrackingPrivacyHost {
            WTFMove(*hostName),
            WTFMove(*allowedCategories)
        }
    };
}

void ArgumentCoder<WebKit::ScriptTrackingPrivacyRules>::encode(Encoder& encoder, const WebKit::ScriptTrackingPrivacyRules& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.thirdPartyHosts)>, Vector<WebKit::ScriptTrackingPrivacyHost>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.thirdPartyTopDomains)>, Vector<WebKit::ScriptTrackingPrivacyHost>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.firstPartyHosts)>, Vector<WebKit::ScriptTrackingPrivacyHost>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.firstPartyTopDomains)>, Vector<WebKit::ScriptTrackingPrivacyHost>>);
    struct ShouldBeSameSizeAsScriptTrackingPrivacyRules : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::ScriptTrackingPrivacyRules>, false> {
        Vector<WebKit::ScriptTrackingPrivacyHost> thirdPartyHosts;
        Vector<WebKit::ScriptTrackingPrivacyHost> thirdPartyTopDomains;
        Vector<WebKit::ScriptTrackingPrivacyHost> firstPartyHosts;
        Vector<WebKit::ScriptTrackingPrivacyHost> firstPartyTopDomains;
    };
    static_assert(sizeof(ShouldBeSameSizeAsScriptTrackingPrivacyRules) == sizeof(WebKit::ScriptTrackingPrivacyRules));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::ScriptTrackingPrivacyRules, thirdPartyHosts)
        , offsetof(WebKit::ScriptTrackingPrivacyRules, thirdPartyTopDomains)
        , offsetof(WebKit::ScriptTrackingPrivacyRules, firstPartyHosts)
        , offsetof(WebKit::ScriptTrackingPrivacyRules, firstPartyTopDomains)
    >::value);

    encoder << instance.thirdPartyHosts;
    encoder << instance.thirdPartyTopDomains;
    encoder << instance.firstPartyHosts;
    encoder << instance.firstPartyTopDomains;
}

std::optional<WebKit::ScriptTrackingPrivacyRules> ArgumentCoder<WebKit::ScriptTrackingPrivacyRules>::decode(Decoder& decoder)
{
    auto thirdPartyHosts = decoder.decode<Vector<WebKit::ScriptTrackingPrivacyHost>>();
    auto thirdPartyTopDomains = decoder.decode<Vector<WebKit::ScriptTrackingPrivacyHost>>();
    auto firstPartyHosts = decoder.decode<Vector<WebKit::ScriptTrackingPrivacyHost>>();
    auto firstPartyTopDomains = decoder.decode<Vector<WebKit::ScriptTrackingPrivacyHost>>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebKit::ScriptTrackingPrivacyRules {
            WTFMove(*thirdPartyHosts),
            WTFMove(*thirdPartyTopDomains),
            WTFMove(*firstPartyHosts),
            WTFMove(*firstPartyTopDomains)
        }
    };
}

#if ENABLE(MOMENTUM_EVENT_DISPATCHER)
void ArgumentCoder<WebKit::ScrollingAccelerationCurve>::encode(Encoder& encoder, const WebKit::ScrollingAccelerationCurve& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.gainLinear())>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.gainParabolic())>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.gainCubic())>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.gainQuartic())>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.tangentSpeedLinear())>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.tangentSpeedParabolicRoot())>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.resolution())>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.frameRate())>, float>);

    encoder << instance.gainLinear();
    encoder << instance.gainParabolic();
    encoder << instance.gainCubic();
    encoder << instance.gainQuartic();
    encoder << instance.tangentSpeedLinear();
    encoder << instance.tangentSpeedParabolicRoot();
    encoder << instance.resolution();
    encoder << instance.frameRate();
}

std::optional<WebKit::ScrollingAccelerationCurve> ArgumentCoder<WebKit::ScrollingAccelerationCurve>::decode(Decoder& decoder)
{
    auto gainLinear = decoder.decode<float>();
    auto gainParabolic = decoder.decode<float>();
    auto gainCubic = decoder.decode<float>();
    auto gainQuartic = decoder.decode<float>();
    auto tangentSpeedLinear = decoder.decode<float>();
    auto tangentSpeedParabolicRoot = decoder.decode<float>();
    auto resolution = decoder.decode<float>();
    auto frameRate = decoder.decode<float>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebKit::ScrollingAccelerationCurve {
            WTFMove(*gainLinear),
            WTFMove(*gainParabolic),
            WTFMove(*gainCubic),
            WTFMove(*gainQuartic),
            WTFMove(*tangentSpeedLinear),
            WTFMove(*tangentSpeedParabolicRoot),
            WTFMove(*resolution),
            WTFMove(*frameRate)
        }
    };
}

#endif

void ArgumentCoder<WebCore::SerializedNode::QualifiedName>::encode(Encoder& encoder, const WebCore::SerializedNode::QualifiedName& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.prefix)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.localName)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.namespaceURI)>, String>);
    struct ShouldBeSameSizeAsQualifiedName : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::SerializedNode::QualifiedName>, false> {
        String prefix;
        String localName;
        String namespaceURI;
    };
    static_assert(sizeof(ShouldBeSameSizeAsQualifiedName) == sizeof(WebCore::SerializedNode::QualifiedName));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::SerializedNode::QualifiedName, prefix)
        , offsetof(WebCore::SerializedNode::QualifiedName, localName)
        , offsetof(WebCore::SerializedNode::QualifiedName, namespaceURI)
    >::value);

    encoder << instance.prefix;
    encoder << instance.localName;
    encoder << instance.namespaceURI;
}

std::optional<WebCore::SerializedNode::QualifiedName> ArgumentCoder<WebCore::SerializedNode::QualifiedName>::decode(Decoder& decoder)
{
    auto prefix = decoder.decode<String>();
    auto localName = decoder.decode<String>();
    auto namespaceURI = decoder.decode<String>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::SerializedNode::QualifiedName {
            WTFMove(*prefix),
            WTFMove(*localName),
            WTFMove(*namespaceURI)
        }
    };
}

void ArgumentCoder<WebCore::SerializedNode::ContainerNode>::encode(Encoder& encoder, const WebCore::SerializedNode::ContainerNode& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.children)>, Vector<WebCore::SerializedNode>>);
    struct ShouldBeSameSizeAsContainerNode : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::SerializedNode::ContainerNode>, false> {
        Vector<WebCore::SerializedNode> children;
    };
    static_assert(sizeof(ShouldBeSameSizeAsContainerNode) == sizeof(WebCore::SerializedNode::ContainerNode));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::SerializedNode::ContainerNode, children)
    >::value);

    encoder << instance.children;
}

std::optional<WebCore::SerializedNode::ContainerNode> ArgumentCoder<WebCore::SerializedNode::ContainerNode>::decode(Decoder& decoder)
{
    auto children = decoder.decode<Vector<WebCore::SerializedNode>>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::SerializedNode::ContainerNode {
            WTFMove(*children)
        }
    };
}

void ArgumentCoder<WebCore::SerializedNode::Attr>::encode(Encoder& encoder, const WebCore::SerializedNode::Attr& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.name)>, WebCore::SerializedNode::QualifiedName>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.value)>, String>);
    struct ShouldBeSameSizeAsAttr : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::SerializedNode::Attr>, false> {
        WebCore::SerializedNode::QualifiedName name;
        String value;
    };
    static_assert(sizeof(ShouldBeSameSizeAsAttr) == sizeof(WebCore::SerializedNode::Attr));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::SerializedNode::Attr, name)
        , offsetof(WebCore::SerializedNode::Attr, value)
    >::value);

    encoder << instance.name;
    encoder << instance.value;
}

std::optional<WebCore::SerializedNode::Attr> ArgumentCoder<WebCore::SerializedNode::Attr>::decode(Decoder& decoder)
{
    auto name = decoder.decode<WebCore::SerializedNode::QualifiedName>();
    auto value = decoder.decode<String>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::SerializedNode::Attr {
            WTFMove(*name),
            WTFMove(*value)
        }
    };
}

void ArgumentCoder<WebCore::SerializedNode::CharacterData>::encode(Encoder& encoder, const WebCore::SerializedNode::CharacterData& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.data)>, String>);
    struct ShouldBeSameSizeAsCharacterData : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::SerializedNode::CharacterData>, false> {
        String data;
    };
    static_assert(sizeof(ShouldBeSameSizeAsCharacterData) == sizeof(WebCore::SerializedNode::CharacterData));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::SerializedNode::CharacterData, data)
    >::value);

    encoder << instance.data;
}

std::optional<WebCore::SerializedNode::CharacterData> ArgumentCoder<WebCore::SerializedNode::CharacterData>::decode(Decoder& decoder)
{
    auto data = decoder.decode<String>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::SerializedNode::CharacterData {
            WTFMove(*data)
        }
    };
}

void ArgumentCoder<WebCore::SerializedNode::Document>::encode(Encoder& encoder, const WebCore::SerializedNode::Document& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.children)>, Vector<WebCore::SerializedNode>>);
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::SerializedNode::ContainerNode, children)
    >::value);

    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.type)>, WebCore::ClonedDocumentType>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.url)>, URL>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.baseURL)>, URL>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.baseURLOverride)>, URL>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.documentURI)>, Variant<String, URL>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.contentType)>, String>);
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::SerializedNode::Document, type)
        , offsetof(WebCore::SerializedNode::Document, url)
        , offsetof(WebCore::SerializedNode::Document, baseURL)
        , offsetof(WebCore::SerializedNode::Document, baseURLOverride)
        , offsetof(WebCore::SerializedNode::Document, documentURI)
        , offsetof(WebCore::SerializedNode::Document, contentType)
    >::value);

    encoder << instance.children;
    encoder << instance.type;
    encoder << instance.url;
    encoder << instance.baseURL;
    encoder << instance.baseURLOverride;
    encoder << instance.documentURI;
    encoder << instance.contentType;
}

std::optional<WebCore::SerializedNode::Document> ArgumentCoder<WebCore::SerializedNode::Document>::decode(Decoder& decoder)
{
    auto children = decoder.decode<Vector<WebCore::SerializedNode>>();
    auto type = decoder.decode<WebCore::ClonedDocumentType>();
    auto url = decoder.decode<URL>();
    auto baseURL = decoder.decode<URL>();
    auto baseURLOverride = decoder.decode<URL>();
    auto documentURI = decoder.decode<Variant<String, URL>>();
    auto contentType = decoder.decode<String>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::SerializedNode::Document {
            WebCore::SerializedNode::ContainerNode {
                WTFMove(*children)
            },
            WTFMove(*type),
            WTFMove(*url),
            WTFMove(*baseURL),
            WTFMove(*baseURLOverride),
            WTFMove(*documentURI),
            WTFMove(*contentType)
        }
    };
}

void ArgumentCoder<WebCore::SerializedNode::DocumentFragment>::encode(Encoder& encoder, const WebCore::SerializedNode::DocumentFragment& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.children)>, Vector<WebCore::SerializedNode>>);
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::SerializedNode::ContainerNode, children)
    >::value);

    static_assert(MembersInCorrectOrder < 0
    >::value);

    encoder << instance.children;
}

std::optional<WebCore::SerializedNode::DocumentFragment> ArgumentCoder<WebCore::SerializedNode::DocumentFragment>::decode(Decoder& decoder)
{
    auto children = decoder.decode<Vector<WebCore::SerializedNode>>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::SerializedNode::DocumentFragment {
            WebCore::SerializedNode::ContainerNode {
                WTFMove(*children)
            }
        }
    };
}

void ArgumentCoder<WebCore::SerializedNode::DocumentType>::encode(Encoder& encoder, const WebCore::SerializedNode::DocumentType& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.name)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.publicId)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.systemId)>, String>);
    struct ShouldBeSameSizeAsDocumentType : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::SerializedNode::DocumentType>, false> {
        String name;
        String publicId;
        String systemId;
    };
    static_assert(sizeof(ShouldBeSameSizeAsDocumentType) == sizeof(WebCore::SerializedNode::DocumentType));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::SerializedNode::DocumentType, name)
        , offsetof(WebCore::SerializedNode::DocumentType, publicId)
        , offsetof(WebCore::SerializedNode::DocumentType, systemId)
    >::value);

    encoder << instance.name;
    encoder << instance.publicId;
    encoder << instance.systemId;
}

std::optional<WebCore::SerializedNode::DocumentType> ArgumentCoder<WebCore::SerializedNode::DocumentType>::decode(Decoder& decoder)
{
    auto name = decoder.decode<String>();
    auto publicId = decoder.decode<String>();
    auto systemId = decoder.decode<String>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::SerializedNode::DocumentType {
            WTFMove(*name),
            WTFMove(*publicId),
            WTFMove(*systemId)
        }
    };
}

void ArgumentCoder<WebCore::SerializedNode::Element::Attribute>::encode(Encoder& encoder, const WebCore::SerializedNode::Element::Attribute& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.name)>, WebCore::SerializedNode::QualifiedName>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.value)>, String>);
    struct ShouldBeSameSizeAsAttribute : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::SerializedNode::Element::Attribute>, false> {
        WebCore::SerializedNode::QualifiedName name;
        String value;
    };
    static_assert(sizeof(ShouldBeSameSizeAsAttribute) == sizeof(WebCore::SerializedNode::Element::Attribute));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::SerializedNode::Element::Attribute, name)
        , offsetof(WebCore::SerializedNode::Element::Attribute, value)
    >::value);

    encoder << instance.name;
    encoder << instance.value;
}

std::optional<WebCore::SerializedNode::Element::Attribute> ArgumentCoder<WebCore::SerializedNode::Element::Attribute>::decode(Decoder& decoder)
{
    auto name = decoder.decode<WebCore::SerializedNode::QualifiedName>();
    auto value = decoder.decode<String>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::SerializedNode::Element::Attribute {
            WTFMove(*name),
            WTFMove(*value)
        }
    };
}

void ArgumentCoder<WebCore::SerializedNode::Element>::encode(Encoder& encoder, const WebCore::SerializedNode::Element& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.children)>, Vector<WebCore::SerializedNode>>);
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::SerializedNode::ContainerNode, children)
    >::value);

    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.name)>, WebCore::SerializedNode::QualifiedName>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.attributes)>, Vector<WebCore::SerializedNode::Element::Attribute>>);
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::SerializedNode::Element, name)
        , offsetof(WebCore::SerializedNode::Element, attributes)
    >::value);

    encoder << instance.children;
    encoder << instance.name;
    encoder << instance.attributes;
}

std::optional<WebCore::SerializedNode::Element> ArgumentCoder<WebCore::SerializedNode::Element>::decode(Decoder& decoder)
{
    auto children = decoder.decode<Vector<WebCore::SerializedNode>>();
    auto name = decoder.decode<WebCore::SerializedNode::QualifiedName>();
    auto attributes = decoder.decode<Vector<WebCore::SerializedNode::Element::Attribute>>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::SerializedNode::Element {
            WebCore::SerializedNode::ContainerNode {
                WTFMove(*children)
            },
            WTFMove(*name),
            WTFMove(*attributes)
        }
    };
}

void ArgumentCoder<WebCore::SerializedNode::Comment>::encode(Encoder& encoder, const WebCore::SerializedNode::Comment& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.data)>, String>);
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::SerializedNode::CharacterData, data)
    >::value);

    static_assert(MembersInCorrectOrder < 0
    >::value);

    encoder << instance.data;
}

std::optional<WebCore::SerializedNode::Comment> ArgumentCoder<WebCore::SerializedNode::Comment>::decode(Decoder& decoder)
{
    auto data = decoder.decode<String>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::SerializedNode::Comment {
            WebCore::SerializedNode::CharacterData {
                WTFMove(*data)
            }
        }
    };
}

void ArgumentCoder<WebCore::SerializedNode::Text>::encode(Encoder& encoder, const WebCore::SerializedNode::Text& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.data)>, String>);
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::SerializedNode::CharacterData, data)
    >::value);

    static_assert(MembersInCorrectOrder < 0
    >::value);

    encoder << instance.data;
}

std::optional<WebCore::SerializedNode::Text> ArgumentCoder<WebCore::SerializedNode::Text>::decode(Decoder& decoder)
{
    auto data = decoder.decode<String>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::SerializedNode::Text {
            WebCore::SerializedNode::CharacterData {
                WTFMove(*data)
            }
        }
    };
}

void ArgumentCoder<WebCore::SerializedNode::CDATASection>::encode(Encoder& encoder, const WebCore::SerializedNode::CDATASection& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.data)>, String>);
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::SerializedNode::CharacterData, data)
    >::value);

    static_assert(MembersInCorrectOrder < 0
    >::value);

    static_assert(MembersInCorrectOrder < 0
    >::value);

    encoder << instance.data;
}

std::optional<WebCore::SerializedNode::CDATASection> ArgumentCoder<WebCore::SerializedNode::CDATASection>::decode(Decoder& decoder)
{
    auto data = decoder.decode<String>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::SerializedNode::CDATASection {
            WebCore::SerializedNode::Text {
                WebCore::SerializedNode::CharacterData {
                    WTFMove(*data)
                }
            }
        }
    };
}

void ArgumentCoder<WebCore::SerializedNode::ProcessingInstruction>::encode(Encoder& encoder, const WebCore::SerializedNode::ProcessingInstruction& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.data)>, String>);
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::SerializedNode::CharacterData, data)
    >::value);

    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.target)>, String>);
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::SerializedNode::ProcessingInstruction, target)
    >::value);

    encoder << instance.data;
    encoder << instance.target;
}

std::optional<WebCore::SerializedNode::ProcessingInstruction> ArgumentCoder<WebCore::SerializedNode::ProcessingInstruction>::decode(Decoder& decoder)
{
    auto data = decoder.decode<String>();
    auto target = decoder.decode<String>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::SerializedNode::ProcessingInstruction {
            WebCore::SerializedNode::CharacterData {
                WTFMove(*data)
            },
            WTFMove(*target)
        }
    };
}

void ArgumentCoder<WebCore::SerializedNode::ShadowRoot>::encode(Encoder& encoder, const WebCore::SerializedNode::ShadowRoot& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.children)>, Vector<WebCore::SerializedNode>>);
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::SerializedNode::ContainerNode, children)
    >::value);

    static_assert(MembersInCorrectOrder < 0
    >::value);

    static_assert(MembersInCorrectOrder < 0
    >::value);

    encoder << instance.children;
}

std::optional<WebCore::SerializedNode::ShadowRoot> ArgumentCoder<WebCore::SerializedNode::ShadowRoot>::decode(Decoder& decoder)
{
    auto children = decoder.decode<Vector<WebCore::SerializedNode>>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::SerializedNode::ShadowRoot {
            WebCore::SerializedNode::DocumentFragment {
                WebCore::SerializedNode::ContainerNode {
                    WTFMove(*children)
                }
            }
        }
    };
}

void ArgumentCoder<WebCore::SerializedNode::HTMLTemplateElement>::encode(Encoder& encoder, const WebCore::SerializedNode::HTMLTemplateElement& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.children)>, Vector<WebCore::SerializedNode>>);
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::SerializedNode::ContainerNode, children)
    >::value);

    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.name)>, WebCore::SerializedNode::QualifiedName>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.attributes)>, Vector<WebCore::SerializedNode::Element::Attribute>>);
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::SerializedNode::Element, name)
        , offsetof(WebCore::SerializedNode::Element, attributes)
    >::value);

    static_assert(MembersInCorrectOrder < 0
    >::value);

    encoder << instance.children;
    encoder << instance.name;
    encoder << instance.attributes;
}

std::optional<WebCore::SerializedNode::HTMLTemplateElement> ArgumentCoder<WebCore::SerializedNode::HTMLTemplateElement>::decode(Decoder& decoder)
{
    auto children = decoder.decode<Vector<WebCore::SerializedNode>>();
    auto name = decoder.decode<WebCore::SerializedNode::QualifiedName>();
    auto attributes = decoder.decode<Vector<WebCore::SerializedNode::Element::Attribute>>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::SerializedNode::HTMLTemplateElement {
            WebCore::SerializedNode::Element {
                WebCore::SerializedNode::ContainerNode {
                    WTFMove(*children)
                },
                WTFMove(*name),
                WTFMove(*attributes)
            }
        }
    };
}

void ArgumentCoder<WebCore::SerializedNode>::encode(Encoder& encoder, const WebCore::SerializedNode& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.data)>, Variant<WebCore::SerializedNode::Attr, WebCore::SerializedNode::CDATASection, WebCore::SerializedNode::Comment, WebCore::SerializedNode::Document, WebCore::SerializedNode::DocumentFragment, WebCore::SerializedNode::DocumentType, WebCore::SerializedNode::Element, WebCore::SerializedNode::ProcessingInstruction, WebCore::SerializedNode::ShadowRoot, WebCore::SerializedNode::Text, WebCore::SerializedNode::HTMLTemplateElement>>);
    struct ShouldBeSameSizeAsSerializedNode : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::SerializedNode>, false> {
        Variant<WebCore::SerializedNode::Attr, WebCore::SerializedNode::CDATASection, WebCore::SerializedNode::Comment, WebCore::SerializedNode::Document, WebCore::SerializedNode::DocumentFragment, WebCore::SerializedNode::DocumentType, WebCore::SerializedNode::Element, WebCore::SerializedNode::ProcessingInstruction, WebCore::SerializedNode::ShadowRoot, WebCore::SerializedNode::Text, WebCore::SerializedNode::HTMLTemplateElement> data;
    };
    static_assert(sizeof(ShouldBeSameSizeAsSerializedNode) == sizeof(WebCore::SerializedNode));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::SerializedNode, data)
    >::value);

    encoder << instance.data;
}

std::optional<WebCore::SerializedNode> ArgumentCoder<WebCore::SerializedNode>::decode(Decoder& decoder)
{
    auto data = decoder.decode<Variant<WebCore::SerializedNode::Attr, WebCore::SerializedNode::CDATASection, WebCore::SerializedNode::Comment, WebCore::SerializedNode::Document, WebCore::SerializedNode::DocumentFragment, WebCore::SerializedNode::DocumentType, WebCore::SerializedNode::Element, WebCore::SerializedNode::ProcessingInstruction, WebCore::SerializedNode::ShadowRoot, WebCore::SerializedNode::Text, WebCore::SerializedNode::HTMLTemplateElement>>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::SerializedNode {
            WTFMove(*data)
        }
    };
}

void ArgumentCoder<WebKit::HTTPBody>::encode(Encoder& encoder, const WebKit::HTTPBody& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.contentType)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.elements)>, Vector<WebKit::HTTPBody::Element>>);
    struct ShouldBeSameSizeAsHTTPBody : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::HTTPBody>, false> {
        String contentType;
        Vector<WebKit::HTTPBody::Element> elements;
    };
    static_assert(sizeof(ShouldBeSameSizeAsHTTPBody) == sizeof(WebKit::HTTPBody));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::HTTPBody, contentType)
        , offsetof(WebKit::HTTPBody, elements)
    >::value);

    encoder << instance.contentType;
    encoder << instance.elements;
}

std::optional<WebKit::HTTPBody> ArgumentCoder<WebKit::HTTPBody>::decode(Decoder& decoder)
{
    auto contentType = decoder.decode<String>();
    auto elements = decoder.decode<Vector<WebKit::HTTPBody::Element>>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebKit::HTTPBody {
            WTFMove(*contentType),
            WTFMove(*elements)
        }
    };
}

void ArgumentCoder<WebKit::HTTPBody::Element>::encode(Encoder& encoder, const WebKit::HTTPBody::Element& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.data)>, Variant<Vector<uint8_t>, WebKit::HTTPBody::Element::FileData, String>>);
    struct ShouldBeSameSizeAsElement : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::HTTPBody::Element>, false> {
        Variant<Vector<uint8_t>, WebKit::HTTPBody::Element::FileData, String> data;
    };
    static_assert(sizeof(ShouldBeSameSizeAsElement) == sizeof(WebKit::HTTPBody::Element));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::HTTPBody::Element, data)
    >::value);

    encoder << instance.data;
}

std::optional<WebKit::HTTPBody::Element> ArgumentCoder<WebKit::HTTPBody::Element>::decode(Decoder& decoder)
{
    auto data = decoder.decode<Variant<Vector<uint8_t>, WebKit::HTTPBody::Element::FileData, String>>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebKit::HTTPBody::Element {
            WTFMove(*data)
        }
    };
}

void ArgumentCoder<WebKit::HTTPBody::Element::FileData>::encode(Encoder& encoder, const WebKit::HTTPBody::Element::FileData& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.filePath)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.fileStart)>, int64_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.fileLength)>, std::optional<int64_t>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.expectedFileModificationTime)>, std::optional<WallTime>>);
    struct ShouldBeSameSizeAsFileData : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::HTTPBody::Element::FileData>, false> {
        String filePath;
        int64_t fileStart;
        std::optional<int64_t> fileLength;
        std::optional<WallTime> expectedFileModificationTime;
    };
    static_assert(sizeof(ShouldBeSameSizeAsFileData) == sizeof(WebKit::HTTPBody::Element::FileData));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::HTTPBody::Element::FileData, filePath)
        , offsetof(WebKit::HTTPBody::Element::FileData, fileStart)
        , offsetof(WebKit::HTTPBody::Element::FileData, fileLength)
        , offsetof(WebKit::HTTPBody::Element::FileData, expectedFileModificationTime)
    >::value);

    encoder << instance.filePath;
    encoder << instance.fileStart;
    encoder << instance.fileLength;
    encoder << instance.expectedFileModificationTime;
}

std::optional<WebKit::HTTPBody::Element::FileData> ArgumentCoder<WebKit::HTTPBody::Element::FileData>::decode(Decoder& decoder)
{
    auto filePath = decoder.decode<String>();
    auto fileStart = decoder.decode<int64_t>();
    auto fileLength = decoder.decode<std::optional<int64_t>>();
    auto expectedFileModificationTime = decoder.decode<std::optional<WallTime>>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebKit::HTTPBody::Element::FileData {
            WTFMove(*filePath),
            WTFMove(*fileStart),
            WTFMove(*fileLength),
            WTFMove(*expectedFileModificationTime)
        }
    };
}

void ArgumentCoder<WebKit::FrameState>::encode(Encoder& encoder, const WebKit::FrameState& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.urlString)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.originalURLString)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.referrer)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.target)>, AtomString>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.frameID)>, std::optional<WebCore::FrameIdentifier>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.stateObjectData)>, std::optional<Vector<uint8_t>>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.documentSequenceNumber)>, int64_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.itemSequenceNumber)>, int64_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.scrollPosition)>, WebCore::IntPoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.shouldRestoreScrollPosition)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.pageScaleFactor)>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.httpBody)>, std::optional<WebKit::HTTPBody>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.itemID)>, Markable<WebCore::BackForwardItemIdentifier>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.frameItemID)>, Markable<WebCore::BackForwardFrameItemIdentifier>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.hasCachedPage)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.title)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.shouldOpenExternalURLsPolicy)>, WebCore::ShouldOpenExternalURLsPolicy>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.sessionStateObject)>, RefPtr<WebCore::SerializedScriptValue>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.wasCreatedByJSWithoutUserInteraction)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.wasRestoredFromSession)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.policyContainer)>, std::optional<WebCore::PolicyContainer>>);
#if PLATFORM(IOS_FAMILY)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.exposedContentRect)>, WebCore::FloatRect>);
#endif
#if PLATFORM(IOS_FAMILY)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.unobscuredContentRect)>, WebCore::IntRect>);
#endif
#if PLATFORM(IOS_FAMILY)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.minimumLayoutSizeInScrollViewCoordinates)>, WebCore::FloatSize>);
#endif
#if PLATFORM(IOS_FAMILY)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.contentSize)>, WebCore::IntSize>);
#endif
#if PLATFORM(IOS_FAMILY)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.scaleIsInitial)>, bool>);
#endif
#if PLATFORM(IOS_FAMILY)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.obscuredInsets)>, WebCore::FloatBoxExtent>);
#endif
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.children)>, Vector<Ref<WebKit::FrameState>>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.documentState())>, Vector<AtomString>>);

    encoder << instance.urlString;
    encoder << instance.originalURLString;
    encoder << instance.referrer;
    encoder << instance.target;
    encoder << instance.frameID;
    encoder << instance.stateObjectData;
    encoder << instance.documentSequenceNumber;
    encoder << instance.itemSequenceNumber;
    encoder << instance.scrollPosition;
    encoder << instance.shouldRestoreScrollPosition;
    encoder << instance.pageScaleFactor;
    encoder << instance.httpBody;
    encoder << instance.itemID;
    encoder << instance.frameItemID;
    encoder << instance.hasCachedPage;
    encoder << instance.title;
    encoder << instance.shouldOpenExternalURLsPolicy;
    encoder << instance.sessionStateObject;
    encoder << instance.wasCreatedByJSWithoutUserInteraction;
    encoder << instance.wasRestoredFromSession;
    encoder << instance.policyContainer;
#if PLATFORM(IOS_FAMILY)
    encoder << instance.exposedContentRect;
#endif
#if PLATFORM(IOS_FAMILY)
    encoder << instance.unobscuredContentRect;
#endif
#if PLATFORM(IOS_FAMILY)
    encoder << instance.minimumLayoutSizeInScrollViewCoordinates;
#endif
#if PLATFORM(IOS_FAMILY)
    encoder << instance.contentSize;
#endif
#if PLATFORM(IOS_FAMILY)
    encoder << instance.scaleIsInitial;
#endif
#if PLATFORM(IOS_FAMILY)
    encoder << instance.obscuredInsets;
#endif
    encoder << instance.children;
    encoder << instance.documentState();
}

std::optional<Ref<WebKit::FrameState>> ArgumentCoder<WebKit::FrameState>::decode(Decoder& decoder)
{
    auto urlString = decoder.decode<String>();
    auto originalURLString = decoder.decode<String>();
    auto referrer = decoder.decode<String>();
    auto target = decoder.decode<AtomString>();
    auto frameID = decoder.decode<std::optional<WebCore::FrameIdentifier>>();
    auto stateObjectData = decoder.decode<std::optional<Vector<uint8_t>>>();
    auto documentSequenceNumber = decoder.decode<int64_t>();
    auto itemSequenceNumber = decoder.decode<int64_t>();
    auto scrollPosition = decoder.decode<WebCore::IntPoint>();
    auto shouldRestoreScrollPosition = decoder.decode<bool>();
    auto pageScaleFactor = decoder.decode<float>();
    auto httpBody = decoder.decode<std::optional<WebKit::HTTPBody>>();
    auto itemID = decoder.decode<Markable<WebCore::BackForwardItemIdentifier>>();
    auto frameItemID = decoder.decode<Markable<WebCore::BackForwardFrameItemIdentifier>>();
    auto hasCachedPage = decoder.decode<bool>();
    auto title = decoder.decode<String>();
    auto shouldOpenExternalURLsPolicy = decoder.decode<WebCore::ShouldOpenExternalURLsPolicy>();
    auto sessionStateObject = decoder.decode<RefPtr<WebCore::SerializedScriptValue>>();
    auto wasCreatedByJSWithoutUserInteraction = decoder.decode<bool>();
    auto wasRestoredFromSession = decoder.decode<bool>();
    auto policyContainer = decoder.decode<std::optional<WebCore::PolicyContainer>>();
#if PLATFORM(IOS_FAMILY)
    auto exposedContentRect = decoder.decode<WebCore::FloatRect>();
#endif
#if PLATFORM(IOS_FAMILY)
    auto unobscuredContentRect = decoder.decode<WebCore::IntRect>();
#endif
#if PLATFORM(IOS_FAMILY)
    auto minimumLayoutSizeInScrollViewCoordinates = decoder.decode<WebCore::FloatSize>();
#endif
#if PLATFORM(IOS_FAMILY)
    auto contentSize = decoder.decode<WebCore::IntSize>();
#endif
#if PLATFORM(IOS_FAMILY)
    auto scaleIsInitial = decoder.decode<bool>();
#endif
#if PLATFORM(IOS_FAMILY)
    auto obscuredInsets = decoder.decode<WebCore::FloatBoxExtent>();
#endif
    auto children = decoder.decode<Vector<Ref<WebKit::FrameState>>>();
    auto documentState = decoder.decode<Vector<AtomString>>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;

    if (!(WebKit::FrameState::validateDocumentState(*documentState)))
        return std::nullopt;
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebKit::FrameState::create(
            WTFMove(*urlString),
            WTFMove(*originalURLString),
            WTFMove(*referrer),
            WTFMove(*target),
            WTFMove(*frameID),
            WTFMove(*stateObjectData),
            WTFMove(*documentSequenceNumber),
            WTFMove(*itemSequenceNumber),
            WTFMove(*scrollPosition),
            WTFMove(*shouldRestoreScrollPosition),
            WTFMove(*pageScaleFactor),
            WTFMove(*httpBody),
            WTFMove(*itemID),
            WTFMove(*frameItemID),
            WTFMove(*hasCachedPage),
            WTFMove(*title),
            WTFMove(*shouldOpenExternalURLsPolicy),
            WTFMove(*sessionStateObject),
            WTFMove(*wasCreatedByJSWithoutUserInteraction),
            WTFMove(*wasRestoredFromSession),
            WTFMove(*policyContainer),
#if PLATFORM(IOS_FAMILY)
            WTFMove(*exposedContentRect),
#endif
#if PLATFORM(IOS_FAMILY)
            WTFMove(*unobscuredContentRect),
#endif
#if PLATFORM(IOS_FAMILY)
            WTFMove(*minimumLayoutSizeInScrollViewCoordinates),
#endif
#if PLATFORM(IOS_FAMILY)
            WTFMove(*contentSize),
#endif
#if PLATFORM(IOS_FAMILY)
            WTFMove(*scaleIsInitial),
#endif
#if PLATFORM(IOS_FAMILY)
            WTFMove(*obscuredInsets),
#endif
            WTFMove(*children),
            WTFMove(*documentState)
        )
    };
}

void ArgumentCoder<WebKit::BackForwardListState>::encode(Encoder& encoder, const WebKit::BackForwardListState& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.items)>, Vector<Ref<WebKit::FrameState>>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.currentIndex)>, std::optional<uint32_t>>);
    struct ShouldBeSameSizeAsBackForwardListState : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::BackForwardListState>, false> {
        Vector<Ref<WebKit::FrameState>> items;
        std::optional<uint32_t> currentIndex;
    };
    static_assert(sizeof(ShouldBeSameSizeAsBackForwardListState) == sizeof(WebKit::BackForwardListState));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::BackForwardListState, items)
        , offsetof(WebKit::BackForwardListState, currentIndex)
    >::value);

    encoder << instance.items;
    encoder << instance.currentIndex;
}

std::optional<WebKit::BackForwardListState> ArgumentCoder<WebKit::BackForwardListState>::decode(Decoder& decoder)
{
    auto items = decoder.decode<Vector<Ref<WebKit::FrameState>>>();
    auto currentIndex = decoder.decode<std::optional<uint32_t>>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebKit::BackForwardListState {
            WTFMove(*items),
            WTFMove(*currentIndex)
        }
    };
}

#if ENABLE(IMAGE_ANALYSIS)
void ArgumentCoder<WebCore::TextRecognitionWordData>::encode(Encoder& encoder, const WebCore::TextRecognitionWordData& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.text)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.normalizedQuad)>, WebCore::FloatQuad>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.hasLeadingWhitespace)>, bool>);
    struct ShouldBeSameSizeAsTextRecognitionWordData : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::TextRecognitionWordData>, false> {
        String text;
        WebCore::FloatQuad normalizedQuad;
        bool hasLeadingWhitespace;
    };
    static_assert(sizeof(ShouldBeSameSizeAsTextRecognitionWordData) == sizeof(WebCore::TextRecognitionWordData));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::TextRecognitionWordData, text)
        , offsetof(WebCore::TextRecognitionWordData, normalizedQuad)
        , offsetof(WebCore::TextRecognitionWordData, hasLeadingWhitespace)
    >::value);

    encoder << instance.text;
    encoder << instance.normalizedQuad;
    encoder << instance.hasLeadingWhitespace;
}

std::optional<WebCore::TextRecognitionWordData> ArgumentCoder<WebCore::TextRecognitionWordData>::decode(Decoder& decoder)
{
    auto text = decoder.decode<String>();
    auto normalizedQuad = decoder.decode<WebCore::FloatQuad>();
    auto hasLeadingWhitespace = decoder.decode<bool>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::TextRecognitionWordData {
            WTFMove(*text),
            WTFMove(*normalizedQuad),
            WTFMove(*hasLeadingWhitespace)
        }
    };
}

#endif

#if ENABLE(IMAGE_ANALYSIS)
void ArgumentCoder<WebCore::TextRecognitionLineData>::encode(Encoder& encoder, const WebCore::TextRecognitionLineData& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.normalizedQuad)>, WebCore::FloatQuad>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.children)>, Vector<WebCore::TextRecognitionWordData>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.hasTrailingNewline)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isVertical)>, bool>);
    struct ShouldBeSameSizeAsTextRecognitionLineData : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::TextRecognitionLineData>, false> {
        WebCore::FloatQuad normalizedQuad;
        Vector<WebCore::TextRecognitionWordData> children;
        bool hasTrailingNewline;
        bool isVertical;
    };
    static_assert(sizeof(ShouldBeSameSizeAsTextRecognitionLineData) == sizeof(WebCore::TextRecognitionLineData));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::TextRecognitionLineData, normalizedQuad)
        , offsetof(WebCore::TextRecognitionLineData, children)
        , offsetof(WebCore::TextRecognitionLineData, hasTrailingNewline)
        , offsetof(WebCore::TextRecognitionLineData, isVertical)
    >::value);

    encoder << instance.normalizedQuad;
    encoder << instance.children;
    encoder << instance.hasTrailingNewline;
    encoder << instance.isVertical;
}

std::optional<WebCore::TextRecognitionLineData> ArgumentCoder<WebCore::TextRecognitionLineData>::decode(Decoder& decoder)
{
    auto normalizedQuad = decoder.decode<WebCore::FloatQuad>();
    auto children = decoder.decode<Vector<WebCore::TextRecognitionWordData>>();
    auto hasTrailingNewline = decoder.decode<bool>();
    auto isVertical = decoder.decode<bool>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::TextRecognitionLineData {
            WTFMove(*normalizedQuad),
            WTFMove(*children),
            WTFMove(*hasTrailingNewline),
            WTFMove(*isVertical)
        }
    };
}

#endif

#if ENABLE(IMAGE_ANALYSIS)
void ArgumentCoder<WebCore::TextRecognitionBlockData>::encode(Encoder& encoder, const WebCore::TextRecognitionBlockData& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.text)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.normalizedQuad)>, WebCore::FloatQuad>);
    struct ShouldBeSameSizeAsTextRecognitionBlockData : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::TextRecognitionBlockData>, false> {
        String text;
        WebCore::FloatQuad normalizedQuad;
    };
    static_assert(sizeof(ShouldBeSameSizeAsTextRecognitionBlockData) == sizeof(WebCore::TextRecognitionBlockData));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::TextRecognitionBlockData, text)
        , offsetof(WebCore::TextRecognitionBlockData, normalizedQuad)
    >::value);

    encoder << instance.text;
    encoder << instance.normalizedQuad;
}

std::optional<WebCore::TextRecognitionBlockData> ArgumentCoder<WebCore::TextRecognitionBlockData>::decode(Decoder& decoder)
{
    auto text = decoder.decode<String>();
    auto normalizedQuad = decoder.decode<WebCore::FloatQuad>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::TextRecognitionBlockData {
            WTFMove(*text),
            WTFMove(*normalizedQuad)
        }
    };
}

#endif

#if ENABLE(IMAGE_ANALYSIS)
void ArgumentCoder<WebCore::TextRecognitionResult>::encode(Encoder& encoder, const WebCore::TextRecognitionResult& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.lines)>, Vector<WebCore::TextRecognitionLineData>>);
#if ENABLE(DATA_DETECTION)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.dataDetectors)>, Vector<WebCore::TextRecognitionDataDetector>>);
#endif
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.blocks)>, Vector<WebCore::TextRecognitionBlockData>>);
#if ENABLE(IMAGE_ANALYSIS_ENHANCEMENTS)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.imageAnalysisData)>, RetainPtr<NSData>>);
#endif
    struct ShouldBeSameSizeAsTextRecognitionResult : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::TextRecognitionResult>, false> {
        Vector<WebCore::TextRecognitionLineData> lines;
#if ENABLE(DATA_DETECTION)
        Vector<WebCore::TextRecognitionDataDetector> dataDetectors;
#endif
        Vector<WebCore::TextRecognitionBlockData> blocks;
#if ENABLE(IMAGE_ANALYSIS_ENHANCEMENTS)
        RetainPtr<NSData> imageAnalysisData;
#endif
    };
    static_assert(sizeof(ShouldBeSameSizeAsTextRecognitionResult) == sizeof(WebCore::TextRecognitionResult));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::TextRecognitionResult, lines)
#if ENABLE(DATA_DETECTION)
        , offsetof(WebCore::TextRecognitionResult, dataDetectors)
#endif
        , offsetof(WebCore::TextRecognitionResult, blocks)
#if ENABLE(IMAGE_ANALYSIS_ENHANCEMENTS)
        , offsetof(WebCore::TextRecognitionResult, imageAnalysisData)
#endif
    >::value);

    encoder << instance.lines;
#if ENABLE(DATA_DETECTION)
    encoder << instance.dataDetectors;
#endif
    encoder << instance.blocks;
#if ENABLE(IMAGE_ANALYSIS_ENHANCEMENTS)
    encoder << instance.imageAnalysisData;
#endif
}

std::optional<WebCore::TextRecognitionResult> ArgumentCoder<WebCore::TextRecognitionResult>::decode(Decoder& decoder)
{
    auto lines = decoder.decode<Vector<WebCore::TextRecognitionLineData>>();
#if ENABLE(DATA_DETECTION)
    auto dataDetectors = decoder.decode<Vector<WebCore::TextRecognitionDataDetector>>();
#endif
    auto blocks = decoder.decode<Vector<WebCore::TextRecognitionBlockData>>();
#if ENABLE(IMAGE_ANALYSIS_ENHANCEMENTS)
    auto imageAnalysisData = decoder.decode<RetainPtr<NSData>>();
#endif
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::TextRecognitionResult {
            WTFMove(*lines),
#if ENABLE(DATA_DETECTION)
            WTFMove(*dataDetectors),
#endif
            WTFMove(*blocks),
#if ENABLE(IMAGE_ANALYSIS_ENHANCEMENTS)
            WTFMove(*imageAnalysisData)
#endif
        }
    };
}

#endif

void ArgumentCoder<WebKit::URLSchemeTaskParameters>::encode(Encoder& encoder, const WebKit::URLSchemeTaskParameters& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.handlerIdentifier)>, WebKit::WebURLSchemeHandlerIdentifier>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.taskIdentifier)>, WebCore::ResourceLoaderIdentifier>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.request)>, WebCore::ResourceRequest>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.frameInfo)>, WebKit::FrameInfoData>);
    struct ShouldBeSameSizeAsURLSchemeTaskParameters : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::URLSchemeTaskParameters>, false> {
        WebKit::WebURLSchemeHandlerIdentifier handlerIdentifier;
        WebCore::ResourceLoaderIdentifier taskIdentifier;
        WebCore::ResourceRequest request;
        WebKit::FrameInfoData frameInfo;
    };
    static_assert(sizeof(ShouldBeSameSizeAsURLSchemeTaskParameters) == sizeof(WebKit::URLSchemeTaskParameters));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::URLSchemeTaskParameters, handlerIdentifier)
        , offsetof(WebKit::URLSchemeTaskParameters, taskIdentifier)
        , offsetof(WebKit::URLSchemeTaskParameters, request)
        , offsetof(WebKit::URLSchemeTaskParameters, frameInfo)
    >::value);

    encoder << instance.handlerIdentifier;
    encoder << instance.taskIdentifier;
    encoder << instance.request;
    encoder << IPC::FormDataReference { instance.request.httpBody() };
    encoder << instance.frameInfo;
}

std::optional<WebKit::URLSchemeTaskParameters> ArgumentCoder<WebKit::URLSchemeTaskParameters>::decode(Decoder& decoder)
{
    auto handlerIdentifier = decoder.decode<WebKit::WebURLSchemeHandlerIdentifier>();
    auto taskIdentifier = decoder.decode<WebCore::ResourceLoaderIdentifier>();
    auto request = decoder.decode<WebCore::ResourceRequest>();
    if (request) {
        if (auto requestBody = decoder.decode<IPC::FormDataReference>())
            request->setHTTPBody(requestBody->takeData());
    }
    auto frameInfo = decoder.decode<WebKit::FrameInfoData>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebKit::URLSchemeTaskParameters {
            WTFMove(*handlerIdentifier),
            WTFMove(*taskIdentifier),
            WTFMove(*request),
            WTFMove(*frameInfo)
        }
    };
}

#if USE(COORDINATED_GRAPHICS) || USE(TEXTURE_MAPPER)
void ArgumentCoder<WebKit::UpdateInfo>::encode(Encoder& encoder, WebKit::UpdateInfo&& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.viewSize)>, WebCore::IntSize>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.deviceScaleFactor)>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.scrollRect)>, WebCore::IntRect>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.scrollOffset)>, WebCore::IntSize>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.updateRectBounds)>, WebCore::IntRect>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.updateRects)>, Vector<WebCore::IntRect>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.updateScaleFactor)>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.bitmapHandle)>, std::optional<WebCore::ShareableBitmapHandle>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.bitmapOffset)>, WebCore::IntPoint>);
    struct ShouldBeSameSizeAsUpdateInfo : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::UpdateInfo>, false> {
        WebCore::IntSize viewSize;
        float deviceScaleFactor;
        WebCore::IntRect scrollRect;
        WebCore::IntSize scrollOffset;
        WebCore::IntRect updateRectBounds;
        Vector<WebCore::IntRect> updateRects;
        float updateScaleFactor;
        std::optional<WebCore::ShareableBitmapHandle> bitmapHandle;
        WebCore::IntPoint bitmapOffset;
    };
    static_assert(sizeof(ShouldBeSameSizeAsUpdateInfo) == sizeof(WebKit::UpdateInfo));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::UpdateInfo, viewSize)
        , offsetof(WebKit::UpdateInfo, deviceScaleFactor)
        , offsetof(WebKit::UpdateInfo, scrollRect)
        , offsetof(WebKit::UpdateInfo, scrollOffset)
        , offsetof(WebKit::UpdateInfo, updateRectBounds)
        , offsetof(WebKit::UpdateInfo, updateRects)
        , offsetof(WebKit::UpdateInfo, updateScaleFactor)
        , offsetof(WebKit::UpdateInfo, bitmapHandle)
        , offsetof(WebKit::UpdateInfo, bitmapOffset)
    >::value);

    encoder << WTFMove(instance.viewSize);
    encoder << WTFMove(instance.deviceScaleFactor);
    encoder << WTFMove(instance.scrollRect);
    encoder << WTFMove(instance.scrollOffset);
    encoder << WTFMove(instance.updateRectBounds);
    encoder << WTFMove(instance.updateRects);
    encoder << WTFMove(instance.updateScaleFactor);
    encoder << WTFMove(instance.bitmapHandle);
    encoder << WTFMove(instance.bitmapOffset);
}

std::optional<WebKit::UpdateInfo> ArgumentCoder<WebKit::UpdateInfo>::decode(Decoder& decoder)
{
    auto viewSize = decoder.decode<WebCore::IntSize>();
    auto deviceScaleFactor = decoder.decode<float>();
    auto scrollRect = decoder.decode<WebCore::IntRect>();
    auto scrollOffset = decoder.decode<WebCore::IntSize>();
    auto updateRectBounds = decoder.decode<WebCore::IntRect>();
    auto updateRects = decoder.decode<Vector<WebCore::IntRect>>();
    auto updateScaleFactor = decoder.decode<float>();
    auto bitmapHandle = decoder.decode<std::optional<WebCore::ShareableBitmapHandle>>();
    auto bitmapOffset = decoder.decode<WebCore::IntPoint>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebKit::UpdateInfo {
            WTFMove(*viewSize),
            WTFMove(*deviceScaleFactor),
            WTFMove(*scrollRect),
            WTFMove(*scrollOffset),
            WTFMove(*updateRectBounds),
            WTFMove(*updateRects),
            WTFMove(*updateScaleFactor),
            WTFMove(*bitmapHandle),
            WTFMove(*bitmapOffset)
        }
    };
}

#endif

void ArgumentCoder<WebKit::UserContentControllerParameters>::encode(Encoder& encoder, const WebKit::UserContentControllerParameters& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.identifier)>, WebKit::UserContentControllerIdentifier>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.userContentWorlds)>, Vector<WebKit::ContentWorldData>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.userScripts)>, Vector<WebKit::WebUserScriptData>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.userStyleSheets)>, Vector<WebKit::WebUserStyleSheetData>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.messageHandlers)>, Vector<WebKit::WebScriptMessageHandlerData>>);
#if ENABLE(CONTENT_EXTENSIONS)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.contentRuleLists)>, Vector<std::pair<WebKit::WebCompiledContentRuleListData, URL>>>);
#endif
    struct ShouldBeSameSizeAsUserContentControllerParameters : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::UserContentControllerParameters>, false> {
        WebKit::UserContentControllerIdentifier identifier;
        Vector<WebKit::ContentWorldData> userContentWorlds;
        Vector<WebKit::WebUserScriptData> userScripts;
        Vector<WebKit::WebUserStyleSheetData> userStyleSheets;
        Vector<WebKit::WebScriptMessageHandlerData> messageHandlers;
#if ENABLE(CONTENT_EXTENSIONS)
        Vector<std::pair<WebKit::WebCompiledContentRuleListData, URL>> contentRuleLists;
#endif
    };
    static_assert(sizeof(ShouldBeSameSizeAsUserContentControllerParameters) == sizeof(WebKit::UserContentControllerParameters));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::UserContentControllerParameters, identifier)
        , offsetof(WebKit::UserContentControllerParameters, userContentWorlds)
        , offsetof(WebKit::UserContentControllerParameters, userScripts)
        , offsetof(WebKit::UserContentControllerParameters, userStyleSheets)
        , offsetof(WebKit::UserContentControllerParameters, messageHandlers)
#if ENABLE(CONTENT_EXTENSIONS)
        , offsetof(WebKit::UserContentControllerParameters, contentRuleLists)
#endif
    >::value);

    encoder << instance.identifier;
    encoder << instance.userContentWorlds;
    encoder << instance.userScripts;
    encoder << instance.userStyleSheets;
    encoder << instance.messageHandlers;
#if ENABLE(CONTENT_EXTENSIONS)
    encoder << instance.contentRuleLists;
#endif
}

std::optional<WebKit::UserContentControllerParameters> ArgumentCoder<WebKit::UserContentControllerParameters>::decode(Decoder& decoder)
{
    bool addedDecodingFailureIndex = false;
    auto identifier = decoder.decode<WebKit::UserContentControllerIdentifier>();
    if (!identifier && !addedDecodingFailureIndex) [[unlikely]] {
        decoder.addIndexOfDecodingFailure(0);
        addedDecodingFailureIndex = true;
    }
    auto userContentWorlds = decoder.decode<Vector<WebKit::ContentWorldData>>();
    if (!userContentWorlds && !addedDecodingFailureIndex) [[unlikely]] {
        decoder.addIndexOfDecodingFailure(1);
        addedDecodingFailureIndex = true;
    }
    auto userScripts = decoder.decode<Vector<WebKit::WebUserScriptData>>();
    if (!userScripts && !addedDecodingFailureIndex) [[unlikely]] {
        decoder.addIndexOfDecodingFailure(2);
        addedDecodingFailureIndex = true;
    }
    auto userStyleSheets = decoder.decode<Vector<WebKit::WebUserStyleSheetData>>();
    if (!userStyleSheets && !addedDecodingFailureIndex) [[unlikely]] {
        decoder.addIndexOfDecodingFailure(3);
        addedDecodingFailureIndex = true;
    }
    auto messageHandlers = decoder.decode<Vector<WebKit::WebScriptMessageHandlerData>>();
    if (!messageHandlers && !addedDecodingFailureIndex) [[unlikely]] {
        decoder.addIndexOfDecodingFailure(4);
        addedDecodingFailureIndex = true;
    }
#if ENABLE(CONTENT_EXTENSIONS)
    auto contentRuleLists = decoder.decode<Vector<std::pair<WebKit::WebCompiledContentRuleListData, URL>>>();
    if (!contentRuleLists && !addedDecodingFailureIndex) [[unlikely]] {
        decoder.addIndexOfDecodingFailure(5);
        addedDecodingFailureIndex = true;
    }
#endif
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebKit::UserContentControllerParameters {
            WTFMove(*identifier),
            WTFMove(*userContentWorlds),
            WTFMove(*userScripts),
            WTFMove(*userStyleSheets),
            WTFMove(*messageHandlers),
#if ENABLE(CONTENT_EXTENSIONS)
            WTFMove(*contentRuleLists)
#endif
        }
    };
}

void ArgumentCoder<WebKit::UserData>::encode(Encoder& encoder, const WebKit::UserData& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.protectedObject())>, RefPtr<API::Object>>);

    encoder << instance.protectedObject();
}

std::optional<WebKit::UserData> ArgumentCoder<WebKit::UserData>::decode(Decoder& decoder)
{
    auto protectedObject = decoder.decode<RefPtr<API::Object>>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebKit::UserData {
            WTFMove(*protectedObject)
        }
    };
}

#if ENABLE(UI_SIDE_COMPOSITING)
void ArgumentCoder<WebKit::VisibleContentRectUpdateInfo>::encode(Encoder& encoder, const WebKit::VisibleContentRectUpdateInfo& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.exposedContentRect())>, WebCore::FloatRect>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.unobscuredContentRect())>, WebCore::FloatRect>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.contentInsets())>, WebCore::FloatBoxExtent>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.unobscuredRectInScrollViewCoordinates())>, WebCore::FloatRect>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.unobscuredContentRectRespectingInputViewBounds())>, WebCore::FloatRect>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.layoutViewportRect())>, WebCore::FloatRect>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.obscuredInsets())>, WebCore::FloatBoxExtent>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.unobscuredSafeAreaInsets())>, WebCore::FloatBoxExtent>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.scale())>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.viewStability())>, OptionSet<WebKit::ViewStabilityFlag>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isFirstUpdateForNewViewSize())>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.allowShrinkToFit())>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.enclosedInScrollableAncestorView())>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.scrollVelocity())>, WebCore::VelocityData>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.lastLayerTreeTransactionID())>, WebKit::TransactionID>);

    encoder << instance.exposedContentRect();
    encoder << instance.unobscuredContentRect();
    encoder << instance.contentInsets();
    encoder << instance.unobscuredRectInScrollViewCoordinates();
    encoder << instance.unobscuredContentRectRespectingInputViewBounds();
    encoder << instance.layoutViewportRect();
    encoder << instance.obscuredInsets();
    encoder << instance.unobscuredSafeAreaInsets();
    encoder << instance.scale();
    encoder << instance.viewStability();
    encoder << instance.isFirstUpdateForNewViewSize();
    encoder << instance.allowShrinkToFit();
    encoder << instance.enclosedInScrollableAncestorView();
    encoder << instance.scrollVelocity();
    encoder << instance.lastLayerTreeTransactionID();
}

std::optional<WebKit::VisibleContentRectUpdateInfo> ArgumentCoder<WebKit::VisibleContentRectUpdateInfo>::decode(Decoder& decoder)
{
    auto exposedContentRect = decoder.decode<WebCore::FloatRect>();
    auto unobscuredContentRect = decoder.decode<WebCore::FloatRect>();
    auto contentInsets = decoder.decode<WebCore::FloatBoxExtent>();
    auto unobscuredRectInScrollViewCoordinates = decoder.decode<WebCore::FloatRect>();
    auto unobscuredContentRectRespectingInputViewBounds = decoder.decode<WebCore::FloatRect>();
    auto layoutViewportRect = decoder.decode<WebCore::FloatRect>();
    auto obscuredInsets = decoder.decode<WebCore::FloatBoxExtent>();
    auto unobscuredSafeAreaInsets = decoder.decode<WebCore::FloatBoxExtent>();
    auto scale = decoder.decode<double>();
    auto viewStability = decoder.decode<OptionSet<WebKit::ViewStabilityFlag>>();
    auto isFirstUpdateForNewViewSize = decoder.decode<bool>();
    auto allowShrinkToFit = decoder.decode<bool>();
    auto enclosedInScrollableAncestorView = decoder.decode<bool>();
    auto scrollVelocity = decoder.decode<WebCore::VelocityData>();
    auto lastLayerTreeTransactionID = decoder.decode<WebKit::TransactionID>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebKit::VisibleContentRectUpdateInfo {
            WTFMove(*exposedContentRect),
            WTFMove(*unobscuredContentRect),
            WTFMove(*contentInsets),
            WTFMove(*unobscuredRectInScrollViewCoordinates),
            WTFMove(*unobscuredContentRectRespectingInputViewBounds),
            WTFMove(*layoutViewportRect),
            WTFMove(*obscuredInsets),
            WTFMove(*unobscuredSafeAreaInsets),
            WTFMove(*scale),
            WTFMove(*viewStability),
            WTFMove(*isFirstUpdateForNewViewSize),
            WTFMove(*allowShrinkToFit),
            WTFMove(*enclosedInScrollableAncestorView),
            WTFMove(*scrollVelocity),
            WTFMove(*lastLayerTreeTransactionID)
        }
    };
}

#endif

void ArgumentCoder<WTF::MediaTime>::encode(Encoder& encoder, const WTF::MediaTime& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.timeValue())>, int64_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.timeScale())>, uint32_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.timeFlags())>, uint8_t>);

    encoder << instance.timeValue();
    encoder << instance.timeScale();
    encoder << instance.timeFlags();
}

void ArgumentCoder<WTF::MediaTime>::encode(StreamConnectionEncoder& encoder, const WTF::MediaTime& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.timeValue())>, int64_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.timeScale())>, uint32_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.timeFlags())>, uint8_t>);

    encoder << instance.timeValue();
    encoder << instance.timeScale();
    encoder << instance.timeFlags();
}

std::optional<WTF::MediaTime> ArgumentCoder<WTF::MediaTime>::decode(Decoder& decoder)
{
    auto timeValue = decoder.decode<int64_t>();
    auto timeScale = decoder.decode<uint32_t>();
    auto timeFlags = decoder.decode<uint8_t>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WTF::MediaTime {
            WTFMove(*timeValue),
            WTFMove(*timeScale),
            WTFMove(*timeFlags)
        }
    };
}

void ArgumentCoder<WTF::Seconds>::encode(Encoder& encoder, const WTF::Seconds& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.value())>, double>);

    encoder << instance.value();
}

void ArgumentCoder<WTF::Seconds>::encode(StreamConnectionEncoder& encoder, const WTF::Seconds& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.value())>, double>);

    encoder << instance.value();
}

std::optional<WTF::Seconds> ArgumentCoder<WTF::Seconds>::decode(Decoder& decoder)
{
    auto value = decoder.decode<double>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WTF::Seconds {
            WTFMove(*value)
        }
    };
}

void ArgumentCoder<WTF::MonotonicTime>::encode(Encoder& encoder, const WTF::MonotonicTime& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.secondsSinceEpoch().seconds())>, double>);

    encoder << instance.secondsSinceEpoch().seconds();
}

std::optional<WTF::MonotonicTime> ArgumentCoder<WTF::MonotonicTime>::decode(Decoder& decoder)
{
    auto secondsSinceEpochseconds = decoder.decode<double>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WTF::MonotonicTime::fromRawSeconds(
            WTFMove(*secondsSinceEpochseconds)
        )
    };
}

void ArgumentCoder<WTF::WallTime>::encode(Encoder& encoder, const WTF::WallTime& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.secondsSinceEpoch().seconds())>, double>);

    encoder << instance.secondsSinceEpoch().seconds();
}

std::optional<WTF::WallTime> ArgumentCoder<WTF::WallTime>::decode(Decoder& decoder)
{
    auto secondsSinceEpochseconds = decoder.decode<double>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WTF::WallTime::fromRawSeconds(
            WTFMove(*secondsSinceEpochseconds)
        )
    };
}

void ArgumentCoder<WTF::AtomString>::encode(Encoder& encoder, const WTF::AtomString& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.string())>, String>);

    encoder << instance.string();
}

void ArgumentCoder<WTF::AtomString>::encode(StreamConnectionEncoder& encoder, const WTF::AtomString& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.string())>, String>);

    encoder << instance.string();
}

std::optional<WTF::AtomString> ArgumentCoder<WTF::AtomString>::decode(Decoder& decoder)
{
    auto string = decoder.decode<String>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WTF::AtomString {
            WTFMove(*string)
        }
    };
}

void ArgumentCoder<WTF::JSONImpl::Value>::encode(Encoder& encoder, const WTF::JSONImpl::Value& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.toJSONString())>, String>);

    encoder << instance.toJSONString();
}

std::optional<Ref<WTF::JSONImpl::Value>> ArgumentCoder<WTF::JSONImpl::Value>::decode(Decoder& decoder)
{
    auto toJSONString = decoder.decode<String>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WTF::JSONImpl::Value::optionalParseJSON(
            WTFMove(*toJSONString)
        )
    };
}

void ArgumentCoder<WTF::MemoryPressureHandlerConfiguration>::encode(Encoder& encoder, const WTF::MemoryPressureHandlerConfiguration& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.baseThreshold)>, uint64_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.conservativeThresholdFraction)>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.strictThresholdFraction)>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.killThresholdFraction)>, std::optional<double>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.pollInterval)>, Seconds>);
    struct ShouldBeSameSizeAsMemoryPressureHandlerConfiguration : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WTF::MemoryPressureHandlerConfiguration>, false> {
        uint64_t baseThreshold;
        double conservativeThresholdFraction;
        double strictThresholdFraction;
        std::optional<double> killThresholdFraction;
        Seconds pollInterval;
    };
    static_assert(sizeof(ShouldBeSameSizeAsMemoryPressureHandlerConfiguration) == sizeof(WTF::MemoryPressureHandlerConfiguration));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WTF::MemoryPressureHandlerConfiguration, baseThreshold)
        , offsetof(WTF::MemoryPressureHandlerConfiguration, conservativeThresholdFraction)
        , offsetof(WTF::MemoryPressureHandlerConfiguration, strictThresholdFraction)
        , offsetof(WTF::MemoryPressureHandlerConfiguration, killThresholdFraction)
        , offsetof(WTF::MemoryPressureHandlerConfiguration, pollInterval)
    >::value);

    encoder << instance.baseThreshold;
    encoder << instance.conservativeThresholdFraction;
    encoder << instance.strictThresholdFraction;
    encoder << instance.killThresholdFraction;
    encoder << instance.pollInterval;
}

std::optional<WTF::MemoryPressureHandlerConfiguration> ArgumentCoder<WTF::MemoryPressureHandlerConfiguration>::decode(Decoder& decoder)
{
    auto baseThreshold = decoder.decode<uint64_t>();
    auto conservativeThresholdFraction = decoder.decode<double>();
    auto strictThresholdFraction = decoder.decode<double>();
    auto killThresholdFraction = decoder.decode<std::optional<double>>();
    auto pollInterval = decoder.decode<Seconds>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WTF::MemoryPressureHandlerConfiguration {
            WTFMove(*baseThreshold),
            WTFMove(*conservativeThresholdFraction),
            WTFMove(*strictThresholdFraction),
            WTFMove(*killThresholdFraction),
            WTFMove(*pollInterval)
        }
    };
}

void ArgumentCoder<std::monostate>::encode(Encoder& encoder, const std::monostate& instance)
{
    struct ShouldBeSameSizeAsmonostate : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<std::monostate>, false> {
    };
    static_assert(sizeof(ShouldBeSameSizeAsmonostate) == sizeof(std::monostate));
    static_assert(MembersInCorrectOrder < 0
    >::value);

}

void ArgumentCoder<std::monostate>::encode(StreamConnectionEncoder& encoder, const std::monostate& instance)
{
    struct ShouldBeSameSizeAsmonostate : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<std::monostate>, false> {
    };
    static_assert(sizeof(ShouldBeSameSizeAsmonostate) == sizeof(std::monostate));
    static_assert(MembersInCorrectOrder < 0
    >::value);

}

std::optional<std::monostate> ArgumentCoder<std::monostate>::decode(Decoder& decoder)
{
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        std::monostate {
        }
    };
}

#if PLATFORM(COCOA)
std::optional<WTF::MachSendRightAnnotated> ArgumentCoder<WTF::MachSendRightAnnotated>::decode(Decoder& decoder)
{
    auto sendRight = decoder.decode<MachSendRight>();
    auto data = decoder.decode<FixedVector<uint8_t>>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WTF::MachSendRightAnnotated {
            WTFMove(*sendRight),
            WTFMove(*data)
        }
    };
}

#endif

void ArgumentCoder<WebKit::WebBackForwardListCounts>::encode(Encoder& encoder, const WebKit::WebBackForwardListCounts& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.backCount)>, uint32_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.forwardCount)>, uint32_t>);
    struct ShouldBeSameSizeAsWebBackForwardListCounts : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::WebBackForwardListCounts>, false> {
        uint32_t backCount;
        uint32_t forwardCount;
    };
    static_assert(sizeof(ShouldBeSameSizeAsWebBackForwardListCounts) == sizeof(WebKit::WebBackForwardListCounts));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::WebBackForwardListCounts, backCount)
        , offsetof(WebKit::WebBackForwardListCounts, forwardCount)
    >::value);

    encoder << instance.backCount;
    encoder << instance.forwardCount;
}

std::optional<WebKit::WebBackForwardListCounts> ArgumentCoder<WebKit::WebBackForwardListCounts>::decode(Decoder& decoder)
{
    auto backCount = decoder.decode<uint32_t>();
    auto forwardCount = decoder.decode<uint32_t>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebKit::WebBackForwardListCounts {
            WTFMove(*backCount),
            WTFMove(*forwardCount)
        }
    };
}

#if ENABLE(CONTEXT_MENUS)
void ArgumentCoder<WebKit::WebContextMenuItemData>::encode(Encoder& encoder, const WebKit::WebContextMenuItemData& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.type())>, WebCore::ContextMenuItemType>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.action())>, WebCore::ContextMenuAction>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.title())>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.enabled())>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.checked())>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.indentationLevel())>, unsigned>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.submenu())>, Vector<WebKit::WebContextMenuItemData>>);

    encoder << instance.type();
    encoder << instance.action();
    encoder << instance.title();
    encoder << instance.enabled();
    encoder << instance.checked();
    encoder << instance.indentationLevel();
    encoder << instance.submenu();
}

std::optional<WebKit::WebContextMenuItemData> ArgumentCoder<WebKit::WebContextMenuItemData>::decode(Decoder& decoder)
{
    auto type = decoder.decode<WebCore::ContextMenuItemType>();
    auto action = decoder.decode<WebCore::ContextMenuAction>();
    auto title = decoder.decode<String>();
    auto enabled = decoder.decode<bool>();
    auto checked = decoder.decode<bool>();
    auto indentationLevel = decoder.decode<unsigned>();
    auto submenu = decoder.decode<Vector<WebKit::WebContextMenuItemData>>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebKit::WebContextMenuItemData {
            WTFMove(*type),
            WTFMove(*action),
            WTFMove(*title),
            WTFMove(*enabled),
            WTFMove(*checked),
            WTFMove(*indentationLevel),
            WTFMove(*submenu)
        }
    };
}

#endif

void ArgumentCoder<WebCore::DOMCacheEngine::CacheInfo>::encode(Encoder& encoder, const WebCore::DOMCacheEngine::CacheInfo& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.identifier)>, WebCore::DOMCacheIdentifier>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.name)>, String>);
    struct ShouldBeSameSizeAsCacheInfo : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::DOMCacheEngine::CacheInfo>, false> {
        WebCore::DOMCacheIdentifier identifier;
        String name;
    };
    static_assert(sizeof(ShouldBeSameSizeAsCacheInfo) == sizeof(WebCore::DOMCacheEngine::CacheInfo));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::DOMCacheEngine::CacheInfo, identifier)
        , offsetof(WebCore::DOMCacheEngine::CacheInfo, name)
    >::value);

    encoder << instance.identifier;
    encoder << instance.name;
}

std::optional<WebCore::DOMCacheEngine::CacheInfo> ArgumentCoder<WebCore::DOMCacheEngine::CacheInfo>::decode(Decoder& decoder)
{
    auto identifier = decoder.decode<WebCore::DOMCacheIdentifier>();
    auto name = decoder.decode<String>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::DOMCacheEngine::CacheInfo {
            WTFMove(*identifier),
            WTFMove(*name)
        }
    };
}

void ArgumentCoder<WebCore::DOMCacheEngine::CacheInfos>::encode(Encoder& encoder, const WebCore::DOMCacheEngine::CacheInfos& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.infos)>, Vector<WebCore::DOMCacheEngine::CacheInfo>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.updateCounter)>, uint64_t>);
    struct ShouldBeSameSizeAsCacheInfos : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::DOMCacheEngine::CacheInfos>, false> {
        Vector<WebCore::DOMCacheEngine::CacheInfo> infos;
        uint64_t updateCounter;
    };
    static_assert(sizeof(ShouldBeSameSizeAsCacheInfos) == sizeof(WebCore::DOMCacheEngine::CacheInfos));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::DOMCacheEngine::CacheInfos, infos)
        , offsetof(WebCore::DOMCacheEngine::CacheInfos, updateCounter)
    >::value);

    encoder << instance.infos;
    encoder << instance.updateCounter;
}

std::optional<WebCore::DOMCacheEngine::CacheInfos> ArgumentCoder<WebCore::DOMCacheEngine::CacheInfos>::decode(Decoder& decoder)
{
    auto infos = decoder.decode<Vector<WebCore::DOMCacheEngine::CacheInfo>>();
    auto updateCounter = decoder.decode<uint64_t>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::DOMCacheEngine::CacheInfos {
            WTFMove(*infos),
            WTFMove(*updateCounter)
        }
    };
}

void ArgumentCoder<WebCore::DOMCacheEngine::CacheIdentifierOperationResult>::encode(Encoder& encoder, const WebCore::DOMCacheEngine::CacheIdentifierOperationResult& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.identifier)>, WebCore::DOMCacheIdentifier>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.hadStorageError)>, bool>);
    struct ShouldBeSameSizeAsCacheIdentifierOperationResult : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::DOMCacheEngine::CacheIdentifierOperationResult>, false> {
        WebCore::DOMCacheIdentifier identifier;
        bool hadStorageError;
    };
    static_assert(sizeof(ShouldBeSameSizeAsCacheIdentifierOperationResult) == sizeof(WebCore::DOMCacheEngine::CacheIdentifierOperationResult));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::DOMCacheEngine::CacheIdentifierOperationResult, identifier)
        , offsetof(WebCore::DOMCacheEngine::CacheIdentifierOperationResult, hadStorageError)
    >::value);

    encoder << instance.identifier;
    encoder << instance.hadStorageError;
}

std::optional<WebCore::DOMCacheEngine::CacheIdentifierOperationResult> ArgumentCoder<WebCore::DOMCacheEngine::CacheIdentifierOperationResult>::decode(Decoder& decoder)
{
    auto identifier = decoder.decode<WebCore::DOMCacheIdentifier>();
    auto hadStorageError = decoder.decode<bool>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::DOMCacheEngine::CacheIdentifierOperationResult {
            WTFMove(*identifier),
            WTFMove(*hadStorageError)
        }
    };
}

#if HAVE(TRANSLATION_UI_SERVICES) && ENABLE(CONTEXT_MENUS)
void ArgumentCoder<WebCore::TranslationContextMenuInfo>::encode(Encoder& encoder, const WebCore::TranslationContextMenuInfo& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.text)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.selectionBoundsInRootView)>, WebCore::IntRect>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.locationInRootView)>, WebCore::IntPoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.mode)>, WebCore::TranslationContextMenuMode>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.source)>, WebCore::TranslationContextMenuSource>);
    struct ShouldBeSameSizeAsTranslationContextMenuInfo : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::TranslationContextMenuInfo>, false> {
        String text;
        WebCore::IntRect selectionBoundsInRootView;
        WebCore::IntPoint locationInRootView;
        WebCore::TranslationContextMenuMode mode;
        WebCore::TranslationContextMenuSource source;
    };
    static_assert(sizeof(ShouldBeSameSizeAsTranslationContextMenuInfo) == sizeof(WebCore::TranslationContextMenuInfo));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::TranslationContextMenuInfo, text)
        , offsetof(WebCore::TranslationContextMenuInfo, selectionBoundsInRootView)
        , offsetof(WebCore::TranslationContextMenuInfo, locationInRootView)
        , offsetof(WebCore::TranslationContextMenuInfo, mode)
        , offsetof(WebCore::TranslationContextMenuInfo, source)
    >::value);

    encoder << instance.text;
    encoder << instance.selectionBoundsInRootView;
    encoder << instance.locationInRootView;
    encoder << instance.mode;
    encoder << instance.source;
}

std::optional<WebCore::TranslationContextMenuInfo> ArgumentCoder<WebCore::TranslationContextMenuInfo>::decode(Decoder& decoder)
{
    auto text = decoder.decode<String>();
    auto selectionBoundsInRootView = decoder.decode<WebCore::IntRect>();
    auto locationInRootView = decoder.decode<WebCore::IntPoint>();
    auto mode = decoder.decode<WebCore::TranslationContextMenuMode>();
    auto source = decoder.decode<WebCore::TranslationContextMenuSource>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::TranslationContextMenuInfo {
            WTFMove(*text),
            WTFMove(*selectionBoundsInRootView),
            WTFMove(*locationInRootView),
            WTFMove(*mode),
            WTFMove(*source)
        }
    };
}

#endif

#if USE(APPKIT)
void ArgumentCoder<WebCore::AppKitControlSystemImage>::encode(Encoder& encoder, const WebCore::AppKitControlSystemImage& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_controlType)>, WebCore::AppKitControlSystemImageType>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_tintColor)>, WebCore::Color>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_useDarkAppearance)>, bool>);
    struct ShouldBeSameSizeAsAppKitControlSystemImage : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::AppKitControlSystemImage>, true> {
        WebCore::AppKitControlSystemImageType m_controlType;
        WebCore::Color m_tintColor;
        bool m_useDarkAppearance;
    };
    static_assert(sizeof(ShouldBeSameSizeAsAppKitControlSystemImage) == sizeof(WebCore::AppKitControlSystemImage));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::AppKitControlSystemImage, m_controlType)
        , offsetof(WebCore::AppKitControlSystemImage, m_tintColor)
        , offsetof(WebCore::AppKitControlSystemImage, m_useDarkAppearance)
    >::value);

    encoder << instance.m_tintColor;
    encoder << instance.m_useDarkAppearance;
}

void ArgumentCoder<WebCore::AppKitControlSystemImage>::encode(StreamConnectionEncoder& encoder, const WebCore::AppKitControlSystemImage& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_controlType)>, WebCore::AppKitControlSystemImageType>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_tintColor)>, WebCore::Color>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_useDarkAppearance)>, bool>);
    struct ShouldBeSameSizeAsAppKitControlSystemImage : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::AppKitControlSystemImage>, true> {
        WebCore::AppKitControlSystemImageType m_controlType;
        WebCore::Color m_tintColor;
        bool m_useDarkAppearance;
    };
    static_assert(sizeof(ShouldBeSameSizeAsAppKitControlSystemImage) == sizeof(WebCore::AppKitControlSystemImage));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::AppKitControlSystemImage, m_controlType)
        , offsetof(WebCore::AppKitControlSystemImage, m_tintColor)
        , offsetof(WebCore::AppKitControlSystemImage, m_useDarkAppearance)
    >::value);

    encoder << instance.m_tintColor;
    encoder << instance.m_useDarkAppearance;
}

std::optional<Ref<WebCore::AppKitControlSystemImage>> ArgumentCoder<WebCore::AppKitControlSystemImage>::decode(Decoder& decoder)
{
    auto m_tintColor = decoder.decode<WebCore::Color>();
    auto m_useDarkAppearance = decoder.decode<bool>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::ScrollbarTrackCornerSystemImageMac::create(
            WTFMove(*m_tintColor),
            WTFMove(*m_useDarkAppearance)
        )
    };
}

#endif

void ArgumentCoder<WebCore::Style::ListStyleType>::encode(Encoder& encoder, const WebCore::Style::ListStyleType& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.ipcData())>, Variant<WebCore::Style::ListStyleType::NoneData, WebCore::Style::ListStyleType::StringData, WebCore::Style::ListStyleType::CounterStyleData>>);

    encoder << instance.ipcData();
}

std::optional<WebCore::Style::ListStyleType> ArgumentCoder<WebCore::Style::ListStyleType>::decode(Decoder& decoder)
{
    auto ipcData = decoder.decode<Variant<WebCore::Style::ListStyleType::NoneData, WebCore::Style::ListStyleType::StringData, WebCore::Style::ListStyleType::CounterStyleData>>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::Style::ListStyleType {
            WTFMove(*ipcData)
        }
    };
}

void ArgumentCoder<WebCore::Style::ListStyleType::NoneData>::encode(Encoder& encoder, const WebCore::Style::ListStyleType::NoneData& instance)
{
    struct ShouldBeSameSizeAsNoneData : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::Style::ListStyleType::NoneData>, false> {
    };
    static_assert(sizeof(ShouldBeSameSizeAsNoneData) == sizeof(WebCore::Style::ListStyleType::NoneData));
    static_assert(MembersInCorrectOrder < 0
    >::value);

}

std::optional<WebCore::Style::ListStyleType::NoneData> ArgumentCoder<WebCore::Style::ListStyleType::NoneData>::decode(Decoder& decoder)
{
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::Style::ListStyleType::NoneData {
        }
    };
}

void ArgumentCoder<WebCore::Style::ListStyleType::StringData>::encode(Encoder& encoder, const WebCore::Style::ListStyleType::StringData& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.identifier)>, AtomString>);
    struct ShouldBeSameSizeAsStringData : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::Style::ListStyleType::StringData>, false> {
        AtomString identifier;
    };
    static_assert(sizeof(ShouldBeSameSizeAsStringData) == sizeof(WebCore::Style::ListStyleType::StringData));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::Style::ListStyleType::StringData, identifier)
    >::value);

    encoder << instance.identifier;
}

std::optional<WebCore::Style::ListStyleType::StringData> ArgumentCoder<WebCore::Style::ListStyleType::StringData>::decode(Decoder& decoder)
{
    auto identifier = decoder.decode<AtomString>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::Style::ListStyleType::StringData {
            WTFMove(*identifier)
        }
    };
}

void ArgumentCoder<WebCore::Style::ListStyleType::CounterStyleData>::encode(Encoder& encoder, const WebCore::Style::ListStyleType::CounterStyleData& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.identifier)>, AtomString>);
    struct ShouldBeSameSizeAsCounterStyleData : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::Style::ListStyleType::CounterStyleData>, false> {
        AtomString identifier;
    };
    static_assert(sizeof(ShouldBeSameSizeAsCounterStyleData) == sizeof(WebCore::Style::ListStyleType::CounterStyleData));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::Style::ListStyleType::CounterStyleData, identifier)
    >::value);

    encoder << instance.identifier;
}

std::optional<WebCore::Style::ListStyleType::CounterStyleData> ArgumentCoder<WebCore::Style::ListStyleType::CounterStyleData>::decode(Decoder& decoder)
{
    auto identifier = decoder.decode<AtomString>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::Style::ListStyleType::CounterStyleData {
            WTFMove(*identifier)
        }
    };
}

void ArgumentCoder<WebCore::DOMCacheEngine::CrossThreadRecord>::encode(Encoder& encoder, const WebCore::DOMCacheEngine::CrossThreadRecord& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.identifier)>, uint64_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.updateResponseCounter)>, uint64_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.requestHeadersGuard)>, WebCore::FetchHeadersGuard>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.request)>, WebCore::ResourceRequest>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.options)>, WebCore::FetchOptions>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.referrer)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.responseHeadersGuard)>, WebCore::FetchHeadersGuard>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.response)>, WebCore::ResourceResponseData>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.responseBody)>, Variant<std::nullptr_t, Ref<WebCore::FormData>, Ref<WebCore::SharedBuffer>>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.responseBodySize)>, uint64_t>);
    struct ShouldBeSameSizeAsCrossThreadRecord : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::DOMCacheEngine::CrossThreadRecord>, false> {
        uint64_t identifier;
        uint64_t updateResponseCounter;
        WebCore::FetchHeadersGuard requestHeadersGuard;
        WebCore::ResourceRequest request;
        WebCore::FetchOptions options;
        String referrer;
        WebCore::FetchHeadersGuard responseHeadersGuard;
        WebCore::ResourceResponseData response;
        Variant<std::nullptr_t, Ref<WebCore::FormData>, Ref<WebCore::SharedBuffer>> responseBody;
        uint64_t responseBodySize;
    };
    static_assert(sizeof(ShouldBeSameSizeAsCrossThreadRecord) == sizeof(WebCore::DOMCacheEngine::CrossThreadRecord));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::DOMCacheEngine::CrossThreadRecord, identifier)
        , offsetof(WebCore::DOMCacheEngine::CrossThreadRecord, updateResponseCounter)
        , offsetof(WebCore::DOMCacheEngine::CrossThreadRecord, requestHeadersGuard)
        , offsetof(WebCore::DOMCacheEngine::CrossThreadRecord, request)
        , offsetof(WebCore::DOMCacheEngine::CrossThreadRecord, options)
        , offsetof(WebCore::DOMCacheEngine::CrossThreadRecord, referrer)
        , offsetof(WebCore::DOMCacheEngine::CrossThreadRecord, responseHeadersGuard)
        , offsetof(WebCore::DOMCacheEngine::CrossThreadRecord, response)
        , offsetof(WebCore::DOMCacheEngine::CrossThreadRecord, responseBody)
        , offsetof(WebCore::DOMCacheEngine::CrossThreadRecord, responseBodySize)
    >::value);

    encoder << instance.identifier;
    encoder << instance.updateResponseCounter;
    encoder << instance.requestHeadersGuard;
    encoder << instance.request;
    encoder << instance.options;
    encoder << instance.referrer;
    encoder << instance.responseHeadersGuard;
    encoder << instance.response;
    encoder << instance.responseBody;
    encoder << instance.responseBodySize;
}

std::optional<WebCore::DOMCacheEngine::CrossThreadRecord> ArgumentCoder<WebCore::DOMCacheEngine::CrossThreadRecord>::decode(Decoder& decoder)
{
    auto identifier = decoder.decode<uint64_t>();
    auto updateResponseCounter = decoder.decode<uint64_t>();
    auto requestHeadersGuard = decoder.decode<WebCore::FetchHeadersGuard>();
    auto request = decoder.decode<WebCore::ResourceRequest>();
    auto options = decoder.decode<WebCore::FetchOptions>();
    auto referrer = decoder.decode<String>();
    auto responseHeadersGuard = decoder.decode<WebCore::FetchHeadersGuard>();
    auto response = decoder.decode<WebCore::ResourceResponseData>();
    auto responseBody = decoder.decode<Variant<std::nullptr_t, Ref<WebCore::FormData>, Ref<WebCore::SharedBuffer>>>();
    auto responseBodySize = decoder.decode<uint64_t>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::DOMCacheEngine::CrossThreadRecord {
            WTFMove(*identifier),
            WTFMove(*updateResponseCounter),
            WTFMove(*requestHeadersGuard),
            WTFMove(*request),
            WTFMove(*options),
            WTFMove(*referrer),
            WTFMove(*responseHeadersGuard),
            WTFMove(*response),
            WTFMove(*responseBody),
            WTFMove(*responseBodySize)
        }
    };
}

void ArgumentCoder<WebCore::TransformationMatrix>::encode(Encoder& encoder, const WebCore::TransformationMatrix& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m11())>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m12())>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m13())>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m14())>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m21())>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m22())>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m23())>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m24())>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m31())>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m32())>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m33())>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m34())>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m41())>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m42())>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m43())>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m44())>, double>);

    encoder << instance.m11();
    encoder << instance.m12();
    encoder << instance.m13();
    encoder << instance.m14();
    encoder << instance.m21();
    encoder << instance.m22();
    encoder << instance.m23();
    encoder << instance.m24();
    encoder << instance.m31();
    encoder << instance.m32();
    encoder << instance.m33();
    encoder << instance.m34();
    encoder << instance.m41();
    encoder << instance.m42();
    encoder << instance.m43();
    encoder << instance.m44();
}

void ArgumentCoder<WebCore::TransformationMatrix>::encode(StreamConnectionEncoder& encoder, const WebCore::TransformationMatrix& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m11())>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m12())>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m13())>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m14())>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m21())>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m22())>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m23())>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m24())>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m31())>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m32())>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m33())>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m34())>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m41())>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m42())>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m43())>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m44())>, double>);

    encoder << instance.m11();
    encoder << instance.m12();
    encoder << instance.m13();
    encoder << instance.m14();
    encoder << instance.m21();
    encoder << instance.m22();
    encoder << instance.m23();
    encoder << instance.m24();
    encoder << instance.m31();
    encoder << instance.m32();
    encoder << instance.m33();
    encoder << instance.m34();
    encoder << instance.m41();
    encoder << instance.m42();
    encoder << instance.m43();
    encoder << instance.m44();
}

std::optional<WebCore::TransformationMatrix> ArgumentCoder<WebCore::TransformationMatrix>::decode(Decoder& decoder)
{
    auto m11 = decoder.decode<double>();
    auto m12 = decoder.decode<double>();
    auto m13 = decoder.decode<double>();
    auto m14 = decoder.decode<double>();
    auto m21 = decoder.decode<double>();
    auto m22 = decoder.decode<double>();
    auto m23 = decoder.decode<double>();
    auto m24 = decoder.decode<double>();
    auto m31 = decoder.decode<double>();
    auto m32 = decoder.decode<double>();
    auto m33 = decoder.decode<double>();
    auto m34 = decoder.decode<double>();
    auto m41 = decoder.decode<double>();
    auto m42 = decoder.decode<double>();
    auto m43 = decoder.decode<double>();
    auto m44 = decoder.decode<double>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::TransformationMatrix {
            WTFMove(*m11),
            WTFMove(*m12),
            WTFMove(*m13),
            WTFMove(*m14),
            WTFMove(*m21),
            WTFMove(*m22),
            WTFMove(*m23),
            WTFMove(*m24),
            WTFMove(*m31),
            WTFMove(*m32),
            WTFMove(*m33),
            WTFMove(*m34),
            WTFMove(*m41),
            WTFMove(*m42),
            WTFMove(*m43),
            WTFMove(*m44)
        }
    };
}

void ArgumentCoder<WebCore::CacheQueryOptions>::encode(Encoder& encoder, const WebCore::CacheQueryOptions& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.ignoreSearch)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.ignoreMethod)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.ignoreVary)>, bool>);
    struct ShouldBeSameSizeAsCacheQueryOptions : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::CacheQueryOptions>, false> {
        bool ignoreSearch;
        bool ignoreMethod;
        bool ignoreVary;
    };
    static_assert(sizeof(ShouldBeSameSizeAsCacheQueryOptions) == sizeof(WebCore::CacheQueryOptions));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::CacheQueryOptions, ignoreSearch)
        , offsetof(WebCore::CacheQueryOptions, ignoreMethod)
        , offsetof(WebCore::CacheQueryOptions, ignoreVary)
    >::value);

    encoder << instance.ignoreSearch;
    encoder << instance.ignoreMethod;
    encoder << instance.ignoreVary;
}

std::optional<WebCore::CacheQueryOptions> ArgumentCoder<WebCore::CacheQueryOptions>::decode(Decoder& decoder)
{
    auto ignoreSearch = decoder.decode<bool>();
    auto ignoreMethod = decoder.decode<bool>();
    auto ignoreVary = decoder.decode<bool>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::CacheQueryOptions {
            WTFMove(*ignoreSearch),
            WTFMove(*ignoreMethod),
            WTFMove(*ignoreVary)
        }
    };
}

void ArgumentCoder<WebCore::CharacterRange>::encode(Encoder& encoder, const WebCore::CharacterRange& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.location)>, uint64_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.length)>, uint64_t>);
    struct ShouldBeSameSizeAsCharacterRange : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::CharacterRange>, false> {
        uint64_t location;
        uint64_t length;
    };
    static_assert(sizeof(ShouldBeSameSizeAsCharacterRange) == sizeof(WebCore::CharacterRange));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::CharacterRange, location)
        , offsetof(WebCore::CharacterRange, length)
    >::value);

    encoder << instance.location;
    encoder << instance.length;
}

std::optional<WebCore::CharacterRange> ArgumentCoder<WebCore::CharacterRange>::decode(Decoder& decoder)
{
    auto location = decoder.decode<uint64_t>();
    auto length = decoder.decode<uint64_t>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;

    if (!(!(CheckedUint64 { *location } + *length).hasOverflowed()))
        return std::nullopt;
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::CharacterRange {
            WTFMove(*location),
            WTFMove(*length)
        }
    };
}

void ArgumentCoder<WebCore::AffineTransform>::encode(Encoder& encoder, const WebCore::AffineTransform& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.span())>, std::span<const double, 6>>);

    encoder << instance.span();
}

void ArgumentCoder<WebCore::AffineTransform>::encode(StreamConnectionEncoder& encoder, const WebCore::AffineTransform& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.span())>, std::span<const double, 6>>);

    encoder << instance.span();
}

std::optional<WebCore::AffineTransform> ArgumentCoder<WebCore::AffineTransform>::decode(Decoder& decoder)
{
    auto span = decoder.decode<std::span<const double, 6>>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::AffineTransform {
            WTFMove(*span)
        }
    };
}

void ArgumentCoder<WebCore::FloatPoint>::encode(Encoder& encoder, const WebCore::FloatPoint& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.x())>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.y())>, float>);

    encoder << instance.x();
    encoder << instance.y();
}

void ArgumentCoder<WebCore::FloatPoint>::encode(StreamConnectionEncoder& encoder, const WebCore::FloatPoint& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.x())>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.y())>, float>);

    encoder << instance.x();
    encoder << instance.y();
}

std::optional<WebCore::FloatPoint> ArgumentCoder<WebCore::FloatPoint>::decode(Decoder& decoder)
{
    auto x = decoder.decode<float>();
    auto y = decoder.decode<float>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::FloatPoint {
            WTFMove(*x),
            WTFMove(*y)
        }
    };
}

void ArgumentCoder<WebCore::FloatPoint3D>::encode(Encoder& encoder, const WebCore::FloatPoint3D& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.x())>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.y())>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.z())>, float>);

    encoder << instance.x();
    encoder << instance.y();
    encoder << instance.z();
}

void ArgumentCoder<WebCore::FloatPoint3D>::encode(StreamConnectionEncoder& encoder, const WebCore::FloatPoint3D& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.x())>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.y())>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.z())>, float>);

    encoder << instance.x();
    encoder << instance.y();
    encoder << instance.z();
}

std::optional<WebCore::FloatPoint3D> ArgumentCoder<WebCore::FloatPoint3D>::decode(Decoder& decoder)
{
    auto x = decoder.decode<float>();
    auto y = decoder.decode<float>();
    auto z = decoder.decode<float>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::FloatPoint3D {
            WTFMove(*x),
            WTFMove(*y),
            WTFMove(*z)
        }
    };
}

void ArgumentCoder<WebCore::FloatQuad>::encode(Encoder& encoder, const WebCore::FloatQuad& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.p1())>, WebCore::FloatPoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.p2())>, WebCore::FloatPoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.p3())>, WebCore::FloatPoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.p4())>, WebCore::FloatPoint>);

    encoder << instance.p1();
    encoder << instance.p2();
    encoder << instance.p3();
    encoder << instance.p4();
}

std::optional<WebCore::FloatQuad> ArgumentCoder<WebCore::FloatQuad>::decode(Decoder& decoder)
{
    auto p1 = decoder.decode<WebCore::FloatPoint>();
    auto p2 = decoder.decode<WebCore::FloatPoint>();
    auto p3 = decoder.decode<WebCore::FloatPoint>();
    auto p4 = decoder.decode<WebCore::FloatPoint>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::FloatQuad {
            WTFMove(*p1),
            WTFMove(*p2),
            WTFMove(*p3),
            WTFMove(*p4)
        }
    };
}

void ArgumentCoder<WebCore::IDBCursorRecord>::encode(Encoder& encoder, const WebCore::IDBCursorRecord& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.key)>, WebCore::IDBKeyData>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.primaryKey)>, WebCore::IDBKeyData>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.value)>, WebCore::IDBValue>);
    struct ShouldBeSameSizeAsIDBCursorRecord : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::IDBCursorRecord>, false> {
        WebCore::IDBKeyData key;
        WebCore::IDBKeyData primaryKey;
        WebCore::IDBValue value;
    };
    static_assert(sizeof(ShouldBeSameSizeAsIDBCursorRecord) == sizeof(WebCore::IDBCursorRecord));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::IDBCursorRecord, key)
        , offsetof(WebCore::IDBCursorRecord, primaryKey)
        , offsetof(WebCore::IDBCursorRecord, value)
    >::value);

    encoder << instance.key;
    encoder << instance.primaryKey;
    encoder << instance.value;
}

std::optional<WebCore::IDBCursorRecord> ArgumentCoder<WebCore::IDBCursorRecord>::decode(Decoder& decoder)
{
    auto key = decoder.decode<WebCore::IDBKeyData>();
    auto primaryKey = decoder.decode<WebCore::IDBKeyData>();
    auto value = decoder.decode<WebCore::IDBValue>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::IDBCursorRecord {
            WTFMove(*key),
            WTFMove(*primaryKey),
            WTFMove(*value)
        }
    };
}

void ArgumentCoder<WebCore::IDBCursorInfo>::encode(Encoder& encoder, const WebCore::IDBCursorInfo& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.identifier())>, WebCore::IDBResourceIdentifier>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.transactionIdentifier())>, WebCore::IDBResourceIdentifier>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.objectStoreIdentifier())>, WebCore::IDBObjectStoreIdentifier>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.sourceIdentifier())>, Variant<WebCore::IDBObjectStoreIdentifier, WebCore::IDBIndexIdentifier>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.range())>, WebCore::IDBKeyRangeData>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.cursorSource())>, WebCore::IndexedDB::CursorSource>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.cursorDirection())>, WebCore::IndexedDB::CursorDirection>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.cursorType())>, WebCore::IndexedDB::CursorType>);

    encoder << instance.identifier();
    encoder << instance.transactionIdentifier();
    encoder << instance.objectStoreIdentifier();
    encoder << instance.sourceIdentifier();
    encoder << instance.range();
    encoder << instance.cursorSource();
    encoder << instance.cursorDirection();
    encoder << instance.cursorType();
}

std::optional<WebCore::IDBCursorInfo> ArgumentCoder<WebCore::IDBCursorInfo>::decode(Decoder& decoder)
{
    auto identifier = decoder.decode<WebCore::IDBResourceIdentifier>();
    auto transactionIdentifier = decoder.decode<WebCore::IDBResourceIdentifier>();
    auto objectStoreIdentifier = decoder.decode<WebCore::IDBObjectStoreIdentifier>();
    auto sourceIdentifier = decoder.decode<Variant<WebCore::IDBObjectStoreIdentifier, WebCore::IDBIndexIdentifier>>();
    auto range = decoder.decode<WebCore::IDBKeyRangeData>();
    auto cursorSource = decoder.decode<WebCore::IndexedDB::CursorSource>();
    auto cursorDirection = decoder.decode<WebCore::IndexedDB::CursorDirection>();
    auto cursorType = decoder.decode<WebCore::IndexedDB::CursorType>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::IDBCursorInfo {
            WTFMove(*identifier),
            WTFMove(*transactionIdentifier),
            WTFMove(*objectStoreIdentifier),
            WTFMove(*sourceIdentifier),
            WTFMove(*range),
            WTFMove(*cursorSource),
            WTFMove(*cursorDirection),
            WTFMove(*cursorType)
        }
    };
}

void ArgumentCoder<WebCore::IDBError>::encode(Encoder& encoder, const WebCore::IDBError& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.code())>, std::optional<WebCore::ExceptionCode>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.messageForSerialization())>, String>);

    encoder << instance.code();
    encoder << instance.messageForSerialization();
}

std::optional<WebCore::IDBError> ArgumentCoder<WebCore::IDBError>::decode(Decoder& decoder)
{
    auto code = decoder.decode<std::optional<WebCore::ExceptionCode>>();
    auto messageForSerialization = decoder.decode<String>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::IDBError {
            WTFMove(*code),
            WTFMove(*messageForSerialization)
        }
    };
}

void ArgumentCoder<WebCore::IDBGetAllRecordsData>::encode(Encoder& encoder, const WebCore::IDBGetAllRecordsData& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.keyRangeData)>, WebCore::IDBKeyRangeData>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.getAllType)>, WebCore::IndexedDB::GetAllType>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.count)>, std::optional<uint32_t>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.objectStoreIdentifier)>, WebCore::IDBObjectStoreIdentifier>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.indexIdentifier)>, std::optional<WebCore::IDBIndexIdentifier>>);
    struct ShouldBeSameSizeAsIDBGetAllRecordsData : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::IDBGetAllRecordsData>, false> {
        WebCore::IDBKeyRangeData keyRangeData;
        WebCore::IndexedDB::GetAllType getAllType;
        std::optional<uint32_t> count;
        WebCore::IDBObjectStoreIdentifier objectStoreIdentifier;
        std::optional<WebCore::IDBIndexIdentifier> indexIdentifier;
    };
    static_assert(sizeof(ShouldBeSameSizeAsIDBGetAllRecordsData) == sizeof(WebCore::IDBGetAllRecordsData));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::IDBGetAllRecordsData, keyRangeData)
        , offsetof(WebCore::IDBGetAllRecordsData, getAllType)
        , offsetof(WebCore::IDBGetAllRecordsData, count)
        , offsetof(WebCore::IDBGetAllRecordsData, objectStoreIdentifier)
        , offsetof(WebCore::IDBGetAllRecordsData, indexIdentifier)
    >::value);

    encoder << instance.keyRangeData;
    encoder << instance.getAllType;
    encoder << instance.count;
    encoder << instance.objectStoreIdentifier;
    encoder << instance.indexIdentifier;
}

std::optional<WebCore::IDBGetAllRecordsData> ArgumentCoder<WebCore::IDBGetAllRecordsData>::decode(Decoder& decoder)
{
    auto keyRangeData = decoder.decode<WebCore::IDBKeyRangeData>();
    auto getAllType = decoder.decode<WebCore::IndexedDB::GetAllType>();
    auto count = decoder.decode<std::optional<uint32_t>>();
    auto objectStoreIdentifier = decoder.decode<WebCore::IDBObjectStoreIdentifier>();
    auto indexIdentifier = decoder.decode<std::optional<WebCore::IDBIndexIdentifier>>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::IDBGetAllRecordsData {
            WTFMove(*keyRangeData),
            WTFMove(*getAllType),
            WTFMove(*count),
            WTFMove(*objectStoreIdentifier),
            WTFMove(*indexIdentifier)
        }
    };
}

void ArgumentCoder<WebCore::IDBGetResult>::encode(Encoder& encoder, const WebCore::IDBGetResult& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.keyData())>, WebCore::IDBKeyData>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.primaryKeyData())>, WebCore::IDBKeyData>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.value())>, WebCore::IDBValue>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.keyPath())>, std::optional<WebCore::IDBKeyPath>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.prefetchedRecords())>, Vector<WebCore::IDBCursorRecord>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isDefined())>, bool>);

    encoder << instance.keyData();
    encoder << instance.primaryKeyData();
    encoder << instance.value();
    encoder << instance.keyPath();
    encoder << instance.prefetchedRecords();
    encoder << instance.isDefined();
}

std::optional<WebCore::IDBGetResult> ArgumentCoder<WebCore::IDBGetResult>::decode(Decoder& decoder)
{
    auto keyData = decoder.decode<WebCore::IDBKeyData>();
    auto primaryKeyData = decoder.decode<WebCore::IDBKeyData>();
    auto value = decoder.decode<WebCore::IDBValue>();
    auto keyPath = decoder.decode<std::optional<WebCore::IDBKeyPath>>();
    auto prefetchedRecords = decoder.decode<Vector<WebCore::IDBCursorRecord>>();
    auto isDefined = decoder.decode<bool>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::IDBGetResult {
            WTFMove(*keyData),
            WTFMove(*primaryKeyData),
            WTFMove(*value),
            WTFMove(*keyPath),
            WTFMove(*prefetchedRecords),
            WTFMove(*isDefined)
        }
    };
}

void ArgumentCoder<WebCore::IDBGetAllResult>::encode(Encoder& encoder, const WebCore::IDBGetAllResult& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.type())>, WebCore::IndexedDB::GetAllType>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.keys())>, Vector<WebCore::IDBKeyData>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.values())>, Vector<WebCore::IDBValue>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.keyPath())>, std::optional<WebCore::IDBKeyPath>>);

    encoder << instance.type();
    encoder << instance.keys();
    encoder << instance.values();
    encoder << instance.keyPath();
}

std::optional<WebCore::IDBGetAllResult> ArgumentCoder<WebCore::IDBGetAllResult>::decode(Decoder& decoder)
{
    auto type = decoder.decode<WebCore::IndexedDB::GetAllType>();
    auto keys = decoder.decode<Vector<WebCore::IDBKeyData>>();
    auto values = decoder.decode<Vector<WebCore::IDBValue>>();
    auto keyPath = decoder.decode<std::optional<WebCore::IDBKeyPath>>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::IDBGetAllResult {
            WTFMove(*type),
            WTFMove(*keys),
            WTFMove(*values),
            WTFMove(*keyPath)
        }
    };
}

void ArgumentCoder<WebCore::IDBDatabaseInfo>::encode(Encoder& encoder, const WebCore::IDBDatabaseInfo& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_name)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_version)>, uint64_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_maxIndexID)>, uint64_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_objectStoreMap)>, HashMap<WebCore::IDBObjectStoreIdentifier, WebCore::IDBObjectStoreInfo>>);
    struct ShouldBeSameSizeAsIDBDatabaseInfo : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::IDBDatabaseInfo>, false> {
        String m_name;
        uint64_t m_version;
        uint64_t m_maxIndexID;
        HashMap<WebCore::IDBObjectStoreIdentifier, WebCore::IDBObjectStoreInfo> m_objectStoreMap;
    };
    static_assert(sizeof(ShouldBeSameSizeAsIDBDatabaseInfo) == sizeof(WebCore::IDBDatabaseInfo));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::IDBDatabaseInfo, m_name)
        , offsetof(WebCore::IDBDatabaseInfo, m_version)
        , offsetof(WebCore::IDBDatabaseInfo, m_maxIndexID)
        , offsetof(WebCore::IDBDatabaseInfo, m_objectStoreMap)
    >::value);

    encoder << instance.m_name;
    encoder << instance.m_version;
    encoder << instance.m_maxIndexID;
    encoder << instance.m_objectStoreMap;
}

std::optional<WebCore::IDBDatabaseInfo> ArgumentCoder<WebCore::IDBDatabaseInfo>::decode(Decoder& decoder)
{
    auto m_name = decoder.decode<String>();
    auto m_version = decoder.decode<uint64_t>();
    auto m_maxIndexID = decoder.decode<uint64_t>();
    auto m_objectStoreMap = decoder.decode<HashMap<WebCore::IDBObjectStoreIdentifier, WebCore::IDBObjectStoreInfo>>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::IDBDatabaseInfo {
            WTFMove(*m_name),
            WTFMove(*m_version),
            WTFMove(*m_maxIndexID),
            WTFMove(*m_objectStoreMap)
        }
    };
}

void ArgumentCoder<WebCore::IDBKeyRangeData>::encode(Encoder& encoder, const WebCore::IDBKeyRangeData& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.lowerKey)>, WebCore::IDBKeyData>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.upperKey)>, WebCore::IDBKeyData>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.lowerOpen)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.upperOpen)>, bool>);
    struct ShouldBeSameSizeAsIDBKeyRangeData : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::IDBKeyRangeData>, false> {
        WebCore::IDBKeyData lowerKey;
        WebCore::IDBKeyData upperKey;
        bool lowerOpen;
        bool upperOpen;
    };
    static_assert(sizeof(ShouldBeSameSizeAsIDBKeyRangeData) == sizeof(WebCore::IDBKeyRangeData));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::IDBKeyRangeData, lowerKey)
        , offsetof(WebCore::IDBKeyRangeData, upperKey)
        , offsetof(WebCore::IDBKeyRangeData, lowerOpen)
        , offsetof(WebCore::IDBKeyRangeData, upperOpen)
    >::value);

    encoder << instance.lowerKey;
    encoder << instance.upperKey;
    encoder << instance.lowerOpen;
    encoder << instance.upperOpen;
}

std::optional<WebCore::IDBKeyRangeData> ArgumentCoder<WebCore::IDBKeyRangeData>::decode(Decoder& decoder)
{
    auto lowerKey = decoder.decode<WebCore::IDBKeyData>();
    auto upperKey = decoder.decode<WebCore::IDBKeyData>();
    auto lowerOpen = decoder.decode<bool>();
    auto upperOpen = decoder.decode<bool>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::IDBKeyRangeData {
            WTFMove(*lowerKey),
            WTFMove(*upperKey),
            WTFMove(*lowerOpen),
            WTFMove(*upperOpen)
        }
    };
}

void ArgumentCoder<WebCore::IDBTransactionInfo>::encode(Encoder& encoder, const WebCore::IDBTransactionInfo& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.identifier())>, WebCore::IDBResourceIdentifier>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.mode())>, WebCore::IDBTransactionMode>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.durability())>, WebCore::IDBTransactionDurability>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.newVersion())>, uint64_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.objectStores())>, Vector<String>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.originalDatabaseInfo())>, std::unique_ptr<WebCore::IDBDatabaseInfo>>);

    encoder << instance.identifier();
    encoder << instance.mode();
    encoder << instance.durability();
    encoder << instance.newVersion();
    encoder << instance.objectStores();
    encoder << instance.originalDatabaseInfo();
}

std::optional<WebCore::IDBTransactionInfo> ArgumentCoder<WebCore::IDBTransactionInfo>::decode(Decoder& decoder)
{
    auto identifier = decoder.decode<WebCore::IDBResourceIdentifier>();
    auto mode = decoder.decode<WebCore::IDBTransactionMode>();
    auto durability = decoder.decode<WebCore::IDBTransactionDurability>();
    auto newVersion = decoder.decode<uint64_t>();
    auto objectStores = decoder.decode<Vector<String>>();
    auto originalDatabaseInfo = decoder.decode<std::unique_ptr<WebCore::IDBDatabaseInfo>>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::IDBTransactionInfo {
            WTFMove(*identifier),
            WTFMove(*mode),
            WTFMove(*durability),
            WTFMove(*newVersion),
            WTFMove(*objectStores),
            WTFMove(*originalDatabaseInfo)
        }
    };
}

void ArgumentCoder<WebCore::IDBGetRecordData>::encode(Encoder& encoder, const WebCore::IDBGetRecordData& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.keyRangeData)>, WebCore::IDBKeyRangeData>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.type)>, WebCore::IDBGetRecordDataType>);
    struct ShouldBeSameSizeAsIDBGetRecordData : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::IDBGetRecordData>, false> {
        WebCore::IDBKeyRangeData keyRangeData;
        WebCore::IDBGetRecordDataType type;
    };
    static_assert(sizeof(ShouldBeSameSizeAsIDBGetRecordData) == sizeof(WebCore::IDBGetRecordData));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::IDBGetRecordData, keyRangeData)
        , offsetof(WebCore::IDBGetRecordData, type)
    >::value);

    encoder << instance.keyRangeData;
    encoder << instance.type;
}

std::optional<WebCore::IDBGetRecordData> ArgumentCoder<WebCore::IDBGetRecordData>::decode(Decoder& decoder)
{
    auto keyRangeData = decoder.decode<WebCore::IDBKeyRangeData>();
    auto type = decoder.decode<WebCore::IDBGetRecordDataType>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::IDBGetRecordData {
            WTFMove(*keyRangeData),
            WTFMove(*type)
        }
    };
}

void ArgumentCoder<WebCore::IDBIndexInfo>::encode(Encoder& encoder, const WebCore::IDBIndexInfo& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.identifier())>, WebCore::IDBIndexIdentifier>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.objectStoreIdentifier())>, WebCore::IDBObjectStoreIdentifier>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.name())>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.keyPath())>, WebCore::IDBKeyPath>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.unique())>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.multiEntry())>, bool>);

    encoder << instance.identifier();
    encoder << instance.objectStoreIdentifier();
    encoder << instance.name();
    encoder << instance.keyPath();
    encoder << instance.unique();
    encoder << instance.multiEntry();
}

std::optional<WebCore::IDBIndexInfo> ArgumentCoder<WebCore::IDBIndexInfo>::decode(Decoder& decoder)
{
    auto identifier = decoder.decode<WebCore::IDBIndexIdentifier>();
    auto objectStoreIdentifier = decoder.decode<WebCore::IDBObjectStoreIdentifier>();
    auto name = decoder.decode<String>();
    auto keyPath = decoder.decode<WebCore::IDBKeyPath>();
    auto unique = decoder.decode<bool>();
    auto multiEntry = decoder.decode<bool>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::IDBIndexInfo {
            WTFMove(*identifier),
            WTFMove(*objectStoreIdentifier),
            WTFMove(*name),
            WTFMove(*keyPath),
            WTFMove(*unique),
            WTFMove(*multiEntry)
        }
    };
}

void ArgumentCoder<WebCore::IDBObjectStoreInfo>::encode(Encoder& encoder, const WebCore::IDBObjectStoreInfo& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.identifier())>, WebCore::IDBObjectStoreIdentifier>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.name())>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.keyPath())>, std::optional<WebCore::IDBKeyPath>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.autoIncrement())>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.indexMap())>, HashMap<WebCore::IDBIndexIdentifier, WebCore::IDBIndexInfo>>);

    encoder << instance.identifier();
    encoder << instance.name();
    encoder << instance.keyPath();
    encoder << instance.autoIncrement();
    encoder << instance.indexMap();
}

std::optional<WebCore::IDBObjectStoreInfo> ArgumentCoder<WebCore::IDBObjectStoreInfo>::decode(Decoder& decoder)
{
    auto identifier = decoder.decode<WebCore::IDBObjectStoreIdentifier>();
    auto name = decoder.decode<String>();
    auto keyPath = decoder.decode<std::optional<WebCore::IDBKeyPath>>();
    auto autoIncrement = decoder.decode<bool>();
    auto indexMap = decoder.decode<HashMap<WebCore::IDBIndexIdentifier, WebCore::IDBIndexInfo>>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::IDBObjectStoreInfo {
            WTFMove(*identifier),
            WTFMove(*name),
            WTFMove(*keyPath),
            WTFMove(*autoIncrement),
            WTFMove(*indexMap)
        }
    };
}

void ArgumentCoder<WebCore::IDBIterateCursorData>::encode(Encoder& encoder, const WebCore::IDBIterateCursorData& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.keyData)>, WebCore::IDBKeyData>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.primaryKeyData)>, WebCore::IDBKeyData>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.count)>, unsigned>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.option)>, WebCore::IndexedDB::CursorIterateOption>);
    struct ShouldBeSameSizeAsIDBIterateCursorData : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::IDBIterateCursorData>, false> {
        WebCore::IDBKeyData keyData;
        WebCore::IDBKeyData primaryKeyData;
        unsigned count;
        WebCore::IndexedDB::CursorIterateOption option;
    };
    static_assert(sizeof(ShouldBeSameSizeAsIDBIterateCursorData) == sizeof(WebCore::IDBIterateCursorData));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::IDBIterateCursorData, keyData)
        , offsetof(WebCore::IDBIterateCursorData, primaryKeyData)
        , offsetof(WebCore::IDBIterateCursorData, count)
        , offsetof(WebCore::IDBIterateCursorData, option)
    >::value);

    encoder << instance.keyData;
    encoder << instance.primaryKeyData;
    encoder << instance.count;
    encoder << instance.option;
}

std::optional<WebCore::IDBIterateCursorData> ArgumentCoder<WebCore::IDBIterateCursorData>::decode(Decoder& decoder)
{
    auto keyData = decoder.decode<WebCore::IDBKeyData>();
    auto primaryKeyData = decoder.decode<WebCore::IDBKeyData>();
    auto count = decoder.decode<unsigned>();
    auto option = decoder.decode<WebCore::IndexedDB::CursorIterateOption>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::IDBIterateCursorData {
            WTFMove(*keyData),
            WTFMove(*primaryKeyData),
            WTFMove(*count),
            WTFMove(*option)
        }
    };
}

void ArgumentCoder<WebCore::IDBResourceIdentifier>::encode(Encoder& encoder, const WebCore::IDBResourceIdentifier& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_idbConnectionIdentifier)>, Markable<WebCore::IDBConnectionIdentifier>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_resourceNumber)>, Markable<WebCore::IDBResourceObjectIdentifier>>);
    struct ShouldBeSameSizeAsIDBResourceIdentifier : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::IDBResourceIdentifier>, false> {
        Markable<WebCore::IDBConnectionIdentifier> m_idbConnectionIdentifier;
        Markable<WebCore::IDBResourceObjectIdentifier> m_resourceNumber;
    };
    static_assert(sizeof(ShouldBeSameSizeAsIDBResourceIdentifier) == sizeof(WebCore::IDBResourceIdentifier));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::IDBResourceIdentifier, m_idbConnectionIdentifier)
        , offsetof(WebCore::IDBResourceIdentifier, m_resourceNumber)
    >::value);

    encoder << instance.m_idbConnectionIdentifier;
    encoder << instance.m_resourceNumber;
}

std::optional<WebCore::IDBResourceIdentifier> ArgumentCoder<WebCore::IDBResourceIdentifier>::decode(Decoder& decoder)
{
    auto m_idbConnectionIdentifier = decoder.decode<Markable<WebCore::IDBConnectionIdentifier>>();
    auto m_resourceNumber = decoder.decode<Markable<WebCore::IDBResourceObjectIdentifier>>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::IDBResourceIdentifier {
            WTFMove(*m_idbConnectionIdentifier),
            WTFMove(*m_resourceNumber)
        }
    };
}

void ArgumentCoder<WebCore::IDBValue>::encode(Encoder& encoder, const WebCore::IDBValue& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.data())>, WebCore::ThreadSafeDataBuffer>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.blobURLs())>, Vector<String>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.blobFilePaths())>, Vector<String>>);

    encoder << instance.data();
    encoder << instance.blobURLs();
    encoder << instance.blobFilePaths();
}

std::optional<WebCore::IDBValue> ArgumentCoder<WebCore::IDBValue>::decode(Decoder& decoder)
{
    auto data = decoder.decode<WebCore::ThreadSafeDataBuffer>();
    auto blobURLs = decoder.decode<Vector<String>>();
    auto blobFilePaths = decoder.decode<Vector<String>>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::IDBValue {
            WTFMove(*data),
            WTFMove(*blobURLs),
            WTFMove(*blobFilePaths)
        }
    };
}

void ArgumentCoder<WebCore::IDBOpenRequestData>::encode(Encoder& encoder, const WebCore::IDBOpenRequestData& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_serverConnectionIdentifier)>, WebCore::IDBConnectionIdentifier>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_requestIdentifier)>, WebCore::IDBResourceIdentifier>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_databaseIdentifier)>, WebCore::IDBDatabaseIdentifier>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_requestedVersion)>, uint64_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_requestType)>, WebCore::IndexedDB::RequestType>);
    struct ShouldBeSameSizeAsIDBOpenRequestData : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::IDBOpenRequestData>, false> {
        WebCore::IDBConnectionIdentifier m_serverConnectionIdentifier;
        WebCore::IDBResourceIdentifier m_requestIdentifier;
        WebCore::IDBDatabaseIdentifier m_databaseIdentifier;
        uint64_t m_requestedVersion;
        WebCore::IndexedDB::RequestType m_requestType;
    };
    static_assert(sizeof(ShouldBeSameSizeAsIDBOpenRequestData) == sizeof(WebCore::IDBOpenRequestData));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::IDBOpenRequestData, m_serverConnectionIdentifier)
        , offsetof(WebCore::IDBOpenRequestData, m_requestIdentifier)
        , offsetof(WebCore::IDBOpenRequestData, m_databaseIdentifier)
        , offsetof(WebCore::IDBOpenRequestData, m_requestedVersion)
        , offsetof(WebCore::IDBOpenRequestData, m_requestType)
    >::value);

    encoder << instance.m_serverConnectionIdentifier;
    encoder << instance.m_requestIdentifier;
    encoder << instance.m_databaseIdentifier;
    encoder << instance.m_requestedVersion;
    encoder << instance.m_requestType;
}

std::optional<WebCore::IDBOpenRequestData> ArgumentCoder<WebCore::IDBOpenRequestData>::decode(Decoder& decoder)
{
    auto m_serverConnectionIdentifier = decoder.decode<WebCore::IDBConnectionIdentifier>();
    auto m_requestIdentifier = decoder.decode<WebCore::IDBResourceIdentifier>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;

    if (!(!m_requestIdentifier->isEmpty()))
        return std::nullopt;
    auto m_databaseIdentifier = decoder.decode<WebCore::IDBDatabaseIdentifier>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;

    if (!(m_databaseIdentifier->isValid()))
        return std::nullopt;
    auto m_requestedVersion = decoder.decode<uint64_t>();
    auto m_requestType = decoder.decode<WebCore::IndexedDB::RequestType>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::IDBOpenRequestData {
            WTFMove(*m_serverConnectionIdentifier),
            WTFMove(*m_requestIdentifier),
            WTFMove(*m_databaseIdentifier),
            WTFMove(*m_requestedVersion),
            WTFMove(*m_requestType)
        }
    };
}

void ArgumentCoder<WebCore::IDBRequestData>::encode(Encoder& encoder, const WebCore::IDBRequestData& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_serverConnectionIdentifier)>, WebCore::IDBConnectionIdentifier>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_requestIdentifier)>, WebCore::IDBResourceIdentifier>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_transactionIdentifier)>, WebCore::IDBResourceIdentifier>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_cursorIdentifier)>, std::optional<WebCore::IDBResourceIdentifier>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_objectStoreIdentifier)>, Markable<WebCore::IDBObjectStoreIdentifier>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_indexIdentifier)>, Markable<WebCore::IDBIndexIdentifier>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_indexRecordType)>, WebCore::IndexedDB::IndexRecordType>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_requestedVersion)>, uint64_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_requestType)>, WebCore::IndexedDB::RequestType>);
    struct ShouldBeSameSizeAsIDBRequestData : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::IDBRequestData>, false> {
        WebCore::IDBConnectionIdentifier m_serverConnectionIdentifier;
        WebCore::IDBResourceIdentifier m_requestIdentifier;
        WebCore::IDBResourceIdentifier m_transactionIdentifier;
        std::optional<WebCore::IDBResourceIdentifier> m_cursorIdentifier;
        Markable<WebCore::IDBObjectStoreIdentifier> m_objectStoreIdentifier;
        Markable<WebCore::IDBIndexIdentifier> m_indexIdentifier;
        WebCore::IndexedDB::IndexRecordType m_indexRecordType;
        uint64_t m_requestedVersion;
        WebCore::IndexedDB::RequestType m_requestType;
    };
    static_assert(sizeof(ShouldBeSameSizeAsIDBRequestData) == sizeof(WebCore::IDBRequestData));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::IDBRequestData, m_serverConnectionIdentifier)
        , offsetof(WebCore::IDBRequestData, m_requestIdentifier)
        , offsetof(WebCore::IDBRequestData, m_transactionIdentifier)
        , offsetof(WebCore::IDBRequestData, m_cursorIdentifier)
        , offsetof(WebCore::IDBRequestData, m_objectStoreIdentifier)
        , offsetof(WebCore::IDBRequestData, m_indexIdentifier)
        , offsetof(WebCore::IDBRequestData, m_indexRecordType)
        , offsetof(WebCore::IDBRequestData, m_requestedVersion)
        , offsetof(WebCore::IDBRequestData, m_requestType)
    >::value);

    encoder << instance.m_serverConnectionIdentifier;
    encoder << instance.m_requestIdentifier;
    encoder << instance.m_transactionIdentifier;
    encoder << instance.m_cursorIdentifier;
    encoder << instance.m_objectStoreIdentifier;
    encoder << instance.m_indexIdentifier;
    encoder << instance.m_indexRecordType;
    encoder << instance.m_requestedVersion;
    encoder << instance.m_requestType;
}

std::optional<WebCore::IDBRequestData> ArgumentCoder<WebCore::IDBRequestData>::decode(Decoder& decoder)
{
    auto m_serverConnectionIdentifier = decoder.decode<WebCore::IDBConnectionIdentifier>();
    auto m_requestIdentifier = decoder.decode<WebCore::IDBResourceIdentifier>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;

    if (!(!m_requestIdentifier->isEmpty()))
        return std::nullopt;
    auto m_transactionIdentifier = decoder.decode<WebCore::IDBResourceIdentifier>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;

    if (!(!m_transactionIdentifier->isEmpty()))
        return std::nullopt;
    auto m_cursorIdentifier = decoder.decode<std::optional<WebCore::IDBResourceIdentifier>>();
    auto m_objectStoreIdentifier = decoder.decode<Markable<WebCore::IDBObjectStoreIdentifier>>();
    auto m_indexIdentifier = decoder.decode<Markable<WebCore::IDBIndexIdentifier>>();
    auto m_indexRecordType = decoder.decode<WebCore::IndexedDB::IndexRecordType>();
    auto m_requestedVersion = decoder.decode<uint64_t>();
    auto m_requestType = decoder.decode<WebCore::IndexedDB::RequestType>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::IDBRequestData {
            WTFMove(*m_serverConnectionIdentifier),
            WTFMove(*m_requestIdentifier),
            WTFMove(*m_transactionIdentifier),
            WTFMove(*m_cursorIdentifier),
            WTFMove(*m_objectStoreIdentifier),
            WTFMove(*m_indexIdentifier),
            WTFMove(*m_indexRecordType),
            WTFMove(*m_requestedVersion),
            WTFMove(*m_requestType)
        }
    };
}

void ArgumentCoder<WebCore::IDBDatabaseIdentifier>::encode(Encoder& encoder, const WebCore::IDBDatabaseIdentifier& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_databaseName)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_origin)>, WebCore::ClientOrigin>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_isTransient)>, bool>);
    struct ShouldBeSameSizeAsIDBDatabaseIdentifier : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::IDBDatabaseIdentifier>, false> {
        String m_databaseName;
        WebCore::ClientOrigin m_origin;
        bool m_isTransient;
    };
    static_assert(sizeof(ShouldBeSameSizeAsIDBDatabaseIdentifier) == sizeof(WebCore::IDBDatabaseIdentifier));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::IDBDatabaseIdentifier, m_databaseName)
        , offsetof(WebCore::IDBDatabaseIdentifier, m_origin)
        , offsetof(WebCore::IDBDatabaseIdentifier, m_isTransient)
    >::value);

    encoder << instance.m_databaseName;
    encoder << instance.m_origin;
    encoder << instance.m_isTransient;
}

std::optional<WebCore::IDBDatabaseIdentifier> ArgumentCoder<WebCore::IDBDatabaseIdentifier>::decode(Decoder& decoder)
{
    auto m_databaseName = decoder.decode<String>();
    auto m_origin = decoder.decode<WebCore::ClientOrigin>();
    auto m_isTransient = decoder.decode<bool>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    WebCore::IDBDatabaseIdentifier result;
    result.m_databaseName = WTFMove(*m_databaseName);
    result.m_origin = WTFMove(*m_origin);
    result.m_isTransient = WTFMove(*m_isTransient);
    return { WTFMove(result) };
}

void ArgumentCoder<WebCore::IDBDatabaseNameAndVersion>::encode(Encoder& encoder, const WebCore::IDBDatabaseNameAndVersion& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.name)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.version)>, uint64_t>);
    struct ShouldBeSameSizeAsIDBDatabaseNameAndVersion : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::IDBDatabaseNameAndVersion>, false> {
        String name;
        uint64_t version;
    };
    static_assert(sizeof(ShouldBeSameSizeAsIDBDatabaseNameAndVersion) == sizeof(WebCore::IDBDatabaseNameAndVersion));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::IDBDatabaseNameAndVersion, name)
        , offsetof(WebCore::IDBDatabaseNameAndVersion, version)
    >::value);

    encoder << instance.name;
    encoder << instance.version;
}

std::optional<WebCore::IDBDatabaseNameAndVersion> ArgumentCoder<WebCore::IDBDatabaseNameAndVersion>::decode(Decoder& decoder)
{
    auto name = decoder.decode<String>();
    auto version = decoder.decode<uint64_t>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::IDBDatabaseNameAndVersion {
            WTFMove(*name),
            WTFMove(*version)
        }
    };
}

void ArgumentCoder<WebCore::IDBResultData>::encode(Encoder& encoder, const WebCore::IDBResultData& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_type)>, WebCore::IDBResultType>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_requestIdentifier)>, WebCore::IDBResourceIdentifier>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_error)>, WebCore::IDBError>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_databaseConnectionIdentifier)>, std::optional<WebCore::IDBDatabaseConnectionIdentifier>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_databaseInfo)>, std::unique_ptr<WebCore::IDBDatabaseInfo>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_transactionInfo)>, std::unique_ptr<WebCore::IDBTransactionInfo>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_resultKey)>, std::unique_ptr<WebCore::IDBKeyData>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_getResult)>, std::unique_ptr<WebCore::IDBGetResult>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_getAllResult)>, std::unique_ptr<WebCore::IDBGetAllResult>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_resultInteger)>, uint64_t>);
    struct ShouldBeSameSizeAsIDBResultData : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::IDBResultData>, false> {
        WebCore::IDBResultType m_type;
        WebCore::IDBResourceIdentifier m_requestIdentifier;
        WebCore::IDBError m_error;
        std::optional<WebCore::IDBDatabaseConnectionIdentifier> m_databaseConnectionIdentifier;
        std::unique_ptr<WebCore::IDBDatabaseInfo> m_databaseInfo;
        std::unique_ptr<WebCore::IDBTransactionInfo> m_transactionInfo;
        std::unique_ptr<WebCore::IDBKeyData> m_resultKey;
        std::unique_ptr<WebCore::IDBGetResult> m_getResult;
        std::unique_ptr<WebCore::IDBGetAllResult> m_getAllResult;
        uint64_t m_resultInteger;
    };
    static_assert(sizeof(ShouldBeSameSizeAsIDBResultData) == sizeof(WebCore::IDBResultData));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::IDBResultData, m_type)
        , offsetof(WebCore::IDBResultData, m_requestIdentifier)
        , offsetof(WebCore::IDBResultData, m_error)
        , offsetof(WebCore::IDBResultData, m_databaseConnectionIdentifier)
        , offsetof(WebCore::IDBResultData, m_databaseInfo)
        , offsetof(WebCore::IDBResultData, m_transactionInfo)
        , offsetof(WebCore::IDBResultData, m_resultKey)
        , offsetof(WebCore::IDBResultData, m_getResult)
        , offsetof(WebCore::IDBResultData, m_getAllResult)
        , offsetof(WebCore::IDBResultData, m_resultInteger)
    >::value);

    encoder << instance.m_type;
    encoder << instance.m_requestIdentifier;
    encoder << instance.m_error;
    encoder << instance.m_databaseConnectionIdentifier;
    encoder << instance.m_databaseInfo;
    encoder << instance.m_transactionInfo;
    encoder << instance.m_resultKey;
    encoder << instance.m_getResult;
    encoder << instance.m_getAllResult;
    encoder << instance.m_resultInteger;
}

std::optional<WebCore::IDBResultData> ArgumentCoder<WebCore::IDBResultData>::decode(Decoder& decoder)
{
    auto m_type = decoder.decode<WebCore::IDBResultType>();
    auto m_requestIdentifier = decoder.decode<WebCore::IDBResourceIdentifier>();
    auto m_error = decoder.decode<WebCore::IDBError>();
    auto m_databaseConnectionIdentifier = decoder.decode<std::optional<WebCore::IDBDatabaseConnectionIdentifier>>();
    auto m_databaseInfo = decoder.decode<std::unique_ptr<WebCore::IDBDatabaseInfo>>();
    auto m_transactionInfo = decoder.decode<std::unique_ptr<WebCore::IDBTransactionInfo>>();
    auto m_resultKey = decoder.decode<std::unique_ptr<WebCore::IDBKeyData>>();
    auto m_getResult = decoder.decode<std::unique_ptr<WebCore::IDBGetResult>>();
    auto m_getAllResult = decoder.decode<std::unique_ptr<WebCore::IDBGetAllResult>>();
    auto m_resultInteger = decoder.decode<uint64_t>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    WebCore::IDBResultData result;
    result.m_type = WTFMove(*m_type);
    result.m_requestIdentifier = WTFMove(*m_requestIdentifier);
    result.m_error = WTFMove(*m_error);
    result.m_databaseConnectionIdentifier = WTFMove(*m_databaseConnectionIdentifier);
    result.m_databaseInfo = WTFMove(*m_databaseInfo);
    result.m_transactionInfo = WTFMove(*m_transactionInfo);
    result.m_resultKey = WTFMove(*m_resultKey);
    result.m_getResult = WTFMove(*m_getResult);
    result.m_getAllResult = WTFMove(*m_getAllResult);
    result.m_resultInteger = WTFMove(*m_resultInteger);
    return { WTFMove(result) };
}

void ArgumentCoder<WebCore::IDBKeyData>::encode(Encoder& encoder, const WebCore::IDBKeyData& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isPlaceholder())>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.value())>, Variant<std::nullptr_t, WebCore::IDBKeyData::Invalid, Vector<WebCore::IDBKeyData>, String, double, WebCore::IDBKeyData::Date, WebCore::ThreadSafeDataBuffer, WebCore::IDBKeyData::Min, WebCore::IDBKeyData::Max>>);

    encoder << instance.isPlaceholder();
    encoder << instance.value();
}

std::optional<WebCore::IDBKeyData> ArgumentCoder<WebCore::IDBKeyData>::decode(Decoder& decoder)
{
    auto isPlaceholder = decoder.decode<bool>();
    auto value = decoder.decode<Variant<std::nullptr_t, WebCore::IDBKeyData::Invalid, Vector<WebCore::IDBKeyData>, String, double, WebCore::IDBKeyData::Date, WebCore::ThreadSafeDataBuffer, WebCore::IDBKeyData::Min, WebCore::IDBKeyData::Max>>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;

    if (!(WebCore::IDBKeyData::isValidValue(*value)))
        return std::nullopt;
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::IDBKeyData {
            WTFMove(*isPlaceholder),
            WTFMove(*value)
        }
    };
}

void ArgumentCoder<WebCore::IDBKeyData::Invalid>::encode(Encoder& encoder, const WebCore::IDBKeyData::Invalid& instance)
{
    struct ShouldBeSameSizeAsInvalid : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::IDBKeyData::Invalid>, false> {
    };
    static_assert(sizeof(ShouldBeSameSizeAsInvalid) == sizeof(WebCore::IDBKeyData::Invalid));
    static_assert(MembersInCorrectOrder < 0
    >::value);

}

std::optional<WebCore::IDBKeyData::Invalid> ArgumentCoder<WebCore::IDBKeyData::Invalid>::decode(Decoder& decoder)
{
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::IDBKeyData::Invalid {
        }
    };
}

void ArgumentCoder<WebCore::IDBKeyData::Min>::encode(Encoder& encoder, const WebCore::IDBKeyData::Min& instance)
{
    struct ShouldBeSameSizeAsMin : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::IDBKeyData::Min>, false> {
    };
    static_assert(sizeof(ShouldBeSameSizeAsMin) == sizeof(WebCore::IDBKeyData::Min));
    static_assert(MembersInCorrectOrder < 0
    >::value);

}

std::optional<WebCore::IDBKeyData::Min> ArgumentCoder<WebCore::IDBKeyData::Min>::decode(Decoder& decoder)
{
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::IDBKeyData::Min {
        }
    };
}

void ArgumentCoder<WebCore::IDBKeyData::Max>::encode(Encoder& encoder, const WebCore::IDBKeyData::Max& instance)
{
    struct ShouldBeSameSizeAsMax : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::IDBKeyData::Max>, false> {
    };
    static_assert(sizeof(ShouldBeSameSizeAsMax) == sizeof(WebCore::IDBKeyData::Max));
    static_assert(MembersInCorrectOrder < 0
    >::value);

}

std::optional<WebCore::IDBKeyData::Max> ArgumentCoder<WebCore::IDBKeyData::Max>::decode(Decoder& decoder)
{
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::IDBKeyData::Max {
        }
    };
}

void ArgumentCoder<WebCore::IDBKeyData::Date>::encode(Encoder& encoder, const WebCore::IDBKeyData::Date& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.value)>, double>);
    struct ShouldBeSameSizeAsDate : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::IDBKeyData::Date>, false> {
        double value;
    };
    static_assert(sizeof(ShouldBeSameSizeAsDate) == sizeof(WebCore::IDBKeyData::Date));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::IDBKeyData::Date, value)
    >::value);

    encoder << instance.value;
}

std::optional<WebCore::IDBKeyData::Date> ArgumentCoder<WebCore::IDBKeyData::Date>::decode(Decoder& decoder)
{
    auto value = decoder.decode<double>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::IDBKeyData::Date {
            WTFMove(*value)
        }
    };
}

void ArgumentCoder<WebCore::IndexKey>::encode(Encoder& encoder, const WebCore::IndexKey& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.data())>, Variant<std::nullptr_t, WebCore::IDBKeyData, Vector<WebCore::IDBKeyData>>>);

    encoder << instance.data();
}

std::optional<WebCore::IndexKey> ArgumentCoder<WebCore::IndexKey>::decode(Decoder& decoder)
{
    auto data = decoder.decode<Variant<std::nullptr_t, WebCore::IDBKeyData, Vector<WebCore::IDBKeyData>>>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::IndexKey {
            WTFMove(*data)
        }
    };
}

void ArgumentCoder<WebCore::FloatRect>::encode(Encoder& encoder, const WebCore::FloatRect& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.location())>, WebCore::FloatPoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.size())>, WebCore::FloatSize>);

    encoder << instance.location();
    encoder << instance.size();
}

void ArgumentCoder<WebCore::FloatRect>::encode(StreamConnectionEncoder& encoder, const WebCore::FloatRect& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.location())>, WebCore::FloatPoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.size())>, WebCore::FloatSize>);

    encoder << instance.location();
    encoder << instance.size();
}

std::optional<WebCore::FloatRect> ArgumentCoder<WebCore::FloatRect>::decode(Decoder& decoder)
{
    auto location = decoder.decode<WebCore::FloatPoint>();
    auto size = decoder.decode<WebCore::FloatSize>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::FloatRect {
            WTFMove(*location),
            WTFMove(*size)
        }
    };
}

void ArgumentCoder<WebCore::LinearTimingFunction::Point>::encode(Encoder& encoder, const WebCore::LinearTimingFunction::Point& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.value)>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.progress)>, double>);
    struct ShouldBeSameSizeAsPoint : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::LinearTimingFunction::Point>, false> {
        double value;
        double progress;
    };
    static_assert(sizeof(ShouldBeSameSizeAsPoint) == sizeof(WebCore::LinearTimingFunction::Point));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::LinearTimingFunction::Point, value)
        , offsetof(WebCore::LinearTimingFunction::Point, progress)
    >::value);

    encoder << instance.value;
    encoder << instance.progress;
}

std::optional<WebCore::LinearTimingFunction::Point> ArgumentCoder<WebCore::LinearTimingFunction::Point>::decode(Decoder& decoder)
{
    auto value = decoder.decode<double>();
    auto progress = decoder.decode<double>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::LinearTimingFunction::Point {
            WTFMove(*value),
            WTFMove(*progress)
        }
    };
}

void ArgumentCoder<WebCore::LinearTimingFunction>::encode(Encoder& encoder, const WebCore::LinearTimingFunction& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.points())>, Vector<WebCore::LinearTimingFunction::Point>>);

    encoder << instance.points();
}

std::optional<Ref<WebCore::LinearTimingFunction>> ArgumentCoder<WebCore::LinearTimingFunction>::decode(Decoder& decoder)
{
    auto points = decoder.decode<Vector<WebCore::LinearTimingFunction::Point>>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::LinearTimingFunction::create(
            WTFMove(*points)
        )
    };
}

void ArgumentCoder<WebCore::CubicBezierTimingFunction>::encode(Encoder& encoder, const WebCore::CubicBezierTimingFunction& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.timingFunctionPreset())>, WebCore::CubicBezierTimingFunction::TimingFunctionPreset>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.x1())>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.y1())>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.x2())>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.y2())>, double>);

    encoder << instance.timingFunctionPreset();
    encoder << instance.x1();
    encoder << instance.y1();
    encoder << instance.x2();
    encoder << instance.y2();
}

std::optional<Ref<WebCore::CubicBezierTimingFunction>> ArgumentCoder<WebCore::CubicBezierTimingFunction>::decode(Decoder& decoder)
{
    auto timingFunctionPreset = decoder.decode<WebCore::CubicBezierTimingFunction::TimingFunctionPreset>();
    auto x1 = decoder.decode<double>();
    auto y1 = decoder.decode<double>();
    auto x2 = decoder.decode<double>();
    auto y2 = decoder.decode<double>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::CubicBezierTimingFunction::create(
            WTFMove(*timingFunctionPreset),
            WTFMove(*x1),
            WTFMove(*y1),
            WTFMove(*x2),
            WTFMove(*y2)
        )
    };
}

void ArgumentCoder<WebCore::StepsTimingFunction>::encode(Encoder& encoder, const WebCore::StepsTimingFunction& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.numberOfSteps())>, int>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.stepPosition())>, std::optional<WebCore::StepsTimingFunction::StepPosition>>);

    encoder << instance.numberOfSteps();
    encoder << instance.stepPosition();
}

std::optional<Ref<WebCore::StepsTimingFunction>> ArgumentCoder<WebCore::StepsTimingFunction>::decode(Decoder& decoder)
{
    auto numberOfSteps = decoder.decode<int>();
    auto stepPosition = decoder.decode<std::optional<WebCore::StepsTimingFunction::StepPosition>>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::StepsTimingFunction::create(
            WTFMove(*numberOfSteps),
            WTFMove(*stepPosition)
        )
    };
}

void ArgumentCoder<WebCore::SpringTimingFunction>::encode(Encoder& encoder, const WebCore::SpringTimingFunction& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.mass())>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.stiffness())>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.damping())>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.initialVelocity())>, double>);

    encoder << instance.mass();
    encoder << instance.stiffness();
    encoder << instance.damping();
    encoder << instance.initialVelocity();
}

std::optional<Ref<WebCore::SpringTimingFunction>> ArgumentCoder<WebCore::SpringTimingFunction>::decode(Decoder& decoder)
{
    auto mass = decoder.decode<double>();
    auto stiffness = decoder.decode<double>();
    auto damping = decoder.decode<double>();
    auto initialVelocity = decoder.decode<double>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::SpringTimingFunction::create(
            WTFMove(*mass),
            WTFMove(*stiffness),
            WTFMove(*damping),
            WTFMove(*initialVelocity)
        )
    };
}

void ArgumentCoder<WebCore::ResourceLoadStatistics>::encode(Encoder& encoder, const WebCore::ResourceLoadStatistics& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.registrableDomain)>, WebCore::RegistrableDomain>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.lastSeen)>, WallTime>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.hadUserInteraction)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.mostRecentUserInteractionTime)>, WallTime>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.grandfathered)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.storageAccessUnderTopFrameDomains)>, HashSet<WebCore::RegistrableDomain>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.topFrameUniqueRedirectsTo)>, HashSet<WebCore::RegistrableDomain>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.topFrameUniqueRedirectsToSinceSameSiteStrictEnforcement)>, HashSet<WebCore::RegistrableDomain>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.topFrameUniqueRedirectsFrom)>, HashSet<WebCore::RegistrableDomain>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.topFrameLinkDecorationsFrom)>, HashSet<WebCore::RegistrableDomain>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.gotLinkDecorationFromPrevalentResource)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.topFrameLoadedThirdPartyScripts)>, HashSet<WebCore::RegistrableDomain>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.subframeUnderTopFrameDomains)>, HashSet<WebCore::RegistrableDomain>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.subresourceUnderTopFrameDomains)>, HashSet<WebCore::RegistrableDomain>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.subresourceUniqueRedirectsTo)>, HashSet<WebCore::RegistrableDomain>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.subresourceUniqueRedirectsFrom)>, HashSet<WebCore::RegistrableDomain>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isPrevalentResource)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isVeryPrevalentResource)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.dataRecordsRemoved)>, unsigned>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.timesAccessedAsFirstPartyDueToUserInteraction)>, unsigned>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.timesAccessedAsFirstPartyDueToStorageAccessAPI)>, unsigned>);
#if ENABLE(WEB_API_STATISTICS)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.topFrameRegistrableDomainsWhichAccessedWebAPIs)>, HashSet<WebCore::RegistrableDomain>>);
#endif
#if ENABLE(WEB_API_STATISTICS)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.fontsFailedToLoad)>, HashSet<String>>);
#endif
#if ENABLE(WEB_API_STATISTICS)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.fontsSuccessfullyLoaded)>, HashSet<String>>);
#endif
#if ENABLE(WEB_API_STATISTICS)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.canvasActivityRecord)>, WebCore::CanvasActivityRecord>);
#endif
#if ENABLE(WEB_API_STATISTICS)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.navigatorFunctionsAccessed)>, OptionSet<WebCore::NavigatorAPIsAccessed>>);
#endif
#if ENABLE(WEB_API_STATISTICS)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.screenFunctionsAccessed)>, OptionSet<WebCore::ScreenAPIsAccessed>>);
#endif
    struct ShouldBeSameSizeAsResourceLoadStatistics : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::ResourceLoadStatistics>, false> {
        WebCore::RegistrableDomain registrableDomain;
        WallTime lastSeen;
        bool hadUserInteraction;
        WallTime mostRecentUserInteractionTime;
        bool grandfathered;
        HashSet<WebCore::RegistrableDomain> storageAccessUnderTopFrameDomains;
        HashSet<WebCore::RegistrableDomain> topFrameUniqueRedirectsTo;
        HashSet<WebCore::RegistrableDomain> topFrameUniqueRedirectsToSinceSameSiteStrictEnforcement;
        HashSet<WebCore::RegistrableDomain> topFrameUniqueRedirectsFrom;
        HashSet<WebCore::RegistrableDomain> topFrameLinkDecorationsFrom;
        bool gotLinkDecorationFromPrevalentResource;
        HashSet<WebCore::RegistrableDomain> topFrameLoadedThirdPartyScripts;
        HashSet<WebCore::RegistrableDomain> subframeUnderTopFrameDomains;
        HashSet<WebCore::RegistrableDomain> subresourceUnderTopFrameDomains;
        HashSet<WebCore::RegistrableDomain> subresourceUniqueRedirectsTo;
        HashSet<WebCore::RegistrableDomain> subresourceUniqueRedirectsFrom;
        bool isPrevalentResource;
        bool isVeryPrevalentResource;
        unsigned dataRecordsRemoved;
        unsigned timesAccessedAsFirstPartyDueToUserInteraction;
        unsigned timesAccessedAsFirstPartyDueToStorageAccessAPI;
#if ENABLE(WEB_API_STATISTICS)
        HashSet<WebCore::RegistrableDomain> topFrameRegistrableDomainsWhichAccessedWebAPIs;
#endif
#if ENABLE(WEB_API_STATISTICS)
        HashSet<String> fontsFailedToLoad;
#endif
#if ENABLE(WEB_API_STATISTICS)
        HashSet<String> fontsSuccessfullyLoaded;
#endif
#if ENABLE(WEB_API_STATISTICS)
        WebCore::CanvasActivityRecord canvasActivityRecord;
#endif
#if ENABLE(WEB_API_STATISTICS)
        OptionSet<WebCore::NavigatorAPIsAccessed> navigatorFunctionsAccessed;
#endif
#if ENABLE(WEB_API_STATISTICS)
        OptionSet<WebCore::ScreenAPIsAccessed> screenFunctionsAccessed;
#endif
    };
    static_assert(sizeof(ShouldBeSameSizeAsResourceLoadStatistics) == sizeof(WebCore::ResourceLoadStatistics));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::ResourceLoadStatistics, registrableDomain)
        , offsetof(WebCore::ResourceLoadStatistics, lastSeen)
        , offsetof(WebCore::ResourceLoadStatistics, hadUserInteraction)
        , offsetof(WebCore::ResourceLoadStatistics, mostRecentUserInteractionTime)
        , offsetof(WebCore::ResourceLoadStatistics, grandfathered)
        , offsetof(WebCore::ResourceLoadStatistics, storageAccessUnderTopFrameDomains)
        , offsetof(WebCore::ResourceLoadStatistics, topFrameUniqueRedirectsTo)
        , offsetof(WebCore::ResourceLoadStatistics, topFrameUniqueRedirectsToSinceSameSiteStrictEnforcement)
        , offsetof(WebCore::ResourceLoadStatistics, topFrameUniqueRedirectsFrom)
        , offsetof(WebCore::ResourceLoadStatistics, topFrameLinkDecorationsFrom)
        , offsetof(WebCore::ResourceLoadStatistics, gotLinkDecorationFromPrevalentResource)
        , offsetof(WebCore::ResourceLoadStatistics, topFrameLoadedThirdPartyScripts)
        , offsetof(WebCore::ResourceLoadStatistics, subframeUnderTopFrameDomains)
        , offsetof(WebCore::ResourceLoadStatistics, subresourceUnderTopFrameDomains)
        , offsetof(WebCore::ResourceLoadStatistics, subresourceUniqueRedirectsTo)
        , offsetof(WebCore::ResourceLoadStatistics, subresourceUniqueRedirectsFrom)
        , offsetof(WebCore::ResourceLoadStatistics, isPrevalentResource)
        , offsetof(WebCore::ResourceLoadStatistics, isVeryPrevalentResource)
        , offsetof(WebCore::ResourceLoadStatistics, dataRecordsRemoved)
        , offsetof(WebCore::ResourceLoadStatistics, timesAccessedAsFirstPartyDueToUserInteraction)
        , offsetof(WebCore::ResourceLoadStatistics, timesAccessedAsFirstPartyDueToStorageAccessAPI)
#if ENABLE(WEB_API_STATISTICS)
        , offsetof(WebCore::ResourceLoadStatistics, topFrameRegistrableDomainsWhichAccessedWebAPIs)
#endif
#if ENABLE(WEB_API_STATISTICS)
        , offsetof(WebCore::ResourceLoadStatistics, fontsFailedToLoad)
#endif
#if ENABLE(WEB_API_STATISTICS)
        , offsetof(WebCore::ResourceLoadStatistics, fontsSuccessfullyLoaded)
#endif
#if ENABLE(WEB_API_STATISTICS)
        , offsetof(WebCore::ResourceLoadStatistics, canvasActivityRecord)
#endif
#if ENABLE(WEB_API_STATISTICS)
        , offsetof(WebCore::ResourceLoadStatistics, navigatorFunctionsAccessed)
#endif
#if ENABLE(WEB_API_STATISTICS)
        , offsetof(WebCore::ResourceLoadStatistics, screenFunctionsAccessed)
#endif
    >::value);

    encoder << instance.registrableDomain;
    encoder << instance.lastSeen;
    encoder << instance.hadUserInteraction;
    encoder << instance.mostRecentUserInteractionTime;
    encoder << instance.grandfathered;
    encoder << instance.storageAccessUnderTopFrameDomains;
    encoder << instance.topFrameUniqueRedirectsTo;
    encoder << instance.topFrameUniqueRedirectsToSinceSameSiteStrictEnforcement;
    encoder << instance.topFrameUniqueRedirectsFrom;
    encoder << instance.topFrameLinkDecorationsFrom;
    encoder << instance.gotLinkDecorationFromPrevalentResource;
    encoder << instance.topFrameLoadedThirdPartyScripts;
    encoder << instance.subframeUnderTopFrameDomains;
    encoder << instance.subresourceUnderTopFrameDomains;
    encoder << instance.subresourceUniqueRedirectsTo;
    encoder << instance.subresourceUniqueRedirectsFrom;
    encoder << instance.isPrevalentResource;
    encoder << instance.isVeryPrevalentResource;
    encoder << instance.dataRecordsRemoved;
    encoder << instance.timesAccessedAsFirstPartyDueToUserInteraction;
    encoder << instance.timesAccessedAsFirstPartyDueToStorageAccessAPI;
#if ENABLE(WEB_API_STATISTICS)
    encoder << instance.topFrameRegistrableDomainsWhichAccessedWebAPIs;
#endif
#if ENABLE(WEB_API_STATISTICS)
    encoder << instance.fontsFailedToLoad;
#endif
#if ENABLE(WEB_API_STATISTICS)
    encoder << instance.fontsSuccessfullyLoaded;
#endif
#if ENABLE(WEB_API_STATISTICS)
    encoder << instance.canvasActivityRecord;
#endif
#if ENABLE(WEB_API_STATISTICS)
    encoder << instance.navigatorFunctionsAccessed;
#endif
#if ENABLE(WEB_API_STATISTICS)
    encoder << instance.screenFunctionsAccessed;
#endif
}

std::optional<WebCore::ResourceLoadStatistics> ArgumentCoder<WebCore::ResourceLoadStatistics>::decode(Decoder& decoder)
{
    auto registrableDomain = decoder.decode<WebCore::RegistrableDomain>();
    auto lastSeen = decoder.decode<WallTime>();
    auto hadUserInteraction = decoder.decode<bool>();
    auto mostRecentUserInteractionTime = decoder.decode<WallTime>();
    auto grandfathered = decoder.decode<bool>();
    auto storageAccessUnderTopFrameDomains = decoder.decode<HashSet<WebCore::RegistrableDomain>>();
    auto topFrameUniqueRedirectsTo = decoder.decode<HashSet<WebCore::RegistrableDomain>>();
    auto topFrameUniqueRedirectsToSinceSameSiteStrictEnforcement = decoder.decode<HashSet<WebCore::RegistrableDomain>>();
    auto topFrameUniqueRedirectsFrom = decoder.decode<HashSet<WebCore::RegistrableDomain>>();
    auto topFrameLinkDecorationsFrom = decoder.decode<HashSet<WebCore::RegistrableDomain>>();
    auto gotLinkDecorationFromPrevalentResource = decoder.decode<bool>();
    auto topFrameLoadedThirdPartyScripts = decoder.decode<HashSet<WebCore::RegistrableDomain>>();
    auto subframeUnderTopFrameDomains = decoder.decode<HashSet<WebCore::RegistrableDomain>>();
    auto subresourceUnderTopFrameDomains = decoder.decode<HashSet<WebCore::RegistrableDomain>>();
    auto subresourceUniqueRedirectsTo = decoder.decode<HashSet<WebCore::RegistrableDomain>>();
    auto subresourceUniqueRedirectsFrom = decoder.decode<HashSet<WebCore::RegistrableDomain>>();
    auto isPrevalentResource = decoder.decode<bool>();
    auto isVeryPrevalentResource = decoder.decode<bool>();
    auto dataRecordsRemoved = decoder.decode<unsigned>();
    auto timesAccessedAsFirstPartyDueToUserInteraction = decoder.decode<unsigned>();
    auto timesAccessedAsFirstPartyDueToStorageAccessAPI = decoder.decode<unsigned>();
#if ENABLE(WEB_API_STATISTICS)
    auto topFrameRegistrableDomainsWhichAccessedWebAPIs = decoder.decode<HashSet<WebCore::RegistrableDomain>>();
#endif
#if ENABLE(WEB_API_STATISTICS)
    auto fontsFailedToLoad = decoder.decode<HashSet<String>>();
#endif
#if ENABLE(WEB_API_STATISTICS)
    auto fontsSuccessfullyLoaded = decoder.decode<HashSet<String>>();
#endif
#if ENABLE(WEB_API_STATISTICS)
    auto canvasActivityRecord = decoder.decode<WebCore::CanvasActivityRecord>();
#endif
#if ENABLE(WEB_API_STATISTICS)
    auto navigatorFunctionsAccessed = decoder.decode<OptionSet<WebCore::NavigatorAPIsAccessed>>();
#endif
#if ENABLE(WEB_API_STATISTICS)
    auto screenFunctionsAccessed = decoder.decode<OptionSet<WebCore::ScreenAPIsAccessed>>();
#endif
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    WebCore::ResourceLoadStatistics result;
    result.registrableDomain = WTFMove(*registrableDomain);
    result.lastSeen = WTFMove(*lastSeen);
    result.hadUserInteraction = WTFMove(*hadUserInteraction);
    result.mostRecentUserInteractionTime = WTFMove(*mostRecentUserInteractionTime);
    result.grandfathered = WTFMove(*grandfathered);
    result.storageAccessUnderTopFrameDomains = WTFMove(*storageAccessUnderTopFrameDomains);
    result.topFrameUniqueRedirectsTo = WTFMove(*topFrameUniqueRedirectsTo);
    result.topFrameUniqueRedirectsToSinceSameSiteStrictEnforcement = WTFMove(*topFrameUniqueRedirectsToSinceSameSiteStrictEnforcement);
    result.topFrameUniqueRedirectsFrom = WTFMove(*topFrameUniqueRedirectsFrom);
    result.topFrameLinkDecorationsFrom = WTFMove(*topFrameLinkDecorationsFrom);
    result.gotLinkDecorationFromPrevalentResource = WTFMove(*gotLinkDecorationFromPrevalentResource);
    result.topFrameLoadedThirdPartyScripts = WTFMove(*topFrameLoadedThirdPartyScripts);
    result.subframeUnderTopFrameDomains = WTFMove(*subframeUnderTopFrameDomains);
    result.subresourceUnderTopFrameDomains = WTFMove(*subresourceUnderTopFrameDomains);
    result.subresourceUniqueRedirectsTo = WTFMove(*subresourceUniqueRedirectsTo);
    result.subresourceUniqueRedirectsFrom = WTFMove(*subresourceUniqueRedirectsFrom);
    result.isPrevalentResource = WTFMove(*isPrevalentResource);
    result.isVeryPrevalentResource = WTFMove(*isVeryPrevalentResource);
    result.dataRecordsRemoved = WTFMove(*dataRecordsRemoved);
    result.timesAccessedAsFirstPartyDueToUserInteraction = WTFMove(*timesAccessedAsFirstPartyDueToUserInteraction);
    result.timesAccessedAsFirstPartyDueToStorageAccessAPI = WTFMove(*timesAccessedAsFirstPartyDueToStorageAccessAPI);
#if ENABLE(WEB_API_STATISTICS)
    result.topFrameRegistrableDomainsWhichAccessedWebAPIs = WTFMove(*topFrameRegistrableDomainsWhichAccessedWebAPIs);
#endif
#if ENABLE(WEB_API_STATISTICS)
    result.fontsFailedToLoad = WTFMove(*fontsFailedToLoad);
#endif
#if ENABLE(WEB_API_STATISTICS)
    result.fontsSuccessfullyLoaded = WTFMove(*fontsSuccessfullyLoaded);
#endif
#if ENABLE(WEB_API_STATISTICS)
    result.canvasActivityRecord = WTFMove(*canvasActivityRecord);
#endif
#if ENABLE(WEB_API_STATISTICS)
    result.navigatorFunctionsAccessed = WTFMove(*navigatorFunctionsAccessed);
#endif
#if ENABLE(WEB_API_STATISTICS)
    result.screenFunctionsAccessed = WTFMove(*screenFunctionsAccessed);
#endif
    return { WTFMove(result) };
}

#if ENABLE(GPU_PROCESS) && ENABLE(WEBGL)
void ArgumentCoder<WebCore::GraphicsContextGLActiveInfo>::encode(Encoder& encoder, const WebCore::GraphicsContextGLActiveInfo& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.name)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.type)>, GCGLenum>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.size)>, GCGLint>);
    struct ShouldBeSameSizeAsGraphicsContextGLActiveInfo : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::GraphicsContextGLActiveInfo>, false> {
        String name;
        GCGLenum type;
        GCGLint size;
    };
    static_assert(sizeof(ShouldBeSameSizeAsGraphicsContextGLActiveInfo) == sizeof(WebCore::GraphicsContextGLActiveInfo));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::GraphicsContextGLActiveInfo, name)
        , offsetof(WebCore::GraphicsContextGLActiveInfo, type)
        , offsetof(WebCore::GraphicsContextGLActiveInfo, size)
    >::value);

    encoder << instance.name;
    encoder << instance.type;
    encoder << instance.size;
}

void ArgumentCoder<WebCore::GraphicsContextGLActiveInfo>::encode(StreamConnectionEncoder& encoder, const WebCore::GraphicsContextGLActiveInfo& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.name)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.type)>, GCGLenum>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.size)>, GCGLint>);
    struct ShouldBeSameSizeAsGraphicsContextGLActiveInfo : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::GraphicsContextGLActiveInfo>, false> {
        String name;
        GCGLenum type;
        GCGLint size;
    };
    static_assert(sizeof(ShouldBeSameSizeAsGraphicsContextGLActiveInfo) == sizeof(WebCore::GraphicsContextGLActiveInfo));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::GraphicsContextGLActiveInfo, name)
        , offsetof(WebCore::GraphicsContextGLActiveInfo, type)
        , offsetof(WebCore::GraphicsContextGLActiveInfo, size)
    >::value);

    encoder << instance.name;
    encoder << instance.type;
    encoder << instance.size;
}

std::optional<WebCore::GraphicsContextGLActiveInfo> ArgumentCoder<WebCore::GraphicsContextGLActiveInfo>::decode(Decoder& decoder)
{
    auto name = decoder.decode<String>();
    auto type = decoder.decode<GCGLenum>();
    auto size = decoder.decode<GCGLint>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::GraphicsContextGLActiveInfo {
            WTFMove(*name),
            WTFMove(*type),
            WTFMove(*size)
        }
    };
}

#endif

void ArgumentCoder<WebCore::ShareDataWithParsedURL>::encode(Encoder& encoder, const WebCore::ShareDataWithParsedURL& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.shareData)>, WebCore::ShareData>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.url)>, std::optional<URL>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.files)>, Vector<WebCore::RawFile>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.originator)>, WebCore::ShareDataOriginator>);
    struct ShouldBeSameSizeAsShareDataWithParsedURL : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::ShareDataWithParsedURL>, false> {
        WebCore::ShareData shareData;
        std::optional<URL> url;
        Vector<WebCore::RawFile> files;
        WebCore::ShareDataOriginator originator;
    };
    static_assert(sizeof(ShouldBeSameSizeAsShareDataWithParsedURL) == sizeof(WebCore::ShareDataWithParsedURL));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::ShareDataWithParsedURL, shareData)
        , offsetof(WebCore::ShareDataWithParsedURL, url)
        , offsetof(WebCore::ShareDataWithParsedURL, files)
        , offsetof(WebCore::ShareDataWithParsedURL, originator)
    >::value);

    encoder << instance.shareData;
    encoder << instance.url;
    encoder << instance.files;
    encoder << instance.originator;
}

std::optional<WebCore::ShareDataWithParsedURL> ArgumentCoder<WebCore::ShareDataWithParsedURL>::decode(Decoder& decoder)
{
    auto shareData = decoder.decode<WebCore::ShareData>();
    auto url = decoder.decode<std::optional<URL>>();
    auto files = decoder.decode<Vector<WebCore::RawFile>>();
    auto originator = decoder.decode<WebCore::ShareDataOriginator>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::ShareDataWithParsedURL {
            WTFMove(*shareData),
            WTFMove(*url),
            WTFMove(*files),
            WTFMove(*originator)
        }
    };
}

void ArgumentCoder<WebCore::ShareData>::encode(Encoder& encoder, const WebCore::ShareData& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.title)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.text)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.url)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.files)>, Vector<Ref<WebCore::File>>>);
    struct ShouldBeSameSizeAsShareData : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::ShareData>, false> {
        String title;
        String text;
        String url;
        Vector<Ref<WebCore::File>> files;
    };
    static_assert(sizeof(ShouldBeSameSizeAsShareData) == sizeof(WebCore::ShareData));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::ShareData, title)
        , offsetof(WebCore::ShareData, text)
        , offsetof(WebCore::ShareData, url)
        , offsetof(WebCore::ShareData, files)
    >::value);

    encoder << instance.title;
    encoder << instance.text;
    encoder << instance.url;
}

std::optional<WebCore::ShareData> ArgumentCoder<WebCore::ShareData>::decode(Decoder& decoder)
{
    auto title = decoder.decode<String>();
    auto text = decoder.decode<String>();
    auto url = decoder.decode<String>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::ShareData {
            WTFMove(*title),
            WTFMove(*text),
            WTFMove(*url)
        }
    };
}

#if ENABLE(WEB_PAGE_SPATIAL_BACKDROP)
void ArgumentCoder<WebCore::SpatialBackdropSource>::encode(Encoder& encoder, const WebCore::SpatialBackdropSource& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_sourceURL)>, URL>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_modelURL)>, URL>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_environmentMapURL)>, std::optional<URL>>);
    struct ShouldBeSameSizeAsSpatialBackdropSource : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::SpatialBackdropSource>, false> {
        URL m_sourceURL;
        URL m_modelURL;
        std::optional<URL> m_environmentMapURL;
    };
    static_assert(sizeof(ShouldBeSameSizeAsSpatialBackdropSource) == sizeof(WebCore::SpatialBackdropSource));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::SpatialBackdropSource, m_sourceURL)
        , offsetof(WebCore::SpatialBackdropSource, m_modelURL)
        , offsetof(WebCore::SpatialBackdropSource, m_environmentMapURL)
    >::value);

    encoder << instance.m_sourceURL;
    encoder << instance.m_modelURL;
    encoder << instance.m_environmentMapURL;
}

std::optional<WebCore::SpatialBackdropSource> ArgumentCoder<WebCore::SpatialBackdropSource>::decode(Decoder& decoder)
{
    auto m_sourceURL = decoder.decode<URL>();
    auto m_modelURL = decoder.decode<URL>();
    auto m_environmentMapURL = decoder.decode<std::optional<URL>>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::SpatialBackdropSource {
            WTFMove(*m_sourceURL),
            WTFMove(*m_modelURL),
            WTFMove(*m_environmentMapURL)
        }
    };
}

#endif

void ArgumentCoder<WebCore::TargetedElementAdjustment>::encode(Encoder& encoder, const WebCore::TargetedElementAdjustment& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.identifiers)>, WebCore::TargetedElementIdentifiers>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.selectors)>, WebCore::TargetedElementSelectors>);
    struct ShouldBeSameSizeAsTargetedElementAdjustment : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::TargetedElementAdjustment>, false> {
        WebCore::TargetedElementIdentifiers identifiers;
        WebCore::TargetedElementSelectors selectors;
    };
    static_assert(sizeof(ShouldBeSameSizeAsTargetedElementAdjustment) == sizeof(WebCore::TargetedElementAdjustment));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::TargetedElementAdjustment, identifiers)
        , offsetof(WebCore::TargetedElementAdjustment, selectors)
    >::value);

    encoder << instance.identifiers;
    encoder << instance.selectors;
}

std::optional<WebCore::TargetedElementAdjustment> ArgumentCoder<WebCore::TargetedElementAdjustment>::decode(Decoder& decoder)
{
    auto identifiers = decoder.decode<WebCore::TargetedElementIdentifiers>();
    auto selectors = decoder.decode<WebCore::TargetedElementSelectors>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::TargetedElementAdjustment {
            WTFMove(*identifiers),
            WTFMove(*selectors)
        }
    };
}

void ArgumentCoder<WebCore::TargetedElementRequest>::encode(Encoder& encoder, const WebCore::TargetedElementRequest& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.data)>, Variant<WebCore::FloatPoint, String, WebCore::TargetedElementSelectors>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.canIncludeNearbyElements)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.shouldIgnorePointerEventsNone)>, bool>);
    struct ShouldBeSameSizeAsTargetedElementRequest : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::TargetedElementRequest>, false> {
        Variant<WebCore::FloatPoint, String, WebCore::TargetedElementSelectors> data;
        bool canIncludeNearbyElements;
        bool shouldIgnorePointerEventsNone;
    };
    static_assert(sizeof(ShouldBeSameSizeAsTargetedElementRequest) == sizeof(WebCore::TargetedElementRequest));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::TargetedElementRequest, data)
        , offsetof(WebCore::TargetedElementRequest, canIncludeNearbyElements)
        , offsetof(WebCore::TargetedElementRequest, shouldIgnorePointerEventsNone)
    >::value);

    encoder << instance.data;
    encoder << instance.canIncludeNearbyElements;
    encoder << instance.shouldIgnorePointerEventsNone;
}

std::optional<WebCore::TargetedElementRequest> ArgumentCoder<WebCore::TargetedElementRequest>::decode(Decoder& decoder)
{
    auto data = decoder.decode<Variant<WebCore::FloatPoint, String, WebCore::TargetedElementSelectors>>();
    auto canIncludeNearbyElements = decoder.decode<bool>();
    auto shouldIgnorePointerEventsNone = decoder.decode<bool>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::TargetedElementRequest {
            WTFMove(*data),
            WTFMove(*canIncludeNearbyElements),
            WTFMove(*shouldIgnorePointerEventsNone)
        }
    };
}

void ArgumentCoder<WebCore::TargetedElementInfo>::encode(Encoder& encoder, const WebCore::TargetedElementInfo& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.nodeIdentifier)>, WebCore::NodeIdentifier>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.documentIdentifier)>, WebCore::ScriptExecutionContextIdentifier>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.offsetEdges)>, WebCore::RectEdges<bool>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.renderedText)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.searchableText)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.screenReaderText)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.selectors)>, Vector<Vector<String>>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.boundsInRootView)>, WebCore::FloatRect>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.boundsInClientCoordinates)>, WebCore::FloatRect>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.positionType)>, WebCore::PositionType>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.childFrameIdentifiers)>, Vector<WebCore::FrameIdentifier>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.mediaAndLinkURLs)>, HashSet<URL>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isNearbyTarget)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isPseudoElement)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isInShadowTree)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isInVisibilityAdjustmentSubtree)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.hasLargeReplacedDescendant)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.hasAudibleMedia)>, bool>);
    struct ShouldBeSameSizeAsTargetedElementInfo : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::TargetedElementInfo>, false> {
        WebCore::NodeIdentifier nodeIdentifier;
        WebCore::ScriptExecutionContextIdentifier documentIdentifier;
        WebCore::RectEdges<bool> offsetEdges;
        String renderedText;
        String searchableText;
        String screenReaderText;
        Vector<Vector<String>> selectors;
        WebCore::FloatRect boundsInRootView;
        WebCore::FloatRect boundsInClientCoordinates;
        WebCore::PositionType positionType;
        Vector<WebCore::FrameIdentifier> childFrameIdentifiers;
        HashSet<URL> mediaAndLinkURLs;
        bool isNearbyTarget;
        bool isPseudoElement;
        bool isInShadowTree;
        bool isInVisibilityAdjustmentSubtree;
        bool hasLargeReplacedDescendant;
        bool hasAudibleMedia;
    };
    static_assert(sizeof(ShouldBeSameSizeAsTargetedElementInfo) == sizeof(WebCore::TargetedElementInfo));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::TargetedElementInfo, nodeIdentifier)
        , offsetof(WebCore::TargetedElementInfo, documentIdentifier)
        , offsetof(WebCore::TargetedElementInfo, offsetEdges)
        , offsetof(WebCore::TargetedElementInfo, renderedText)
        , offsetof(WebCore::TargetedElementInfo, searchableText)
        , offsetof(WebCore::TargetedElementInfo, screenReaderText)
        , offsetof(WebCore::TargetedElementInfo, selectors)
        , offsetof(WebCore::TargetedElementInfo, boundsInRootView)
        , offsetof(WebCore::TargetedElementInfo, boundsInClientCoordinates)
        , offsetof(WebCore::TargetedElementInfo, positionType)
        , offsetof(WebCore::TargetedElementInfo, childFrameIdentifiers)
        , offsetof(WebCore::TargetedElementInfo, mediaAndLinkURLs)
        , offsetof(WebCore::TargetedElementInfo, isNearbyTarget)
        , offsetof(WebCore::TargetedElementInfo, isPseudoElement)
        , offsetof(WebCore::TargetedElementInfo, isInShadowTree)
        , offsetof(WebCore::TargetedElementInfo, isInVisibilityAdjustmentSubtree)
        , offsetof(WebCore::TargetedElementInfo, hasLargeReplacedDescendant)
        , offsetof(WebCore::TargetedElementInfo, hasAudibleMedia)
    >::value);

    encoder << instance.nodeIdentifier;
    encoder << instance.documentIdentifier;
    encoder << instance.offsetEdges;
    encoder << instance.renderedText;
    encoder << instance.searchableText;
    encoder << instance.screenReaderText;
    encoder << instance.selectors;
    encoder << instance.boundsInRootView;
    encoder << instance.boundsInClientCoordinates;
    encoder << instance.positionType;
    encoder << instance.childFrameIdentifiers;
    encoder << instance.mediaAndLinkURLs;
    encoder << instance.isNearbyTarget;
    encoder << instance.isPseudoElement;
    encoder << instance.isInShadowTree;
    encoder << instance.isInVisibilityAdjustmentSubtree;
    encoder << instance.hasLargeReplacedDescendant;
    encoder << instance.hasAudibleMedia;
}

std::optional<WebCore::TargetedElementInfo> ArgumentCoder<WebCore::TargetedElementInfo>::decode(Decoder& decoder)
{
    auto nodeIdentifier = decoder.decode<WebCore::NodeIdentifier>();
    auto documentIdentifier = decoder.decode<WebCore::ScriptExecutionContextIdentifier>();
    auto offsetEdges = decoder.decode<WebCore::RectEdges<bool>>();
    auto renderedText = decoder.decode<String>();
    auto searchableText = decoder.decode<String>();
    auto screenReaderText = decoder.decode<String>();
    auto selectors = decoder.decode<Vector<Vector<String>>>();
    auto boundsInRootView = decoder.decode<WebCore::FloatRect>();
    auto boundsInClientCoordinates = decoder.decode<WebCore::FloatRect>();
    auto positionType = decoder.decode<WebCore::PositionType>();
    auto childFrameIdentifiers = decoder.decode<Vector<WebCore::FrameIdentifier>>();
    auto mediaAndLinkURLs = decoder.decode<HashSet<URL>>();
    auto isNearbyTarget = decoder.decode<bool>();
    auto isPseudoElement = decoder.decode<bool>();
    auto isInShadowTree = decoder.decode<bool>();
    auto isInVisibilityAdjustmentSubtree = decoder.decode<bool>();
    auto hasLargeReplacedDescendant = decoder.decode<bool>();
    auto hasAudibleMedia = decoder.decode<bool>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::TargetedElementInfo {
            WTFMove(*nodeIdentifier),
            WTFMove(*documentIdentifier),
            WTFMove(*offsetEdges),
            WTFMove(*renderedText),
            WTFMove(*searchableText),
            WTFMove(*screenReaderText),
            WTFMove(*selectors),
            WTFMove(*boundsInRootView),
            WTFMove(*boundsInClientCoordinates),
            WTFMove(*positionType),
            WTFMove(*childFrameIdentifiers),
            WTFMove(*mediaAndLinkURLs),
            WTFMove(*isNearbyTarget),
            WTFMove(*isPseudoElement),
            WTFMove(*isInShadowTree),
            WTFMove(*isInVisibilityAdjustmentSubtree),
            WTFMove(*hasLargeReplacedDescendant),
            WTFMove(*hasAudibleMedia)
        }
    };
}

void ArgumentCoder<WebCore::RawFile>::encode(Encoder& encoder, const WebCore::RawFile& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.fileName)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.fileData)>, RefPtr<WebCore::SharedBuffer>>);
    struct ShouldBeSameSizeAsRawFile : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::RawFile>, false> {
        String fileName;
        RefPtr<WebCore::SharedBuffer> fileData;
    };
    static_assert(sizeof(ShouldBeSameSizeAsRawFile) == sizeof(WebCore::RawFile));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::RawFile, fileName)
        , offsetof(WebCore::RawFile, fileData)
    >::value);

    encoder << instance.fileName;
    encoder << instance.fileData;
}

std::optional<WebCore::RawFile> ArgumentCoder<WebCore::RawFile>::decode(Decoder& decoder)
{
    auto fileName = decoder.decode<String>();
    auto fileData = decoder.decode<RefPtr<WebCore::SharedBuffer>>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::RawFile {
            WTFMove(*fileName),
            WTFMove(*fileData)
        }
    };
}

void ArgumentCoder<WebCore::FloatRoundedRect>::encode(Encoder& encoder, const WebCore::FloatRoundedRect& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.rect())>, WebCore::FloatRect>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.radii().topLeft())>, WebCore::FloatSize>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.radii().topRight())>, WebCore::FloatSize>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.radii().bottomLeft())>, WebCore::FloatSize>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.radii().bottomRight())>, WebCore::FloatSize>);

    encoder << instance.rect();
    encoder << instance.radii().topLeft();
    encoder << instance.radii().topRight();
    encoder << instance.radii().bottomLeft();
    encoder << instance.radii().bottomRight();
}

void ArgumentCoder<WebCore::FloatRoundedRect>::encode(StreamConnectionEncoder& encoder, const WebCore::FloatRoundedRect& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.rect())>, WebCore::FloatRect>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.radii().topLeft())>, WebCore::FloatSize>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.radii().topRight())>, WebCore::FloatSize>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.radii().bottomLeft())>, WebCore::FloatSize>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.radii().bottomRight())>, WebCore::FloatSize>);

    encoder << instance.rect();
    encoder << instance.radii().topLeft();
    encoder << instance.radii().topRight();
    encoder << instance.radii().bottomLeft();
    encoder << instance.radii().bottomRight();
}

std::optional<WebCore::FloatRoundedRect> ArgumentCoder<WebCore::FloatRoundedRect>::decode(Decoder& decoder)
{
    auto rect = decoder.decode<WebCore::FloatRect>();
    auto radiitopLeft = decoder.decode<WebCore::FloatSize>();
    auto radiitopRight = decoder.decode<WebCore::FloatSize>();
    auto radiibottomLeft = decoder.decode<WebCore::FloatSize>();
    auto radiibottomRight = decoder.decode<WebCore::FloatSize>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::FloatRoundedRect {
            WTFMove(*rect),
            WTFMove(*radiitopLeft),
            WTFMove(*radiitopRight),
            WTFMove(*radiibottomLeft),
            WTFMove(*radiibottomRight)
        }
    };
}

void ArgumentCoder<WebCore::IntRect>::encode(Encoder& encoder, const WebCore::IntRect& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.location())>, WebCore::IntPoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.size())>, WebCore::IntSize>);

    encoder << instance.location();
    encoder << instance.size();
}

void ArgumentCoder<WebCore::IntRect>::encode(StreamConnectionEncoder& encoder, const WebCore::IntRect& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.location())>, WebCore::IntPoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.size())>, WebCore::IntSize>);

    encoder << instance.location();
    encoder << instance.size();
}

std::optional<WebCore::IntRect> ArgumentCoder<WebCore::IntRect>::decode(Decoder& decoder)
{
    auto location = decoder.decode<WebCore::IntPoint>();
    auto size = decoder.decode<WebCore::IntSize>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;

    if (!(WebCore::IntRect { *location, *size }.isValid()))
        return std::nullopt;
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::IntRect {
            WTFMove(*location),
            WTFMove(*size)
        }
    };
}

void ArgumentCoder<WebCore::IntPoint>::encode(Encoder& encoder, const WebCore::IntPoint& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.x())>, int>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.y())>, int>);

    encoder << instance.x();
    encoder << instance.y();
}

void ArgumentCoder<WebCore::IntPoint>::encode(StreamConnectionEncoder& encoder, const WebCore::IntPoint& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.x())>, int>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.y())>, int>);

    encoder << instance.x();
    encoder << instance.y();
}

std::optional<WebCore::IntPoint> ArgumentCoder<WebCore::IntPoint>::decode(Decoder& decoder)
{
    auto x = decoder.decode<int>();
    auto y = decoder.decode<int>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::IntPoint {
            WTFMove(*x),
            WTFMove(*y)
        }
    };
}

void ArgumentCoder<WebCore::IntSize>::encode(Encoder& encoder, const WebCore::IntSize& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.width())>, int>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.height())>, int>);

    encoder << instance.width();
    encoder << instance.height();
}

void ArgumentCoder<WebCore::IntSize>::encode(StreamConnectionEncoder& encoder, const WebCore::IntSize& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.width())>, int>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.height())>, int>);

    encoder << instance.width();
    encoder << instance.height();
}

std::optional<WebCore::IntSize> ArgumentCoder<WebCore::IntSize>::decode(Decoder& decoder)
{
    auto width = decoder.decode<int>();
    auto height = decoder.decode<int>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::IntSize {
            WTFMove(*width),
            WTFMove(*height)
        }
    };
}

void ArgumentCoder<WebCore::FloatSize>::encode(Encoder& encoder, const WebCore::FloatSize& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.width())>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.height())>, float>);

    encoder << instance.width();
    encoder << instance.height();
}

void ArgumentCoder<WebCore::FloatSize>::encode(StreamConnectionEncoder& encoder, const WebCore::FloatSize& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.width())>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.height())>, float>);

    encoder << instance.width();
    encoder << instance.height();
}

std::optional<WebCore::FloatSize> ArgumentCoder<WebCore::FloatSize>::decode(Decoder& decoder)
{
    auto width = decoder.decode<float>();
    auto height = decoder.decode<float>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::FloatSize {
            WTFMove(*width),
            WTFMove(*height)
        }
    };
}

void ArgumentCoder<WebCore::LayoutUnit>::encode(Encoder& encoder, const WebCore::LayoutUnit& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.rawValue())>, int>);

    encoder << instance.rawValue();
}

void ArgumentCoder<WebCore::LayoutUnit>::encode(StreamConnectionEncoder& encoder, const WebCore::LayoutUnit& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.rawValue())>, int>);

    encoder << instance.rawValue();
}

std::optional<WebCore::LayoutUnit> ArgumentCoder<WebCore::LayoutUnit>::decode(Decoder& decoder)
{
    auto rawValue = decoder.decode<int>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::LayoutUnit::fromRawValue(
            WTFMove(*rawValue)
        )
    };
}

void ArgumentCoder<WebCore::LayoutPoint>::encode(Encoder& encoder, const WebCore::LayoutPoint& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.x())>, WebCore::LayoutUnit>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.y())>, WebCore::LayoutUnit>);

    encoder << instance.x();
    encoder << instance.y();
}

void ArgumentCoder<WebCore::LayoutPoint>::encode(StreamConnectionEncoder& encoder, const WebCore::LayoutPoint& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.x())>, WebCore::LayoutUnit>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.y())>, WebCore::LayoutUnit>);

    encoder << instance.x();
    encoder << instance.y();
}

std::optional<WebCore::LayoutPoint> ArgumentCoder<WebCore::LayoutPoint>::decode(Decoder& decoder)
{
    auto x = decoder.decode<WebCore::LayoutUnit>();
    auto y = decoder.decode<WebCore::LayoutUnit>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::LayoutPoint {
            WTFMove(*x),
            WTFMove(*y)
        }
    };
}

void ArgumentCoder<WebCore::LayoutSize>::encode(Encoder& encoder, const WebCore::LayoutSize& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.width())>, WebCore::LayoutUnit>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.height())>, WebCore::LayoutUnit>);

    encoder << instance.width();
    encoder << instance.height();
}

void ArgumentCoder<WebCore::LayoutSize>::encode(StreamConnectionEncoder& encoder, const WebCore::LayoutSize& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.width())>, WebCore::LayoutUnit>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.height())>, WebCore::LayoutUnit>);

    encoder << instance.width();
    encoder << instance.height();
}

std::optional<WebCore::LayoutSize> ArgumentCoder<WebCore::LayoutSize>::decode(Decoder& decoder)
{
    auto width = decoder.decode<WebCore::LayoutUnit>();
    auto height = decoder.decode<WebCore::LayoutUnit>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::LayoutSize {
            WTFMove(*width),
            WTFMove(*height)
        }
    };
}

void ArgumentCoder<WebCore::DictionaryPopupInfo>::encode(Encoder& encoder, const WebCore::DictionaryPopupInfo& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.origin)>, WebCore::FloatPoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.textIndicator)>, RefPtr<WebCore::TextIndicator>>);
#if ENABLE(LEGACY_PDFKIT_PLUGIN)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.platformData)>, WebCore::DictionaryPopupInfoCocoa>);
#endif
#if !(ENABLE(LEGACY_PDFKIT_PLUGIN))
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.text)>, String>);
#endif
    struct ShouldBeSameSizeAsDictionaryPopupInfo : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::DictionaryPopupInfo>, false> {
        WebCore::FloatPoint origin;
        RefPtr<WebCore::TextIndicator> textIndicator;
#if ENABLE(LEGACY_PDFKIT_PLUGIN)
        WebCore::DictionaryPopupInfoCocoa platformData;
#endif
#if !(ENABLE(LEGACY_PDFKIT_PLUGIN))
        String text;
#endif
    };
    static_assert(sizeof(ShouldBeSameSizeAsDictionaryPopupInfo) == sizeof(WebCore::DictionaryPopupInfo));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::DictionaryPopupInfo, origin)
        , offsetof(WebCore::DictionaryPopupInfo, textIndicator)
#if ENABLE(LEGACY_PDFKIT_PLUGIN)
        , offsetof(WebCore::DictionaryPopupInfo, platformData)
#endif
#if !(ENABLE(LEGACY_PDFKIT_PLUGIN))
        , offsetof(WebCore::DictionaryPopupInfo, text)
#endif
    >::value);

    encoder << instance.origin;
    encoder << instance.textIndicator;
#if ENABLE(LEGACY_PDFKIT_PLUGIN)
    encoder << instance.platformData;
#endif
#if !(ENABLE(LEGACY_PDFKIT_PLUGIN))
    encoder << instance.text;
#endif
}

std::optional<WebCore::DictionaryPopupInfo> ArgumentCoder<WebCore::DictionaryPopupInfo>::decode(Decoder& decoder)
{
    auto origin = decoder.decode<WebCore::FloatPoint>();
    auto textIndicator = decoder.decode<RefPtr<WebCore::TextIndicator>>();
#if ENABLE(LEGACY_PDFKIT_PLUGIN)
    auto platformData = decoder.decode<WebCore::DictionaryPopupInfoCocoa>();
#endif
#if !(ENABLE(LEGACY_PDFKIT_PLUGIN))
    auto text = decoder.decode<String>();
#endif
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::DictionaryPopupInfo {
            WTFMove(*origin),
            WTFMove(*textIndicator),
#if ENABLE(LEGACY_PDFKIT_PLUGIN)
            WTFMove(*platformData),
#endif
#if !(ENABLE(LEGACY_PDFKIT_PLUGIN))
            WTFMove(*text)
#endif
        }
    };
}

void ArgumentCoder<WebCore::PrivateClickMeasurement>::encode(Encoder& encoder, const WebCore::PrivateClickMeasurement& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.sourceID())>, uint8_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.sourceSite())>, WebCore::PCM::SourceSite>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.destinationSite())>, WebCore::PCM::AttributionDestinationSite>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.timeOfAdClick())>, WallTime>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isEphemeral())>, WebCore::PCM::AttributionEphemeral>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.adamID())>, std::optional<uint64_t>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.attributionTriggerData())>, std::optional<WebCore::PCM::AttributionTriggerData>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.timesToSend())>, WebCore::PCM::AttributionTimeToSendData>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.ephemeralSourceNonce())>, std::optional<WebCore::PCM::EphemeralNonce>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.sourceApplicationBundleID())>, String>);

    encoder << instance.sourceID();
    encoder << instance.sourceSite();
    encoder << instance.destinationSite();
    encoder << instance.timeOfAdClick();
    encoder << instance.isEphemeral();
    encoder << instance.adamID();
    encoder << instance.attributionTriggerData();
    encoder << instance.timesToSend();
    encoder << instance.ephemeralSourceNonce();
    encoder << instance.sourceApplicationBundleID();
}

std::optional<WebCore::PrivateClickMeasurement> ArgumentCoder<WebCore::PrivateClickMeasurement>::decode(Decoder& decoder)
{
    auto sourceID = decoder.decode<uint8_t>();
    auto sourceSite = decoder.decode<WebCore::PCM::SourceSite>();
    auto destinationSite = decoder.decode<WebCore::PCM::AttributionDestinationSite>();
    auto timeOfAdClick = decoder.decode<WallTime>();
    auto isEphemeral = decoder.decode<WebCore::PCM::AttributionEphemeral>();
    auto adamID = decoder.decode<std::optional<uint64_t>>();
    auto attributionTriggerData = decoder.decode<std::optional<WebCore::PCM::AttributionTriggerData>>();
    auto timesToSend = decoder.decode<WebCore::PCM::AttributionTimeToSendData>();
    auto ephemeralSourceNonce = decoder.decode<std::optional<WebCore::PCM::EphemeralNonce>>();
    auto sourceApplicationBundleID = decoder.decode<String>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::PrivateClickMeasurement {
            WTFMove(*sourceID),
            WTFMove(*sourceSite),
            WTFMove(*destinationSite),
            WTFMove(*timeOfAdClick),
            WTFMove(*isEphemeral),
            WTFMove(*adamID),
            WTFMove(*attributionTriggerData),
            WTFMove(*timesToSend),
            WTFMove(*ephemeralSourceNonce),
            WTFMove(*sourceApplicationBundleID)
        }
    };
}

void ArgumentCoder<WebCore::PCM::SourceSite>::encode(Encoder& encoder, const WebCore::PCM::SourceSite& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.registrableDomain)>, WebCore::RegistrableDomain>);
    struct ShouldBeSameSizeAsSourceSite : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::PCM::SourceSite>, false> {
        WebCore::RegistrableDomain registrableDomain;
    };
    static_assert(sizeof(ShouldBeSameSizeAsSourceSite) == sizeof(WebCore::PCM::SourceSite));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::PCM::SourceSite, registrableDomain)
    >::value);

    encoder << instance.registrableDomain;
}

std::optional<WebCore::PCM::SourceSite> ArgumentCoder<WebCore::PCM::SourceSite>::decode(Decoder& decoder)
{
    auto registrableDomain = decoder.decode<WebCore::RegistrableDomain>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::PCM::SourceSite {
            WTFMove(*registrableDomain)
        }
    };
}

void ArgumentCoder<WebCore::PCM::AttributionDestinationSite>::encode(Encoder& encoder, const WebCore::PCM::AttributionDestinationSite& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.registrableDomain)>, WebCore::RegistrableDomain>);
    struct ShouldBeSameSizeAsAttributionDestinationSite : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::PCM::AttributionDestinationSite>, false> {
        WebCore::RegistrableDomain registrableDomain;
    };
    static_assert(sizeof(ShouldBeSameSizeAsAttributionDestinationSite) == sizeof(WebCore::PCM::AttributionDestinationSite));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::PCM::AttributionDestinationSite, registrableDomain)
    >::value);

    encoder << instance.registrableDomain;
}

std::optional<WebCore::PCM::AttributionDestinationSite> ArgumentCoder<WebCore::PCM::AttributionDestinationSite>::decode(Decoder& decoder)
{
    auto registrableDomain = decoder.decode<WebCore::RegistrableDomain>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::PCM::AttributionDestinationSite {
            WTFMove(*registrableDomain)
        }
    };
}

void ArgumentCoder<WebCore::PCM::EphemeralNonce>::encode(Encoder& encoder, const WebCore::PCM::EphemeralNonce& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.nonce)>, String>);
    struct ShouldBeSameSizeAsEphemeralNonce : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::PCM::EphemeralNonce>, false> {
        String nonce;
    };
    static_assert(sizeof(ShouldBeSameSizeAsEphemeralNonce) == sizeof(WebCore::PCM::EphemeralNonce));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::PCM::EphemeralNonce, nonce)
    >::value);

    encoder << instance.nonce;
}

std::optional<WebCore::PCM::EphemeralNonce> ArgumentCoder<WebCore::PCM::EphemeralNonce>::decode(Decoder& decoder)
{
    auto nonce = decoder.decode<String>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::PCM::EphemeralNonce {
            WTFMove(*nonce)
        }
    };
}

void ArgumentCoder<WebCore::PCM::AttributionTriggerData>::encode(Encoder& encoder, const WebCore::PCM::AttributionTriggerData& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.data)>, uint8_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.priority)>, uint8_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.wasSent)>, WebCore::PCM::WasSent>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.sourceRegistrableDomain)>, std::optional<WebCore::RegistrableDomain>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.ephemeralDestinationNonce)>, std::optional<WebCore::PCM::EphemeralNonce>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.destinationSite)>, std::optional<WebCore::RegistrableDomain>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.destinationUnlinkableToken)>, std::optional<WebCore::PCM::DestinationUnlinkableToken>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.destinationSecretToken)>, std::optional<WebCore::PCM::DestinationSecretToken>>);
    struct ShouldBeSameSizeAsAttributionTriggerData : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::PCM::AttributionTriggerData>, false> {
        uint8_t data;
        uint8_t priority;
        WebCore::PCM::WasSent wasSent;
        std::optional<WebCore::RegistrableDomain> sourceRegistrableDomain;
        std::optional<WebCore::PCM::EphemeralNonce> ephemeralDestinationNonce;
        std::optional<WebCore::RegistrableDomain> destinationSite;
        std::optional<WebCore::PCM::DestinationUnlinkableToken> destinationUnlinkableToken;
        std::optional<WebCore::PCM::DestinationSecretToken> destinationSecretToken;
    };
    static_assert(sizeof(ShouldBeSameSizeAsAttributionTriggerData) == sizeof(WebCore::PCM::AttributionTriggerData));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::PCM::AttributionTriggerData, data)
        , offsetof(WebCore::PCM::AttributionTriggerData, priority)
        , offsetof(WebCore::PCM::AttributionTriggerData, wasSent)
        , offsetof(WebCore::PCM::AttributionTriggerData, sourceRegistrableDomain)
        , offsetof(WebCore::PCM::AttributionTriggerData, ephemeralDestinationNonce)
        , offsetof(WebCore::PCM::AttributionTriggerData, destinationSite)
        , offsetof(WebCore::PCM::AttributionTriggerData, destinationUnlinkableToken)
        , offsetof(WebCore::PCM::AttributionTriggerData, destinationSecretToken)
    >::value);

    encoder << instance.data;
    encoder << instance.priority;
    encoder << instance.wasSent;
    encoder << instance.sourceRegistrableDomain;
    encoder << instance.ephemeralDestinationNonce;
    encoder << instance.destinationSite;
}

std::optional<WebCore::PCM::AttributionTriggerData> ArgumentCoder<WebCore::PCM::AttributionTriggerData>::decode(Decoder& decoder)
{
    auto data = decoder.decode<uint8_t>();
    auto priority = decoder.decode<uint8_t>();
    auto wasSent = decoder.decode<WebCore::PCM::WasSent>();
    auto sourceRegistrableDomain = decoder.decode<std::optional<WebCore::RegistrableDomain>>();
    auto ephemeralDestinationNonce = decoder.decode<std::optional<WebCore::PCM::EphemeralNonce>>();
    auto destinationSite = decoder.decode<std::optional<WebCore::RegistrableDomain>>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::PCM::AttributionTriggerData {
            WTFMove(*data),
            WTFMove(*priority),
            WTFMove(*wasSent),
            WTFMove(*sourceRegistrableDomain),
            WTFMove(*ephemeralDestinationNonce),
            WTFMove(*destinationSite)
        }
    };
}

void ArgumentCoder<WebCore::PCM::AttributionTimeToSendData>::encode(Encoder& encoder, const WebCore::PCM::AttributionTimeToSendData& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.sourceEarliestTimeToSend)>, std::optional<WallTime>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.destinationEarliestTimeToSend)>, std::optional<WallTime>>);
    struct ShouldBeSameSizeAsAttributionTimeToSendData : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::PCM::AttributionTimeToSendData>, false> {
        std::optional<WallTime> sourceEarliestTimeToSend;
        std::optional<WallTime> destinationEarliestTimeToSend;
    };
    static_assert(sizeof(ShouldBeSameSizeAsAttributionTimeToSendData) == sizeof(WebCore::PCM::AttributionTimeToSendData));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::PCM::AttributionTimeToSendData, sourceEarliestTimeToSend)
        , offsetof(WebCore::PCM::AttributionTimeToSendData, destinationEarliestTimeToSend)
    >::value);

    encoder << instance.sourceEarliestTimeToSend;
    encoder << instance.destinationEarliestTimeToSend;
}

std::optional<WebCore::PCM::AttributionTimeToSendData> ArgumentCoder<WebCore::PCM::AttributionTimeToSendData>::decode(Decoder& decoder)
{
    auto sourceEarliestTimeToSend = decoder.decode<std::optional<WallTime>>();
    auto destinationEarliestTimeToSend = decoder.decode<std::optional<WallTime>>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::PCM::AttributionTimeToSendData {
            WTFMove(*sourceEarliestTimeToSend),
            WTFMove(*destinationEarliestTimeToSend)
        }
    };
}

#if ENABLE(APPLE_PAY_RECURRING_PAYMENTS)
void ArgumentCoder<WebCore::ApplePayRecurringPaymentRequest>::encode(Encoder& encoder, const WebCore::ApplePayRecurringPaymentRequest& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.paymentDescription)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.regularBilling)>, WebCore::ApplePayLineItem>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.trialBilling)>, std::optional<WebCore::ApplePayLineItem>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.billingAgreement)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.managementURL)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.tokenNotificationURL)>, String>);
    struct ShouldBeSameSizeAsApplePayRecurringPaymentRequest : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::ApplePayRecurringPaymentRequest>, false> {
        String paymentDescription;
        WebCore::ApplePayLineItem regularBilling;
        std::optional<WebCore::ApplePayLineItem> trialBilling;
        String billingAgreement;
        String managementURL;
        String tokenNotificationURL;
    };
    static_assert(sizeof(ShouldBeSameSizeAsApplePayRecurringPaymentRequest) == sizeof(WebCore::ApplePayRecurringPaymentRequest));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::ApplePayRecurringPaymentRequest, paymentDescription)
        , offsetof(WebCore::ApplePayRecurringPaymentRequest, regularBilling)
        , offsetof(WebCore::ApplePayRecurringPaymentRequest, trialBilling)
        , offsetof(WebCore::ApplePayRecurringPaymentRequest, billingAgreement)
        , offsetof(WebCore::ApplePayRecurringPaymentRequest, managementURL)
        , offsetof(WebCore::ApplePayRecurringPaymentRequest, tokenNotificationURL)
    >::value);

    encoder << instance.paymentDescription;
    encoder << instance.regularBilling;
    encoder << instance.trialBilling;
    encoder << instance.billingAgreement;
    encoder << instance.managementURL;
    encoder << instance.tokenNotificationURL;
}

std::optional<WebCore::ApplePayRecurringPaymentRequest> ArgumentCoder<WebCore::ApplePayRecurringPaymentRequest>::decode(Decoder& decoder)
{
    auto paymentDescription = decoder.decode<String>();
    auto regularBilling = decoder.decode<WebCore::ApplePayLineItem>();
    auto trialBilling = decoder.decode<std::optional<WebCore::ApplePayLineItem>>();
    auto billingAgreement = decoder.decode<String>();
    auto managementURL = decoder.decode<String>();
    auto tokenNotificationURL = decoder.decode<String>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::ApplePayRecurringPaymentRequest {
            WTFMove(*paymentDescription),
            WTFMove(*regularBilling),
            WTFMove(*trialBilling),
            WTFMove(*billingAgreement),
            WTFMove(*managementURL),
            WTFMove(*tokenNotificationURL)
        }
    };
}

#endif

#if ENABLE(APPLE_PAY_MULTI_MERCHANT_PAYMENTS)
void ArgumentCoder<WebCore::ApplePayPaymentTokenContext>::encode(Encoder& encoder, const WebCore::ApplePayPaymentTokenContext& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.merchantIdentifier)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.externalIdentifier)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.merchantName)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.merchantDomain)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.amount)>, String>);
    struct ShouldBeSameSizeAsApplePayPaymentTokenContext : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::ApplePayPaymentTokenContext>, false> {
        String merchantIdentifier;
        String externalIdentifier;
        String merchantName;
        String merchantDomain;
        String amount;
    };
    static_assert(sizeof(ShouldBeSameSizeAsApplePayPaymentTokenContext) == sizeof(WebCore::ApplePayPaymentTokenContext));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::ApplePayPaymentTokenContext, merchantIdentifier)
        , offsetof(WebCore::ApplePayPaymentTokenContext, externalIdentifier)
        , offsetof(WebCore::ApplePayPaymentTokenContext, merchantName)
        , offsetof(WebCore::ApplePayPaymentTokenContext, merchantDomain)
        , offsetof(WebCore::ApplePayPaymentTokenContext, amount)
    >::value);

    encoder << instance.merchantIdentifier;
    encoder << instance.externalIdentifier;
    encoder << instance.merchantName;
    encoder << instance.merchantDomain;
    encoder << instance.amount;
}

std::optional<WebCore::ApplePayPaymentTokenContext> ArgumentCoder<WebCore::ApplePayPaymentTokenContext>::decode(Decoder& decoder)
{
    auto merchantIdentifier = decoder.decode<String>();
    auto externalIdentifier = decoder.decode<String>();
    auto merchantName = decoder.decode<String>();
    auto merchantDomain = decoder.decode<String>();
    auto amount = decoder.decode<String>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::ApplePayPaymentTokenContext {
            WTFMove(*merchantIdentifier),
            WTFMove(*externalIdentifier),
            WTFMove(*merchantName),
            WTFMove(*merchantDomain),
            WTFMove(*amount)
        }
    };
}

#endif

#if ENABLE(APPLE_PAY_DEFERRED_PAYMENTS)
void ArgumentCoder<WebCore::ApplePayDeferredPaymentRequest>::encode(Encoder& encoder, const WebCore::ApplePayDeferredPaymentRequest& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.billingAgreement)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.deferredBilling)>, WebCore::ApplePayLineItem>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.freeCancellationDate)>, WallTime>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.freeCancellationDateTimeZone)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.managementURL)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.paymentDescription)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.tokenNotificationURL)>, String>);
    struct ShouldBeSameSizeAsApplePayDeferredPaymentRequest : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::ApplePayDeferredPaymentRequest>, false> {
        String billingAgreement;
        WebCore::ApplePayLineItem deferredBilling;
        WallTime freeCancellationDate;
        String freeCancellationDateTimeZone;
        String managementURL;
        String paymentDescription;
        String tokenNotificationURL;
    };
    static_assert(sizeof(ShouldBeSameSizeAsApplePayDeferredPaymentRequest) == sizeof(WebCore::ApplePayDeferredPaymentRequest));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::ApplePayDeferredPaymentRequest, billingAgreement)
        , offsetof(WebCore::ApplePayDeferredPaymentRequest, deferredBilling)
        , offsetof(WebCore::ApplePayDeferredPaymentRequest, freeCancellationDate)
        , offsetof(WebCore::ApplePayDeferredPaymentRequest, freeCancellationDateTimeZone)
        , offsetof(WebCore::ApplePayDeferredPaymentRequest, managementURL)
        , offsetof(WebCore::ApplePayDeferredPaymentRequest, paymentDescription)
        , offsetof(WebCore::ApplePayDeferredPaymentRequest, tokenNotificationURL)
    >::value);

    encoder << instance.billingAgreement;
    encoder << instance.deferredBilling;
    encoder << instance.freeCancellationDate;
    encoder << instance.freeCancellationDateTimeZone;
    encoder << instance.managementURL;
    encoder << instance.paymentDescription;
    encoder << instance.tokenNotificationURL;
}

std::optional<WebCore::ApplePayDeferredPaymentRequest> ArgumentCoder<WebCore::ApplePayDeferredPaymentRequest>::decode(Decoder& decoder)
{
    auto billingAgreement = decoder.decode<String>();
    auto deferredBilling = decoder.decode<WebCore::ApplePayLineItem>();
    auto freeCancellationDate = decoder.decode<WallTime>();
    auto freeCancellationDateTimeZone = decoder.decode<String>();
    auto managementURL = decoder.decode<String>();
    auto paymentDescription = decoder.decode<String>();
    auto tokenNotificationURL = decoder.decode<String>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::ApplePayDeferredPaymentRequest {
            WTFMove(*billingAgreement),
            WTFMove(*deferredBilling),
            WTFMove(*freeCancellationDate),
            WTFMove(*freeCancellationDateTimeZone),
            WTFMove(*managementURL),
            WTFMove(*paymentDescription),
            WTFMove(*tokenNotificationURL)
        }
    };
}

#endif

#if ENABLE(APPLE_PAY_PAYMENT_ORDER_DETAILS)
void ArgumentCoder<WebCore::ApplePayPaymentOrderDetails>::encode(Encoder& encoder, const WebCore::ApplePayPaymentOrderDetails& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.orderTypeIdentifier)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.orderIdentifier)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.webServiceURL)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.authenticationToken)>, String>);
    struct ShouldBeSameSizeAsApplePayPaymentOrderDetails : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::ApplePayPaymentOrderDetails>, false> {
        String orderTypeIdentifier;
        String orderIdentifier;
        String webServiceURL;
        String authenticationToken;
    };
    static_assert(sizeof(ShouldBeSameSizeAsApplePayPaymentOrderDetails) == sizeof(WebCore::ApplePayPaymentOrderDetails));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::ApplePayPaymentOrderDetails, orderTypeIdentifier)
        , offsetof(WebCore::ApplePayPaymentOrderDetails, orderIdentifier)
        , offsetof(WebCore::ApplePayPaymentOrderDetails, webServiceURL)
        , offsetof(WebCore::ApplePayPaymentOrderDetails, authenticationToken)
    >::value);

    encoder << instance.orderTypeIdentifier;
    encoder << instance.orderIdentifier;
    encoder << instance.webServiceURL;
    encoder << instance.authenticationToken;
}

std::optional<WebCore::ApplePayPaymentOrderDetails> ArgumentCoder<WebCore::ApplePayPaymentOrderDetails>::decode(Decoder& decoder)
{
    auto orderTypeIdentifier = decoder.decode<String>();
    auto orderIdentifier = decoder.decode<String>();
    auto webServiceURL = decoder.decode<String>();
    auto authenticationToken = decoder.decode<String>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::ApplePayPaymentOrderDetails {
            WTFMove(*orderTypeIdentifier),
            WTFMove(*orderIdentifier),
            WTFMove(*webServiceURL),
            WTFMove(*authenticationToken)
        }
    };
}

#endif

#if ENABLE(APPLE_PAY_AMS_UI) && ENABLE(PAYMENT_REQUEST)
void ArgumentCoder<WebCore::ApplePayAMSUIRequest>::encode(Encoder& encoder, const WebCore::ApplePayAMSUIRequest& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.engagementRequest)>, String>);
    struct ShouldBeSameSizeAsApplePayAMSUIRequest : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::ApplePayAMSUIRequest>, false> {
        String engagementRequest;
    };
    static_assert(sizeof(ShouldBeSameSizeAsApplePayAMSUIRequest) == sizeof(WebCore::ApplePayAMSUIRequest));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::ApplePayAMSUIRequest, engagementRequest)
    >::value);

    encoder << instance.engagementRequest;
}

std::optional<WebCore::ApplePayAMSUIRequest> ArgumentCoder<WebCore::ApplePayAMSUIRequest>::decode(Decoder& decoder)
{
    auto engagementRequest = decoder.decode<String>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::ApplePayAMSUIRequest {
            WTFMove(*engagementRequest)
        }
    };
}

#endif

#if ENABLE(APPLE_PAY_AUTOMATIC_RELOAD_PAYMENTS)
void ArgumentCoder<WebCore::ApplePayAutomaticReloadPaymentRequest>::encode(Encoder& encoder, const WebCore::ApplePayAutomaticReloadPaymentRequest& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.paymentDescription)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.automaticReloadBilling)>, WebCore::ApplePayLineItem>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.billingAgreement)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.managementURL)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.tokenNotificationURL)>, String>);
    struct ShouldBeSameSizeAsApplePayAutomaticReloadPaymentRequest : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::ApplePayAutomaticReloadPaymentRequest>, false> {
        String paymentDescription;
        WebCore::ApplePayLineItem automaticReloadBilling;
        String billingAgreement;
        String managementURL;
        String tokenNotificationURL;
    };
    static_assert(sizeof(ShouldBeSameSizeAsApplePayAutomaticReloadPaymentRequest) == sizeof(WebCore::ApplePayAutomaticReloadPaymentRequest));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::ApplePayAutomaticReloadPaymentRequest, paymentDescription)
        , offsetof(WebCore::ApplePayAutomaticReloadPaymentRequest, automaticReloadBilling)
        , offsetof(WebCore::ApplePayAutomaticReloadPaymentRequest, billingAgreement)
        , offsetof(WebCore::ApplePayAutomaticReloadPaymentRequest, managementURL)
        , offsetof(WebCore::ApplePayAutomaticReloadPaymentRequest, tokenNotificationURL)
    >::value);

    encoder << instance.paymentDescription;
    encoder << instance.automaticReloadBilling;
    encoder << instance.billingAgreement;
    encoder << instance.managementURL;
    encoder << instance.tokenNotificationURL;
}

std::optional<WebCore::ApplePayAutomaticReloadPaymentRequest> ArgumentCoder<WebCore::ApplePayAutomaticReloadPaymentRequest>::decode(Decoder& decoder)
{
    auto paymentDescription = decoder.decode<String>();
    auto automaticReloadBilling = decoder.decode<WebCore::ApplePayLineItem>();
    auto billingAgreement = decoder.decode<String>();
    auto managementURL = decoder.decode<String>();
    auto tokenNotificationURL = decoder.decode<String>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::ApplePayAutomaticReloadPaymentRequest {
            WTFMove(*paymentDescription),
            WTFMove(*automaticReloadBilling),
            WTFMove(*billingAgreement),
            WTFMove(*managementURL),
            WTFMove(*tokenNotificationURL)
        }
    };
}

#endif

#if ENABLE(APPLE_PAY_SHIPPING_METHOD_DATE_COMPONENTS_RANGE)
void ArgumentCoder<WebCore::ApplePayDateComponents>::encode(Encoder& encoder, const WebCore::ApplePayDateComponents& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.years)>, std::optional<unsigned>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.months)>, std::optional<unsigned>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.days)>, std::optional<unsigned>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.hours)>, std::optional<unsigned>>);
    struct ShouldBeSameSizeAsApplePayDateComponents : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::ApplePayDateComponents>, false> {
        std::optional<unsigned> years;
        std::optional<unsigned> months;
        std::optional<unsigned> days;
        std::optional<unsigned> hours;
    };
    static_assert(sizeof(ShouldBeSameSizeAsApplePayDateComponents) == sizeof(WebCore::ApplePayDateComponents));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::ApplePayDateComponents, years)
        , offsetof(WebCore::ApplePayDateComponents, months)
        , offsetof(WebCore::ApplePayDateComponents, days)
        , offsetof(WebCore::ApplePayDateComponents, hours)
    >::value);

    encoder << instance.years;
    encoder << instance.months;
    encoder << instance.days;
    encoder << instance.hours;
}

std::optional<WebCore::ApplePayDateComponents> ArgumentCoder<WebCore::ApplePayDateComponents>::decode(Decoder& decoder)
{
    auto years = decoder.decode<std::optional<unsigned>>();
    auto months = decoder.decode<std::optional<unsigned>>();
    auto days = decoder.decode<std::optional<unsigned>>();
    auto hours = decoder.decode<std::optional<unsigned>>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::ApplePayDateComponents {
            WTFMove(*years),
            WTFMove(*months),
            WTFMove(*days),
            WTFMove(*hours)
        }
    };
}

#endif

#if ENABLE(APPLE_PAY_SHIPPING_METHOD_DATE_COMPONENTS_RANGE)
void ArgumentCoder<WebCore::ApplePayDateComponentsRange>::encode(Encoder& encoder, const WebCore::ApplePayDateComponentsRange& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.startDateComponents)>, WebCore::ApplePayDateComponents>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.endDateComponents)>, WebCore::ApplePayDateComponents>);
    struct ShouldBeSameSizeAsApplePayDateComponentsRange : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::ApplePayDateComponentsRange>, false> {
        WebCore::ApplePayDateComponents startDateComponents;
        WebCore::ApplePayDateComponents endDateComponents;
    };
    static_assert(sizeof(ShouldBeSameSizeAsApplePayDateComponentsRange) == sizeof(WebCore::ApplePayDateComponentsRange));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::ApplePayDateComponentsRange, startDateComponents)
        , offsetof(WebCore::ApplePayDateComponentsRange, endDateComponents)
    >::value);

    encoder << instance.startDateComponents;
    encoder << instance.endDateComponents;
}

std::optional<WebCore::ApplePayDateComponentsRange> ArgumentCoder<WebCore::ApplePayDateComponentsRange>::decode(Decoder& decoder)
{
    auto startDateComponents = decoder.decode<WebCore::ApplePayDateComponents>();
    auto endDateComponents = decoder.decode<WebCore::ApplePayDateComponents>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::ApplePayDateComponentsRange {
            WTFMove(*startDateComponents),
            WTFMove(*endDateComponents)
        }
    };
}

#endif

#if ENABLE(APPLE_PAY)
void ArgumentCoder<WebCore::ApplePaySetupConfiguration>::encode(Encoder& encoder, const WebCore::ApplePaySetupConfiguration& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.merchantIdentifier)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.referrerIdentifier)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.signature)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.signedFields)>, Vector<String>>);
    struct ShouldBeSameSizeAsApplePaySetupConfiguration : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::ApplePaySetupConfiguration>, false> {
        String merchantIdentifier;
        String referrerIdentifier;
        String signature;
        Vector<String> signedFields;
    };
    static_assert(sizeof(ShouldBeSameSizeAsApplePaySetupConfiguration) == sizeof(WebCore::ApplePaySetupConfiguration));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::ApplePaySetupConfiguration, merchantIdentifier)
        , offsetof(WebCore::ApplePaySetupConfiguration, referrerIdentifier)
        , offsetof(WebCore::ApplePaySetupConfiguration, signature)
        , offsetof(WebCore::ApplePaySetupConfiguration, signedFields)
    >::value);

    encoder << instance.merchantIdentifier;
    encoder << instance.referrerIdentifier;
    encoder << instance.signature;
    encoder << instance.signedFields;
}

std::optional<WebCore::ApplePaySetupConfiguration> ArgumentCoder<WebCore::ApplePaySetupConfiguration>::decode(Decoder& decoder)
{
    auto merchantIdentifier = decoder.decode<String>();
    auto referrerIdentifier = decoder.decode<String>();
    auto signature = decoder.decode<String>();
    auto signedFields = decoder.decode<Vector<String>>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::ApplePaySetupConfiguration {
            WTFMove(*merchantIdentifier),
            WTFMove(*referrerIdentifier),
            WTFMove(*signature),
            WTFMove(*signedFields)
        }
    };
}

#endif

#if ENABLE(APPLE_PAY)
void ArgumentCoder<WebCore::ApplePayLineItem>::encode(Encoder& encoder, const WebCore::ApplePayLineItem& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.type)>, WebCore::ApplePayLineItem::Type>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.label)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.amount)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.paymentTiming)>, WebCore::ApplePayPaymentTiming>);
#if ENABLE(APPLE_PAY_RECURRING_LINE_ITEM)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.recurringPaymentStartDate)>, WallTime>);
#endif
#if ENABLE(APPLE_PAY_RECURRING_LINE_ITEM)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.recurringPaymentIntervalUnit)>, WebCore::ApplePayRecurringPaymentDateUnit>);
#endif
#if ENABLE(APPLE_PAY_RECURRING_LINE_ITEM)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.recurringPaymentIntervalCount)>, unsigned>);
#endif
#if ENABLE(APPLE_PAY_RECURRING_LINE_ITEM)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.recurringPaymentEndDate)>, WallTime>);
#endif
#if ENABLE(APPLE_PAY_DEFERRED_LINE_ITEM)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.deferredPaymentDate)>, WallTime>);
#endif
#if ENABLE(APPLE_PAY_AUTOMATIC_RELOAD_LINE_ITEM)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.automaticReloadPaymentThresholdAmount)>, String>);
#endif
#if ENABLE(APPLE_PAY_DISBURSEMENTS)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.disbursementLineItemType)>, std::optional<WebCore::ApplePayLineItem::DisbursementLineItemType>>);
#endif
    struct ShouldBeSameSizeAsApplePayLineItem : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::ApplePayLineItem>, false> {
        WebCore::ApplePayLineItem::Type type;
        String label;
        String amount;
        WebCore::ApplePayPaymentTiming paymentTiming;
#if ENABLE(APPLE_PAY_RECURRING_LINE_ITEM)
        WallTime recurringPaymentStartDate;
#endif
#if ENABLE(APPLE_PAY_RECURRING_LINE_ITEM)
        WebCore::ApplePayRecurringPaymentDateUnit recurringPaymentIntervalUnit;
#endif
#if ENABLE(APPLE_PAY_RECURRING_LINE_ITEM)
        unsigned recurringPaymentIntervalCount;
#endif
#if ENABLE(APPLE_PAY_RECURRING_LINE_ITEM)
        WallTime recurringPaymentEndDate;
#endif
#if ENABLE(APPLE_PAY_DEFERRED_LINE_ITEM)
        WallTime deferredPaymentDate;
#endif
#if ENABLE(APPLE_PAY_AUTOMATIC_RELOAD_LINE_ITEM)
        String automaticReloadPaymentThresholdAmount;
#endif
#if ENABLE(APPLE_PAY_DISBURSEMENTS)
        std::optional<WebCore::ApplePayLineItem::DisbursementLineItemType> disbursementLineItemType;
#endif
    };
    static_assert(sizeof(ShouldBeSameSizeAsApplePayLineItem) == sizeof(WebCore::ApplePayLineItem));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::ApplePayLineItem, type)
        , offsetof(WebCore::ApplePayLineItem, label)
        , offsetof(WebCore::ApplePayLineItem, amount)
        , offsetof(WebCore::ApplePayLineItem, paymentTiming)
#if ENABLE(APPLE_PAY_RECURRING_LINE_ITEM)
        , offsetof(WebCore::ApplePayLineItem, recurringPaymentStartDate)
#endif
#if ENABLE(APPLE_PAY_RECURRING_LINE_ITEM)
        , offsetof(WebCore::ApplePayLineItem, recurringPaymentIntervalUnit)
#endif
#if ENABLE(APPLE_PAY_RECURRING_LINE_ITEM)
        , offsetof(WebCore::ApplePayLineItem, recurringPaymentIntervalCount)
#endif
#if ENABLE(APPLE_PAY_RECURRING_LINE_ITEM)
        , offsetof(WebCore::ApplePayLineItem, recurringPaymentEndDate)
#endif
#if ENABLE(APPLE_PAY_DEFERRED_LINE_ITEM)
        , offsetof(WebCore::ApplePayLineItem, deferredPaymentDate)
#endif
#if ENABLE(APPLE_PAY_AUTOMATIC_RELOAD_LINE_ITEM)
        , offsetof(WebCore::ApplePayLineItem, automaticReloadPaymentThresholdAmount)
#endif
#if ENABLE(APPLE_PAY_DISBURSEMENTS)
        , offsetof(WebCore::ApplePayLineItem, disbursementLineItemType)
#endif
    >::value);

    encoder << instance.type;
    encoder << instance.label;
    encoder << instance.amount;
    encoder << instance.paymentTiming;
#if ENABLE(APPLE_PAY_RECURRING_LINE_ITEM)
    encoder << instance.recurringPaymentStartDate;
#endif
#if ENABLE(APPLE_PAY_RECURRING_LINE_ITEM)
    encoder << instance.recurringPaymentIntervalUnit;
#endif
#if ENABLE(APPLE_PAY_RECURRING_LINE_ITEM)
    encoder << instance.recurringPaymentIntervalCount;
#endif
#if ENABLE(APPLE_PAY_RECURRING_LINE_ITEM)
    encoder << instance.recurringPaymentEndDate;
#endif
#if ENABLE(APPLE_PAY_DEFERRED_LINE_ITEM)
    encoder << instance.deferredPaymentDate;
#endif
#if ENABLE(APPLE_PAY_AUTOMATIC_RELOAD_LINE_ITEM)
    encoder << instance.automaticReloadPaymentThresholdAmount;
#endif
#if ENABLE(APPLE_PAY_DISBURSEMENTS)
    encoder << instance.disbursementLineItemType;
#endif
}

std::optional<WebCore::ApplePayLineItem> ArgumentCoder<WebCore::ApplePayLineItem>::decode(Decoder& decoder)
{
    auto type = decoder.decode<WebCore::ApplePayLineItem::Type>();
    auto label = decoder.decode<String>();
    auto amount = decoder.decode<String>();
    auto paymentTiming = decoder.decode<WebCore::ApplePayPaymentTiming>();
#if ENABLE(APPLE_PAY_RECURRING_LINE_ITEM)
    auto recurringPaymentStartDate = decoder.decode<WallTime>();
#endif
#if ENABLE(APPLE_PAY_RECURRING_LINE_ITEM)
    auto recurringPaymentIntervalUnit = decoder.decode<WebCore::ApplePayRecurringPaymentDateUnit>();
#endif
#if ENABLE(APPLE_PAY_RECURRING_LINE_ITEM)
    auto recurringPaymentIntervalCount = decoder.decode<unsigned>();
#endif
#if ENABLE(APPLE_PAY_RECURRING_LINE_ITEM)
    auto recurringPaymentEndDate = decoder.decode<WallTime>();
#endif
#if ENABLE(APPLE_PAY_DEFERRED_LINE_ITEM)
    auto deferredPaymentDate = decoder.decode<WallTime>();
#endif
#if ENABLE(APPLE_PAY_AUTOMATIC_RELOAD_LINE_ITEM)
    auto automaticReloadPaymentThresholdAmount = decoder.decode<String>();
#endif
#if ENABLE(APPLE_PAY_DISBURSEMENTS)
    auto disbursementLineItemType = decoder.decode<std::optional<WebCore::ApplePayLineItem::DisbursementLineItemType>>();
#endif
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::ApplePayLineItem {
            WTFMove(*type),
            WTFMove(*label),
            WTFMove(*amount),
            WTFMove(*paymentTiming),
#if ENABLE(APPLE_PAY_RECURRING_LINE_ITEM)
            WTFMove(*recurringPaymentStartDate),
#endif
#if ENABLE(APPLE_PAY_RECURRING_LINE_ITEM)
            WTFMove(*recurringPaymentIntervalUnit),
#endif
#if ENABLE(APPLE_PAY_RECURRING_LINE_ITEM)
            WTFMove(*recurringPaymentIntervalCount),
#endif
#if ENABLE(APPLE_PAY_RECURRING_LINE_ITEM)
            WTFMove(*recurringPaymentEndDate),
#endif
#if ENABLE(APPLE_PAY_DEFERRED_LINE_ITEM)
            WTFMove(*deferredPaymentDate),
#endif
#if ENABLE(APPLE_PAY_AUTOMATIC_RELOAD_LINE_ITEM)
            WTFMove(*automaticReloadPaymentThresholdAmount),
#endif
#if ENABLE(APPLE_PAY_DISBURSEMENTS)
            WTFMove(*disbursementLineItemType)
#endif
        }
    };
}

#endif

#if ENABLE(APPLE_PAY)
void ArgumentCoder<WebCore::ApplePayShippingMethod>::encode(Encoder& encoder, const WebCore::ApplePayShippingMethod& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.label)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.detail)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.amount)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.identifier)>, String>);
#if ENABLE(APPLE_PAY_SHIPPING_METHOD_DATE_COMPONENTS_RANGE)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.dateComponentsRange)>, std::optional<WebCore::ApplePayDateComponentsRange>>);
#endif
#if ENABLE(APPLE_PAY_SELECTED_SHIPPING_METHOD)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.selected)>, bool>);
#endif
    struct ShouldBeSameSizeAsApplePayShippingMethod : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::ApplePayShippingMethod>, false> {
        String label;
        String detail;
        String amount;
        String identifier;
#if ENABLE(APPLE_PAY_SHIPPING_METHOD_DATE_COMPONENTS_RANGE)
        std::optional<WebCore::ApplePayDateComponentsRange> dateComponentsRange;
#endif
#if ENABLE(APPLE_PAY_SELECTED_SHIPPING_METHOD)
        bool selected;
#endif
    };
    static_assert(sizeof(ShouldBeSameSizeAsApplePayShippingMethod) == sizeof(WebCore::ApplePayShippingMethod));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::ApplePayShippingMethod, label)
        , offsetof(WebCore::ApplePayShippingMethod, detail)
        , offsetof(WebCore::ApplePayShippingMethod, amount)
        , offsetof(WebCore::ApplePayShippingMethod, identifier)
#if ENABLE(APPLE_PAY_SHIPPING_METHOD_DATE_COMPONENTS_RANGE)
        , offsetof(WebCore::ApplePayShippingMethod, dateComponentsRange)
#endif
#if ENABLE(APPLE_PAY_SELECTED_SHIPPING_METHOD)
        , offsetof(WebCore::ApplePayShippingMethod, selected)
#endif
    >::value);

    encoder << instance.label;
    encoder << instance.detail;
    encoder << instance.amount;
    encoder << instance.identifier;
#if ENABLE(APPLE_PAY_SHIPPING_METHOD_DATE_COMPONENTS_RANGE)
    encoder << instance.dateComponentsRange;
#endif
#if ENABLE(APPLE_PAY_SELECTED_SHIPPING_METHOD)
    encoder << instance.selected;
#endif
}

std::optional<WebCore::ApplePayShippingMethod> ArgumentCoder<WebCore::ApplePayShippingMethod>::decode(Decoder& decoder)
{
    auto label = decoder.decode<String>();
    auto detail = decoder.decode<String>();
    auto amount = decoder.decode<String>();
    auto identifier = decoder.decode<String>();
#if ENABLE(APPLE_PAY_SHIPPING_METHOD_DATE_COMPONENTS_RANGE)
    auto dateComponentsRange = decoder.decode<std::optional<WebCore::ApplePayDateComponentsRange>>();
#endif
#if ENABLE(APPLE_PAY_SELECTED_SHIPPING_METHOD)
    auto selected = decoder.decode<bool>();
#endif
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::ApplePayShippingMethod {
            WTFMove(*label),
            WTFMove(*detail),
            WTFMove(*amount),
            WTFMove(*identifier),
#if ENABLE(APPLE_PAY_SHIPPING_METHOD_DATE_COMPONENTS_RANGE)
            WTFMove(*dateComponentsRange),
#endif
#if ENABLE(APPLE_PAY_SELECTED_SHIPPING_METHOD)
            WTFMove(*selected)
#endif
        }
    };
}

#endif

#if ENABLE(APPLE_PAY)
void ArgumentCoder<WebCore::ApplePayError>::encode(Encoder& encoder, const WebCore::ApplePayError& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.code())>, WebCore::ApplePayErrorCode>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.contactField())>, std::optional<WebCore::ApplePayErrorContactField>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.message())>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.domain())>, std::optional<WebCore::ApplePayError::Domain>>);

    encoder << instance.code();
    encoder << instance.contactField();
    encoder << instance.message();
    encoder << instance.domain();
}

std::optional<Ref<WebCore::ApplePayError>> ArgumentCoder<WebCore::ApplePayError>::decode(Decoder& decoder)
{
    auto code = decoder.decode<WebCore::ApplePayErrorCode>();
    auto contactField = decoder.decode<std::optional<WebCore::ApplePayErrorContactField>>();
    auto message = decoder.decode<String>();
    auto domain = decoder.decode<std::optional<WebCore::ApplePayError::Domain>>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::ApplePayError::create(
            WTFMove(*code),
            WTFMove(*contactField),
            WTFMove(*message),
            WTFMove(*domain)
        )
    };
}

#endif

#if ENABLE(APPLE_PAY)
void ArgumentCoder<WebCore::ApplePayLogoSystemImage>::encode(Encoder& encoder, const WebCore::ApplePayLogoSystemImage& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.applePayLogoStyle())>, WebCore::ApplePayLogoStyle>);

    encoder << instance.applePayLogoStyle();
}

void ArgumentCoder<WebCore::ApplePayLogoSystemImage>::encode(StreamConnectionEncoder& encoder, const WebCore::ApplePayLogoSystemImage& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.applePayLogoStyle())>, WebCore::ApplePayLogoStyle>);

    encoder << instance.applePayLogoStyle();
}

std::optional<Ref<WebCore::ApplePayLogoSystemImage>> ArgumentCoder<WebCore::ApplePayLogoSystemImage>::decode(Decoder& decoder)
{
    auto applePayLogoStyle = decoder.decode<WebCore::ApplePayLogoStyle>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::ApplePayLogoSystemImage::create(
            WTFMove(*applePayLogoStyle)
        )
    };
}

#endif

#if ENABLE(APPLE_PAY)
void ArgumentCoder<WebCore::ApplePayDetailsUpdateBase>::encode(Encoder& encoder, const WebCore::ApplePayDetailsUpdateBase& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.newTotal)>, WebCore::ApplePayLineItem>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.newLineItems)>, Vector<WebCore::ApplePayLineItem>>);
#if ENABLE(APPLE_PAY_RECURRING_PAYMENTS)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.newRecurringPaymentRequest)>, std::optional<WebCore::ApplePayRecurringPaymentRequest>>);
#endif
#if ENABLE(APPLE_PAY_AUTOMATIC_RELOAD_PAYMENTS)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.newAutomaticReloadPaymentRequest)>, std::optional<WebCore::ApplePayAutomaticReloadPaymentRequest>>);
#endif
#if ENABLE(APPLE_PAY_MULTI_MERCHANT_PAYMENTS)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.newMultiTokenContexts)>, std::optional<Vector<WebCore::ApplePayPaymentTokenContext>>>);
#endif
#if ENABLE(APPLE_PAY_DEFERRED_PAYMENTS)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.newDeferredPaymentRequest)>, std::optional<WebCore::ApplePayDeferredPaymentRequest>>);
#endif
#if ENABLE(APPLE_PAY_DISBURSEMENTS)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.newDisbursementRequest)>, std::optional<WebCore::ApplePayDisbursementRequest>>);
#endif
    struct ShouldBeSameSizeAsApplePayDetailsUpdateBase : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::ApplePayDetailsUpdateBase>, false> {
        WebCore::ApplePayLineItem newTotal;
        Vector<WebCore::ApplePayLineItem> newLineItems;
#if ENABLE(APPLE_PAY_RECURRING_PAYMENTS)
        std::optional<WebCore::ApplePayRecurringPaymentRequest> newRecurringPaymentRequest;
#endif
#if ENABLE(APPLE_PAY_AUTOMATIC_RELOAD_PAYMENTS)
        std::optional<WebCore::ApplePayAutomaticReloadPaymentRequest> newAutomaticReloadPaymentRequest;
#endif
#if ENABLE(APPLE_PAY_MULTI_MERCHANT_PAYMENTS)
        std::optional<Vector<WebCore::ApplePayPaymentTokenContext>> newMultiTokenContexts;
#endif
#if ENABLE(APPLE_PAY_DEFERRED_PAYMENTS)
        std::optional<WebCore::ApplePayDeferredPaymentRequest> newDeferredPaymentRequest;
#endif
#if ENABLE(APPLE_PAY_DISBURSEMENTS)
        std::optional<WebCore::ApplePayDisbursementRequest> newDisbursementRequest;
#endif
    };
    static_assert(sizeof(ShouldBeSameSizeAsApplePayDetailsUpdateBase) == sizeof(WebCore::ApplePayDetailsUpdateBase));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::ApplePayDetailsUpdateBase, newTotal)
        , offsetof(WebCore::ApplePayDetailsUpdateBase, newLineItems)
#if ENABLE(APPLE_PAY_RECURRING_PAYMENTS)
        , offsetof(WebCore::ApplePayDetailsUpdateBase, newRecurringPaymentRequest)
#endif
#if ENABLE(APPLE_PAY_AUTOMATIC_RELOAD_PAYMENTS)
        , offsetof(WebCore::ApplePayDetailsUpdateBase, newAutomaticReloadPaymentRequest)
#endif
#if ENABLE(APPLE_PAY_MULTI_MERCHANT_PAYMENTS)
        , offsetof(WebCore::ApplePayDetailsUpdateBase, newMultiTokenContexts)
#endif
#if ENABLE(APPLE_PAY_DEFERRED_PAYMENTS)
        , offsetof(WebCore::ApplePayDetailsUpdateBase, newDeferredPaymentRequest)
#endif
#if ENABLE(APPLE_PAY_DISBURSEMENTS)
        , offsetof(WebCore::ApplePayDetailsUpdateBase, newDisbursementRequest)
#endif
    >::value);

    encoder << instance.newTotal;
    encoder << instance.newLineItems;
#if ENABLE(APPLE_PAY_RECURRING_PAYMENTS)
    encoder << instance.newRecurringPaymentRequest;
#endif
#if ENABLE(APPLE_PAY_AUTOMATIC_RELOAD_PAYMENTS)
    encoder << instance.newAutomaticReloadPaymentRequest;
#endif
#if ENABLE(APPLE_PAY_MULTI_MERCHANT_PAYMENTS)
    encoder << instance.newMultiTokenContexts;
#endif
#if ENABLE(APPLE_PAY_DEFERRED_PAYMENTS)
    encoder << instance.newDeferredPaymentRequest;
#endif
#if ENABLE(APPLE_PAY_DISBURSEMENTS)
    encoder << instance.newDisbursementRequest;
#endif
}

std::optional<WebCore::ApplePayDetailsUpdateBase> ArgumentCoder<WebCore::ApplePayDetailsUpdateBase>::decode(Decoder& decoder)
{
    auto newTotal = decoder.decode<WebCore::ApplePayLineItem>();
    auto newLineItems = decoder.decode<Vector<WebCore::ApplePayLineItem>>();
#if ENABLE(APPLE_PAY_RECURRING_PAYMENTS)
    auto newRecurringPaymentRequest = decoder.decode<std::optional<WebCore::ApplePayRecurringPaymentRequest>>();
#endif
#if ENABLE(APPLE_PAY_AUTOMATIC_RELOAD_PAYMENTS)
    auto newAutomaticReloadPaymentRequest = decoder.decode<std::optional<WebCore::ApplePayAutomaticReloadPaymentRequest>>();
#endif
#if ENABLE(APPLE_PAY_MULTI_MERCHANT_PAYMENTS)
    auto newMultiTokenContexts = decoder.decode<std::optional<Vector<WebCore::ApplePayPaymentTokenContext>>>();
#endif
#if ENABLE(APPLE_PAY_DEFERRED_PAYMENTS)
    auto newDeferredPaymentRequest = decoder.decode<std::optional<WebCore::ApplePayDeferredPaymentRequest>>();
#endif
#if ENABLE(APPLE_PAY_DISBURSEMENTS)
    auto newDisbursementRequest = decoder.decode<std::optional<WebCore::ApplePayDisbursementRequest>>();
#endif
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::ApplePayDetailsUpdateBase {
            WTFMove(*newTotal),
            WTFMove(*newLineItems),
#if ENABLE(APPLE_PAY_RECURRING_PAYMENTS)
            WTFMove(*newRecurringPaymentRequest),
#endif
#if ENABLE(APPLE_PAY_AUTOMATIC_RELOAD_PAYMENTS)
            WTFMove(*newAutomaticReloadPaymentRequest),
#endif
#if ENABLE(APPLE_PAY_MULTI_MERCHANT_PAYMENTS)
            WTFMove(*newMultiTokenContexts),
#endif
#if ENABLE(APPLE_PAY_DEFERRED_PAYMENTS)
            WTFMove(*newDeferredPaymentRequest),
#endif
#if ENABLE(APPLE_PAY_DISBURSEMENTS)
            WTFMove(*newDisbursementRequest)
#endif
        }
    };
}

#endif

#if ENABLE(APPLE_PAY)
void ArgumentCoder<WebCore::ApplePayPaymentMethodUpdate>::encode(Encoder& encoder, const WebCore::ApplePayPaymentMethodUpdate& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.newTotal)>, WebCore::ApplePayLineItem>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.newLineItems)>, Vector<WebCore::ApplePayLineItem>>);
#if ENABLE(APPLE_PAY_RECURRING_PAYMENTS)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.newRecurringPaymentRequest)>, std::optional<WebCore::ApplePayRecurringPaymentRequest>>);
#endif
#if ENABLE(APPLE_PAY_AUTOMATIC_RELOAD_PAYMENTS)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.newAutomaticReloadPaymentRequest)>, std::optional<WebCore::ApplePayAutomaticReloadPaymentRequest>>);
#endif
#if ENABLE(APPLE_PAY_MULTI_MERCHANT_PAYMENTS)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.newMultiTokenContexts)>, std::optional<Vector<WebCore::ApplePayPaymentTokenContext>>>);
#endif
#if ENABLE(APPLE_PAY_DEFERRED_PAYMENTS)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.newDeferredPaymentRequest)>, std::optional<WebCore::ApplePayDeferredPaymentRequest>>);
#endif
#if ENABLE(APPLE_PAY_DISBURSEMENTS)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.newDisbursementRequest)>, std::optional<WebCore::ApplePayDisbursementRequest>>);
#endif
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::ApplePayDetailsUpdateBase, newTotal)
        , offsetof(WebCore::ApplePayDetailsUpdateBase, newLineItems)
#if ENABLE(APPLE_PAY_RECURRING_PAYMENTS)
        , offsetof(WebCore::ApplePayDetailsUpdateBase, newRecurringPaymentRequest)
#endif
#if ENABLE(APPLE_PAY_AUTOMATIC_RELOAD_PAYMENTS)
        , offsetof(WebCore::ApplePayDetailsUpdateBase, newAutomaticReloadPaymentRequest)
#endif
#if ENABLE(APPLE_PAY_MULTI_MERCHANT_PAYMENTS)
        , offsetof(WebCore::ApplePayDetailsUpdateBase, newMultiTokenContexts)
#endif
#if ENABLE(APPLE_PAY_DEFERRED_PAYMENTS)
        , offsetof(WebCore::ApplePayDetailsUpdateBase, newDeferredPaymentRequest)
#endif
#if ENABLE(APPLE_PAY_DISBURSEMENTS)
        , offsetof(WebCore::ApplePayDetailsUpdateBase, newDisbursementRequest)
#endif
    >::value);

#if ENABLE(APPLE_PAY_UPDATE_SHIPPING_METHODS_WHEN_CHANGING_LINE_ITEMS)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.errors)>, Vector<Ref<WebCore::ApplePayError>>>);
#endif
#if ENABLE(APPLE_PAY_UPDATE_SHIPPING_METHODS_WHEN_CHANGING_LINE_ITEMS)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.newShippingMethods)>, Vector<WebCore::ApplePayShippingMethod>>);
#endif
#if ENABLE(APPLE_PAY_INSTALLMENTS)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.installmentGroupIdentifier)>, String>);
#endif
    static_assert(MembersInCorrectOrder < 0
#if ENABLE(APPLE_PAY_UPDATE_SHIPPING_METHODS_WHEN_CHANGING_LINE_ITEMS)
        , offsetof(WebCore::ApplePayPaymentMethodUpdate, errors)
#endif
#if ENABLE(APPLE_PAY_UPDATE_SHIPPING_METHODS_WHEN_CHANGING_LINE_ITEMS)
        , offsetof(WebCore::ApplePayPaymentMethodUpdate, newShippingMethods)
#endif
#if ENABLE(APPLE_PAY_INSTALLMENTS)
        , offsetof(WebCore::ApplePayPaymentMethodUpdate, installmentGroupIdentifier)
#endif
    >::value);

    encoder << instance.newTotal;
    encoder << instance.newLineItems;
#if ENABLE(APPLE_PAY_RECURRING_PAYMENTS)
    encoder << instance.newRecurringPaymentRequest;
#endif
#if ENABLE(APPLE_PAY_AUTOMATIC_RELOAD_PAYMENTS)
    encoder << instance.newAutomaticReloadPaymentRequest;
#endif
#if ENABLE(APPLE_PAY_MULTI_MERCHANT_PAYMENTS)
    encoder << instance.newMultiTokenContexts;
#endif
#if ENABLE(APPLE_PAY_DEFERRED_PAYMENTS)
    encoder << instance.newDeferredPaymentRequest;
#endif
#if ENABLE(APPLE_PAY_DISBURSEMENTS)
    encoder << instance.newDisbursementRequest;
#endif
#if ENABLE(APPLE_PAY_UPDATE_SHIPPING_METHODS_WHEN_CHANGING_LINE_ITEMS)
    encoder << instance.errors;
#endif
#if ENABLE(APPLE_PAY_UPDATE_SHIPPING_METHODS_WHEN_CHANGING_LINE_ITEMS)
    encoder << instance.newShippingMethods;
#endif
#if ENABLE(APPLE_PAY_INSTALLMENTS)
    encoder << instance.installmentGroupIdentifier;
#endif
}

std::optional<WebCore::ApplePayPaymentMethodUpdate> ArgumentCoder<WebCore::ApplePayPaymentMethodUpdate>::decode(Decoder& decoder)
{
    auto newTotal = decoder.decode<WebCore::ApplePayLineItem>();
    auto newLineItems = decoder.decode<Vector<WebCore::ApplePayLineItem>>();
#if ENABLE(APPLE_PAY_RECURRING_PAYMENTS)
    auto newRecurringPaymentRequest = decoder.decode<std::optional<WebCore::ApplePayRecurringPaymentRequest>>();
#endif
#if ENABLE(APPLE_PAY_AUTOMATIC_RELOAD_PAYMENTS)
    auto newAutomaticReloadPaymentRequest = decoder.decode<std::optional<WebCore::ApplePayAutomaticReloadPaymentRequest>>();
#endif
#if ENABLE(APPLE_PAY_MULTI_MERCHANT_PAYMENTS)
    auto newMultiTokenContexts = decoder.decode<std::optional<Vector<WebCore::ApplePayPaymentTokenContext>>>();
#endif
#if ENABLE(APPLE_PAY_DEFERRED_PAYMENTS)
    auto newDeferredPaymentRequest = decoder.decode<std::optional<WebCore::ApplePayDeferredPaymentRequest>>();
#endif
#if ENABLE(APPLE_PAY_DISBURSEMENTS)
    auto newDisbursementRequest = decoder.decode<std::optional<WebCore::ApplePayDisbursementRequest>>();
#endif
#if ENABLE(APPLE_PAY_UPDATE_SHIPPING_METHODS_WHEN_CHANGING_LINE_ITEMS)
    auto errors = decoder.decode<Vector<Ref<WebCore::ApplePayError>>>();
#endif
#if ENABLE(APPLE_PAY_UPDATE_SHIPPING_METHODS_WHEN_CHANGING_LINE_ITEMS)
    auto newShippingMethods = decoder.decode<Vector<WebCore::ApplePayShippingMethod>>();
#endif
#if ENABLE(APPLE_PAY_INSTALLMENTS)
    auto installmentGroupIdentifier = decoder.decode<String>();
#endif
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::ApplePayPaymentMethodUpdate {
            WebCore::ApplePayDetailsUpdateBase {
                WTFMove(*newTotal),
                WTFMove(*newLineItems),
#if ENABLE(APPLE_PAY_RECURRING_PAYMENTS)
                WTFMove(*newRecurringPaymentRequest),
#endif
#if ENABLE(APPLE_PAY_AUTOMATIC_RELOAD_PAYMENTS)
                WTFMove(*newAutomaticReloadPaymentRequest),
#endif
#if ENABLE(APPLE_PAY_MULTI_MERCHANT_PAYMENTS)
                WTFMove(*newMultiTokenContexts),
#endif
#if ENABLE(APPLE_PAY_DEFERRED_PAYMENTS)
                WTFMove(*newDeferredPaymentRequest),
#endif
#if ENABLE(APPLE_PAY_DISBURSEMENTS)
                WTFMove(*newDisbursementRequest)
#endif
            },
#if ENABLE(APPLE_PAY_UPDATE_SHIPPING_METHODS_WHEN_CHANGING_LINE_ITEMS)
            WTFMove(*errors),
#endif
#if ENABLE(APPLE_PAY_UPDATE_SHIPPING_METHODS_WHEN_CHANGING_LINE_ITEMS)
            WTFMove(*newShippingMethods),
#endif
#if ENABLE(APPLE_PAY_INSTALLMENTS)
            WTFMove(*installmentGroupIdentifier)
#endif
        }
    };
}

#endif

#if ENABLE(APPLE_PAY)
void ArgumentCoder<WebCore::ApplePayShippingContactUpdate>::encode(Encoder& encoder, const WebCore::ApplePayShippingContactUpdate& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.newTotal)>, WebCore::ApplePayLineItem>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.newLineItems)>, Vector<WebCore::ApplePayLineItem>>);
#if ENABLE(APPLE_PAY_RECURRING_PAYMENTS)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.newRecurringPaymentRequest)>, std::optional<WebCore::ApplePayRecurringPaymentRequest>>);
#endif
#if ENABLE(APPLE_PAY_AUTOMATIC_RELOAD_PAYMENTS)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.newAutomaticReloadPaymentRequest)>, std::optional<WebCore::ApplePayAutomaticReloadPaymentRequest>>);
#endif
#if ENABLE(APPLE_PAY_MULTI_MERCHANT_PAYMENTS)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.newMultiTokenContexts)>, std::optional<Vector<WebCore::ApplePayPaymentTokenContext>>>);
#endif
#if ENABLE(APPLE_PAY_DEFERRED_PAYMENTS)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.newDeferredPaymentRequest)>, std::optional<WebCore::ApplePayDeferredPaymentRequest>>);
#endif
#if ENABLE(APPLE_PAY_DISBURSEMENTS)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.newDisbursementRequest)>, std::optional<WebCore::ApplePayDisbursementRequest>>);
#endif
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::ApplePayDetailsUpdateBase, newTotal)
        , offsetof(WebCore::ApplePayDetailsUpdateBase, newLineItems)
#if ENABLE(APPLE_PAY_RECURRING_PAYMENTS)
        , offsetof(WebCore::ApplePayDetailsUpdateBase, newRecurringPaymentRequest)
#endif
#if ENABLE(APPLE_PAY_AUTOMATIC_RELOAD_PAYMENTS)
        , offsetof(WebCore::ApplePayDetailsUpdateBase, newAutomaticReloadPaymentRequest)
#endif
#if ENABLE(APPLE_PAY_MULTI_MERCHANT_PAYMENTS)
        , offsetof(WebCore::ApplePayDetailsUpdateBase, newMultiTokenContexts)
#endif
#if ENABLE(APPLE_PAY_DEFERRED_PAYMENTS)
        , offsetof(WebCore::ApplePayDetailsUpdateBase, newDeferredPaymentRequest)
#endif
#if ENABLE(APPLE_PAY_DISBURSEMENTS)
        , offsetof(WebCore::ApplePayDetailsUpdateBase, newDisbursementRequest)
#endif
    >::value);

    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.errors)>, Vector<Ref<WebCore::ApplePayError>>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.newShippingMethods)>, Vector<WebCore::ApplePayShippingMethod>>);
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::ApplePayShippingContactUpdate, errors)
        , offsetof(WebCore::ApplePayShippingContactUpdate, newShippingMethods)
    >::value);

    encoder << instance.newTotal;
    encoder << instance.newLineItems;
#if ENABLE(APPLE_PAY_RECURRING_PAYMENTS)
    encoder << instance.newRecurringPaymentRequest;
#endif
#if ENABLE(APPLE_PAY_AUTOMATIC_RELOAD_PAYMENTS)
    encoder << instance.newAutomaticReloadPaymentRequest;
#endif
#if ENABLE(APPLE_PAY_MULTI_MERCHANT_PAYMENTS)
    encoder << instance.newMultiTokenContexts;
#endif
#if ENABLE(APPLE_PAY_DEFERRED_PAYMENTS)
    encoder << instance.newDeferredPaymentRequest;
#endif
#if ENABLE(APPLE_PAY_DISBURSEMENTS)
    encoder << instance.newDisbursementRequest;
#endif
    encoder << instance.errors;
    encoder << instance.newShippingMethods;
}

std::optional<WebCore::ApplePayShippingContactUpdate> ArgumentCoder<WebCore::ApplePayShippingContactUpdate>::decode(Decoder& decoder)
{
    auto newTotal = decoder.decode<WebCore::ApplePayLineItem>();
    auto newLineItems = decoder.decode<Vector<WebCore::ApplePayLineItem>>();
#if ENABLE(APPLE_PAY_RECURRING_PAYMENTS)
    auto newRecurringPaymentRequest = decoder.decode<std::optional<WebCore::ApplePayRecurringPaymentRequest>>();
#endif
#if ENABLE(APPLE_PAY_AUTOMATIC_RELOAD_PAYMENTS)
    auto newAutomaticReloadPaymentRequest = decoder.decode<std::optional<WebCore::ApplePayAutomaticReloadPaymentRequest>>();
#endif
#if ENABLE(APPLE_PAY_MULTI_MERCHANT_PAYMENTS)
    auto newMultiTokenContexts = decoder.decode<std::optional<Vector<WebCore::ApplePayPaymentTokenContext>>>();
#endif
#if ENABLE(APPLE_PAY_DEFERRED_PAYMENTS)
    auto newDeferredPaymentRequest = decoder.decode<std::optional<WebCore::ApplePayDeferredPaymentRequest>>();
#endif
#if ENABLE(APPLE_PAY_DISBURSEMENTS)
    auto newDisbursementRequest = decoder.decode<std::optional<WebCore::ApplePayDisbursementRequest>>();
#endif
    auto errors = decoder.decode<Vector<Ref<WebCore::ApplePayError>>>();
    auto newShippingMethods = decoder.decode<Vector<WebCore::ApplePayShippingMethod>>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::ApplePayShippingContactUpdate {
            WebCore::ApplePayDetailsUpdateBase {
                WTFMove(*newTotal),
                WTFMove(*newLineItems),
#if ENABLE(APPLE_PAY_RECURRING_PAYMENTS)
                WTFMove(*newRecurringPaymentRequest),
#endif
#if ENABLE(APPLE_PAY_AUTOMATIC_RELOAD_PAYMENTS)
                WTFMove(*newAutomaticReloadPaymentRequest),
#endif
#if ENABLE(APPLE_PAY_MULTI_MERCHANT_PAYMENTS)
                WTFMove(*newMultiTokenContexts),
#endif
#if ENABLE(APPLE_PAY_DEFERRED_PAYMENTS)
                WTFMove(*newDeferredPaymentRequest),
#endif
#if ENABLE(APPLE_PAY_DISBURSEMENTS)
                WTFMove(*newDisbursementRequest)
#endif
            },
            WTFMove(*errors),
            WTFMove(*newShippingMethods)
        }
    };
}

#endif

#if ENABLE(APPLE_PAY)
void ArgumentCoder<WebCore::ApplePayShippingMethodUpdate>::encode(Encoder& encoder, const WebCore::ApplePayShippingMethodUpdate& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.newTotal)>, WebCore::ApplePayLineItem>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.newLineItems)>, Vector<WebCore::ApplePayLineItem>>);
#if ENABLE(APPLE_PAY_RECURRING_PAYMENTS)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.newRecurringPaymentRequest)>, std::optional<WebCore::ApplePayRecurringPaymentRequest>>);
#endif
#if ENABLE(APPLE_PAY_AUTOMATIC_RELOAD_PAYMENTS)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.newAutomaticReloadPaymentRequest)>, std::optional<WebCore::ApplePayAutomaticReloadPaymentRequest>>);
#endif
#if ENABLE(APPLE_PAY_MULTI_MERCHANT_PAYMENTS)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.newMultiTokenContexts)>, std::optional<Vector<WebCore::ApplePayPaymentTokenContext>>>);
#endif
#if ENABLE(APPLE_PAY_DEFERRED_PAYMENTS)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.newDeferredPaymentRequest)>, std::optional<WebCore::ApplePayDeferredPaymentRequest>>);
#endif
#if ENABLE(APPLE_PAY_DISBURSEMENTS)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.newDisbursementRequest)>, std::optional<WebCore::ApplePayDisbursementRequest>>);
#endif
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::ApplePayDetailsUpdateBase, newTotal)
        , offsetof(WebCore::ApplePayDetailsUpdateBase, newLineItems)
#if ENABLE(APPLE_PAY_RECURRING_PAYMENTS)
        , offsetof(WebCore::ApplePayDetailsUpdateBase, newRecurringPaymentRequest)
#endif
#if ENABLE(APPLE_PAY_AUTOMATIC_RELOAD_PAYMENTS)
        , offsetof(WebCore::ApplePayDetailsUpdateBase, newAutomaticReloadPaymentRequest)
#endif
#if ENABLE(APPLE_PAY_MULTI_MERCHANT_PAYMENTS)
        , offsetof(WebCore::ApplePayDetailsUpdateBase, newMultiTokenContexts)
#endif
#if ENABLE(APPLE_PAY_DEFERRED_PAYMENTS)
        , offsetof(WebCore::ApplePayDetailsUpdateBase, newDeferredPaymentRequest)
#endif
#if ENABLE(APPLE_PAY_DISBURSEMENTS)
        , offsetof(WebCore::ApplePayDetailsUpdateBase, newDisbursementRequest)
#endif
    >::value);

#if ENABLE(APPLE_PAY_UPDATE_SHIPPING_METHODS_WHEN_CHANGING_LINE_ITEMS)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.newShippingMethods)>, Vector<WebCore::ApplePayShippingMethod>>);
#endif
    static_assert(MembersInCorrectOrder < 0
#if ENABLE(APPLE_PAY_UPDATE_SHIPPING_METHODS_WHEN_CHANGING_LINE_ITEMS)
        , offsetof(WebCore::ApplePayShippingMethodUpdate, newShippingMethods)
#endif
    >::value);

    encoder << instance.newTotal;
    encoder << instance.newLineItems;
#if ENABLE(APPLE_PAY_RECURRING_PAYMENTS)
    encoder << instance.newRecurringPaymentRequest;
#endif
#if ENABLE(APPLE_PAY_AUTOMATIC_RELOAD_PAYMENTS)
    encoder << instance.newAutomaticReloadPaymentRequest;
#endif
#if ENABLE(APPLE_PAY_MULTI_MERCHANT_PAYMENTS)
    encoder << instance.newMultiTokenContexts;
#endif
#if ENABLE(APPLE_PAY_DEFERRED_PAYMENTS)
    encoder << instance.newDeferredPaymentRequest;
#endif
#if ENABLE(APPLE_PAY_DISBURSEMENTS)
    encoder << instance.newDisbursementRequest;
#endif
#if ENABLE(APPLE_PAY_UPDATE_SHIPPING_METHODS_WHEN_CHANGING_LINE_ITEMS)
    encoder << instance.newShippingMethods;
#endif
}

std::optional<WebCore::ApplePayShippingMethodUpdate> ArgumentCoder<WebCore::ApplePayShippingMethodUpdate>::decode(Decoder& decoder)
{
    auto newTotal = decoder.decode<WebCore::ApplePayLineItem>();
    auto newLineItems = decoder.decode<Vector<WebCore::ApplePayLineItem>>();
#if ENABLE(APPLE_PAY_RECURRING_PAYMENTS)
    auto newRecurringPaymentRequest = decoder.decode<std::optional<WebCore::ApplePayRecurringPaymentRequest>>();
#endif
#if ENABLE(APPLE_PAY_AUTOMATIC_RELOAD_PAYMENTS)
    auto newAutomaticReloadPaymentRequest = decoder.decode<std::optional<WebCore::ApplePayAutomaticReloadPaymentRequest>>();
#endif
#if ENABLE(APPLE_PAY_MULTI_MERCHANT_PAYMENTS)
    auto newMultiTokenContexts = decoder.decode<std::optional<Vector<WebCore::ApplePayPaymentTokenContext>>>();
#endif
#if ENABLE(APPLE_PAY_DEFERRED_PAYMENTS)
    auto newDeferredPaymentRequest = decoder.decode<std::optional<WebCore::ApplePayDeferredPaymentRequest>>();
#endif
#if ENABLE(APPLE_PAY_DISBURSEMENTS)
    auto newDisbursementRequest = decoder.decode<std::optional<WebCore::ApplePayDisbursementRequest>>();
#endif
#if ENABLE(APPLE_PAY_UPDATE_SHIPPING_METHODS_WHEN_CHANGING_LINE_ITEMS)
    auto newShippingMethods = decoder.decode<Vector<WebCore::ApplePayShippingMethod>>();
#endif
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::ApplePayShippingMethodUpdate {
            WebCore::ApplePayDetailsUpdateBase {
                WTFMove(*newTotal),
                WTFMove(*newLineItems),
#if ENABLE(APPLE_PAY_RECURRING_PAYMENTS)
                WTFMove(*newRecurringPaymentRequest),
#endif
#if ENABLE(APPLE_PAY_AUTOMATIC_RELOAD_PAYMENTS)
                WTFMove(*newAutomaticReloadPaymentRequest),
#endif
#if ENABLE(APPLE_PAY_MULTI_MERCHANT_PAYMENTS)
                WTFMove(*newMultiTokenContexts),
#endif
#if ENABLE(APPLE_PAY_DEFERRED_PAYMENTS)
                WTFMove(*newDeferredPaymentRequest),
#endif
#if ENABLE(APPLE_PAY_DISBURSEMENTS)
                WTFMove(*newDisbursementRequest)
#endif
            },
#if ENABLE(APPLE_PAY_UPDATE_SHIPPING_METHODS_WHEN_CHANGING_LINE_ITEMS)
            WTFMove(*newShippingMethods)
#endif
        }
    };
}

#endif

#if ENABLE(APPLE_PAY)
void ArgumentCoder<WebCore::ApplePayPaymentAuthorizationResult>::encode(Encoder& encoder, const WebCore::ApplePayPaymentAuthorizationResult& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.status)>, unsigned short>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.errors)>, Vector<Ref<WebCore::ApplePayError>>>);
#if ENABLE(APPLE_PAY_PAYMENT_ORDER_DETAILS)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.orderDetails)>, std::optional<WebCore::ApplePayPaymentOrderDetails>>);
#endif
    struct ShouldBeSameSizeAsApplePayPaymentAuthorizationResult : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::ApplePayPaymentAuthorizationResult>, false> {
        unsigned short status;
        Vector<Ref<WebCore::ApplePayError>> errors;
#if ENABLE(APPLE_PAY_PAYMENT_ORDER_DETAILS)
        std::optional<WebCore::ApplePayPaymentOrderDetails> orderDetails;
#endif
    };
    static_assert(sizeof(ShouldBeSameSizeAsApplePayPaymentAuthorizationResult) == sizeof(WebCore::ApplePayPaymentAuthorizationResult));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::ApplePayPaymentAuthorizationResult, status)
        , offsetof(WebCore::ApplePayPaymentAuthorizationResult, errors)
#if ENABLE(APPLE_PAY_PAYMENT_ORDER_DETAILS)
        , offsetof(WebCore::ApplePayPaymentAuthorizationResult, orderDetails)
#endif
    >::value);

    encoder << instance.status;
    encoder << instance.errors;
#if ENABLE(APPLE_PAY_PAYMENT_ORDER_DETAILS)
    encoder << instance.orderDetails;
#endif
}

std::optional<WebCore::ApplePayPaymentAuthorizationResult> ArgumentCoder<WebCore::ApplePayPaymentAuthorizationResult>::decode(Decoder& decoder)
{
    auto status = decoder.decode<unsigned short>();
    auto errors = decoder.decode<Vector<Ref<WebCore::ApplePayError>>>();
#if ENABLE(APPLE_PAY_PAYMENT_ORDER_DETAILS)
    auto orderDetails = decoder.decode<std::optional<WebCore::ApplePayPaymentOrderDetails>>();
#endif
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::ApplePayPaymentAuthorizationResult {
            WTFMove(*status),
            WTFMove(*errors),
#if ENABLE(APPLE_PAY_PAYMENT_ORDER_DETAILS)
            WTFMove(*orderDetails)
#endif
        }
    };
}

#endif

#if ENABLE(APPLE_PAY_DISBURSEMENTS)
void ArgumentCoder<WebCore::ApplePayDisbursementRequest>::encode(Encoder& encoder, const WebCore::ApplePayDisbursementRequest& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.requiredRecipientContactFields)>, std::optional<Vector<WebCore::ApplePayContactField>>>);
    struct ShouldBeSameSizeAsApplePayDisbursementRequest : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::ApplePayDisbursementRequest>, false> {
        std::optional<Vector<WebCore::ApplePayContactField>> requiredRecipientContactFields;
    };
    static_assert(sizeof(ShouldBeSameSizeAsApplePayDisbursementRequest) == sizeof(WebCore::ApplePayDisbursementRequest));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::ApplePayDisbursementRequest, requiredRecipientContactFields)
    >::value);

    encoder << instance.requiredRecipientContactFields;
}

std::optional<WebCore::ApplePayDisbursementRequest> ArgumentCoder<WebCore::ApplePayDisbursementRequest>::decode(Decoder& decoder)
{
    auto requiredRecipientContactFields = decoder.decode<std::optional<Vector<WebCore::ApplePayContactField>>>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::ApplePayDisbursementRequest {
            WTFMove(*requiredRecipientContactFields)
        }
    };
}

#endif

#if ENABLE(APPLE_PAY_INSTALLMENTS)
void ArgumentCoder<WebCore::ApplePayInstallmentConfiguration>::encode(Encoder& encoder, const WebCore::ApplePayInstallmentConfiguration& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.featureType)>, WebCore::ApplePaySetupFeatureType>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.merchandisingImageData)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.openToBuyThresholdAmount)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.bindingTotalAmount)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.currencyCode)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isInStorePurchase)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.merchantIdentifier)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.referrerIdentifier)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.items)>, Vector<WebCore::ApplePayInstallmentItem>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.applicationMetadata)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.retailChannel)>, WebCore::ApplePayInstallmentRetailChannel>);
    struct ShouldBeSameSizeAsApplePayInstallmentConfiguration : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::ApplePayInstallmentConfiguration>, false> {
        WebCore::ApplePaySetupFeatureType featureType;
        String merchandisingImageData;
        String openToBuyThresholdAmount;
        String bindingTotalAmount;
        String currencyCode;
        bool isInStorePurchase;
        String merchantIdentifier;
        String referrerIdentifier;
        Vector<WebCore::ApplePayInstallmentItem> items;
        String applicationMetadata;
        WebCore::ApplePayInstallmentRetailChannel retailChannel;
    };
    static_assert(sizeof(ShouldBeSameSizeAsApplePayInstallmentConfiguration) == sizeof(WebCore::ApplePayInstallmentConfiguration));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::ApplePayInstallmentConfiguration, featureType)
        , offsetof(WebCore::ApplePayInstallmentConfiguration, merchandisingImageData)
        , offsetof(WebCore::ApplePayInstallmentConfiguration, openToBuyThresholdAmount)
        , offsetof(WebCore::ApplePayInstallmentConfiguration, bindingTotalAmount)
        , offsetof(WebCore::ApplePayInstallmentConfiguration, currencyCode)
        , offsetof(WebCore::ApplePayInstallmentConfiguration, isInStorePurchase)
        , offsetof(WebCore::ApplePayInstallmentConfiguration, merchantIdentifier)
        , offsetof(WebCore::ApplePayInstallmentConfiguration, referrerIdentifier)
        , offsetof(WebCore::ApplePayInstallmentConfiguration, items)
        , offsetof(WebCore::ApplePayInstallmentConfiguration, applicationMetadata)
        , offsetof(WebCore::ApplePayInstallmentConfiguration, retailChannel)
    >::value);

    encoder << instance.featureType;
    encoder << instance.merchandisingImageData;
    encoder << instance.openToBuyThresholdAmount;
    encoder << instance.bindingTotalAmount;
    encoder << instance.currencyCode;
    encoder << instance.isInStorePurchase;
    encoder << instance.merchantIdentifier;
    encoder << instance.referrerIdentifier;
    encoder << instance.items;
    encoder << instance.applicationMetadata;
    encoder << instance.retailChannel;
}

std::optional<WebCore::ApplePayInstallmentConfiguration> ArgumentCoder<WebCore::ApplePayInstallmentConfiguration>::decode(Decoder& decoder)
{
    auto featureType = decoder.decode<WebCore::ApplePaySetupFeatureType>();
    auto merchandisingImageData = decoder.decode<String>();
    auto openToBuyThresholdAmount = decoder.decode<String>();
    auto bindingTotalAmount = decoder.decode<String>();
    auto currencyCode = decoder.decode<String>();
    auto isInStorePurchase = decoder.decode<bool>();
    auto merchantIdentifier = decoder.decode<String>();
    auto referrerIdentifier = decoder.decode<String>();
    auto items = decoder.decode<Vector<WebCore::ApplePayInstallmentItem>>();
    auto applicationMetadata = decoder.decode<String>();
    auto retailChannel = decoder.decode<WebCore::ApplePayInstallmentRetailChannel>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::ApplePayInstallmentConfiguration {
            WTFMove(*featureType),
            WTFMove(*merchandisingImageData),
            WTFMove(*openToBuyThresholdAmount),
            WTFMove(*bindingTotalAmount),
            WTFMove(*currencyCode),
            WTFMove(*isInStorePurchase),
            WTFMove(*merchantIdentifier),
            WTFMove(*referrerIdentifier),
            WTFMove(*items),
            WTFMove(*applicationMetadata),
            WTFMove(*retailChannel)
        }
    };
}

#endif

#if ENABLE(APPLE_PAY_INSTALLMENTS)
void ArgumentCoder<WebCore::PaymentInstallmentConfiguration>::encode(Encoder& encoder, const WebCore::PaymentInstallmentConfiguration& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.applePayInstallmentConfiguration())>, std::optional<WebCore::ApplePayInstallmentConfiguration>>);

    encoder << instance.applePayInstallmentConfiguration();
}

std::optional<WebCore::PaymentInstallmentConfiguration> ArgumentCoder<WebCore::PaymentInstallmentConfiguration>::decode(Decoder& decoder)
{
    auto applePayInstallmentConfiguration = decoder.decode<std::optional<WebCore::ApplePayInstallmentConfiguration>>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::PaymentInstallmentConfiguration {
            WTFMove(*applePayInstallmentConfiguration)
        }
    };
}

#endif

#if ENABLE(APPLE_PAY_INSTALLMENTS)
void ArgumentCoder<WebCore::ApplePayInstallmentItem>::encode(Encoder& encoder, const WebCore::ApplePayInstallmentItem& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.type)>, WebCore::ApplePayInstallmentItemType>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.amount)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.currencyCode)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.programIdentifier)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.apr)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.programTerms)>, String>);
    struct ShouldBeSameSizeAsApplePayInstallmentItem : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::ApplePayInstallmentItem>, false> {
        WebCore::ApplePayInstallmentItemType type;
        String amount;
        String currencyCode;
        String programIdentifier;
        String apr;
        String programTerms;
    };
    static_assert(sizeof(ShouldBeSameSizeAsApplePayInstallmentItem) == sizeof(WebCore::ApplePayInstallmentItem));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::ApplePayInstallmentItem, type)
        , offsetof(WebCore::ApplePayInstallmentItem, amount)
        , offsetof(WebCore::ApplePayInstallmentItem, currencyCode)
        , offsetof(WebCore::ApplePayInstallmentItem, programIdentifier)
        , offsetof(WebCore::ApplePayInstallmentItem, apr)
        , offsetof(WebCore::ApplePayInstallmentItem, programTerms)
    >::value);

    encoder << instance.type;
    encoder << instance.amount;
    encoder << instance.currencyCode;
    encoder << instance.programIdentifier;
    encoder << instance.apr;
    encoder << instance.programTerms;
}

std::optional<WebCore::ApplePayInstallmentItem> ArgumentCoder<WebCore::ApplePayInstallmentItem>::decode(Decoder& decoder)
{
    auto type = decoder.decode<WebCore::ApplePayInstallmentItemType>();
    auto amount = decoder.decode<String>();
    auto currencyCode = decoder.decode<String>();
    auto programIdentifier = decoder.decode<String>();
    auto apr = decoder.decode<String>();
    auto programTerms = decoder.decode<String>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::ApplePayInstallmentItem {
            WTFMove(*type),
            WTFMove(*amount),
            WTFMove(*currencyCode),
            WTFMove(*programIdentifier),
            WTFMove(*apr),
            WTFMove(*programTerms)
        }
    };
}

#endif

#if ENABLE(APPLE_PAY_COUPON_CODE)
void ArgumentCoder<WebCore::ApplePayCouponCodeUpdate>::encode(Encoder& encoder, const WebCore::ApplePayCouponCodeUpdate& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.newTotal)>, WebCore::ApplePayLineItem>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.newLineItems)>, Vector<WebCore::ApplePayLineItem>>);
#if ENABLE(APPLE_PAY_RECURRING_PAYMENTS)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.newRecurringPaymentRequest)>, std::optional<WebCore::ApplePayRecurringPaymentRequest>>);
#endif
#if ENABLE(APPLE_PAY_AUTOMATIC_RELOAD_PAYMENTS)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.newAutomaticReloadPaymentRequest)>, std::optional<WebCore::ApplePayAutomaticReloadPaymentRequest>>);
#endif
#if ENABLE(APPLE_PAY_MULTI_MERCHANT_PAYMENTS)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.newMultiTokenContexts)>, std::optional<Vector<WebCore::ApplePayPaymentTokenContext>>>);
#endif
#if ENABLE(APPLE_PAY_DEFERRED_PAYMENTS)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.newDeferredPaymentRequest)>, std::optional<WebCore::ApplePayDeferredPaymentRequest>>);
#endif
#if ENABLE(APPLE_PAY_DISBURSEMENTS)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.newDisbursementRequest)>, std::optional<WebCore::ApplePayDisbursementRequest>>);
#endif
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::ApplePayDetailsUpdateBase, newTotal)
        , offsetof(WebCore::ApplePayDetailsUpdateBase, newLineItems)
#if ENABLE(APPLE_PAY_RECURRING_PAYMENTS)
        , offsetof(WebCore::ApplePayDetailsUpdateBase, newRecurringPaymentRequest)
#endif
#if ENABLE(APPLE_PAY_AUTOMATIC_RELOAD_PAYMENTS)
        , offsetof(WebCore::ApplePayDetailsUpdateBase, newAutomaticReloadPaymentRequest)
#endif
#if ENABLE(APPLE_PAY_MULTI_MERCHANT_PAYMENTS)
        , offsetof(WebCore::ApplePayDetailsUpdateBase, newMultiTokenContexts)
#endif
#if ENABLE(APPLE_PAY_DEFERRED_PAYMENTS)
        , offsetof(WebCore::ApplePayDetailsUpdateBase, newDeferredPaymentRequest)
#endif
#if ENABLE(APPLE_PAY_DISBURSEMENTS)
        , offsetof(WebCore::ApplePayDetailsUpdateBase, newDisbursementRequest)
#endif
    >::value);

    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.errors)>, Vector<Ref<WebCore::ApplePayError>>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.newShippingMethods)>, Vector<WebCore::ApplePayShippingMethod>>);
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::ApplePayCouponCodeUpdate, errors)
        , offsetof(WebCore::ApplePayCouponCodeUpdate, newShippingMethods)
    >::value);

    encoder << instance.newTotal;
    encoder << instance.newLineItems;
#if ENABLE(APPLE_PAY_RECURRING_PAYMENTS)
    encoder << instance.newRecurringPaymentRequest;
#endif
#if ENABLE(APPLE_PAY_AUTOMATIC_RELOAD_PAYMENTS)
    encoder << instance.newAutomaticReloadPaymentRequest;
#endif
#if ENABLE(APPLE_PAY_MULTI_MERCHANT_PAYMENTS)
    encoder << instance.newMultiTokenContexts;
#endif
#if ENABLE(APPLE_PAY_DEFERRED_PAYMENTS)
    encoder << instance.newDeferredPaymentRequest;
#endif
#if ENABLE(APPLE_PAY_DISBURSEMENTS)
    encoder << instance.newDisbursementRequest;
#endif
    encoder << instance.errors;
    encoder << instance.newShippingMethods;
}

std::optional<WebCore::ApplePayCouponCodeUpdate> ArgumentCoder<WebCore::ApplePayCouponCodeUpdate>::decode(Decoder& decoder)
{
    auto newTotal = decoder.decode<WebCore::ApplePayLineItem>();
    auto newLineItems = decoder.decode<Vector<WebCore::ApplePayLineItem>>();
#if ENABLE(APPLE_PAY_RECURRING_PAYMENTS)
    auto newRecurringPaymentRequest = decoder.decode<std::optional<WebCore::ApplePayRecurringPaymentRequest>>();
#endif
#if ENABLE(APPLE_PAY_AUTOMATIC_RELOAD_PAYMENTS)
    auto newAutomaticReloadPaymentRequest = decoder.decode<std::optional<WebCore::ApplePayAutomaticReloadPaymentRequest>>();
#endif
#if ENABLE(APPLE_PAY_MULTI_MERCHANT_PAYMENTS)
    auto newMultiTokenContexts = decoder.decode<std::optional<Vector<WebCore::ApplePayPaymentTokenContext>>>();
#endif
#if ENABLE(APPLE_PAY_DEFERRED_PAYMENTS)
    auto newDeferredPaymentRequest = decoder.decode<std::optional<WebCore::ApplePayDeferredPaymentRequest>>();
#endif
#if ENABLE(APPLE_PAY_DISBURSEMENTS)
    auto newDisbursementRequest = decoder.decode<std::optional<WebCore::ApplePayDisbursementRequest>>();
#endif
    auto errors = decoder.decode<Vector<Ref<WebCore::ApplePayError>>>();
    auto newShippingMethods = decoder.decode<Vector<WebCore::ApplePayShippingMethod>>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::ApplePayCouponCodeUpdate {
            WebCore::ApplePayDetailsUpdateBase {
                WTFMove(*newTotal),
                WTFMove(*newLineItems),
#if ENABLE(APPLE_PAY_RECURRING_PAYMENTS)
                WTFMove(*newRecurringPaymentRequest),
#endif
#if ENABLE(APPLE_PAY_AUTOMATIC_RELOAD_PAYMENTS)
                WTFMove(*newAutomaticReloadPaymentRequest),
#endif
#if ENABLE(APPLE_PAY_MULTI_MERCHANT_PAYMENTS)
                WTFMove(*newMultiTokenContexts),
#endif
#if ENABLE(APPLE_PAY_DEFERRED_PAYMENTS)
                WTFMove(*newDeferredPaymentRequest),
#endif
#if ENABLE(APPLE_PAY_DISBURSEMENTS)
                WTFMove(*newDisbursementRequest)
#endif
            },
            WTFMove(*errors),
            WTFMove(*newShippingMethods)
        }
    };
}

#endif

#if ENABLE(APPLICATION_MANIFEST)
void ArgumentCoder<WebCore::ApplicationManifest::Icon>::encode(Encoder& encoder, const WebCore::ApplicationManifest::Icon& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.src)>, URL>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.sizes)>, Vector<String>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.type)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.purposes)>, OptionSet<WebCore::ApplicationManifest::Icon::Purpose>>);
    struct ShouldBeSameSizeAsIcon : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::ApplicationManifest::Icon>, false> {
        URL src;
        Vector<String> sizes;
        String type;
        OptionSet<WebCore::ApplicationManifest::Icon::Purpose> purposes;
    };
    static_assert(sizeof(ShouldBeSameSizeAsIcon) == sizeof(WebCore::ApplicationManifest::Icon));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::ApplicationManifest::Icon, src)
        , offsetof(WebCore::ApplicationManifest::Icon, sizes)
        , offsetof(WebCore::ApplicationManifest::Icon, type)
        , offsetof(WebCore::ApplicationManifest::Icon, purposes)
    >::value);

    encoder << instance.src;
    encoder << instance.sizes;
    encoder << instance.type;
    encoder << instance.purposes;
}

std::optional<WebCore::ApplicationManifest::Icon> ArgumentCoder<WebCore::ApplicationManifest::Icon>::decode(Decoder& decoder)
{
    auto src = decoder.decode<URL>();
    auto sizes = decoder.decode<Vector<String>>();
    auto type = decoder.decode<String>();
    auto purposes = decoder.decode<OptionSet<WebCore::ApplicationManifest::Icon::Purpose>>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::ApplicationManifest::Icon {
            WTFMove(*src),
            WTFMove(*sizes),
            WTFMove(*type),
            WTFMove(*purposes)
        }
    };
}

#endif

#if ENABLE(APPLICATION_MANIFEST)
void ArgumentCoder<WebCore::ApplicationManifest::Shortcut>::encode(Encoder& encoder, const WebCore::ApplicationManifest::Shortcut& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.name)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.url)>, URL>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.icons)>, Vector<WebCore::ApplicationManifest::Icon>>);
    struct ShouldBeSameSizeAsShortcut : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::ApplicationManifest::Shortcut>, false> {
        String name;
        URL url;
        Vector<WebCore::ApplicationManifest::Icon> icons;
    };
    static_assert(sizeof(ShouldBeSameSizeAsShortcut) == sizeof(WebCore::ApplicationManifest::Shortcut));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::ApplicationManifest::Shortcut, name)
        , offsetof(WebCore::ApplicationManifest::Shortcut, url)
        , offsetof(WebCore::ApplicationManifest::Shortcut, icons)
    >::value);

    encoder << instance.name;
    encoder << instance.url;
    encoder << instance.icons;
}

std::optional<WebCore::ApplicationManifest::Shortcut> ArgumentCoder<WebCore::ApplicationManifest::Shortcut>::decode(Decoder& decoder)
{
    auto name = decoder.decode<String>();
    auto url = decoder.decode<URL>();
    auto icons = decoder.decode<Vector<WebCore::ApplicationManifest::Icon>>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::ApplicationManifest::Shortcut {
            WTFMove(*name),
            WTFMove(*url),
            WTFMove(*icons)
        }
    };
}

#endif

#if ENABLE(APPLICATION_MANIFEST)
void ArgumentCoder<WebCore::ApplicationManifest>::encode(Encoder& encoder, const WebCore::ApplicationManifest& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.rawJSON)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.dir)>, WebCore::ApplicationManifest::Direction>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.name)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.shortName)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.description)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.scope)>, URL>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isDefaultScope)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.display)>, WebCore::ApplicationManifest::Display>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.orientation)>, std::optional<WebCore::ScreenOrientationLockType>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.manifestURL)>, URL>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.startURL)>, URL>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.id)>, URL>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.backgroundColor)>, WebCore::Color>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.themeColor)>, WebCore::Color>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.categories)>, Vector<String>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.icons)>, Vector<WebCore::ApplicationManifest::Icon>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.shortcuts)>, Vector<WebCore::ApplicationManifest::Shortcut>>);
    struct ShouldBeSameSizeAsApplicationManifest : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::ApplicationManifest>, false> {
        String rawJSON;
        WebCore::ApplicationManifest::Direction dir;
        String name;
        String shortName;
        String description;
        URL scope;
        bool isDefaultScope;
        WebCore::ApplicationManifest::Display display;
        std::optional<WebCore::ScreenOrientationLockType> orientation;
        URL manifestURL;
        URL startURL;
        URL id;
        WebCore::Color backgroundColor;
        WebCore::Color themeColor;
        Vector<String> categories;
        Vector<WebCore::ApplicationManifest::Icon> icons;
        Vector<WebCore::ApplicationManifest::Shortcut> shortcuts;
    };
    static_assert(sizeof(ShouldBeSameSizeAsApplicationManifest) == sizeof(WebCore::ApplicationManifest));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::ApplicationManifest, rawJSON)
        , offsetof(WebCore::ApplicationManifest, dir)
        , offsetof(WebCore::ApplicationManifest, name)
        , offsetof(WebCore::ApplicationManifest, shortName)
        , offsetof(WebCore::ApplicationManifest, description)
        , offsetof(WebCore::ApplicationManifest, scope)
        , offsetof(WebCore::ApplicationManifest, isDefaultScope)
        , offsetof(WebCore::ApplicationManifest, display)
        , offsetof(WebCore::ApplicationManifest, orientation)
        , offsetof(WebCore::ApplicationManifest, manifestURL)
        , offsetof(WebCore::ApplicationManifest, startURL)
        , offsetof(WebCore::ApplicationManifest, id)
        , offsetof(WebCore::ApplicationManifest, backgroundColor)
        , offsetof(WebCore::ApplicationManifest, themeColor)
        , offsetof(WebCore::ApplicationManifest, categories)
        , offsetof(WebCore::ApplicationManifest, icons)
        , offsetof(WebCore::ApplicationManifest, shortcuts)
    >::value);

    encoder << instance.rawJSON;
    encoder << instance.dir;
    encoder << instance.name;
    encoder << instance.shortName;
    encoder << instance.description;
    encoder << instance.scope;
    encoder << instance.isDefaultScope;
    encoder << instance.display;
    encoder << instance.orientation;
    encoder << instance.manifestURL;
    encoder << instance.startURL;
    encoder << instance.id;
    encoder << instance.backgroundColor;
    encoder << instance.themeColor;
    encoder << instance.categories;
    encoder << instance.icons;
    encoder << instance.shortcuts;
}

std::optional<WebCore::ApplicationManifest> ArgumentCoder<WebCore::ApplicationManifest>::decode(Decoder& decoder)
{
    auto rawJSON = decoder.decode<String>();
    auto dir = decoder.decode<WebCore::ApplicationManifest::Direction>();
    auto name = decoder.decode<String>();
    auto shortName = decoder.decode<String>();
    auto description = decoder.decode<String>();
    auto scope = decoder.decode<URL>();
    auto isDefaultScope = decoder.decode<bool>();
    auto display = decoder.decode<WebCore::ApplicationManifest::Display>();
    auto orientation = decoder.decode<std::optional<WebCore::ScreenOrientationLockType>>();
    auto manifestURL = decoder.decode<URL>();
    auto startURL = decoder.decode<URL>();
    auto id = decoder.decode<URL>();
    auto backgroundColor = decoder.decode<WebCore::Color>();
    auto themeColor = decoder.decode<WebCore::Color>();
    auto categories = decoder.decode<Vector<String>>();
    auto icons = decoder.decode<Vector<WebCore::ApplicationManifest::Icon>>();
    auto shortcuts = decoder.decode<Vector<WebCore::ApplicationManifest::Shortcut>>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::ApplicationManifest {
            WTFMove(*rawJSON),
            WTFMove(*dir),
            WTFMove(*name),
            WTFMove(*shortName),
            WTFMove(*description),
            WTFMove(*scope),
            WTFMove(*isDefaultScope),
            WTFMove(*display),
            WTFMove(*orientation),
            WTFMove(*manifestURL),
            WTFMove(*startURL),
            WTFMove(*id),
            WTFMove(*backgroundColor),
            WTFMove(*themeColor),
            WTFMove(*categories),
            WTFMove(*icons),
            WTFMove(*shortcuts)
        }
    };
}

#endif

void ArgumentCoder<WebCore::RetrieveRecordsOptions>::encode(Encoder& encoder, const WebCore::RetrieveRecordsOptions& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.request)>, WebCore::ResourceRequest>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.crossOriginEmbedderPolicy)>, WebCore::CrossOriginEmbedderPolicy>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.sourceOrigin)>, Ref<WebCore::SecurityOrigin>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.ignoreSearch)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.ignoreMethod)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.ignoreVary)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.shouldProvideResponse)>, bool>);
    struct ShouldBeSameSizeAsRetrieveRecordsOptions : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::RetrieveRecordsOptions>, false> {
        WebCore::ResourceRequest request;
        WebCore::CrossOriginEmbedderPolicy crossOriginEmbedderPolicy;
        Ref<WebCore::SecurityOrigin> sourceOrigin;
        bool ignoreSearch;
        bool ignoreMethod;
        bool ignoreVary;
        bool shouldProvideResponse;
    };
    static_assert(sizeof(ShouldBeSameSizeAsRetrieveRecordsOptions) == sizeof(WebCore::RetrieveRecordsOptions));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::RetrieveRecordsOptions, request)
        , offsetof(WebCore::RetrieveRecordsOptions, crossOriginEmbedderPolicy)
        , offsetof(WebCore::RetrieveRecordsOptions, sourceOrigin)
        , offsetof(WebCore::RetrieveRecordsOptions, ignoreSearch)
        , offsetof(WebCore::RetrieveRecordsOptions, ignoreMethod)
        , offsetof(WebCore::RetrieveRecordsOptions, ignoreVary)
        , offsetof(WebCore::RetrieveRecordsOptions, shouldProvideResponse)
    >::value);

    encoder << instance.request;
    encoder << instance.crossOriginEmbedderPolicy;
    encoder << instance.sourceOrigin;
    encoder << instance.ignoreSearch;
    encoder << instance.ignoreMethod;
    encoder << instance.ignoreVary;
    encoder << instance.shouldProvideResponse;
}

std::optional<WebCore::RetrieveRecordsOptions> ArgumentCoder<WebCore::RetrieveRecordsOptions>::decode(Decoder& decoder)
{
    auto request = decoder.decode<WebCore::ResourceRequest>();
    auto crossOriginEmbedderPolicy = decoder.decode<WebCore::CrossOriginEmbedderPolicy>();
    auto sourceOrigin = decoder.decode<Ref<WebCore::SecurityOrigin>>();
    auto ignoreSearch = decoder.decode<bool>();
    auto ignoreMethod = decoder.decode<bool>();
    auto ignoreVary = decoder.decode<bool>();
    auto shouldProvideResponse = decoder.decode<bool>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::RetrieveRecordsOptions {
            WTFMove(*request),
            WTFMove(*crossOriginEmbedderPolicy),
            WTFMove(*sourceOrigin),
            WTFMove(*ignoreSearch),
            WTFMove(*ignoreMethod),
            WTFMove(*ignoreVary),
            WTFMove(*shouldProvideResponse)
        }
    };
}

void ArgumentCoder<WebCore::ContactInfo>::encode(Encoder& encoder, const WebCore::ContactInfo& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.name)>, Vector<String>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.email)>, Vector<String>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.tel)>, Vector<String>>);
    struct ShouldBeSameSizeAsContactInfo : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::ContactInfo>, false> {
        Vector<String> name;
        Vector<String> email;
        Vector<String> tel;
    };
    static_assert(sizeof(ShouldBeSameSizeAsContactInfo) == sizeof(WebCore::ContactInfo));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::ContactInfo, name)
        , offsetof(WebCore::ContactInfo, email)
        , offsetof(WebCore::ContactInfo, tel)
    >::value);

    encoder << instance.name;
    encoder << instance.email;
    encoder << instance.tel;
}

std::optional<WebCore::ContactInfo> ArgumentCoder<WebCore::ContactInfo>::decode(Decoder& decoder)
{
    auto name = decoder.decode<Vector<String>>();
    auto email = decoder.decode<Vector<String>>();
    auto tel = decoder.decode<Vector<String>>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::ContactInfo {
            WTFMove(*name),
            WTFMove(*email),
            WTFMove(*tel)
        }
    };
}

void ArgumentCoder<WebCore::ContactsRequestData>::encode(Encoder& encoder, const WebCore::ContactsRequestData& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.properties)>, Vector<WebCore::ContactProperty>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.multiple)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.url)>, String>);
    struct ShouldBeSameSizeAsContactsRequestData : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::ContactsRequestData>, false> {
        Vector<WebCore::ContactProperty> properties;
        bool multiple;
        String url;
    };
    static_assert(sizeof(ShouldBeSameSizeAsContactsRequestData) == sizeof(WebCore::ContactsRequestData));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::ContactsRequestData, properties)
        , offsetof(WebCore::ContactsRequestData, multiple)
        , offsetof(WebCore::ContactsRequestData, url)
    >::value);

    encoder << instance.properties;
    encoder << instance.multiple;
    encoder << instance.url;
}

std::optional<WebCore::ContactsRequestData> ArgumentCoder<WebCore::ContactsRequestData>::decode(Decoder& decoder)
{
    auto properties = decoder.decode<Vector<WebCore::ContactProperty>>();
    auto multiple = decoder.decode<bool>();
    auto url = decoder.decode<String>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::ContactsRequestData {
            WTFMove(*properties),
            WTFMove(*multiple),
            WTFMove(*url)
        }
    };
}

#if ENABLE(MEDIA_SESSION)
void ArgumentCoder<WebCore::MediaPositionState>::encode(Encoder& encoder, const WebCore::MediaPositionState& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.duration)>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.playbackRate)>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.position)>, double>);
    struct ShouldBeSameSizeAsMediaPositionState : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::MediaPositionState>, false> {
        double duration;
        double playbackRate;
        double position;
    };
    static_assert(sizeof(ShouldBeSameSizeAsMediaPositionState) == sizeof(WebCore::MediaPositionState));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::MediaPositionState, duration)
        , offsetof(WebCore::MediaPositionState, playbackRate)
        , offsetof(WebCore::MediaPositionState, position)
    >::value);

    encoder << instance.duration;
    encoder << instance.playbackRate;
    encoder << instance.position;
}

std::optional<WebCore::MediaPositionState> ArgumentCoder<WebCore::MediaPositionState>::decode(Decoder& decoder)
{
    auto duration = decoder.decode<double>();
    auto playbackRate = decoder.decode<double>();
    auto position = decoder.decode<double>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::MediaPositionState {
            WTFMove(*duration),
            WTFMove(*playbackRate),
            WTFMove(*position)
        }
    };
}

#endif

#if ENABLE(WEB_RTC)
void ArgumentCoder<WebCore::DetachedRTCDataChannel>::encode(Encoder& encoder, const WebCore::DetachedRTCDataChannel& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.identifier)>, WebCore::RTCDataChannelIdentifier>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.label)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.options)>, WebCore::RTCDataChannelInit>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.state)>, WebCore::RTCDataChannelState>);
    struct ShouldBeSameSizeAsDetachedRTCDataChannel : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::DetachedRTCDataChannel>, false> {
        WebCore::RTCDataChannelIdentifier identifier;
        String label;
        WebCore::RTCDataChannelInit options;
        WebCore::RTCDataChannelState state;
    };
    static_assert(sizeof(ShouldBeSameSizeAsDetachedRTCDataChannel) == sizeof(WebCore::DetachedRTCDataChannel));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::DetachedRTCDataChannel, identifier)
        , offsetof(WebCore::DetachedRTCDataChannel, label)
        , offsetof(WebCore::DetachedRTCDataChannel, options)
        , offsetof(WebCore::DetachedRTCDataChannel, state)
    >::value);

    encoder << instance.identifier;
    encoder << instance.label;
    encoder << instance.options;
    encoder << instance.state;
}

std::optional<WebCore::DetachedRTCDataChannel> ArgumentCoder<WebCore::DetachedRTCDataChannel>::decode(Decoder& decoder)
{
    auto identifier = decoder.decode<WebCore::RTCDataChannelIdentifier>();
    auto label = decoder.decode<String>();
    auto options = decoder.decode<WebCore::RTCDataChannelInit>();
    auto state = decoder.decode<WebCore::RTCDataChannelState>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::DetachedRTCDataChannel {
            WTFMove(*identifier),
            WTFMove(*label),
            WTFMove(*options),
            WTFMove(*state)
        }
    };
}

#endif

#if ENABLE(WEB_CODECS)
void ArgumentCoder<WebCore::WebCodecsEncodedVideoChunkData>::encode(Encoder& encoder, const WebCore::WebCodecsEncodedVideoChunkData& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.type)>, WebCore::WebCodecsEncodedVideoChunkType>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.timestamp)>, int64_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.duration)>, std::optional<uint64_t>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.buffer)>, Vector<uint8_t>>);
    struct ShouldBeSameSizeAsWebCodecsEncodedVideoChunkData : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::WebCodecsEncodedVideoChunkData>, false> {
        WebCore::WebCodecsEncodedVideoChunkType type;
        int64_t timestamp;
        std::optional<uint64_t> duration;
        Vector<uint8_t> buffer;
    };
    static_assert(sizeof(ShouldBeSameSizeAsWebCodecsEncodedVideoChunkData) == sizeof(WebCore::WebCodecsEncodedVideoChunkData));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::WebCodecsEncodedVideoChunkData, type)
        , offsetof(WebCore::WebCodecsEncodedVideoChunkData, timestamp)
        , offsetof(WebCore::WebCodecsEncodedVideoChunkData, duration)
        , offsetof(WebCore::WebCodecsEncodedVideoChunkData, buffer)
    >::value);

    encoder << instance.type;
    encoder << instance.timestamp;
    encoder << instance.duration;
    encoder << instance.buffer;
}

std::optional<WebCore::WebCodecsEncodedVideoChunkData> ArgumentCoder<WebCore::WebCodecsEncodedVideoChunkData>::decode(Decoder& decoder)
{
    auto type = decoder.decode<WebCore::WebCodecsEncodedVideoChunkType>();
    auto timestamp = decoder.decode<int64_t>();
    auto duration = decoder.decode<std::optional<uint64_t>>();
    auto buffer = decoder.decode<Vector<uint8_t>>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::WebCodecsEncodedVideoChunkData {
            WTFMove(*type),
            WTFMove(*timestamp),
            WTFMove(*duration),
            WTFMove(*buffer)
        }
    };
}

#endif

#if ENABLE(WEB_CODECS)
void ArgumentCoder<WebCore::WebCodecsEncodedAudioChunkData>::encode(Encoder& encoder, const WebCore::WebCodecsEncodedAudioChunkData& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.type)>, WebCore::WebCodecsEncodedAudioChunkType>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.timestamp)>, int64_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.duration)>, std::optional<uint64_t>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.buffer)>, Vector<uint8_t>>);
    struct ShouldBeSameSizeAsWebCodecsEncodedAudioChunkData : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::WebCodecsEncodedAudioChunkData>, false> {
        WebCore::WebCodecsEncodedAudioChunkType type;
        int64_t timestamp;
        std::optional<uint64_t> duration;
        Vector<uint8_t> buffer;
    };
    static_assert(sizeof(ShouldBeSameSizeAsWebCodecsEncodedAudioChunkData) == sizeof(WebCore::WebCodecsEncodedAudioChunkData));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::WebCodecsEncodedAudioChunkData, type)
        , offsetof(WebCore::WebCodecsEncodedAudioChunkData, timestamp)
        , offsetof(WebCore::WebCodecsEncodedAudioChunkData, duration)
        , offsetof(WebCore::WebCodecsEncodedAudioChunkData, buffer)
    >::value);

    encoder << instance.type;
    encoder << instance.timestamp;
    encoder << instance.duration;
    encoder << instance.buffer;
}

std::optional<WebCore::WebCodecsEncodedAudioChunkData> ArgumentCoder<WebCore::WebCodecsEncodedAudioChunkData>::decode(Decoder& decoder)
{
    auto type = decoder.decode<WebCore::WebCodecsEncodedAudioChunkType>();
    auto timestamp = decoder.decode<int64_t>();
    auto duration = decoder.decode<std::optional<uint64_t>>();
    auto buffer = decoder.decode<Vector<uint8_t>>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::WebCodecsEncodedAudioChunkData {
            WTFMove(*type),
            WTFMove(*timestamp),
            WTFMove(*duration),
            WTFMove(*buffer)
        }
    };
}

#endif

void ArgumentCoder<WebCore::HTMLModelElementCamera>::encode(Encoder& encoder, const WebCore::HTMLModelElementCamera& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.pitch)>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.yaw)>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.scale)>, double>);
    struct ShouldBeSameSizeAsHTMLModelElementCamera : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::HTMLModelElementCamera>, false> {
        double pitch;
        double yaw;
        double scale;
    };
    static_assert(sizeof(ShouldBeSameSizeAsHTMLModelElementCamera) == sizeof(WebCore::HTMLModelElementCamera));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::HTMLModelElementCamera, pitch)
        , offsetof(WebCore::HTMLModelElementCamera, yaw)
        , offsetof(WebCore::HTMLModelElementCamera, scale)
    >::value);

    encoder << instance.pitch;
    encoder << instance.yaw;
    encoder << instance.scale;
}

std::optional<WebCore::HTMLModelElementCamera> ArgumentCoder<WebCore::HTMLModelElementCamera>::decode(Decoder& decoder)
{
    auto pitch = decoder.decode<double>();
    auto yaw = decoder.decode<double>();
    auto scale = decoder.decode<double>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::HTMLModelElementCamera {
            WTFMove(*pitch),
            WTFMove(*yaw),
            WTFMove(*scale)
        }
    };
}

void ArgumentCoder<WebCore::NotificationData>::encode(Encoder& encoder, const WebCore::NotificationData& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.navigateURL)>, URL>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.title)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.body)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.iconURL)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.tag)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.language)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.direction)>, WebCore::NotificationDirection>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.originString)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.serviceWorkerRegistrationURL)>, URL>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.notificationID)>, WTF::UUID>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.contextIdentifier)>, std::optional<WebCore::ScriptExecutionContextIdentifier>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.sourceSession)>, PAL::SessionID>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.creationTime)>, MonotonicTime>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.data)>, Vector<uint8_t>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.silent)>, std::optional<bool>>);
    struct ShouldBeSameSizeAsNotificationData : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::NotificationData>, false> {
        URL navigateURL;
        String title;
        String body;
        String iconURL;
        String tag;
        String language;
        WebCore::NotificationDirection direction;
        String originString;
        URL serviceWorkerRegistrationURL;
        WTF::UUID notificationID;
        std::optional<WebCore::ScriptExecutionContextIdentifier> contextIdentifier;
        PAL::SessionID sourceSession;
        MonotonicTime creationTime;
        Vector<uint8_t> data;
        std::optional<bool> silent;
    };
    static_assert(sizeof(ShouldBeSameSizeAsNotificationData) == sizeof(WebCore::NotificationData));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::NotificationData, navigateURL)
        , offsetof(WebCore::NotificationData, title)
        , offsetof(WebCore::NotificationData, body)
        , offsetof(WebCore::NotificationData, iconURL)
        , offsetof(WebCore::NotificationData, tag)
        , offsetof(WebCore::NotificationData, language)
        , offsetof(WebCore::NotificationData, direction)
        , offsetof(WebCore::NotificationData, originString)
        , offsetof(WebCore::NotificationData, serviceWorkerRegistrationURL)
        , offsetof(WebCore::NotificationData, notificationID)
        , offsetof(WebCore::NotificationData, contextIdentifier)
        , offsetof(WebCore::NotificationData, sourceSession)
        , offsetof(WebCore::NotificationData, creationTime)
        , offsetof(WebCore::NotificationData, data)
        , offsetof(WebCore::NotificationData, silent)
    >::value);

    encoder << instance.navigateURL;
    encoder << instance.title;
    encoder << instance.body;
    encoder << instance.iconURL;
    encoder << instance.tag;
    encoder << instance.language;
    encoder << instance.direction;
    encoder << instance.originString;
    encoder << instance.serviceWorkerRegistrationURL;
    encoder << instance.notificationID;
    encoder << instance.contextIdentifier;
    encoder << instance.sourceSession;
    encoder << instance.creationTime;
    encoder << instance.data;
    encoder << instance.silent;
}

std::optional<WebCore::NotificationData> ArgumentCoder<WebCore::NotificationData>::decode(Decoder& decoder)
{
    auto navigateURL = decoder.decode<URL>();
    auto title = decoder.decode<String>();
    auto body = decoder.decode<String>();
    auto iconURL = decoder.decode<String>();
    auto tag = decoder.decode<String>();
    auto language = decoder.decode<String>();
    auto direction = decoder.decode<WebCore::NotificationDirection>();
    auto originString = decoder.decode<String>();
    auto serviceWorkerRegistrationURL = decoder.decode<URL>();
    auto notificationID = decoder.decode<WTF::UUID>();
    auto contextIdentifier = decoder.decode<std::optional<WebCore::ScriptExecutionContextIdentifier>>();
    auto sourceSession = decoder.decode<PAL::SessionID>();
    auto creationTime = decoder.decode<MonotonicTime>();
    auto data = decoder.decode<Vector<uint8_t>>();
    auto silent = decoder.decode<std::optional<bool>>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::NotificationData {
            WTFMove(*navigateURL),
            WTFMove(*title),
            WTFMove(*body),
            WTFMove(*iconURL),
            WTFMove(*tag),
            WTFMove(*language),
            WTFMove(*direction),
            WTFMove(*originString),
            WTFMove(*serviceWorkerRegistrationURL),
            WTFMove(*notificationID),
            WTFMove(*contextIdentifier),
            WTFMove(*sourceSession),
            WTFMove(*creationTime),
            WTFMove(*data),
            WTFMove(*silent)
        }
    };
}

void ArgumentCoder<WebCore::PermissionDescriptor>::encode(Encoder& encoder, const WebCore::PermissionDescriptor& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.name)>, WebCore::PermissionName>);
    struct ShouldBeSameSizeAsPermissionDescriptor : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::PermissionDescriptor>, false> {
        WebCore::PermissionName name;
    };
    static_assert(sizeof(ShouldBeSameSizeAsPermissionDescriptor) == sizeof(WebCore::PermissionDescriptor));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::PermissionDescriptor, name)
    >::value);

    encoder << instance.name;
}

std::optional<WebCore::PermissionDescriptor> ArgumentCoder<WebCore::PermissionDescriptor>::decode(Decoder& decoder)
{
    auto name = decoder.decode<WebCore::PermissionName>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::PermissionDescriptor {
            WTFMove(*name)
        }
    };
}

void ArgumentCoder<WebCore::PushSubscriptionData>::encode(Encoder& encoder, const WebCore::PushSubscriptionData& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.identifier)>, Markable<WebCore::PushSubscriptionIdentifier>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.endpoint)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.expirationTime)>, std::optional<WebCore::EpochTimeStamp>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.serverVAPIDPublicKey)>, Vector<uint8_t>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.clientECDHPublicKey)>, Vector<uint8_t>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.sharedAuthenticationSecret)>, Vector<uint8_t>>);
    struct ShouldBeSameSizeAsPushSubscriptionData : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::PushSubscriptionData>, false> {
        Markable<WebCore::PushSubscriptionIdentifier> identifier;
        String endpoint;
        std::optional<WebCore::EpochTimeStamp> expirationTime;
        Vector<uint8_t> serverVAPIDPublicKey;
        Vector<uint8_t> clientECDHPublicKey;
        Vector<uint8_t> sharedAuthenticationSecret;
    };
    static_assert(sizeof(ShouldBeSameSizeAsPushSubscriptionData) == sizeof(WebCore::PushSubscriptionData));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::PushSubscriptionData, identifier)
        , offsetof(WebCore::PushSubscriptionData, endpoint)
        , offsetof(WebCore::PushSubscriptionData, expirationTime)
        , offsetof(WebCore::PushSubscriptionData, serverVAPIDPublicKey)
        , offsetof(WebCore::PushSubscriptionData, clientECDHPublicKey)
        , offsetof(WebCore::PushSubscriptionData, sharedAuthenticationSecret)
    >::value);

    encoder << instance.identifier;
    encoder << instance.endpoint;
    encoder << instance.expirationTime;
    encoder << instance.serverVAPIDPublicKey;
    encoder << instance.clientECDHPublicKey;
    encoder << instance.sharedAuthenticationSecret;
}

std::optional<WebCore::PushSubscriptionData> ArgumentCoder<WebCore::PushSubscriptionData>::decode(Decoder& decoder)
{
    auto identifier = decoder.decode<Markable<WebCore::PushSubscriptionIdentifier>>();
    auto endpoint = decoder.decode<String>();
    auto expirationTime = decoder.decode<std::optional<WebCore::EpochTimeStamp>>();
    auto serverVAPIDPublicKey = decoder.decode<Vector<uint8_t>>();
    auto clientECDHPublicKey = decoder.decode<Vector<uint8_t>>();
    auto sharedAuthenticationSecret = decoder.decode<Vector<uint8_t>>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::PushSubscriptionData {
            WTFMove(*identifier),
            WTFMove(*endpoint),
            WTFMove(*expirationTime),
            WTFMove(*serverVAPIDPublicKey),
            WTFMove(*clientECDHPublicKey),
            WTFMove(*sharedAuthenticationSecret)
        }
    };
}

void ArgumentCoder<WebCore::DeprecationReportBody>::encode(Encoder& encoder, const WebCore::DeprecationReportBody& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.id())>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.anticipatedRemoval())>, WallTime>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.message())>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.sourceFile())>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.lineNumber())>, std::optional<unsigned>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.columnNumber())>, std::optional<unsigned>>);

    encoder << instance.id();
    encoder << instance.anticipatedRemoval();
    encoder << instance.message();
    encoder << instance.sourceFile();
    encoder << instance.lineNumber();
    encoder << instance.columnNumber();
}

std::optional<Ref<WebCore::DeprecationReportBody>> ArgumentCoder<WebCore::DeprecationReportBody>::decode(Decoder& decoder)
{
    auto id = decoder.decode<String>();
    auto anticipatedRemoval = decoder.decode<WallTime>();
    auto message = decoder.decode<String>();
    auto sourceFile = decoder.decode<String>();
    auto lineNumber = decoder.decode<std::optional<unsigned>>();
    auto columnNumber = decoder.decode<std::optional<unsigned>>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::DeprecationReportBody::create(
            WTFMove(*id),
            WTFMove(*anticipatedRemoval),
            WTFMove(*message),
            WTFMove(*sourceFile),
            WTFMove(*lineNumber),
            WTFMove(*columnNumber)
        )
    };
}

void ArgumentCoder<WebCore::Report>::encode(Encoder& encoder, const WebCore::Report& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.type())>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.url())>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.body())>, RefPtr<WebCore::ReportBody>>);

    encoder << instance.type();
    encoder << instance.url();
    encoder << instance.body();
}

std::optional<Ref<WebCore::Report>> ArgumentCoder<WebCore::Report>::decode(Decoder& decoder)
{
    auto type = decoder.decode<String>();
    auto url = decoder.decode<String>();
    auto body = decoder.decode<RefPtr<WebCore::ReportBody>>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::Report::create(
            WTFMove(*type),
            WTFMove(*url),
            WTFMove(*body)
        )
    };
}

void ArgumentCoder<WebCore::TestReportBody>::encode(Encoder& encoder, const WebCore::TestReportBody& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.message())>, String>);

    encoder << instance.message();
}

std::optional<Ref<WebCore::TestReportBody>> ArgumentCoder<WebCore::TestReportBody>::decode(Decoder& decoder)
{
    auto message = decoder.decode<String>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::TestReportBody::create(
            WTFMove(*message)
        )
    };
}

void ArgumentCoder<WebCore::SpeechRecognitionError>::encode(Encoder& encoder, const WebCore::SpeechRecognitionError& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.type)>, WebCore::SpeechRecognitionErrorType>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.message)>, String>);
    struct ShouldBeSameSizeAsSpeechRecognitionError : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::SpeechRecognitionError>, false> {
        WebCore::SpeechRecognitionErrorType type;
        String message;
    };
    static_assert(sizeof(ShouldBeSameSizeAsSpeechRecognitionError) == sizeof(WebCore::SpeechRecognitionError));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::SpeechRecognitionError, type)
        , offsetof(WebCore::SpeechRecognitionError, message)
    >::value);

    encoder << instance.type;
    encoder << instance.message;
}

std::optional<WebCore::SpeechRecognitionError> ArgumentCoder<WebCore::SpeechRecognitionError>::decode(Decoder& decoder)
{
    auto type = decoder.decode<WebCore::SpeechRecognitionErrorType>();
    auto message = decoder.decode<String>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::SpeechRecognitionError {
            WTFMove(*type),
            WTFMove(*message)
        }
    };
}

void ArgumentCoder<WebCore::SpeechRecognitionRequestInfo>::encode(Encoder& encoder, const WebCore::SpeechRecognitionRequestInfo& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.clientIdentifier)>, WebCore::SpeechRecognitionConnectionClientIdentifier>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.lang)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.continuous)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.interimResults)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.maxAlternatives)>, uint64_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.clientOrigin)>, WebCore::ClientOrigin>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.mainFrameIdentifier)>, WebCore::FrameIdentifier>);
    struct ShouldBeSameSizeAsSpeechRecognitionRequestInfo : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::SpeechRecognitionRequestInfo>, false> {
        WebCore::SpeechRecognitionConnectionClientIdentifier clientIdentifier;
        String lang;
        bool continuous;
        bool interimResults;
        uint64_t maxAlternatives;
        WebCore::ClientOrigin clientOrigin;
        WebCore::FrameIdentifier mainFrameIdentifier;
    };
    static_assert(sizeof(ShouldBeSameSizeAsSpeechRecognitionRequestInfo) == sizeof(WebCore::SpeechRecognitionRequestInfo));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::SpeechRecognitionRequestInfo, clientIdentifier)
        , offsetof(WebCore::SpeechRecognitionRequestInfo, lang)
        , offsetof(WebCore::SpeechRecognitionRequestInfo, continuous)
        , offsetof(WebCore::SpeechRecognitionRequestInfo, interimResults)
        , offsetof(WebCore::SpeechRecognitionRequestInfo, maxAlternatives)
        , offsetof(WebCore::SpeechRecognitionRequestInfo, clientOrigin)
        , offsetof(WebCore::SpeechRecognitionRequestInfo, mainFrameIdentifier)
    >::value);

    encoder << instance.clientIdentifier;
    encoder << instance.lang;
    encoder << instance.continuous;
    encoder << instance.interimResults;
    encoder << instance.maxAlternatives;
    encoder << instance.clientOrigin;
    encoder << instance.mainFrameIdentifier;
}

std::optional<WebCore::SpeechRecognitionRequestInfo> ArgumentCoder<WebCore::SpeechRecognitionRequestInfo>::decode(Decoder& decoder)
{
    auto clientIdentifier = decoder.decode<WebCore::SpeechRecognitionConnectionClientIdentifier>();
    auto lang = decoder.decode<String>();
    auto continuous = decoder.decode<bool>();
    auto interimResults = decoder.decode<bool>();
    auto maxAlternatives = decoder.decode<uint64_t>();
    auto clientOrigin = decoder.decode<WebCore::ClientOrigin>();
    auto mainFrameIdentifier = decoder.decode<WebCore::FrameIdentifier>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::SpeechRecognitionRequestInfo {
            WTFMove(*clientIdentifier),
            WTFMove(*lang),
            WTFMove(*continuous),
            WTFMove(*interimResults),
            WTFMove(*maxAlternatives),
            WTFMove(*clientOrigin),
            WTFMove(*mainFrameIdentifier)
        }
    };
}

void ArgumentCoder<WebCore::SpeechRecognitionAlternativeData>::encode(Encoder& encoder, const WebCore::SpeechRecognitionAlternativeData& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.transcript)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.confidence)>, double>);
    struct ShouldBeSameSizeAsSpeechRecognitionAlternativeData : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::SpeechRecognitionAlternativeData>, false> {
        String transcript;
        double confidence;
    };
    static_assert(sizeof(ShouldBeSameSizeAsSpeechRecognitionAlternativeData) == sizeof(WebCore::SpeechRecognitionAlternativeData));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::SpeechRecognitionAlternativeData, transcript)
        , offsetof(WebCore::SpeechRecognitionAlternativeData, confidence)
    >::value);

    encoder << instance.transcript;
    encoder << instance.confidence;
}

std::optional<WebCore::SpeechRecognitionAlternativeData> ArgumentCoder<WebCore::SpeechRecognitionAlternativeData>::decode(Decoder& decoder)
{
    auto transcript = decoder.decode<String>();
    auto confidence = decoder.decode<double>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::SpeechRecognitionAlternativeData {
            WTFMove(*transcript),
            WTFMove(*confidence)
        }
    };
}

void ArgumentCoder<WebCore::SpeechRecognitionResultData>::encode(Encoder& encoder, const WebCore::SpeechRecognitionResultData& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.alternatives)>, Vector<WebCore::SpeechRecognitionAlternativeData>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isFinal)>, bool>);
    struct ShouldBeSameSizeAsSpeechRecognitionResultData : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::SpeechRecognitionResultData>, false> {
        Vector<WebCore::SpeechRecognitionAlternativeData> alternatives;
        bool isFinal;
    };
    static_assert(sizeof(ShouldBeSameSizeAsSpeechRecognitionResultData) == sizeof(WebCore::SpeechRecognitionResultData));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::SpeechRecognitionResultData, alternatives)
        , offsetof(WebCore::SpeechRecognitionResultData, isFinal)
    >::value);

    encoder << instance.alternatives;
    encoder << instance.isFinal;
}

std::optional<WebCore::SpeechRecognitionResultData> ArgumentCoder<WebCore::SpeechRecognitionResultData>::decode(Decoder& decoder)
{
    auto alternatives = decoder.decode<Vector<WebCore::SpeechRecognitionAlternativeData>>();
    auto isFinal = decoder.decode<bool>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::SpeechRecognitionResultData {
            WTFMove(*alternatives),
            WTFMove(*isFinal)
        }
    };
}

void ArgumentCoder<WebCore::WebLockManagerSnapshot>::encode(Encoder& encoder, const WebCore::WebLockManagerSnapshot& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.held)>, Vector<WebCore::WebLockManagerSnapshot::Info>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.pending)>, Vector<WebCore::WebLockManagerSnapshot::Info>>);
    struct ShouldBeSameSizeAsWebLockManagerSnapshot : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::WebLockManagerSnapshot>, false> {
        Vector<WebCore::WebLockManagerSnapshot::Info> held;
        Vector<WebCore::WebLockManagerSnapshot::Info> pending;
    };
    static_assert(sizeof(ShouldBeSameSizeAsWebLockManagerSnapshot) == sizeof(WebCore::WebLockManagerSnapshot));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::WebLockManagerSnapshot, held)
        , offsetof(WebCore::WebLockManagerSnapshot, pending)
    >::value);

    encoder << instance.held;
    encoder << instance.pending;
}

std::optional<WebCore::WebLockManagerSnapshot> ArgumentCoder<WebCore::WebLockManagerSnapshot>::decode(Decoder& decoder)
{
    auto held = decoder.decode<Vector<WebCore::WebLockManagerSnapshot::Info>>();
    auto pending = decoder.decode<Vector<WebCore::WebLockManagerSnapshot::Info>>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::WebLockManagerSnapshot {
            WTFMove(*held),
            WTFMove(*pending)
        }
    };
}

void ArgumentCoder<WebCore::WebLockManagerSnapshot::Info>::encode(Encoder& encoder, const WebCore::WebLockManagerSnapshot::Info& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.name)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.mode)>, WebCore::WebLockMode>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.clientId)>, String>);
    struct ShouldBeSameSizeAsInfo : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::WebLockManagerSnapshot::Info>, false> {
        String name;
        WebCore::WebLockMode mode;
        String clientId;
    };
    static_assert(sizeof(ShouldBeSameSizeAsInfo) == sizeof(WebCore::WebLockManagerSnapshot::Info));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::WebLockManagerSnapshot::Info, name)
        , offsetof(WebCore::WebLockManagerSnapshot::Info, mode)
        , offsetof(WebCore::WebLockManagerSnapshot::Info, clientId)
    >::value);

    encoder << instance.name;
    encoder << instance.mode;
    encoder << instance.clientId;
}

std::optional<WebCore::WebLockManagerSnapshot::Info> ArgumentCoder<WebCore::WebLockManagerSnapshot::Info>::decode(Decoder& decoder)
{
    auto name = decoder.decode<String>();
    auto mode = decoder.decode<WebCore::WebLockMode>();
    auto clientId = decoder.decode<String>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::WebLockManagerSnapshot::Info {
            WTFMove(*name),
            WTFMove(*mode),
            WTFMove(*clientId)
        }
    };
}

#if ENABLE(WEB_AUTHN)
void ArgumentCoder<WebCore::AuthenticatorResponseBaseData>::encode(Encoder& encoder, const WebCore::AuthenticatorResponseBaseData& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.rawId)>, RefPtr<JSC::ArrayBuffer>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.extensionOutputs)>, std::optional<WebCore::AuthenticationExtensionsClientOutputs>>);
    struct ShouldBeSameSizeAsAuthenticatorResponseBaseData : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::AuthenticatorResponseBaseData>, false> {
        RefPtr<JSC::ArrayBuffer> rawId;
        std::optional<WebCore::AuthenticationExtensionsClientOutputs> extensionOutputs;
    };
    static_assert(sizeof(ShouldBeSameSizeAsAuthenticatorResponseBaseData) == sizeof(WebCore::AuthenticatorResponseBaseData));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::AuthenticatorResponseBaseData, rawId)
        , offsetof(WebCore::AuthenticatorResponseBaseData, extensionOutputs)
    >::value);

    encoder << instance.rawId;
    encoder << instance.extensionOutputs;
}

std::optional<WebCore::AuthenticatorResponseBaseData> ArgumentCoder<WebCore::AuthenticatorResponseBaseData>::decode(Decoder& decoder)
{
    auto rawId = decoder.decode<RefPtr<JSC::ArrayBuffer>>();
    auto extensionOutputs = decoder.decode<std::optional<WebCore::AuthenticationExtensionsClientOutputs>>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::AuthenticatorResponseBaseData {
            WTFMove(*rawId),
            WTFMove(*extensionOutputs)
        }
    };
}

#endif

#if ENABLE(WEB_AUTHN)
void ArgumentCoder<WebCore::AuthenticatorAttestationResponseData>::encode(Encoder& encoder, const WebCore::AuthenticatorAttestationResponseData& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.rawId)>, RefPtr<JSC::ArrayBuffer>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.extensionOutputs)>, std::optional<WebCore::AuthenticationExtensionsClientOutputs>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.clientDataJSON)>, RefPtr<JSC::ArrayBuffer>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.attestationObject)>, RefPtr<JSC::ArrayBuffer>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.transports)>, Vector<WebCore::AuthenticatorTransport>>);
    struct ShouldBeSameSizeAsAuthenticatorAttestationResponseData : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::AuthenticatorAttestationResponseData>, false> {
        RefPtr<JSC::ArrayBuffer> rawId;
        std::optional<WebCore::AuthenticationExtensionsClientOutputs> extensionOutputs;
        RefPtr<JSC::ArrayBuffer> clientDataJSON;
        RefPtr<JSC::ArrayBuffer> attestationObject;
        Vector<WebCore::AuthenticatorTransport> transports;
    };
    static_assert(sizeof(ShouldBeSameSizeAsAuthenticatorAttestationResponseData) == sizeof(WebCore::AuthenticatorAttestationResponseData));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::AuthenticatorAttestationResponseData, rawId)
        , offsetof(WebCore::AuthenticatorAttestationResponseData, extensionOutputs)
        , offsetof(WebCore::AuthenticatorAttestationResponseData, clientDataJSON)
        , offsetof(WebCore::AuthenticatorAttestationResponseData, attestationObject)
        , offsetof(WebCore::AuthenticatorAttestationResponseData, transports)
    >::value);

    encoder << instance.rawId;
    encoder << instance.extensionOutputs;
    encoder << instance.clientDataJSON;
    encoder << instance.attestationObject;
    encoder << instance.transports;
}

std::optional<WebCore::AuthenticatorAttestationResponseData> ArgumentCoder<WebCore::AuthenticatorAttestationResponseData>::decode(Decoder& decoder)
{
    auto rawId = decoder.decode<RefPtr<JSC::ArrayBuffer>>();
    auto extensionOutputs = decoder.decode<std::optional<WebCore::AuthenticationExtensionsClientOutputs>>();
    auto clientDataJSON = decoder.decode<RefPtr<JSC::ArrayBuffer>>();
    auto attestationObject = decoder.decode<RefPtr<JSC::ArrayBuffer>>();
    auto transports = decoder.decode<Vector<WebCore::AuthenticatorTransport>>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::AuthenticatorAttestationResponseData {
            WTFMove(*rawId),
            WTFMove(*extensionOutputs),
            WTFMove(*clientDataJSON),
            WTFMove(*attestationObject),
            WTFMove(*transports)
        }
    };
}

#endif

#if ENABLE(WEB_AUTHN)
void ArgumentCoder<WebCore::AuthenticatorAssertionResponseData>::encode(Encoder& encoder, const WebCore::AuthenticatorAssertionResponseData& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.rawId)>, RefPtr<JSC::ArrayBuffer>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.extensionOutputs)>, std::optional<WebCore::AuthenticationExtensionsClientOutputs>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.clientDataJSON)>, RefPtr<JSC::ArrayBuffer>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.authenticatorData)>, RefPtr<JSC::ArrayBuffer>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.signature)>, RefPtr<JSC::ArrayBuffer>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.userHandle)>, RefPtr<JSC::ArrayBuffer>>);
    struct ShouldBeSameSizeAsAuthenticatorAssertionResponseData : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::AuthenticatorAssertionResponseData>, false> {
        RefPtr<JSC::ArrayBuffer> rawId;
        std::optional<WebCore::AuthenticationExtensionsClientOutputs> extensionOutputs;
        RefPtr<JSC::ArrayBuffer> clientDataJSON;
        RefPtr<JSC::ArrayBuffer> authenticatorData;
        RefPtr<JSC::ArrayBuffer> signature;
        RefPtr<JSC::ArrayBuffer> userHandle;
    };
    static_assert(sizeof(ShouldBeSameSizeAsAuthenticatorAssertionResponseData) == sizeof(WebCore::AuthenticatorAssertionResponseData));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::AuthenticatorAssertionResponseData, rawId)
        , offsetof(WebCore::AuthenticatorAssertionResponseData, extensionOutputs)
        , offsetof(WebCore::AuthenticatorAssertionResponseData, clientDataJSON)
        , offsetof(WebCore::AuthenticatorAssertionResponseData, authenticatorData)
        , offsetof(WebCore::AuthenticatorAssertionResponseData, signature)
        , offsetof(WebCore::AuthenticatorAssertionResponseData, userHandle)
    >::value);

    encoder << instance.rawId;
    encoder << instance.extensionOutputs;
    encoder << instance.clientDataJSON;
    encoder << instance.authenticatorData;
    encoder << instance.signature;
    encoder << instance.userHandle;
}

std::optional<WebCore::AuthenticatorAssertionResponseData> ArgumentCoder<WebCore::AuthenticatorAssertionResponseData>::decode(Decoder& decoder)
{
    auto rawId = decoder.decode<RefPtr<JSC::ArrayBuffer>>();
    auto extensionOutputs = decoder.decode<std::optional<WebCore::AuthenticationExtensionsClientOutputs>>();
    auto clientDataJSON = decoder.decode<RefPtr<JSC::ArrayBuffer>>();
    auto authenticatorData = decoder.decode<RefPtr<JSC::ArrayBuffer>>();
    auto signature = decoder.decode<RefPtr<JSC::ArrayBuffer>>();
    auto userHandle = decoder.decode<RefPtr<JSC::ArrayBuffer>>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::AuthenticatorAssertionResponseData {
            WTFMove(*rawId),
            WTFMove(*extensionOutputs),
            WTFMove(*clientDataJSON),
            WTFMove(*authenticatorData),
            WTFMove(*signature),
            WTFMove(*userHandle)
        }
    };
}

#endif

#if ENABLE(WEB_AUTHN)
void ArgumentCoder<WebCore::AuthenticatorResponseData>::encode(Encoder& encoder, const WebCore::AuthenticatorResponseData& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.getSerializableForm())>, WebCore::AuthenticatorResponseDataSerializableForm>);

    encoder << instance.getSerializableForm();
}

std::optional<WebCore::AuthenticatorResponseData> ArgumentCoder<WebCore::AuthenticatorResponseData>::decode(Decoder& decoder)
{
    auto getSerializableForm = decoder.decode<WebCore::AuthenticatorResponseDataSerializableForm>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::AuthenticatorResponseData {
            WTFMove(*getSerializableForm)
        }
    };
}

#endif

#if ENABLE(WEB_AUTHN)
void ArgumentCoder<WebCore::AuthenticationExtensionsClientInputs::LargeBlobInputs>::encode(Encoder& encoder, const WebCore::AuthenticationExtensionsClientInputs::LargeBlobInputs& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.support)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.read)>, std::optional<bool>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.write)>, std::optional<WebCore::BufferSource>>);
    struct ShouldBeSameSizeAsLargeBlobInputs : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::AuthenticationExtensionsClientInputs::LargeBlobInputs>, false> {
        String support;
        std::optional<bool> read;
        std::optional<WebCore::BufferSource> write;
    };
    static_assert(sizeof(ShouldBeSameSizeAsLargeBlobInputs) == sizeof(WebCore::AuthenticationExtensionsClientInputs::LargeBlobInputs));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::AuthenticationExtensionsClientInputs::LargeBlobInputs, support)
        , offsetof(WebCore::AuthenticationExtensionsClientInputs::LargeBlobInputs, read)
        , offsetof(WebCore::AuthenticationExtensionsClientInputs::LargeBlobInputs, write)
    >::value);

    encoder << instance.support;
    encoder << instance.read;
    encoder << instance.write;
}

std::optional<WebCore::AuthenticationExtensionsClientInputs::LargeBlobInputs> ArgumentCoder<WebCore::AuthenticationExtensionsClientInputs::LargeBlobInputs>::decode(Decoder& decoder)
{
    auto support = decoder.decode<String>();
    auto read = decoder.decode<std::optional<bool>>();
    auto write = decoder.decode<std::optional<WebCore::BufferSource>>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::AuthenticationExtensionsClientInputs::LargeBlobInputs {
            WTFMove(*support),
            WTFMove(*read),
            WTFMove(*write)
        }
    };
}

#endif

#if ENABLE(WEB_AUTHN)
void ArgumentCoder<WebCore::AuthenticationExtensionsClientInputs::PRFValues>::encode(Encoder& encoder, const WebCore::AuthenticationExtensionsClientInputs::PRFValues& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.first)>, WebCore::BufferSource>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.second)>, std::optional<WebCore::BufferSource>>);
    struct ShouldBeSameSizeAsPRFValues : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::AuthenticationExtensionsClientInputs::PRFValues>, false> {
        WebCore::BufferSource first;
        std::optional<WebCore::BufferSource> second;
    };
    static_assert(sizeof(ShouldBeSameSizeAsPRFValues) == sizeof(WebCore::AuthenticationExtensionsClientInputs::PRFValues));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::AuthenticationExtensionsClientInputs::PRFValues, first)
        , offsetof(WebCore::AuthenticationExtensionsClientInputs::PRFValues, second)
    >::value);

    encoder << instance.first;
    encoder << instance.second;
}

std::optional<WebCore::AuthenticationExtensionsClientInputs::PRFValues> ArgumentCoder<WebCore::AuthenticationExtensionsClientInputs::PRFValues>::decode(Decoder& decoder)
{
    auto first = decoder.decode<WebCore::BufferSource>();
    auto second = decoder.decode<std::optional<WebCore::BufferSource>>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::AuthenticationExtensionsClientInputs::PRFValues {
            WTFMove(*first),
            WTFMove(*second)
        }
    };
}

#endif

#if ENABLE(WEB_AUTHN)
void ArgumentCoder<WebCore::AuthenticationExtensionsClientInputs::PRFInputs>::encode(Encoder& encoder, const WebCore::AuthenticationExtensionsClientInputs::PRFInputs& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.eval)>, std::optional<WebCore::AuthenticationExtensionsClientInputs::PRFValues>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.evalByCredential)>, std::optional<Vector<KeyValuePair<String, WebCore::AuthenticationExtensionsClientInputs::PRFValues>>>>);
    struct ShouldBeSameSizeAsPRFInputs : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::AuthenticationExtensionsClientInputs::PRFInputs>, false> {
        std::optional<WebCore::AuthenticationExtensionsClientInputs::PRFValues> eval;
        std::optional<Vector<KeyValuePair<String, WebCore::AuthenticationExtensionsClientInputs::PRFValues>>> evalByCredential;
    };
    static_assert(sizeof(ShouldBeSameSizeAsPRFInputs) == sizeof(WebCore::AuthenticationExtensionsClientInputs::PRFInputs));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::AuthenticationExtensionsClientInputs::PRFInputs, eval)
        , offsetof(WebCore::AuthenticationExtensionsClientInputs::PRFInputs, evalByCredential)
    >::value);

    encoder << instance.eval;
    encoder << instance.evalByCredential;
}

std::optional<WebCore::AuthenticationExtensionsClientInputs::PRFInputs> ArgumentCoder<WebCore::AuthenticationExtensionsClientInputs::PRFInputs>::decode(Decoder& decoder)
{
    auto eval = decoder.decode<std::optional<WebCore::AuthenticationExtensionsClientInputs::PRFValues>>();
    auto evalByCredential = decoder.decode<std::optional<Vector<KeyValuePair<String, WebCore::AuthenticationExtensionsClientInputs::PRFValues>>>>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::AuthenticationExtensionsClientInputs::PRFInputs {
            WTFMove(*eval),
            WTFMove(*evalByCredential)
        }
    };
}

#endif

#if ENABLE(WEB_AUTHN)
void ArgumentCoder<WebCore::AuthenticationExtensionsClientInputs>::encode(Encoder& encoder, const WebCore::AuthenticationExtensionsClientInputs& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.appid)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.credProps)>, std::optional<bool>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.largeBlob)>, std::optional<WebCore::AuthenticationExtensionsClientInputs::LargeBlobInputs>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.prf)>, std::optional<WebCore::AuthenticationExtensionsClientInputs::PRFInputs>>);
    struct ShouldBeSameSizeAsAuthenticationExtensionsClientInputs : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::AuthenticationExtensionsClientInputs>, false> {
        String appid;
        std::optional<bool> credProps;
        std::optional<WebCore::AuthenticationExtensionsClientInputs::LargeBlobInputs> largeBlob;
        std::optional<WebCore::AuthenticationExtensionsClientInputs::PRFInputs> prf;
    };
    static_assert(sizeof(ShouldBeSameSizeAsAuthenticationExtensionsClientInputs) == sizeof(WebCore::AuthenticationExtensionsClientInputs));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::AuthenticationExtensionsClientInputs, appid)
        , offsetof(WebCore::AuthenticationExtensionsClientInputs, credProps)
        , offsetof(WebCore::AuthenticationExtensionsClientInputs, largeBlob)
        , offsetof(WebCore::AuthenticationExtensionsClientInputs, prf)
    >::value);

    encoder << instance.appid;
    encoder << instance.credProps;
    encoder << instance.largeBlob;
    encoder << instance.prf;
}

std::optional<WebCore::AuthenticationExtensionsClientInputs> ArgumentCoder<WebCore::AuthenticationExtensionsClientInputs>::decode(Decoder& decoder)
{
    auto appid = decoder.decode<String>();
    auto credProps = decoder.decode<std::optional<bool>>();
    auto largeBlob = decoder.decode<std::optional<WebCore::AuthenticationExtensionsClientInputs::LargeBlobInputs>>();
    auto prf = decoder.decode<std::optional<WebCore::AuthenticationExtensionsClientInputs::PRFInputs>>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    WebCore::AuthenticationExtensionsClientInputs result;
    result.appid = WTFMove(*appid);
    result.credProps = WTFMove(*credProps);
    result.largeBlob = WTFMove(*largeBlob);
    result.prf = WTFMove(*prf);
    return { WTFMove(result) };
}

#endif

#if ENABLE(WEB_AUTHN)
void ArgumentCoder<WebCore::CredentialPropertiesOutput>::encode(Encoder& encoder, const WebCore::CredentialPropertiesOutput& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.rk)>, bool>);
    struct ShouldBeSameSizeAsCredentialPropertiesOutput : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::CredentialPropertiesOutput>, false> {
        bool rk;
    };
    static_assert(sizeof(ShouldBeSameSizeAsCredentialPropertiesOutput) == sizeof(WebCore::CredentialPropertiesOutput));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::CredentialPropertiesOutput, rk)
    >::value);

    encoder << instance.rk;
}

std::optional<WebCore::CredentialPropertiesOutput> ArgumentCoder<WebCore::CredentialPropertiesOutput>::decode(Decoder& decoder)
{
    auto rk = decoder.decode<bool>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::CredentialPropertiesOutput {
            WTFMove(*rk)
        }
    };
}

#endif

#if ENABLE(WEB_AUTHN)
void ArgumentCoder<WebCore::AuthenticationExtensionsClientOutputs::LargeBlobOutputs>::encode(Encoder& encoder, const WebCore::AuthenticationExtensionsClientOutputs::LargeBlobOutputs& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.supported)>, std::optional<bool>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.blob)>, RefPtr<JSC::ArrayBuffer>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.written)>, std::optional<bool>>);
    struct ShouldBeSameSizeAsLargeBlobOutputs : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::AuthenticationExtensionsClientOutputs::LargeBlobOutputs>, false> {
        std::optional<bool> supported;
        RefPtr<JSC::ArrayBuffer> blob;
        std::optional<bool> written;
    };
    static_assert(sizeof(ShouldBeSameSizeAsLargeBlobOutputs) == sizeof(WebCore::AuthenticationExtensionsClientOutputs::LargeBlobOutputs));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::AuthenticationExtensionsClientOutputs::LargeBlobOutputs, supported)
        , offsetof(WebCore::AuthenticationExtensionsClientOutputs::LargeBlobOutputs, blob)
        , offsetof(WebCore::AuthenticationExtensionsClientOutputs::LargeBlobOutputs, written)
    >::value);

    encoder << instance.supported;
    encoder << instance.blob;
    encoder << instance.written;
}

std::optional<WebCore::AuthenticationExtensionsClientOutputs::LargeBlobOutputs> ArgumentCoder<WebCore::AuthenticationExtensionsClientOutputs::LargeBlobOutputs>::decode(Decoder& decoder)
{
    auto supported = decoder.decode<std::optional<bool>>();
    auto blob = decoder.decode<RefPtr<JSC::ArrayBuffer>>();
    auto written = decoder.decode<std::optional<bool>>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::AuthenticationExtensionsClientOutputs::LargeBlobOutputs {
            WTFMove(*supported),
            WTFMove(*blob),
            WTFMove(*written)
        }
    };
}

#endif

#if ENABLE(WEB_AUTHN)
void ArgumentCoder<WebCore::AuthenticationExtensionsClientOutputs::PRFValues>::encode(Encoder& encoder, const WebCore::AuthenticationExtensionsClientOutputs::PRFValues& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.first)>, RefPtr<JSC::ArrayBuffer>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.second)>, RefPtr<JSC::ArrayBuffer>>);
    struct ShouldBeSameSizeAsPRFValues : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::AuthenticationExtensionsClientOutputs::PRFValues>, false> {
        RefPtr<JSC::ArrayBuffer> first;
        RefPtr<JSC::ArrayBuffer> second;
    };
    static_assert(sizeof(ShouldBeSameSizeAsPRFValues) == sizeof(WebCore::AuthenticationExtensionsClientOutputs::PRFValues));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::AuthenticationExtensionsClientOutputs::PRFValues, first)
        , offsetof(WebCore::AuthenticationExtensionsClientOutputs::PRFValues, second)
    >::value);

    encoder << instance.first;
    encoder << instance.second;
}

std::optional<WebCore::AuthenticationExtensionsClientOutputs::PRFValues> ArgumentCoder<WebCore::AuthenticationExtensionsClientOutputs::PRFValues>::decode(Decoder& decoder)
{
    auto first = decoder.decode<RefPtr<JSC::ArrayBuffer>>();
    auto second = decoder.decode<RefPtr<JSC::ArrayBuffer>>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::AuthenticationExtensionsClientOutputs::PRFValues {
            WTFMove(*first),
            WTFMove(*second)
        }
    };
}

#endif

#if ENABLE(WEB_AUTHN)
void ArgumentCoder<WebCore::AuthenticationExtensionsClientOutputs::PRFOutputs>::encode(Encoder& encoder, const WebCore::AuthenticationExtensionsClientOutputs::PRFOutputs& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.enabled)>, std::optional<bool>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.results)>, std::optional<WebCore::AuthenticationExtensionsClientOutputs::PRFValues>>);
    struct ShouldBeSameSizeAsPRFOutputs : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::AuthenticationExtensionsClientOutputs::PRFOutputs>, false> {
        std::optional<bool> enabled;
        std::optional<WebCore::AuthenticationExtensionsClientOutputs::PRFValues> results;
    };
    static_assert(sizeof(ShouldBeSameSizeAsPRFOutputs) == sizeof(WebCore::AuthenticationExtensionsClientOutputs::PRFOutputs));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::AuthenticationExtensionsClientOutputs::PRFOutputs, enabled)
        , offsetof(WebCore::AuthenticationExtensionsClientOutputs::PRFOutputs, results)
    >::value);

    encoder << instance.enabled;
    encoder << instance.results;
}

std::optional<WebCore::AuthenticationExtensionsClientOutputs::PRFOutputs> ArgumentCoder<WebCore::AuthenticationExtensionsClientOutputs::PRFOutputs>::decode(Decoder& decoder)
{
    auto enabled = decoder.decode<std::optional<bool>>();
    auto results = decoder.decode<std::optional<WebCore::AuthenticationExtensionsClientOutputs::PRFValues>>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::AuthenticationExtensionsClientOutputs::PRFOutputs {
            WTFMove(*enabled),
            WTFMove(*results)
        }
    };
}

#endif

#if ENABLE(WEB_AUTHN)
void ArgumentCoder<WebCore::AuthenticationExtensionsClientOutputs>::encode(Encoder& encoder, const WebCore::AuthenticationExtensionsClientOutputs& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.appid)>, std::optional<bool>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.credProps)>, std::optional<WebCore::CredentialPropertiesOutput>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.largeBlob)>, std::optional<WebCore::AuthenticationExtensionsClientOutputs::LargeBlobOutputs>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.prf)>, std::optional<WebCore::AuthenticationExtensionsClientOutputs::PRFOutputs>>);
    struct ShouldBeSameSizeAsAuthenticationExtensionsClientOutputs : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::AuthenticationExtensionsClientOutputs>, false> {
        std::optional<bool> appid;
        std::optional<WebCore::CredentialPropertiesOutput> credProps;
        std::optional<WebCore::AuthenticationExtensionsClientOutputs::LargeBlobOutputs> largeBlob;
        std::optional<WebCore::AuthenticationExtensionsClientOutputs::PRFOutputs> prf;
    };
    static_assert(sizeof(ShouldBeSameSizeAsAuthenticationExtensionsClientOutputs) == sizeof(WebCore::AuthenticationExtensionsClientOutputs));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::AuthenticationExtensionsClientOutputs, appid)
        , offsetof(WebCore::AuthenticationExtensionsClientOutputs, credProps)
        , offsetof(WebCore::AuthenticationExtensionsClientOutputs, largeBlob)
        , offsetof(WebCore::AuthenticationExtensionsClientOutputs, prf)
    >::value);

    encoder << instance.appid;
    encoder << instance.credProps;
    encoder << instance.largeBlob;
    encoder << instance.prf;
}

std::optional<WebCore::AuthenticationExtensionsClientOutputs> ArgumentCoder<WebCore::AuthenticationExtensionsClientOutputs>::decode(Decoder& decoder)
{
    auto appid = decoder.decode<std::optional<bool>>();
    auto credProps = decoder.decode<std::optional<WebCore::CredentialPropertiesOutput>>();
    auto largeBlob = decoder.decode<std::optional<WebCore::AuthenticationExtensionsClientOutputs::LargeBlobOutputs>>();
    auto prf = decoder.decode<std::optional<WebCore::AuthenticationExtensionsClientOutputs::PRFOutputs>>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::AuthenticationExtensionsClientOutputs {
            WTFMove(*appid),
            WTFMove(*credProps),
            WTFMove(*largeBlob),
            WTFMove(*prf)
        }
    };
}

#endif

#if ENABLE(WEB_AUTHN)
void ArgumentCoder<WebCore::PublicKeyCredentialParameters>::encode(Encoder& encoder, const WebCore::PublicKeyCredentialParameters& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.type)>, WebCore::PublicKeyCredentialType>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.alg)>, int64_t>);
    struct ShouldBeSameSizeAsPublicKeyCredentialParameters : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::PublicKeyCredentialParameters>, false> {
        WebCore::PublicKeyCredentialType type;
        int64_t alg;
    };
    static_assert(sizeof(ShouldBeSameSizeAsPublicKeyCredentialParameters) == sizeof(WebCore::PublicKeyCredentialParameters));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::PublicKeyCredentialParameters, type)
        , offsetof(WebCore::PublicKeyCredentialParameters, alg)
    >::value);

    encoder << instance.type;
    encoder << instance.alg;
}

std::optional<WebCore::PublicKeyCredentialParameters> ArgumentCoder<WebCore::PublicKeyCredentialParameters>::decode(Decoder& decoder)
{
    auto type = decoder.decode<WebCore::PublicKeyCredentialType>();
    auto alg = decoder.decode<int64_t>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::PublicKeyCredentialParameters {
            WTFMove(*type),
            WTFMove(*alg)
        }
    };
}

#endif

#if ENABLE(WEB_AUTHN)
void ArgumentCoder<WebCore::UnknownCredentialOptions>::encode(Encoder& encoder, const WebCore::UnknownCredentialOptions& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.rpId)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.credentialId)>, String>);
    struct ShouldBeSameSizeAsUnknownCredentialOptions : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::UnknownCredentialOptions>, false> {
        String rpId;
        String credentialId;
    };
    static_assert(sizeof(ShouldBeSameSizeAsUnknownCredentialOptions) == sizeof(WebCore::UnknownCredentialOptions));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::UnknownCredentialOptions, rpId)
        , offsetof(WebCore::UnknownCredentialOptions, credentialId)
    >::value);

    encoder << instance.rpId;
    encoder << instance.credentialId;
}

std::optional<WebCore::UnknownCredentialOptions> ArgumentCoder<WebCore::UnknownCredentialOptions>::decode(Decoder& decoder)
{
    auto rpId = decoder.decode<String>();
    auto credentialId = decoder.decode<String>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::UnknownCredentialOptions {
            WTFMove(*rpId),
            WTFMove(*credentialId)
        }
    };
}

#endif

#if ENABLE(WEB_AUTHN)
void ArgumentCoder<WebCore::AllAcceptedCredentialsOptions>::encode(Encoder& encoder, const WebCore::AllAcceptedCredentialsOptions& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.rpId)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.userId)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.allAcceptedCredentialIds)>, Vector<String>>);
    struct ShouldBeSameSizeAsAllAcceptedCredentialsOptions : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::AllAcceptedCredentialsOptions>, false> {
        String rpId;
        String userId;
        Vector<String> allAcceptedCredentialIds;
    };
    static_assert(sizeof(ShouldBeSameSizeAsAllAcceptedCredentialsOptions) == sizeof(WebCore::AllAcceptedCredentialsOptions));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::AllAcceptedCredentialsOptions, rpId)
        , offsetof(WebCore::AllAcceptedCredentialsOptions, userId)
        , offsetof(WebCore::AllAcceptedCredentialsOptions, allAcceptedCredentialIds)
    >::value);

    encoder << instance.rpId;
    encoder << instance.userId;
    encoder << instance.allAcceptedCredentialIds;
}

std::optional<WebCore::AllAcceptedCredentialsOptions> ArgumentCoder<WebCore::AllAcceptedCredentialsOptions>::decode(Decoder& decoder)
{
    auto rpId = decoder.decode<String>();
    auto userId = decoder.decode<String>();
    auto allAcceptedCredentialIds = decoder.decode<Vector<String>>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::AllAcceptedCredentialsOptions {
            WTFMove(*rpId),
            WTFMove(*userId),
            WTFMove(*allAcceptedCredentialIds)
        }
    };
}

#endif

#if ENABLE(WEB_AUTHN)
void ArgumentCoder<WebCore::CurrentUserDetailsOptions>::encode(Encoder& encoder, const WebCore::CurrentUserDetailsOptions& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.rpId)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.userId)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.name)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.displayName)>, String>);
    struct ShouldBeSameSizeAsCurrentUserDetailsOptions : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::CurrentUserDetailsOptions>, false> {
        String rpId;
        String userId;
        String name;
        String displayName;
    };
    static_assert(sizeof(ShouldBeSameSizeAsCurrentUserDetailsOptions) == sizeof(WebCore::CurrentUserDetailsOptions));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::CurrentUserDetailsOptions, rpId)
        , offsetof(WebCore::CurrentUserDetailsOptions, userId)
        , offsetof(WebCore::CurrentUserDetailsOptions, name)
        , offsetof(WebCore::CurrentUserDetailsOptions, displayName)
    >::value);

    encoder << instance.rpId;
    encoder << instance.userId;
    encoder << instance.name;
    encoder << instance.displayName;
}

std::optional<WebCore::CurrentUserDetailsOptions> ArgumentCoder<WebCore::CurrentUserDetailsOptions>::decode(Decoder& decoder)
{
    auto rpId = decoder.decode<String>();
    auto userId = decoder.decode<String>();
    auto name = decoder.decode<String>();
    auto displayName = decoder.decode<String>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::CurrentUserDetailsOptions {
            WTFMove(*rpId),
            WTFMove(*userId),
            WTFMove(*name),
            WTFMove(*displayName)
        }
    };
}

#endif

#if ENABLE(WEB_AUTHN)
void ArgumentCoder<WebCore::AuthenticatorSelectionCriteria>::encode(Encoder& encoder, const WebCore::AuthenticatorSelectionCriteria& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.authenticatorAttachment)>, std::optional<WebCore::AuthenticatorAttachment>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.residentKey)>, std::optional<WebCore::ResidentKeyRequirement>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.requireResidentKey)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.userVerification)>, WebCore::UserVerificationRequirement>);
    struct ShouldBeSameSizeAsAuthenticatorSelectionCriteria : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::AuthenticatorSelectionCriteria>, false> {
        std::optional<WebCore::AuthenticatorAttachment> authenticatorAttachment;
        std::optional<WebCore::ResidentKeyRequirement> residentKey;
        bool requireResidentKey;
        WebCore::UserVerificationRequirement userVerification;
    };
    static_assert(sizeof(ShouldBeSameSizeAsAuthenticatorSelectionCriteria) == sizeof(WebCore::AuthenticatorSelectionCriteria));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::AuthenticatorSelectionCriteria, authenticatorAttachment)
        , offsetof(WebCore::AuthenticatorSelectionCriteria, residentKey)
        , offsetof(WebCore::AuthenticatorSelectionCriteria, requireResidentKey)
        , offsetof(WebCore::AuthenticatorSelectionCriteria, userVerification)
    >::value);

    encoder << instance.authenticatorAttachment;
    encoder << instance.residentKey;
    encoder << instance.requireResidentKey;
    encoder << instance.userVerification;
}

std::optional<WebCore::AuthenticatorSelectionCriteria> ArgumentCoder<WebCore::AuthenticatorSelectionCriteria>::decode(Decoder& decoder)
{
    auto authenticatorAttachment = decoder.decode<std::optional<WebCore::AuthenticatorAttachment>>();
    auto residentKey = decoder.decode<std::optional<WebCore::ResidentKeyRequirement>>();
    auto requireResidentKey = decoder.decode<bool>();
    auto userVerification = decoder.decode<WebCore::UserVerificationRequirement>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::AuthenticatorSelectionCriteria {
            WTFMove(*authenticatorAttachment),
            WTFMove(*residentKey),
            WTFMove(*requireResidentKey),
            WTFMove(*userVerification)
        }
    };
}

#endif

#if ENABLE(WEB_AUTHN)
void ArgumentCoder<WebCore::PublicKeyCredentialEntity>::encode(Encoder& encoder, const WebCore::PublicKeyCredentialEntity& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.name)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.icon)>, String>);
    struct ShouldBeSameSizeAsPublicKeyCredentialEntity : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::PublicKeyCredentialEntity>, false> {
        String name;
        String icon;
    };
    static_assert(sizeof(ShouldBeSameSizeAsPublicKeyCredentialEntity) == sizeof(WebCore::PublicKeyCredentialEntity));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::PublicKeyCredentialEntity, name)
        , offsetof(WebCore::PublicKeyCredentialEntity, icon)
    >::value);

    encoder << instance.name;
    encoder << instance.icon;
}

std::optional<WebCore::PublicKeyCredentialEntity> ArgumentCoder<WebCore::PublicKeyCredentialEntity>::decode(Decoder& decoder)
{
    auto name = decoder.decode<String>();
    auto icon = decoder.decode<String>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::PublicKeyCredentialEntity {
            WTFMove(*name),
            WTFMove(*icon)
        }
    };
}

#endif

#if ENABLE(WEB_AUTHN)
void ArgumentCoder<WebCore::PublicKeyCredentialRpEntity>::encode(Encoder& encoder, const WebCore::PublicKeyCredentialRpEntity& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.name)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.icon)>, String>);
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::PublicKeyCredentialEntity, name)
        , offsetof(WebCore::PublicKeyCredentialEntity, icon)
    >::value);

    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.id)>, String>);
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::PublicKeyCredentialRpEntity, id)
    >::value);

    encoder << instance.name;
    encoder << instance.icon;
    encoder << instance.id;
}

std::optional<WebCore::PublicKeyCredentialRpEntity> ArgumentCoder<WebCore::PublicKeyCredentialRpEntity>::decode(Decoder& decoder)
{
    auto name = decoder.decode<String>();
    auto icon = decoder.decode<String>();
    auto id = decoder.decode<String>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::PublicKeyCredentialRpEntity {
            WebCore::PublicKeyCredentialEntity {
                WTFMove(*name),
                WTFMove(*icon)
            },
            WTFMove(*id)
        }
    };
}

#endif

#if ENABLE(WEB_AUTHN)
void ArgumentCoder<WebCore::PublicKeyCredentialUserEntity>::encode(Encoder& encoder, const WebCore::PublicKeyCredentialUserEntity& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.name)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.icon)>, String>);
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::PublicKeyCredentialEntity, name)
        , offsetof(WebCore::PublicKeyCredentialEntity, icon)
    >::value);

    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.id)>, WebCore::BufferSource>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.displayName)>, String>);
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::PublicKeyCredentialUserEntity, id)
        , offsetof(WebCore::PublicKeyCredentialUserEntity, displayName)
    >::value);

    encoder << instance.name;
    encoder << instance.icon;
    encoder << instance.id;
    encoder << instance.displayName;
}

std::optional<WebCore::PublicKeyCredentialUserEntity> ArgumentCoder<WebCore::PublicKeyCredentialUserEntity>::decode(Decoder& decoder)
{
    auto name = decoder.decode<String>();
    auto icon = decoder.decode<String>();
    auto id = decoder.decode<WebCore::BufferSource>();
    auto displayName = decoder.decode<String>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::PublicKeyCredentialUserEntity {
            WebCore::PublicKeyCredentialEntity {
                WTFMove(*name),
                WTFMove(*icon)
            },
            WTFMove(*id),
            WTFMove(*displayName)
        }
    };
}

#endif

#if ENABLE(WEB_AUTHN)
void ArgumentCoder<WebCore::PublicKeyCredentialDescriptor>::encode(Encoder& encoder, const WebCore::PublicKeyCredentialDescriptor& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.type)>, WebCore::PublicKeyCredentialType>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.id)>, WebCore::BufferSource>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.transports)>, Vector<WebCore::AuthenticatorTransport>>);
    struct ShouldBeSameSizeAsPublicKeyCredentialDescriptor : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::PublicKeyCredentialDescriptor>, false> {
        WebCore::PublicKeyCredentialType type;
        WebCore::BufferSource id;
        Vector<WebCore::AuthenticatorTransport> transports;
    };
    static_assert(sizeof(ShouldBeSameSizeAsPublicKeyCredentialDescriptor) == sizeof(WebCore::PublicKeyCredentialDescriptor));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::PublicKeyCredentialDescriptor, type)
        , offsetof(WebCore::PublicKeyCredentialDescriptor, id)
        , offsetof(WebCore::PublicKeyCredentialDescriptor, transports)
    >::value);

    encoder << instance.type;
    encoder << instance.id;
    encoder << instance.transports;
}

std::optional<WebCore::PublicKeyCredentialDescriptor> ArgumentCoder<WebCore::PublicKeyCredentialDescriptor>::decode(Decoder& decoder)
{
    auto type = decoder.decode<WebCore::PublicKeyCredentialType>();
    auto id = decoder.decode<WebCore::BufferSource>();
    auto transports = decoder.decode<Vector<WebCore::AuthenticatorTransport>>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::PublicKeyCredentialDescriptor {
            WTFMove(*type),
            WTFMove(*id),
            WTFMove(*transports)
        }
    };
}

#endif

void ArgumentCoder<WebCore::PublicKeyCredentialCreationOptions>::encode(Encoder& encoder, const WebCore::PublicKeyCredentialCreationOptions& instance)
{
#if ENABLE(WEB_AUTHN)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.rp)>, WebCore::PublicKeyCredentialRpEntity>);
#endif
#if ENABLE(WEB_AUTHN)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.user)>, WebCore::PublicKeyCredentialUserEntity>);
#endif
#if ENABLE(WEB_AUTHN)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.challenge)>, WebCore::BufferSource>);
#endif
#if ENABLE(WEB_AUTHN)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.pubKeyCredParams)>, Vector<WebCore::PublicKeyCredentialParameters>>);
#endif
#if ENABLE(WEB_AUTHN)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.timeout)>, std::optional<unsigned>>);
#endif
#if ENABLE(WEB_AUTHN)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.excludeCredentials)>, Vector<WebCore::PublicKeyCredentialDescriptor>>);
#endif
#if ENABLE(WEB_AUTHN)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.authenticatorSelection)>, std::optional<WebCore::AuthenticatorSelectionCriteria>>);
#endif
#if ENABLE(WEB_AUTHN)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.attestation)>, WebCore::AttestationConveyancePreference>);
#endif
#if ENABLE(WEB_AUTHN)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.extensions)>, std::optional<WebCore::AuthenticationExtensionsClientInputs>>);
#endif
    struct ShouldBeSameSizeAsPublicKeyCredentialCreationOptions : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::PublicKeyCredentialCreationOptions>, false> {
#if ENABLE(WEB_AUTHN)
        WebCore::PublicKeyCredentialRpEntity rp;
#endif
#if ENABLE(WEB_AUTHN)
        WebCore::PublicKeyCredentialUserEntity user;
#endif
#if ENABLE(WEB_AUTHN)
        WebCore::BufferSource challenge;
#endif
#if ENABLE(WEB_AUTHN)
        Vector<WebCore::PublicKeyCredentialParameters> pubKeyCredParams;
#endif
#if ENABLE(WEB_AUTHN)
        std::optional<unsigned> timeout;
#endif
#if ENABLE(WEB_AUTHN)
        Vector<WebCore::PublicKeyCredentialDescriptor> excludeCredentials;
#endif
#if ENABLE(WEB_AUTHN)
        std::optional<WebCore::AuthenticatorSelectionCriteria> authenticatorSelection;
#endif
#if ENABLE(WEB_AUTHN)
        WebCore::AttestationConveyancePreference attestation;
#endif
#if ENABLE(WEB_AUTHN)
        std::optional<WebCore::AuthenticationExtensionsClientInputs> extensions;
#endif
    };
    static_assert(sizeof(ShouldBeSameSizeAsPublicKeyCredentialCreationOptions) == sizeof(WebCore::PublicKeyCredentialCreationOptions));
    static_assert(MembersInCorrectOrder < 0
#if ENABLE(WEB_AUTHN)
        , offsetof(WebCore::PublicKeyCredentialCreationOptions, rp)
#endif
#if ENABLE(WEB_AUTHN)
        , offsetof(WebCore::PublicKeyCredentialCreationOptions, user)
#endif
#if ENABLE(WEB_AUTHN)
        , offsetof(WebCore::PublicKeyCredentialCreationOptions, challenge)
#endif
#if ENABLE(WEB_AUTHN)
        , offsetof(WebCore::PublicKeyCredentialCreationOptions, pubKeyCredParams)
#endif
#if ENABLE(WEB_AUTHN)
        , offsetof(WebCore::PublicKeyCredentialCreationOptions, timeout)
#endif
#if ENABLE(WEB_AUTHN)
        , offsetof(WebCore::PublicKeyCredentialCreationOptions, excludeCredentials)
#endif
#if ENABLE(WEB_AUTHN)
        , offsetof(WebCore::PublicKeyCredentialCreationOptions, authenticatorSelection)
#endif
#if ENABLE(WEB_AUTHN)
        , offsetof(WebCore::PublicKeyCredentialCreationOptions, attestation)
#endif
#if ENABLE(WEB_AUTHN)
        , offsetof(WebCore::PublicKeyCredentialCreationOptions, extensions)
#endif
    >::value);

#if ENABLE(WEB_AUTHN)
    encoder << instance.rp;
#endif
#if ENABLE(WEB_AUTHN)
    encoder << instance.user;
#endif
#if ENABLE(WEB_AUTHN)
    encoder << instance.challenge;
#endif
#if ENABLE(WEB_AUTHN)
    encoder << instance.pubKeyCredParams;
#endif
#if ENABLE(WEB_AUTHN)
    encoder << instance.timeout;
#endif
#if ENABLE(WEB_AUTHN)
    encoder << instance.excludeCredentials;
#endif
#if ENABLE(WEB_AUTHN)
    encoder << instance.authenticatorSelection;
#endif
#if ENABLE(WEB_AUTHN)
    encoder << instance.attestation;
#endif
#if ENABLE(WEB_AUTHN)
    encoder << instance.extensions;
#endif
}

std::optional<WebCore::PublicKeyCredentialCreationOptions> ArgumentCoder<WebCore::PublicKeyCredentialCreationOptions>::decode(Decoder& decoder)
{
#if ENABLE(WEB_AUTHN)
    auto rp = decoder.decode<WebCore::PublicKeyCredentialRpEntity>();
#endif
#if ENABLE(WEB_AUTHN)
    auto user = decoder.decode<WebCore::PublicKeyCredentialUserEntity>();
#endif
#if ENABLE(WEB_AUTHN)
    auto challenge = decoder.decode<WebCore::BufferSource>();
#endif
#if ENABLE(WEB_AUTHN)
    auto pubKeyCredParams = decoder.decode<Vector<WebCore::PublicKeyCredentialParameters>>();
#endif
#if ENABLE(WEB_AUTHN)
    auto timeout = decoder.decode<std::optional<unsigned>>();
#endif
#if ENABLE(WEB_AUTHN)
    auto excludeCredentials = decoder.decode<Vector<WebCore::PublicKeyCredentialDescriptor>>();
#endif
#if ENABLE(WEB_AUTHN)
    auto authenticatorSelection = decoder.decode<std::optional<WebCore::AuthenticatorSelectionCriteria>>();
#endif
#if ENABLE(WEB_AUTHN)
    auto attestation = decoder.decode<WebCore::AttestationConveyancePreference>();
#endif
#if ENABLE(WEB_AUTHN)
    auto extensions = decoder.decode<std::optional<WebCore::AuthenticationExtensionsClientInputs>>();
#endif
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::PublicKeyCredentialCreationOptions {
#if ENABLE(WEB_AUTHN)
            WTFMove(*rp),
#endif
#if ENABLE(WEB_AUTHN)
            WTFMove(*user),
#endif
#if ENABLE(WEB_AUTHN)
            WTFMove(*challenge),
#endif
#if ENABLE(WEB_AUTHN)
            WTFMove(*pubKeyCredParams),
#endif
#if ENABLE(WEB_AUTHN)
            WTFMove(*timeout),
#endif
#if ENABLE(WEB_AUTHN)
            WTFMove(*excludeCredentials),
#endif
#if ENABLE(WEB_AUTHN)
            WTFMove(*authenticatorSelection),
#endif
#if ENABLE(WEB_AUTHN)
            WTFMove(*attestation),
#endif
#if ENABLE(WEB_AUTHN)
            WTFMove(*extensions)
#endif
        }
    };
}

void ArgumentCoder<WebCore::PublicKeyCredentialRequestOptions>::encode(Encoder& encoder, const WebCore::PublicKeyCredentialRequestOptions& instance)
{
#if ENABLE(WEB_AUTHN)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.challenge)>, WebCore::BufferSource>);
#endif
#if ENABLE(WEB_AUTHN)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.timeout)>, std::optional<unsigned>>);
#endif
#if ENABLE(WEB_AUTHN)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.rpId)>, String>);
#endif
#if ENABLE(WEB_AUTHN)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.allowCredentials)>, Vector<WebCore::PublicKeyCredentialDescriptor>>);
#endif
#if ENABLE(WEB_AUTHN)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.userVerification)>, WebCore::UserVerificationRequirement>);
#endif
#if ENABLE(WEB_AUTHN)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.extensions)>, std::optional<WebCore::AuthenticationExtensionsClientInputs>>);
#endif
#if ENABLE(WEB_AUTHN)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.authenticatorAttachment)>, std::optional<WebCore::AuthenticatorAttachment>>);
#endif
    struct ShouldBeSameSizeAsPublicKeyCredentialRequestOptions : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::PublicKeyCredentialRequestOptions>, false> {
#if ENABLE(WEB_AUTHN)
        WebCore::BufferSource challenge;
#endif
#if ENABLE(WEB_AUTHN)
        std::optional<unsigned> timeout;
#endif
#if ENABLE(WEB_AUTHN)
        String rpId;
#endif
#if ENABLE(WEB_AUTHN)
        Vector<WebCore::PublicKeyCredentialDescriptor> allowCredentials;
#endif
#if ENABLE(WEB_AUTHN)
        WebCore::UserVerificationRequirement userVerification;
#endif
#if ENABLE(WEB_AUTHN)
        std::optional<WebCore::AuthenticationExtensionsClientInputs> extensions;
#endif
#if ENABLE(WEB_AUTHN)
        std::optional<WebCore::AuthenticatorAttachment> authenticatorAttachment;
#endif
    };
    static_assert(sizeof(ShouldBeSameSizeAsPublicKeyCredentialRequestOptions) == sizeof(WebCore::PublicKeyCredentialRequestOptions));
    static_assert(MembersInCorrectOrder < 0
#if ENABLE(WEB_AUTHN)
        , offsetof(WebCore::PublicKeyCredentialRequestOptions, challenge)
#endif
#if ENABLE(WEB_AUTHN)
        , offsetof(WebCore::PublicKeyCredentialRequestOptions, timeout)
#endif
#if ENABLE(WEB_AUTHN)
        , offsetof(WebCore::PublicKeyCredentialRequestOptions, rpId)
#endif
#if ENABLE(WEB_AUTHN)
        , offsetof(WebCore::PublicKeyCredentialRequestOptions, allowCredentials)
#endif
#if ENABLE(WEB_AUTHN)
        , offsetof(WebCore::PublicKeyCredentialRequestOptions, userVerification)
#endif
#if ENABLE(WEB_AUTHN)
        , offsetof(WebCore::PublicKeyCredentialRequestOptions, extensions)
#endif
#if ENABLE(WEB_AUTHN)
        , offsetof(WebCore::PublicKeyCredentialRequestOptions, authenticatorAttachment)
#endif
    >::value);

#if ENABLE(WEB_AUTHN)
    encoder << instance.challenge;
#endif
#if ENABLE(WEB_AUTHN)
    encoder << instance.timeout;
#endif
#if ENABLE(WEB_AUTHN)
    encoder << instance.rpId;
#endif
#if ENABLE(WEB_AUTHN)
    encoder << instance.allowCredentials;
#endif
#if ENABLE(WEB_AUTHN)
    encoder << instance.userVerification;
#endif
#if ENABLE(WEB_AUTHN)
    encoder << instance.extensions;
#endif
}

std::optional<WebCore::PublicKeyCredentialRequestOptions> ArgumentCoder<WebCore::PublicKeyCredentialRequestOptions>::decode(Decoder& decoder)
{
#if ENABLE(WEB_AUTHN)
    auto challenge = decoder.decode<WebCore::BufferSource>();
#endif
#if ENABLE(WEB_AUTHN)
    auto timeout = decoder.decode<std::optional<unsigned>>();
#endif
#if ENABLE(WEB_AUTHN)
    auto rpId = decoder.decode<String>();
#endif
#if ENABLE(WEB_AUTHN)
    auto allowCredentials = decoder.decode<Vector<WebCore::PublicKeyCredentialDescriptor>>();
#endif
#if ENABLE(WEB_AUTHN)
    auto userVerification = decoder.decode<WebCore::UserVerificationRequirement>();
#endif
#if ENABLE(WEB_AUTHN)
    auto extensions = decoder.decode<std::optional<WebCore::AuthenticationExtensionsClientInputs>>();
#endif
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::PublicKeyCredentialRequestOptions {
#if ENABLE(WEB_AUTHN)
            WTFMove(*challenge),
#endif
#if ENABLE(WEB_AUTHN)
            WTFMove(*timeout),
#endif
#if ENABLE(WEB_AUTHN)
            WTFMove(*rpId),
#endif
#if ENABLE(WEB_AUTHN)
            WTFMove(*allowCredentials),
#endif
#if ENABLE(WEB_AUTHN)
            WTFMove(*userVerification),
#endif
#if ENABLE(WEB_AUTHN)
            WTFMove(*extensions)
#endif
        }
    };
}

void ArgumentCoder<WebCore::RegistrableDomain>::encode(Encoder& encoder, const WebCore::RegistrableDomain& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.string())>, String>);

    encoder << instance.string();
}

std::optional<WebCore::RegistrableDomain> ArgumentCoder<WebCore::RegistrableDomain>::decode(Decoder& decoder)
{
    auto string = decoder.decode<String>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::RegistrableDomain::fromRawString(
            WTFMove(*string)
        )
    };
}

void ArgumentCoder<WebCore::Site>::encode(Encoder& encoder, const WebCore::Site& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.protocol())>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.domain())>, WebCore::RegistrableDomain>);

    encoder << instance.protocol();
    encoder << instance.domain();
}

std::optional<WebCore::Site> ArgumentCoder<WebCore::Site>::decode(Decoder& decoder)
{
    auto protocol = decoder.decode<String>();
    auto domain = decoder.decode<WebCore::RegistrableDomain>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::Site {
            WTFMove(*protocol),
            WTFMove(*domain)
        }
    };
}

void ArgumentCoder<WebCore::AudioConfiguration>::encode(Encoder& encoder, const WebCore::AudioConfiguration& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.contentType)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.channels)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.bitrate)>, std::optional<uint64_t>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.samplerate)>, std::optional<uint32_t>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.spatialRendering)>, std::optional<bool>>);
    struct ShouldBeSameSizeAsAudioConfiguration : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::AudioConfiguration>, false> {
        String contentType;
        String channels;
        std::optional<uint64_t> bitrate;
        std::optional<uint32_t> samplerate;
        std::optional<bool> spatialRendering;
    };
    static_assert(sizeof(ShouldBeSameSizeAsAudioConfiguration) == sizeof(WebCore::AudioConfiguration));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::AudioConfiguration, contentType)
        , offsetof(WebCore::AudioConfiguration, channels)
        , offsetof(WebCore::AudioConfiguration, bitrate)
        , offsetof(WebCore::AudioConfiguration, samplerate)
        , offsetof(WebCore::AudioConfiguration, spatialRendering)
    >::value);

    encoder << instance.contentType;
    encoder << instance.channels;
    encoder << instance.bitrate;
    encoder << instance.samplerate;
    encoder << instance.spatialRendering;
}

std::optional<WebCore::AudioConfiguration> ArgumentCoder<WebCore::AudioConfiguration>::decode(Decoder& decoder)
{
    auto contentType = decoder.decode<String>();
    auto channels = decoder.decode<String>();
    auto bitrate = decoder.decode<std::optional<uint64_t>>();
    auto samplerate = decoder.decode<std::optional<uint32_t>>();
    auto spatialRendering = decoder.decode<std::optional<bool>>();
    if (!decoder.isValid()) [[unlikely]]
        return std::nullopt;
    return {
        WebCore::AudioConfiguration {
            WTFMove(*contentType),
            WTFMove(*channels),
            WTFMove(*bitrate),
            WTFMove(*samplerate),
            WTFMove(*spatialRendering)
        }
    };
}

void ArgumentCoder<WebCore::Cookie>::encode(Encoder& encoder, const WebCore::Cookie& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.name)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.value)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.domain)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.path)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.partitionKey)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.created)>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.expires)>, std::optional<double>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.httpOnly)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.secure)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.session)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.comment)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.commentURL)>, URL>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.ports)>, Vector<uint16_t>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.sameSite)>, WebCore::Cookie::SameSitePolicy>);
    struct ShouldBeSameSizeAsCookie : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::Cookie>, false> {
        String name;
        String value;
        String domain;
        String path;
        String partitionKey;
        double created;
        std::optional<double> expires;
        bool httpOnly;
        bool secure;
        bool session;
        String comment;
        URL commentURL;
        Vector<uint16_t> ports;
        WebCore::Cookie::SameSitePolicy sameSite;
    };
    static_assert(sizeof(ShouldBeSameSizeAsCookie) == sizeof(WebCore::Cookie));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::Cookie, name)
        , offsetof(WebCore::Cookie, value)
        , offsetof(WebCore::Cookie, domain)
        , offsetof(WebCore::Cookie, path)
        , offsetof(WebCore::Cookie, partitionKey)
        , offsetof(WebCore::Cookie, created)
        , offsetof(WebCore::Cookie, expires)
        , offsetof(WebCore::Cookie, httpOnly)
        , offsetof(WebCore::Cookie, secure)
        , offsetof(WebCore::Cookie, session)
        , offsetof(WebCore::Cookie, comment)
        , offsetof(WebCore::Cookie, commentURL)
        , offsetof(WebCore::Cookie, ports)
        , offsetof(WebCore::Cookie, sameSite)
    >::value);

    encoder << instance.name;
    encoder << instance.value;
    encoder << instance.domain;
    encoder << instance.path;
    encoder << instance.partitionKey;
    encoder << instance.created;
    encoder <