// java wrapper for vtkStackedTreeLayoutStrategy object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkStackedTreeLayoutStrategy.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkAreaLayoutStrategy_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkStackedTreeLayoutStrategy_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkStackedTreeLayoutStrategy",dType)) { return me; }
  if ((res= vtkAreaLayoutStrategy_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkStackedTreeLayoutStrategy_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkStackedTreeLayoutStrategy* op = static_cast<vtkStackedTreeLayoutStrategy*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkStackedTreeLayoutStrategy_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkStackedTreeLayoutStrategy* op = static_cast<vtkStackedTreeLayoutStrategy*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkStackedTreeLayoutStrategy_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkStackedTreeLayoutStrategy* op = static_cast<vtkStackedTreeLayoutStrategy*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkStackedTreeLayoutStrategy_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkStackedTreeLayoutStrategy* op = static_cast<vtkStackedTreeLayoutStrategy*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStackedTreeLayoutStrategy_Layout_14(JNIEnv* env, jobject obj,jobject id0,jobject id1,jobject id2)
{
  vtkTree * temp0;
  vtkDataArray * temp1;
  vtkDataArray * temp2;
  temp0 = static_cast<vtkTree*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id2));

  vtkStackedTreeLayoutStrategy* op = static_cast<vtkStackedTreeLayoutStrategy*>(vtkJavaGetPointerFromObject(env, obj));
  op->Layout(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStackedTreeLayoutStrategy_LayoutEdgePoints_15(JNIEnv* env, jobject obj,jobject id0,jobject id1,jobject id2,jobject id3)
{
  vtkTree * temp0;
  vtkDataArray * temp1;
  vtkDataArray * temp2;
  vtkTree * temp3;
  temp0 = static_cast<vtkTree*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id2));
  temp3 = static_cast<vtkTree*>(vtkJavaGetPointerFromObject(env, id3));

  vtkStackedTreeLayoutStrategy* op = static_cast<vtkStackedTreeLayoutStrategy*>(vtkJavaGetPointerFromObject(env, obj));
  op->LayoutEdgePoints(temp0,temp1,temp2,temp3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStackedTreeLayoutStrategy_SetInteriorRadius_16(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkStackedTreeLayoutStrategy* op = static_cast<vtkStackedTreeLayoutStrategy*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInteriorRadius(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkStackedTreeLayoutStrategy_GetInteriorRadius_17(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkStackedTreeLayoutStrategy* op = static_cast<vtkStackedTreeLayoutStrategy*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInteriorRadius();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStackedTreeLayoutStrategy_SetRingThickness_18(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkStackedTreeLayoutStrategy* op = static_cast<vtkStackedTreeLayoutStrategy*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRingThickness(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkStackedTreeLayoutStrategy_GetRingThickness_19(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkStackedTreeLayoutStrategy* op = static_cast<vtkStackedTreeLayoutStrategy*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRingThickness();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStackedTreeLayoutStrategy_SetRootStartAngle_110(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkStackedTreeLayoutStrategy* op = static_cast<vtkStackedTreeLayoutStrategy*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRootStartAngle(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkStackedTreeLayoutStrategy_GetRootStartAngle_111(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkStackedTreeLayoutStrategy* op = static_cast<vtkStackedTreeLayoutStrategy*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRootStartAngle();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStackedTreeLayoutStrategy_SetRootEndAngle_112(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkStackedTreeLayoutStrategy* op = static_cast<vtkStackedTreeLayoutStrategy*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRootEndAngle(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkStackedTreeLayoutStrategy_GetRootEndAngle_113(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkStackedTreeLayoutStrategy* op = static_cast<vtkStackedTreeLayoutStrategy*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRootEndAngle();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStackedTreeLayoutStrategy_SetUseRectangularCoordinates_114(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkStackedTreeLayoutStrategy* op = static_cast<vtkStackedTreeLayoutStrategy*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUseRectangularCoordinates(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkStackedTreeLayoutStrategy_GetUseRectangularCoordinates_115(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkStackedTreeLayoutStrategy* op = static_cast<vtkStackedTreeLayoutStrategy*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUseRectangularCoordinates();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStackedTreeLayoutStrategy_UseRectangularCoordinatesOn_116(JNIEnv* env, jobject obj)
{

  vtkStackedTreeLayoutStrategy* op = static_cast<vtkStackedTreeLayoutStrategy*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseRectangularCoordinatesOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStackedTreeLayoutStrategy_UseRectangularCoordinatesOff_117(JNIEnv* env, jobject obj)
{

  vtkStackedTreeLayoutStrategy* op = static_cast<vtkStackedTreeLayoutStrategy*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseRectangularCoordinatesOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStackedTreeLayoutStrategy_SetReverse_118(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkStackedTreeLayoutStrategy* op = static_cast<vtkStackedTreeLayoutStrategy*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetReverse(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkStackedTreeLayoutStrategy_GetReverse_119(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkStackedTreeLayoutStrategy* op = static_cast<vtkStackedTreeLayoutStrategy*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetReverse();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStackedTreeLayoutStrategy_ReverseOn_120(JNIEnv* env, jobject obj)
{

  vtkStackedTreeLayoutStrategy* op = static_cast<vtkStackedTreeLayoutStrategy*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReverseOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStackedTreeLayoutStrategy_ReverseOff_121(JNIEnv* env, jobject obj)
{

  vtkStackedTreeLayoutStrategy* op = static_cast<vtkStackedTreeLayoutStrategy*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReverseOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStackedTreeLayoutStrategy_SetInteriorLogSpacingValue_122(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkStackedTreeLayoutStrategy* op = static_cast<vtkStackedTreeLayoutStrategy*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInteriorLogSpacingValue(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkStackedTreeLayoutStrategy_GetInteriorLogSpacingValue_123(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkStackedTreeLayoutStrategy* op = static_cast<vtkStackedTreeLayoutStrategy*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInteriorLogSpacingValue();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkStackedTreeLayoutStrategy_FindVertex_124(JNIEnv* env, jobject obj,jobject id0,jobject id1,jfloatArray id2)
{
  vtkTree * temp0;
  vtkDataArray * temp1;
  float temp2[2];
  long long   temp20;
  temp0 = static_cast<vtkTree*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id1));
  env->GetFloatArrayRegion(id2, 0, 2, &temp2[0]);

  vtkStackedTreeLayoutStrategy* op = static_cast<vtkStackedTreeLayoutStrategy*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->FindVertex(temp0,temp1,temp2);
  env->SetFloatArrayRegion(id2, 0, 2, &temp2[0]);
  return temp20;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkStackedTreeLayoutStrategy_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkStackedTreeLayoutStrategy::New());
}
