// java wrapper for vtkPeriodicTable object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkPeriodicTable.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkObject_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkPeriodicTable_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkPeriodicTable",dType)) { return me; }
  if ((res= vtkObject_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPeriodicTable_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPeriodicTable* op = static_cast<vtkPeriodicTable*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPeriodicTable_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPeriodicTable* op = static_cast<vtkPeriodicTable*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPeriodicTable_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPeriodicTable* op = static_cast<vtkPeriodicTable*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPeriodicTable_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPeriodicTable* op = static_cast<vtkPeriodicTable*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPeriodicTable_GetBlueObeliskData_14(JNIEnv* env, jobject obj)
{
  vtkBlueObeliskData * temp20;

  vtkPeriodicTable* op = static_cast<vtkPeriodicTable*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBlueObeliskData();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jshort  JNICALL Java_vtk_vtkPeriodicTable_GetNumberOfElements_15(JNIEnv* env, jobject obj)
{
   unsigned short   temp20;

  vtkPeriodicTable* op = static_cast<vtkPeriodicTable*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfElements();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkPeriodicTable_GetSymbol_16(JNIEnv* env, jobject obj,jshort id0)
{
   unsigned short   temp0;
  const char * temp20;
  temp0 = id0;

  vtkPeriodicTable* op = static_cast<vtkPeriodicTable*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSymbol(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkPeriodicTable_GetElementName_17(JNIEnv* env, jobject obj,jshort id0)
{
   unsigned short   temp0;
  const char * temp20;
  temp0 = id0;

  vtkPeriodicTable* op = static_cast<vtkPeriodicTable*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetElementName(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jshort  JNICALL Java_vtk_vtkPeriodicTable_GetAtomicNumber_18(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  vtkStdString temp0;
   unsigned short   temp20;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);

  vtkPeriodicTable* op = static_cast<vtkPeriodicTable*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAtomicNumber(temp0);
  return temp20;

}

extern "C" JNIEXPORT jfloat  JNICALL Java_vtk_vtkPeriodicTable_GetCovalentRadius_19(JNIEnv* env, jobject obj,jshort id0)
{
   unsigned short   temp0;
  float   temp20;
  temp0 = id0;

  vtkPeriodicTable* op = static_cast<vtkPeriodicTable*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCovalentRadius(temp0);
  return temp20;

}

extern "C" JNIEXPORT jfloat  JNICALL Java_vtk_vtkPeriodicTable_GetVDWRadius_110(JNIEnv* env, jobject obj,jshort id0)
{
   unsigned short   temp0;
  float   temp20;
  temp0 = id0;

  vtkPeriodicTable* op = static_cast<vtkPeriodicTable*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetVDWRadius(temp0);
  return temp20;

}

extern "C" JNIEXPORT jfloat  JNICALL Java_vtk_vtkPeriodicTable_GetMaxVDWRadius_111(JNIEnv* env, jobject obj)
{
  float   temp20;

  vtkPeriodicTable* op = static_cast<vtkPeriodicTable*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaxVDWRadius();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPeriodicTable_GetDefaultLUT_112(JNIEnv* env, jobject obj,jobject id0)
{
  vtkLookupTable * temp0;
  temp0 = static_cast<vtkLookupTable*>(vtkJavaGetPointerFromObject(env, id0));

  vtkPeriodicTable* op = static_cast<vtkPeriodicTable*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetDefaultLUT(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPeriodicTable_GetDefaultRGBTuple_113(JNIEnv* env, jobject obj,jshort id0,jfloatArray id1)
{
   unsigned short   temp0;
  float temp1[3];
  temp0 = id0;
  env->GetFloatArrayRegion(id1, 0, 3, &temp1[0]);

  vtkPeriodicTable* op = static_cast<vtkPeriodicTable*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetDefaultRGBTuple(temp0,temp1);
  env->SetFloatArrayRegion(id1, 0, 3, &temp1[0]);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkPeriodicTable_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkPeriodicTable::New());
}
