// java wrapper for vtkSuperquadric object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkSuperquadric.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkImplicitFunction_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkSuperquadric_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkSuperquadric",dType)) { return me; }
  if ((res= vtkImplicitFunction_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSuperquadric_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSuperquadric* op = static_cast<vtkSuperquadric*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSuperquadric_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSuperquadric* op = static_cast<vtkSuperquadric*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSuperquadric_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSuperquadric* op = static_cast<vtkSuperquadric*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSuperquadric_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSuperquadric* op = static_cast<vtkSuperquadric*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkSuperquadric_EvaluateFunction_14(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  double   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkSuperquadric* op = static_cast<vtkSuperquadric*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->EvaluateFunction(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSuperquadric_EvaluateGradient_15(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1)
{
  double temp0[3];
  double temp1[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

  vtkSuperquadric* op = static_cast<vtkSuperquadric*>(vtkJavaGetPointerFromObject(env, obj));
  op->EvaluateGradient(temp0,temp1);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->SetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSuperquadric_SetCenter_16(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkSuperquadric* op = static_cast<vtkSuperquadric*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCenter(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSuperquadric_SetCenter_17(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkSuperquadric* op = static_cast<vtkSuperquadric*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCenter(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkSuperquadric_GetCenter_18(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkSuperquadric* op = static_cast<vtkSuperquadric*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCenter();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSuperquadric_SetScale_19(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkSuperquadric* op = static_cast<vtkSuperquadric*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScale(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSuperquadric_SetScale_110(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkSuperquadric* op = static_cast<vtkSuperquadric*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScale(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkSuperquadric_GetScale_111(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkSuperquadric* op = static_cast<vtkSuperquadric*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetScale();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkSuperquadric_GetThickness_112(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkSuperquadric* op = static_cast<vtkSuperquadric*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetThickness();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSuperquadric_SetThickness_113(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkSuperquadric* op = static_cast<vtkSuperquadric*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetThickness(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkSuperquadric_GetThicknessMinValue_114(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkSuperquadric* op = static_cast<vtkSuperquadric*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetThicknessMinValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkSuperquadric_GetThicknessMaxValue_115(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkSuperquadric* op = static_cast<vtkSuperquadric*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetThicknessMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkSuperquadric_GetPhiRoundness_116(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkSuperquadric* op = static_cast<vtkSuperquadric*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPhiRoundness();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSuperquadric_SetPhiRoundness_117(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkSuperquadric* op = static_cast<vtkSuperquadric*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPhiRoundness(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkSuperquadric_GetThetaRoundness_118(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkSuperquadric* op = static_cast<vtkSuperquadric*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetThetaRoundness();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSuperquadric_SetThetaRoundness_119(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkSuperquadric* op = static_cast<vtkSuperquadric*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetThetaRoundness(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSuperquadric_SetSize_120(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkSuperquadric* op = static_cast<vtkSuperquadric*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSize(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkSuperquadric_GetSize_121(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkSuperquadric* op = static_cast<vtkSuperquadric*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSize();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSuperquadric_ToroidalOn_122(JNIEnv* env, jobject obj)
{

  vtkSuperquadric* op = static_cast<vtkSuperquadric*>(vtkJavaGetPointerFromObject(env, obj));
  op->ToroidalOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSuperquadric_ToroidalOff_123(JNIEnv* env, jobject obj)
{

  vtkSuperquadric* op = static_cast<vtkSuperquadric*>(vtkJavaGetPointerFromObject(env, obj));
  op->ToroidalOff();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSuperquadric_GetToroidal_124(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkSuperquadric* op = static_cast<vtkSuperquadric*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetToroidal();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSuperquadric_SetToroidal_125(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkSuperquadric* op = static_cast<vtkSuperquadric*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetToroidal(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSuperquadric_EvaluateFunction_126(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkDataArray * temp0;
  vtkDataArray * temp1;
  temp0 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id1));

  vtkSuperquadric* op = static_cast<vtkSuperquadric*>(vtkJavaGetPointerFromObject(env, obj));
  op->EvaluateFunction(temp0,temp1);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkSuperquadric_EvaluateFunction_127(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkSuperquadric* op = static_cast<vtkSuperquadric*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->EvaluateFunction(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkSuperquadric_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkSuperquadric::New());
}
