// java wrapper for vtkStructuredGrid object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkStructuredGrid.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkPointSet_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkStructuredGrid_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkStructuredGrid",dType)) { return me; }
  if ((res= vtkPointSet_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkStructuredGrid_ExtendedNew_10(JNIEnv* env, jobject obj)
{
  vtkStructuredGrid * temp20;

  vtkStructuredGrid* op = static_cast<vtkStructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ExtendedNew();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkStructuredGrid_IsTypeOf_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkStructuredGrid* op = static_cast<vtkStructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkStructuredGrid_IsA_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkStructuredGrid* op = static_cast<vtkStructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkStructuredGrid_GetNumberOfGenerationsFromBaseType_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkStructuredGrid* op = static_cast<vtkStructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkStructuredGrid_GetNumberOfGenerationsFromBase_14(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkStructuredGrid* op = static_cast<vtkStructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkStructuredGrid_GetDataObjectType_15(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkStructuredGrid* op = static_cast<vtkStructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataObjectType();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStructuredGrid_CopyStructure_16(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataSet * temp0;
  temp0 = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, id0));

  vtkStructuredGrid* op = static_cast<vtkStructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->CopyStructure(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStructuredGrid_Initialize_17(JNIEnv* env, jobject obj)
{

  vtkStructuredGrid* op = static_cast<vtkStructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->Initialize();

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkStructuredGrid_GetNumberOfCells_18(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkStructuredGrid* op = static_cast<vtkStructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfCells();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkStructuredGrid_GetNumberOfPoints_19(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkStructuredGrid* op = static_cast<vtkStructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfPoints();
  return temp20;

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkStructuredGrid_GetPoint_110(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  double * temp20;
  temp0 = id0;

  vtkStructuredGrid* op = static_cast<vtkStructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPoint(temp0);
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStructuredGrid_GetPoint_111(JNIEnv* env, jobject obj,jlong id0,jdoubleArray id1)
{
  long long   temp0;
  double temp1[3];
  temp0 = id0;
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

  vtkStructuredGrid* op = static_cast<vtkStructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetPoint(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkStructuredGrid_GetCell_112(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  vtkCell * temp20;
  temp0 = id0;

  vtkStructuredGrid* op = static_cast<vtkStructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCell(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkStructuredGrid_GetCell_113(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2)
{
  int   temp0;
  int   temp1;
  int   temp2;
  vtkCell * temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkStructuredGrid* op = static_cast<vtkStructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCell(temp0,temp1,temp2);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStructuredGrid_GetCell_114(JNIEnv* env, jobject obj,jlong id0,jobject id1)
{
  long long   temp0;
  vtkGenericCell * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkGenericCell*>(vtkJavaGetPointerFromObject(env, id1));

  vtkStructuredGrid* op = static_cast<vtkStructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetCell(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStructuredGrid_GetCellBounds_115(JNIEnv* env, jobject obj,jlong id0,jdoubleArray id1)
{
  long long   temp0;
  double temp1[6];
  temp0 = id0;
  env->GetDoubleArrayRegion(id1, 0, 6, &temp1[0]);

  vtkStructuredGrid* op = static_cast<vtkStructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetCellBounds(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 6, &temp1[0]);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkStructuredGrid_GetCellType_116(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  int   temp20;
  temp0 = id0;

  vtkStructuredGrid* op = static_cast<vtkStructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellType(temp0);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkStructuredGrid_GetCellSize_117(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  long long   temp20;
  temp0 = id0;

  vtkStructuredGrid* op = static_cast<vtkStructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellSize(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStructuredGrid_GetCellPoints_118(JNIEnv* env, jobject obj,jlong id0,jobject id1)
{
  long long   temp0;
  vtkIdList * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id1));

  vtkStructuredGrid* op = static_cast<vtkStructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetCellPoints(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStructuredGrid_GetPointCells_119(JNIEnv* env, jobject obj,jlong id0,jobject id1)
{
  long long   temp0;
  vtkIdList * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id1));

  vtkStructuredGrid* op = static_cast<vtkStructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetPointCells(temp0,temp1);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkStructuredGrid_GetMaxCellSize_120(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkStructuredGrid* op = static_cast<vtkStructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaxCellSize();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkStructuredGrid_GetMaxSpatialDimension_121(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkStructuredGrid* op = static_cast<vtkStructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaxSpatialDimension();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkStructuredGrid_GetMinSpatialDimension_122(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkStructuredGrid* op = static_cast<vtkStructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMinSpatialDimension();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStructuredGrid_GetCellNeighbors_123(JNIEnv* env, jobject obj,jlong id0,jobject id1,jobject id2)
{
  long long   temp0;
  vtkIdList * temp1;
  vtkIdList * temp2;
  temp0 = id0;
  temp1 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id2));

  vtkStructuredGrid* op = static_cast<vtkStructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetCellNeighbors(temp0,temp1,temp2);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkStructuredGrid_GetCells_124(JNIEnv* env, jobject obj)
{
  vtkStructuredCellArray * temp20;

  vtkStructuredGrid* op = static_cast<vtkStructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCells();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStructuredGrid_BlankPoint_125(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  temp0 = id0;

  vtkStructuredGrid* op = static_cast<vtkStructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->BlankPoint(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStructuredGrid_UnBlankPoint_126(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  temp0 = id0;

  vtkStructuredGrid* op = static_cast<vtkStructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->UnBlankPoint(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStructuredGrid_BlankCell_127(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  temp0 = id0;

  vtkStructuredGrid* op = static_cast<vtkStructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->BlankCell(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStructuredGrid_UnBlankCell_128(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  temp0 = id0;

  vtkStructuredGrid* op = static_cast<vtkStructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->UnBlankCell(temp0);

}

extern "C" JNIEXPORT jbyte  JNICALL Java_vtk_vtkStructuredGrid_IsPointVisible_129(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
   unsigned char   temp20;
  temp0 = id0;

  vtkStructuredGrid* op = static_cast<vtkStructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsPointVisible(temp0);
  return temp20;

}

extern "C" JNIEXPORT jbyte  JNICALL Java_vtk_vtkStructuredGrid_IsCellVisible_130(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
   unsigned char   temp20;
  temp0 = id0;

  vtkStructuredGrid* op = static_cast<vtkStructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsCellVisible(temp0);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkStructuredGrid_HasAnyBlankPoints_131(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkStructuredGrid* op = static_cast<vtkStructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasAnyBlankPoints();
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkStructuredGrid_HasAnyBlankCells_132(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkStructuredGrid* op = static_cast<vtkStructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasAnyBlankCells();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkStructuredGrid_GetDataDescription_133(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkStructuredGrid* op = static_cast<vtkStructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataDescription();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStructuredGrid_GetCellDims_134(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[3];
  env->GetIntArrayRegion(id0, 0, 3, reinterpret_cast<jint*>(&temp0[0]));

  vtkStructuredGrid* op = static_cast<vtkStructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetCellDims(temp0);
  env->SetIntArrayRegion(id0, 0, 3, reinterpret_cast<jint*>(&temp0[0]));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStructuredGrid_SetDimensions_135(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2)
{
  int   temp0;
  int   temp1;
  int   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkStructuredGrid* op = static_cast<vtkStructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDimensions(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStructuredGrid_SetDimensions_136(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[3];
  env->GetIntArrayRegion(id0, 0, 3, reinterpret_cast<jint*>(&temp0[0]));

  vtkStructuredGrid* op = static_cast<vtkStructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDimensions(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStructuredGrid_GetDimensions_137(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[3];
  env->GetIntArrayRegion(id0, 0, 3, reinterpret_cast<jint*>(&temp0[0]));

  vtkStructuredGrid* op = static_cast<vtkStructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetDimensions(temp0);
  env->SetIntArrayRegion(id0, 0, 3, reinterpret_cast<jint*>(&temp0[0]));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkStructuredGrid_GetDataDimension_138(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkStructuredGrid* op = static_cast<vtkStructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataDimension();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStructuredGrid_SetExtent_139(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[6];
  env->GetIntArrayRegion(id0, 0, 6, reinterpret_cast<jint*>(&temp0[0]));

  vtkStructuredGrid* op = static_cast<vtkStructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetExtent(temp0);
  env->SetIntArrayRegion(id0, 0, 6, reinterpret_cast<jint*>(&temp0[0]));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStructuredGrid_SetExtent_140(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2,jint id3,jint id4,jint id5)
{
  int   temp0;
  int   temp1;
  int   temp2;
  int   temp3;
  int   temp4;
  int   temp5;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = id5;

  vtkStructuredGrid* op = static_cast<vtkStructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetExtent(temp0,temp1,temp2,temp3,temp4,temp5);

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkStructuredGrid_GetExtent_141(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkStructuredGrid* op = static_cast<vtkStructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetExtent();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 6);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkStructuredGrid_GetActualMemorySize_142(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkStructuredGrid* op = static_cast<vtkStructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetActualMemorySize();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStructuredGrid_ShallowCopy_143(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataObject * temp0;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkStructuredGrid* op = static_cast<vtkStructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->ShallowCopy(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStructuredGrid_DeepCopy_144(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataObject * temp0;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkStructuredGrid* op = static_cast<vtkStructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->DeepCopy(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkStructuredGrid_GetExtentType_145(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkStructuredGrid* op = static_cast<vtkStructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetExtentType();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkStructuredGrid_GetData_146(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformation * temp0;
  vtkStructuredGrid * temp20;
  temp0 = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, id0));

  vtkStructuredGrid* op = static_cast<vtkStructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetData(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkStructuredGrid_GetData_147(JNIEnv* env, jobject obj,jobject id0,jint id1)
{
  vtkInformationVector * temp0;
  int   temp1;
  vtkStructuredGrid * temp20;
  temp0 = static_cast<vtkInformationVector*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;

  vtkStructuredGrid* op = static_cast<vtkStructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetData(temp0,temp1);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStructuredGrid_GetPoint_148(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2,jdoubleArray id3,jboolean id4)
{
  int   temp0;
  int   temp1;
  int   temp2;
  double temp3[3];
  bool   temp4;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  env->GetDoubleArrayRegion(id3, 0, 3, &temp3[0]);
  temp4 = (id4 != 0) ? true : false;

  vtkStructuredGrid* op = static_cast<vtkStructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetPoint(temp0,temp1,temp2,temp3,temp4);
  env->SetDoubleArrayRegion(id3, 0, 3, &temp3[0]);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkStructuredGrid_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkStructuredGrid::New());
}
