// java wrapper for vtkObject object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkObject.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkObjectBase_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkObject_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkObject",dType)) { return me; }
  if ((res= vtkObjectBase_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkObject_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkObject* op = static_cast<vtkObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkObject_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkObject* op = static_cast<vtkObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkObject_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkObject* op = static_cast<vtkObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkObject_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkObject* op = static_cast<vtkObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkObject_DebugOn_14(JNIEnv* env, jobject obj)
{

  vtkObject* op = static_cast<vtkObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->DebugOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkObject_DebugOff_15(JNIEnv* env, jobject obj)
{

  vtkObject* op = static_cast<vtkObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->DebugOff();

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkObject_GetDebug_16(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkObject* op = static_cast<vtkObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDebug();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkObject_SetDebug_17(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkObject* op = static_cast<vtkObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDebug(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkObject_BreakOnError_18(JNIEnv* env, jobject obj)
{

  vtkObject* op = static_cast<vtkObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->BreakOnError();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkObject_Modified_19(JNIEnv* env, jobject obj)
{

  vtkObject* op = static_cast<vtkObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->Modified();

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkObject_GetMTime_110(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkObject* op = static_cast<vtkObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMTime();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkObject_SetGlobalWarningDisplay_111(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkObject* op = static_cast<vtkObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetGlobalWarningDisplay(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkObject_GlobalWarningDisplayOn_112(JNIEnv* env, jobject obj)
{

  vtkObject* op = static_cast<vtkObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->GlobalWarningDisplayOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkObject_GlobalWarningDisplayOff_113(JNIEnv* env, jobject obj)
{

  vtkObject* op = static_cast<vtkObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->GlobalWarningDisplayOff();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkObject_GetGlobalWarningDisplay_114(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkObject* op = static_cast<vtkObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGlobalWarningDisplay();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkObject_RemoveObserver_115(JNIEnv* env, jobject obj,jlong id0)
{
   unsigned long   temp0;
  temp0 = id0;

  vtkObject* op = static_cast<vtkObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveObserver(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkObject_RemoveObservers_116(JNIEnv* env, jobject obj,jlong id0)
{
   unsigned long   temp0;
  temp0 = id0;

  vtkObject* op = static_cast<vtkObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveObservers(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkObject_RemoveObservers_117(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkObject* op = static_cast<vtkObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveObservers(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkObject_RemoveAllObservers_118(JNIEnv* env, jobject obj)
{

  vtkObject* op = static_cast<vtkObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveAllObservers();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkObject_HasObserver_119(JNIEnv* env, jobject obj,jlong id0)
{
   unsigned long   temp0;
  int   temp20;
  temp0 = id0;

  vtkObject* op = static_cast<vtkObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasObserver(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkObject_HasObserver_120(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkObject* op = static_cast<vtkObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasObserver(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkObject_InvokeEvent_121(JNIEnv* env, jobject obj,jlong id0)
{
   unsigned long   temp0;
  int   temp20;
  temp0 = id0;

  vtkObject* op = static_cast<vtkObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->InvokeEvent(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkObject_InvokeEvent_122(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkObject* op = static_cast<vtkObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->InvokeEvent(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkObject_SetObjectName_123(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  std::string temp0;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);

  vtkObject* op = static_cast<vtkObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetObjectName(temp0);

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkObject_GetObjectName_124(JNIEnv* env, jobject obj)
{
  std::string   temp20;

  vtkObject* op = static_cast<vtkObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetObjectName();
  return vtkJavaStringToUTF8(env, temp20);

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkObject_GetObjectDescription_125(JNIEnv* env, jobject obj)
{
  std::string   temp20;

  vtkObject* op = static_cast<vtkObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetObjectDescription();
  return vtkJavaStringToUTF8(env, temp20);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkObject_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkObject::New());
}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkObject_AddObserver(JNIEnv* env, jobject obj, jbyteArray id0, jint len0, jobject id1, jbyteArray id2, jint len2)
{
  vtkJavaCommand* command = vtkJavaCommand::New();
  command->AssignJavaVM(env);
  command->SetGlobalRef(env->NewGlobalRef(id1));
  char* handler = vtkJavaUTF8ToChars(env, id2, len2);
  jclass classtype = env->GetObjectClass(id1);
  command->SetMethodID(env->GetMethodID(classtype, handler,"()V"));
  delete[] handler;
  char* event = vtkJavaUTF8ToChars(env, id0, len0);
  vtkObject* op = static_cast<vtkObject*>(vtkJavaGetPointerFromObject(env, obj));
  unsigned long result = op->AddObserver(event, command);
  delete[] event;
  command->Delete();
  return result;
}
