// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
#include "vtkCellGridShaderBases.h"

const char *vtkCellGridShaderBases =
"// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen\n"
"// SPDX-License-Identifier: BSD-3-Clause\n"
"\n"
"// NB: The functions named NoneXxxI0_basisAt() are dummy functions used when\n"
"// not coloring by a field. They are never called.\n"
"\n"
"// Forward-declare the \"generic\" shape gradient so that specializations of\n"
"// {{ShapeName}}_normalToSideAt() can call it. This way things will just\n"
"// work, even with curved elements.\n"
"void shapeGradientAt(in vec3 param, in float coeff[{ShapeCoeffPerCell}], out vec3 dxdr, out vec3 dxds, out vec3 dxdt);\n"
"\n"
"#define RealT float\n"
"\n"
"#ifdef SHAPE_pyramid\n"
"int pyramid_axisPermutationForSide(in int side)\n"
"{{\n"
"  switch(side)\n"
"  {{\n"
"  case 0: return 2; // (+r, +t) = -S\n"
"  case 1: return 1; // (+s, +t) = +R\n"
"  case 2: return 3; // (-r, +t) = +S\n"
"  case 3: return 0; // (-s, +t) = -R\n"
"  case 4: return 4; // (-r, -s) = -T\n"
"  // case 5: return 5; // (+r, +s) = +T\n"
"  // case 1: return 6; // (-r+s,-r-s+t) = +RST\n"
"  // case 2: return 0; // (-s, +t) = -R\n"
"  // case 3: return 4; // (-r, -s) = -T\n"
"  }}\n"
"}}\n"
"\n"
"vec3 pyramid_normalToSideAt(in int sideId, in float shapeVals[{ShapeCoeffPerCell}], in vec3 rst, in vec3 cameraVector)\n"
"{{\n"
"  vec3 dxdr;\n"
"  vec3 dxds;\n"
"  vec3 dxdt;\n"
"  vec3 nn;\n"
"  shapeGradientAt(rst, shapeVals, dxdr, dxds, dxdt);\n"
"  vec3 corners[5];\n"
"  if (sideId < 4)\n"
"  {{\n"
"    for (int ii = 0; ii < 5; ++ii)\n"
"    {{\n"
"      corners[ii] = vec3(shapeVals[ii * 3], shapeVals[ii * 3 + 1], shapeVals[ii * 3 + 2]);\n"
"    }}\n"
"  }}\n"
"  switch (sideId)\n"
"  {{\n"
"  // Triangles\n"
"#if 0\n"
"     // NB: These work for a linear pyramid but will not compute normals for higher-order pyramids.\n"
"  case  0: nn = cross(corners[1] - corners[0], corners[4] - corners[0]); break;\n"
"  case  1: nn = cross(corners[2] - corners[1], corners[4] - corners[1]); break;\n"
"  case  2: nn = cross(corners[3] - corners[2], corners[4] - corners[2]); break;\n"
"  case  3: nn = cross(corners[0] - corners[3], corners[4] - corners[3]); break;\n"
"#else\n"
"     // NB: These would work in theory for higher-order pyramids, but fail due to a degeneracy in the parameter space.\n"
"  case  0: nn = cross( dxdr,  dxds + 0.5 * dxdt); break; // -S -dxds + dxdt  cross(dxdr, dxdt)\n"
"  case  1: nn = cross( dxds, -dxdr + 0.5 * dxdt); break; // +R  dxdr + dxdt  cross(dxds, dxdt)\n"
"  case  2: nn = cross(-dxdr, -dxds + 0.5 * dxdt); break; // +S  dxds + dxdt  cross(dxdt, dxdr)\n"
"  case  3: nn = cross(-dxds,  dxdr + 0.5 * dxdt); break; // -R -dxdr + dxdt  cross(dxdt, dxds)\n"
"#endif\n"
"  // Quadrilateral\n"
"  case  4: nn = cross(dxds, dxdr); break; // -T\n"
"  // Edges and vertices should not be shaded.\n"
"  default: nn = cameraVector; break;\n"
"  }}\n"
"  return normalize(nn);\n"
"}}\n"
"\n"
"void NonePyrI0_basisAt(in vec3 param, out float[1] basis) {{ }}\n"
"void NonePyrC1_basisAt(in vec3 param, out float[1] basis) {{ }}\n"
"#endif /* SHAPE_pyramid */\n"
"\n"
"#ifdef SHAPE_wedge\n"
"int wedge_axisPermutationForSide(in int side)\n"
"{{\n"
"  switch(side)\n"
"  {{\n"
"  case 0: return 2; // (+r, +t) = -S\n"
"  case 1: return 6; // (-r+s, +t) = +RS\n"
"  case 2: return 0; // (-s, +t) = -R\n"
"  case 3: return 4; // (-r, -s) = -T\n"
"  case 4: return 5; // (+r, +s) = +T\n"
"  }}\n"
"}}\n"
"\n"
"vec3 wedge_normalToSideAt(in int sideId, in float shapeVals[{ShapeCoeffPerCell}], in vec3 rst, in vec3 cameraVector)\n"
"{{\n"
"  vec3 dxdr;\n"
"  vec3 dxds;\n"
"  vec3 dxdt;\n"
"  vec3 nn;\n"
"  shapeGradientAt(rst, shapeVals, dxdr, dxds, dxdt);\n"
"  switch (sideId)\n"
"  {{\n"
"  // Quadrilaterals\n"
"  case 0: nn = cross(dxdr, dxdt); break; // -S\n"
"  case 1: nn = cross(dxds - dxdr, dxdt); break; // +RS\n"
"  case 2: nn = cross(dxdt, dxds); break; // -R\n"
"  // Triangles\n"
"  case 3: nn = cross(dxds, dxdr); break; // -T\n"
"  case 4: nn = cross(dxdr, dxds); break; // +T\n"
"  // Edges and vertices should not be shaded.\n"
"  default: nn = cameraVector; break;\n"
"  }}\n"
"  return normalize(nn);\n"
"}}\n"
"\n"
"void NoneWdgI0_basisAt(in vec3 param, out float[1] basis) {{ }}\n"
"void NoneWdgC1_basisAt(in vec3 param, out float[1] basis) {{ }}\n"
"#endif /* SHAPE_wedge */\n"
"\n"
"#ifdef SHAPE_hexahedron\n"
"int hexahedron_axisPermutationForSide(in int side)\n"
"{{\n"
"  switch(side)\n"
"  {{\n"
"  case 0: return 2; // (+r, +t) = -S\n"
"  case 1: return 1; // (+s, +t) = +R\n"
"  case 2: return 3; // (-r, +t) = +S\n"
"  case 3: return 0; // (-s, +t) = -R\n"
"  case 4: return 4; // (-r, -s) = -T\n"
"  case 5: return 5; // (+r, +s) = +T\n"
"  // case 1: return 6; // (-r+s,-r-s+t) = +RST\n"
"  // case 2: return 0; // (-s, +t) = -R\n"
"  // case 3: return 4; // (-r, -s) = -T\n"
"  }}\n"
"}}\n"
"\n"
"vec3 hexahedron_normalToSideAt(in int sideId, in float shapeVals[{ShapeCoeffPerCell}], in vec3 rst, in vec3 cameraVector)\n"
"{{\n"
"  vec3 dxdr;\n"
"  vec3 dxds;\n"
"  vec3 dxdt;\n"
"  vec3 nn;\n"
"  shapeGradientAt(rst, shapeVals, dxdr, dxds, dxdt);\n"
"  switch (sideId)\n"
"  {{\n"
"  // Quadrilaterals\n"
"  case  0: nn = cross(dxdr, dxdt); break; // -S\n"
"  case  1: nn = cross(dxds, dxdt); break; // +R\n"
"  case  2: nn = cross(dxdt, dxdr); break; // +S\n"
"  case  3: nn = cross(dxdt, dxds); break; // -R\n"
"  case  4: nn = cross(dxds, dxdr); break; // -T\n"
"  case  5: nn = cross(dxdr, dxds); break; // +T\n"
"  // Edges and vertices should be rendered without shading.\n"
"  default: nn = cameraVector; break;\n"
"  }}\n"
"  return normalize(nn);\n"
"}}\n"
"\n"
"void NoneHexI0_basisAt(in vec3 param, out float[1] basis) {{ }}\n"
"void NoneHexC1_basisAt(in vec3 param, out float[1] basis) {{ }}\n"
"#endif /* SHAPE_hexahedron */\n"
"\n"
"#ifdef SHAPE_tetrahedron\n"
"int tetrahedron_axisPermutationForSide(in int side)\n"
"{{\n"
"  switch(side)\n"
"  {{\n"
"  case 0: return 2; // (+r, +t) = -S\n"
"  case 1: return 6; // (-r+s,-r-s+t) = +RST\n"
"  case 2: return 0; // (-s, +t) = -R\n"
"  case 3: return 4; // (-r, -s) = -T\n"
"  }}\n"
"}}\n"
"\n"
"vec3 tetrahedron_normalToSideAt(in int sideId, in float shapeVals[{ShapeCoeffPerCell}], in vec3 rst, in vec3 cameraVector)\n"
"{{\n"
"  vec3 dxdr;\n"
"  vec3 dxds;\n"
"  vec3 dxdt;\n"
"  vec3 nn;\n"
"  shapeGradientAt(rst, shapeVals, dxdr, dxds, dxdt);\n"
"  switch (sideId)\n"
"  {{\n"
"  // Triangles\n"
"  case  0: nn = cross(dxdr, dxdt); break; // -S\n"
"  case  1: nn = cross(-dxdr + dxds, dxdt - dxdr); break; // +RS\n"
"  case  2: nn = cross(dxdt, dxds); break; // -R\n"
"  case  3: nn = cross(dxds, dxdr); break; // -T\n"
"  // Edges and vertices should not be shaded.\n"
"  default: nn = cameraVector; break;\n"
"  }}\n"
"  return normalize(nn);\n"
"}}\n"
"\n"
"void NoneTetI0_basisAt(in vec3 param, out float[1] basis) {{ }}\n"
"void NoneTetC1_basisAt(in vec3 param, out float[1] basis) {{ }}\n"
"#endif /* SHAPE_tetrahedron */\n"
"\n"
"#ifdef SHAPE_quadrilateral\n"
"int quadrilateral_axisPermutationForSide(in int side)\n"
"{{\n"
"  switch(side)\n"
"  {{\n"
"  case -1: return 5; // (+r, +s) = +T (rendering the cell itself)\n"
"  case 0: return 2; // (+r, +t) = -S\n"
"  case 1: return 1; // (+s, +t) = +R\n"
"  case 2: return 3; // (-r, +t) = +S\n"
"  case 3: return 0; // (-s, +t) = -R\n"
"  // case 4: return 4; // (-r, -s) = -T\n"
"  // case 5: return 5; // (+r, +s) = +T\n"
"  // case 1: return 6; // (-r+s,-r-s+t) = +RST\n"
"  // case 2: return 0; // (-s, +t) = -R\n"
"  // case 3: return 4; // (-r, -s) = -T\n"
"  }}\n"
"}}\n"
"\n"
"vec3 quadrilateral_normalToSideAt(in int sideId, in float shapeVals[{ShapeCoeffPerCell}], in vec3 rst, in vec3 cameraVector)\n"
"{{\n"
"  vec3 dxdr;\n"
"  vec3 dxds;\n"
"  vec3 dxdt; // Note this should always be zero.\n"
"  vec3 nn;\n"
"  shapeGradientAt(rst, shapeVals, dxdr, dxds, dxdt);\n"
"  switch (sideId)\n"
"  {{\n"
"  // Self\n"
"  case -1: nn = cross(dxdr, dxds); break; // +T\n"
"  // Edges and vertices should not be shaded.\n"
"  default: nn = cameraVector; break;\n"
"  }}\n"
"  return normalize(nn);\n"
"}}\n"
"void NoneQuadI0_basisAt(in vec3 param, out float[1] basis) {{ }}\n"
"void NoneQuadC1_basisAt(in vec3 param, out float[1] basis) {{ }}\n"
"#endif /* SHAPE_quadrilateral */\n"
"\n"
"#ifdef SHAPE_triangle\n"
"int triangle_axisPermutationForSide(in int side)\n"
"{{\n"
"  switch(side)\n"
"  {{\n"
"  case -1: return 5; // (+r, +s) = +T (normal to triangle itself)\n"
"  case 0: return 2; // (+r, +t) = -S\n"
"  case 1: return 6; // (-r+s,-r-s) = +RS (T)\n"
"  case 2: return 0; // (-s, +t) = -R\n"
"  // case 3: return 4; // (-r, -s) = -T\n"
"  }}\n"
"}}\n"
"\n"
"vec3 triangle_normalToSideAt(in int sideId, in float shapeVals[{ShapeCoeffPerCell}], in vec3 rst, in vec3 cameraVector)\n"
"{{\n"
"  vec3 dxdr;\n"
"  vec3 dxds;\n"
"  vec3 dxdt; // This will always be zero.\n"
"  vec3 nn;\n"
"  shapeGradientAt(rst, shapeVals, dxdr, dxds, dxdt);\n"
"  switch (sideId)\n"
"  {{\n"
"  // Self\n"
"  case -1: nn = cross(dxdr, dxds); break; // +T\n"
"  // Edges and vertices should not be shaded.\n"
"  default: nn = cameraVector; break;\n"
"  }}\n"
"  return normalize(nn);\n"
"}}\n"
"\n"
"void NoneTriI0_basisAt(in vec3 param, out float[1] basis) {{ }}\n"
"void NoneTriC1_basisAt(in vec3 param, out float[1] basis) {{ }}\n"
"#endif /* SHAPE_triangle */\n"
"\n"
"#ifdef SHAPE_edge\n"
"int edge_axisPermutationForSide(in int side)\n"
"{{\n"
"  if (side < 0) {{ return 7; }} // Camera-facing normal.\n"
"  return side; // side 0 = -R (0), side 1 = +R (1)\n"
"}}\n"
"\n"
"vec3 edge_normalToSideAt(in int sideId, in float shapeVals[{ShapeCoeffPerCell}], in vec3 rst, in vec3 cameraVector)\n"
"{{\n"
"  return normalize(cameraVector);\n"
"}}\n"
"\n"
"void NoneEdgeI0_basisAt(in vec3 param, out float[1] basis) {{ }}\n"
"void NoneEdgeC1_basisAt(in vec3 param, out float[1] basis) {{ }}\n"
"#endif /* SHAPE_edge */\n"
"\n"
"#ifdef SHAPE_vertex\n"
"int vertex_axisPermutationForSide(in int side)\n"
"{{\n"
"  return 7; // Camera-facing normal\n"
"}}\n"
"\n"
"vec3 vertex_normalToSideAt(in int sideId, in float shapeVals[{ShapeCoeffPerCell}], in vec3 rst, in vec3 cameraVector)\n"
"{{\n"
"  vec3 nn;\n"
"  nn = cameraVector;\n"
"  return normalize(nn);\n"
"}}\n"
"\n"
"void NoneVertI0_basisAt(in vec3 param, out float[1] basis) {{ }}\n"
"void NoneVertC1_basisAt(in vec3 param, out float[1] basis) {{ }}\n"
"#endif /* SHAPE_vertex */\n"
"";
