// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
#include "Basis_HGrad_PyrI2Basis.h"

const char *Basis_HGrad_PyrI2Basis =
"if (abs(tt - 1.0) < eps)\n"
"{\n"
"  if (tt <= 1.0)\n"
"  {\n"
"    tt = 1.0 - eps;\n"
"  }\n"
"  else\n"
"  {\n"
"    tt = 1.0 + eps;\n"
"  }\n"
"}\n"
"\n"
"RealT ww = 1.0 / (1.0 - tt);\n"
"\n"
"basis[0] = 0.25 * (-rr - ss - 1.0) * ((1.0 - rr) * (1.0 - ss) - tt + rr * ss * tt * ww);\n"
"basis[1] = 0.25 * (rr - ss - 1.0) * ((1.0 + rr) * (1.0 - ss) - tt - rr * ss * tt * ww);\n"
"basis[2] = 0.25 * (rr + ss - 1.0) * ((1.0 + rr) * (1.0 + ss) - tt + rr * ss * tt * ww);\n"
"basis[3] = 0.25 * (-rr + ss - 1.0) * ((1.0 - rr) * (1.0 + ss) - tt - rr * ss * tt * ww);\n"
"\n"
"basis[4] = tt * (2.0 * tt - 1.0);\n"
"\n"
"basis[5] = 0.5 * (1.0 + rr - tt) * (1.0 - rr - tt) * (1.0 - ss - tt) * ww;\n"
"basis[6] = 0.5 * (1.0 + ss - tt) * (1.0 - ss - tt) * (1.0 + rr - tt) * ww;\n"
"basis[7] = 0.5 * (1.0 + rr - tt) * (1.0 - rr - tt) * (1.0 + ss - tt) * ww;\n"
"basis[8] = 0.5 * (1.0 + ss - tt) * (1.0 - ss - tt) * (1.0 - rr - tt) * ww;\n"
"\n"
"basis[9] = tt * (1.0 - rr - tt) * (1.0 - ss - tt) * ww;\n"
"basis[10] = tt * (1.0 + rr - tt) * (1.0 - ss - tt) * ww;\n"
"basis[11] = tt * (1.0 + rr - tt) * (1.0 + ss - tt) * ww;\n"
"basis[12] = tt * (1.0 - rr - tt) * (1.0 + ss - tt) * ww;\n"
"";
