// python wrapper for vtkPPixelTransfer
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkPPixelTransfer.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkPPixelTransfer(PyObject *dict); }

static PyObject *
PyvtkPPixelTransfer_SetSourceRank(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSourceRank");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkPPixelTransfer *op = static_cast<vtkPPixelTransfer *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    op->SetSourceRank(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPPixelTransfer_GetSourceRank(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSourceRank");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkPPixelTransfer *op = static_cast<vtkPPixelTransfer *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = op->GetSourceRank();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPPixelTransfer_SetDestinationRank(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDestinationRank");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkPPixelTransfer *op = static_cast<vtkPPixelTransfer *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    op->SetDestinationRank(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPPixelTransfer_GetDestinationRank(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDestinationRank");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkPPixelTransfer *op = static_cast<vtkPPixelTransfer *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = op->GetDestinationRank();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPPixelTransfer_Sender(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Sender");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkPPixelTransfer *op = static_cast<vtkPPixelTransfer *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    bool tempr = op->Sender(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPPixelTransfer_Receiver(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Receiver");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkPPixelTransfer *op = static_cast<vtkPPixelTransfer *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    bool tempr = op->Receiver(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPPixelTransfer_Local(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Local");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkPPixelTransfer *op = static_cast<vtkPPixelTransfer *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    bool tempr = op->Local(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPPixelTransfer_SetSourceWholeExtent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSourceWholeExtent");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkPPixelTransfer *op = static_cast<vtkPPixelTransfer *>(vp);

  vtkPixelExtent *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetSpecialObject(temp0, "vtkPixelExtent"))
  {
    op->SetSourceWholeExtent(*temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPPixelTransfer_GetSourceWholeExtent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSourceWholeExtent");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkPPixelTransfer *op = static_cast<vtkPPixelTransfer *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkPixelExtent *tempr = &op->GetSourceWholeExtent();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildSpecialObject(tempr, "vtkPixelExtent");
    }
  }

  return result;
}


static PyObject *
PyvtkPPixelTransfer_SetSourceExtent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSourceExtent");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkPPixelTransfer *op = static_cast<vtkPPixelTransfer *>(vp);

  vtkPixelExtent *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetSpecialObject(temp0, "vtkPixelExtent"))
  {
    op->SetSourceExtent(*temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPPixelTransfer_GetSourceExtent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSourceExtent");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkPPixelTransfer *op = static_cast<vtkPPixelTransfer *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkPixelExtent *tempr = &op->GetSourceExtent();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildSpecialObject(tempr, "vtkPixelExtent");
    }
  }

  return result;
}


static PyObject *
PyvtkPPixelTransfer_SetDestinationWholeExtent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDestinationWholeExtent");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkPPixelTransfer *op = static_cast<vtkPPixelTransfer *>(vp);

  vtkPixelExtent *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetSpecialObject(temp0, "vtkPixelExtent"))
  {
    op->SetDestinationWholeExtent(*temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPPixelTransfer_GetDestinationWholeExtent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDestinationWholeExtent");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkPPixelTransfer *op = static_cast<vtkPPixelTransfer *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkPixelExtent *tempr = &op->GetDestinationWholeExtent();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildSpecialObject(tempr, "vtkPixelExtent");
    }
  }

  return result;
}


static PyObject *
PyvtkPPixelTransfer_SetDestinationExtent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDestinationExtent");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkPPixelTransfer *op = static_cast<vtkPPixelTransfer *>(vp);

  vtkPixelExtent *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetSpecialObject(temp0, "vtkPixelExtent"))
  {
    op->SetDestinationExtent(*temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPPixelTransfer_GetDestinationExtent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDestinationExtent");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkPPixelTransfer *op = static_cast<vtkPPixelTransfer *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkPixelExtent *tempr = &op->GetDestinationExtent();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildSpecialObject(tempr, "vtkPixelExtent");
    }
  }

  return result;
}


static PyObject *
PyvtkPPixelTransfer_SetTransactionId(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTransactionId");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkPPixelTransfer *op = static_cast<vtkPPixelTransfer *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    op->SetTransactionId(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPPixelTransfer_GetTransactionId(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTransactionId");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkPPixelTransfer *op = static_cast<vtkPPixelTransfer *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = op->GetTransactionId();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPPixelTransfer_SetUseBlockingSend(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUseBlockingSend");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkPPixelTransfer *op = static_cast<vtkPPixelTransfer *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    op->SetUseBlockingSend(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPPixelTransfer_GetUseBlockingSend(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetUseBlockingSend");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkPPixelTransfer *op = static_cast<vtkPPixelTransfer *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = op->GetUseBlockingSend();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPPixelTransfer_SetUseBlockingRecv(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUseBlockingRecv");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkPPixelTransfer *op = static_cast<vtkPPixelTransfer *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    op->SetUseBlockingRecv(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPPixelTransfer_GetUseBlockingRecv(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetUseBlockingRecv");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkPPixelTransfer *op = static_cast<vtkPPixelTransfer *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = op->GetUseBlockingRecv();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPPixelTransfer_Blit(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Blit");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkPPixelTransfer *op = static_cast<vtkPPixelTransfer *>(vp);

  int temp0;
  int temp1;
  void  *temp2 = nullptr;
  Py_buffer pbuf2 = { nullptr, nullptr, 0, 0, 0, 0, nullptr, nullptr, nullptr, nullptr, nullptr };
  int temp3;
  void  *temp4 = nullptr;
  Py_buffer pbuf4 = { nullptr, nullptr, 0, 0, 0, 0, nullptr, nullptr, nullptr, nullptr, nullptr };
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(5) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetBuffer(temp2, &pbuf2) &&
      ap.GetValue(temp3) &&
      ap.GetBuffer(temp4, &pbuf4))
  {
    int tempr = op->Blit(temp0, temp1, temp2, temp3, temp4);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  if (pbuf2.obj != nullptr)
  {
    PyBuffer_Release(&pbuf2);
  }
  if (pbuf4.obj != nullptr)
  {
    PyBuffer_Release(&pbuf4);
  }
  return result;
}

static PyMethodDef PyvtkPPixelTransfer_Methods[] = {
  {"SetSourceRank", PyvtkPPixelTransfer_SetSourceRank, METH_VARARGS,
   "SetSourceRank(self, rank:int) -> None\nC++: void SetSourceRank(int rank)\n\nSet/Get the MPI rank of source and destination processes.\n"},
  {"GetSourceRank", PyvtkPPixelTransfer_GetSourceRank, METH_VARARGS,
   "GetSourceRank(self) -> int\nC++: int GetSourceRank()\n\n"},
  {"SetDestinationRank", PyvtkPPixelTransfer_SetDestinationRank, METH_VARARGS,
   "SetDestinationRank(self, rank:int) -> None\nC++: void SetDestinationRank(int rank)\n\n"},
  {"GetDestinationRank", PyvtkPPixelTransfer_GetDestinationRank, METH_VARARGS,
   "GetDestinationRank(self) -> int\nC++: int GetDestinationRank()\n\n"},
  {"Sender", PyvtkPPixelTransfer_Sender, METH_VARARGS,
   "Sender(self, rank:int) -> bool\nC++: bool Sender(int rank)\n\nTests to determine a given rank's role in this transaction. If\nboth Sender and Receiver are true then the operation is local and\nno mpi calls are made.\n"},
  {"Receiver", PyvtkPPixelTransfer_Receiver, METH_VARARGS,
   "Receiver(self, rank:int) -> bool\nC++: bool Receiver(int rank)\n\n"},
  {"Local", PyvtkPPixelTransfer_Local, METH_VARARGS,
   "Local(self, rank:int) -> bool\nC++: bool Local(int rank)\n\n"},
  {"SetSourceWholeExtent", PyvtkPPixelTransfer_SetSourceWholeExtent, METH_VARARGS,
   "SetSourceWholeExtent(self, srcExt:vtkPixelExtent) -> None\nC++: void SetSourceWholeExtent(vtkPixelExtent &srcExt)\n\nSet/Get the source extent. This is the extent of the array that\ndata will be copied from.\n"},
  {"GetSourceWholeExtent", PyvtkPPixelTransfer_GetSourceWholeExtent, METH_VARARGS,
   "GetSourceWholeExtent(self) -> vtkPixelExtent\nC++: vtkPixelExtent &GetSourceWholeExtent()\n\n"},
  {"SetSourceExtent", PyvtkPPixelTransfer_SetSourceExtent, METH_VARARGS,
   "SetSourceExtent(self, srcExt:vtkPixelExtent) -> None\nC++: void SetSourceExtent(vtkPixelExtent &srcExt)\n\nSet/Get the source extent. This is the subset extent in the array\nthat data will be copied from.\n"},
  {"GetSourceExtent", PyvtkPPixelTransfer_GetSourceExtent, METH_VARARGS,
   "GetSourceExtent(self) -> vtkPixelExtent\nC++: vtkPixelExtent &GetSourceExtent()\n\n"},
  {"SetDestinationWholeExtent", PyvtkPPixelTransfer_SetDestinationWholeExtent, METH_VARARGS,
   "SetDestinationWholeExtent(self, destExt:vtkPixelExtent) -> None\nC++: void SetDestinationWholeExtent(vtkPixelExtent &destExt)\n\nSet/get the destination extent. This is the extent of array that\nwill recveive the data.\n"},
  {"GetDestinationWholeExtent", PyvtkPPixelTransfer_GetDestinationWholeExtent, METH_VARARGS,
   "GetDestinationWholeExtent(self) -> vtkPixelExtent\nC++: vtkPixelExtent &GetDestinationWholeExtent()\n\n"},
  {"SetDestinationExtent", PyvtkPPixelTransfer_SetDestinationExtent, METH_VARARGS,
   "SetDestinationExtent(self, destExt:vtkPixelExtent) -> None\nC++: void SetDestinationExtent(vtkPixelExtent &destExt)\n\nSet/get the destination extent. This is the subset extent in the\narray that will recveive the data.\n"},
  {"GetDestinationExtent", PyvtkPPixelTransfer_GetDestinationExtent, METH_VARARGS,
   "GetDestinationExtent(self) -> vtkPixelExtent\nC++: vtkPixelExtent &GetDestinationExtent()\n\n"},
  {"SetTransactionId", PyvtkPPixelTransfer_SetTransactionId, METH_VARARGS,
   "SetTransactionId(self, id:int) -> None\nC++: void SetTransactionId(int id)\n\nSet/get the transaction id.\n"},
  {"GetTransactionId", PyvtkPPixelTransfer_GetTransactionId, METH_VARARGS,
   "GetTransactionId(self) -> int\nC++: int GetTransactionId()\n\n"},
  {"SetUseBlockingSend", PyvtkPPixelTransfer_SetUseBlockingSend, METH_VARARGS,
   "SetUseBlockingSend(self, val:int) -> None\nC++: void SetUseBlockingSend(int val)\n\nEnable/disable non-blocking communication\n"},
  {"GetUseBlockingSend", PyvtkPPixelTransfer_GetUseBlockingSend, METH_VARARGS,
   "GetUseBlockingSend(self) -> int\nC++: int GetUseBlockingSend()\n\n"},
  {"SetUseBlockingRecv", PyvtkPPixelTransfer_SetUseBlockingRecv, METH_VARARGS,
   "SetUseBlockingRecv(self, val:int) -> None\nC++: void SetUseBlockingRecv(int val)\n\n"},
  {"GetUseBlockingRecv", PyvtkPPixelTransfer_GetUseBlockingRecv, METH_VARARGS,
   "GetUseBlockingRecv(self) -> int\nC++: int GetUseBlockingRecv()\n\n"},
  {"Blit", PyvtkPPixelTransfer_Blit, METH_VARARGS,
   "Blit(self, nComps:int, srcType:int, srcData:Pointer, destType:int,\n     destData:Pointer) -> int\nC++: int Blit(int nComps, int srcType, void *srcData,\n    int destType, void *destData)\n\nBlock transfer for local memory to memory transfers, without\nusing mpi.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkPPixelTransfer_GetSets[] = {
  {
    /*name=*/pystr("source_rank"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPPixelTransfer_GetSourceRank(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPPixelTransfer_SetSourceRank(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPPixelTransfer_SetSourceRank(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetSourceRank/SetSourceRank\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("destination_rank"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPPixelTransfer_GetDestinationRank(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPPixelTransfer_SetDestinationRank(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPPixelTransfer_SetDestinationRank(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetDestinationRank/SetDestinationRank\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("source_whole_extent"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPPixelTransfer_SetSourceWholeExtent(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPPixelTransfer_SetSourceWholeExtent(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetSourceWholeExtent\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("source_extent"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPPixelTransfer_SetSourceExtent(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPPixelTransfer_SetSourceExtent(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetSourceExtent\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("destination_whole_extent"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPPixelTransfer_SetDestinationWholeExtent(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPPixelTransfer_SetDestinationWholeExtent(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetDestinationWholeExtent\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("destination_extent"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPPixelTransfer_SetDestinationExtent(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPPixelTransfer_SetDestinationExtent(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetDestinationExtent\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("transaction_id"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPPixelTransfer_GetTransactionId(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPPixelTransfer_SetTransactionId(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPPixelTransfer_SetTransactionId(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetTransactionId/SetTransactionId\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("use_blocking_send"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPPixelTransfer_GetUseBlockingSend(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPPixelTransfer_SetUseBlockingSend(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPPixelTransfer_SetUseBlockingSend(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetUseBlockingSend/SetUseBlockingSend\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("use_blocking_recv"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPPixelTransfer_GetUseBlockingRecv(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPPixelTransfer_SetUseBlockingRecv(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPPixelTransfer_SetUseBlockingRecv(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetUseBlockingRecv/SetUseBlockingRecv\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("source_whole_extent"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPPixelTransfer_GetSourceWholeExtent(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetSourceWholeExtent\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("source_whole_extent"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPPixelTransfer_GetSourceWholeExtent(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetSourceWholeExtent\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("source_extent"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPPixelTransfer_GetSourceExtent(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetSourceExtent\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("source_extent"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPPixelTransfer_GetSourceExtent(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetSourceExtent\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("destination_whole_extent"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPPixelTransfer_GetDestinationWholeExtent(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetDestinationWholeExtent\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("destination_whole_extent"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPPixelTransfer_GetDestinationWholeExtent(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetDestinationWholeExtent\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("destination_extent"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPPixelTransfer_GetDestinationExtent(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetDestinationExtent\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("destination_extent"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPPixelTransfer_GetDestinationExtent(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetDestinationExtent\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};

static PyObject *
PyvtkPPixelTransfer_vtkPPixelTransfer_s1(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "vtkPPixelTransfer");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkPPixelTransfer *op = new vtkPPixelTransfer();

    result = PyVTKSpecialObject_New("vtkPPixelTransfer", op);
  }

  return result;
}

static PyObject *
PyvtkPPixelTransfer_vtkPPixelTransfer_s2(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "vtkPPixelTransfer");

  int temp0;
  vtkPixelExtent *temp1 = nullptr;
  PyObject *pobj1 = nullptr;
  vtkPixelExtent *temp2 = nullptr;
  PyObject *pobj2 = nullptr;
  int temp3;
  vtkPixelExtent *temp4 = nullptr;
  PyObject *pobj4 = nullptr;
  vtkPixelExtent *temp5 = nullptr;
  PyObject *pobj5 = nullptr;
  int temp6 = 0;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(6, 7) &&
      ap.GetValue(temp0) &&
      ap.GetSpecialObject(temp1, pobj1, "vtkPixelExtent") &&
      ap.GetSpecialObject(temp2, pobj2, "vtkPixelExtent") &&
      ap.GetValue(temp3) &&
      ap.GetSpecialObject(temp4, pobj4, "vtkPixelExtent") &&
      ap.GetSpecialObject(temp5, pobj5, "vtkPixelExtent") &&
      (ap.NoArgsLeft() || ap.GetValue(temp6)))
  {
    vtkPPixelTransfer *op = new vtkPPixelTransfer(temp0, *temp1, *temp2, temp3, *temp4, *temp5, temp6);

    result = PyVTKSpecialObject_New("vtkPPixelTransfer", op);
  }

  Py_XDECREF(pobj1);
  Py_XDECREF(pobj2);
  Py_XDECREF(pobj4);
  Py_XDECREF(pobj5);

  return result;
}

static PyObject *
PyvtkPPixelTransfer_vtkPPixelTransfer_s3(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "vtkPPixelTransfer");

  int temp0;
  vtkPixelExtent *temp1 = nullptr;
  PyObject *pobj1 = nullptr;
  vtkPixelExtent *temp2 = nullptr;
  PyObject *pobj2 = nullptr;
  int temp3;
  vtkPixelExtent *temp4 = nullptr;
  PyObject *pobj4 = nullptr;
  int temp5;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(6) &&
      ap.GetValue(temp0) &&
      ap.GetSpecialObject(temp1, pobj1, "vtkPixelExtent") &&
      ap.GetSpecialObject(temp2, pobj2, "vtkPixelExtent") &&
      ap.GetValue(temp3) &&
      ap.GetSpecialObject(temp4, pobj4, "vtkPixelExtent") &&
      ap.GetValue(temp5))
  {
    vtkPPixelTransfer *op = new vtkPPixelTransfer(temp0, *temp1, *temp2, temp3, *temp4, temp5);

    result = PyVTKSpecialObject_New("vtkPPixelTransfer", op);
  }

  Py_XDECREF(pobj1);
  Py_XDECREF(pobj2);
  Py_XDECREF(pobj4);

  return result;
}

static PyObject *
PyvtkPPixelTransfer_vtkPPixelTransfer_s4(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "vtkPPixelTransfer");

  int temp0;
  int temp1;
  vtkPixelExtent *temp2 = nullptr;
  PyObject *pobj2 = nullptr;
  vtkPixelExtent *temp3 = nullptr;
  PyObject *pobj3 = nullptr;
  int temp4 = 0;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(4, 5) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetSpecialObject(temp2, pobj2, "vtkPixelExtent") &&
      ap.GetSpecialObject(temp3, pobj3, "vtkPixelExtent") &&
      (ap.NoArgsLeft() || ap.GetValue(temp4)))
  {
    vtkPPixelTransfer *op = new vtkPPixelTransfer(temp0, temp1, *temp2, *temp3, temp4);

    result = PyVTKSpecialObject_New("vtkPPixelTransfer", op);
  }

  Py_XDECREF(pobj2);
  Py_XDECREF(pobj3);

  return result;
}

static PyObject *
PyvtkPPixelTransfer_vtkPPixelTransfer_s5(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "vtkPPixelTransfer");

  int temp0;
  int temp1;
  vtkPixelExtent *temp2 = nullptr;
  PyObject *pobj2 = nullptr;
  int temp3 = 0;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(3, 4) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetSpecialObject(temp2, pobj2, "vtkPixelExtent") &&
      (ap.NoArgsLeft() || ap.GetValue(temp3)))
  {
    vtkPPixelTransfer *op = new vtkPPixelTransfer(temp0, temp1, *temp2, temp3);

    result = PyVTKSpecialObject_New("vtkPPixelTransfer", op);
  }

  Py_XDECREF(pobj2);

  return result;
}

static PyObject *
PyvtkPPixelTransfer_vtkPPixelTransfer_s6(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "vtkPPixelTransfer");

  int temp0;
  vtkPixelExtent *temp1 = nullptr;
  PyObject *pobj1 = nullptr;
  int temp2;
  vtkPixelExtent *temp3 = nullptr;
  PyObject *pobj3 = nullptr;
  int temp4 = 0;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(4, 5) &&
      ap.GetValue(temp0) &&
      ap.GetSpecialObject(temp1, pobj1, "vtkPixelExtent") &&
      ap.GetValue(temp2) &&
      ap.GetSpecialObject(temp3, pobj3, "vtkPixelExtent") &&
      (ap.NoArgsLeft() || ap.GetValue(temp4)))
  {
    vtkPPixelTransfer *op = new vtkPPixelTransfer(temp0, *temp1, temp2, *temp3, temp4);

    result = PyVTKSpecialObject_New("vtkPPixelTransfer", op);
  }

  Py_XDECREF(pobj1);
  Py_XDECREF(pobj3);

  return result;
}

static PyObject *
PyvtkPPixelTransfer_vtkPPixelTransfer_s7(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "vtkPPixelTransfer");

  vtkPixelExtent *temp0 = nullptr;
  PyObject *pobj0 = nullptr;
  vtkPixelExtent *temp1 = nullptr;
  PyObject *pobj1 = nullptr;
  vtkPixelExtent *temp2 = nullptr;
  PyObject *pobj2 = nullptr;
  vtkPixelExtent *temp3 = nullptr;
  PyObject *pobj3 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(4) &&
      ap.GetSpecialObject(temp0, pobj0, "vtkPixelExtent") &&
      ap.GetSpecialObject(temp1, pobj1, "vtkPixelExtent") &&
      ap.GetSpecialObject(temp2, pobj2, "vtkPixelExtent") &&
      ap.GetSpecialObject(temp3, pobj3, "vtkPixelExtent"))
  {
    vtkPPixelTransfer *op = new vtkPPixelTransfer(*temp0, *temp1, *temp2, *temp3);

    result = PyVTKSpecialObject_New("vtkPPixelTransfer", op);
  }

  Py_XDECREF(pobj0);
  Py_XDECREF(pobj1);
  Py_XDECREF(pobj2);
  Py_XDECREF(pobj3);

  return result;
}

static PyObject *
PyvtkPPixelTransfer_vtkPPixelTransfer_s8(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "vtkPPixelTransfer");

  vtkPPixelTransfer *temp0 = nullptr;
  PyObject *pobj0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetSpecialObject(temp0, pobj0, "vtkPPixelTransfer"))
  {
    vtkPPixelTransfer *op = new vtkPPixelTransfer(*temp0);

    result = PyVTKSpecialObject_New("vtkPPixelTransfer", op);
  }

  Py_XDECREF(pobj0);

  return result;
}

static PyMethodDef PyvtkPPixelTransfer_vtkPPixelTransfer_Methods[] = {
  {"vtkPPixelTransfer", PyvtkPPixelTransfer_vtkPPixelTransfer_s2, METH_VARARGS,
   "@iWWiWW|i vtkPixelExtent vtkPixelExtent vtkPixelExtent vtkPixelExtent"},
  {"vtkPPixelTransfer", PyvtkPPixelTransfer_vtkPPixelTransfer_s3, METH_VARARGS,
   "@iWWiWi vtkPixelExtent vtkPixelExtent vtkPixelExtent"},
  {"vtkPPixelTransfer", PyvtkPPixelTransfer_vtkPPixelTransfer_s4, METH_VARARGS,
   "@iiWW|i vtkPixelExtent vtkPixelExtent"},
  {"vtkPPixelTransfer", PyvtkPPixelTransfer_vtkPPixelTransfer_s5, METH_VARARGS,
   "@iiW|i vtkPixelExtent"},
  {"vtkPPixelTransfer", PyvtkPPixelTransfer_vtkPPixelTransfer_s6, METH_VARARGS,
   "@iWiW|i vtkPixelExtent vtkPixelExtent"},
  {"vtkPPixelTransfer", PyvtkPPixelTransfer_vtkPPixelTransfer_s7, METH_VARARGS,
   "@WWWW vtkPixelExtent vtkPixelExtent vtkPixelExtent vtkPixelExtent"},
  {"vtkPPixelTransfer", PyvtkPPixelTransfer_vtkPPixelTransfer_s8, METH_VARARGS,
   "@W vtkPPixelTransfer"},
  {nullptr, nullptr, 0, nullptr}
};

static PyObject *
PyvtkPPixelTransfer_vtkPPixelTransfer(PyObject *self, PyObject *args)
{
  PyMethodDef *methods = PyvtkPPixelTransfer_vtkPPixelTransfer_Methods;
  int nargs = vtkPythonArgs::GetArgCount(args);

  switch(nargs)
  {
    case 0:
      return PyvtkPPixelTransfer_vtkPPixelTransfer_s1(self, args);
    case 7:
      return PyvtkPPixelTransfer_vtkPPixelTransfer_s2(self, args);
    case 3:
      return PyvtkPPixelTransfer_vtkPPixelTransfer_s5(self, args);
    case 1:
      return PyvtkPPixelTransfer_vtkPPixelTransfer_s8(self, args);
    case 4:
    case 5:
    case 6:
      return vtkPythonOverload::CallMethod(methods, self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "vtkPPixelTransfer");
  return nullptr;
}


static const char *PyvtkPPixelTransfer_Doc =

  "vtkPPixelTransfer() -> vtkPPixelTransfer\nC++: vtkPPixelTransfer()\nvtkPPixelTransfer(srcRank:int, srcWholeExt:vtkPixelExtent,\n    srcExt:vtkPixelExtent, destRank:int, destWholeExt:vtkPixelExtent,\n    destExt:vtkPixelExtent, id:int=0) -> vtkPPixelTransfer\nC++: vtkPPixelTransfer(int srcRank, const vtkPixelExtent &srcWholeExt,\n     const vtkPixelExtent &srcExt, int destRank,\n    const vtkPixelExtent &destWholeExt, const vtkPixelExtent &destExt,\n     int id=0)\nvtkPPixelTransfer(srcRank:int, srcWholeExt:vtkPixelExtent,\n    targetExt:vtkPixelExtent, destRank:int,\n    destWholeExt:vtkPixelExtent, id:int) -> vtkPPixelTransfer\nC++: vtkPPixelTransfer(int srcRank, const vtkPixelExtent &srcWholeExt,\n     const vtkPixelExtent &targetExt, int destRank,\n    const vtkPixelExtent &destWholeExt, int id)\nvtkPPixelTransfer(srcRank:int, destRank:int, wholeExt:vtkPixelExtent,\n    targetExt:vtkPixelExtent, id:int=0) -> vtkPPixelTransfer\nC++: vtkPPixelTransfer(int srcRank, int destRank,\n    const vtkPixelExtent &wholeExt, const vtkPixelExtent &targetExt,\n    int id=0)\nvtkPPixelTransfer(srcRank:int, destRank:int, ext:vtkPixelExtent,\n    id:int=0) -> vtkPPixelTransfer\nC++: vtkPPixelTransfer(int srcRank, int destRank,\n    const vtkPixelExtent &ext, int id=0)\nvtkPPixelTransfer(srcRank:int, srcWholeExt:vtkPixelExtent,\n    destRank:int, destWholeExt:vtkPixelExtent, id:int=0)\n    -> vtkPPixelTransfer\nC++: vtkPPixelTransfer(int srcRank, const vtkPixelExtent &srcWholeExt,\n     int destRank, const vtkPixelExtent &destWholeExt, int id=0)\nvtkPPixelTransfer(srcWholeExt:vtkPixelExtent, srcExt:vtkPixelExtent,\n    destWholeExt:vtkPixelExtent, destExt:vtkPixelExtent)\n    -> vtkPPixelTransfer\nC++: vtkPPixelTransfer(const vtkPixelExtent &srcWholeExt,\n    const vtkPixelExtent &srcExt, const vtkPixelExtent &destWholeExt,\n    const vtkPixelExtent &destExt)\nvtkPPixelTransfer(__a:vtkPPixelTransfer) -> vtkPPixelTransfer\nC++: vtkPPixelTransfer(const &vtkPPixelTransfer)\n""\n"
  "vtkPPixelTransfer - class to handle inter-process communication of\npixel data from non-contiguous regions of a shared index space.\n\n"
  "Superclass: vtkPixelTransfer\n\n"
  "For example copying a subset of one image to a subset of another. The\n"
  "class can be used for purely local(no MPI) non-contigious data\n"
  "transfers by setting the source and destination ranks to the same id.\n"
  "In that case memcpy is used.\n\n"
  "@sa\n"
  "vtkPixelExtent\n\n";

static PyObject *
PyvtkPPixelTransfer_New(PyTypeObject *, PyObject *args, PyObject *kwds)
{
  if (kwds && PyDict_Size(kwds))
  {
    PyErr_SetString(PyExc_TypeError,
                    "this function takes no keyword arguments");
    return nullptr;
  }

  return PyvtkPPixelTransfer_vtkPPixelTransfer(nullptr, args);
}

static void PyvtkPPixelTransfer_Delete(PyObject *self)
{
  PyVTKSpecialObject *obj = (PyVTKSpecialObject *)self;
  delete static_cast<vtkPPixelTransfer *>(obj->vtk_ptr);
  PyObject_Del(self);
}

static PyObject *PyvtkPPixelTransfer_String(PyObject *self)
{
  PyVTKSpecialObject *obj = (PyVTKSpecialObject *)self;
  std::ostringstream os;
  if (obj->vtk_ptr)
  {
    os << *static_cast<const vtkPPixelTransfer *>(obj->vtk_ptr);
  }
  const std::string &s = os.str();
  return PyUnicode_FromStringAndSize(s.data(), s.size());
}

static Py_hash_t PyvtkPPixelTransfer_Hash(PyObject *self)
{
  return PyObject_HashNotImplemented(self);
}

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkPPixelTransfer_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRenderingParallelLIC.vtkPPixelTransfer", // tp_name
  sizeof(PyVTKSpecialObject), // tp_basicsize
  0, // tp_itemsize
  PyvtkPPixelTransfer_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKSpecialObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  PyvtkPPixelTransfer_Hash, // tp_hash
  nullptr, // tp_call
  PyvtkPPixelTransfer_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  nullptr, // tp_setattro
  nullptr, // tp_as_buffer
  Py_TPFLAGS_DEFAULT, // tp_flags
  PyvtkPPixelTransfer_Doc, // tp_doc
  nullptr, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  0, // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  nullptr, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  0, // tp_dictoffset
  nullptr, // tp_init
  nullptr, // tp_alloc
  PyvtkPPixelTransfer_New, // tp_new
  PyObject_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static void *PyvtkPPixelTransfer_CCopy(const void *obj)
{
  if (obj)
  {
    return new vtkPPixelTransfer(*static_cast<const vtkPPixelTransfer*>(obj));
  }
  return nullptr;
}

#ifndef DECLARED_PyvtkPPixelTransfer_TypeNew
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkPPixelTransfer_TypeNew(); }
#define DECLARED_PyvtkPPixelTransfer_TypeNew
#endif

PyObject *PyvtkPPixelTransfer_TypeNew()
{
  PyTypeObject *pytype = PyVTKSpecialType_Add(
    &PyvtkPPixelTransfer_Type,
    PyvtkPPixelTransfer_Methods,
    PyvtkPPixelTransfer_GetSets,
    PyvtkPPixelTransfer_vtkPPixelTransfer_Methods,
    &PyvtkPPixelTransfer_CCopy);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindSpecialTypeObject("vtkPixelTransfer");

  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkPPixelTransfer(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkPPixelTransfer_TypeNew();

  if (o && PyDict_SetItemString(dict, "vtkPPixelTransfer", o) != 0)
  {
    Py_DECREF(o);
  }

}

