/** @file
 * VirtualBox API class wrapper code for IGuestDnDTarget.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2026 Oracle and/or its affiliates.
 *
 * This file is part of VirtualBox base platform packages, as
 * available from https://www.virtualbox.org.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, in version 3 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <https://www.gnu.org/licenses>.
 *
 * SPDX-License-Identifier: GPL-3.0-only
 */

#define LOG_GROUP LOG_GROUP_MAIN_GUESTDNDTARGET

#include "GuestDnDTargetWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(GuestDnDTargetWrap)

//
// IDnDBase properties
//

STDMETHODIMP GuestDnDTargetWrap::COMGETTER(Formats)(ComSafeArrayOut(BSTR, aFormats))
{
    LogRelFlow(("{%p} %s: enter aFormats=%p\n", this, "GuestDnDTarget::getFormats", aFormats));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aFormats);
        ArrayBSTROutConverter TmpFormats(ComSafeArrayOutArg(aFormats));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTDNDTARGET_GET_FORMATS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getFormats(TmpFormats.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTDNDTARGET_GET_FORMATS_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpFormats.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTDNDTARGET_GET_FORMATS_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTDNDTARGET_GET_FORMATS_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aFormats=%zu hrc=%Rhrc\n", this, "GuestDnDTarget::getFormats", ComSafeArraySize(*aFormats), hrc));
    return hrc;
}

STDMETHODIMP GuestDnDTargetWrap::COMGETTER(InternalAndReservedAttribute1IDnDBase)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP GuestDnDTargetWrap::COMGETTER(InternalAndReservedAttribute2IDnDBase)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

//
// IDnDTarget properties
//

STDMETHODIMP GuestDnDTargetWrap::COMGETTER(InternalAndReservedAttribute1IDnDTarget)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP GuestDnDTargetWrap::COMGETTER(InternalAndReservedAttribute2IDnDTarget)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

//
// IGuestDnDTarget properties
//

STDMETHODIMP GuestDnDTargetWrap::COMGETTER(MidlDoesNotLikeEmptyInterfaces)(BOOL *aMidlDoesNotLikeEmptyInterfaces)
{
#if 0 /* This is a dummy attribute */
    LogRelFlow(("{%p} %s: enter aMidlDoesNotLikeEmptyInterfaces=%p\n", this, "GuestDnDTarget::getMidlDoesNotLikeEmptyInterfaces", aMidlDoesNotLikeEmptyInterfaces));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aMidlDoesNotLikeEmptyInterfaces);
        
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getMidlDoesNotLikeEmptyInterfaces(aMidlDoesNotLikeEmptyInterfaces);
        }
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
    }

    LogRelFlow(("{%p} %s: leave *aMidlDoesNotLikeEmptyInterfaces=%RTbool hrc=%Rhrc\n", this, "GuestDnDTarget::getMidlDoesNotLikeEmptyInterfaces", *aMidlDoesNotLikeEmptyInterfaces, hrc));
    return hrc;
#else  /* dummy attribute */
    NOREF(aMidlDoesNotLikeEmptyInterfaces);
    return E_FAIL;
#endif /* dummy attribute */
}


//
// IDnDBase methods
//

STDMETHODIMP GuestDnDTargetWrap::IsFormatSupported(IN_BSTR aFormat,
                                                   BOOL *aSupported)
{
    LogRelFlow(("{%p} %s: enter aFormat=%ls aSupported=%p\n", this, "GuestDnDTarget::isFormatSupported", aFormat, aSupported));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSupported);


        BSTRInConverter TmpFormat(aFormat);
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTDNDTARGET_ISFORMATSUPPORTED_ENTER(this, TmpFormat.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = isFormatSupported(TmpFormat.str(),
                                    aSupported);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTDNDTARGET_ISFORMATSUPPORTED_RETURN(this, hrc, 0 /*normal*/, TmpFormat.str().c_str(), *aSupported != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTDNDTARGET_ISFORMATSUPPORTED_RETURN(this, hrc, 1 /*hrc exception*/, 0, *aSupported != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTDNDTARGET_ISFORMATSUPPORTED_RETURN(this, hrc, 9 /*unhandled exception*/, 0, *aSupported != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave aSupported=%RTbool hrc=%Rhrc\n", this, "GuestDnDTarget::isFormatSupported", *aSupported, hrc));
    return hrc;
}

STDMETHODIMP GuestDnDTargetWrap::AddFormats(ComSafeArrayIn(IN_BSTR, aFormats))
{
    LogRelFlow(("{%p} %s: enter aFormats=%zu\n", this, "GuestDnDTarget::addFormats", aFormats));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        ArrayBSTRInConverter TmpFormats(ComSafeArrayInArg(aFormats));

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTDNDTARGET_ADDFORMATS_ENTER(this, (uint32_t)TmpFormats.array().size(), NULL /*for now*/);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = addFormats(TmpFormats.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTDNDTARGET_ADDFORMATS_RETURN(this, hrc, 0 /*normal*/, (uint32_t)TmpFormats.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTDNDTARGET_ADDFORMATS_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTDNDTARGET_ADDFORMATS_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "GuestDnDTarget::addFormats", hrc));
    return hrc;
}

STDMETHODIMP GuestDnDTargetWrap::RemoveFormats(ComSafeArrayIn(IN_BSTR, aFormats))
{
    LogRelFlow(("{%p} %s: enter aFormats=%zu\n", this, "GuestDnDTarget::removeFormats", aFormats));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        ArrayBSTRInConverter TmpFormats(ComSafeArrayInArg(aFormats));

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTDNDTARGET_REMOVEFORMATS_ENTER(this, (uint32_t)TmpFormats.array().size(), NULL /*for now*/);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = removeFormats(TmpFormats.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTDNDTARGET_REMOVEFORMATS_RETURN(this, hrc, 0 /*normal*/, (uint32_t)TmpFormats.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTDNDTARGET_REMOVEFORMATS_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTDNDTARGET_REMOVEFORMATS_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "GuestDnDTarget::removeFormats", hrc));
    return hrc;
}

STDMETHODIMP GuestDnDTargetWrap::InternalAndReservedMethod1IDnDBase()
{
    return E_NOTIMPL;
}

//
// IDnDTarget methods
//

STDMETHODIMP GuestDnDTargetWrap::Enter(ULONG aScreenId,
                                       ULONG aY,
                                       ULONG aX,
                                       DnDAction_T aDefaultAction,
                                       ComSafeArrayIn(DnDAction_T, aAllowedActions),
                                       ComSafeArrayIn(IN_BSTR, aFormats),
                                       DnDAction_T *aResultAction)
{
    LogRelFlow(("{%p} %s: enter aScreenId=%RU32 aY=%RU32 aX=%RU32 aDefaultAction=%RU32 aAllowedActions=%zu aFormats=%zu aResultAction=%p\n", this, "GuestDnDTarget::enter", aScreenId, aY, aX, aDefaultAction, aAllowedActions, aFormats, aResultAction));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aResultAction);


        
        
        
        
        ArrayInConverter<DnDAction_T> TmpAllowedActions(ComSafeArrayInArg(aAllowedActions));
        ArrayBSTRInConverter TmpFormats(ComSafeArrayInArg(aFormats));
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTDNDTARGET_ENTER_ENTER(this, aScreenId, aY, aX, aDefaultAction, (uint32_t)TmpAllowedActions.array().size(), NULL /*for now*/, (uint32_t)TmpFormats.array().size(), NULL /*for now*/);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = enter(aScreenId,
                        aY,
                        aX,
                        aDefaultAction,
                        TmpAllowedActions.array(),
                        TmpFormats.array(),
                        aResultAction);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTDNDTARGET_ENTER_RETURN(this, hrc, 0 /*normal*/, aScreenId, aY, aX, aDefaultAction, (uint32_t)TmpAllowedActions.array().size(), NULL /*for now*/, (uint32_t)TmpFormats.array().size(), NULL /*for now*/, *aResultAction);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTDNDTARGET_ENTER_RETURN(this, hrc, 1 /*hrc exception*/, aScreenId, aY, aX, aDefaultAction, 0, 0, 0, 0, *aResultAction);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTDNDTARGET_ENTER_RETURN(this, hrc, 9 /*unhandled exception*/, aScreenId, aY, aX, aDefaultAction, 0, 0, 0, 0, *aResultAction);
#endif
    }

    LogRelFlow(("{%p} %s: leave aResultAction=%RU32 hrc=%Rhrc\n", this, "GuestDnDTarget::enter", *aResultAction, hrc));
    return hrc;
}

STDMETHODIMP GuestDnDTargetWrap::Move(ULONG aScreenId,
                                      ULONG aX,
                                      ULONG aY,
                                      DnDAction_T aDefaultAction,
                                      ComSafeArrayIn(DnDAction_T, aAllowedActions),
                                      ComSafeArrayIn(IN_BSTR, aFormats),
                                      DnDAction_T *aResultAction)
{
    LogRelFlow(("{%p} %s: enter aScreenId=%RU32 aX=%RU32 aY=%RU32 aDefaultAction=%RU32 aAllowedActions=%zu aFormats=%zu aResultAction=%p\n", this, "GuestDnDTarget::move", aScreenId, aX, aY, aDefaultAction, aAllowedActions, aFormats, aResultAction));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aResultAction);


        
        
        
        
        ArrayInConverter<DnDAction_T> TmpAllowedActions(ComSafeArrayInArg(aAllowedActions));
        ArrayBSTRInConverter TmpFormats(ComSafeArrayInArg(aFormats));
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTDNDTARGET_MOVE_ENTER(this, aScreenId, aX, aY, aDefaultAction, (uint32_t)TmpAllowedActions.array().size(), NULL /*for now*/, (uint32_t)TmpFormats.array().size(), NULL /*for now*/);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = move(aScreenId,
                       aX,
                       aY,
                       aDefaultAction,
                       TmpAllowedActions.array(),
                       TmpFormats.array(),
                       aResultAction);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTDNDTARGET_MOVE_RETURN(this, hrc, 0 /*normal*/, aScreenId, aX, aY, aDefaultAction, (uint32_t)TmpAllowedActions.array().size(), NULL /*for now*/, (uint32_t)TmpFormats.array().size(), NULL /*for now*/, *aResultAction);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTDNDTARGET_MOVE_RETURN(this, hrc, 1 /*hrc exception*/, aScreenId, aX, aY, aDefaultAction, 0, 0, 0, 0, *aResultAction);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTDNDTARGET_MOVE_RETURN(this, hrc, 9 /*unhandled exception*/, aScreenId, aX, aY, aDefaultAction, 0, 0, 0, 0, *aResultAction);
#endif
    }

    LogRelFlow(("{%p} %s: leave aResultAction=%RU32 hrc=%Rhrc\n", this, "GuestDnDTarget::move", *aResultAction, hrc));
    return hrc;
}

STDMETHODIMP GuestDnDTargetWrap::Leave(ULONG aScreenId)
{
    LogRelFlow(("{%p} %s: enter aScreenId=%RU32\n", this, "GuestDnDTarget::leave", aScreenId));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTDNDTARGET_LEAVE_ENTER(this, aScreenId);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = leave(aScreenId);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTDNDTARGET_LEAVE_RETURN(this, hrc, 0 /*normal*/, aScreenId);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTDNDTARGET_LEAVE_RETURN(this, hrc, 1 /*hrc exception*/, aScreenId);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTDNDTARGET_LEAVE_RETURN(this, hrc, 9 /*unhandled exception*/, aScreenId);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "GuestDnDTarget::leave", hrc));
    return hrc;
}

STDMETHODIMP GuestDnDTargetWrap::Drop(ULONG aScreenId,
                                      ULONG aX,
                                      ULONG aY,
                                      DnDAction_T aDefaultAction,
                                      ComSafeArrayIn(DnDAction_T, aAllowedActions),
                                      ComSafeArrayIn(IN_BSTR, aFormats),
                                      BSTR *aFormat,
                                      DnDAction_T *aResultAction)
{
    LogRelFlow(("{%p} %s: enter aScreenId=%RU32 aX=%RU32 aY=%RU32 aDefaultAction=%RU32 aAllowedActions=%zu aFormats=%zu aFormat=%p aResultAction=%p\n", this, "GuestDnDTarget::drop", aScreenId, aX, aY, aDefaultAction, aAllowedActions, aFormats, aFormat, aResultAction));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aFormat);
        CheckComArgOutPointerValidThrow(aResultAction);


        
        
        
        
        ArrayInConverter<DnDAction_T> TmpAllowedActions(ComSafeArrayInArg(aAllowedActions));
        ArrayBSTRInConverter TmpFormats(ComSafeArrayInArg(aFormats));
        BSTROutConverter TmpFormat(aFormat);
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTDNDTARGET_DROP_ENTER(this, aScreenId, aX, aY, aDefaultAction, (uint32_t)TmpAllowedActions.array().size(), NULL /*for now*/, (uint32_t)TmpFormats.array().size(), NULL /*for now*/);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = drop(aScreenId,
                       aX,
                       aY,
                       aDefaultAction,
                       TmpAllowedActions.array(),
                       TmpFormats.array(),
                       TmpFormat.str(),
                       aResultAction);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTDNDTARGET_DROP_RETURN(this, hrc, 0 /*normal*/, aScreenId, aX, aY, aDefaultAction, (uint32_t)TmpAllowedActions.array().size(), NULL /*for now*/, (uint32_t)TmpFormats.array().size(), NULL /*for now*/, TmpFormat.str().c_str(), *aResultAction);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTDNDTARGET_DROP_RETURN(this, hrc, 1 /*hrc exception*/, aScreenId, aX, aY, aDefaultAction, 0, 0, 0, 0, 0, *aResultAction);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTDNDTARGET_DROP_RETURN(this, hrc, 9 /*unhandled exception*/, aScreenId, aX, aY, aDefaultAction, 0, 0, 0, 0, 0, *aResultAction);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aFormat=%ls aResultAction=%RU32 hrc=%Rhrc\n", this, "GuestDnDTarget::drop", *aFormat, *aResultAction, hrc));
    return hrc;
}

STDMETHODIMP GuestDnDTargetWrap::SendData(ULONG aScreenId,
                                          IN_BSTR aFormat,
                                          ComSafeArrayIn(BYTE, aData),
                                          IProgress **aProgress)
{
    LogRelFlow(("{%p} %s: enter aScreenId=%RU32 aFormat=%ls aData=%zu aProgress=%p\n", this, "GuestDnDTarget::sendData", aScreenId, aFormat, aData, aProgress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProgress);


        
        BSTRInConverter TmpFormat(aFormat);
        ArrayInConverter<BYTE> TmpData(ComSafeArrayInArg(aData));
        ComTypeOutConverter<IProgress> TmpProgress(aProgress);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTDNDTARGET_SENDDATA_ENTER(this, aScreenId, TmpFormat.str().c_str(), (uint32_t)TmpData.array().size(), NULL /*for now*/);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = sendData(aScreenId,
                           TmpFormat.str(),
                           TmpData.array(),
                           TmpProgress.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTDNDTARGET_SENDDATA_RETURN(this, hrc, 0 /*normal*/, aScreenId, TmpFormat.str().c_str(), (uint32_t)TmpData.array().size(), NULL /*for now*/, (void *)TmpProgress.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTDNDTARGET_SENDDATA_RETURN(this, hrc, 1 /*hrc exception*/, aScreenId, 0, 0, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTDNDTARGET_SENDDATA_RETURN(this, hrc, 9 /*unhandled exception*/, aScreenId, 0, 0, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aProgress=%p hrc=%Rhrc\n", this, "GuestDnDTarget::sendData", *aProgress, hrc));
    return hrc;
}

STDMETHODIMP GuestDnDTargetWrap::Cancel(BOOL *aVeto)
{
    LogRelFlow(("{%p} %s: enter aVeto=%p\n", this, "GuestDnDTarget::cancel", aVeto));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aVeto);


        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTDNDTARGET_CANCEL_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = cancel(aVeto);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTDNDTARGET_CANCEL_RETURN(this, hrc, 0 /*normal*/, *aVeto != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTDNDTARGET_CANCEL_RETURN(this, hrc, 1 /*hrc exception*/, *aVeto != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTDNDTARGET_CANCEL_RETURN(this, hrc, 9 /*unhandled exception*/, *aVeto != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave aVeto=%RTbool hrc=%Rhrc\n", this, "GuestDnDTarget::cancel", *aVeto, hrc));
    return hrc;
}

STDMETHODIMP GuestDnDTargetWrap::InternalAndReservedMethod1IDnDTarget()
{
    return E_NOTIMPL;
}

//
// IGuestDnDTarget methods
//

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(GuestDnDTargetWrap)
NS_IMPL_THREADSAFE_ISUPPORTS3_CI(GuestDnDTargetWrap, IGuestDnDTarget, IDnDTarget, IDnDBase)
#endif // VBOX_WITH_XPCOM
