package models

import (
	i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91 "github.com/microsoft/kiota-abstractions-go/serialization"
	ie8677ce2c7e1b4c22e9c3827ecd078d41185424dd9eeb92b7d971ed2d49a392e "github.com/microsoft/kiota-abstractions-go/store"
)

// ChangeNotificationEncryptedContent
type ChangeNotificationEncryptedContent struct {
	// Stores model information.
	backingStore ie8677ce2c7e1b4c22e9c3827ecd078d41185424dd9eeb92b7d971ed2d49a392e.BackingStore
}

// NewChangeNotificationEncryptedContent instantiates a new changeNotificationEncryptedContent and sets the default values.
func NewChangeNotificationEncryptedContent() *ChangeNotificationEncryptedContent {
	m := &ChangeNotificationEncryptedContent{}
	m.backingStore = ie8677ce2c7e1b4c22e9c3827ecd078d41185424dd9eeb92b7d971ed2d49a392e.BackingStoreFactoryInstance()
	m.SetAdditionalData(make(map[string]any))
	return m
}

// CreateChangeNotificationEncryptedContentFromDiscriminatorValue creates a new instance of the appropriate class based on discriminator value
func CreateChangeNotificationEncryptedContentFromDiscriminatorValue(parseNode i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) (i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.Parsable, error) {
	return NewChangeNotificationEncryptedContent(), nil
}

// GetAdditionalData gets the additionalData property value. Stores additional data not described in the OpenAPI description found when deserializing. Can be used for serialization as well.
func (m *ChangeNotificationEncryptedContent) GetAdditionalData() map[string]any {
	val, err := m.backingStore.Get("additionalData")
	if err != nil {
		panic(err)
	}
	if val == nil {
		var value = make(map[string]any)
		m.SetAdditionalData(value)
	}
	return val.(map[string]any)
}

// GetBackingStore gets the backingStore property value. Stores model information.
func (m *ChangeNotificationEncryptedContent) GetBackingStore() ie8677ce2c7e1b4c22e9c3827ecd078d41185424dd9eeb92b7d971ed2d49a392e.BackingStore {
	return m.backingStore
}

// GetData gets the data property value. Base64-encoded encrypted data that produces a full resource respresented as JSON. The data has been encrypted with the provided dataKey using an AES/CBC/PKCS5PADDING cipher suite.
func (m *ChangeNotificationEncryptedContent) GetData() *string {
	val, err := m.GetBackingStore().Get("data")
	if err != nil {
		panic(err)
	}
	if val != nil {
		return val.(*string)
	}
	return nil
}

// GetDataKey gets the dataKey property value. Base64-encoded symmetric key generated by Microsoft Graph to encrypt the data value and to generate the data signature. This key is encrypted with the certificate public key that was provided during the subscription. It must be decrypted with the certificate private key before it can be used to decrypt the data or verify the signature. This key has been encrypted with the following cipher suite: RSA/ECB/OAEPWithSHA1AndMGF1Padding.
func (m *ChangeNotificationEncryptedContent) GetDataKey() *string {
	val, err := m.GetBackingStore().Get("dataKey")
	if err != nil {
		panic(err)
	}
	if val != nil {
		return val.(*string)
	}
	return nil
}

// GetDataSignature gets the dataSignature property value. Base64-encoded HMAC-SHA256 hash of the data for validation purposes.
func (m *ChangeNotificationEncryptedContent) GetDataSignature() *string {
	val, err := m.GetBackingStore().Get("dataSignature")
	if err != nil {
		panic(err)
	}
	if val != nil {
		return val.(*string)
	}
	return nil
}

// GetEncryptionCertificateId gets the encryptionCertificateId property value. ID of the certificate used to encrypt the dataKey.
func (m *ChangeNotificationEncryptedContent) GetEncryptionCertificateId() *string {
	val, err := m.GetBackingStore().Get("encryptionCertificateId")
	if err != nil {
		panic(err)
	}
	if val != nil {
		return val.(*string)
	}
	return nil
}

// GetEncryptionCertificateThumbprint gets the encryptionCertificateThumbprint property value. Hexadecimal representation of the thumbprint of the certificate used to encrypt the dataKey.
func (m *ChangeNotificationEncryptedContent) GetEncryptionCertificateThumbprint() *string {
	val, err := m.GetBackingStore().Get("encryptionCertificateThumbprint")
	if err != nil {
		panic(err)
	}
	if val != nil {
		return val.(*string)
	}
	return nil
}

// GetFieldDeserializers the deserialization information for the current model
func (m *ChangeNotificationEncryptedContent) GetFieldDeserializers() map[string]func(i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
	res := make(map[string]func(i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error)
	res["data"] = func(n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
		val, err := n.GetStringValue()
		if err != nil {
			return err
		}
		if val != nil {
			m.SetData(val)
		}
		return nil
	}
	res["dataKey"] = func(n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
		val, err := n.GetStringValue()
		if err != nil {
			return err
		}
		if val != nil {
			m.SetDataKey(val)
		}
		return nil
	}
	res["dataSignature"] = func(n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
		val, err := n.GetStringValue()
		if err != nil {
			return err
		}
		if val != nil {
			m.SetDataSignature(val)
		}
		return nil
	}
	res["encryptionCertificateId"] = func(n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
		val, err := n.GetStringValue()
		if err != nil {
			return err
		}
		if val != nil {
			m.SetEncryptionCertificateId(val)
		}
		return nil
	}
	res["encryptionCertificateThumbprint"] = func(n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
		val, err := n.GetStringValue()
		if err != nil {
			return err
		}
		if val != nil {
			m.SetEncryptionCertificateThumbprint(val)
		}
		return nil
	}
	res["@odata.type"] = func(n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
		val, err := n.GetStringValue()
		if err != nil {
			return err
		}
		if val != nil {
			m.SetOdataType(val)
		}
		return nil
	}
	return res
}

// GetOdataType gets the @odata.type property value. The OdataType property
func (m *ChangeNotificationEncryptedContent) GetOdataType() *string {
	val, err := m.GetBackingStore().Get("odataType")
	if err != nil {
		panic(err)
	}
	if val != nil {
		return val.(*string)
	}
	return nil
}

// Serialize serializes information the current object
func (m *ChangeNotificationEncryptedContent) Serialize(writer i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.SerializationWriter) error {
	{
		err := writer.WriteStringValue("data", m.GetData())
		if err != nil {
			return err
		}
	}
	{
		err := writer.WriteStringValue("dataKey", m.GetDataKey())
		if err != nil {
			return err
		}
	}
	{
		err := writer.WriteStringValue("dataSignature", m.GetDataSignature())
		if err != nil {
			return err
		}
	}
	{
		err := writer.WriteStringValue("encryptionCertificateId", m.GetEncryptionCertificateId())
		if err != nil {
			return err
		}
	}
	{
		err := writer.WriteStringValue("encryptionCertificateThumbprint", m.GetEncryptionCertificateThumbprint())
		if err != nil {
			return err
		}
	}
	{
		err := writer.WriteStringValue("@odata.type", m.GetOdataType())
		if err != nil {
			return err
		}
	}
	{
		err := writer.WriteAdditionalData(m.GetAdditionalData())
		if err != nil {
			return err
		}
	}
	return nil
}

// SetAdditionalData sets the additionalData property value. Stores additional data not described in the OpenAPI description found when deserializing. Can be used for serialization as well.
func (m *ChangeNotificationEncryptedContent) SetAdditionalData(value map[string]any) {
	err := m.GetBackingStore().Set("additionalData", value)
	if err != nil {
		panic(err)
	}
}

// SetBackingStore sets the backingStore property value. Stores model information.
func (m *ChangeNotificationEncryptedContent) SetBackingStore(value ie8677ce2c7e1b4c22e9c3827ecd078d41185424dd9eeb92b7d971ed2d49a392e.BackingStore) {
	m.backingStore = value
}

// SetData sets the data property value. Base64-encoded encrypted data that produces a full resource respresented as JSON. The data has been encrypted with the provided dataKey using an AES/CBC/PKCS5PADDING cipher suite.
func (m *ChangeNotificationEncryptedContent) SetData(value *string) {
	err := m.GetBackingStore().Set("data", value)
	if err != nil {
		panic(err)
	}
}

// SetDataKey sets the dataKey property value. Base64-encoded symmetric key generated by Microsoft Graph to encrypt the data value and to generate the data signature. This key is encrypted with the certificate public key that was provided during the subscription. It must be decrypted with the certificate private key before it can be used to decrypt the data or verify the signature. This key has been encrypted with the following cipher suite: RSA/ECB/OAEPWithSHA1AndMGF1Padding.
func (m *ChangeNotificationEncryptedContent) SetDataKey(value *string) {
	err := m.GetBackingStore().Set("dataKey", value)
	if err != nil {
		panic(err)
	}
}

// SetDataSignature sets the dataSignature property value. Base64-encoded HMAC-SHA256 hash of the data for validation purposes.
func (m *ChangeNotificationEncryptedContent) SetDataSignature(value *string) {
	err := m.GetBackingStore().Set("dataSignature", value)
	if err != nil {
		panic(err)
	}
}

// SetEncryptionCertificateId sets the encryptionCertificateId property value. ID of the certificate used to encrypt the dataKey.
func (m *ChangeNotificationEncryptedContent) SetEncryptionCertificateId(value *string) {
	err := m.GetBackingStore().Set("encryptionCertificateId", value)
	if err != nil {
		panic(err)
	}
}

// SetEncryptionCertificateThumbprint sets the encryptionCertificateThumbprint property value. Hexadecimal representation of the thumbprint of the certificate used to encrypt the dataKey.
func (m *ChangeNotificationEncryptedContent) SetEncryptionCertificateThumbprint(value *string) {
	err := m.GetBackingStore().Set("encryptionCertificateThumbprint", value)
	if err != nil {
		panic(err)
	}
}

// SetOdataType sets the @odata.type property value. The OdataType property
func (m *ChangeNotificationEncryptedContent) SetOdataType(value *string) {
	err := m.GetBackingStore().Set("odataType", value)
	if err != nil {
		panic(err)
	}
}

// ChangeNotificationEncryptedContentable
type ChangeNotificationEncryptedContentable interface {
	i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.AdditionalDataHolder
	ie8677ce2c7e1b4c22e9c3827ecd078d41185424dd9eeb92b7d971ed2d49a392e.BackedModel
	i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.Parsable
	GetBackingStore() ie8677ce2c7e1b4c22e9c3827ecd078d41185424dd9eeb92b7d971ed2d49a392e.BackingStore
	GetData() *string
	GetDataKey() *string
	GetDataSignature() *string
	GetEncryptionCertificateId() *string
	GetEncryptionCertificateThumbprint() *string
	GetOdataType() *string
	SetBackingStore(value ie8677ce2c7e1b4c22e9c3827ecd078d41185424dd9eeb92b7d971ed2d49a392e.BackingStore)
	SetData(value *string)
	SetDataKey(value *string)
	SetDataSignature(value *string)
	SetEncryptionCertificateId(value *string)
	SetEncryptionCertificateThumbprint(value *string)
	SetOdataType(value *string)
}
