//
// Copyright 2025 Pixar
//
// Licensed under the terms set forth in the LICENSE.txt file available at
// https://openusd.org/license.
//
////////////////////////////////////////////////////////////////////////

/* ************************************************************************** */
/* **                                                                      ** */
/* ** This file is generated by a script.                                  ** */
/* **                                                                      ** */
/* ** Do not edit it directly (unless it is within a CUSTOM CODE section)! ** */
/* ** Edit hdSchemaDefs.py instead to make changes.                        ** */
/* **                                                                      ** */
/* ************************************************************************** */

#include "pxr/usdImaging/usdSkelImaging/resolvedSkeletonSchema.h"

#include "pxr/imaging/hd/retainedDataSource.h"

#include "pxr/base/trace/trace.h"

// --(BEGIN CUSTOM CODE: Includes)--
// --(END CUSTOM CODE: Includes)--

PXR_NAMESPACE_OPEN_SCOPE

TF_DEFINE_PUBLIC_TOKENS(UsdSkelImagingResolvedSkeletonSchemaTokens,
    USD_SKEL_IMAGING_RESOLVED_SKELETON_SCHEMA_TOKENS);

// --(BEGIN CUSTOM CODE: Schema Methods)--
// --(END CUSTOM CODE: Schema Methods)--

HdMatrixDataSourceHandle
UsdSkelImagingResolvedSkeletonSchema::GetSkelLocalToWorld() const
{
    return _GetTypedDataSource<HdMatrixDataSource>(
        UsdSkelImagingResolvedSkeletonSchemaTokens->skelLocalToWorld);
}

HdMatrix4fArrayDataSourceHandle
UsdSkelImagingResolvedSkeletonSchema::GetSkinningTransforms() const
{
    return _GetTypedDataSource<HdMatrix4fArrayDataSource>(
        UsdSkelImagingResolvedSkeletonSchemaTokens->skinningTransforms);
}

HdTokenArrayDataSourceHandle
UsdSkelImagingResolvedSkeletonSchema::GetBlendShapes() const
{
    return _GetTypedDataSource<HdTokenArrayDataSource>(
        UsdSkelImagingResolvedSkeletonSchemaTokens->blendShapes);
}

HdFloatArrayDataSourceHandle
UsdSkelImagingResolvedSkeletonSchema::GetBlendShapeWeights() const
{
    return _GetTypedDataSource<HdFloatArrayDataSource>(
        UsdSkelImagingResolvedSkeletonSchemaTokens->blendShapeWeights);
}

/*static*/
HdContainerDataSourceHandle
UsdSkelImagingResolvedSkeletonSchema::BuildRetained(
        const HdMatrixDataSourceHandle &skelLocalToWorld,
        const HdMatrix4fArrayDataSourceHandle &skinningTransforms,
        const HdTokenArrayDataSourceHandle &blendShapes,
        const HdFloatArrayDataSourceHandle &blendShapeWeights
)
{
    TfToken _names[4];
    HdDataSourceBaseHandle _values[4];

    size_t _count = 0;

    if (skelLocalToWorld) {
        _names[_count] = UsdSkelImagingResolvedSkeletonSchemaTokens->skelLocalToWorld;
        _values[_count++] = skelLocalToWorld;
    }

    if (skinningTransforms) {
        _names[_count] = UsdSkelImagingResolvedSkeletonSchemaTokens->skinningTransforms;
        _values[_count++] = skinningTransforms;
    }

    if (blendShapes) {
        _names[_count] = UsdSkelImagingResolvedSkeletonSchemaTokens->blendShapes;
        _values[_count++] = blendShapes;
    }

    if (blendShapeWeights) {
        _names[_count] = UsdSkelImagingResolvedSkeletonSchemaTokens->blendShapeWeights;
        _values[_count++] = blendShapeWeights;
    }
    return HdRetainedContainerDataSource::New(_count, _names, _values);
}

UsdSkelImagingResolvedSkeletonSchema::Builder &
UsdSkelImagingResolvedSkeletonSchema::Builder::SetSkelLocalToWorld(
    const HdMatrixDataSourceHandle &skelLocalToWorld)
{
    _skelLocalToWorld = skelLocalToWorld;
    return *this;
}

UsdSkelImagingResolvedSkeletonSchema::Builder &
UsdSkelImagingResolvedSkeletonSchema::Builder::SetSkinningTransforms(
    const HdMatrix4fArrayDataSourceHandle &skinningTransforms)
{
    _skinningTransforms = skinningTransforms;
    return *this;
}

UsdSkelImagingResolvedSkeletonSchema::Builder &
UsdSkelImagingResolvedSkeletonSchema::Builder::SetBlendShapes(
    const HdTokenArrayDataSourceHandle &blendShapes)
{
    _blendShapes = blendShapes;
    return *this;
}

UsdSkelImagingResolvedSkeletonSchema::Builder &
UsdSkelImagingResolvedSkeletonSchema::Builder::SetBlendShapeWeights(
    const HdFloatArrayDataSourceHandle &blendShapeWeights)
{
    _blendShapeWeights = blendShapeWeights;
    return *this;
}

HdContainerDataSourceHandle
UsdSkelImagingResolvedSkeletonSchema::Builder::Build()
{
    return UsdSkelImagingResolvedSkeletonSchema::BuildRetained(
        _skelLocalToWorld,
        _skinningTransforms,
        _blendShapes,
        _blendShapeWeights
    );
}

/*static*/
UsdSkelImagingResolvedSkeletonSchema
UsdSkelImagingResolvedSkeletonSchema::GetFromParent(
        const HdContainerDataSourceHandle &fromParentContainer)
{
    return UsdSkelImagingResolvedSkeletonSchema(
        fromParentContainer
        ? HdContainerDataSource::Cast(fromParentContainer->Get(
                UsdSkelImagingResolvedSkeletonSchemaTokens->resolvedSkeleton))
        : nullptr);
}

/*static*/
const TfToken &
UsdSkelImagingResolvedSkeletonSchema::GetSchemaToken()
{
    return UsdSkelImagingResolvedSkeletonSchemaTokens->resolvedSkeleton;
}

/*static*/
const HdDataSourceLocator &
UsdSkelImagingResolvedSkeletonSchema::GetDefaultLocator()
{
    static const HdDataSourceLocator locator(GetSchemaToken());
    return locator;
}

/* static */
const HdDataSourceLocator &
UsdSkelImagingResolvedSkeletonSchema::GetSkelLocalToWorldLocator()
{
    static const HdDataSourceLocator locator =
        GetDefaultLocator().Append(
            UsdSkelImagingResolvedSkeletonSchemaTokens->skelLocalToWorld);
    return locator;
}

/* static */
const HdDataSourceLocator &
UsdSkelImagingResolvedSkeletonSchema::GetSkinningTransformsLocator()
{
    static const HdDataSourceLocator locator =
        GetDefaultLocator().Append(
            UsdSkelImagingResolvedSkeletonSchemaTokens->skinningTransforms);
    return locator;
}

/* static */
const HdDataSourceLocator &
UsdSkelImagingResolvedSkeletonSchema::GetBlendShapesLocator()
{
    static const HdDataSourceLocator locator =
        GetDefaultLocator().Append(
            UsdSkelImagingResolvedSkeletonSchemaTokens->blendShapes);
    return locator;
}

/* static */
const HdDataSourceLocator &
UsdSkelImagingResolvedSkeletonSchema::GetBlendShapeWeightsLocator()
{
    static const HdDataSourceLocator locator =
        GetDefaultLocator().Append(
            UsdSkelImagingResolvedSkeletonSchemaTokens->blendShapeWeights);
    return locator;
} 

PXR_NAMESPACE_CLOSE_SCOPE
