//
// Copyright 2023 Pixar
//
// Licensed under the terms set forth in the LICENSE.txt file available at
// https://openusd.org/license.
//
////////////////////////////////////////////////////////////////////////

/* ************************************************************************** */
/* **                                                                      ** */
/* ** This file is generated by a script.                                  ** */
/* **                                                                      ** */
/* ** Do not edit it directly (unless it is within a CUSTOM CODE section)! ** */
/* ** Edit hdSchemaDefs.py instead to make changes.                        ** */
/* **                                                                      ** */
/* ************************************************************************** */

#include "pxr/imaging/hd/sampleFilterSchema.h"

#include "pxr/imaging/hd/retainedDataSource.h"

#include "pxr/base/trace/trace.h"

// --(BEGIN CUSTOM CODE: Includes)--
// --(END CUSTOM CODE: Includes)--

PXR_NAMESPACE_OPEN_SCOPE

TF_DEFINE_PUBLIC_TOKENS(HdSampleFilterSchemaTokens,
    HD_SAMPLE_FILTER_SCHEMA_TOKENS);

// --(BEGIN CUSTOM CODE: Schema Methods)--
// --(END CUSTOM CODE: Schema Methods)--

HdMaterialNodeSchema
HdSampleFilterSchema::GetResource() const
{
    return HdMaterialNodeSchema(_GetTypedDataSource<HdContainerDataSource>(
        HdSampleFilterSchemaTokens->resource));
}

/*static*/
HdContainerDataSourceHandle
HdSampleFilterSchema::BuildRetained(
        const HdContainerDataSourceHandle &resource
)
{
    TfToken _names[1];
    HdDataSourceBaseHandle _values[1];

    size_t _count = 0;

    if (resource) {
        _names[_count] = HdSampleFilterSchemaTokens->resource;
        _values[_count++] = resource;
    }
    return HdRetainedContainerDataSource::New(_count, _names, _values);
}

HdSampleFilterSchema::Builder &
HdSampleFilterSchema::Builder::SetResource(
    const HdContainerDataSourceHandle &resource)
{
    _resource = resource;
    return *this;
}

HdContainerDataSourceHandle
HdSampleFilterSchema::Builder::Build()
{
    return HdSampleFilterSchema::BuildRetained(
        _resource
    );
}

/*static*/
HdSampleFilterSchema
HdSampleFilterSchema::GetFromParent(
        const HdContainerDataSourceHandle &fromParentContainer)
{
    return HdSampleFilterSchema(
        fromParentContainer
        ? HdContainerDataSource::Cast(fromParentContainer->Get(
                HdSampleFilterSchemaTokens->sampleFilter))
        : nullptr);
}

/*static*/
const TfToken &
HdSampleFilterSchema::GetSchemaToken()
{
    return HdSampleFilterSchemaTokens->sampleFilter;
}

/*static*/
const HdDataSourceLocator &
HdSampleFilterSchema::GetDefaultLocator()
{
    static const HdDataSourceLocator locator(GetSchemaToken());
    return locator;
}

/* static */
const HdDataSourceLocator &
HdSampleFilterSchema::GetResourceLocator()
{
    static const HdDataSourceLocator locator =
        GetDefaultLocator().Append(
            HdSampleFilterSchemaTokens->resource);
    return locator;
} 

PXR_NAMESPACE_CLOSE_SCOPE