/* Generated by wayland-scanner 1.24.0 */

#ifndef TREELAND_WALLPAPER_SHELL_UNSTABLE_V1_CLIENT_PROTOCOL_H
#define TREELAND_WALLPAPER_SHELL_UNSTABLE_V1_CLIENT_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-client-core.h"

#ifdef  __cplusplus
extern "C" {
#endif

/**
 * @page page_treeland_wallpaper_shell_unstable_v1 The treeland_wallpaper_shell_unstable_v1 protocol
 * @section page_ifaces_treeland_wallpaper_shell_unstable_v1 Interfaces
 * - @subpage page_iface_treeland_wallpaper_notifier_v1 - Notification interface for wallpaper source changes
 * - @subpage page_iface_treeland_wallpaper_shell_v1 - Wallpaper shell global
 * - @subpage page_iface_treeland_wallpaper_surface_v1 - Wallpaper surface controller
 * @section page_copyright_treeland_wallpaper_shell_unstable_v1 Copyright
 * <pre>
 *
 * SPDX-FileCopyrightText: 2025 UnionTech Software Technology Co., Ltd.
 * SPDX-License-Identifier: MIT
 * </pre>
 */
struct treeland_wallpaper_notifier_v1;
struct treeland_wallpaper_shell_v1;
struct treeland_wallpaper_surface_v1;
struct wl_surface;

#ifndef TREELAND_WALLPAPER_NOTIFIER_V1_INTERFACE
#define TREELAND_WALLPAPER_NOTIFIER_V1_INTERFACE
/**
 * @page page_iface_treeland_wallpaper_notifier_v1 treeland_wallpaper_notifier_v1
 * @section page_iface_treeland_wallpaper_notifier_v1_desc Description
 *
 * The treeland_wallpaper_notifier_v1 interface provides notifications
 * about the availability and lifetime of wallpaper sources managed by
 * the compositor.
 *
 * This interface is purely event-driven. Clients receive events when
 * wallpaper sources are added, become active, or are removed, and may
 * update their internal state or user interface accordingly.
 * @section page_iface_treeland_wallpaper_notifier_v1_api API
 * See @ref iface_treeland_wallpaper_notifier_v1.
 */
/**
 * @defgroup iface_treeland_wallpaper_notifier_v1 The treeland_wallpaper_notifier_v1 interface
 *
 * The treeland_wallpaper_notifier_v1 interface provides notifications
 * about the availability and lifetime of wallpaper sources managed by
 * the compositor.
 *
 * This interface is purely event-driven. Clients receive events when
 * wallpaper sources are added, become active, or are removed, and may
 * update their internal state or user interface accordingly.
 */
extern const struct wl_interface treeland_wallpaper_notifier_v1_interface;
#endif
#ifndef TREELAND_WALLPAPER_SHELL_V1_INTERFACE
#define TREELAND_WALLPAPER_SHELL_V1_INTERFACE
/**
 * @page page_iface_treeland_wallpaper_shell_v1 treeland_wallpaper_shell_v1
 * @section page_iface_treeland_wallpaper_shell_v1_desc Description
 *
 * The treeland_wallpaper_shell_v1 interface is a global object exposed by
 * the compositor that allows a client to assign the wallpaper role to
 * a wl_surface and create wallpaper surface objects.
 *
 * A wallpaper surface represents content intended to be displayed as
 * the desktop wallpaper, such as a static image or a dynamic media
 * source, and is associated with exactly one wl_surface.
 *
 * This interface follows the shell pattern used by other Wayland
 * protocols: it assigns a specific role to a wl_surface and manages
 * the lifetime and behavior of wallpaper surfaces.
 *
 * This interface is a singleton. At most one client may bind to
 * treeland_wallpaper_shell_v1 at any given time.
 * @section page_iface_treeland_wallpaper_shell_v1_api API
 * See @ref iface_treeland_wallpaper_shell_v1.
 */
/**
 * @defgroup iface_treeland_wallpaper_shell_v1 The treeland_wallpaper_shell_v1 interface
 *
 * The treeland_wallpaper_shell_v1 interface is a global object exposed by
 * the compositor that allows a client to assign the wallpaper role to
 * a wl_surface and create wallpaper surface objects.
 *
 * A wallpaper surface represents content intended to be displayed as
 * the desktop wallpaper, such as a static image or a dynamic media
 * source, and is associated with exactly one wl_surface.
 *
 * This interface follows the shell pattern used by other Wayland
 * protocols: it assigns a specific role to a wl_surface and manages
 * the lifetime and behavior of wallpaper surfaces.
 *
 * This interface is a singleton. At most one client may bind to
 * treeland_wallpaper_shell_v1 at any given time.
 */
extern const struct wl_interface treeland_wallpaper_shell_v1_interface;
#endif
#ifndef TREELAND_WALLPAPER_SURFACE_V1_INTERFACE
#define TREELAND_WALLPAPER_SURFACE_V1_INTERFACE
/**
 * @page page_iface_treeland_wallpaper_surface_v1 treeland_wallpaper_surface_v1
 * @section page_iface_treeland_wallpaper_surface_v1_desc Description
 *
 * The treeland_wallpaper_surface_v1 interface controls the behavior of a
 * wallpaper surface.
 *
 * A wallpaper surface is bound to exactly one wl_surface and defines how
 * that surface should be sized, positioned, and synchronized with the
 * compositor's wallpaper management logic.
 * @section page_iface_treeland_wallpaper_surface_v1_api API
 * See @ref iface_treeland_wallpaper_surface_v1.
 */
/**
 * @defgroup iface_treeland_wallpaper_surface_v1 The treeland_wallpaper_surface_v1 interface
 *
 * The treeland_wallpaper_surface_v1 interface controls the behavior of a
 * wallpaper surface.
 *
 * A wallpaper surface is bound to exactly one wl_surface and defines how
 * that surface should be sized, positioned, and synchronized with the
 * compositor's wallpaper management logic.
 */
extern const struct wl_interface treeland_wallpaper_surface_v1_interface;
#endif

#ifndef TREELAND_WALLPAPER_NOTIFIER_V1_WALLPAPER_SOURCE_TYPE_ENUM
#define TREELAND_WALLPAPER_NOTIFIER_V1_WALLPAPER_SOURCE_TYPE_ENUM
enum treeland_wallpaper_notifier_v1_wallpaper_source_type {
	/**
	 * The wallpaper source is an image
	 */
	TREELAND_WALLPAPER_NOTIFIER_V1_WALLPAPER_SOURCE_TYPE_IMAGE = 0,
	/**
	 * The wallpaper source is a video
	 */
	TREELAND_WALLPAPER_NOTIFIER_V1_WALLPAPER_SOURCE_TYPE_VIDEO = 1,
};
#endif /* TREELAND_WALLPAPER_NOTIFIER_V1_WALLPAPER_SOURCE_TYPE_ENUM */

/**
 * @ingroup iface_treeland_wallpaper_notifier_v1
 * @struct treeland_wallpaper_notifier_v1_listener
 */
struct treeland_wallpaper_notifier_v1_listener {
	/**
	 * Notify about a new wallpaper source
	 *
	 * This event is sent by the compositor when a new wallpaper
	 * source is added or becomes active.
	 *
	 * The source_type argument describes the type of the wallpaper
	 * source. The meaning of the file_source argument depends on the
	 * reported source_type.
	 * @param source_type The type of the wallpaper source
	 * @param file_source The file path or identifier of the wallpaper source
	 */
	void (*add)(void *data,
		    struct treeland_wallpaper_notifier_v1 *treeland_wallpaper_notifier_v1,
		    uint32_t source_type,
		    const char *file_source);
	/**
	 * Notify that a wallpaper source has been removed
	 *
	 * This event indicates that the wallpaper source identified by
	 * file_source is no longer available.
	 *
	 * After receiving this event, the client should discard any
	 * internal state associated with the wallpaper source and must not
	 * reference it anymore.
	 * @param file_source The file path or identifier of the wallpaper source
	 */
	void (*remove)(void *data,
		       struct treeland_wallpaper_notifier_v1 *treeland_wallpaper_notifier_v1,
		       const char *file_source);
};

/**
 * @ingroup iface_treeland_wallpaper_notifier_v1
 */
static inline int
treeland_wallpaper_notifier_v1_add_listener(struct treeland_wallpaper_notifier_v1 *treeland_wallpaper_notifier_v1,
					    const struct treeland_wallpaper_notifier_v1_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) treeland_wallpaper_notifier_v1,
				     (void (**)(void)) listener, data);
}

#define TREELAND_WALLPAPER_NOTIFIER_V1_DESTROY 0

/**
 * @ingroup iface_treeland_wallpaper_notifier_v1
 */
#define TREELAND_WALLPAPER_NOTIFIER_V1_ADD_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_wallpaper_notifier_v1
 */
#define TREELAND_WALLPAPER_NOTIFIER_V1_REMOVE_SINCE_VERSION 1

/**
 * @ingroup iface_treeland_wallpaper_notifier_v1
 */
#define TREELAND_WALLPAPER_NOTIFIER_V1_DESTROY_SINCE_VERSION 1

/** @ingroup iface_treeland_wallpaper_notifier_v1 */
static inline void
treeland_wallpaper_notifier_v1_set_user_data(struct treeland_wallpaper_notifier_v1 *treeland_wallpaper_notifier_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) treeland_wallpaper_notifier_v1, user_data);
}

/** @ingroup iface_treeland_wallpaper_notifier_v1 */
static inline void *
treeland_wallpaper_notifier_v1_get_user_data(struct treeland_wallpaper_notifier_v1 *treeland_wallpaper_notifier_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) treeland_wallpaper_notifier_v1);
}

static inline uint32_t
treeland_wallpaper_notifier_v1_get_version(struct treeland_wallpaper_notifier_v1 *treeland_wallpaper_notifier_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) treeland_wallpaper_notifier_v1);
}

/**
 * @ingroup iface_treeland_wallpaper_notifier_v1
 *
 * Destroys this treeland_wallpaper_notifier_v1 object.
 *
 * Destroying a bound treeland_wallpaper_notifier_v1 object while
 * wallpaper surface objects created from it are still alive is
 * illegal and will result in a protocol error.
 */
static inline void
treeland_wallpaper_notifier_v1_destroy(struct treeland_wallpaper_notifier_v1 *treeland_wallpaper_notifier_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_wallpaper_notifier_v1,
			 TREELAND_WALLPAPER_NOTIFIER_V1_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_wallpaper_notifier_v1), WL_MARSHAL_FLAG_DESTROY);
}

#define TREELAND_WALLPAPER_SHELL_V1_DESTROY 0
#define TREELAND_WALLPAPER_SHELL_V1_GET_TREELAND_WALLPAPER_SURFACE 1


/**
 * @ingroup iface_treeland_wallpaper_shell_v1
 */
#define TREELAND_WALLPAPER_SHELL_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_wallpaper_shell_v1
 */
#define TREELAND_WALLPAPER_SHELL_V1_GET_TREELAND_WALLPAPER_SURFACE_SINCE_VERSION 1

/** @ingroup iface_treeland_wallpaper_shell_v1 */
static inline void
treeland_wallpaper_shell_v1_set_user_data(struct treeland_wallpaper_shell_v1 *treeland_wallpaper_shell_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) treeland_wallpaper_shell_v1, user_data);
}

/** @ingroup iface_treeland_wallpaper_shell_v1 */
static inline void *
treeland_wallpaper_shell_v1_get_user_data(struct treeland_wallpaper_shell_v1 *treeland_wallpaper_shell_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) treeland_wallpaper_shell_v1);
}

static inline uint32_t
treeland_wallpaper_shell_v1_get_version(struct treeland_wallpaper_shell_v1 *treeland_wallpaper_shell_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) treeland_wallpaper_shell_v1);
}

/**
 * @ingroup iface_treeland_wallpaper_shell_v1
 *
 * Destroys this treeland_wallpaper_shell_v1 object.
 *
 * Destroying a bound treeland_wallpaper_shell_v1 object while there
 * are still treeland_wallpaper_surface_v1 objects created from it
 * is illegal and will result in a protocol error.
 */
static inline void
treeland_wallpaper_shell_v1_destroy(struct treeland_wallpaper_shell_v1 *treeland_wallpaper_shell_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_wallpaper_shell_v1,
			 TREELAND_WALLPAPER_SHELL_V1_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_wallpaper_shell_v1), WL_MARSHAL_FLAG_DESTROY);
}

/**
 * @ingroup iface_treeland_wallpaper_shell_v1
 *
 * Creates a treeland_wallpaper_surface_v1 object and assigns the
 * wallpaper role to the given wl_surface.
 *
 * The provided wl_surface must not already have a role, and while
 * it is used as a wallpaper surface, it must not be assigned any
 * other role.
 *
 * The file_source argument specifies the initial wallpaper source
 * identifier. Its interpretation depends on the wallpaper source
 * type selected by the compositor.
 */
static inline struct treeland_wallpaper_surface_v1 *
treeland_wallpaper_shell_v1_get_treeland_wallpaper_surface(struct treeland_wallpaper_shell_v1 *treeland_wallpaper_shell_v1, struct wl_surface *surface, const char *file_source)
{
	struct wl_proxy *id;

	id = wl_proxy_marshal_flags((struct wl_proxy *) treeland_wallpaper_shell_v1,
			 TREELAND_WALLPAPER_SHELL_V1_GET_TREELAND_WALLPAPER_SURFACE, &treeland_wallpaper_surface_v1_interface, wl_proxy_get_version((struct wl_proxy *) treeland_wallpaper_shell_v1), 0, NULL, surface, file_source);

	return (struct treeland_wallpaper_surface_v1 *) id;
}

#ifndef TREELAND_WALLPAPER_SURFACE_V1_ERROR_ENUM
#define TREELAND_WALLPAPER_SURFACE_V1_ERROR_ENUM
enum treeland_wallpaper_surface_v1_error {
	/**
	 * The specified wallpaper source is invalid, unsupported, or failed to load.
	 */
	TREELAND_WALLPAPER_SURFACE_V1_ERROR_INVALID_SOURCE = 1,
	/**
	 * Permission denied when opening the specified wallpaper source
	 */
	TREELAND_WALLPAPER_SURFACE_V1_ERROR_PERMISSION_DENIED = 2,
};
#endif /* TREELAND_WALLPAPER_SURFACE_V1_ERROR_ENUM */

/**
 * @ingroup iface_treeland_wallpaper_surface_v1
 * @struct treeland_wallpaper_surface_v1_listener
 */
struct treeland_wallpaper_surface_v1_listener {
	/**
	 * Update wallpaper position or progress
	 *
	 * This event provides a position value associated with the
	 * wallpaper.
	 *
	 * The semantic meaning of the position value is
	 * compositor-defined. It may represent a scroll offset, animation
	 * progress, or playback position. The value is expressed as a
	 * fixed-point number[0, 1.0].
	 * @param position Position or progress value in fixed-point format
	 */
	void (*position)(void *data,
			 struct treeland_wallpaper_surface_v1 *treeland_wallpaper_surface_v1,
			 wl_fixed_t position);
	/**
	 * Pause wallpaper updates
	 *
	 * This event instructs the client to pause wallpaper updates or
	 * animations.
	 *
	 * After receiving this event, the client should stop advancing any
	 * time-based or animated wallpaper content until a play event is
	 * received.
	 */
	void (*pause)(void *data,
		      struct treeland_wallpaper_surface_v1 *treeland_wallpaper_surface_v1);
	/**
	 * Set wallpaper playback rate
	 *
	 * Sets the playback speed of the wallpaper content.
	 *
	 * A rate of 1.0 represents normal speed. A rate of 0.0 represents
	 * a paused state.
	 * @param rate Playback rate multiplier
	 */
	void (*set_playback_rate)(void *data,
				  struct treeland_wallpaper_surface_v1 *treeland_wallpaper_surface_v1,
				  wl_fixed_t rate);
	/**
	 * Resume wallpaper updates
	 *
	 * This event instructs the client to resume wallpaper updates or
	 * animations after a pause.
	 */
	void (*play)(void *data,
		     struct treeland_wallpaper_surface_v1 *treeland_wallpaper_surface_v1);
	/**
	 * Request a gradual slowdown of wallpaper updates
	 *
	 * This event instructs the client to progressively reduce the
	 * playback or animation update rate of the wallpaper content until
	 * it comes to a complete stop.
	 *
	 * The slowdown should be smooth and continuous rather than abrupt.
	 *
	 * The duration argument specifies the amount of time, in
	 * milliseconds, over which the slowdown should occur. After this
	 * duration has elapsed, the client should consider the wallpaper
	 * paused.
	 *
	 * A duration of 0 means the client should pause immediately.
	 * @param duration Duration in milliseconds over which the slowdown occurs
	 */
	void (*slow_down)(void *data,
			  struct treeland_wallpaper_surface_v1 *treeland_wallpaper_surface_v1,
			  uint32_t duration);
};

/**
 * @ingroup iface_treeland_wallpaper_surface_v1
 */
static inline int
treeland_wallpaper_surface_v1_add_listener(struct treeland_wallpaper_surface_v1 *treeland_wallpaper_surface_v1,
					   const struct treeland_wallpaper_surface_v1_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) treeland_wallpaper_surface_v1,
				     (void (**)(void)) listener, data);
}

#define TREELAND_WALLPAPER_SURFACE_V1_DESTROY 0
#define TREELAND_WALLPAPER_SURFACE_V1_SOURCE_FAILED 1

/**
 * @ingroup iface_treeland_wallpaper_surface_v1
 */
#define TREELAND_WALLPAPER_SURFACE_V1_POSITION_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_wallpaper_surface_v1
 */
#define TREELAND_WALLPAPER_SURFACE_V1_PAUSE_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_wallpaper_surface_v1
 */
#define TREELAND_WALLPAPER_SURFACE_V1_SET_PLAYBACK_RATE_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_wallpaper_surface_v1
 */
#define TREELAND_WALLPAPER_SURFACE_V1_PLAY_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_wallpaper_surface_v1
 */
#define TREELAND_WALLPAPER_SURFACE_V1_SLOW_DOWN_SINCE_VERSION 1

/**
 * @ingroup iface_treeland_wallpaper_surface_v1
 */
#define TREELAND_WALLPAPER_SURFACE_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_wallpaper_surface_v1
 */
#define TREELAND_WALLPAPER_SURFACE_V1_SOURCE_FAILED_SINCE_VERSION 1

/** @ingroup iface_treeland_wallpaper_surface_v1 */
static inline void
treeland_wallpaper_surface_v1_set_user_data(struct treeland_wallpaper_surface_v1 *treeland_wallpaper_surface_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) treeland_wallpaper_surface_v1, user_data);
}

/** @ingroup iface_treeland_wallpaper_surface_v1 */
static inline void *
treeland_wallpaper_surface_v1_get_user_data(struct treeland_wallpaper_surface_v1 *treeland_wallpaper_surface_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) treeland_wallpaper_surface_v1);
}

static inline uint32_t
treeland_wallpaper_surface_v1_get_version(struct treeland_wallpaper_surface_v1 *treeland_wallpaper_surface_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) treeland_wallpaper_surface_v1);
}

/**
 * @ingroup iface_treeland_wallpaper_surface_v1
 *
 * Destroy the wallpaper surface object and release its association with
 * the underlying wl_surface.
 *
 * After calling this request, the wallpaper surface object becomes
 * invalid and must not be used again.
 *
 * This request should only be sent when the client intends to
 * permanently stop using the wallpaper surface, such as when the
 * client is shutting down or after receiving the
 * treeland_wallpaper_produce_v1.removed event for this surface.
 */
static inline void
treeland_wallpaper_surface_v1_destroy(struct treeland_wallpaper_surface_v1 *treeland_wallpaper_surface_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_wallpaper_surface_v1,
			 TREELAND_WALLPAPER_SURFACE_V1_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_wallpaper_surface_v1), WL_MARSHAL_FLAG_DESTROY);
}

/**
 * @ingroup iface_treeland_wallpaper_surface_v1
 *
 * Reports to the compositor that a wallpaper-related operation has
 * failed on the client side.
 *
 * This request may be sent by the client when it fails to open,
 * load, or otherwise process the configured wallpaper source.
 * The compositor may use this information for diagnostics, policy
 * decisions, or to adjust internal state.
 *
 * Possible error values include:
 * - invalid_source: The specified wallpaper source is invalid,
 * unsupported, or could not be processed. This is a fatal error and
 * indicates that the source should be verified before retrying.
 * - permission_denied: The client does not have permission to access
 * the specified wallpaper source.
 */
static inline void
treeland_wallpaper_surface_v1_source_failed(struct treeland_wallpaper_surface_v1 *treeland_wallpaper_surface_v1, uint32_t error)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_wallpaper_surface_v1,
			 TREELAND_WALLPAPER_SURFACE_V1_SOURCE_FAILED, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_wallpaper_surface_v1), 0, error);
}

#ifdef  __cplusplus
}
#endif

#endif
