/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1alpha1

import (
	labels "k8s.io/apimachinery/pkg/labels"
	listers "k8s.io/client-go/listers"
	cache "k8s.io/client-go/tools/cache"
	apisxv1alpha1 "sigs.k8s.io/gateway-api/apisx/v1alpha1"
)

// XMeshLister helps list XMeshes.
// All objects returned here must be treated as read-only.
type XMeshLister interface {
	// List lists all XMeshes in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*apisxv1alpha1.XMesh, err error)
	// Get retrieves the XMesh from the index for a given name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*apisxv1alpha1.XMesh, error)
	XMeshListerExpansion
}

// xMeshLister implements the XMeshLister interface.
type xMeshLister struct {
	listers.ResourceIndexer[*apisxv1alpha1.XMesh]
}

// NewXMeshLister returns a new XMeshLister.
func NewXMeshLister(indexer cache.Indexer) XMeshLister {
	return &xMeshLister{listers.New[*apisxv1alpha1.XMesh](indexer, apisxv1alpha1.Resource("xmesh"))}
}
