/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

import (
	apisv1 "sigs.k8s.io/gateway-api/apis/v1"
)

// HTTPCORSFilterApplyConfiguration represents a declarative configuration of the HTTPCORSFilter type for use
// with apply.
type HTTPCORSFilterApplyConfiguration struct {
	AllowOrigins     []apisv1.CORSOrigin             `json:"allowOrigins,omitempty"`
	AllowCredentials *bool                           `json:"allowCredentials,omitempty"`
	AllowMethods     []apisv1.HTTPMethodWithWildcard `json:"allowMethods,omitempty"`
	AllowHeaders     []apisv1.HTTPHeaderName         `json:"allowHeaders,omitempty"`
	ExposeHeaders    []apisv1.HTTPHeaderName         `json:"exposeHeaders,omitempty"`
	MaxAge           *int32                          `json:"maxAge,omitempty"`
}

// HTTPCORSFilterApplyConfiguration constructs a declarative configuration of the HTTPCORSFilter type for use with
// apply.
func HTTPCORSFilter() *HTTPCORSFilterApplyConfiguration {
	return &HTTPCORSFilterApplyConfiguration{}
}

// WithAllowOrigins adds the given value to the AllowOrigins field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the AllowOrigins field.
func (b *HTTPCORSFilterApplyConfiguration) WithAllowOrigins(values ...apisv1.CORSOrigin) *HTTPCORSFilterApplyConfiguration {
	for i := range values {
		b.AllowOrigins = append(b.AllowOrigins, values[i])
	}
	return b
}

// WithAllowCredentials sets the AllowCredentials field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the AllowCredentials field is set to the value of the last call.
func (b *HTTPCORSFilterApplyConfiguration) WithAllowCredentials(value bool) *HTTPCORSFilterApplyConfiguration {
	b.AllowCredentials = &value
	return b
}

// WithAllowMethods adds the given value to the AllowMethods field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the AllowMethods field.
func (b *HTTPCORSFilterApplyConfiguration) WithAllowMethods(values ...apisv1.HTTPMethodWithWildcard) *HTTPCORSFilterApplyConfiguration {
	for i := range values {
		b.AllowMethods = append(b.AllowMethods, values[i])
	}
	return b
}

// WithAllowHeaders adds the given value to the AllowHeaders field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the AllowHeaders field.
func (b *HTTPCORSFilterApplyConfiguration) WithAllowHeaders(values ...apisv1.HTTPHeaderName) *HTTPCORSFilterApplyConfiguration {
	for i := range values {
		b.AllowHeaders = append(b.AllowHeaders, values[i])
	}
	return b
}

// WithExposeHeaders adds the given value to the ExposeHeaders field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the ExposeHeaders field.
func (b *HTTPCORSFilterApplyConfiguration) WithExposeHeaders(values ...apisv1.HTTPHeaderName) *HTTPCORSFilterApplyConfiguration {
	for i := range values {
		b.ExposeHeaders = append(b.ExposeHeaders, values[i])
	}
	return b
}

// WithMaxAge sets the MaxAge field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the MaxAge field is set to the value of the last call.
func (b *HTTPCORSFilterApplyConfiguration) WithMaxAge(value int32) *HTTPCORSFilterApplyConfiguration {
	b.MaxAge = &value
	return b
}
