/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1

import (
	corev1 "k8s.io/api/core/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	listers "k8s.io/client-go/listers"
	cache "k8s.io/client-go/tools/cache"
)

// PodTemplateLister helps list PodTemplates.
// All objects returned here must be treated as read-only.
type PodTemplateLister interface {
	// List lists all PodTemplates in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*corev1.PodTemplate, err error)
	// PodTemplates returns an object that can list and get PodTemplates.
	PodTemplates(namespace string) PodTemplateNamespaceLister
	PodTemplateListerExpansion
}

// podTemplateLister implements the PodTemplateLister interface.
type podTemplateLister struct {
	listers.ResourceIndexer[*corev1.PodTemplate]
}

// NewPodTemplateLister returns a new PodTemplateLister.
func NewPodTemplateLister(indexer cache.Indexer) PodTemplateLister {
	return &podTemplateLister{listers.New[*corev1.PodTemplate](indexer, corev1.Resource("podtemplate"))}
}

// PodTemplates returns an object that can list and get PodTemplates.
func (s *podTemplateLister) PodTemplates(namespace string) PodTemplateNamespaceLister {
	return podTemplateNamespaceLister{listers.NewNamespaced[*corev1.PodTemplate](s.ResourceIndexer, namespace)}
}

// PodTemplateNamespaceLister helps list and get PodTemplates.
// All objects returned here must be treated as read-only.
type PodTemplateNamespaceLister interface {
	// List lists all PodTemplates in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*corev1.PodTemplate, err error)
	// Get retrieves the PodTemplate from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*corev1.PodTemplate, error)
	PodTemplateNamespaceListerExpansion
}

// podTemplateNamespaceLister implements the PodTemplateNamespaceLister
// interface.
type podTemplateNamespaceLister struct {
	listers.ResourceIndexer[*corev1.PodTemplate]
}
