/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

// FractionApplyConfiguration represents a declarative configuration of the Fraction type for use
// with apply.
type FractionApplyConfiguration struct {
	Numerator   *int32 `json:"numerator,omitempty"`
	Denominator *int32 `json:"denominator,omitempty"`
}

// FractionApplyConfiguration constructs a declarative configuration of the Fraction type for use with
// apply.
func Fraction() *FractionApplyConfiguration {
	return &FractionApplyConfiguration{}
}

// WithNumerator sets the Numerator field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Numerator field is set to the value of the last call.
func (b *FractionApplyConfiguration) WithNumerator(value int32) *FractionApplyConfiguration {
	b.Numerator = &value
	return b
}

// WithDenominator sets the Denominator field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Denominator field is set to the value of the last call.
func (b *FractionApplyConfiguration) WithDenominator(value int32) *FractionApplyConfiguration {
	b.Denominator = &value
	return b
}
