// python wrapper for ttkTopologicalCompressionWriter
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "ttkTopologicalCompressionWriter.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_ttkTopologicalCompressionWriter(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyttkTopologicalCompressionWriter_ClassNew(); }


static PyObject *
PyttkTopologicalCompressionWriter_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = ttkTopologicalCompressionWriter::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTopologicalCompressionWriter_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTopologicalCompressionWriter *op = static_cast<ttkTopologicalCompressionWriter *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->ttkTopologicalCompressionWriter::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTopologicalCompressionWriter_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    ttkTopologicalCompressionWriter *tempr = ttkTopologicalCompressionWriter::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTopologicalCompressionWriter_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTopologicalCompressionWriter *op = static_cast<ttkTopologicalCompressionWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    ttkTopologicalCompressionWriter *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->ttkTopologicalCompressionWriter::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTopologicalCompressionWriter_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = ttkTopologicalCompressionWriter::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTopologicalCompressionWriter_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTopologicalCompressionWriter *op = static_cast<ttkTopologicalCompressionWriter *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->ttkTopologicalCompressionWriter::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTopologicalCompressionWriter_SetFileName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetFileName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTopologicalCompressionWriter *op = static_cast<ttkTopologicalCompressionWriter *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetFilePath(temp0))
  {
    if (ap.IsBound())
    {
      op->SetFileName(temp0);
    }
    else
    {
      op->ttkTopologicalCompressionWriter::SetFileName(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkTopologicalCompressionWriter_GetFileName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFileName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTopologicalCompressionWriter *op = static_cast<ttkTopologicalCompressionWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    char *tempr = (ap.IsBound() ?
      op->GetFileName() :
      op->ttkTopologicalCompressionWriter::GetFileName());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTopologicalCompressionWriter_GetTolerance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTolerance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTopologicalCompressionWriter *op = static_cast<ttkTopologicalCompressionWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetTolerance() :
      op->ttkTopologicalCompressionWriter::GetTolerance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTopologicalCompressionWriter_SetTolerance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTolerance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTopologicalCompressionWriter *op = static_cast<ttkTopologicalCompressionWriter *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetTolerance(temp0);
    }
    else
    {
      op->ttkTopologicalCompressionWriter::SetTolerance(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkTopologicalCompressionWriter_GetMaximumError(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMaximumError");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTopologicalCompressionWriter *op = static_cast<ttkTopologicalCompressionWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetMaximumError() :
      op->ttkTopologicalCompressionWriter::GetMaximumError());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTopologicalCompressionWriter_SetMaximumError(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetMaximumError");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTopologicalCompressionWriter *op = static_cast<ttkTopologicalCompressionWriter *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetMaximumError(temp0);
    }
    else
    {
      op->ttkTopologicalCompressionWriter::SetMaximumError(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkTopologicalCompressionWriter_GetZFPTolerance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetZFPTolerance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTopologicalCompressionWriter *op = static_cast<ttkTopologicalCompressionWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetZFPTolerance() :
      op->ttkTopologicalCompressionWriter::GetZFPTolerance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTopologicalCompressionWriter_SetZFPTolerance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetZFPTolerance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTopologicalCompressionWriter *op = static_cast<ttkTopologicalCompressionWriter *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetZFPTolerance(temp0);
    }
    else
    {
      op->ttkTopologicalCompressionWriter::SetZFPTolerance(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkTopologicalCompressionWriter_GetZFPOnly(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetZFPOnly");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTopologicalCompressionWriter *op = static_cast<ttkTopologicalCompressionWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetZFPOnly() :
      op->ttkTopologicalCompressionWriter::GetZFPOnly());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTopologicalCompressionWriter_SetZFPOnly(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetZFPOnly");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTopologicalCompressionWriter *op = static_cast<ttkTopologicalCompressionWriter *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetZFPOnly(temp0);
    }
    else
    {
      op->ttkTopologicalCompressionWriter::SetZFPOnly(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkTopologicalCompressionWriter_GetCompressionType(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetCompressionType");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTopologicalCompressionWriter *op = static_cast<ttkTopologicalCompressionWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetCompressionType() :
      op->ttkTopologicalCompressionWriter::GetCompressionType());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTopologicalCompressionWriter_SetCompressionType(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetCompressionType");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTopologicalCompressionWriter *op = static_cast<ttkTopologicalCompressionWriter *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetCompressionType(temp0);
    }
    else
    {
      op->ttkTopologicalCompressionWriter::SetCompressionType(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkTopologicalCompressionWriter_GetNbSegments(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNbSegments");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTopologicalCompressionWriter *op = static_cast<ttkTopologicalCompressionWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetNbSegments() :
      op->ttkTopologicalCompressionWriter::GetNbSegments());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTopologicalCompressionWriter_SetNbSegments(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNbSegments");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTopologicalCompressionWriter *op = static_cast<ttkTopologicalCompressionWriter *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetNbSegments(temp0);
    }
    else
    {
      op->ttkTopologicalCompressionWriter::SetNbSegments(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkTopologicalCompressionWriter_GetNbVertices(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNbVertices");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTopologicalCompressionWriter *op = static_cast<ttkTopologicalCompressionWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetNbVertices() :
      op->ttkTopologicalCompressionWriter::GetNbVertices());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTopologicalCompressionWriter_SetNbVertices(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNbVertices");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTopologicalCompressionWriter *op = static_cast<ttkTopologicalCompressionWriter *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetNbVertices(temp0);
    }
    else
    {
      op->ttkTopologicalCompressionWriter::SetNbVertices(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkTopologicalCompressionWriter_GetSQMethod(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSQMethod");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTopologicalCompressionWriter *op = static_cast<ttkTopologicalCompressionWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    std::string tempr = (ap.IsBound() ?
      op->GetSQMethod() :
      op->ttkTopologicalCompressionWriter::GetSQMethod());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTopologicalCompressionWriter_SetSQMethod(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSQMethod");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTopologicalCompressionWriter *op = static_cast<ttkTopologicalCompressionWriter *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetSQMethod(temp0);
    }
    else
    {
      op->ttkTopologicalCompressionWriter::SetSQMethod(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkTopologicalCompressionWriter_SetSubdivide(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSubdivide");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTopologicalCompressionWriter *op = static_cast<ttkTopologicalCompressionWriter *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetSubdivide(temp0);
    }
    else
    {
      op->ttkTopologicalCompressionWriter::SetSubdivide(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkTopologicalCompressionWriter_GetSubdivide(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSubdivide");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTopologicalCompressionWriter *op = static_cast<ttkTopologicalCompressionWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetSubdivide() :
      op->ttkTopologicalCompressionWriter::GetSubdivide());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTopologicalCompressionWriter_SetUseTopologicalSimplification(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUseTopologicalSimplification");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTopologicalCompressionWriter *op = static_cast<ttkTopologicalCompressionWriter *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetUseTopologicalSimplification(temp0);
    }
    else
    {
      op->ttkTopologicalCompressionWriter::SetUseTopologicalSimplification(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkTopologicalCompressionWriter_GetUseTopologicalSimplification(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetUseTopologicalSimplification");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTopologicalCompressionWriter *op = static_cast<ttkTopologicalCompressionWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetUseTopologicalSimplification() :
      op->ttkTopologicalCompressionWriter::GetUseTopologicalSimplification());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTopologicalCompressionWriter_SetSQMethodPV(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSQMethodPV");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTopologicalCompressionWriter *op = static_cast<ttkTopologicalCompressionWriter *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetSQMethodPV(temp0);
    }
    else
    {
      op->ttkTopologicalCompressionWriter::SetSQMethodPV(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkTopologicalCompressionWriter_Write(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Write");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTopologicalCompressionWriter *op = static_cast<ttkTopologicalCompressionWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->Write() :
      op->ttkTopologicalCompressionWriter::Write());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTopologicalCompressionWriter_GetInput(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetInput");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTopologicalCompressionWriter *op = static_cast<ttkTopologicalCompressionWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkDataObject *tempr = (ap.IsBound() ?
      op->GetInput() :
      op->ttkTopologicalCompressionWriter::GetInput());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTopologicalCompressionWriter_SetInputData(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetInputData");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTopologicalCompressionWriter *op = static_cast<ttkTopologicalCompressionWriter *>(vp);

  vtkDataObject *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkDataObject"))
  {
    if (ap.IsBound())
    {
      op->SetInputData(temp0);
    }
    else
    {
      op->ttkTopologicalCompressionWriter::SetInputData(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyttkTopologicalCompressionWriter_Methods[] = {
  {"IsTypeOf", PyttkTopologicalCompressionWriter_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyttkTopologicalCompressionWriter_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyttkTopologicalCompressionWriter_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> ttkTopologicalCompressionWriter\nC++: static ttkTopologicalCompressionWriter *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyttkTopologicalCompressionWriter_NewInstance, METH_VARARGS,
   "NewInstance(self) -> ttkTopologicalCompressionWriter\nC++: ttkTopologicalCompressionWriter *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyttkTopologicalCompressionWriter_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyttkTopologicalCompressionWriter_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetFileName", PyttkTopologicalCompressionWriter_SetFileName, METH_VARARGS,
   "SetFileName(self, _arg:str) -> None\nC++: virtual void SetFileName(const char *_arg)\n\n"},
  {"GetFileName", PyttkTopologicalCompressionWriter_GetFileName, METH_VARARGS,
   "GetFileName(self) -> str\nC++: virtual char *GetFileName()\n\n"},
  {"GetTolerance", PyttkTopologicalCompressionWriter_GetTolerance, METH_VARARGS,
   "GetTolerance(self) -> float\nC++: virtual double GetTolerance()\n\n"},
  {"SetTolerance", PyttkTopologicalCompressionWriter_SetTolerance, METH_VARARGS,
   "SetTolerance(self, _arg:float) -> None\nC++: virtual void SetTolerance(double _arg)\n\n"},
  {"GetMaximumError", PyttkTopologicalCompressionWriter_GetMaximumError, METH_VARARGS,
   "GetMaximumError(self) -> float\nC++: virtual double GetMaximumError()\n\n"},
  {"SetMaximumError", PyttkTopologicalCompressionWriter_SetMaximumError, METH_VARARGS,
   "SetMaximumError(self, _arg:float) -> None\nC++: virtual void SetMaximumError(double _arg)\n\n"},
  {"GetZFPTolerance", PyttkTopologicalCompressionWriter_GetZFPTolerance, METH_VARARGS,
   "GetZFPTolerance(self) -> float\nC++: virtual double GetZFPTolerance()\n\n"},
  {"SetZFPTolerance", PyttkTopologicalCompressionWriter_SetZFPTolerance, METH_VARARGS,
   "SetZFPTolerance(self, _arg:float) -> None\nC++: virtual void SetZFPTolerance(double _arg)\n\n"},
  {"GetZFPOnly", PyttkTopologicalCompressionWriter_GetZFPOnly, METH_VARARGS,
   "GetZFPOnly(self) -> bool\nC++: virtual bool GetZFPOnly()\n\n"},
  {"SetZFPOnly", PyttkTopologicalCompressionWriter_SetZFPOnly, METH_VARARGS,
   "SetZFPOnly(self, _arg:bool) -> None\nC++: virtual void SetZFPOnly(bool _arg)\n\n"},
  {"GetCompressionType", PyttkTopologicalCompressionWriter_GetCompressionType, METH_VARARGS,
   "GetCompressionType(self) -> int\nC++: virtual int GetCompressionType()\n\n"},
  {"SetCompressionType", PyttkTopologicalCompressionWriter_SetCompressionType, METH_VARARGS,
   "SetCompressionType(self, _arg:int) -> None\nC++: virtual void SetCompressionType(int _arg)\n\n"},
  {"GetNbSegments", PyttkTopologicalCompressionWriter_GetNbSegments, METH_VARARGS,
   "GetNbSegments(self) -> int\nC++: virtual int GetNbSegments()\n\n"},
  {"SetNbSegments", PyttkTopologicalCompressionWriter_SetNbSegments, METH_VARARGS,
   "SetNbSegments(self, _arg:int) -> None\nC++: virtual void SetNbSegments(int _arg)\n\n"},
  {"GetNbVertices", PyttkTopologicalCompressionWriter_GetNbVertices, METH_VARARGS,
   "GetNbVertices(self) -> int\nC++: virtual int GetNbVertices()\n\n"},
  {"SetNbVertices", PyttkTopologicalCompressionWriter_SetNbVertices, METH_VARARGS,
   "SetNbVertices(self, _arg:int) -> None\nC++: virtual void SetNbVertices(int _arg)\n\n"},
  {"GetSQMethod", PyttkTopologicalCompressionWriter_GetSQMethod, METH_VARARGS,
   "GetSQMethod(self) -> str\nC++: virtual std::string GetSQMethod()\n\n"},
  {"SetSQMethod", PyttkTopologicalCompressionWriter_SetSQMethod, METH_VARARGS,
   "SetSQMethod(self, _arg:str) -> None\nC++: virtual void SetSQMethod(const std::string &_arg)\n\n"},
  {"SetSubdivide", PyttkTopologicalCompressionWriter_SetSubdivide, METH_VARARGS,
   "SetSubdivide(self, _arg:bool) -> None\nC++: virtual void SetSubdivide(bool _arg)\n\n"},
  {"GetSubdivide", PyttkTopologicalCompressionWriter_GetSubdivide, METH_VARARGS,
   "GetSubdivide(self) -> bool\nC++: virtual bool GetSubdivide()\n\n"},
  {"SetUseTopologicalSimplification", PyttkTopologicalCompressionWriter_SetUseTopologicalSimplification, METH_VARARGS,
   "SetUseTopologicalSimplification(self, _arg:bool) -> None\nC++: virtual void SetUseTopologicalSimplification(bool _arg)\n\n"},
  {"GetUseTopologicalSimplification", PyttkTopologicalCompressionWriter_GetUseTopologicalSimplification, METH_VARARGS,
   "GetUseTopologicalSimplification(self) -> bool\nC++: virtual bool GetUseTopologicalSimplification()\n\n"},
  {"SetSQMethodPV", PyttkTopologicalCompressionWriter_SetSQMethodPV, METH_VARARGS,
   "SetSQMethodPV(self, c:int) -> None\nC++: void SetSQMethodPV(int c)\n\n"},
  {"Write", PyttkTopologicalCompressionWriter_Write, METH_VARARGS,
   "Write(self) -> int\nC++: int Write()\n\n"},
  {"GetInput", PyttkTopologicalCompressionWriter_GetInput, METH_VARARGS,
   "GetInput(self) -> vtkDataObject\nC++: vtkDataObject *GetInput()\n\n"},
  {"SetInputData", PyttkTopologicalCompressionWriter_SetInputData, METH_VARARGS,
   "SetInputData(self, input:vtkDataObject) -> None\nC++: void SetInputData(vtkDataObject *input)\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyttkTopologicalCompressionWriter_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("file_name"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkTopologicalCompressionWriter_GetFileName(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkTopologicalCompressionWriter_SetFileName(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkTopologicalCompressionWriter_SetFileName(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetFileName/SetFileName\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("tolerance"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkTopologicalCompressionWriter_GetTolerance(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkTopologicalCompressionWriter_SetTolerance(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkTopologicalCompressionWriter_SetTolerance(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetTolerance/SetTolerance\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("maximum_error"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkTopologicalCompressionWriter_GetMaximumError(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkTopologicalCompressionWriter_SetMaximumError(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkTopologicalCompressionWriter_SetMaximumError(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetMaximumError/SetMaximumError\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("zfp_tolerance"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkTopologicalCompressionWriter_GetZFPTolerance(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkTopologicalCompressionWriter_SetZFPTolerance(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkTopologicalCompressionWriter_SetZFPTolerance(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetZFPTolerance/SetZFPTolerance\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("zfp_only"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkTopologicalCompressionWriter_GetZFPOnly(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkTopologicalCompressionWriter_SetZFPOnly(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkTopologicalCompressionWriter_SetZFPOnly(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetZFPOnly/SetZFPOnly\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("compression_type"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkTopologicalCompressionWriter_GetCompressionType(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkTopologicalCompressionWriter_SetCompressionType(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkTopologicalCompressionWriter_SetCompressionType(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetCompressionType/SetCompressionType\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("nb_segments"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkTopologicalCompressionWriter_GetNbSegments(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkTopologicalCompressionWriter_SetNbSegments(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkTopologicalCompressionWriter_SetNbSegments(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetNbSegments/SetNbSegments\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("nb_vertices"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkTopologicalCompressionWriter_GetNbVertices(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkTopologicalCompressionWriter_SetNbVertices(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkTopologicalCompressionWriter_SetNbVertices(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetNbVertices/SetNbVertices\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("sq_method"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkTopologicalCompressionWriter_GetSQMethod(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkTopologicalCompressionWriter_SetSQMethod(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkTopologicalCompressionWriter_SetSQMethod(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetSQMethod/SetSQMethod\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("subdivide"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkTopologicalCompressionWriter_GetSubdivide(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkTopologicalCompressionWriter_SetSubdivide(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkTopologicalCompressionWriter_SetSubdivide(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetSubdivide/SetSubdivide\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("use_topological_simplification"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkTopologicalCompressionWriter_GetUseTopologicalSimplification(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkTopologicalCompressionWriter_SetUseTopologicalSimplification(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkTopologicalCompressionWriter_SetUseTopologicalSimplification(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetUseTopologicalSimplification/SetUseTopologicalSimplification\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("sq_method_pv"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkTopologicalCompressionWriter_SetSQMethodPV(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkTopologicalCompressionWriter_SetSQMethodPV(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetSQMethodPV\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("input_data"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkTopologicalCompressionWriter_SetInputData(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkTopologicalCompressionWriter_SetInputData(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetInputData\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("input"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkTopologicalCompressionWriter_GetInput(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetInput\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyttkTopologicalCompressionWriter_Doc =
  "ttkTopologicalCompressionWriter - \\ingroup vtkWrappers\n\n"
  "Superclass: ttkAlgorithm\n\n"
  "\\author Maxime Soler <soler.maxime@total.com>\\date 21/04/2017\n\n"
  "VTK-filter that wraps the topologicalCompressionWriter processing\n"
  "package.\n\n"
  "Online examples:\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/persistenceDrivenCompression/\"\n"
  "  >Persistence-Driven Compression example\\n\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyttkTopologicalCompressionWriter_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "ttkTopologicalCompressionWriter.ttkTopologicalCompressionWriter", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyttkTopologicalCompressionWriter_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyttkTopologicalCompressionWriter_StaticNew()
{
  return ttkTopologicalCompressionWriter::New();
}

PyObject *PyttkTopologicalCompressionWriter_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyttkTopologicalCompressionWriter_Type, PyttkTopologicalCompressionWriter_Methods,
    "ttkTopologicalCompressionWriter",
 &PyttkTopologicalCompressionWriter_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("ttkAlgorithm");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyttkTopologicalCompressionWriter_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_ttkTopologicalCompressionWriter(
  PyObject *dict)
{
  PyObject *o;
  o = PyttkTopologicalCompressionWriter_ClassNew();

  if (o && PyDict_SetItemString(dict, "ttkTopologicalCompressionWriter", o) != 0)
  {
    Py_DECREF(o);
  }

}

