// python wrapper for ttkContourForests
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "ttkContourForests.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_ttkContourForests(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyttkContourForests_ClassNew(); }


static PyObject *
PyttkContourForests_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = ttkContourForests::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkContourForests_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkContourForests *op = static_cast<ttkContourForests *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->ttkContourForests::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkContourForests_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    ttkContourForests *tempr = ttkContourForests::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkContourForests_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkContourForests *op = static_cast<ttkContourForests *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    ttkContourForests *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->ttkContourForests::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkContourForests_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = ttkContourForests::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkContourForests_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkContourForests *op = static_cast<ttkContourForests *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->ttkContourForests::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkContourForests_GetForceInputOffsetScalarField(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetForceInputOffsetScalarField");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkContourForests *op = static_cast<ttkContourForests *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetForceInputOffsetScalarField() :
      op->ttkContourForests::GetForceInputOffsetScalarField());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkContourForests_SetForceInputOffsetScalarField(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetForceInputOffsetScalarField");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkContourForests *op = static_cast<ttkContourForests *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetForceInputOffsetScalarField(temp0);
    }
    else
    {
      op->ttkContourForests::SetForceInputOffsetScalarField(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkContourForests_SetTreeType(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTreeType");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkContourForests *op = static_cast<ttkContourForests *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetTreeType(temp0);
    }
    else
    {
      op->ttkContourForests::SetTreeType(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkContourForests_ShowMin(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ShowMin");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkContourForests *op = static_cast<ttkContourForests *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->ShowMin(temp0);
    }
    else
    {
      op->ttkContourForests::ShowMin(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkContourForests_ShowMax(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ShowMax");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkContourForests *op = static_cast<ttkContourForests *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->ShowMax(temp0);
    }
    else
    {
      op->ttkContourForests::ShowMax(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkContourForests_ShowSaddle1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ShowSaddle1");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkContourForests *op = static_cast<ttkContourForests *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->ShowSaddle1(temp0);
    }
    else
    {
      op->ttkContourForests::ShowSaddle1(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkContourForests_ShowSaddle2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ShowSaddle2");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkContourForests *op = static_cast<ttkContourForests *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->ShowSaddle2(temp0);
    }
    else
    {
      op->ttkContourForests::ShowSaddle2(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkContourForests_ShowArc(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ShowArc");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkContourForests *op = static_cast<ttkContourForests *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->ShowArc(temp0);
    }
    else
    {
      op->ttkContourForests::ShowArc(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkContourForests_SetArcResolution(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetArcResolution");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkContourForests *op = static_cast<ttkContourForests *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetArcResolution(temp0);
    }
    else
    {
      op->ttkContourForests::SetArcResolution(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkContourForests_SetPartitionNumber(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPartitionNumber");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkContourForests *op = static_cast<ttkContourForests *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetPartitionNumber(temp0);
    }
    else
    {
      op->ttkContourForests::SetPartitionNumber(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkContourForests_SetLessPartition(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetLessPartition");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkContourForests *op = static_cast<ttkContourForests *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetLessPartition(temp0);
    }
    else
    {
      op->ttkContourForests::SetLessPartition(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkContourForests_SetSkeletonSmoothing(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSkeletonSmoothing");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkContourForests *op = static_cast<ttkContourForests *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetSkeletonSmoothing(temp0);
    }
    else
    {
      op->ttkContourForests::SetSkeletonSmoothing(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkContourForests_SetSimplificationType(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSimplificationType");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkContourForests *op = static_cast<ttkContourForests *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetSimplificationType(temp0);
    }
    else
    {
      op->ttkContourForests::SetSimplificationType(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkContourForests_SetSimplificationThreshold(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSimplificationThreshold");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkContourForests *op = static_cast<ttkContourForests *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetSimplificationThreshold(temp0);
    }
    else
    {
      op->ttkContourForests::SetSimplificationThreshold(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyttkContourForests_Methods[] = {
  {"IsTypeOf", PyttkContourForests_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyttkContourForests_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyttkContourForests_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> ttkContourForests\nC++: static ttkContourForests *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyttkContourForests_NewInstance, METH_VARARGS,
   "NewInstance(self) -> ttkContourForests\nC++: ttkContourForests *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyttkContourForests_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyttkContourForests_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetForceInputOffsetScalarField", PyttkContourForests_GetForceInputOffsetScalarField, METH_VARARGS,
   "GetForceInputOffsetScalarField(self) -> bool\nC++: virtual bool GetForceInputOffsetScalarField()\n\n"},
  {"SetForceInputOffsetScalarField", PyttkContourForests_SetForceInputOffsetScalarField, METH_VARARGS,
   "SetForceInputOffsetScalarField(self, onOff:bool) -> None\nC++: void SetForceInputOffsetScalarField(bool onOff)\n\n"},
  {"SetTreeType", PyttkContourForests_SetTreeType, METH_VARARGS,
   "SetTreeType(self, tree:int) -> None\nC++: void SetTreeType(int tree)\n\n"},
  {"ShowMin", PyttkContourForests_ShowMin, METH_VARARGS,
   "ShowMin(self, state:bool) -> None\nC++: void ShowMin(bool state)\n\n"},
  {"ShowMax", PyttkContourForests_ShowMax, METH_VARARGS,
   "ShowMax(self, state:bool) -> None\nC++: void ShowMax(bool state)\n\n"},
  {"ShowSaddle1", PyttkContourForests_ShowSaddle1, METH_VARARGS,
   "ShowSaddle1(self, state:bool) -> None\nC++: void ShowSaddle1(bool state)\n\n"},
  {"ShowSaddle2", PyttkContourForests_ShowSaddle2, METH_VARARGS,
   "ShowSaddle2(self, state:bool) -> None\nC++: void ShowSaddle2(bool state)\n\n"},
  {"ShowArc", PyttkContourForests_ShowArc, METH_VARARGS,
   "ShowArc(self, state:bool) -> None\nC++: void ShowArc(bool state)\n\n"},
  {"SetArcResolution", PyttkContourForests_SetArcResolution, METH_VARARGS,
   "SetArcResolution(self, arcResolution:int) -> None\nC++: void SetArcResolution(int arcResolution)\n\n"},
  {"SetPartitionNumber", PyttkContourForests_SetPartitionNumber, METH_VARARGS,
   "SetPartitionNumber(self, partitionNum:int) -> None\nC++: void SetPartitionNumber(int partitionNum)\n\n"},
  {"SetLessPartition", PyttkContourForests_SetLessPartition, METH_VARARGS,
   "SetLessPartition(self, l:bool) -> None\nC++: void SetLessPartition(bool l)\n\n"},
  {"SetSkeletonSmoothing", PyttkContourForests_SetSkeletonSmoothing, METH_VARARGS,
   "SetSkeletonSmoothing(self, skeletonSmooth:float) -> None\nC++: void SetSkeletonSmoothing(double skeletonSmooth)\n\n"},
  {"SetSimplificationType", PyttkContourForests_SetSimplificationType, METH_VARARGS,
   "SetSimplificationType(self, type:int) -> None\nC++: void SetSimplificationType(int type)\n\n"},
  {"SetSimplificationThreshold", PyttkContourForests_SetSimplificationThreshold, METH_VARARGS,
   "SetSimplificationThreshold(self, simplificationThreshold:float)\n    -> None\nC++: void SetSimplificationThreshold(\n    double simplificationThreshold)\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyttkContourForests_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("force_input_offset_scalar_field"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkContourForests_GetForceInputOffsetScalarField(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkContourForests_SetForceInputOffsetScalarField(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkContourForests_SetForceInputOffsetScalarField(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetForceInputOffsetScalarField/SetForceInputOffsetScalarField\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("tree_type"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkContourForests_SetTreeType(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkContourForests_SetTreeType(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetTreeType\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("arc_resolution"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkContourForests_SetArcResolution(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkContourForests_SetArcResolution(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetArcResolution\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("partition_number"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkContourForests_SetPartitionNumber(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkContourForests_SetPartitionNumber(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetPartitionNumber\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("less_partition"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkContourForests_SetLessPartition(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkContourForests_SetLessPartition(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetLessPartition\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("skeleton_smoothing"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkContourForests_SetSkeletonSmoothing(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkContourForests_SetSkeletonSmoothing(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetSkeletonSmoothing\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("simplification_type"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkContourForests_SetSimplificationType(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkContourForests_SetSimplificationType(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetSimplificationType\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("simplification_threshold"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkContourForests_SetSimplificationThreshold(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkContourForests_SetSimplificationThreshold(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetSimplificationThreshold\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyttkContourForests_Doc =
  "ttkContourForests - \\ingroup vtk\n\n"
  "Superclass: ttkAlgorithm\n\n"
  "\\author Guillaume Favelier <guillaume.favelier@lip6.fr>.\\author\n"
  "Julien Tierny <julien.tierny@lip6.fr>\\date February 2016\n\n"
  "TTK VTK-filter that efficiently computes the contour tree of\n"
  "scalar data and more (data segmentation, topological simplification,\n"
  "persistence diagrams, persistence curves, etc.).\n\n"
  "This filter takes a scalar field attached as point data to a geometry\n"
  "(either 2D or 3D, either regular grids or triangulations) and\n"
  "computes its contour tree. Several outputs are produced to encode the\n"
  "nodes of the tree (as points in 3D space), the arcs of the tree and\n"
  "the data segmentation.\n\n"
  "\\param Input Input scalar field, either 2D or 3D, either regular\n"
  "grid or triangulation (vtkDataSet)\n"
  "\\param Output0 Output nodes (vtkPolyData)\n"
  "\\param Output1 Output arcs (vtkPolyData)\n"
  "\\param Output2 Output data segmentation (vtkUnstructuredGrid)\n"
  "\\param Output3 Output persistence diagram (vtkUnstructuredGrid)\n"
  "\\param Output4 Output persistence curve (vtkUnstructuredGrid)\n\n"
  "This filter can be used as any other VTK filter (for instance, by\n"
  "using the sequence of calls SetInputData(), Update(), GetOutput()).\n\n"
  "See the related ParaView example state files for usage examples\n"
  "within a VTK pipeline.\n\n"
  "Related publication\n\n"
  "\"Contour Forests: Fast Multi-threaded Augmented Contour Trees\"\n\n"
  "Charles Gueunet, Pierre Fortin, Julien Jomier, Julien Tierny\n\n"
  "Proc. of IEEE LDAV 2016.\n\n"
  "\\sa ttk::cf::ContourForests\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyttkContourForests_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "ttkContourForests.ttkContourForests", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyttkContourForests_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyttkContourForests_StaticNew()
{
  return ttkContourForests::New();
}

PyObject *PyttkContourForests_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyttkContourForests_Type, PyttkContourForests_Methods,
    "ttkContourForests",
 &PyttkContourForests_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("ttkAlgorithm");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyttkContourForests_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_ttkContourForests(
  PyObject *dict)
{
  PyObject *o;
  o = PyttkContourForests_ClassNew();

  if (o && PyDict_SetItemString(dict, "ttkContourForests", o) != 0)
  {
    Py_DECREF(o);
  }

}

