// python wrapper for ttkContinuousScatterPlot
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "ttkContinuousScatterPlot.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_ttkContinuousScatterPlot(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyttkContinuousScatterPlot_ClassNew(); }


static PyObject *
PyttkContinuousScatterPlot_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = ttkContinuousScatterPlot::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkContinuousScatterPlot_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkContinuousScatterPlot *op = static_cast<ttkContinuousScatterPlot *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->ttkContinuousScatterPlot::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkContinuousScatterPlot_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    ttkContinuousScatterPlot *tempr = ttkContinuousScatterPlot::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkContinuousScatterPlot_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkContinuousScatterPlot *op = static_cast<ttkContinuousScatterPlot *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    ttkContinuousScatterPlot *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->ttkContinuousScatterPlot::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkContinuousScatterPlot_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = ttkContinuousScatterPlot::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkContinuousScatterPlot_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkContinuousScatterPlot *op = static_cast<ttkContinuousScatterPlot *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->ttkContinuousScatterPlot::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkContinuousScatterPlot_SetWithDummyValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetWithDummyValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkContinuousScatterPlot *op = static_cast<ttkContinuousScatterPlot *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetWithDummyValue(temp0);
    }
    else
    {
      op->ttkContinuousScatterPlot::SetWithDummyValue(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkContinuousScatterPlot_GetWithDummyValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetWithDummyValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkContinuousScatterPlot *op = static_cast<ttkContinuousScatterPlot *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetWithDummyValue() :
      op->ttkContinuousScatterPlot::GetWithDummyValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkContinuousScatterPlot_SetDummyValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDummyValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkContinuousScatterPlot *op = static_cast<ttkContinuousScatterPlot *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetDummyValue(temp0);
    }
    else
    {
      op->ttkContinuousScatterPlot::SetDummyValue(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkContinuousScatterPlot_GetDummyValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDummyValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkContinuousScatterPlot *op = static_cast<ttkContinuousScatterPlot *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetDummyValue() :
      op->ttkContinuousScatterPlot::GetDummyValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkContinuousScatterPlot_SetProjectImageSupport(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetProjectImageSupport");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkContinuousScatterPlot *op = static_cast<ttkContinuousScatterPlot *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetProjectImageSupport(temp0);
    }
    else
    {
      op->ttkContinuousScatterPlot::SetProjectImageSupport(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkContinuousScatterPlot_GetProjectImageSupport(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetProjectImageSupport");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkContinuousScatterPlot *op = static_cast<ttkContinuousScatterPlot *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetProjectImageSupport() :
      op->ttkContinuousScatterPlot::GetProjectImageSupport());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkContinuousScatterPlot_SetScatterplotResolution(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetScatterplotResolution");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkContinuousScatterPlot *op = static_cast<ttkContinuousScatterPlot *>(vp);

  int temp0;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetScatterplotResolution(temp0, temp1);
    }
    else
    {
      op->ttkContinuousScatterPlot::SetScatterplotResolution(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyttkContinuousScatterPlot_Methods[] = {
  {"IsTypeOf", PyttkContinuousScatterPlot_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyttkContinuousScatterPlot_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyttkContinuousScatterPlot_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> ttkContinuousScatterPlot\nC++: static ttkContinuousScatterPlot *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyttkContinuousScatterPlot_NewInstance, METH_VARARGS,
   "NewInstance(self) -> ttkContinuousScatterPlot\nC++: ttkContinuousScatterPlot *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyttkContinuousScatterPlot_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyttkContinuousScatterPlot_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetWithDummyValue", PyttkContinuousScatterPlot_SetWithDummyValue, METH_VARARGS,
   "SetWithDummyValue(self, _arg:bool) -> None\nC++: virtual void SetWithDummyValue(bool _arg)\n\n"},
  {"GetWithDummyValue", PyttkContinuousScatterPlot_GetWithDummyValue, METH_VARARGS,
   "GetWithDummyValue(self) -> bool\nC++: virtual bool GetWithDummyValue()\n\n"},
  {"SetDummyValue", PyttkContinuousScatterPlot_SetDummyValue, METH_VARARGS,
   "SetDummyValue(self, _arg:float) -> None\nC++: virtual void SetDummyValue(double _arg)\n\n"},
  {"GetDummyValue", PyttkContinuousScatterPlot_GetDummyValue, METH_VARARGS,
   "GetDummyValue(self) -> float\nC++: virtual double GetDummyValue()\n\n"},
  {"SetProjectImageSupport", PyttkContinuousScatterPlot_SetProjectImageSupport, METH_VARARGS,
   "SetProjectImageSupport(self, _arg:bool) -> None\nC++: virtual void SetProjectImageSupport(bool _arg)\n\n"},
  {"GetProjectImageSupport", PyttkContinuousScatterPlot_GetProjectImageSupport, METH_VARARGS,
   "GetProjectImageSupport(self) -> bool\nC++: virtual bool GetProjectImageSupport()\n\n"},
  {"SetScatterplotResolution", PyttkContinuousScatterPlot_SetScatterplotResolution, METH_VARARGS,
   "SetScatterplotResolution(self, N:int, M:int) -> None\nC++: void SetScatterplotResolution(int N, int M)\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyttkContinuousScatterPlot_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("with_dummy_value"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkContinuousScatterPlot_GetWithDummyValue(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkContinuousScatterPlot_SetWithDummyValue(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkContinuousScatterPlot_SetWithDummyValue(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetWithDummyValue/SetWithDummyValue\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("dummy_value"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkContinuousScatterPlot_GetDummyValue(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkContinuousScatterPlot_SetDummyValue(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkContinuousScatterPlot_SetDummyValue(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetDummyValue/SetDummyValue\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("project_image_support"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkContinuousScatterPlot_GetProjectImageSupport(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkContinuousScatterPlot_SetProjectImageSupport(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkContinuousScatterPlot_SetProjectImageSupport(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetProjectImageSupport/SetProjectImageSupport\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("scatterplot_resolution"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkContinuousScatterPlot_SetScatterplotResolution(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkContinuousScatterPlot_SetScatterplotResolution(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetScatterplotResolution\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyttkContinuousScatterPlot_Doc =
  "ttkContinuousScatterPlot - \\ingroup vtk\n\n"
  "Superclass: ttkAlgorithm\n\n"
  "\\author Guillaume Favelier <guillaume.favelier@lip6.fr>\\author Julien\n"
  "Tierny <julien.tierny@lip6.fr>\\date March 2016\n\n"
  "TTK VTK-filter that computes the continuous scatterplot of bivariate\n"
  "volumetric data.\n\n"
  "This filter produces a 2D vtkUnstructuredGrid with a scalar field\n"
  "(named \"Density\") representing the continuous scatter plot (attached\n"
  "to the 2D geometry as point data). A point mask is also attached to\n"
  "the 2D geometry as point data.\n\n"
  "The components of the input bivariate data must be specified as\n"
  "independent scalar fields attached to the input geometry as point\n"
  "data.\n\n"
  "\\param Input Input bivariate volumetric data-set, either regular\n"
  "    grids or\n"
  "tetrahedral meshes (vtkDataSet)\n"
  "\\param Output Output 2D continuous scatter plot (vtkUnstructuredGrid)\n\n"
  "This module respects the following convention regarding the order of\n"
  "the input arrays to process (SetInputArrayToProcess()):\n"
  "\\param idx 0: first scalar array.\n"
  "\\param idx 1: second scalar array.\n\n"
  "This filter can be used as any other VTK filter (for instance, by\n"
  "using the sequence of calls SetInputData(), Update(), GetOutput()).\n\n"
  "See the related ParaView example state files for usage examples\n"
  "within a VTK pipeline.\n\n"
  "Related publication\n\n"
  "\"Continuous Scatterplots\"\n\n"
  "Sven Bachthaler, Daniel Weiskopf\n\n"
  "Proc. of IEEE VIS 2008.\n\n"
  "IEEE Transactions on Visualization and Computer Graphics, 2008.\n\n"
  "\\sa ttk::ContinuousScatterPlot\n\n"
  "Online examples:\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/builtInExample2/\"\n"
  "  > Builtin example 2\\n\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyttkContinuousScatterPlot_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "ttkContinuousScatterPlot.ttkContinuousScatterPlot", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyttkContinuousScatterPlot_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyttkContinuousScatterPlot_StaticNew()
{
  return ttkContinuousScatterPlot::New();
}

PyObject *PyttkContinuousScatterPlot_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyttkContinuousScatterPlot_Type, PyttkContinuousScatterPlot_Methods,
    "ttkContinuousScatterPlot",
 &PyttkContinuousScatterPlot_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("ttkAlgorithm");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyttkContinuousScatterPlot_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_ttkContinuousScatterPlot(
  PyObject *dict)
{
  PyObject *o;
  o = PyttkContinuousScatterPlot_ClassNew();

  if (o && PyDict_SetItemString(dict, "ttkContinuousScatterPlot", o) != 0)
  {
    Py_DECREF(o);
  }

}

