// python wrapper for ttkArrayEditor
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "ttkArrayEditor.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_ttkArrayEditor(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyttkArrayEditor_ClassNew(); }

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyttkArrayEditor_MODE_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "ttkArrayEditor.ttkArrayEditor.MODE", // tp_name
  sizeof(PyLongObject), // tp_basicsize
  0, // tp_itemsize
  nullptr, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  nullptr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  nullptr, // tp_str
  nullptr, // tp_getattro
  nullptr, // tp_setattro
  nullptr, // tp_as_buffer
  Py_TPFLAGS_DEFAULT
#if PY_VERSION_HEX >= 0x030A0000
    | Py_TPFLAGS_DISALLOW_INSTANTIATION
#endif
  , // tp_flags
  nullptr, // tp_doc
  nullptr, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  0, // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  nullptr, // tp_getset
  &PyLong_Type, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  0, // tp_dictoffset
  nullptr, // tp_init
  nullptr, // tp_alloc
  nullptr, // tp_new
  PyObject_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

template<class T>
static PyObject *PyttkArrayEditor_MODE_FromEnum(T val)
{
  return PyVTKEnum_New(&PyttkArrayEditor_MODE_Type, static_cast<int>(val));
}


static PyObject *
PyttkArrayEditor_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = ttkArrayEditor::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkArrayEditor_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkArrayEditor *op = static_cast<ttkArrayEditor *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->ttkArrayEditor::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkArrayEditor_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    ttkArrayEditor *tempr = ttkArrayEditor::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkArrayEditor_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkArrayEditor *op = static_cast<ttkArrayEditor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    ttkArrayEditor *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->ttkArrayEditor::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkArrayEditor_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = ttkArrayEditor::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkArrayEditor_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkArrayEditor *op = static_cast<ttkArrayEditor *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->ttkArrayEditor::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkArrayEditor_SetEditorMode_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetEditorMode");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkArrayEditor *op = static_cast<ttkArrayEditor *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetEditorMode(temp0);
    }
    else
    {
      op->ttkArrayEditor::SetEditorMode(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyttkArrayEditor_SetEditorMode_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetEditorMode");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkArrayEditor *op = static_cast<ttkArrayEditor *>(vp);

  typedef ttkArrayEditor::MODE temp0_type;
  temp0_type temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetEnumValue(temp0, "ttkArrayEditor.MODE"))
  {
    if (ap.IsBound())
    {
      op->SetEditorMode(temp0);
    }
    else
    {
      op->ttkArrayEditor::SetEditorMode(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyttkArrayEditor_SetEditorMode_Methods[] = {
  {"SetEditorMode", PyttkArrayEditor_SetEditorMode_s1, METH_VARARGS,
   "@i"},
  {"SetEditorMode", PyttkArrayEditor_SetEditorMode_s2, METH_VARARGS,
   "@E ttkArrayEditor.MODE"},
  {nullptr, nullptr, 0, nullptr}
};

static PyObject *
PyttkArrayEditor_SetEditorMode(PyObject *self, PyObject *args)
{
  PyMethodDef *methods = PyttkArrayEditor_SetEditorMode_Methods;
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return vtkPythonOverload::CallMethod(methods, self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetEditorMode");
  return nullptr;
}


static PyObject *
PyttkArrayEditor_GetEditorMode(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetEditorMode");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkArrayEditor *op = static_cast<ttkArrayEditor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    typedef ttkArrayEditor::MODE tempr_type;
  tempr_type tempr = (ap.IsBound() ?
      op->GetEditorMode() :
      op->ttkArrayEditor::GetEditorMode());

    if (!ap.ErrorOccurred())
    {
      result = PyttkArrayEditor_MODE_FromEnum(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkArrayEditor_SetTargetAssociation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTargetAssociation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkArrayEditor *op = static_cast<ttkArrayEditor *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetTargetAssociation(temp0);
    }
    else
    {
      op->ttkArrayEditor::SetTargetAssociation(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkArrayEditor_GetTargetAssociation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTargetAssociation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkArrayEditor *op = static_cast<ttkArrayEditor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetTargetAssociation() :
      op->ttkArrayEditor::GetTargetAssociation());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkArrayEditor_SetDataString(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDataString");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkArrayEditor *op = static_cast<ttkArrayEditor *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetDataString(temp0);
    }
    else
    {
      op->ttkArrayEditor::SetDataString(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkArrayEditor_GetDataString(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDataString");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkArrayEditor *op = static_cast<ttkArrayEditor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    std::string tempr = (ap.IsBound() ?
      op->GetDataString() :
      op->ttkArrayEditor::GetDataString());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkArrayEditor_SetReplaceExistingArrays(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetReplaceExistingArrays");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkArrayEditor *op = static_cast<ttkArrayEditor *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetReplaceExistingArrays(temp0);
    }
    else
    {
      op->ttkArrayEditor::SetReplaceExistingArrays(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkArrayEditor_GetReplaceExistingArrays(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetReplaceExistingArrays");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkArrayEditor *op = static_cast<ttkArrayEditor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetReplaceExistingArrays() :
      op->ttkArrayEditor::GetReplaceExistingArrays());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkArrayEditor_SetTargetArrayName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTargetArrayName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkArrayEditor *op = static_cast<ttkArrayEditor *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetTargetArrayName(temp0);
    }
    else
    {
      op->ttkArrayEditor::SetTargetArrayName(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkArrayEditor_GetTargetArrayName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTargetArrayName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkArrayEditor *op = static_cast<ttkArrayEditor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    std::string tempr = (ap.IsBound() ?
      op->GetTargetArrayName() :
      op->ttkArrayEditor::GetTargetArrayName());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkArrayEditor_SetTargetArrayType(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTargetArrayType");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkArrayEditor *op = static_cast<ttkArrayEditor *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetTargetArrayType(temp0);
    }
    else
    {
      op->ttkArrayEditor::SetTargetArrayType(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkArrayEditor_GetTargetArrayType(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTargetArrayType");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkArrayEditor *op = static_cast<ttkArrayEditor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetTargetArrayType() :
      op->ttkArrayEditor::GetTargetArrayType());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkArrayEditor_SetTargetArrayIndexation_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTargetArrayIndexation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkArrayEditor *op = static_cast<ttkArrayEditor *>(vp);

  int temp0;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetTargetArrayIndexation(temp0, temp1);
    }
    else
    {
      op->ttkArrayEditor::SetTargetArrayIndexation(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyttkArrayEditor_SetTargetArrayIndexation_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTargetArrayIndexation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkArrayEditor *op = static_cast<ttkArrayEditor *>(vp);

  const size_t size0 = 2;
  int temp0[2];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    if (ap.IsBound())
    {
      op->SetTargetArrayIndexation(temp0);
    }
    else
    {
      op->ttkArrayEditor::SetTargetArrayIndexation(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyttkArrayEditor_SetTargetArrayIndexation(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 2:
      return PyttkArrayEditor_SetTargetArrayIndexation_s1(self, args);
    case 1:
      return PyttkArrayEditor_SetTargetArrayIndexation_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetTargetArrayIndexation");
  return nullptr;
}


static PyObject *
PyttkArrayEditor_GetTargetArrayIndexation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTargetArrayIndexation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkArrayEditor *op = static_cast<ttkArrayEditor *>(vp);

  size_t sizer = 2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int *tempr = (ap.IsBound() ?
      op->GetTargetArrayIndexation() :
      op->ttkArrayEditor::GetTargetArrayIndexation());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}


static PyObject *
PyttkArrayEditor_GetArraySelection(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetArraySelection");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkArrayEditor *op = static_cast<ttkArrayEditor *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    vtkDataArraySelection *tempr = (ap.IsBound() ?
      op->GetArraySelection(temp0) :
      op->ttkArrayEditor::GetArraySelection(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkArrayEditor_GetPointDataArraySelection(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPointDataArraySelection");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkArrayEditor *op = static_cast<ttkArrayEditor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkDataArraySelection *tempr = (ap.IsBound() ?
      op->GetPointDataArraySelection() :
      op->ttkArrayEditor::GetPointDataArraySelection());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkArrayEditor_GetCellDataArraySelection(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetCellDataArraySelection");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkArrayEditor *op = static_cast<ttkArrayEditor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkDataArraySelection *tempr = (ap.IsBound() ?
      op->GetCellDataArraySelection() :
      op->ttkArrayEditor::GetCellDataArraySelection());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkArrayEditor_GetFieldDataArraySelection(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFieldDataArraySelection");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkArrayEditor *op = static_cast<ttkArrayEditor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkDataArraySelection *tempr = (ap.IsBound() ?
      op->GetFieldDataArraySelection() :
      op->ttkArrayEditor::GetFieldDataArraySelection());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkArrayEditor_GetVertexDataArraySelection(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetVertexDataArraySelection");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkArrayEditor *op = static_cast<ttkArrayEditor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkDataArraySelection *tempr = (ap.IsBound() ?
      op->GetVertexDataArraySelection() :
      op->ttkArrayEditor::GetVertexDataArraySelection());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkArrayEditor_GetEdgeDataArraySelection(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetEdgeDataArraySelection");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkArrayEditor *op = static_cast<ttkArrayEditor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkDataArraySelection *tempr = (ap.IsBound() ?
      op->GetEdgeDataArraySelection() :
      op->ttkArrayEditor::GetEdgeDataArraySelection());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkArrayEditor_GetRowDataArraySelection(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRowDataArraySelection");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkArrayEditor *op = static_cast<ttkArrayEditor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkDataArraySelection *tempr = (ap.IsBound() ?
      op->GetRowDataArraySelection() :
      op->ttkArrayEditor::GetRowDataArraySelection());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}

static PyMethodDef PyttkArrayEditor_Methods[] = {
  {"IsTypeOf", PyttkArrayEditor_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyttkArrayEditor_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyttkArrayEditor_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> ttkArrayEditor\nC++: static ttkArrayEditor *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyttkArrayEditor_NewInstance, METH_VARARGS,
   "NewInstance(self) -> ttkArrayEditor\nC++: ttkArrayEditor *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyttkArrayEditor_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyttkArrayEditor_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetEditorMode", PyttkArrayEditor_SetEditorMode, METH_VARARGS,
   "SetEditorMode(self, _arg:int) -> None\nC++: virtual void SetEditorMode(int _arg)\nSetEditorMode(self, _arg:MODE) -> None\nC++: virtual void SetEditorMode(MODE _arg)\n\n"},
  {"GetEditorMode", PyttkArrayEditor_GetEditorMode, METH_VARARGS,
   "GetEditorMode(self) -> MODE\nC++: virtual MODE GetEditorMode()\n\n"},
  {"SetTargetAssociation", PyttkArrayEditor_SetTargetAssociation, METH_VARARGS,
   "SetTargetAssociation(self, _arg:int) -> None\nC++: virtual void SetTargetAssociation(int _arg)\n\n"},
  {"GetTargetAssociation", PyttkArrayEditor_GetTargetAssociation, METH_VARARGS,
   "GetTargetAssociation(self) -> int\nC++: virtual int GetTargetAssociation()\n\n"},
  {"SetDataString", PyttkArrayEditor_SetDataString, METH_VARARGS,
   "SetDataString(self, _arg:str) -> None\nC++: virtual void SetDataString(const std::string &_arg)\n\n"},
  {"GetDataString", PyttkArrayEditor_GetDataString, METH_VARARGS,
   "GetDataString(self) -> str\nC++: virtual std::string GetDataString()\n\n"},
  {"SetReplaceExistingArrays", PyttkArrayEditor_SetReplaceExistingArrays, METH_VARARGS,
   "SetReplaceExistingArrays(self, _arg:bool) -> None\nC++: virtual void SetReplaceExistingArrays(bool _arg)\n\n"},
  {"GetReplaceExistingArrays", PyttkArrayEditor_GetReplaceExistingArrays, METH_VARARGS,
   "GetReplaceExistingArrays(self) -> bool\nC++: virtual bool GetReplaceExistingArrays()\n\n"},
  {"SetTargetArrayName", PyttkArrayEditor_SetTargetArrayName, METH_VARARGS,
   "SetTargetArrayName(self, _arg:str) -> None\nC++: virtual void SetTargetArrayName(const std::string &_arg)\n\n"},
  {"GetTargetArrayName", PyttkArrayEditor_GetTargetArrayName, METH_VARARGS,
   "GetTargetArrayName(self) -> str\nC++: virtual std::string GetTargetArrayName()\n\n"},
  {"SetTargetArrayType", PyttkArrayEditor_SetTargetArrayType, METH_VARARGS,
   "SetTargetArrayType(self, _arg:int) -> None\nC++: virtual void SetTargetArrayType(int _arg)\n\n"},
  {"GetTargetArrayType", PyttkArrayEditor_GetTargetArrayType, METH_VARARGS,
   "GetTargetArrayType(self) -> int\nC++: virtual int GetTargetArrayType()\n\n"},
  {"SetTargetArrayIndexation", PyttkArrayEditor_SetTargetArrayIndexation, METH_VARARGS,
   "SetTargetArrayIndexation(self, _arg1:int, _arg2:int) -> None\nC++: virtual void SetTargetArrayIndexation(int _arg1, int _arg2)\nSetTargetArrayIndexation(self, _arg:(int, int)) -> None\nC++: void SetTargetArrayIndexation(const int _arg[2])\n\n"},
  {"GetTargetArrayIndexation", PyttkArrayEditor_GetTargetArrayIndexation, METH_VARARGS,
   "GetTargetArrayIndexation(self) -> (int, int)\nC++: virtual int *GetTargetArrayIndexation()\n\n"},
  {"GetArraySelection", PyttkArrayEditor_GetArraySelection, METH_VARARGS,
   "GetArraySelection(self, association:int) -> vtkDataArraySelection\nC++: vtkDataArraySelection *GetArraySelection(int association)\n\n"},
  {"GetPointDataArraySelection", PyttkArrayEditor_GetPointDataArraySelection, METH_VARARGS,
   "GetPointDataArraySelection(self) -> vtkDataArraySelection\nC++: vtkDataArraySelection *GetPointDataArraySelection()\n\n"},
  {"GetCellDataArraySelection", PyttkArrayEditor_GetCellDataArraySelection, METH_VARARGS,
   "GetCellDataArraySelection(self) -> vtkDataArraySelection\nC++: vtkDataArraySelection *GetCellDataArraySelection()\n\n"},
  {"GetFieldDataArraySelection", PyttkArrayEditor_GetFieldDataArraySelection, METH_VARARGS,
   "GetFieldDataArraySelection(self) -> vtkDataArraySelection\nC++: vtkDataArraySelection *GetFieldDataArraySelection()\n\n"},
  {"GetVertexDataArraySelection", PyttkArrayEditor_GetVertexDataArraySelection, METH_VARARGS,
   "GetVertexDataArraySelection(self) -> vtkDataArraySelection\nC++: vtkDataArraySelection *GetVertexDataArraySelection()\n\n"},
  {"GetEdgeDataArraySelection", PyttkArrayEditor_GetEdgeDataArraySelection, METH_VARARGS,
   "GetEdgeDataArraySelection(self) -> vtkDataArraySelection\nC++: vtkDataArraySelection *GetEdgeDataArraySelection()\n\n"},
  {"GetRowDataArraySelection", PyttkArrayEditor_GetRowDataArraySelection, METH_VARARGS,
   "GetRowDataArraySelection(self) -> vtkDataArraySelection\nC++: vtkDataArraySelection *GetRowDataArraySelection()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyttkArrayEditor_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("editor_mode"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkArrayEditor_SetEditorMode(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkArrayEditor_SetEditorMode(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetEditorMode\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("editor_mode"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkArrayEditor_GetEditorMode(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkArrayEditor_SetEditorMode(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkArrayEditor_SetEditorMode(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetEditorMode/SetEditorMode\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("target_association"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkArrayEditor_GetTargetAssociation(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkArrayEditor_SetTargetAssociation(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkArrayEditor_SetTargetAssociation(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetTargetAssociation/SetTargetAssociation\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("data_string"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkArrayEditor_GetDataString(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkArrayEditor_SetDataString(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkArrayEditor_SetDataString(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetDataString/SetDataString\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("replace_existing_arrays"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkArrayEditor_GetReplaceExistingArrays(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkArrayEditor_SetReplaceExistingArrays(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkArrayEditor_SetReplaceExistingArrays(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetReplaceExistingArrays/SetReplaceExistingArrays\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("target_array_name"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkArrayEditor_GetTargetArrayName(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkArrayEditor_SetTargetArrayName(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkArrayEditor_SetTargetArrayName(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetTargetArrayName/SetTargetArrayName\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("target_array_type"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkArrayEditor_GetTargetArrayType(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkArrayEditor_SetTargetArrayType(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkArrayEditor_SetTargetArrayType(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetTargetArrayType/SetTargetArrayType\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("target_array_indexation"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkArrayEditor_GetTargetArrayIndexation(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkArrayEditor_SetTargetArrayIndexation(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkArrayEditor_SetTargetArrayIndexation(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetTargetArrayIndexation/SetTargetArrayIndexation\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("point_data_array_selection"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkArrayEditor_GetPointDataArraySelection(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetPointDataArraySelection\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("cell_data_array_selection"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkArrayEditor_GetCellDataArraySelection(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetCellDataArraySelection\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("field_data_array_selection"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkArrayEditor_GetFieldDataArraySelection(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetFieldDataArraySelection\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("vertex_data_array_selection"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkArrayEditor_GetVertexDataArraySelection(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetVertexDataArraySelection\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("edge_data_array_selection"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkArrayEditor_GetEdgeDataArraySelection(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetEdgeDataArraySelection\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("row_data_array_selection"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkArrayEditor_GetRowDataArraySelection(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetRowDataArraySelection\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyttkArrayEditor_Doc =
  "ttkArrayEditor - \\ingroup vtk\n\n"
  "Superclass: ttkAlgorithm\n\n"
  "\\author Jonas Lukasczyk <jl@jluk.de>\\date 1.10.2018\n\n"
  "TTK VTK-filter that edit arrays of a vtkDataObject.\n\n"
  "This filter adds data arrays to a 'vtkDataObject' (called target)\n"
  "based on a string or point/cell/field data of an optional second\n"
  "'vtkDataObject' (called source). This filter can also be used to\n"
  "directly edit an array (including renaming, type conversion, and\n"
  "reindexing).\n\n"
  "Online examples:\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/cinemaIO/\">Cinema\n"
  "   IO example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/contourTreeAlignment/\"\n"
  "  >Contour Tree Alignment example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/mergeTreeWAE/\">Me\n"
  "  rge tree Wasserstein Auto-Encoder example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/nestedTrackingFromOverlap/\"\n"
  "  >Nested Tracking From Overlap example\\n\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyttkArrayEditor_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "ttkArrayEditor.ttkArrayEditor", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyttkArrayEditor_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyttkArrayEditor_StaticNew()
{
  return ttkArrayEditor::New();
}

PyObject *PyttkArrayEditor_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyttkArrayEditor_Type, PyttkArrayEditor_Methods,
    "ttkArrayEditor",
 &PyttkArrayEditor_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("ttkAlgorithm");

  PyObject *d = pytype->tp_dict;
  PyObject *o;

  PyType_Ready(&PyttkArrayEditor_MODE_Type);
  // members of ttkArrayEditor::MODE
  {
    PyObject *enumval;
    PyObject *enumdict = PyDict_New();
    PyttkArrayEditor_MODE_Type.tp_dict = enumdict;

    typedef ttkArrayEditor::MODE cxx_enum_type;
    static const struct {
      const char *name; cxx_enum_type value;
    } constants[4] = {
      { "ADD_ARRAYS_FROM_STRING", cxx_enum_type::ADD_ARRAYS_FROM_STRING },
      { "ADD_ARRAYS_FROM_SOURCE", cxx_enum_type::ADD_ARRAYS_FROM_SOURCE },
      { "FILTER_ARRAYS_FROM_SOURCE", cxx_enum_type::FILTER_ARRAYS_FROM_SOURCE },
      { "EDIT_ARRAY", cxx_enum_type::EDIT_ARRAY },
    };

    for (int c = 0; c < 4; c++)
    {
      enumval = PyttkArrayEditor_MODE_FromEnum(constants[c].value);
      if (enumval)
      {
        PyDict_SetItemString(enumdict, constants[c].name, enumval);
        Py_DECREF(enumval);
      }
    }
  }

  PyVTKEnum_Add(&PyttkArrayEditor_MODE_Type, "ttkArrayEditor.MODE");

  o = (PyObject *)&PyttkArrayEditor_MODE_Type;
  if (PyDict_SetItemString(d, "MODE", o) != 0)
  {
    Py_DECREF(o);
  }

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyttkArrayEditor_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_ttkArrayEditor(
  PyObject *dict)
{
  PyObject *o;
  o = PyttkArrayEditor_ClassNew();

  if (o && PyDict_SetItemString(dict, "ttkArrayEditor", o) != 0)
  {
    Py_DECREF(o);
  }

}

