/* RsyncTask.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from RsyncTask.vala, do not modify */

/*
 * RsyncTask.vala
 *
 * Copyright 2012-2018 Tony George <teejeetech@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 *
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>
#include <gee.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_ASYNC_TASK (async_task_get_type ())
#define ASYNC_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ASYNC_TASK, AsyncTask))
#define ASYNC_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ASYNC_TASK, AsyncTaskClass))
#define IS_ASYNC_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ASYNC_TASK))
#define IS_ASYNC_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ASYNC_TASK))
#define ASYNC_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ASYNC_TASK, AsyncTaskClass))

typedef struct _AsyncTask AsyncTask;
typedef struct _AsyncTaskClass AsyncTaskClass;
typedef struct _AsyncTaskPrivate AsyncTaskPrivate;
typedef enum  {
	APP_STATUS_NOT_STARTED,
	APP_STATUS_RUNNING,
	APP_STATUS_PAUSED,
	APP_STATUS_FINISHED,
	APP_STATUS_CANCELLED,
	APP_STATUS_PASSWORD_REQUIRED
} AppStatus;

#define TYPE_APP_STATUS (app_status_get_type ())

#define TYPE_RSYNC_TASK (rsync_task_get_type ())
#define RSYNC_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RSYNC_TASK, RsyncTask))
#define RSYNC_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RSYNC_TASK, RsyncTaskClass))
#define IS_RSYNC_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RSYNC_TASK))
#define IS_RSYNC_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RSYNC_TASK))
#define RSYNC_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RSYNC_TASK, RsyncTaskClass))

typedef struct _RsyncTask RsyncTask;
typedef struct _RsyncTaskClass RsyncTaskClass;
typedef struct _RsyncTaskPrivate RsyncTaskPrivate;
enum  {
	RSYNC_TASK_0_PROPERTY,
	RSYNC_TASK_NUM_PROPERTIES
};
static GParamSpec* rsync_task_properties[RSYNC_TASK_NUM_PROPERTIES];
typedef enum  {
	RSYNC_TASK_REGEX_TYPE_Status,
	RSYNC_TASK_REGEX_TYPE_Created,
	RSYNC_TASK_REGEX_TYPE_LogCreated,
	RSYNC_TASK_REGEX_TYPE_Deleted,
	RSYNC_TASK_REGEX_TYPE_LogDeleted,
	RSYNC_TASK_REGEX_TYPE_Modified,
	RSYNC_TASK_REGEX_TYPE_LogModified,
	RSYNC_TASK_REGEX_TYPE_Unchanged,
	RSYNC_TASK_REGEX_TYPE_LogUnchanged,
	RSYNC_TASK_REGEX_TYPE_TotalSize,
	RSYNC_TASK_REGEX_TYPE_Count
} RsyncTaskRegexType;

#define RSYNC_TASK_TYPE_REGEX_TYPE (rsync_task_regex_type_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_FILE_ITEM (file_item_get_type ())
#define FILE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FILE_ITEM, FileItem))
#define FILE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FILE_ITEM, FileItemClass))
#define IS_FILE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FILE_ITEM))
#define IS_FILE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FILE_ITEM))
#define FILE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FILE_ITEM, FileItemClass))

typedef struct _FileItem FileItem;
typedef struct _FileItemClass FileItemClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_match_info_unref0(var) ((var == NULL) ? NULL : (var = (g_match_info_unref (var), NULL)))
typedef struct _FileItemPrivate FileItemPrivate;

struct _AsyncTask {
	GObject parent_instance;
	AsyncTaskPrivate * priv;
	GDataOutputStream* dos_log;
	GPid child_pid;
	gchar* script_file;
	gchar* working_dir;
	AppStatus status;
	GMutex status_line_mutex;
	gint exit_code;
	GTimer* timer;
	gdouble progress;
	gdouble percent;
	gint64 prg_count;
	gint64 prg_count_total;
};

struct _AsyncTaskClass {
	GObjectClass parent_class;
	void (*prepare) (AsyncTask* self);
	gchar* (*build_script) (AsyncTask* self);
	gboolean (*begin) (AsyncTask* self);
	void (*execute) (AsyncTask* self);
	void (*parse_stdout_line) (AsyncTask* self, const gchar* out_line);
	void (*parse_stderr_line) (AsyncTask* self, const gchar* err_line);
	void (*finish_task) (AsyncTask* self);
};

struct _RsyncTask {
	AsyncTask parent_instance;
	RsyncTaskPrivate * priv;
	gboolean delete_extra;
	gboolean delete_after;
	gboolean delete_excluded;
	gboolean relative;
	gchar* rsync_log_file;
	gchar* exclude_from_file;
	gchar* link_from_path;
	gchar* source_path;
	gchar* dest_path;
	gboolean verbose;
	gboolean io_nice;
	gboolean dry_run;
	GQueue* status_lines;
	gint64 status_line_count;
	gint64 total_size;
	gint64 count_created;
	gint64 count_deleted;
	gint64 count_modified;
	gint64 count_checksum;
	gint64 count_size;
	gint64 count_timestamp;
	gint64 count_permissions;
	gint64 count_owner;
	gint64 count_group;
	gint64 count_unchanged;
	GString* log;
};

struct _RsyncTaskClass {
	AsyncTaskClass parent_class;
};

struct _RsyncTaskPrivate {
	GRegex** regex_list;
	gint regex_list_length1;
	gint _regex_list_size_;
};

struct _FileItem {
	GObject parent_instance;
	FileItemPrivate * priv;
	gchar* file_name;
	gchar* file_location;
	gchar* file_path;
	gchar* file_path_prefix;
	GFileType file_type;
	GDateTime* modified;
	gchar* permissions;
	gchar* owner_user;
	gchar* owner_group;
	gchar* content_type;
	gchar* file_status;
	gboolean is_selected;
	gboolean is_symlink;
	gchar* symlink_target;
	glong file_count;
	glong dir_count;
	GIcon* icon;
};

struct _FileItemClass {
	GObjectClass parent_class;
};

static gint RsyncTask_private_offset;
static gpointer rsync_task_parent_class = NULL;

VALA_EXTERN GType async_task_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AsyncTask, g_object_unref)
VALA_EXTERN GType app_status_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType rsync_task_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RsyncTask, g_object_unref)
VALA_EXTERN void async_task_prepare (AsyncTask* self);
VALA_EXTERN gchar* async_task_build_script (AsyncTask* self);
VALA_EXTERN void async_task_parse_stdout_line (AsyncTask* self,
                                   const gchar* out_line);
VALA_EXTERN void async_task_parse_stderr_line (AsyncTask* self,
                                   const gchar* err_line);
VALA_EXTERN void async_task_finish_task (AsyncTask* self);
static GType rsync_task_regex_type_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static void _g_free0_ (gpointer var);
static inline void _g_queue_free__g_free0_ (GQueue* self);
VALA_EXTERN RsyncTask* rsync_task_new (void);
VALA_EXTERN RsyncTask* rsync_task_construct (GType object_type);
VALA_EXTERN AsyncTask* async_task_construct (GType object_type);
static void rsync_task_init_regular_expressions (RsyncTask* self);
VALA_EXTERN void tee_jee_logging_log_error (const gchar* message,
                                gboolean highlight,
                                gboolean is_warning);
static void rsync_task_real_prepare (AsyncTask* base);
static gchar* rsync_task_real_build_script (AsyncTask* base);
VALA_EXTERN gchar* tee_jee_file_system_escape_single_quote (const gchar* file_path);
VALA_EXTERN gchar* tee_jee_file_system_remove_trailing_slash (const gchar* path);
VALA_EXTERN GType file_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FileItem, g_object_unref)
VALA_EXTERN GeeArrayList* rsync_task_parse_log (RsyncTask* self,
                                    const gchar* log_file_path);
VALA_EXTERN gboolean tee_jee_file_system_file_exists (const gchar* file_path);
VALA_EXTERN void tee_jee_logging_log_debug (const gchar* message);
VALA_EXTERN gint64* tee_jee_file_system_file_line_count (const gchar* file_path);
static gint64* _int64_dup (gint64* self);
VALA_EXTERN gchar* tee_jee_file_system_path_combine (const gchar* path1,
                                         const gchar* path2);
VALA_EXTERN gchar* tee_jee_file_system_file_parent (const gchar* file_path);
VALA_EXTERN FileItem* file_item_new_from_disk_path_with_basic_info (const gchar* _file_path);
VALA_EXTERN FileItem* file_item_construct_from_disk_path_with_basic_info (GType object_type,
                                                              const gchar* _file_path);
VALA_EXTERN void tee_jee_logging_log_msg (const gchar* message,
                              gboolean highlight);
VALA_EXTERN gboolean tee_jee_file_system_file_gzip (const gchar* src_file);
static void rsync_task_real_parse_stdout_line (AsyncTask* base,
                                        const gchar* out_line);
VALA_EXTERN gboolean rsync_task_update_progress_parse_console_output (RsyncTask* self,
                                                          const gchar* line);
static void rsync_task_real_parse_stderr_line (AsyncTask* base,
                                        const gchar* err_line);
VALA_EXTERN void async_task_set_status_line (AsyncTask* self,
                                 const gchar* value);
static void rsync_task_real_finish_task (AsyncTask* base);
VALA_EXTERN gboolean tee_jee_file_system_file_write (const gchar* file_path,
                                         const gchar* contents);
static void rsync_task_finalize (GObject * obj);
static GType rsync_task_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
rsync_task_get_instance_private (RsyncTask* self)
{
	return G_STRUCT_MEMBER_P (self, RsyncTask_private_offset);
}

static GType
rsync_task_regex_type_get_type_once (void)
{
	static const GEnumValue values[] = {{RSYNC_TASK_REGEX_TYPE_Status, "RSYNC_TASK_REGEX_TYPE_Status", "status"}, {RSYNC_TASK_REGEX_TYPE_Created, "RSYNC_TASK_REGEX_TYPE_Created", "created"}, {RSYNC_TASK_REGEX_TYPE_LogCreated, "RSYNC_TASK_REGEX_TYPE_LogCreated", "logcreated"}, {RSYNC_TASK_REGEX_TYPE_Deleted, "RSYNC_TASK_REGEX_TYPE_Deleted", "deleted"}, {RSYNC_TASK_REGEX_TYPE_LogDeleted, "RSYNC_TASK_REGEX_TYPE_LogDeleted", "logdeleted"}, {RSYNC_TASK_REGEX_TYPE_Modified, "RSYNC_TASK_REGEX_TYPE_Modified", "modified"}, {RSYNC_TASK_REGEX_TYPE_LogModified, "RSYNC_TASK_REGEX_TYPE_LogModified", "logmodified"}, {RSYNC_TASK_REGEX_TYPE_Unchanged, "RSYNC_TASK_REGEX_TYPE_Unchanged", "unchanged"}, {RSYNC_TASK_REGEX_TYPE_LogUnchanged, "RSYNC_TASK_REGEX_TYPE_LogUnchanged", "logunchanged"}, {RSYNC_TASK_REGEX_TYPE_TotalSize, "RSYNC_TASK_REGEX_TYPE_TotalSize", "totalsize"}, {RSYNC_TASK_REGEX_TYPE_Count, "RSYNC_TASK_REGEX_TYPE_Count", "count"}, {0, NULL, NULL}};
	GType rsync_task_regex_type_type_id;
	rsync_task_regex_type_type_id = g_enum_register_static ("RsyncTaskRegexType", values);
	return rsync_task_regex_type_type_id;
}

static GType
rsync_task_regex_type_get_type (void)
{
	static volatile gsize rsync_task_regex_type_type_id__once = 0;
	if (g_once_init_enter (&rsync_task_regex_type_type_id__once)) {
		GType rsync_task_regex_type_type_id;
		rsync_task_regex_type_type_id = rsync_task_regex_type_get_type_once ();
		g_once_init_leave (&rsync_task_regex_type_type_id__once, rsync_task_regex_type_type_id);
	}
	return rsync_task_regex_type_type_id__once;
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static inline void
_g_queue_free__g_free0_ (GQueue* self)
{
	g_queue_free_full (self, (GDestroyNotify) _g_free0_);
}

RsyncTask*
rsync_task_construct (GType object_type)
{
	RsyncTask * self = NULL;
	GQueue* _tmp0_;
	self = (RsyncTask*) async_task_construct (object_type);
	rsync_task_init_regular_expressions (self);
	_tmp0_ = g_queue_new ();
	(self->status_lines == NULL) ? NULL : (self->status_lines = (_g_queue_free__g_free0_ (self->status_lines), NULL));
	self->status_lines = _tmp0_;
	return self;
}

RsyncTask*
rsync_task_new (void)
{
	return rsync_task_construct (TYPE_RSYNC_TASK);
}

static void
rsync_task_init_regular_expressions (RsyncTask* self)
{
	GRegex** _tmp0_;
	gint _tmp0__length1;
	GRegex** _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->regex_list;
	_tmp0__length1 = self->priv->regex_list_length1;
	if (_tmp0_ != NULL) {
		return;
	}
	_tmp1_ = g_new0 (GRegex*, RSYNC_TASK_REGEX_TYPE_Count + 1);
	self->priv->regex_list = (_vala_array_free (self->priv->regex_list, self->priv->regex_list_length1, (GDestroyNotify) g_regex_unref), NULL);
	self->priv->regex_list = _tmp1_;
	self->priv->regex_list_length1 = RSYNC_TASK_REGEX_TYPE_Count;
	self->priv->_regex_list_size_ = self->priv->regex_list_length1;
	{
		GRegex* _tmp2_ = NULL;
		GRegex* _tmp3_;
		GRegex** _tmp4_;
		gint _tmp4__length1;
		GRegex* _tmp5_;
		GRegex* _tmp6_ = NULL;
		GRegex* _tmp7_;
		GRegex** _tmp8_;
		gint _tmp8__length1;
		GRegex* _tmp9_;
		GRegex* _tmp10_ = NULL;
		GRegex* _tmp11_;
		GRegex** _tmp12_;
		gint _tmp12__length1;
		GRegex* _tmp13_;
		GRegex* _tmp14_ = NULL;
		GRegex* _tmp15_;
		GRegex** _tmp16_;
		gint _tmp16__length1;
		GRegex* _tmp17_;
		GRegex* _tmp18_ = NULL;
		GRegex* _tmp19_;
		GRegex** _tmp20_;
		gint _tmp20__length1;
		GRegex* _tmp21_;
		GRegex* _tmp22_ = NULL;
		GRegex* _tmp23_;
		GRegex** _tmp24_;
		gint _tmp24__length1;
		GRegex* _tmp25_;
		GRegex* _tmp26_ = NULL;
		GRegex* _tmp27_;
		GRegex** _tmp28_;
		gint _tmp28__length1;
		GRegex* _tmp29_;
		GRegex* _tmp30_ = NULL;
		GRegex* _tmp31_;
		GRegex** _tmp32_;
		gint _tmp32__length1;
		GRegex* _tmp33_;
		GRegex* _tmp34_ = NULL;
		GRegex* _tmp35_;
		GRegex** _tmp36_;
		gint _tmp36__length1;
		GRegex* _tmp37_;
		GRegex* _tmp38_ = NULL;
		GRegex* _tmp39_;
		GRegex** _tmp40_;
		gint _tmp40__length1;
		GRegex* _tmp41_;
		_tmp3_ = g_regex_new ("([<>ch.*])([.fdLDS])(c|\\+|\\.| )(s|\\+|\\.| )(t|\\+|\\.| )(p|\\+|\\.|" \
" )(o|\\+|\\.| )(g|\\+|\\.| )(u|\\+|\\.| )(a|\\+|\\.| )(x|\\+|\\.| ) (." \
"*)", 0, 0, &_inner_error0_);
		_tmp2_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp4_ = self->priv->regex_list;
		_tmp4__length1 = self->priv->regex_list_length1;
		_tmp5_ = _tmp2_;
		_tmp2_ = NULL;
		_g_regex_unref0 (_tmp4_[RSYNC_TASK_REGEX_TYPE_Status]);
		_tmp4_[RSYNC_TASK_REGEX_TYPE_Status] = _tmp5_;
		_tmp7_ = g_regex_new ("([<>ch.*])([.fdLDS])[+]{9} (.*)", 0, 0, &_inner_error0_);
		_tmp6_ = _tmp7_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (_tmp2_);
			goto __catch0_g_error;
		}
		_tmp8_ = self->priv->regex_list;
		_tmp8__length1 = self->priv->regex_list_length1;
		_tmp9_ = _tmp6_;
		_tmp6_ = NULL;
		_g_regex_unref0 (_tmp8_[RSYNC_TASK_REGEX_TYPE_Created]);
		_tmp8_[RSYNC_TASK_REGEX_TYPE_Created] = _tmp9_;
		_tmp11_ = g_regex_new ("[0-9\\/]+ [0-9:.]+ \\[[0-9]+\\] ([<>ch.*])([.fdLDS])[+]{9} (.*)", 0, 0, &_inner_error0_);
		_tmp10_ = _tmp11_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (_tmp6_);
			_g_regex_unref0 (_tmp2_);
			goto __catch0_g_error;
		}
		_tmp12_ = self->priv->regex_list;
		_tmp12__length1 = self->priv->regex_list_length1;
		_tmp13_ = _tmp10_;
		_tmp10_ = NULL;
		_g_regex_unref0 (_tmp12_[RSYNC_TASK_REGEX_TYPE_LogCreated]);
		_tmp12_[RSYNC_TASK_REGEX_TYPE_LogCreated] = _tmp13_;
		_tmp15_ = g_regex_new ("\\*deleting[ \\t]+(.*)", 0, 0, &_inner_error0_);
		_tmp14_ = _tmp15_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (_tmp10_);
			_g_regex_unref0 (_tmp6_);
			_g_regex_unref0 (_tmp2_);
			goto __catch0_g_error;
		}
		_tmp16_ = self->priv->regex_list;
		_tmp16__length1 = self->priv->regex_list_length1;
		_tmp17_ = _tmp14_;
		_tmp14_ = NULL;
		_g_regex_unref0 (_tmp16_[RSYNC_TASK_REGEX_TYPE_Deleted]);
		_tmp16_[RSYNC_TASK_REGEX_TYPE_Deleted] = _tmp17_;
		_tmp19_ = g_regex_new ("[0-9\\/]+ [0-9:.]+ \\[[0-9]+\\] \\*deleting[ \\t]+(.*)", 0, 0, &_inner_error0_);
		_tmp18_ = _tmp19_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (_tmp14_);
			_g_regex_unref0 (_tmp10_);
			_g_regex_unref0 (_tmp6_);
			_g_regex_unref0 (_tmp2_);
			goto __catch0_g_error;
		}
		_tmp20_ = self->priv->regex_list;
		_tmp20__length1 = self->priv->regex_list_length1;
		_tmp21_ = _tmp18_;
		_tmp18_ = NULL;
		_g_regex_unref0 (_tmp20_[RSYNC_TASK_REGEX_TYPE_LogDeleted]);
		_tmp20_[RSYNC_TASK_REGEX_TYPE_LogDeleted] = _tmp21_;
		_tmp23_ = g_regex_new ("([<>ch.])([.fdLDS])(c|\\+|\\.| )(s|\\+|\\.| )(t|\\+|\\.| )(p|\\+|\\.| " \
")(o|\\+|\\.| )(g|\\+|\\.| )(u|\\+|\\.| )(a|\\+|\\.| )(x|\\+|\\.) (.*)", 0, 0, &_inner_error0_);
		_tmp22_ = _tmp23_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (_tmp18_);
			_g_regex_unref0 (_tmp14_);
			_g_regex_unref0 (_tmp10_);
			_g_regex_unref0 (_tmp6_);
			_g_regex_unref0 (_tmp2_);
			goto __catch0_g_error;
		}
		_tmp24_ = self->priv->regex_list;
		_tmp24__length1 = self->priv->regex_list_length1;
		_tmp25_ = _tmp22_;
		_tmp22_ = NULL;
		_g_regex_unref0 (_tmp24_[RSYNC_TASK_REGEX_TYPE_Modified]);
		_tmp24_[RSYNC_TASK_REGEX_TYPE_Modified] = _tmp25_;
		_tmp27_ = g_regex_new ("[0-9\\/]+ [0-9:.]+ \\[[0-9]+\\] ([<>ch.])([.fdLDS])(c|\\+|\\.| )(s|\\+" \
"|\\.| )(t|\\+|\\.| )(p|\\+|\\.| )(o|\\+|\\.| )(g|\\+|\\.| )(u|\\+|\\.|" \
" )(a|\\+|\\.| )(x|\\+|\\.) (.*)", 0, 0, &_inner_error0_);
		_tmp26_ = _tmp27_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (_tmp22_);
			_g_regex_unref0 (_tmp18_);
			_g_regex_unref0 (_tmp14_);
			_g_regex_unref0 (_tmp10_);
			_g_regex_unref0 (_tmp6_);
			_g_regex_unref0 (_tmp2_);
			goto __catch0_g_error;
		}
		_tmp28_ = self->priv->regex_list;
		_tmp28__length1 = self->priv->regex_list_length1;
		_tmp29_ = _tmp26_;
		_tmp26_ = NULL;
		_g_regex_unref0 (_tmp28_[RSYNC_TASK_REGEX_TYPE_LogModified]);
		_tmp28_[RSYNC_TASK_REGEX_TYPE_LogModified] = _tmp29_;
		_tmp31_ = g_regex_new ("([.h])([.fdLDS])[ ]{9} (.*)", 0, 0, &_inner_error0_);
		_tmp30_ = _tmp31_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (_tmp26_);
			_g_regex_unref0 (_tmp22_);
			_g_regex_unref0 (_tmp18_);
			_g_regex_unref0 (_tmp14_);
			_g_regex_unref0 (_tmp10_);
			_g_regex_unref0 (_tmp6_);
			_g_regex_unref0 (_tmp2_);
			goto __catch0_g_error;
		}
		_tmp32_ = self->priv->regex_list;
		_tmp32__length1 = self->priv->regex_list_length1;
		_tmp33_ = _tmp30_;
		_tmp30_ = NULL;
		_g_regex_unref0 (_tmp32_[RSYNC_TASK_REGEX_TYPE_Unchanged]);
		_tmp32_[RSYNC_TASK_REGEX_TYPE_Unchanged] = _tmp33_;
		_tmp35_ = g_regex_new ("[0-9\\/]+ [0-9:.]+ \\[[0-9]+\\] ([.h])([.fdLDS])[ ]{9} (.*)", 0, 0, &_inner_error0_);
		_tmp34_ = _tmp35_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (_tmp30_);
			_g_regex_unref0 (_tmp26_);
			_g_regex_unref0 (_tmp22_);
			_g_regex_unref0 (_tmp18_);
			_g_regex_unref0 (_tmp14_);
			_g_regex_unref0 (_tmp10_);
			_g_regex_unref0 (_tmp6_);
			_g_regex_unref0 (_tmp2_);
			goto __catch0_g_error;
		}
		_tmp36_ = self->priv->regex_list;
		_tmp36__length1 = self->priv->regex_list_length1;
		_tmp37_ = _tmp34_;
		_tmp34_ = NULL;
		_g_regex_unref0 (_tmp36_[RSYNC_TASK_REGEX_TYPE_LogUnchanged]);
		_tmp36_[RSYNC_TASK_REGEX_TYPE_LogUnchanged] = _tmp37_;
		_tmp39_ = g_regex_new ("total size is ([0-9,]+)[ \\t]+speedup is [0-9.]+", 0, 0, &_inner_error0_);
		_tmp38_ = _tmp39_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (_tmp34_);
			_g_regex_unref0 (_tmp30_);
			_g_regex_unref0 (_tmp26_);
			_g_regex_unref0 (_tmp22_);
			_g_regex_unref0 (_tmp18_);
			_g_regex_unref0 (_tmp14_);
			_g_regex_unref0 (_tmp10_);
			_g_regex_unref0 (_tmp6_);
			_g_regex_unref0 (_tmp2_);
			goto __catch0_g_error;
		}
		_tmp40_ = self->priv->regex_list;
		_tmp40__length1 = self->priv->regex_list_length1;
		_tmp41_ = _tmp38_;
		_tmp38_ = NULL;
		_g_regex_unref0 (_tmp40_[RSYNC_TASK_REGEX_TYPE_TotalSize]);
		_tmp40_[RSYNC_TASK_REGEX_TYPE_TotalSize] = _tmp41_;
		_g_regex_unref0 (_tmp38_);
		_g_regex_unref0 (_tmp34_);
		_g_regex_unref0 (_tmp30_);
		_g_regex_unref0 (_tmp26_);
		_g_regex_unref0 (_tmp22_);
		_g_regex_unref0 (_tmp18_);
		_g_regex_unref0 (_tmp14_);
		_g_regex_unref0 (_tmp10_);
		_g_regex_unref0 (_tmp6_);
		_g_regex_unref0 (_tmp2_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp42_;
		const gchar* _tmp43_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp42_ = e;
		_tmp43_ = _tmp42_->message;
		tee_jee_logging_log_error (_tmp43_, FALSE, FALSE);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
rsync_task_real_prepare (AsyncTask* base)
{
	RsyncTask * self;
	GString* _tmp0_;
	self = (RsyncTask*) base;
	ASYNC_TASK_CLASS (rsync_task_parent_class)->prepare (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ASYNC_TASK, AsyncTask));
	self->status_line_count = (gint64) 0;
	self->total_size = (gint64) 0;
	self->count_created = (gint64) 0;
	self->count_deleted = (gint64) 0;
	self->count_modified = (gint64) 0;
	self->count_checksum = (gint64) 0;
	self->count_size = (gint64) 0;
	self->count_timestamp = (gint64) 0;
	self->count_permissions = (gint64) 0;
	self->count_owner = (gint64) 0;
	self->count_group = (gint64) 0;
	self->count_unchanged = (gint64) 0;
	_tmp0_ = g_string_new ("");
	_g_string_free0 (self->log);
	self->log = _tmp0_;
}

static gchar*
rsync_task_real_build_script (AsyncTask* base)
{
	RsyncTask * self;
	gchar* cmd = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	const gchar* _tmp23_;
	gint _tmp24_;
	gint _tmp25_;
	const gchar* _tmp36_;
	gint _tmp37_;
	gint _tmp38_;
	const gchar* _tmp46_;
	gint _tmp47_;
	gint _tmp48_;
	const gchar* _tmp59_;
	gchar* _tmp60_;
	const gchar* _tmp61_;
	gchar* _tmp62_;
	const gchar* _tmp63_;
	const gchar* _tmp64_;
	gchar* _tmp65_;
	gchar* _tmp66_;
	gchar* _tmp67_;
	gchar* _tmp68_;
	gchar* _tmp69_;
	const gchar* _tmp70_;
	const gchar* _tmp71_;
	gchar* _tmp72_;
	gchar* _tmp73_;
	gchar* _tmp74_;
	gchar* _tmp75_;
	gchar* _tmp76_;
	gchar* result;
	self = (RsyncTask*) base;
	_tmp0_ = g_strdup ("export LC_ALL=C.UTF-8\n");
	cmd = _tmp0_;
	if (self->io_nice) {
	}
	_tmp1_ = cmd;
	_tmp2_ = g_strconcat (_tmp1_, "rsync -aii", NULL);
	_g_free0 (cmd);
	cmd = _tmp2_;
	_tmp3_ = cmd;
	_tmp4_ = g_strconcat (_tmp3_, " --recursive", NULL);
	_g_free0 (cmd);
	cmd = _tmp4_;
	if (self->verbose) {
		const gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = cmd;
		_tmp6_ = g_strconcat (_tmp5_, " --verbose", NULL);
		_g_free0 (cmd);
		cmd = _tmp6_;
	} else {
		const gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp7_ = cmd;
		_tmp8_ = g_strconcat (_tmp7_, " --quiet", NULL);
		_g_free0 (cmd);
		cmd = _tmp8_;
	}
	if (self->delete_extra) {
		const gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp9_ = cmd;
		_tmp10_ = g_strconcat (_tmp9_, " --delete", NULL);
		_g_free0 (cmd);
		cmd = _tmp10_;
	}
	if (self->delete_after) {
		const gchar* _tmp11_;
		gchar* _tmp12_;
		_tmp11_ = cmd;
		_tmp12_ = g_strconcat (_tmp11_, " --delete-after", NULL);
		_g_free0 (cmd);
		cmd = _tmp12_;
	}
	_tmp13_ = cmd;
	_tmp14_ = g_strconcat (_tmp13_, " --force", NULL);
	_g_free0 (cmd);
	cmd = _tmp14_;
	_tmp15_ = cmd;
	_tmp16_ = g_strconcat (_tmp15_, " --stats", NULL);
	_g_free0 (cmd);
	cmd = _tmp16_;
	_tmp17_ = cmd;
	_tmp18_ = g_strconcat (_tmp17_, " --sparse", NULL);
	_g_free0 (cmd);
	cmd = _tmp18_;
	if (self->delete_excluded) {
		const gchar* _tmp19_;
		gchar* _tmp20_;
		_tmp19_ = cmd;
		_tmp20_ = g_strconcat (_tmp19_, " --delete-excluded", NULL);
		_g_free0 (cmd);
		cmd = _tmp20_;
	}
	if (self->dry_run) {
		const gchar* _tmp21_;
		gchar* _tmp22_;
		_tmp21_ = cmd;
		_tmp22_ = g_strconcat (_tmp21_, " --dry-run", NULL);
		_g_free0 (cmd);
		cmd = _tmp22_;
	}
	_tmp23_ = self->link_from_path;
	_tmp24_ = strlen (_tmp23_);
	_tmp25_ = _tmp24_;
	if (_tmp25_ > 0) {
		const gchar* _tmp26_;
		const gchar* _tmp29_;
		const gchar* _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
		gchar* _tmp33_;
		gchar* _tmp34_;
		gchar* _tmp35_;
		_tmp26_ = self->link_from_path;
		if (!g_str_has_suffix (_tmp26_, "/")) {
			const gchar* _tmp27_;
			gchar* _tmp28_;
			_tmp27_ = self->link_from_path;
			_tmp28_ = g_strdup_printf ("%s/", _tmp27_);
			_g_free0 (self->link_from_path);
			self->link_from_path = _tmp28_;
		}
		_tmp29_ = cmd;
		_tmp30_ = self->link_from_path;
		_tmp31_ = tee_jee_file_system_escape_single_quote (_tmp30_);
		_tmp32_ = _tmp31_;
		_tmp33_ = g_strdup_printf (" --link-dest='%s'", _tmp32_);
		_tmp34_ = _tmp33_;
		_tmp35_ = g_strconcat (_tmp29_, _tmp34_, NULL);
		_g_free0 (cmd);
		cmd = _tmp35_;
		_g_free0 (_tmp34_);
		_g_free0 (_tmp32_);
	}
	_tmp36_ = self->rsync_log_file;
	_tmp37_ = strlen (_tmp36_);
	_tmp38_ = _tmp37_;
	if (_tmp38_ > 0) {
		const gchar* _tmp39_;
		const gchar* _tmp40_;
		gchar* _tmp41_;
		gchar* _tmp42_;
		gchar* _tmp43_;
		gchar* _tmp44_;
		gchar* _tmp45_;
		_tmp39_ = cmd;
		_tmp40_ = self->rsync_log_file;
		_tmp41_ = tee_jee_file_system_escape_single_quote (_tmp40_);
		_tmp42_ = _tmp41_;
		_tmp43_ = g_strdup_printf (" --log-file='%s'", _tmp42_);
		_tmp44_ = _tmp43_;
		_tmp45_ = g_strconcat (_tmp39_, _tmp44_, NULL);
		_g_free0 (cmd);
		cmd = _tmp45_;
		_g_free0 (_tmp44_);
		_g_free0 (_tmp42_);
	}
	_tmp46_ = self->exclude_from_file;
	_tmp47_ = strlen (_tmp46_);
	_tmp48_ = _tmp47_;
	if (_tmp48_ > 0) {
		const gchar* _tmp49_;
		const gchar* _tmp50_;
		gchar* _tmp51_;
		gchar* _tmp52_;
		gchar* _tmp53_;
		gchar* _tmp54_;
		gchar* _tmp55_;
		gboolean _tmp56_ = FALSE;
		_tmp49_ = cmd;
		_tmp50_ = self->exclude_from_file;
		_tmp51_ = tee_jee_file_system_escape_single_quote (_tmp50_);
		_tmp52_ = _tmp51_;
		_tmp53_ = g_strdup_printf (" --exclude-from='%s'", _tmp52_);
		_tmp54_ = _tmp53_;
		_tmp55_ = g_strconcat (_tmp49_, _tmp54_, NULL);
		_g_free0 (cmd);
		cmd = _tmp55_;
		_g_free0 (_tmp54_);
		_g_free0 (_tmp52_);
		if (self->delete_extra) {
			_tmp56_ = self->delete_excluded;
		} else {
			_tmp56_ = FALSE;
		}
		if (_tmp56_) {
			const gchar* _tmp57_;
			gchar* _tmp58_;
			_tmp57_ = cmd;
			_tmp58_ = g_strconcat (_tmp57_, " --delete-excluded", NULL);
			_g_free0 (cmd);
			cmd = _tmp58_;
		}
	}
	_tmp59_ = self->source_path;
	_tmp60_ = tee_jee_file_system_remove_trailing_slash (_tmp59_);
	_g_free0 (self->source_path);
	self->source_path = _tmp60_;
	_tmp61_ = self->dest_path;
	_tmp62_ = tee_jee_file_system_remove_trailing_slash (_tmp61_);
	_g_free0 (self->dest_path);
	self->dest_path = _tmp62_;
	_tmp63_ = cmd;
	_tmp64_ = self->source_path;
	_tmp65_ = tee_jee_file_system_escape_single_quote (_tmp64_);
	_tmp66_ = _tmp65_;
	_tmp67_ = g_strdup_printf (" '%s/'", _tmp66_);
	_tmp68_ = _tmp67_;
	_tmp69_ = g_strconcat (_tmp63_, _tmp68_, NULL);
	_g_free0 (cmd);
	cmd = _tmp69_;
	_g_free0 (_tmp68_);
	_g_free0 (_tmp66_);
	_tmp70_ = cmd;
	_tmp71_ = self->dest_path;
	_tmp72_ = tee_jee_file_system_escape_single_quote (_tmp71_);
	_tmp73_ = _tmp72_;
	_tmp74_ = g_strdup_printf (" '%s/'", _tmp73_);
	_tmp75_ = _tmp74_;
	_tmp76_ = g_strconcat (_tmp70_, _tmp75_, NULL);
	_g_free0 (cmd);
	cmd = _tmp76_;
	_g_free0 (_tmp75_);
	_g_free0 (_tmp73_);
	result = cmd;
	return result;
}

static gint64*
_int64_dup (gint64* self)
{
	gint64* dup;
	dup = g_new0 (gint64, 1);
	memcpy (dup, self, sizeof (gint64));
	return dup;
}

static gpointer
__int64_dup0 (gpointer self)
{
	return self ? _int64_dup (self) : NULL;
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

GeeArrayList*
rsync_task_parse_log (RsyncTask* self,
                      const gchar* log_file_path)
{
	GeeArrayList* list = NULL;
	GeeArrayList* _tmp0_;
	gchar* log_file = NULL;
	gchar* _tmp1_;
	GDataOutputStream* dos_changes = NULL;
	const gchar* _tmp2_;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gint64* _tmp20_ = NULL;
	const gchar* _tmp21_;
	gint64* _tmp22_;
	gint64* _tmp25_;
	gint64* _tmp26_;
	GDataOutputStream* _tmp190_;
	GError* _inner_error0_ = NULL;
	GeeArrayList* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (log_file_path != NULL, NULL);
	_tmp0_ = gee_array_list_new (TYPE_FILE_ITEM, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	list = _tmp0_;
	_tmp1_ = g_strdup (log_file_path);
	log_file = _tmp1_;
	dos_changes = NULL;
	_tmp2_ = log_file;
	if (!g_str_has_suffix (_tmp2_, "-changes")) {
		gchar* log_file_changes = NULL;
		gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = g_strconcat (log_file_path, "-changes", NULL);
		log_file_changes = _tmp3_;
		_tmp4_ = log_file_changes;
		if (tee_jee_file_system_file_exists (_tmp4_)) {
			const gchar* _tmp5_;
			gchar* _tmp6_;
			_tmp5_ = log_file_changes;
			_tmp6_ = g_strdup (_tmp5_);
			_g_free0 (log_file);
			log_file = _tmp6_;
		} else {
			{
				GFile* file = NULL;
				const gchar* _tmp7_;
				GFile* _tmp8_;
				GFile* _tmp9_;
				GFileOutputStream* file_stream = NULL;
				GFile* _tmp11_;
				GFileOutputStream* _tmp12_;
				GFileOutputStream* _tmp13_;
				GDataOutputStream* _tmp14_;
				_tmp7_ = log_file_changes;
				_tmp8_ = g_file_new_for_path (_tmp7_);
				file = _tmp8_;
				_tmp9_ = file;
				if (g_file_query_exists (_tmp9_, NULL)) {
					GFile* _tmp10_;
					_tmp10_ = file;
					g_file_delete (_tmp10_, NULL, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_object_unref0 (file);
						goto __catch0_g_error;
					}
				}
				_tmp11_ = file;
				_tmp12_ = g_file_create (_tmp11_, G_FILE_CREATE_REPLACE_DESTINATION, NULL, &_inner_error0_);
				file_stream = _tmp12_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (file);
					goto __catch0_g_error;
				}
				_tmp13_ = file_stream;
				_tmp14_ = g_data_output_stream_new ((GOutputStream*) _tmp13_);
				_g_object_unref0 (dos_changes);
				dos_changes = _tmp14_;
				_g_object_unref0 (file_stream);
				_g_object_unref0 (file);
			}
			goto __finally0;
			__catch0_g_error:
			{
				GError* e = NULL;
				GError* _tmp15_;
				const gchar* _tmp16_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp15_ = e;
				_tmp16_ = _tmp15_->message;
				tee_jee_logging_log_error (_tmp16_, FALSE, FALSE);
				_g_error_free0 (e);
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (log_file_changes);
				_g_object_unref0 (dos_changes);
				_g_free0 (log_file);
				_g_object_unref0 (list);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		_g_free0 (log_file_changes);
	}
	tee_jee_logging_log_debug ("RsyncTask: parse_log()");
	_tmp17_ = log_file;
	_tmp18_ = g_strdup_printf ("log_file = %s", _tmp17_);
	_tmp19_ = _tmp18_;
	tee_jee_logging_log_debug (_tmp19_);
	_g_free0 (_tmp19_);
	((AsyncTask*) self)->prg_count = (gint64) 0;
	_tmp21_ = log_file;
	_tmp22_ = tee_jee_file_system_file_line_count (_tmp21_);
	_tmp20_ = _tmp22_;
	if (_tmp20_ == NULL) {
		gint64 _tmp23_;
		gint64* _tmp24_;
		_tmp23_ = (gint64) 0;
		_tmp24_ = __int64_dup0 (&_tmp23_);
		_g_free0 (_tmp20_);
		_tmp20_ = _tmp24_;
	}
	_tmp25_ = _tmp20_;
	_tmp20_ = NULL;
	_tmp26_ = _tmp25_;
	((AsyncTask*) self)->prg_count_total = *_tmp26_;
	_g_free0 (_tmp26_);
	{
		gchar* line = NULL;
		GFile* file = NULL;
		const gchar* _tmp27_;
		GFile* _tmp28_;
		GFile* _tmp29_;
		GFileInputStream* _tmp35_ = NULL;
		GFile* _tmp36_;
		GFileInputStream* _tmp37_;
		GDataInputStream* dis = NULL;
		GDataInputStream* _tmp38_;
		gchar* item_path = NULL;
		gchar* _tmp39_;
		gchar* item_disk_path = NULL;
		gchar* _tmp40_;
		gchar* item_status = NULL;
		gchar* _tmp41_;
		gchar* item_basepath = NULL;
		gchar* _tmp42_;
		gchar* _tmp43_;
		gchar* _tmp44_;
		gchar* _tmp45_;
		_tmp27_ = log_file;
		_tmp28_ = g_file_new_for_path (_tmp27_);
		file = _tmp28_;
		_tmp29_ = file;
		if (!g_file_query_exists (_tmp29_, NULL)) {
			const gchar* _tmp30_;
			gchar* _tmp31_;
			gchar* _tmp32_;
			gchar* _tmp33_;
			gchar* _tmp34_;
			_tmp30_ = log_file;
			_tmp31_ = g_strdup_printf (": %s", _tmp30_);
			_tmp32_ = _tmp31_;
			_tmp33_ = g_strconcat (_ ("File not found"), _tmp32_, NULL);
			_tmp34_ = _tmp33_;
			tee_jee_logging_log_error (_tmp34_, FALSE, FALSE);
			_g_free0 (_tmp34_);
			_g_free0 (_tmp32_);
			result = list;
			_g_object_unref0 (file);
			_g_free0 (line);
			_g_free0 (_tmp20_);
			_g_object_unref0 (dos_changes);
			_g_free0 (log_file);
			return result;
		}
		_tmp36_ = file;
		_tmp37_ = g_file_read (_tmp36_, NULL, &_inner_error0_);
		_tmp35_ = _tmp37_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (file);
			_g_free0 (line);
			goto __catch1_g_error;
		}
		_tmp38_ = g_data_input_stream_new ((GInputStream*) _tmp35_);
		dis = _tmp38_;
		_tmp39_ = g_strdup ("");
		item_path = _tmp39_;
		_tmp40_ = g_strdup ("");
		item_disk_path = _tmp40_;
		_tmp41_ = g_strdup ("");
		item_status = _tmp41_;
		_tmp42_ = tee_jee_file_system_file_parent (log_file_path);
		_tmp43_ = _tmp42_;
		_tmp44_ = tee_jee_file_system_path_combine (_tmp43_, "localhost");
		_tmp45_ = _tmp44_;
		_g_free0 (_tmp43_);
		item_basepath = _tmp45_;
		while (TRUE) {
			gchar* _tmp46_ = NULL;
			GDataInputStream* _tmp47_;
			gchar* _tmp48_;
			gchar* _tmp49_;
			const gchar* _tmp50_;
			gint64 _tmp51_;
			const gchar* _tmp52_;
			gchar* _tmp53_;
			gchar* _tmp54_;
			gint _tmp55_;
			gint _tmp56_;
			gboolean _tmp57_;
			gchar* _tmp58_;
			GMatchInfo* match = NULL;
			gboolean _tmp59_ = FALSE;
			GRegex** _tmp60_;
			gint _tmp60__length1;
			GRegex* _tmp61_;
			const gchar* _tmp62_;
			GMatchInfo* _tmp63_ = NULL;
			gboolean _tmp64_;
			gboolean _tmp171_ = FALSE;
			gboolean _tmp172_ = FALSE;
			const gchar* _tmp173_;
			gint _tmp174_;
			gint _tmp175_;
			_tmp47_ = dis;
			_tmp48_ = g_data_input_stream_read_line (_tmp47_, NULL, NULL, &_inner_error0_);
			_tmp46_ = _tmp48_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (item_basepath);
				_g_free0 (item_status);
				_g_free0 (item_disk_path);
				_g_free0 (item_path);
				_g_object_unref0 (dis);
				_g_object_unref0 (_tmp35_);
				_g_object_unref0 (file);
				_g_free0 (line);
				goto __catch1_g_error;
			}
			_tmp49_ = _tmp46_;
			_tmp46_ = NULL;
			_g_free0 (line);
			line = _tmp49_;
			_tmp50_ = line;
			if (!(_tmp50_ != NULL)) {
				_g_free0 (_tmp46_);
				break;
			}
			_tmp51_ = ((AsyncTask*) self)->prg_count;
			((AsyncTask*) self)->prg_count = _tmp51_ + 1;
			_tmp52_ = line;
			_tmp53_ = string_strip (_tmp52_);
			_tmp54_ = _tmp53_;
			_tmp55_ = strlen (_tmp54_);
			_tmp56_ = _tmp55_;
			_tmp57_ = _tmp56_ == 0;
			_g_free0 (_tmp54_);
			if (_tmp57_) {
				_g_free0 (_tmp46_);
				continue;
			}
			_tmp58_ = g_strdup ("");
			_g_free0 (item_path);
			item_path = _tmp58_;
			_tmp60_ = self->priv->regex_list;
			_tmp60__length1 = self->priv->regex_list_length1;
			_tmp61_ = _tmp60_[RSYNC_TASK_REGEX_TYPE_Created];
			_tmp62_ = line;
			_tmp64_ = g_regex_match (_tmp61_, _tmp62_, 0, &_tmp63_);
			_g_match_info_unref0 (match);
			match = _tmp63_;
			if (_tmp64_) {
				_tmp59_ = TRUE;
			} else {
				GRegex** _tmp65_;
				gint _tmp65__length1;
				GRegex* _tmp66_;
				const gchar* _tmp67_;
				GMatchInfo* _tmp68_ = NULL;
				gboolean _tmp69_;
				_tmp65_ = self->priv->regex_list;
				_tmp65__length1 = self->priv->regex_list_length1;
				_tmp66_ = _tmp65_[RSYNC_TASK_REGEX_TYPE_LogCreated];
				_tmp67_ = line;
				_tmp69_ = g_regex_match (_tmp66_, _tmp67_, 0, &_tmp68_);
				_g_match_info_unref0 (match);
				match = _tmp68_;
				_tmp59_ = _tmp69_;
			}
			if (_tmp59_) {
				GDataOutputStream* _tmp70_;
				GMatchInfo* _tmp75_;
				gchar* _tmp76_;
				gchar* _tmp77_;
				gchar** _tmp78_;
				gchar** _tmp79_;
				gchar** _tmp80_;
				gint _tmp80__length1;
				const gchar* _tmp81_;
				gchar* _tmp82_;
				gchar* _tmp83_;
				_tmp70_ = dos_changes;
				if (_tmp70_ != NULL) {
					GDataOutputStream* _tmp71_;
					const gchar* _tmp72_;
					gchar* _tmp73_;
					gchar* _tmp74_;
					_tmp71_ = dos_changes;
					_tmp72_ = line;
					_tmp73_ = g_strdup_printf ("%s\n", _tmp72_);
					_tmp74_ = _tmp73_;
					g_data_output_stream_put_string (_tmp71_, _tmp74_, NULL, &_inner_error0_);
					_g_free0 (_tmp74_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_match_info_unref0 (match);
						_g_free0 (_tmp46_);
						_g_free0 (item_basepath);
						_g_free0 (item_status);
						_g_free0 (item_disk_path);
						_g_free0 (item_path);
						_g_object_unref0 (dis);
						_g_object_unref0 (_tmp35_);
						_g_object_unref0 (file);
						_g_free0 (line);
						goto __catch1_g_error;
					}
				}
				_tmp75_ = match;
				_tmp76_ = g_match_info_fetch (_tmp75_, 3);
				_tmp77_ = _tmp76_;
				_tmp79_ = _tmp78_ = g_strsplit (_tmp77_, " -> ", 0);
				_tmp80_ = _tmp79_;
				_tmp80__length1 = _vala_array_length (_tmp78_);
				_tmp81_ = _tmp80_[0];
				_tmp82_ = string_strip (_tmp81_);
				_g_free0 (item_path);
				item_path = _tmp82_;
				_tmp80_ = (_vala_array_free (_tmp80_, _tmp80__length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (_tmp77_);
				_tmp83_ = g_strdup ("created");
				_g_free0 (item_status);
				item_status = _tmp83_;
			} else {
				gboolean _tmp84_ = FALSE;
				GRegex** _tmp85_;
				gint _tmp85__length1;
				GRegex* _tmp86_;
				const gchar* _tmp87_;
				GMatchInfo* _tmp88_ = NULL;
				gboolean _tmp89_;
				_tmp85_ = self->priv->regex_list;
				_tmp85__length1 = self->priv->regex_list_length1;
				_tmp86_ = _tmp85_[RSYNC_TASK_REGEX_TYPE_LogDeleted];
				_tmp87_ = line;
				_tmp89_ = g_regex_match (_tmp86_, _tmp87_, 0, &_tmp88_);
				_g_match_info_unref0 (match);
				match = _tmp88_;
				if (_tmp89_) {
					_tmp84_ = TRUE;
				} else {
					GRegex** _tmp90_;
					gint _tmp90__length1;
					GRegex* _tmp91_;
					const gchar* _tmp92_;
					GMatchInfo* _tmp93_ = NULL;
					gboolean _tmp94_;
					_tmp90_ = self->priv->regex_list;
					_tmp90__length1 = self->priv->regex_list_length1;
					_tmp91_ = _tmp90_[RSYNC_TASK_REGEX_TYPE_Deleted];
					_tmp92_ = line;
					_tmp94_ = g_regex_match (_tmp91_, _tmp92_, 0, &_tmp93_);
					_g_match_info_unref0 (match);
					match = _tmp93_;
					_tmp84_ = _tmp94_;
				}
				if (_tmp84_) {
					GDataOutputStream* _tmp95_;
					GMatchInfo* _tmp100_;
					gchar* _tmp101_;
					gchar* _tmp102_;
					gchar** _tmp103_;
					gchar** _tmp104_;
					gchar** _tmp105_;
					gint _tmp105__length1;
					const gchar* _tmp106_;
					gchar* _tmp107_;
					gchar* _tmp108_;
					_tmp95_ = dos_changes;
					if (_tmp95_ != NULL) {
						GDataOutputStream* _tmp96_;
						const gchar* _tmp97_;
						gchar* _tmp98_;
						gchar* _tmp99_;
						_tmp96_ = dos_changes;
						_tmp97_ = line;
						_tmp98_ = g_strdup_printf ("%s\n", _tmp97_);
						_tmp99_ = _tmp98_;
						g_data_output_stream_put_string (_tmp96_, _tmp99_, NULL, &_inner_error0_);
						_g_free0 (_tmp99_);
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							_g_match_info_unref0 (match);
							_g_free0 (_tmp46_);
							_g_free0 (item_basepath);
							_g_free0 (item_status);
							_g_free0 (item_disk_path);
							_g_free0 (item_path);
							_g_object_unref0 (dis);
							_g_object_unref0 (_tmp35_);
							_g_object_unref0 (file);
							_g_free0 (line);
							goto __catch1_g_error;
						}
					}
					_tmp100_ = match;
					_tmp101_ = g_match_info_fetch (_tmp100_, 1);
					_tmp102_ = _tmp101_;
					_tmp104_ = _tmp103_ = g_strsplit (_tmp102_, " -> ", 0);
					_tmp105_ = _tmp104_;
					_tmp105__length1 = _vala_array_length (_tmp103_);
					_tmp106_ = _tmp105_[0];
					_tmp107_ = string_strip (_tmp106_);
					_g_free0 (item_path);
					item_path = _tmp107_;
					_tmp105_ = (_vala_array_free (_tmp105_, _tmp105__length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (_tmp102_);
					_tmp108_ = g_strdup ("deleted");
					_g_free0 (item_status);
					item_status = _tmp108_;
				} else {
					gboolean _tmp109_ = FALSE;
					GRegex** _tmp110_;
					gint _tmp110__length1;
					GRegex* _tmp111_;
					const gchar* _tmp112_;
					GMatchInfo* _tmp113_ = NULL;
					gboolean _tmp114_;
					_tmp110_ = self->priv->regex_list;
					_tmp110__length1 = self->priv->regex_list_length1;
					_tmp111_ = _tmp110_[RSYNC_TASK_REGEX_TYPE_Modified];
					_tmp112_ = line;
					_tmp114_ = g_regex_match (_tmp111_, _tmp112_, 0, &_tmp113_);
					_g_match_info_unref0 (match);
					match = _tmp113_;
					if (_tmp114_) {
						_tmp109_ = TRUE;
					} else {
						GRegex** _tmp115_;
						gint _tmp115__length1;
						GRegex* _tmp116_;
						const gchar* _tmp117_;
						GMatchInfo* _tmp118_ = NULL;
						gboolean _tmp119_;
						_tmp115_ = self->priv->regex_list;
						_tmp115__length1 = self->priv->regex_list_length1;
						_tmp116_ = _tmp115_[RSYNC_TASK_REGEX_TYPE_LogModified];
						_tmp117_ = line;
						_tmp119_ = g_regex_match (_tmp116_, _tmp117_, 0, &_tmp118_);
						_g_match_info_unref0 (match);
						match = _tmp118_;
						_tmp109_ = _tmp119_;
					}
					if (_tmp109_) {
						GDataOutputStream* _tmp120_;
						GMatchInfo* _tmp125_;
						gchar* _tmp126_;
						gchar* _tmp127_;
						gchar** _tmp128_;
						gchar** _tmp129_;
						gchar** _tmp130_;
						gint _tmp130__length1;
						const gchar* _tmp131_;
						gchar* _tmp132_;
						GMatchInfo* _tmp133_;
						gchar* _tmp134_;
						gchar* _tmp135_;
						gboolean _tmp136_;
						_tmp120_ = dos_changes;
						if (_tmp120_ != NULL) {
							GDataOutputStream* _tmp121_;
							const gchar* _tmp122_;
							gchar* _tmp123_;
							gchar* _tmp124_;
							_tmp121_ = dos_changes;
							_tmp122_ = line;
							_tmp123_ = g_strdup_printf ("%s\n", _tmp122_);
							_tmp124_ = _tmp123_;
							g_data_output_stream_put_string (_tmp121_, _tmp124_, NULL, &_inner_error0_);
							_g_free0 (_tmp124_);
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
								_g_match_info_unref0 (match);
								_g_free0 (_tmp46_);
								_g_free0 (item_basepath);
								_g_free0 (item_status);
								_g_free0 (item_disk_path);
								_g_free0 (item_path);
								_g_object_unref0 (dis);
								_g_object_unref0 (_tmp35_);
								_g_object_unref0 (file);
								_g_free0 (line);
								goto __catch1_g_error;
							}
						}
						_tmp125_ = match;
						_tmp126_ = g_match_info_fetch (_tmp125_, 12);
						_tmp127_ = _tmp126_;
						_tmp129_ = _tmp128_ = g_strsplit (_tmp127_, " -> ", 0);
						_tmp130_ = _tmp129_;
						_tmp130__length1 = _vala_array_length (_tmp128_);
						_tmp131_ = _tmp130_[0];
						_tmp132_ = string_strip (_tmp131_);
						_g_free0 (item_path);
						item_path = _tmp132_;
						_tmp130_ = (_vala_array_free (_tmp130_, _tmp130__length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (_tmp127_);
						_tmp133_ = match;
						_tmp134_ = g_match_info_fetch (_tmp133_, 3);
						_tmp135_ = _tmp134_;
						_tmp136_ = g_strcmp0 (_tmp135_, "c") == 0;
						_g_free0 (_tmp135_);
						if (_tmp136_) {
							gchar* _tmp137_;
							_tmp137_ = g_strdup ("checksum");
							_g_free0 (item_status);
							item_status = _tmp137_;
						} else {
							GMatchInfo* _tmp138_;
							gchar* _tmp139_;
							gchar* _tmp140_;
							gboolean _tmp141_;
							_tmp138_ = match;
							_tmp139_ = g_match_info_fetch (_tmp138_, 4);
							_tmp140_ = _tmp139_;
							_tmp141_ = g_strcmp0 (_tmp140_, "s") == 0;
							_g_free0 (_tmp140_);
							if (_tmp141_) {
								gchar* _tmp142_;
								_tmp142_ = g_strdup ("size");
								_g_free0 (item_status);
								item_status = _tmp142_;
							} else {
								GMatchInfo* _tmp143_;
								gchar* _tmp144_;
								gchar* _tmp145_;
								gboolean _tmp146_;
								_tmp143_ = match;
								_tmp144_ = g_match_info_fetch (_tmp143_, 5);
								_tmp145_ = _tmp144_;
								_tmp146_ = g_strcmp0 (_tmp145_, "t") == 0;
								_g_free0 (_tmp145_);
								if (_tmp146_) {
									gchar* _tmp147_;
									_tmp147_ = g_strdup ("timestamp");
									_g_free0 (item_status);
									item_status = _tmp147_;
								} else {
									GMatchInfo* _tmp148_;
									gchar* _tmp149_;
									gchar* _tmp150_;
									gboolean _tmp151_;
									_tmp148_ = match;
									_tmp149_ = g_match_info_fetch (_tmp148_, 6);
									_tmp150_ = _tmp149_;
									_tmp151_ = g_strcmp0 (_tmp150_, "p") == 0;
									_g_free0 (_tmp150_);
									if (_tmp151_) {
										gchar* _tmp152_;
										_tmp152_ = g_strdup ("permissions");
										_g_free0 (item_status);
										item_status = _tmp152_;
									} else {
										GMatchInfo* _tmp153_;
										gchar* _tmp154_;
										gchar* _tmp155_;
										gboolean _tmp156_;
										_tmp153_ = match;
										_tmp154_ = g_match_info_fetch (_tmp153_, 7);
										_tmp155_ = _tmp154_;
										_tmp156_ = g_strcmp0 (_tmp155_, "o") == 0;
										_g_free0 (_tmp155_);
										if (_tmp156_) {
											gchar* _tmp157_;
											_tmp157_ = g_strdup ("owner");
											_g_free0 (item_status);
											item_status = _tmp157_;
										} else {
											GMatchInfo* _tmp158_;
											gchar* _tmp159_;
											gchar* _tmp160_;
											gboolean _tmp161_;
											_tmp158_ = match;
											_tmp159_ = g_match_info_fetch (_tmp158_, 8);
											_tmp160_ = _tmp159_;
											_tmp161_ = g_strcmp0 (_tmp160_, "g") == 0;
											_g_free0 (_tmp160_);
											if (_tmp161_) {
												gchar* _tmp162_;
												_tmp162_ = g_strdup ("group");
												_g_free0 (item_status);
												item_status = _tmp162_;
											}
										}
									}
								}
							}
						}
					} else {
						GRegex** _tmp163_;
						gint _tmp163__length1;
						GRegex* _tmp164_;
						const gchar* _tmp165_;
						GMatchInfo* _tmp166_ = NULL;
						gboolean _tmp167_;
						_tmp163_ = self->priv->regex_list;
						_tmp163__length1 = self->priv->regex_list_length1;
						_tmp164_ = _tmp163_[RSYNC_TASK_REGEX_TYPE_LogUnchanged];
						_tmp165_ = line;
						_tmp167_ = g_regex_match (_tmp164_, _tmp165_, 0, &_tmp166_);
						_g_match_info_unref0 (match);
						match = _tmp166_;
						if (_tmp167_) {
						} else {
							const gchar* _tmp168_;
							gchar* _tmp169_;
							gchar* _tmp170_;
							_tmp168_ = line;
							_tmp169_ = g_strdup_printf ("not-matched: %s", _tmp168_);
							_tmp170_ = _tmp169_;
							tee_jee_logging_log_debug (_tmp170_);
							_g_free0 (_tmp170_);
						}
					}
				}
			}
			_tmp173_ = item_path;
			_tmp174_ = strlen (_tmp173_);
			_tmp175_ = _tmp174_;
			if (_tmp175_ > 0) {
				const gchar* _tmp176_;
				_tmp176_ = item_path;
				_tmp172_ = g_strcmp0 (_tmp176_, "/./") != 0;
			} else {
				_tmp172_ = FALSE;
			}
			if (_tmp172_) {
				const gchar* _tmp177_;
				_tmp177_ = item_path;
				_tmp171_ = g_strcmp0 (_tmp177_, "./") != 0;
			} else {
				_tmp171_ = FALSE;
			}
			if (_tmp171_) {
				const gchar* _tmp178_;
				const gchar* _tmp179_;
				gchar* _tmp180_;
				FileItem* item = NULL;
				const gchar* _tmp181_;
				FileItem* _tmp182_;
				FileItem* _tmp183_;
				const gchar* _tmp184_;
				gchar* _tmp185_;
				GeeArrayList* _tmp186_;
				FileItem* _tmp187_;
				_tmp178_ = item_basepath;
				_tmp179_ = item_path;
				_tmp180_ = tee_jee_file_system_path_combine (_tmp178_, _tmp179_);
				_g_free0 (item_disk_path);
				item_disk_path = _tmp180_;
				_tmp181_ = item_disk_path;
				_tmp182_ = file_item_new_from_disk_path_with_basic_info (_tmp181_);
				item = _tmp182_;
				_tmp183_ = item;
				_tmp184_ = item_status;
				_tmp185_ = g_strdup (_tmp184_);
				_g_free0 (_tmp183_->file_status);
				_tmp183_->file_status = _tmp185_;
				_tmp186_ = list;
				_tmp187_ = item;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp186_, _tmp187_);
				_g_object_unref0 (item);
			}
			_g_match_info_unref0 (match);
			_g_free0 (_tmp46_);
		}
		_g_free0 (item_basepath);
		_g_free0 (item_status);
		_g_free0 (item_disk_path);
		_g_free0 (item_path);
		_g_object_unref0 (dis);
		_g_object_unref0 (_tmp35_);
		_g_object_unref0 (file);
		_g_free0 (line);
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp188_;
		const gchar* _tmp189_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp188_ = e;
		_tmp189_ = _tmp188_->message;
		tee_jee_logging_log_error (_tmp189_, FALSE, FALSE);
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (_tmp20_);
		_g_object_unref0 (dos_changes);
		_g_free0 (log_file);
		_g_object_unref0 (list);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp190_ = dos_changes;
	if (_tmp190_ != NULL) {
		gchar* _tmp191_;
		gchar* _tmp192_;
		_tmp191_ = g_strdup_printf ("Archiving: %s", log_file_path);
		_tmp192_ = _tmp191_;
		tee_jee_logging_log_msg (_tmp192_, FALSE);
		_g_free0 (_tmp192_);
		tee_jee_file_system_file_gzip (log_file_path);
	}
	tee_jee_logging_log_debug ("RsyncTask: parse_log(): exit");
	result = list;
	_g_free0 (_tmp20_);
	_g_object_unref0 (dos_changes);
	_g_free0 (log_file);
	return result;
}

static void
rsync_task_real_parse_stdout_line (AsyncTask* base,
                                   const gchar* out_line)
{
	RsyncTask * self;
	self = (RsyncTask*) base;
	g_return_if_fail (out_line != NULL);
	rsync_task_update_progress_parse_console_output (self, out_line);
}

static void
rsync_task_real_parse_stderr_line (AsyncTask* base,
                                   const gchar* err_line)
{
	RsyncTask * self;
	self = (RsyncTask*) base;
	g_return_if_fail (err_line != NULL);
	rsync_task_update_progress_parse_console_output (self, err_line);
}

static gint64
int64_parse (const gchar* str,
             guint _base)
{
	gint64 result;
	g_return_val_if_fail (str != NULL, 0LL);
	result = g_ascii_strtoll (str, NULL, _base);
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

gboolean
rsync_task_update_progress_parse_console_output (RsyncTask* self,
                                                 const gchar* line)
{
	gboolean _tmp0_ = FALSE;
	gint64 _tmp3_;
	GMatchInfo* match = NULL;
	GRegex** _tmp4_;
	gint _tmp4__length1;
	GRegex* _tmp5_;
	GMatchInfo* _tmp6_ = NULL;
	gboolean _tmp7_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (line != NULL, FALSE);
	if (line == NULL) {
		_tmp0_ = TRUE;
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (line);
		_tmp2_ = _tmp1_;
		_tmp0_ = _tmp2_ == 0;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	_tmp3_ = self->status_line_count;
	self->status_line_count = _tmp3_ + 1;
	if (((AsyncTask*) self)->prg_count_total > ((gint64) 0)) {
		((AsyncTask*) self)->prg_count = self->status_line_count;
		((AsyncTask*) self)->progress = (((AsyncTask*) self)->prg_count * 1.0) / ((AsyncTask*) self)->prg_count_total;
	}
	_tmp4_ = self->priv->regex_list;
	_tmp4__length1 = self->priv->regex_list_length1;
	_tmp5_ = _tmp4_[RSYNC_TASK_REGEX_TYPE_Created];
	_tmp7_ = g_regex_match (_tmp5_, line, 0, &_tmp6_);
	_g_match_info_unref0 (match);
	match = _tmp6_;
	if (_tmp7_) {
		gint64 _tmp8_;
		GMatchInfo* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar** _tmp12_;
		gchar** _tmp13_;
		gchar** _tmp14_;
		gint _tmp14__length1;
		const gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		GString* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		_tmp8_ = self->count_created;
		self->count_created = _tmp8_ + 1;
		_tmp9_ = match;
		_tmp10_ = g_match_info_fetch (_tmp9_, 3);
		_tmp11_ = _tmp10_;
		_tmp13_ = _tmp12_ = g_strsplit (_tmp11_, " -> ", 0);
		_tmp14_ = _tmp13_;
		_tmp14__length1 = _vala_array_length (_tmp12_);
		_tmp15_ = _tmp14_[0];
		_tmp16_ = string_strip (_tmp15_);
		_tmp17_ = _tmp16_;
		async_task_set_status_line ((AsyncTask*) self, _tmp17_);
		_g_free0 (_tmp17_);
		_tmp14_ = (_vala_array_free (_tmp14_, _tmp14__length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (_tmp11_);
		_tmp18_ = self->log;
		_tmp19_ = g_strconcat (line, "\n", NULL);
		_tmp20_ = _tmp19_;
		g_string_append (_tmp18_, _tmp20_);
		_g_free0 (_tmp20_);
	} else {
		GRegex** _tmp21_;
		gint _tmp21__length1;
		GRegex* _tmp22_;
		GMatchInfo* _tmp23_ = NULL;
		gboolean _tmp24_;
		_tmp21_ = self->priv->regex_list;
		_tmp21__length1 = self->priv->regex_list_length1;
		_tmp22_ = _tmp21_[RSYNC_TASK_REGEX_TYPE_Deleted];
		_tmp24_ = g_regex_match (_tmp22_, line, 0, &_tmp23_);
		_g_match_info_unref0 (match);
		match = _tmp23_;
		if (_tmp24_) {
			gint64 _tmp25_;
			GMatchInfo* _tmp26_;
			gchar* _tmp27_;
			gchar* _tmp28_;
			gchar** _tmp29_;
			gchar** _tmp30_;
			gchar** _tmp31_;
			gint _tmp31__length1;
			const gchar* _tmp32_;
			gchar* _tmp33_;
			gchar* _tmp34_;
			GString* _tmp35_;
			gchar* _tmp36_;
			gchar* _tmp37_;
			_tmp25_ = self->count_deleted;
			self->count_deleted = _tmp25_ + 1;
			_tmp26_ = match;
			_tmp27_ = g_match_info_fetch (_tmp26_, 1);
			_tmp28_ = _tmp27_;
			_tmp30_ = _tmp29_ = g_strsplit (_tmp28_, " -> ", 0);
			_tmp31_ = _tmp30_;
			_tmp31__length1 = _vala_array_length (_tmp29_);
			_tmp32_ = _tmp31_[0];
			_tmp33_ = string_strip (_tmp32_);
			_tmp34_ = _tmp33_;
			async_task_set_status_line ((AsyncTask*) self, _tmp34_);
			_g_free0 (_tmp34_);
			_tmp31_ = (_vala_array_free (_tmp31_, _tmp31__length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (_tmp28_);
			_tmp35_ = self->log;
			_tmp36_ = g_strconcat (line, "\n", NULL);
			_tmp37_ = _tmp36_;
			g_string_append (_tmp35_, _tmp37_);
			_g_free0 (_tmp37_);
		} else {
			GRegex** _tmp38_;
			gint _tmp38__length1;
			GRegex* _tmp39_;
			GMatchInfo* _tmp40_ = NULL;
			gboolean _tmp41_;
			_tmp38_ = self->priv->regex_list;
			_tmp38__length1 = self->priv->regex_list_length1;
			_tmp39_ = _tmp38_[RSYNC_TASK_REGEX_TYPE_Unchanged];
			_tmp41_ = g_regex_match (_tmp39_, line, 0, &_tmp40_);
			_g_match_info_unref0 (match);
			match = _tmp40_;
			if (_tmp41_) {
				gint64 _tmp42_;
				GMatchInfo* _tmp43_;
				gchar* _tmp44_;
				gchar* _tmp45_;
				gchar** _tmp46_;
				gchar** _tmp47_;
				gchar** _tmp48_;
				gint _tmp48__length1;
				const gchar* _tmp49_;
				gchar* _tmp50_;
				gchar* _tmp51_;
				_tmp42_ = self->count_unchanged;
				self->count_unchanged = _tmp42_ + 1;
				_tmp43_ = match;
				_tmp44_ = g_match_info_fetch (_tmp43_, 3);
				_tmp45_ = _tmp44_;
				_tmp47_ = _tmp46_ = g_strsplit (_tmp45_, " -> ", 0);
				_tmp48_ = _tmp47_;
				_tmp48__length1 = _vala_array_length (_tmp46_);
				_tmp49_ = _tmp48_[0];
				_tmp50_ = string_strip (_tmp49_);
				_tmp51_ = _tmp50_;
				async_task_set_status_line ((AsyncTask*) self, _tmp51_);
				_g_free0 (_tmp51_);
				_tmp48_ = (_vala_array_free (_tmp48_, _tmp48__length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (_tmp45_);
			} else {
				GRegex** _tmp52_;
				gint _tmp52__length1;
				GRegex* _tmp53_;
				GMatchInfo* _tmp54_ = NULL;
				gboolean _tmp55_;
				_tmp52_ = self->priv->regex_list;
				_tmp52__length1 = self->priv->regex_list_length1;
				_tmp53_ = _tmp52_[RSYNC_TASK_REGEX_TYPE_Modified];
				_tmp55_ = g_regex_match (_tmp53_, line, 0, &_tmp54_);
				_g_match_info_unref0 (match);
				match = _tmp54_;
				if (_tmp55_) {
					gint64 _tmp56_;
					GMatchInfo* _tmp57_;
					gchar* _tmp58_;
					gchar* _tmp59_;
					gchar** _tmp60_;
					gchar** _tmp61_;
					gchar** _tmp62_;
					gint _tmp62__length1;
					const gchar* _tmp63_;
					gchar* _tmp64_;
					gchar* _tmp65_;
					GString* _tmp66_;
					gchar* _tmp67_;
					gchar* _tmp68_;
					GMatchInfo* _tmp69_;
					gchar* _tmp70_;
					gchar* _tmp71_;
					gboolean _tmp72_;
					_tmp56_ = self->count_modified;
					self->count_modified = _tmp56_ + 1;
					_tmp57_ = match;
					_tmp58_ = g_match_info_fetch (_tmp57_, 12);
					_tmp59_ = _tmp58_;
					_tmp61_ = _tmp60_ = g_strsplit (_tmp59_, " -> ", 0);
					_tmp62_ = _tmp61_;
					_tmp62__length1 = _vala_array_length (_tmp60_);
					_tmp63_ = _tmp62_[0];
					_tmp64_ = string_strip (_tmp63_);
					_tmp65_ = _tmp64_;
					async_task_set_status_line ((AsyncTask*) self, _tmp65_);
					_g_free0 (_tmp65_);
					_tmp62_ = (_vala_array_free (_tmp62_, _tmp62__length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (_tmp59_);
					_tmp66_ = self->log;
					_tmp67_ = g_strconcat (line, "\n", NULL);
					_tmp68_ = _tmp67_;
					g_string_append (_tmp66_, _tmp68_);
					_g_free0 (_tmp68_);
					_tmp69_ = match;
					_tmp70_ = g_match_info_fetch (_tmp69_, 3);
					_tmp71_ = _tmp70_;
					_tmp72_ = g_strcmp0 (_tmp71_, "c") == 0;
					_g_free0 (_tmp71_);
					if (_tmp72_) {
						gint64 _tmp73_;
						_tmp73_ = self->count_checksum;
						self->count_checksum = _tmp73_ + 1;
					} else {
						GMatchInfo* _tmp74_;
						gchar* _tmp75_;
						gchar* _tmp76_;
						gboolean _tmp77_;
						_tmp74_ = match;
						_tmp75_ = g_match_info_fetch (_tmp74_, 4);
						_tmp76_ = _tmp75_;
						_tmp77_ = g_strcmp0 (_tmp76_, "s") == 0;
						_g_free0 (_tmp76_);
						if (_tmp77_) {
							gint64 _tmp78_;
							_tmp78_ = self->count_size;
							self->count_size = _tmp78_ + 1;
						} else {
							GMatchInfo* _tmp79_;
							gchar* _tmp80_;
							gchar* _tmp81_;
							gboolean _tmp82_;
							_tmp79_ = match;
							_tmp80_ = g_match_info_fetch (_tmp79_, 5);
							_tmp81_ = _tmp80_;
							_tmp82_ = g_strcmp0 (_tmp81_, "t") == 0;
							_g_free0 (_tmp81_);
							if (_tmp82_) {
								gint64 _tmp83_;
								_tmp83_ = self->count_timestamp;
								self->count_timestamp = _tmp83_ + 1;
							} else {
								GMatchInfo* _tmp84_;
								gchar* _tmp85_;
								gchar* _tmp86_;
								gboolean _tmp87_;
								_tmp84_ = match;
								_tmp85_ = g_match_info_fetch (_tmp84_, 6);
								_tmp86_ = _tmp85_;
								_tmp87_ = g_strcmp0 (_tmp86_, "p") == 0;
								_g_free0 (_tmp86_);
								if (_tmp87_) {
									gint64 _tmp88_;
									_tmp88_ = self->count_permissions;
									self->count_permissions = _tmp88_ + 1;
								} else {
									GMatchInfo* _tmp89_;
									gchar* _tmp90_;
									gchar* _tmp91_;
									gboolean _tmp92_;
									_tmp89_ = match;
									_tmp90_ = g_match_info_fetch (_tmp89_, 7);
									_tmp91_ = _tmp90_;
									_tmp92_ = g_strcmp0 (_tmp91_, "o") == 0;
									_g_free0 (_tmp91_);
									if (_tmp92_) {
										gint64 _tmp93_;
										_tmp93_ = self->count_owner;
										self->count_owner = _tmp93_ + 1;
									} else {
										GMatchInfo* _tmp94_;
										gchar* _tmp95_;
										gchar* _tmp96_;
										gboolean _tmp97_;
										_tmp94_ = match;
										_tmp95_ = g_match_info_fetch (_tmp94_, 8);
										_tmp96_ = _tmp95_;
										_tmp97_ = g_strcmp0 (_tmp96_, "g") == 0;
										_g_free0 (_tmp96_);
										if (_tmp97_) {
											gint64 _tmp98_;
											_tmp98_ = self->count_group;
											self->count_group = _tmp98_ + 1;
										} else {
											gint64 _tmp99_;
											_tmp99_ = self->count_unchanged;
											self->count_unchanged = _tmp99_ + 1;
										}
									}
								}
							}
						}
					}
				} else {
					GRegex** _tmp100_;
					gint _tmp100__length1;
					GRegex* _tmp101_;
					GMatchInfo* _tmp102_ = NULL;
					gboolean _tmp103_;
					_tmp100_ = self->priv->regex_list;
					_tmp100__length1 = self->priv->regex_list_length1;
					_tmp101_ = _tmp100_[RSYNC_TASK_REGEX_TYPE_TotalSize];
					_tmp103_ = g_regex_match (_tmp101_, line, 0, &_tmp102_);
					_g_match_info_unref0 (match);
					match = _tmp102_;
					if (_tmp103_) {
						GMatchInfo* _tmp104_;
						gchar* _tmp105_;
						gchar* _tmp106_;
						gchar* _tmp107_;
						gchar* _tmp108_;
						_tmp104_ = match;
						_tmp105_ = g_match_info_fetch (_tmp104_, 1);
						_tmp106_ = _tmp105_;
						_tmp107_ = string_replace (_tmp106_, ",", "");
						_tmp108_ = _tmp107_;
						self->total_size = int64_parse (_tmp108_, (guint) 0);
						_g_free0 (_tmp108_);
						_g_free0 (_tmp106_);
					} else {
					}
				}
			}
		}
	}
	result = TRUE;
	_g_match_info_unref0 (match);
	return result;
}

static void
rsync_task_real_finish_task (AsyncTask* base)
{
	RsyncTask * self;
	const gchar* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	self = (RsyncTask*) base;
	_tmp0_ = self->rsync_log_file;
	_tmp1_ = strlen (_tmp0_);
	_tmp2_ = _tmp1_;
	if (0 < _tmp2_) {
		const gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		GString* _tmp6_;
		const gchar* _tmp7_;
		_tmp3_ = self->rsync_log_file;
		_tmp4_ = g_strconcat (_tmp3_, "-changes", NULL);
		_tmp5_ = _tmp4_;
		_tmp6_ = self->log;
		_tmp7_ = _tmp6_->str;
		tee_jee_file_system_file_write (_tmp5_, _tmp7_);
		_g_free0 (_tmp5_);
	}
}

static void
rsync_task_class_init (RsyncTaskClass * klass,
                       gpointer klass_data)
{
	rsync_task_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RsyncTask_private_offset);
	((AsyncTaskClass *) klass)->prepare = (void (*) (AsyncTask*)) rsync_task_real_prepare;
	((AsyncTaskClass *) klass)->build_script = (gchar* (*) (AsyncTask*)) rsync_task_real_build_script;
	((AsyncTaskClass *) klass)->parse_stdout_line = (void (*) (AsyncTask*, const gchar*)) rsync_task_real_parse_stdout_line;
	((AsyncTaskClass *) klass)->parse_stderr_line = (void (*) (AsyncTask*, const gchar*)) rsync_task_real_parse_stderr_line;
	((AsyncTaskClass *) klass)->finish_task = (void (*) (AsyncTask*)) rsync_task_real_finish_task;
	G_OBJECT_CLASS (klass)->finalize = rsync_task_finalize;
}

static void
rsync_task_instance_init (RsyncTask * self,
                          gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	self->priv = rsync_task_get_instance_private (self);
	self->delete_extra = TRUE;
	self->delete_after = FALSE;
	self->delete_excluded = FALSE;
	self->relative = FALSE;
	_tmp0_ = g_strdup ("");
	self->rsync_log_file = _tmp0_;
	_tmp1_ = g_strdup ("");
	self->exclude_from_file = _tmp1_;
	_tmp2_ = g_strdup ("");
	self->link_from_path = _tmp2_;
	_tmp3_ = g_strdup ("");
	self->source_path = _tmp3_;
	_tmp4_ = g_strdup ("");
	self->dest_path = _tmp4_;
	self->verbose = TRUE;
	self->io_nice = TRUE;
	self->dry_run = FALSE;
	self->priv->regex_list = NULL;
	self->priv->regex_list_length1 = 0;
	self->priv->_regex_list_size_ = self->priv->regex_list_length1;
	self->status_line_count = (gint64) 0;
	self->total_size = (gint64) 0;
}

static void
rsync_task_finalize (GObject * obj)
{
	RsyncTask * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_RSYNC_TASK, RsyncTask);
	_g_free0 (self->rsync_log_file);
	_g_free0 (self->exclude_from_file);
	_g_free0 (self->link_from_path);
	_g_free0 (self->source_path);
	_g_free0 (self->dest_path);
	self->priv->regex_list = (_vala_array_free (self->priv->regex_list, self->priv->regex_list_length1, (GDestroyNotify) g_regex_unref), NULL);
	(self->status_lines == NULL) ? NULL : (self->status_lines = (_g_queue_free__g_free0_ (self->status_lines), NULL));
	_g_string_free0 (self->log);
	G_OBJECT_CLASS (rsync_task_parent_class)->finalize (obj);
}

static GType
rsync_task_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RsyncTaskClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rsync_task_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RsyncTask), 0, (GInstanceInitFunc) rsync_task_instance_init, NULL };
	GType rsync_task_type_id;
	rsync_task_type_id = g_type_register_static (TYPE_ASYNC_TASK, "RsyncTask", &g_define_type_info, 0);
	RsyncTask_private_offset = g_type_add_instance_private (rsync_task_type_id, sizeof (RsyncTaskPrivate));
	return rsync_task_type_id;
}

GType
rsync_task_get_type (void)
{
	static volatile gsize rsync_task_type_id__once = 0;
	if (g_once_init_enter (&rsync_task_type_id__once)) {
		GType rsync_task_type_id;
		rsync_task_type_id = rsync_task_get_type_once ();
		g_once_init_leave (&rsync_task_type_id__once, rsync_task_type_id);
	}
	return rsync_task_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

