/* TeeJee.Misc.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from TeeJee.Misc.vala, do not modify */

/*
 * TeeJee.Misc.vala
 *
 * Copyright 2012-2018 Tony George <teejeetech@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 *
 */

#define _XOPEN_SOURCE

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <locale.h>
#include <time.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

VALA_EXTERN void tee_jee_misc_set_numeric_locale (const gchar* type);
VALA_EXTERN gchar* tee_jee_misc_timestamp (gboolean show_millis);
VALA_EXTERN gchar* tee_jee_misc_timestamp_numeric (void);
VALA_EXTERN gchar* tee_jee_misc_timestamp_for_path (void);
VALA_EXTERN gchar* tee_jee_misc_format_duration (gdouble millis);
VALA_EXTERN gchar* tee_jee_misc_escape_html (const gchar* html);
VALA_EXTERN gchar* tee_jee_misc_random_string (gint length,
                                   const gchar* charset);

void
tee_jee_misc_set_numeric_locale (const gchar* type)
{
	g_return_if_fail (type != NULL);
	setlocale (LC_NUMERIC, type);
	setlocale (LC_COLLATE, type);
	setlocale (LC_TIME, type);
}

gchar*
tee_jee_misc_timestamp (gboolean show_millis)
{
	GDateTime* now = NULL;
	GDateTime* _tmp0_;
	gchar* result;
	_tmp0_ = g_date_time_new_now_local ();
	now = _tmp0_;
	if (show_millis) {
		gint msec = 0;
		GDateTime* _tmp1_;
		GDateTime* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp1_ = now;
		msec = g_date_time_get_microsecond (_tmp1_) / 1000;
		_tmp2_ = now;
		_tmp3_ = g_date_time_format (_tmp2_, "%H:%M:%S");
		_tmp4_ = _tmp3_;
		_tmp5_ = g_strdup_printf ("%s.%03d", _tmp4_, msec);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		result = _tmp6_;
		_g_date_time_unref0 (now);
		return result;
	} else {
		GDateTime* _tmp7_;
		gchar* _tmp8_;
		_tmp7_ = now;
		_tmp8_ = g_date_time_format (_tmp7_, "%H:%M:%S");
		result = _tmp8_;
		_g_date_time_unref0 (now);
		return result;
	}
}

gchar*
tee_jee_misc_timestamp_numeric (void)
{
	time_t _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	_tmp0_ = time (NULL);
	_tmp1_ = g_strdup_printf ("%ld", (glong) _tmp0_);
	result = _tmp1_;
	return result;
}

static void
g_time_local (time_t time,
              struct tm* result)
{
	struct tm _result_ = {0};
	struct tm _tmp0_ = {0};
	localtime_r (&time, &_tmp0_);
	_result_ = _tmp0_;
	*result = _result_;
	return;
}

static gchar*
g_time_format (struct tm *self,
               const gchar* format)
{
	gchar* buffer = NULL;
	gchar* _tmp0_;
	gint buffer_length1;
	gint _buffer_size_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (format != NULL, NULL);
	_tmp0_ = g_new0 (gchar, 64);
	buffer = _tmp0_;
	buffer_length1 = 64;
	_buffer_size_ = buffer_length1;
	strftime (buffer, (gint) buffer_length1, format, &(*self));
	_tmp1_ = g_strdup ((const gchar*) buffer);
	result = _tmp1_;
	buffer = (g_free (buffer), NULL);
	return result;
}

gchar*
tee_jee_misc_timestamp_for_path (void)
{
	struct tm t = {0};
	time_t _tmp0_;
	struct tm _tmp1_ = {0};
	gchar* _tmp2_;
	gchar* result;
	_tmp0_ = time (NULL);
	g_time_local (_tmp0_, &_tmp1_);
	t = _tmp1_;
	_tmp2_ = g_time_format (&t, "%Y-%m-%d_%H-%M-%S");
	result = _tmp2_;
	return result;
}

gchar*
tee_jee_misc_format_duration (gdouble millis)
{
	gdouble time = 0.0;
	gdouble hr = 0.0;
	gdouble min = 0.0;
	gdouble sec = 0.0;
	gchar* _tmp0_;
	gchar* result;
	time = millis / 1000.0;
	hr = floor (time / (60.0 * 60));
	time = time - ((hr * 60) * 60);
	min = floor (time / 60.0);
	time = time - (min * 60);
	sec = floor (time);
	_tmp0_ = g_strdup_printf ("%02.0lf:%02.0lf:%02.0lf", hr, min, sec);
	result = _tmp0_;
	return result;
}

gchar*
tee_jee_misc_escape_html (const gchar* html)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (html != NULL, NULL);
	_tmp0_ = g_markup_escape_text (html, (gssize) -1);
	result = _tmp0_;
	return result;
}

static gunichar
string_get_char (const gchar* self,
                 glong index)
{
	gunichar result;
	g_return_val_if_fail (self != NULL, 0U);
	result = g_utf8_get_char (((gchar*) self) + index);
	return result;
}

static gint
string_index_of_nth_char (const gchar* self,
                          glong c)
{
	gchar* _tmp0_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_offset_to_pointer (self, c);
	result = (gint) (_tmp0_ - ((gchar*) self));
	return result;
}

static gchar*
g_unichar_to_string (gunichar self)
{
	gchar* str = NULL;
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = g_new0 (gchar, 7);
	str = (gchar*) _tmp0_;
	g_unichar_to_utf8 (self, str);
	result = str;
	return result;
}

gchar*
tee_jee_misc_random_string (gint length,
                            const gchar* charset)
{
	gchar* random = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (charset != NULL, NULL);
	_tmp0_ = g_strdup ("");
	random = _tmp0_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gint random_index = 0;
				gint _tmp3_;
				gint _tmp4_;
				gchar* ch = NULL;
				gchar* _tmp5_;
				const gchar* _tmp6_;
				const gchar* _tmp7_;
				gchar* _tmp8_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(i < length)) {
					break;
				}
				_tmp3_ = strlen (charset);
				_tmp4_ = _tmp3_;
				random_index = (gint) g_random_int_range ((gint32) 0, (gint32) _tmp4_);
				_tmp5_ = g_unichar_to_string (string_get_char (charset, (glong) string_index_of_nth_char (charset, (glong) random_index)));
				ch = _tmp5_;
				_tmp6_ = random;
				_tmp7_ = ch;
				_tmp8_ = g_strconcat (_tmp6_, _tmp7_, NULL);
				_g_free0 (random);
				random = _tmp8_;
				_g_free0 (ch);
			}
		}
	}
	result = random;
	return result;
}

