/* FsTabEntry.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from FsTabEntry.vala, do not modify */

/*
 * FsTabEntry.vala
 *
 * Copyright 2012-2018 Tony George <teejeetech@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 *
 */

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gtk/gtk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_FS_TAB_ENTRY (fs_tab_entry_get_type ())
#define FS_TAB_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FS_TAB_ENTRY, FsTabEntry))
#define FS_TAB_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FS_TAB_ENTRY, FsTabEntryClass))
#define IS_FS_TAB_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FS_TAB_ENTRY))
#define IS_FS_TAB_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FS_TAB_ENTRY))
#define FS_TAB_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FS_TAB_ENTRY, FsTabEntryClass))

typedef struct _FsTabEntry FsTabEntry;
typedef struct _FsTabEntryClass FsTabEntryClass;
typedef struct _FsTabEntryPrivate FsTabEntryPrivate;
enum  {
	FS_TAB_ENTRY_0_PROPERTY,
	FS_TAB_ENTRY_DEVICE_UUID_PROPERTY,
	FS_TAB_ENTRY_NUM_PROPERTIES
};
static GParamSpec* fs_tab_entry_properties[FS_TAB_ENTRY_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_CRYPT_TAB_ENTRY (crypt_tab_entry_get_type ())
#define CRYPT_TAB_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CRYPT_TAB_ENTRY, CryptTabEntry))
#define CRYPT_TAB_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CRYPT_TAB_ENTRY, CryptTabEntryClass))
#define IS_CRYPT_TAB_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CRYPT_TAB_ENTRY))
#define IS_CRYPT_TAB_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CRYPT_TAB_ENTRY))
#define CRYPT_TAB_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CRYPT_TAB_ENTRY, CryptTabEntryClass))

typedef struct _CryptTabEntry CryptTabEntry;
typedef struct _CryptTabEntryClass CryptTabEntryClass;

#define TYPE_DEVICE (device_get_type ())
#define DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DEVICE, Device))
#define DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DEVICE, DeviceClass))
#define IS_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DEVICE))
#define IS_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DEVICE))
#define DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DEVICE, DeviceClass))

typedef struct _Device Device;
typedef struct _DeviceClass DeviceClass;
typedef struct _CryptTabEntryPrivate CryptTabEntryPrivate;

struct _FsTabEntry {
	GObject parent_instance;
	FsTabEntryPrivate * priv;
	gboolean is_comment;
	gboolean is_empty_line;
	gchar* device_string;
	gchar* mount_point;
	gchar* type;
	gchar* options;
	gchar* dump;
	gchar* pass;
	gchar* line;
};

struct _FsTabEntryClass {
	GObjectClass parent_class;
};

struct _CryptTabEntry {
	GObject parent_instance;
	CryptTabEntryPrivate * priv;
	gboolean is_comment;
	gboolean is_empty_line;
	gchar* mapped_name;
	gchar* device_string;
	gchar* keyfile;
	gchar* options;
	gchar* line;
};

struct _CryptTabEntryClass {
	GObjectClass parent_class;
};

static gpointer fs_tab_entry_parent_class = NULL;

VALA_EXTERN GType fs_tab_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FsTabEntry, g_object_unref)
VALA_EXTERN GeeArrayList* fs_tab_entry_read_file (const gchar* file_path);
VALA_EXTERN gboolean tee_jee_file_system_file_exists (const gchar* file_path);
VALA_EXTERN gchar* tee_jee_file_system_file_read (const gchar* file_path);
VALA_EXTERN FsTabEntry* fs_tab_entry_new (void);
VALA_EXTERN FsTabEntry* fs_tab_entry_construct (GType object_type);
VALA_EXTERN gchar* fs_tab_entry_write_file (GeeArrayList* entries,
                                const gchar* file_path,
                                gboolean keep_comments_and_empty_lines);
static gint __lambda8_ (FsTabEntry* a,
                 FsTabEntry* b);
static gint ___lambda8__gcompare_data_func (gconstpointer a,
                                     gconstpointer b,
                                     gpointer self);
VALA_EXTERN gboolean tee_jee_file_system_file_delete (const gchar* file_path);
VALA_EXTERN gboolean tee_jee_file_system_file_write (const gchar* file_path,
                                         const gchar* contents);
VALA_EXTERN gchar* fs_tab_entry_subvolume_name (FsTabEntry* self);
VALA_EXTERN gboolean fs_tab_entry_is_for_system_directory (FsTabEntry* self);
VALA_EXTERN FsTabEntry* fs_tab_entry_find_entry_by_mount_point (GeeArrayList* entries,
                                                    const gchar* mount_path);
VALA_EXTERN GType crypt_tab_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CryptTabEntry, g_object_unref)
VALA_EXTERN GType device_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Device, g_object_unref)
VALA_EXTERN Device* fs_tab_entry_resolve_device (FsTabEntry* self,
                                     GeeArrayList* crypttab,
                                     GtkWindow* parent_window);
VALA_EXTERN gchar* fs_tab_entry_get_device_uuid (FsTabEntry* self);
VALA_EXTERN Device* device_get_device_by_uuid (const gchar* uuid);
VALA_EXTERN Device* device_get_device_by_name (const gchar* file_name);
VALA_EXTERN Device* device_luks_unlock (Device* luks_device,
                            const gchar* mapped_name,
                            const gchar* passphrase,
                            GtkWindow* parent_window,
                            gchar** message,
                            gchar** details);
VALA_EXTERN void fs_tab_entry_append_option (FsTabEntry* self,
                                 const gchar* option);
VALA_EXTERN void fs_tab_entry_remove_option (FsTabEntry* self,
                                 const gchar* option);
VALA_EXTERN void fs_tab_entry_set_device_uuid (FsTabEntry* self,
                                   const gchar* value);
static void fs_tab_entry_finalize (GObject * obj);
static GType fs_tab_entry_get_type_once (void);
static void _vala_fs_tab_entry_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec);
static void _vala_fs_tab_entry_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

GeeArrayList*
fs_tab_entry_read_file (const gchar* file_path)
{
	GeeArrayList* list = NULL;
	GeeArrayList* _tmp0_;
	gchar* text = NULL;
	gchar* _tmp1_;
	gchar** lines = NULL;
	const gchar* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint lines_length1;
	gint _lines_size_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	GeeArrayList* result;
	g_return_val_if_fail (file_path != NULL, NULL);
	_tmp0_ = gee_array_list_new (TYPE_FS_TAB_ENTRY, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	list = _tmp0_;
	if (!tee_jee_file_system_file_exists (file_path)) {
		result = list;
		return result;
	}
	_tmp1_ = tee_jee_file_system_file_read (file_path);
	text = _tmp1_;
	_tmp2_ = text;
	_tmp4_ = _tmp3_ = g_strsplit (_tmp2_, "\n", 0);
	lines = _tmp4_;
	lines_length1 = _vala_array_length (_tmp3_);
	_lines_size_ = lines_length1;
	_tmp5_ = lines;
	_tmp5__length1 = lines_length1;
	{
		gchar** line_collection = NULL;
		gint line_collection_length1 = 0;
		gint _line_collection_size_ = 0;
		gint line_it = 0;
		line_collection = _tmp5_;
		line_collection_length1 = _tmp5__length1;
		for (line_it = 0; line_it < line_collection_length1; line_it = line_it + 1) {
			gchar* _tmp6_;
			gchar* line = NULL;
			_tmp6_ = g_strdup (line_collection[line_it]);
			line = _tmp6_;
			{
				FsTabEntry* entry = NULL;
				FsTabEntry* _tmp7_;
				GeeArrayList* _tmp8_;
				FsTabEntry* _tmp9_;
				FsTabEntry* _tmp10_;
				const gchar* _tmp11_;
				gchar* _tmp12_;
				gchar* _tmp13_;
				FsTabEntry* _tmp14_;
				const gchar* _tmp15_;
				gchar* _tmp16_;
				gchar* _tmp17_;
				gint _tmp18_;
				gint _tmp19_;
				FsTabEntry* _tmp20_;
				_tmp7_ = fs_tab_entry_new ();
				entry = _tmp7_;
				_tmp8_ = list;
				_tmp9_ = entry;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp8_, _tmp9_);
				_tmp10_ = entry;
				_tmp11_ = line;
				_tmp12_ = string_strip (_tmp11_);
				_tmp13_ = _tmp12_;
				_tmp10_->is_comment = g_str_has_prefix (_tmp13_, "#");
				_g_free0 (_tmp13_);
				_tmp14_ = entry;
				_tmp15_ = line;
				_tmp16_ = string_strip (_tmp15_);
				_tmp17_ = _tmp16_;
				_tmp18_ = strlen (_tmp17_);
				_tmp19_ = _tmp18_;
				_tmp14_->is_empty_line = _tmp19_ == 0;
				_g_free0 (_tmp17_);
				_tmp20_ = entry;
				if (_tmp20_->is_comment) {
					FsTabEntry* _tmp21_;
					const gchar* _tmp22_;
					gchar* _tmp23_;
					_tmp21_ = entry;
					_tmp22_ = line;
					_tmp23_ = g_strdup (_tmp22_);
					_g_free0 (_tmp21_->line);
					_tmp21_->line = _tmp23_;
				} else {
					FsTabEntry* _tmp24_;
					_tmp24_ = entry;
					if (_tmp24_->is_empty_line) {
						FsTabEntry* _tmp25_;
						gchar* _tmp26_;
						_tmp25_ = entry;
						_tmp26_ = g_strdup ("");
						_g_free0 (_tmp25_->line);
						_tmp25_->line = _tmp26_;
					} else {
						FsTabEntry* _tmp27_;
						const gchar* _tmp28_;
						gchar* _tmp29_;
						gchar** parts = NULL;
						const gchar* _tmp30_;
						gchar* _tmp31_;
						gchar* _tmp32_;
						gchar** _tmp33_;
						gchar** _tmp34_;
						gchar** _tmp35_;
						gint _tmp35__length1;
						gint parts_length1;
						gint _parts_size_;
						gint part_num = 0;
						gchar** _tmp36_;
						gint _tmp36__length1;
						_tmp27_ = entry;
						_tmp28_ = line;
						_tmp29_ = g_strdup (_tmp28_);
						_g_free0 (_tmp27_->line);
						_tmp27_->line = _tmp29_;
						_tmp30_ = line;
						_tmp31_ = string_replace (_tmp30_, "\t", " ");
						_tmp32_ = _tmp31_;
						_tmp34_ = _tmp33_ = g_strsplit (_tmp32_, " ", 0);
						_tmp35_ = _tmp34_;
						_tmp35__length1 = _vala_array_length (_tmp33_);
						_g_free0 (_tmp32_);
						parts = _tmp35_;
						parts_length1 = _tmp35__length1;
						_parts_size_ = parts_length1;
						part_num = -1;
						_tmp36_ = parts;
						_tmp36__length1 = parts_length1;
						{
							gchar** part_collection = NULL;
							gint part_collection_length1 = 0;
							gint _part_collection_size_ = 0;
							gint part_it = 0;
							part_collection = _tmp36_;
							part_collection_length1 = _tmp36__length1;
							for (part_it = 0; part_it < part_collection_length1; part_it = part_it + 1) {
								gchar* _tmp37_;
								gchar* part = NULL;
								_tmp37_ = g_strdup (part_collection[part_it]);
								part = _tmp37_;
								{
									const gchar* _tmp38_;
									gchar* _tmp39_;
									gchar* _tmp40_;
									gint _tmp41_;
									gint _tmp42_;
									gboolean _tmp43_;
									gint _tmp44_;
									_tmp38_ = part;
									_tmp39_ = string_strip (_tmp38_);
									_tmp40_ = _tmp39_;
									_tmp41_ = strlen (_tmp40_);
									_tmp42_ = _tmp41_;
									_tmp43_ = _tmp42_ == 0;
									_g_free0 (_tmp40_);
									if (_tmp43_) {
										_g_free0 (part);
										continue;
									}
									part_num = part_num + 1;
									_tmp44_ = part_num;
									switch (_tmp44_) {
										case 0:
										{
											FsTabEntry* _tmp45_;
											const gchar* _tmp46_;
											gchar* _tmp47_;
											_tmp45_ = entry;
											_tmp46_ = part;
											_tmp47_ = string_strip (_tmp46_);
											_g_free0 (_tmp45_->device_string);
											_tmp45_->device_string = _tmp47_;
											break;
										}
										case 1:
										{
											FsTabEntry* _tmp48_;
											const gchar* _tmp49_;
											gchar* _tmp50_;
											_tmp48_ = entry;
											_tmp49_ = part;
											_tmp50_ = string_strip (_tmp49_);
											_g_free0 (_tmp48_->mount_point);
											_tmp48_->mount_point = _tmp50_;
											break;
										}
										case 2:
										{
											FsTabEntry* _tmp51_;
											const gchar* _tmp52_;
											gchar* _tmp53_;
											_tmp51_ = entry;
											_tmp52_ = part;
											_tmp53_ = string_strip (_tmp52_);
											_g_free0 (_tmp51_->type);
											_tmp51_->type = _tmp53_;
											break;
										}
										case 3:
										{
											FsTabEntry* _tmp54_;
											const gchar* _tmp55_;
											gchar* _tmp56_;
											_tmp54_ = entry;
											_tmp55_ = part;
											_tmp56_ = string_strip (_tmp55_);
											_g_free0 (_tmp54_->options);
											_tmp54_->options = _tmp56_;
											break;
										}
										case 4:
										{
											FsTabEntry* _tmp57_;
											const gchar* _tmp58_;
											gchar* _tmp59_;
											_tmp57_ = entry;
											_tmp58_ = part;
											_tmp59_ = string_strip (_tmp58_);
											_g_free0 (_tmp57_->dump);
											_tmp57_->dump = _tmp59_;
											break;
										}
										case 5:
										{
											FsTabEntry* _tmp60_;
											const gchar* _tmp61_;
											gchar* _tmp62_;
											_tmp60_ = entry;
											_tmp61_ = part;
											_tmp62_ = string_strip (_tmp61_);
											_g_free0 (_tmp60_->pass);
											_tmp60_->pass = _tmp62_;
											break;
										}
										default:
										break;
									}
									_g_free0 (part);
								}
							}
						}
						parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
					}
				}
				_g_object_unref0 (entry);
				_g_free0 (line);
			}
		}
	}
	result = list;
	lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (text);
	return result;
}

static gint
__lambda8_ (FsTabEntry* a,
            FsTabEntry* b)
{
	GCompareFunc _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = ((GCompareFunc) g_strcmp0);
	_tmp1_ = a->mount_point;
	_tmp2_ = b->mount_point;
	result = _tmp0_ (_tmp1_, _tmp2_);
	return result;
}

static gint
___lambda8__gcompare_data_func (gconstpointer a,
                                gconstpointer b,
                                gpointer self)
{
	gint result;
	result = __lambda8_ ((FsTabEntry*) a, (FsTabEntry*) b);
	return result;
}

gchar*
fs_tab_entry_write_file (GeeArrayList* entries,
                         const gchar* file_path,
                         gboolean keep_comments_and_empty_lines)
{
	gchar* text = NULL;
	gchar* _tmp0_;
	const gchar* _tmp35_;
	gchar* result;
	g_return_val_if_fail (entries != NULL, NULL);
	g_return_val_if_fail (file_path != NULL, NULL);
	_tmp0_ = g_strdup ("");
	text = _tmp0_;
	if (!keep_comments_and_empty_lines) {
		const gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = text;
		_tmp2_ = g_strconcat (_tmp1_, "# <file system> <mount point> <type> <options> <dump> <pass>\n\n", NULL);
		_g_free0 (text);
		text = _tmp2_;
	}
	{
		GeeArrayList* _entry_list = NULL;
		gint _entry_size = 0;
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _entry_index = 0;
		_entry_list = entries;
		_tmp3_ = _entry_list;
		_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_entry_size = _tmp5_;
		_entry_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			FsTabEntry* entry = NULL;
			GeeArrayList* _tmp8_;
			gpointer _tmp9_;
			gboolean _tmp10_ = FALSE;
			FsTabEntry* _tmp11_;
			_entry_index = _entry_index + 1;
			_tmp6_ = _entry_index;
			_tmp7_ = _entry_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _entry_list;
			_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _entry_index);
			entry = (FsTabEntry*) _tmp9_;
			_tmp11_ = entry;
			if (_tmp11_->is_comment) {
				_tmp10_ = TRUE;
			} else {
				FsTabEntry* _tmp12_;
				_tmp12_ = entry;
				_tmp10_ = _tmp12_->is_empty_line;
			}
			if (_tmp10_) {
				if (keep_comments_and_empty_lines) {
					const gchar* _tmp13_;
					FsTabEntry* _tmp14_;
					const gchar* _tmp15_;
					gchar* _tmp16_;
					gchar* _tmp17_;
					gchar* _tmp18_;
					_tmp13_ = text;
					_tmp14_ = entry;
					_tmp15_ = _tmp14_->line;
					_tmp16_ = g_strdup_printf ("%s\n", _tmp15_);
					_tmp17_ = _tmp16_;
					_tmp18_ = g_strconcat (_tmp13_, _tmp17_, NULL);
					_g_free0 (text);
					text = _tmp18_;
					_g_free0 (_tmp17_);
				}
			} else {
				const gchar* _tmp19_;
				FsTabEntry* _tmp20_;
				const gchar* _tmp21_;
				FsTabEntry* _tmp22_;
				const gchar* _tmp23_;
				FsTabEntry* _tmp24_;
				const gchar* _tmp25_;
				FsTabEntry* _tmp26_;
				const gchar* _tmp27_;
				FsTabEntry* _tmp28_;
				const gchar* _tmp29_;
				FsTabEntry* _tmp30_;
				const gchar* _tmp31_;
				gchar* _tmp32_;
				gchar* _tmp33_;
				gchar* _tmp34_;
				_tmp19_ = text;
				_tmp20_ = entry;
				_tmp21_ = _tmp20_->device_string;
				_tmp22_ = entry;
				_tmp23_ = _tmp22_->mount_point;
				_tmp24_ = entry;
				_tmp25_ = _tmp24_->type;
				_tmp26_ = entry;
				_tmp27_ = _tmp26_->options;
				_tmp28_ = entry;
				_tmp29_ = _tmp28_->dump;
				_tmp30_ = entry;
				_tmp31_ = _tmp30_->pass;
				_tmp32_ = g_strdup_printf ("%s\t%s\t%s\t%s\t%s\t%s\n", _tmp21_, _tmp23_, _tmp25_, _tmp27_, _tmp29_, _tmp31_);
				_tmp33_ = _tmp32_;
				_tmp34_ = g_strconcat (_tmp19_, _tmp33_, NULL);
				_g_free0 (text);
				text = _tmp34_;
				_g_free0 (_tmp33_);
			}
			_g_object_unref0 (entry);
		}
	}
	gee_list_sort ((GeeList*) entries, ___lambda8__gcompare_data_func, NULL, NULL);
	if (tee_jee_file_system_file_exists (file_path)) {
		tee_jee_file_system_file_delete (file_path);
	}
	_tmp35_ = text;
	tee_jee_file_system_file_write (file_path, _tmp35_);
	result = text;
	return result;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

gchar*
fs_tab_entry_subvolume_name (FsTabEntry* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->options;
	_tmp1_ = g_utf8_strdown (_tmp0_, (gssize) -1);
	_tmp2_ = _tmp1_;
	_tmp3_ = string_contains (_tmp2_, "subvol=");
	_g_free0 (_tmp2_);
	if (_tmp3_) {
		gchar* txt = NULL;
		const gchar* _tmp4_;
		gchar** _tmp5_;
		gchar** _tmp6_;
		gchar** _tmp7_;
		gint _tmp7__length1;
		const gchar* _tmp8_;
		gchar** _tmp9_;
		gchar** _tmp10_;
		gchar** _tmp11_;
		gint _tmp11__length1;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gboolean _tmp15_ = FALSE;
		const gchar* _tmp16_;
		_tmp4_ = self->options;
		_tmp6_ = _tmp5_ = g_strsplit (_tmp4_, "subvol=", 0);
		_tmp7_ = _tmp6_;
		_tmp7__length1 = _vala_array_length (_tmp5_);
		_tmp8_ = _tmp7_[1];
		_tmp10_ = _tmp9_ = g_strsplit (_tmp8_, ",", 0);
		_tmp11_ = _tmp10_;
		_tmp11__length1 = _vala_array_length (_tmp9_);
		_tmp12_ = _tmp11_[0];
		_tmp13_ = string_strip (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp11_ = (_vala_array_free (_tmp11_, _tmp11__length1, (GDestroyNotify) g_free), NULL);
		_tmp7_ = (_vala_array_free (_tmp7_, _tmp7__length1, (GDestroyNotify) g_free), NULL);
		txt = _tmp14_;
		_tmp16_ = txt;
		if (g_str_has_prefix (_tmp16_, "/")) {
			const gchar* _tmp17_;
			gchar** _tmp18_;
			gchar** _tmp19_;
			gchar** _tmp20_;
			gint _tmp20__length1;
			_tmp17_ = txt;
			_tmp19_ = _tmp18_ = g_strsplit (_tmp17_, "/", 0);
			_tmp20_ = _tmp19_;
			_tmp20__length1 = _vala_array_length (_tmp18_);
			_tmp15_ = _vala_array_length (_tmp18_) == 2;
			_tmp20_ = (_vala_array_free (_tmp20_, _tmp20__length1, (GDestroyNotify) g_free), NULL);
		} else {
			_tmp15_ = FALSE;
		}
		if (_tmp15_) {
			const gchar* _tmp21_;
			gchar** _tmp22_;
			gchar** _tmp23_;
			gchar** _tmp24_;
			gint _tmp24__length1;
			const gchar* _tmp25_;
			gchar* _tmp26_;
			_tmp21_ = txt;
			_tmp23_ = _tmp22_ = g_strsplit (_tmp21_, "/", 0);
			_tmp24_ = _tmp23_;
			_tmp24__length1 = _vala_array_length (_tmp22_);
			_tmp25_ = _tmp24_[1];
			_tmp26_ = g_strdup (_tmp25_);
			_g_free0 (txt);
			txt = _tmp26_;
			_tmp24_ = (_vala_array_free (_tmp24_, _tmp24__length1, (GDestroyNotify) g_free), NULL);
		}
		result = txt;
		return result;
	} else {
		gchar* _tmp27_;
		_tmp27_ = g_strdup ("");
		result = _tmp27_;
		return result;
	}
}

gboolean
fs_tab_entry_is_for_system_directory (FsTabEntry* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	const gchar* _tmp7_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp7_ = self->mount_point;
	if (g_str_has_prefix (_tmp7_, "/mnt")) {
		_tmp6_ = TRUE;
	} else {
		const gchar* _tmp8_;
		_tmp8_ = self->mount_point;
		_tmp6_ = g_str_has_prefix (_tmp8_, "/mount");
	}
	if (_tmp6_) {
		_tmp5_ = TRUE;
	} else {
		const gchar* _tmp9_;
		_tmp9_ = self->mount_point;
		_tmp5_ = g_str_has_prefix (_tmp9_, "/sdcard");
	}
	if (_tmp5_) {
		_tmp4_ = TRUE;
	} else {
		const gchar* _tmp10_;
		_tmp10_ = self->mount_point;
		_tmp4_ = g_str_has_prefix (_tmp10_, "/cdrom");
	}
	if (_tmp4_) {
		_tmp3_ = TRUE;
	} else {
		const gchar* _tmp11_;
		_tmp11_ = self->mount_point;
		_tmp3_ = g_str_has_prefix (_tmp11_, "/media");
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		const gchar* _tmp12_;
		_tmp12_ = self->mount_point;
		_tmp2_ = g_strcmp0 (_tmp12_, "none") == 0;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		const gchar* _tmp13_;
		_tmp13_ = self->mount_point;
		_tmp1_ = !g_str_has_prefix (_tmp13_, "/");
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp14_ = FALSE;
		const gchar* _tmp15_;
		_tmp15_ = self->device_string;
		if (!g_str_has_prefix (_tmp15_, "/dev/")) {
			const gchar* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			_tmp16_ = self->device_string;
			_tmp17_ = g_utf8_strdown (_tmp16_, (gssize) -1);
			_tmp18_ = _tmp17_;
			_tmp14_ = !g_str_has_prefix (_tmp18_, "uuid=");
			_g_free0 (_tmp18_);
		} else {
			_tmp14_ = FALSE;
		}
		_tmp0_ = _tmp14_;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	} else {
		result = TRUE;
		return result;
	}
}

FsTabEntry*
fs_tab_entry_find_entry_by_mount_point (GeeArrayList* entries,
                                        const gchar* mount_path)
{
	FsTabEntry* result;
	g_return_val_if_fail (entries != NULL, NULL);
	g_return_val_if_fail (mount_path != NULL, NULL);
	{
		GeeArrayList* _entry_list = NULL;
		gint _entry_size = 0;
		GeeArrayList* _tmp0_;
		gint _tmp1_;
		gint _tmp2_;
		gint _entry_index = 0;
		_entry_list = entries;
		_tmp0_ = _entry_list;
		_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
		_tmp2_ = _tmp1_;
		_entry_size = _tmp2_;
		_entry_index = -1;
		while (TRUE) {
			gint _tmp3_;
			gint _tmp4_;
			FsTabEntry* entry = NULL;
			GeeArrayList* _tmp5_;
			gpointer _tmp6_;
			FsTabEntry* _tmp7_;
			const gchar* _tmp8_;
			_entry_index = _entry_index + 1;
			_tmp3_ = _entry_index;
			_tmp4_ = _entry_size;
			if (!(_tmp3_ < _tmp4_)) {
				break;
			}
			_tmp5_ = _entry_list;
			_tmp6_ = gee_abstract_list_get ((GeeAbstractList*) _tmp5_, _entry_index);
			entry = (FsTabEntry*) _tmp6_;
			_tmp7_ = entry;
			_tmp8_ = _tmp7_->mount_point;
			if (g_strcmp0 (_tmp8_, mount_path) == 0) {
				result = entry;
				return result;
			}
			_g_object_unref0 (entry);
		}
	}
	result = NULL;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

Device*
fs_tab_entry_resolve_device (FsTabEntry* self,
                             GeeArrayList* crypttab,
                             GtkWindow* parent_window)
{
	Device* dev_fstab = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gboolean _tmp5_;
	Device* _tmp12_;
	Device* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (crypttab != NULL, NULL);
	dev_fstab = NULL;
	_tmp0_ = fs_tab_entry_get_device_uuid (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = strlen (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_ > 0;
	_g_free0 (_tmp2_);
	if (_tmp5_) {
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		Device* _tmp9_;
		_tmp6_ = fs_tab_entry_get_device_uuid (self);
		_tmp7_ = _tmp6_;
		_tmp8_ = _tmp7_;
		_tmp9_ = device_get_device_by_uuid (_tmp8_);
		_g_object_unref0 (dev_fstab);
		dev_fstab = _tmp9_;
		_g_free0 (_tmp8_);
	} else {
		const gchar* _tmp10_;
		Device* _tmp11_;
		_tmp10_ = self->device_string;
		_tmp11_ = device_get_device_by_name (_tmp10_);
		_g_object_unref0 (dev_fstab);
		dev_fstab = _tmp11_;
	}
	_tmp12_ = dev_fstab;
	if (_tmp12_ == NULL) {
		const gchar* _tmp13_;
		_tmp13_ = self->device_string;
		if (g_str_has_prefix (_tmp13_, "/dev/mapper/")) {
			gchar* mapped_name = NULL;
			const gchar* _tmp14_;
			gchar* _tmp15_;
			_tmp14_ = self->device_string;
			_tmp15_ = string_replace (_tmp14_, "/dev/mapper/", "");
			mapped_name = _tmp15_;
			{
				GeeArrayList* _item_list = NULL;
				gint _item_size = 0;
				GeeArrayList* _tmp16_;
				gint _tmp17_;
				gint _tmp18_;
				gint _item_index = 0;
				_item_list = crypttab;
				_tmp16_ = _item_list;
				_tmp17_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp16_);
				_tmp18_ = _tmp17_;
				_item_size = _tmp18_;
				_item_index = -1;
				while (TRUE) {
					gint _tmp19_;
					gint _tmp20_;
					CryptTabEntry* item = NULL;
					GeeArrayList* _tmp21_;
					gpointer _tmp22_;
					CryptTabEntry* _tmp23_;
					const gchar* _tmp24_;
					const gchar* _tmp25_;
					_item_index = _item_index + 1;
					_tmp19_ = _item_index;
					_tmp20_ = _item_size;
					if (!(_tmp19_ < _tmp20_)) {
						break;
					}
					_tmp21_ = _item_list;
					_tmp22_ = gee_abstract_list_get ((GeeAbstractList*) _tmp21_, _item_index);
					item = (CryptTabEntry*) _tmp22_;
					_tmp23_ = item;
					_tmp24_ = _tmp23_->mapped_name;
					_tmp25_ = mapped_name;
					if (g_strcmp0 (_tmp24_, _tmp25_) == 0) {
						CryptTabEntry* _tmp26_;
						const gchar* _tmp27_;
						gchar* _tmp28_;
						gchar* _tmp29_;
						gchar* _tmp30_;
						gchar* _tmp31_;
						gint _tmp32_;
						gint _tmp33_;
						gboolean _tmp34_;
						_tmp26_ = item;
						_tmp27_ = _tmp26_->device_string;
						_tmp28_ = g_strdup (_tmp27_);
						_g_free0 (self->device_string);
						self->device_string = _tmp28_;
						_tmp29_ = fs_tab_entry_get_device_uuid (self);
						_tmp30_ = _tmp29_;
						_tmp31_ = _tmp30_;
						_tmp32_ = strlen (_tmp31_);
						_tmp33_ = _tmp32_;
						_tmp34_ = _tmp33_ > 0;
						_g_free0 (_tmp31_);
						if (_tmp34_) {
							Device* dev_luks = NULL;
							gchar* _tmp35_;
							gchar* _tmp36_;
							gchar* _tmp37_;
							Device* _tmp38_;
							Device* _tmp39_;
							Device* _tmp40_;
							_tmp35_ = fs_tab_entry_get_device_uuid (self);
							_tmp36_ = _tmp35_;
							_tmp37_ = _tmp36_;
							_tmp38_ = device_get_device_by_uuid (_tmp37_);
							_tmp39_ = _tmp38_;
							_g_free0 (_tmp37_);
							dev_luks = _tmp39_;
							_tmp40_ = dev_luks;
							if (_tmp40_ != NULL) {
								gchar* msg_out = NULL;
								gchar* msg_err = NULL;
								Device* dev_unlocked = NULL;
								Device* _tmp41_;
								gchar* _tmp42_ = NULL;
								gchar* _tmp43_ = NULL;
								Device* _tmp44_;
								Device* _tmp45_;
								_tmp41_ = dev_luks;
								_tmp44_ = device_luks_unlock (_tmp41_, "", "", parent_window, &_tmp42_, &_tmp43_);
								_g_free0 (msg_out);
								msg_out = _tmp42_;
								_g_free0 (msg_err);
								msg_err = _tmp43_;
								dev_unlocked = _tmp44_;
								_tmp45_ = dev_unlocked;
								if (_tmp45_ != NULL) {
									Device* _tmp46_;
									Device* _tmp47_;
									_tmp46_ = dev_unlocked;
									_tmp47_ = _g_object_ref0 (_tmp46_);
									_g_object_unref0 (dev_fstab);
									dev_fstab = _tmp47_;
								} else {
									Device* _tmp48_;
									Device* _tmp49_;
									_tmp48_ = dev_luks;
									_tmp49_ = _g_object_ref0 (_tmp48_);
									_g_object_unref0 (dev_fstab);
									dev_fstab = _tmp49_;
								}
								_g_object_unref0 (dev_unlocked);
								_g_free0 (msg_err);
								_g_free0 (msg_out);
							}
							_g_object_unref0 (dev_luks);
						} else {
						}
						_g_object_unref0 (item);
						break;
					}
					_g_object_unref0 (item);
				}
			}
			_g_free0 (mapped_name);
		}
	}
	result = dev_fstab;
	return result;
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

void
fs_tab_entry_append_option (FsTabEntry* self,
                            const gchar* option)
{
	const gchar* _tmp0_;
	const gchar* _tmp5_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (option != NULL);
	_tmp0_ = self->options;
	if (!string_contains (_tmp0_, option)) {
		const gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp1_ = self->options;
		_tmp2_ = g_strdup_printf (",%s", option);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_strconcat (_tmp1_, _tmp3_, NULL);
		_g_free0 (self->options);
		self->options = _tmp4_;
		_g_free0 (_tmp3_);
	}
	_tmp5_ = self->options;
	if (g_str_has_prefix (_tmp5_, ",")) {
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gchar* _tmp10_;
		_tmp6_ = self->options;
		_tmp7_ = self->options;
		_tmp8_ = strlen (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = string_slice (_tmp6_, (glong) 1, (glong) _tmp9_);
		_g_free0 (self->options);
		self->options = _tmp10_;
	}
	_tmp11_ = self->options;
	_tmp12_ = string_strip (_tmp11_);
	_g_free0 (self->options);
	self->options = _tmp12_;
}

void
fs_tab_entry_remove_option (FsTabEntry* self,
                            const gchar* option)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp10_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (option != NULL);
	_tmp0_ = self->options;
	_tmp1_ = string_replace (_tmp0_, option, "");
	_tmp2_ = _tmp1_;
	_tmp3_ = string_strip (_tmp2_);
	_g_free0 (self->options);
	self->options = _tmp3_;
	_g_free0 (_tmp2_);
	_tmp4_ = self->options;
	if (g_str_has_prefix (_tmp4_, ",")) {
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gchar* _tmp9_;
		_tmp5_ = self->options;
		_tmp6_ = self->options;
		_tmp7_ = strlen (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = string_slice (_tmp5_, (glong) 1, (glong) _tmp8_);
		_g_free0 (self->options);
		self->options = _tmp9_;
	}
	_tmp10_ = self->options;
	if (g_str_has_suffix (_tmp10_, ",")) {
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		gchar* _tmp15_;
		_tmp11_ = self->options;
		_tmp12_ = self->options;
		_tmp13_ = strlen (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = string_slice (_tmp11_, (glong) 0, (glong) (_tmp14_ - 1));
		_g_free0 (self->options);
		self->options = _tmp15_;
	}
	_tmp16_ = self->options;
	_tmp17_ = string_strip (_tmp16_);
	_g_free0 (self->options);
	self->options = _tmp17_;
}

FsTabEntry*
fs_tab_entry_construct (GType object_type)
{
	FsTabEntry * self = NULL;
	self = (FsTabEntry*) g_object_new (object_type, NULL);
	return self;
}

FsTabEntry*
fs_tab_entry_new (void)
{
	return fs_tab_entry_construct (TYPE_FS_TAB_ENTRY);
}

gchar*
fs_tab_entry_get_device_uuid (FsTabEntry* self)
{
	gchar* result;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->device_string;
	_tmp1_ = g_utf8_strdown (_tmp0_, (gssize) -1);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_str_has_prefix (_tmp2_, "uuid=");
	_g_free0 (_tmp2_);
	if (_tmp3_) {
		const gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar** _tmp9_;
		gchar** _tmp10_;
		gchar** _tmp11_;
		gint _tmp11__length1;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		_tmp4_ = self->device_string;
		_tmp5_ = string_replace (_tmp4_, "\"", "");
		_tmp6_ = _tmp5_;
		_tmp7_ = string_replace (_tmp6_, "'", "");
		_tmp8_ = _tmp7_;
		_tmp10_ = _tmp9_ = g_strsplit (_tmp8_, "=", 0);
		_tmp11_ = _tmp10_;
		_tmp11__length1 = _vala_array_length (_tmp9_);
		_tmp12_ = _tmp11_[1];
		_tmp13_ = g_strdup (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp11_ = (_vala_array_free (_tmp11_, _tmp11__length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (_tmp8_);
		_g_free0 (_tmp6_);
		result = _tmp14_;
		return result;
	} else {
		gchar* _tmp15_;
		_tmp15_ = g_strdup ("");
		result = _tmp15_;
		return result;
	}
}

void
fs_tab_entry_set_device_uuid (FsTabEntry* self,
                              const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup_printf ("UUID=%s", value);
	_g_free0 (self->device_string);
	self->device_string = _tmp0_;
	g_object_notify_by_pspec ((GObject *) self, fs_tab_entry_properties[FS_TAB_ENTRY_DEVICE_UUID_PROPERTY]);
}

static void
fs_tab_entry_class_init (FsTabEntryClass * klass,
                         gpointer klass_data)
{
	fs_tab_entry_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->get_property = _vala_fs_tab_entry_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_fs_tab_entry_set_property;
	G_OBJECT_CLASS (klass)->finalize = fs_tab_entry_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FS_TAB_ENTRY_DEVICE_UUID_PROPERTY, fs_tab_entry_properties[FS_TAB_ENTRY_DEVICE_UUID_PROPERTY] = g_param_spec_string ("device-uuid", "device-uuid", "device-uuid", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
fs_tab_entry_instance_init (FsTabEntry * self,
                            gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	self->is_comment = FALSE;
	self->is_empty_line = FALSE;
	_tmp0_ = g_strdup ("");
	self->device_string = _tmp0_;
	_tmp1_ = g_strdup ("");
	self->mount_point = _tmp1_;
	_tmp2_ = g_strdup ("");
	self->type = _tmp2_;
	_tmp3_ = g_strdup ("defaults");
	self->options = _tmp3_;
	_tmp4_ = g_strdup ("0");
	self->dump = _tmp4_;
	_tmp5_ = g_strdup ("0");
	self->pass = _tmp5_;
	_tmp6_ = g_strdup ("");
	self->line = _tmp6_;
}

static void
fs_tab_entry_finalize (GObject * obj)
{
	FsTabEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_FS_TAB_ENTRY, FsTabEntry);
	_g_free0 (self->device_string);
	_g_free0 (self->mount_point);
	_g_free0 (self->type);
	_g_free0 (self->options);
	_g_free0 (self->dump);
	_g_free0 (self->pass);
	_g_free0 (self->line);
	G_OBJECT_CLASS (fs_tab_entry_parent_class)->finalize (obj);
}

static GType
fs_tab_entry_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FsTabEntryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) fs_tab_entry_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FsTabEntry), 0, (GInstanceInitFunc) fs_tab_entry_instance_init, NULL };
	GType fs_tab_entry_type_id;
	fs_tab_entry_type_id = g_type_register_static (G_TYPE_OBJECT, "FsTabEntry", &g_define_type_info, 0);
	return fs_tab_entry_type_id;
}

GType
fs_tab_entry_get_type (void)
{
	static volatile gsize fs_tab_entry_type_id__once = 0;
	if (g_once_init_enter (&fs_tab_entry_type_id__once)) {
		GType fs_tab_entry_type_id;
		fs_tab_entry_type_id = fs_tab_entry_get_type_once ();
		g_once_init_leave (&fs_tab_entry_type_id__once, fs_tab_entry_type_id);
	}
	return fs_tab_entry_type_id__once;
}

static void
_vala_fs_tab_entry_get_property (GObject * object,
                                 guint property_id,
                                 GValue * value,
                                 GParamSpec * pspec)
{
	FsTabEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_FS_TAB_ENTRY, FsTabEntry);
	switch (property_id) {
		case FS_TAB_ENTRY_DEVICE_UUID_PROPERTY:
		g_value_take_string (value, fs_tab_entry_get_device_uuid (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_fs_tab_entry_set_property (GObject * object,
                                 guint property_id,
                                 const GValue * value,
                                 GParamSpec * pspec)
{
	FsTabEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_FS_TAB_ENTRY, FsTabEntry);
	switch (property_id) {
		case FS_TAB_ENTRY_DEVICE_UUID_PROPERTY:
		fs_tab_entry_set_device_uuid (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

