/* CryptTabEntry.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from CryptTabEntry.vala, do not modify */

/*
 * CryptTabEntry.vala
 *
 * Copyright 2016 Tony George <teejeetech@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 *
 */

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_CRYPT_TAB_ENTRY (crypt_tab_entry_get_type ())
#define CRYPT_TAB_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CRYPT_TAB_ENTRY, CryptTabEntry))
#define CRYPT_TAB_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CRYPT_TAB_ENTRY, CryptTabEntryClass))
#define IS_CRYPT_TAB_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CRYPT_TAB_ENTRY))
#define IS_CRYPT_TAB_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CRYPT_TAB_ENTRY))
#define CRYPT_TAB_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CRYPT_TAB_ENTRY, CryptTabEntryClass))

typedef struct _CryptTabEntry CryptTabEntry;
typedef struct _CryptTabEntryClass CryptTabEntryClass;
typedef struct _CryptTabEntryPrivate CryptTabEntryPrivate;
enum  {
	CRYPT_TAB_ENTRY_0_PROPERTY,
	CRYPT_TAB_ENTRY_DEVICE_UUID_PROPERTY,
	CRYPT_TAB_ENTRY_NUM_PROPERTIES
};
static GParamSpec* crypt_tab_entry_properties[CRYPT_TAB_ENTRY_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _CryptTabEntry {
	GObject parent_instance;
	CryptTabEntryPrivate * priv;
	gboolean is_comment;
	gboolean is_empty_line;
	gchar* mapped_name;
	gchar* device_string;
	gchar* keyfile;
	gchar* options;
	gchar* line;
};

struct _CryptTabEntryClass {
	GObjectClass parent_class;
};

static gpointer crypt_tab_entry_parent_class = NULL;

VALA_EXTERN GType crypt_tab_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CryptTabEntry, g_object_unref)
VALA_EXTERN GeeArrayList* crypt_tab_entry_read_file (const gchar* file_path);
VALA_EXTERN gboolean tee_jee_file_system_file_exists (const gchar* file_path);
VALA_EXTERN gchar* tee_jee_file_system_file_read (const gchar* file_path);
VALA_EXTERN CryptTabEntry* crypt_tab_entry_new (void);
VALA_EXTERN CryptTabEntry* crypt_tab_entry_construct (GType object_type);
VALA_EXTERN gchar* crypt_tab_entry_write_file (GeeArrayList* entries,
                                   const gchar* file_path,
                                   gboolean keep_comments_and_empty_lines);
VALA_EXTERN gboolean tee_jee_file_system_file_delete (const gchar* file_path);
VALA_EXTERN gboolean tee_jee_file_system_file_write (const gchar* file_path,
                                         const gchar* contents);
VALA_EXTERN void crypt_tab_entry_append_option (CryptTabEntry* self,
                                    const gchar* option);
VALA_EXTERN void crypt_tab_entry_remove_option (CryptTabEntry* self,
                                    const gchar* option);
VALA_EXTERN CryptTabEntry* crypt_tab_entry_find_entry_by_uuid (GeeArrayList* entries,
                                                   const gchar* uuid);
VALA_EXTERN gchar* crypt_tab_entry_get_device_uuid (CryptTabEntry* self);
VALA_EXTERN void crypt_tab_entry_set_device_uuid (CryptTabEntry* self,
                                      const gchar* value);
static void crypt_tab_entry_finalize (GObject * obj);
static GType crypt_tab_entry_get_type_once (void);
static void _vala_crypt_tab_entry_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec);
static void _vala_crypt_tab_entry_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

GeeArrayList*
crypt_tab_entry_read_file (const gchar* file_path)
{
	GeeArrayList* list = NULL;
	GeeArrayList* _tmp0_;
	gchar* text = NULL;
	gchar* _tmp1_;
	gchar** lines = NULL;
	const gchar* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint lines_length1;
	gint _lines_size_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	GeeArrayList* result;
	g_return_val_if_fail (file_path != NULL, NULL);
	_tmp0_ = gee_array_list_new (TYPE_CRYPT_TAB_ENTRY, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	list = _tmp0_;
	if (!tee_jee_file_system_file_exists (file_path)) {
		result = list;
		return result;
	}
	_tmp1_ = tee_jee_file_system_file_read (file_path);
	text = _tmp1_;
	_tmp2_ = text;
	_tmp4_ = _tmp3_ = g_strsplit (_tmp2_, "\n", 0);
	lines = _tmp4_;
	lines_length1 = _vala_array_length (_tmp3_);
	_lines_size_ = lines_length1;
	_tmp5_ = lines;
	_tmp5__length1 = lines_length1;
	{
		gchar** line_collection = NULL;
		gint line_collection_length1 = 0;
		gint _line_collection_size_ = 0;
		gint line_it = 0;
		line_collection = _tmp5_;
		line_collection_length1 = _tmp5__length1;
		for (line_it = 0; line_it < line_collection_length1; line_it = line_it + 1) {
			gchar* _tmp6_;
			gchar* line = NULL;
			_tmp6_ = g_strdup (line_collection[line_it]);
			line = _tmp6_;
			{
				CryptTabEntry* entry = NULL;
				CryptTabEntry* _tmp7_;
				GeeArrayList* _tmp8_;
				CryptTabEntry* _tmp9_;
				CryptTabEntry* _tmp10_;
				const gchar* _tmp11_;
				gchar* _tmp12_;
				gchar* _tmp13_;
				CryptTabEntry* _tmp14_;
				const gchar* _tmp15_;
				gchar* _tmp16_;
				gchar* _tmp17_;
				gint _tmp18_;
				gint _tmp19_;
				CryptTabEntry* _tmp20_;
				_tmp7_ = crypt_tab_entry_new ();
				entry = _tmp7_;
				_tmp8_ = list;
				_tmp9_ = entry;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp8_, _tmp9_);
				_tmp10_ = entry;
				_tmp11_ = line;
				_tmp12_ = string_strip (_tmp11_);
				_tmp13_ = _tmp12_;
				_tmp10_->is_comment = g_str_has_prefix (_tmp13_, "#");
				_g_free0 (_tmp13_);
				_tmp14_ = entry;
				_tmp15_ = line;
				_tmp16_ = string_strip (_tmp15_);
				_tmp17_ = _tmp16_;
				_tmp18_ = strlen (_tmp17_);
				_tmp19_ = _tmp18_;
				_tmp14_->is_empty_line = _tmp19_ == 0;
				_g_free0 (_tmp17_);
				_tmp20_ = entry;
				if (_tmp20_->is_comment) {
					CryptTabEntry* _tmp21_;
					const gchar* _tmp22_;
					gchar* _tmp23_;
					_tmp21_ = entry;
					_tmp22_ = line;
					_tmp23_ = g_strdup (_tmp22_);
					_g_free0 (_tmp21_->line);
					_tmp21_->line = _tmp23_;
				} else {
					CryptTabEntry* _tmp24_;
					_tmp24_ = entry;
					if (_tmp24_->is_empty_line) {
						CryptTabEntry* _tmp25_;
						gchar* _tmp26_;
						_tmp25_ = entry;
						_tmp26_ = g_strdup ("");
						_g_free0 (_tmp25_->line);
						_tmp25_->line = _tmp26_;
					} else {
						CryptTabEntry* _tmp27_;
						const gchar* _tmp28_;
						gchar* _tmp29_;
						gchar** parts = NULL;
						const gchar* _tmp30_;
						gchar* _tmp31_;
						gchar* _tmp32_;
						gchar** _tmp33_;
						gchar** _tmp34_;
						gchar** _tmp35_;
						gint _tmp35__length1;
						gint parts_length1;
						gint _parts_size_;
						gint part_num = 0;
						gchar** _tmp36_;
						gint _tmp36__length1;
						_tmp27_ = entry;
						_tmp28_ = line;
						_tmp29_ = g_strdup (_tmp28_);
						_g_free0 (_tmp27_->line);
						_tmp27_->line = _tmp29_;
						_tmp30_ = line;
						_tmp31_ = string_replace (_tmp30_, "\t", " ");
						_tmp32_ = _tmp31_;
						_tmp34_ = _tmp33_ = g_strsplit (_tmp32_, " ", 0);
						_tmp35_ = _tmp34_;
						_tmp35__length1 = _vala_array_length (_tmp33_);
						_g_free0 (_tmp32_);
						parts = _tmp35_;
						parts_length1 = _tmp35__length1;
						_parts_size_ = parts_length1;
						part_num = -1;
						_tmp36_ = parts;
						_tmp36__length1 = parts_length1;
						{
							gchar** part_collection = NULL;
							gint part_collection_length1 = 0;
							gint _part_collection_size_ = 0;
							gint part_it = 0;
							part_collection = _tmp36_;
							part_collection_length1 = _tmp36__length1;
							for (part_it = 0; part_it < part_collection_length1; part_it = part_it + 1) {
								gchar* _tmp37_;
								gchar* part = NULL;
								_tmp37_ = g_strdup (part_collection[part_it]);
								part = _tmp37_;
								{
									const gchar* _tmp38_;
									gchar* _tmp39_;
									gchar* _tmp40_;
									gint _tmp41_;
									gint _tmp42_;
									gboolean _tmp43_;
									gint _tmp44_;
									_tmp38_ = part;
									_tmp39_ = string_strip (_tmp38_);
									_tmp40_ = _tmp39_;
									_tmp41_ = strlen (_tmp40_);
									_tmp42_ = _tmp41_;
									_tmp43_ = _tmp42_ == 0;
									_g_free0 (_tmp40_);
									if (_tmp43_) {
										_g_free0 (part);
										continue;
									}
									part_num = part_num + 1;
									_tmp44_ = part_num;
									switch (_tmp44_) {
										case 0:
										{
											CryptTabEntry* _tmp45_;
											const gchar* _tmp46_;
											gchar* _tmp47_;
											_tmp45_ = entry;
											_tmp46_ = part;
											_tmp47_ = string_strip (_tmp46_);
											_g_free0 (_tmp45_->mapped_name);
											_tmp45_->mapped_name = _tmp47_;
											break;
										}
										case 1:
										{
											CryptTabEntry* _tmp48_;
											const gchar* _tmp49_;
											gchar* _tmp50_;
											_tmp48_ = entry;
											_tmp49_ = part;
											_tmp50_ = string_strip (_tmp49_);
											_g_free0 (_tmp48_->device_string);
											_tmp48_->device_string = _tmp50_;
											break;
										}
										case 2:
										{
											CryptTabEntry* _tmp51_;
											const gchar* _tmp52_;
											gchar* _tmp53_;
											_tmp51_ = entry;
											_tmp52_ = part;
											_tmp53_ = string_strip (_tmp52_);
											_g_free0 (_tmp51_->keyfile);
											_tmp51_->keyfile = _tmp53_;
											break;
										}
										case 3:
										{
											CryptTabEntry* _tmp54_;
											const gchar* _tmp55_;
											gchar* _tmp56_;
											_tmp54_ = entry;
											_tmp55_ = part;
											_tmp56_ = string_strip (_tmp55_);
											_g_free0 (_tmp54_->options);
											_tmp54_->options = _tmp56_;
											break;
										}
										default:
										break;
									}
									_g_free0 (part);
								}
							}
						}
						parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
					}
				}
				_g_object_unref0 (entry);
				_g_free0 (line);
			}
		}
	}
	result = list;
	lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (text);
	return result;
}

gchar*
crypt_tab_entry_write_file (GeeArrayList* entries,
                            const gchar* file_path,
                            gboolean keep_comments_and_empty_lines)
{
	gchar* text = NULL;
	gchar* _tmp0_;
	const gchar* _tmp29_;
	gchar* result;
	g_return_val_if_fail (entries != NULL, NULL);
	g_return_val_if_fail (file_path != NULL, NULL);
	_tmp0_ = g_strdup ("");
	text = _tmp0_;
	{
		GeeArrayList* _entry_list = NULL;
		gint _entry_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _entry_index = 0;
		_entry_list = entries;
		_tmp1_ = _entry_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_entry_size = _tmp3_;
		_entry_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			CryptTabEntry* entry = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			gboolean _tmp8_ = FALSE;
			CryptTabEntry* _tmp9_;
			_entry_index = _entry_index + 1;
			_tmp4_ = _entry_index;
			_tmp5_ = _entry_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _entry_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _entry_index);
			entry = (CryptTabEntry*) _tmp7_;
			_tmp9_ = entry;
			if (_tmp9_->is_comment) {
				_tmp8_ = TRUE;
			} else {
				CryptTabEntry* _tmp10_;
				_tmp10_ = entry;
				_tmp8_ = _tmp10_->is_empty_line;
			}
			if (_tmp8_) {
				if (keep_comments_and_empty_lines) {
					const gchar* _tmp11_;
					CryptTabEntry* _tmp12_;
					const gchar* _tmp13_;
					gchar* _tmp14_;
					gchar* _tmp15_;
					gchar* _tmp16_;
					_tmp11_ = text;
					_tmp12_ = entry;
					_tmp13_ = _tmp12_->line;
					_tmp14_ = g_strdup_printf ("%s\n", _tmp13_);
					_tmp15_ = _tmp14_;
					_tmp16_ = g_strconcat (_tmp11_, _tmp15_, NULL);
					_g_free0 (text);
					text = _tmp16_;
					_g_free0 (_tmp15_);
				}
			} else {
				const gchar* _tmp17_;
				CryptTabEntry* _tmp18_;
				const gchar* _tmp19_;
				CryptTabEntry* _tmp20_;
				const gchar* _tmp21_;
				CryptTabEntry* _tmp22_;
				const gchar* _tmp23_;
				CryptTabEntry* _tmp24_;
				const gchar* _tmp25_;
				gchar* _tmp26_;
				gchar* _tmp27_;
				gchar* _tmp28_;
				_tmp17_ = text;
				_tmp18_ = entry;
				_tmp19_ = _tmp18_->mapped_name;
				_tmp20_ = entry;
				_tmp21_ = _tmp20_->device_string;
				_tmp22_ = entry;
				_tmp23_ = _tmp22_->keyfile;
				_tmp24_ = entry;
				_tmp25_ = _tmp24_->options;
				_tmp26_ = g_strdup_printf ("%s\t%s\t%s\t%s\n", _tmp19_, _tmp21_, _tmp23_, _tmp25_);
				_tmp27_ = _tmp26_;
				_tmp28_ = g_strconcat (_tmp17_, _tmp27_, NULL);
				_g_free0 (text);
				text = _tmp28_;
				_g_free0 (_tmp27_);
			}
			_g_object_unref0 (entry);
		}
	}
	if (tee_jee_file_system_file_exists (file_path)) {
		tee_jee_file_system_file_delete (file_path);
	}
	_tmp29_ = text;
	tee_jee_file_system_file_write (file_path, _tmp29_);
	result = text;
	return result;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

void
crypt_tab_entry_append_option (CryptTabEntry* self,
                               const gchar* option)
{
	const gchar* _tmp0_;
	const gchar* _tmp5_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (option != NULL);
	_tmp0_ = self->options;
	if (!string_contains (_tmp0_, option)) {
		const gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp1_ = self->options;
		_tmp2_ = g_strdup_printf (",%s", option);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_strconcat (_tmp1_, _tmp3_, NULL);
		_g_free0 (self->options);
		self->options = _tmp4_;
		_g_free0 (_tmp3_);
	}
	_tmp5_ = self->options;
	if (g_str_has_prefix (_tmp5_, ",")) {
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gchar* _tmp10_;
		_tmp6_ = self->options;
		_tmp7_ = self->options;
		_tmp8_ = strlen (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = string_slice (_tmp6_, (glong) 1, (glong) _tmp9_);
		_g_free0 (self->options);
		self->options = _tmp10_;
	}
	_tmp11_ = self->options;
	_tmp12_ = string_strip (_tmp11_);
	_g_free0 (self->options);
	self->options = _tmp12_;
}

void
crypt_tab_entry_remove_option (CryptTabEntry* self,
                               const gchar* option)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp10_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (option != NULL);
	_tmp0_ = self->options;
	_tmp1_ = string_replace (_tmp0_, option, "");
	_tmp2_ = _tmp1_;
	_tmp3_ = string_strip (_tmp2_);
	_g_free0 (self->options);
	self->options = _tmp3_;
	_g_free0 (_tmp2_);
	_tmp4_ = self->options;
	if (g_str_has_prefix (_tmp4_, ",")) {
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gchar* _tmp9_;
		_tmp5_ = self->options;
		_tmp6_ = self->options;
		_tmp7_ = strlen (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = string_slice (_tmp5_, (glong) 1, (glong) _tmp8_);
		_g_free0 (self->options);
		self->options = _tmp9_;
	}
	_tmp10_ = self->options;
	if (g_str_has_suffix (_tmp10_, ",")) {
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		gchar* _tmp15_;
		_tmp11_ = self->options;
		_tmp12_ = self->options;
		_tmp13_ = strlen (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = string_slice (_tmp11_, (glong) 0, (glong) (_tmp14_ - 1));
		_g_free0 (self->options);
		self->options = _tmp15_;
	}
	_tmp16_ = self->options;
	_tmp17_ = string_strip (_tmp16_);
	_g_free0 (self->options);
	self->options = _tmp17_;
}

CryptTabEntry*
crypt_tab_entry_find_entry_by_uuid (GeeArrayList* entries,
                                    const gchar* uuid)
{
	CryptTabEntry* result;
	g_return_val_if_fail (entries != NULL, NULL);
	g_return_val_if_fail (uuid != NULL, NULL);
	{
		GeeArrayList* _entry_list = NULL;
		gint _entry_size = 0;
		GeeArrayList* _tmp0_;
		gint _tmp1_;
		gint _tmp2_;
		gint _entry_index = 0;
		_entry_list = entries;
		_tmp0_ = _entry_list;
		_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
		_tmp2_ = _tmp1_;
		_entry_size = _tmp2_;
		_entry_index = -1;
		while (TRUE) {
			gint _tmp3_;
			gint _tmp4_;
			CryptTabEntry* entry = NULL;
			GeeArrayList* _tmp5_;
			gpointer _tmp6_;
			CryptTabEntry* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			gboolean _tmp11_;
			_entry_index = _entry_index + 1;
			_tmp3_ = _entry_index;
			_tmp4_ = _entry_size;
			if (!(_tmp3_ < _tmp4_)) {
				break;
			}
			_tmp5_ = _entry_list;
			_tmp6_ = gee_abstract_list_get ((GeeAbstractList*) _tmp5_, _entry_index);
			entry = (CryptTabEntry*) _tmp6_;
			_tmp7_ = entry;
			_tmp8_ = crypt_tab_entry_get_device_uuid (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp10_ = _tmp9_;
			_tmp11_ = g_strcmp0 (_tmp10_, uuid) == 0;
			_g_free0 (_tmp10_);
			if (_tmp11_) {
				result = entry;
				return result;
			}
			_g_object_unref0 (entry);
		}
	}
	result = NULL;
	return result;
}

CryptTabEntry*
crypt_tab_entry_construct (GType object_type)
{
	CryptTabEntry * self = NULL;
	self = (CryptTabEntry*) g_object_new (object_type, NULL);
	return self;
}

CryptTabEntry*
crypt_tab_entry_new (void)
{
	return crypt_tab_entry_construct (TYPE_CRYPT_TAB_ENTRY);
}

gchar*
crypt_tab_entry_get_device_uuid (CryptTabEntry* self)
{
	gchar* result;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->device_string;
	_tmp1_ = g_utf8_strdown (_tmp0_, (gssize) -1);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_str_has_prefix (_tmp2_, "uuid=");
	_g_free0 (_tmp2_);
	if (_tmp3_) {
		const gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar** _tmp9_;
		gchar** _tmp10_;
		gchar** _tmp11_;
		gint _tmp11__length1;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		_tmp4_ = self->device_string;
		_tmp5_ = string_replace (_tmp4_, "\"", "");
		_tmp6_ = _tmp5_;
		_tmp7_ = string_replace (_tmp6_, "'", "");
		_tmp8_ = _tmp7_;
		_tmp10_ = _tmp9_ = g_strsplit (_tmp8_, "=", 0);
		_tmp11_ = _tmp10_;
		_tmp11__length1 = _vala_array_length (_tmp9_);
		_tmp12_ = _tmp11_[1];
		_tmp13_ = g_strdup (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp11_ = (_vala_array_free (_tmp11_, _tmp11__length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (_tmp8_);
		_g_free0 (_tmp6_);
		result = _tmp14_;
		return result;
	} else {
		gchar* _tmp15_;
		_tmp15_ = g_strdup ("");
		result = _tmp15_;
		return result;
	}
}

void
crypt_tab_entry_set_device_uuid (CryptTabEntry* self,
                                 const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup_printf ("UUID=%s", value);
	_g_free0 (self->device_string);
	self->device_string = _tmp0_;
	g_object_notify_by_pspec ((GObject *) self, crypt_tab_entry_properties[CRYPT_TAB_ENTRY_DEVICE_UUID_PROPERTY]);
}

static void
crypt_tab_entry_class_init (CryptTabEntryClass * klass,
                            gpointer klass_data)
{
	crypt_tab_entry_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->get_property = _vala_crypt_tab_entry_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_crypt_tab_entry_set_property;
	G_OBJECT_CLASS (klass)->finalize = crypt_tab_entry_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CRYPT_TAB_ENTRY_DEVICE_UUID_PROPERTY, crypt_tab_entry_properties[CRYPT_TAB_ENTRY_DEVICE_UUID_PROPERTY] = g_param_spec_string ("device-uuid", "device-uuid", "device-uuid", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
crypt_tab_entry_instance_init (CryptTabEntry * self,
                               gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	self->is_comment = FALSE;
	self->is_empty_line = FALSE;
	_tmp0_ = g_strdup ("");
	self->mapped_name = _tmp0_;
	_tmp1_ = g_strdup ("");
	self->device_string = _tmp1_;
	_tmp2_ = g_strdup ("none");
	self->keyfile = _tmp2_;
	_tmp3_ = g_strdup ("luks,nofail");
	self->options = _tmp3_;
	_tmp4_ = g_strdup ("");
	self->line = _tmp4_;
}

static void
crypt_tab_entry_finalize (GObject * obj)
{
	CryptTabEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CRYPT_TAB_ENTRY, CryptTabEntry);
	_g_free0 (self->mapped_name);
	_g_free0 (self->device_string);
	_g_free0 (self->keyfile);
	_g_free0 (self->options);
	_g_free0 (self->line);
	G_OBJECT_CLASS (crypt_tab_entry_parent_class)->finalize (obj);
}

static GType
crypt_tab_entry_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (CryptTabEntryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) crypt_tab_entry_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CryptTabEntry), 0, (GInstanceInitFunc) crypt_tab_entry_instance_init, NULL };
	GType crypt_tab_entry_type_id;
	crypt_tab_entry_type_id = g_type_register_static (G_TYPE_OBJECT, "CryptTabEntry", &g_define_type_info, 0);
	return crypt_tab_entry_type_id;
}

GType
crypt_tab_entry_get_type (void)
{
	static volatile gsize crypt_tab_entry_type_id__once = 0;
	if (g_once_init_enter (&crypt_tab_entry_type_id__once)) {
		GType crypt_tab_entry_type_id;
		crypt_tab_entry_type_id = crypt_tab_entry_get_type_once ();
		g_once_init_leave (&crypt_tab_entry_type_id__once, crypt_tab_entry_type_id);
	}
	return crypt_tab_entry_type_id__once;
}

static void
_vala_crypt_tab_entry_get_property (GObject * object,
                                    guint property_id,
                                    GValue * value,
                                    GParamSpec * pspec)
{
	CryptTabEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CRYPT_TAB_ENTRY, CryptTabEntry);
	switch (property_id) {
		case CRYPT_TAB_ENTRY_DEVICE_UUID_PROPERTY:
		g_value_take_string (value, crypt_tab_entry_get_device_uuid (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_crypt_tab_entry_set_property (GObject * object,
                                    guint property_id,
                                    const GValue * value,
                                    GParamSpec * pspec)
{
	CryptTabEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CRYPT_TAB_ENTRY, CryptTabEntry);
	switch (property_id) {
		case CRYPT_TAB_ENTRY_DEVICE_UUID_PROPERTY:
		crypt_tab_entry_set_device_uuid (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

