/* AsyncTask.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from AsyncTask.vala, do not modify */

/*
 * AsyncTask.vala
 *
 * Copyright 2012-2018 Tony George <teejeetech@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 *
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>
#include <gio/gunixoutputstream.h>
#include <gio/gunixinputstream.h>
#include <signal.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_ASYNC_TASK (async_task_get_type ())
#define ASYNC_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ASYNC_TASK, AsyncTask))
#define ASYNC_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ASYNC_TASK, AsyncTaskClass))
#define IS_ASYNC_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ASYNC_TASK))
#define IS_ASYNC_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ASYNC_TASK))
#define ASYNC_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ASYNC_TASK, AsyncTaskClass))

typedef struct _AsyncTask AsyncTask;
typedef struct _AsyncTaskClass AsyncTaskClass;
typedef struct _AsyncTaskPrivate AsyncTaskPrivate;
typedef enum  {
	APP_STATUS_NOT_STARTED,
	APP_STATUS_RUNNING,
	APP_STATUS_PAUSED,
	APP_STATUS_FINISHED,
	APP_STATUS_CANCELLED,
	APP_STATUS_PASSWORD_REQUIRED
} AppStatus;

#define TYPE_APP_STATUS (app_status_get_type ())
enum  {
	ASYNC_TASK_0_PROPERTY,
	ASYNC_TASK_STATUS_LINE_PROPERTY,
	ASYNC_TASK_STAT_TIME_ELAPSED_PROPERTY,
	ASYNC_TASK_STAT_TIME_REMAINING_PROPERTY,
	ASYNC_TASK_NUM_PROPERTIES
};
static GParamSpec* async_task_properties[ASYNC_TASK_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))
#define _g_thread_unref0(var) ((var == NULL) ? NULL : (var = (g_thread_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
enum  {
	ASYNC_TASK_STDOUT_LINE_READ_SIGNAL,
	ASYNC_TASK_STDERR_LINE_READ_SIGNAL,
	ASYNC_TASK_TASK_COMPLETE_SIGNAL,
	ASYNC_TASK_NUM_SIGNALS
};
static guint async_task_signals[ASYNC_TASK_NUM_SIGNALS] = {0};

struct _AsyncTask {
	GObject parent_instance;
	AsyncTaskPrivate * priv;
	GDataOutputStream* dos_log;
	GPid child_pid;
	gchar* script_file;
	gchar* working_dir;
	AppStatus status;
	GMutex status_line_mutex;
	gint exit_code;
	GTimer* timer;
	gdouble progress;
	gdouble percent;
	gint64 prg_count;
	gint64 prg_count_total;
};

struct _AsyncTaskClass {
	GObjectClass parent_class;
	void (*prepare) (AsyncTask* self);
	gchar* (*build_script) (AsyncTask* self);
	gboolean (*begin) (AsyncTask* self);
	void (*execute) (AsyncTask* self);
	void (*parse_stdout_line) (AsyncTask* self, const gchar* out_line);
	void (*parse_stderr_line) (AsyncTask* self, const gchar* err_line);
	void (*finish_task) (AsyncTask* self);
};

struct _AsyncTaskPrivate {
	gchar* err_line;
	gchar* out_line;
	GDataOutputStream* dos_in;
	GDataInputStream* dis_out;
	GDataInputStream* dis_err;
	gboolean stdout_is_open;
	gboolean stderr_is_open;
	gint input_fd;
	gint output_fd;
	gint error_fd;
	gboolean finish_called;
	gchar* _status_line;
	gdouble timerOffset;
};

static gint AsyncTask_private_offset;
static gpointer async_task_parent_class = NULL;
VALA_EXTERN gchar* tee_jee_process_helper_TEMP_DIR;

VALA_EXTERN GType async_task_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AsyncTask, g_object_unref)
VALA_EXTERN GType app_status_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void async_task_prepare (AsyncTask* self);
VALA_EXTERN gchar* async_task_build_script (AsyncTask* self);
VALA_EXTERN gboolean async_task_begin (AsyncTask* self);
VALA_EXTERN void async_task_execute (AsyncTask* self);
VALA_EXTERN void async_task_parse_stdout_line (AsyncTask* self,
                                   const gchar* out_line);
VALA_EXTERN void async_task_parse_stderr_line (AsyncTask* self,
                                   const gchar* err_line);
VALA_EXTERN void async_task_finish_task (AsyncTask* self);
static gchar* _async_task_get_status_line (AsyncTask* self);
VALA_EXTERN AsyncTask* async_task_construct (GType object_type);
VALA_EXTERN gchar* tee_jee_misc_timestamp_for_path (void);
VALA_EXTERN gchar* tee_jee_file_system_path_combine (const gchar* path1,
                                         const gchar* path2);
VALA_EXTERN gboolean tee_jee_file_system_dir_create (const gchar* dir_path,
                                         gboolean show_message);
static void async_task_real_prepare (AsyncTask* self);
VALA_EXTERN void tee_jee_logging_log_debug (const gchar* message);
VALA_EXTERN gchar* tee_jee_process_helper_save_bash_script_temp (const gchar* commands,
                                                     const gchar* script_path,
                                                     gboolean force_locale,
                                                     gboolean supress_errors);
static gchar* async_task_real_build_script (AsyncTask* self);
static gboolean async_task_real_begin (AsyncTask* self);
static void async_task_read_stdout (AsyncTask* self);
static gpointer _async_task_read_stdout_gthread_func (gpointer self);
VALA_EXTERN void tee_jee_logging_log_error (const gchar* message,
                                gboolean highlight,
                                gboolean is_warning);
static void async_task_read_stderr (AsyncTask* self);
static gpointer _async_task_read_stderr_gthread_func (gpointer self);
static void async_task_finish (AsyncTask* self);
VALA_EXTERN void async_task_write_stdin (AsyncTask* self,
                             const gchar* line);
static void async_task_real_execute (AsyncTask* self);
static void async_task_real_parse_stdout_line (AsyncTask* self,
                                        const gchar* out_line);
static void async_task_real_parse_stderr_line (AsyncTask* self,
                                        const gchar* err_line);
VALA_EXTERN gint async_task_read_exit_code (AsyncTask* self);
VALA_EXTERN void async_task_set_status_line (AsyncTask* self,
                                 const gchar* value);
static void async_task_real_finish_task (AsyncTask* self);
VALA_EXTERN gchar* tee_jee_file_system_file_parent (const gchar* file_path);
VALA_EXTERN gboolean tee_jee_file_system_file_exists (const gchar* file_path);
VALA_EXTERN gchar* tee_jee_file_system_file_read (const gchar* file_path);
VALA_EXTERN gboolean async_task_is_running (AsyncTask* self);
VALA_EXTERN void async_task_stop (AsyncTask* self,
                      AppStatus status_to_update);
VALA_EXTERN void tee_jee_process_helper_process_quit (GPid process_pid,
                                          gboolean killChildren);
VALA_EXTERN void async_task_pause (AsyncTask* self,
                       AppStatus status_to_update);
VALA_EXTERN void tee_jee_process_helper_process_send_signal (GPid process_pid,
                                                 int sig,
                                                 gboolean children);
VALA_EXTERN gulong tee_jee_system_timer_elapsed (GTimer* timer,
                                     gboolean stop);
VALA_EXTERN void async_task_resume (AsyncTask* self,
                        AppStatus status_to_update);
VALA_EXTERN void async_task_print_app_status (AsyncTask* self);
VALA_EXTERN gchar* async_task_get_status_line (AsyncTask* self);
static gdouble async_task_get_elapsed (AsyncTask* self);
VALA_EXTERN gchar* async_task_get_stat_time_elapsed (AsyncTask* self);
VALA_EXTERN gchar* tee_jee_misc_format_duration (gdouble millis);
VALA_EXTERN gchar* async_task_get_stat_time_remaining (AsyncTask* self);
static void async_task_finalize (GObject * obj);
static GType async_task_get_type_once (void);
static void _vala_async_task_get_property (GObject * object,
                                    guint property_id,
                                    GValue * value,
                                    GParamSpec * pspec);
static void _vala_async_task_set_property (GObject * object,
                                    guint property_id,
                                    const GValue * value,
                                    GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static void _vala_clear_GMutex (GMutex * mutex);
static void _vala_clear_GRecMutex (GRecMutex * mutex);
static void _vala_clear_GRWLock (GRWLock * mutex);
static void _vala_clear_GCond (GCond * mutex);

static inline gpointer
async_task_get_instance_private (AsyncTask* self)
{
	return G_STRUCT_MEMBER_P (self, AsyncTask_private_offset);
}

static gchar*
_async_task_get_status_line (AsyncTask* self)
{
	gchar* ret = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup ("");
	ret = _tmp0_;
	if (g_mutex_trylock (&self->status_line_mutex)) {
		const gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = self->priv->_status_line;
		_tmp2_ = g_strdup (_tmp1_);
		_g_free0 (ret);
		ret = _tmp2_;
		g_mutex_unlock (&self->status_line_mutex);
	}
	result = ret;
	return result;
}

AsyncTask*
async_task_construct (GType object_type)
{
	AsyncTask * self = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	self = (AsyncTask*) g_object_new (object_type, NULL);
	_tmp0_ = tee_jee_process_helper_TEMP_DIR;
	_tmp1_ = g_strconcat (_tmp0_, "/", NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = tee_jee_misc_timestamp_for_path ();
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat (_tmp2_, _tmp4_, NULL);
	_g_free0 (self->working_dir);
	self->working_dir = _tmp5_;
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	_tmp6_ = self->working_dir;
	_tmp7_ = tee_jee_file_system_path_combine (_tmp6_, "script.sh");
	_g_free0 (self->script_file);
	self->script_file = _tmp7_;
	_vala_clear_GMutex (&self->status_line_mutex);
	g_mutex_init (&self->status_line_mutex);
	_tmp8_ = self->working_dir;
	tee_jee_file_system_dir_create (_tmp8_, FALSE);
	return self;
}

static void
async_task_real_prepare (AsyncTask* self)
{
	gchar* script_text = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	_tmp0_ = async_task_build_script (self);
	script_text = _tmp0_;
	tee_jee_logging_log_debug (script_text);
	_tmp1_ = self->script_file;
	_tmp2_ = tee_jee_process_helper_save_bash_script_temp (script_text, _tmp1_, TRUE, FALSE);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp3_);
	_tmp4_ = self->script_file;
	_tmp5_ = g_strdup_printf ("AsyncTask:prepare(): saved: %s", _tmp4_);
	_tmp6_ = _tmp5_;
	tee_jee_logging_log_debug (_tmp6_);
	_g_free0 (_tmp6_);
	_g_free0 (script_text);
}

void
async_task_prepare (AsyncTask* self)
{
	AsyncTaskClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = ASYNC_TASK_GET_CLASS (self);
	if (_klass_->prepare) {
		_klass_->prepare (self);
	}
}

static gchar*
async_task_real_build_script (AsyncTask* self)
{
	g_critical ("Type `%s' does not implement abstract method `async_task_build_script'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

gchar*
async_task_build_script (AsyncTask* self)
{
	AsyncTaskClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = ASYNC_TASK_GET_CLASS (self);
	if (_klass_->build_script) {
		return _klass_->build_script (self);
	}
	return NULL;
}

static gpointer
_async_task_read_stdout_gthread_func (gpointer self)
{
	gpointer result;
	async_task_read_stdout ((AsyncTask*) self);
	result = NULL;
	g_object_unref (self);
	return result;
}

static gpointer
_async_task_read_stderr_gthread_func (gpointer self)
{
	gpointer result;
	async_task_read_stderr ((AsyncTask*) self);
	result = NULL;
	g_object_unref (self);
	return result;
}

static gboolean
async_task_real_begin (AsyncTask* self)
{
	gboolean has_started = FALSE;
	gchar** spawn_args = NULL;
	gchar** _tmp0_;
	gint spawn_args_length1;
	gint _spawn_args_size_;
	gchar** _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar** spawn_env = NULL;
	gchar** _tmp4_;
	gchar** _tmp5_;
	gint spawn_env_length1;
	gint _spawn_env_size_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self->status = APP_STATUS_RUNNING;
	has_started = TRUE;
	self->priv->finish_called = FALSE;
	self->prg_count = (gint64) 0;
	_tmp0_ = g_new0 (gchar*, 1 + 1);
	spawn_args = _tmp0_;
	spawn_args_length1 = 1;
	_spawn_args_size_ = spawn_args_length1;
	_tmp1_ = spawn_args;
	_tmp1__length1 = spawn_args_length1;
	_tmp2_ = self->script_file;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (_tmp1_[0]);
	_tmp1_[0] = _tmp3_;
	_tmp5_ = _tmp4_ = g_get_environ ();
	spawn_env = _tmp5_;
	spawn_env_length1 = _vala_array_length (_tmp4_);
	_spawn_env_size_ = spawn_env_length1;
	{
		GTimer* _tmp6_;
		GTimer* _tmp7_;
		const gchar* _tmp8_;
		gchar** _tmp9_;
		gint _tmp9__length1;
		gchar** _tmp10_;
		gint _tmp10__length1;
		GPid _tmp11_ = 0;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
		gchar* _tmp15_;
		gchar* _tmp16_;
		GUnixOutputStream* uos_in = NULL;
		GUnixOutputStream* _tmp17_;
		GUnixInputStream* uis_out = NULL;
		GUnixInputStream* _tmp18_;
		GUnixInputStream* uis_err = NULL;
		GUnixInputStream* _tmp19_;
		GDataOutputStream* _tmp20_;
		GDataInputStream* _tmp21_;
		GDataInputStream* _tmp22_;
		GDataInputStream* _tmp23_;
		GDataInputStream* _tmp24_;
		_tmp6_ = g_timer_new ();
		_g_timer_destroy0 (self->timer);
		self->timer = _tmp6_;
		_tmp7_ = self->timer;
		g_timer_start (_tmp7_);
		_tmp8_ = self->working_dir;
		_tmp9_ = spawn_args;
		_tmp9__length1 = spawn_args_length1;
		_tmp10_ = spawn_env;
		_tmp10__length1 = spawn_env_length1;
		g_spawn_async_with_pipes (_tmp8_, _tmp9_, _tmp10_, G_SPAWN_SEARCH_PATH, NULL, NULL, &_tmp11_, &_tmp12_, &_tmp13_, &_tmp14_, &_inner_error0_);
		self->child_pid = _tmp11_;
		self->priv->input_fd = _tmp12_;
		self->priv->output_fd = _tmp13_;
		self->priv->error_fd = _tmp14_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp15_ = g_strdup_printf ("AsyncTask: child_pid: %d", (gint) self->child_pid);
		_tmp16_ = _tmp15_;
		tee_jee_logging_log_debug (_tmp16_);
		_g_free0 (_tmp16_);
		_tmp17_ = (GUnixOutputStream*) g_unix_output_stream_new (self->priv->input_fd, TRUE);
		uos_in = _tmp17_;
		_tmp18_ = (GUnixInputStream*) g_unix_input_stream_new (self->priv->output_fd, TRUE);
		uis_out = _tmp18_;
		_tmp19_ = (GUnixInputStream*) g_unix_input_stream_new (self->priv->error_fd, TRUE);
		uis_err = _tmp19_;
		_tmp20_ = g_data_output_stream_new ((GOutputStream*) uos_in);
		_g_object_unref0 (self->priv->dos_in);
		self->priv->dos_in = _tmp20_;
		_tmp21_ = g_data_input_stream_new ((GInputStream*) uis_out);
		_g_object_unref0 (self->priv->dis_out);
		self->priv->dis_out = _tmp21_;
		_tmp22_ = g_data_input_stream_new ((GInputStream*) uis_err);
		_g_object_unref0 (self->priv->dis_err);
		self->priv->dis_err = _tmp22_;
		_tmp23_ = self->priv->dis_out;
		g_data_input_stream_set_newline_type (_tmp23_, G_DATA_STREAM_NEWLINE_TYPE_ANY);
		_tmp24_ = self->priv->dis_err;
		g_data_input_stream_set_newline_type (_tmp24_, G_DATA_STREAM_NEWLINE_TYPE_ANY);
		{
			GThread* _tmp25_;
			GThread* _tmp26_;
			_tmp25_ = g_thread_try_new ("async-task-stdout-reader", _async_task_read_stdout_gthread_func, g_object_ref (self), &_inner_error0_);
			_tmp26_ = _tmp25_;
			_g_thread_unref0 (_tmp26_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError* e = NULL;
			GError* _tmp27_;
			const gchar* _tmp28_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			tee_jee_logging_log_error ("AsyncTask.begin():create_thread:read_stdout()", FALSE, FALSE);
			_tmp27_ = e;
			_tmp28_ = _tmp27_->message;
			tee_jee_logging_log_error (_tmp28_, FALSE, FALSE);
			_g_error_free0 (e);
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (uis_err);
			_g_object_unref0 (uis_out);
			_g_object_unref0 (uos_in);
			goto __catch0_g_error;
		}
		{
			GThread* _tmp29_;
			GThread* _tmp30_;
			_tmp29_ = g_thread_try_new ("async-task-stderr-reader", _async_task_read_stderr_gthread_func, g_object_ref (self), &_inner_error0_);
			_tmp30_ = _tmp29_;
			_g_thread_unref0 (_tmp30_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch2_g_error;
			}
		}
		goto __finally2;
		__catch2_g_error:
		{
			GError* e = NULL;
			GError* _tmp31_;
			const gchar* _tmp32_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			tee_jee_logging_log_error ("AsyncTask.begin():create_thread:read_stderr()", FALSE, FALSE);
			_tmp31_ = e;
			_tmp32_ = _tmp31_->message;
			tee_jee_logging_log_error (_tmp32_, FALSE, FALSE);
			_g_error_free0 (e);
		}
		__finally2:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (uis_err);
			_g_object_unref0 (uis_out);
			_g_object_unref0 (uos_in);
			goto __catch0_g_error;
		}
		_g_object_unref0 (uis_err);
		_g_object_unref0 (uis_out);
		_g_object_unref0 (uos_in);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp33_;
		const gchar* _tmp34_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		tee_jee_logging_log_error ("AsyncTask.begin()", FALSE, FALSE);
		_tmp33_ = e;
		_tmp34_ = _tmp33_->message;
		tee_jee_logging_log_error (_tmp34_, FALSE, FALSE);
		has_started = FALSE;
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp35_ = FALSE;
		spawn_env = (_vala_array_free (spawn_env, spawn_env_length1, (GDestroyNotify) g_free), NULL);
		spawn_args = (_vala_array_free (spawn_args, spawn_args_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp35_;
	}
	result = has_started;
	spawn_env = (_vala_array_free (spawn_env, spawn_env_length1, (GDestroyNotify) g_free), NULL);
	spawn_args = (_vala_array_free (spawn_args, spawn_args_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

gboolean
async_task_begin (AsyncTask* self)
{
	AsyncTaskClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = ASYNC_TASK_GET_CLASS (self);
	if (_klass_->begin) {
		return _klass_->begin (self);
	}
	return FALSE;
}

static void
async_task_read_stdout (AsyncTask* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		gchar* _tmp0_ = NULL;
		GDataInputStream* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gboolean _tmp16_ = FALSE;
		self->priv->stdout_is_open = TRUE;
		_tmp1_ = self->priv->dis_out;
		_tmp2_ = g_data_input_stream_read_line (_tmp1_, NULL, NULL, &_inner_error0_);
		_tmp0_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		_g_free0 (self->priv->out_line);
		self->priv->out_line = _tmp3_;
		while (TRUE) {
			const gchar* _tmp4_;
			const gchar* _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			gchar* _tmp10_ = NULL;
			GDataInputStream* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			_tmp4_ = self->priv->out_line;
			if (!(_tmp4_ != NULL)) {
				break;
			}
			_tmp5_ = self->priv->out_line;
			_tmp6_ = strlen (_tmp5_);
			_tmp7_ = _tmp6_;
			if (_tmp7_ > 0) {
				const gchar* _tmp8_;
				const gchar* _tmp9_;
				_tmp8_ = self->priv->out_line;
				async_task_parse_stdout_line (self, _tmp8_);
				_tmp9_ = self->priv->out_line;
				g_signal_emit (self, async_task_signals[ASYNC_TASK_STDOUT_LINE_READ_SIGNAL], 0, _tmp9_);
			}
			_tmp11_ = self->priv->dis_out;
			_tmp12_ = g_data_input_stream_read_line (_tmp11_, NULL, NULL, &_inner_error0_);
			_tmp10_ = _tmp12_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (_tmp0_);
				goto __catch0_g_error;
			}
			_tmp13_ = _tmp10_;
			_tmp10_ = NULL;
			_g_free0 (self->priv->out_line);
			self->priv->out_line = _tmp13_;
			_g_free0 (_tmp10_);
		}
		self->priv->stdout_is_open = FALSE;
		{
			GDataInputStream* _tmp14_;
			_tmp14_ = self->priv->dis_out;
			if (_tmp14_ != NULL) {
				GDataInputStream* _tmp15_;
				_tmp15_ = self->priv->dis_out;
				g_input_stream_close ((GInputStream*) _tmp15_, NULL, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch1_g_error;
				}
			}
		}
		goto __finally1;
		__catch1_g_error:
		{
			g_clear_error (&_inner_error0_);
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp0_);
			goto __catch0_g_error;
		}
		_g_object_unref0 (self->priv->dis_out);
		self->priv->dis_out = NULL;
		if (!self->priv->stdout_is_open) {
			_tmp16_ = !self->priv->stderr_is_open;
		} else {
			_tmp16_ = FALSE;
		}
		if (_tmp16_) {
			async_task_finish (self);
		}
		_g_free0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp17_;
		const gchar* _tmp18_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		tee_jee_logging_log_error ("AsyncTask.read_stdout()", FALSE, FALSE);
		_tmp17_ = e;
		_tmp18_ = _tmp17_->message;
		tee_jee_logging_log_error (_tmp18_, FALSE, FALSE);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
async_task_read_stderr (AsyncTask* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		gchar* _tmp0_ = NULL;
		GDataInputStream* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gboolean _tmp16_ = FALSE;
		self->priv->stderr_is_open = TRUE;
		_tmp1_ = self->priv->dis_err;
		_tmp2_ = g_data_input_stream_read_line (_tmp1_, NULL, NULL, &_inner_error0_);
		_tmp0_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		_g_free0 (self->priv->err_line);
		self->priv->err_line = _tmp3_;
		while (TRUE) {
			const gchar* _tmp4_;
			const gchar* _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			gchar* _tmp10_ = NULL;
			GDataInputStream* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			_tmp4_ = self->priv->err_line;
			if (!(_tmp4_ != NULL)) {
				break;
			}
			_tmp5_ = self->priv->err_line;
			_tmp6_ = strlen (_tmp5_);
			_tmp7_ = _tmp6_;
			if (_tmp7_ > 0) {
				const gchar* _tmp8_;
				const gchar* _tmp9_;
				_tmp8_ = self->priv->err_line;
				async_task_parse_stderr_line (self, _tmp8_);
				_tmp9_ = self->priv->err_line;
				g_signal_emit (self, async_task_signals[ASYNC_TASK_STDERR_LINE_READ_SIGNAL], 0, _tmp9_);
			}
			_tmp11_ = self->priv->dis_err;
			_tmp12_ = g_data_input_stream_read_line (_tmp11_, NULL, NULL, &_inner_error0_);
			_tmp10_ = _tmp12_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (_tmp0_);
				goto __catch0_g_error;
			}
			_tmp13_ = _tmp10_;
			_tmp10_ = NULL;
			_g_free0 (self->priv->err_line);
			self->priv->err_line = _tmp13_;
			_g_free0 (_tmp10_);
		}
		self->priv->stderr_is_open = FALSE;
		{
			GDataInputStream* _tmp14_;
			_tmp14_ = self->priv->dis_err;
			if (_tmp14_ != NULL) {
				GDataInputStream* _tmp15_;
				_tmp15_ = self->priv->dis_err;
				g_input_stream_close ((GInputStream*) _tmp15_, NULL, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch1_g_error;
				}
			}
		}
		goto __finally1;
		__catch1_g_error:
		{
			g_clear_error (&_inner_error0_);
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp0_);
			goto __catch0_g_error;
		}
		_g_object_unref0 (self->priv->dis_err);
		self->priv->dis_err = NULL;
		if (!self->priv->stdout_is_open) {
			_tmp16_ = !self->priv->stderr_is_open;
		} else {
			_tmp16_ = FALSE;
		}
		if (_tmp16_) {
			async_task_finish (self);
		}
		_g_free0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp17_;
		const gchar* _tmp18_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		tee_jee_logging_log_error ("AsyncTask.read_stderr()", FALSE, FALSE);
		_tmp17_ = e;
		_tmp18_ = _tmp17_->message;
		tee_jee_logging_log_error (_tmp18_, FALSE, FALSE);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
async_task_write_stdin (AsyncTask* self,
                        const gchar* line)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (line != NULL);
	{
		if (self->status == APP_STATUS_RUNNING) {
			GDataOutputStream* _tmp0_;
			gchar* _tmp1_;
			gchar* _tmp2_;
			_tmp0_ = self->priv->dos_in;
			_tmp1_ = g_strconcat (line, "\n", NULL);
			_tmp2_ = _tmp1_;
			g_data_output_stream_put_string (_tmp0_, _tmp2_, NULL, &_inner_error0_);
			_g_free0 (_tmp2_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		} else {
			tee_jee_logging_log_error ("AsyncTask.write_stdin(): NOT RUNNING", FALSE, FALSE);
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = g_strdup_printf ("AsyncTask.write_stdin(): %s", line);
		_tmp4_ = _tmp3_;
		tee_jee_logging_log_error (_tmp4_, FALSE, FALSE);
		_g_free0 (_tmp4_);
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		tee_jee_logging_log_error (_tmp6_, FALSE, FALSE);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
async_task_real_execute (AsyncTask* self)
{
	tee_jee_logging_log_debug ("AsyncTask:execute()");
	async_task_prepare (self);
	async_task_begin (self);
}

void
async_task_execute (AsyncTask* self)
{
	AsyncTaskClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = ASYNC_TASK_GET_CLASS (self);
	if (_klass_->execute) {
		_klass_->execute (self);
	}
}

static void
async_task_real_parse_stdout_line (AsyncTask* self,
                                   const gchar* out_line)
{
	g_critical ("Type `%s' does not implement abstract method `async_task_parse_stdout_line'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
async_task_parse_stdout_line (AsyncTask* self,
                              const gchar* out_line)
{
	AsyncTaskClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = ASYNC_TASK_GET_CLASS (self);
	if (_klass_->parse_stdout_line) {
		_klass_->parse_stdout_line (self, out_line);
	}
}

static void
async_task_real_parse_stderr_line (AsyncTask* self,
                                   const gchar* err_line)
{
	g_critical ("Type `%s' does not implement abstract method `async_task_parse_stderr_line'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
async_task_parse_stderr_line (AsyncTask* self,
                              const gchar* err_line)
{
	AsyncTaskClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = ASYNC_TASK_GET_CLASS (self);
	if (_klass_->parse_stderr_line) {
		_klass_->parse_stderr_line (self, err_line);
	}
}

static void
async_task_finish (AsyncTask* self)
{
	gchar* _tmp2_;
	gchar* _tmp3_;
	GTimer* _tmp4_;
	gboolean _tmp5_ = FALSE;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	if (self->priv->finish_called) {
		return;
	}
	self->priv->finish_called = TRUE;
	tee_jee_logging_log_debug ("AsyncTask: finish(): enter");
	{
		GDataOutputStream* _tmp0_;
		_tmp0_ = self->priv->dos_in;
		if (_tmp0_ != NULL) {
			GDataOutputStream* _tmp1_;
			_tmp1_ = self->priv->dos_in;
			g_output_stream_close ((GOutputStream*) _tmp1_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_IO_ERROR) {
					goto __catch0_g_io_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
	}
	goto __finally0;
	__catch0_g_io_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (self->priv->dos_in);
	self->priv->dos_in = NULL;
	g_spawn_close_pid (self->child_pid);
	async_task_read_exit_code (self);
	async_task_set_status_line (self, "");
	_tmp2_ = g_strdup ("");
	_g_free0 (self->priv->err_line);
	self->priv->err_line = _tmp2_;
	_tmp3_ = g_strdup ("");
	_g_free0 (self->priv->out_line);
	self->priv->out_line = _tmp3_;
	_tmp4_ = self->timer;
	g_timer_stop (_tmp4_);
	async_task_finish_task (self);
	if (self->status != APP_STATUS_CANCELLED) {
		_tmp5_ = self->status != APP_STATUS_PASSWORD_REQUIRED;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		self->status = APP_STATUS_FINISHED;
	}
	g_signal_emit (self, async_task_signals[ASYNC_TASK_TASK_COMPLETE_SIGNAL], 0);
}

static void
async_task_real_finish_task (AsyncTask* self)
{
}

void
async_task_finish_task (AsyncTask* self)
{
	AsyncTaskClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = ASYNC_TASK_GET_CLASS (self);
	if (_klass_->finish_task) {
		_klass_->finish_task (self);
	}
}

gint
async_task_read_exit_code (AsyncTask* self)
{
	gchar* path = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	self->exit_code = -1;
	_tmp0_ = self->script_file;
	_tmp1_ = tee_jee_file_system_file_parent (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat (_tmp2_, "/status", NULL);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	path = _tmp4_;
	_tmp5_ = path;
	if (tee_jee_file_system_file_exists (_tmp5_)) {
		gchar* txt = NULL;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		const gchar* _tmp8_;
		_tmp6_ = path;
		_tmp7_ = tee_jee_file_system_file_read (_tmp6_);
		txt = _tmp7_;
		_tmp8_ = txt;
		self->exit_code = atoi (_tmp8_);
		_g_free0 (txt);
	}
	_tmp9_ = g_strdup_printf ("exit_code: %d", self->exit_code);
	_tmp10_ = _tmp9_;
	tee_jee_logging_log_debug (_tmp10_);
	_g_free0 (_tmp10_);
	result = self->exit_code;
	_g_free0 (path);
	return result;
}

gboolean
async_task_is_running (AsyncTask* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->status == APP_STATUS_RUNNING;
	return result;
}

void
async_task_stop (AsyncTask* self,
                 AppStatus status_to_update)
{
	g_return_if_fail (self != NULL);
	self->status = status_to_update;
	if (0 != ((gint) self->child_pid)) {
		gchar* _tmp0_;
		gchar* _tmp1_;
		tee_jee_process_helper_process_quit (self->child_pid, TRUE);
		self->child_pid = (GPid) 0;
		_tmp0_ = g_strdup_printf ("process_quit: %d  ", (gint) self->child_pid);
		_tmp1_ = _tmp0_;
		tee_jee_logging_log_debug (_tmp1_);
		_g_free0 (_tmp1_);
	}
}

void
async_task_pause (AsyncTask* self,
                  AppStatus status_to_update)
{
	g_return_if_fail (self != NULL);
	self->status = status_to_update;
	if (0 != ((gint) self->child_pid)) {
		GTimer* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		tee_jee_process_helper_process_send_signal (self->child_pid, SIGSTOP, TRUE);
		_tmp0_ = self->timer;
		self->priv->timerOffset = self->priv->timerOffset + tee_jee_system_timer_elapsed (_tmp0_, TRUE);
		_tmp1_ = g_strdup_printf ("process_paused: %d  ", (gint) self->child_pid);
		_tmp2_ = _tmp1_;
		tee_jee_logging_log_debug (_tmp2_);
		_g_free0 (_tmp2_);
	}
}

void
async_task_resume (AsyncTask* self,
                   AppStatus status_to_update)
{
	g_return_if_fail (self != NULL);
	self->status = status_to_update;
	if (0 != ((gint) self->child_pid)) {
		GTimer* _tmp0_;
		GTimer* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		tee_jee_process_helper_process_send_signal (self->child_pid, SIGCONT, TRUE);
		_tmp0_ = g_timer_new ();
		_g_timer_destroy0 (self->timer);
		self->timer = _tmp0_;
		_tmp1_ = self->timer;
		g_timer_start (_tmp1_);
		_tmp2_ = g_strdup_printf ("process_resumed: %d  ", (gint) self->child_pid);
		_tmp3_ = _tmp2_;
		tee_jee_logging_log_debug (_tmp3_);
		_g_free0 (_tmp3_);
	}
}

void
async_task_print_app_status (AsyncTask* self)
{
	g_return_if_fail (self != NULL);
	switch (self->status) {
		case APP_STATUS_NOT_STARTED:
		{
			gchar* _tmp0_;
			gchar* _tmp1_;
			_tmp0_ = g_strdup_printf ("status=%s", "NOT_STARTED");
			_tmp1_ = _tmp0_;
			tee_jee_logging_log_debug (_tmp1_);
			_g_free0 (_tmp1_);
			break;
		}
		case APP_STATUS_RUNNING:
		{
			gchar* _tmp2_;
			gchar* _tmp3_;
			_tmp2_ = g_strdup_printf ("status=%s", "RUNNING");
			_tmp3_ = _tmp2_;
			tee_jee_logging_log_debug (_tmp3_);
			_g_free0 (_tmp3_);
			break;
		}
		case APP_STATUS_PAUSED:
		{
			gchar* _tmp4_;
			gchar* _tmp5_;
			_tmp4_ = g_strdup_printf ("status=%s", "PAUSED");
			_tmp5_ = _tmp4_;
			tee_jee_logging_log_debug (_tmp5_);
			_g_free0 (_tmp5_);
			break;
		}
		case APP_STATUS_FINISHED:
		{
			gchar* _tmp6_;
			gchar* _tmp7_;
			_tmp6_ = g_strdup_printf ("status=%s", "FINISHED");
			_tmp7_ = _tmp6_;
			tee_jee_logging_log_debug (_tmp7_);
			_g_free0 (_tmp7_);
			break;
		}
		case APP_STATUS_CANCELLED:
		{
			gchar* _tmp8_;
			gchar* _tmp9_;
			_tmp8_ = g_strdup_printf ("status=%s", "CANCELLED");
			_tmp9_ = _tmp8_;
			tee_jee_logging_log_debug (_tmp9_);
			_g_free0 (_tmp9_);
			break;
		}
		case APP_STATUS_PASSWORD_REQUIRED:
		{
			gchar* _tmp10_;
			gchar* _tmp11_;
			_tmp10_ = g_strdup_printf ("status=%s", "PASSWORD_REQUIRED");
			_tmp11_ = _tmp10_;
			tee_jee_logging_log_debug (_tmp11_);
			_g_free0 (_tmp11_);
			break;
		}
		default:
		break;
	}
}

gchar*
async_task_get_status_line (AsyncTask* self)
{
	gchar* result;
	gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = _async_task_get_status_line (self);
	result = _tmp0_;
	return result;
}

void
async_task_set_status_line (AsyncTask* self,
                            const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_mutex_lock (&self->status_line_mutex);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_status_line);
	self->priv->_status_line = _tmp0_;
	g_mutex_unlock (&self->status_line_mutex);
}

static gdouble
async_task_get_elapsed (AsyncTask* self)
{
	gdouble result;
	gdouble elapsed = 0.0;
	g_return_val_if_fail (self != NULL, 0.0);
	elapsed = self->priv->timerOffset;
	if (self->status != APP_STATUS_PAUSED) {
		GTimer* _tmp0_;
		_tmp0_ = self->timer;
		elapsed += (gdouble) tee_jee_system_timer_elapsed (_tmp0_, TRUE);
	}
	result = elapsed;
	return result;
}

gchar*
async_task_get_stat_time_elapsed (AsyncTask* self)
{
	gchar* result;
	gdouble _tmp0_;
	gdouble _tmp1_;
	gchar* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = async_task_get_elapsed (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = tee_jee_misc_format_duration (_tmp1_);
	result = _tmp2_;
	return result;
}

gchar*
async_task_get_stat_time_remaining (AsyncTask* self)
{
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->progress > ((gdouble) 0)) {
		gdouble remaining = 0.0;
		gdouble _tmp0_;
		gdouble _tmp1_;
		gchar* _tmp2_;
		_tmp0_ = async_task_get_elapsed (self);
		_tmp1_ = _tmp0_;
		remaining = (_tmp1_ / self->progress) * (1.0 - self->progress);
		if (remaining < ((gdouble) 0)) {
			remaining = (gdouble) 0;
		}
		_tmp2_ = tee_jee_misc_format_duration (remaining);
		result = _tmp2_;
		return result;
	} else {
		gchar* _tmp3_;
		_tmp3_ = g_strdup ("???");
		result = _tmp3_;
		return result;
	}
}

static void
async_task_class_init (AsyncTaskClass * klass,
                       gpointer klass_data)
{
	async_task_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &AsyncTask_private_offset);
	((AsyncTaskClass *) klass)->prepare = (void (*) (AsyncTask*)) async_task_real_prepare;
	((AsyncTaskClass *) klass)->build_script = (gchar* (*) (AsyncTask*)) async_task_real_build_script;
	((AsyncTaskClass *) klass)->begin = (gboolean (*) (AsyncTask*)) async_task_real_begin;
	((AsyncTaskClass *) klass)->execute = (void (*) (AsyncTask*)) async_task_real_execute;
	((AsyncTaskClass *) klass)->parse_stdout_line = (void (*) (AsyncTask*, const gchar*)) async_task_real_parse_stdout_line;
	((AsyncTaskClass *) klass)->parse_stderr_line = (void (*) (AsyncTask*, const gchar*)) async_task_real_parse_stderr_line;
	((AsyncTaskClass *) klass)->finish_task = (void (*) (AsyncTask*)) async_task_real_finish_task;
	G_OBJECT_CLASS (klass)->get_property = _vala_async_task_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_async_task_set_property;
	G_OBJECT_CLASS (klass)->finalize = async_task_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ASYNC_TASK_STATUS_LINE_PROPERTY, async_task_properties[ASYNC_TASK_STATUS_LINE_PROPERTY] = g_param_spec_string ("status-line", "status-line", "status-line", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ASYNC_TASK_STAT_TIME_ELAPSED_PROPERTY, async_task_properties[ASYNC_TASK_STAT_TIME_ELAPSED_PROPERTY] = g_param_spec_string ("stat-time-elapsed", "stat-time-elapsed", "stat-time-elapsed", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ASYNC_TASK_STAT_TIME_REMAINING_PROPERTY, async_task_properties[ASYNC_TASK_STAT_TIME_REMAINING_PROPERTY] = g_param_spec_string ("stat-time-remaining", "stat-time-remaining", "stat-time-remaining", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	async_task_signals[ASYNC_TASK_STDOUT_LINE_READ_SIGNAL] = g_signal_new ("stdout-line-read", TYPE_ASYNC_TASK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	async_task_signals[ASYNC_TASK_STDERR_LINE_READ_SIGNAL] = g_signal_new ("stderr-line-read", TYPE_ASYNC_TASK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	async_task_signals[ASYNC_TASK_TASK_COMPLETE_SIGNAL] = g_signal_new ("task-complete", TYPE_ASYNC_TASK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
async_task_instance_init (AsyncTask * self,
                          gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	self->priv = async_task_get_instance_private (self);
	_tmp0_ = g_strdup ("");
	self->priv->err_line = _tmp0_;
	_tmp1_ = g_strdup ("");
	self->priv->out_line = _tmp1_;
	self->priv->dos_in = NULL;
	self->priv->dis_out = NULL;
	self->priv->dis_err = NULL;
	self->dos_log = NULL;
	self->priv->stdout_is_open = FALSE;
	self->priv->stderr_is_open = FALSE;
	self->child_pid = (GPid) 0;
	self->priv->input_fd = -1;
	self->priv->output_fd = -1;
	self->priv->error_fd = -1;
	self->priv->finish_called = FALSE;
	_tmp2_ = g_strdup ("");
	self->script_file = _tmp2_;
	_tmp3_ = g_strdup ("");
	self->working_dir = _tmp3_;
	self->status = APP_STATUS_NOT_STARTED;
	_tmp4_ = g_strdup ("");
	self->priv->_status_line = _tmp4_;
	self->exit_code = 0;
	self->priv->timerOffset = 0.0;
	self->progress = 0.0;
	self->percent = 0.0;
	self->prg_count = (gint64) 0;
	self->prg_count_total = (gint64) 0;
}

static void
async_task_finalize (GObject * obj)
{
	AsyncTask * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ASYNC_TASK, AsyncTask);
	_g_free0 (self->priv->err_line);
	_g_free0 (self->priv->out_line);
	_g_object_unref0 (self->priv->dos_in);
	_g_object_unref0 (self->priv->dis_out);
	_g_object_unref0 (self->priv->dis_err);
	_g_object_unref0 (self->dos_log);
	_g_free0 (self->script_file);
	_g_free0 (self->working_dir);
	_g_free0 (self->priv->_status_line);
	_vala_clear_GMutex (&self->status_line_mutex);
	_g_timer_destroy0 (self->timer);
	G_OBJECT_CLASS (async_task_parent_class)->finalize (obj);
}

static GType
async_task_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AsyncTaskClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) async_task_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AsyncTask), 0, (GInstanceInitFunc) async_task_instance_init, NULL };
	GType async_task_type_id;
	async_task_type_id = g_type_register_static (G_TYPE_OBJECT, "AsyncTask", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	AsyncTask_private_offset = g_type_add_instance_private (async_task_type_id, sizeof (AsyncTaskPrivate));
	return async_task_type_id;
}

GType
async_task_get_type (void)
{
	static volatile gsize async_task_type_id__once = 0;
	if (g_once_init_enter (&async_task_type_id__once)) {
		GType async_task_type_id;
		async_task_type_id = async_task_get_type_once ();
		g_once_init_leave (&async_task_type_id__once, async_task_type_id);
	}
	return async_task_type_id__once;
}

static void
_vala_async_task_get_property (GObject * object,
                               guint property_id,
                               GValue * value,
                               GParamSpec * pspec)
{
	AsyncTask * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_ASYNC_TASK, AsyncTask);
	switch (property_id) {
		case ASYNC_TASK_STATUS_LINE_PROPERTY:
		g_value_take_string (value, async_task_get_status_line (self));
		break;
		case ASYNC_TASK_STAT_TIME_ELAPSED_PROPERTY:
		g_value_take_string (value, async_task_get_stat_time_elapsed (self));
		break;
		case ASYNC_TASK_STAT_TIME_REMAINING_PROPERTY:
		g_value_take_string (value, async_task_get_stat_time_remaining (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_async_task_set_property (GObject * object,
                               guint property_id,
                               const GValue * value,
                               GParamSpec * pspec)
{
	AsyncTask * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_ASYNC_TASK, AsyncTask);
	switch (property_id) {
		case ASYNC_TASK_STATUS_LINE_PROPERTY:
		async_task_set_status_line (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static GType
app_status_get_type_once (void)
{
	static const GEnumValue values[] = {{APP_STATUS_NOT_STARTED, "APP_STATUS_NOT_STARTED", "not-started"}, {APP_STATUS_RUNNING, "APP_STATUS_RUNNING", "running"}, {APP_STATUS_PAUSED, "APP_STATUS_PAUSED", "paused"}, {APP_STATUS_FINISHED, "APP_STATUS_FINISHED", "finished"}, {APP_STATUS_CANCELLED, "APP_STATUS_CANCELLED", "cancelled"}, {APP_STATUS_PASSWORD_REQUIRED, "APP_STATUS_PASSWORD_REQUIRED", "password-required"}, {0, NULL, NULL}};
	GType app_status_type_id;
	app_status_type_id = g_enum_register_static ("AppStatus", values);
	return app_status_type_id;
}

GType
app_status_get_type (void)
{
	static volatile gsize app_status_type_id__once = 0;
	if (g_once_init_enter (&app_status_type_id__once)) {
		GType app_status_type_id;
		app_status_type_id = app_status_get_type_once ();
		g_once_init_leave (&app_status_type_id__once, app_status_type_id);
	}
	return app_status_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static void
_vala_clear_GMutex (GMutex * mutex)
{
	GMutex zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GMutex))) {
		g_mutex_clear (mutex);
		memset (mutex, 0, sizeof (GMutex));
	}
}

static void
_vala_clear_GRecMutex (GRecMutex * mutex)
{
	GRecMutex zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GRecMutex))) {
		g_rec_mutex_clear (mutex);
		memset (mutex, 0, sizeof (GRecMutex));
	}
}

static void
_vala_clear_GRWLock (GRWLock * mutex)
{
	GRWLock zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GRWLock))) {
		g_rw_lock_clear (mutex);
		memset (mutex, 0, sizeof (GRWLock));
	}
}

static void
_vala_clear_GCond (GCond * mutex)
{
	GCond zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GCond))) {
		g_cond_clear (mutex);
		memset (mutex, 0, sizeof (GCond));
	}
}

