/* RestoreWindow.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from RestoreWindow.vala, do not modify */

/*
 * RestoreWindow.vala
 *
 * Copyright 2012-2018 Tony George <teejeetech@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 *
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <glib/gi18n-lib.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gdk/gdk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_RESTORE_WINDOW (restore_window_get_type ())
#define RESTORE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RESTORE_WINDOW, RestoreWindow))
#define RESTORE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RESTORE_WINDOW, RestoreWindowClass))
#define IS_RESTORE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RESTORE_WINDOW))
#define IS_RESTORE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RESTORE_WINDOW))
#define RESTORE_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RESTORE_WINDOW, RestoreWindowClass))

typedef struct _RestoreWindow RestoreWindow;
typedef struct _RestoreWindowClass RestoreWindowClass;
typedef struct _RestoreWindowPrivate RestoreWindowPrivate;

#define TYPE_RESTORE_DEVICE_BOX (restore_device_box_get_type ())
#define RESTORE_DEVICE_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RESTORE_DEVICE_BOX, RestoreDeviceBox))
#define RESTORE_DEVICE_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RESTORE_DEVICE_BOX, RestoreDeviceBoxClass))
#define IS_RESTORE_DEVICE_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RESTORE_DEVICE_BOX))
#define IS_RESTORE_DEVICE_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RESTORE_DEVICE_BOX))
#define RESTORE_DEVICE_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RESTORE_DEVICE_BOX, RestoreDeviceBoxClass))

typedef struct _RestoreDeviceBox RestoreDeviceBox;
typedef struct _RestoreDeviceBoxClass RestoreDeviceBoxClass;

#define TYPE_RESTORE_EXCLUDE_BOX (restore_exclude_box_get_type ())
#define RESTORE_EXCLUDE_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RESTORE_EXCLUDE_BOX, RestoreExcludeBox))
#define RESTORE_EXCLUDE_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RESTORE_EXCLUDE_BOX, RestoreExcludeBoxClass))
#define IS_RESTORE_EXCLUDE_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RESTORE_EXCLUDE_BOX))
#define IS_RESTORE_EXCLUDE_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RESTORE_EXCLUDE_BOX))
#define RESTORE_EXCLUDE_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RESTORE_EXCLUDE_BOX, RestoreExcludeBoxClass))

typedef struct _RestoreExcludeBox RestoreExcludeBox;
typedef struct _RestoreExcludeBoxClass RestoreExcludeBoxClass;

#define TYPE_EXCLUDE_APPS_BOX (exclude_apps_box_get_type ())
#define EXCLUDE_APPS_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EXCLUDE_APPS_BOX, ExcludeAppsBox))
#define EXCLUDE_APPS_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EXCLUDE_APPS_BOX, ExcludeAppsBoxClass))
#define IS_EXCLUDE_APPS_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EXCLUDE_APPS_BOX))
#define IS_EXCLUDE_APPS_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EXCLUDE_APPS_BOX))
#define EXCLUDE_APPS_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EXCLUDE_APPS_BOX, ExcludeAppsBoxClass))

typedef struct _ExcludeAppsBox ExcludeAppsBox;
typedef struct _ExcludeAppsBoxClass ExcludeAppsBoxClass;

#define TYPE_RESTORE_SUMMARY_BOX (restore_summary_box_get_type ())
#define RESTORE_SUMMARY_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RESTORE_SUMMARY_BOX, RestoreSummaryBox))
#define RESTORE_SUMMARY_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RESTORE_SUMMARY_BOX, RestoreSummaryBoxClass))
#define IS_RESTORE_SUMMARY_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RESTORE_SUMMARY_BOX))
#define IS_RESTORE_SUMMARY_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RESTORE_SUMMARY_BOX))
#define RESTORE_SUMMARY_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RESTORE_SUMMARY_BOX, RestoreSummaryBoxClass))

typedef struct _RestoreSummaryBox RestoreSummaryBox;
typedef struct _RestoreSummaryBoxClass RestoreSummaryBoxClass;

#define TYPE_RESTORE_BOX (restore_box_get_type ())
#define RESTORE_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RESTORE_BOX, RestoreBox))
#define RESTORE_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RESTORE_BOX, RestoreBoxClass))
#define IS_RESTORE_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RESTORE_BOX))
#define IS_RESTORE_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RESTORE_BOX))
#define RESTORE_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RESTORE_BOX, RestoreBoxClass))

typedef struct _RestoreBox RestoreBox;
typedef struct _RestoreBoxClass RestoreBoxClass;

#define TYPE_RSYNC_LOG_BOX (rsync_log_box_get_type ())
#define RSYNC_LOG_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RSYNC_LOG_BOX, RsyncLogBox))
#define RSYNC_LOG_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RSYNC_LOG_BOX, RsyncLogBoxClass))
#define IS_RSYNC_LOG_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RSYNC_LOG_BOX))
#define IS_RSYNC_LOG_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RSYNC_LOG_BOX))
#define RSYNC_LOG_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RSYNC_LOG_BOX, RsyncLogBoxClass))

typedef struct _RsyncLogBox RsyncLogBox;
typedef struct _RsyncLogBoxClass RsyncLogBoxClass;

#define TYPE_USERS_BOX (users_box_get_type ())
#define USERS_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_USERS_BOX, UsersBox))
#define USERS_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_USERS_BOX, UsersBoxClass))
#define IS_USERS_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_USERS_BOX))
#define IS_USERS_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_USERS_BOX))
#define USERS_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_USERS_BOX, UsersBoxClass))

typedef struct _UsersBox UsersBox;
typedef struct _UsersBoxClass UsersBoxClass;

#define TYPE_RESTORE_FINISH_BOX (restore_finish_box_get_type ())
#define RESTORE_FINISH_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RESTORE_FINISH_BOX, RestoreFinishBox))
#define RESTORE_FINISH_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RESTORE_FINISH_BOX, RestoreFinishBoxClass))
#define IS_RESTORE_FINISH_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RESTORE_FINISH_BOX))
#define IS_RESTORE_FINISH_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RESTORE_FINISH_BOX))
#define RESTORE_FINISH_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RESTORE_FINISH_BOX, RestoreFinishBoxClass))

typedef struct _RestoreFinishBox RestoreFinishBox;
typedef struct _RestoreFinishBoxClass RestoreFinishBoxClass;
enum  {
	RESTORE_WINDOW_0_PROPERTY,
	RESTORE_WINDOW_NUM_PROPERTIES
};
static GParamSpec* restore_window_properties[RESTORE_WINDOW_NUM_PROPERTIES];
typedef enum  {
	RESTORE_WINDOW_TABS_TARGET_DEVICE = 0,
	RESTORE_WINDOW_TABS_RESTORE_EXCLUDE = 1,
	RESTORE_WINDOW_TABS_EXCLUDE_APPS = 2,
	RESTORE_WINDOW_TABS_CHECK = 3,
	RESTORE_WINDOW_TABS_SHOW_LOG = 4,
	RESTORE_WINDOW_TABS_USERS = 5,
	RESTORE_WINDOW_TABS_SUMMARY = 6,
	RESTORE_WINDOW_TABS_RESTORE = 7,
	RESTORE_WINDOW_TABS_FINISH = 8
} RestoreWindowTabs;

#define RESTORE_WINDOW_TYPE_TABS (restore_window_tabs_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_MAIN (main_get_type ())
#define MAIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN, Main))
#define MAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN, MainClass))
#define IS_MAIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN))
#define IS_MAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN))
#define MAIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN, MainClass))

typedef struct _Main Main;
typedef struct _MainClass MainClass;
typedef struct _MainPrivate MainPrivate;

#define TYPE_DEVICE (device_get_type ())
#define DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DEVICE, Device))
#define DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DEVICE, DeviceClass))
#define IS_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DEVICE))
#define IS_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DEVICE))
#define DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DEVICE, DeviceClass))

typedef struct _Device Device;
typedef struct _DeviceClass DeviceClass;

#define TYPE_APP_EXCLUDE_ENTRY (app_exclude_entry_get_type ())
#define APP_EXCLUDE_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_EXCLUDE_ENTRY, AppExcludeEntry))
#define APP_EXCLUDE_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_EXCLUDE_ENTRY, AppExcludeEntryClass))
#define IS_APP_EXCLUDE_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_EXCLUDE_ENTRY))
#define IS_APP_EXCLUDE_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_EXCLUDE_ENTRY))
#define APP_EXCLUDE_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_EXCLUDE_ENTRY, AppExcludeEntryClass))

typedef struct _AppExcludeEntry AppExcludeEntry;
typedef struct _AppExcludeEntryClass AppExcludeEntryClass;

#define TYPE_MOUNT_ENTRY (mount_entry_get_type ())
#define MOUNT_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MOUNT_ENTRY, MountEntry))
#define MOUNT_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MOUNT_ENTRY, MountEntryClass))
#define IS_MOUNT_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MOUNT_ENTRY))
#define IS_MOUNT_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MOUNT_ENTRY))
#define MOUNT_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MOUNT_ENTRY, MountEntryClass))

typedef struct _MountEntry MountEntry;
typedef struct _MountEntryClass MountEntryClass;

#define TYPE_SNAPSHOT_REPO (snapshot_repo_get_type ())
#define SNAPSHOT_REPO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SNAPSHOT_REPO, SnapshotRepo))
#define SNAPSHOT_REPO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SNAPSHOT_REPO, SnapshotRepoClass))
#define IS_SNAPSHOT_REPO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SNAPSHOT_REPO))
#define IS_SNAPSHOT_REPO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SNAPSHOT_REPO))
#define SNAPSHOT_REPO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SNAPSHOT_REPO, SnapshotRepoClass))

typedef struct _SnapshotRepo SnapshotRepo;
typedef struct _SnapshotRepoClass SnapshotRepoClass;

#define TYPE_SUBVOLUME (subvolume_get_type ())
#define SUBVOLUME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUBVOLUME, Subvolume))
#define SUBVOLUME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUBVOLUME, SubvolumeClass))
#define IS_SUBVOLUME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUBVOLUME))
#define IS_SUBVOLUME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUBVOLUME))
#define SUBVOLUME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUBVOLUME, SubvolumeClass))

typedef struct _Subvolume Subvolume;
typedef struct _SubvolumeClass SubvolumeClass;

#define TYPE_LINUX_DISTRO (linux_distro_get_type ())
#define LINUX_DISTRO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LINUX_DISTRO, LinuxDistro))
#define LINUX_DISTRO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LINUX_DISTRO, LinuxDistroClass))
#define IS_LINUX_DISTRO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LINUX_DISTRO))
#define IS_LINUX_DISTRO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LINUX_DISTRO))
#define LINUX_DISTRO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LINUX_DISTRO, LinuxDistroClass))

typedef struct _LinuxDistro LinuxDistro;
typedef struct _LinuxDistroClass LinuxDistroClass;

#define TYPE_APP_LOCK (app_lock_get_type ())
#define APP_LOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_LOCK, AppLock))
#define APP_LOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_LOCK, AppLockClass))
#define IS_APP_LOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_LOCK))
#define IS_APP_LOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_LOCK))
#define APP_LOCK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_LOCK, AppLockClass))

typedef struct _AppLock AppLock;
typedef struct _AppLockClass AppLockClass;

#define TYPE_SNAPSHOT (snapshot_get_type ())
#define SNAPSHOT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SNAPSHOT, Snapshot))
#define SNAPSHOT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SNAPSHOT, SnapshotClass))
#define IS_SNAPSHOT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SNAPSHOT))
#define IS_SNAPSHOT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SNAPSHOT))
#define SNAPSHOT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SNAPSHOT, SnapshotClass))

typedef struct _Snapshot Snapshot;
typedef struct _SnapshotClass SnapshotClass;

#define TYPE_ASYNC_TASK (async_task_get_type ())
#define ASYNC_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ASYNC_TASK, AsyncTask))
#define ASYNC_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ASYNC_TASK, AsyncTaskClass))
#define IS_ASYNC_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ASYNC_TASK))
#define IS_ASYNC_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ASYNC_TASK))
#define ASYNC_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ASYNC_TASK, AsyncTaskClass))

typedef struct _AsyncTask AsyncTask;
typedef struct _AsyncTaskClass AsyncTaskClass;

#define TYPE_RSYNC_TASK (rsync_task_get_type ())
#define RSYNC_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RSYNC_TASK, RsyncTask))
#define RSYNC_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RSYNC_TASK, RsyncTaskClass))
#define IS_RSYNC_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RSYNC_TASK))
#define IS_RSYNC_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RSYNC_TASK))
#define RSYNC_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RSYNC_TASK, RsyncTaskClass))

typedef struct _RsyncTask RsyncTask;
typedef struct _RsyncTaskClass RsyncTaskClass;

#define TYPE_DELETE_FILE_TASK (delete_file_task_get_type ())
#define DELETE_FILE_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DELETE_FILE_TASK, DeleteFileTask))
#define DELETE_FILE_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DELETE_FILE_TASK, DeleteFileTaskClass))
#define IS_DELETE_FILE_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DELETE_FILE_TASK))
#define IS_DELETE_FILE_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DELETE_FILE_TASK))
#define DELETE_FILE_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DELETE_FILE_TASK, DeleteFileTaskClass))

typedef struct _DeleteFileTask DeleteFileTask;
typedef struct _DeleteFileTaskClass DeleteFileTaskClass;

#define TYPE_RSYNC_SPACE_CHECK_TASK (rsync_space_check_task_get_type ())
#define RSYNC_SPACE_CHECK_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RSYNC_SPACE_CHECK_TASK, RsyncSpaceCheckTask))
#define RSYNC_SPACE_CHECK_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RSYNC_SPACE_CHECK_TASK, RsyncSpaceCheckTaskClass))
#define IS_RSYNC_SPACE_CHECK_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RSYNC_SPACE_CHECK_TASK))
#define IS_RSYNC_SPACE_CHECK_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RSYNC_SPACE_CHECK_TASK))
#define RSYNC_SPACE_CHECK_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RSYNC_SPACE_CHECK_TASK, RsyncSpaceCheckTaskClass))

typedef struct _RsyncSpaceCheckTask RsyncSpaceCheckTask;
typedef struct _RsyncSpaceCheckTaskClass RsyncSpaceCheckTaskClass;

#define TYPE_SYSTEM_USER (system_user_get_type ())
#define SYSTEM_USER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SYSTEM_USER, SystemUser))
#define SYSTEM_USER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SYSTEM_USER, SystemUserClass))
#define IS_SYSTEM_USER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SYSTEM_USER))
#define IS_SYSTEM_USER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SYSTEM_USER))
#define SYSTEM_USER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SYSTEM_USER, SystemUserClass))

typedef struct _SystemUser SystemUser;
typedef struct _SystemUserClass SystemUserClass;

#define TYPE_EXCLUDE_BOX (exclude_box_get_type ())
#define EXCLUDE_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EXCLUDE_BOX, ExcludeBox))
#define EXCLUDE_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EXCLUDE_BOX, ExcludeBoxClass))
#define IS_EXCLUDE_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EXCLUDE_BOX))
#define IS_EXCLUDE_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EXCLUDE_BOX))
#define EXCLUDE_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EXCLUDE_BOX, ExcludeBoxClass))

typedef struct _ExcludeBox ExcludeBox;
typedef struct _ExcludeBoxClass ExcludeBoxClass;

#define TYPE_CUSTOM_MESSAGE_DIALOG (custom_message_dialog_get_type ())
#define CUSTOM_MESSAGE_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CUSTOM_MESSAGE_DIALOG, CustomMessageDialog))
#define CUSTOM_MESSAGE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CUSTOM_MESSAGE_DIALOG, CustomMessageDialogClass))
#define IS_CUSTOM_MESSAGE_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CUSTOM_MESSAGE_DIALOG))
#define IS_CUSTOM_MESSAGE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CUSTOM_MESSAGE_DIALOG))
#define CUSTOM_MESSAGE_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CUSTOM_MESSAGE_DIALOG, CustomMessageDialogClass))

typedef struct _CustomMessageDialog CustomMessageDialog;
typedef struct _CustomMessageDialogClass CustomMessageDialogClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef enum  {
	APP_STATUS_NOT_STARTED,
	APP_STATUS_RUNNING,
	APP_STATUS_PAUSED,
	APP_STATUS_FINISHED,
	APP_STATUS_CANCELLED,
	APP_STATUS_PASSWORD_REQUIRED
} AppStatus;

#define TYPE_APP_STATUS (app_status_get_type ())
typedef struct _SnapshotPrivate SnapshotPrivate;

#define TYPE_FS_TAB_ENTRY (fs_tab_entry_get_type ())
#define FS_TAB_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FS_TAB_ENTRY, FsTabEntry))
#define FS_TAB_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FS_TAB_ENTRY, FsTabEntryClass))
#define IS_FS_TAB_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FS_TAB_ENTRY))
#define IS_FS_TAB_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FS_TAB_ENTRY))
#define FS_TAB_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FS_TAB_ENTRY, FsTabEntryClass))

typedef struct _FsTabEntry FsTabEntry;
typedef struct _FsTabEntryClass FsTabEntryClass;

#define TYPE_CRYPT_TAB_ENTRY (crypt_tab_entry_get_type ())
#define CRYPT_TAB_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CRYPT_TAB_ENTRY, CryptTabEntry))
#define CRYPT_TAB_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CRYPT_TAB_ENTRY, CryptTabEntryClass))
#define IS_CRYPT_TAB_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CRYPT_TAB_ENTRY))
#define IS_CRYPT_TAB_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CRYPT_TAB_ENTRY))
#define CRYPT_TAB_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CRYPT_TAB_ENTRY, CryptTabEntryClass))

typedef struct _CryptTabEntry CryptTabEntry;
typedef struct _CryptTabEntryClass CryptTabEntryClass;

struct _RestoreWindow {
	GtkWindow parent_instance;
	RestoreWindowPrivate * priv;
	gboolean check_before_restore;
};

struct _RestoreWindowClass {
	GtkWindowClass parent_class;
};

struct _RestoreWindowPrivate {
	GtkBox* vbox_main;
	GtkNotebook* notebook;
	GtkButtonBox* bbox_action;
	RestoreDeviceBox* restore_device_box;
	RestoreExcludeBox* restore_exclude_box;
	ExcludeAppsBox* exclude_apps_box;
	RestoreSummaryBox* summary_box;
	RestoreBox* check_box;
	RsyncLogBox* log_box;
	RestoreBox* restore_box;
	UsersBox* users_box;
	RestoreFinishBox* restore_finish_box;
	GtkButton* btn_prev;
	GtkButton* btn_next;
	GtkButton* btn_cancel;
	GtkButton* btn_close;
	guint tmr_init;
	gint def_width;
	gint def_height;
	gboolean success;
};

struct _Main {
	GObject parent_instance;
	MainPrivate * priv;
	gchar* app_path;
	gchar* share_folder;
	gchar* rsnapshot_conf_path;
	gchar* app_conf_path;
	gchar* app_conf_path_old;
	gchar* app_conf_path_default;
	gboolean first_run;
	gchar* backup_uuid;
	gchar* backup_parent_uuid;
	gboolean btrfs_mode;
	gboolean include_btrfs_home_for_backup;
	gboolean include_btrfs_home_for_restore;
	gboolean stop_cron_emails;
	GeeArrayList* partitions;
	GeeArrayList* exclude_list_user;
	GeeArrayList* exclude_list_default;
	GeeArrayList* exclude_list_default_extra;
	GeeArrayList* exclude_list_home;
	GeeArrayList* exclude_list_restore;
	GeeArrayList* exclude_list_apps;
	GeeArrayList* mount_list;
	GeeArrayList* exclude_app_names;
	SnapshotRepo* repo;
	Device* sys_root;
	Device* sys_boot;
	Device* sys_efi;
	Device* sys_home;
	GeeHashMap* sys_subvolumes;
	gchar* mount_point_restore;
	gchar* mount_point_app;
	LinuxDistro* current_distro;
	gboolean mirror_system;
	gboolean schedule_monthly;
	gboolean schedule_weekly;
	gboolean schedule_daily;
	gboolean schedule_hourly;
	gboolean schedule_boot;
	gint count_monthly;
	gint count_weekly;
	gint count_daily;
	gint count_hourly;
	gint count_boot;
	gchar* app_mode;
	gboolean dry_run;
	gboolean thr_success;
	gboolean thread_restore_running;
	gboolean thread_restore_success;
	gboolean thread_delete_running;
	gboolean thread_delete_success;
	gboolean thread_subvol_info_running;
	gboolean thread_subvol_info_success;
	gint thr_retval;
	gchar* thr_arg1;
	gboolean thr_timeout_active;
	gchar* thr_timeout_cmd;
	gint startup_delay_interval_mins;
	gint retain_snapshots_max_days;
	gchar* log_dir;
	gchar* log_file;
	AppLock* app_lock;
	gchar* date_format;
	GeeArrayList* delete_list;
	Snapshot* snapshot_to_delete;
	Snapshot* snapshot_to_restore;
	gboolean reinstall_grub2;
	gboolean update_initramfs;
	gboolean update_grub;
	gchar* grub_device;
	gboolean use_option_raw;
	gboolean cmd_skip_grub;
	gchar* cmd_grub_device;
	gchar* cmd_target_device;
	gchar* cmd_backup_device;
	gchar* cmd_snapshot;
	gboolean cmd_confirm;
	gboolean cmd_verbose;
	gboolean cmd_scripted;
	gchar* cmd_comments;
	gchar* cmd_tags;
	gboolean* cmd_btrfs_mode;
	gchar* progress_text;
	GtkWindow* parent_window;
	RsyncTask* task;
	DeleteFileTask* delete_file_task;
	RsyncSpaceCheckTask* space_check_task;
	GeeHashMap* current_system_users;
	gchar* users_with_encrypted_home;
	gchar* encrypted_home_dirs;
	gboolean encrypted_home_warning_shown;
	gchar* encrypted_private_dirs;
	gboolean encrypted_private_warning_shown;
};

struct _MainClass {
	GObjectClass parent_class;
};

struct _Snapshot {
	GObject parent_instance;
	SnapshotPrivate * priv;
	gchar* path;
	gchar* name;
	GDateTime* date;
	gchar* sys_uuid;
	gchar* sys_distro;
	gchar* app_version;
	gchar* description;
	gint64 file_count;
	GeeArrayList* tags;
	GeeArrayList* exclude_list;
	GeeHashMap* subvolumes;
	GeeArrayList* fstab_list;
	GeeArrayList* cryttab_list;
	gboolean valid;
	gboolean live;
	gboolean marked_for_deletion;
	LinuxDistro* distro;
	SnapshotRepo* repo;
	gboolean btrfs_mode;
	GeeHashMap* paths;
	gchar* mount_path_root;
	gchar* mount_path_home;
	DeleteFileTask* delete_file_task;
};

struct _SnapshotClass {
	GObjectClass parent_class;
};

static gint RestoreWindow_private_offset;
static gpointer restore_window_parent_class = NULL;
VALA_EXTERN Main* App;

VALA_EXTERN GType restore_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RestoreWindow, g_object_unref)
VALA_EXTERN GType restore_device_box_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RestoreDeviceBox, g_object_unref)
VALA_EXTERN GType restore_exclude_box_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RestoreExcludeBox, g_object_unref)
VALA_EXTERN GType exclude_apps_box_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ExcludeAppsBox, g_object_unref)
VALA_EXTERN GType restore_summary_box_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RestoreSummaryBox, g_object_unref)
VALA_EXTERN GType restore_box_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RestoreBox, g_object_unref)
VALA_EXTERN GType rsync_log_box_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RsyncLogBox, g_object_unref)
VALA_EXTERN GType users_box_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UsersBox, g_object_unref)
VALA_EXTERN GType restore_finish_box_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RestoreFinishBox, g_object_unref)
VALA_EXTERN GType restore_window_tabs_get_type (void) G_GNUC_CONST ;
VALA_EXTERN RestoreWindow* restore_window_new (void);
VALA_EXTERN RestoreWindow* restore_window_construct (GType object_type);
VALA_EXTERN void tee_jee_logging_log_debug (const gchar* message);
VALA_EXTERN GType main_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Main, g_object_unref)
VALA_EXTERN GType device_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Device, g_object_unref)
VALA_EXTERN GType app_exclude_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AppExcludeEntry, g_object_unref)
VALA_EXTERN GType mount_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MountEntry, g_object_unref)
VALA_EXTERN GType snapshot_repo_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SnapshotRepo, g_object_unref)
VALA_EXTERN GType subvolume_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Subvolume, g_object_unref)
VALA_EXTERN GType linux_distro_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LinuxDistro, g_object_unref)
VALA_EXTERN GType app_lock_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AppLock, g_object_unref)
VALA_EXTERN GType snapshot_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Snapshot, g_object_unref)
VALA_EXTERN GType async_task_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AsyncTask, g_object_unref)
VALA_EXTERN GType rsync_task_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RsyncTask, g_object_unref)
VALA_EXTERN GType delete_file_task_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DeleteFileTask, g_object_unref)
VALA_EXTERN GType rsync_space_check_task_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RsyncSpaceCheckTask, g_object_unref)
VALA_EXTERN GType system_user_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SystemUser, g_object_unref)
VALA_EXTERN GdkPixbuf* icon_manager_lookup (const gchar* icon_name,
                                gint icon_size,
                                gboolean symbolic,
                                gboolean use_hardcoded,
                                gint scale);
static gboolean restore_window_on_delete_event (RestoreWindow* self,
                                         GdkEventAny* event);
static gboolean _restore_window_on_delete_event_gtk_widget_delete_event (GtkWidget* _sender,
                                                                  GdkEventAny* event,
                                                                  gpointer self);
VALA_EXTERN GtkNotebook* tee_jee_gtk_helper_add_notebook (GtkBox* box,
                                              gboolean show_tabs,
                                              gboolean show_border);
VALA_EXTERN RestoreDeviceBox* restore_device_box_new (GtkWindow* _parent_window);
VALA_EXTERN RestoreDeviceBox* restore_device_box_construct (GType object_type,
                                                GtkWindow* _parent_window);
VALA_EXTERN RestoreExcludeBox* restore_exclude_box_new (GtkWindow* _parent_window);
VALA_EXTERN RestoreExcludeBox* restore_exclude_box_construct (GType object_type,
                                                  GtkWindow* _parent_window);
VALA_EXTERN ExcludeAppsBox* exclude_apps_box_new (GtkWindow* _parent_window);
VALA_EXTERN ExcludeAppsBox* exclude_apps_box_construct (GType object_type,
                                            GtkWindow* _parent_window);
VALA_EXTERN RestoreBox* restore_box_new (GtkWindow* _parent_window);
VALA_EXTERN RestoreBox* restore_box_construct (GType object_type,
                                   GtkWindow* _parent_window);
VALA_EXTERN RsyncLogBox* rsync_log_box_new (GtkWindow* _window);
VALA_EXTERN RsyncLogBox* rsync_log_box_construct (GType object_type,
                                      GtkWindow* _window);
VALA_EXTERN GType exclude_box_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ExcludeBox, g_object_unref)
VALA_EXTERN ExcludeBox* exclude_box_new (GtkWindow* _parent_window);
VALA_EXTERN ExcludeBox* exclude_box_construct (GType object_type,
                                   GtkWindow* _parent_window);
VALA_EXTERN UsersBox* users_box_new (GtkWindow* _parent_window,
                         ExcludeBox* _exclude_box,
                         gboolean _restore_mode);
VALA_EXTERN UsersBox* users_box_construct (GType object_type,
                               GtkWindow* _parent_window,
                               ExcludeBox* _exclude_box,
                               gboolean _restore_mode);
VALA_EXTERN RestoreSummaryBox* restore_summary_box_new (GtkWindow* _parent_window);
VALA_EXTERN RestoreSummaryBox* restore_summary_box_construct (GType object_type,
                                                  GtkWindow* _parent_window);
VALA_EXTERN RestoreFinishBox* restore_finish_box_new (GtkWindow* _parent_window);
VALA_EXTERN RestoreFinishBox* restore_finish_box_construct (GType object_type,
                                                GtkWindow* _parent_window);
static void restore_window_create_actions (RestoreWindow* self);
VALA_EXTERN void tee_jee_gtk_helper_gtk_do_events (void);
static gboolean restore_window_init_delayed (RestoreWindow* self);
static gboolean _restore_window_init_delayed_gsource_func (gpointer self);
static void restore_window_go_first (RestoreWindow* self);
static void restore_window_save_changes (RestoreWindow* self);
VALA_EXTERN void main_cron_job_update (Main* self);
VALA_EXTERN GtkButton* tee_jee_gtk_helper_add_button (GtkBox* box,
                                          const gchar* text,
                                          const gchar* tooltip,
                                          GtkSizeGroup* size_group,
                                          GtkImage* icon);
static void __lambda130_ (RestoreWindow* self);
static void restore_window_go_prev (RestoreWindow* self);
static void ___lambda130__gtk_button_clicked (GtkButton* _sender,
                                       gpointer self);
static void __lambda131_ (RestoreWindow* self);
VALA_EXTERN void tee_jee_gtk_helper_gtk_set_busy (gboolean busy,
                                      GtkWindow* win);
static void restore_window_go_next (RestoreWindow* self);
static void ___lambda131__gtk_button_clicked (GtkButton* _sender,
                                       gpointer self);
static void __lambda132_ (RestoreWindow* self);
static void ___lambda132__gtk_button_clicked (GtkButton* _sender,
                                       gpointer self);
static void __lambda133_ (RestoreWindow* self);
VALA_EXTERN GType custom_message_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CustomMessageDialog, g_object_unref)
VALA_EXTERN CustomMessageDialog* custom_message_dialog_new (const gchar* _msg_title,
                                                const gchar* _msg_body,
                                                GtkMessageType _msg_type,
                                                GtkWindow* parent,
                                                GtkButtonsType _buttons_type);
VALA_EXTERN CustomMessageDialog* custom_message_dialog_construct (GType object_type,
                                                      const gchar* _msg_title,
                                                      const gchar* _msg_body,
                                                      GtkMessageType _msg_type,
                                                      GtkWindow* parent,
                                                      GtkButtonsType _buttons_type);
VALA_EXTERN GType app_status_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void async_task_stop (AsyncTask* self,
                      AppStatus status_to_update);
static void ___lambda133__gtk_button_clicked (GtkButton* _sender,
                                       gpointer self);
static void restore_window_action_buttons_set_no_show_all (RestoreWindow* self,
                                                    gboolean val);
VALA_EXTERN GType fs_tab_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FsTabEntry, g_object_unref)
VALA_EXTERN GType crypt_tab_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CryptTabEntry, g_object_unref)
static void restore_window_initialize_tab (RestoreWindow* self);
static gboolean restore_window_validate_current_tab (RestoreWindow* self);
VALA_EXTERN void restore_device_box_refresh (RestoreDeviceBox* self,
                                 gboolean reset_device_selections);
VALA_EXTERN void restore_exclude_box_refresh (RestoreExcludeBox* self);
VALA_EXTERN void exclude_apps_box_refresh (ExcludeAppsBox* self);
VALA_EXTERN gboolean restore_box_restore (RestoreBox* self);
VALA_EXTERN gboolean tee_jee_file_system_file_exists (const gchar* file_path);
VALA_EXTERN gchar* snapshot_get_rsync_restore_log_file (Snapshot* self);
VALA_EXTERN void rsync_log_box_open_log (RsyncLogBox* self,
                             const gchar* _rsync_log_file);
VALA_EXTERN void restore_finish_box_update_message (RestoreFinishBox* self,
                                        gboolean success,
                                        const gchar* message_header,
                                        const gchar* message_body);
VALA_EXTERN void users_box_refresh (UsersBox* self);
VALA_EXTERN void restore_summary_box_refresh (RestoreSummaryBox* self);
VALA_EXTERN gboolean restore_device_box_check_and_mount_devices (RestoreDeviceBox* self);
VALA_EXTERN void main_add_app_exclude_entries (Main* self);
VALA_EXTERN void main_save_exclude_list_selections (Main* self);
static void restore_window_finalize (GObject * obj);
static GType restore_window_get_type_once (void);

static inline gpointer
restore_window_get_instance_private (RestoreWindow* self)
{
	return G_STRUCT_MEMBER_P (self, RestoreWindow_private_offset);
}

static GType
restore_window_tabs_get_type_once (void)
{
	static const GEnumValue values[] = {{RESTORE_WINDOW_TABS_TARGET_DEVICE, "RESTORE_WINDOW_TABS_TARGET_DEVICE", "target-device"}, {RESTORE_WINDOW_TABS_RESTORE_EXCLUDE, "RESTORE_WINDOW_TABS_RESTORE_EXCLUDE", "restore-exclude"}, {RESTORE_WINDOW_TABS_EXCLUDE_APPS, "RESTORE_WINDOW_TABS_EXCLUDE_APPS", "exclude-apps"}, {RESTORE_WINDOW_TABS_CHECK, "RESTORE_WINDOW_TABS_CHECK", "check"}, {RESTORE_WINDOW_TABS_SHOW_LOG, "RESTORE_WINDOW_TABS_SHOW_LOG", "show-log"}, {RESTORE_WINDOW_TABS_USERS, "RESTORE_WINDOW_TABS_USERS", "users"}, {RESTORE_WINDOW_TABS_SUMMARY, "RESTORE_WINDOW_TABS_SUMMARY", "summary"}, {RESTORE_WINDOW_TABS_RESTORE, "RESTORE_WINDOW_TABS_RESTORE", "restore"}, {RESTORE_WINDOW_TABS_FINISH, "RESTORE_WINDOW_TABS_FINISH", "finish"}, {0, NULL, NULL}};
	GType restore_window_tabs_type_id;
	restore_window_tabs_type_id = g_enum_register_static ("RestoreWindowTabs", values);
	return restore_window_tabs_type_id;
}

GType
restore_window_tabs_get_type (void)
{
	static volatile gsize restore_window_tabs_type_id__once = 0;
	if (g_once_init_enter (&restore_window_tabs_type_id__once)) {
		GType restore_window_tabs_type_id;
		restore_window_tabs_type_id = restore_window_tabs_get_type_once ();
		g_once_init_leave (&restore_window_tabs_type_id__once, restore_window_tabs_type_id);
	}
	return restore_window_tabs_type_id__once;
}

static gboolean
_restore_window_on_delete_event_gtk_widget_delete_event (GtkWidget* _sender,
                                                         GdkEventAny* event,
                                                         gpointer self)
{
	gboolean result;
	result = restore_window_on_delete_event ((RestoreWindow*) self, event);
	return result;
}

static gboolean
_restore_window_init_delayed_gsource_func (gpointer self)
{
	gboolean result;
	result = restore_window_init_delayed ((RestoreWindow*) self);
	return result;
}

RestoreWindow*
restore_window_construct (GType object_type)
{
	RestoreWindow * self = NULL;
	const gchar* _tmp0_ = NULL;
	Main* _tmp1_;
	GdkPixbuf* _tmp2_;
	GdkPixbuf* _tmp3_;
	GtkBox* _tmp4_;
	GtkBox* _tmp5_;
	GtkBox* _tmp6_;
	GtkBox* _tmp7_;
	GtkNotebook* _tmp8_;
	GtkLabel* label = NULL;
	GtkLabel* _tmp9_;
	RestoreDeviceBox* _tmp10_;
	RestoreDeviceBox* _tmp11_;
	GtkNotebook* _tmp12_;
	RestoreDeviceBox* _tmp13_;
	GtkLabel* _tmp14_;
	GtkLabel* _tmp15_;
	RestoreExcludeBox* _tmp16_;
	RestoreExcludeBox* _tmp17_;
	GtkNotebook* _tmp18_;
	RestoreExcludeBox* _tmp19_;
	GtkLabel* _tmp20_;
	GtkLabel* _tmp21_;
	ExcludeAppsBox* _tmp22_;
	ExcludeAppsBox* _tmp23_;
	GtkNotebook* _tmp24_;
	ExcludeAppsBox* _tmp25_;
	GtkLabel* _tmp26_;
	GtkLabel* _tmp27_;
	RestoreBox* _tmp28_;
	RestoreBox* _tmp29_;
	GtkNotebook* _tmp30_;
	RestoreBox* _tmp31_;
	GtkLabel* _tmp32_;
	GtkLabel* _tmp33_;
	RsyncLogBox* _tmp34_;
	RsyncLogBox* _tmp35_;
	GtkNotebook* _tmp36_;
	RsyncLogBox* _tmp37_;
	GtkLabel* _tmp38_;
	GtkLabel* _tmp39_;
	ExcludeBox* exclude_box = NULL;
	ExcludeBox* _tmp40_;
	UsersBox* _tmp41_;
	UsersBox* _tmp42_;
	GtkNotebook* _tmp43_;
	UsersBox* _tmp44_;
	GtkLabel* _tmp45_;
	GtkLabel* _tmp46_;
	RestoreSummaryBox* _tmp47_;
	RestoreSummaryBox* _tmp48_;
	GtkNotebook* _tmp49_;
	RestoreSummaryBox* _tmp50_;
	GtkLabel* _tmp51_;
	GtkLabel* _tmp52_;
	RestoreBox* _tmp53_;
	RestoreBox* _tmp54_;
	GtkNotebook* _tmp55_;
	RestoreBox* _tmp56_;
	GtkLabel* _tmp57_;
	GtkLabel* _tmp58_;
	RestoreFinishBox* _tmp59_;
	RestoreFinishBox* _tmp60_;
	GtkNotebook* _tmp61_;
	RestoreFinishBox* _tmp62_;
	GtkLabel* _tmp63_;
	self = (RestoreWindow*) g_object_new (object_type, NULL);
	tee_jee_logging_log_debug ("RestoreWindow: RestoreWindow()");
	_tmp1_ = App;
	if (_tmp1_->mirror_system) {
		_tmp0_ = _ ("Clone System");
	} else {
		_tmp0_ = _ ("Restore Snapshot");
	}
	gtk_window_set_title ((GtkWindow*) self, _tmp0_);
	g_object_set ((GtkWindow*) self, "window-position", GTK_WIN_POS_CENTER, NULL);
	gtk_window_set_modal ((GtkWindow*) self, TRUE);
	gtk_window_set_default_size ((GtkWindow*) self, self->priv->def_width, self->priv->def_height);
	_tmp2_ = icon_manager_lookup ("timeshift", 16, FALSE, FALSE, 1);
	_tmp3_ = _tmp2_;
	gtk_window_set_icon ((GtkWindow*) self, _tmp3_);
	_g_object_unref0 (_tmp3_);
	gtk_window_resize ((GtkWindow*) self, self->priv->def_width, self->priv->def_height);
	g_signal_connect_object ((GtkWidget*) self, "delete-event", (GCallback) _restore_window_on_delete_event_gtk_widget_delete_event, self, 0);
	_tmp4_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 6);
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->vbox_main);
	self->priv->vbox_main = _tmp4_;
	_tmp5_ = self->priv->vbox_main;
	g_object_set ((GtkWidget*) _tmp5_, "margin", 0, NULL);
	_tmp6_ = self->priv->vbox_main;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp6_);
	_tmp7_ = self->priv->vbox_main;
	_tmp8_ = tee_jee_gtk_helper_add_notebook (_tmp7_, FALSE, FALSE);
	_g_object_unref0 (self->priv->notebook);
	self->priv->notebook = _tmp8_;
	_tmp9_ = (GtkLabel*) gtk_label_new (_ ("Restore Device"));
	g_object_ref_sink (_tmp9_);
	_g_object_unref0 (label);
	label = _tmp9_;
	_tmp10_ = restore_device_box_new ((GtkWindow*) self);
	g_object_ref_sink (_tmp10_);
	_g_object_unref0 (self->priv->restore_device_box);
	self->priv->restore_device_box = _tmp10_;
	_tmp11_ = self->priv->restore_device_box;
	g_object_set ((GtkWidget*) _tmp11_, "margin", 12, NULL);
	_tmp12_ = self->priv->notebook;
	_tmp13_ = self->priv->restore_device_box;
	_tmp14_ = label;
	gtk_notebook_append_page (_tmp12_, (GtkWidget*) _tmp13_, (GtkWidget*) _tmp14_);
	_tmp15_ = (GtkLabel*) gtk_label_new (_ ("Restore Exclude"));
	g_object_ref_sink (_tmp15_);
	_g_object_unref0 (label);
	label = _tmp15_;
	_tmp16_ = restore_exclude_box_new ((GtkWindow*) self);
	g_object_ref_sink (_tmp16_);
	_g_object_unref0 (self->priv->restore_exclude_box);
	self->priv->restore_exclude_box = _tmp16_;
	_tmp17_ = self->priv->restore_exclude_box;
	g_object_set ((GtkWidget*) _tmp17_, "margin", 12, NULL);
	_tmp18_ = self->priv->notebook;
	_tmp19_ = self->priv->restore_exclude_box;
	_tmp20_ = label;
	gtk_notebook_append_page (_tmp18_, (GtkWidget*) _tmp19_, (GtkWidget*) _tmp20_);
	_tmp21_ = (GtkLabel*) gtk_label_new (_ ("Exclude Apps"));
	g_object_ref_sink (_tmp21_);
	_g_object_unref0 (label);
	label = _tmp21_;
	_tmp22_ = exclude_apps_box_new ((GtkWindow*) self);
	g_object_ref_sink (_tmp22_);
	_g_object_unref0 (self->priv->exclude_apps_box);
	self->priv->exclude_apps_box = _tmp22_;
	_tmp23_ = self->priv->exclude_apps_box;
	g_object_set ((GtkWidget*) _tmp23_, "margin", 12, NULL);
	_tmp24_ = self->priv->notebook;
	_tmp25_ = self->priv->exclude_apps_box;
	_tmp26_ = label;
	gtk_notebook_append_page (_tmp24_, (GtkWidget*) _tmp25_, (GtkWidget*) _tmp26_);
	_tmp27_ = (GtkLabel*) gtk_label_new (_ ("Checking Restore Actions (Dry Run)"));
	g_object_ref_sink (_tmp27_);
	_g_object_unref0 (label);
	label = _tmp27_;
	_tmp28_ = restore_box_new ((GtkWindow*) self);
	g_object_ref_sink (_tmp28_);
	_g_object_unref0 (self->priv->check_box);
	self->priv->check_box = _tmp28_;
	_tmp29_ = self->priv->check_box;
	g_object_set ((GtkWidget*) _tmp29_, "margin", 12, NULL);
	_tmp30_ = self->priv->notebook;
	_tmp31_ = self->priv->check_box;
	_tmp32_ = label;
	gtk_notebook_append_page (_tmp30_, (GtkWidget*) _tmp31_, (GtkWidget*) _tmp32_);
	_tmp33_ = (GtkLabel*) gtk_label_new (_ ("Confirm Actions"));
	g_object_ref_sink (_tmp33_);
	_g_object_unref0 (label);
	label = _tmp33_;
	_tmp34_ = rsync_log_box_new ((GtkWindow*) self);
	g_object_ref_sink (_tmp34_);
	_g_object_unref0 (self->priv->log_box);
	self->priv->log_box = _tmp34_;
	_tmp35_ = self->priv->log_box;
	g_object_set ((GtkWidget*) _tmp35_, "margin", 12, NULL);
	_tmp36_ = self->priv->notebook;
	_tmp37_ = self->priv->log_box;
	_tmp38_ = label;
	gtk_notebook_append_page (_tmp36_, (GtkWidget*) _tmp37_, (GtkWidget*) _tmp38_);
	_tmp39_ = (GtkLabel*) gtk_label_new (_ ("Users Home"));
	g_object_ref_sink (_tmp39_);
	_g_object_unref0 (label);
	label = _tmp39_;
	_tmp40_ = exclude_box_new ((GtkWindow*) self);
	g_object_ref_sink (_tmp40_);
	exclude_box = _tmp40_;
	_tmp41_ = users_box_new ((GtkWindow*) self, exclude_box, TRUE);
	g_object_ref_sink (_tmp41_);
	_g_object_unref0 (self->priv->users_box);
	self->priv->users_box = _tmp41_;
	_tmp42_ = self->priv->users_box;
	g_object_set ((GtkWidget*) _tmp42_, "margin", 12, NULL);
	_tmp43_ = self->priv->notebook;
	_tmp44_ = self->priv->users_box;
	_tmp45_ = label;
	gtk_notebook_append_page (_tmp43_, (GtkWidget*) _tmp44_, (GtkWidget*) _tmp45_);
	_tmp46_ = (GtkLabel*) gtk_label_new (_ ("Summary"));
	g_object_ref_sink (_tmp46_);
	_g_object_unref0 (label);
	label = _tmp46_;
	_tmp47_ = restore_summary_box_new ((GtkWindow*) self);
	g_object_ref_sink (_tmp47_);
	_g_object_unref0 (self->priv->summary_box);
	self->priv->summary_box = _tmp47_;
	_tmp48_ = self->priv->summary_box;
	g_object_set ((GtkWidget*) _tmp48_, "margin", 12, NULL);
	_tmp49_ = self->priv->notebook;
	_tmp50_ = self->priv->summary_box;
	_tmp51_ = label;
	gtk_notebook_append_page (_tmp49_, (GtkWidget*) _tmp50_, (GtkWidget*) _tmp51_);
	_tmp52_ = (GtkLabel*) gtk_label_new (_ ("Restore"));
	g_object_ref_sink (_tmp52_);
	_g_object_unref0 (label);
	label = _tmp52_;
	_tmp53_ = restore_box_new ((GtkWindow*) self);
	g_object_ref_sink (_tmp53_);
	_g_object_unref0 (self->priv->restore_box);
	self->priv->restore_box = _tmp53_;
	_tmp54_ = self->priv->restore_box;
	g_object_set ((GtkWidget*) _tmp54_, "margin", 12, NULL);
	_tmp55_ = self->priv->notebook;
	_tmp56_ = self->priv->restore_box;
	_tmp57_ = label;
	gtk_notebook_append_page (_tmp55_, (GtkWidget*) _tmp56_, (GtkWidget*) _tmp57_);
	_tmp58_ = (GtkLabel*) gtk_label_new (_ ("Finished"));
	g_object_ref_sink (_tmp58_);
	_g_object_unref0 (label);
	label = _tmp58_;
	_tmp59_ = restore_finish_box_new ((GtkWindow*) self);
	g_object_ref_sink (_tmp59_);
	_g_object_unref0 (self->priv->restore_finish_box);
	self->priv->restore_finish_box = _tmp59_;
	_tmp60_ = self->priv->restore_finish_box;
	g_object_set ((GtkWidget*) _tmp60_, "margin", 12, NULL);
	_tmp61_ = self->priv->notebook;
	_tmp62_ = self->priv->restore_finish_box;
	_tmp63_ = label;
	gtk_notebook_append_page (_tmp61_, (GtkWidget*) _tmp62_, (GtkWidget*) _tmp63_);
	restore_window_create_actions (self);
	gtk_widget_show_all ((GtkWidget*) self);
	tee_jee_gtk_helper_gtk_do_events ();
	self->priv->tmr_init = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 100, _restore_window_init_delayed_gsource_func, g_object_ref (self), g_object_unref);
	tee_jee_logging_log_debug ("RestoreWindow: RestoreWindow(): exit");
	_g_object_unref0 (exclude_box);
	_g_object_unref0 (label);
	return self;
}

RestoreWindow*
restore_window_new (void)
{
	return restore_window_construct (TYPE_RESTORE_WINDOW);
}

static gboolean
restore_window_init_delayed (RestoreWindow* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->tmr_init > ((guint) 0)) {
		g_source_remove (self->priv->tmr_init);
		self->priv->tmr_init = (guint) 0;
	}
	gtk_window_resize ((GtkWindow*) self, self->priv->def_width, self->priv->def_height);
	restore_window_go_first (self);
	result = FALSE;
	return result;
}

static gboolean
restore_window_on_delete_event (RestoreWindow* self,
                                GdkEventAny* event)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	restore_window_save_changes (self);
	result = FALSE;
	return result;
}

static void
restore_window_save_changes (RestoreWindow* self)
{
	Main* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = App;
	main_cron_job_update (_tmp0_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
__lambda130_ (RestoreWindow* self)
{
	restore_window_go_prev (self);
}

static void
___lambda130__gtk_button_clicked (GtkButton* _sender,
                                  gpointer self)
{
	__lambda130_ ((RestoreWindow*) self);
}

static void
__lambda131_ (RestoreWindow* self)
{
	tee_jee_gtk_helper_gtk_set_busy (TRUE, (GtkWindow*) self);
	tee_jee_gtk_helper_gtk_do_events ();
	tee_jee_gtk_helper_gtk_set_busy (FALSE, (GtkWindow*) self);
	restore_window_go_next (self);
}

static void
___lambda131__gtk_button_clicked (GtkButton* _sender,
                                  gpointer self)
{
	__lambda131_ ((RestoreWindow*) self);
}

static void
__lambda132_ (RestoreWindow* self)
{
	restore_window_save_changes (self);
	gtk_widget_destroy ((GtkWidget*) self);
}

static void
___lambda132__gtk_button_clicked (GtkButton* _sender,
                                  gpointer self)
{
	__lambda132_ ((RestoreWindow*) self);
}

static void
__lambda133_ (RestoreWindow* self)
{
	Main* _tmp0_;
	Main* _tmp8_;
	RsyncTask* _tmp9_;
	_tmp0_ = App;
	if (!_tmp0_->dry_run) {
		gchar* title = NULL;
		gchar* _tmp1_;
		gchar* msg = NULL;
		gchar* _tmp2_;
		CustomMessageDialog* dlg = NULL;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		CustomMessageDialog* _tmp5_;
		gint response = 0;
		CustomMessageDialog* _tmp6_;
		CustomMessageDialog* _tmp7_;
		_tmp1_ = g_strdup (_ ("Cancel restore?"));
		title = _tmp1_;
		_tmp2_ = g_strdup (_ ("Cancelling the restore process will leave the target system in an inco" \
"nsistent state. The system may fail to boot or you may run into variou" \
"s issues. After cancelling, you need to restore another snapshot, to b" \
"ring the system to a consistent state. Click Yes to confirm."));
		msg = _tmp2_;
		_tmp3_ = title;
		_tmp4_ = msg;
		_tmp5_ = custom_message_dialog_new (_tmp3_, _tmp4_, GTK_MESSAGE_ERROR, (GtkWindow*) self, GTK_BUTTONS_YES_NO);
		g_object_ref_sink (_tmp5_);
		dlg = _tmp5_;
		_tmp6_ = dlg;
		response = gtk_dialog_run ((GtkDialog*) _tmp6_);
		_tmp7_ = dlg;
		gtk_widget_destroy ((GtkWidget*) _tmp7_);
		if (response != ((gint) GTK_RESPONSE_YES)) {
			_g_object_unref0 (dlg);
			_g_free0 (msg);
			_g_free0 (title);
			return;
		}
		_g_object_unref0 (dlg);
		_g_free0 (msg);
		_g_free0 (title);
	}
	_tmp8_ = App;
	_tmp9_ = _tmp8_->task;
	if (_tmp9_ != NULL) {
		Main* _tmp10_;
		RsyncTask* _tmp11_;
		_tmp10_ = App;
		_tmp11_ = _tmp10_->task;
		async_task_stop ((AsyncTask*) _tmp11_, APP_STATUS_CANCELLED);
	}
	gtk_widget_destroy ((GtkWidget*) self);
}

static void
___lambda133__gtk_button_clicked (GtkButton* _sender,
                                  gpointer self)
{
	__lambda133_ ((RestoreWindow*) self);
}

static void
restore_window_create_actions (RestoreWindow* self)
{
	GtkBox* hbox = NULL;
	GtkBox* _tmp0_;
	GtkBox* _tmp1_;
	GtkButtonBox* bbox = NULL;
	GtkButtonBox* _tmp2_;
	GtkButtonBox* _tmp3_;
	GtkSizeGroup* size_group = NULL;
	GtkButton* _tmp4_;
	GtkButton* _tmp5_;
	GtkButton* _tmp6_;
	GtkButton* _tmp7_;
	GtkButton* _tmp8_;
	GtkButton* _tmp9_;
	GtkButton* _tmp10_;
	GtkButton* _tmp11_;
	GtkButton* _tmp12_;
	GtkButton* _tmp13_;
	GtkButton* _tmp14_;
	GtkButton* _tmp15_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
	g_object_ref_sink (_tmp0_);
	hbox = _tmp0_;
	_tmp1_ = self->priv->vbox_main;
	gtk_container_add ((GtkContainer*) _tmp1_, (GtkWidget*) hbox);
	_tmp2_ = (GtkButtonBox*) gtk_button_box_new (GTK_ORIENTATION_HORIZONTAL);
	g_object_ref_sink (_tmp2_);
	bbox = _tmp2_;
	g_object_set ((GtkWidget*) bbox, "margin", 12, NULL);
	gtk_box_set_spacing ((GtkBox*) bbox, 6);
	gtk_widget_set_hexpand ((GtkWidget*) bbox, TRUE);
	gtk_container_add ((GtkContainer*) hbox, (GtkWidget*) bbox);
	_tmp3_ = _g_object_ref0 (bbox);
	_g_object_unref0 (self->priv->bbox_action);
	self->priv->bbox_action = _tmp3_;
	gtk_button_box_set_layout (bbox, GTK_BUTTONBOX_CENTER);
	size_group = NULL;
	_tmp4_ = tee_jee_gtk_helper_add_button ((GtkBox*) bbox, _ ("Previous"), "", size_group, NULL);
	_g_object_unref0 (self->priv->btn_prev);
	self->priv->btn_prev = _tmp4_;
	_tmp5_ = self->priv->btn_prev;
	g_signal_connect_object (_tmp5_, "clicked", (GCallback) ___lambda130__gtk_button_clicked, self, 0);
	_tmp6_ = tee_jee_gtk_helper_add_button ((GtkBox*) bbox, _ ("Next"), "", size_group, NULL);
	_g_object_unref0 (self->priv->btn_next);
	self->priv->btn_next = _tmp6_;
	_tmp7_ = self->priv->btn_next;
	g_signal_connect_object (_tmp7_, "clicked", (GCallback) ___lambda131__gtk_button_clicked, self, 0);
	_tmp8_ = tee_jee_gtk_helper_add_button ((GtkBox*) bbox, _ ("Cancel"), "", size_group, NULL);
	_g_object_unref0 (self->priv->btn_close);
	self->priv->btn_close = _tmp8_;
	_tmp9_ = self->priv->btn_close;
	g_signal_connect_object (_tmp9_, "clicked", (GCallback) ___lambda132__gtk_button_clicked, self, 0);
	_tmp10_ = tee_jee_gtk_helper_add_button ((GtkBox*) bbox, _ ("Cancel"), "", size_group, NULL);
	_g_object_unref0 (self->priv->btn_cancel);
	self->priv->btn_cancel = _tmp10_;
	_tmp11_ = self->priv->btn_cancel;
	g_signal_connect_object (_tmp11_, "clicked", (GCallback) ___lambda133__gtk_button_clicked, self, 0);
	_tmp12_ = self->priv->btn_prev;
	_tmp13_ = self->priv->btn_next;
	_tmp14_ = self->priv->btn_cancel;
	_tmp15_ = self->priv->btn_close;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp15_, TRUE);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp14_, TRUE);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp13_, TRUE);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp12_, TRUE);
	restore_window_action_buttons_set_no_show_all (self, TRUE);
	_g_object_unref0 (size_group);
	_g_object_unref0 (bbox);
	_g_object_unref0 (hbox);
}

static void
restore_window_action_buttons_set_no_show_all (RestoreWindow* self,
                                               gboolean val)
{
	GtkButton* _tmp0_;
	GtkButton* _tmp1_;
	GtkButton* _tmp2_;
	GtkButton* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->btn_prev;
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp0_, val);
	_tmp1_ = self->priv->btn_next;
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp1_, val);
	_tmp2_ = self->priv->btn_close;
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp2_, val);
	_tmp3_ = self->priv->btn_cancel;
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp3_, val);
}

static void
restore_window_go_first (RestoreWindow* self)
{
	Main* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = App;
	if (_tmp0_->btrfs_mode) {
		Main* _tmp1_;
		Snapshot* _tmp2_;
		GeeHashMap* _tmp3_;
		_tmp1_ = App;
		_tmp2_ = _tmp1_->snapshot_to_restore;
		_tmp3_ = _tmp2_->subvolumes;
		if (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp3_, "@home")) {
			GtkNotebook* _tmp4_;
			_tmp4_ = self->priv->notebook;
			g_object_set (_tmp4_, "page", (gint) RESTORE_WINDOW_TABS_USERS, NULL);
		} else {
			GtkNotebook* _tmp5_;
			_tmp5_ = self->priv->notebook;
			g_object_set (_tmp5_, "page", (gint) RESTORE_WINDOW_TABS_SUMMARY, NULL);
		}
	} else {
		GtkNotebook* _tmp6_;
		_tmp6_ = self->priv->notebook;
		g_object_set (_tmp6_, "page", (gint) RESTORE_WINDOW_TABS_TARGET_DEVICE, NULL);
	}
	restore_window_initialize_tab (self);
}

static void
restore_window_go_prev (RestoreWindow* self)
{
	GtkNotebook* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->notebook;
	g_object_get (_tmp0_, "page", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	switch (_tmp2_) {
		case RESTORE_WINDOW_TABS_RESTORE_EXCLUDE:
		{
			GtkNotebook* _tmp3_;
			_tmp3_ = self->priv->notebook;
			g_object_set (_tmp3_, "page", (gint) RESTORE_WINDOW_TABS_TARGET_DEVICE, NULL);
			break;
		}
		case RESTORE_WINDOW_TABS_EXCLUDE_APPS:
		{
			GtkNotebook* _tmp4_;
			_tmp4_ = self->priv->notebook;
			g_object_set (_tmp4_, "page", (gint) RESTORE_WINDOW_TABS_RESTORE_EXCLUDE, NULL);
			break;
		}
		case RESTORE_WINDOW_TABS_SUMMARY:
		{
			GtkNotebook* _tmp5_;
			_tmp5_ = self->priv->notebook;
			g_object_set (_tmp5_, "page", (gint) RESTORE_WINDOW_TABS_RESTORE_EXCLUDE, NULL);
			break;
		}
		case RESTORE_WINDOW_TABS_TARGET_DEVICE:
		case RESTORE_WINDOW_TABS_RESTORE:
		case RESTORE_WINDOW_TABS_FINISH:
		{
			break;
		}
		default:
		break;
	}
	restore_window_initialize_tab (self);
}

static void
restore_window_go_next (RestoreWindow* self)
{
	GtkNotebook* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_if_fail (self != NULL);
	if (!restore_window_validate_current_tab (self)) {
		return;
	}
	_tmp0_ = self->priv->notebook;
	g_object_get (_tmp0_, "page", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	switch (_tmp2_) {
		case RESTORE_WINDOW_TABS_TARGET_DEVICE:
		{
			gboolean _tmp3_ = FALSE;
			Main* _tmp4_;
			_tmp4_ = App;
			if (!_tmp4_->btrfs_mode) {
				_tmp3_ = self->check_before_restore;
			} else {
				_tmp3_ = FALSE;
			}
			if (_tmp3_) {
				GtkNotebook* _tmp5_;
				_tmp5_ = self->priv->notebook;
				g_object_set (_tmp5_, "page", (gint) RESTORE_WINDOW_TABS_CHECK, NULL);
			} else {
				GtkNotebook* _tmp6_;
				_tmp6_ = self->priv->notebook;
				g_object_set (_tmp6_, "page", (gint) RESTORE_WINDOW_TABS_SUMMARY, NULL);
			}
			break;
		}
		case RESTORE_WINDOW_TABS_CHECK:
		{
			GtkNotebook* _tmp7_;
			_tmp7_ = self->priv->notebook;
			g_object_set (_tmp7_, "page", (gint) RESTORE_WINDOW_TABS_SHOW_LOG, NULL);
			break;
		}
		case RESTORE_WINDOW_TABS_SHOW_LOG:
		{
			GtkNotebook* _tmp8_;
			_tmp8_ = self->priv->notebook;
			g_object_set (_tmp8_, "page", (gint) RESTORE_WINDOW_TABS_SUMMARY, NULL);
			break;
		}
		case RESTORE_WINDOW_TABS_USERS:
		{
			GtkNotebook* _tmp9_;
			_tmp9_ = self->priv->notebook;
			g_object_set (_tmp9_, "page", (gint) RESTORE_WINDOW_TABS_SUMMARY, NULL);
			break;
		}
		case RESTORE_WINDOW_TABS_SUMMARY:
		{
			GtkNotebook* _tmp10_;
			_tmp10_ = self->priv->notebook;
			g_object_set (_tmp10_, "page", (gint) RESTORE_WINDOW_TABS_RESTORE, NULL);
			break;
		}
		case RESTORE_WINDOW_TABS_RESTORE:
		{
			GtkNotebook* _tmp11_;
			_tmp11_ = self->priv->notebook;
			g_object_set (_tmp11_, "page", (gint) RESTORE_WINDOW_TABS_FINISH, NULL);
			break;
		}
		case RESTORE_WINDOW_TABS_FINISH:
		{
			gtk_widget_destroy ((GtkWidget*) self);
			break;
		}
		default:
		break;
	}
	tee_jee_gtk_helper_gtk_do_events ();
	restore_window_initialize_tab (self);
}

static void
restore_window_initialize_tab (RestoreWindow* self)
{
	GtkNotebook* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GtkNotebook* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GtkNotebook* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	GtkNotebook* _tmp41_;
	gint _tmp42_;
	gint _tmp43_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->notebook;
	g_object_get (_tmp0_, "page", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	if (_tmp2_ < 0) {
		return;
	}
	_tmp3_ = self->priv->notebook;
	g_object_get (_tmp3_, "page", &_tmp4_, NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strdup_printf ("initialize_tab: %d", _tmp5_);
	_tmp7_ = _tmp6_;
	tee_jee_logging_log_debug (_tmp7_);
	_g_free0 (_tmp7_);
	restore_window_action_buttons_set_no_show_all (self, FALSE);
	_tmp8_ = self->priv->notebook;
	g_object_get (_tmp8_, "page", &_tmp9_, NULL);
	_tmp10_ = _tmp9_;
	switch (_tmp10_) {
		case RESTORE_WINDOW_TABS_RESTORE:
		{
			GtkButton* _tmp11_;
			GtkButton* _tmp12_;
			GtkButton* _tmp13_;
			GtkButton* _tmp14_;
			_tmp11_ = self->priv->btn_prev;
			gtk_widget_hide ((GtkWidget*) _tmp11_);
			_tmp12_ = self->priv->btn_next;
			gtk_widget_hide ((GtkWidget*) _tmp12_);
			_tmp13_ = self->priv->btn_close;
			gtk_widget_hide ((GtkWidget*) _tmp13_);
			_tmp14_ = self->priv->btn_cancel;
			gtk_widget_show ((GtkWidget*) _tmp14_);
			break;
		}
		case RESTORE_WINDOW_TABS_CHECK:
		{
			GtkButton* _tmp15_;
			GtkButton* _tmp16_;
			GtkButton* _tmp17_;
			GtkButton* _tmp18_;
			GtkButton* _tmp19_;
			_tmp15_ = self->priv->btn_prev;
			gtk_widget_hide ((GtkWidget*) _tmp15_);
			_tmp16_ = self->priv->btn_next;
			gtk_widget_hide ((GtkWidget*) _tmp16_);
			_tmp17_ = self->priv->btn_close;
			gtk_widget_hide ((GtkWidget*) _tmp17_);
			_tmp18_ = self->priv->btn_cancel;
			gtk_widget_show ((GtkWidget*) _tmp18_);
			_tmp19_ = self->priv->btn_cancel;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp19_, TRUE);
			break;
		}
		case RESTORE_WINDOW_TABS_TARGET_DEVICE:
		case RESTORE_WINDOW_TABS_RESTORE_EXCLUDE:
		case RESTORE_WINDOW_TABS_EXCLUDE_APPS:
		case RESTORE_WINDOW_TABS_SUMMARY:
		case RESTORE_WINDOW_TABS_USERS:
		{
			GtkButton* _tmp20_;
			GtkButton* _tmp21_;
			GtkButton* _tmp22_;
			GtkButton* _tmp23_;
			GtkButton* _tmp24_;
			GtkButton* _tmp25_;
			GtkButton* _tmp26_;
			_tmp20_ = self->priv->btn_prev;
			gtk_widget_show ((GtkWidget*) _tmp20_);
			_tmp21_ = self->priv->btn_next;
			gtk_widget_show ((GtkWidget*) _tmp21_);
			_tmp22_ = self->priv->btn_close;
			gtk_widget_show ((GtkWidget*) _tmp22_);
			_tmp23_ = self->priv->btn_cancel;
			gtk_widget_hide ((GtkWidget*) _tmp23_);
			_tmp24_ = self->priv->btn_prev;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp24_, FALSE);
			_tmp25_ = self->priv->btn_next;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp25_, TRUE);
			_tmp26_ = self->priv->btn_close;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp26_, TRUE);
			break;
		}
		case RESTORE_WINDOW_TABS_SHOW_LOG:
		{
			GtkButton* _tmp27_;
			GtkButton* _tmp28_;
			GtkButton* _tmp29_;
			GtkButton* _tmp30_;
			GtkButton* _tmp31_;
			GtkButton* _tmp32_;
			GtkButton* _tmp33_;
			_tmp27_ = self->priv->btn_prev;
			gtk_widget_show ((GtkWidget*) _tmp27_);
			_tmp28_ = self->priv->btn_next;
			gtk_widget_show ((GtkWidget*) _tmp28_);
			_tmp29_ = self->priv->btn_close;
			gtk_widget_show ((GtkWidget*) _tmp29_);
			_tmp30_ = self->priv->btn_cancel;
			gtk_widget_hide ((GtkWidget*) _tmp30_);
			_tmp31_ = self->priv->btn_prev;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp31_, FALSE);
			_tmp32_ = self->priv->btn_next;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp32_, TRUE);
			_tmp33_ = self->priv->btn_close;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp33_, TRUE);
			break;
		}
		case RESTORE_WINDOW_TABS_FINISH:
		{
			GtkButton* _tmp34_;
			GtkButton* _tmp35_;
			GtkButton* _tmp36_;
			GtkButton* _tmp37_;
			GtkButton* _tmp38_;
			GtkButton* _tmp39_;
			GtkButton* _tmp40_;
			_tmp34_ = self->priv->btn_prev;
			gtk_widget_show ((GtkWidget*) _tmp34_);
			_tmp35_ = self->priv->btn_next;
			gtk_widget_show ((GtkWidget*) _tmp35_);
			_tmp36_ = self->priv->btn_close;
			gtk_widget_show ((GtkWidget*) _tmp36_);
			_tmp37_ = self->priv->btn_cancel;
			gtk_widget_hide ((GtkWidget*) _tmp37_);
			_tmp38_ = self->priv->btn_prev;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp38_, FALSE);
			_tmp39_ = self->priv->btn_next;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp39_, FALSE);
			_tmp40_ = self->priv->btn_close;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp40_, TRUE);
			break;
		}
		default:
		break;
	}
	tee_jee_gtk_helper_gtk_do_events ();
	_tmp41_ = self->priv->notebook;
	g_object_get (_tmp41_, "page", &_tmp42_, NULL);
	_tmp43_ = _tmp42_;
	switch (_tmp43_) {
		case RESTORE_WINDOW_TABS_TARGET_DEVICE:
		{
			RestoreDeviceBox* _tmp44_;
			_tmp44_ = self->priv->restore_device_box;
			restore_device_box_refresh (_tmp44_, FALSE);
			break;
		}
		case RESTORE_WINDOW_TABS_RESTORE_EXCLUDE:
		{
			RestoreExcludeBox* _tmp45_;
			_tmp45_ = self->priv->restore_exclude_box;
			restore_exclude_box_refresh (_tmp45_);
			break;
		}
		case RESTORE_WINDOW_TABS_EXCLUDE_APPS:
		{
			ExcludeAppsBox* _tmp46_;
			_tmp46_ = self->priv->exclude_apps_box;
			exclude_apps_box_refresh (_tmp46_);
			break;
		}
		case RESTORE_WINDOW_TABS_CHECK:
		{
			Main* _tmp47_;
			RestoreBox* _tmp48_;
			_tmp47_ = App;
			_tmp47_->dry_run = TRUE;
			_tmp48_ = self->priv->check_box;
			self->priv->success = restore_box_restore (_tmp48_);
			restore_window_go_next (self);
			break;
		}
		case RESTORE_WINDOW_TABS_SHOW_LOG:
		{
			Main* _tmp49_;
			Snapshot* _tmp50_;
			gchar* _tmp51_;
			gchar* _tmp52_;
			gchar* _tmp53_;
			gboolean _tmp54_;
			_tmp49_ = App;
			_tmp50_ = _tmp49_->snapshot_to_restore;
			_tmp51_ = snapshot_get_rsync_restore_log_file (_tmp50_);
			_tmp52_ = _tmp51_;
			_tmp53_ = _tmp52_;
			_tmp54_ = tee_jee_file_system_file_exists (_tmp53_);
			_g_free0 (_tmp53_);
			if (_tmp54_) {
				RsyncLogBox* _tmp55_;
				Main* _tmp56_;
				Snapshot* _tmp57_;
				gchar* _tmp58_;
				gchar* _tmp59_;
				gchar* _tmp60_;
				_tmp55_ = self->priv->log_box;
				_tmp56_ = App;
				_tmp57_ = _tmp56_->snapshot_to_restore;
				_tmp58_ = snapshot_get_rsync_restore_log_file (_tmp57_);
				_tmp59_ = _tmp58_;
				_tmp60_ = _tmp59_;
				rsync_log_box_open_log (_tmp55_, _tmp60_);
				_g_free0 (_tmp60_);
			} else {
				GtkNotebook* _tmp61_;
				RestoreFinishBox* _tmp62_;
				_tmp61_ = self->priv->notebook;
				g_object_set (_tmp61_, "page", (gint) RESTORE_WINDOW_TABS_FINISH, NULL);
				restore_window_initialize_tab (self);
				_tmp62_ = self->priv->restore_finish_box;
				restore_finish_box_update_message (_tmp62_, FALSE, _ ("Error running Rsync"), "");
			}
			break;
		}
		case RESTORE_WINDOW_TABS_USERS:
		{
			UsersBox* _tmp63_;
			_tmp63_ = self->priv->users_box;
			users_box_refresh (_tmp63_);
			break;
		}
		case RESTORE_WINDOW_TABS_SUMMARY:
		{
			RestoreSummaryBox* _tmp64_;
			_tmp64_ = self->priv->summary_box;
			restore_summary_box_refresh (_tmp64_);
			break;
		}
		case RESTORE_WINDOW_TABS_RESTORE:
		{
			Main* _tmp65_;
			RestoreBox* _tmp66_;
			_tmp65_ = App;
			_tmp65_->dry_run = FALSE;
			_tmp66_ = self->priv->restore_box;
			self->priv->success = restore_box_restore (_tmp66_);
			restore_window_go_next (self);
			break;
		}
		case RESTORE_WINDOW_TABS_FINISH:
		{
			RestoreFinishBox* _tmp67_;
			GtkButton* _tmp68_;
			_tmp67_ = self->priv->restore_finish_box;
			restore_finish_box_update_message (_tmp67_, self->priv->success, "", "");
			_tmp68_ = self->priv->btn_close;
			gtk_button_set_label (_tmp68_, _ ("Close"));
			break;
		}
		default:
		break;
	}
	tee_jee_gtk_helper_gtk_do_events ();
}

static gboolean
restore_window_validate_current_tab (RestoreWindow* self)
{
	GtkNotebook* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->notebook;
	g_object_get (_tmp0_, "page", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == ((gint) RESTORE_WINDOW_TABS_TARGET_DEVICE)) {
		gboolean ok = FALSE;
		RestoreDeviceBox* _tmp3_;
		_tmp3_ = self->priv->restore_device_box;
		ok = restore_device_box_check_and_mount_devices (_tmp3_);
		if (ok) {
			Main* _tmp4_;
			_tmp4_ = App;
			main_add_app_exclude_entries (_tmp4_);
		}
		result = ok;
		return result;
	} else {
		GtkNotebook* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		_tmp5_ = self->priv->notebook;
		g_object_get (_tmp5_, "page", &_tmp6_, NULL);
		_tmp7_ = _tmp6_;
		if (_tmp7_ == ((gint) RESTORE_WINDOW_TABS_RESTORE_EXCLUDE)) {
			Main* _tmp8_;
			_tmp8_ = App;
			main_save_exclude_list_selections (_tmp8_);
		} else {
			GtkNotebook* _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			_tmp9_ = self->priv->notebook;
			g_object_get (_tmp9_, "page", &_tmp10_, NULL);
			_tmp11_ = _tmp10_;
			if (_tmp11_ == ((gint) RESTORE_WINDOW_TABS_EXCLUDE_APPS)) {
				Main* _tmp12_;
				_tmp12_ = App;
				main_save_exclude_list_selections (_tmp12_);
			}
		}
	}
	result = TRUE;
	return result;
}

static void
restore_window_class_init (RestoreWindowClass * klass,
                           gpointer klass_data)
{
	restore_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RestoreWindow_private_offset);
	G_OBJECT_CLASS (klass)->finalize = restore_window_finalize;
}

static void
restore_window_instance_init (RestoreWindow * self,
                              gpointer klass)
{
	self->priv = restore_window_get_instance_private (self);
	self->priv->def_width = 500;
	self->priv->def_height = 500;
	self->priv->success = FALSE;
	self->check_before_restore = TRUE;
}

static void
restore_window_finalize (GObject * obj)
{
	RestoreWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_RESTORE_WINDOW, RestoreWindow);
	_g_object_unref0 (self->priv->vbox_main);
	_g_object_unref0 (self->priv->notebook);
	_g_object_unref0 (self->priv->bbox_action);
	_g_object_unref0 (self->priv->restore_device_box);
	_g_object_unref0 (self->priv->restore_exclude_box);
	_g_object_unref0 (self->priv->exclude_apps_box);
	_g_object_unref0 (self->priv->summary_box);
	_g_object_unref0 (self->priv->check_box);
	_g_object_unref0 (self->priv->log_box);
	_g_object_unref0 (self->priv->restore_box);
	_g_object_unref0 (self->priv->users_box);
	_g_object_unref0 (self->priv->restore_finish_box);
	_g_object_unref0 (self->priv->btn_prev);
	_g_object_unref0 (self->priv->btn_next);
	_g_object_unref0 (self->priv->btn_cancel);
	_g_object_unref0 (self->priv->btn_close);
	G_OBJECT_CLASS (restore_window_parent_class)->finalize (obj);
}

static GType
restore_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RestoreWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) restore_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RestoreWindow), 0, (GInstanceInitFunc) restore_window_instance_init, NULL };
	GType restore_window_type_id;
	restore_window_type_id = g_type_register_static (gtk_window_get_type (), "RestoreWindow", &g_define_type_info, 0);
	RestoreWindow_private_offset = g_type_add_instance_private (restore_window_type_id, sizeof (RestoreWindowPrivate));
	return restore_window_type_id;
}

GType
restore_window_get_type (void)
{
	static volatile gsize restore_window_type_id__once = 0;
	if (g_once_init_enter (&restore_window_type_id__once)) {
		GType restore_window_type_id;
		restore_window_type_id = restore_window_get_type_once ();
		g_once_init_leave (&restore_window_type_id__once, restore_window_type_id);
	}
	return restore_window_type_id__once;
}

