// Code generated by smithy-go-codegen DO NOT EDIT.

package iam

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Retrieves the configuration information for the outbound identity federation
// feature in your Amazon Web Services account. The response includes the unique
// issuer URL for your Amazon Web Services account and the current enabled/disabled
// status of the feature. Use this operation to obtain the issuer URL that you need
// to configure trust relationships with external services.
func (c *Client) GetOutboundWebIdentityFederationInfo(ctx context.Context, params *GetOutboundWebIdentityFederationInfoInput, optFns ...func(*Options)) (*GetOutboundWebIdentityFederationInfoOutput, error) {
	if params == nil {
		params = &GetOutboundWebIdentityFederationInfoInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetOutboundWebIdentityFederationInfo", params, optFns, c.addOperationGetOutboundWebIdentityFederationInfoMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetOutboundWebIdentityFederationInfoOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetOutboundWebIdentityFederationInfoInput struct {
	noSmithyDocumentSerde
}

type GetOutboundWebIdentityFederationInfoOutput struct {

	// A unique issuer URL for your Amazon Web Services account that hosts the OpenID
	// Connect (OIDC) discovery endpoints at /.well-known/openid-configuration and
	// /.well-known/jwks.json . The OpenID Connect (OIDC) discovery endpoints contain
	// verification keys and metadata necessary for token verification.
	IssuerIdentifier *string

	// Indicates whether outbound identity federation is currently enabled for your
	// Amazon Web Services account. When true, IAM principals in the account can call
	// the GetWebIdentityToken API to obtain JSON Web Tokens (JWTs) for authentication
	// with external services.
	JwtVendingEnabled bool

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetOutboundWebIdentityFederationInfoMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsquery_serializeOpGetOutboundWebIdentityFederationInfo{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsquery_deserializeOpGetOutboundWebIdentityFederationInfo{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetOutboundWebIdentityFederationInfo"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetOutboundWebIdentityFederationInfo(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetOutboundWebIdentityFederationInfo(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetOutboundWebIdentityFederationInfo",
	}
}
