/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1beta1

// IngressClassSpecApplyConfiguration represents a declarative configuration of the IngressClassSpec type for use
// with apply.
//
// IngressClassSpec provides information about the class of an Ingress.
type IngressClassSpecApplyConfiguration struct {
	// controller refers to the name of the controller that should handle this
	// class. This allows for different "flavors" that are controlled by the
	// same controller. For example, you may have different parameters for the
	// same implementing controller. This should be specified as a
	// domain-prefixed path no more than 250 characters in length, e.g.
	// "acme.io/ingress-controller". This field is immutable.
	Controller *string `json:"controller,omitempty"`
	// parameters is a link to a custom resource containing additional
	// configuration for the controller. This is optional if the controller does
	// not require extra parameters.
	Parameters *IngressClassParametersReferenceApplyConfiguration `json:"parameters,omitempty"`
}

// IngressClassSpecApplyConfiguration constructs a declarative configuration of the IngressClassSpec type for use with
// apply.
func IngressClassSpec() *IngressClassSpecApplyConfiguration {
	return &IngressClassSpecApplyConfiguration{}
}

// WithController sets the Controller field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Controller field is set to the value of the last call.
func (b *IngressClassSpecApplyConfiguration) WithController(value string) *IngressClassSpecApplyConfiguration {
	b.Controller = &value
	return b
}

// WithParameters sets the Parameters field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Parameters field is set to the value of the last call.
func (b *IngressClassSpecApplyConfiguration) WithParameters(value *IngressClassParametersReferenceApplyConfiguration) *IngressClassSpecApplyConfiguration {
	b.Parameters = value
	return b
}
