// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) Go Code Generator. DO NOT EDIT.

package azcertificates

import (
	"context"
	"errors"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
)

// Client - The key vault client performs cryptographic key operations and vault operations against the Key Vault service.
// Don't use this type directly, use a constructor function instead.
type Client struct {
	internal     *azcore.Client
	vaultBaseUrl string
}

// BackupCertificate - Backs up the specified certificate.
//
// Requests that a backup of the specified certificate be downloaded to the client. All versions of the certificate will be
// downloaded. This operation requires the certificates/backup permission.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 7.6
//   - name - The name of the certificate.
//   - options - BackupCertificateOptions contains the optional parameters for the Client.BackupCertificate method.
func (client *Client) BackupCertificate(ctx context.Context, name string, options *BackupCertificateOptions) (BackupCertificateResponse, error) {
	var err error
	const operationName = "Client.BackupCertificate"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.backupCertificateCreateRequest(ctx, name, options)
	if err != nil {
		return BackupCertificateResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return BackupCertificateResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return BackupCertificateResponse{}, err
	}
	resp, err := client.backupCertificateHandleResponse(httpResp)
	return resp, err
}

// backupCertificateCreateRequest creates the BackupCertificate request.
func (client *Client) backupCertificateCreateRequest(ctx context.Context, name string, _ *BackupCertificateOptions) (*policy.Request, error) {
	host := "{vaultBaseUrl}"
	host = strings.ReplaceAll(host, "{vaultBaseUrl}", client.vaultBaseUrl)
	urlPath := "/certificates/{certificate-name}/backup"
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{certificate-name}", url.PathEscape(name))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.6")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// backupCertificateHandleResponse handles the BackupCertificate response.
func (client *Client) backupCertificateHandleResponse(resp *http.Response) (BackupCertificateResponse, error) {
	result := BackupCertificateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.BackupCertificateResult); err != nil {
		return BackupCertificateResponse{}, err
	}
	return result, nil
}

// CreateCertificate - Creates a new certificate.
//
// If this is the first version, the certificate resource is created. This operation requires the certificates/create permission.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 7.6
//   - name - The name of the certificate. The value you provide may be copied globally for the purpose of running the service.
//     The value provided should not include personally identifiable or sensitive information.
//   - parameters - The parameters to create a certificate.
//   - options - CreateCertificateOptions contains the optional parameters for the Client.CreateCertificate method.
func (client *Client) CreateCertificate(ctx context.Context, name string, parameters CreateCertificateParameters, options *CreateCertificateOptions) (CreateCertificateResponse, error) {
	var err error
	const operationName = "Client.CreateCertificate"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createCertificateCreateRequest(ctx, name, parameters, options)
	if err != nil {
		return CreateCertificateResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return CreateCertificateResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return CreateCertificateResponse{}, err
	}
	resp, err := client.createCertificateHandleResponse(httpResp)
	return resp, err
}

// createCertificateCreateRequest creates the CreateCertificate request.
func (client *Client) createCertificateCreateRequest(ctx context.Context, name string, parameters CreateCertificateParameters, _ *CreateCertificateOptions) (*policy.Request, error) {
	host := "{vaultBaseUrl}"
	host = strings.ReplaceAll(host, "{vaultBaseUrl}", client.vaultBaseUrl)
	urlPath := "/certificates/{certificate-name}/create"
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{certificate-name}", url.PathEscape(name))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.6")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	req.Raw().Header["Content-Type"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, parameters); err != nil {
		return nil, err
	}
	return req, nil
}

// createCertificateHandleResponse handles the CreateCertificate response.
func (client *Client) createCertificateHandleResponse(resp *http.Response) (CreateCertificateResponse, error) {
	result := CreateCertificateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.CertificateOperation); err != nil {
		return CreateCertificateResponse{}, err
	}
	return result, nil
}

// DeleteCertificate - Deletes a certificate from a specified key vault.
//
// Deletes all versions of a certificate object along with its associated policy. Delete certificate cannot be used to remove
// individual versions of a certificate object. This operation requires the certificates/delete permission.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 7.6
//   - name - The name of the certificate.
//   - options - DeleteCertificateOptions contains the optional parameters for the Client.DeleteCertificate method.
func (client *Client) DeleteCertificate(ctx context.Context, name string, options *DeleteCertificateOptions) (DeleteCertificateResponse, error) {
	var err error
	const operationName = "Client.DeleteCertificate"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteCertificateCreateRequest(ctx, name, options)
	if err != nil {
		return DeleteCertificateResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return DeleteCertificateResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return DeleteCertificateResponse{}, err
	}
	resp, err := client.deleteCertificateHandleResponse(httpResp)
	return resp, err
}

// deleteCertificateCreateRequest creates the DeleteCertificate request.
func (client *Client) deleteCertificateCreateRequest(ctx context.Context, name string, _ *DeleteCertificateOptions) (*policy.Request, error) {
	host := "{vaultBaseUrl}"
	host = strings.ReplaceAll(host, "{vaultBaseUrl}", client.vaultBaseUrl)
	urlPath := "/certificates/{certificate-name}"
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{certificate-name}", url.PathEscape(name))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.6")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// deleteCertificateHandleResponse handles the DeleteCertificate response.
func (client *Client) deleteCertificateHandleResponse(resp *http.Response) (DeleteCertificateResponse, error) {
	result := DeleteCertificateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DeletedCertificate); err != nil {
		return DeleteCertificateResponse{}, err
	}
	return result, nil
}

// DeleteCertificateOperation - Deletes the creation operation for a specific certificate.
//
// Deletes the creation operation for a specified certificate that is in the process of being created. The certificate is
// no longer created. This operation requires the certificates/update permission.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 7.6
//   - name - The name of the certificate.
//   - options - DeleteCertificateOperationOptions contains the optional parameters for the Client.DeleteCertificateOperation
//     method.
func (client *Client) DeleteCertificateOperation(ctx context.Context, name string, options *DeleteCertificateOperationOptions) (DeleteCertificateOperationResponse, error) {
	var err error
	const operationName = "Client.DeleteCertificateOperation"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteCertificateOperationCreateRequest(ctx, name, options)
	if err != nil {
		return DeleteCertificateOperationResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return DeleteCertificateOperationResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return DeleteCertificateOperationResponse{}, err
	}
	resp, err := client.deleteCertificateOperationHandleResponse(httpResp)
	return resp, err
}

// deleteCertificateOperationCreateRequest creates the DeleteCertificateOperation request.
func (client *Client) deleteCertificateOperationCreateRequest(ctx context.Context, name string, _ *DeleteCertificateOperationOptions) (*policy.Request, error) {
	host := "{vaultBaseUrl}"
	host = strings.ReplaceAll(host, "{vaultBaseUrl}", client.vaultBaseUrl)
	urlPath := "/certificates/{certificate-name}/pending"
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{certificate-name}", url.PathEscape(name))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.6")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// deleteCertificateOperationHandleResponse handles the DeleteCertificateOperation response.
func (client *Client) deleteCertificateOperationHandleResponse(resp *http.Response) (DeleteCertificateOperationResponse, error) {
	result := DeleteCertificateOperationResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.CertificateOperation); err != nil {
		return DeleteCertificateOperationResponse{}, err
	}
	return result, nil
}

// DeleteContacts - Deletes the certificate contacts for a specified key vault.
//
// Deletes the certificate contacts for a specified key vault certificate. This operation requires the certificates/managecontacts
// permission.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 7.6
//   - options - DeleteContactsOptions contains the optional parameters for the Client.DeleteContacts method.
func (client *Client) DeleteContacts(ctx context.Context, options *DeleteContactsOptions) (DeleteContactsResponse, error) {
	var err error
	const operationName = "Client.DeleteContacts"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteContactsCreateRequest(ctx, options)
	if err != nil {
		return DeleteContactsResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return DeleteContactsResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return DeleteContactsResponse{}, err
	}
	resp, err := client.deleteContactsHandleResponse(httpResp)
	return resp, err
}

// deleteContactsCreateRequest creates the DeleteContacts request.
func (client *Client) deleteContactsCreateRequest(ctx context.Context, _ *DeleteContactsOptions) (*policy.Request, error) {
	host := "{vaultBaseUrl}"
	host = strings.ReplaceAll(host, "{vaultBaseUrl}", client.vaultBaseUrl)
	urlPath := "/certificates/contacts"
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.6")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// deleteContactsHandleResponse handles the DeleteContacts response.
func (client *Client) deleteContactsHandleResponse(resp *http.Response) (DeleteContactsResponse, error) {
	result := DeleteContactsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Contacts); err != nil {
		return DeleteContactsResponse{}, err
	}
	return result, nil
}

// DeleteIssuer - Deletes the specified certificate issuer.
//
// The DeleteCertificateIssuer operation permanently removes the specified certificate issuer from the vault. This operation
// requires the certificates/manageissuers/deleteissuers permission.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 7.6
//   - name - The name of the issuer.
//   - options - DeleteIssuerOptions contains the optional parameters for the Client.DeleteIssuer method.
func (client *Client) DeleteIssuer(ctx context.Context, name string, options *DeleteIssuerOptions) (DeleteIssuerResponse, error) {
	var err error
	const operationName = "Client.DeleteIssuer"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteIssuerCreateRequest(ctx, name, options)
	if err != nil {
		return DeleteIssuerResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return DeleteIssuerResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return DeleteIssuerResponse{}, err
	}
	resp, err := client.deleteIssuerHandleResponse(httpResp)
	return resp, err
}

// deleteIssuerCreateRequest creates the DeleteIssuer request.
func (client *Client) deleteIssuerCreateRequest(ctx context.Context, name string, _ *DeleteIssuerOptions) (*policy.Request, error) {
	host := "{vaultBaseUrl}"
	host = strings.ReplaceAll(host, "{vaultBaseUrl}", client.vaultBaseUrl)
	urlPath := "/certificates/issuers/{issuer-name}"
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{issuer-name}", url.PathEscape(name))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.6")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// deleteIssuerHandleResponse handles the DeleteIssuer response.
func (client *Client) deleteIssuerHandleResponse(resp *http.Response) (DeleteIssuerResponse, error) {
	result := DeleteIssuerResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Issuer); err != nil {
		return DeleteIssuerResponse{}, err
	}
	return result, nil
}

// GetCertificate - Gets information about a certificate.
//
// Gets information about a specific certificate. This operation requires the certificates/get permission.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 7.6
//   - name - The name of the certificate in the given vault.
//   - version - The version of the certificate. This URI fragment is optional. If not specified, the latest version of the certificate
//     is returned.
//   - options - GetCertificateOptions contains the optional parameters for the Client.GetCertificate method.
func (client *Client) GetCertificate(ctx context.Context, name string, version string, options *GetCertificateOptions) (GetCertificateResponse, error) {
	var err error
	const operationName = "Client.GetCertificate"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCertificateCreateRequest(ctx, name, version, options)
	if err != nil {
		return GetCertificateResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return GetCertificateResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return GetCertificateResponse{}, err
	}
	resp, err := client.getCertificateHandleResponse(httpResp)
	return resp, err
}

// getCertificateCreateRequest creates the GetCertificate request.
func (client *Client) getCertificateCreateRequest(ctx context.Context, name string, version string, _ *GetCertificateOptions) (*policy.Request, error) {
	host := "{vaultBaseUrl}"
	host = strings.ReplaceAll(host, "{vaultBaseUrl}", client.vaultBaseUrl)
	urlPath := "/certificates/{certificate-name}/{certificate-version}"
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{certificate-name}", url.PathEscape(name))
	urlPath = strings.ReplaceAll(urlPath, "{certificate-version}", url.PathEscape(version))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.6")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getCertificateHandleResponse handles the GetCertificate response.
func (client *Client) getCertificateHandleResponse(resp *http.Response) (GetCertificateResponse, error) {
	result := GetCertificateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Certificate); err != nil {
		return GetCertificateResponse{}, err
	}
	return result, nil
}

// GetCertificateOperation - Gets the creation operation of a certificate.
//
// Gets the creation operation associated with a specified certificate. This operation requires the certificates/get permission.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 7.6
//   - name - The name of the certificate.
//   - options - GetCertificateOperationOptions contains the optional parameters for the Client.GetCertificateOperation method.
func (client *Client) GetCertificateOperation(ctx context.Context, name string, options *GetCertificateOperationOptions) (GetCertificateOperationResponse, error) {
	var err error
	const operationName = "Client.GetCertificateOperation"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCertificateOperationCreateRequest(ctx, name, options)
	if err != nil {
		return GetCertificateOperationResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return GetCertificateOperationResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return GetCertificateOperationResponse{}, err
	}
	resp, err := client.getCertificateOperationHandleResponse(httpResp)
	return resp, err
}

// getCertificateOperationCreateRequest creates the GetCertificateOperation request.
func (client *Client) getCertificateOperationCreateRequest(ctx context.Context, name string, _ *GetCertificateOperationOptions) (*policy.Request, error) {
	host := "{vaultBaseUrl}"
	host = strings.ReplaceAll(host, "{vaultBaseUrl}", client.vaultBaseUrl)
	urlPath := "/certificates/{certificate-name}/pending"
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{certificate-name}", url.PathEscape(name))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.6")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getCertificateOperationHandleResponse handles the GetCertificateOperation response.
func (client *Client) getCertificateOperationHandleResponse(resp *http.Response) (GetCertificateOperationResponse, error) {
	result := GetCertificateOperationResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.CertificateOperation); err != nil {
		return GetCertificateOperationResponse{}, err
	}
	return result, nil
}

// GetCertificatePolicy - Lists the policy for a certificate.
//
// The GetCertificatePolicy operation returns the specified certificate policy resources in the specified key vault. This
// operation requires the certificates/get permission.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 7.6
//   - name - The name of the certificate in a given key vault.
//   - options - GetCertificatePolicyOptions contains the optional parameters for the Client.GetCertificatePolicy method.
func (client *Client) GetCertificatePolicy(ctx context.Context, name string, options *GetCertificatePolicyOptions) (GetCertificatePolicyResponse, error) {
	var err error
	const operationName = "Client.GetCertificatePolicy"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCertificatePolicyCreateRequest(ctx, name, options)
	if err != nil {
		return GetCertificatePolicyResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return GetCertificatePolicyResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return GetCertificatePolicyResponse{}, err
	}
	resp, err := client.getCertificatePolicyHandleResponse(httpResp)
	return resp, err
}

// getCertificatePolicyCreateRequest creates the GetCertificatePolicy request.
func (client *Client) getCertificatePolicyCreateRequest(ctx context.Context, name string, _ *GetCertificatePolicyOptions) (*policy.Request, error) {
	host := "{vaultBaseUrl}"
	host = strings.ReplaceAll(host, "{vaultBaseUrl}", client.vaultBaseUrl)
	urlPath := "/certificates/{certificate-name}/policy"
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{certificate-name}", url.PathEscape(name))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.6")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getCertificatePolicyHandleResponse handles the GetCertificatePolicy response.
func (client *Client) getCertificatePolicyHandleResponse(resp *http.Response) (GetCertificatePolicyResponse, error) {
	result := GetCertificatePolicyResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.CertificatePolicy); err != nil {
		return GetCertificatePolicyResponse{}, err
	}
	return result, nil
}

// GetContacts - Lists the certificate contacts for a specified key vault.
//
// The GetCertificateContacts operation returns the set of certificate contact resources in the specified key vault. This
// operation requires the certificates/managecontacts permission.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 7.6
//   - options - GetContactsOptions contains the optional parameters for the Client.GetContacts method.
func (client *Client) GetContacts(ctx context.Context, options *GetContactsOptions) (GetContactsResponse, error) {
	var err error
	const operationName = "Client.GetContacts"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getContactsCreateRequest(ctx, options)
	if err != nil {
		return GetContactsResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return GetContactsResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return GetContactsResponse{}, err
	}
	resp, err := client.getContactsHandleResponse(httpResp)
	return resp, err
}

// getContactsCreateRequest creates the GetContacts request.
func (client *Client) getContactsCreateRequest(ctx context.Context, _ *GetContactsOptions) (*policy.Request, error) {
	host := "{vaultBaseUrl}"
	host = strings.ReplaceAll(host, "{vaultBaseUrl}", client.vaultBaseUrl)
	urlPath := "/certificates/contacts"
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.6")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getContactsHandleResponse handles the GetContacts response.
func (client *Client) getContactsHandleResponse(resp *http.Response) (GetContactsResponse, error) {
	result := GetContactsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Contacts); err != nil {
		return GetContactsResponse{}, err
	}
	return result, nil
}

// GetDeletedCertificate - Retrieves information about the specified deleted certificate.
//
// The GetDeletedCertificate operation retrieves the deleted certificate information plus its attributes, such as retention
// interval, scheduled permanent deletion and the current deletion recovery level. This operation requires the certificates/get
// permission.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 7.6
//   - name - The name of the certificate
//   - options - GetDeletedCertificateOptions contains the optional parameters for the Client.GetDeletedCertificate method.
func (client *Client) GetDeletedCertificate(ctx context.Context, name string, options *GetDeletedCertificateOptions) (GetDeletedCertificateResponse, error) {
	var err error
	const operationName = "Client.GetDeletedCertificate"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getDeletedCertificateCreateRequest(ctx, name, options)
	if err != nil {
		return GetDeletedCertificateResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return GetDeletedCertificateResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return GetDeletedCertificateResponse{}, err
	}
	resp, err := client.getDeletedCertificateHandleResponse(httpResp)
	return resp, err
}

// getDeletedCertificateCreateRequest creates the GetDeletedCertificate request.
func (client *Client) getDeletedCertificateCreateRequest(ctx context.Context, name string, _ *GetDeletedCertificateOptions) (*policy.Request, error) {
	host := "{vaultBaseUrl}"
	host = strings.ReplaceAll(host, "{vaultBaseUrl}", client.vaultBaseUrl)
	urlPath := "/deletedcertificates/{certificate-name}"
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{certificate-name}", url.PathEscape(name))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.6")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getDeletedCertificateHandleResponse handles the GetDeletedCertificate response.
func (client *Client) getDeletedCertificateHandleResponse(resp *http.Response) (GetDeletedCertificateResponse, error) {
	result := GetDeletedCertificateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DeletedCertificate); err != nil {
		return GetDeletedCertificateResponse{}, err
	}
	return result, nil
}

// GetIssuer - Lists the specified certificate issuer.
//
// The GetCertificateIssuer operation returns the specified certificate issuer resources in the specified key vault. This
// operation requires the certificates/manageissuers/getissuers permission.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 7.6
//   - name - The name of the issuer.
//   - options - GetIssuerOptions contains the optional parameters for the Client.GetIssuer method.
func (client *Client) GetIssuer(ctx context.Context, name string, options *GetIssuerOptions) (GetIssuerResponse, error) {
	var err error
	const operationName = "Client.GetIssuer"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getIssuerCreateRequest(ctx, name, options)
	if err != nil {
		return GetIssuerResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return GetIssuerResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return GetIssuerResponse{}, err
	}
	resp, err := client.getIssuerHandleResponse(httpResp)
	return resp, err
}

// getIssuerCreateRequest creates the GetIssuer request.
func (client *Client) getIssuerCreateRequest(ctx context.Context, name string, _ *GetIssuerOptions) (*policy.Request, error) {
	host := "{vaultBaseUrl}"
	host = strings.ReplaceAll(host, "{vaultBaseUrl}", client.vaultBaseUrl)
	urlPath := "/certificates/issuers/{issuer-name}"
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{issuer-name}", url.PathEscape(name))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.6")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getIssuerHandleResponse handles the GetIssuer response.
func (client *Client) getIssuerHandleResponse(resp *http.Response) (GetIssuerResponse, error) {
	result := GetIssuerResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Issuer); err != nil {
		return GetIssuerResponse{}, err
	}
	return result, nil
}

// ImportCertificate - Imports a certificate into a specified key vault.
//
// Imports an existing valid certificate, containing a private key, into Azure Key Vault. This operation requires the certificates/import
// permission. The certificate to be imported can be in either PFX or PEM format. If the certificate is in PEM format the
// PEM file must contain the key as well as x509 certificates. Key Vault will only accept a key in PKCS#8 format.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 7.6
//   - name - The name of the certificate. The value you provide may be copied globally for the purpose of running the service.
//     The value provided should not include personally identifiable or sensitive information.
//   - parameters - The parameters to import the certificate.
//   - options - ImportCertificateOptions contains the optional parameters for the Client.ImportCertificate method.
func (client *Client) ImportCertificate(ctx context.Context, name string, parameters ImportCertificateParameters, options *ImportCertificateOptions) (ImportCertificateResponse, error) {
	var err error
	const operationName = "Client.ImportCertificate"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.importCertificateCreateRequest(ctx, name, parameters, options)
	if err != nil {
		return ImportCertificateResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ImportCertificateResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ImportCertificateResponse{}, err
	}
	resp, err := client.importCertificateHandleResponse(httpResp)
	return resp, err
}

// importCertificateCreateRequest creates the ImportCertificate request.
func (client *Client) importCertificateCreateRequest(ctx context.Context, name string, parameters ImportCertificateParameters, _ *ImportCertificateOptions) (*policy.Request, error) {
	host := "{vaultBaseUrl}"
	host = strings.ReplaceAll(host, "{vaultBaseUrl}", client.vaultBaseUrl)
	urlPath := "/certificates/{certificate-name}/import"
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{certificate-name}", url.PathEscape(name))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.6")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	req.Raw().Header["Content-Type"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, parameters); err != nil {
		return nil, err
	}
	return req, nil
}

// importCertificateHandleResponse handles the ImportCertificate response.
func (client *Client) importCertificateHandleResponse(resp *http.Response) (ImportCertificateResponse, error) {
	result := ImportCertificateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Certificate); err != nil {
		return ImportCertificateResponse{}, err
	}
	return result, nil
}

// NewListCertificatePropertiesPager - List certificates in a specified key vault
//
// The GetCertificates operation returns the set of certificates resources in the specified key vault. This operation requires
// the certificates/list permission.
//
// Generated from API version 7.6
//   - options - ListCertificatePropertiesOptions contains the optional parameters for the Client.NewListCertificatePropertiesPager
//     method.
func (client *Client) NewListCertificatePropertiesPager(options *ListCertificatePropertiesOptions) *runtime.Pager[ListCertificatePropertiesResponse] {
	return runtime.NewPager(runtime.PagingHandler[ListCertificatePropertiesResponse]{
		More: func(page ListCertificatePropertiesResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ListCertificatePropertiesResponse) (ListCertificatePropertiesResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "Client.NewListCertificatePropertiesPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listCertificatePropertiesCreateRequest(ctx, options)
			}, nil)
			if err != nil {
				return ListCertificatePropertiesResponse{}, err
			}
			return client.listCertificatePropertiesHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listCertificatePropertiesCreateRequest creates the ListCertificateProperties request.
func (client *Client) listCertificatePropertiesCreateRequest(ctx context.Context, options *ListCertificatePropertiesOptions) (*policy.Request, error) {
	host := "{vaultBaseUrl}"
	host = strings.ReplaceAll(host, "{vaultBaseUrl}", client.vaultBaseUrl)
	urlPath := "/certificates"
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.6")
	if options != nil && options.IncludePending != nil {
		reqQP.Set("includePending", strconv.FormatBool(*options.IncludePending))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listCertificatePropertiesHandleResponse handles the ListCertificateProperties response.
func (client *Client) listCertificatePropertiesHandleResponse(resp *http.Response) (ListCertificatePropertiesResponse, error) {
	result := ListCertificatePropertiesResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.CertificatePropertiesListResult); err != nil {
		return ListCertificatePropertiesResponse{}, err
	}
	return result, nil
}

// NewListCertificatePropertiesVersionsPager - List the versions of a certificate.
//
// The GetCertificateVersions operation returns the versions of a certificate in the specified key vault. This operation requires
// the certificates/list permission.
//
// Generated from API version 7.6
//   - name - The name of the certificate.
//   - options - ListCertificatePropertiesVersionsOptions contains the optional parameters for the Client.NewListCertificatePropertiesVersionsPager
//     method.
func (client *Client) NewListCertificatePropertiesVersionsPager(name string, options *ListCertificatePropertiesVersionsOptions) *runtime.Pager[ListCertificatePropertiesVersionsResponse] {
	return runtime.NewPager(runtime.PagingHandler[ListCertificatePropertiesVersionsResponse]{
		More: func(page ListCertificatePropertiesVersionsResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ListCertificatePropertiesVersionsResponse) (ListCertificatePropertiesVersionsResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "Client.NewListCertificatePropertiesVersionsPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listCertificatePropertiesVersionsCreateRequest(ctx, name, options)
			}, nil)
			if err != nil {
				return ListCertificatePropertiesVersionsResponse{}, err
			}
			return client.listCertificatePropertiesVersionsHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listCertificatePropertiesVersionsCreateRequest creates the ListCertificatePropertiesVersions request.
func (client *Client) listCertificatePropertiesVersionsCreateRequest(ctx context.Context, name string, _ *ListCertificatePropertiesVersionsOptions) (*policy.Request, error) {
	host := "{vaultBaseUrl}"
	host = strings.ReplaceAll(host, "{vaultBaseUrl}", client.vaultBaseUrl)
	urlPath := "/certificates/{certificate-name}/versions"
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{certificate-name}", url.PathEscape(name))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.6")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listCertificatePropertiesVersionsHandleResponse handles the ListCertificatePropertiesVersions response.
func (client *Client) listCertificatePropertiesVersionsHandleResponse(resp *http.Response) (ListCertificatePropertiesVersionsResponse, error) {
	result := ListCertificatePropertiesVersionsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.CertificatePropertiesListResult); err != nil {
		return ListCertificatePropertiesVersionsResponse{}, err
	}
	return result, nil
}

// NewListDeletedCertificatePropertiesPager - Lists the deleted certificates in the specified vault currently available for
// recovery.
//
// The GetDeletedCertificates operation retrieves the certificates in the current vault which are in a deleted state and ready
// for recovery or purging. This operation includes deletion-specific information. This operation requires the certificates/get/list
// permission. This operation can only be enabled on soft-delete enabled vaults.
//
// Generated from API version 7.6
//   - options - ListDeletedCertificatePropertiesOptions contains the optional parameters for the Client.NewListDeletedCertificatePropertiesPager
//     method.
func (client *Client) NewListDeletedCertificatePropertiesPager(options *ListDeletedCertificatePropertiesOptions) *runtime.Pager[ListDeletedCertificatePropertiesResponse] {
	return runtime.NewPager(runtime.PagingHandler[ListDeletedCertificatePropertiesResponse]{
		More: func(page ListDeletedCertificatePropertiesResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ListDeletedCertificatePropertiesResponse) (ListDeletedCertificatePropertiesResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "Client.NewListDeletedCertificatePropertiesPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listDeletedCertificatePropertiesCreateRequest(ctx, options)
			}, nil)
			if err != nil {
				return ListDeletedCertificatePropertiesResponse{}, err
			}
			return client.listDeletedCertificatePropertiesHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listDeletedCertificatePropertiesCreateRequest creates the ListDeletedCertificateProperties request.
func (client *Client) listDeletedCertificatePropertiesCreateRequest(ctx context.Context, options *ListDeletedCertificatePropertiesOptions) (*policy.Request, error) {
	host := "{vaultBaseUrl}"
	host = strings.ReplaceAll(host, "{vaultBaseUrl}", client.vaultBaseUrl)
	urlPath := "/deletedcertificates"
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.6")
	if options != nil && options.IncludePending != nil {
		reqQP.Set("includePending", strconv.FormatBool(*options.IncludePending))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listDeletedCertificatePropertiesHandleResponse handles the ListDeletedCertificateProperties response.
func (client *Client) listDeletedCertificatePropertiesHandleResponse(resp *http.Response) (ListDeletedCertificatePropertiesResponse, error) {
	result := ListDeletedCertificatePropertiesResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DeletedCertificatePropertiesListResult); err != nil {
		return ListDeletedCertificatePropertiesResponse{}, err
	}
	return result, nil
}

// NewListIssuerPropertiesPager - List certificate issuers for a specified key vault.
//
// The GetCertificateIssuers operation returns the set of certificate issuer resources in the specified key vault. This operation
// requires the certificates/manageissuers/getissuers permission.
//
// Generated from API version 7.6
//   - options - ListIssuerPropertiesOptions contains the optional parameters for the Client.NewListIssuerPropertiesPager method.
func (client *Client) NewListIssuerPropertiesPager(options *ListIssuerPropertiesOptions) *runtime.Pager[ListIssuerPropertiesResponse] {
	return runtime.NewPager(runtime.PagingHandler[ListIssuerPropertiesResponse]{
		More: func(page ListIssuerPropertiesResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ListIssuerPropertiesResponse) (ListIssuerPropertiesResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "Client.NewListIssuerPropertiesPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listIssuerPropertiesCreateRequest(ctx, options)
			}, nil)
			if err != nil {
				return ListIssuerPropertiesResponse{}, err
			}
			return client.listIssuerPropertiesHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listIssuerPropertiesCreateRequest creates the ListIssuerProperties request.
func (client *Client) listIssuerPropertiesCreateRequest(ctx context.Context, _ *ListIssuerPropertiesOptions) (*policy.Request, error) {
	host := "{vaultBaseUrl}"
	host = strings.ReplaceAll(host, "{vaultBaseUrl}", client.vaultBaseUrl)
	urlPath := "/certificates/issuers"
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.6")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listIssuerPropertiesHandleResponse handles the ListIssuerProperties response.
func (client *Client) listIssuerPropertiesHandleResponse(resp *http.Response) (ListIssuerPropertiesResponse, error) {
	result := ListIssuerPropertiesResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.IssuerPropertiesListResult); err != nil {
		return ListIssuerPropertiesResponse{}, err
	}
	return result, nil
}

// MergeCertificate - Merges a certificate or a certificate chain with a key pair existing on the server.
//
// The MergeCertificate operation performs the merging of a certificate or certificate chain with a key pair currently available
// in the service. This operation requires the certificates/create permission.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 7.6
//   - name - The name of the certificate.
//   - parameters - The parameters to merge certificate.
//   - options - MergeCertificateOptions contains the optional parameters for the Client.MergeCertificate method.
func (client *Client) MergeCertificate(ctx context.Context, name string, parameters MergeCertificateParameters, options *MergeCertificateOptions) (MergeCertificateResponse, error) {
	var err error
	const operationName = "Client.MergeCertificate"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.mergeCertificateCreateRequest(ctx, name, parameters, options)
	if err != nil {
		return MergeCertificateResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return MergeCertificateResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusCreated) {
		err = runtime.NewResponseError(httpResp)
		return MergeCertificateResponse{}, err
	}
	resp, err := client.mergeCertificateHandleResponse(httpResp)
	return resp, err
}

// mergeCertificateCreateRequest creates the MergeCertificate request.
func (client *Client) mergeCertificateCreateRequest(ctx context.Context, name string, parameters MergeCertificateParameters, _ *MergeCertificateOptions) (*policy.Request, error) {
	host := "{vaultBaseUrl}"
	host = strings.ReplaceAll(host, "{vaultBaseUrl}", client.vaultBaseUrl)
	urlPath := "/certificates/{certificate-name}/pending/merge"
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{certificate-name}", url.PathEscape(name))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.6")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	req.Raw().Header["Content-Type"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, parameters); err != nil {
		return nil, err
	}
	return req, nil
}

// mergeCertificateHandleResponse handles the MergeCertificate response.
func (client *Client) mergeCertificateHandleResponse(resp *http.Response) (MergeCertificateResponse, error) {
	result := MergeCertificateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Certificate); err != nil {
		return MergeCertificateResponse{}, err
	}
	return result, nil
}

// PurgeDeletedCertificate - Permanently deletes the specified deleted certificate.
//
// The PurgeDeletedCertificate operation performs an irreversible deletion of the specified certificate, without possibility
// for recovery. The operation is not available if the recovery level does not specify 'Purgeable'. This operation requires
// the certificate/purge permission.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 7.6
//   - name - The name of the certificate
//   - options - PurgeDeletedCertificateOptions contains the optional parameters for the Client.PurgeDeletedCertificate method.
func (client *Client) PurgeDeletedCertificate(ctx context.Context, name string, options *PurgeDeletedCertificateOptions) (PurgeDeletedCertificateResponse, error) {
	var err error
	const operationName = "Client.PurgeDeletedCertificate"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.purgeDeletedCertificateCreateRequest(ctx, name, options)
	if err != nil {
		return PurgeDeletedCertificateResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return PurgeDeletedCertificateResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return PurgeDeletedCertificateResponse{}, err
	}
	return PurgeDeletedCertificateResponse{}, nil
}

// purgeDeletedCertificateCreateRequest creates the PurgeDeletedCertificate request.
func (client *Client) purgeDeletedCertificateCreateRequest(ctx context.Context, name string, _ *PurgeDeletedCertificateOptions) (*policy.Request, error) {
	host := "{vaultBaseUrl}"
	host = strings.ReplaceAll(host, "{vaultBaseUrl}", client.vaultBaseUrl)
	urlPath := "/deletedcertificates/{certificate-name}"
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{certificate-name}", url.PathEscape(name))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.6")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// RecoverDeletedCertificate - Recovers the deleted certificate back to its current version under /certificates.
//
// The RecoverDeletedCertificate operation performs the reversal of the Delete operation. The operation is applicable in vaults
// enabled for soft-delete, and must be issued during the retention interval (available in the deleted certificate's attributes).
// This operation requires the certificates/recover permission.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 7.6
//   - name - The name of the deleted certificate
//   - options - RecoverDeletedCertificateOptions contains the optional parameters for the Client.RecoverDeletedCertificate method.
func (client *Client) RecoverDeletedCertificate(ctx context.Context, name string, options *RecoverDeletedCertificateOptions) (RecoverDeletedCertificateResponse, error) {
	var err error
	const operationName = "Client.RecoverDeletedCertificate"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.recoverDeletedCertificateCreateRequest(ctx, name, options)
	if err != nil {
		return RecoverDeletedCertificateResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return RecoverDeletedCertificateResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return RecoverDeletedCertificateResponse{}, err
	}
	resp, err := client.recoverDeletedCertificateHandleResponse(httpResp)
	return resp, err
}

// recoverDeletedCertificateCreateRequest creates the RecoverDeletedCertificate request.
func (client *Client) recoverDeletedCertificateCreateRequest(ctx context.Context, name string, _ *RecoverDeletedCertificateOptions) (*policy.Request, error) {
	host := "{vaultBaseUrl}"
	host = strings.ReplaceAll(host, "{vaultBaseUrl}", client.vaultBaseUrl)
	urlPath := "/deletedcertificates/{certificate-name}/recover"
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{certificate-name}", url.PathEscape(name))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.6")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// recoverDeletedCertificateHandleResponse handles the RecoverDeletedCertificate response.
func (client *Client) recoverDeletedCertificateHandleResponse(resp *http.Response) (RecoverDeletedCertificateResponse, error) {
	result := RecoverDeletedCertificateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Certificate); err != nil {
		return RecoverDeletedCertificateResponse{}, err
	}
	return result, nil
}

// RestoreCertificate - Restores a backed up certificate to a vault.
//
// Restores a backed up certificate, and all its versions, to a vault. This operation requires the certificates/restore permission.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 7.6
//   - parameters - The parameters to restore the certificate.
//   - options - RestoreCertificateOptions contains the optional parameters for the Client.RestoreCertificate method.
func (client *Client) RestoreCertificate(ctx context.Context, parameters RestoreCertificateParameters, options *RestoreCertificateOptions) (RestoreCertificateResponse, error) {
	var err error
	const operationName = "Client.RestoreCertificate"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.restoreCertificateCreateRequest(ctx, parameters, options)
	if err != nil {
		return RestoreCertificateResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return RestoreCertificateResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return RestoreCertificateResponse{}, err
	}
	resp, err := client.restoreCertificateHandleResponse(httpResp)
	return resp, err
}

// restoreCertificateCreateRequest creates the RestoreCertificate request.
func (client *Client) restoreCertificateCreateRequest(ctx context.Context, parameters RestoreCertificateParameters, _ *RestoreCertificateOptions) (*policy.Request, error) {
	host := "{vaultBaseUrl}"
	host = strings.ReplaceAll(host, "{vaultBaseUrl}", client.vaultBaseUrl)
	urlPath := "/certificates/restore"
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.6")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	req.Raw().Header["Content-Type"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, parameters); err != nil {
		return nil, err
	}
	return req, nil
}

// restoreCertificateHandleResponse handles the RestoreCertificate response.
func (client *Client) restoreCertificateHandleResponse(resp *http.Response) (RestoreCertificateResponse, error) {
	result := RestoreCertificateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Certificate); err != nil {
		return RestoreCertificateResponse{}, err
	}
	return result, nil
}

// SetContacts - Sets the certificate contacts for the specified key vault.
//
// Sets the certificate contacts for the specified key vault. This operation requires the certificates/managecontacts permission.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 7.6
//   - contacts - The contacts for the key vault certificate.
//   - options - SetContactsOptions contains the optional parameters for the Client.SetContacts method.
func (client *Client) SetContacts(ctx context.Context, contacts Contacts, options *SetContactsOptions) (SetContactsResponse, error) {
	var err error
	const operationName = "Client.SetContacts"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.setContactsCreateRequest(ctx, contacts, options)
	if err != nil {
		return SetContactsResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return SetContactsResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return SetContactsResponse{}, err
	}
	resp, err := client.setContactsHandleResponse(httpResp)
	return resp, err
}

// setContactsCreateRequest creates the SetContacts request.
func (client *Client) setContactsCreateRequest(ctx context.Context, contacts Contacts, _ *SetContactsOptions) (*policy.Request, error) {
	host := "{vaultBaseUrl}"
	host = strings.ReplaceAll(host, "{vaultBaseUrl}", client.vaultBaseUrl)
	urlPath := "/certificates/contacts"
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.6")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	req.Raw().Header["Content-Type"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, contacts); err != nil {
		return nil, err
	}
	return req, nil
}

// setContactsHandleResponse handles the SetContacts response.
func (client *Client) setContactsHandleResponse(resp *http.Response) (SetContactsResponse, error) {
	result := SetContactsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Contacts); err != nil {
		return SetContactsResponse{}, err
	}
	return result, nil
}

// SetIssuer - Sets the specified certificate issuer.
//
// The SetCertificateIssuer operation adds or updates the specified certificate issuer. This operation requires the certificates/setissuers
// permission.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 7.6
//   - name - The name of the issuer. The value you provide may be copied globally for the purpose of running the service. The
//     value provided should not include personally identifiable or sensitive information.
//   - parameter - Certificate issuer set parameter.
//   - options - SetIssuerOptions contains the optional parameters for the Client.SetIssuer method.
func (client *Client) SetIssuer(ctx context.Context, name string, parameter SetIssuerParameters, options *SetIssuerOptions) (SetIssuerResponse, error) {
	var err error
	const operationName = "Client.SetIssuer"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.setIssuerCreateRequest(ctx, name, parameter, options)
	if err != nil {
		return SetIssuerResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return SetIssuerResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return SetIssuerResponse{}, err
	}
	resp, err := client.setIssuerHandleResponse(httpResp)
	return resp, err
}

// setIssuerCreateRequest creates the SetIssuer request.
func (client *Client) setIssuerCreateRequest(ctx context.Context, name string, parameter SetIssuerParameters, _ *SetIssuerOptions) (*policy.Request, error) {
	host := "{vaultBaseUrl}"
	host = strings.ReplaceAll(host, "{vaultBaseUrl}", client.vaultBaseUrl)
	urlPath := "/certificates/issuers/{issuer-name}"
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{issuer-name}", url.PathEscape(name))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.6")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	req.Raw().Header["Content-Type"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, parameter); err != nil {
		return nil, err
	}
	return req, nil
}

// setIssuerHandleResponse handles the SetIssuer response.
func (client *Client) setIssuerHandleResponse(resp *http.Response) (SetIssuerResponse, error) {
	result := SetIssuerResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Issuer); err != nil {
		return SetIssuerResponse{}, err
	}
	return result, nil
}

// UpdateCertificate - Updates the specified attributes associated with the given certificate.
//
// The UpdateCertificate operation applies the specified update on the given certificate; the only elements updated are the
// certificate's attributes. This operation requires the certificates/update permission.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 7.6
//   - name - The name of the certificate in the given key vault.
//   - version - The version of the certificate.
//   - parameters - The parameters for certificate update.
//   - options - UpdateCertificateOptions contains the optional parameters for the Client.UpdateCertificate method.
func (client *Client) UpdateCertificate(ctx context.Context, name string, version string, parameters UpdateCertificateParameters, options *UpdateCertificateOptions) (UpdateCertificateResponse, error) {
	var err error
	const operationName = "Client.UpdateCertificate"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.updateCertificateCreateRequest(ctx, name, version, parameters, options)
	if err != nil {
		return UpdateCertificateResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return UpdateCertificateResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return UpdateCertificateResponse{}, err
	}
	resp, err := client.updateCertificateHandleResponse(httpResp)
	return resp, err
}

// updateCertificateCreateRequest creates the UpdateCertificate request.
func (client *Client) updateCertificateCreateRequest(ctx context.Context, name string, version string, parameters UpdateCertificateParameters, _ *UpdateCertificateOptions) (*policy.Request, error) {
	host := "{vaultBaseUrl}"
	host = strings.ReplaceAll(host, "{vaultBaseUrl}", client.vaultBaseUrl)
	urlPath := "/certificates/{certificate-name}/{certificate-version}"
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{certificate-name}", url.PathEscape(name))
	urlPath = strings.ReplaceAll(urlPath, "{certificate-version}", url.PathEscape(version))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.6")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	req.Raw().Header["Content-Type"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, parameters); err != nil {
		return nil, err
	}
	return req, nil
}

// updateCertificateHandleResponse handles the UpdateCertificate response.
func (client *Client) updateCertificateHandleResponse(resp *http.Response) (UpdateCertificateResponse, error) {
	result := UpdateCertificateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Certificate); err != nil {
		return UpdateCertificateResponse{}, err
	}
	return result, nil
}

// UpdateCertificateOperation - Updates a certificate operation.
//
// Updates a certificate creation operation that is already in progress. This operation requires the certificates/update permission.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 7.6
//   - name - The name of the certificate.
//   - certificateOperation - The certificate operation response.
//   - options - UpdateCertificateOperationOptions contains the optional parameters for the Client.UpdateCertificateOperation
//     method.
func (client *Client) UpdateCertificateOperation(ctx context.Context, name string, certificateOperation UpdateCertificateOperationParameter, options *UpdateCertificateOperationOptions) (UpdateCertificateOperationResponse, error) {
	var err error
	const operationName = "Client.UpdateCertificateOperation"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.updateCertificateOperationCreateRequest(ctx, name, certificateOperation, options)
	if err != nil {
		return UpdateCertificateOperationResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return UpdateCertificateOperationResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return UpdateCertificateOperationResponse{}, err
	}
	resp, err := client.updateCertificateOperationHandleResponse(httpResp)
	return resp, err
}

// updateCertificateOperationCreateRequest creates the UpdateCertificateOperation request.
func (client *Client) updateCertificateOperationCreateRequest(ctx context.Context, name string, certificateOperation UpdateCertificateOperationParameter, _ *UpdateCertificateOperationOptions) (*policy.Request, error) {
	host := "{vaultBaseUrl}"
	host = strings.ReplaceAll(host, "{vaultBaseUrl}", client.vaultBaseUrl)
	urlPath := "/certificates/{certificate-name}/pending"
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{certificate-name}", url.PathEscape(name))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.6")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	req.Raw().Header["Content-Type"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, certificateOperation); err != nil {
		return nil, err
	}
	return req, nil
}

// updateCertificateOperationHandleResponse handles the UpdateCertificateOperation response.
func (client *Client) updateCertificateOperationHandleResponse(resp *http.Response) (UpdateCertificateOperationResponse, error) {
	result := UpdateCertificateOperationResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.CertificateOperation); err != nil {
		return UpdateCertificateOperationResponse{}, err
	}
	return result, nil
}

// UpdateCertificatePolicy - Updates the policy for a certificate.
//
// Set specified members in the certificate policy. Leave others as null. This operation requires the certificates/update
// permission.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 7.6
//   - name - The name of the certificate in the given vault.
//   - certificatePolicy - The policy for the certificate.
//   - options - UpdateCertificatePolicyOptions contains the optional parameters for the Client.UpdateCertificatePolicy method.
func (client *Client) UpdateCertificatePolicy(ctx context.Context, name string, certificatePolicy CertificatePolicy, options *UpdateCertificatePolicyOptions) (UpdateCertificatePolicyResponse, error) {
	var err error
	const operationName = "Client.UpdateCertificatePolicy"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.updateCertificatePolicyCreateRequest(ctx, name, certificatePolicy, options)
	if err != nil {
		return UpdateCertificatePolicyResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return UpdateCertificatePolicyResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return UpdateCertificatePolicyResponse{}, err
	}
	resp, err := client.updateCertificatePolicyHandleResponse(httpResp)
	return resp, err
}

// updateCertificatePolicyCreateRequest creates the UpdateCertificatePolicy request.
func (client *Client) updateCertificatePolicyCreateRequest(ctx context.Context, name string, certificatePolicy CertificatePolicy, _ *UpdateCertificatePolicyOptions) (*policy.Request, error) {
	host := "{vaultBaseUrl}"
	host = strings.ReplaceAll(host, "{vaultBaseUrl}", client.vaultBaseUrl)
	urlPath := "/certificates/{certificate-name}/policy"
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{certificate-name}", url.PathEscape(name))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.6")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	req.Raw().Header["Content-Type"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, certificatePolicy); err != nil {
		return nil, err
	}
	return req, nil
}

// updateCertificatePolicyHandleResponse handles the UpdateCertificatePolicy response.
func (client *Client) updateCertificatePolicyHandleResponse(resp *http.Response) (UpdateCertificatePolicyResponse, error) {
	result := UpdateCertificatePolicyResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.CertificatePolicy); err != nil {
		return UpdateCertificatePolicyResponse{}, err
	}
	return result, nil
}

// UpdateIssuer - Updates the specified certificate issuer.
//
// The UpdateCertificateIssuer operation performs an update on the specified certificate issuer entity. This operation requires
// the certificates/setissuers permission.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 7.6
//   - name - The name of the issuer.
//   - parameter - Certificate issuer update parameter.
//   - options - UpdateIssuerOptions contains the optional parameters for the Client.UpdateIssuer method.
func (client *Client) UpdateIssuer(ctx context.Context, name string, parameter UpdateIssuerParameters, options *UpdateIssuerOptions) (UpdateIssuerResponse, error) {
	var err error
	const operationName = "Client.UpdateIssuer"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.updateIssuerCreateRequest(ctx, name, parameter, options)
	if err != nil {
		return UpdateIssuerResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return UpdateIssuerResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return UpdateIssuerResponse{}, err
	}
	resp, err := client.updateIssuerHandleResponse(httpResp)
	return resp, err
}

// updateIssuerCreateRequest creates the UpdateIssuer request.
func (client *Client) updateIssuerCreateRequest(ctx context.Context, name string, parameter UpdateIssuerParameters, _ *UpdateIssuerOptions) (*policy.Request, error) {
	host := "{vaultBaseUrl}"
	host = strings.ReplaceAll(host, "{vaultBaseUrl}", client.vaultBaseUrl)
	urlPath := "/certificates/issuers/{issuer-name}"
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{issuer-name}", url.PathEscape(name))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.6")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	req.Raw().Header["Content-Type"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, parameter); err != nil {
		return nil, err
	}
	return req, nil
}

// updateIssuerHandleResponse handles the UpdateIssuer response.
func (client *Client) updateIssuerHandleResponse(resp *http.Response) (UpdateIssuerResponse, error) {
	result := UpdateIssuerResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Issuer); err != nil {
		return UpdateIssuerResponse{}, err
	}
	return result, nil
}
