// This file is generated by kconfig_compiler_kf6 from spectacle.kcfg.
// All changes you do to this file will be lost.
#ifndef SETTINGS_H
#define SETTINGS_H

#include <kconfigskeleton.h>
#include <QCoreApplication>
#include <QDebug>
#include <qqmlintegration.h>

#include <QStandardPaths>
#include <CaptureModeModel.h>
#include <Gui/Annotations/AnnotationDocument.h>
#include <Platforms/VideoPlatform.h>
#include <Gui/SettingsDialog/SettingsUtils.h>
#include <KLocalizedString>

class QQmlEngine;
class QJSEngine;

class Settings : public KConfigSkeleton
{
  Q_OBJECT
  QML_ELEMENT
  QML_SINGLETON
  public:
    enum EnumLaunchAction { TakeRectangularScreenshot, TakeFullscreenScreenshot, UseLastUsedCapturemode, DoNotTakeScreenshot };
    Q_ENUM(EnumLaunchAction)
    enum EnumPrintKeyRunningAction { TakeNewScreenshot, StartNewInstance, FocusWindow };
    Q_ENUM(EnumPrintKeyRunningAction)
    enum EnumClipboardGroup { PostScreenshotDoNothing, PostScreenshotCopyImage, PostScreenshotCopyLocation };
    Q_ENUM(EnumClipboardGroup)
    enum EnumShowMagnifier { ShowMagnifierNever, ShowMagnifierAlways, ShowMagnifierShiftHeld };
    Q_ENUM(EnumShowMagnifier)
    enum EnumRememberSelectionRect { Never, Always, UntilClosed };
    Q_ENUM(EnumRememberSelectionRect)

    static Settings *self();
    static Settings *create(QQmlEngine *, QJSEngine *);
    ~Settings() override;

    /**
      Set What to do when Spectacle is launched
    */
    static
    void setLaunchAction( int v )
    {
      if (v != self()->mLaunchAction && !self()->isLaunchActionImmutable()) {
        self()->mLaunchAction = v;
        Q_EMIT self()->launchActionChanged();
      }
    }

    Q_PROPERTY(int launchAction READ launchAction WRITE setLaunchAction NOTIFY launchActionChanged)
    Q_PROPERTY(bool isLaunchActionImmutable READ isLaunchActionImmutable CONSTANT)
    Q_PROPERTY(int defaultLaunchActionValue READ defaultLaunchActionValue CONSTANT)
    /**
      Get What to do when Spectacle is launched
    */
    static
    int launchAction()
    {
      return self()->mLaunchAction;
    }

    /**
      Is What to do when Spectacle is launched Immutable
    */
    static
    bool isLaunchActionImmutable()
    {
      return self()->isImmutable( QStringLiteral( "launchAction" ) );
    }

    /**
      Get What to do when Spectacle is launched default value
    */
    static
    int defaultLaunchActionValue()
    {
        return defaultLaunchActionValue_helper();
    }

    /**
      Set What should happen if print key is pressed when Spectacle is already running
    */
    static
    void setPrintKeyRunningAction( int v )
    {
      if (v != self()->mPrintKeyRunningAction && !self()->isPrintKeyRunningActionImmutable()) {
        self()->mPrintKeyRunningAction = v;
        Q_EMIT self()->printKeyRunningActionChanged();
      }
    }

    Q_PROPERTY(int printKeyRunningAction READ printKeyRunningAction WRITE setPrintKeyRunningAction NOTIFY printKeyRunningActionChanged)
    Q_PROPERTY(bool isPrintKeyRunningActionImmutable READ isPrintKeyRunningActionImmutable CONSTANT)
    Q_PROPERTY(int defaultPrintKeyRunningActionValue READ defaultPrintKeyRunningActionValue CONSTANT)
    /**
      Get What should happen if print key is pressed when Spectacle is already running
    */
    static
    int printKeyRunningAction()
    {
      return self()->mPrintKeyRunningAction;
    }

    /**
      Is What should happen if print key is pressed when Spectacle is already running Immutable
    */
    static
    bool isPrintKeyRunningActionImmutable()
    {
      return self()->isImmutable( QStringLiteral( "printKeyRunningAction" ) );
    }

    /**
      Get What should happen if print key is pressed when Spectacle is already running default value
    */
    static
    int defaultPrintKeyRunningActionValue()
    {
        return defaultPrintKeyRunningActionValue_helper();
    }

    /**
      Set Save screenshot automatically after it is taken
    */
    static
    void setAutoSaveImage( bool v )
    {
      if (v != self()->mAutoSaveImage && !self()->isAutoSaveImageImmutable()) {
        self()->mAutoSaveImage = v;
        Q_EMIT self()->autoSaveImageChanged();
      }
    }

    Q_PROPERTY(bool autoSaveImage READ autoSaveImage WRITE setAutoSaveImage NOTIFY autoSaveImageChanged)
    Q_PROPERTY(bool isAutoSaveImageImmutable READ isAutoSaveImageImmutable CONSTANT)
    Q_PROPERTY(bool defaultAutoSaveImageValue READ defaultAutoSaveImageValue CONSTANT)
    /**
      Get Save screenshot automatically after it is taken
    */
    static
    bool autoSaveImage()
    {
      return self()->mAutoSaveImage;
    }

    /**
      Is Save screenshot automatically after it is taken Immutable
    */
    static
    bool isAutoSaveImageImmutable()
    {
      return self()->isImmutable( QStringLiteral( "autoSaveImage" ) );
    }

    /**
      Get Save screenshot automatically after it is taken default value
    */
    static
    bool defaultAutoSaveImageValue()
    {
        return defaultAutoSaveImageValue_helper();
    }

    /**
      Set Clipboard action which should be executed after the screenshot is taken
    */
    static
    void setClipboardGroup( int v )
    {
      if (v != self()->mClipboardGroup && !self()->isClipboardGroupImmutable()) {
        self()->mClipboardGroup = v;
        Q_EMIT self()->clipboardGroupChanged();
      }
    }

    Q_PROPERTY(int clipboardGroup READ clipboardGroup WRITE setClipboardGroup NOTIFY clipboardGroupChanged)
    Q_PROPERTY(bool isClipboardGroupImmutable READ isClipboardGroupImmutable CONSTANT)
    Q_PROPERTY(int defaultClipboardGroupValue READ defaultClipboardGroupValue CONSTANT)
    /**
      Get Clipboard action which should be executed after the screenshot is taken
    */
    static
    int clipboardGroup()
    {
      return self()->mClipboardGroup;
    }

    /**
      Is Clipboard action which should be executed after the screenshot is taken Immutable
    */
    static
    bool isClipboardGroupImmutable()
    {
      return self()->isImmutable( QStringLiteral( "clipboardGroup" ) );
    }

    /**
      Get Clipboard action which should be executed after the screenshot is taken default value
    */
    static
    int defaultClipboardGroupValue()
    {
        return defaultClipboardGroupValue_helper();
    }

    /**
      Set Whether to use a light color mask in the region selection dialog
    */
    static
    void setUseLightMaskColor( bool v )
    {
      if (v != self()->mUseLightMaskColor && !self()->isUseLightMaskColorImmutable()) {
        self()->mUseLightMaskColor = v;
        Q_EMIT self()->useLightMaskColorChanged();
      }
    }

    Q_PROPERTY(bool useLightMaskColor READ useLightMaskColor WRITE setUseLightMaskColor NOTIFY useLightMaskColorChanged)
    Q_PROPERTY(bool isUseLightMaskColorImmutable READ isUseLightMaskColorImmutable CONSTANT)
    Q_PROPERTY(bool defaultUseLightMaskColorValue READ defaultUseLightMaskColorValue CONSTANT)
    /**
      Get Whether to use a light color mask in the region selection dialog
    */
    static
    bool useLightMaskColor()
    {
      return self()->mUseLightMaskColor;
    }

    /**
      Is Whether to use a light color mask in the region selection dialog Immutable
    */
    static
    bool isUseLightMaskColorImmutable()
    {
      return self()->isImmutable( QStringLiteral( "useLightMaskColor" ) );
    }

    /**
      Get Whether to use a light color mask in the region selection dialog default value
    */
    static
    bool defaultUseLightMaskColorValue()
    {
        return defaultUseLightMaskColorValue_helper();
    }

    /**
      Set Clipboard action which should be executed after the screenshot is taken
    */
    static
    void setShowMagnifier( int v )
    {
      if (v != self()->mShowMagnifier && !self()->isShowMagnifierImmutable()) {
        self()->mShowMagnifier = v;
        Q_EMIT self()->showMagnifierChanged();
      }
    }

    Q_PROPERTY(int showMagnifier READ showMagnifier WRITE setShowMagnifier NOTIFY showMagnifierChanged)
    Q_PROPERTY(bool isShowMagnifierImmutable READ isShowMagnifierImmutable CONSTANT)
    Q_PROPERTY(int defaultShowMagnifierValue READ defaultShowMagnifierValue CONSTANT)
    /**
      Get Clipboard action which should be executed after the screenshot is taken
    */
    static
    int showMagnifier()
    {
      return self()->mShowMagnifier;
    }

    /**
      Is Clipboard action which should be executed after the screenshot is taken Immutable
    */
    static
    bool isShowMagnifierImmutable()
    {
      return self()->isImmutable( QStringLiteral( "showMagnifier" ) );
    }

    /**
      Get Clipboard action which should be executed after the screenshot is taken default value
    */
    static
    int defaultShowMagnifierValue()
    {
        return defaultShowMagnifierValue_helper();
    }

    /**
      Set Whether the screenshot should be captured after selecting the region and releasing the mouse
    */
    static
    void setUseReleaseToCapture( bool v )
    {
      if (v != self()->mUseReleaseToCapture && !self()->isUseReleaseToCaptureImmutable()) {
        self()->mUseReleaseToCapture = v;
        Q_EMIT self()->useReleaseToCaptureChanged();
      }
    }

    Q_PROPERTY(bool useReleaseToCapture READ useReleaseToCapture WRITE setUseReleaseToCapture NOTIFY useReleaseToCaptureChanged)
    Q_PROPERTY(bool isUseReleaseToCaptureImmutable READ isUseReleaseToCaptureImmutable CONSTANT)
    Q_PROPERTY(bool defaultUseReleaseToCaptureValue READ defaultUseReleaseToCaptureValue CONSTANT)
    /**
      Get Whether the screenshot should be captured after selecting the region and releasing the mouse
    */
    static
    bool useReleaseToCapture()
    {
      return self()->mUseReleaseToCapture;
    }

    /**
      Is Whether the screenshot should be captured after selecting the region and releasing the mouse Immutable
    */
    static
    bool isUseReleaseToCaptureImmutable()
    {
      return self()->isImmutable( QStringLiteral( "useReleaseToCapture" ) );
    }

    /**
      Get Whether the screenshot should be captured after selecting the region and releasing the mouse default value
    */
    static
    bool defaultUseReleaseToCaptureValue()
    {
        return defaultUseReleaseToCaptureValue_helper();
    }

    /**
      Set Remember the last rectangular region
    */
    static
    void setRememberSelectionRect( int v )
    {
      if (v != self()->mRememberSelectionRect && !self()->isRememberSelectionRectImmutable()) {
        self()->mRememberSelectionRect = v;
        Q_EMIT self()->rememberSelectionRectChanged();
      }
    }

    Q_PROPERTY(int rememberSelectionRect READ rememberSelectionRect WRITE setRememberSelectionRect NOTIFY rememberSelectionRectChanged)
    Q_PROPERTY(bool isRememberSelectionRectImmutable READ isRememberSelectionRectImmutable CONSTANT)
    Q_PROPERTY(int defaultRememberSelectionRectValue READ defaultRememberSelectionRectValue CONSTANT)
    /**
      Get Remember the last rectangular region
    */
    static
    int rememberSelectionRect()
    {
      return self()->mRememberSelectionRect;
    }

    /**
      Is Remember the last rectangular region Immutable
    */
    static
    bool isRememberSelectionRectImmutable()
    {
      return self()->isImmutable( QStringLiteral( "rememberSelectionRect" ) );
    }

    /**
      Get Remember the last rectangular region default value
    */
    static
    int defaultRememberSelectionRectValue()
    {
        return defaultRememberSelectionRectValue_helper();
    }

    /**
      Set The last used region the user selected
    */
    static
    void setSelectionRect( const QRectF & v )
    {
      if (v != self()->mSelectionRect && !self()->isSelectionRectImmutable()) {
        self()->mSelectionRect = v;
        Q_EMIT self()->selectionRectChanged();
      }
    }

    Q_PROPERTY(QRectF selectionRect READ selectionRect WRITE setSelectionRect NOTIFY selectionRectChanged)
    Q_PROPERTY(bool isSelectionRectImmutable READ isSelectionRectImmutable CONSTANT)
    Q_PROPERTY(QRectF defaultSelectionRectValue READ defaultSelectionRectValue CONSTANT)
    /**
      Get The last used region the user selected
    */
    static
    QRectF selectionRect()
    {
      return self()->mSelectionRect;
    }

    /**
      Is The last used region the user selected Immutable
    */
    static
    bool isSelectionRectImmutable()
    {
      return self()->isImmutable( QStringLiteral( "selectionRect" ) );
    }

    /**
      Get The last used region the user selected default value
    */
    static
    QRectF defaultSelectionRectValue()
    {
        return defaultSelectionRectValue_helper();
    }

    /**
      Set Take screenshot on click
    */
    static
    void setCaptureOnClick( bool v )
    {
      if (v != self()->mCaptureOnClick && !self()->isCaptureOnClickImmutable()) {
        self()->mCaptureOnClick = v;
        Q_EMIT self()->captureOnClickChanged();
      }
    }

    Q_PROPERTY(bool captureOnClick READ captureOnClick WRITE setCaptureOnClick NOTIFY captureOnClickChanged)
    Q_PROPERTY(bool isCaptureOnClickImmutable READ isCaptureOnClickImmutable CONSTANT)
    Q_PROPERTY(bool defaultCaptureOnClickValue READ defaultCaptureOnClickValue CONSTANT)
    /**
      Get Take screenshot on click
    */
    static
    bool captureOnClick()
    {
      return self()->mCaptureOnClick;
    }

    /**
      Is Take screenshot on click Immutable
    */
    static
    bool isCaptureOnClickImmutable()
    {
      return self()->isImmutable( QStringLiteral( "captureOnClick" ) );
    }

    /**
      Get Take screenshot on click default value
    */
    static
    bool defaultCaptureOnClickValue()
    {
        return defaultCaptureOnClickValue_helper();
    }

    /**
      Set Whether the mouse cursor is included in the screenshot
    */
    static
    void setIncludePointer( bool v )
    {
      if (v != self()->mIncludePointer && !self()->isIncludePointerImmutable()) {
        self()->mIncludePointer = v;
        Q_EMIT self()->includePointerChanged();
      }
    }

    Q_PROPERTY(bool includePointer READ includePointer WRITE setIncludePointer NOTIFY includePointerChanged)
    Q_PROPERTY(bool isIncludePointerImmutable READ isIncludePointerImmutable CONSTANT)
    Q_PROPERTY(bool defaultIncludePointerValue READ defaultIncludePointerValue CONSTANT)
    /**
      Get Whether the mouse cursor is included in the screenshot
    */
    static
    bool includePointer()
    {
      return self()->mIncludePointer;
    }

    /**
      Is Whether the mouse cursor is included in the screenshot Immutable
    */
    static
    bool isIncludePointerImmutable()
    {
      return self()->isImmutable( QStringLiteral( "includePointer" ) );
    }

    /**
      Get Whether the mouse cursor is included in the screenshot default value
    */
    static
    bool defaultIncludePointerValue()
    {
        return defaultIncludePointerValue_helper();
    }

    /**
      Set Whether the mouse cursor is included in the video
    */
    static
    void setVideoIncludePointer( bool v )
    {
      if (v != self()->mVideoIncludePointer && !self()->isVideoIncludePointerImmutable()) {
        self()->mVideoIncludePointer = v;
        Q_EMIT self()->videoIncludePointerChanged();
      }
    }

    Q_PROPERTY(bool videoIncludePointer READ videoIncludePointer WRITE setVideoIncludePointer NOTIFY videoIncludePointerChanged)
    Q_PROPERTY(bool isVideoIncludePointerImmutable READ isVideoIncludePointerImmutable CONSTANT)
    Q_PROPERTY(bool defaultVideoIncludePointerValue READ defaultVideoIncludePointerValue CONSTANT)
    /**
      Get Whether the mouse cursor is included in the video
    */
    static
    bool videoIncludePointer()
    {
      return self()->mVideoIncludePointer;
    }

    /**
      Is Whether the mouse cursor is included in the video Immutable
    */
    static
    bool isVideoIncludePointerImmutable()
    {
      return self()->isImmutable( QStringLiteral( "videoIncludePointer" ) );
    }

    /**
      Get Whether the mouse cursor is included in the video default value
    */
    static
    bool defaultVideoIncludePointerValue()
    {
        return defaultVideoIncludePointerValue_helper();
    }

    /**
      Set Whether the window decorations are included in the screenshot
    */
    static
    void setIncludeDecorations( bool v )
    {
      if (v != self()->mIncludeDecorations && !self()->isIncludeDecorationsImmutable()) {
        self()->mIncludeDecorations = v;
        Q_EMIT self()->includeDecorationsChanged();
      }
    }

    Q_PROPERTY(bool includeDecorations READ includeDecorations WRITE setIncludeDecorations NOTIFY includeDecorationsChanged)
    Q_PROPERTY(bool isIncludeDecorationsImmutable READ isIncludeDecorationsImmutable CONSTANT)
    Q_PROPERTY(bool defaultIncludeDecorationsValue READ defaultIncludeDecorationsValue CONSTANT)
    /**
      Get Whether the window decorations are included in the screenshot
    */
    static
    bool includeDecorations()
    {
      return self()->mIncludeDecorations;
    }

    /**
      Is Whether the window decorations are included in the screenshot Immutable
    */
    static
    bool isIncludeDecorationsImmutable()
    {
      return self()->isImmutable( QStringLiteral( "includeDecorations" ) );
    }

    /**
      Get Whether the window decorations are included in the screenshot default value
    */
    static
    bool defaultIncludeDecorationsValue()
    {
        return defaultIncludeDecorationsValue_helper();
    }

    /**
      Set Whether the window shadow is included in the screenshot
    */
    static
    void setIncludeShadow( bool v )
    {
      if (v != self()->mIncludeShadow && !self()->isIncludeShadowImmutable()) {
        self()->mIncludeShadow = v;
        Q_EMIT self()->includeShadowChanged();
      }
    }

    Q_PROPERTY(bool includeShadow READ includeShadow WRITE setIncludeShadow NOTIFY includeShadowChanged)
    Q_PROPERTY(bool isIncludeShadowImmutable READ isIncludeShadowImmutable CONSTANT)
    Q_PROPERTY(bool defaultIncludeShadowValue READ defaultIncludeShadowValue CONSTANT)
    /**
      Get Whether the window shadow is included in the screenshot
    */
    static
    bool includeShadow()
    {
      return self()->mIncludeShadow;
    }

    /**
      Is Whether the window shadow is included in the screenshot Immutable
    */
    static
    bool isIncludeShadowImmutable()
    {
      return self()->isImmutable( QStringLiteral( "includeShadow" ) );
    }

    /**
      Get Whether the window shadow is included in the screenshot default value
    */
    static
    bool defaultIncludeShadowValue()
    {
        return defaultIncludeShadowValue_helper();
    }

    /**
      Set Only capture the current pop up menu
    */
    static
    void setTransientOnly( bool v )
    {
      if (v != self()->mTransientOnly && !self()->isTransientOnlyImmutable()) {
        self()->mTransientOnly = v;
        Q_EMIT self()->transientOnlyChanged();
      }
    }

    Q_PROPERTY(bool transientOnly READ transientOnly WRITE setTransientOnly NOTIFY transientOnlyChanged)
    Q_PROPERTY(bool isTransientOnlyImmutable READ isTransientOnlyImmutable CONSTANT)
    Q_PROPERTY(bool defaultTransientOnlyValue READ defaultTransientOnlyValue CONSTANT)
    /**
      Get Only capture the current pop up menu
    */
    static
    bool transientOnly()
    {
      return self()->mTransientOnly;
    }

    /**
      Is Only capture the current pop up menu Immutable
    */
    static
    bool isTransientOnlyImmutable()
    {
      return self()->isImmutable( QStringLiteral( "transientOnly" ) );
    }

    /**
      Get Only capture the current pop up menu default value
    */
    static
    bool defaultTransientOnlyValue()
    {
        return defaultTransientOnlyValue_helper();
    }

    /**
      Set Quit after saving or copying an image
    */
    static
    void setQuitAfterSaveCopyExport( bool v )
    {
      if (v != self()->mQuitAfterSaveCopyExport && !self()->isQuitAfterSaveCopyExportImmutable()) {
        self()->mQuitAfterSaveCopyExport = v;
        Q_EMIT self()->quitAfterSaveCopyExportChanged();
      }
    }

    Q_PROPERTY(bool quitAfterSaveCopyExport READ quitAfterSaveCopyExport WRITE setQuitAfterSaveCopyExport NOTIFY quitAfterSaveCopyExportChanged)
    Q_PROPERTY(bool isQuitAfterSaveCopyExportImmutable READ isQuitAfterSaveCopyExportImmutable CONSTANT)
    Q_PROPERTY(bool defaultQuitAfterSaveCopyExportValue READ defaultQuitAfterSaveCopyExportValue CONSTANT)
    /**
      Get Quit after saving or copying an image
    */
    static
    bool quitAfterSaveCopyExport()
    {
      return self()->mQuitAfterSaveCopyExport;
    }

    /**
      Is Quit after saving or copying an image Immutable
    */
    static
    bool isQuitAfterSaveCopyExportImmutable()
    {
      return self()->isImmutable( QStringLiteral( "quitAfterSaveCopyExport" ) );
    }

    /**
      Get Quit after saving or copying an image default value
    */
    static
    bool defaultQuitAfterSaveCopyExportValue()
    {
        return defaultQuitAfterSaveCopyExportValue_helper();
    }

    /**
      Set Delay
    */
    static
    void setCaptureDelay( double v )
    {
      if (v < 0)
      {
        qDebug() << "setCaptureDelay: value " << v << " is less than the minimum value of 0";
        v = 0;
      }
      if (v != self()->mCaptureDelay && !self()->isCaptureDelayImmutable()) {
        self()->mCaptureDelay = v;
        Q_EMIT self()->captureDelayChanged();
      }
    }

    Q_PROPERTY(double captureDelay READ captureDelay WRITE setCaptureDelay NOTIFY captureDelayChanged)
    Q_PROPERTY(bool isCaptureDelayImmutable READ isCaptureDelayImmutable CONSTANT)
    Q_PROPERTY(double defaultCaptureDelayValue READ defaultCaptureDelayValue CONSTANT)
    /**
      Get Delay
    */
    static
    double captureDelay()
    {
      return self()->mCaptureDelay;
    }

    /**
      Is Delay Immutable
    */
    static
    bool isCaptureDelayImmutable()
    {
      return self()->isImmutable( QStringLiteral( "captureDelay" ) );
    }

    /**
      Get Delay default value
    */
    static
    double defaultCaptureDelayValue()
    {
        return defaultCaptureDelayValue_helper();
    }

    /**
      Set captureMode
    */
    static
    void setCaptureMode( int v )
    {
      if (v != self()->mCaptureMode && !self()->isCaptureModeImmutable()) {
        self()->mCaptureMode = v;
        Q_EMIT self()->captureModeChanged();
      }
    }

    Q_PROPERTY(int captureMode READ captureMode WRITE setCaptureMode NOTIFY captureModeChanged)
    Q_PROPERTY(bool isCaptureModeImmutable READ isCaptureModeImmutable CONSTANT)
    Q_PROPERTY(int defaultCaptureModeValue READ defaultCaptureModeValue CONSTANT)
    /**
      Get captureMode
    */
    static
    int captureMode()
    {
      return self()->mCaptureMode;
    }

    /**
      Is captureMode Immutable
    */
    static
    bool isCaptureModeImmutable()
    {
      return self()->isImmutable( QStringLiteral( "captureMode" ) );
    }

    /**
      Get captureMode default value
    */
    static
    int defaultCaptureModeValue()
    {
        return defaultCaptureModeValue_helper();
    }

    /**
      Set Default filename
    */
    static
    void setImageSaveLocation( const QUrl & v )
    {
      if (v != self()->mImageSaveLocation && !self()->isImageSaveLocationImmutable()) {
        self()->mImageSaveLocation = v;
        Q_EMIT self()->imageSaveLocationChanged();
      }
    }

    Q_PROPERTY(QUrl imageSaveLocation READ imageSaveLocation WRITE setImageSaveLocation NOTIFY imageSaveLocationChanged)
    Q_PROPERTY(bool isImageSaveLocationImmutable READ isImageSaveLocationImmutable CONSTANT)
    Q_PROPERTY(QUrl defaultImageSaveLocationValue READ defaultImageSaveLocationValue CONSTANT)
    /**
      Get Default filename
    */
    static
    QUrl imageSaveLocation()
    {
      return self()->mImageSaveLocation;
    }

    /**
      Is Default filename Immutable
    */
    static
    bool isImageSaveLocationImmutable()
    {
      return self()->isImmutable( QStringLiteral( "imageSaveLocation" ) );
    }

    /**
      Get Default filename default value
    */
    static
    QUrl defaultImageSaveLocationValue()
    {
        return defaultImageSaveLocationValue_helper();
    }

    /**
      Set Compression quality for lossy file formats
    */
    static
    void setImageCompressionQuality( uint v )
    {

      if (v > 100)
      {
        qDebug() << "setImageCompressionQuality: value " << v << " is greater than the maximum value of 100";
        v = 100;
      }

      if (v != self()->mImageCompressionQuality && !self()->isImageCompressionQualityImmutable()) {
        self()->mImageCompressionQuality = v;
        Q_EMIT self()->imageCompressionQualityChanged();
      }
    }

    Q_PROPERTY(uint imageCompressionQuality READ imageCompressionQuality WRITE setImageCompressionQuality NOTIFY imageCompressionQualityChanged)
    Q_PROPERTY(bool isImageCompressionQualityImmutable READ isImageCompressionQualityImmutable CONSTANT)
    Q_PROPERTY(uint defaultImageCompressionQualityValue READ defaultImageCompressionQualityValue CONSTANT)
    /**
      Get Compression quality for lossy file formats
    */
    static
    uint imageCompressionQuality()
    {
      return self()->mImageCompressionQuality;
    }

    /**
      Is Compression quality for lossy file formats Immutable
    */
    static
    bool isImageCompressionQualityImmutable()
    {
      return self()->isImmutable( QStringLiteral( "imageCompressionQuality" ) );
    }

    /**
      Get Compression quality for lossy file formats default value
    */
    static
    uint defaultImageCompressionQualityValue()
    {
        return defaultImageCompressionQualityValue_helper();
    }

    /**
      Set Default save image format
    */
    static
    void setPreferredImageFormat( const QString & v )
    {
      if (v != self()->mPreferredImageFormat && !self()->isPreferredImageFormatImmutable()) {
        self()->mPreferredImageFormat = v;
        Q_EMIT self()->preferredImageFormatChanged();
      }
    }

    Q_PROPERTY(QString preferredImageFormat READ preferredImageFormat WRITE setPreferredImageFormat NOTIFY preferredImageFormatChanged)
    Q_PROPERTY(bool isPreferredImageFormatImmutable READ isPreferredImageFormatImmutable CONSTANT)
    Q_PROPERTY(QString defaultPreferredImageFormatValue READ defaultPreferredImageFormatValue CONSTANT)
    /**
      Get Default save image format
    */
    static
    QString preferredImageFormat()
    {
      return self()->mPreferredImageFormat;
    }

    /**
      Is Default save image format Immutable
    */
    static
    bool isPreferredImageFormatImmutable()
    {
      return self()->isImmutable( QStringLiteral( "preferredImageFormat" ) );
    }

    /**
      Get Default save image format default value
    */
    static
    QString defaultPreferredImageFormatValue()
    {
        return defaultPreferredImageFormatValue_helper();
    }

    /**
      Set The filename template used when saving screenshots
    */
    static
    void setImageFilenameTemplate( const QString & v )
    {
      if (v != self()->mImageFilenameTemplate && !self()->isImageFilenameTemplateImmutable()) {
        self()->mImageFilenameTemplate = v;
        Q_EMIT self()->imageFilenameTemplateChanged();
      }
    }

    Q_PROPERTY(QString imageFilenameTemplate READ imageFilenameTemplate WRITE setImageFilenameTemplate NOTIFY imageFilenameTemplateChanged)
    Q_PROPERTY(bool isImageFilenameTemplateImmutable READ isImageFilenameTemplateImmutable CONSTANT)
    Q_PROPERTY(QString defaultImageFilenameTemplateValue READ defaultImageFilenameTemplateValue CONSTANT)
    /**
      Get The filename template used when saving screenshots
    */
    static
    QString imageFilenameTemplate()
    {
      return self()->mImageFilenameTemplate;
    }

    /**
      Is The filename template used when saving screenshots Immutable
    */
    static
    bool isImageFilenameTemplateImmutable()
    {
      return self()->isImmutable( QStringLiteral( "imageFilenameTemplate" ) );
    }

    /**
      Get The filename template used when saving screenshots default value
    */
    static
    QString defaultImageFilenameTemplateValue()
    {
        return defaultImageFilenameTemplateValue_helper();
    }

    /**
      Set The path of the file saved last
    */
    static
    void setLastImageSaveLocation( const QUrl & v )
    {
      if (v != self()->mLastImageSaveLocation && !self()->isLastImageSaveLocationImmutable()) {
        self()->mLastImageSaveLocation = v;
        Q_EMIT self()->lastImageSaveLocationChanged();
      }
    }

    Q_PROPERTY(QUrl lastImageSaveLocation READ lastImageSaveLocation WRITE setLastImageSaveLocation NOTIFY lastImageSaveLocationChanged)
    Q_PROPERTY(bool isLastImageSaveLocationImmutable READ isLastImageSaveLocationImmutable CONSTANT)
    Q_PROPERTY(QUrl defaultLastImageSaveLocationValue READ defaultLastImageSaveLocationValue CONSTANT)
    /**
      Get The path of the file saved last
    */
    static
    QUrl lastImageSaveLocation()
    {
      return self()->mLastImageSaveLocation;
    }

    /**
      Is The path of the file saved last Immutable
    */
    static
    bool isLastImageSaveLocationImmutable()
    {
      return self()->isImmutable( QStringLiteral( "lastImageSaveLocation" ) );
    }

    /**
      Get The path of the file saved last default value
    */
    static
    QUrl defaultLastImageSaveLocationValue()
    {
        return defaultLastImageSaveLocationValue_helper();
    }

    /**
      Set Last path used for "save as" action
    */
    static
    void setLastImageSaveAsLocation( const QUrl & v )
    {
      if (v != self()->mLastImageSaveAsLocation && !self()->isLastImageSaveAsLocationImmutable()) {
        self()->mLastImageSaveAsLocation = v;
        Q_EMIT self()->lastImageSaveAsLocationChanged();
      }
    }

    Q_PROPERTY(QUrl lastImageSaveAsLocation READ lastImageSaveAsLocation WRITE setLastImageSaveAsLocation NOTIFY lastImageSaveAsLocationChanged)
    Q_PROPERTY(bool isLastImageSaveAsLocationImmutable READ isLastImageSaveAsLocationImmutable CONSTANT)
    Q_PROPERTY(QUrl defaultLastImageSaveAsLocationValue READ defaultLastImageSaveAsLocationValue CONSTANT)
    /**
      Get Last path used for "save as" action
    */
    static
    QUrl lastImageSaveAsLocation()
    {
      return self()->mLastImageSaveAsLocation;
    }

    /**
      Is Last path used for "save as" action Immutable
    */
    static
    bool isLastImageSaveAsLocationImmutable()
    {
      return self()->isImmutable( QStringLiteral( "lastImageSaveAsLocation" ) );
    }

    /**
      Get Last path used for "save as" action default value
    */
    static
    QUrl defaultLastImageSaveAsLocationValue()
    {
        return defaultLastImageSaveAsLocationValue_helper();
    }

    /**
      Set Default filename
    */
    static
    void setVideoSaveLocation( const QUrl & v )
    {
      if (v != self()->mVideoSaveLocation && !self()->isVideoSaveLocationImmutable()) {
        self()->mVideoSaveLocation = v;
        Q_EMIT self()->videoSaveLocationChanged();
      }
    }

    Q_PROPERTY(QUrl videoSaveLocation READ videoSaveLocation WRITE setVideoSaveLocation NOTIFY videoSaveLocationChanged)
    Q_PROPERTY(bool isVideoSaveLocationImmutable READ isVideoSaveLocationImmutable CONSTANT)
    Q_PROPERTY(QUrl defaultVideoSaveLocationValue READ defaultVideoSaveLocationValue CONSTANT)
    /**
      Get Default filename
    */
    static
    QUrl videoSaveLocation()
    {
      return self()->mVideoSaveLocation;
    }

    /**
      Is Default filename Immutable
    */
    static
    bool isVideoSaveLocationImmutable()
    {
      return self()->isImmutable( QStringLiteral( "videoSaveLocation" ) );
    }

    /**
      Get Default filename default value
    */
    static
    QUrl defaultVideoSaveLocationValue()
    {
        return defaultVideoSaveLocationValue_helper();
    }

    /**
      Set Default video format
    */
    static
    void setPreferredVideoFormat( int v )
    {
      if (v != self()->mPreferredVideoFormat && !self()->isPreferredVideoFormatImmutable()) {
        self()->mPreferredVideoFormat = v;
        Q_EMIT self()->preferredVideoFormatChanged();
      }
    }

    Q_PROPERTY(int preferredVideoFormat READ preferredVideoFormat WRITE setPreferredVideoFormat NOTIFY preferredVideoFormatChanged)
    Q_PROPERTY(bool isPreferredVideoFormatImmutable READ isPreferredVideoFormatImmutable CONSTANT)
    Q_PROPERTY(int defaultPreferredVideoFormatValue READ defaultPreferredVideoFormatValue CONSTANT)
    /**
      Get Default video format
    */
    static
    int preferredVideoFormat()
    {
      return self()->mPreferredVideoFormat;
    }

    /**
      Is Default video format Immutable
    */
    static
    bool isPreferredVideoFormatImmutable()
    {
      return self()->isImmutable( QStringLiteral( "preferredVideoFormat" ) );
    }

    /**
      Get Default video format default value
    */
    static
    int defaultPreferredVideoFormatValue()
    {
        return defaultPreferredVideoFormatValue_helper();
    }

    /**
      Set The filename template used when saving screencasts
    */
    static
    void setVideoFilenameTemplate( const QString & v )
    {
      if (v != self()->mVideoFilenameTemplate && !self()->isVideoFilenameTemplateImmutable()) {
        self()->mVideoFilenameTemplate = v;
        Q_EMIT self()->videoFilenameTemplateChanged();
      }
    }

    Q_PROPERTY(QString videoFilenameTemplate READ videoFilenameTemplate WRITE setVideoFilenameTemplate NOTIFY videoFilenameTemplateChanged)
    Q_PROPERTY(bool isVideoFilenameTemplateImmutable READ isVideoFilenameTemplateImmutable CONSTANT)
    Q_PROPERTY(QString defaultVideoFilenameTemplateValue READ defaultVideoFilenameTemplateValue CONSTANT)
    /**
      Get The filename template used when saving screencasts
    */
    static
    QString videoFilenameTemplate()
    {
      return self()->mVideoFilenameTemplate;
    }

    /**
      Is The filename template used when saving screencasts Immutable
    */
    static
    bool isVideoFilenameTemplateImmutable()
    {
      return self()->isImmutable( QStringLiteral( "videoFilenameTemplate" ) );
    }

    /**
      Get The filename template used when saving screencasts default value
    */
    static
    QString defaultVideoFilenameTemplateValue()
    {
        return defaultVideoFilenameTemplateValue_helper();
    }

    /**
      Set The path of the file saved last
    */
    static
    void setLastVideoSaveLocation( const QUrl & v )
    {
      if (v != self()->mLastVideoSaveLocation && !self()->isLastVideoSaveLocationImmutable()) {
        self()->mLastVideoSaveLocation = v;
        Q_EMIT self()->lastVideoSaveLocationChanged();
      }
    }

    Q_PROPERTY(QUrl lastVideoSaveLocation READ lastVideoSaveLocation WRITE setLastVideoSaveLocation NOTIFY lastVideoSaveLocationChanged)
    Q_PROPERTY(bool isLastVideoSaveLocationImmutable READ isLastVideoSaveLocationImmutable CONSTANT)
    Q_PROPERTY(QUrl defaultLastVideoSaveLocationValue READ defaultLastVideoSaveLocationValue CONSTANT)
    /**
      Get The path of the file saved last
    */
    static
    QUrl lastVideoSaveLocation()
    {
      return self()->mLastVideoSaveLocation;
    }

    /**
      Is The path of the file saved last Immutable
    */
    static
    bool isLastVideoSaveLocationImmutable()
    {
      return self()->isImmutable( QStringLiteral( "lastVideoSaveLocation" ) );
    }

    /**
      Get The path of the file saved last default value
    */
    static
    QUrl defaultLastVideoSaveLocationValue()
    {
        return defaultLastVideoSaveLocationValue_helper();
    }

    /**
      Set Last path used for "save as" action
    */
    static
    void setLastVideoSaveAsLocation( const QUrl & v )
    {
      if (v != self()->mLastVideoSaveAsLocation && !self()->isLastVideoSaveAsLocationImmutable()) {
        self()->mLastVideoSaveAsLocation = v;
        Q_EMIT self()->lastVideoSaveAsLocationChanged();
      }
    }

    Q_PROPERTY(QUrl lastVideoSaveAsLocation READ lastVideoSaveAsLocation WRITE setLastVideoSaveAsLocation NOTIFY lastVideoSaveAsLocationChanged)
    Q_PROPERTY(bool isLastVideoSaveAsLocationImmutable READ isLastVideoSaveAsLocationImmutable CONSTANT)
    Q_PROPERTY(QUrl defaultLastVideoSaveAsLocationValue READ defaultLastVideoSaveAsLocationValue CONSTANT)
    /**
      Get Last path used for "save as" action
    */
    static
    QUrl lastVideoSaveAsLocation()
    {
      return self()->mLastVideoSaveAsLocation;
    }

    /**
      Is Last path used for "save as" action Immutable
    */
    static
    bool isLastVideoSaveAsLocationImmutable()
    {
      return self()->isImmutable( QStringLiteral( "lastVideoSaveAsLocation" ) );
    }

    /**
      Get Last path used for "save as" action default value
    */
    static
    QUrl defaultLastVideoSaveAsLocationValue()
    {
        return defaultLastVideoSaveAsLocationValue_helper();
    }

    /**
      Set The last used annotation tool type
    */
    static
    void setAnnotationToolType( int v )
    {
      if (v != self()->mAnnotationToolType && !self()->isAnnotationToolTypeImmutable()) {
        self()->mAnnotationToolType = v;
        Q_EMIT self()->annotationToolTypeChanged();
      }
    }

    Q_PROPERTY(int annotationToolType READ annotationToolType WRITE setAnnotationToolType NOTIFY annotationToolTypeChanged)
    Q_PROPERTY(bool isAnnotationToolTypeImmutable READ isAnnotationToolTypeImmutable CONSTANT)
    Q_PROPERTY(int defaultAnnotationToolTypeValue READ defaultAnnotationToolTypeValue CONSTANT)
    /**
      Get The last used annotation tool type
    */
    static
    int annotationToolType()
    {
      return self()->mAnnotationToolType;
    }

    /**
      Is The last used annotation tool type Immutable
    */
    static
    bool isAnnotationToolTypeImmutable()
    {
      return self()->isImmutable( QStringLiteral( "annotationToolType" ) );
    }

    /**
      Get The last used annotation tool type default value
    */
    static
    int defaultAnnotationToolTypeValue()
    {
        return defaultAnnotationToolTypeValue_helper();
    }

    /**
      Set Stroke width for freehand annotation tool
    */
    static
    void setFreehandStrokeWidth( uint v )
    {
      if (v < 1)
      {
        qDebug() << "setFreehandStrokeWidth: value " << v << " is less than the minimum value of 1";
        v = 1;
      }
      if (v != self()->mFreehandStrokeWidth && !self()->isFreehandStrokeWidthImmutable()) {
        self()->mFreehandStrokeWidth = v;
        Q_EMIT self()->freehandStrokeWidthChanged();
      }
    }

    Q_PROPERTY(uint freehandStrokeWidth READ freehandStrokeWidth WRITE setFreehandStrokeWidth NOTIFY freehandStrokeWidthChanged)
    Q_PROPERTY(bool isFreehandStrokeWidthImmutable READ isFreehandStrokeWidthImmutable CONSTANT)
    Q_PROPERTY(uint defaultFreehandStrokeWidthValue READ defaultFreehandStrokeWidthValue CONSTANT)
    /**
      Get Stroke width for freehand annotation tool
    */
    static
    uint freehandStrokeWidth()
    {
      return self()->mFreehandStrokeWidth;
    }

    /**
      Is Stroke width for freehand annotation tool Immutable
    */
    static
    bool isFreehandStrokeWidthImmutable()
    {
      return self()->isImmutable( QStringLiteral( "freehandStrokeWidth" ) );
    }

    /**
      Get Stroke width for freehand annotation tool default value
    */
    static
    uint defaultFreehandStrokeWidthValue()
    {
        return defaultFreehandStrokeWidthValue_helper();
    }

    /**
      Set Stroke width for highlighter annotation tool
    */
    static
    void setHighlighterStrokeWidth( uint v )
    {
      if (v < 1)
      {
        qDebug() << "setHighlighterStrokeWidth: value " << v << " is less than the minimum value of 1";
        v = 1;
      }
      if (v != self()->mHighlighterStrokeWidth && !self()->isHighlighterStrokeWidthImmutable()) {
        self()->mHighlighterStrokeWidth = v;
        Q_EMIT self()->highlighterStrokeWidthChanged();
      }
    }

    Q_PROPERTY(uint highlighterStrokeWidth READ highlighterStrokeWidth WRITE setHighlighterStrokeWidth NOTIFY highlighterStrokeWidthChanged)
    Q_PROPERTY(bool isHighlighterStrokeWidthImmutable READ isHighlighterStrokeWidthImmutable CONSTANT)
    Q_PROPERTY(uint defaultHighlighterStrokeWidthValue READ defaultHighlighterStrokeWidthValue CONSTANT)
    /**
      Get Stroke width for highlighter annotation tool
    */
    static
    uint highlighterStrokeWidth()
    {
      return self()->mHighlighterStrokeWidth;
    }

    /**
      Is Stroke width for highlighter annotation tool Immutable
    */
    static
    bool isHighlighterStrokeWidthImmutable()
    {
      return self()->isImmutable( QStringLiteral( "highlighterStrokeWidth" ) );
    }

    /**
      Get Stroke width for highlighter annotation tool default value
    */
    static
    uint defaultHighlighterStrokeWidthValue()
    {
        return defaultHighlighterStrokeWidthValue_helper();
    }

    /**
      Set Stroke width for line annotation tool
    */
    static
    void setLineStrokeWidth( uint v )
    {
      if (v < 1)
      {
        qDebug() << "setLineStrokeWidth: value " << v << " is less than the minimum value of 1";
        v = 1;
      }
      if (v != self()->mLineStrokeWidth && !self()->isLineStrokeWidthImmutable()) {
        self()->mLineStrokeWidth = v;
        Q_EMIT self()->lineStrokeWidthChanged();
      }
    }

    Q_PROPERTY(uint lineStrokeWidth READ lineStrokeWidth WRITE setLineStrokeWidth NOTIFY lineStrokeWidthChanged)
    Q_PROPERTY(bool isLineStrokeWidthImmutable READ isLineStrokeWidthImmutable CONSTANT)
    Q_PROPERTY(uint defaultLineStrokeWidthValue READ defaultLineStrokeWidthValue CONSTANT)
    /**
      Get Stroke width for line annotation tool
    */
    static
    uint lineStrokeWidth()
    {
      return self()->mLineStrokeWidth;
    }

    /**
      Is Stroke width for line annotation tool Immutable
    */
    static
    bool isLineStrokeWidthImmutable()
    {
      return self()->isImmutable( QStringLiteral( "lineStrokeWidth" ) );
    }

    /**
      Get Stroke width for line annotation tool default value
    */
    static
    uint defaultLineStrokeWidthValue()
    {
        return defaultLineStrokeWidthValue_helper();
    }

    /**
      Set Stroke width for arrow annotation tool
    */
    static
    void setArrowStrokeWidth( uint v )
    {
      if (v < 1)
      {
        qDebug() << "setArrowStrokeWidth: value " << v << " is less than the minimum value of 1";
        v = 1;
      }
      if (v != self()->mArrowStrokeWidth && !self()->isArrowStrokeWidthImmutable()) {
        self()->mArrowStrokeWidth = v;
        Q_EMIT self()->arrowStrokeWidthChanged();
      }
    }

    Q_PROPERTY(uint arrowStrokeWidth READ arrowStrokeWidth WRITE setArrowStrokeWidth NOTIFY arrowStrokeWidthChanged)
    Q_PROPERTY(bool isArrowStrokeWidthImmutable READ isArrowStrokeWidthImmutable CONSTANT)
    Q_PROPERTY(uint defaultArrowStrokeWidthValue READ defaultArrowStrokeWidthValue CONSTANT)
    /**
      Get Stroke width for arrow annotation tool
    */
    static
    uint arrowStrokeWidth()
    {
      return self()->mArrowStrokeWidth;
    }

    /**
      Is Stroke width for arrow annotation tool Immutable
    */
    static
    bool isArrowStrokeWidthImmutable()
    {
      return self()->isImmutable( QStringLiteral( "arrowStrokeWidth" ) );
    }

    /**
      Get Stroke width for arrow annotation tool default value
    */
    static
    uint defaultArrowStrokeWidthValue()
    {
        return defaultArrowStrokeWidthValue_helper();
    }

    /**
      Set Stroke width for rectangle annotation tool
    */
    static
    void setRectangleStrokeWidth( uint v )
    {
      if (v != self()->mRectangleStrokeWidth && !self()->isRectangleStrokeWidthImmutable()) {
        self()->mRectangleStrokeWidth = v;
        Q_EMIT self()->rectangleStrokeWidthChanged();
      }
    }

    Q_PROPERTY(uint rectangleStrokeWidth READ rectangleStrokeWidth WRITE setRectangleStrokeWidth NOTIFY rectangleStrokeWidthChanged)
    Q_PROPERTY(bool isRectangleStrokeWidthImmutable READ isRectangleStrokeWidthImmutable CONSTANT)
    Q_PROPERTY(uint defaultRectangleStrokeWidthValue READ defaultRectangleStrokeWidthValue CONSTANT)
    /**
      Get Stroke width for rectangle annotation tool
    */
    static
    uint rectangleStrokeWidth()
    {
      return self()->mRectangleStrokeWidth;
    }

    /**
      Is Stroke width for rectangle annotation tool Immutable
    */
    static
    bool isRectangleStrokeWidthImmutable()
    {
      return self()->isImmutable( QStringLiteral( "rectangleStrokeWidth" ) );
    }

    /**
      Get Stroke width for rectangle annotation tool default value
    */
    static
    uint defaultRectangleStrokeWidthValue()
    {
        return defaultRectangleStrokeWidthValue_helper();
    }

    /**
      Set Stroke width for ellipse annotation tool
    */
    static
    void setEllipseStrokeWidth( uint v )
    {
      if (v != self()->mEllipseStrokeWidth && !self()->isEllipseStrokeWidthImmutable()) {
        self()->mEllipseStrokeWidth = v;
        Q_EMIT self()->ellipseStrokeWidthChanged();
      }
    }

    Q_PROPERTY(uint ellipseStrokeWidth READ ellipseStrokeWidth WRITE setEllipseStrokeWidth NOTIFY ellipseStrokeWidthChanged)
    Q_PROPERTY(bool isEllipseStrokeWidthImmutable READ isEllipseStrokeWidthImmutable CONSTANT)
    Q_PROPERTY(uint defaultEllipseStrokeWidthValue READ defaultEllipseStrokeWidthValue CONSTANT)
    /**
      Get Stroke width for ellipse annotation tool
    */
    static
    uint ellipseStrokeWidth()
    {
      return self()->mEllipseStrokeWidth;
    }

    /**
      Is Stroke width for ellipse annotation tool Immutable
    */
    static
    bool isEllipseStrokeWidthImmutable()
    {
      return self()->isImmutable( QStringLiteral( "ellipseStrokeWidth" ) );
    }

    /**
      Get Stroke width for ellipse annotation tool default value
    */
    static
    uint defaultEllipseStrokeWidthValue()
    {
        return defaultEllipseStrokeWidthValue_helper();
    }

    /**
      Set Stroke color for freehand annotation tool
    */
    static
    void setFreehandStrokeColor( const QColor & v )
    {
      if (v != self()->mFreehandStrokeColor && !self()->isFreehandStrokeColorImmutable()) {
        self()->mFreehandStrokeColor = v;
        Q_EMIT self()->freehandStrokeColorChanged();
      }
    }

    Q_PROPERTY(QColor freehandStrokeColor READ freehandStrokeColor WRITE setFreehandStrokeColor NOTIFY freehandStrokeColorChanged)
    Q_PROPERTY(bool isFreehandStrokeColorImmutable READ isFreehandStrokeColorImmutable CONSTANT)
    Q_PROPERTY(QColor defaultFreehandStrokeColorValue READ defaultFreehandStrokeColorValue CONSTANT)
    /**
      Get Stroke color for freehand annotation tool
    */
    static
    QColor freehandStrokeColor()
    {
      return self()->mFreehandStrokeColor;
    }

    /**
      Is Stroke color for freehand annotation tool Immutable
    */
    static
    bool isFreehandStrokeColorImmutable()
    {
      return self()->isImmutable( QStringLiteral( "freehandStrokeColor" ) );
    }

    /**
      Get Stroke color for freehand annotation tool default value
    */
    static
    QColor defaultFreehandStrokeColorValue()
    {
        return defaultFreehandStrokeColorValue_helper();
    }

    /**
      Set Stroke color for highlighter annotation tool
    */
    static
    void setHighlighterStrokeColor( const QColor & v )
    {
      if (v != self()->mHighlighterStrokeColor && !self()->isHighlighterStrokeColorImmutable()) {
        self()->mHighlighterStrokeColor = v;
        Q_EMIT self()->highlighterStrokeColorChanged();
      }
    }

    Q_PROPERTY(QColor highlighterStrokeColor READ highlighterStrokeColor WRITE setHighlighterStrokeColor NOTIFY highlighterStrokeColorChanged)
    Q_PROPERTY(bool isHighlighterStrokeColorImmutable READ isHighlighterStrokeColorImmutable CONSTANT)
    Q_PROPERTY(QColor defaultHighlighterStrokeColorValue READ defaultHighlighterStrokeColorValue CONSTANT)
    /**
      Get Stroke color for highlighter annotation tool
    */
    static
    QColor highlighterStrokeColor()
    {
      return self()->mHighlighterStrokeColor;
    }

    /**
      Is Stroke color for highlighter annotation tool Immutable
    */
    static
    bool isHighlighterStrokeColorImmutable()
    {
      return self()->isImmutable( QStringLiteral( "highlighterStrokeColor" ) );
    }

    /**
      Get Stroke color for highlighter annotation tool default value
    */
    static
    QColor defaultHighlighterStrokeColorValue()
    {
        return defaultHighlighterStrokeColorValue_helper();
    }

    /**
      Set Stroke color for line annotation tool
    */
    static
    void setLineStrokeColor( const QColor & v )
    {
      if (v != self()->mLineStrokeColor && !self()->isLineStrokeColorImmutable()) {
        self()->mLineStrokeColor = v;
        Q_EMIT self()->lineStrokeColorChanged();
      }
    }

    Q_PROPERTY(QColor lineStrokeColor READ lineStrokeColor WRITE setLineStrokeColor NOTIFY lineStrokeColorChanged)
    Q_PROPERTY(bool isLineStrokeColorImmutable READ isLineStrokeColorImmutable CONSTANT)
    Q_PROPERTY(QColor defaultLineStrokeColorValue READ defaultLineStrokeColorValue CONSTANT)
    /**
      Get Stroke color for line annotation tool
    */
    static
    QColor lineStrokeColor()
    {
      return self()->mLineStrokeColor;
    }

    /**
      Is Stroke color for line annotation tool Immutable
    */
    static
    bool isLineStrokeColorImmutable()
    {
      return self()->isImmutable( QStringLiteral( "lineStrokeColor" ) );
    }

    /**
      Get Stroke color for line annotation tool default value
    */
    static
    QColor defaultLineStrokeColorValue()
    {
        return defaultLineStrokeColorValue_helper();
    }

    /**
      Set Stroke color for arrow annotation tool
    */
    static
    void setArrowStrokeColor( const QColor & v )
    {
      if (v != self()->mArrowStrokeColor && !self()->isArrowStrokeColorImmutable()) {
        self()->mArrowStrokeColor = v;
        Q_EMIT self()->arrowStrokeColorChanged();
      }
    }

    Q_PROPERTY(QColor arrowStrokeColor READ arrowStrokeColor WRITE setArrowStrokeColor NOTIFY arrowStrokeColorChanged)
    Q_PROPERTY(bool isArrowStrokeColorImmutable READ isArrowStrokeColorImmutable CONSTANT)
    Q_PROPERTY(QColor defaultArrowStrokeColorValue READ defaultArrowStrokeColorValue CONSTANT)
    /**
      Get Stroke color for arrow annotation tool
    */
    static
    QColor arrowStrokeColor()
    {
      return self()->mArrowStrokeColor;
    }

    /**
      Is Stroke color for arrow annotation tool Immutable
    */
    static
    bool isArrowStrokeColorImmutable()
    {
      return self()->isImmutable( QStringLiteral( "arrowStrokeColor" ) );
    }

    /**
      Get Stroke color for arrow annotation tool default value
    */
    static
    QColor defaultArrowStrokeColorValue()
    {
        return defaultArrowStrokeColorValue_helper();
    }

    /**
      Set Stroke color for rectangle annotation tool
    */
    static
    void setRectangleStrokeColor( const QColor & v )
    {
      if (v != self()->mRectangleStrokeColor && !self()->isRectangleStrokeColorImmutable()) {
        self()->mRectangleStrokeColor = v;
        Q_EMIT self()->rectangleStrokeColorChanged();
      }
    }

    Q_PROPERTY(QColor rectangleStrokeColor READ rectangleStrokeColor WRITE setRectangleStrokeColor NOTIFY rectangleStrokeColorChanged)
    Q_PROPERTY(bool isRectangleStrokeColorImmutable READ isRectangleStrokeColorImmutable CONSTANT)
    Q_PROPERTY(QColor defaultRectangleStrokeColorValue READ defaultRectangleStrokeColorValue CONSTANT)
    /**
      Get Stroke color for rectangle annotation tool
    */
    static
    QColor rectangleStrokeColor()
    {
      return self()->mRectangleStrokeColor;
    }

    /**
      Is Stroke color for rectangle annotation tool Immutable
    */
    static
    bool isRectangleStrokeColorImmutable()
    {
      return self()->isImmutable( QStringLiteral( "rectangleStrokeColor" ) );
    }

    /**
      Get Stroke color for rectangle annotation tool default value
    */
    static
    QColor defaultRectangleStrokeColorValue()
    {
        return defaultRectangleStrokeColorValue_helper();
    }

    /**
      Set Stroke color for ellipse annotation tool
    */
    static
    void setEllipseStrokeColor( const QColor & v )
    {
      if (v != self()->mEllipseStrokeColor && !self()->isEllipseStrokeColorImmutable()) {
        self()->mEllipseStrokeColor = v;
        Q_EMIT self()->ellipseStrokeColorChanged();
      }
    }

    Q_PROPERTY(QColor ellipseStrokeColor READ ellipseStrokeColor WRITE setEllipseStrokeColor NOTIFY ellipseStrokeColorChanged)
    Q_PROPERTY(bool isEllipseStrokeColorImmutable READ isEllipseStrokeColorImmutable CONSTANT)
    Q_PROPERTY(QColor defaultEllipseStrokeColorValue READ defaultEllipseStrokeColorValue CONSTANT)
    /**
      Get Stroke color for ellipse annotation tool
    */
    static
    QColor ellipseStrokeColor()
    {
      return self()->mEllipseStrokeColor;
    }

    /**
      Is Stroke color for ellipse annotation tool Immutable
    */
    static
    bool isEllipseStrokeColorImmutable()
    {
      return self()->isImmutable( QStringLiteral( "ellipseStrokeColor" ) );
    }

    /**
      Get Stroke color for ellipse annotation tool default value
    */
    static
    QColor defaultEllipseStrokeColorValue()
    {
        return defaultEllipseStrokeColorValue_helper();
    }

    /**
      Set Fill color for rectangle annotation tool
    */
    static
    void setRectangleFillColor( const QColor & v )
    {
      if (v != self()->mRectangleFillColor && !self()->isRectangleFillColorImmutable()) {
        self()->mRectangleFillColor = v;
        Q_EMIT self()->rectangleFillColorChanged();
      }
    }

    Q_PROPERTY(QColor rectangleFillColor READ rectangleFillColor WRITE setRectangleFillColor NOTIFY rectangleFillColorChanged)
    Q_PROPERTY(bool isRectangleFillColorImmutable READ isRectangleFillColorImmutable CONSTANT)
    Q_PROPERTY(QColor defaultRectangleFillColorValue READ defaultRectangleFillColorValue CONSTANT)
    /**
      Get Fill color for rectangle annotation tool
    */
    static
    QColor rectangleFillColor()
    {
      return self()->mRectangleFillColor;
    }

    /**
      Is Fill color for rectangle annotation tool Immutable
    */
    static
    bool isRectangleFillColorImmutable()
    {
      return self()->isImmutable( QStringLiteral( "rectangleFillColor" ) );
    }

    /**
      Get Fill color for rectangle annotation tool default value
    */
    static
    QColor defaultRectangleFillColorValue()
    {
        return defaultRectangleFillColorValue_helper();
    }

    /**
      Set Fill color for ellipse annotation tool
    */
    static
    void setEllipseFillColor( const QColor & v )
    {
      if (v != self()->mEllipseFillColor && !self()->isEllipseFillColorImmutable()) {
        self()->mEllipseFillColor = v;
        Q_EMIT self()->ellipseFillColorChanged();
      }
    }

    Q_PROPERTY(QColor ellipseFillColor READ ellipseFillColor WRITE setEllipseFillColor NOTIFY ellipseFillColorChanged)
    Q_PROPERTY(bool isEllipseFillColorImmutable READ isEllipseFillColorImmutable CONSTANT)
    Q_PROPERTY(QColor defaultEllipseFillColorValue READ defaultEllipseFillColorValue CONSTANT)
    /**
      Get Fill color for ellipse annotation tool
    */
    static
    QColor ellipseFillColor()
    {
      return self()->mEllipseFillColor;
    }

    /**
      Is Fill color for ellipse annotation tool Immutable
    */
    static
    bool isEllipseFillColorImmutable()
    {
      return self()->isImmutable( QStringLiteral( "ellipseFillColor" ) );
    }

    /**
      Get Fill color for ellipse annotation tool default value
    */
    static
    QColor defaultEllipseFillColorValue()
    {
        return defaultEllipseFillColorValue_helper();
    }

    /**
      Set Fill color for number annotation tool
    */
    static
    void setNumberFillColor( const QColor & v )
    {
      if (v != self()->mNumberFillColor && !self()->isNumberFillColorImmutable()) {
        self()->mNumberFillColor = v;
        Q_EMIT self()->numberFillColorChanged();
      }
    }

    Q_PROPERTY(QColor numberFillColor READ numberFillColor WRITE setNumberFillColor NOTIFY numberFillColorChanged)
    Q_PROPERTY(bool isNumberFillColorImmutable READ isNumberFillColorImmutable CONSTANT)
    Q_PROPERTY(QColor defaultNumberFillColorValue READ defaultNumberFillColorValue CONSTANT)
    /**
      Get Fill color for number annotation tool
    */
    static
    QColor numberFillColor()
    {
      return self()->mNumberFillColor;
    }

    /**
      Is Fill color for number annotation tool Immutable
    */
    static
    bool isNumberFillColorImmutable()
    {
      return self()->isImmutable( QStringLiteral( "numberFillColor" ) );
    }

    /**
      Get Fill color for number annotation tool default value
    */
    static
    QColor defaultNumberFillColorValue()
    {
        return defaultNumberFillColorValue_helper();
    }

    /**
      Set The strength of the blur effect.
    */
    static
    void setBlurStrength( double v )
    {
      if (v < 0)
      {
        qDebug() << "setBlurStrength: value " << v << " is less than the minimum value of 0";
        v = 0;
      }

      if (v > 1)
      {
        qDebug() << "setBlurStrength: value " << v << " is greater than the maximum value of 1";
        v = 1;
      }

      if (v != self()->mBlurStrength && !self()->isBlurStrengthImmutable()) {
        self()->mBlurStrength = v;
        Q_EMIT self()->blurStrengthChanged();
      }
    }

    Q_PROPERTY(double blurStrength READ blurStrength WRITE setBlurStrength NOTIFY blurStrengthChanged)
    Q_PROPERTY(bool isBlurStrengthImmutable READ isBlurStrengthImmutable CONSTANT)
    Q_PROPERTY(double defaultBlurStrengthValue READ defaultBlurStrengthValue CONSTANT)
    /**
      Get The strength of the blur effect.
    */
    static
    double blurStrength()
    {
      return self()->mBlurStrength;
    }

    /**
      Is The strength of the blur effect. Immutable
    */
    static
    bool isBlurStrengthImmutable()
    {
      return self()->isImmutable( QStringLiteral( "blurStrength" ) );
    }

    /**
      Get The strength of the blur effect. default value
    */
    static
    double defaultBlurStrengthValue()
    {
        return defaultBlurStrengthValue_helper();
    }

    /**
      Set The strength of the pixelate effect.
    */
    static
    void setPixelateStrength( double v )
    {
      if (v < 0)
      {
        qDebug() << "setPixelateStrength: value " << v << " is less than the minimum value of 0";
        v = 0;
      }

      if (v > 1)
      {
        qDebug() << "setPixelateStrength: value " << v << " is greater than the maximum value of 1";
        v = 1;
      }

      if (v != self()->mPixelateStrength && !self()->isPixelateStrengthImmutable()) {
        self()->mPixelateStrength = v;
        Q_EMIT self()->pixelateStrengthChanged();
      }
    }

    Q_PROPERTY(double pixelateStrength READ pixelateStrength WRITE setPixelateStrength NOTIFY pixelateStrengthChanged)
    Q_PROPERTY(bool isPixelateStrengthImmutable READ isPixelateStrengthImmutable CONSTANT)
    Q_PROPERTY(double defaultPixelateStrengthValue READ defaultPixelateStrengthValue CONSTANT)
    /**
      Get The strength of the pixelate effect.
    */
    static
    double pixelateStrength()
    {
      return self()->mPixelateStrength;
    }

    /**
      Is The strength of the pixelate effect. Immutable
    */
    static
    bool isPixelateStrengthImmutable()
    {
      return self()->isImmutable( QStringLiteral( "pixelateStrength" ) );
    }

    /**
      Get The strength of the pixelate effect. default value
    */
    static
    double defaultPixelateStrengthValue()
    {
        return defaultPixelateStrengthValue_helper();
    }

    /**
      Set Font for text annotations
    */
    static
    void setTextFont( const QFont & v )
    {
      if (v != self()->mTextFont && !self()->isTextFontImmutable()) {
        self()->mTextFont = v;
        Q_EMIT self()->textFontChanged();
      }
    }

    Q_PROPERTY(QFont textFont READ textFont WRITE setTextFont NOTIFY textFontChanged)
    Q_PROPERTY(bool isTextFontImmutable READ isTextFontImmutable CONSTANT)
    /**
      Get Font for text annotations
    */
    static
    QFont textFont()
    {
      return self()->mTextFont;
    }

    /**
      Is Font for text annotations Immutable
    */
    static
    bool isTextFontImmutable()
    {
      return self()->isImmutable( QStringLiteral( "textFont" ) );
    }

    /**
      Set Font for number annotations
    */
    static
    void setNumberFont( const QFont & v )
    {
      if (v != self()->mNumberFont && !self()->isNumberFontImmutable()) {
        self()->mNumberFont = v;
        Q_EMIT self()->numberFontChanged();
      }
    }

    Q_PROPERTY(QFont numberFont READ numberFont WRITE setNumberFont NOTIFY numberFontChanged)
    Q_PROPERTY(bool isNumberFontImmutable READ isNumberFontImmutable CONSTANT)
    /**
      Get Font for number annotations
    */
    static
    QFont numberFont()
    {
      return self()->mNumberFont;
    }

    /**
      Is Font for number annotations Immutable
    */
    static
    bool isNumberFontImmutable()
    {
      return self()->isImmutable( QStringLiteral( "numberFont" ) );
    }

    /**
      Set Font color for annotations
    */
    static
    void setTextFontColor( const QColor & v )
    {
      if (v != self()->mTextFontColor && !self()->isTextFontColorImmutable()) {
        self()->mTextFontColor = v;
        Q_EMIT self()->textFontColorChanged();
      }
    }

    Q_PROPERTY(QColor textFontColor READ textFontColor WRITE setTextFontColor NOTIFY textFontColorChanged)
    Q_PROPERTY(bool isTextFontColorImmutable READ isTextFontColorImmutable CONSTANT)
    Q_PROPERTY(QColor defaultTextFontColorValue READ defaultTextFontColorValue CONSTANT)
    /**
      Get Font color for annotations
    */
    static
    QColor textFontColor()
    {
      return self()->mTextFontColor;
    }

    /**
      Is Font color for annotations Immutable
    */
    static
    bool isTextFontColorImmutable()
    {
      return self()->isImmutable( QStringLiteral( "textFontColor" ) );
    }

    /**
      Get Font color for annotations default value
    */
    static
    QColor defaultTextFontColorValue()
    {
        return defaultTextFontColorValue_helper();
    }

    /**
      Set Font color for annotations
    */
    static
    void setNumberFontColor( const QColor & v )
    {
      if (v != self()->mNumberFontColor && !self()->isNumberFontColorImmutable()) {
        self()->mNumberFontColor = v;
        Q_EMIT self()->numberFontColorChanged();
      }
    }

    Q_PROPERTY(QColor numberFontColor READ numberFontColor WRITE setNumberFontColor NOTIFY numberFontColorChanged)
    Q_PROPERTY(bool isNumberFontColorImmutable READ isNumberFontColorImmutable CONSTANT)
    Q_PROPERTY(QColor defaultNumberFontColorValue READ defaultNumberFontColorValue CONSTANT)
    /**
      Get Font color for annotations
    */
    static
    QColor numberFontColor()
    {
      return self()->mNumberFontColor;
    }

    /**
      Is Font color for annotations Immutable
    */
    static
    bool isNumberFontColorImmutable()
    {
      return self()->isImmutable( QStringLiteral( "numberFontColor" ) );
    }

    /**
      Get Font color for annotations default value
    */
    static
    QColor defaultNumberFontColorValue()
    {
        return defaultNumberFontColorValue_helper();
    }

    /**
      Set Whether freehand annotation tool has a drop shadow
    */
    static
    void setFreehandShadow( bool v )
    {
      if (v != self()->mFreehandShadow && !self()->isFreehandShadowImmutable()) {
        self()->mFreehandShadow = v;
        Q_EMIT self()->freehandShadowChanged();
      }
    }

    Q_PROPERTY(bool freehandShadow READ freehandShadow WRITE setFreehandShadow NOTIFY freehandShadowChanged)
    Q_PROPERTY(bool isFreehandShadowImmutable READ isFreehandShadowImmutable CONSTANT)
    Q_PROPERTY(bool defaultFreehandShadowValue READ defaultFreehandShadowValue CONSTANT)
    /**
      Get Whether freehand annotation tool has a drop shadow
    */
    static
    bool freehandShadow()
    {
      return self()->mFreehandShadow;
    }

    /**
      Is Whether freehand annotation tool has a drop shadow Immutable
    */
    static
    bool isFreehandShadowImmutable()
    {
      return self()->isImmutable( QStringLiteral( "freehandShadow" ) );
    }

    /**
      Get Whether freehand annotation tool has a drop shadow default value
    */
    static
    bool defaultFreehandShadowValue()
    {
        return defaultFreehandShadowValue_helper();
    }

    /**
      Set Whether line annotation tool has a drop shadow
    */
    static
    void setLineShadow( bool v )
    {
      if (v != self()->mLineShadow && !self()->isLineShadowImmutable()) {
        self()->mLineShadow = v;
        Q_EMIT self()->lineShadowChanged();
      }
    }

    Q_PROPERTY(bool lineShadow READ lineShadow WRITE setLineShadow NOTIFY lineShadowChanged)
    Q_PROPERTY(bool isLineShadowImmutable READ isLineShadowImmutable CONSTANT)
    Q_PROPERTY(bool defaultLineShadowValue READ defaultLineShadowValue CONSTANT)
    /**
      Get Whether line annotation tool has a drop shadow
    */
    static
    bool lineShadow()
    {
      return self()->mLineShadow;
    }

    /**
      Is Whether line annotation tool has a drop shadow Immutable
    */
    static
    bool isLineShadowImmutable()
    {
      return self()->isImmutable( QStringLiteral( "lineShadow" ) );
    }

    /**
      Get Whether line annotation tool has a drop shadow default value
    */
    static
    bool defaultLineShadowValue()
    {
        return defaultLineShadowValue_helper();
    }

    /**
      Set Whether arrow annotation tool has a drop shadow
    */
    static
    void setArrowShadow( bool v )
    {
      if (v != self()->mArrowShadow && !self()->isArrowShadowImmutable()) {
        self()->mArrowShadow = v;
        Q_EMIT self()->arrowShadowChanged();
      }
    }

    Q_PROPERTY(bool arrowShadow READ arrowShadow WRITE setArrowShadow NOTIFY arrowShadowChanged)
    Q_PROPERTY(bool isArrowShadowImmutable READ isArrowShadowImmutable CONSTANT)
    Q_PROPERTY(bool defaultArrowShadowValue READ defaultArrowShadowValue CONSTANT)
    /**
      Get Whether arrow annotation tool has a drop shadow
    */
    static
    bool arrowShadow()
    {
      return self()->mArrowShadow;
    }

    /**
      Is Whether arrow annotation tool has a drop shadow Immutable
    */
    static
    bool isArrowShadowImmutable()
    {
      return self()->isImmutable( QStringLiteral( "arrowShadow" ) );
    }

    /**
      Get Whether arrow annotation tool has a drop shadow default value
    */
    static
    bool defaultArrowShadowValue()
    {
        return defaultArrowShadowValue_helper();
    }

    /**
      Set Whether rectangle annotation tool has a drop shadow
    */
    static
    void setRectangleShadow( bool v )
    {
      if (v != self()->mRectangleShadow && !self()->isRectangleShadowImmutable()) {
        self()->mRectangleShadow = v;
        Q_EMIT self()->rectangleShadowChanged();
      }
    }

    Q_PROPERTY(bool rectangleShadow READ rectangleShadow WRITE setRectangleShadow NOTIFY rectangleShadowChanged)
    Q_PROPERTY(bool isRectangleShadowImmutable READ isRectangleShadowImmutable CONSTANT)
    Q_PROPERTY(bool defaultRectangleShadowValue READ defaultRectangleShadowValue CONSTANT)
    /**
      Get Whether rectangle annotation tool has a drop shadow
    */
    static
    bool rectangleShadow()
    {
      return self()->mRectangleShadow;
    }

    /**
      Is Whether rectangle annotation tool has a drop shadow Immutable
    */
    static
    bool isRectangleShadowImmutable()
    {
      return self()->isImmutable( QStringLiteral( "rectangleShadow" ) );
    }

    /**
      Get Whether rectangle annotation tool has a drop shadow default value
    */
    static
    bool defaultRectangleShadowValue()
    {
        return defaultRectangleShadowValue_helper();
    }

    /**
      Set Whether ellipse annotation tool has a drop shadow
    */
    static
    void setEllipseShadow( bool v )
    {
      if (v != self()->mEllipseShadow && !self()->isEllipseShadowImmutable()) {
        self()->mEllipseShadow = v;
        Q_EMIT self()->ellipseShadowChanged();
      }
    }

    Q_PROPERTY(bool ellipseShadow READ ellipseShadow WRITE setEllipseShadow NOTIFY ellipseShadowChanged)
    Q_PROPERTY(bool isEllipseShadowImmutable READ isEllipseShadowImmutable CONSTANT)
    Q_PROPERTY(bool defaultEllipseShadowValue READ defaultEllipseShadowValue CONSTANT)
    /**
      Get Whether ellipse annotation tool has a drop shadow
    */
    static
    bool ellipseShadow()
    {
      return self()->mEllipseShadow;
    }

    /**
      Is Whether ellipse annotation tool has a drop shadow Immutable
    */
    static
    bool isEllipseShadowImmutable()
    {
      return self()->isImmutable( QStringLiteral( "ellipseShadow" ) );
    }

    /**
      Get Whether ellipse annotation tool has a drop shadow default value
    */
    static
    bool defaultEllipseShadowValue()
    {
        return defaultEllipseShadowValue_helper();
    }

    /**
      Set Whether text annotation tool has a drop shadow
    */
    static
    void setTextShadow( bool v )
    {
      if (v != self()->mTextShadow && !self()->isTextShadowImmutable()) {
        self()->mTextShadow = v;
        Q_EMIT self()->textShadowChanged();
      }
    }

    Q_PROPERTY(bool textShadow READ textShadow WRITE setTextShadow NOTIFY textShadowChanged)
    Q_PROPERTY(bool isTextShadowImmutable READ isTextShadowImmutable CONSTANT)
    Q_PROPERTY(bool defaultTextShadowValue READ defaultTextShadowValue CONSTANT)
    /**
      Get Whether text annotation tool has a drop shadow
    */
    static
    bool textShadow()
    {
      return self()->mTextShadow;
    }

    /**
      Is Whether text annotation tool has a drop shadow Immutable
    */
    static
    bool isTextShadowImmutable()
    {
      return self()->isImmutable( QStringLiteral( "textShadow" ) );
    }

    /**
      Get Whether text annotation tool has a drop shadow default value
    */
    static
    bool defaultTextShadowValue()
    {
        return defaultTextShadowValue_helper();
    }

    /**
      Set Whether number annotation tool has a drop shadow
    */
    static
    void setNumberShadow( bool v )
    {
      if (v != self()->mNumberShadow && !self()->isNumberShadowImmutable()) {
        self()->mNumberShadow = v;
        Q_EMIT self()->numberShadowChanged();
      }
    }

    Q_PROPERTY(bool numberShadow READ numberShadow WRITE setNumberShadow NOTIFY numberShadowChanged)
    Q_PROPERTY(bool isNumberShadowImmutable READ isNumberShadowImmutable CONSTANT)
    Q_PROPERTY(bool defaultNumberShadowValue READ defaultNumberShadowValue CONSTANT)
    /**
      Get Whether number annotation tool has a drop shadow
    */
    static
    bool numberShadow()
    {
      return self()->mNumberShadow;
    }

    /**
      Is Whether number annotation tool has a drop shadow Immutable
    */
    static
    bool isNumberShadowImmutable()
    {
      return self()->isImmutable( QStringLiteral( "numberShadow" ) );
    }

    /**
      Get Whether number annotation tool has a drop shadow default value
    */
    static
    bool defaultNumberShadowValue()
    {
        return defaultNumberShadowValue_helper();
    }


    enum {
      signalLaunchActionChanged = 1,
      signalPrintKeyRunningActionChanged = 2,
      signalAutoSaveImageChanged = 3,
      signalClipboardGroupChanged = 4,
      signalUseLightMaskColorChanged = 5,
      signalShowMagnifierChanged = 6,
      signalUseReleaseToCaptureChanged = 7,
      signalRememberSelectionRectChanged = 8,
      signalSelectionRectChanged = 9,
      signalCaptureOnClickChanged = 10,
      signalIncludePointerChanged = 11,
      signalVideoIncludePointerChanged = 12,
      signalIncludeDecorationsChanged = 13,
      signalIncludeShadowChanged = 14,
      signalTransientOnlyChanged = 15,
      signalQuitAfterSaveCopyExportChanged = 16,
      signalCaptureDelayChanged = 17,
      signalCaptureModeChanged = 18,
      signalImageSaveLocationChanged = 19,
      signalImageCompressionQualityChanged = 20,
      signalPreferredImageFormatChanged = 21,
      signalImageFilenameTemplateChanged = 22,
      signalLastImageSaveLocationChanged = 23,
      signalLastImageSaveAsLocationChanged = 24,
      signalVideoSaveLocationChanged = 25,
      signalPreferredVideoFormatChanged = 26,
      signalVideoFilenameTemplateChanged = 27,
      signalLastVideoSaveLocationChanged = 28,
      signalLastVideoSaveAsLocationChanged = 29,
      signalAnnotationToolTypeChanged = 30,
      signalFreehandStrokeWidthChanged = 31,
      signalHighlighterStrokeWidthChanged = 32,
      signalLineStrokeWidthChanged = 33,
      signalArrowStrokeWidthChanged = 34,
      signalRectangleStrokeWidthChanged = 35,
      signalEllipseStrokeWidthChanged = 36,
      signalFreehandStrokeColorChanged = 37,
      signalHighlighterStrokeColorChanged = 38,
      signalLineStrokeColorChanged = 39,
      signalArrowStrokeColorChanged = 40,
      signalRectangleStrokeColorChanged = 41,
      signalEllipseStrokeColorChanged = 42,
      signalRectangleFillColorChanged = 43,
      signalEllipseFillColorChanged = 44,
      signalNumberFillColorChanged = 45,
      signalBlurStrengthChanged = 46,
      signalPixelateStrengthChanged = 47,
      signalTextFontChanged = 48,
      signalNumberFontChanged = 49,
      signalTextFontColorChanged = 50,
      signalNumberFontColorChanged = 51,
      signalFreehandShadowChanged = 52,
      signalLineShadowChanged = 53,
      signalArrowShadowChanged = 54,
      signalRectangleShadowChanged = 55,
      signalEllipseShadowChanged = 56,
      signalTextShadowChanged = 57,
      signalNumberShadowChanged = 58
    };

  Q_SIGNALS:
    void launchActionChanged();

    void printKeyRunningActionChanged();

    void autoSaveImageChanged();

    void clipboardGroupChanged();

    void useLightMaskColorChanged();

    void showMagnifierChanged();

    void useReleaseToCaptureChanged();

    void rememberSelectionRectChanged();

    void selectionRectChanged();

    void captureOnClickChanged();

    void includePointerChanged();

    void videoIncludePointerChanged();

    void includeDecorationsChanged();

    void includeShadowChanged();

    void transientOnlyChanged();

    void quitAfterSaveCopyExportChanged();

    void captureDelayChanged();

    void captureModeChanged();

    void imageSaveLocationChanged();

    void imageCompressionQualityChanged();

    void preferredImageFormatChanged();

    void imageFilenameTemplateChanged();

    void lastImageSaveLocationChanged();

    void lastImageSaveAsLocationChanged();

    void videoSaveLocationChanged();

    void preferredVideoFormatChanged();

    void videoFilenameTemplateChanged();

    void lastVideoSaveLocationChanged();

    void lastVideoSaveAsLocationChanged();

    void annotationToolTypeChanged();

    void freehandStrokeWidthChanged();

    void highlighterStrokeWidthChanged();

    void lineStrokeWidthChanged();

    void arrowStrokeWidthChanged();

    void rectangleStrokeWidthChanged();

    void ellipseStrokeWidthChanged();

    void freehandStrokeColorChanged();

    void highlighterStrokeColorChanged();

    void lineStrokeColorChanged();

    void arrowStrokeColorChanged();

    void rectangleStrokeColorChanged();

    void ellipseStrokeColorChanged();

    void rectangleFillColorChanged();

    void ellipseFillColorChanged();

    void numberFillColorChanged();

    void blurStrengthChanged();

    void pixelateStrengthChanged();

    void textFontChanged();

    void numberFontChanged();

    void textFontColorChanged();

    void numberFontColorChanged();

    void freehandShadowChanged();

    void lineShadowChanged();

    void arrowShadowChanged();

    void rectangleShadowChanged();

    void ellipseShadowChanged();

    void textShadowChanged();

    void numberShadowChanged();

  private:
    void itemChanged(quint64 signalFlag);

  protected:
    Settings();
    friend class SettingsHelper;


    // General
    int mLaunchAction;
    static int defaultLaunchActionValue_helper();
    int mPrintKeyRunningAction;
    static int defaultPrintKeyRunningActionValue_helper();
    bool mAutoSaveImage;
    static bool defaultAutoSaveImageValue_helper();
    int mClipboardGroup;
    static int defaultClipboardGroupValue_helper();
    bool mUseLightMaskColor;
    static bool defaultUseLightMaskColorValue_helper();
    int mShowMagnifier;
    static int defaultShowMagnifierValue_helper();
    bool mUseReleaseToCapture;
    static bool defaultUseReleaseToCaptureValue_helper();
    int mRememberSelectionRect;
    static int defaultRememberSelectionRectValue_helper();

    // GuiConfig
    QRectF mSelectionRect;
    static QRectF defaultSelectionRectValue_helper();
    bool mCaptureOnClick;
    static bool defaultCaptureOnClickValue_helper();
    bool mIncludePointer;
    static bool defaultIncludePointerValue_helper();
    bool mVideoIncludePointer;
    static bool defaultVideoIncludePointerValue_helper();
    bool mIncludeDecorations;
    static bool defaultIncludeDecorationsValue_helper();
    bool mIncludeShadow;
    static bool defaultIncludeShadowValue_helper();
    bool mTransientOnly;
    static bool defaultTransientOnlyValue_helper();
    bool mQuitAfterSaveCopyExport;
    static bool defaultQuitAfterSaveCopyExportValue_helper();
    double mCaptureDelay;
    static double defaultCaptureDelayValue_helper();
    int mCaptureMode;
    static int defaultCaptureModeValue_helper();

    // ImageSave
    QUrl mImageSaveLocation;
    static QUrl defaultImageSaveLocationValue_helper();
    uint mImageCompressionQuality;
    static uint defaultImageCompressionQualityValue_helper();
    QString mPreferredImageFormat;
    static QString defaultPreferredImageFormatValue_helper();
    QString mImageFilenameTemplate;
    static QString defaultImageFilenameTemplateValue_helper();
    QUrl mLastImageSaveLocation;
    static QUrl defaultLastImageSaveLocationValue_helper();
    QUrl mLastImageSaveAsLocation;
    static QUrl defaultLastImageSaveAsLocationValue_helper();

    // VideoSave
    QUrl mVideoSaveLocation;
    static QUrl defaultVideoSaveLocationValue_helper();
    int mPreferredVideoFormat;
    static int defaultPreferredVideoFormatValue_helper();
    QString mVideoFilenameTemplate;
    static QString defaultVideoFilenameTemplateValue_helper();
    QUrl mLastVideoSaveLocation;
    static QUrl defaultLastVideoSaveLocationValue_helper();
    QUrl mLastVideoSaveAsLocation;
    static QUrl defaultLastVideoSaveAsLocationValue_helper();

    // Annotations
    int mAnnotationToolType;
    static int defaultAnnotationToolTypeValue_helper();
    uint mFreehandStrokeWidth;
    static uint defaultFreehandStrokeWidthValue_helper();
    uint mHighlighterStrokeWidth;
    static uint defaultHighlighterStrokeWidthValue_helper();
    uint mLineStrokeWidth;
    static uint defaultLineStrokeWidthValue_helper();
    uint mArrowStrokeWidth;
    static uint defaultArrowStrokeWidthValue_helper();
    uint mRectangleStrokeWidth;
    static uint defaultRectangleStrokeWidthValue_helper();
    uint mEllipseStrokeWidth;
    static uint defaultEllipseStrokeWidthValue_helper();
    QColor mFreehandStrokeColor;
    static QColor defaultFreehandStrokeColorValue_helper();
    QColor mHighlighterStrokeColor;
    static QColor defaultHighlighterStrokeColorValue_helper();
    QColor mLineStrokeColor;
    static QColor defaultLineStrokeColorValue_helper();
    QColor mArrowStrokeColor;
    static QColor defaultArrowStrokeColorValue_helper();
    QColor mRectangleStrokeColor;
    static QColor defaultRectangleStrokeColorValue_helper();
    QColor mEllipseStrokeColor;
    static QColor defaultEllipseStrokeColorValue_helper();
    QColor mRectangleFillColor;
    static QColor defaultRectangleFillColorValue_helper();
    QColor mEllipseFillColor;
    static QColor defaultEllipseFillColorValue_helper();
    QColor mNumberFillColor;
    static QColor defaultNumberFillColorValue_helper();
    double mBlurStrength;
    static double defaultBlurStrengthValue_helper();
    double mPixelateStrength;
    static double defaultPixelateStrengthValue_helper();
    QFont mTextFont;
    static QFont defaultTextFontValue_helper();
    QFont mNumberFont;
    static QFont defaultNumberFontValue_helper();
    QColor mTextFontColor;
    static QColor defaultTextFontColorValue_helper();
    QColor mNumberFontColor;
    static QColor defaultNumberFontColorValue_helper();
    bool mFreehandShadow;
    static bool defaultFreehandShadowValue_helper();
    bool mLineShadow;
    static bool defaultLineShadowValue_helper();
    bool mArrowShadow;
    static bool defaultArrowShadowValue_helper();
    bool mRectangleShadow;
    static bool defaultRectangleShadowValue_helper();
    bool mEllipseShadow;
    static bool defaultEllipseShadowValue_helper();
    bool mTextShadow;
    static bool defaultTextShadowValue_helper();
    bool mNumberShadow;
    static bool defaultNumberShadowValue_helper();
};

#endif

