/* OAuth1Authenticator.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from OAuth1Authenticator.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 * Copyright 2017 Jens Georg <mail@jensge.org>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib-object.h>
#include "shotwell-plugin-dev-1.0.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include "shotwell-plugin-common.h"
#include <libsecret/secret.h>
#include "shotwell-authenticator.h"

#define PUBLISHING_AUTHENTICATOR_SHOTWELL_OAUTH1_AUTHENTICATOR_SECRET_TYPE_USERNAME "username"
#define PUBLISHING_AUTHENTICATOR_SHOTWELL_OAUTH1_AUTHENTICATOR_SECRET_TYPE_AUTH_TOKEN "auth-token"
#define PUBLISHING_AUTHENTICATOR_SHOTWELL_OAUTH1_AUTHENTICATOR_SECRET_TYPE_AUTH_TOKEN_SECRET "auth-token-secret"
#define PUBLISHING_AUTHENTICATOR_SHOTWELL_OAUTH1_AUTHENTICATOR_SCHEMA_KEY_ACCOUNTNAME "accountname"
#define PUBLISHING_AUTHENTICATOR_SHOTWELL_OAUTH1_AUTHENTICATOR_SCHEMA_KEY_PROFILE_ID "shotwell-profile-id"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define PUBLISHING_AUTHENTICATOR_SHOTWELL_OAUTH1_TYPE_AUTHENTICATOR (publishing_authenticator_shotwell_oauth1_authenticator_get_type ())
#define PUBLISHING_AUTHENTICATOR_SHOTWELL_OAUTH1_AUTHENTICATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PUBLISHING_AUTHENTICATOR_SHOTWELL_OAUTH1_TYPE_AUTHENTICATOR, PublishingAuthenticatorShotwellOAuth1Authenticator))
#define PUBLISHING_AUTHENTICATOR_SHOTWELL_OAUTH1_AUTHENTICATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PUBLISHING_AUTHENTICATOR_SHOTWELL_OAUTH1_TYPE_AUTHENTICATOR, PublishingAuthenticatorShotwellOAuth1AuthenticatorClass))
#define PUBLISHING_AUTHENTICATOR_SHOTWELL_OAUTH1_IS_AUTHENTICATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PUBLISHING_AUTHENTICATOR_SHOTWELL_OAUTH1_TYPE_AUTHENTICATOR))
#define PUBLISHING_AUTHENTICATOR_SHOTWELL_OAUTH1_IS_AUTHENTICATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PUBLISHING_AUTHENTICATOR_SHOTWELL_OAUTH1_TYPE_AUTHENTICATOR))
#define PUBLISHING_AUTHENTICATOR_SHOTWELL_OAUTH1_AUTHENTICATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PUBLISHING_AUTHENTICATOR_SHOTWELL_OAUTH1_TYPE_AUTHENTICATOR, PublishingAuthenticatorShotwellOAuth1AuthenticatorClass))

typedef struct _PublishingAuthenticatorShotwellOAuth1Authenticator PublishingAuthenticatorShotwellOAuth1Authenticator;
typedef struct _PublishingAuthenticatorShotwellOAuth1AuthenticatorClass PublishingAuthenticatorShotwellOAuth1AuthenticatorClass;
typedef struct _PublishingAuthenticatorShotwellOAuth1AuthenticatorPrivate PublishingAuthenticatorShotwellOAuth1AuthenticatorPrivate;
enum  {
	PUBLISHING_AUTHENTICATOR_SHOTWELL_OAUTH1_AUTHENTICATOR_0_PROPERTY,
	PUBLISHING_AUTHENTICATOR_SHOTWELL_OAUTH1_AUTHENTICATOR_NUM_PROPERTIES
};
static GParamSpec* publishing_authenticator_shotwell_oauth1_authenticator_properties[PUBLISHING_AUTHENTICATOR_SHOTWELL_OAUTH1_AUTHENTICATOR_NUM_PROPERTIES];
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _publishing_rest_support_session_unref0(var) ((var == NULL) ? NULL : (var = (publishing_rest_support_session_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _secret_schema_unref0(var) ((var == NULL) ? NULL : (var = (secret_schema_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _PublishingAuthenticatorShotwellOAuth1Authenticator {
	GObject parent_instance;
	PublishingAuthenticatorShotwellOAuth1AuthenticatorPrivate * priv;
	GHashTable* params;
	PublishingRESTSupportOAuth1Session* session;
	SpitPublishingPluginHost* host;
};

struct _PublishingAuthenticatorShotwellOAuth1AuthenticatorClass {
	GObjectClass parent_class;
	void (*authenticate) (PublishingAuthenticatorShotwellOAuth1Authenticator* self);
	gboolean (*can_logout) (PublishingAuthenticatorShotwellOAuth1Authenticator* self);
	void (*logout) (PublishingAuthenticatorShotwellOAuth1Authenticator* self);
	void (*refresh) (PublishingAuthenticatorShotwellOAuth1Authenticator* self);
	void (*set_accountname) (PublishingAuthenticatorShotwellOAuth1Authenticator* self, const gchar* name);
};

struct _PublishingAuthenticatorShotwellOAuth1AuthenticatorPrivate {
	SecretSchema* schema;
	gchar* service;
	gchar* accountname;
};

static gint PublishingAuthenticatorShotwellOAuth1Authenticator_private_offset;
static gpointer publishing_authenticator_shotwell_oauth1_authenticator_parent_class = NULL;
static SpitPublishingAuthenticatorIface * publishing_authenticator_shotwell_oauth1_authenticator_spit_publishing_authenticator_parent_iface = NULL;

VALA_EXTERN GType publishing_authenticator_shotwell_oauth1_authenticator_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void publishing_authenticator_shotwell_oauth1_authenticator_authenticate (PublishingAuthenticatorShotwellOAuth1Authenticator* self);
VALA_EXTERN gboolean publishing_authenticator_shotwell_oauth1_authenticator_can_logout (PublishingAuthenticatorShotwellOAuth1Authenticator* self);
VALA_EXTERN void publishing_authenticator_shotwell_oauth1_authenticator_logout (PublishingAuthenticatorShotwellOAuth1Authenticator* self);
VALA_EXTERN void publishing_authenticator_shotwell_oauth1_authenticator_refresh (PublishingAuthenticatorShotwellOAuth1Authenticator* self);
VALA_EXTERN void publishing_authenticator_shotwell_oauth1_authenticator_set_accountname (PublishingAuthenticatorShotwellOAuth1Authenticator* self,
                                                                             const gchar* name);
VALA_EXTERN void publishing_authenticator_shotwell_oauth1_authenticator_on_session_authenticated (PublishingAuthenticatorShotwellOAuth1Authenticator* self);
static void _publishing_authenticator_shotwell_oauth1_authenticator_on_session_authenticated_publishing_rest_support_session_authenticated (PublishingRESTSupportSession* _sender,
                                                                                                                                     gpointer self);
VALA_EXTERN PublishingAuthenticatorShotwellOAuth1Authenticator* publishing_authenticator_shotwell_oauth1_authenticator_construct (GType object_type,
                                                                                                                      const gchar* service,
                                                                                                                      const gchar* api_key,
                                                                                                                      const gchar* api_secret,
                                                                                                                      SpitPublishingPluginHost* host);
static void _g_free0_ (gpointer var);
static void _g_variant_unref0_ (gpointer var);
static GVariant* _variant_new1 (const gchar* value);
static GVariant* _variant_new2 (const gchar* value);
static void publishing_authenticator_shotwell_oauth1_authenticator_real_authenticate (PublishingAuthenticatorShotwellOAuth1Authenticator* self);
static gboolean publishing_authenticator_shotwell_oauth1_authenticator_real_can_logout (PublishingAuthenticatorShotwellOAuth1Authenticator* self);
static GHashTable* publishing_authenticator_shotwell_oauth1_authenticator_real_get_authentication_parameter (SpitPublishingAuthenticator* base);
static void publishing_authenticator_shotwell_oauth1_authenticator_real_logout (PublishingAuthenticatorShotwellOAuth1Authenticator* self);
static void publishing_authenticator_shotwell_oauth1_authenticator_real_refresh (PublishingAuthenticatorShotwellOAuth1Authenticator* self);
static void publishing_authenticator_shotwell_oauth1_authenticator_real_set_accountname (PublishingAuthenticatorShotwellOAuth1Authenticator* self,
                                                                                  const gchar* name);
VALA_EXTERN void publishing_authenticator_shotwell_oauth1_authenticator_invalidate_persistent_session (PublishingAuthenticatorShotwellOAuth1Authenticator* self);
VALA_EXTERN void publishing_authenticator_shotwell_oauth1_authenticator_set_persistent_access_phase_token (PublishingAuthenticatorShotwellOAuth1Authenticator* self,
                                                                                               const gchar* token);
VALA_EXTERN void publishing_authenticator_shotwell_oauth1_authenticator_set_persistent_access_phase_token_secret (PublishingAuthenticatorShotwellOAuth1Authenticator* self,
                                                                                                      const gchar* secret);
VALA_EXTERN void publishing_authenticator_shotwell_oauth1_authenticator_set_persistent_access_phase_username (PublishingAuthenticatorShotwellOAuth1Authenticator* self,
                                                                                                  const gchar* username);
VALA_EXTERN gboolean publishing_authenticator_shotwell_oauth1_authenticator_is_persistent_session_valid (PublishingAuthenticatorShotwellOAuth1Authenticator* self);
VALA_EXTERN gchar* publishing_authenticator_shotwell_oauth1_authenticator_get_persistent_access_phase_username (PublishingAuthenticatorShotwellOAuth1Authenticator* self);
VALA_EXTERN gchar* publishing_authenticator_shotwell_oauth1_authenticator_get_persistent_access_phase_token (PublishingAuthenticatorShotwellOAuth1Authenticator* self);
VALA_EXTERN gchar* publishing_authenticator_shotwell_oauth1_authenticator_get_persistent_access_phase_token_secret (PublishingAuthenticatorShotwellOAuth1Authenticator* self);
static GVariant* _variant_new3 (gchar* value);
static GVariant* _variant_new4 (gchar* value);
static GVariant* _variant_new5 (gchar* value);
static void publishing_authenticator_shotwell_oauth1_authenticator_finalize (GObject * obj);
static GType publishing_authenticator_shotwell_oauth1_authenticator_get_type_once (void);

static inline gpointer
publishing_authenticator_shotwell_oauth1_authenticator_get_instance_private (PublishingAuthenticatorShotwellOAuth1Authenticator* self)
{
	return G_STRUCT_MEMBER_P (self, PublishingAuthenticatorShotwellOAuth1Authenticator_private_offset);
}

static void
_publishing_authenticator_shotwell_oauth1_authenticator_on_session_authenticated_publishing_rest_support_session_authenticated (PublishingRESTSupportSession* _sender,
                                                                                                                                gpointer self)
{
	publishing_authenticator_shotwell_oauth1_authenticator_on_session_authenticated ((PublishingAuthenticatorShotwellOAuth1Authenticator*) self);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_g_variant_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_variant_unref (var), NULL));
}

static GVariant*
_variant_new1 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static GVariant*
_variant_new2 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

PublishingAuthenticatorShotwellOAuth1Authenticator*
publishing_authenticator_shotwell_oauth1_authenticator_construct (GType object_type,
                                                                  const gchar* service,
                                                                  const gchar* api_key,
                                                                  const gchar* api_secret,
                                                                  SpitPublishingPluginHost* host)
{
	PublishingAuthenticatorShotwellOAuth1Authenticator * self = NULL;
	SpitPublishingPluginHost* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	SecretSchema* _tmp4_;
	GHashFunc _tmp5_;
	GEqualFunc _tmp6_;
	GHashTable* _tmp7_;
	GHashTable* _tmp8_;
	gchar* _tmp9_;
	GVariant* _tmp10_;
	GHashTable* _tmp11_;
	gchar* _tmp12_;
	GVariant* _tmp13_;
	PublishingRESTSupportOAuth1Session* _tmp14_;
	PublishingRESTSupportOAuth1Session* _tmp15_;
	PublishingRESTSupportOAuth1Session* _tmp16_;
	g_return_val_if_fail (service != NULL, NULL);
	g_return_val_if_fail (api_key != NULL, NULL);
	g_return_val_if_fail (api_secret != NULL, NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (host, SPIT_PUBLISHING_TYPE_PLUGIN_HOST), NULL);
	self = (PublishingAuthenticatorShotwellOAuth1Authenticator*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (host);
	_g_object_unref0 (self->host);
	self->host = _tmp0_;
	_tmp1_ = g_strdup (service);
	_g_free0 (self->priv->service);
	self->priv->service = _tmp1_;
	_tmp2_ = g_strconcat ("org.gnome.Shotwell.", service, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = secret_schema_new (_tmp3_, SECRET_SCHEMA_NONE, PUBLISHING_AUTHENTICATOR_SHOTWELL_OAUTH1_AUTHENTICATOR_SCHEMA_KEY_PROFILE_ID, SECRET_SCHEMA_ATTRIBUTE_STRING, PUBLISHING_AUTHENTICATOR_SHOTWELL_OAUTH1_AUTHENTICATOR_SCHEMA_KEY_ACCOUNTNAME, SECRET_SCHEMA_ATTRIBUTE_STRING, "type", SECRET_SCHEMA_ATTRIBUTE_STRING, NULL);
	_secret_schema_unref0 (self->priv->schema);
	self->priv->schema = _tmp4_;
	_g_free0 (_tmp3_);
	_tmp5_ = g_str_hash;
	_tmp6_ = g_str_equal;
	_tmp7_ = g_hash_table_new_full (_tmp5_, _tmp6_, _g_free0_, _g_variant_unref0_);
	_g_hash_table_unref0 (self->params);
	self->params = _tmp7_;
	_tmp8_ = self->params;
	_tmp9_ = g_strdup ("ConsumerKey");
	_tmp10_ = _variant_new1 (api_key);
	g_hash_table_insert (_tmp8_, _tmp9_, _tmp10_);
	_tmp11_ = self->params;
	_tmp12_ = g_strdup ("ConsumerSecret");
	_tmp13_ = _variant_new2 (api_secret);
	g_hash_table_insert (_tmp11_, _tmp12_, _tmp13_);
	_tmp14_ = publishing_rest_support_oauth1_session_new (NULL);
	_publishing_rest_support_session_unref0 (self->session);
	self->session = _tmp14_;
	_tmp15_ = self->session;
	publishing_rest_support_oauth1_session_set_api_credentials (_tmp15_, api_key, api_secret);
	_tmp16_ = self->session;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, PUBLISHING_REST_SUPPORT_TYPE_SESSION, PublishingRESTSupportSession), "authenticated", (GCallback) _publishing_authenticator_shotwell_oauth1_authenticator_on_session_authenticated_publishing_rest_support_session_authenticated, self, 0);
	return self;
}

static void
publishing_authenticator_shotwell_oauth1_authenticator_real_authenticate (PublishingAuthenticatorShotwellOAuth1Authenticator* self)
{
	g_critical ("Type `%s' does not implement abstract method `publishing_authenticator_shotwell_oauth1_authenticator_authenticate'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
publishing_authenticator_shotwell_oauth1_authenticator_authenticate (PublishingAuthenticatorShotwellOAuth1Authenticator* self)
{
	PublishingAuthenticatorShotwellOAuth1AuthenticatorClass* _klass_;
	g_return_if_fail (PUBLISHING_AUTHENTICATOR_SHOTWELL_OAUTH1_IS_AUTHENTICATOR (self));
	_klass_ = PUBLISHING_AUTHENTICATOR_SHOTWELL_OAUTH1_AUTHENTICATOR_GET_CLASS (self);
	if (_klass_->authenticate) {
		_klass_->authenticate (self);
	}
}

static gboolean
publishing_authenticator_shotwell_oauth1_authenticator_real_can_logout (PublishingAuthenticatorShotwellOAuth1Authenticator* self)
{
	gboolean _tmp0_ = FALSE;
	g_critical ("Type `%s' does not implement abstract method `publishing_authenticator_shotwell_oauth1_authenticator_can_logout'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return _tmp0_;
}

gboolean
publishing_authenticator_shotwell_oauth1_authenticator_can_logout (PublishingAuthenticatorShotwellOAuth1Authenticator* self)
{
	PublishingAuthenticatorShotwellOAuth1AuthenticatorClass* _klass_;
	g_return_val_if_fail (PUBLISHING_AUTHENTICATOR_SHOTWELL_OAUTH1_IS_AUTHENTICATOR (self), FALSE);
	_klass_ = PUBLISHING_AUTHENTICATOR_SHOTWELL_OAUTH1_AUTHENTICATOR_GET_CLASS (self);
	if (_klass_->can_logout) {
		return _klass_->can_logout (self);
	}
	return FALSE;
}

static gpointer
_g_hash_table_ref0 (gpointer self)
{
	return self ? g_hash_table_ref (self) : NULL;
}

static GHashTable*
publishing_authenticator_shotwell_oauth1_authenticator_real_get_authentication_parameter (SpitPublishingAuthenticator* base)
{
	PublishingAuthenticatorShotwellOAuth1Authenticator * self;
	GHashTable* _tmp0_;
	GHashTable* _tmp1_;
	GHashTable* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, PUBLISHING_AUTHENTICATOR_SHOTWELL_OAUTH1_TYPE_AUTHENTICATOR, PublishingAuthenticatorShotwellOAuth1Authenticator);
	_tmp0_ = self->params;
	_tmp1_ = _g_hash_table_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
publishing_authenticator_shotwell_oauth1_authenticator_real_logout (PublishingAuthenticatorShotwellOAuth1Authenticator* self)
{
	g_critical ("Type `%s' does not implement abstract method `publishing_authenticator_shotwell_oauth1_authenticator_logout'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
publishing_authenticator_shotwell_oauth1_authenticator_logout (PublishingAuthenticatorShotwellOAuth1Authenticator* self)
{
	PublishingAuthenticatorShotwellOAuth1AuthenticatorClass* _klass_;
	g_return_if_fail (PUBLISHING_AUTHENTICATOR_SHOTWELL_OAUTH1_IS_AUTHENTICATOR (self));
	_klass_ = PUBLISHING_AUTHENTICATOR_SHOTWELL_OAUTH1_AUTHENTICATOR_GET_CLASS (self);
	if (_klass_->logout) {
		_klass_->logout (self);
	}
}

static void
publishing_authenticator_shotwell_oauth1_authenticator_real_refresh (PublishingAuthenticatorShotwellOAuth1Authenticator* self)
{
	g_critical ("Type `%s' does not implement abstract method `publishing_authenticator_shotwell_oauth1_authenticator_refresh'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
publishing_authenticator_shotwell_oauth1_authenticator_refresh (PublishingAuthenticatorShotwellOAuth1Authenticator* self)
{
	PublishingAuthenticatorShotwellOAuth1AuthenticatorClass* _klass_;
	g_return_if_fail (PUBLISHING_AUTHENTICATOR_SHOTWELL_OAUTH1_IS_AUTHENTICATOR (self));
	_klass_ = PUBLISHING_AUTHENTICATOR_SHOTWELL_OAUTH1_AUTHENTICATOR_GET_CLASS (self);
	if (_klass_->refresh) {
		_klass_->refresh (self);
	}
}

static void
publishing_authenticator_shotwell_oauth1_authenticator_real_set_accountname (PublishingAuthenticatorShotwellOAuth1Authenticator* self,
                                                                             const gchar* name)
{
	gchar* _tmp0_;
	g_return_if_fail (name != NULL);
	_tmp0_ = g_strdup (name);
	_g_free0 (self->priv->accountname);
	self->priv->accountname = _tmp0_;
}

void
publishing_authenticator_shotwell_oauth1_authenticator_set_accountname (PublishingAuthenticatorShotwellOAuth1Authenticator* self,
                                                                        const gchar* name)
{
	PublishingAuthenticatorShotwellOAuth1AuthenticatorClass* _klass_;
	g_return_if_fail (PUBLISHING_AUTHENTICATOR_SHOTWELL_OAUTH1_IS_AUTHENTICATOR (self));
	_klass_ = PUBLISHING_AUTHENTICATOR_SHOTWELL_OAUTH1_AUTHENTICATOR_GET_CLASS (self);
	if (_klass_->set_accountname) {
		_klass_->set_accountname (self, name);
	}
}

void
publishing_authenticator_shotwell_oauth1_authenticator_invalidate_persistent_session (PublishingAuthenticatorShotwellOAuth1Authenticator* self)
{
	g_return_if_fail (PUBLISHING_AUTHENTICATOR_SHOTWELL_OAUTH1_IS_AUTHENTICATOR (self));
	publishing_authenticator_shotwell_oauth1_authenticator_set_persistent_access_phase_token (self, NULL);
	publishing_authenticator_shotwell_oauth1_authenticator_set_persistent_access_phase_token_secret (self, NULL);
	publishing_authenticator_shotwell_oauth1_authenticator_set_persistent_access_phase_username (self, NULL);
}

gboolean
publishing_authenticator_shotwell_oauth1_authenticator_is_persistent_session_valid (PublishingAuthenticatorShotwellOAuth1Authenticator* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_;
	gboolean result;
	g_return_val_if_fail (PUBLISHING_AUTHENTICATOR_SHOTWELL_OAUTH1_IS_AUTHENTICATOR (self), FALSE);
	_tmp2_ = publishing_authenticator_shotwell_oauth1_authenticator_get_persistent_access_phase_username (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_ != NULL;
	_g_free0 (_tmp3_);
	if (_tmp4_) {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = publishing_authenticator_shotwell_oauth1_authenticator_get_persistent_access_phase_token (self);
		_tmp6_ = _tmp5_;
		_tmp1_ = _tmp6_ != NULL;
		_g_free0 (_tmp6_);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp7_ = publishing_authenticator_shotwell_oauth1_authenticator_get_persistent_access_phase_token_secret (self);
		_tmp8_ = _tmp7_;
		_tmp0_ = _tmp8_ != NULL;
		_g_free0 (_tmp8_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

gchar*
publishing_authenticator_shotwell_oauth1_authenticator_get_persistent_access_phase_username (PublishingAuthenticatorShotwellOAuth1Authenticator* self)
{
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (PUBLISHING_AUTHENTICATOR_SHOTWELL_OAUTH1_IS_AUTHENTICATOR (self), NULL);
	{
		gchar* _tmp0_ = NULL;
		SecretSchema* _tmp1_;
		SpitPublishingPluginHost* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp1_ = self->priv->schema;
		_tmp2_ = self->host;
		_tmp3_ = spit_publishing_plugin_host_get_current_profile_id (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = self->priv->accountname;
		_tmp6_ = secret_password_lookup_sync (_tmp1_, NULL, &_inner_error0_, PUBLISHING_AUTHENTICATOR_SHOTWELL_OAUTH1_AUTHENTICATOR_SCHEMA_KEY_PROFILE_ID, _tmp4_, PUBLISHING_AUTHENTICATOR_SHOTWELL_OAUTH1_AUTHENTICATOR_SCHEMA_KEY_ACCOUNTNAME, _tmp5_, "type", PUBLISHING_AUTHENTICATOR_SHOTWELL_OAUTH1_AUTHENTICATOR_SECRET_TYPE_USERNAME, NULL);
		_tmp7_ = _tmp6_;
		_g_free0 (_tmp4_);
		_tmp0_ = _tmp7_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp8_ = _tmp0_;
		_tmp0_ = NULL;
		result = _tmp8_;
		_g_free0 (_tmp0_);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp9_;
		const gchar* _tmp10_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp9_ = err;
		_tmp10_ = _tmp9_->message;
		g_critical ("OAuth1Authenticator.vala:80: Failed to lookup username from password s" \
"tore: %s", _tmp10_);
		result = NULL;
		_g_error_free0 (err);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

void
publishing_authenticator_shotwell_oauth1_authenticator_set_persistent_access_phase_username (PublishingAuthenticatorShotwellOAuth1Authenticator* self,
                                                                                             const gchar* username)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (PUBLISHING_AUTHENTICATOR_SHOTWELL_OAUTH1_IS_AUTHENTICATOR (self));
	{
		gboolean _tmp0_ = FALSE;
		if (username == NULL) {
			_tmp0_ = TRUE;
		} else {
			_tmp0_ = g_strcmp0 (username, "") == 0;
		}
		if (_tmp0_) {
			SecretSchema* _tmp1_;
			SpitPublishingPluginHost* _tmp2_;
			gchar* _tmp3_;
			gchar* _tmp4_;
			const gchar* _tmp5_;
			_tmp1_ = self->priv->schema;
			_tmp2_ = self->host;
			_tmp3_ = spit_publishing_plugin_host_get_current_profile_id (_tmp2_);
			_tmp4_ = _tmp3_;
			_tmp5_ = self->priv->accountname;
			secret_password_clear_sync (_tmp1_, NULL, &_inner_error0_, PUBLISHING_AUTHENTICATOR_SHOTWELL_OAUTH1_AUTHENTICATOR_SCHEMA_KEY_PROFILE_ID, _tmp4_, PUBLISHING_AUTHENTICATOR_SHOTWELL_OAUTH1_AUTHENTICATOR_SCHEMA_KEY_ACCOUNTNAME, _tmp5_, "type", PUBLISHING_AUTHENTICATOR_SHOTWELL_OAUTH1_AUTHENTICATOR_SECRET_TYPE_USERNAME, NULL);
			_g_free0 (_tmp4_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		} else {
			SecretSchema* _tmp6_;
			const gchar* _tmp7_;
			const gchar* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			SpitPublishingPluginHost* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			const gchar* _tmp14_;
			_tmp6_ = self->priv->schema;
			_tmp7_ = self->priv->accountname;
			_tmp8_ = self->priv->service;
			_tmp9_ = g_strdup_printf ("Shotwell publishing (%s@%s)", _tmp7_, _tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = self->host;
			_tmp12_ = spit_publishing_plugin_host_get_current_profile_id (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = self->priv->accountname;
			secret_password_store_sync (_tmp6_, SECRET_COLLECTION_DEFAULT, _tmp10_, username, NULL, &_inner_error0_, PUBLISHING_AUTHENTICATOR_SHOTWELL_OAUTH1_AUTHENTICATOR_SCHEMA_KEY_PROFILE_ID, _tmp13_, PUBLISHING_AUTHENTICATOR_SHOTWELL_OAUTH1_AUTHENTICATOR_SCHEMA_KEY_ACCOUNTNAME, _tmp14_, "type", PUBLISHING_AUTHENTICATOR_SHOTWELL_OAUTH1_AUTHENTICATOR_SECRET_TYPE_USERNAME, NULL);
			_g_free0 (_tmp13_);
			_g_free0 (_tmp10_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp15_;
		const gchar* _tmp16_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp15_ = err;
		_tmp16_ = _tmp15_->message;
		g_critical ("OAuth1Authenticator.vala:100: Failed to store username in store: %s", _tmp16_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

gchar*
publishing_authenticator_shotwell_oauth1_authenticator_get_persistent_access_phase_token (PublishingAuthenticatorShotwellOAuth1Authenticator* self)
{
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (PUBLISHING_AUTHENTICATOR_SHOTWELL_OAUTH1_IS_AUTHENTICATOR (self), NULL);
	{
		gchar* _tmp0_ = NULL;
		SecretSchema* _tmp1_;
		SpitPublishingPluginHost* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp1_ = self->priv->schema;
		_tmp2_ = self->host;
		_tmp3_ = spit_publishing_plugin_host_get_current_profile_id (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = self->priv->accountname;
		_tmp6_ = secret_password_lookup_sync (_tmp1_, NULL, &_inner_error0_, PUBLISHING_AUTHENTICATOR_SHOTWELL_OAUTH1_AUTHENTICATOR_SCHEMA_KEY_PROFILE_ID, _tmp4_, PUBLISHING_AUTHENTICATOR_SHOTWELL_OAUTH1_AUTHENTICATOR_SCHEMA_KEY_ACCOUNTNAME, _tmp5_, "type", PUBLISHING_AUTHENTICATOR_SHOTWELL_OAUTH1_AUTHENTICATOR_SECRET_TYPE_AUTH_TOKEN, NULL);
		_tmp7_ = _tmp6_;
		_g_free0 (_tmp4_);
		_tmp0_ = _tmp7_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp8_ = _tmp0_;
		_tmp0_ = NULL;
		result = _tmp8_;
		_g_free0 (_tmp0_);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp9_;
		const gchar* _tmp10_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp9_ = err;
		_tmp10_ = _tmp9_->message;
		g_critical ("OAuth1Authenticator.vala:111: Failed to lookup auth-token from passwor" \
"d store: %s", _tmp10_);
		result = NULL;
		_g_error_free0 (err);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

void
publishing_authenticator_shotwell_oauth1_authenticator_set_persistent_access_phase_token (PublishingAuthenticatorShotwellOAuth1Authenticator* self,
                                                                                          const gchar* token)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (PUBLISHING_AUTHENTICATOR_SHOTWELL_OAUTH1_IS_AUTHENTICATOR (self));
	{
		gboolean _tmp0_ = FALSE;
		if (token == NULL) {
			_tmp0_ = TRUE;
		} else {
			_tmp0_ = g_strcmp0 (token, "") == 0;
		}
		if (_tmp0_) {
			SecretSchema* _tmp1_;
			SpitPublishingPluginHost* _tmp2_;
			gchar* _tmp3_;
			gchar* _tmp4_;
			const gchar* _tmp5_;
			_tmp1_ = self->priv->schema;
			_tmp2_ = self->host;
			_tmp3_ = spit_publishing_plugin_host_get_current_profile_id (_tmp2_);
			_tmp4_ = _tmp3_;
			_tmp5_ = self->priv->accountname;
			secret_password_clear_sync (_tmp1_, NULL, &_inner_error0_, PUBLISHING_AUTHENTICATOR_SHOTWELL_OAUTH1_AUTHENTICATOR_SCHEMA_KEY_PROFILE_ID, _tmp4_, PUBLISHING_AUTHENTICATOR_SHOTWELL_OAUTH1_AUTHENTICATOR_SCHEMA_KEY_ACCOUNTNAME, _tmp5_, "type", PUBLISHING_AUTHENTICATOR_SHOTWELL_OAUTH1_AUTHENTICATOR_SECRET_TYPE_AUTH_TOKEN, NULL);
			_g_free0 (_tmp4_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		} else {
			SecretSchema* _tmp6_;
			const gchar* _tmp7_;
			const gchar* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			SpitPublishingPluginHost* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			const gchar* _tmp14_;
			_tmp6_ = self->priv->schema;
			_tmp7_ = self->priv->accountname;
			_tmp8_ = self->priv->service;
			_tmp9_ = g_strdup_printf ("Shotwell publishing (%s@%s)", _tmp7_, _tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = self->host;
			_tmp12_ = spit_publishing_plugin_host_get_current_profile_id (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = self->priv->accountname;
			secret_password_store_sync (_tmp6_, SECRET_COLLECTION_DEFAULT, _tmp10_, token, NULL, &_inner_error0_, PUBLISHING_AUTHENTICATOR_SHOTWELL_OAUTH1_AUTHENTICATOR_SCHEMA_KEY_PROFILE_ID, _tmp13_, PUBLISHING_AUTHENTICATOR_SHOTWELL_OAUTH1_AUTHENTICATOR_SCHEMA_KEY_ACCOUNTNAME, _tmp14_, "type", PUBLISHING_AUTHENTICATOR_SHOTWELL_OAUTH1_AUTHENTICATOR_SECRET_TYPE_AUTH_TOKEN, NULL);
			_g_free0 (_tmp13_);
			_g_free0 (_tmp10_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp15_;
		const gchar* _tmp16_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp15_ = err;
		_tmp16_ = _tmp15_->message;
		g_critical ("OAuth1Authenticator.vala:132: Failed to store auth-token store: %s", _tmp16_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

gchar*
publishing_authenticator_shotwell_oauth1_authenticator_get_persistent_access_phase_token_secret (PublishingAuthenticatorShotwellOAuth1Authenticator* self)
{
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (PUBLISHING_AUTHENTICATOR_SHOTWELL_OAUTH1_IS_AUTHENTICATOR (self), NULL);
	{
		gchar* _tmp0_ = NULL;
		SecretSchema* _tmp1_;
		SpitPublishingPluginHost* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp1_ = self->priv->schema;
		_tmp2_ = self->host;
		_tmp3_ = spit_publishing_plugin_host_get_current_profile_id (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = self->priv->accountname;
		_tmp6_ = secret_password_lookup_sync (_tmp1_, NULL, &_inner_error0_, PUBLISHING_AUTHENTICATOR_SHOTWELL_OAUTH1_AUTHENTICATOR_SCHEMA_KEY_PROFILE_ID, _tmp4_, PUBLISHING_AUTHENTICATOR_SHOTWELL_OAUTH1_AUTHENTICATOR_SCHEMA_KEY_ACCOUNTNAME, _tmp5_, "type", PUBLISHING_AUTHENTICATOR_SHOTWELL_OAUTH1_AUTHENTICATOR_SECRET_TYPE_AUTH_TOKEN_SECRET, NULL);
		_tmp7_ = _tmp6_;
		_g_free0 (_tmp4_);
		_tmp0_ = _tmp7_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp8_ = _tmp0_;
		_tmp0_ = NULL;
		result = _tmp8_;
		_g_free0 (_tmp0_);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp9_;
		const gchar* _tmp10_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp9_ = err;
		_tmp10_ = _tmp9_->message;
		g_critical ("OAuth1Authenticator.vala:143: Failed to lookup auth-token-secret from " \
"password store: %s", _tmp10_);
		result = NULL;
		_g_error_free0 (err);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

void
publishing_authenticator_shotwell_oauth1_authenticator_set_persistent_access_phase_token_secret (PublishingAuthenticatorShotwellOAuth1Authenticator* self,
                                                                                                 const gchar* secret)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (PUBLISHING_AUTHENTICATOR_SHOTWELL_OAUTH1_IS_AUTHENTICATOR (self));
	{
		gboolean _tmp0_ = FALSE;
		if (secret == NULL) {
			_tmp0_ = TRUE;
		} else {
			_tmp0_ = g_strcmp0 (secret, "") == 0;
		}
		if (_tmp0_) {
			SecretSchema* _tmp1_;
			SpitPublishingPluginHost* _tmp2_;
			gchar* _tmp3_;
			gchar* _tmp4_;
			const gchar* _tmp5_;
			_tmp1_ = self->priv->schema;
			_tmp2_ = self->host;
			_tmp3_ = spit_publishing_plugin_host_get_current_profile_id (_tmp2_);
			_tmp4_ = _tmp3_;
			_tmp5_ = self->priv->accountname;
			secret_password_clear_sync (_tmp1_, NULL, &_inner_error0_, PUBLISHING_AUTHENTICATOR_SHOTWELL_OAUTH1_AUTHENTICATOR_SCHEMA_KEY_PROFILE_ID, _tmp4_, PUBLISHING_AUTHENTICATOR_SHOTWELL_OAUTH1_AUTHENTICATOR_SCHEMA_KEY_ACCOUNTNAME, _tmp5_, "type", PUBLISHING_AUTHENTICATOR_SHOTWELL_OAUTH1_AUTHENTICATOR_SECRET_TYPE_AUTH_TOKEN_SECRET, NULL);
			_g_free0 (_tmp4_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		} else {
			SecretSchema* _tmp6_;
			const gchar* _tmp7_;
			const gchar* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			SpitPublishingPluginHost* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			const gchar* _tmp14_;
			_tmp6_ = self->priv->schema;
			_tmp7_ = self->priv->accountname;
			_tmp8_ = self->priv->service;
			_tmp9_ = g_strdup_printf ("Shotwell publishing (%s@%s)", _tmp7_, _tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = self->host;
			_tmp12_ = spit_publishing_plugin_host_get_current_profile_id (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = self->priv->accountname;
			secret_password_store_sync (_tmp6_, SECRET_COLLECTION_DEFAULT, _tmp10_, secret, NULL, &_inner_error0_, PUBLISHING_AUTHENTICATOR_SHOTWELL_OAUTH1_AUTHENTICATOR_SCHEMA_KEY_PROFILE_ID, _tmp13_, PUBLISHING_AUTHENTICATOR_SHOTWELL_OAUTH1_AUTHENTICATOR_SCHEMA_KEY_ACCOUNTNAME, _tmp14_, "type", PUBLISHING_AUTHENTICATOR_SHOTWELL_OAUTH1_AUTHENTICATOR_SECRET_TYPE_AUTH_TOKEN_SECRET, NULL);
			_g_free0 (_tmp13_);
			_g_free0 (_tmp10_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp15_;
		const gchar* _tmp16_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp15_ = err;
		_tmp16_ = _tmp15_->message;
		g_critical ("OAuth1Authenticator.vala:164: Failed to store auth-token-secret store:" \
" %s", _tmp16_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static GVariant*
_variant_new3 (gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static GVariant*
_variant_new4 (gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static GVariant*
_variant_new5 (gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

void
publishing_authenticator_shotwell_oauth1_authenticator_on_session_authenticated (PublishingAuthenticatorShotwellOAuth1Authenticator* self)
{
	GHashTable* _tmp0_;
	gchar* _tmp1_;
	PublishingRESTSupportOAuth1Session* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GVariant* _tmp5_;
	GHashTable* _tmp6_;
	gchar* _tmp7_;
	PublishingRESTSupportOAuth1Session* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GVariant* _tmp11_;
	GHashTable* _tmp12_;
	gchar* _tmp13_;
	PublishingRESTSupportOAuth1Session* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	GVariant* _tmp17_;
	PublishingRESTSupportOAuth1Session* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	PublishingRESTSupportOAuth1Session* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	PublishingRESTSupportOAuth1Session* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	g_return_if_fail (PUBLISHING_AUTHENTICATOR_SHOTWELL_OAUTH1_IS_AUTHENTICATOR (self));
	_tmp0_ = self->params;
	_tmp1_ = g_strdup ("AuthToken");
	_tmp2_ = self->session;
	_tmp3_ = publishing_rest_support_oauth1_session_get_access_phase_token (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _variant_new3 (_tmp4_);
	g_hash_table_insert (_tmp0_, _tmp1_, _tmp5_);
	_g_free0 (_tmp4_);
	_tmp6_ = self->params;
	_tmp7_ = g_strdup ("AuthTokenSecret");
	_tmp8_ = self->session;
	_tmp9_ = publishing_rest_support_oauth1_session_get_access_phase_token_secret (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = _variant_new4 (_tmp10_);
	g_hash_table_insert (_tmp6_, _tmp7_, _tmp11_);
	_g_free0 (_tmp10_);
	_tmp12_ = self->params;
	_tmp13_ = g_strdup ("Username");
	_tmp14_ = self->session;
	_tmp15_ = publishing_rest_support_oauth1_session_get_username (_tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = _variant_new5 (_tmp16_);
	g_hash_table_insert (_tmp12_, _tmp13_, _tmp17_);
	_g_free0 (_tmp16_);
	_tmp18_ = self->session;
	_tmp19_ = publishing_rest_support_oauth1_session_get_access_phase_token (_tmp18_);
	_tmp20_ = _tmp19_;
	publishing_authenticator_shotwell_oauth1_authenticator_set_persistent_access_phase_token (self, _tmp20_);
	_g_free0 (_tmp20_);
	_tmp21_ = self->session;
	_tmp22_ = publishing_rest_support_oauth1_session_get_access_phase_token_secret (_tmp21_);
	_tmp23_ = _tmp22_;
	publishing_authenticator_shotwell_oauth1_authenticator_set_persistent_access_phase_token_secret (self, _tmp23_);
	_g_free0 (_tmp23_);
	_tmp24_ = self->session;
	_tmp25_ = publishing_rest_support_oauth1_session_get_username (_tmp24_);
	_tmp26_ = _tmp25_;
	publishing_authenticator_shotwell_oauth1_authenticator_set_persistent_access_phase_username (self, _tmp26_);
	_g_free0 (_tmp26_);
	g_signal_emit_by_name (G_TYPE_CHECK_INSTANCE_CAST (self, SPIT_PUBLISHING_TYPE_AUTHENTICATOR, SpitPublishingAuthenticator), "authenticated");
}

static void
publishing_authenticator_shotwell_oauth1_authenticator_class_init (PublishingAuthenticatorShotwellOAuth1AuthenticatorClass * klass,
                                                                   gpointer klass_data)
{
	publishing_authenticator_shotwell_oauth1_authenticator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PublishingAuthenticatorShotwellOAuth1Authenticator_private_offset);
	((PublishingAuthenticatorShotwellOAuth1AuthenticatorClass *) klass)->authenticate = (void (*) (PublishingAuthenticatorShotwellOAuth1Authenticator*)) publishing_authenticator_shotwell_oauth1_authenticator_real_authenticate;
	((PublishingAuthenticatorShotwellOAuth1AuthenticatorClass *) klass)->can_logout = (gboolean (*) (PublishingAuthenticatorShotwellOAuth1Authenticator*)) publishing_authenticator_shotwell_oauth1_authenticator_real_can_logout;
	((PublishingAuthenticatorShotwellOAuth1AuthenticatorClass *) klass)->logout = (void (*) (PublishingAuthenticatorShotwellOAuth1Authenticator*)) publishing_authenticator_shotwell_oauth1_authenticator_real_logout;
	((PublishingAuthenticatorShotwellOAuth1AuthenticatorClass *) klass)->refresh = (void (*) (PublishingAuthenticatorShotwellOAuth1Authenticator*)) publishing_authenticator_shotwell_oauth1_authenticator_real_refresh;
	((PublishingAuthenticatorShotwellOAuth1AuthenticatorClass *) klass)->set_accountname = (void (*) (PublishingAuthenticatorShotwellOAuth1Authenticator*, const gchar*)) publishing_authenticator_shotwell_oauth1_authenticator_real_set_accountname;
	G_OBJECT_CLASS (klass)->finalize = publishing_authenticator_shotwell_oauth1_authenticator_finalize;
}

static void
publishing_authenticator_shotwell_oauth1_authenticator_spit_publishing_authenticator_interface_init (SpitPublishingAuthenticatorIface * iface,
                                                                                                     gpointer iface_data)
{
	publishing_authenticator_shotwell_oauth1_authenticator_spit_publishing_authenticator_parent_iface = g_type_interface_peek_parent (iface);
	iface->authenticate = (void (*) (SpitPublishingAuthenticator*)) publishing_authenticator_shotwell_oauth1_authenticator_authenticate;
	iface->can_logout = (gboolean (*) (SpitPublishingAuthenticator*)) publishing_authenticator_shotwell_oauth1_authenticator_can_logout;
	iface->get_authentication_parameter = (GHashTable* (*) (SpitPublishingAuthenticator*)) publishing_authenticator_shotwell_oauth1_authenticator_real_get_authentication_parameter;
	iface->logout = (void (*) (SpitPublishingAuthenticator*)) publishing_authenticator_shotwell_oauth1_authenticator_logout;
	iface->refresh = (void (*) (SpitPublishingAuthenticator*)) publishing_authenticator_shotwell_oauth1_authenticator_refresh;
	iface->set_accountname = (void (*) (SpitPublishingAuthenticator*, const gchar*)) publishing_authenticator_shotwell_oauth1_authenticator_set_accountname;
}

static void
publishing_authenticator_shotwell_oauth1_authenticator_instance_init (PublishingAuthenticatorShotwellOAuth1Authenticator * self,
                                                                      gpointer klass)
{
	gchar* _tmp0_;
	self->priv = publishing_authenticator_shotwell_oauth1_authenticator_get_instance_private (self);
	self->priv->schema = NULL;
	self->priv->service = NULL;
	_tmp0_ = g_strdup ("default");
	self->priv->accountname = _tmp0_;
}

static void
publishing_authenticator_shotwell_oauth1_authenticator_finalize (GObject * obj)
{
	PublishingAuthenticatorShotwellOAuth1Authenticator * self;
	PublishingRESTSupportOAuth1Session* _tmp0_;
	guint _tmp1_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PUBLISHING_AUTHENTICATOR_SHOTWELL_OAUTH1_TYPE_AUTHENTICATOR, PublishingAuthenticatorShotwellOAuth1Authenticator);
	_tmp0_ = self->session;
	g_signal_parse_name ("authenticated", PUBLISHING_REST_SUPPORT_TYPE_SESSION, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, PUBLISHING_REST_SUPPORT_TYPE_SESSION, PublishingRESTSupportSession), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _publishing_authenticator_shotwell_oauth1_authenticator_on_session_authenticated_publishing_rest_support_session_authenticated, self);
	_g_hash_table_unref0 (self->params);
	_publishing_rest_support_session_unref0 (self->session);
	_g_object_unref0 (self->host);
	_secret_schema_unref0 (self->priv->schema);
	_g_free0 (self->priv->service);
	_g_free0 (self->priv->accountname);
	G_OBJECT_CLASS (publishing_authenticator_shotwell_oauth1_authenticator_parent_class)->finalize (obj);
}

static GType
publishing_authenticator_shotwell_oauth1_authenticator_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PublishingAuthenticatorShotwellOAuth1AuthenticatorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) publishing_authenticator_shotwell_oauth1_authenticator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PublishingAuthenticatorShotwellOAuth1Authenticator), 0, (GInstanceInitFunc) publishing_authenticator_shotwell_oauth1_authenticator_instance_init, NULL };
	static const GInterfaceInfo spit_publishing_authenticator_info = { (GInterfaceInitFunc) publishing_authenticator_shotwell_oauth1_authenticator_spit_publishing_authenticator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType publishing_authenticator_shotwell_oauth1_authenticator_type_id;
	publishing_authenticator_shotwell_oauth1_authenticator_type_id = g_type_register_static (G_TYPE_OBJECT, "PublishingAuthenticatorShotwellOAuth1Authenticator", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	g_type_add_interface_static (publishing_authenticator_shotwell_oauth1_authenticator_type_id, SPIT_PUBLISHING_TYPE_AUTHENTICATOR, &spit_publishing_authenticator_info);
	PublishingAuthenticatorShotwellOAuth1Authenticator_private_offset = g_type_add_instance_private (publishing_authenticator_shotwell_oauth1_authenticator_type_id, sizeof (PublishingAuthenticatorShotwellOAuth1AuthenticatorPrivate));
	return publishing_authenticator_shotwell_oauth1_authenticator_type_id;
}

GType
publishing_authenticator_shotwell_oauth1_authenticator_get_type (void)
{
	static volatile gsize publishing_authenticator_shotwell_oauth1_authenticator_type_id__once = 0;
	if (g_once_init_enter (&publishing_authenticator_shotwell_oauth1_authenticator_type_id__once)) {
		GType publishing_authenticator_shotwell_oauth1_authenticator_type_id;
		publishing_authenticator_shotwell_oauth1_authenticator_type_id = publishing_authenticator_shotwell_oauth1_authenticator_get_type_once ();
		g_once_init_leave (&publishing_authenticator_shotwell_oauth1_authenticator_type_id__once, publishing_authenticator_shotwell_oauth1_authenticator_type_id);
	}
	return publishing_authenticator_shotwell_oauth1_authenticator_type_id__once;
}

