#ifndef __SOURCE4_DSDB_SCHEMA_PROTO_H__
#define __SOURCE4_DSDB_SCHEMA_PROTO_H__

#undef _PRINTF_ATTRIBUTE
#define _PRINTF_ATTRIBUTE(a1, a2) PRINTF_ATTRIBUTE(a1, a2)
/* This file was automatically generated by mkproto.pl. DO NOT EDIT */

/* this file contains prototypes for functions that are private 
 * to this subsystem or library. These functions should not be 
 * used outside this particular subsystem! */


/* The following definitions come from ../../source4/dsdb/schema/schema_init.c  */

struct dsdb_schema *dsdb_new_schema(TALLOC_CTX *mem_ctx);
struct dsdb_schema *dsdb_schema_copy_shallow(TALLOC_CTX *mem_ctx,
					     struct ldb_context *ldb,
					     const struct dsdb_schema *schema);
WERROR dsdb_load_prefixmap_from_drsuapi(struct dsdb_schema *schema,
					const struct drsuapi_DsReplicaOIDMapping_Ctr *ctr);
WERROR dsdb_load_oid_mappings_ldb(struct dsdb_schema *schema,
				  const struct ldb_val *prefixMap,
				  const struct ldb_val *schemaInfo);
WERROR dsdb_get_oid_mappings_drsuapi(const struct dsdb_schema *schema,
				     bool include_schema_info,
				     TALLOC_CTX *mem_ctx,
				     struct drsuapi_DsReplicaOIDMapping_Ctr **_ctr);
WERROR dsdb_get_drsuapi_prefixmap_as_blob(const struct drsuapi_DsReplicaOIDMapping_Ctr *ctr,
					  TALLOC_CTX *mem_ctx,
					  struct ldb_val *prefixMap);
WERROR dsdb_get_oid_mappings_ldb(const struct dsdb_schema *schema,
				 TALLOC_CTX *mem_ctx,
				 struct ldb_val *prefixMap,
				 struct ldb_val *schemaInfo);
WERROR dsdb_create_prefix_mapping(struct ldb_context *ldb, struct dsdb_schema *schema, const char *full_oid);
WERROR dsdb_write_prefixes_from_schema_to_ldb(TALLOC_CTX *mem_ctx, struct ldb_context *ldb,
					      const struct dsdb_schema *schema);
WERROR dsdb_read_prefixes_from_ldb(struct ldb_context *ldb, TALLOC_CTX *mem_ctx, struct dsdb_schema_prefixmap **_pfm);

/** Create an dsdb_attribute out of ldb message, attr must be already talloced
 *
 * If supplied the attribute will be checked against the prefixmap to
 * ensure it can be mapped.  However we can't have this attribute
 * const as dsdb_schema_pfm_attid_from_oid calls
 * dsdb_schema_pfm_make_attid_impl() which may modify prefixmap in
 * other situations.
 */
WERROR dsdb_attribute_from_ldb(struct dsdb_schema_prefixmap *prefixmap,
			       struct ldb_message *msg,
			       struct dsdb_attribute *attr);
WERROR dsdb_set_attribute_from_ldb_dups(struct ldb_context *ldb,
					struct dsdb_schema *schema,
					struct ldb_message *msg,
					bool checkdups);
WERROR dsdb_set_attribute_from_ldb(struct ldb_context *ldb,
				   struct dsdb_schema *schema,
				   struct ldb_message *msg);
WERROR dsdb_set_class_from_ldb_dups(struct dsdb_schema *schema,
				    struct ldb_message *msg,
				    bool checkdups);
WERROR dsdb_set_class_from_ldb(struct dsdb_schema *schema,
			       struct ldb_message *msg);
int dsdb_load_ldb_results_into_schema(TALLOC_CTX *mem_ctx, struct ldb_context *ldb,
				      struct dsdb_schema *schema,
				      struct ldb_result *attrs_class_res,
				      char **error_string);
int dsdb_schema_from_ldb_results(TALLOC_CTX *mem_ctx, struct ldb_context *ldb,
				 struct ldb_message *schema_msg,
				 struct ldb_result *attrs_class_res,
				 struct dsdb_schema **schema_out,
				 char **error_string);

/* The following definitions come from ../../source4/dsdb/schema/schema_set.c  */

const struct ldb_schema_attribute *dsdb_attribute_handler_override(struct ldb_context *ldb,
								   void *private_data,
								   const char *name);
int dsdb_schema_set_indices_and_attributes(struct ldb_context *ldb,
					   struct dsdb_schema *schema,
					   enum schema_set_enum mode);

/**
 * Clean up Classes and Attributes accessor arrays
 */
int dsdb_setup_sorted_accessors(struct ldb_context *ldb,
				struct dsdb_schema *schema);

/**
 * Attach the schema to an opaque pointer on the ldb,
 * so ldb modules can find it
 */
int dsdb_set_schema_refresh_function(struct ldb_context *ldb,
				     dsdb_schema_refresh_fn refresh_fn,
				     struct ldb_module *module);

/**
 * Attach the schema to an opaque pointer on the ldb,
 * so ldb modules can find it
 */
int dsdb_set_schema(struct ldb_context *ldb,
		    struct dsdb_schema *schema,
		    enum schema_set_enum write_indices_and_attributes);

/**
 * Make this ldb use a specified schema, already fully calculated and belonging to another ldb
 *
 * The write_indices_and_attributes controls writing of the @ records
 * because we cannot write to a database that does not yet exist on
 * disk.
 */
int dsdb_reference_schema(struct ldb_context *ldb, struct dsdb_schema *schema,
			  enum schema_set_enum write_indices_and_attributes);

/**
 * Make this ldb use the 'global' schema, setup to avoid having multiple copies in this process
 */
int dsdb_set_global_schema(struct ldb_context *ldb);
bool dsdb_uses_global_schema(struct ldb_context *ldb);

/**
 * Find the schema object for this ldb
 *
 * If reference_ctx is not NULL, then talloc_reference onto that context
 */
struct dsdb_schema *dsdb_get_schema(struct ldb_context *ldb, TALLOC_CTX *reference_ctx);

/**
 * Make the schema found on this ldb the 'global' schema
 */
void dsdb_make_schema_global(struct ldb_context *ldb, struct dsdb_schema *schema);

/**
 * When loading the schema from LDIF files, we don't get the extended DNs.
 *
 * We need to set these up, so that from the moment we start the provision,
 * the defaultObjectCategory links are set up correctly.
 */
int dsdb_schema_fill_extended_dn(struct ldb_context *ldb, struct dsdb_schema *schema);

/**
 * @brief Add a new element to the schema and checks if it's a duplicate
 *
 * This function will add a new element to the schema and checks for existing
 * duplicates.
 *
 * @param[in]  ldb                A pointer to an LDB context
 *
 * @param[in]  schema             A pointer to the dsdb_schema where the element
 *                                will be added.
 *
 * @param[in]  msg                The ldb_message object representing the element
 *                                to add.
 *
 * @param[in]  checkdups          A boolean to indicate if checks for duplicates
 *                                should be done.
 *
 * @return                        A WERROR code
 */
WERROR dsdb_schema_set_el_from_ldb_msg_dups(struct ldb_context *ldb, struct dsdb_schema *schema,
					    struct ldb_message *msg, bool checkdups);
WERROR dsdb_schema_set_el_from_ldb_msg(struct ldb_context *ldb,
				       struct dsdb_schema *schema,
				       struct ldb_message *msg);

/**
 * Rather than read a schema from the LDB itself, read it from an ldif
 * file.  This allows schema to be loaded and used while adding the
 * schema itself to the directory.
 *
 * Should be called with a transaction (or failing that, have no concurrent
 * access while called).
 */
WERROR dsdb_set_schema_from_ldif(struct ldb_context *ldb,
				 const char *pf, const char *df,
				 const char *dn);

/* The following definitions come from ../../source4/dsdb/schema/schema_query.c  */

const struct dsdb_attribute *dsdb_attribute_by_attributeID_id(const struct dsdb_schema *schema,
							      uint32_t id);
const struct dsdb_attribute *dsdb_attribute_by_attributeID_oid(const struct dsdb_schema *schema,
							       const char *oid);
const struct dsdb_attribute *dsdb_attribute_by_lDAPDisplayName(const struct dsdb_schema *schema,
							       const char *name);
const struct dsdb_attribute *dsdb_attribute_by_lDAPDisplayName_ldb_val(const struct dsdb_schema *schema,
								       const struct ldb_val *name);
const struct dsdb_attribute *dsdb_attribute_by_linkID(const struct dsdb_schema *schema,
						      int linkID);
const struct dsdb_attribute *dsdb_attribute_by_cn_ldb_val(const struct dsdb_schema *schema,
							  const struct ldb_val *cn);
const struct dsdb_class *dsdb_class_by_governsID_id(const struct dsdb_schema *schema,
						    uint32_t id);
const struct dsdb_class *dsdb_class_by_governsID_oid(const struct dsdb_schema *schema,
						     const char *oid);
const struct dsdb_class *dsdb_class_by_lDAPDisplayName(const struct dsdb_schema *schema,
						       const char *name);
const struct dsdb_class *dsdb_class_by_lDAPDisplayName_ldb_val(const struct dsdb_schema *schema,
							       const struct ldb_val *name);
const struct dsdb_class *dsdb_class_by_cn_ldb_val(const struct dsdb_schema *schema,
						  const struct ldb_val *cn);
const char *dsdb_lDAPDisplayName_by_id(const struct dsdb_schema *schema,
				       uint32_t id);

/**
    Return a list of linked attributes, in lDAPDisplayName format.

    This may be used to determine if a modification would require
    backlinks to be updated, for example
*/
WERROR dsdb_linked_attribute_lDAPDisplayName_list(const struct dsdb_schema *schema, TALLOC_CTX *mem_ctx, const char ***attr_list_ret);
const char **merge_attr_list(TALLOC_CTX *mem_ctx,
		       const char **attrs, const char * const*new_attrs);
const char **dsdb_attribute_list(TALLOC_CTX *mem_ctx, const struct dsdb_class *sclass, enum dsdb_attr_list_query query);
const char **dsdb_full_attribute_list(TALLOC_CTX *mem_ctx,
				      const struct dsdb_schema *schema,
				      const struct ldb_message_element *class_list,
				      enum dsdb_attr_list_query query);
const struct GUID *class_schemaid_guid_by_lDAPDisplayName(const struct dsdb_schema *schema,
                                                          const char *name);
const struct GUID *attribute_schemaid_guid_by_lDAPDisplayName(const struct dsdb_schema *schema,
							      const char *name);
int dsdb_sort_objectClass_attr(struct ldb_context *ldb,
			       const struct dsdb_schema *schema,
			       const struct ldb_message_element *objectclass_element,
			       TALLOC_CTX *mem_ctx,
			       struct ldb_message_element *out_objectclass_element);

/* The following definitions come from ../../source4/dsdb/schema/schema_syntax.c  */


/**
 * Initialize dsdb_syntax_ctx with default values
 * for common cases.
 */
void dsdb_syntax_ctx_init(struct dsdb_syntax_ctx *ctx,
			  struct ldb_context *ldb,
			  const struct dsdb_schema *schema);

/**
 * Returns ATTID for DRS attribute.
 *
 * ATTID depends on whether we are replicating
 * Schema NC or msDs-IntId is set for schemaAttribute
 * for the attribute.
 */
uint32_t dsdb_attribute_get_attid(const struct dsdb_attribute *attr,
				  bool for_schema_nc);

/**
 * Map an ATTID from remote DC to a local ATTID
 * using remote prefixMap
 */
const struct dsdb_syntax *find_syntax_map_by_ad_oid(const char *ad_oid);
const struct dsdb_syntax *find_syntax_map_by_ad_syntax(int oMSyntax);
const struct dsdb_syntax *find_syntax_map_by_standard_oid(const char *standard_oid);
const struct dsdb_syntax *dsdb_syntax_for_attribute(const struct dsdb_attribute *attr);
WERROR dsdb_attribute_drsuapi_remote_to_local(const struct dsdb_syntax_ctx *ctx,
					      enum drsuapi_DsAttributeId remote_attid_as_enum,
					      enum drsuapi_DsAttributeId *local_attid_as_enum,
					      const struct dsdb_attribute **_sa);
WERROR dsdb_attribute_drsuapi_to_ldb(struct ldb_context *ldb,
				     const struct dsdb_schema *schema,
				     const struct dsdb_schema_prefixmap *pfm_remote,
				     const struct drsuapi_DsReplicaAttribute *in,
				     TALLOC_CTX *mem_ctx,
				     struct ldb_message_element *out,
				     enum drsuapi_DsAttributeId *local_attid_as_enum);

/* The following definitions come from ../../source4/dsdb/schema/schema_description.c  */

char *schema_attribute_description(TALLOC_CTX *mem_ctx, 
					  enum dsdb_schema_convert_target target,
					  const char *separator,
					  const char *oid, 
					  const char *name,
					  const char *equality, 
					  const char *substring, 
					  const char *syntax,
					  bool single_value, bool operational,
					  uint32_t *range_lower,
					  uint32_t *range_upper,
					  const char *property_guid,
					  const char *property_set_guid,
					  bool indexed, bool system_only);
char *schema_attribute_to_description(TALLOC_CTX *mem_ctx, const struct dsdb_attribute *attribute) ;
char *schema_attribute_to_extendedInfo(TALLOC_CTX *mem_ctx, const struct dsdb_attribute *attribute);
char *schema_class_description(TALLOC_CTX *mem_ctx, 
			       enum dsdb_schema_convert_target target,
			       const char *separator,
			       const char *oid, 
			       const char *name,
			       const char **auxillary_classes,
			       const char *subClassOf,
			       int objectClassCategory,
			       const char **must,
			       const char **may,
			       const char *schemaHexGUID);
char *schema_class_to_description(TALLOC_CTX *mem_ctx, const struct dsdb_class *sclass);
char *schema_class_to_dITContentRule(TALLOC_CTX *mem_ctx, const struct dsdb_class *sclass,
				     const struct dsdb_schema *schema);
char *schema_class_to_extendedInfo(TALLOC_CTX *mem_ctx, const struct dsdb_class *sclass);

/* The following definitions come from ../../source4/dsdb/schema/schema_convert_to_ol.c  */

char *dsdb_convert_schema_to_openldap(struct ldb_context *ldb, char *target_str, const char *mappings);

/* The following definitions come from ../../source4/dsdb/schema/schema_inferiors.c  */

int schema_fill_constructed(const struct dsdb_schema *schema);

/* The following definitions come from ../../source4/dsdb/schema/schema_prefixmap.c  */


/**
 * Determine range type for supplied ATTID
 */
enum dsdb_attid_type dsdb_pfm_get_attid_type(uint32_t attid);

/**
 * Initial prefixMap creation according to:
 * [MS-DRSR] section 5.12.2
 */
WERROR dsdb_schema_pfm_new(TALLOC_CTX *mem_ctx, struct dsdb_schema_prefixmap **_pfm);
struct dsdb_schema_prefixmap *dsdb_schema_pfm_copy_shallow(TALLOC_CTX *mem_ctx,
							   const struct dsdb_schema_prefixmap *pfm);

/**
 * Adds oid to prefix map.
 * On success returns ID for newly added index
 * or ID of existing entry that matches oid
 * Reference: [MS-DRSR] section 5.12.2
 *
 * \param pfm prefixMap
 * \param bin_oid OID prefix to be added to prefixMap
 * \param pfm_id Location where to store prefixMap entry ID
 */
WERROR dsdb_schema_pfm_add_entry(struct dsdb_schema_prefixmap *pfm,
				 DATA_BLOB bin_oid,
				 const uint32_t *remote_id,
				 uint32_t *_idx);

/**
 * Lookup partial-binary-oid in prefixMap
 */
WERROR dsdb_schema_pfm_find_binary_oid(const struct dsdb_schema_prefixmap *pfm,
				       DATA_BLOB bin_oid,
				       uint32_t *_idx);

/**
 * Lookup full-oid in prefixMap
 * Note: this may be slow.
 */
WERROR dsdb_schema_pfm_find_oid(const struct dsdb_schema_prefixmap *pfm,
				const char *full_oid,
				uint32_t *_idx);

/**
 * Make ATTID for given OID
 * Reference: [MS-DRSR] section 5.12.2
 *
 * Note: This function may change prefixMap if prefix
 * for supplied 'oid' doesn't exists yet.
 * It is recommended to be used mostly when caller
 * want to add new prefixes.
 * Otherwise dsdb_schema_pfm_attid_from_oid() should be used.
 */
WERROR dsdb_schema_pfm_make_attid(struct dsdb_schema_prefixmap *pfm,
				  const char *oid,
				  uint32_t *attid);

/**
 * Make ATTID for given OID
 * Reference: [MS-DRSR] section 5.12.2
 */
WERROR dsdb_schema_pfm_attid_from_oid(struct dsdb_schema_prefixmap *pfm,
				      const char *oid,
				      uint32_t *attid);

/**
 * Make OID for given ATTID.
 * Reference: [MS-DRSR] section 5.12.2
 */
WERROR dsdb_schema_pfm_oid_from_attid(const struct dsdb_schema_prefixmap *pfm,
				      uint32_t attid,
				      TALLOC_CTX *mem_ctx, const char **_oid);

/**
 * Convert drsuapi_ prefix map to prefixMap internal presentation.
 *
 * \param ctr Pointer to drsuapi_DsReplicaOIDMapping_Ctr which represents drsuapi_ prefixMap
 * \param have_schema_info if drsuapi_prefixMap have schem_info in it or not
 * \param mem_ctx TALLOC_CTX to make allocations in
 * \param _pfm Out pointer to hold newly created prefixMap
 * \param _schema_info Out param to store schema_info to. If NULL, schema_info is not decoded
 */
WERROR dsdb_schema_pfm_from_drsuapi_pfm(const struct drsuapi_DsReplicaOIDMapping_Ctr *ctr,
					bool have_schema_info,
					TALLOC_CTX *mem_ctx,
					struct dsdb_schema_prefixmap **_pfm,
					struct dsdb_schema_info **_schema_info);

/**
 * Convert drsuapi_ prefix map to prefixMap internal presentation.
 *
 * \param pfm Schema prefixMap to be converted
 * \param schema_info schema_info string - if NULL, we don't need it
 * \param mem_ctx TALLOC_CTX to make allocations in
 * \param _ctr Out pointer to drsuapi_DsReplicaOIDMapping_Ctr prefix map structure
 */
WERROR dsdb_drsuapi_pfm_from_schema_pfm(const struct dsdb_schema_prefixmap *pfm,
					const struct dsdb_schema_info *schema_info,
					TALLOC_CTX *mem_ctx,
					struct drsuapi_DsReplicaOIDMapping_Ctr **_ctr);

/**
 * Verifies schema prefixMap and drsuapi prefixMap are same.
 * Note that we just need to verify pfm contains prefixes
 * from ctr, not that those prefixes has same id_prefix.
 */
WERROR dsdb_schema_pfm_contains_drsuapi_pfm(const struct dsdb_schema_prefixmap *pfm,
					    const struct drsuapi_DsReplicaOIDMapping_Ctr *ctr);

/* The following definitions come from ../../source4/dsdb/schema/schema_info_attr.c  */


/**
 * Creates and initializes new dsdb_schema_info value.
 * Initial schemaInfo values is with:
 *   revision = 0
 *   invocationId = GUID_ZERO
 */
WERROR dsdb_schema_info_new(TALLOC_CTX *mem_ctx, struct dsdb_schema_info **_schema_info);

/**
 * Creates and initializes new dsdb_schema_info blob value.
 * Initial schemaInfo values is with:
 *   revision = 0
 *   invocationId = GUID_ZERO
 */
WERROR dsdb_schema_info_blob_new(TALLOC_CTX *mem_ctx, DATA_BLOB *_schema_info_blob);

/**
 * Verify the 'blob' is a valid schemaInfo blob
 */
bool dsdb_schema_info_blob_is_valid(const DATA_BLOB *blob);

/**
 * Parse schemaInfo structure from a data_blob
 * (DATA_BLOB or ldb_val).
 * Suitable for parsing blobs that come from
 * DRS interface or from LDB database
 */
WERROR dsdb_schema_info_from_blob(const DATA_BLOB *blob,
				  TALLOC_CTX *mem_ctx, struct dsdb_schema_info **_schema_info);

/**
 * Creates a blob from schemaInfo structure
 * Suitable for packing schemaInfo into a blob
 * which is to be used in DRS interface of LDB database
 */
WERROR dsdb_blob_from_schema_info(const struct dsdb_schema_info *schema_info,
				  TALLOC_CTX *mem_ctx, DATA_BLOB *blob);

/**
 * Compares schemaInfo signatures in dsdb_schema and prefixMap.
 * NOTE: At present function compares schemaInfo values
 * as string without taking into account schemaVersion field
 *
 * @return WERR_OK if schemaInfos are equal
 * 	   WERR_DS_DRA_SCHEMA_MISMATCH if schemaInfos are different
 */
WERROR dsdb_schema_info_cmp(const struct dsdb_schema *schema,
			    const struct drsuapi_DsReplicaOIDMapping_Ctr *ctr);

/* The following definitions come from ../../source4/dsdb/schema/schema_filtered.c  */

bool dsdb_attribute_is_attr_in_filtered_replica(struct dsdb_attribute *attribute);

/* The following definitions come from ../../source4/dsdb/schema/dsdb_dn.c  */

WERROR dsdb_dn_la_to_blob(struct ldb_context *sam_ctx,
			  const struct dsdb_attribute *schema_attrib,
			  const struct dsdb_schema *schema,
			  TALLOC_CTX *mem_ctx,
			  struct dsdb_dn *dsdb_dn, DATA_BLOB **blob);
WERROR dsdb_dn_la_from_blob(struct ldb_context *sam_ctx,
			    const struct dsdb_attribute *schema_attrib,
			    const struct dsdb_schema *schema,
			    TALLOC_CTX *mem_ctx,
			    DATA_BLOB *blob,
			    struct dsdb_dn **dsdb_dn);
#undef _PRINTF_ATTRIBUTE
#define _PRINTF_ATTRIBUTE(a1, a2)

#endif /* __SOURCE4_DSDB_SCHEMA_PROTO_H__ */

