#define _CFFI_

/* We try to define Py_LIMITED_API before including Python.h.

   Mess: we can only define it if Py_DEBUG, Py_TRACE_REFS and
   Py_REF_DEBUG are not defined.  This is a best-effort approximation:
   we can learn about Py_DEBUG from pyconfig.h, but it is unclear if
   the same works for the other two macros.  Py_DEBUG implies them,
   but not the other way around.

   The implementation is messy (issue #350): on Windows, with _MSC_VER,
   we have to define Py_LIMITED_API even before including pyconfig.h.
   In that case, we guess what pyconfig.h will do to the macros above,
   and check our guess after the #include.

   Note that on Windows, with CPython 3.x, you need >= 3.5 and virtualenv
   version >= 16.0.0.  With older versions of either, you don't get a
   copy of PYTHON3.DLL in the virtualenv.  We can't check the version of
   CPython *before* we even include pyconfig.h.  ffi.set_source() puts
   a ``#define _CFFI_NO_LIMITED_API'' at the start of this file if it is
   running on Windows < 3.5, as an attempt at fixing it, but that's
   arguably wrong because it may not be the target version of Python.
   Still better than nothing I guess.  As another workaround, you can
   remove the definition of Py_LIMITED_API here.

   See also 'py_limited_api' in cffi/setuptools_ext.py.
*/
#if !defined(_CFFI_USE_EMBEDDING) && !defined(Py_LIMITED_API)
#  ifdef _MSC_VER
#    if !defined(_DEBUG) && !defined(Py_DEBUG) && !defined(Py_TRACE_REFS) && !defined(Py_REF_DEBUG) && !defined(_CFFI_NO_LIMITED_API)
#      define Py_LIMITED_API
#    endif
#    include <pyconfig.h>
     /* sanity-check: Py_LIMITED_API will cause crashes if any of these
        are also defined.  Normally, the Python file PC/pyconfig.h does not
        cause any of these to be defined, with the exception that _DEBUG
        causes Py_DEBUG.  Double-check that. */
#    ifdef Py_LIMITED_API
#      if defined(Py_DEBUG)
#        error "pyconfig.h unexpectedly defines Py_DEBUG, but Py_LIMITED_API is set"
#      endif
#      if defined(Py_TRACE_REFS)
#        error "pyconfig.h unexpectedly defines Py_TRACE_REFS, but Py_LIMITED_API is set"
#      endif
#      if defined(Py_REF_DEBUG)
#        error "pyconfig.h unexpectedly defines Py_REF_DEBUG, but Py_LIMITED_API is set"
#      endif
#    endif
#  else
#    include <pyconfig.h>
#    if !defined(Py_DEBUG) && !defined(Py_TRACE_REFS) && !defined(Py_REF_DEBUG) && !defined(_CFFI_NO_LIMITED_API)
#      define Py_LIMITED_API
#    endif
#  endif
#endif

#include <Python.h>
#ifdef __cplusplus
extern "C" {
#endif
#include <stddef.h>

/* This part is from file 'cffi/parse_c_type.h'.  It is copied at the
   beginning of C sources generated by CFFI's ffi.set_source(). */

typedef void *_cffi_opcode_t;

#define _CFFI_OP(opcode, arg)   (_cffi_opcode_t)(opcode | (((uintptr_t)(arg)) << 8))
#define _CFFI_GETOP(cffi_opcode)    ((unsigned char)(uintptr_t)cffi_opcode)
#define _CFFI_GETARG(cffi_opcode)   (((intptr_t)cffi_opcode) >> 8)

#define _CFFI_OP_PRIMITIVE       1
#define _CFFI_OP_POINTER         3
#define _CFFI_OP_ARRAY           5
#define _CFFI_OP_OPEN_ARRAY      7
#define _CFFI_OP_STRUCT_UNION    9
#define _CFFI_OP_ENUM           11
#define _CFFI_OP_FUNCTION       13
#define _CFFI_OP_FUNCTION_END   15
#define _CFFI_OP_NOOP           17
#define _CFFI_OP_BITFIELD       19
#define _CFFI_OP_TYPENAME       21
#define _CFFI_OP_CPYTHON_BLTN_V 23   // varargs
#define _CFFI_OP_CPYTHON_BLTN_N 25   // noargs
#define _CFFI_OP_CPYTHON_BLTN_O 27   // O  (i.e. a single arg)
#define _CFFI_OP_CONSTANT       29
#define _CFFI_OP_CONSTANT_INT   31
#define _CFFI_OP_GLOBAL_VAR     33
#define _CFFI_OP_DLOPEN_FUNC    35
#define _CFFI_OP_DLOPEN_CONST   37
#define _CFFI_OP_GLOBAL_VAR_F   39
#define _CFFI_OP_EXTERN_PYTHON  41

#define _CFFI_PRIM_VOID          0
#define _CFFI_PRIM_BOOL          1
#define _CFFI_PRIM_CHAR          2
#define _CFFI_PRIM_SCHAR         3
#define _CFFI_PRIM_UCHAR         4
#define _CFFI_PRIM_SHORT         5
#define _CFFI_PRIM_USHORT        6
#define _CFFI_PRIM_INT           7
#define _CFFI_PRIM_UINT          8
#define _CFFI_PRIM_LONG          9
#define _CFFI_PRIM_ULONG        10
#define _CFFI_PRIM_LONGLONG     11
#define _CFFI_PRIM_ULONGLONG    12
#define _CFFI_PRIM_FLOAT        13
#define _CFFI_PRIM_DOUBLE       14
#define _CFFI_PRIM_LONGDOUBLE   15

#define _CFFI_PRIM_WCHAR        16
#define _CFFI_PRIM_INT8         17
#define _CFFI_PRIM_UINT8        18
#define _CFFI_PRIM_INT16        19
#define _CFFI_PRIM_UINT16       20
#define _CFFI_PRIM_INT32        21
#define _CFFI_PRIM_UINT32       22
#define _CFFI_PRIM_INT64        23
#define _CFFI_PRIM_UINT64       24
#define _CFFI_PRIM_INTPTR       25
#define _CFFI_PRIM_UINTPTR      26
#define _CFFI_PRIM_PTRDIFF      27
#define _CFFI_PRIM_SIZE         28
#define _CFFI_PRIM_SSIZE        29
#define _CFFI_PRIM_INT_LEAST8   30
#define _CFFI_PRIM_UINT_LEAST8  31
#define _CFFI_PRIM_INT_LEAST16  32
#define _CFFI_PRIM_UINT_LEAST16 33
#define _CFFI_PRIM_INT_LEAST32  34
#define _CFFI_PRIM_UINT_LEAST32 35
#define _CFFI_PRIM_INT_LEAST64  36
#define _CFFI_PRIM_UINT_LEAST64 37
#define _CFFI_PRIM_INT_FAST8    38
#define _CFFI_PRIM_UINT_FAST8   39
#define _CFFI_PRIM_INT_FAST16   40
#define _CFFI_PRIM_UINT_FAST16  41
#define _CFFI_PRIM_INT_FAST32   42
#define _CFFI_PRIM_UINT_FAST32  43
#define _CFFI_PRIM_INT_FAST64   44
#define _CFFI_PRIM_UINT_FAST64  45
#define _CFFI_PRIM_INTMAX       46
#define _CFFI_PRIM_UINTMAX      47
#define _CFFI_PRIM_FLOATCOMPLEX 48
#define _CFFI_PRIM_DOUBLECOMPLEX 49
#define _CFFI_PRIM_CHAR16       50
#define _CFFI_PRIM_CHAR32       51

#define _CFFI__NUM_PRIM         52
#define _CFFI__UNKNOWN_PRIM           (-1)
#define _CFFI__UNKNOWN_FLOAT_PRIM     (-2)
#define _CFFI__UNKNOWN_LONG_DOUBLE    (-3)

#define _CFFI__IO_FILE_STRUCT         (-1)


struct _cffi_global_s {
    const char *name;
    void *address;
    _cffi_opcode_t type_op;
    void *size_or_direct_fn;  // OP_GLOBAL_VAR: size, or 0 if unknown
                              // OP_CPYTHON_BLTN_*: addr of direct function
};

struct _cffi_getconst_s {
    unsigned long long value;
    const struct _cffi_type_context_s *ctx;
    int gindex;
};

struct _cffi_struct_union_s {
    const char *name;
    int type_index;          // -> _cffi_types, on a OP_STRUCT_UNION
    int flags;               // _CFFI_F_* flags below
    size_t size;
    int alignment;
    int first_field_index;   // -> _cffi_fields array
    int num_fields;
};
#define _CFFI_F_UNION         0x01   // is a union, not a struct
#define _CFFI_F_CHECK_FIELDS  0x02   // complain if fields are not in the
                                     // "standard layout" or if some are missing
#define _CFFI_F_PACKED        0x04   // for CHECK_FIELDS, assume a packed struct
#define _CFFI_F_EXTERNAL      0x08   // in some other ffi.include()
#define _CFFI_F_OPAQUE        0x10   // opaque

struct _cffi_field_s {
    const char *name;
    size_t field_offset;
    size_t field_size;
    _cffi_opcode_t field_type_op;
};

struct _cffi_enum_s {
    const char *name;
    int type_index;          // -> _cffi_types, on a OP_ENUM
    int type_prim;           // _CFFI_PRIM_xxx
    const char *enumerators; // comma-delimited string
};

struct _cffi_typename_s {
    const char *name;
    int type_index;   /* if opaque, points to a possibly artificial
                         OP_STRUCT which is itself opaque */
};

struct _cffi_type_context_s {
    _cffi_opcode_t *types;
    const struct _cffi_global_s *globals;
    const struct _cffi_field_s *fields;
    const struct _cffi_struct_union_s *struct_unions;
    const struct _cffi_enum_s *enums;
    const struct _cffi_typename_s *typenames;
    int num_globals;
    int num_struct_unions;
    int num_enums;
    int num_typenames;
    const char *const *includes;
    int num_types;
    int flags;      /* future extension */
};

struct _cffi_parse_info_s {
    const struct _cffi_type_context_s *ctx;
    _cffi_opcode_t *output;
    unsigned int output_size;
    size_t error_location;
    const char *error_message;
};

struct _cffi_externpy_s {
    const char *name;
    size_t size_of_result;
    void *reserved1, *reserved2;
};

#ifdef _CFFI_INTERNAL
static int parse_c_type(struct _cffi_parse_info_s *info, const char *input);
static int search_in_globals(const struct _cffi_type_context_s *ctx,
                             const char *search, size_t search_len);
static int search_in_struct_unions(const struct _cffi_type_context_s *ctx,
                                   const char *search, size_t search_len);
#endif

/* this block of #ifs should be kept exactly identical between
   c/_cffi_backend.c, cffi/vengine_cpy.py, cffi/vengine_gen.py
   and cffi/_cffi_include.h */
#if defined(_MSC_VER)
# include <malloc.h>   /* for alloca() */
# if _MSC_VER < 1600   /* MSVC < 2010 */
   typedef __int8 int8_t;
   typedef __int16 int16_t;
   typedef __int32 int32_t;
   typedef __int64 int64_t;
   typedef unsigned __int8 uint8_t;
   typedef unsigned __int16 uint16_t;
   typedef unsigned __int32 uint32_t;
   typedef unsigned __int64 uint64_t;
   typedef __int8 int_least8_t;
   typedef __int16 int_least16_t;
   typedef __int32 int_least32_t;
   typedef __int64 int_least64_t;
   typedef unsigned __int8 uint_least8_t;
   typedef unsigned __int16 uint_least16_t;
   typedef unsigned __int32 uint_least32_t;
   typedef unsigned __int64 uint_least64_t;
   typedef __int8 int_fast8_t;
   typedef __int16 int_fast16_t;
   typedef __int32 int_fast32_t;
   typedef __int64 int_fast64_t;
   typedef unsigned __int8 uint_fast8_t;
   typedef unsigned __int16 uint_fast16_t;
   typedef unsigned __int32 uint_fast32_t;
   typedef unsigned __int64 uint_fast64_t;
   typedef __int64 intmax_t;
   typedef unsigned __int64 uintmax_t;
# else
#  include <stdint.h>
# endif
# if _MSC_VER < 1800   /* MSVC < 2013 */
#  ifndef __cplusplus
    typedef unsigned char _Bool;
#  endif
# endif
# define _cffi_float_complex_t   _Fcomplex    /* include <complex.h> for it */
# define _cffi_double_complex_t  _Dcomplex    /* include <complex.h> for it */
#else
# include <stdint.h>
# if (defined (__SVR4) && defined (__sun)) || defined(_AIX) || defined(__hpux)
#  include <alloca.h>
# endif
# define _cffi_float_complex_t   float _Complex
# define _cffi_double_complex_t  double _Complex
#endif

#ifdef __GNUC__
# define _CFFI_UNUSED_FN  __attribute__((unused))
#else
# define _CFFI_UNUSED_FN  /* nothing */
#endif

#ifdef __cplusplus
# ifndef _Bool
   typedef bool _Bool;   /* semi-hackish: C++ has no _Bool; bool is builtin */
# endif
#endif

/**********  CPython-specific section  **********/
#ifndef PYPY_VERSION


#if PY_MAJOR_VERSION >= 3
# define PyInt_FromLong PyLong_FromLong
#endif

#define _cffi_from_c_double PyFloat_FromDouble
#define _cffi_from_c_float PyFloat_FromDouble
#define _cffi_from_c_long PyInt_FromLong
#define _cffi_from_c_ulong PyLong_FromUnsignedLong
#define _cffi_from_c_longlong PyLong_FromLongLong
#define _cffi_from_c_ulonglong PyLong_FromUnsignedLongLong
#define _cffi_from_c__Bool PyBool_FromLong

#define _cffi_to_c_double PyFloat_AsDouble
#define _cffi_to_c_float PyFloat_AsDouble

#define _cffi_from_c_int(x, type)                                        \
    (((type)-1) > 0 ? /* unsigned */                                     \
        (sizeof(type) < sizeof(long) ?                                   \
            PyInt_FromLong((long)x) :                                    \
         sizeof(type) == sizeof(long) ?                                  \
            PyLong_FromUnsignedLong((unsigned long)x) :                  \
            PyLong_FromUnsignedLongLong((unsigned long long)x)) :        \
        (sizeof(type) <= sizeof(long) ?                                  \
            PyInt_FromLong((long)x) :                                    \
            PyLong_FromLongLong((long long)x)))

#define _cffi_to_c_int(o, type)                                          \
    ((type)(                                                             \
     sizeof(type) == 1 ? (((type)-1) > 0 ? (type)_cffi_to_c_u8(o)        \
                                         : (type)_cffi_to_c_i8(o)) :     \
     sizeof(type) == 2 ? (((type)-1) > 0 ? (type)_cffi_to_c_u16(o)       \
                                         : (type)_cffi_to_c_i16(o)) :    \
     sizeof(type) == 4 ? (((type)-1) > 0 ? (type)_cffi_to_c_u32(o)       \
                                         : (type)_cffi_to_c_i32(o)) :    \
     sizeof(type) == 8 ? (((type)-1) > 0 ? (type)_cffi_to_c_u64(o)       \
                                         : (type)_cffi_to_c_i64(o)) :    \
     (Py_FatalError("unsupported size for type " #type), (type)0)))

#define _cffi_to_c_i8                                                    \
                 ((int(*)(PyObject *))_cffi_exports[1])
#define _cffi_to_c_u8                                                    \
                 ((int(*)(PyObject *))_cffi_exports[2])
#define _cffi_to_c_i16                                                   \
                 ((int(*)(PyObject *))_cffi_exports[3])
#define _cffi_to_c_u16                                                   \
                 ((int(*)(PyObject *))_cffi_exports[4])
#define _cffi_to_c_i32                                                   \
                 ((int(*)(PyObject *))_cffi_exports[5])
#define _cffi_to_c_u32                                                   \
                 ((unsigned int(*)(PyObject *))_cffi_exports[6])
#define _cffi_to_c_i64                                                   \
                 ((long long(*)(PyObject *))_cffi_exports[7])
#define _cffi_to_c_u64                                                   \
                 ((unsigned long long(*)(PyObject *))_cffi_exports[8])
#define _cffi_to_c_char                                                  \
                 ((int(*)(PyObject *))_cffi_exports[9])
#define _cffi_from_c_pointer                                             \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[10])
#define _cffi_to_c_pointer                                               \
    ((char *(*)(PyObject *, struct _cffi_ctypedescr *))_cffi_exports[11])
#define _cffi_get_struct_layout                                          \
    not used any more
#define _cffi_restore_errno                                              \
    ((void(*)(void))_cffi_exports[13])
#define _cffi_save_errno                                                 \
    ((void(*)(void))_cffi_exports[14])
#define _cffi_from_c_char                                                \
    ((PyObject *(*)(char))_cffi_exports[15])
#define _cffi_from_c_deref                                               \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[16])
#define _cffi_to_c                                                       \
    ((int(*)(char *, struct _cffi_ctypedescr *, PyObject *))_cffi_exports[17])
#define _cffi_from_c_struct                                              \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[18])
#define _cffi_to_c_wchar_t                                               \
    ((_cffi_wchar_t(*)(PyObject *))_cffi_exports[19])
#define _cffi_from_c_wchar_t                                             \
    ((PyObject *(*)(_cffi_wchar_t))_cffi_exports[20])
#define _cffi_to_c_long_double                                           \
    ((long double(*)(PyObject *))_cffi_exports[21])
#define _cffi_to_c__Bool                                                 \
    ((_Bool(*)(PyObject *))_cffi_exports[22])
#define _cffi_prepare_pointer_call_argument                              \
    ((Py_ssize_t(*)(struct _cffi_ctypedescr *,                           \
                    PyObject *, char **))_cffi_exports[23])
#define _cffi_convert_array_from_object                                  \
    ((int(*)(char *, struct _cffi_ctypedescr *, PyObject *))_cffi_exports[24])
#define _CFFI_CPIDX  25
#define _cffi_call_python                                                \
    ((void(*)(struct _cffi_externpy_s *, char *))_cffi_exports[_CFFI_CPIDX])
#define _cffi_to_c_wchar3216_t                                           \
    ((int(*)(PyObject *))_cffi_exports[26])
#define _cffi_from_c_wchar3216_t                                         \
    ((PyObject *(*)(int))_cffi_exports[27])
#define _CFFI_NUM_EXPORTS 28

struct _cffi_ctypedescr;

static void *_cffi_exports[_CFFI_NUM_EXPORTS];

#define _cffi_type(index)   (                           \
    assert((((uintptr_t)_cffi_types[index]) & 1) == 0), \
    (struct _cffi_ctypedescr *)_cffi_types[index])

static PyObject *_cffi_init(const char *module_name, Py_ssize_t version,
                            const struct _cffi_type_context_s *ctx)
{
    PyObject *module, *o_arg, *new_module;
    void *raw[] = {
        (void *)module_name,
        (void *)version,
        (void *)_cffi_exports,
        (void *)ctx,
    };

    module = PyImport_ImportModule("_cffi_backend");
    if (module == NULL)
        goto failure;

    o_arg = PyLong_FromVoidPtr((void *)raw);
    if (o_arg == NULL)
        goto failure;

    new_module = PyObject_CallMethod(
        module, (char *)"_init_cffi_1_0_external_module", (char *)"O", o_arg);

    Py_DECREF(o_arg);
    Py_DECREF(module);
    return new_module;

  failure:
    Py_XDECREF(module);
    return NULL;
}


#ifdef HAVE_WCHAR_H
typedef wchar_t _cffi_wchar_t;
#else
typedef uint16_t _cffi_wchar_t;   /* same random pick as _cffi_backend.c */
#endif

_CFFI_UNUSED_FN static uint16_t _cffi_to_c_char16_t(PyObject *o)
{
    if (sizeof(_cffi_wchar_t) == 2)
        return (uint16_t)_cffi_to_c_wchar_t(o);
    else
        return (uint16_t)_cffi_to_c_wchar3216_t(o);
}

_CFFI_UNUSED_FN static PyObject *_cffi_from_c_char16_t(uint16_t x)
{
    if (sizeof(_cffi_wchar_t) == 2)
        return _cffi_from_c_wchar_t((_cffi_wchar_t)x);
    else
        return _cffi_from_c_wchar3216_t((int)x);
}

_CFFI_UNUSED_FN static int _cffi_to_c_char32_t(PyObject *o)
{
    if (sizeof(_cffi_wchar_t) == 4)
        return (int)_cffi_to_c_wchar_t(o);
    else
        return (int)_cffi_to_c_wchar3216_t(o);
}

_CFFI_UNUSED_FN static PyObject *_cffi_from_c_char32_t(unsigned int x)
{
    if (sizeof(_cffi_wchar_t) == 4)
        return _cffi_from_c_wchar_t((_cffi_wchar_t)x);
    else
        return _cffi_from_c_wchar3216_t((int)x);
}

union _cffi_union_alignment_u {
    unsigned char m_char;
    unsigned short m_short;
    unsigned int m_int;
    unsigned long m_long;
    unsigned long long m_longlong;
    float m_float;
    double m_double;
    long double m_longdouble;
};

struct _cffi_freeme_s {
    struct _cffi_freeme_s *next;
    union _cffi_union_alignment_u alignment;
};

_CFFI_UNUSED_FN static int
_cffi_convert_array_argument(struct _cffi_ctypedescr *ctptr, PyObject *arg,
                             char **output_data, Py_ssize_t datasize,
                             struct _cffi_freeme_s **freeme)
{
    char *p;
    if (datasize < 0)
        return -1;

    p = *output_data;
    if (p == NULL) {
        struct _cffi_freeme_s *fp = (struct _cffi_freeme_s *)PyObject_Malloc(
            offsetof(struct _cffi_freeme_s, alignment) + (size_t)datasize);
        if (fp == NULL)
            return -1;
        fp->next = *freeme;
        *freeme = fp;
        p = *output_data = (char *)&fp->alignment;
    }
    memset((void *)p, 0, (size_t)datasize);
    return _cffi_convert_array_from_object(p, ctptr, arg);
}

_CFFI_UNUSED_FN static void
_cffi_free_array_arguments(struct _cffi_freeme_s *freeme)
{
    do {
        void *p = (void *)freeme;
        freeme = freeme->next;
        PyObject_Free(p);
    } while (freeme != NULL);
}

/**********  end CPython-specific section  **********/
#else
_CFFI_UNUSED_FN
static void (*_cffi_call_python_org)(struct _cffi_externpy_s *, char *);
# define _cffi_call_python  _cffi_call_python_org
#endif


#define _cffi_array_len(array)   (sizeof(array) / sizeof((array)[0]))

#define _cffi_prim_int(size, sign)                                      \
    ((size) == 1 ? ((sign) ? _CFFI_PRIM_INT8  : _CFFI_PRIM_UINT8)  :    \
     (size) == 2 ? ((sign) ? _CFFI_PRIM_INT16 : _CFFI_PRIM_UINT16) :    \
     (size) == 4 ? ((sign) ? _CFFI_PRIM_INT32 : _CFFI_PRIM_UINT32) :    \
     (size) == 8 ? ((sign) ? _CFFI_PRIM_INT64 : _CFFI_PRIM_UINT64) :    \
     _CFFI__UNKNOWN_PRIM)

#define _cffi_prim_float(size)                                          \
    ((size) == sizeof(float) ? _CFFI_PRIM_FLOAT :                       \
     (size) == sizeof(double) ? _CFFI_PRIM_DOUBLE :                     \
     (size) == sizeof(long double) ? _CFFI__UNKNOWN_LONG_DOUBLE :       \
     _CFFI__UNKNOWN_FLOAT_PRIM)

#define _cffi_check_int(got, got_nonpos, expected)      \
    ((got_nonpos) == (expected <= 0) &&                 \
     (got) == (unsigned long long)expected)

#ifdef MS_WIN32
# define _cffi_stdcall  __stdcall
#else
# define _cffi_stdcall  /* nothing */
#endif

#ifdef __cplusplus
}
#endif

/************************************************************/

#include "log.h"
#include "session-lock.h"
#include "server.h"
#include "view.h"
#include "util.h"
#include "output.h"
#include "internal-view.h"
#include "cursor.h"
#include "input-device.h"
#include "keyboard.h"


/************************************************************/

static void *_cffi_types[] = {
/*  0 */ _CFFI_OP(_CFFI_OP_FUNCTION, 29), // _Bool()(struct qw_idle_inhibitor *, struct wlr_surface *)
/*  1 */ _CFFI_OP(_CFFI_OP_POINTER, 353), // struct qw_idle_inhibitor *
/*  2 */ _CFFI_OP(_CFFI_OP_POINTER, 397), // struct wlr_surface *
/*  3 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/*  4 */ _CFFI_OP(_CFFI_OP_FUNCTION, 29), // _Bool()(struct qw_input_device *)
/*  5 */ _CFFI_OP(_CFFI_OP_POINTER, 355), // struct qw_input_device *
/*  6 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/*  7 */ _CFFI_OP(_CFFI_OP_FUNCTION, 29), // _Bool()(struct qw_server *, int)
/*  8 */ _CFFI_OP(_CFFI_OP_POINTER, 365), // struct qw_server *
/*  9 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7), // int
/* 10 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 11 */ _CFFI_OP(_CFFI_OP_FUNCTION, 29), // _Bool()(struct qw_view *)
/* 12 */ _CFFI_OP(_CFFI_OP_POINTER, 368), // struct qw_view *
/* 13 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 14 */ _CFFI_OP(_CFFI_OP_FUNCTION, 29), // _Bool()(struct wlr_surface *, struct wlr_surface *)
/* 15 */ _CFFI_OP(_CFFI_OP_NOOP, 2),
/* 16 */ _CFFI_OP(_CFFI_OP_NOOP, 2),
/* 17 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 18 */ _CFFI_OP(_CFFI_OP_FUNCTION, 29), // _Bool()(void *)
/* 19 */ _CFFI_OP(_CFFI_OP_POINTER, 406), // void *
/* 20 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 21 */ _CFFI_OP(_CFFI_OP_FUNCTION, 29), // _Bool()(void *, void *)
/* 22 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 23 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 24 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 25 */ _CFFI_OP(_CFFI_OP_FUNCTION, 29), // _Bool()(void *, void *, void *, _Bool, _Bool)
/* 26 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 27 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 28 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 29 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 1), // _Bool
/* 30 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 1),
/* 31 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 32 */ _CFFI_OP(_CFFI_OP_FUNCTION, 45), // char const *()(struct qw_server *)
/* 33 */ _CFFI_OP(_CFFI_OP_NOOP, 8),
/* 34 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 35 */ _CFFI_OP(_CFFI_OP_FUNCTION, 45), // char const *()(void *)
/* 36 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 37 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 38 */ _CFFI_OP(_CFFI_OP_FUNCTION, 128), // enum wlr_log_importance()(void)
/* 39 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 40 */ _CFFI_OP(_CFFI_OP_FUNCTION, 9), // int()(_Bool, void *)
/* 41 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 1),
/* 42 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 43 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 44 */ _CFFI_OP(_CFFI_OP_FUNCTION, 9), // int()(char const *)
/* 45 */ _CFFI_OP(_CFFI_OP_POINTER, 324), // char const *
/* 46 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 47 */ _CFFI_OP(_CFFI_OP_FUNCTION, 9), // int()(int, uint32_t, _Bool, int, int, void *)
/* 48 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 49 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22), // uint32_t
/* 50 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 1),
/* 51 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 52 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 53 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 54 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 55 */ _CFFI_OP(_CFFI_OP_FUNCTION, 9), // int()(struct qw_server *)
/* 56 */ _CFFI_OP(_CFFI_OP_NOOP, 8),
/* 57 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 58 */ _CFFI_OP(_CFFI_OP_FUNCTION, 9), // int()(uint32_t)
/* 59 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 60 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 61 */ _CFFI_OP(_CFFI_OP_FUNCTION, 9), // int()(uint32_t, uint32_t, void *)
/* 62 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 63 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 64 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 65 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 66 */ _CFFI_OP(_CFFI_OP_FUNCTION, 9), // int()(void *)
/* 67 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 68 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 69 */ _CFFI_OP(_CFFI_OP_FUNCTION, 145), // struct libinput_device *()(struct qw_input_device *)
/* 70 */ _CFFI_OP(_CFFI_OP_NOOP, 5),
/* 71 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 72 */ _CFFI_OP(_CFFI_OP_FUNCTION, 153), // struct qw_cursor *()(struct qw_server *)
/* 73 */ _CFFI_OP(_CFFI_OP_NOOP, 8),
/* 74 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 75 */ _CFFI_OP(_CFFI_OP_FUNCTION, 88), // struct qw_internal_view *()(struct qw_server *, int, int, int, int)
/* 76 */ _CFFI_OP(_CFFI_OP_NOOP, 8),
/* 77 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 78 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 79 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 80 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 81 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 82 */ _CFFI_OP(_CFFI_OP_FUNCTION, 183), // struct qw_keyboard *()(struct qw_input_device *)
/* 83 */ _CFFI_OP(_CFFI_OP_NOOP, 5),
/* 84 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 85 */ _CFFI_OP(_CFFI_OP_FUNCTION, 8), // struct qw_server *()(void)
/* 86 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 87 */ _CFFI_OP(_CFFI_OP_FUNCTION, 12), // struct qw_view *()(struct qw_internal_view *)
/* 88 */ _CFFI_OP(_CFFI_OP_POINTER, 356), // struct qw_internal_view *
/* 89 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 90 */ _CFFI_OP(_CFFI_OP_FUNCTION, 12), // struct qw_view *()(struct qw_server *, double, double, struct wlr_surface * *, double *, double *)
/* 91 */ _CFFI_OP(_CFFI_OP_NOOP, 8),
/* 92 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14), // double
/* 93 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14),
/* 94 */ _CFFI_OP(_CFFI_OP_POINTER, 2), // struct wlr_surface * *
/* 95 */ _CFFI_OP(_CFFI_OP_POINTER, 92), // double *
/* 96 */ _CFFI_OP(_CFFI_OP_NOOP, 95),
/* 97 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 98 */ _CFFI_OP(_CFFI_OP_FUNCTION, 12), // struct qw_view *()(struct wlr_surface *, _Bool *, _Bool *)
/* 99 */ _CFFI_OP(_CFFI_OP_NOOP, 2),
/* 100 */ _CFFI_OP(_CFFI_OP_POINTER, 29), // _Bool *
/* 101 */ _CFFI_OP(_CFFI_OP_NOOP, 100),
/* 102 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 103 */ _CFFI_OP(_CFFI_OP_FUNCTION, 370), // struct wlr_box()(void *)
/* 104 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 105 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 106 */ _CFFI_OP(_CFFI_OP_FUNCTION, 251), // struct wlr_output *()(struct qw_server *)
/* 107 */ _CFFI_OP(_CFFI_OP_NOOP, 8),
/* 108 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 109 */ _CFFI_OP(_CFFI_OP_FUNCTION, 385), // struct wlr_scene_node *()(void *)
/* 110 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 111 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 112 */ _CFFI_OP(_CFFI_OP_FUNCTION, 49), // uint32_t()(char const *)
/* 113 */ _CFFI_OP(_CFFI_OP_NOOP, 45),
/* 114 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 115 */ _CFFI_OP(_CFFI_OP_FUNCTION, 49), // uint32_t()(struct qw_server *, int)
/* 116 */ _CFFI_OP(_CFFI_OP_NOOP, 8),
/* 117 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 118 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 119 */ _CFFI_OP(_CFFI_OP_FUNCTION, 406), // void()(_Bool, void *)
/* 120 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 1),
/* 121 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 122 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 123 */ _CFFI_OP(_CFFI_OP_FUNCTION, 406), // void()(char *, void *)
/* 124 */ _CFFI_OP(_CFFI_OP_POINTER, 324), // char *
/* 125 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 126 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 127 */ _CFFI_OP(_CFFI_OP_FUNCTION, 406), // void()(enum wlr_log_importance, char const *)
/* 128 */ _CFFI_OP(_CFFI_OP_ENUM, 14), // enum wlr_log_importance
/* 129 */ _CFFI_OP(_CFFI_OP_NOOP, 45),
/* 130 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 131 */ _CFFI_OP(_CFFI_OP_FUNCTION, 406), // void()(enum wlr_log_importance, void(*)(enum wlr_log_importance, char const *))
/* 132 */ _CFFI_OP(_CFFI_OP_NOOP, 128),
/* 133 */ _CFFI_OP(_CFFI_OP_POINTER, 127), // void(*)(enum wlr_log_importance, char const *)
/* 134 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 135 */ _CFFI_OP(_CFFI_OP_FUNCTION, 406), // void()(int)
/* 136 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 137 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 138 */ _CFFI_OP(_CFFI_OP_FUNCTION, 406), // void()(int, int, int, int)
/* 139 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 140 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 141 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 142 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 143 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 144 */ _CFFI_OP(_CFFI_OP_FUNCTION, 406), // void()(struct libinput_device *, double)
/* 145 */ _CFFI_OP(_CFFI_OP_POINTER, 349), // struct libinput_device *
/* 146 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14),
/* 147 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 148 */ _CFFI_OP(_CFFI_OP_FUNCTION, 406), // void()(struct libinput_device *, int)
/* 149 */ _CFFI_OP(_CFFI_OP_NOOP, 145),
/* 150 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 151 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 152 */ _CFFI_OP(_CFFI_OP_FUNCTION, 406), // void()(struct qw_cursor *)
/* 153 */ _CFFI_OP(_CFFI_OP_POINTER, 351), // struct qw_cursor *
/* 154 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 155 */ _CFFI_OP(_CFFI_OP_FUNCTION, 406), // void()(struct qw_cursor *, double, double)
/* 156 */ _CFFI_OP(_CFFI_OP_NOOP, 153),
/* 157 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14),
/* 158 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14),
/* 159 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 160 */ _CFFI_OP(_CFFI_OP_FUNCTION, 406), // void()(struct qw_cursor *, struct wlr_pointer_constraint_v1 *)
/* 161 */ _CFFI_OP(_CFFI_OP_NOOP, 153),
/* 162 */ _CFFI_OP(_CFFI_OP_POINTER, 381), // struct wlr_pointer_constraint_v1 *
/* 163 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 164 */ _CFFI_OP(_CFFI_OP_FUNCTION, 406), // void()(struct qw_cursor *, uint32_t)
/* 165 */ _CFFI_OP(_CFFI_OP_NOOP, 153),
/* 166 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 167 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 168 */ _CFFI_OP(_CFFI_OP_FUNCTION, 406), // void()(struct qw_input_device *, char const *, int, int, int)
/* 169 */ _CFFI_OP(_CFFI_OP_NOOP, 5),
/* 170 */ _CFFI_OP(_CFFI_OP_NOOP, 45),
/* 171 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 172 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 173 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 174 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 175 */ _CFFI_OP(_CFFI_OP_FUNCTION, 406), // void()(struct qw_internal_view *, int, int, int, int)
/* 176 */ _CFFI_OP(_CFFI_OP_NOOP, 88),
/* 177 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 178 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 179 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 180 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 181 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 182 */ _CFFI_OP(_CFFI_OP_FUNCTION, 406), // void()(struct qw_keyboard *, char const *, char const *, char const *)
/* 183 */ _CFFI_OP(_CFFI_OP_POINTER, 357), // struct qw_keyboard *
/* 184 */ _CFFI_OP(_CFFI_OP_NOOP, 45),
/* 185 */ _CFFI_OP(_CFFI_OP_NOOP, 45),
/* 186 */ _CFFI_OP(_CFFI_OP_NOOP, 45),
/* 187 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 188 */ _CFFI_OP(_CFFI_OP_FUNCTION, 406), // void()(struct qw_keyboard *, int, int)
/* 189 */ _CFFI_OP(_CFFI_OP_NOOP, 183),
/* 190 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 191 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 192 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 193 */ _CFFI_OP(_CFFI_OP_FUNCTION, 406), // void()(struct qw_output *)
/* 194 */ _CFFI_OP(_CFFI_OP_POINTER, 360), // struct qw_output *
/* 195 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 196 */ _CFFI_OP(_CFFI_OP_FUNCTION, 406), // void()(struct qw_output *, _Bool)
/* 197 */ _CFFI_OP(_CFFI_OP_NOOP, 194),
/* 198 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 1),
/* 199 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 200 */ _CFFI_OP(_CFFI_OP_FUNCTION, 406), // void()(struct qw_output *, cairo_surface_t *, enum qw_wallpaper_mode)
/* 201 */ _CFFI_OP(_CFFI_OP_NOOP, 194),
/* 202 */ _CFFI_OP(_CFFI_OP_POINTER, 322), // cairo_surface_t *
/* 203 */ _CFFI_OP(_CFFI_OP_ENUM, 12), // enum qw_wallpaper_mode
/* 204 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 205 */ _CFFI_OP(_CFFI_OP_FUNCTION, 406), // void()(struct qw_output *, float *)
/* 206 */ _CFFI_OP(_CFFI_OP_NOOP, 194),
/* 207 */ _CFFI_OP(_CFFI_OP_POINTER, 338), // float *
/* 208 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 209 */ _CFFI_OP(_CFFI_OP_FUNCTION, 406), // void()(struct qw_output *, void *)
/* 210 */ _CFFI_OP(_CFFI_OP_NOOP, 194),
/* 211 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 212 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 213 */ _CFFI_OP(_CFFI_OP_FUNCTION, 406), // void()(struct qw_server *)
/* 214 */ _CFFI_OP(_CFFI_OP_NOOP, 8),
/* 215 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 216 */ _CFFI_OP(_CFFI_OP_FUNCTION, 406), // void()(struct qw_server *, _Bool)
/* 217 */ _CFFI_OP(_CFFI_OP_NOOP, 8),
/* 218 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 1),
/* 219 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 220 */ _CFFI_OP(_CFFI_OP_FUNCTION, 406), // void()(struct qw_server *, char const *, char const *, char const *)
/* 221 */ _CFFI_OP(_CFFI_OP_NOOP, 8),
/* 222 */ _CFFI_OP(_CFFI_OP_NOOP, 45),
/* 223 */ _CFFI_OP(_CFFI_OP_NOOP, 45),
/* 224 */ _CFFI_OP(_CFFI_OP_NOOP, 45),
/* 225 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 226 */ _CFFI_OP(_CFFI_OP_FUNCTION, 406), // void()(struct qw_server *, int, int, _Bool)
/* 227 */ _CFFI_OP(_CFFI_OP_NOOP, 8),
/* 228 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 229 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 230 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 1),
/* 231 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 232 */ _CFFI_OP(_CFFI_OP_FUNCTION, 406), // void()(struct qw_server *, int, int, cairo_surface_t *, enum qw_wallpaper_mode)
/* 233 */ _CFFI_OP(_CFFI_OP_NOOP, 8),
/* 234 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 235 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 236 */ _CFFI_OP(_CFFI_OP_NOOP, 202),
/* 237 */ _CFFI_OP(_CFFI_OP_NOOP, 203),
/* 238 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 239 */ _CFFI_OP(_CFFI_OP_FUNCTION, 406), // void()(struct qw_server *, int, int, float *)
/* 240 */ _CFFI_OP(_CFFI_OP_NOOP, 8),
/* 241 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 242 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 243 */ _CFFI_OP(_CFFI_OP_NOOP, 207),
/* 244 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 245 */ _CFFI_OP(_CFFI_OP_FUNCTION, 406), // void()(struct qw_server *, struct wlr_input_device *)
/* 246 */ _CFFI_OP(_CFFI_OP_NOOP, 8),
/* 247 */ _CFFI_OP(_CFFI_OP_POINTER, 379), // struct wlr_input_device *
/* 248 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 249 */ _CFFI_OP(_CFFI_OP_FUNCTION, 406), // void()(struct qw_server *, struct wlr_output *)
/* 250 */ _CFFI_OP(_CFFI_OP_NOOP, 8),
/* 251 */ _CFFI_OP(_CFFI_OP_POINTER, 380), // struct wlr_output *
/* 252 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 253 */ _CFFI_OP(_CFFI_OP_FUNCTION, 406), // void()(struct qw_server *, void(*)(int))
/* 254 */ _CFFI_OP(_CFFI_OP_NOOP, 8),
/* 255 */ _CFFI_OP(_CFFI_OP_POINTER, 135), // void(*)(int)
/* 256 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 257 */ _CFFI_OP(_CFFI_OP_FUNCTION, 406), // void()(struct qw_server *, void(*)(int, int, int, int))
/* 258 */ _CFFI_OP(_CFFI_OP_NOOP, 8),
/* 259 */ _CFFI_OP(_CFFI_OP_POINTER, 138), // void(*)(int, int, int, int)
/* 260 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 261 */ _CFFI_OP(_CFFI_OP_FUNCTION, 406), // void()(struct qw_server *, void(*)(struct qw_input_device *, char const *, int, int, int))
/* 262 */ _CFFI_OP(_CFFI_OP_NOOP, 8),
/* 263 */ _CFFI_OP(_CFFI_OP_POINTER, 168), // void(*)(struct qw_input_device *, char const *, int, int, int)
/* 264 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 265 */ _CFFI_OP(_CFFI_OP_FUNCTION, 406), // void()(struct qw_server *, void(*)(uintptr_t, uintptr_t, struct scene_node_info))
/* 266 */ _CFFI_OP(_CFFI_OP_NOOP, 8),
/* 267 */ _CFFI_OP(_CFFI_OP_POINTER, 293), // void(*)(uintptr_t, uintptr_t, struct scene_node_info)
/* 268 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 269 */ _CFFI_OP(_CFFI_OP_FUNCTION, 406), // void()(struct qw_view *)
/* 270 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 271 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 272 */ _CFFI_OP(_CFFI_OP_FUNCTION, 406), // void()(struct qw_view *, int)
/* 273 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 274 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 275 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 276 */ _CFFI_OP(_CFFI_OP_FUNCTION, 406), // void()(struct qw_view *, int, int)
/* 277 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 278 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 279 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 280 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 281 */ _CFFI_OP(_CFFI_OP_FUNCTION, 406), // void()(struct qw_view *, struct qw_border const *, int)
/* 282 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 283 */ _CFFI_OP(_CFFI_OP_POINTER, 350), // struct qw_border const *
/* 284 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 285 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 286 */ _CFFI_OP(_CFFI_OP_FUNCTION, 406), // void()(struct qw_view *, void *)
/* 287 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 288 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 289 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 290 */ _CFFI_OP(_CFFI_OP_FUNCTION, 406), // void()(struct wlr_surface *)
/* 291 */ _CFFI_OP(_CFFI_OP_NOOP, 2),
/* 292 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 293 */ _CFFI_OP(_CFFI_OP_FUNCTION, 406), // void()(uintptr_t, uintptr_t, struct scene_node_info)
/* 294 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 26), // uintptr_t
/* 295 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 26),
/* 296 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 21), // struct scene_node_info
/* 297 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 298 */ _CFFI_OP(_CFFI_OP_FUNCTION, 406), // void()(void *)
/* 299 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 300 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 301 */ _CFFI_OP(_CFFI_OP_FUNCTION, 406), // void()(void *, _Bool)
/* 302 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 303 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 1),
/* 304 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 305 */ _CFFI_OP(_CFFI_OP_FUNCTION, 406), // void()(void *, int)
/* 306 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 307 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 308 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 309 */ _CFFI_OP(_CFFI_OP_FUNCTION, 406), // void()(void *, int, int, int, int, struct qw_border const *, int, int)
/* 310 */ _CFFI_OP(_CFFI_OP_NOOP, 19),
/* 311 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 312 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 313 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 314 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 315 */ _CFFI_OP(_CFFI_OP_NOOP, 283),
/* 316 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 317 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 318 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 319 */ _CFFI_OP(_CFFI_OP_POINTER, 18), // _Bool(*)(void *)
/* 320 */ _CFFI_OP(_CFFI_OP_POINTER, 21), // _Bool(*)(void *, void *)
/* 321 */ _CFFI_OP(_CFFI_OP_POINTER, 25), // _Bool(*)(void *, void *, void *, _Bool, _Bool)
/* 322 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 2), // cairo_surface_t
/* 323 */ _CFFI_OP(_CFFI_OP_POINTER, 35), // char const *(*)(void *)
/* 324 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 2), // char
/* 325 */ _CFFI_OP(_CFFI_OP_ENUM, 0), // enum $1
/* 326 */ _CFFI_OP(_CFFI_OP_ENUM, 1), // enum $2
/* 327 */ _CFFI_OP(_CFFI_OP_ENUM, 2), // enum BUTTON_SCROLL
/* 328 */ _CFFI_OP(_CFFI_OP_ENUM, 3), // enum libinput_config_accel_profile
/* 329 */ _CFFI_OP(_CFFI_OP_ENUM, 4), // enum libinput_config_click_method
/* 330 */ _CFFI_OP(_CFFI_OP_ENUM, 5), // enum libinput_config_scroll_method
/* 331 */ _CFFI_OP(_CFFI_OP_ENUM, 6), // enum libinput_config_tap_button_map
/* 332 */ _CFFI_OP(_CFFI_OP_ENUM, 7), // enum qw_background_type
/* 333 */ _CFFI_OP(_CFFI_OP_ENUM, 8), // enum qw_border_type
/* 334 */ _CFFI_OP(_CFFI_OP_ENUM, 9), // enum qw_session_lock_state
/* 335 */ _CFFI_OP(_CFFI_OP_ENUM, 10), // enum qw_view_state
/* 336 */ _CFFI_OP(_CFFI_OP_ENUM, 11), // enum qw_view_type
/* 337 */ _CFFI_OP(_CFFI_OP_ENUM, 13), // enum wlr_input_device_type
/* 338 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 13), // float
/* 339 */ _CFFI_OP(_CFFI_OP_ARRAY, 338), // float[4]
/* 340 */ (_cffi_opcode_t)(4),
/* 341 */ _CFFI_OP(_CFFI_OP_ARRAY, 339), // float[4][4]
/* 342 */ (_cffi_opcode_t)(4),
/* 343 */ _CFFI_OP(_CFFI_OP_POINTER, 40), // int(*)(_Bool, void *)
/* 344 */ _CFFI_OP(_CFFI_OP_POINTER, 47), // int(*)(int, uint32_t, _Bool, int, int, void *)
/* 345 */ _CFFI_OP(_CFFI_OP_POINTER, 61), // int(*)(uint32_t, uint32_t, void *)
/* 346 */ _CFFI_OP(_CFFI_OP_POINTER, 66), // int(*)(void *)
/* 347 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 0), // struct $4
/* 348 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 1), // struct $5
/* 349 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 3), // struct libinput_device
/* 350 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 4), // struct qw_border
/* 351 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 5), // struct qw_cursor
/* 352 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 6), // struct qw_drag_icon
/* 353 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 7), // struct qw_idle_inhibitor
/* 354 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 8), // struct qw_implicit_grab
/* 355 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 9), // struct qw_input_device
/* 356 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 10), // struct qw_internal_view
/* 357 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 11), // struct qw_keyboard
/* 358 */ _CFFI_OP(_CFFI_OP_POINTER, 359), // struct qw_layer_view *
/* 359 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 12), // struct qw_layer_view
/* 360 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 13), // struct qw_output
/* 361 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 14), // struct qw_output_background
/* 362 */ _CFFI_OP(_CFFI_OP_POINTER, 363), // struct qw_output_background_wallpaper *
/* 363 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 15), // struct qw_output_background_wallpaper
/* 364 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 16), // struct qw_pointer_constraint
/* 365 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 17), // struct qw_server
/* 366 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 18), // struct qw_session_lock
/* 367 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 19), // struct qw_session_lock_surface
/* 368 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 20), // struct qw_view
/* 369 */ _CFFI_OP(_CFFI_OP_POINTER, 103), // struct wlr_box(*)(void *)
/* 370 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 22), // struct wlr_box
/* 371 */ _CFFI_OP(_CFFI_OP_POINTER, 372), // struct wlr_buffer *
/* 372 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 23), // struct wlr_buffer
/* 373 */ _CFFI_OP(_CFFI_OP_POINTER, 374), // struct wlr_cursor *
/* 374 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 24), // struct wlr_cursor
/* 375 */ _CFFI_OP(_CFFI_OP_POINTER, 376), // struct wlr_cursor_state *
/* 376 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 25), // struct wlr_cursor_state
/* 377 */ _CFFI_OP(_CFFI_OP_POINTER, 378), // struct wlr_foreign_toplevel_handle_v1 *
/* 378 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 26), // struct wlr_foreign_toplevel_handle_v1
/* 379 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 27), // struct wlr_input_device
/* 380 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 28), // struct wlr_output
/* 381 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 29), // struct wlr_pointer_constraint_v1
/* 382 */ _CFFI_OP(_CFFI_OP_POINTER, 383), // struct wlr_scene_buffer *
/* 383 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 30), // struct wlr_scene_buffer
/* 384 */ _CFFI_OP(_CFFI_OP_POINTER, 109), // struct wlr_scene_node *(*)(void *)
/* 385 */ _CFFI_OP(_CFFI_OP_POINTER, 386), // struct wlr_scene_node *
/* 386 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 31), // struct wlr_scene_node
/* 387 */ _CFFI_OP(_CFFI_OP_POINTER, 388), // struct wlr_scene_output *
/* 388 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 32), // struct wlr_scene_output
/* 389 */ _CFFI_OP(_CFFI_OP_POINTER, 390), // struct wlr_scene_rect *
/* 390 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 33), // struct wlr_scene_rect
/* 391 */ _CFFI_OP(_CFFI_OP_POINTER, 392), // struct wlr_scene_tree *
/* 392 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 34), // struct wlr_scene_tree
/* 393 */ _CFFI_OP(_CFFI_OP_POINTER, 394), // struct wlr_session_lock_surface_v1 *
/* 394 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 35), // struct wlr_session_lock_surface_v1
/* 395 */ _CFFI_OP(_CFFI_OP_POINTER, 396), // struct wlr_session_lock_v1 *
/* 396 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 36), // struct wlr_session_lock_v1
/* 397 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 37), // struct wlr_surface
/* 398 */ _CFFI_OP(_CFFI_OP_POINTER, 119), // void(*)(_Bool, void *)
/* 399 */ _CFFI_OP(_CFFI_OP_POINTER, 123), // void(*)(char *, void *)
/* 400 */ _CFFI_OP(_CFFI_OP_POINTER, 209), // void(*)(struct qw_output *, void *)
/* 401 */ _CFFI_OP(_CFFI_OP_POINTER, 286), // void(*)(struct qw_view *, void *)
/* 402 */ _CFFI_OP(_CFFI_OP_POINTER, 298), // void(*)(void *)
/* 403 */ _CFFI_OP(_CFFI_OP_POINTER, 301), // void(*)(void *, _Bool)
/* 404 */ _CFFI_OP(_CFFI_OP_POINTER, 305), // void(*)(void *, int)
/* 405 */ _CFFI_OP(_CFFI_OP_POINTER, 309), // void(*)(void *, int, int, int, int, struct qw_border const *, int, int)
/* 406 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 0), // void
};

static int _cffi_const_NET_WM_WINDOW_TYPE_DIALOG(unsigned long long *o)
{
  int n = (NET_WM_WINDOW_TYPE_DIALOG) <= 0;
  *o = (unsigned long long)((NET_WM_WINDOW_TYPE_DIALOG) | 0);  /* check that NET_WM_WINDOW_TYPE_DIALOG is an integer */
  return n;
}

static int _cffi_const_NET_WM_WINDOW_TYPE_UTILITY(unsigned long long *o)
{
  int n = (NET_WM_WINDOW_TYPE_UTILITY) <= 0;
  *o = (unsigned long long)((NET_WM_WINDOW_TYPE_UTILITY) | 0);  /* check that NET_WM_WINDOW_TYPE_UTILITY is an integer */
  return n;
}

static int _cffi_const_NET_WM_WINDOW_TYPE_TOOLBAR(unsigned long long *o)
{
  int n = (NET_WM_WINDOW_TYPE_TOOLBAR) <= 0;
  *o = (unsigned long long)((NET_WM_WINDOW_TYPE_TOOLBAR) | 0);  /* check that NET_WM_WINDOW_TYPE_TOOLBAR is an integer */
  return n;
}

static int _cffi_const_NET_WM_WINDOW_TYPE_MENU(unsigned long long *o)
{
  int n = (NET_WM_WINDOW_TYPE_MENU) <= 0;
  *o = (unsigned long long)((NET_WM_WINDOW_TYPE_MENU) | 0);  /* check that NET_WM_WINDOW_TYPE_MENU is an integer */
  return n;
}

static int _cffi_const_NET_WM_WINDOW_TYPE_SPLASH(unsigned long long *o)
{
  int n = (NET_WM_WINDOW_TYPE_SPLASH) <= 0;
  *o = (unsigned long long)((NET_WM_WINDOW_TYPE_SPLASH) | 0);  /* check that NET_WM_WINDOW_TYPE_SPLASH is an integer */
  return n;
}

static int _cffi_const_NET_WM_WINDOW_TYPE_DOCK(unsigned long long *o)
{
  int n = (NET_WM_WINDOW_TYPE_DOCK) <= 0;
  *o = (unsigned long long)((NET_WM_WINDOW_TYPE_DOCK) | 0);  /* check that NET_WM_WINDOW_TYPE_DOCK is an integer */
  return n;
}

static int _cffi_const_NET_WM_WINDOW_TYPE_TOOLTIP(unsigned long long *o)
{
  int n = (NET_WM_WINDOW_TYPE_TOOLTIP) <= 0;
  *o = (unsigned long long)((NET_WM_WINDOW_TYPE_TOOLTIP) | 0);  /* check that NET_WM_WINDOW_TYPE_TOOLTIP is an integer */
  return n;
}

static int _cffi_const_NET_WM_WINDOW_TYPE_NOTIFICATION(unsigned long long *o)
{
  int n = (NET_WM_WINDOW_TYPE_NOTIFICATION) <= 0;
  *o = (unsigned long long)((NET_WM_WINDOW_TYPE_NOTIFICATION) | 0);  /* check that NET_WM_WINDOW_TYPE_NOTIFICATION is an integer */
  return n;
}

static int _cffi_const_NET_WM_WINDOW_TYPE_DESKTOP(unsigned long long *o)
{
  int n = (NET_WM_WINDOW_TYPE_DESKTOP) <= 0;
  *o = (unsigned long long)((NET_WM_WINDOW_TYPE_DESKTOP) | 0);  /* check that NET_WM_WINDOW_TYPE_DESKTOP is an integer */
  return n;
}

static int _cffi_const_NET_WM_WINDOW_TYPE_DROPDOWN_MENU(unsigned long long *o)
{
  int n = (NET_WM_WINDOW_TYPE_DROPDOWN_MENU) <= 0;
  *o = (unsigned long long)((NET_WM_WINDOW_TYPE_DROPDOWN_MENU) | 0);  /* check that NET_WM_WINDOW_TYPE_DROPDOWN_MENU is an integer */
  return n;
}

static int _cffi_const_NET_WM_WINDOW_TYPE_POPUP_MENU(unsigned long long *o)
{
  int n = (NET_WM_WINDOW_TYPE_POPUP_MENU) <= 0;
  *o = (unsigned long long)((NET_WM_WINDOW_TYPE_POPUP_MENU) | 0);  /* check that NET_WM_WINDOW_TYPE_POPUP_MENU is an integer */
  return n;
}

static int _cffi_const_NET_WM_WINDOW_TYPE_COMBO(unsigned long long *o)
{
  int n = (NET_WM_WINDOW_TYPE_COMBO) <= 0;
  *o = (unsigned long long)((NET_WM_WINDOW_TYPE_COMBO) | 0);  /* check that NET_WM_WINDOW_TYPE_COMBO is an integer */
  return n;
}

static int _cffi_const_NET_WM_WINDOW_TYPE_DND(unsigned long long *o)
{
  int n = (NET_WM_WINDOW_TYPE_DND) <= 0;
  *o = (unsigned long long)((NET_WM_WINDOW_TYPE_DND) | 0);  /* check that NET_WM_WINDOW_TYPE_DND is an integer */
  return n;
}

static int _cffi_const_NET_WM_WINDOW_TYPE_NORMAL(unsigned long long *o)
{
  int n = (NET_WM_WINDOW_TYPE_NORMAL) <= 0;
  *o = (unsigned long long)((NET_WM_WINDOW_TYPE_NORMAL) | 0);  /* check that NET_WM_WINDOW_TYPE_NORMAL is an integer */
  return n;
}

static int _cffi_const_ATOM_LAST(unsigned long long *o)
{
  int n = (ATOM_LAST) <= 0;
  *o = (unsigned long long)((ATOM_LAST) | 0);  /* check that ATOM_LAST is an integer */
  return n;
}

static int _cffi_const_LAYER_BACKGROUND(unsigned long long *o)
{
  int n = (LAYER_BACKGROUND) <= 0;
  *o = (unsigned long long)((LAYER_BACKGROUND) | 0);  /* check that LAYER_BACKGROUND is an integer */
  return n;
}

static int _cffi_const_LAYER_BOTTOM(unsigned long long *o)
{
  int n = (LAYER_BOTTOM) <= 0;
  *o = (unsigned long long)((LAYER_BOTTOM) | 0);  /* check that LAYER_BOTTOM is an integer */
  return n;
}

static int _cffi_const_LAYER_KEEPBELOW(unsigned long long *o)
{
  int n = (LAYER_KEEPBELOW) <= 0;
  *o = (unsigned long long)((LAYER_KEEPBELOW) | 0);  /* check that LAYER_KEEPBELOW is an integer */
  return n;
}

static int _cffi_const_LAYER_LAYOUT(unsigned long long *o)
{
  int n = (LAYER_LAYOUT) <= 0;
  *o = (unsigned long long)((LAYER_LAYOUT) | 0);  /* check that LAYER_LAYOUT is an integer */
  return n;
}

static int _cffi_const_LAYER_KEEPABOVE(unsigned long long *o)
{
  int n = (LAYER_KEEPABOVE) <= 0;
  *o = (unsigned long long)((LAYER_KEEPABOVE) | 0);  /* check that LAYER_KEEPABOVE is an integer */
  return n;
}

static int _cffi_const_LAYER_MAX(unsigned long long *o)
{
  int n = (LAYER_MAX) <= 0;
  *o = (unsigned long long)((LAYER_MAX) | 0);  /* check that LAYER_MAX is an integer */
  return n;
}

static int _cffi_const_LAYER_FULLSCREEN(unsigned long long *o)
{
  int n = (LAYER_FULLSCREEN) <= 0;
  *o = (unsigned long long)((LAYER_FULLSCREEN) | 0);  /* check that LAYER_FULLSCREEN is an integer */
  return n;
}

static int _cffi_const_LAYER_BRINGTOFRONT(unsigned long long *o)
{
  int n = (LAYER_BRINGTOFRONT) <= 0;
  *o = (unsigned long long)((LAYER_BRINGTOFRONT) | 0);  /* check that LAYER_BRINGTOFRONT is an integer */
  return n;
}

static int _cffi_const_LAYER_TOP(unsigned long long *o)
{
  int n = (LAYER_TOP) <= 0;
  *o = (unsigned long long)((LAYER_TOP) | 0);  /* check that LAYER_TOP is an integer */
  return n;
}

static int _cffi_const_LAYER_OVERLAY(unsigned long long *o)
{
  int n = (LAYER_OVERLAY) <= 0;
  *o = (unsigned long long)((LAYER_OVERLAY) | 0);  /* check that LAYER_OVERLAY is an integer */
  return n;
}

static int _cffi_const_LAYER_DRAG_ICON(unsigned long long *o)
{
  int n = (LAYER_DRAG_ICON) <= 0;
  *o = (unsigned long long)((LAYER_DRAG_ICON) | 0);  /* check that LAYER_DRAG_ICON is an integer */
  return n;
}

static int _cffi_const_LAYER_LOCK(unsigned long long *o)
{
  int n = (LAYER_LOCK) <= 0;
  *o = (unsigned long long)((LAYER_LOCK) | 0);  /* check that LAYER_LOCK is an integer */
  return n;
}

static int _cffi_const_LAYER_END(unsigned long long *o)
{
  int n = (LAYER_END) <= 0;
  *o = (unsigned long long)((LAYER_END) | 0);  /* check that LAYER_END is an integer */
  return n;
}

static int _cffi_const_BUTTON_SCROLL_UP(unsigned long long *o)
{
  int n = (BUTTON_SCROLL_UP) <= 0;
  *o = (unsigned long long)((BUTTON_SCROLL_UP) | 0);  /* check that BUTTON_SCROLL_UP is an integer */
  return n;
}

static int _cffi_const_BUTTON_SCROLL_DOWN(unsigned long long *o)
{
  int n = (BUTTON_SCROLL_DOWN) <= 0;
  *o = (unsigned long long)((BUTTON_SCROLL_DOWN) | 0);  /* check that BUTTON_SCROLL_DOWN is an integer */
  return n;
}

static int _cffi_const_BUTTON_SCROLL_LEFT(unsigned long long *o)
{
  int n = (BUTTON_SCROLL_LEFT) <= 0;
  *o = (unsigned long long)((BUTTON_SCROLL_LEFT) | 0);  /* check that BUTTON_SCROLL_LEFT is an integer */
  return n;
}

static int _cffi_const_BUTTON_SCROLL_RIGHT(unsigned long long *o)
{
  int n = (BUTTON_SCROLL_RIGHT) <= 0;
  *o = (unsigned long long)((BUTTON_SCROLL_RIGHT) | 0);  /* check that BUTTON_SCROLL_RIGHT is an integer */
  return n;
}

static int _cffi_const_LIBINPUT_CONFIG_ACCEL_PROFILE_NONE(unsigned long long *o)
{
  int n = (LIBINPUT_CONFIG_ACCEL_PROFILE_NONE) <= 0;
  *o = (unsigned long long)((LIBINPUT_CONFIG_ACCEL_PROFILE_NONE) | 0);  /* check that LIBINPUT_CONFIG_ACCEL_PROFILE_NONE is an integer */
  return n;
}

static int _cffi_const_LIBINPUT_CONFIG_ACCEL_PROFILE_FLAT(unsigned long long *o)
{
  int n = (LIBINPUT_CONFIG_ACCEL_PROFILE_FLAT) <= 0;
  *o = (unsigned long long)((LIBINPUT_CONFIG_ACCEL_PROFILE_FLAT) | 0);  /* check that LIBINPUT_CONFIG_ACCEL_PROFILE_FLAT is an integer */
  return n;
}

static int _cffi_const_LIBINPUT_CONFIG_ACCEL_PROFILE_ADAPTIVE(unsigned long long *o)
{
  int n = (LIBINPUT_CONFIG_ACCEL_PROFILE_ADAPTIVE) <= 0;
  *o = (unsigned long long)((LIBINPUT_CONFIG_ACCEL_PROFILE_ADAPTIVE) | 0);  /* check that LIBINPUT_CONFIG_ACCEL_PROFILE_ADAPTIVE is an integer */
  return n;
}

static int _cffi_const_LIBINPUT_CONFIG_CLICK_METHOD_NONE(unsigned long long *o)
{
  int n = (LIBINPUT_CONFIG_CLICK_METHOD_NONE) <= 0;
  *o = (unsigned long long)((LIBINPUT_CONFIG_CLICK_METHOD_NONE) | 0);  /* check that LIBINPUT_CONFIG_CLICK_METHOD_NONE is an integer */
  return n;
}

static int _cffi_const_LIBINPUT_CONFIG_CLICK_METHOD_BUTTON_AREAS(unsigned long long *o)
{
  int n = (LIBINPUT_CONFIG_CLICK_METHOD_BUTTON_AREAS) <= 0;
  *o = (unsigned long long)((LIBINPUT_CONFIG_CLICK_METHOD_BUTTON_AREAS) | 0);  /* check that LIBINPUT_CONFIG_CLICK_METHOD_BUTTON_AREAS is an integer */
  return n;
}

static int _cffi_const_LIBINPUT_CONFIG_CLICK_METHOD_CLICKFINGER(unsigned long long *o)
{
  int n = (LIBINPUT_CONFIG_CLICK_METHOD_CLICKFINGER) <= 0;
  *o = (unsigned long long)((LIBINPUT_CONFIG_CLICK_METHOD_CLICKFINGER) | 0);  /* check that LIBINPUT_CONFIG_CLICK_METHOD_CLICKFINGER is an integer */
  return n;
}

static int _cffi_const_LIBINPUT_CONFIG_SCROLL_NO_SCROLL(unsigned long long *o)
{
  int n = (LIBINPUT_CONFIG_SCROLL_NO_SCROLL) <= 0;
  *o = (unsigned long long)((LIBINPUT_CONFIG_SCROLL_NO_SCROLL) | 0);  /* check that LIBINPUT_CONFIG_SCROLL_NO_SCROLL is an integer */
  return n;
}

static int _cffi_const_LIBINPUT_CONFIG_SCROLL_2FG(unsigned long long *o)
{
  int n = (LIBINPUT_CONFIG_SCROLL_2FG) <= 0;
  *o = (unsigned long long)((LIBINPUT_CONFIG_SCROLL_2FG) | 0);  /* check that LIBINPUT_CONFIG_SCROLL_2FG is an integer */
  return n;
}

static int _cffi_const_LIBINPUT_CONFIG_SCROLL_EDGE(unsigned long long *o)
{
  int n = (LIBINPUT_CONFIG_SCROLL_EDGE) <= 0;
  *o = (unsigned long long)((LIBINPUT_CONFIG_SCROLL_EDGE) | 0);  /* check that LIBINPUT_CONFIG_SCROLL_EDGE is an integer */
  return n;
}

static int _cffi_const_LIBINPUT_CONFIG_SCROLL_ON_BUTTON_DOWN(unsigned long long *o)
{
  int n = (LIBINPUT_CONFIG_SCROLL_ON_BUTTON_DOWN) <= 0;
  *o = (unsigned long long)((LIBINPUT_CONFIG_SCROLL_ON_BUTTON_DOWN) | 0);  /* check that LIBINPUT_CONFIG_SCROLL_ON_BUTTON_DOWN is an integer */
  return n;
}

static int _cffi_const_LIBINPUT_CONFIG_TAP_MAP_LRM(unsigned long long *o)
{
  int n = (LIBINPUT_CONFIG_TAP_MAP_LRM) <= 0;
  *o = (unsigned long long)((LIBINPUT_CONFIG_TAP_MAP_LRM) | 0);  /* check that LIBINPUT_CONFIG_TAP_MAP_LRM is an integer */
  return n;
}

static int _cffi_const_LIBINPUT_CONFIG_TAP_MAP_LMR(unsigned long long *o)
{
  int n = (LIBINPUT_CONFIG_TAP_MAP_LMR) <= 0;
  *o = (unsigned long long)((LIBINPUT_CONFIG_TAP_MAP_LMR) | 0);  /* check that LIBINPUT_CONFIG_TAP_MAP_LMR is an integer */
  return n;
}

static int _cffi_const_QW_BACKGROUND_COLOR_RECT(unsigned long long *o)
{
  int n = (QW_BACKGROUND_COLOR_RECT) <= 0;
  *o = (unsigned long long)((QW_BACKGROUND_COLOR_RECT) | 0);  /* check that QW_BACKGROUND_COLOR_RECT is an integer */
  return n;
}

static int _cffi_const_QW_BACKGROUND_WALLPAPER(unsigned long long *o)
{
  int n = (QW_BACKGROUND_WALLPAPER) <= 0;
  *o = (unsigned long long)((QW_BACKGROUND_WALLPAPER) | 0);  /* check that QW_BACKGROUND_WALLPAPER is an integer */
  return n;
}

static int _cffi_const_QW_BACKGROUND_DESTROYED(unsigned long long *o)
{
  int n = (QW_BACKGROUND_DESTROYED) <= 0;
  *o = (unsigned long long)((QW_BACKGROUND_DESTROYED) | 0);  /* check that QW_BACKGROUND_DESTROYED is an integer */
  return n;
}

static int _cffi_const_QW_BORDER_RECT(unsigned long long *o)
{
  int n = (QW_BORDER_RECT) <= 0;
  *o = (unsigned long long)((QW_BORDER_RECT) | 0);  /* check that QW_BORDER_RECT is an integer */
  return n;
}

static int _cffi_const_QW_BORDER_BUFFER(unsigned long long *o)
{
  int n = (QW_BORDER_BUFFER) <= 0;
  *o = (unsigned long long)((QW_BORDER_BUFFER) | 0);  /* check that QW_BORDER_BUFFER is an integer */
  return n;
}

static int _cffi_const_QW_SESSION_LOCK_LOCKED(unsigned long long *o)
{
  int n = (QW_SESSION_LOCK_LOCKED) <= 0;
  *o = (unsigned long long)((QW_SESSION_LOCK_LOCKED) | 0);  /* check that QW_SESSION_LOCK_LOCKED is an integer */
  return n;
}

static int _cffi_const_QW_SESSION_LOCK_UNLOCKED(unsigned long long *o)
{
  int n = (QW_SESSION_LOCK_UNLOCKED) <= 0;
  *o = (unsigned long long)((QW_SESSION_LOCK_UNLOCKED) | 0);  /* check that QW_SESSION_LOCK_UNLOCKED is an integer */
  return n;
}

static int _cffi_const_QW_SESSION_LOCK_CRASHED(unsigned long long *o)
{
  int n = (QW_SESSION_LOCK_CRASHED) <= 0;
  *o = (unsigned long long)((QW_SESSION_LOCK_CRASHED) | 0);  /* check that QW_SESSION_LOCK_CRASHED is an integer */
  return n;
}

static int _cffi_const_NOT_FLOATING(unsigned long long *o)
{
  int n = (NOT_FLOATING) <= 0;
  *o = (unsigned long long)((NOT_FLOATING) | 0);  /* check that NOT_FLOATING is an integer */
  return n;
}

static int _cffi_const_FLOATING(unsigned long long *o)
{
  int n = (FLOATING) <= 0;
  *o = (unsigned long long)((FLOATING) | 0);  /* check that FLOATING is an integer */
  return n;
}

static int _cffi_const_MAXIMIZED(unsigned long long *o)
{
  int n = (MAXIMIZED) <= 0;
  *o = (unsigned long long)((MAXIMIZED) | 0);  /* check that MAXIMIZED is an integer */
  return n;
}

static int _cffi_const_FULLSCREEN(unsigned long long *o)
{
  int n = (FULLSCREEN) <= 0;
  *o = (unsigned long long)((FULLSCREEN) | 0);  /* check that FULLSCREEN is an integer */
  return n;
}

static int _cffi_const_TOP(unsigned long long *o)
{
  int n = (TOP) <= 0;
  *o = (unsigned long long)((TOP) | 0);  /* check that TOP is an integer */
  return n;
}

static int _cffi_const_MINIMIZED(unsigned long long *o)
{
  int n = (MINIMIZED) <= 0;
  *o = (unsigned long long)((MINIMIZED) | 0);  /* check that MINIMIZED is an integer */
  return n;
}

static int _cffi_const_QW_VIEW_XDG(unsigned long long *o)
{
  int n = (QW_VIEW_XDG) <= 0;
  *o = (unsigned long long)((QW_VIEW_XDG) | 0);  /* check that QW_VIEW_XDG is an integer */
  return n;
}

static int _cffi_const_QW_VIEW_XDG_POPUP(unsigned long long *o)
{
  int n = (QW_VIEW_XDG_POPUP) <= 0;
  *o = (unsigned long long)((QW_VIEW_XDG_POPUP) | 0);  /* check that QW_VIEW_XDG_POPUP is an integer */
  return n;
}

static int _cffi_const_QW_VIEW_XWAYLAND(unsigned long long *o)
{
  int n = (QW_VIEW_XWAYLAND) <= 0;
  *o = (unsigned long long)((QW_VIEW_XWAYLAND) | 0);  /* check that QW_VIEW_XWAYLAND is an integer */
  return n;
}

static int _cffi_const_QW_VIEW_INTERNAL(unsigned long long *o)
{
  int n = (QW_VIEW_INTERNAL) <= 0;
  *o = (unsigned long long)((QW_VIEW_INTERNAL) | 0);  /* check that QW_VIEW_INTERNAL is an integer */
  return n;
}

static int _cffi_const_WALLPAPER_MODE_ORIGINAL(unsigned long long *o)
{
  int n = (WALLPAPER_MODE_ORIGINAL) <= 0;
  *o = (unsigned long long)((WALLPAPER_MODE_ORIGINAL) | 0);  /* check that WALLPAPER_MODE_ORIGINAL is an integer */
  return n;
}

static int _cffi_const_WALLPAPER_MODE_STRETCH(unsigned long long *o)
{
  int n = (WALLPAPER_MODE_STRETCH) <= 0;
  *o = (unsigned long long)((WALLPAPER_MODE_STRETCH) | 0);  /* check that WALLPAPER_MODE_STRETCH is an integer */
  return n;
}

static int _cffi_const_WALLPAPER_MODE_FILL(unsigned long long *o)
{
  int n = (WALLPAPER_MODE_FILL) <= 0;
  *o = (unsigned long long)((WALLPAPER_MODE_FILL) | 0);  /* check that WALLPAPER_MODE_FILL is an integer */
  return n;
}

static int _cffi_const_WALLPAPER_MODE_CENTER(unsigned long long *o)
{
  int n = (WALLPAPER_MODE_CENTER) <= 0;
  *o = (unsigned long long)((WALLPAPER_MODE_CENTER) | 0);  /* check that WALLPAPER_MODE_CENTER is an integer */
  return n;
}

static int _cffi_const_WLR_INPUT_DEVICE_KEYBOARD(unsigned long long *o)
{
  int n = (WLR_INPUT_DEVICE_KEYBOARD) <= 0;
  *o = (unsigned long long)((WLR_INPUT_DEVICE_KEYBOARD) | 0);  /* check that WLR_INPUT_DEVICE_KEYBOARD is an integer */
  return n;
}

static int _cffi_const_WLR_INPUT_DEVICE_POINTER(unsigned long long *o)
{
  int n = (WLR_INPUT_DEVICE_POINTER) <= 0;
  *o = (unsigned long long)((WLR_INPUT_DEVICE_POINTER) | 0);  /* check that WLR_INPUT_DEVICE_POINTER is an integer */
  return n;
}

static int _cffi_const_WLR_INPUT_DEVICE_TOUCH(unsigned long long *o)
{
  int n = (WLR_INPUT_DEVICE_TOUCH) <= 0;
  *o = (unsigned long long)((WLR_INPUT_DEVICE_TOUCH) | 0);  /* check that WLR_INPUT_DEVICE_TOUCH is an integer */
  return n;
}

static int _cffi_const_WLR_INPUT_DEVICE_TABLET(unsigned long long *o)
{
  int n = (WLR_INPUT_DEVICE_TABLET) <= 0;
  *o = (unsigned long long)((WLR_INPUT_DEVICE_TABLET) | 0);  /* check that WLR_INPUT_DEVICE_TABLET is an integer */
  return n;
}

static int _cffi_const_WLR_INPUT_DEVICE_TABLET_PAD(unsigned long long *o)
{
  int n = (WLR_INPUT_DEVICE_TABLET_PAD) <= 0;
  *o = (unsigned long long)((WLR_INPUT_DEVICE_TABLET_PAD) | 0);  /* check that WLR_INPUT_DEVICE_TABLET_PAD is an integer */
  return n;
}

static int _cffi_const_WLR_INPUT_DEVICE_SWITCH(unsigned long long *o)
{
  int n = (WLR_INPUT_DEVICE_SWITCH) <= 0;
  *o = (unsigned long long)((WLR_INPUT_DEVICE_SWITCH) | 0);  /* check that WLR_INPUT_DEVICE_SWITCH is an integer */
  return n;
}

static int _cffi_const_WLR_SILENT(unsigned long long *o)
{
  int n = (WLR_SILENT) <= 0;
  *o = (unsigned long long)((WLR_SILENT) | 0);  /* check that WLR_SILENT is an integer */
  return n;
}

static int _cffi_const_WLR_ERROR(unsigned long long *o)
{
  int n = (WLR_ERROR) <= 0;
  *o = (unsigned long long)((WLR_ERROR) | 0);  /* check that WLR_ERROR is an integer */
  return n;
}

static int _cffi_const_WLR_INFO(unsigned long long *o)
{
  int n = (WLR_INFO) <= 0;
  *o = (unsigned long long)((WLR_INFO) | 0);  /* check that WLR_INFO is an integer */
  return n;
}

static int _cffi_const_WLR_DEBUG(unsigned long long *o)
{
  int n = (WLR_DEBUG) <= 0;
  *o = (unsigned long long)((WLR_DEBUG) | 0);  /* check that WLR_DEBUG is an integer */
  return n;
}

static struct _cffi_externpy_s _cffi_externpy__add_idle_inhibitor_cb =
  { "libqtile.backend.wayland._ffi.add_idle_inhibitor_cb", (int)sizeof(_Bool), 0, 0 };

static _Bool add_idle_inhibitor_cb(void * a0, void * a1, void * a2, _Bool a3, _Bool a4)
{
  char a[40];
  char *p = a;
  *(void * *)(p + 0) = a0;
  *(void * *)(p + 8) = a1;
  *(void * *)(p + 16) = a2;
  *(_Bool *)(p + 24) = a3;
  *(_Bool *)(p + 32) = a4;
  _cffi_call_python(&_cffi_externpy__add_idle_inhibitor_cb, p);
  return *(_Bool *)p;
}

static struct _cffi_externpy_s _cffi_externpy__check_inhibited_cb =
  { "libqtile.backend.wayland._ffi.check_inhibited_cb", (int)sizeof(_Bool), 0, 0 };

static _Bool check_inhibited_cb(void * a0)
{
  char a[8];
  char *p = a;
  *(void * *)(p + 0) = a0;
  _cffi_call_python(&_cffi_externpy__check_inhibited_cb, p);
  return *(_Bool *)p;
}

static struct _cffi_externpy_s _cffi_externpy__cursor_button_cb =
  { "libqtile.backend.wayland._ffi.cursor_button_cb", (int)sizeof(int), 0, 0 };

static int cursor_button_cb(int a0, uint32_t a1, _Bool a2, int a3, int a4, void * a5)
{
  char a[48];
  char *p = a;
  *(int *)(p + 0) = a0;
  *(uint32_t *)(p + 8) = a1;
  *(_Bool *)(p + 16) = a2;
  *(int *)(p + 24) = a3;
  *(int *)(p + 32) = a4;
  *(void * *)(p + 40) = a5;
  _cffi_call_python(&_cffi_externpy__cursor_button_cb, p);
  return *(int *)p;
}

static struct _cffi_externpy_s _cffi_externpy__cursor_motion_cb =
  { "libqtile.backend.wayland._ffi.cursor_motion_cb", 0, 0, 0 };

static void cursor_motion_cb(void * a0)
{
  char a[8];
  char *p = a;
  *(void * *)(p + 0) = a0;
  _cffi_call_python(&_cffi_externpy__cursor_motion_cb, p);
}

static struct _cffi_externpy_s _cffi_externpy__focus_current_window_cb =
  { "libqtile.backend.wayland._ffi.focus_current_window_cb", (int)sizeof(_Bool), 0, 0 };

static _Bool focus_current_window_cb(void * a0)
{
  char a[8];
  char *p = a;
  *(void * *)(p + 0) = a0;
  _cffi_call_python(&_cffi_externpy__focus_current_window_cb, p);
  return *(_Bool *)p;
}

static struct _cffi_externpy_s _cffi_externpy__get_current_output_dims_cb =
  { "libqtile.backend.wayland._ffi.get_current_output_dims_cb", (int)sizeof(struct wlr_box), 0, 0 };

static struct wlr_box get_current_output_dims_cb(void * a0)
{
  char a[sizeof(struct wlr_box) > 8 ? sizeof(struct wlr_box) : 8];
  char *p = a;
  *(void * *)(p + 0) = a0;
  _cffi_call_python(&_cffi_externpy__get_current_output_dims_cb, p);
  return *(struct wlr_box *)p;
}

static struct _cffi_externpy_s _cffi_externpy__keyboard_key_cb =
  { "libqtile.backend.wayland._ffi.keyboard_key_cb", (int)sizeof(int), 0, 0 };

static int keyboard_key_cb(uint32_t a0, uint32_t a1, void * a2)
{
  char a[24];
  char *p = a;
  *(uint32_t *)(p + 0) = a0;
  *(uint32_t *)(p + 8) = a1;
  *(void * *)(p + 16) = a2;
  _cffi_call_python(&_cffi_externpy__keyboard_key_cb, p);
  return *(int *)p;
}

static struct _cffi_externpy_s _cffi_externpy__log_cb =
  { "libqtile.backend.wayland._ffi.log_cb", 0, 0, 0 };

static void log_cb(enum wlr_log_importance a0, char const * a1)
{
  char a[16];
  char *p = a;
  *(enum wlr_log_importance *)(p + 0) = a0;
  *(char const * *)(p + 8) = a1;
  _cffi_call_python(&_cffi_externpy__log_cb, p);
}

static struct _cffi_externpy_s _cffi_externpy__manage_view_cb =
  { "libqtile.backend.wayland._ffi.manage_view_cb", 0, 0, 0 };

static void manage_view_cb(struct qw_view * a0, void * a1)
{
  char a[16];
  char *p = a;
  *(struct qw_view * *)(p + 0) = a0;
  *(void * *)(p + 8) = a1;
  _cffi_call_python(&_cffi_externpy__manage_view_cb, p);
}

static struct _cffi_externpy_s _cffi_externpy__on_input_device_added_cb =
  { "libqtile.backend.wayland._ffi.on_input_device_added_cb", 0, 0, 0 };

static void on_input_device_added_cb(void * a0)
{
  char a[8];
  char *p = a;
  *(void * *)(p + 0) = a0;
  _cffi_call_python(&_cffi_externpy__on_input_device_added_cb, p);
}

static struct _cffi_externpy_s _cffi_externpy__on_screen_change_cb =
  { "libqtile.backend.wayland._ffi.on_screen_change_cb", 0, 0, 0 };

static void on_screen_change_cb(void * a0)
{
  char a[8];
  char *p = a;
  *(void * *)(p + 0) = a0;
  _cffi_call_python(&_cffi_externpy__on_screen_change_cb, p);
}

static struct _cffi_externpy_s _cffi_externpy__on_screen_reserve_space_cb =
  { "libqtile.backend.wayland._ffi.on_screen_reserve_space_cb", 0, 0, 0 };

static void on_screen_reserve_space_cb(struct qw_output * a0, void * a1)
{
  char a[16];
  char *p = a;
  *(struct qw_output * *)(p + 0) = a0;
  *(void * *)(p + 8) = a1;
  _cffi_call_python(&_cffi_externpy__on_screen_reserve_space_cb, p);
}

static struct _cffi_externpy_s _cffi_externpy__on_session_lock_cb =
  { "libqtile.backend.wayland._ffi.on_session_lock_cb", 0, 0, 0 };

static void on_session_lock_cb(_Bool a0, void * a1)
{
  char a[16];
  char *p = a;
  *(_Bool *)(p + 0) = a0;
  *(void * *)(p + 8) = a1;
  _cffi_call_python(&_cffi_externpy__on_session_lock_cb, p);
}

static struct _cffi_externpy_s _cffi_externpy__remove_idle_inhibitor_cb =
  { "libqtile.backend.wayland._ffi.remove_idle_inhibitor_cb", (int)sizeof(_Bool), 0, 0 };

static _Bool remove_idle_inhibitor_cb(void * a0, void * a1)
{
  char a[16];
  char *p = a;
  *(void * *)(p + 0) = a0;
  *(void * *)(p + 8) = a1;
  _cffi_call_python(&_cffi_externpy__remove_idle_inhibitor_cb, p);
  return *(_Bool *)p;
}

static struct _cffi_externpy_s _cffi_externpy__request_close_cb =
  { "libqtile.backend.wayland._ffi.request_close_cb", (int)sizeof(int), 0, 0 };

static int request_close_cb(void * a0)
{
  char a[8];
  char *p = a;
  *(void * *)(p + 0) = a0;
  _cffi_call_python(&_cffi_externpy__request_close_cb, p);
  return *(int *)p;
}

static struct _cffi_externpy_s _cffi_externpy__request_focus_cb =
  { "libqtile.backend.wayland._ffi.request_focus_cb", (int)sizeof(int), 0, 0 };

static int request_focus_cb(void * a0)
{
  char a[8];
  char *p = a;
  *(void * *)(p + 0) = a0;
  _cffi_call_python(&_cffi_externpy__request_focus_cb, p);
  return *(int *)p;
}

static struct _cffi_externpy_s _cffi_externpy__request_fullscreen_cb =
  { "libqtile.backend.wayland._ffi.request_fullscreen_cb", (int)sizeof(int), 0, 0 };

static int request_fullscreen_cb(_Bool a0, void * a1)
{
  char a[16];
  char *p = a;
  *(_Bool *)(p + 0) = a0;
  *(void * *)(p + 8) = a1;
  _cffi_call_python(&_cffi_externpy__request_fullscreen_cb, p);
  return *(int *)p;
}

static struct _cffi_externpy_s _cffi_externpy__request_maximize_cb =
  { "libqtile.backend.wayland._ffi.request_maximize_cb", (int)sizeof(int), 0, 0 };

static int request_maximize_cb(_Bool a0, void * a1)
{
  char a[16];
  char *p = a;
  *(_Bool *)(p + 0) = a0;
  *(void * *)(p + 8) = a1;
  _cffi_call_python(&_cffi_externpy__request_maximize_cb, p);
  return *(int *)p;
}

static struct _cffi_externpy_s _cffi_externpy__request_minimize_cb =
  { "libqtile.backend.wayland._ffi.request_minimize_cb", (int)sizeof(int), 0, 0 };

static int request_minimize_cb(_Bool a0, void * a1)
{
  char a[16];
  char *p = a;
  *(_Bool *)(p + 0) = a0;
  *(void * *)(p + 8) = a1;
  _cffi_call_python(&_cffi_externpy__request_minimize_cb, p);
  return *(int *)p;
}

static struct _cffi_externpy_s _cffi_externpy__set_app_id_cb =
  { "libqtile.backend.wayland._ffi.set_app_id_cb", 0, 0, 0 };

static void set_app_id_cb(char * a0, void * a1)
{
  char a[16];
  char *p = a;
  *(char * *)(p + 0) = a0;
  *(void * *)(p + 8) = a1;
  _cffi_call_python(&_cffi_externpy__set_app_id_cb, p);
}

static struct _cffi_externpy_s _cffi_externpy__set_title_cb =
  { "libqtile.backend.wayland._ffi.set_title_cb", 0, 0, 0 };

static void set_title_cb(char * a0, void * a1)
{
  char a[16];
  char *p = a;
  *(char * *)(p + 0) = a0;
  *(void * *)(p + 8) = a1;
  _cffi_call_python(&_cffi_externpy__set_title_cb, p);
}

static struct _cffi_externpy_s _cffi_externpy__unmanage_view_cb =
  { "libqtile.backend.wayland._ffi.unmanage_view_cb", 0, 0, 0 };

static void unmanage_view_cb(struct qw_view * a0, void * a1)
{
  char a[16];
  char *p = a;
  *(struct qw_view * *)(p + 0) = a0;
  *(void * *)(p + 8) = a1;
  _cffi_call_python(&_cffi_externpy__unmanage_view_cb, p);
}

static struct _cffi_externpy_s _cffi_externpy__view_activation_cb =
  { "libqtile.backend.wayland._ffi.view_activation_cb", 0, 0, 0 };

static void view_activation_cb(struct qw_view * a0, void * a1)
{
  char a[16];
  char *p = a;
  *(struct qw_view * *)(p + 0) = a0;
  *(void * *)(p + 8) = a1;
  _cffi_call_python(&_cffi_externpy__view_activation_cb, p);
}

static void _cffi_d_qw_cursor_destroy(struct qw_cursor * x0)
{
  qw_cursor_destroy(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_qw_cursor_destroy(PyObject *self, PyObject *arg0)
{
  struct qw_cursor * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(153), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct qw_cursor *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(153), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { qw_cursor_destroy(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_qw_cursor_destroy _cffi_d_qw_cursor_destroy
#endif

static void _cffi_d_qw_cursor_hide(struct qw_cursor * x0)
{
  qw_cursor_hide(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_qw_cursor_hide(PyObject *self, PyObject *arg0)
{
  struct qw_cursor * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(153), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct qw_cursor *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(153), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { qw_cursor_hide(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_qw_cursor_hide _cffi_d_qw_cursor_hide
#endif

static void _cffi_d_qw_cursor_pointer_constraint_new(struct qw_cursor * x0, struct wlr_pointer_constraint_v1 * x1)
{
  qw_cursor_pointer_constraint_new(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_qw_cursor_pointer_constraint_new(PyObject *self, PyObject *args)
{
  struct qw_cursor * x0;
  struct wlr_pointer_constraint_v1 * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "qw_cursor_pointer_constraint_new", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(153), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct qw_cursor *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(153), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(162), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_pointer_constraint_v1 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(162), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { qw_cursor_pointer_constraint_new(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_qw_cursor_pointer_constraint_new _cffi_d_qw_cursor_pointer_constraint_new
#endif

static void _cffi_d_qw_cursor_release_implicit_grab(struct qw_cursor * x0, uint32_t x1)
{
  qw_cursor_release_implicit_grab(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_qw_cursor_release_implicit_grab(PyObject *self, PyObject *args)
{
  struct qw_cursor * x0;
  uint32_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "qw_cursor_release_implicit_grab", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(153), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct qw_cursor *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(153), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { qw_cursor_release_implicit_grab(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_qw_cursor_release_implicit_grab _cffi_d_qw_cursor_release_implicit_grab
#endif

static void _cffi_d_qw_cursor_show(struct qw_cursor * x0)
{
  qw_cursor_show(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_qw_cursor_show(PyObject *self, PyObject *arg0)
{
  struct qw_cursor * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(153), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct qw_cursor *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(153), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { qw_cursor_show(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_qw_cursor_show _cffi_d_qw_cursor_show
#endif

static void _cffi_d_qw_cursor_update_pointer_focus(struct qw_cursor * x0)
{
  qw_cursor_update_pointer_focus(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_qw_cursor_update_pointer_focus(PyObject *self, PyObject *arg0)
{
  struct qw_cursor * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(153), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct qw_cursor *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(153), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { qw_cursor_update_pointer_focus(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_qw_cursor_update_pointer_focus _cffi_d_qw_cursor_update_pointer_focus
#endif

static void _cffi_d_qw_cursor_warp_cursor(struct qw_cursor * x0, double x1, double x2)
{
  qw_cursor_warp_cursor(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_qw_cursor_warp_cursor(PyObject *self, PyObject *args)
{
  struct qw_cursor * x0;
  double x1;
  double x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "qw_cursor_warp_cursor", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(153), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct qw_cursor *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(153), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (double)_cffi_to_c_double(arg1);
  if (x1 == (double)-1 && PyErr_Occurred())
    return NULL;

  x2 = (double)_cffi_to_c_double(arg2);
  if (x2 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { qw_cursor_warp_cursor(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_qw_cursor_warp_cursor _cffi_d_qw_cursor_warp_cursor
#endif

static void _cffi_d_qw_input_device_config_accel_set_profile(struct libinput_device * x0, int x1)
{
  qw_input_device_config_accel_set_profile(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_qw_input_device_config_accel_set_profile(PyObject *self, PyObject *args)
{
  struct libinput_device * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "qw_input_device_config_accel_set_profile", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(145), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct libinput_device *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(145), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { qw_input_device_config_accel_set_profile(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_qw_input_device_config_accel_set_profile _cffi_d_qw_input_device_config_accel_set_profile
#endif

static void _cffi_d_qw_input_device_config_accel_set_speed(struct libinput_device * x0, double x1)
{
  qw_input_device_config_accel_set_speed(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_qw_input_device_config_accel_set_speed(PyObject *self, PyObject *args)
{
  struct libinput_device * x0;
  double x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "qw_input_device_config_accel_set_speed", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(145), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct libinput_device *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(145), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (double)_cffi_to_c_double(arg1);
  if (x1 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { qw_input_device_config_accel_set_speed(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_qw_input_device_config_accel_set_speed _cffi_d_qw_input_device_config_accel_set_speed
#endif

static void _cffi_d_qw_input_device_config_click_set_method(struct libinput_device * x0, int x1)
{
  qw_input_device_config_click_set_method(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_qw_input_device_config_click_set_method(PyObject *self, PyObject *args)
{
  struct libinput_device * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "qw_input_device_config_click_set_method", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(145), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct libinput_device *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(145), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { qw_input_device_config_click_set_method(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_qw_input_device_config_click_set_method _cffi_d_qw_input_device_config_click_set_method
#endif

static void _cffi_d_qw_input_device_config_dwt_set_enabled(struct libinput_device * x0, int x1)
{
  qw_input_device_config_dwt_set_enabled(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_qw_input_device_config_dwt_set_enabled(PyObject *self, PyObject *args)
{
  struct libinput_device * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "qw_input_device_config_dwt_set_enabled", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(145), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct libinput_device *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(145), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { qw_input_device_config_dwt_set_enabled(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_qw_input_device_config_dwt_set_enabled _cffi_d_qw_input_device_config_dwt_set_enabled
#endif

static void _cffi_d_qw_input_device_config_left_handed_set(struct libinput_device * x0, int x1)
{
  qw_input_device_config_left_handed_set(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_qw_input_device_config_left_handed_set(PyObject *self, PyObject *args)
{
  struct libinput_device * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "qw_input_device_config_left_handed_set", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(145), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct libinput_device *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(145), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { qw_input_device_config_left_handed_set(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_qw_input_device_config_left_handed_set _cffi_d_qw_input_device_config_left_handed_set
#endif

static void _cffi_d_qw_input_device_config_middle_emulation_set_enabled(struct libinput_device * x0, int x1)
{
  qw_input_device_config_middle_emulation_set_enabled(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_qw_input_device_config_middle_emulation_set_enabled(PyObject *self, PyObject *args)
{
  struct libinput_device * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "qw_input_device_config_middle_emulation_set_enabled", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(145), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct libinput_device *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(145), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { qw_input_device_config_middle_emulation_set_enabled(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_qw_input_device_config_middle_emulation_set_enabled _cffi_d_qw_input_device_config_middle_emulation_set_enabled
#endif

static void _cffi_d_qw_input_device_config_scroll_set_button(struct libinput_device * x0, int x1)
{
  qw_input_device_config_scroll_set_button(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_qw_input_device_config_scroll_set_button(PyObject *self, PyObject *args)
{
  struct libinput_device * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "qw_input_device_config_scroll_set_button", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(145), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct libinput_device *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(145), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { qw_input_device_config_scroll_set_button(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_qw_input_device_config_scroll_set_button _cffi_d_qw_input_device_config_scroll_set_button
#endif

static void _cffi_d_qw_input_device_config_scroll_set_method(struct libinput_device * x0, int x1)
{
  qw_input_device_config_scroll_set_method(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_qw_input_device_config_scroll_set_method(PyObject *self, PyObject *args)
{
  struct libinput_device * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "qw_input_device_config_scroll_set_method", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(145), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct libinput_device *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(145), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { qw_input_device_config_scroll_set_method(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_qw_input_device_config_scroll_set_method _cffi_d_qw_input_device_config_scroll_set_method
#endif

static void _cffi_d_qw_input_device_config_scroll_set_natural_scroll_enabled(struct libinput_device * x0, int x1)
{
  qw_input_device_config_scroll_set_natural_scroll_enabled(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_qw_input_device_config_scroll_set_natural_scroll_enabled(PyObject *self, PyObject *args)
{
  struct libinput_device * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "qw_input_device_config_scroll_set_natural_scroll_enabled", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(145), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct libinput_device *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(145), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { qw_input_device_config_scroll_set_natural_scroll_enabled(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_qw_input_device_config_scroll_set_natural_scroll_enabled _cffi_d_qw_input_device_config_scroll_set_natural_scroll_enabled
#endif

static void _cffi_d_qw_input_device_config_tap_set_button_map(struct libinput_device * x0, int x1)
{
  qw_input_device_config_tap_set_button_map(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_qw_input_device_config_tap_set_button_map(PyObject *self, PyObject *args)
{
  struct libinput_device * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "qw_input_device_config_tap_set_button_map", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(145), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct libinput_device *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(145), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { qw_input_device_config_tap_set_button_map(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_qw_input_device_config_tap_set_button_map _cffi_d_qw_input_device_config_tap_set_button_map
#endif

static void _cffi_d_qw_input_device_config_tap_set_drag_enabled(struct libinput_device * x0, int x1)
{
  qw_input_device_config_tap_set_drag_enabled(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_qw_input_device_config_tap_set_drag_enabled(PyObject *self, PyObject *args)
{
  struct libinput_device * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "qw_input_device_config_tap_set_drag_enabled", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(145), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct libinput_device *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(145), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { qw_input_device_config_tap_set_drag_enabled(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_qw_input_device_config_tap_set_drag_enabled _cffi_d_qw_input_device_config_tap_set_drag_enabled
#endif

static void _cffi_d_qw_input_device_config_tap_set_drag_lock_enabled(struct libinput_device * x0, int x1)
{
  qw_input_device_config_tap_set_drag_lock_enabled(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_qw_input_device_config_tap_set_drag_lock_enabled(PyObject *self, PyObject *args)
{
  struct libinput_device * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "qw_input_device_config_tap_set_drag_lock_enabled", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(145), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct libinput_device *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(145), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { qw_input_device_config_tap_set_drag_lock_enabled(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_qw_input_device_config_tap_set_drag_lock_enabled _cffi_d_qw_input_device_config_tap_set_drag_lock_enabled
#endif

static void _cffi_d_qw_input_device_config_tap_set_enabled(struct libinput_device * x0, int x1)
{
  qw_input_device_config_tap_set_enabled(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_qw_input_device_config_tap_set_enabled(PyObject *self, PyObject *args)
{
  struct libinput_device * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "qw_input_device_config_tap_set_enabled", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(145), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct libinput_device *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(145), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { qw_input_device_config_tap_set_enabled(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_qw_input_device_config_tap_set_enabled _cffi_d_qw_input_device_config_tap_set_enabled
#endif

static struct qw_keyboard * _cffi_d_qw_input_device_get_keyboard(struct qw_input_device * x0)
{
  return qw_input_device_get_keyboard(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_qw_input_device_get_keyboard(PyObject *self, PyObject *arg0)
{
  struct qw_input_device * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct qw_keyboard * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(5), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct qw_input_device *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(5), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = qw_input_device_get_keyboard(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(183));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_qw_input_device_get_keyboard _cffi_d_qw_input_device_get_keyboard
#endif

static struct libinput_device * _cffi_d_qw_input_device_get_libinput_handle(struct qw_input_device * x0)
{
  return qw_input_device_get_libinput_handle(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_qw_input_device_get_libinput_handle(PyObject *self, PyObject *arg0)
{
  struct qw_input_device * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct libinput_device * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(5), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct qw_input_device *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(5), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = qw_input_device_get_libinput_handle(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(145));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_qw_input_device_get_libinput_handle _cffi_d_qw_input_device_get_libinput_handle
#endif

static _Bool _cffi_d_qw_input_device_is_touchpad(struct qw_input_device * x0)
{
  return qw_input_device_is_touchpad(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_qw_input_device_is_touchpad(PyObject *self, PyObject *arg0)
{
  struct qw_input_device * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(5), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct qw_input_device *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(5), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = qw_input_device_is_touchpad(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_qw_input_device_is_touchpad _cffi_d_qw_input_device_is_touchpad
#endif

static struct qw_view * _cffi_d_qw_internal_view_get_base(struct qw_internal_view * x0)
{
  return qw_internal_view_get_base(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_qw_internal_view_get_base(PyObject *self, PyObject *arg0)
{
  struct qw_internal_view * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct qw_view * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(88), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct qw_internal_view *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(88), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = qw_internal_view_get_base(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(12));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_qw_internal_view_get_base _cffi_d_qw_internal_view_get_base
#endif

static void _cffi_d_qw_internal_view_set_buffer_with_damage(struct qw_internal_view * x0, int x1, int x2, int x3, int x4)
{
  qw_internal_view_set_buffer_with_damage(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_qw_internal_view_set_buffer_with_damage(PyObject *self, PyObject *args)
{
  struct qw_internal_view * x0;
  int x1;
  int x2;
  int x3;
  int x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "qw_internal_view_set_buffer_with_damage", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(88), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct qw_internal_view *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(88), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, int);
  if (x3 == (int)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, int);
  if (x4 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { qw_internal_view_set_buffer_with_damage(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_qw_internal_view_set_buffer_with_damage _cffi_d_qw_internal_view_set_buffer_with_damage
#endif

static void _cffi_d_qw_keyboard_set_keymap(struct qw_keyboard * x0, char const * x1, char const * x2, char const * x3)
{
  qw_keyboard_set_keymap(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_qw_keyboard_set_keymap(PyObject *self, PyObject *args)
{
  struct qw_keyboard * x0;
  char const * x1;
  char const * x2;
  char const * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "qw_keyboard_set_keymap", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(183), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct qw_keyboard *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(183), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(45), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(45), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(45), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(45), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(45), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(45), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { qw_keyboard_set_keymap(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_qw_keyboard_set_keymap _cffi_d_qw_keyboard_set_keymap
#endif

static void _cffi_d_qw_keyboard_set_repeat_info(struct qw_keyboard * x0, int x1, int x2)
{
  qw_keyboard_set_repeat_info(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_qw_keyboard_set_repeat_info(PyObject *self, PyObject *args)
{
  struct qw_keyboard * x0;
  int x1;
  int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "qw_keyboard_set_repeat_info", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(183), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct qw_keyboard *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(183), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { qw_keyboard_set_repeat_info(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_qw_keyboard_set_repeat_info _cffi_d_qw_keyboard_set_repeat_info
#endif

static void _cffi_d_qw_log_init(enum wlr_log_importance x0, void(* x1)(enum wlr_log_importance, char const *))
{
  qw_log_init(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_qw_log_init(PyObject *self, PyObject *args)
{
  enum wlr_log_importance x0;
  void(* x1)(enum wlr_log_importance, char const *);
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "qw_log_init", 2, 2, &arg0, &arg1))
    return NULL;

  if (_cffi_to_c((char *)&x0, _cffi_type(128), arg0) < 0)
    return NULL;

  x1 = (void(*)(enum wlr_log_importance, char const *))_cffi_to_c_pointer(arg1, _cffi_type(133));
  if (x1 == (void(*)(enum wlr_log_importance, char const *))NULL && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { qw_log_init(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_qw_log_init _cffi_d_qw_log_init
#endif

static void _cffi_d_qw_output_arrange_layers(struct qw_output * x0)
{
  qw_output_arrange_layers(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_qw_output_arrange_layers(PyObject *self, PyObject *arg0)
{
  struct qw_output * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(194), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct qw_output *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(194), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { qw_output_arrange_layers(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_qw_output_arrange_layers _cffi_d_qw_output_arrange_layers
#endif

static void _cffi_d_qw_output_paint_background_color(struct qw_output * x0, float * x1)
{
  qw_output_paint_background_color(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_qw_output_paint_background_color(PyObject *self, PyObject *args)
{
  struct qw_output * x0;
  float * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "qw_output_paint_background_color", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(194), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct qw_output *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(194), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(207), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (float *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(207), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { qw_output_paint_background_color(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_qw_output_paint_background_color _cffi_d_qw_output_paint_background_color
#endif

static void _cffi_d_qw_output_paint_wallpaper(struct qw_output * x0, cairo_surface_t * x1, enum qw_wallpaper_mode x2)
{
  qw_output_paint_wallpaper(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_qw_output_paint_wallpaper(PyObject *self, PyObject *args)
{
  struct qw_output * x0;
  cairo_surface_t * x1;
  enum qw_wallpaper_mode x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "qw_output_paint_wallpaper", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(194), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct qw_output *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(194), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(202), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (cairo_surface_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(202), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x2, _cffi_type(203), arg2) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { qw_output_paint_wallpaper(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_qw_output_paint_wallpaper _cffi_d_qw_output_paint_wallpaper
#endif

static void _cffi_d_qw_output_toggle_fullscreen_background(struct qw_output * x0, _Bool x1)
{
  qw_output_toggle_fullscreen_background(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_qw_output_toggle_fullscreen_background(PyObject *self, PyObject *args)
{
  struct qw_output * x0;
  _Bool x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "qw_output_toggle_fullscreen_background", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(194), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct qw_output *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(194), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (_Bool)_cffi_to_c__Bool(arg1);
  if (x1 == (_Bool)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { qw_output_toggle_fullscreen_background(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_qw_output_toggle_fullscreen_background _cffi_d_qw_output_toggle_fullscreen_background
#endif

static _Bool _cffi_d_qw_server_change_vt(struct qw_server * x0, int x1)
{
  return qw_server_change_vt(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_qw_server_change_vt(PyObject *self, PyObject *args)
{
  struct qw_server * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "qw_server_change_vt", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(8), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct qw_server *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(8), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = qw_server_change_vt(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_qw_server_change_vt _cffi_d_qw_server_change_vt
#endif

static struct qw_server * _cffi_d_qw_server_create(void)
{
  return qw_server_create();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_qw_server_create(PyObject *self, PyObject *noarg)
{
  struct qw_server * result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = qw_server_create(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(8));
  return pyresult;
}
#else
#  define _cffi_f_qw_server_create _cffi_d_qw_server_create
#endif

static struct qw_cursor * _cffi_d_qw_server_cursor_create(struct qw_server * x0)
{
  return qw_server_cursor_create(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_qw_server_cursor_create(PyObject *self, PyObject *arg0)
{
  struct qw_server * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct qw_cursor * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(8), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct qw_server *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(8), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = qw_server_cursor_create(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(153));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_qw_server_cursor_create _cffi_d_qw_server_cursor_create
#endif

static void _cffi_d_qw_server_finalize(struct qw_server * x0)
{
  qw_server_finalize(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_qw_server_finalize(PyObject *self, PyObject *arg0)
{
  struct qw_server * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(8), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct qw_server *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(8), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { qw_server_finalize(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_qw_server_finalize _cffi_d_qw_server_finalize
#endif

static struct wlr_output * _cffi_d_qw_server_get_current_output(struct qw_server * x0)
{
  return qw_server_get_current_output(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_qw_server_get_current_output(PyObject *self, PyObject *arg0)
{
  struct qw_server * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_output * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(8), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct qw_server *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(8), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = qw_server_get_current_output(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(251));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_qw_server_get_current_output _cffi_d_qw_server_get_current_output
#endif

static struct qw_cursor * _cffi_d_qw_server_get_cursor(struct qw_server * x0)
{
  return qw_server_get_cursor(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_qw_server_get_cursor(PyObject *self, PyObject *arg0)
{
  struct qw_server * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct qw_cursor * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(8), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct qw_server *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(8), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = qw_server_get_cursor(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(153));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_qw_server_get_cursor _cffi_d_qw_server_get_cursor
#endif

static int _cffi_d_qw_server_get_event_loop_fd(struct qw_server * x0)
{
  return qw_server_get_event_loop_fd(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_qw_server_get_event_loop_fd(PyObject *self, PyObject *arg0)
{
  struct qw_server * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(8), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct qw_server *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(8), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = qw_server_get_event_loop_fd(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_qw_server_get_event_loop_fd _cffi_d_qw_server_get_event_loop_fd
#endif

static uint32_t _cffi_d_qw_server_get_sym_from_code(struct qw_server * x0, int x1)
{
  return qw_server_get_sym_from_code(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_qw_server_get_sym_from_code(PyObject *self, PyObject *args)
{
  struct qw_server * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "qw_server_get_sym_from_code", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(8), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct qw_server *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(8), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = qw_server_get_sym_from_code(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_qw_server_get_sym_from_code _cffi_d_qw_server_get_sym_from_code
#endif

static void _cffi_d_qw_server_idle_notify_activity(struct qw_server * x0)
{
  qw_server_idle_notify_activity(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_qw_server_idle_notify_activity(PyObject *self, PyObject *arg0)
{
  struct qw_server * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(8), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct qw_server *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(8), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { qw_server_idle_notify_activity(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_qw_server_idle_notify_activity _cffi_d_qw_server_idle_notify_activity
#endif

static _Bool _cffi_d_qw_server_inhibitor_surface_visible(struct qw_idle_inhibitor * x0, struct wlr_surface * x1)
{
  return qw_server_inhibitor_surface_visible(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_qw_server_inhibitor_surface_visible(PyObject *self, PyObject *args)
{
  struct qw_idle_inhibitor * x0;
  struct wlr_surface * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "qw_server_inhibitor_surface_visible", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct qw_idle_inhibitor *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(2), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = qw_server_inhibitor_surface_visible(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_qw_server_inhibitor_surface_visible _cffi_d_qw_server_inhibitor_surface_visible
#endif

static void _cffi_d_qw_server_input_device_new(struct qw_server * x0, struct wlr_input_device * x1)
{
  qw_server_input_device_new(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_qw_server_input_device_new(PyObject *self, PyObject *args)
{
  struct qw_server * x0;
  struct wlr_input_device * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "qw_server_input_device_new", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(8), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct qw_server *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(8), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(247), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_input_device *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(247), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { qw_server_input_device_new(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_qw_server_input_device_new _cffi_d_qw_server_input_device_new
#endif

static struct qw_internal_view * _cffi_d_qw_server_internal_view_new(struct qw_server * x0, int x1, int x2, int x3, int x4)
{
  return qw_server_internal_view_new(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_qw_server_internal_view_new(PyObject *self, PyObject *args)
{
  struct qw_server * x0;
  int x1;
  int x2;
  int x3;
  int x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct qw_internal_view * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "qw_server_internal_view_new", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(8), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct qw_server *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(8), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, int);
  if (x3 == (int)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, int);
  if (x4 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = qw_server_internal_view_new(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(88));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_qw_server_internal_view_new _cffi_d_qw_server_internal_view_new
#endif

static void _cffi_d_qw_server_keyboard_clear_focus(struct qw_server * x0)
{
  qw_server_keyboard_clear_focus(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_qw_server_keyboard_clear_focus(PyObject *self, PyObject *arg0)
{
  struct qw_server * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(8), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct qw_server *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(8), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { qw_server_keyboard_clear_focus(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_qw_server_keyboard_clear_focus _cffi_d_qw_server_keyboard_clear_focus
#endif

static void _cffi_d_qw_server_keyboard_new(struct qw_server * x0, struct wlr_input_device * x1)
{
  qw_server_keyboard_new(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_qw_server_keyboard_new(PyObject *self, PyObject *args)
{
  struct qw_server * x0;
  struct wlr_input_device * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "qw_server_keyboard_new", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(8), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct qw_server *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(8), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(247), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_input_device *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(247), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { qw_server_keyboard_new(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_qw_server_keyboard_new _cffi_d_qw_server_keyboard_new
#endif

static void _cffi_d_qw_server_loop_input_devices(struct qw_server * x0, void(* x1)(struct qw_input_device *, char const *, int, int, int))
{
  qw_server_loop_input_devices(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_qw_server_loop_input_devices(PyObject *self, PyObject *args)
{
  struct qw_server * x0;
  void(* x1)(struct qw_input_device *, char const *, int, int, int);
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "qw_server_loop_input_devices", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(8), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct qw_server *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(8), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (void(*)(struct qw_input_device *, char const *, int, int, int))_cffi_to_c_pointer(arg1, _cffi_type(263));
  if (x1 == (void(*)(struct qw_input_device *, char const *, int, int, int))NULL && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { qw_server_loop_input_devices(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_qw_server_loop_input_devices _cffi_d_qw_server_loop_input_devices
#endif

static void _cffi_d_qw_server_loop_output_dims(struct qw_server * x0, void(* x1)(int, int, int, int))
{
  qw_server_loop_output_dims(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_qw_server_loop_output_dims(PyObject *self, PyObject *args)
{
  struct qw_server * x0;
  void(* x1)(int, int, int, int);
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "qw_server_loop_output_dims", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(8), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct qw_server *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(8), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (void(*)(int, int, int, int))_cffi_to_c_pointer(arg1, _cffi_type(259));
  if (x1 == (void(*)(int, int, int, int))NULL && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { qw_server_loop_output_dims(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_qw_server_loop_output_dims _cffi_d_qw_server_loop_output_dims
#endif

static void _cffi_d_qw_server_loop_visible_views(struct qw_server * x0, void(* x1)(int))
{
  qw_server_loop_visible_views(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_qw_server_loop_visible_views(PyObject *self, PyObject *args)
{
  struct qw_server * x0;
  void(* x1)(int);
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "qw_server_loop_visible_views", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(8), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct qw_server *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(8), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (void(*)(int))_cffi_to_c_pointer(arg1, _cffi_type(255));
  if (x1 == (void(*)(int))NULL && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { qw_server_loop_visible_views(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_qw_server_loop_visible_views _cffi_d_qw_server_loop_visible_views
#endif

static void _cffi_d_qw_server_output_new(struct qw_server * x0, struct wlr_output * x1)
{
  qw_server_output_new(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_qw_server_output_new(PyObject *self, PyObject *args)
{
  struct qw_server * x0;
  struct wlr_output * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "qw_server_output_new", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(8), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct qw_server *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(8), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(251), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_output *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(251), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { qw_server_output_new(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_qw_server_output_new _cffi_d_qw_server_output_new
#endif

static void _cffi_d_qw_server_paint_background_color(struct qw_server * x0, int x1, int x2, float * x3)
{
  qw_server_paint_background_color(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_qw_server_paint_background_color(PyObject *self, PyObject *args)
{
  struct qw_server * x0;
  int x1;
  int x2;
  float * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "qw_server_paint_background_color", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(8), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct qw_server *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(8), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(207), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (float *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(207), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { qw_server_paint_background_color(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_qw_server_paint_background_color _cffi_d_qw_server_paint_background_color
#endif

static void _cffi_d_qw_server_paint_wallpaper(struct qw_server * x0, int x1, int x2, cairo_surface_t * x3, enum qw_wallpaper_mode x4)
{
  qw_server_paint_wallpaper(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_qw_server_paint_wallpaper(PyObject *self, PyObject *args)
{
  struct qw_server * x0;
  int x1;
  int x2;
  cairo_surface_t * x3;
  enum qw_wallpaper_mode x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "qw_server_paint_wallpaper", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(8), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct qw_server *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(8), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(202), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (cairo_surface_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(202), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x4, _cffi_type(203), arg4) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { qw_server_paint_wallpaper(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_qw_server_paint_wallpaper _cffi_d_qw_server_paint_wallpaper
#endif

static void _cffi_d_qw_server_poll(struct qw_server * x0)
{
  qw_server_poll(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_qw_server_poll(PyObject *self, PyObject *arg0)
{
  struct qw_server * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(8), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct qw_server *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(8), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { qw_server_poll(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_qw_server_poll _cffi_d_qw_server_poll
#endif

static void _cffi_d_qw_server_set_inhibited(struct qw_server * x0, _Bool x1)
{
  qw_server_set_inhibited(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_qw_server_set_inhibited(PyObject *self, PyObject *args)
{
  struct qw_server * x0;
  _Bool x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "qw_server_set_inhibited", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(8), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct qw_server *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(8), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (_Bool)_cffi_to_c__Bool(arg1);
  if (x1 == (_Bool)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { qw_server_set_inhibited(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_qw_server_set_inhibited _cffi_d_qw_server_set_inhibited
#endif

static void _cffi_d_qw_server_set_keymap(struct qw_server * x0, char const * x1, char const * x2, char const * x3)
{
  qw_server_set_keymap(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_qw_server_set_keymap(PyObject *self, PyObject *args)
{
  struct qw_server * x0;
  char const * x1;
  char const * x2;
  char const * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "qw_server_set_keymap", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(8), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct qw_server *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(8), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(45), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(45), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(45), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(45), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(45), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(45), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { qw_server_set_keymap(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_qw_server_set_keymap _cffi_d_qw_server_set_keymap
#endif

static void _cffi_d_qw_server_set_output_fullscreen_background(struct qw_server * x0, int x1, int x2, _Bool x3)
{
  qw_server_set_output_fullscreen_background(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_qw_server_set_output_fullscreen_background(PyObject *self, PyObject *args)
{
  struct qw_server * x0;
  int x1;
  int x2;
  _Bool x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "qw_server_set_output_fullscreen_background", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(8), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct qw_server *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(8), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  x3 = (_Bool)_cffi_to_c__Bool(arg3);
  if (x3 == (_Bool)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { qw_server_set_output_fullscreen_background(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_qw_server_set_output_fullscreen_background _cffi_d_qw_server_set_output_fullscreen_background
#endif

static void _cffi_d_qw_server_start(struct qw_server * x0)
{
  qw_server_start(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_qw_server_start(PyObject *self, PyObject *arg0)
{
  struct qw_server * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(8), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct qw_server *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(8), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { qw_server_start(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_qw_server_start _cffi_d_qw_server_start
#endif

static void _cffi_d_qw_server_traverse_scene_graph(struct qw_server * x0, void(* x1)(uintptr_t, uintptr_t, struct scene_node_info))
{
  qw_server_traverse_scene_graph(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_qw_server_traverse_scene_graph(PyObject *self, PyObject *args)
{
  struct qw_server * x0;
  void(* x1)(uintptr_t, uintptr_t, struct scene_node_info);
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "qw_server_traverse_scene_graph", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(8), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct qw_server *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(8), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (void(*)(uintptr_t, uintptr_t, struct scene_node_info))_cffi_to_c_pointer(arg1, _cffi_type(267));
  if (x1 == (void(*)(uintptr_t, uintptr_t, struct scene_node_info))NULL && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { qw_server_traverse_scene_graph(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_qw_server_traverse_scene_graph _cffi_d_qw_server_traverse_scene_graph
#endif

static struct qw_view * _cffi_d_qw_server_view_at(struct qw_server * x0, double x1, double x2, struct wlr_surface * * x3, double * x4, double * x5)
{
  return qw_server_view_at(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_qw_server_view_at(PyObject *self, PyObject *args)
{
  struct qw_server * x0;
  double x1;
  double x2;
  struct wlr_surface * * x3;
  double * x4;
  double * x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct qw_view * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "qw_server_view_at", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(8), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct qw_server *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(8), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (double)_cffi_to_c_double(arg1);
  if (x1 == (double)-1 && PyErr_Occurred())
    return NULL;

  x2 = (double)_cffi_to_c_double(arg2);
  if (x2 == (double)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(94), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (struct wlr_surface * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(94), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(95), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(95), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(95), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(95), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = qw_server_view_at(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(12));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_qw_server_view_at _cffi_d_qw_server_view_at
#endif

static char const * _cffi_d_qw_server_xwayland_display_name(struct qw_server * x0)
{
  return qw_server_xwayland_display_name(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_qw_server_xwayland_display_name(PyObject *self, PyObject *arg0)
{
  struct qw_server * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char const * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(8), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct qw_server *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(8), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = qw_server_xwayland_display_name(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(45));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_qw_server_xwayland_display_name _cffi_d_qw_server_xwayland_display_name
#endif

static void _cffi_d_qw_session_lock_focus_first_lock_surface(struct qw_server * x0)
{
  qw_session_lock_focus_first_lock_surface(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_qw_session_lock_focus_first_lock_surface(PyObject *self, PyObject *arg0)
{
  struct qw_server * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(8), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct qw_server *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(8), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { qw_session_lock_focus_first_lock_surface(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_qw_session_lock_focus_first_lock_surface _cffi_d_qw_session_lock_focus_first_lock_surface
#endif

static void _cffi_d_qw_session_lock_init(struct qw_server * x0)
{
  qw_session_lock_init(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_qw_session_lock_init(PyObject *self, PyObject *arg0)
{
  struct qw_server * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(8), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct qw_server *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(8), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { qw_session_lock_init(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_qw_session_lock_init _cffi_d_qw_session_lock_init
#endif

static void _cffi_d_qw_session_lock_output_change(struct qw_output * x0)
{
  qw_session_lock_output_change(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_qw_session_lock_output_change(PyObject *self, PyObject *arg0)
{
  struct qw_output * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(194), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct qw_output *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(194), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { qw_session_lock_output_change(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_qw_session_lock_output_change _cffi_d_qw_session_lock_output_change
#endif

static void _cffi_d_qw_session_lock_output_create_blanking_rects(struct qw_output * x0)
{
  qw_session_lock_output_create_blanking_rects(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_qw_session_lock_output_create_blanking_rects(PyObject *self, PyObject *arg0)
{
  struct qw_output * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(194), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct qw_output *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(194), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { qw_session_lock_output_create_blanking_rects(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_qw_session_lock_output_create_blanking_rects _cffi_d_qw_session_lock_output_create_blanking_rects
#endif

static _Bool _cffi_d_qw_surfaces_on_same_output(struct wlr_surface * x0, struct wlr_surface * x1)
{
  return qw_surfaces_on_same_output(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_qw_surfaces_on_same_output(PyObject *self, PyObject *args)
{
  struct wlr_surface * x0;
  struct wlr_surface * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "qw_surfaces_on_same_output", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(2), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(2), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = qw_surfaces_on_same_output(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_qw_surfaces_on_same_output _cffi_d_qw_surfaces_on_same_output
#endif

static void _cffi_d_qw_util_deactivate_surface(struct wlr_surface * x0)
{
  qw_util_deactivate_surface(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_qw_util_deactivate_surface(PyObject *self, PyObject *arg0)
{
  struct wlr_surface * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(2), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { qw_util_deactivate_surface(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_qw_util_deactivate_surface _cffi_d_qw_util_deactivate_surface
#endif

static int _cffi_d_qw_util_get_button_code(uint32_t x0)
{
  return qw_util_get_button_code(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_qw_util_get_button_code(PyObject *self, PyObject *arg0)
{
  uint32_t x0;
  int result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, uint32_t);
  if (x0 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = qw_util_get_button_code(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  return pyresult;
}
#else
#  define _cffi_f_qw_util_get_button_code _cffi_d_qw_util_get_button_code
#endif

static int _cffi_d_qw_util_get_modifier_code(char const * x0)
{
  return qw_util_get_modifier_code(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_qw_util_get_modifier_code(PyObject *self, PyObject *arg0)
{
  char const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(45), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(45), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = qw_util_get_modifier_code(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_qw_util_get_modifier_code _cffi_d_qw_util_get_modifier_code
#endif

static void _cffi_d_qw_view_cleanup_borders(struct qw_view * x0)
{
  qw_view_cleanup_borders(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_qw_view_cleanup_borders(PyObject *self, PyObject *arg0)
{
  struct qw_view * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct qw_view *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { qw_view_cleanup_borders(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_qw_view_cleanup_borders _cffi_d_qw_view_cleanup_borders
#endif

static struct qw_view * _cffi_d_qw_view_from_wlr_surface(struct wlr_surface * x0, _Bool * x1, _Bool * x2)
{
  return qw_view_from_wlr_surface(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_qw_view_from_wlr_surface(PyObject *self, PyObject *args)
{
  struct wlr_surface * x0;
  _Bool * x1;
  _Bool * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct qw_view * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "qw_view_from_wlr_surface", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(2), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(100), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (_Bool *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(100), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(100), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (_Bool *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(100), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = qw_view_from_wlr_surface(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(12));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_qw_view_from_wlr_surface _cffi_d_qw_view_from_wlr_surface
#endif

static void _cffi_d_qw_view_ftl_manager_handle_create(struct qw_view * x0)
{
  qw_view_ftl_manager_handle_create(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_qw_view_ftl_manager_handle_create(PyObject *self, PyObject *arg0)
{
  struct qw_view * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct qw_view *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { qw_view_ftl_manager_handle_create(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_qw_view_ftl_manager_handle_create _cffi_d_qw_view_ftl_manager_handle_create
#endif

static void _cffi_d_qw_view_ftl_manager_handle_destroy(struct qw_view * x0)
{
  qw_view_ftl_manager_handle_destroy(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_qw_view_ftl_manager_handle_destroy(PyObject *self, PyObject *arg0)
{
  struct qw_view * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct qw_view *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { qw_view_ftl_manager_handle_destroy(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_qw_view_ftl_manager_handle_destroy _cffi_d_qw_view_ftl_manager_handle_destroy
#endif

static _Bool _cffi_d_qw_view_is_visible(struct qw_view * x0)
{
  return qw_view_is_visible(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_qw_view_is_visible(PyObject *self, PyObject *arg0)
{
  struct qw_view * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct qw_view *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = qw_view_is_visible(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_qw_view_is_visible _cffi_d_qw_view_is_visible
#endif

static void _cffi_d_qw_view_lower_to_bottom(struct qw_view * x0)
{
  qw_view_lower_to_bottom(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_qw_view_lower_to_bottom(PyObject *self, PyObject *arg0)
{
  struct qw_view * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct qw_view *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { qw_view_lower_to_bottom(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_qw_view_lower_to_bottom _cffi_d_qw_view_lower_to_bottom
#endif

static void _cffi_d_qw_view_move_down(struct qw_view * x0)
{
  qw_view_move_down(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_qw_view_move_down(PyObject *self, PyObject *arg0)
{
  struct qw_view * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct qw_view *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { qw_view_move_down(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_qw_view_move_down _cffi_d_qw_view_move_down
#endif

static void _cffi_d_qw_view_move_up(struct qw_view * x0)
{
  qw_view_move_up(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_qw_view_move_up(PyObject *self, PyObject *arg0)
{
  struct qw_view * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct qw_view *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { qw_view_move_up(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_qw_view_move_up _cffi_d_qw_view_move_up
#endif

static void _cffi_d_qw_view_paint_borders(struct qw_view * x0, struct qw_border const * x1, int x2)
{
  qw_view_paint_borders(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_qw_view_paint_borders(PyObject *self, PyObject *args)
{
  struct qw_view * x0;
  struct qw_border const * x1;
  int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "qw_view_paint_borders", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct qw_view *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(283), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct qw_border const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(283), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { qw_view_paint_borders(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_qw_view_paint_borders _cffi_d_qw_view_paint_borders
#endif

static void _cffi_d_qw_view_raise_to_top(struct qw_view * x0)
{
  qw_view_raise_to_top(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_qw_view_raise_to_top(PyObject *self, PyObject *arg0)
{
  struct qw_view * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct qw_view *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { qw_view_raise_to_top(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_qw_view_raise_to_top _cffi_d_qw_view_raise_to_top
#endif

static void _cffi_d_qw_view_reparent(struct qw_view * x0, int x1)
{
  qw_view_reparent(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_qw_view_reparent(PyObject *self, PyObject *args)
{
  struct qw_view * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "qw_view_reparent", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct qw_view *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { qw_view_reparent(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_qw_view_reparent _cffi_d_qw_view_reparent
#endif

static void _cffi_d_qw_view_resize_ftl_output_tracking_buffer(struct qw_view * x0, int x1, int x2)
{
  qw_view_resize_ftl_output_tracking_buffer(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_qw_view_resize_ftl_output_tracking_buffer(PyObject *self, PyObject *args)
{
  struct qw_view * x0;
  int x1;
  int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "qw_view_resize_ftl_output_tracking_buffer", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct qw_view *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { qw_view_resize_ftl_output_tracking_buffer(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_qw_view_resize_ftl_output_tracking_buffer _cffi_d_qw_view_resize_ftl_output_tracking_buffer
#endif

static uint32_t _cffi_d_qwu_keysym_from_name(char const * x0)
{
  return qwu_keysym_from_name(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_qwu_keysym_from_name(PyObject *self, PyObject *arg0)
{
  char const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(45), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(45), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = qwu_keysym_from_name(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_qwu_keysym_from_name _cffi_d_qwu_keysym_from_name
#endif

static enum wlr_log_importance _cffi_d_wlr_log_get_verbosity(void)
{
  return wlr_log_get_verbosity();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_log_get_verbosity(PyObject *self, PyObject *noarg)
{
  enum wlr_log_importance result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_log_get_verbosity(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(128));
  return pyresult;
}
#else
#  define _cffi_f_wlr_log_get_verbosity _cffi_d_wlr_log_get_verbosity
#endif

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_qw_border(struct qw_border *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { enum qw_border_type *tmp = &p->type; (void)tmp; }
  (void)((p->width) | 0);  /* check that 'struct qw_border.width' is an integer */
  /* cannot generate 'struct $4' in field 'rect': unknown type name */
  /* cannot generate 'struct $5' in field 'buffer': unknown type name */
}
struct _cffi_align_struct_qw_border { char x; struct qw_border y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_qw_cursor(struct qw_cursor *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_cursor * *tmp = &p->cursor; (void)tmp; }
  { struct qw_view * *tmp = &p->view; (void)tmp; }
  { struct qw_implicit_grab *tmp = &p->implicit_grab; (void)tmp; }
}
struct _cffi_align_struct_qw_cursor { char x; struct qw_cursor y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_qw_drag_icon(struct qw_drag_icon *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct qw_server * *tmp = &p->server; (void)tmp; }
}
struct _cffi_align_struct_qw_drag_icon { char x; struct qw_drag_icon y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_qw_idle_inhibitor(struct qw_idle_inhibitor *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct qw_server * *tmp = &p->server; (void)tmp; }
}
struct _cffi_align_struct_qw_idle_inhibitor { char x; struct qw_idle_inhibitor y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_qw_implicit_grab(struct qw_implicit_grab *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { double *tmp = &p->start_dx; (void)tmp; }
  { double *tmp = &p->start_dy; (void)tmp; }
  (void)((p->live) | 0);  /* check that 'struct qw_implicit_grab.live' is an integer */
}
struct _cffi_align_struct_qw_implicit_grab { char x; struct qw_implicit_grab y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_qw_input_device(struct qw_input_device *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
}
struct _cffi_align_struct_qw_input_device { char x; struct qw_input_device y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_qw_internal_view(struct qw_internal_view *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct qw_view *tmp = &p->base; (void)tmp; }
  { struct wlr_scene_buffer * *tmp = &p->scene_buffer; (void)tmp; }
  { struct wlr_buffer * *tmp = &p->buffer; (void)tmp; }
  { cairo_surface_t * *tmp = &p->image_surface; (void)tmp; }
  { double *tmp = &p->scale; (void)tmp; }
}
struct _cffi_align_struct_qw_internal_view { char x; struct qw_internal_view y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_qw_keyboard(struct qw_keyboard *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
}
struct _cffi_align_struct_qw_keyboard { char x; struct qw_keyboard y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_qw_output(struct qw_output *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct qw_server * *tmp = &p->server; (void)tmp; }
  { struct wlr_scene_output * *tmp = &p->scene; (void)tmp; }
  { struct wlr_output * *tmp = &p->wlr_output; (void)tmp; }
  (void)((p->x) | 0);  /* check that 'struct qw_output.x' is an integer */
  (void)((p->y) | 0);  /* check that 'struct qw_output.y' is an integer */
  { struct wlr_box *tmp = &p->full_area; (void)tmp; }
  { struct wlr_box *tmp = &p->area; (void)tmp; }
}
struct _cffi_align_struct_qw_output { char x; struct qw_output y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_qw_output_background(struct qw_output_background *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { enum qw_background_type *tmp = &p->type; (void)tmp; }
  { struct wlr_scene_rect * *tmp = &p->color_rect; (void)tmp; }
  { struct qw_output_background_wallpaper * *tmp = &p->wallpaper; (void)tmp; }
}
struct _cffi_align_struct_qw_output_background { char x; struct qw_output_background y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_qw_output_background_wallpaper(struct qw_output_background_wallpaper *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_scene_buffer * *tmp = &p->buffer; (void)tmp; }
  { cairo_surface_t * *tmp = &p->surface; (void)tmp; }
}
struct _cffi_align_struct_qw_output_background_wallpaper { char x; struct qw_output_background_wallpaper y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_qw_pointer_constraint(struct qw_pointer_constraint *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct qw_cursor * *tmp = &p->cursor; (void)tmp; }
}
struct _cffi_align_struct_qw_pointer_constraint { char x; struct qw_pointer_constraint y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_qw_server(struct qw_server *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { char const * *tmp = &p->socket; (void)tmp; }
  { int(* *tmp)(uint32_t, uint32_t, void *) = &p->keyboard_key_cb; (void)tmp; }
  { void(* *tmp)(struct qw_view *, void *) = &p->manage_view_cb; (void)tmp; }
  { void(* *tmp)(struct qw_view *, void *) = &p->unmanage_view_cb; (void)tmp; }
  { void(* *tmp)(void *) = &p->cursor_motion_cb; (void)tmp; }
  { int(* *tmp)(int, uint32_t, _Bool, int, int, void *) = &p->cursor_button_cb; (void)tmp; }
  { void(* *tmp)(void *) = &p->on_screen_change_cb; (void)tmp; }
  { void(* *tmp)(struct qw_output *, void *) = &p->on_screen_reserve_space_cb; (void)tmp; }
  { void(* *tmp)(struct qw_view *, void *) = &p->view_activation_cb; (void)tmp; }
  { void(* *tmp)(void *) = &p->on_input_device_added_cb; (void)tmp; }
  { _Bool(* *tmp)(void *) = &p->focus_current_window_cb; (void)tmp; }
  { void(* *tmp)(_Bool, void *) = &p->on_session_lock_cb; (void)tmp; }
  { struct wlr_box(* *tmp)(void *) = &p->get_current_output_dims_cb; (void)tmp; }
  { _Bool(* *tmp)(void *, void *, void *, _Bool, _Bool) = &p->add_idle_inhibitor_cb; (void)tmp; }
  { _Bool(* *tmp)(void *, void *) = &p->remove_idle_inhibitor_cb; (void)tmp; }
  { _Bool(* *tmp)(void *) = &p->check_inhibited_cb; (void)tmp; }
  { void * *tmp = &p->view_activation_cb_data; (void)tmp; }
  { void * *tmp = &p->cb_data; (void)tmp; }
  { struct qw_layer_view * *tmp = &p->exclusive_layer; (void)tmp; }
}
struct _cffi_align_struct_qw_server { char x; struct qw_server y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_qw_session_lock(struct qw_session_lock *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct qw_server * *tmp = &p->server; (void)tmp; }
  { struct wlr_scene_tree * *tmp = &p->scene; (void)tmp; }
  { struct wlr_session_lock_v1 * *tmp = &p->lock; (void)tmp; }
}
struct _cffi_align_struct_qw_session_lock { char x; struct qw_session_lock y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_qw_session_lock_surface(struct qw_session_lock_surface *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct qw_server * *tmp = &p->server; (void)tmp; }
  { struct wlr_session_lock_surface_v1 * *tmp = &p->lock_surface; (void)tmp; }
}
struct _cffi_align_struct_qw_session_lock_surface { char x; struct qw_session_lock_surface y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_qw_view(struct qw_view *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct qw_server * *tmp = &p->server; (void)tmp; }
  (void)((p->layer) | 0);  /* check that 'struct qw_view.layer' is an integer */
  (void)((p->x) | 0);  /* check that 'struct qw_view.x' is an integer */
  (void)((p->y) | 0);  /* check that 'struct qw_view.y' is an integer */
  (void)((p->width) | 0);  /* check that 'struct qw_view.width' is an integer */
  (void)((p->height) | 0);  /* check that 'struct qw_view.height' is an integer */
  (void)((p->border_count) | 0);  /* check that 'struct qw_view.border_count' is an integer */
  { enum qw_view_state *tmp = &p->state; (void)tmp; }
  { enum qw_view_type *tmp = &p->view_type; (void)tmp; }
  { char * *tmp = &p->shell; (void)tmp; }
  (void)((p->wid) | 0);  /* check that 'struct qw_view.wid' is an integer */
  { char * *tmp = &p->title; (void)tmp; }
  { char * *tmp = &p->app_id; (void)tmp; }
  (void)((p->urgent) | 0);  /* check that 'struct qw_view.urgent' is an integer */
  { char * *tmp = &p->instance; (void)tmp; }
  { char * *tmp = &p->role; (void)tmp; }
  (void)((p->skip_taskbar) | 0);  /* check that 'struct qw_view.skip_taskbar' is an integer */
  { struct wlr_scene_tree * *tmp = &p->content_tree; (void)tmp; }
  { struct wlr_foreign_toplevel_handle_v1 * *tmp = &p->ftl_handle; (void)tmp; }
  { int(* *tmp)(void *) = &p->request_focus_cb; (void)tmp; }
  { int(* *tmp)(void *) = &p->request_close_cb; (void)tmp; }
  { int(* *tmp)(_Bool, void *) = &p->request_maximize_cb; (void)tmp; }
  { int(* *tmp)(_Bool, void *) = &p->request_minimize_cb; (void)tmp; }
  { int(* *tmp)(_Bool, void *) = &p->request_fullscreen_cb; (void)tmp; }
  { void(* *tmp)(char *, void *) = &p->set_title_cb; (void)tmp; }
  { void(* *tmp)(char *, void *) = &p->set_app_id_cb; (void)tmp; }
  { void * *tmp = &p->cb_data; (void)tmp; }
  { struct wlr_scene_node *(* *tmp)(void *) = &p->get_tree_node; (void)tmp; }
  { void(* *tmp)(void *, _Bool) = &p->update_fullscreen; (void)tmp; }
  { void(* *tmp)(void *, _Bool) = &p->update_maximized; (void)tmp; }
  { void(* *tmp)(void *, _Bool) = &p->update_minimized; (void)tmp; }
  { void(* *tmp)(void *, int, int, int, int, struct qw_border const *, int, int) = &p->place; (void)tmp; }
  { void(* *tmp)(void *, int) = &p->focus; (void)tmp; }
  { void(* *tmp)(void *) = &p->kill; (void)tmp; }
  { void(* *tmp)(void *) = &p->hide; (void)tmp; }
  { void(* *tmp)(void *) = &p->unhide; (void)tmp; }
  { int(* *tmp)(void *) = &p->get_pid; (void)tmp; }
  { char const *(* *tmp)(void *) = &p->get_wm_type; (void)tmp; }
  { _Bool(* *tmp)(void *) = &p->has_fixed_size; (void)tmp; }
  { int(* *tmp)(void *) = &p->get_parent; (void)tmp; }
}
struct _cffi_align_struct_qw_view { char x; struct qw_view y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_scene_node_info(struct scene_node_info *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { char * *tmp = &p->name; (void)tmp; }
  { char * *tmp = &p->type; (void)tmp; }
  (void)((p->enabled) | 0);  /* check that 'struct scene_node_info.enabled' is an integer */
  (void)((p->x) | 0);  /* check that 'struct scene_node_info.x' is an integer */
  (void)((p->y) | 0);  /* check that 'struct scene_node_info.y' is an integer */
  (void)((p->view_wid) | 0);  /* check that 'struct scene_node_info.view_wid' is an integer */
}
struct _cffi_align_struct_scene_node_info { char x; struct scene_node_info y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_box(struct wlr_box *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->x) | 0);  /* check that 'struct wlr_box.x' is an integer */
  (void)((p->y) | 0);  /* check that 'struct wlr_box.y' is an integer */
  (void)((p->width) | 0);  /* check that 'struct wlr_box.width' is an integer */
  (void)((p->height) | 0);  /* check that 'struct wlr_box.height' is an integer */
}
struct _cffi_align_struct_wlr_box { char x; struct wlr_box y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_cursor(struct wlr_cursor *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_cursor_state * *tmp = &p->state; (void)tmp; }
  { double *tmp = &p->x; (void)tmp; }
  { double *tmp = &p->y; (void)tmp; }
}
struct _cffi_align_struct_wlr_cursor { char x; struct wlr_cursor y; };

static float const (*_cffi_var_QW_SESSION_LOCK_BLANKING_RECT_CRASHED(void))[4]
{
  return &(QW_SESSION_LOCK_BLANKING_RECT_CRASHED);
}

static float const (*_cffi_var_QW_SESSION_LOCK_BLANKING_RECT_LOCKED(void))[4]
{
  return &(QW_SESSION_LOCK_BLANKING_RECT_LOCKED);
}

static const struct _cffi_global_s _cffi_globals[] = {
  { "ATOM_LAST", (void *)_cffi_const_ATOM_LAST, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "BUTTON_SCROLL_DOWN", (void *)_cffi_const_BUTTON_SCROLL_DOWN, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "BUTTON_SCROLL_LEFT", (void *)_cffi_const_BUTTON_SCROLL_LEFT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "BUTTON_SCROLL_RIGHT", (void *)_cffi_const_BUTTON_SCROLL_RIGHT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "BUTTON_SCROLL_UP", (void *)_cffi_const_BUTTON_SCROLL_UP, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "FLOATING", (void *)_cffi_const_FLOATING, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "FULLSCREEN", (void *)_cffi_const_FULLSCREEN, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "LAYER_BACKGROUND", (void *)_cffi_const_LAYER_BACKGROUND, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "LAYER_BOTTOM", (void *)_cffi_const_LAYER_BOTTOM, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "LAYER_BRINGTOFRONT", (void *)_cffi_const_LAYER_BRINGTOFRONT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "LAYER_DRAG_ICON", (void *)_cffi_const_LAYER_DRAG_ICON, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "LAYER_END", (void *)_cffi_const_LAYER_END, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "LAYER_FULLSCREEN", (void *)_cffi_const_LAYER_FULLSCREEN, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "LAYER_KEEPABOVE", (void *)_cffi_const_LAYER_KEEPABOVE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "LAYER_KEEPBELOW", (void *)_cffi_const_LAYER_KEEPBELOW, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "LAYER_LAYOUT", (void *)_cffi_const_LAYER_LAYOUT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "LAYER_LOCK", (void *)_cffi_const_LAYER_LOCK, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "LAYER_MAX", (void *)_cffi_const_LAYER_MAX, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "LAYER_OVERLAY", (void *)_cffi_const_LAYER_OVERLAY, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "LAYER_TOP", (void *)_cffi_const_LAYER_TOP, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "LIBINPUT_CONFIG_ACCEL_PROFILE_ADAPTIVE", (void *)_cffi_const_LIBINPUT_CONFIG_ACCEL_PROFILE_ADAPTIVE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "LIBINPUT_CONFIG_ACCEL_PROFILE_FLAT", (void *)_cffi_const_LIBINPUT_CONFIG_ACCEL_PROFILE_FLAT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "LIBINPUT_CONFIG_ACCEL_PROFILE_NONE", (void *)_cffi_const_LIBINPUT_CONFIG_ACCEL_PROFILE_NONE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "LIBINPUT_CONFIG_CLICK_METHOD_BUTTON_AREAS", (void *)_cffi_const_LIBINPUT_CONFIG_CLICK_METHOD_BUTTON_AREAS, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "LIBINPUT_CONFIG_CLICK_METHOD_CLICKFINGER", (void *)_cffi_const_LIBINPUT_CONFIG_CLICK_METHOD_CLICKFINGER, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "LIBINPUT_CONFIG_CLICK_METHOD_NONE", (void *)_cffi_const_LIBINPUT_CONFIG_CLICK_METHOD_NONE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "LIBINPUT_CONFIG_SCROLL_2FG", (void *)_cffi_const_LIBINPUT_CONFIG_SCROLL_2FG, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "LIBINPUT_CONFIG_SCROLL_EDGE", (void *)_cffi_const_LIBINPUT_CONFIG_SCROLL_EDGE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "LIBINPUT_CONFIG_SCROLL_NO_SCROLL", (void *)_cffi_const_LIBINPUT_CONFIG_SCROLL_NO_SCROLL, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "LIBINPUT_CONFIG_SCROLL_ON_BUTTON_DOWN", (void *)_cffi_const_LIBINPUT_CONFIG_SCROLL_ON_BUTTON_DOWN, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "LIBINPUT_CONFIG_TAP_MAP_LMR", (void *)_cffi_const_LIBINPUT_CONFIG_TAP_MAP_LMR, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "LIBINPUT_CONFIG_TAP_MAP_LRM", (void *)_cffi_const_LIBINPUT_CONFIG_TAP_MAP_LRM, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "MAXIMIZED", (void *)_cffi_const_MAXIMIZED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "MINIMIZED", (void *)_cffi_const_MINIMIZED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "NET_WM_WINDOW_TYPE_COMBO", (void *)_cffi_const_NET_WM_WINDOW_TYPE_COMBO, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "NET_WM_WINDOW_TYPE_DESKTOP", (void *)_cffi_const_NET_WM_WINDOW_TYPE_DESKTOP, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "NET_WM_WINDOW_TYPE_DIALOG", (void *)_cffi_const_NET_WM_WINDOW_TYPE_DIALOG, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "NET_WM_WINDOW_TYPE_DND", (void *)_cffi_const_NET_WM_WINDOW_TYPE_DND, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "NET_WM_WINDOW_TYPE_DOCK", (void *)_cffi_const_NET_WM_WINDOW_TYPE_DOCK, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "NET_WM_WINDOW_TYPE_DROPDOWN_MENU", (void *)_cffi_const_NET_WM_WINDOW_TYPE_DROPDOWN_MENU, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "NET_WM_WINDOW_TYPE_MENU", (void *)_cffi_const_NET_WM_WINDOW_TYPE_MENU, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "NET_WM_WINDOW_TYPE_NORMAL", (void *)_cffi_const_NET_WM_WINDOW_TYPE_NORMAL, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "NET_WM_WINDOW_TYPE_NOTIFICATION", (void *)_cffi_const_NET_WM_WINDOW_TYPE_NOTIFICATION, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "NET_WM_WINDOW_TYPE_POPUP_MENU", (void *)_cffi_const_NET_WM_WINDOW_TYPE_POPUP_MENU, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "NET_WM_WINDOW_TYPE_SPLASH", (void *)_cffi_const_NET_WM_WINDOW_TYPE_SPLASH, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "NET_WM_WINDOW_TYPE_TOOLBAR", (void *)_cffi_const_NET_WM_WINDOW_TYPE_TOOLBAR, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "NET_WM_WINDOW_TYPE_TOOLTIP", (void *)_cffi_const_NET_WM_WINDOW_TYPE_TOOLTIP, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "NET_WM_WINDOW_TYPE_UTILITY", (void *)_cffi_const_NET_WM_WINDOW_TYPE_UTILITY, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "NOT_FLOATING", (void *)_cffi_const_NOT_FLOATING, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "QW_BACKGROUND_COLOR_RECT", (void *)_cffi_const_QW_BACKGROUND_COLOR_RECT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "QW_BACKGROUND_DESTROYED", (void *)_cffi_const_QW_BACKGROUND_DESTROYED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "QW_BACKGROUND_WALLPAPER", (void *)_cffi_const_QW_BACKGROUND_WALLPAPER, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "QW_BORDER_BUFFER", (void *)_cffi_const_QW_BORDER_BUFFER, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "QW_BORDER_RECT", (void *)_cffi_const_QW_BORDER_RECT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "QW_SESSION_LOCK_BLANKING_RECT_CRASHED", (void *)_cffi_var_QW_SESSION_LOCK_BLANKING_RECT_CRASHED, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 339), (void *)0 },
  { "QW_SESSION_LOCK_BLANKING_RECT_LOCKED", (void *)_cffi_var_QW_SESSION_LOCK_BLANKING_RECT_LOCKED, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 339), (void *)0 },
  { "QW_SESSION_LOCK_CRASHED", (void *)_cffi_const_QW_SESSION_LOCK_CRASHED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "QW_SESSION_LOCK_LOCKED", (void *)_cffi_const_QW_SESSION_LOCK_LOCKED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "QW_SESSION_LOCK_UNLOCKED", (void *)_cffi_const_QW_SESSION_LOCK_UNLOCKED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "QW_VIEW_INTERNAL", (void *)_cffi_const_QW_VIEW_INTERNAL, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "QW_VIEW_XDG", (void *)_cffi_const_QW_VIEW_XDG, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "QW_VIEW_XDG_POPUP", (void *)_cffi_const_QW_VIEW_XDG_POPUP, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "QW_VIEW_XWAYLAND", (void *)_cffi_const_QW_VIEW_XWAYLAND, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "TOP", (void *)_cffi_const_TOP, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WALLPAPER_MODE_CENTER", (void *)_cffi_const_WALLPAPER_MODE_CENTER, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WALLPAPER_MODE_FILL", (void *)_cffi_const_WALLPAPER_MODE_FILL, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WALLPAPER_MODE_ORIGINAL", (void *)_cffi_const_WALLPAPER_MODE_ORIGINAL, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WALLPAPER_MODE_STRETCH", (void *)_cffi_const_WALLPAPER_MODE_STRETCH, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_DEBUG", (void *)_cffi_const_WLR_DEBUG, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_ERROR", (void *)_cffi_const_WLR_ERROR, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_INFO", (void *)_cffi_const_WLR_INFO, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_INPUT_DEVICE_KEYBOARD", (void *)_cffi_const_WLR_INPUT_DEVICE_KEYBOARD, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_INPUT_DEVICE_POINTER", (void *)_cffi_const_WLR_INPUT_DEVICE_POINTER, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_INPUT_DEVICE_SWITCH", (void *)_cffi_const_WLR_INPUT_DEVICE_SWITCH, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_INPUT_DEVICE_TABLET", (void *)_cffi_const_WLR_INPUT_DEVICE_TABLET, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_INPUT_DEVICE_TABLET_PAD", (void *)_cffi_const_WLR_INPUT_DEVICE_TABLET_PAD, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_INPUT_DEVICE_TOUCH", (void *)_cffi_const_WLR_INPUT_DEVICE_TOUCH, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_SILENT", (void *)_cffi_const_WLR_SILENT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "add_idle_inhibitor_cb", (void *)&_cffi_externpy__add_idle_inhibitor_cb, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 321), (void *)add_idle_inhibitor_cb },
  { "check_inhibited_cb", (void *)&_cffi_externpy__check_inhibited_cb, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 319), (void *)check_inhibited_cb },
  { "cursor_button_cb", (void *)&_cffi_externpy__cursor_button_cb, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 344), (void *)cursor_button_cb },
  { "cursor_motion_cb", (void *)&_cffi_externpy__cursor_motion_cb, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 402), (void *)cursor_motion_cb },
  { "focus_current_window_cb", (void *)&_cffi_externpy__focus_current_window_cb, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 319), (void *)focus_current_window_cb },
  { "get_current_output_dims_cb", (void *)&_cffi_externpy__get_current_output_dims_cb, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 369), (void *)get_current_output_dims_cb },
  { "keyboard_key_cb", (void *)&_cffi_externpy__keyboard_key_cb, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 345), (void *)keyboard_key_cb },
  { "log_cb", (void *)&_cffi_externpy__log_cb, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 133), (void *)log_cb },
  { "manage_view_cb", (void *)&_cffi_externpy__manage_view_cb, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 401), (void *)manage_view_cb },
  { "on_input_device_added_cb", (void *)&_cffi_externpy__on_input_device_added_cb, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 402), (void *)on_input_device_added_cb },
  { "on_screen_change_cb", (void *)&_cffi_externpy__on_screen_change_cb, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 402), (void *)on_screen_change_cb },
  { "on_screen_reserve_space_cb", (void *)&_cffi_externpy__on_screen_reserve_space_cb, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 400), (void *)on_screen_reserve_space_cb },
  { "on_session_lock_cb", (void *)&_cffi_externpy__on_session_lock_cb, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 398), (void *)on_session_lock_cb },
  { "qw_cursor_destroy", (void *)_cffi_f_qw_cursor_destroy, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 152), (void *)_cffi_d_qw_cursor_destroy },
  { "qw_cursor_hide", (void *)_cffi_f_qw_cursor_hide, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 152), (void *)_cffi_d_qw_cursor_hide },
  { "qw_cursor_pointer_constraint_new", (void *)_cffi_f_qw_cursor_pointer_constraint_new, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 160), (void *)_cffi_d_qw_cursor_pointer_constraint_new },
  { "qw_cursor_release_implicit_grab", (void *)_cffi_f_qw_cursor_release_implicit_grab, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 164), (void *)_cffi_d_qw_cursor_release_implicit_grab },
  { "qw_cursor_show", (void *)_cffi_f_qw_cursor_show, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 152), (void *)_cffi_d_qw_cursor_show },
  { "qw_cursor_update_pointer_focus", (void *)_cffi_f_qw_cursor_update_pointer_focus, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 152), (void *)_cffi_d_qw_cursor_update_pointer_focus },
  { "qw_cursor_warp_cursor", (void *)_cffi_f_qw_cursor_warp_cursor, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 155), (void *)_cffi_d_qw_cursor_warp_cursor },
  { "qw_input_device_config_accel_set_profile", (void *)_cffi_f_qw_input_device_config_accel_set_profile, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 148), (void *)_cffi_d_qw_input_device_config_accel_set_profile },
  { "qw_input_device_config_accel_set_speed", (void *)_cffi_f_qw_input_device_config_accel_set_speed, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 144), (void *)_cffi_d_qw_input_device_config_accel_set_speed },
  { "qw_input_device_config_click_set_method", (void *)_cffi_f_qw_input_device_config_click_set_method, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 148), (void *)_cffi_d_qw_input_device_config_click_set_method },
  { "qw_input_device_config_dwt_set_enabled", (void *)_cffi_f_qw_input_device_config_dwt_set_enabled, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 148), (void *)_cffi_d_qw_input_device_config_dwt_set_enabled },
  { "qw_input_device_config_left_handed_set", (void *)_cffi_f_qw_input_device_config_left_handed_set, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 148), (void *)_cffi_d_qw_input_device_config_left_handed_set },
  { "qw_input_device_config_middle_emulation_set_enabled", (void *)_cffi_f_qw_input_device_config_middle_emulation_set_enabled, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 148), (void *)_cffi_d_qw_input_device_config_middle_emulation_set_enabled },
  { "qw_input_device_config_scroll_set_button", (void *)_cffi_f_qw_input_device_config_scroll_set_button, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 148), (void *)_cffi_d_qw_input_device_config_scroll_set_button },
  { "qw_input_device_config_scroll_set_method", (void *)_cffi_f_qw_input_device_config_scroll_set_method, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 148), (void *)_cffi_d_qw_input_device_config_scroll_set_method },
  { "qw_input_device_config_scroll_set_natural_scroll_enabled", (void *)_cffi_f_qw_input_device_config_scroll_set_natural_scroll_enabled, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 148), (void *)_cffi_d_qw_input_device_config_scroll_set_natural_scroll_enabled },
  { "qw_input_device_config_tap_set_button_map", (void *)_cffi_f_qw_input_device_config_tap_set_button_map, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 148), (void *)_cffi_d_qw_input_device_config_tap_set_button_map },
  { "qw_input_device_config_tap_set_drag_enabled", (void *)_cffi_f_qw_input_device_config_tap_set_drag_enabled, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 148), (void *)_cffi_d_qw_input_device_config_tap_set_drag_enabled },
  { "qw_input_device_config_tap_set_drag_lock_enabled", (void *)_cffi_f_qw_input_device_config_tap_set_drag_lock_enabled, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 148), (void *)_cffi_d_qw_input_device_config_tap_set_drag_lock_enabled },
  { "qw_input_device_config_tap_set_enabled", (void *)_cffi_f_qw_input_device_config_tap_set_enabled, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 148), (void *)_cffi_d_qw_input_device_config_tap_set_enabled },
  { "qw_input_device_get_keyboard", (void *)_cffi_f_qw_input_device_get_keyboard, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 82), (void *)_cffi_d_qw_input_device_get_keyboard },
  { "qw_input_device_get_libinput_handle", (void *)_cffi_f_qw_input_device_get_libinput_handle, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 69), (void *)_cffi_d_qw_input_device_get_libinput_handle },
  { "qw_input_device_is_touchpad", (void *)_cffi_f_qw_input_device_is_touchpad, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 4), (void *)_cffi_d_qw_input_device_is_touchpad },
  { "qw_internal_view_get_base", (void *)_cffi_f_qw_internal_view_get_base, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 87), (void *)_cffi_d_qw_internal_view_get_base },
  { "qw_internal_view_set_buffer_with_damage", (void *)_cffi_f_qw_internal_view_set_buffer_with_damage, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 175), (void *)_cffi_d_qw_internal_view_set_buffer_with_damage },
  { "qw_keyboard_set_keymap", (void *)_cffi_f_qw_keyboard_set_keymap, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 182), (void *)_cffi_d_qw_keyboard_set_keymap },
  { "qw_keyboard_set_repeat_info", (void *)_cffi_f_qw_keyboard_set_repeat_info, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 188), (void *)_cffi_d_qw_keyboard_set_repeat_info },
  { "qw_log_init", (void *)_cffi_f_qw_log_init, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 131), (void *)_cffi_d_qw_log_init },
  { "qw_output_arrange_layers", (void *)_cffi_f_qw_output_arrange_layers, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 193), (void *)_cffi_d_qw_output_arrange_layers },
  { "qw_output_paint_background_color", (void *)_cffi_f_qw_output_paint_background_color, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 205), (void *)_cffi_d_qw_output_paint_background_color },
  { "qw_output_paint_wallpaper", (void *)_cffi_f_qw_output_paint_wallpaper, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 200), (void *)_cffi_d_qw_output_paint_wallpaper },
  { "qw_output_toggle_fullscreen_background", (void *)_cffi_f_qw_output_toggle_fullscreen_background, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 196), (void *)_cffi_d_qw_output_toggle_fullscreen_background },
  { "qw_server_change_vt", (void *)_cffi_f_qw_server_change_vt, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 7), (void *)_cffi_d_qw_server_change_vt },
  { "qw_server_create", (void *)_cffi_f_qw_server_create, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 85), (void *)_cffi_d_qw_server_create },
  { "qw_server_cursor_create", (void *)_cffi_f_qw_server_cursor_create, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 72), (void *)_cffi_d_qw_server_cursor_create },
  { "qw_server_finalize", (void *)_cffi_f_qw_server_finalize, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 213), (void *)_cffi_d_qw_server_finalize },
  { "qw_server_get_current_output", (void *)_cffi_f_qw_server_get_current_output, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 106), (void *)_cffi_d_qw_server_get_current_output },
  { "qw_server_get_cursor", (void *)_cffi_f_qw_server_get_cursor, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 72), (void *)_cffi_d_qw_server_get_cursor },
  { "qw_server_get_event_loop_fd", (void *)_cffi_f_qw_server_get_event_loop_fd, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 55), (void *)_cffi_d_qw_server_get_event_loop_fd },
  { "qw_server_get_sym_from_code", (void *)_cffi_f_qw_server_get_sym_from_code, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 115), (void *)_cffi_d_qw_server_get_sym_from_code },
  { "qw_server_idle_notify_activity", (void *)_cffi_f_qw_server_idle_notify_activity, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 213), (void *)_cffi_d_qw_server_idle_notify_activity },
  { "qw_server_inhibitor_surface_visible", (void *)_cffi_f_qw_server_inhibitor_surface_visible, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 0), (void *)_cffi_d_qw_server_inhibitor_surface_visible },
  { "qw_server_input_device_new", (void *)_cffi_f_qw_server_input_device_new, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 245), (void *)_cffi_d_qw_server_input_device_new },
  { "qw_server_internal_view_new", (void *)_cffi_f_qw_server_internal_view_new, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 75), (void *)_cffi_d_qw_server_internal_view_new },
  { "qw_server_keyboard_clear_focus", (void *)_cffi_f_qw_server_keyboard_clear_focus, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 213), (void *)_cffi_d_qw_server_keyboard_clear_focus },
  { "qw_server_keyboard_new", (void *)_cffi_f_qw_server_keyboard_new, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 245), (void *)_cffi_d_qw_server_keyboard_new },
  { "qw_server_loop_input_devices", (void *)_cffi_f_qw_server_loop_input_devices, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 261), (void *)_cffi_d_qw_server_loop_input_devices },
  { "qw_server_loop_output_dims", (void *)_cffi_f_qw_server_loop_output_dims, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 257), (void *)_cffi_d_qw_server_loop_output_dims },
  { "qw_server_loop_visible_views", (void *)_cffi_f_qw_server_loop_visible_views, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 253), (void *)_cffi_d_qw_server_loop_visible_views },
  { "qw_server_output_new", (void *)_cffi_f_qw_server_output_new, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 249), (void *)_cffi_d_qw_server_output_new },
  { "qw_server_paint_background_color", (void *)_cffi_f_qw_server_paint_background_color, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 239), (void *)_cffi_d_qw_server_paint_background_color },
  { "qw_server_paint_wallpaper", (void *)_cffi_f_qw_server_paint_wallpaper, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 232), (void *)_cffi_d_qw_server_paint_wallpaper },
  { "qw_server_poll", (void *)_cffi_f_qw_server_poll, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 213), (void *)_cffi_d_qw_server_poll },
  { "qw_server_set_inhibited", (void *)_cffi_f_qw_server_set_inhibited, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 216), (void *)_cffi_d_qw_server_set_inhibited },
  { "qw_server_set_keymap", (void *)_cffi_f_qw_server_set_keymap, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 220), (void *)_cffi_d_qw_server_set_keymap },
  { "qw_server_set_output_fullscreen_background", (void *)_cffi_f_qw_server_set_output_fullscreen_background, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 226), (void *)_cffi_d_qw_server_set_output_fullscreen_background },
  { "qw_server_start", (void *)_cffi_f_qw_server_start, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 213), (void *)_cffi_d_qw_server_start },
  { "qw_server_traverse_scene_graph", (void *)_cffi_f_qw_server_traverse_scene_graph, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 265), (void *)_cffi_d_qw_server_traverse_scene_graph },
  { "qw_server_view_at", (void *)_cffi_f_qw_server_view_at, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 90), (void *)_cffi_d_qw_server_view_at },
  { "qw_server_xwayland_display_name", (void *)_cffi_f_qw_server_xwayland_display_name, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 32), (void *)_cffi_d_qw_server_xwayland_display_name },
  { "qw_session_lock_focus_first_lock_surface", (void *)_cffi_f_qw_session_lock_focus_first_lock_surface, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 213), (void *)_cffi_d_qw_session_lock_focus_first_lock_surface },
  { "qw_session_lock_init", (void *)_cffi_f_qw_session_lock_init, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 213), (void *)_cffi_d_qw_session_lock_init },
  { "qw_session_lock_output_change", (void *)_cffi_f_qw_session_lock_output_change, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 193), (void *)_cffi_d_qw_session_lock_output_change },
  { "qw_session_lock_output_create_blanking_rects", (void *)_cffi_f_qw_session_lock_output_create_blanking_rects, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 193), (void *)_cffi_d_qw_session_lock_output_create_blanking_rects },
  { "qw_surfaces_on_same_output", (void *)_cffi_f_qw_surfaces_on_same_output, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 14), (void *)_cffi_d_qw_surfaces_on_same_output },
  { "qw_util_deactivate_surface", (void *)_cffi_f_qw_util_deactivate_surface, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 290), (void *)_cffi_d_qw_util_deactivate_surface },
  { "qw_util_get_button_code", (void *)_cffi_f_qw_util_get_button_code, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 58), (void *)_cffi_d_qw_util_get_button_code },
  { "qw_util_get_modifier_code", (void *)_cffi_f_qw_util_get_modifier_code, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 44), (void *)_cffi_d_qw_util_get_modifier_code },
  { "qw_view_cleanup_borders", (void *)_cffi_f_qw_view_cleanup_borders, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 269), (void *)_cffi_d_qw_view_cleanup_borders },
  { "qw_view_from_wlr_surface", (void *)_cffi_f_qw_view_from_wlr_surface, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 98), (void *)_cffi_d_qw_view_from_wlr_surface },
  { "qw_view_ftl_manager_handle_create", (void *)_cffi_f_qw_view_ftl_manager_handle_create, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 269), (void *)_cffi_d_qw_view_ftl_manager_handle_create },
  { "qw_view_ftl_manager_handle_destroy", (void *)_cffi_f_qw_view_ftl_manager_handle_destroy, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 269), (void *)_cffi_d_qw_view_ftl_manager_handle_destroy },
  { "qw_view_is_visible", (void *)_cffi_f_qw_view_is_visible, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 11), (void *)_cffi_d_qw_view_is_visible },
  { "qw_view_lower_to_bottom", (void *)_cffi_f_qw_view_lower_to_bottom, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 269), (void *)_cffi_d_qw_view_lower_to_bottom },
  { "qw_view_move_down", (void *)_cffi_f_qw_view_move_down, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 269), (void *)_cffi_d_qw_view_move_down },
  { "qw_view_move_up", (void *)_cffi_f_qw_view_move_up, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 269), (void *)_cffi_d_qw_view_move_up },
  { "qw_view_paint_borders", (void *)_cffi_f_qw_view_paint_borders, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 281), (void *)_cffi_d_qw_view_paint_borders },
  { "qw_view_raise_to_top", (void *)_cffi_f_qw_view_raise_to_top, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 269), (void *)_cffi_d_qw_view_raise_to_top },
  { "qw_view_reparent", (void *)_cffi_f_qw_view_reparent, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 272), (void *)_cffi_d_qw_view_reparent },
  { "qw_view_resize_ftl_output_tracking_buffer", (void *)_cffi_f_qw_view_resize_ftl_output_tracking_buffer, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 276), (void *)_cffi_d_qw_view_resize_ftl_output_tracking_buffer },
  { "qwu_keysym_from_name", (void *)_cffi_f_qwu_keysym_from_name, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 112), (void *)_cffi_d_qwu_keysym_from_name },
  { "remove_idle_inhibitor_cb", (void *)&_cffi_externpy__remove_idle_inhibitor_cb, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 320), (void *)remove_idle_inhibitor_cb },
  { "request_close_cb", (void *)&_cffi_externpy__request_close_cb, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 346), (void *)request_close_cb },
  { "request_focus_cb", (void *)&_cffi_externpy__request_focus_cb, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 346), (void *)request_focus_cb },
  { "request_fullscreen_cb", (void *)&_cffi_externpy__request_fullscreen_cb, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 343), (void *)request_fullscreen_cb },
  { "request_maximize_cb", (void *)&_cffi_externpy__request_maximize_cb, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 343), (void *)request_maximize_cb },
  { "request_minimize_cb", (void *)&_cffi_externpy__request_minimize_cb, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 343), (void *)request_minimize_cb },
  { "set_app_id_cb", (void *)&_cffi_externpy__set_app_id_cb, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 399), (void *)set_app_id_cb },
  { "set_title_cb", (void *)&_cffi_externpy__set_title_cb, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 399), (void *)set_title_cb },
  { "unmanage_view_cb", (void *)&_cffi_externpy__unmanage_view_cb, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 401), (void *)unmanage_view_cb },
  { "view_activation_cb", (void *)&_cffi_externpy__view_activation_cb, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 401), (void *)view_activation_cb },
  { "wlr_log_get_verbosity", (void *)_cffi_f_wlr_log_get_verbosity, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 38), (void *)_cffi_d_wlr_log_get_verbosity },
};

static const struct _cffi_field_s _cffi_fields[] = {
  { "type", offsetof(struct qw_border, type),
            sizeof(((struct qw_border *)0)->type),
            _CFFI_OP(_CFFI_OP_NOOP, 333) },
  { "width", offsetof(struct qw_border, width),
             sizeof(((struct qw_border *)0)->width),
             _CFFI_OP(_CFFI_OP_NOOP, 49) },
  { "rect", offsetof(struct qw_border, rect),
            sizeof(((struct qw_border *)0)->rect),
            _CFFI_OP(_CFFI_OP_NOOP, 347) },
  { "buffer", offsetof(struct qw_border, buffer),
              sizeof(((struct qw_border *)0)->buffer),
              _CFFI_OP(_CFFI_OP_NOOP, 348) },
  { "cursor", offsetof(struct qw_cursor, cursor),
              sizeof(((struct qw_cursor *)0)->cursor),
              _CFFI_OP(_CFFI_OP_NOOP, 373) },
  { "view", offsetof(struct qw_cursor, view),
            sizeof(((struct qw_cursor *)0)->view),
            _CFFI_OP(_CFFI_OP_NOOP, 12) },
  { "implicit_grab", offsetof(struct qw_cursor, implicit_grab),
                     sizeof(((struct qw_cursor *)0)->implicit_grab),
                     _CFFI_OP(_CFFI_OP_NOOP, 354) },
  { "server", offsetof(struct qw_drag_icon, server),
              sizeof(((struct qw_drag_icon *)0)->server),
              _CFFI_OP(_CFFI_OP_NOOP, 8) },
  { "server", offsetof(struct qw_idle_inhibitor, server),
              sizeof(((struct qw_idle_inhibitor *)0)->server),
              _CFFI_OP(_CFFI_OP_NOOP, 8) },
  { "start_dx", offsetof(struct qw_implicit_grab, start_dx),
                sizeof(((struct qw_implicit_grab *)0)->start_dx),
                _CFFI_OP(_CFFI_OP_NOOP, 92) },
  { "start_dy", offsetof(struct qw_implicit_grab, start_dy),
                sizeof(((struct qw_implicit_grab *)0)->start_dy),
                _CFFI_OP(_CFFI_OP_NOOP, 92) },
  { "live", offsetof(struct qw_implicit_grab, live),
            sizeof(((struct qw_implicit_grab *)0)->live),
            _CFFI_OP(_CFFI_OP_NOOP, 29) },
  { "base", offsetof(struct qw_internal_view, base),
            sizeof(((struct qw_internal_view *)0)->base),
            _CFFI_OP(_CFFI_OP_NOOP, 368) },
  { "scene_buffer", offsetof(struct qw_internal_view, scene_buffer),
                    sizeof(((struct qw_internal_view *)0)->scene_buffer),
                    _CFFI_OP(_CFFI_OP_NOOP, 382) },
  { "buffer", offsetof(struct qw_internal_view, buffer),
              sizeof(((struct qw_internal_view *)0)->buffer),
              _CFFI_OP(_CFFI_OP_NOOP, 371) },
  { "image_surface", offsetof(struct qw_internal_view, image_surface),
                     sizeof(((struct qw_internal_view *)0)->image_surface),
                     _CFFI_OP(_CFFI_OP_NOOP, 202) },
  { "scale", offsetof(struct qw_internal_view, scale),
             sizeof(((struct qw_internal_view *)0)->scale),
             _CFFI_OP(_CFFI_OP_NOOP, 92) },
  { "server", offsetof(struct qw_output, server),
              sizeof(((struct qw_output *)0)->server),
              _CFFI_OP(_CFFI_OP_NOOP, 8) },
  { "scene", offsetof(struct qw_output, scene),
             sizeof(((struct qw_output *)0)->scene),
             _CFFI_OP(_CFFI_OP_NOOP, 387) },
  { "wlr_output", offsetof(struct qw_output, wlr_output),
                  sizeof(((struct qw_output *)0)->wlr_output),
                  _CFFI_OP(_CFFI_OP_NOOP, 251) },
  { "x", offsetof(struct qw_output, x),
         sizeof(((struct qw_output *)0)->x),
         _CFFI_OP(_CFFI_OP_NOOP, 9) },
  { "y", offsetof(struct qw_output, y),
         sizeof(((struct qw_output *)0)->y),
         _CFFI_OP(_CFFI_OP_NOOP, 9) },
  { "full_area", offsetof(struct qw_output, full_area),
                 sizeof(((struct qw_output *)0)->full_area),
                 _CFFI_OP(_CFFI_OP_NOOP, 370) },
  { "area", offsetof(struct qw_output, area),
            sizeof(((struct qw_output *)0)->area),
            _CFFI_OP(_CFFI_OP_NOOP, 370) },
  { "type", offsetof(struct qw_output_background, type),
            sizeof(((struct qw_output_background *)0)->type),
            _CFFI_OP(_CFFI_OP_NOOP, 332) },
  { "color_rect", offsetof(struct qw_output_background, color_rect),
                  sizeof(((struct qw_output_background *)0)->color_rect),
                  _CFFI_OP(_CFFI_OP_NOOP, 389) },
  { "wallpaper", offsetof(struct qw_output_background, wallpaper),
                 sizeof(((struct qw_output_background *)0)->wallpaper),
                 _CFFI_OP(_CFFI_OP_NOOP, 362) },
  { "buffer", offsetof(struct qw_output_background_wallpaper, buffer),
              sizeof(((struct qw_output_background_wallpaper *)0)->buffer),
              _CFFI_OP(_CFFI_OP_NOOP, 382) },
  { "surface", offsetof(struct qw_output_background_wallpaper, surface),
               sizeof(((struct qw_output_background_wallpaper *)0)->surface),
               _CFFI_OP(_CFFI_OP_NOOP, 202) },
  { "cursor", offsetof(struct qw_pointer_constraint, cursor),
              sizeof(((struct qw_pointer_constraint *)0)->cursor),
              _CFFI_OP(_CFFI_OP_NOOP, 153) },
  { "socket", offsetof(struct qw_server, socket),
              sizeof(((struct qw_server *)0)->socket),
              _CFFI_OP(_CFFI_OP_NOOP, 45) },
  { "keyboard_key_cb", offsetof(struct qw_server, keyboard_key_cb),
                       sizeof(((struct qw_server *)0)->keyboard_key_cb),
                       _CFFI_OP(_CFFI_OP_NOOP, 345) },
  { "manage_view_cb", offsetof(struct qw_server, manage_view_cb),
                      sizeof(((struct qw_server *)0)->manage_view_cb),
                      _CFFI_OP(_CFFI_OP_NOOP, 401) },
  { "unmanage_view_cb", offsetof(struct qw_server, unmanage_view_cb),
                        sizeof(((struct qw_server *)0)->unmanage_view_cb),
                        _CFFI_OP(_CFFI_OP_NOOP, 401) },
  { "cursor_motion_cb", offsetof(struct qw_server, cursor_motion_cb),
                        sizeof(((struct qw_server *)0)->cursor_motion_cb),
                        _CFFI_OP(_CFFI_OP_NOOP, 402) },
  { "cursor_button_cb", offsetof(struct qw_server, cursor_button_cb),
                        sizeof(((struct qw_server *)0)->cursor_button_cb),
                        _CFFI_OP(_CFFI_OP_NOOP, 344) },
  { "on_screen_change_cb", offsetof(struct qw_server, on_screen_change_cb),
                           sizeof(((struct qw_server *)0)->on_screen_change_cb),
                           _CFFI_OP(_CFFI_OP_NOOP, 402) },
  { "on_screen_reserve_space_cb", offsetof(struct qw_server, on_screen_reserve_space_cb),
                                  sizeof(((struct qw_server *)0)->on_screen_reserve_space_cb),
                                  _CFFI_OP(_CFFI_OP_NOOP, 400) },
  { "view_activation_cb", offsetof(struct qw_server, view_activation_cb),
                          sizeof(((struct qw_server *)0)->view_activation_cb),
                          _CFFI_OP(_CFFI_OP_NOOP, 401) },
  { "on_input_device_added_cb", offsetof(struct qw_server, on_input_device_added_cb),
                                sizeof(((struct qw_server *)0)->on_input_device_added_cb),
                                _CFFI_OP(_CFFI_OP_NOOP, 402) },
  { "focus_current_window_cb", offsetof(struct qw_server, focus_current_window_cb),
                               sizeof(((struct qw_server *)0)->focus_current_window_cb),
                               _CFFI_OP(_CFFI_OP_NOOP, 319) },
  { "on_session_lock_cb", offsetof(struct qw_server, on_session_lock_cb),
                          sizeof(((struct qw_server *)0)->on_session_lock_cb),
                          _CFFI_OP(_CFFI_OP_NOOP, 398) },
  { "get_current_output_dims_cb", offsetof(struct qw_server, get_current_output_dims_cb),
                                  sizeof(((struct qw_server *)0)->get_current_output_dims_cb),
                                  _CFFI_OP(_CFFI_OP_NOOP, 369) },
  { "add_idle_inhibitor_cb", offsetof(struct qw_server, add_idle_inhibitor_cb),
                             sizeof(((struct qw_server *)0)->add_idle_inhibitor_cb),
                             _CFFI_OP(_CFFI_OP_NOOP, 321) },
  { "remove_idle_inhibitor_cb", offsetof(struct qw_server, remove_idle_inhibitor_cb),
                                sizeof(((struct qw_server *)0)->remove_idle_inhibitor_cb),
                                _CFFI_OP(_CFFI_OP_NOOP, 320) },
  { "check_inhibited_cb", offsetof(struct qw_server, check_inhibited_cb),
                          sizeof(((struct qw_server *)0)->check_inhibited_cb),
                          _CFFI_OP(_CFFI_OP_NOOP, 319) },
  { "view_activation_cb_data", offsetof(struct qw_server, view_activation_cb_data),
                               sizeof(((struct qw_server *)0)->view_activation_cb_data),
                               _CFFI_OP(_CFFI_OP_NOOP, 19) },
  { "cb_data", offsetof(struct qw_server, cb_data),
               sizeof(((struct qw_server *)0)->cb_data),
               _CFFI_OP(_CFFI_OP_NOOP, 19) },
  { "exclusive_layer", offsetof(struct qw_server, exclusive_layer),
                       sizeof(((struct qw_server *)0)->exclusive_layer),
                       _CFFI_OP(_CFFI_OP_NOOP, 358) },
  { "server", offsetof(struct qw_session_lock, server),
              sizeof(((struct qw_session_lock *)0)->server),
              _CFFI_OP(_CFFI_OP_NOOP, 8) },
  { "scene", offsetof(struct qw_session_lock, scene),
             sizeof(((struct qw_session_lock *)0)->scene),
             _CFFI_OP(_CFFI_OP_NOOP, 391) },
  { "lock", offsetof(struct qw_session_lock, lock),
            sizeof(((struct qw_session_lock *)0)->lock),
            _CFFI_OP(_CFFI_OP_NOOP, 395) },
  { "server", offsetof(struct qw_session_lock_surface, server),
              sizeof(((struct qw_session_lock_surface *)0)->server),
              _CFFI_OP(_CFFI_OP_NOOP, 8) },
  { "lock_surface", offsetof(struct qw_session_lock_surface, lock_surface),
                    sizeof(((struct qw_session_lock_surface *)0)->lock_surface),
                    _CFFI_OP(_CFFI_OP_NOOP, 393) },
  { "server", offsetof(struct qw_view, server),
              sizeof(((struct qw_view *)0)->server),
              _CFFI_OP(_CFFI_OP_NOOP, 8) },
  { "layer", offsetof(struct qw_view, layer),
             sizeof(((struct qw_view *)0)->layer),
             _CFFI_OP(_CFFI_OP_NOOP, 9) },
  { "x", offsetof(struct qw_view, x),
         sizeof(((struct qw_view *)0)->x),
         _CFFI_OP(_CFFI_OP_NOOP, 9) },
  { "y", offsetof(struct qw_view, y),
         sizeof(((struct qw_view *)0)->y),
         _CFFI_OP(_CFFI_OP_NOOP, 9) },
  { "width", offsetof(struct qw_view, width),
             sizeof(((struct qw_view *)0)->width),
             _CFFI_OP(_CFFI_OP_NOOP, 9) },
  { "height", offsetof(struct qw_view, height),
              sizeof(((struct qw_view *)0)->height),
              _CFFI_OP(_CFFI_OP_NOOP, 9) },
  { "border_count", offsetof(struct qw_view, border_count),
                    sizeof(((struct qw_view *)0)->border_count),
                    _CFFI_OP(_CFFI_OP_NOOP, 9) },
  { "state", offsetof(struct qw_view, state),
             sizeof(((struct qw_view *)0)->state),
             _CFFI_OP(_CFFI_OP_NOOP, 335) },
  { "view_type", offsetof(struct qw_view, view_type),
                 sizeof(((struct qw_view *)0)->view_type),
                 _CFFI_OP(_CFFI_OP_NOOP, 336) },
  { "shell", offsetof(struct qw_view, shell),
             sizeof(((struct qw_view *)0)->shell),
             _CFFI_OP(_CFFI_OP_NOOP, 124) },
  { "wid", offsetof(struct qw_view, wid),
           sizeof(((struct qw_view *)0)->wid),
           _CFFI_OP(_CFFI_OP_NOOP, 9) },
  { "title", offsetof(struct qw_view, title),
             sizeof(((struct qw_view *)0)->title),
             _CFFI_OP(_CFFI_OP_NOOP, 124) },
  { "app_id", offsetof(struct qw_view, app_id),
              sizeof(((struct qw_view *)0)->app_id),
              _CFFI_OP(_CFFI_OP_NOOP, 124) },
  { "urgent", offsetof(struct qw_view, urgent),
              sizeof(((struct qw_view *)0)->urgent),
              _CFFI_OP(_CFFI_OP_NOOP, 29) },
  { "instance", offsetof(struct qw_view, instance),
                sizeof(((struct qw_view *)0)->instance),
                _CFFI_OP(_CFFI_OP_NOOP, 124) },
  { "role", offsetof(struct qw_view, role),
            sizeof(((struct qw_view *)0)->role),
            _CFFI_OP(_CFFI_OP_NOOP, 124) },
  { "skip_taskbar", offsetof(struct qw_view, skip_taskbar),
                    sizeof(((struct qw_view *)0)->skip_taskbar),
                    _CFFI_OP(_CFFI_OP_NOOP, 29) },
  { "content_tree", offsetof(struct qw_view, content_tree),
                    sizeof(((struct qw_view *)0)->content_tree),
                    _CFFI_OP(_CFFI_OP_NOOP, 391) },
  { "ftl_handle", offsetof(struct qw_view, ftl_handle),
                  sizeof(((struct qw_view *)0)->ftl_handle),
                  _CFFI_OP(_CFFI_OP_NOOP, 377) },
  { "request_focus_cb", offsetof(struct qw_view, request_focus_cb),
                        sizeof(((struct qw_view *)0)->request_focus_cb),
                        _CFFI_OP(_CFFI_OP_NOOP, 346) },
  { "request_close_cb", offsetof(struct qw_view, request_close_cb),
                        sizeof(((struct qw_view *)0)->request_close_cb),
                        _CFFI_OP(_CFFI_OP_NOOP, 346) },
  { "request_maximize_cb", offsetof(struct qw_view, request_maximize_cb),
                           sizeof(((struct qw_view *)0)->request_maximize_cb),
                           _CFFI_OP(_CFFI_OP_NOOP, 343) },
  { "request_minimize_cb", offsetof(struct qw_view, request_minimize_cb),
                           sizeof(((struct qw_view *)0)->request_minimize_cb),
                           _CFFI_OP(_CFFI_OP_NOOP, 343) },
  { "request_fullscreen_cb", offsetof(struct qw_view, request_fullscreen_cb),
                             sizeof(((struct qw_view *)0)->request_fullscreen_cb),
                             _CFFI_OP(_CFFI_OP_NOOP, 343) },
  { "set_title_cb", offsetof(struct qw_view, set_title_cb),
                    sizeof(((struct qw_view *)0)->set_title_cb),
                    _CFFI_OP(_CFFI_OP_NOOP, 399) },
  { "set_app_id_cb", offsetof(struct qw_view, set_app_id_cb),
                     sizeof(((struct qw_view *)0)->set_app_id_cb),
                     _CFFI_OP(_CFFI_OP_NOOP, 399) },
  { "cb_data", offsetof(struct qw_view, cb_data),
               sizeof(((struct qw_view *)0)->cb_data),
               _CFFI_OP(_CFFI_OP_NOOP, 19) },
  { "get_tree_node", offsetof(struct qw_view, get_tree_node),
                     sizeof(((struct qw_view *)0)->get_tree_node),
                     _CFFI_OP(_CFFI_OP_NOOP, 384) },
  { "update_fullscreen", offsetof(struct qw_view, update_fullscreen),
                         sizeof(((struct qw_view *)0)->update_fullscreen),
                         _CFFI_OP(_CFFI_OP_NOOP, 403) },
  { "update_maximized", offsetof(struct qw_view, update_maximized),
                        sizeof(((struct qw_view *)0)->update_maximized),
                        _CFFI_OP(_CFFI_OP_NOOP, 403) },
  { "update_minimized", offsetof(struct qw_view, update_minimized),
                        sizeof(((struct qw_view *)0)->update_minimized),
                        _CFFI_OP(_CFFI_OP_NOOP, 403) },
  { "place", offsetof(struct qw_view, place),
             sizeof(((struct qw_view *)0)->place),
             _CFFI_OP(_CFFI_OP_NOOP, 405) },
  { "focus", offsetof(struct qw_view, focus),
             sizeof(((struct qw_view *)0)->focus),
             _CFFI_OP(_CFFI_OP_NOOP, 404) },
  { "kill", offsetof(struct qw_view, kill),
            sizeof(((struct qw_view *)0)->kill),
            _CFFI_OP(_CFFI_OP_NOOP, 402) },
  { "hide", offsetof(struct qw_view, hide),
            sizeof(((struct qw_view *)0)->hide),
            _CFFI_OP(_CFFI_OP_NOOP, 402) },
  { "unhide", offsetof(struct qw_view, unhide),
              sizeof(((struct qw_view *)0)->unhide),
              _CFFI_OP(_CFFI_OP_NOOP, 402) },
  { "get_pid", offsetof(struct qw_view, get_pid),
               sizeof(((struct qw_view *)0)->get_pid),
               _CFFI_OP(_CFFI_OP_NOOP, 346) },
  { "get_wm_type", offsetof(struct qw_view, get_wm_type),
                   sizeof(((struct qw_view *)0)->get_wm_type),
                   _CFFI_OP(_CFFI_OP_NOOP, 323) },
  { "has_fixed_size", offsetof(struct qw_view, has_fixed_size),
                      sizeof(((struct qw_view *)0)->has_fixed_size),
                      _CFFI_OP(_CFFI_OP_NOOP, 319) },
  { "get_parent", offsetof(struct qw_view, get_parent),
                  sizeof(((struct qw_view *)0)->get_parent),
                  _CFFI_OP(_CFFI_OP_NOOP, 346) },
  { "name", offsetof(struct scene_node_info, name),
            sizeof(((struct scene_node_info *)0)->name),
            _CFFI_OP(_CFFI_OP_NOOP, 124) },
  { "type", offsetof(struct scene_node_info, type),
            sizeof(((struct scene_node_info *)0)->type),
            _CFFI_OP(_CFFI_OP_NOOP, 124) },
  { "enabled", offsetof(struct scene_node_info, enabled),
               sizeof(((struct scene_node_info *)0)->enabled),
               _CFFI_OP(_CFFI_OP_NOOP, 29) },
  { "x", offsetof(struct scene_node_info, x),
         sizeof(((struct scene_node_info *)0)->x),
         _CFFI_OP(_CFFI_OP_NOOP, 9) },
  { "y", offsetof(struct scene_node_info, y),
         sizeof(((struct scene_node_info *)0)->y),
         _CFFI_OP(_CFFI_OP_NOOP, 9) },
  { "view_wid", offsetof(struct scene_node_info, view_wid),
                sizeof(((struct scene_node_info *)0)->view_wid),
                _CFFI_OP(_CFFI_OP_NOOP, 9) },
  { "x", offsetof(struct wlr_box, x),
         sizeof(((struct wlr_box *)0)->x),
         _CFFI_OP(_CFFI_OP_NOOP, 9) },
  { "y", offsetof(struct wlr_box, y),
         sizeof(((struct wlr_box *)0)->y),
         _CFFI_OP(_CFFI_OP_NOOP, 9) },
  { "width", offsetof(struct wlr_box, width),
             sizeof(((struct wlr_box *)0)->width),
             _CFFI_OP(_CFFI_OP_NOOP, 9) },
  { "height", offsetof(struct wlr_box, height),
              sizeof(((struct wlr_box *)0)->height),
              _CFFI_OP(_CFFI_OP_NOOP, 9) },
  { "state", offsetof(struct wlr_cursor, state),
             sizeof(((struct wlr_cursor *)0)->state),
             _CFFI_OP(_CFFI_OP_NOOP, 375) },
  { "x", offsetof(struct wlr_cursor, x),
         sizeof(((struct wlr_cursor *)0)->x),
         _CFFI_OP(_CFFI_OP_NOOP, 92) },
  { "y", offsetof(struct wlr_cursor, y),
         sizeof(((struct wlr_cursor *)0)->y),
         _CFFI_OP(_CFFI_OP_NOOP, 92) },
  { "color", (size_t)-1,
             (size_t)-1,
             _CFFI_OP(_CFFI_OP_NOOP, 341) },
  { "surface", (size_t)-1,
               (size_t)-1,
               _CFFI_OP(_CFFI_OP_NOOP, 202) },
};

static const struct _cffi_struct_union_s _cffi_struct_unions[] = {
  { "$4", 347, _CFFI_F_CHECK_FIELDS,
    (size_t)-2, -2, 107, 1 /* unnamed */ },
  { "$5", 348, _CFFI_F_CHECK_FIELDS,
    (size_t)-2, -2, 108, 1 /* unnamed */ },
  { "_cairo_surface", 322, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "libinput_device", 349, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "qw_border", 350, 0,
    sizeof(struct qw_border), offsetof(struct _cffi_align_struct_qw_border, y), 0, 4 },
  { "qw_cursor", 351, 0,
    sizeof(struct qw_cursor), offsetof(struct _cffi_align_struct_qw_cursor, y), 4, 3 },
  { "qw_drag_icon", 352, 0,
    sizeof(struct qw_drag_icon), offsetof(struct _cffi_align_struct_qw_drag_icon, y), 7, 1 },
  { "qw_idle_inhibitor", 353, 0,
    sizeof(struct qw_idle_inhibitor), offsetof(struct _cffi_align_struct_qw_idle_inhibitor, y), 8, 1 },
  { "qw_implicit_grab", 354, _CFFI_F_CHECK_FIELDS,
    sizeof(struct qw_implicit_grab), offsetof(struct _cffi_align_struct_qw_implicit_grab, y), 9, 3 },
  { "qw_input_device", 355, 0,
    sizeof(struct qw_input_device), offsetof(struct _cffi_align_struct_qw_input_device, y), 12, 0 },
  { "qw_internal_view", 356, 0,
    sizeof(struct qw_internal_view), offsetof(struct _cffi_align_struct_qw_internal_view, y), 12, 5 },
  { "qw_keyboard", 357, 0,
    sizeof(struct qw_keyboard), offsetof(struct _cffi_align_struct_qw_keyboard, y), 17, 0 },
  { "qw_layer_view", 359, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "qw_output", 360, 0,
    sizeof(struct qw_output), offsetof(struct _cffi_align_struct_qw_output, y), 17, 7 },
  { "qw_output_background", 361, 0,
    sizeof(struct qw_output_background), offsetof(struct _cffi_align_struct_qw_output_background, y), 24, 3 },
  { "qw_output_background_wallpaper", 363, _CFFI_F_CHECK_FIELDS,
    sizeof(struct qw_output_background_wallpaper), offsetof(struct _cffi_align_struct_qw_output_background_wallpaper, y), 27, 2 },
  { "qw_pointer_constraint", 364, 0,
    sizeof(struct qw_pointer_constraint), offsetof(struct _cffi_align_struct_qw_pointer_constraint, y), 29, 1 },
  { "qw_server", 365, 0,
    sizeof(struct qw_server), offsetof(struct _cffi_align_struct_qw_server, y), 30, 19 },
  { "qw_session_lock", 366, 0,
    sizeof(struct qw_session_lock), offsetof(struct _cffi_align_struct_qw_session_lock, y), 49, 3 },
  { "qw_session_lock_surface", 367, 0,
    sizeof(struct qw_session_lock_surface), offsetof(struct _cffi_align_struct_qw_session_lock_surface, y), 52, 2 },
  { "qw_view", 368, 0,
    sizeof(struct qw_view), offsetof(struct _cffi_align_struct_qw_view, y), 54, 40 },
  { "scene_node_info", 296, _CFFI_F_CHECK_FIELDS,
    sizeof(struct scene_node_info), offsetof(struct _cffi_align_struct_scene_node_info, y), 94, 6 },
  { "wlr_box", 370, _CFFI_F_CHECK_FIELDS,
    sizeof(struct wlr_box), offsetof(struct _cffi_align_struct_wlr_box, y), 100, 4 },
  { "wlr_buffer", 372, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "wlr_cursor", 374, 0,
    sizeof(struct wlr_cursor), offsetof(struct _cffi_align_struct_wlr_cursor, y), 104, 3 },
  { "wlr_cursor_state", 376, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "wlr_foreign_toplevel_handle_v1", 378, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "wlr_input_device", 379, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "wlr_output", 380, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "wlr_pointer_constraint_v1", 381, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "wlr_scene_buffer", 383, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "wlr_scene_node", 386, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "wlr_scene_output", 388, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "wlr_scene_rect", 390, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "wlr_scene_tree", 392, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "wlr_session_lock_surface_v1", 394, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "wlr_session_lock_v1", 396, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "wlr_surface", 397, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
};

static const struct _cffi_enum_s _cffi_enums[] = {
  { "$1", 325, _cffi_prim_int(4, 0),
    "NET_WM_WINDOW_TYPE_DIALOG,NET_WM_WINDOW_TYPE_UTILITY,NET_WM_WINDOW_TYPE_TOOLBAR,NET_WM_WINDOW_TYPE_MENU,NET_WM_WINDOW_TYPE_SPLASH,NET_WM_WINDOW_TYPE_DOCK,NET_WM_WINDOW_TYPE_TOOLTIP,NET_WM_WINDOW_TYPE_NOTIFICATION,NET_WM_WINDOW_TYPE_DESKTOP,NET_WM_WINDOW_TYPE_DROPDOWN_MENU,NET_WM_WINDOW_TYPE_POPUP_MENU,NET_WM_WINDOW_TYPE_COMBO,NET_WM_WINDOW_TYPE_DND,NET_WM_WINDOW_TYPE_NORMAL,ATOM_LAST" },
  { "$2", 326, _cffi_prim_int(4, 0),
    "LAYER_BACKGROUND,LAYER_BOTTOM,LAYER_KEEPBELOW,LAYER_LAYOUT,LAYER_KEEPABOVE,LAYER_MAX,LAYER_FULLSCREEN,LAYER_BRINGTOFRONT,LAYER_TOP,LAYER_OVERLAY,LAYER_DRAG_ICON,LAYER_LOCK,LAYER_END" },
  { "BUTTON_SCROLL", 327, _cffi_prim_int(sizeof(enum BUTTON_SCROLL), ((enum BUTTON_SCROLL)-1) <= 0),
    "BUTTON_SCROLL_UP,BUTTON_SCROLL_DOWN,BUTTON_SCROLL_LEFT,BUTTON_SCROLL_RIGHT" },
  { "libinput_config_accel_profile", 328, _cffi_prim_int(sizeof(enum libinput_config_accel_profile), ((enum libinput_config_accel_profile)-1) <= 0),
    "LIBINPUT_CONFIG_ACCEL_PROFILE_NONE,LIBINPUT_CONFIG_ACCEL_PROFILE_FLAT,LIBINPUT_CONFIG_ACCEL_PROFILE_ADAPTIVE" },
  { "libinput_config_click_method", 329, _cffi_prim_int(sizeof(enum libinput_config_click_method), ((enum libinput_config_click_method)-1) <= 0),
    "LIBINPUT_CONFIG_CLICK_METHOD_NONE,LIBINPUT_CONFIG_CLICK_METHOD_BUTTON_AREAS,LIBINPUT_CONFIG_CLICK_METHOD_CLICKFINGER" },
  { "libinput_config_scroll_method", 330, _cffi_prim_int(sizeof(enum libinput_config_scroll_method), ((enum libinput_config_scroll_method)-1) <= 0),
    "LIBINPUT_CONFIG_SCROLL_NO_SCROLL,LIBINPUT_CONFIG_SCROLL_2FG,LIBINPUT_CONFIG_SCROLL_EDGE,LIBINPUT_CONFIG_SCROLL_ON_BUTTON_DOWN" },
  { "libinput_config_tap_button_map", 331, _cffi_prim_int(sizeof(enum libinput_config_tap_button_map), ((enum libinput_config_tap_button_map)-1) <= 0),
    "LIBINPUT_CONFIG_TAP_MAP_LRM,LIBINPUT_CONFIG_TAP_MAP_LMR" },
  { "qw_background_type", 332, _cffi_prim_int(sizeof(enum qw_background_type), ((enum qw_background_type)-1) <= 0),
    "QW_BACKGROUND_COLOR_RECT,QW_BACKGROUND_WALLPAPER,QW_BACKGROUND_DESTROYED" },
  { "qw_border_type", 333, _cffi_prim_int(sizeof(enum qw_border_type), ((enum qw_border_type)-1) <= 0),
    "QW_BORDER_RECT,QW_BORDER_BUFFER" },
  { "qw_session_lock_state", 334, _cffi_prim_int(sizeof(enum qw_session_lock_state), ((enum qw_session_lock_state)-1) <= 0),
    "QW_SESSION_LOCK_LOCKED,QW_SESSION_LOCK_UNLOCKED,QW_SESSION_LOCK_CRASHED" },
  { "qw_view_state", 335, _cffi_prim_int(sizeof(enum qw_view_state), ((enum qw_view_state)-1) <= 0),
    "NOT_FLOATING,FLOATING,MAXIMIZED,FULLSCREEN,TOP,MINIMIZED" },
  { "qw_view_type", 336, _cffi_prim_int(sizeof(enum qw_view_type), ((enum qw_view_type)-1) <= 0),
    "QW_VIEW_XDG,QW_VIEW_XDG_POPUP,QW_VIEW_XWAYLAND,QW_VIEW_INTERNAL" },
  { "qw_wallpaper_mode", 203, _cffi_prim_int(sizeof(enum qw_wallpaper_mode), ((enum qw_wallpaper_mode)-1) <= 0),
    "WALLPAPER_MODE_ORIGINAL,WALLPAPER_MODE_STRETCH,WALLPAPER_MODE_FILL,WALLPAPER_MODE_CENTER" },
  { "wlr_input_device_type", 337, _cffi_prim_int(sizeof(enum wlr_input_device_type), ((enum wlr_input_device_type)-1) <= 0),
    "WLR_INPUT_DEVICE_KEYBOARD,WLR_INPUT_DEVICE_POINTER,WLR_INPUT_DEVICE_TOUCH,WLR_INPUT_DEVICE_TABLET,WLR_INPUT_DEVICE_TABLET_PAD,WLR_INPUT_DEVICE_SWITCH" },
  { "wlr_log_importance", 128, _cffi_prim_int(sizeof(enum wlr_log_importance), ((enum wlr_log_importance)-1) <= 0),
    "WLR_SILENT,WLR_ERROR,WLR_INFO,WLR_DEBUG" },
};

static const struct _cffi_typename_s _cffi_typenames[] = {
  { "add_idle_inhibitor_cb_t", 321 },
  { "cairo_surface_t", 322 },
  { "check_inhibited_cb_t", 319 },
  { "cursor_button_cb_t", 344 },
  { "cursor_motion_cb_t", 402 },
  { "focus_current_window_cb_t", 319 },
  { "get_current_output_dims_cb_t", 369 },
  { "input_device_cb_t", 263 },
  { "keyboard_key_cb_t", 345 },
  { "manage_view_cb_t", 401 },
  { "node_info_cb_t", 267 },
  { "node_wid_cb_t", 255 },
  { "on_input_device_added_cb_t", 402 },
  { "on_screen_change_cb_t", 402 },
  { "on_screen_reserve_space_cb_t", 400 },
  { "on_session_lock_cb_t", 398 },
  { "output_dims_cb_t", 259 },
  { "remove_idle_inhibitor_cb_t", 320 },
  { "request_close_cb_t", 346 },
  { "request_focus_cb_t", 346 },
  { "request_fullscreen_cb_t", 343 },
  { "request_maximize_cb_t", 343 },
  { "request_minimize_cb_t", 343 },
  { "set_app_id_cb_t", 399 },
  { "set_title_cb_t", 399 },
  { "unmanage_view_cb_t", 401 },
  { "view_activation_cb_t", 401 },
  { "wrapped_log_func_t", 133 },
  { "xkb_keysym_t", 49 },
};

static const struct _cffi_type_context_s _cffi_type_context = {
  _cffi_types,
  _cffi_globals,
  _cffi_fields,
  _cffi_struct_unions,
  _cffi_enums,
  _cffi_typenames,
  183,  /* num_globals */
  38,  /* num_struct_unions */
  15,  /* num_enums */
  29,  /* num_typenames */
  NULL,  /* no includes */
  407,  /* num_types */
  1,  /* flags */
};

#ifdef __GNUC__
#  pragma GCC visibility push(default)  /* for -fvisibility= */
#endif

#ifdef PYPY_VERSION
PyMODINIT_FUNC
_cffi_pypyinit__ffi(const void *p[])
{
    if (((intptr_t)p[0]) >= 0x0A03) {
        _cffi_call_python_org = (void(*)(struct _cffi_externpy_s *, char *))p[1];
    }
    p[0] = (const void *)0x2601;
    p[1] = &_cffi_type_context;
#if PY_MAJOR_VERSION >= 3
    return NULL;
#endif
}
#  ifdef _MSC_VER
     PyMODINIT_FUNC
#  if PY_MAJOR_VERSION >= 3
     PyInit__ffi(void) { return NULL; }
#  else
     init_ffi(void) { }
#  endif
#  endif
#elif PY_MAJOR_VERSION >= 3
PyMODINIT_FUNC
PyInit__ffi(void)
{
  return _cffi_init("libqtile.backend.wayland._ffi", 0x2601, &_cffi_type_context);
}
#else
PyMODINIT_FUNC
init_ffi(void)
{
  _cffi_init("libqtile.backend.wayland._ffi", 0x2601, &_cffi_type_context);
}
#endif

#ifdef __GNUC__
#  pragma GCC visibility pop
#endif
