/**
 * Qt6 Common library
 *
 * The Qt6 Common library is auto-generated and available to users under the same license as the Qt which it is used with or built with. See available licenses below. 
 * SPDX-License-Identifier: LicenseRef-Qt-Commercial OR LGPL-3.0-only OR GPL-2.0-only OR GPL-3.0-only
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

#include "QtOAIHttpFileElement.h"

#include <QtCore/qdebug.h>
#include <QtCore/qfile.h>
#include <QtCore/qfileinfo.h>
#include <QtCore/qjsondocument.h>
#include <QtCore/qjsonobject.h>

namespace QtCommonOpenAPI {

QtOAIHttpFileElement::QtOAIHttpFileElement() = default;

QtOAIHttpFileElementShared::~QtOAIHttpFileElementShared()
{
    // Cleanup temporary file when last reference is destroyed
    if (m_temporary && !m_localFilename.isEmpty() && QFile::exists(m_localFilename))
        QFile::remove(m_localFilename);
}

QtOAIHttpFileElement::QtOAIHttpFileElement(const QString &localFilename)
    : d(new QtOAIHttpFileElementShared(localFilename)){}

QtOAIHttpFileElement::QtOAIHttpFileElement(const QtOAIHttpFileElement &other)
    : d(other.d) {}

QtOAIHttpFileElement &QtOAIHttpFileElement::operator=(const QtOAIHttpFileElement &other)
{
    if (this != &other)
        d = other.d;
    return *this;
}

QtOAIHttpFileElement::~QtOAIHttpFileElement() = default;

void QtOAIHttpFileElement::setMimeType(const QString &mime)
{
    d.detach();
    d->m_mimeType = mime;
}

void QtOAIHttpFileElement::setVariableName(const QString &name)
{
    d.detach();
    d->m_variableName = name;
}

void QtOAIHttpFileElement::setTemporary(bool temp)
{
    d.detach();
    d->m_temporary = temp;
}

QString QtOAIHttpFileElement::mimeType() const
{
    return d->m_mimeType;
}

QString QtOAIHttpFileElement::filename() const
{
    return d->m_localFilename;
}

QString QtOAIHttpFileElement::variableName() const
{
    return d->m_variableName;
}

QString QtOAIHttpFileElement::requestFilename() const
{
    return QFileInfo(d->m_localFilename).fileName();
}


bool QtOAIHttpFileElement::isTemporary() const
{
    return d->m_temporary;
}

bool QtOAIHttpFileElement::isSet() const {
    return !d->m_localFilename.isEmpty();
}

/*!
    \internal

    Returns the content of the local file as QString.
*/
QString QtOAIHttpFileElement::asJson() const
{
    const QByteArray data = loadFromLocalFile();
    return QString::fromUtf8(data);
}

/*!
    \internal

    Returns the content of the local file as QJsonValue.
*/
QJsonValue QtOAIHttpFileElement::asJsonValue() const
{
    const QByteArray data = loadFromLocalFile();
    const QJsonObject object = QJsonDocument::fromJson(data).object();
    return QJsonValue(object);
}

/*!
    \internal

    Writes the string \a instr to the file with filename m_localFilename,
    creating or overwriting it.
*/
bool QtOAIHttpFileElement::fromStringValue(const QString &instr)
{
    return saveToLocalFile(instr.toUtf8());
}

/*!
    \internal

    Writes the json value \a jval to the file with filename m_localFilename,
    creating or overwriting it.
*/
bool QtOAIHttpFileElement::fromJsonValue(const QJsonValue &jval)
{
    const QByteArray content = QJsonDocument(jval.toObject()).toJson(QJsonDocument::Compact);
    return saveToLocalFile(content);
}

/*!
    \internal

    Creates or overwrites a file with filename m_localFilename,
    with \a bytes content.
*/
bool QtOAIHttpFileElement::saveToLocalFile(const QByteArray &bytes)
{
    if (d->m_localFilename.isEmpty()) {
        qDebug() << "Local filename is empty, skipping save.";
        return false;
    }
    QFile file(d->m_localFilename);
    bool result = file.open(QIODevice::WriteOnly | QIODevice::Truncate);
    if (result) {
        const qint64 written = file.write(bytes);
        file.close();
        result = (written == bytes.size());
        if (!result)
            qDebug() << "Failed to write data to the file" << d->m_localFilename;
    } else {
        qDebug() << "Failed to create the file" << d->m_localFilename;
    }
    return result;
}

/*!
    \internal

    Reads the content of the file with filename m_localFilename.
*/
QByteArray QtOAIHttpFileElement::loadFromLocalFile() const
{
    QByteArray bArray;

    if (d->m_localFilename.isEmpty()) {
        qDebug() << "Local filename is empty, skipping reading.";
        return bArray;
    }

    QFile file(d->m_localFilename);
    if (file.exists() && file.open(QIODevice::ReadOnly)) {
        bArray = file.readAll();
        file.close();
    } else {
        qDebug("Failed to open the file %s", qPrintable(d->m_localFilename));
    }
    return bArray;
}

} // namespace QtCommonOpenAPI
